---
layout: post
title: Polyglot 1.7.0 以及使用 page_id 前置元数据区分不同语言的永久链接
lang: zh-CN
---

我很兴奋地宣布 Jekyll-Polyglot 1.7.0 版本发布了。这个版本增加了一个新功能，可以为页面设置特定于语言的永久链接，并保留它们与其他相关页面的关联。

这项新功能由 **[antoniovazquezblanco](https://github.com/antoniovazquezblanco)** 提供，他是一位绅士和学者。

## 使用 `page_id` 前置元数据将页面与不同永久链接关联

Polyglot 通过匹配永久链接或文件名来关联页面。然而，有些站点翻译可能希望页面具有独特的永久链接。

Polyglot 已经协调了不同语言的同一文档的多个副本。因此，基于 `page_id` 这样的新属性来协调相似页面，与基于永久链接协调没有任何区别。

使用 `page_id` 来协调具有不同永久链接的相似页面，确保了自定义永久链接仍然可以在特定语言的站点上看到。

### 为独特永久链接设置重定向

独特永久链接的挑战在于相对化地生成的 URL。Polyglot 通过建议使用一致的永久链接完全避免了这个问题。

为了解决这个问题，Polyglot 在这些页面上设置了 `redirect_from` 隐藏前置元数据，列出了相应页面的唯一永久链接。

在使用 `jekyll-redirect-from` 插件时，将会读取这些前置元数据，并智能地将页面重定向到自定义的独特永久链接。

要查看此功能的实际效果，请访问[这个不同语言的长永久链接的页面](/a-really-long/permalink/)。

## 其他 bug 修复

* 本次发布应该修复了 [#151](https://github.com/untra/polyglot/issues/151) 和 [#184](https://github.com/untra/polyglot/issues/184)，防止在调用其他 jekyll 命令时启动时崩溃。
