# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs.aio import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSMaintenancesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_maintenances_list(self, resource_group):
        response = self.client.maintenances.list(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_maintenances_get(self, resource_group):
        response = await self.client.maintenances.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            maintenance_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_maintenances_reschedule(self, resource_group):
        response = await self.client.maintenances.reschedule(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            maintenance_name="str",
            body={"message": "str", "rescheduleTime": "2020-02-20 00:00:00"},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_maintenances_schedule(self, resource_group):
        response = await self.client.maintenances.schedule(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            maintenance_name="str",
            body={"message": "str", "scheduleTime": "2020-02-20 00:00:00"},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_maintenances_initiate_checks(self, resource_group):
        response = await self.client.maintenances.initiate_checks(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            maintenance_name="str",
        )

        # please add some check logic here by yourself
        # ...
