# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.impactreporting.aio import ImpactReportingMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestImpactReportingMgmtWorkloadImpactsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ImpactReportingMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workload_impacts_begin_create(self, resource_group):
        response = await (
            await self.client.workload_impacts.begin_create(
                workload_impact_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "impactCategory": "str",
                        "impactedResourceId": "str",
                        "startDateTime": "2020-02-20 00:00:00",
                        "armCorrelationIds": ["str"],
                        "clientIncidentDetails": {"clientIncidentId": "str", "clientIncidentSource": "str"},
                        "confidenceLevel": "str",
                        "connectivity": {
                            "port": 0,
                            "protocol": "str",
                            "source": {"azureResourceId": "str"},
                            "target": {"azureResourceId": "str"},
                        },
                        "endDateTime": "2020-02-20 00:00:00",
                        "errorDetails": {"errorCode": "str", "errorMessage": "str"},
                        "impactDescription": "str",
                        "impactGroupId": "str",
                        "impactUniqueId": "str",
                        "performance": [
                            {
                                "actual": 0.0,
                                "expected": 0.0,
                                "expectedValueRange": {"max": 0.0, "min": 0.0},
                                "metricName": "str",
                                "unit": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "reportedTimeUtc": "2020-02-20 00:00:00",
                        "workload": {"context": "str", "toolset": "str"},
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workload_impacts_get(self, resource_group):
        response = await self.client.workload_impacts.get(
            workload_impact_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workload_impacts_delete(self, resource_group):
        response = await self.client.workload_impacts.delete(
            workload_impact_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workload_impacts_list_by_subscription(self, resource_group):
        response = self.client.workload_impacts.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
