# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpdateConfiguration(Model):
    """Update specific properties of the software update configuration.

    All required parameters must be populated in order to send to Azure.

    :param operating_system: Required. operating system of target machines.
     Possible values include: 'Windows', 'Linux'
    :type operating_system: str or
     ~azure.mgmt.automation.models.OperatingSystemType
    :param windows: Windows specific update configuration.
    :type windows: ~azure.mgmt.automation.models.WindowsProperties
    :param linux: Linux specific update configuration.
    :type linux: ~azure.mgmt.automation.models.LinuxProperties
    :param duration: Maximum time allowed for the software update
     configuration run. Duration needs to be specified using the format
     PT[n]H[n]M[n]S as per ISO8601
    :type duration: timedelta
    :param azure_virtual_machines: List of azure resource Ids for azure
     virtual machines targeted by the software update configuration.
    :type azure_virtual_machines: list[str]
    :param non_azure_computer_names: List of names of non-azure machines
     targeted by the software update configuration.
    :type non_azure_computer_names: list[str]
    :param targets: Group targets for the software update configuration.
    :type targets: ~azure.mgmt.automation.models.TargetProperties
    """

    _validation = {
        'operating_system': {'required': True},
    }

    _attribute_map = {
        'operating_system': {'key': 'operatingSystem', 'type': 'OperatingSystemType'},
        'windows': {'key': 'windows', 'type': 'WindowsProperties'},
        'linux': {'key': 'linux', 'type': 'LinuxProperties'},
        'duration': {'key': 'duration', 'type': 'duration'},
        'azure_virtual_machines': {'key': 'azureVirtualMachines', 'type': '[str]'},
        'non_azure_computer_names': {'key': 'nonAzureComputerNames', 'type': '[str]'},
        'targets': {'key': 'targets', 'type': 'TargetProperties'},
    }

    def __init__(self, **kwargs):
        super(UpdateConfiguration, self).__init__(**kwargs)
        self.operating_system = kwargs.get('operating_system', None)
        self.windows = kwargs.get('windows', None)
        self.linux = kwargs.get('linux', None)
        self.duration = kwargs.get('duration', None)
        self.azure_virtual_machines = kwargs.get('azure_virtual_machines', None)
        self.non_azure_computer_names = kwargs.get('non_azure_computer_names', None)
        self.targets = kwargs.get('targets', None)
