/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment Python binding
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <pygobject.h>
#include <Python.h>

void pypgmimaging_register_classes (PyObject *d);

extern PyMethodDef pypgmimaging_functions[];

DL_EXPORT (void)
init_pgmimaging (void)
{
  PyObject *m, *d;
  PyObject *av;
  int argc, i;
  char **argv;

  init_pygobject ();

  m = Py_InitModule ("_pgmimaging", pypgmimaging_functions);
  d = PyModule_GetDict (m);

  pypgmimaging_register_classes (d);

  if (PyErr_Occurred ())
    Py_FatalError ("Can't initialize module pgm.imaging.");
}
