// SPDX-License-Identifier: BSD-3-Clause
package org.xbill.DNS;

import static org.junit.jupiter.api.Assertions.assertArrayEquals;

import java.io.IOException;
import org.junit.jupiter.api.Test;

class EDNS0MessageTests {

  /* dig +nocookie foo.dns.addere.ch */
  private static final byte[] EDNS0_EMPTY = {
    0x7d, 0x59, 0x01, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x66, 0x6f, 0x6f,
    0x03, 0x64, 0x6e, 0x73, 0x06, 0x61, 0x64, 0x64, 0x65, 0x72, 0x65, 0x02, 0x63, 0x68, 0x00, 0x00,
    0x01, 0x00, 0x01, 0x00, 0x00, 0x29, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  /* dig foo.dns.addere.ch */
  private static final byte[] EDNS0_COOKIE = {
    (byte) 0x95,
    (byte) 0xa6,
    0x01,
    0x20,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x03,
    0x66,
    0x6f,
    0x6f,
    0x03,
    0x64,
    0x6e,
    0x73,
    0x06,
    0x61,
    0x64,
    0x64,
    0x65,
    0x72,
    0x65,
    0x02,
    0x63,
    0x68,
    0x00,
    0x00,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x29,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0c,
    0x00,
    0x0a,
    0x00,
    0x08,
    0x28,
    0x75,
    (byte) 0x83,
    0x7f,
    0x00,
    0x32,
    (byte) 0xe5,
    0x6f
  };

  /* dig +keepalive foo.dns.addere.ch */
  private static final byte[] EDNS0_COOKIE_KEEPALIVE = {
    (byte) 0x8e,
    (byte) 0xdd,
    0x01,
    0x20,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x03,
    0x66,
    0x6f,
    0x6f,
    0x03,
    0x64,
    0x6e,
    0x73,
    0x06,
    0x61,
    0x64,
    0x64,
    0x65,
    0x72,
    0x65,
    0x02,
    0x63,
    0x68,
    0x00,
    0x00,
    0x01,
    0x00,
    0x01,
    0x00,
    0x00,
    0x29,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x10,
    0x00,
    0x0a,
    0x00,
    0x08,
    (byte) 0xeb,
    (byte) 0xed,
    (byte) 0xfc,
    0x4c,
    0x1c,
    0x45,
    0x20,
    0x01,
    0x00,
    0x0b,
    0x00,
    0x00
  };

  /* dig +keepalive +subnet=1.2.3.4 foo.dns.addere.ch */
  private static final byte[] EDNS0_SUBNET_COOKIE_KEEPALIVE = {
    0x42, 0x3a, 0x01, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x66, 0x6f, 0x6f,
    0x03, 0x64, 0x6e, 0x73, 0x06, 0x61, 0x64, 0x64, 0x65, 0x72, 0x65, 0x02, 0x63, 0x68, 0x00, 0x00,
    0x01, 0x00, 0x01, 0x00, 0x00, 0x29, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x08,
    0x00, 0x08, 0x00, 0x01, 0x20, 0x00, 0x01, 0x02, 0x03, 0x04, 0x00, 0x0a, 0x00, 0x08, 0x7c, 0x2e,
    0x0d, 0x0e, (byte) 0x95, (byte) 0xf3, 0x4d, (byte) 0xff, 0x00, 0x0b, 0x00, 0x00
  };

  @Test
  void testParseEdns0Empty() throws IOException {
    Message msg = new Message(EDNS0_EMPTY);
    assertArrayEquals(EDNS0_EMPTY, msg.toWire());
  }

  @Test
  void testParseEdns0Cookie() throws IOException {
    Message msg = new Message(EDNS0_COOKIE);
    assertArrayEquals(EDNS0_COOKIE, msg.toWire());
  }

  @Test
  void testParseEdns0CookieKeepalive() throws IOException {
    Message msg = new Message(EDNS0_COOKIE_KEEPALIVE);
    assertArrayEquals(EDNS0_COOKIE_KEEPALIVE, msg.toWire());
  }

  @Test
  void testParseEdns0SubnetCookieKeepalive() throws IOException {
    Message msg = new Message(EDNS0_SUBNET_COOKIE_KEEPALIVE);
    assertArrayEquals(EDNS0_SUBNET_COOKIE_KEEPALIVE, msg.toWire());
  }
}
