## TFSA-2021-092: Integer overflow in TFLite memory allocation

### CVE Number
CVE-2021-29605

### Impact
The TFLite code for allocating `TFLiteIntArray`s is [vulnerable to an integer
overflow
issue](https://github.com/tensorflow/tensorflow/blob/4ceffae632721e52bf3501b736e4fe9d1221cdfa/tensorflow/lite/c/common.c#L24-L27):

```cc
int TfLiteIntArrayGetSizeInBytes(int size) {
  static TfLiteIntArray dummy;
  return sizeof(dummy) + sizeof(dummy.data[0]) * size;
}
```

An attacker can craft a model such that the `size` multiplier is so large that
the return value overflows the `int` datatype and becomes negative. In turn,
this results in [invalid value being given to
`malloc`](https://github.com/tensorflow/tensorflow/blob/4ceffae632721e52bf3501b736e4fe9d1221cdfa/tensorflow/lite/c/common.c#L47-L52):

```cc
TfLiteIntArray* TfLiteIntArrayCreate(int size) {
  TfLiteIntArray* ret = (TfLiteIntArray*)malloc(TfLiteIntArrayGetSizeInBytes(size));
  ret->size = size;
  return ret;
}
```

In this case, `ret->size` would dereference an invalid pointer.

### Patches
We have patched the issue in GitHub commit
[7c8cc4ec69cd348e44ad6a2699057ca88faad3e5](https://github.com/tensorflow/tensorflow/commit/7c8cc4ec69cd348e44ad6a2699057ca88faad3e5).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
