/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_14 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 3447, "epsg", 3447,
        "ETRS89 / Belgian Lambert 2005");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=50.797815 +lon_0=4.359215833333333 +x_0=15032");
    add_proj4text (p, 2,
        "8 +y_0=166262 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Belgian Lambert 2005\",GEOGCS[\"ETRS89");
    add_srs_wkt (p, 1,
        "\",DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_1\",49.83333333333334],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_2\",51.16666666666666],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 10,
        "_origin\",50.797815],PARAMETER[\"central_meridian\",4.35");
    add_srs_wkt (p, 11,
        "9215833333333],PARAMETER[\"false_easting\",150328],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",166262],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"3447\"]]");
    p = add_epsg_def (filter, first, last, 3448, "epsg", 3448,
        "JAD2001 / Jamaica Metric Grid");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=750");
    add_proj4text (p, 1,
        "000 +y_0=650000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAD2001 / Jamaica Metric Grid\",GEOGCS[\"JAD200");
    add_srs_wkt (p, 1,
        "1\",DATUM[\"Jamaica_2001\",SPHEROID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6758\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4758\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_1SP\"],PARAMETER[\"latitude_of_origin\",18],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-77],PARAMETER[\"scale_factor\",1],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",750000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",650000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"3448\"]]");
    p = add_epsg_def (filter, first, last, 3449, "epsg", 3449,
        "JAD2001 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAD2001 / UTM zone 17N\",GEOGCS[\"JAD2001\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Jamaica_2001\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6758\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4758\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3449\"]]");
    p = add_epsg_def (filter, first, last, 3450, "epsg", 3450,
        "JAD2001 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAD2001 / UTM zone 18N\",GEOGCS[\"JAD2001\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Jamaica_2001\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6758\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4758\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3450\"]]");
    p = add_epsg_def (filter, first, last, 3451, "epsg", 3451,
        "NAD83 / Louisiana North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana North (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 8,
        "2.66666666666666],PARAMETER[\"standard_parallel_2\",31.1");
    add_srs_wkt (p, 9,
        "6666666666667],PARAMETER[\"latitude_of_origin\",30.5],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",-92.5],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",3280833.333300001],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"3451\"]]");
    p = add_epsg_def (filter, first, last, 3452, "epsg", 3452,
        "NAD83 / Louisiana South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91");
    add_proj4text (p, 1,
        ".33333333333333 +x_0=999999.9999898402 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana South (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 8,
        "0.7],PARAMETER[\"standard_parallel_2\",29.3],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",28.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-91.33333333333333],PARAMETER[\"false_easting\",3280833");
    add_srs_wkt (p, 11,
        ".333300001],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"3452\"]]");
    p = add_epsg_def (filter, first, last, 3453, "epsg", 3453,
        "NAD83 / Louisiana Offshore (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.5 +lon_0=-91.33333333333333 +x_0=999999.99");
    add_proj4text (p, 2,
        "99898402 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana Offshore (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",27.83333333333333],PARAMETER[\"standard_parallel_2\",26");
    add_srs_wkt (p, 9,
        ".16666666666667],PARAMETER[\"latitude_of_origin\",25.5],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"central_meridian\",-91.33333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",3280833.333300001],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3453\"]]");
    p = add_epsg_def (filter, first, last, 3454, "epsg", 3454,
        "NAD83 / South Dakota North (ftUS) (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Dakota North (ftUS) (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard");
    add_srs_wkt (p, 8,
        "_parallel_1\",44.4],PARAMETER[\"standard_parallel_2\",42");
    add_srs_wkt (p, 9,
        ".83333333333334],PARAMETER[\"latitude_of_origin\",42.333");
    add_srs_wkt (p, 10,
        "33333333334],PARAMETER[\"central_meridian\",-100.3333333");
    add_srs_wkt (p, 11,
        "333333],PARAMETER[\"false_easting\",1968500],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3454\"]]");
    p = add_epsg_def (filter, first, last, 3455, "epsg", 3455,
        "NAD83 / South Dakota South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Dakota South (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",44.4],PARAMETER[\"standard_parallel_2\",42.833333333333");
    add_srs_wkt (p, 9,
        "34],PARAMETER[\"latitude_of_origin\",42.33333333333334],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"central_meridian\",-100.3333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",1968500],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"3455\"]]");
    p = add_epsg_def (filter, first, last, 3456, "epsg", 3456,
        "NAD83(HARN) / Louisiana North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Louisiana North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",32.66666666666666],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",31.16666666666667],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_origin\",30.5],PARAMETER[\"central_meridian\",-92.");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",3280833.333300001],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 13,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 14,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3456\"]]");
    p = add_epsg_def (filter, first, last, 3457, "epsg", 3457,
        "NAD83(HARN) / Louisiana South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91");
    add_proj4text (p, 1,
        ".33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Louisiana South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",30.7],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_2\",29.3],PARAMETER[\"latitude_of_origin\",28.5],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"central_meridian\",-91.33333333333333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",3280833.333300001],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"3457\"]]");
    p = add_epsg_def (filter, first, last, 3458, "epsg", 3458,
        "NAD83(HARN) / South Dakota North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Dakota North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",45.68333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",44.41666666666666],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",43.83333333333334],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-100],PARAMETER[\"false_easting\",1968500]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3458\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def (filter, first, last, 3459, "epsg", 3459,
        "NAD83(HARN) / South Dakota South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / South Dakota South (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",44.4],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_2\",42.83333333333334],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 10,
        "igin\",42.33333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-100.3333333333333],PARAMETER[\"false_easting\",1968500");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3459\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def (filter, first, last, 3460, "epsg", 3460,
        "Fiji 1986 / Fiji Map Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=200");
    add_proj4text (p, 1,
        "0000 +y_0=4000000 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 2,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fiji 1986 / Fiji Map Grid\",GEOGCS[\"Fiji 1986\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Fiji_Geodetic_Datum_1986\",SPHEROID[\"WGS 72\",");
    add_srs_wkt (p, 2,
        "6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",4.5,0,0,0.554,0.2263],AUTHORITY[\"EPSG\",\"6720\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4720\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",-17],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",178.75],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.99985],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",4000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"3460\"]]");
    p = add_epsg_def (filter, first, last, 3461, "epsg", 3461,
        "Dabola 1981 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-83,");
    add_proj4text (p, 1,
        "37,124,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dabola 1981 / UTM zone 28N\",GEOGCS[\"Dabola 19");
    add_srs_wkt (p, 1,
        "81\",DATUM[\"Dabola_1981\",SPHEROID[\"Clarke 1880 (IGN)\"");
    add_srs_wkt (p, 2,
        ",6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-83,37,124,0,0,0,0],AUTHORITY[\"EPSG\",\"6155");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4155\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3461\"]]");
    p = add_epsg_def (filter, first, last, 3462, "epsg", 3462,
        "Dabola 1981 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-83,");
    add_proj4text (p, 1,
        "37,124,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dabola 1981 / UTM zone 29N\",GEOGCS[\"Dabola 19");
    add_srs_wkt (p, 1,
        "81\",DATUM[\"Dabola_1981\",SPHEROID[\"Clarke 1880 (IGN)\"");
    add_srs_wkt (p, 2,
        ",6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-83,37,124,0,0,0,0],AUTHORITY[\"EPSG\",\"6155");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4155\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3462\"]]");
    p = add_epsg_def (filter, first, last, 3463, "epsg", 3463,
        "NAD83 / Maine CS2000 Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=5");
    add_proj4text (p, 1,
        "00000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine CS2000 Central\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",43.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-69.125],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.99998],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3463\"]]");
    p = add_epsg_def (filter, first, last, 3464, "epsg", 3464,
        "NAD83(HARN) / Maine CS2000 Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=5");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine CS2000 Central\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",43.5],PARAMETER[\"central_meridian\",-69.12");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.99998],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3464\"]]");
    p = add_epsg_def (filter, first, last, 3465, "epsg", 3465,
        "NAD83(NSRS2007) / Alabama East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alabama East\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",30.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-85.83333333333333],PARAMETER[\"scale_factor\",0.99996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",200000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3465\"]]");
    p = add_epsg_def (filter, first, last, 3466, "epsg", 3466,
        "NAD83(NSRS2007) / Alabama West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=6");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alabama West\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",30],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "87.5],PARAMETER[\"scale_factor\",0.999933333],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",600000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3466\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3467, "epsg", 3467,
        "NAD83(NSRS2007) / Alaska Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska Albers\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"standard_parallel_1\",55],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_2\",65],PARAMETER[\"latitude_of_center\",50],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"longitude_of_center\",-154],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3467\"]]");
    p = add_epsg_def (filter, first, last, 3468, "epsg", 3468,
        "NAD83(NSRS2007) / Alaska zone 1");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=32");
    add_proj4text (p, 1,
        "3.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +ga");
    add_proj4text (p, 2,
        "mma=323.1301023611111 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 3,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 1\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_center\",57],PARAMETER[\"longitude_of_ce");
    add_srs_wkt (p, 9,
        "nter\",-133.6666666666667],PARAMETER[\"azimuth\",323.130");
    add_srs_wkt (p, 10,
        "1023611111],PARAMETER[\"rectified_grid_angle\",323.13010");
    add_srs_wkt (p, 11,
        "23611111],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",5000000],PARAMETER[\"false_northing\",-5");
    add_srs_wkt (p, 13,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 15,
        "468\"]]");
    p = add_epsg_def (filter, first, last, 3469, "epsg", 3469,
        "NAD83(NSRS2007) / Alaska zone 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 2\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-142],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3469\"]]");
    p = add_epsg_def (filter, first, last, 3470, "epsg", 3470,
        "NAD83(NSRS2007) / Alaska zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 3\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-146],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3470\"]]");
    p = add_epsg_def (filter, first, last, 3471, "epsg", 3471,
        "NAD83(NSRS2007) / Alaska zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 4\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-150],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3471\"]]");
    p = add_epsg_def (filter, first, last, 3472, "epsg", 3472,
        "NAD83(NSRS2007) / Alaska zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 5\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-154],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3472\"]]");
    p = add_epsg_def (filter, first, last, 3473, "epsg", 3473,
        "NAD83(NSRS2007) / Alaska zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 6\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-158],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3473\"]]");
    p = add_epsg_def (filter, first, last, 3474, "epsg", 3474,
        "NAD83(NSRS2007) / Alaska zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 7\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-162],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3474\"]]");
    p = add_epsg_def (filter, first, last, 3475, "epsg", 3475,
        "NAD83(NSRS2007) / Alaska zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 8\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-166],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3475\"]]");
    p = add_epsg_def (filter, first, last, 3476, "epsg", 3476,
        "NAD83(NSRS2007) / Alaska zone 9");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 9\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-170],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3476\"]]");
    p = add_epsg_def (filter, first, last, 3477, "epsg", 3477,
        "NAD83(NSRS2007) / Alaska zone 10");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Alaska zone 10\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",53.83333333333334],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",51.83333333333334],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",51],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 11,
        "\",-176],PARAMETER[\"false_easting\",1000000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"3477\"]]");
    p = add_epsg_def (filter, first, last, 3478, "epsg", 3478,
        "NAD83(NSRS2007) / Arizona Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arizona Central\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-111.9166666666667],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",213360],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"3478\"]]");
    p = add_epsg_def (filter, first, last, 3479, "epsg", 3479,
        "NAD83(NSRS2007) / Arizona Central (ft)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arizona Central (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",31],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-111.9166666666667],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999],PARAMETER[\"false_easting\",700000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3479\"]]");
    p = add_epsg_def (filter, first, last, 3480, "epsg", 3480,
        "NAD83(NSRS2007) / Arizona East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arizona East\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",31],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "110.1666666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",213360],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3480\"]]");
    p = add_epsg_def (filter, first, last, 3481, "epsg", 3481,
        "NAD83(NSRS2007) / Arizona East (ft)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arizona East (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-110.1666666666667],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",700000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"3481\"]]");
    p = add_epsg_def (filter, first, last, 3482, "epsg", 3482,
        "NAD83(NSRS2007) / Arizona West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arizona West\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",31],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "113.75],PARAMETER[\"scale_factor\",0.999933333],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",213360],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3482\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 3483, "epsg", 3483,
        "NAD83(NSRS2007) / Arizona West (ft)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arizona West (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-113.75],PARAMETER[\"scale_factor\",0.999933333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",700000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3483\"]]");
    p = add_epsg_def (filter, first, last, 3484, "epsg", 3484,
        "NAD83(NSRS2007) / Arkansas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arkansas North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",36.23333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",34.93333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",34.33333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-92],PARAMETER[\"false_easting\",40000");
    add_srs_wkt (p, 12,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 14,
        "RTH],AUTHORITY[\"EPSG\",\"3484\"]]");
    p = add_epsg_def (filter, first, last, 3485, "epsg", 3485,
        "NAD83(NSRS2007) / Arkansas North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arkansas North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",36.23333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",34.93333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",34.33333333333334],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",-92],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",1312333.3333],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 13,
        " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"3485\"]]");
    p = add_epsg_def (filter, first, last, 3486, "epsg", 3486,
        "NAD83(NSRS2007) / Arkansas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arkansas South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",34.76666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",33.3],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 10,
        "f_origin\",32.66666666666666],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 11,
        "an\",-92],PARAMETER[\"false_easting\",400000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",400000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"3486\"]]");
    p = add_epsg_def (filter, first, last, 3487, "epsg", 3487,
        "NAD83(NSRS2007) / Arkansas South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399");
    add_proj4text (p, 2,
        "999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Arkansas South (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",34.76666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",33.3],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",32.66666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-92],PARAMETER[\"false_easting\",1312333.333");
    add_srs_wkt (p, 12,
        "3],PARAMETER[\"false_northing\",1312333.3333],UNIT[\"US ");
    add_srs_wkt (p, 13,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 15,
        "SG\",\"3487\"]]");
    p = add_epsg_def (filter, first, last, 3488, "epsg", 3488,
        "NAD83(NSRS2007) / California Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California Albers\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_1\",34],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_2\",40.5],PARAMETER[\"latitude_of_center\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"longitude_of_center\",-120],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",0],PARAMETER[\"false_northing\",-4000000],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3488\"]]");
    p = add_epsg_def (filter, first, last, 3489, "epsg", 3489,
        "NAD83(NSRS2007) / California zone 1");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 1\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",41.66666666666666],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",40],PARAMETER[\"latitude_");
    add_srs_wkt (p, 10,
        "of_origin\",39.33333333333334],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-122],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"3489\"]]");
    p = add_epsg_def (filter, first, last, 3490, "epsg", 3490,
        "NAD83(NSRS2007) / California zone 1 (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=5000");
    add_proj4text (p, 2,
        "00.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 1 (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",41.6666666666666");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"standard_parallel_2\",40],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",39.33333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-122],PARAMETER[\"false_easting\",6561666.66");
    add_srs_wkt (p, 12,
        "7],PARAMETER[\"false_northing\",1640416.667],UNIT[\"US s");
    add_srs_wkt (p, 13,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 14,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"3490\"]]");
    p = add_epsg_def (filter, first, last, 3491, "epsg", 3491,
        "NAD83(NSRS2007) / California zone 2");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y");
    add_proj4text (p, 2,
        "_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 2\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",39.83333333333334],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",38.33333333333334],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",37.66666666666666],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-122],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 12,
        "000000],PARAMETER[\"false_northing\",500000],UNIT[\"metr");
    add_srs_wkt (p, 13,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3491\"]]");
    p = add_epsg_def (filter, first, last, 3492, "epsg", 3492,
        "NAD83(NSRS2007) / California zone 2 (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.00");
    add_proj4text (p, 2,
        "01016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 2 (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",39.8333333333333");
    add_srs_wkt (p, 9,
        "4],PARAMETER[\"standard_parallel_2\",38.33333333333334],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"latitude_of_origin\",37.66666666666666],PARA");
    add_srs_wkt (p, 11,
        "METER[\"central_meridian\",-122],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
        "ng\",6561666.667],PARAMETER[\"false_northing\",1640416.6");
    add_srs_wkt (p, 13,
        "67],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"3492\"]]");
    p = add_epsg_def (filter, first, last, 3493, "epsg", 3493,
        "NAD83(NSRS2007) / California zone 3");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 3\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",38.43333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",37.06666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",36.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-120.5],PARAMETER[\"false_easting\",2000000],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",500000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"3493\"]]");
    p = add_epsg_def (filter, first, last, 3494, "epsg", 3494,
        "NAD83(NSRS2007) / California zone 3 (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=");
    add_proj4text (p, 2,
        "500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 3,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 3 (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",38.4333333333333");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"standard_parallel_2\",37.06666666666667],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"latitude_of_origin\",36.5],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-120.5],PARAMETER[\"false_easting\",656166");
    add_srs_wkt (p, 12,
        "6.667],PARAMETER[\"false_northing\",1640416.667],UNIT[\"");
    add_srs_wkt (p, 13,
        "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"3494\"]]");
    p = add_epsg_def (filter, first, last, 3495, "epsg", 3495,
        "NAD83(NSRS2007) / California zone 4");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",37.25],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",36],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 10,
        "35.33333333333334],PARAMETER[\"central_meridian\",-119],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3495\"]]");
    p = add_epsg_def (filter, first, last, 3496, "epsg", 3496,
        "NAD83(NSRS2007) / California zone 4 (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.000101600");
    add_proj4text (p, 2,
        "1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 4 (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",37.25],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",36],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",35.33333333333334],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 11,
        "-119],PARAMETER[\"false_easting\",6561666.667],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",1640416.667],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3496\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def (filter, first, last, 3497, "epsg", 3497,
        "NAD83(NSRS2007) / California zone 5");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 5\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",35.46666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",34.03333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",33.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-118],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",500000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"3497\"]]");
    p = add_epsg_def (filter, first, last, 3498, "epsg", 3498,
        "NAD83(NSRS2007) / California zone 5 (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=50");
    add_proj4text (p, 2,
        "0000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 3,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 5 (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",35.4666666666666");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"standard_parallel_2\",34.03333333333333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"latitude_of_origin\",33.5],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-118],PARAMETER[\"false_easting\",6561666.");
    add_srs_wkt (p, 12,
        "667],PARAMETER[\"false_northing\",1640416.667],UNIT[\"US");
    add_srs_wkt (p, 13,
        " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"3498\"]]");
    p = add_epsg_def (filter, first, last, 3499, "epsg", 3499,
        "NAD83(NSRS2007) / California zone 6");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        " +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 6\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",33.88333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",32.78333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",32.16666666666666],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-116.25],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",2000000],PARAMETER[\"false_northing\",500000],UNIT[\"me");
    add_srs_wkt (p, 13,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3499\"]]");
    p = add_epsg_def (filter, first, last, 3500, "epsg", 3500,
        "NAD83(NSRS2007) / California zone 6 (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        ".0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / California zone 6 (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",33.8833333333333");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"standard_parallel_2\",32.78333333333333],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"latitude_of_origin\",32.16666666666666],PARA");
    add_srs_wkt (p, 11,
        "METER[\"central_meridian\",-116.25],PARAMETER[\"false_ea");
    add_srs_wkt (p, 12,
        "sting\",6561666.667],PARAMETER[\"false_northing\",164041");
    add_srs_wkt (p, 13,
        "6.667],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"3500\"]]");
    p = add_epsg_def (filter, first, last, 3501, "epsg", 3501,
        "NAD83(NSRS2007) / Colorado Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Colorado Central\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_1\",39.75],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",38.45],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",37.83333333333334],PARAMETER[\"central_meridian\",-105.");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",914401.8289],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",304800.6096],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"3501\"]]");
    p = add_epsg_def (filter, first, last, 3502, "epsg", 3502,
        "NAD83(NSRS2007) / Colorado Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.60");
    add_proj4text (p, 2,
        "96012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Colorado Central (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"standard_parallel_1\",39.75],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",38.45],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 10,
        "origin\",37.83333333333334],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 11,
        "\",-105.5],PARAMETER[\"false_easting\",3000000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",1000000],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3502\"]]");
    p = add_epsg_def (filter, first, last, 3503, "epsg", 3503,
        "NAD83(NSRS2007) / Colorado North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Colorado North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",40.78333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",39.71666666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",39.33333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-105.5],PARAMETER[\"false_easting\",91");
    add_srs_wkt (p, 12,
        "4401.8289],PARAMETER[\"false_northing\",304800.6096],UNI");
    add_srs_wkt (p, 13,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3503\"]]");
    p = add_epsg_def (filter, first, last, 3504, "epsg", 3504,
        "NAD83(NSRS2007) / Colorado North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Colorado North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",40.78333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",39.71666666666667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",39.33333333333334],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",-105.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
        "ng\",3000000],PARAMETER[\"false_northing\",1000000],UNIT");
    add_srs_wkt (p, 13,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"3504\"]]");
    p = add_epsg_def (filter, first, last, 3505, "epsg", 3505,
        "NAD83(NSRS2007) / Colorado South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 3,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Colorado South\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",38.43333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",37.23333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",36.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-105.5],PARAMETER[\"false_easting\",91");
    add_srs_wkt (p, 12,
        "4401.8289],PARAMETER[\"false_northing\",304800.6096],UNI");
    add_srs_wkt (p, 13,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3505\"]]");
    p = add_epsg_def (filter, first, last, 3506, "epsg", 3506,
        "NAD83(NSRS2007) / Colorado South (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Colorado South (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",38.43333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",37.23333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",36.66666666666666],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",-105.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
        "ng\",3000000],PARAMETER[\"false_northing\",1000000],UNIT");
    add_srs_wkt (p, 13,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"3506\"]]");
    p = add_epsg_def (filter, first, last, 3507, "epsg", 3507,
        "NAD83(NSRS2007) / Connecticut");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=1524");
    add_proj4text (p, 2,
        "00.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Connecticut\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 7,
        "9\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",41.86666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",41.2],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 10,
        "rigin\",40.83333333333334],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-72.75],PARAMETER[\"false_easting\",304800.6096],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",152400.3048],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"3507\"]]");
    p = add_epsg_def (filter, first, last, 3508, "epsg", 3508,
        "NAD83(NSRS2007) / Connecticut (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_");
    add_proj4text (p, 2,
        "0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 3,
        "+units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Connecticut (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",41.86666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",41.2],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_origin\",40.83333333333334],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-72.75],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",500000],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 13,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3508\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def (filter, first, last, 3509, "epsg", 3509,
        "NAD83(NSRS2007) / Delaware");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Delaware\",GEOGCS[\"NAD83(NSR");
    add_srs_wkt (p, 1,
        "S2007)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",38],PARAMETER[\"central_meridian\",-75.4");
    add_srs_wkt (p, 9,
        "1666666666667],PARAMETER[\"scale_factor\",0.999995],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",200000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "509\"]]");
    p = add_epsg_def (filter, first, last, 3510, "epsg", 3510,
        "NAD83(NSRS2007) / Delaware (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Delaware (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",38],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-75.41666666666667],PARAMETER[\"scale_factor\",0.999995]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",656166.667],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3510\"]]");
    p = add_epsg_def (filter, first, last, 3511, "epsg", 3511,
        "NAD83(NSRS2007) / Florida East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Florida East\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",24.33333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-81],PARAMETER[\"scale_factor\",0.99994117");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",200000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3511\"]]");
    p = add_epsg_def (filter, first, last, 3512, "epsg", 3512,
        "NAD83(NSRS2007) / Florida East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Florida East (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",24.33333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-81],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "99941177],PARAMETER[\"false_easting\",656166.667],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3512\"]]");
    p = add_epsg_def (filter, first, last, 3513, "epsg", 3513,
        "NAD83(NSRS2007) / Florida GDL Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_");
    add_proj4text (p, 1,
        "0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Florida GDL Albers\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_1\",24],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_2\",31.5],PARAMETER[\"latitude_of_center\",24],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"longitude_of_center\",-84],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",400000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3513\"]]");
    p = add_epsg_def (filter, first, last, 3514, "epsg", 3514,
        "NAD83(NSRS2007) / Florida North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Florida North\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_1\",30.75],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_2\",29.58333333333333],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 10,
        "f_origin\",29],PARAMETER[\"central_meridian\",-84.5],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",600000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "3514\"]]");
    p = add_epsg_def (filter, first, last, 3515, "epsg", 3515,
        "NAD83(NSRS2007) / Florida North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Florida North (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",30.75],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",29.58333333333333],PARAMETER[\"lati");
    add_srs_wkt (p, 10,
        "tude_of_origin\",29],PARAMETER[\"central_meridian\",-84.");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3515\"]]");
    p = add_epsg_def (filter, first, last, 3516, "epsg", 3516,
        "NAD83(NSRS2007) / Florida West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Florida West\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",24.33333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-82],PARAMETER[\"scale_factor\",0.99994117");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",200000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3516\"]]");
    p = add_epsg_def (filter, first, last, 3517, "epsg", 3517,
        "NAD83(NSRS2007) / Florida West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Florida West (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",24.33333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-82],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "99941177],PARAMETER[\"false_easting\",656166.667],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3517\"]]");
    p = add_epsg_def (filter, first, last, 3518, "epsg", 3518,
        "NAD83(NSRS2007) / Georgia East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Georgia East\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",30],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "82.16666666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",200000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3518\"]]");
    p = add_epsg_def (filter, first, last, 3519, "epsg", 3519,
        "NAD83(NSRS2007) / Georgia East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Georgia East (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",30],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-82.16666666666667],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "999],PARAMETER[\"false_easting\",656166.667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3519\"]]");
    p = add_epsg_def (filter, first, last, 3520, "epsg", 3520,
        "NAD83(NSRS2007) / Georgia West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Georgia West\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",30],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "84.16666666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",700000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3520\"]]");
    p = add_epsg_def (filter, first, last, 3521, "epsg", 3521,
        "NAD83(NSRS2007) / Georgia West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Georgia West (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",30],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-84.16666666666667],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "999],PARAMETER[\"false_easting\",2296583.333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3521\"]]");
    p = add_epsg_def (filter, first, last, 3522, "epsg", 3522,
        "NAD83(NSRS2007) / Idaho Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Idaho Central\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",41.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-114],PARAMETER[\"scale_factor\",0.999947");
    add_srs_wkt (p, 10,
        "368],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"3522\"]]");
    p = add_epsg_def (filter, first, last, 3523, "epsg", 3523,
        "NAD83(NSRS2007) / Idaho Central (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Idaho Central (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",41.66666666666666],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-114],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".999947368],PARAMETER[\"false_easting\",1640416.667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3523\"]]");
    p = add_epsg_def (filter, first, last, 3524, "epsg", 3524,
        "NAD83(NSRS2007) / Idaho East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Idaho East\",GEOGCS[\"NAD83(N");
    add_srs_wkt (p, 1,
        "SRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",41.66666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-112.1666666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999947368],PARAMETER[\"false_easting\",200000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3524\"]]");
    p = add_epsg_def (filter, first, last, 3525, "epsg", 3525,
        "NAD83(NSRS2007) / Idaho East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Idaho East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",41.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-112.1666666666667],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.999947368],PARAMETER[\"false_easting\",65616");
    add_srs_wkt (p, 11,
        "6.667],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "3525\"]]");
    p = add_epsg_def (filter, first, last, 3526, "epsg", 3526,
        "NAD83(NSRS2007) / Idaho West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Idaho West\",GEOGCS[\"NAD83(N");
    add_srs_wkt (p, 1,
        "SRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",41.66666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-115.75],PARAMETER[\"scale_factor\",0.999933");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"false_easting\",800000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"3526\"]]");
    p = add_epsg_def (filter, first, last, 3527, "epsg", 3527,
        "NAD83(NSRS2007) / Idaho West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Idaho West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",41.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-115.75],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".999933333],PARAMETER[\"false_easting\",2624666.667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3527\"]]");
    p = add_epsg_def (filter, first, last, 3528, "epsg", 3528,
        "NAD83(NSRS2007) / Illinois East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Illinois East\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",36.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-88.33333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.999975],PARAMETER[\"false_easting\",300000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3528\"]]");
    p = add_epsg_def (filter, first, last, 3529, "epsg", 3529,
        "NAD83(NSRS2007) / Illinois East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Illinois East (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",36.66666666666666],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-88.33333333333333],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",0.999975],PARAMETER[\"false_easting\",98425");
    add_srs_wkt (p, 11,
        "0.0000000002],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"3529\"]]");
    p = add_epsg_def (filter, first, last, 3530, "epsg", 3530,
        "NAD83(NSRS2007) / Illinois West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Illinois West\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "759\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",36.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",-90.16666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.999941177],PARAMETER[\"false_easting\",700000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"3530\"]]");
    p = add_epsg_def (filter, first, last, 3531, "epsg", 3531,
        "NAD83(NSRS2007) / Illinois West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Illinois West (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",36.66666666666666],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-90.16666666666667],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",0.999941177],PARAMETER[\"false_easting\",22");
    add_srs_wkt (p, 11,
        "96583.333300001],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3531\"]]");
    p = add_epsg_def (filter, first, last, 3532, "epsg", 3532,
        "NAD83(NSRS2007) / Indiana East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Indiana East\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-85.66666666666667],PARAMETER[\"scale_factor\",0.999966");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"false_easting\",100000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",250000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3532\"]]");
    p = add_epsg_def (filter, first, last, 3533, "epsg", 3533,
        "NAD83(NSRS2007) / Indiana East (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Indiana East (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",37.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-85.66666666666667],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".999966667],PARAMETER[\"false_easting\",328083.333],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",820208.3330000002],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"3533\"]]");
    p = add_epsg_def (filter, first, last, 3534, "epsg", 3534,
        "NAD83(NSRS2007) / Indiana West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Indiana West\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-87.08333333333333],PARAMETER[\"scale_factor\",0.999966");
    add_srs_wkt (p, 10,
        "667],PARAMETER[\"false_easting\",900000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",250000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3534\"]]");
    p = add_epsg_def (filter, first, last, 3535, "epsg", 3535,
        "NAD83(NSRS2007) / Indiana West (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Indiana West (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",37.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-87.08333333333333],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".999966667],PARAMETER[\"false_easting\",2952750],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",820208.3330000002],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"3535\"]]");
    p = add_epsg_def (filter, first, last, 3536, "epsg", 3536,
        "NAD83(NSRS2007) / Iowa North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Iowa North\",GEOGCS[\"NAD83(N");
    add_srs_wkt (p, 1,
        "SRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",43.26666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",42.06666666666667],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",41.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-93.5],PARAMETER[\"false_easting\",1500000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"3536\"]]");
    p = add_epsg_def (filter, first, last, 3537, "epsg", 3537,
        "NAD83(NSRS2007) / Iowa North (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.99");
    add_proj4text (p, 2,
        "99898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Iowa North (ft US)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",43.26666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",42.06666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",41.5],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-93.5],PARAMETER[\"false_easting\",4921250],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",3280833.333300001],UNIT[\"US su");
    add_srs_wkt (p, 13,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"3537\"]]");
    p = add_epsg_def (filter, first, last, 3538, "epsg", 3538,
        "NAD83(NSRS2007) / Iowa South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Iowa South\",GEOGCS[\"NAD83(N");
    add_srs_wkt (p, 1,
        "SRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",41.78333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",40.61666666666667],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",40],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 11,
        "93.5],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3538\"]]");
    p = add_epsg_def (filter, first, last, 3539, "epsg", 3539,
        "NAD83(NSRS2007) / Iowa South (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Iowa South (ft US)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",41.78333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",40.61666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",40],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-93.5],PARAMETER[\"false_easting\",1640416.6667],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 13,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3539\"]]");
    p = add_epsg_def (filter, first, last, 3540, "epsg", 3540,
        "NAD83(NSRS2007) / Kansas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kansas North\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",39.78333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",38.71666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",38.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-98],PARAMETER[\"false_easting\",400000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"3540\"]]");
    p = add_epsg_def (filter, first, last, 3541, "epsg", 3541,
        "NAD83(NSRS2007) / Kansas North (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kansas North (ft US)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",39.78333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",38.71666666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",38.33333333333334],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-98],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "1312333.3333],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 13,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 15,
        "SG\",\"3541\"]]");
    p = add_epsg_def (filter, first, last, 3542, "epsg", 3542,
        "NAD83(NSRS2007) / Kansas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y");
    add_proj4text (p, 2,
        "_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kansas South\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2007\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"47");
    add_srs_wkt (p, 7,
        "59\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",38.56666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",37.26666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",36.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-98.5],PARAMETER[\"false_easting\",400000");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",400000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"3542\"]]");
    p = add_epsg_def (filter, first, last, 3543, "epsg", 3543,
        "NAD83(NSRS2007) / Kansas South (ft US)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99");
    add_proj4text (p, 2,
        "998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 3,
        "0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kansas South (ft US)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",38.56666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",37.26666666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",36.66666666666666],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-98.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",1312333.3333],PARAMETER[\"false_northing\",1312333.3333");
    add_srs_wkt (p, 13,
        "],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"3543\"]]");
    p = add_epsg_def (filter, first, last, 3544, "epsg", 3544,
        "NAD83(NSRS2007) / Kentucky North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kentucky North\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",37.96666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",38.96666666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",37.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 11,
        "an\",-84.25],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"3544\"]]");
    p = add_epsg_def (filter, first, last, 3545, "epsg", 3545,
        "NAD83(NSRS2007) / Kentucky North (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kentucky North (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"standard_parallel_1\",37.96666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",38.96666666666667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-84.25],PARAMETER[\"false_easting\",1640416.");
    add_srs_wkt (p, 12,
        "667],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 13,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 14,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"35");
    add_srs_wkt (p, 15,
        "45\"]]");
    p = add_epsg_def (filter, first, last, 3546, "epsg", 3546,
        "NAD83(NSRS2007) / Kentucky Single Zone");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 ");
    add_proj4text (p, 2,
        "+y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kentucky Single Zone\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_1\",37.08333333333334],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",38.66666666666666],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",36.33333333333334],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-85.75],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",1500000],PARAMETER[\"false_northing\",1000000],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3546\"]]");
    p = add_epsg_def (filter, first, last, 3547, "epsg", 3547,
        "NAD83(NSRS2007) / Kentucky Single Zone (ftUS)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 ");
    add_proj4text (p, 2,
        "+y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Kentucky Single Zone (ftUS)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",37.083333333");
    add_srs_wkt (p, 9,
        "33334],PARAMETER[\"standard_parallel_2\",38.666666666666");
    add_srs_wkt (p, 10,
        "66],PARAMETER[\"latitude_of_origin\",36.33333333333334],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"central_meridian\",-85.75],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_easting\",4921250],PARAMETER[\"false_northing\",3280833");
    add_srs_wkt (p, 13,
        ".333],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 15,
        "],AUTHORITY[\"EPSG\",\"3547\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

