include(FindLua51)
find_program(HAVE_LUA_BIN NAMES lua)
mark_as_advanced(HAVE_LUA_BIN)

message(STATUS "Looking for lua.h")
if(LUA_INCLUDE_DIR)
  message(STATUS "Looking for lua.h - found")
else()
  message(STATUS "Looking for lua.h - not found")
endif()

if(HAVE_LUA_BIN)
  message(STATUS "Found Lua: ${HAVE_LUA_BIN}")
endif()

set(LIB_LUA_NAME "")

foreach(lib_path ${LUA_LIBRARIES})
  if(NOT LIB_LUA_NAME)
    string(REGEX MATCH "liblua.*$" LIB_LUA_NAME "${lib_path}")
    string(REPLACE ".${LIB_EXE}" "" LIB_LUA_NAME "${LIB_LUA_NAME}")
    string(REPLACE "lib" "" LIB_LUA_NAME "${LIB_LUA_NAME}")
    if(LIB_LUA_NAME)
      string(REPLACE "/lib${LIB_LUA_NAME}.${LIB_EXE}" "" LUA_LIBRARY_DIR ${lib_path})
    endif()
  endif()
endforeach(lib_path ${LUA_LIBRARIES})

message(STATUS "Looking for lib lua")
if(LUA_LIBRARY_DIR)
  message(STATUS "Looking for lib lua - found")
  message(STATUS "Lua version: ${LIB_LUA_NAME}")
  message(STATUS "Lib path   : ${LUA_LIBRARY_DIR}")
else()
  message(STATUS "Looking for lib lua - not found")
endif()

if(LUA51_FOUND)
  set(HAVE_LUA 1)
  include_directories(${LUA_INCLUDE_DIR})
  link_directories(${LUA_LIBRARY_DIR})
else()
  message(STATUS "Warning : Lua need version 5.1")
endif()
