# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._anomaly_detector_client_enums import *


class AlignPolicy(msrest.serialization.Model):
    """AlignPolicy.

    :param align_mode: An optional field, indicates how we align different variables into the same
     time-range which is required by the model.{Inner, Outer}. Possible values include: "Inner",
     "Outer".
    :type align_mode: str or ~azure.ai.anomalydetector.models.AlignMode
    :param fill_na_method: An optional field, indicates how missed values will be filled with. Can
     not be set to NotFill, when alignMode is Outer.{Previous, Subsequent, Linear, Zero, Fix,
     NotFill}. Possible values include: "Previous", "Subsequent", "Linear", "Zero", "Pad",
     "NotFill".
    :type fill_na_method: str or ~azure.ai.anomalydetector.models.FillNAMethod
    :param padding_value: optional field, only be useful if FillNAMethod is set to Pad.
    :type padding_value: int
    """

    _attribute_map = {
        'align_mode': {'key': 'alignMode', 'type': 'str'},
        'fill_na_method': {'key': 'fillNAMethod', 'type': 'str'},
        'padding_value': {'key': 'paddingValue', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        align_mode: Optional[Union[str, "AlignMode"]] = None,
        fill_na_method: Optional[Union[str, "FillNAMethod"]] = None,
        padding_value: Optional[int] = None,
        **kwargs
    ):
        super(AlignPolicy, self).__init__(**kwargs)
        self.align_mode = align_mode
        self.fill_na_method = fill_na_method
        self.padding_value = padding_value


class AnomalyContributor(msrest.serialization.Model):
    """AnomalyContributor.

    :param contribution_score: The higher the contribution score is, the more likely the variable
     to be the root cause of a anomaly.
    :type contribution_score: float
    :param variable: Variable name of a contributor.
    :type variable: str
    """

    _validation = {
        'contribution_score': {'maximum': 2, 'minimum': 0},
    }

    _attribute_map = {
        'contribution_score': {'key': 'contributionScore', 'type': 'float'},
        'variable': {'key': 'variable', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        contribution_score: Optional[float] = None,
        variable: Optional[str] = None,
        **kwargs
    ):
        super(AnomalyContributor, self).__init__(**kwargs)
        self.contribution_score = contribution_score
        self.variable = variable


class AnomalyDetectorError(msrest.serialization.Model):
    """Error information returned by the API.

    :param code: The error code. Possible values include: "InvalidCustomInterval", "BadArgument",
     "InvalidGranularity", "InvalidPeriod", "InvalidModelArgument", "InvalidSeries",
     "InvalidJsonFormat", "RequiredGranularity", "RequiredSeries".
    :type code: str or ~azure.ai.anomalydetector.models.AnomalyDetectorErrorCodes
    :param message: A message explaining the error reported by the service.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[Union[str, "AnomalyDetectorErrorCodes"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(AnomalyDetectorError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class AnomalyState(msrest.serialization.Model):
    """AnomalyState.

    All required parameters must be populated in order to send to Azure.

    :param timestamp: Required. timestamp.
    :type timestamp: ~datetime.datetime
    :param value:
    :type value: ~azure.ai.anomalydetector.models.AnomalyValue
    :param errors: Error message when inference this timestamp.
    :type errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
    """

    _validation = {
        'timestamp': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'AnomalyValue'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
    }

    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
        value: Optional["AnomalyValue"] = None,
        errors: Optional[List["ErrorResponse"]] = None,
        **kwargs
    ):
        super(AnomalyState, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.value = value
        self.errors = errors


class AnomalyValue(msrest.serialization.Model):
    """AnomalyValue.

    All required parameters must be populated in order to send to Azure.

    :param contributors: If current timestamp is an anomaly, contributors will show potential root
     cause for thus anomaly. Contributors can help us understand why current timestamp has been
     detected as an anomaly.
    :type contributors: list[~azure.ai.anomalydetector.models.AnomalyContributor]
    :param is_anomaly: Required. To indicate whether current timestamp is anomaly or not.
    :type is_anomaly: bool
    :param severity: Required. anomaly score of the current timestamp, the more significant an
     anomaly is, the higher the score will be.
    :type severity: float
    :param score: anomaly score of the current timestamp, the more significant an anomaly is, the
     higher the score will be, score measures global significance.
    :type score: float
    """

    _validation = {
        'is_anomaly': {'required': True},
        'severity': {'required': True, 'maximum': 1, 'minimum': 0},
        'score': {'maximum': 2, 'minimum': 0},
    }

    _attribute_map = {
        'contributors': {'key': 'contributors', 'type': '[AnomalyContributor]'},
        'is_anomaly': {'key': 'isAnomaly', 'type': 'bool'},
        'severity': {'key': 'severity', 'type': 'float'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        is_anomaly: bool,
        severity: float,
        contributors: Optional[List["AnomalyContributor"]] = None,
        score: Optional[float] = None,
        **kwargs
    ):
        super(AnomalyValue, self).__init__(**kwargs)
        self.contributors = contributors
        self.is_anomaly = is_anomaly
        self.severity = severity
        self.score = score


class ChangePointDetectRequest(msrest.serialization.Model):
    """ChangePointDetectRequest.

    All required parameters must be populated in order to send to Azure.

    :param series: Required. Time series data points. Points should be sorted by timestamp in
     ascending order to match the change point detection result.
    :type series: list[~azure.ai.anomalydetector.models.TimeSeriesPoint]
    :param granularity: Required. Can only be one of yearly, monthly, weekly, daily, hourly,
     minutely or secondly. Granularity is used for verify whether input series is valid. Possible
     values include: "yearly", "monthly", "weekly", "daily", "hourly", "minutely", "secondly",
     "microsecond", "none".
    :type granularity: str or ~azure.ai.anomalydetector.models.TimeGranularity
    :param custom_interval: Custom Interval is used to set non-standard time interval, for example,
     if the series is 5 minutes, request can be set as {"granularity":"minutely",
     "customInterval":5}.
    :type custom_interval: int
    :param period: Optional argument, periodic value of a time series. If the value is null or does
     not present, the API will determine the period automatically.
    :type period: int
    :param stable_trend_window: Optional argument, advanced model parameter, a default
     stableTrendWindow will be used in detection.
    :type stable_trend_window: int
    :param threshold: Optional argument, advanced model parameter, between 0.0-1.0, the lower the
     value is, the larger the trend error will be which means less change point will be accepted.
    :type threshold: float
    """

    _validation = {
        'series': {'required': True},
        'granularity': {'required': True},
    }

    _attribute_map = {
        'series': {'key': 'series', 'type': '[TimeSeriesPoint]'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'custom_interval': {'key': 'customInterval', 'type': 'int'},
        'period': {'key': 'period', 'type': 'int'},
        'stable_trend_window': {'key': 'stableTrendWindow', 'type': 'int'},
        'threshold': {'key': 'threshold', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        series: List["TimeSeriesPoint"],
        granularity: Union[str, "TimeGranularity"],
        custom_interval: Optional[int] = None,
        period: Optional[int] = None,
        stable_trend_window: Optional[int] = None,
        threshold: Optional[float] = None,
        **kwargs
    ):
        super(ChangePointDetectRequest, self).__init__(**kwargs)
        self.series = series
        self.granularity = granularity
        self.custom_interval = custom_interval
        self.period = period
        self.stable_trend_window = stable_trend_window
        self.threshold = threshold


class ChangePointDetectResponse(msrest.serialization.Model):
    """ChangePointDetectResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar period: Frequency extracted from the series, zero means no recurrent pattern has been
     found.
    :vartype period: int
    :param is_change_point: isChangePoint contains change point properties for each input point.
     True means an anomaly either negative or positive has been detected. The index of the array is
     consistent with the input series.
    :type is_change_point: list[bool]
    :param confidence_scores: the change point confidence of each point.
    :type confidence_scores: list[float]
    """

    _validation = {
        'period': {'readonly': True},
    }

    _attribute_map = {
        'period': {'key': 'period', 'type': 'int'},
        'is_change_point': {'key': 'isChangePoint', 'type': '[bool]'},
        'confidence_scores': {'key': 'confidenceScores', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        is_change_point: Optional[List[bool]] = None,
        confidence_scores: Optional[List[float]] = None,
        **kwargs
    ):
        super(ChangePointDetectResponse, self).__init__(**kwargs)
        self.period = None
        self.is_change_point = is_change_point
        self.confidence_scores = confidence_scores


class DetectionRequest(msrest.serialization.Model):
    """Request to submit a detection.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. source file link of the input variables, each variable will be a csv
     with two columns, the first column will be timestamp, the second column will be value.Besides
     these variable csv files, a extra meta.json can be included in th zip file if you would like to
     rename a variable.Be default, the file name of the variable will be used as the variable name.
     The variables used in detection should be consistent with variables in the model used for
     detection.
    :type source: str
    :param start_time: Required. A require field, start time of data be used for detection, should
     be date-time.
    :type start_time: ~datetime.datetime
    :param end_time: Required. A require field, end time of data be used for detection, should be
     date-time.
    :type end_time: ~datetime.datetime
    """

    _validation = {
        'source': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        source: str,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        **kwargs
    ):
        super(DetectionRequest, self).__init__(**kwargs)
        self.source = source
        self.start_time = start_time
        self.end_time = end_time


class DetectionResult(msrest.serialization.Model):
    """Anomaly Response of one detection corresponds to a resultId.

    All required parameters must be populated in order to send to Azure.

    :param result_id: Required.
    :type result_id: str
    :param summary: Required. Multivariate anomaly detection status.
    :type summary: ~azure.ai.anomalydetector.models.DetectionResultSummary
    :param results: Required. anomaly status of each timestamp.
    :type results: list[~azure.ai.anomalydetector.models.AnomalyState]
    """

    _validation = {
        'result_id': {'required': True},
        'summary': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'result_id': {'key': 'resultId', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'DetectionResultSummary'},
        'results': {'key': 'results', 'type': '[AnomalyState]'},
    }

    def __init__(
        self,
        *,
        result_id: str,
        summary: "DetectionResultSummary",
        results: List["AnomalyState"],
        **kwargs
    ):
        super(DetectionResult, self).__init__(**kwargs)
        self.result_id = result_id
        self.summary = summary
        self.results = results


class DetectionResultSummary(msrest.serialization.Model):
    """DetectionResultSummary.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Multivariate anomaly detection status. Possible values include:
     "CREATED", "RUNNING", "READY", "FAILED".
    :type status: str or ~azure.ai.anomalydetector.models.DetectionStatus
    :param errors: Error message when creating or training model fails.
    :type errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
    :param variable_states:
    :type variable_states: list[~azure.ai.anomalydetector.models.VariableState]
    :param setup_info: Required. Request when creating the model.
    :type setup_info: ~azure.ai.anomalydetector.models.DetectionRequest
    """

    _validation = {
        'status': {'required': True},
        'setup_info': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'variable_states': {'key': 'variableStates', 'type': '[VariableState]'},
        'setup_info': {'key': 'setupInfo', 'type': 'DetectionRequest'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "DetectionStatus"],
        setup_info: "DetectionRequest",
        errors: Optional[List["ErrorResponse"]] = None,
        variable_states: Optional[List["VariableState"]] = None,
        **kwargs
    ):
        super(DetectionResultSummary, self).__init__(**kwargs)
        self.status = status
        self.errors = errors
        self.variable_states = variable_states
        self.setup_info = setup_info


class DetectRequest(msrest.serialization.Model):
    """DetectRequest.

    All required parameters must be populated in order to send to Azure.

    :param series: Required. Time series data points. Points should be sorted by timestamp in
     ascending order to match the anomaly detection result. If the data is not sorted correctly or
     there is duplicated timestamp, the API will not work. In such case, an error message will be
     returned.
    :type series: list[~azure.ai.anomalydetector.models.TimeSeriesPoint]
    :param granularity: Optional argument, can be one of yearly, monthly, weekly, daily, hourly,
     minutely, secondly, microsecond or none. If granularity is not present, it will be none by
     default. If granularity is none, the timestamp property in time series point can be absent.
     Possible values include: "yearly", "monthly", "weekly", "daily", "hourly", "minutely",
     "secondly", "microsecond", "none".
    :type granularity: str or ~azure.ai.anomalydetector.models.TimeGranularity
    :param custom_interval: Custom Interval is used to set non-standard time interval, for example,
     if the series is 5 minutes, request can be set as {"granularity":"minutely",
     "customInterval":5}.
    :type custom_interval: int
    :param period: Optional argument, periodic value of a time series. If the value is null or does
     not present, the API will determine the period automatically.
    :type period: int
    :param max_anomaly_ratio: Optional argument, advanced model parameter, max anomaly ratio in a
     time series.
    :type max_anomaly_ratio: float
    :param sensitivity: Optional argument, advanced model parameter, between 0-99, the lower the
     value is, the larger the margin value will be which means less anomalies will be accepted.
    :type sensitivity: int
    """

    _validation = {
        'series': {'required': True},
    }

    _attribute_map = {
        'series': {'key': 'series', 'type': '[TimeSeriesPoint]'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'custom_interval': {'key': 'customInterval', 'type': 'int'},
        'period': {'key': 'period', 'type': 'int'},
        'max_anomaly_ratio': {'key': 'maxAnomalyRatio', 'type': 'float'},
        'sensitivity': {'key': 'sensitivity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        series: List["TimeSeriesPoint"],
        granularity: Optional[Union[str, "TimeGranularity"]] = None,
        custom_interval: Optional[int] = None,
        period: Optional[int] = None,
        max_anomaly_ratio: Optional[float] = None,
        sensitivity: Optional[int] = None,
        **kwargs
    ):
        super(DetectRequest, self).__init__(**kwargs)
        self.series = series
        self.granularity = granularity
        self.custom_interval = custom_interval
        self.period = period
        self.max_anomaly_ratio = max_anomaly_ratio
        self.sensitivity = sensitivity


class DiagnosticsInfo(msrest.serialization.Model):
    """DiagnosticsInfo.

    :param model_state:
    :type model_state: ~azure.ai.anomalydetector.models.ModelState
    :param variable_states:
    :type variable_states: list[~azure.ai.anomalydetector.models.VariableState]
    """

    _attribute_map = {
        'model_state': {'key': 'modelState', 'type': 'ModelState'},
        'variable_states': {'key': 'variableStates', 'type': '[VariableState]'},
    }

    def __init__(
        self,
        *,
        model_state: Optional["ModelState"] = None,
        variable_states: Optional[List["VariableState"]] = None,
        **kwargs
    ):
        super(DiagnosticsInfo, self).__init__(**kwargs)
        self.model_state = model_state
        self.variable_states = variable_states


class EntireDetectResponse(msrest.serialization.Model):
    """EntireDetectResponse.

    All required parameters must be populated in order to send to Azure.

    :param period: Required. Frequency extracted from the series, zero means no recurrent pattern
     has been found.
    :type period: int
    :param expected_values: Required. ExpectedValues contain expected value for each input point.
     The index of the array is consistent with the input series.
    :type expected_values: list[float]
    :param upper_margins: Required. UpperMargins contain upper margin of each input point.
     UpperMargin is used to calculate upperBoundary, which equals to expectedValue + (100 -
     marginScale)*upperMargin. Anomalies in response can be filtered by upperBoundary and
     lowerBoundary. By adjusting marginScale value, less significant anomalies can be filtered in
     client side. The index of the array is consistent with the input series.
    :type upper_margins: list[float]
    :param lower_margins: Required. LowerMargins contain lower margin of each input point.
     LowerMargin is used to calculate lowerBoundary, which equals to expectedValue - (100 -
     marginScale)*lowerMargin. Points between the boundary can be marked as normal ones in client
     side. The index of the array is consistent with the input series.
    :type lower_margins: list[float]
    :param is_anomaly: Required. IsAnomaly contains anomaly properties for each input point. True
     means an anomaly either negative or positive has been detected. The index of the array is
     consistent with the input series.
    :type is_anomaly: list[bool]
    :param is_negative_anomaly: Required. IsNegativeAnomaly contains anomaly status in negative
     direction for each input point. True means a negative anomaly has been detected. A negative
     anomaly means the point is detected as an anomaly and its real value is smaller than the
     expected one. The index of the array is consistent with the input series.
    :type is_negative_anomaly: list[bool]
    :param is_positive_anomaly: Required. IsPositiveAnomaly contain anomaly status in positive
     direction for each input point. True means a positive anomaly has been detected. A positive
     anomaly means the point is detected as an anomaly and its real value is larger than the
     expected one. The index of the array is consistent with the input series.
    :type is_positive_anomaly: list[bool]
    """

    _validation = {
        'period': {'required': True},
        'expected_values': {'required': True},
        'upper_margins': {'required': True},
        'lower_margins': {'required': True},
        'is_anomaly': {'required': True},
        'is_negative_anomaly': {'required': True},
        'is_positive_anomaly': {'required': True},
    }

    _attribute_map = {
        'period': {'key': 'period', 'type': 'int'},
        'expected_values': {'key': 'expectedValues', 'type': '[float]'},
        'upper_margins': {'key': 'upperMargins', 'type': '[float]'},
        'lower_margins': {'key': 'lowerMargins', 'type': '[float]'},
        'is_anomaly': {'key': 'isAnomaly', 'type': '[bool]'},
        'is_negative_anomaly': {'key': 'isNegativeAnomaly', 'type': '[bool]'},
        'is_positive_anomaly': {'key': 'isPositiveAnomaly', 'type': '[bool]'},
    }

    def __init__(
        self,
        *,
        period: int,
        expected_values: List[float],
        upper_margins: List[float],
        lower_margins: List[float],
        is_anomaly: List[bool],
        is_negative_anomaly: List[bool],
        is_positive_anomaly: List[bool],
        **kwargs
    ):
        super(EntireDetectResponse, self).__init__(**kwargs)
        self.period = period
        self.expected_values = expected_values
        self.upper_margins = upper_margins
        self.lower_margins = lower_margins
        self.is_anomaly = is_anomaly
        self.is_negative_anomaly = is_negative_anomaly
        self.is_positive_anomaly = is_positive_anomaly


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error Code.
    :type code: str
    :param message: Required. A message explaining the error reported by the service.
    :type message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LastDetectResponse(msrest.serialization.Model):
    """LastDetectResponse.

    All required parameters must be populated in order to send to Azure.

    :param period: Required. Frequency extracted from the series, zero means no recurrent pattern
     has been found.
    :type period: int
    :param suggested_window: Required. Suggested input series points needed for detecting the
     latest point.
    :type suggested_window: int
    :param expected_value: Required. Expected value of the latest point.
    :type expected_value: float
    :param upper_margin: Required. Upper margin of the latest point. UpperMargin is used to
     calculate upperBoundary, which equals to expectedValue + (100 - marginScale)*upperMargin. If
     the value of latest point is between upperBoundary and lowerBoundary, it should be treated as
     normal value. By adjusting marginScale value, anomaly status of latest point can be changed.
    :type upper_margin: float
    :param lower_margin: Required. Lower margin of the latest point. LowerMargin is used to
     calculate lowerBoundary, which equals to expectedValue - (100 - marginScale)*lowerMargin.
    :type lower_margin: float
    :param is_anomaly: Required. Anomaly status of the latest point, true means the latest point is
     an anomaly either in negative direction or positive direction.
    :type is_anomaly: bool
    :param is_negative_anomaly: Required. Anomaly status in negative direction of the latest point.
     True means the latest point is an anomaly and its real value is smaller than the expected one.
    :type is_negative_anomaly: bool
    :param is_positive_anomaly: Required. Anomaly status in positive direction of the latest point.
     True means the latest point is an anomaly and its real value is larger than the expected one.
    :type is_positive_anomaly: bool
    """

    _validation = {
        'period': {'required': True},
        'suggested_window': {'required': True},
        'expected_value': {'required': True},
        'upper_margin': {'required': True},
        'lower_margin': {'required': True},
        'is_anomaly': {'required': True},
        'is_negative_anomaly': {'required': True},
        'is_positive_anomaly': {'required': True},
    }

    _attribute_map = {
        'period': {'key': 'period', 'type': 'int'},
        'suggested_window': {'key': 'suggestedWindow', 'type': 'int'},
        'expected_value': {'key': 'expectedValue', 'type': 'float'},
        'upper_margin': {'key': 'upperMargin', 'type': 'float'},
        'lower_margin': {'key': 'lowerMargin', 'type': 'float'},
        'is_anomaly': {'key': 'isAnomaly', 'type': 'bool'},
        'is_negative_anomaly': {'key': 'isNegativeAnomaly', 'type': 'bool'},
        'is_positive_anomaly': {'key': 'isPositiveAnomaly', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        period: int,
        suggested_window: int,
        expected_value: float,
        upper_margin: float,
        lower_margin: float,
        is_anomaly: bool,
        is_negative_anomaly: bool,
        is_positive_anomaly: bool,
        **kwargs
    ):
        super(LastDetectResponse, self).__init__(**kwargs)
        self.period = period
        self.suggested_window = suggested_window
        self.expected_value = expected_value
        self.upper_margin = upper_margin
        self.lower_margin = lower_margin
        self.is_anomaly = is_anomaly
        self.is_negative_anomaly = is_negative_anomaly
        self.is_positive_anomaly = is_positive_anomaly


class Model(msrest.serialization.Model):
    """Response of get model.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Model identifier.
    :type model_id: str
    :param created_time: Required. Date and time (UTC) when the model was created.
    :type created_time: ~datetime.datetime
    :param last_updated_time: Required. Date and time (UTC) when the model was last updated.
    :type last_updated_time: ~datetime.datetime
    :param model_info: Training Status of the model.
    :type model_info: ~azure.ai.anomalydetector.models.ModelInfo
    """

    _validation = {
        'model_id': {'required': True},
        'created_time': {'required': True},
        'last_updated_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'model_info': {'key': 'modelInfo', 'type': 'ModelInfo'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_time: datetime.datetime,
        last_updated_time: datetime.datetime,
        model_info: Optional["ModelInfo"] = None,
        **kwargs
    ):
        super(Model, self).__init__(**kwargs)
        self.model_id = model_id
        self.created_time = created_time
        self.last_updated_time = last_updated_time
        self.model_info = model_info


class ModelInfo(msrest.serialization.Model):
    """Train result of a model including status, errors and diagnose info for model and variables.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param sliding_window: An optional field, indicates how many history points will be used to
     determine the anomaly score of one subsequent point.
    :type sliding_window: int
    :param align_policy: An optional field, since those multivariate need to be aligned in the same
     timestamp before starting the detection.
    :type align_policy: ~azure.ai.anomalydetector.models.AlignPolicy
    :param source: Required. source file link of the input variables, each variable will be a csv
     with two columns, the first column will be timestamp, the second column will be value.Besides
     these variable csv files, an extra meta.json can be included in th zip file if you would like
     to rename a variable.Be default, the file name of the variable will be used as the variable
     name.
    :type source: str
    :param start_time: Required. require field, start time of data be used for generating
     multivariate anomaly detection model, should be data-time.
    :type start_time: ~datetime.datetime
    :param end_time: Required. require field, end time of data be used for generating multivariate
     anomaly detection model, should be data-time.
    :type end_time: ~datetime.datetime
    :param display_name: optional field, name of the model.
    :type display_name: str
    :ivar status: Model training status. Possible values include: "CREATED", "RUNNING", "READY",
     "FAILED".
    :vartype status: str or ~azure.ai.anomalydetector.models.ModelStatus
    :ivar errors: Error message when fails to create a model.
    :vartype errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
    :ivar diagnostics_info: Used for deep analysis model and variables.
    :vartype diagnostics_info: ~azure.ai.anomalydetector.models.DiagnosticsInfo
    """

    _validation = {
        'source': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
        'display_name': {'max_length': 24, 'min_length': 0},
        'status': {'readonly': True},
        'errors': {'readonly': True},
        'diagnostics_info': {'readonly': True},
    }

    _attribute_map = {
        'sliding_window': {'key': 'slidingWindow', 'type': 'int'},
        'align_policy': {'key': 'alignPolicy', 'type': 'AlignPolicy'},
        'source': {'key': 'source', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'diagnostics_info': {'key': 'diagnosticsInfo', 'type': 'DiagnosticsInfo'},
    }

    def __init__(
        self,
        *,
        source: str,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        sliding_window: Optional[int] = None,
        align_policy: Optional["AlignPolicy"] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(ModelInfo, self).__init__(**kwargs)
        self.sliding_window = sliding_window
        self.align_policy = align_policy
        self.source = source
        self.start_time = start_time
        self.end_time = end_time
        self.display_name = display_name
        self.status = None
        self.errors = None
        self.diagnostics_info = None


class ModelList(msrest.serialization.Model):
    """Response to the list models operation.

    All required parameters must be populated in order to send to Azure.

    :param models: Required. List of models.
    :type models: list[~azure.ai.anomalydetector.models.ModelSnapshot]
    :param current_count: Required. Current count of trained multivariate models.
    :type current_count: int
    :param max_count: Required. Max number of models that can be trained for this subscription.
    :type max_count: int
    :param next_link: next link to fetch more models.
    :type next_link: str
    """

    _validation = {
        'models': {'required': True},
        'current_count': {'required': True},
        'max_count': {'required': True},
    }

    _attribute_map = {
        'models': {'key': 'models', 'type': '[ModelSnapshot]'},
        'current_count': {'key': 'currentCount', 'type': 'int'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        models: List["ModelSnapshot"],
        current_count: int,
        max_count: int,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ModelList, self).__init__(**kwargs)
        self.models = models
        self.current_count = current_count
        self.max_count = max_count
        self.next_link = next_link


class ModelSnapshot(msrest.serialization.Model):
    """ModelSnapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Model identifier.
    :type model_id: str
    :param created_time: Required. Date and time (UTC) when the model was created.
    :type created_time: ~datetime.datetime
    :param last_updated_time: Required. Date and time (UTC) when the model was last updated.
    :type last_updated_time: ~datetime.datetime
    :ivar status: Required. Model training status. Possible values include: "CREATED", "RUNNING",
     "READY", "FAILED".
    :vartype status: str or ~azure.ai.anomalydetector.models.ModelStatus
    :param display_name:
    :type display_name: str
    :param variables_count: Required. Count of variables.
    :type variables_count: int
    """

    _validation = {
        'model_id': {'required': True},
        'created_time': {'required': True},
        'last_updated_time': {'required': True},
        'status': {'required': True, 'readonly': True},
        'variables_count': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'variables_count': {'key': 'variablesCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_time: datetime.datetime,
        last_updated_time: datetime.datetime,
        variables_count: int,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(ModelSnapshot, self).__init__(**kwargs)
        self.model_id = model_id
        self.created_time = created_time
        self.last_updated_time = last_updated_time
        self.status = None
        self.display_name = display_name
        self.variables_count = variables_count


class ModelState(msrest.serialization.Model):
    """ModelState.

    :param epoch_ids: Epoch id.
    :type epoch_ids: list[int]
    :param train_losses:
    :type train_losses: list[float]
    :param validation_losses:
    :type validation_losses: list[float]
    :param latencies_in_seconds:
    :type latencies_in_seconds: list[float]
    """

    _attribute_map = {
        'epoch_ids': {'key': 'epochIds', 'type': '[int]'},
        'train_losses': {'key': 'trainLosses', 'type': '[float]'},
        'validation_losses': {'key': 'validationLosses', 'type': '[float]'},
        'latencies_in_seconds': {'key': 'latenciesInSeconds', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        epoch_ids: Optional[List[int]] = None,
        train_losses: Optional[List[float]] = None,
        validation_losses: Optional[List[float]] = None,
        latencies_in_seconds: Optional[List[float]] = None,
        **kwargs
    ):
        super(ModelState, self).__init__(**kwargs)
        self.epoch_ids = epoch_ids
        self.train_losses = train_losses
        self.validation_losses = validation_losses
        self.latencies_in_seconds = latencies_in_seconds


class TimeSeriesPoint(msrest.serialization.Model):
    """TimeSeriesPoint.

    All required parameters must be populated in order to send to Azure.

    :param timestamp: Optional argument, timestamp of a data point (ISO8601 format).
    :type timestamp: ~datetime.datetime
    :param value: Required. The measurement of that point, should be float.
    :type value: float
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        value: float,
        timestamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(TimeSeriesPoint, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.value = value


class VariableState(msrest.serialization.Model):
    """VariableState.

    :param variable: Variable name.
    :type variable: str
    :param filled_na_ratio: Merged NA ratio of a variable.
    :type filled_na_ratio: float
    :param effective_count: Effective time-series points count.
    :type effective_count: int
    :param start_time: Start time of a variable.
    :type start_time: ~datetime.datetime
    :param end_time: End time of a variable.
    :type end_time: ~datetime.datetime
    :param errors: Error message when parse variable.
    :type errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
    """

    _validation = {
        'filled_na_ratio': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'variable': {'key': 'variable', 'type': 'str'},
        'filled_na_ratio': {'key': 'filledNARatio', 'type': 'float'},
        'effective_count': {'key': 'effectiveCount', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
    }

    def __init__(
        self,
        *,
        variable: Optional[str] = None,
        filled_na_ratio: Optional[float] = None,
        effective_count: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        errors: Optional[List["ErrorResponse"]] = None,
        **kwargs
    ):
        super(VariableState, self).__init__(**kwargs)
        self.variable = variable
        self.filled_na_ratio = filled_na_ratio
        self.effective_count = effective_count
        self.start_time = start_time
        self.end_time = end_time
        self.errors = errors
