# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MapsGeofenceGeometry(Model):
    """The geofence geometry.

    :param device_id: ID of the device.
    :type device_id: str
    :param distance: Distance from the coordinate to the closest border of the
     geofence. Positive means the coordinate is outside of the geofence. If the
     coordinate is outside of the geofence, but more than the value of
     searchBuffer away from the closest geofence border, then the value is 999.
     Negative means the coordinate is inside of the geofence. If the coordinate
     is inside the polygon, but more than the value of searchBuffer away from
     the closest geofencing border,then the value is -999. A value of 999 means
     that there is great confidence the coordinate is well outside the
     geofence. A value of -999 means that there is great confidence the
     coordinate is well within the geofence.
    :type distance: float
    :param geometry_id: The unique ID for the geofence geometry.
    :type geometry_id: str
    :param nearest_lat: Latitude of the nearest point of the geometry.
    :type nearest_lat: float
    :param nearest_lon: Longitude of the nearest point of the geometry.
    :type nearest_lon: float
    :param ud_id: The unique id returned from user upload service when
     uploading a geofence. Will not be included in geofencing post API.
    :type ud_id: str
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'distance': {'key': 'distance', 'type': 'float'},
        'geometry_id': {'key': 'geometryId', 'type': 'str'},
        'nearest_lat': {'key': 'nearestLat', 'type': 'float'},
        'nearest_lon': {'key': 'nearestLon', 'type': 'float'},
        'ud_id': {'key': 'udId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MapsGeofenceGeometry, self).__init__(**kwargs)
        self.device_id = kwargs.get('device_id', None)
        self.distance = kwargs.get('distance', None)
        self.geometry_id = kwargs.get('geometry_id', None)
        self.nearest_lat = kwargs.get('nearest_lat', None)
        self.nearest_lon = kwargs.get('nearest_lon', None)
        self.ud_id = kwargs.get('ud_id', None)
