//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __NAPT_PACKAGE_H_2005_02_19
#define __NAPT_PACKAGE_H_2005_02_19

#include <qstring.h>

#include <ipackage.h>

class QStringList;

using namespace std;

namespace NApt
{

/** This is struct is straight forward. It holds the information as received by apt-cache show. */
struct Package : public IPackage
{
	Package();
	Package(const QString& name);
	explicit Package(const IPackage& package);

	/** @brief Constructs a package from the given lines containing the package information.
	  *
	  * The lines should look like the output of apt-cache show packagename
	  */
	Package(const QStringList& lines);
	/** This holds the name of the package. */
	QString _name;
	QString _essential;
	QString _priority;
	QString _section;
	QString _installedSize;
	QString _maintainer;
	QString _architecture;
	QString _source;
	QString _version;
	QString _replaces;
	QString _provides;
	QString _preDepends;
	QString _depends;
	QString _recommends;
	QString _suggests;
	QString _conflicts;
	QString _filename;
	QString _size;
	QString _md5sum;
	QString _conffiles;
	QString _description;
	InstalledState _installedState;
	QString _installedVersion;
	/** This should be filled with the first line of the description. */
	QString _shortDescription;
	QString _homepage;
	
	virtual QString name() const { return _name; }
	virtual QString essential() const { return _essential; }
	virtual QString priority() const { return _priority; }
	virtual QString section() const { return _section; }
	virtual QString installedSize() const { return _installedSize; }
	virtual QString maintainer() const { return _maintainer; }
	virtual QString architecture() const { return _architecture; }
	virtual QString source() const { return _source; }
	virtual QString version() const { return _version; }
	virtual QString replaces() const { return _replaces; }
	virtual QString provides() const { return _provides; }
	virtual QString preDepends() const { return _preDepends; }
	virtual QString depends() const { return _depends; }
	virtual QString recommends() const { return _recommends; }
	virtual QString suggests() const { return _suggests; }
	virtual QString conflicts() const { return _conflicts; }
	virtual QString filename() const { return _filename; }
	virtual QString size() const { return _size; }
	virtual QString md5sum() const { return _md5sum; }
	virtual QString conffiles() const { return _conffiles; }
	virtual QString description() const { return _description; }
	virtual InstalledState installedState() const { return _installedState; }
	virtual QString installedVersion() const { return _installedVersion; }
	virtual QString shortDescription() const { return _shortDescription; }
	virtual QString homepage() const { return _homepage; }

	
	virtual uint getSize() const 	{ return _size.toUInt(); }
	virtual uint getInstalledSize() const	{ return _installedSize.toUInt(); }
	/** t must provide the operator()(QString&) wich is applied on attributes. */
	template <typename T> void processEntries(T& t);
	
	/** @brief This parses the handed lines and sets the information for this package. 
	  *
	  * The lines should have the form &quot;Section: section information&quot;. 
	  * Where each section information be only one line except for the Description
	  * section which is allowed to have more lines. 
	  * @param lines the lines containing the information, to be handed without a 
	  * trailing newline
	  */
	void parseInformation(const QStringList& lines);
private:
	static QString _emptyString;
};



template <typename T> 
void Package::processEntries(T& t)
{
	t(_name);
	t(_essential);
	t(_priority);
	t(_section);
	t(_installedSize);
	t(_maintainer);
	t(_architecture);
	t(_source);
	t(_version);
	t(_replaces);
	t(_provides);
	t(_preDepends);
	t(_depends);
	t(_recommends);
	t(_suggests);
	t(_conflicts);
	t(_filename);
	t(_size);
	t(_md5sum);
	t(_conffiles);
	t(_description);
	t(_homepage);
}


}	// namespace NApt

#endif	// __NAPT_PACKAGE_H_2005_02_19
