unit unit_command_line_stars_wide_field;

{$mode delphi}

interface

uses
  Classes, SysUtils;

var
  wide_field_stars : array of single;{contains: mag1, ra1,dec1, mag2,ra2,dec2,mag3........}

var
  wide_database: string='';

function read_stars_wide_field: boolean; //write array to disk


implementation

uses
 unit_command_line_general, {for database path only}
 unit_command_line_star_database;{for name_database only}


function read_stars_wide_field : boolean;
var
  FS    : TFileStream;
  iSize : Integer;
begin
  try
    FS := TFileStream.Create(database_path+name_database+'_0101.001',fmOpenRead or fmShareDenyWrite); {read but do not lock file}
    FS.ReadBuffer(iSize,SizeOf(iSize));
    SetLength(wide_field_stars,iSize*3);{set length dynamic array}
    FS.ReadBuffer(wide_field_stars[0],isize*3*sizeof(single){bytes});{this only works with one dimensional arrays}
  fs.free;
  except
    result:=false;
    exit;
  end;
  wide_database:=name_database;{remember which database is in memory}
  result:=true;
end;

{
//USED FOR CREATION OF THE WIDE FIELD DATABASE
var
  star_array : array[0..41264,0..2] of single =    //all stars up to magnitude 8
  (
  (	-15	,	1.767725252	,	-0.291899504	),
  (	-6	,	1.675309906	,	-0.919709903	),
  (	0	,	4.873596766	,	0.676937966	),
  (	0	,	3.837100429	,	-1.061694783	),
  (	0	,	3.73338603	,	0.334553937	),
  (	1	,	1.381830995	,	0.802764629	),
  (	3	,	1.372430608	,	-0.143145706	),
  (	4	,	2.003995701	,	0.091067934	),
  (	5	,	0.426377942	,	-0.998974732	),
  (	6	,	3.681865855	,	-1.053711359	),
  (	9	,	1.549732466	,	0.129278955	),
  (	10	,	5.195838237	,	0.15482814	),
  (	10	,	3.513311938	,	-0.194805659	),
  (	12	,	3.257639986	,	-1.101288685	),
  (	12	,	3.349803453	,	-1.041767002	),
  (	13	,	1.203938869	,	0.288118709	),
  (	13	,	3.837016909	,	-1.061693304	),
  (	13	,	6.011181389	,	-0.517025453	),
  (	13	,	4.31710404	,	-0.461328283	),
  (	14	,	5.416768855	,	0.790291164	),
  (	14	,	2.654492042	,	0.208867759	),
  (	14	,	1.826600026	,	-0.505657973	),
  (	15	,	2.030237452	,	0.489143865	),
  (	15	,	3.257677825	,	-1.101295366	),
  (	16	,	4.597233711	,	-0.647587482	),
  (	16	,	1.41865076	,	0.110821598	),
  (	16	,	1.423720168	,	0.49927308	),
  (	16	,	1.467008574	,	-0.020977593	),
  (	17	,	2.413733433	,	-1.216781622	),
  (	17	,	2.135987445	,	-0.826178112	),
  (	18	,	4.81785329	,	-0.600139807	),
  (	18	,	1.486841177	,	-0.03390398	),
  (	19	,	3.277586156	,	-0.996845623	),
  (	19	,	5.347898357	,	-0.990224574	),
  (	19	,	1.568730303	,	0.784480582	),
  (	19	,	1.669842244	,	-0.313389946	),
  (	19	,	1.735344343	,	0.286212838	),
  (	20	,	0.891531101	,	0.870238602	),
  (	20	,	4.613424778	,	-0.750453704	),
  (	20	,	1.869210254	,	-0.460648381	),
  (	20	,	2.289458152	,	-0.954861673	),
  (	20	,	2.896023955	,	1.077754582	),
  (	20	,	4.953531785	,	-0.458970775	),
  (	20	,	0.036616818	,	0.507704077	),
  (	20	,	2.192624598	,	-1.038633665	),
  (	21	,	0.821041922	,	0.714810732	),
  (	22	,	0.662293435	,	1.557953065	),
  (	22	,	4.401136864	,	-1.204764948	),
  (	22	,	3.093793779	,	0.254316638	),
  (	22	,	3.577431731	,	-0.933166162	),
  (	22	,	4.19024548	,	-0.394821775	),
  (	22	,	3.820114449	,	-0.735796768	),
  (	23	,	0.554890706	,	0.409502433	),
  (	23	,	0.190185411	,	-0.313926758	),
  (	23	,	2.476565439	,	-0.151117012	),
  (	23	,	3.69426906	,	-0.634839556	),
  (	23	,	3.886440361	,	1.294257217	),
  (	23	,	0.304289848	,	0.621682363	),
  (	24	,	5.945782904	,	-0.818290994	),
  (	24	,	0.040005516	,	1.032365646	),
  (	24	,	0.540609991	,	0.738795133	),
  (	24	,	3.645719772	,	-0.825343276	),
  (	24	,	5.795524219	,	-0.819634845	),
  (	25	,	2.705180721	,	0.346280774	),
  (	25	,	2.391079517	,	-0.758039919	),
  (	25	,	4.697581122	,	0.898651696	),
  (	25	,	3.210566751	,	-0.306165342	),
  (	25	,	3.610812672	,	0.860677736	),
  (	25	,	3.377354844	,	0.976682493	),
  (	25	,	1.517374042	,	-0.168766482	),
  (	26	,	5.690583577	,	0.172351424	),
  (	26	,	1.56957751	,	0.649484963	),
  (	26	,	4.584821683	,	-0.650938357	),
  (	27	,	0.500207854	,	0.363173041	),
  (	27	,	0.247443199	,	1.059706724	),
  (	27	,	1.448652186	,	-0.005219911	),
  (	27	,	4.080314638	,	-0.718495366	),
  (	27	,	4.985581054	,	-0.521506882	),
  (	28	,	6.037880458	,	0.49015388	),
  (	28	,	0.795343079	,	0.071369881	),
  (	28	,	4.495875327	,	-0.274443925	),
  (	28	,	2.43076139	,	-1.034546983	),
  (	28	,	2.110030759	,	-0.698185344	),
  (	28	,	3.848139614	,	-0.827081393	),
  (	28	,	4.080319623	,	-0.718497415	),
  (	28	,	4.212513925	,	-0.345672068	),
  (	29	,	4.078361069	,	0.466248581	),
  (	29	,	4.603030085	,	0.219196073	),
  (	29	,	2.452681932	,	-0.960116292	),
  (	29	,	1.937729779	,	-0.511435279	),
  (	29	,	4.63597739	,	-0.681203606	),
  (	29	,	3.207667893	,	-1.025363526	),
  (	29	,	3.178056509	,	-0.885274785	),
  (	29	,	3.322722802	,	-0.854509425	),
  (	29	,	4.183778845	,	-0.455780384	),
  (	30	,	0.992590577	,	0.420710473	),
  (	30	,	1.021594714	,	0.556473305	),
  (	30	,	1.03783648	,	0.698306866	),
  (	30	,	0.176757604	,	0.986758716	),
  (	30	,	0.040126261	,	1.032344376	),
  (	30	,	3.114686078	,	0.937151005	),
  (	30	,	2.887845085	,	0.98406303	),
  (	30	,	3.507813453	,	0.958625624	),
  (	30	,	5.578881022	,	1.092328206	),
  (	30	,	1.481998667	,	-0.59470826	),
  (	30	,	1.951058894	,	0.144672899	),
  (	30	,	1.473253248	,	0.369005382	),
  (	30	,	4.350928224	,	-0.184427445	),
  (	30	,	2.805422785	,	-1.123893965	),
  (	30	,	3.303828074	,	-1.206644264	),
  (	30	,	3.920582044	,	-0.752832696	),
  (	30	,	4.345356516	,	-0.492464162	),
  (	30	,	3.887182444	,	-0.279987133	),
  (	31	,	4.36895654	,	0.55155785	),
  (	31	,	0.972698524	,	0.834046327	),
  (	31	,	5.170434341	,	0.787687042	),
  (	31	,	0.05775245	,	0.265002484	),
  (	31	,	6.042164183	,	0.265378761	),
  (	31	,	1.845792506	,	-0.415968991	),
  (	31	,	1.45181014	,	-0.311057441	),
  (	31	,	1.463602675	,	-0.103147218	),
  (	31	,	1.343236433	,	-0.088784664	),
  (	31	,	3.271873533	,	-0.288265548	),
  (	31	,	2.94136451	,	0.358196314	),
  (	31	,	4.009477956	,	-1.198687998	),
  (	31	,	3.343515005	,	-1.188711874	),
  (	31	,	4.589520425	,	-0.870508141	),
  (	31	,	4.407612434	,	-0.598549702	),
  (	31	,	4.281241795	,	-0.446680037	),
  (	31	,	4.00118969	,	-0.163764302	),
  (	32	,	1.337428361	,	0.719669086	),
  (	32	,	0.374514586	,	1.051298111	),
  (	32	,	1.983563096	,	0.55655938	),
  (	32	,	3.38602376	,	0.668788503	),
  (	32	,	4.488922889	,	1.146940898	),
  (	32	,	5.437656345	,	0.592918023	),
  (	32	,	5.332977585	,	0.7026115	),
  (	32	,	5.622840904	,	1.231516877	),
  (	32	,	1.659430341	,	-0.524704235	),
  (	32	,	4.911607372	,	-0.471078021	),
  (	32	,	5.016791232	,	-0.366935766	),
  (	32	,	4.997793738	,	0.241951739	),
  (	32	,	0.518274463	,	-1.074594659	),
  (	32	,	4.167545344	,	-1.107123683	),
  (	32	,	3.923329768	,	-0.734858635	),
  (	32	,	4.415116229	,	-0.664054612	),
  (	32	,	4.020241846	,	-0.709435344	),
  (	32	,	3.493230029	,	-0.640756969	),
  (	32	,	5.733111916	,	-0.652142125	),
  (	33	,	0.565255483	,	0.610640438	),
  (	33	,	3.64199361	,	0.321072911	),
  (	33	,	3.861477152	,	0.47253687	),
  (	33	,	4.368893487	,	0.551602919	),
  (	33	,	4.368894184	,	0.551604047	),
  (	33	,	3.805139842	,	0.668623457	),
  (	33	,	4.293468438	,	1.073632417	),
  (	33	,	4.017429306	,	1.253742337	),
  (	33	,	3.291635479	,	-0.408357373	),
  (	33	,	4.546624668	,	-0.436325968	),
  (	33	,	4.120162311	,	0.112153925	),
  (	33	,	4.516175563	,	0.433506878	),
  (	33	,	0.11357983	,	-1.348301393	),
  (	33	,	1.195540751	,	-0.960716648	),
  (	33	,	0.114716153	,	-0.738428168	),
  (	33	,	2.561711902	,	-1.13571985	),
  (	33	,	2.757722074	,	-1.076610898	),
  (	33	,	3.0359096	,	-1.099904492	),
  (	33	,	2.82207746	,	-0.86255217	),
  (	33	,	1.7355606	,	-0.753911769	),
  (	33	,	2.127301586	,	-0.42418479	),
  (	33	,	3.343525466	,	-1.188709474	),
  (	33	,	4.561392504	,	-0.983978549	),
  (	33	,	4.189320385	,	-0.670152229	),
  (	33	,	4.025953971	,	-0.779982812	),
  (	33	,	3.619392402	,	-0.727590344	),
  (	33	,	5.703073963	,	-0.281510246	),
  (	34	,	1.317588061	,	0.764860683	),
  (	34	,	0.80632614	,	0.933862878	),
  (	34	,	0.499152913	,	1.111250653	),
  (	34	,	2.352657052	,	0.838462042	),
  (	34	,	4.320636981	,	0.37506266	),
  (	34	,	4.583374097	,	0.912832885	),
  (	34	,	4.969579002	,	0.570540583	),
  (	34	,	5.998038293	,	-0.276128587	),
  (	34	,	1.43223992	,	-0.362330785	),
  (	34	,	1.365427597	,	-0.282840636	),
  (	34	,	3.412855523	,	0.191275629	),
  (	34	,	2.941919788	,	0.269287282	),
  (	34	,	4.834427911	,	-0.443714806	),
  (	34	,	5.285318469	,	-0.014336687	),
  (	34	,	5.001452351	,	-0.085227635	),
  (	34	,	5.176036167	,	0.185236145	),
  (	34	,	4.640269215	,	0.07973381	),
  (	34	,	2.677919916	,	-1.222391205	),
  (	34	,	2.404048585	,	-1.029164918	),
  (	34	,	1.781057157	,	-1.081058966	),
  (	34	,	2.080333076	,	-0.924713531	),
  (	34	,	4.658216832	,	-0.700348877	),
  (	34	,	3.619880982	,	-0.741308719	),
  (	35	,	1.29587989	,	0.578855381	),
  (	35	,	2.649987977	,	0.292563587	),
  (	35	,	2.556252097	,	0.414937697	),
  (	35	,	2.692565334	,	0.748991823	),
  (	35	,	2.499376764	,	0.901873601	),
  (	35	,	3.208924418	,	0.995407934	),
  (	35	,	5.947221595	,	0.527457401	),
  (	35	,	5.635491022	,	-0.097236333	),
  (	35	,	5.784825922	,	-0.005583719	),
  (	35	,	5.940504794	,	0.189042041	),
  (	35	,	1.415797752	,	-0.041838258	),
  (	35	,	1.264723041	,	0.121498667	),
  (	35	,	1.050165016	,	0.217996109	),
  (	35	,	1.462315458	,	0.173383489	),
  (	35	,	1.768394404	,	0.22504736	),
  (	35	,	3.554736073	,	-0.01039355	),
  (	35	,	3.323323042	,	-0.025301826	),
  (	35	,	3.323297375	,	-0.025286484	),
  (	35	,	4.803997437	,	-0.52060191	),
  (	35	,	4.251379406	,	-0.064495654	),
  (	35	,	1.125285555	,	-0.589893114	),
  (	35	,	0.595654141	,	-0.899059614	),
  (	35	,	0.777803226	,	-0.703446534	),
  (	35	,	2.604300489	,	-0.952387071	),
  (	35	,	2.270201614	,	-0.923658982	),
  (	35	,	1.788267363	,	-0.567379449	),
  (	35	,	1.907392812	,	-0.647472266	),
  (	35	,	3.850607904	,	-1.134058484	),
  (	35	,	4.417146141	,	-0.663533916	),
  (	35	,	3.749853794	,	-0.803866016	),
  (	35	,	3.485962178	,	-0.404424581	),
  (	35	,	5.840297373	,	-1.05173292	),
  (	35	,	4.830080526	,	-0.802307426	),
  (	35	,	5.32767155	,	-0.257984187	),
  (	36	,	4.514499427	,	0.251165088	),
  (	36	,	1.486844381	,	-0.03391526	),
  (	36	,	0.981207714	,	0.420851554	),
  (	36	,	0.999912064	,	0.419805727	),
  (	36	,	0.161321788	,	0.94067739	),
  (	36	,	2.336083708	,	0.103771417	),
  (	36	,	2.921947474	,	0.776641757	),
  (	36	,	2.372010155	,	0.823032234	),
  (	36	,	5.108235827	,	0.487987014	),
  (	36	,	5.029000157	,	1.180927823	),
  (	36	,	5.804112319	,	0.108174928	),
  (	36	,	1.385817648	,	-0.11945861	),
  (	36	,	1.478058648	,	-0.045379933	),
  (	36	,	1.283914956	,	0.042597919	),
  (	36	,	1.270626088	,	0.097827639	),
  (	36	,	1.172274066	,	0.276996558	),
  (	36	,	1.670984745	,	0.392927697	),
  (	36	,	1.762485709	,	0.438619486	),
  (	36	,	3.185760415	,	-0.394788161	),
  (	36	,	4.737724605	,	-0.531024284	),
  (	36	,	5.085465573	,	0.054369609	),
  (	36	,	4.143493764	,	-0.05987068	),
  (	36	,	1.038607076	,	-0.235781636	),
  (	36	,	1.788690126	,	-0.883398781	),
  (	36	,	2.284600236	,	-0.579210442	),
  (	36	,	4.586268727	,	-1.059144862	),
  (	36	,	4.560979059	,	-0.969182411	),
  (	36	,	4.50362168	,	-0.754701127	),
  (	36	,	4.095658689	,	-0.519721982	),
  (	36	,	5.432142174	,	-1.155462785	),
  (	36	,	5.971468333	,	-0.895655837	),
  (	36	,	5.399914701	,	-0.825384406	),
  (	36	,	4.741321127	,	-0.874262423	),
  (	37	,	4.804192301	,	1.269441786	),
  (	37	,	0.903954031	,	0.169863162	),
  (	37	,	0.741700509	,	0.47577656	),
  (	37	,	0.49341334	,	0.516229699	),
  (	37	,	0.214506014	,	1.008998408	),
  (	37	,	2.298475865	,	0.112025383	),
  (	37	,	2.448032148	,	0.600265404	),
  (	37	,	2.690821639	,	0.408708282	),
  (	37	,	2.715409689	,	0.724307006	),
  (	37	,	1.920394847	,	0.383661801	),
  (	37	,	1.80113146	,	0.592730029	),
  (	37	,	2.226415789	,	1.059718902	),
  (	37	,	4.128530474	,	0.269155731	),
  (	37	,	4.516241404	,	0.642441418	),
  (	37	,	4.622785978	,	0.802962406	),
  (	37	,	3.684327541	,	1.123572378	),
  (	37	,	5.408950152	,	0.277715868	),
  (	37	,	5.55423245	,	0.527553398	),
  (	37	,	6.029771315	,	0.738727531	),
  (	37	,	4.930904146	,	0.582287936	),
  (	37	,	6.193039465	,	1.354961105	),
  (	37	,	0.712521921	,	0.056464357	),
  (	37	,	1.531359458	,	-0.624225732	),
  (	37	,	1.332828519	,	-0.390457293	),
  (	37	,	1.513878004	,	-0.258691926	),
  (	37	,	1.911535406	,	0.288679831	),
  (	37	,	2.834534661	,	-0.282608262	),
  (	37	,	3.866975601	,	0.033034575	),
  (	37	,	2.761158849	,	0.162430147	),
  (	37	,	4.789282587	,	-0.641632689	),
  (	37	,	4.668142557	,	-0.646525687	),
  (	37	,	4.614587022	,	-0.268762667	),
  (	37	,	4.805304818	,	-0.050679038	),
  (	37	,	4.268743051	,	-0.081894864	),
  (	37	,	4.440379647	,	0.163623918	),
  (	37	,	4.653263023	,	0.483723973	),
  (	37	,	1.110148126	,	-1.090368362	),
  (	37	,	3.07876174	,	-1.164632327	),
  (	37	,	2.492418766	,	-0.995436946	),
  (	37	,	2.490125773	,	-0.706273068	),
  (	37	,	3.283235675	,	-1.258958858	),
  (	37	,	4.444565322	,	-0.97721665	),
  (	37	,	4.175194431	,	-0.509884654	),
  (	37	,	3.659425244	,	-0.781971798	),
  (	37	,	3.657643745	,	-0.734799164	),
  (	38	,	2.192627911	,	-1.038635152	),
  (	38	,	0.985357908	,	0.425291842	),
  (	38	,	0.978776701	,	0.563535031	),
  (	38	,	2.53573003	,	0.172648818	),
  (	38	,	2.493792229	,	1.100640336	),
  (	38	,	3.844741673	,	0.239603502	),
  (	38	,	4.284429244	,	0.334290384	),
  (	38	,	4.113483569	,	0.458948415	),
  (	38	,	4.048390728	,	0.508001374	),
  (	38	,	3.935475533	,	0.704944752	),
  (	38	,	4.27492257	,	0.808325321	),
  (	38	,	4.035764634	,	1.029154093	),
  (	38	,	3.287666587	,	1.218035773	),
  (	38	,	5.399834412	,	0.254730221	),
  (	38	,	5.89614832	,	0.877597161	),
  (	38	,	5.103809187	,	0.902870447	),
  (	38	,	5.43362294	,	1.079389546	),
  (	38	,	4.804403315	,	1.269400267	),
  (	38	,	0.453865521	,	-0.278057877	),
  (	38	,	5.854095772	,	-0.024212452	),
  (	38	,	0.171620152	,	0.538612663	),
  (	38	,	1.502965886	,	-0.391842905	),
  (	38	,	1.205669328	,	-0.058512039	),
  (	38	,	1.63570633	,	0.392816956	),
  (	38	,	3.101083102	,	0.030767383	),
  (	38	,	4.708140498	,	-0.170596192	),
  (	38	,	4.1487333	,	0.078158665	),
  (	38	,	4.659557911	,	0.047241909	),
  (	38	,	4.744450707	,	0.16693019	),
  (	38	,	4.745299423	,	0.502001158	),
  (	38	,	2.405397212	,	-1.08763463	),
  (	38	,	2.334578177	,	-1.058443442	),
  (	38	,	2.971444551	,	-0.951048176	),
  (	38	,	1.960127759	,	-0.755729635	),
  (	38	,	2.047681868	,	-0.433885393	),
  (	38	,	3.98057164	,	-0.909312188	),
  (	38	,	3.979047285	,	-0.850641437	),
  (	38	,	3.19242636	,	-0.914003314	),
  (	38	,	3.263932838	,	-0.876691614	),
  (	38	,	3.692998809	,	-0.465712145	),
  (	38	,	5.274429398	,	-1.155231981	),
  (	38	,	5.004462804	,	-0.48297056	),
  (	38	,	5.672741399	,	-0.2908144	),
  (	38	,	5.44401696	,	-0.165736807	),
  (	39	,	0.893658485	,	0.157574483	),
  (	39	,	1.172075132	,	0.334757341	),
  (	39	,	0.807997989	,	0.677882547	),
  (	39	,	0.982591173	,	0.743135845	),
  (	39	,	0.247657181	,	0.671944361	),
  (	39	,	2.960419129	,	0.577607985	),
  (	39	,	2.438412205	,	0.642311177	),
  (	39	,	2.026530289	,	0.425819227	),
  (	39	,	2.578607919	,	1.030401906	),
  (	39	,	3.994646405	,	0.58143997	),
  (	39	,	4.451846293	,	0.539770822	),
  (	39	,	4.375965201	,	0.679311151	),
  (	39	,	5.380907637	,	0.197276838	),
  (	39	,	5.230573102	,	0.340204882	),
  (	39	,	5.97778609	,	0.429373456	),
  (	39	,	5.790217818	,	0.442358753	),
  (	39	,	5.562341579	,	0.664052011	),
  (	39	,	5.485456659	,	0.718501162	),
  (	39	,	5.806951856	,	1.015804287	),
  (	39	,	5.97633789	,	1.155399888	),
  (	39	,	0.299306292	,	-0.17773089	),
  (	39	,	0.695875764	,	0.00573323	),
  (	39	,	1.555104522	,	-0.24725613	),
  (	39	,	2.206352183	,	-0.068182859	),
  (	39	,	1.245741596	,	-0.056806077	),
  (	39	,	1.060970224	,	0.104532548	),
  (	39	,	3.023761298	,	-0.556025432	),
  (	39	,	2.964167966	,	-0.25790908	),
  (	39	,	3.228441058	,	-0.011639927	),
  (	39	,	3.38415156	,	0.059290509	),
  (	39	,	2.418887025	,	0.040353459	),
  (	39	,	4.964287993	,	-0.368382312	),
  (	39	,	4.772443579	,	-0.367546046	),
  (	39	,	0.9915399	,	-1.295700422	),
  (	39	,	1.515316761	,	-0.891268547	),
  (	39	,	0.298388772	,	-0.964216563	),
  (	39	,	0.385564182	,	-0.756070895	),
  (	39	,	0.97409314	,	-0.170313116	),
  (	39	,	2.692525738	,	-1.070449949	),
  (	39	,	2.295225462	,	-0.803575686	),
  (	39	,	2.780726905	,	-0.841696681	),
  (	39	,	2.682266994	,	-0.735160558	),
  (	39	,	2.047437075	,	-0.809364214	),
  (	39	,	1.897218881	,	-0.467270216	),
  (	39	,	3.830499711	,	-0.86264698	),
  (	39	,	3.965576323	,	-0.79028405	),
  (	39	,	4.149339459	,	-0.586909307	),
  (	39	,	3.222030497	,	-1.117065368	),
  (	39	,	3.379795699	,	-0.997944664	),
  (	39	,	3.848271205	,	-0.659624783	),
  (	39	,	3.306067804	,	-0.847206421	),
  (	39	,	3.944740769	,	-0.441258778	),
  (	39	,	4.218490383	,	-0.360748246	),
  (	39	,	5.238606546	,	-1.272544345	),
  (	39	,	5.072967165	,	-0.775957403	),
  (	39	,	5.0784169	,	-0.708896388	),
  (	39	,	5.314771926	,	-0.218948681	),
  (	40	,	3.733385627	,	0.334552759	),
  (	40	,	1.568743836	,	0.947436323	),
  (	40	,	1.042681805	,	0.624671641	),
  (	40	,	1.084994619	,	0.832736479	),
  (	40	,	0.59915394	,	0.590738641	),
  (	40	,	0.427585072	,	0.848708833	),
  (	40	,	0.452309565	,	0.884683568	),
  (	40	,	0.53856981	,	1.263992764	),
  (	40	,	4.173352861	,	0.273191251	),
  (	40	,	3.804061106	,	0.530096095	),
  (	40	,	3.507868473	,	0.958563146	),
  (	40	,	6.185318072	,	0.810796579	),
  (	40	,	0.084768442	,	-0.154010887	),
  (	40	,	0.366611859	,	-0.142849271	),
  (	40	,	0.399175532	,	0.267834902	),
  (	40	,	5.913868563	,	-0.002057388	),
  (	40	,	6.096377237	,	0.057288905	),
  (	40	,	1.84899418	,	-0.272853717	),
  (	40	,	2.166451302	,	0.160311985	),
  (	40	,	1.133577176	,	0.272750976	),
  (	40	,	1.85052297	,	0.359019322	),
  (	40	,	2.664176146	,	-0.215625955	),
  (	40	,	2.972007626	,	0.105230046	),
  (	40	,	4.994632064	,	-0.379467774	),
  (	40	,	5.068749812	,	-0.311489762	),
  (	40	,	5.215543398	,	0.111760836	),
  (	40	,	4.323673903	,	0.034620553	),
  (	40	,	4.715204585	,	0.051164395	),
  (	40	,	4.702647291	,	0.510469497	),
  (	40	,	1.45571468	,	-1.090651657	),
  (	40	,	0.506093484	,	-0.900709167	),
  (	40	,	0.114351539	,	-0.762352924	),
  (	40	,	0.928965857	,	-0.165075266	),
  (	40	,	2.366869217	,	-1.158841681	),
  (	40	,	2.739634945	,	-1.025195758	),
  (	40	,	2.506483061	,	-1.033753512	),
  (	40	,	2.271659202	,	-0.814173565	),
  (	40	,	2.060434342	,	-0.708180095	),
  (	40	,	2.023742713	,	-0.505356563	),
  (	40	,	1.840096068	,	-0.487554173	),
  (	40	,	3.413401884	,	-1.248765962	),
  (	40	,	3.949320182	,	-0.821200778	),
  (	40	,	4.650135026	,	-1.129651515	),
  (	40	,	4.426934505	,	-0.739372173	),
  (	40	,	4.022124422	,	-0.632890747	),
  (	40	,	3.234751811	,	-1.054187781	),
  (	40	,	3.754879229	,	-0.661224452	),
  (	40	,	4.088536905	,	-0.491048894	),
  (	40	,	4.241129771	,	-0.339656544	),
  (	40	,	3.853091265	,	-0.098792561	),
  (	40	,	5.475146041	,	-1.020220275	),
  (	41	,	0.987537087	,	0.417971847	),
  (	41	,	1.319811448	,	0.716906169	),
  (	41	,	0.944618432	,	0.841116916	),
  (	41	,	0.826863784	,	0.782893547	),
  (	41	,	2.258692553	,	0.099548961	),
  (	41	,	2.850622401	,	0.597128746	),
  (	41	,	3.080700375	,	0.833911392	),
  (	41	,	2.358911961	,	0.729216757	),
  (	41	,	1.944832433	,	0.485157698	),
  (	41	,	4.07067078	,	0.547318634	),
  (	41	,	4.684173936	,	0.992624421	),
  (	41	,	3.513483916	,	0.959717663	),
  (	41	,	5.566838218	,	0.091582104	),
  (	41	,	5.180957408	,	0.323484835	),
  (	41	,	5.364251082	,	0.530031168	),
  (	41	,	5.575970431	,	0.609065054	),
  (	41	,	6.197714653	,	0.773770796	),
  (	41	,	5.701963307	,	0.860613982	),
  (	41	,	5.29546803	,	0.815790388	),
  (	41	,	5.048825516	,	0.931470222	),
  (	41	,	5.519304379	,	0.766685779	),
  (	41	,	5.18440912	,	1.226411595	),
  (	41	,	6.062611438	,	-0.369524695	),
  (	41	,	0.486343173	,	-0.180385284	),
  (	41	,	0.532533198	,	0.0482367	),
  (	41	,	5.98916272	,	-0.132284954	),
  (	41	,	6.280199385	,	0.119774035	),
  (	41	,	1.667282427	,	-0.58358156	),
  (	41	,	1.532959375	,	-0.364487429	),
  (	41	,	1.39441099	,	-0.229978593	),
  (	41	,	1.884363543	,	-0.008599754	),
  (	41	,	1.348905853	,	-0.152787861	),
  (	41	,	1.098972469	,	-0.119328356	),
  (	41	,	1.171892738	,	0.278587361	),
  (	41	,	1.147283516	,	0.306171269	),
  (	41	,	1.697171103	,	0.352766654	),
  (	41	,	3.178316942	,	-0.43160515	),
  (	41	,	2.988349419	,	-0.30864379	),
  (	41	,	2.984194165	,	0.18376828	),
  (	41	,	0.9783444	,	-1.131083903	),
  (	41	,	0.618480078	,	-1.198332527	),
  (	41	,	0.69636852	,	-1.191482992	),
  (	41	,	1.108299262	,	-0.738200609	),
  (	41	,	1.202309493	,	-0.533415016	),
  (	41	,	0.641348122	,	-0.832589779	),
  (	41	,	0.041082697	,	-0.798464939	),
  (	41	,	0.838137279	,	-0.505854399	),
  (	41	,	0.795814172	,	-0.412331512	),
  (	41	,	0.870562621	,	-0.379742424	),
  (	41	,	2.724430763	,	-1.29209881	),
  (	41	,	1.870773601	,	-1.230425286	),
  (	41	,	2.206681636	,	-1.154324872	),
  (	41	,	2.374314096	,	-0.822011635	),
  (	41	,	2.851424974	,	-1.027176896	),
  (	41	,	2.065171259	,	-0.839553851	),
  (	41	,	2.135795925	,	-0.826329899	),
  (	41	,	2.030056001	,	-0.662676148	),
  (	41	,	4.334670326	,	-1.377024486	),
  (	41	,	4.003388007	,	-1.026291157	),
  (	41	,	4.406031527	,	-1.030469627	),
  (	41	,	4.217552228	,	-0.642324701	),
  (	41	,	4.32571936	,	-0.605707719	),
  (	41	,	3.433540366	,	-0.87102987	),
  (	41	,	5.678782713	,	-1.350729861	),
  (	41	,	6.097432995	,	-1.016395691	),
  (	41	,	5.936983915	,	-0.472000321	),
  (	41	,	4.940229163	,	-1.085379835	),
  (	41	,	5.015532333	,	-0.661569577	),
  (	41	,	5.61414415	,	-0.391148457	),
  (	41	,	5.523746886	,	-0.300777669	),
  (	42	,	2.705199443	,	0.346266941	),
  (	42	,	0.646468734	,	0.147655554	),
  (	42	,	0.982658899	,	0.427028765	),
  (	42	,	1.231526501	,	0.400671476	),
  (	42	,	0.422330379	,	0.722615306	),
  (	42	,	0.303260713	,	0.824523761	),
  (	42	,	0.143989906	,	1.098366568	),
  (	42	,	0.825196466	,	0.865904026	),
  (	42	,	0.716518805	,	0.859187695	),
  (	42	,	0.760342132	,	0.920878465	),
  (	42	,	0.744808973	,	0.975558775	),
  (	42	,	1.283036062	,	1.157899003	),
  (	42	,	2.586390035	,	0.453900245	),
  (	42	,	2.289367785	,	0.316824838	),
  (	42	,	1.959641646	,	0.554766133	),
  (	42	,	3.016803572	,	1.210053261	),
  (	42	,	4.078835908	,	0.183938427	),
  (	42	,	4.337590263	,	0.740670905	),
  (	42	,	4.227050477	,	0.784266528	),
  (	42	,	3.736645743	,	0.804411966	),
  (	42	,	3.775086106	,	0.904917752	),
  (	42	,	4.196958522	,	1.02219692	),
  (	42	,	5.962625171	,	0.411297096	),
  (	42	,	6.187793063	,	0.755170185	),
  (	42	,	5.573778248	,	0.687566432	),
  (	42	,	5.646052505	,	0.795716367	),
  (	42	,	5.219865441	,	0.612317801	),
  (	42	,	5.886872594	,	1.019537857	),
  (	42	,	5.687625924	,	1.025904841	),
  (	42	,	4.80295781	,	1.245082657	),
  (	42	,	6.121597703	,	-0.35083319	),
  (	42	,	5.787679046	,	-0.242078448	),
  (	42	,	1.560048345	,	-0.615808186	),
  (	42	,	1.80699358	,	-0.422093616	),
  (	42	,	1.709794363	,	-0.408727827	),
  (	42	,	1.730868348	,	-0.336086975	),
  (	42	,	2.012561358	,	-0.166701118	),
  (	42	,	2.282995642	,	0.059317729	),
  (	42	,	1.213780998	,	-0.249670968	),
  (	42	,	1.443319423	,	0.103810019	),
  (	42	,	1.114981151	,	0.155198218	),
  (	42	,	1.581196832	,	0.168374937	),
  (	42	,	3.110646549	,	-0.591807937	),
  (	42	,	3.7350645	,	-0.104779587	),
  (	42	,	2.731818567	,	-0.293858389	),
  (	42	,	2.530104813	,	-0.019953391	),
  (	42	,	4.565651368	,	-0.421952937	),
  (	42	,	4.866006813	,	-0.143924231	),
  (	42	,	4.750603563	,	0.36328176	),
  (	42	,	4.815817294	,	0.379924381	),
  (	42	,	4.69604013	,	0.650145324	),
  (	42	,	1.56707645	,	-0.747266366	),
  (	42	,	1.445191091	,	-0.619081056	),
  (	42	,	0.3981864	,	-0.856461568	),
  (	42	,	0.288345078	,	-0.815389738	),
  (	42	,	0.255719639	,	-0.512383607	),
  (	42	,	0.932831661	,	-0.377568415	),
  (	42	,	0.71611829	,	-0.241882608	),
  (	42	,	0.76981973	,	-0.155328459	),
  (	42	,	2.175288664	,	-1.342489461	),
  (	42	,	2.553617835	,	-1.090967745	),
  (	42	,	2.015087563	,	-1.267213691	),
  (	42	,	1.906030654	,	-1.186075035	),
  (	42	,	2.271619294	,	-1.043025669	),
  (	42	,	3.096576557	,	-1.113318534	),
  (	42	,	2.917272016	,	-1.02930841	),
  (	42	,	2.258645791	,	-0.750299798	),
  (	42	,	2.269376382	,	-0.616249543	),
  (	42	,	3.874024879	,	-1.379593181	),
  (	42	,	3.22162041	,	-1.384258238	),
  (	42	,	4.256151409	,	-1.111526491	),
  (	42	,	4.007853154	,	-0.835582698	),
  (	42	,	3.949330715	,	-0.821197356	),
  (	42	,	3.171629143	,	-1.127726815	),
  (	42	,	3.890503574	,	-0.760535425	),
  (	42	,	3.691568838	,	-0.718722608	),
  (	42	,	3.538846567	,	-0.687788153	),
  (	42	,	4.082011652	,	-0.258125142	),
  (	42	,	5.960525789	,	-1.420377239	),
  (	42	,	5.88730314	,	-0.759141145	),
  (	42	,	6.06660859	,	-0.789707467	),
  (	42	,	5.234838108	,	-0.615690762	),
  (	42	,	5.437110491	,	-0.441079399	),
  (	43	,	0.71973081	,	0.176520134	),
  (	43	,	0.744344737	,	0.668773224	),
  (	43	,	1.157906145	,	0.389096068	),
  (	43	,	1.075923346	,	0.878790894	),
  (	43	,	1.323910216	,	1.054914447	),
  (	43	,	0.160925227	,	0.588513154	),
  (	43	,	0.912234421	,	1.046156048	),
  (	43	,	2.305720955	,	0.101885479	),
  (	43	,	2.349596858	,	0.206951788	),
  (	43	,	2.298146183	,	0.501949531	),
  (	43	,	3.61926598	,	0.275730319	),
  (	43	,	4.119244324	,	1.357769794	),
  (	43	,	4.591181597	,	1.511225359	),
  (	43	,	5.692592547	,	0.447591198	),
  (	43	,	5.30349743	,	0.832770064	),
  (	43	,	5.034219349	,	0.683225827	),
  (	43	,	5.294460131	,	0.987302888	),
  (	43	,	5.825290451	,	0.995604475	),
  (	43	,	5.365071798	,	1.09945295	),
  (	43	,	6.099506508	,	-0.160266077	),
  (	43	,	5.885401616	,	-0.000345885	),
  (	43	,	5.963352102	,	0.212397167	),
  (	43	,	6.195749485	,	0.098144396	),
  (	43	,	1.815740082	,	-0.297652229	),
  (	43	,	1.635615224	,	-0.109517777	),
  (	43	,	1.268034428	,	0.155333896	),
  (	43	,	1.202775283	,	0.177334792	),
  (	43	,	1.293154325	,	0.235866534	),
  (	43	,	1.213704916	,	0.218353496	),
  (	43	,	1.158431217	,	0.312897239	),
  (	43	,	1.470043893	,	0.162115833	),
  (	43	,	1.460930951	,	0.165624226	),
  (	43	,	1.622894316	,	0.247987356	),
  (	43	,	1.603836774	,	0.25775598	),
  (	43	,	1.53366347	,	0.683270726	),
  (	43	,	2.878749967	,	-0.31935848	),
  (	43	,	3.672377999	,	0.026954527	),
  (	43	,	3.079889754	,	0.113936919	),
  (	43	,	4.541473138	,	-0.224220103	),
  (	43	,	4.631285629	,	-0.224723174	),
  (	43	,	5.134415071	,	-0.022458023	),
  (	43	,	5.203145295	,	0.01755105	),
  (	43	,	4.981518099	,	-0.100171229	),
  (	43	,	4.424437256	,	0.177414795	),
  (	43	,	4.972535268	,	0.262982701	),
  (	43	,	4.911626278	,	0.358560062	),
  (	43	,	1.117145665	,	-0.898589205	),
  (	43	,	1.152087636	,	-0.593700148	),
  (	43	,	0.137661102	,	-1.098834834	),
  (	43	,	0.189166721	,	-1.002918247	),
  (	43	,	0.989790561	,	-0.405848408	),
  (	43	,	0.523638604	,	-0.367880512	),
  (	43	,	2.817734591	,	-1.405690697	),
  (	43	,	2.128985953	,	-1.197590079	),
  (	43	,	3.08274206	,	-1.067766542	),
  (	43	,	1.723407852	,	-0.924597515	),
  (	43	,	2.086717479	,	-0.859484714	),
  (	43	,	2.288118882	,	-0.744367949	),
  (	43	,	2.062297608	,	-0.6782836	),
  (	43	,	2.00202631	,	-0.46781276	),
  (	43	,	1.914224884	,	-0.435535828	),
  (	43	,	2.314864502	,	-0.483617512	),
  (	43	,	2.133782586	,	-0.335889702	),
  (	43	,	3.753877009	,	-0.984130914	),
  (	43	,	3.807507029	,	-0.880645699	),
  (	43	,	4.275329954	,	-0.875385013	),
  (	43	,	3.765706829	,	-0.689613825	),
  (	43	,	3.176872782	,	-0.884207381	),
  (	43	,	3.374763017	,	-0.701256833	),
  (	43	,	3.602674099	,	-0.576739417	),
  (	43	,	5.613191812	,	-1.140758344	),
  (	43	,	4.900167685	,	-1.246675006	),
  (	43	,	6.165262954	,	-0.660050669	),
  (	43	,	5.693909183	,	-0.576420059	),
  (	43	,	5.897063659	,	-0.5645478	),
  (	43	,	4.838213684	,	-0.856471195	),
  (	44	,	0.9201092	,	0.225787552	),
  (	44	,	1.162000823	,	0.398166502	),
  (	44	,	1.112202334	,	0.844900162	),
  (	44	,	1.297152589	,	0.938152147	),
  (	44	,	0.217358529	,	0.716959982	),
  (	44	,	0.195154152	,	0.842720145	),
  (	44	,	0.31029201	,	0.962544964	),
  (	44	,	2.739647533	,	0.640654407	),
  (	44	,	2.959088553	,	0.550248502	),
  (	44	,	1.989332728	,	0.469406448	),
  (	44	,	1.656416188	,	1.029938903	),
  (	44	,	4.139650844	,	0.316619322	),
  (	44	,	4.178253229	,	0.469100106	),
  (	44	,	4.033828021	,	0.652365292	),
  (	44	,	3.455088988	,	0.486673039	),
  (	44	,	3.288707873	,	0.721859576	),
  (	44	,	4.389391898	,	1.43182056	),
  (	44	,	5.594171947	,	0.34566153	),
  (	44	,	5.803162958	,	0.579066748	),
  (	44	,	5.829268479	,	0.658839707	),
  (	44	,	5.892613728	,	0.752644232	),
  (	44	,	4.907750258	,	0.656335591	),
  (	44	,	4.953837026	,	0.767013816	),
  (	44	,	5.696093846	,	1.066759054	),
  (	44	,	5.274780365	,	1.356323146	),
  (	44	,	5.9759694	,	-0.237240802	),
  (	44	,	5.833053021	,	-0.135846673	),
  (	44	,	6.038303514	,	0.066671201	),
  (	44	,	0.206540878	,	0.423532436	),
  (	44	,	1.693709741	,	-0.568626377	),
  (	44	,	1.807227789	,	-0.210115434	),
  (	44	,	1.366727762	,	-0.225868327	),
  (	44	,	1.362662275	,	-0.207159609	),
  (	44	,	1.41348425	,	-0.136281699	),
  (	44	,	1.448322121	,	-0.127436466	),
  (	44	,	1.277991022	,	-0.095164455	),
  (	44	,	1.463397328	,	-0.084445376	),
  (	44	,	1.479977061	,	0.071933256	),
  (	44	,	1.426096245	,	0.05402956	),
  (	44	,	0.946259058	,	0.006952011	),
  (	44	,	3.281472757	,	-0.282680675	),
  (	44	,	3.446802009	,	-0.096677895	),
  (	44	,	2.652628628	,	-0.006488044	),
  (	44	,	3.164293016	,	0.152423962	),
  (	44	,	3.446938307	,	0.305957563	),
  (	44	,	2.889956767	,	0.352209445	),
  (	44	,	4.569948908	,	-0.521294817	),
  (	44	,	4.30670364	,	-0.322125034	),
  (	44	,	4.720041656	,	0.022775821	),
  (	44	,	4.736212212	,	0.043501553	),
  (	44	,	4.917567538	,	0.317341271	),
  (	44	,	1.504346692	,	-1.147300275	),
  (	44	,	0.872851886	,	-0.751621419	),
  (	44	,	1.00117556	,	-0.63181967	),
  (	44	,	0.088063305	,	-1.132137573	),
  (	44	,	0.701064527	,	-0.695610846	),
  (	44	,	0.777856403	,	-0.703447639	),
  (	44	,	2.772730807	,	-1.371963366	),
  (	44	,	2.29820005	,	-0.990818342	),
  (	44	,	2.709242552	,	-0.978138371	),
  (	44	,	2.880470755	,	-0.736979782	),
  (	44	,	2.516852742	,	-0.861402469	),
  (	44	,	2.042409716	,	-0.452688437	),
  (	44	,	2.580811754	,	-0.259124632	),
  (	44	,	2.080686519	,	-0.39933274	),
  (	44	,	4.087221041	,	-1.157457349	),
  (	44	,	3.218187256	,	-1.186141796	),
  (	44	,	3.502136346	,	-1.064450677	),
  (	44	,	4.448775246	,	-0.927822072	),
  (	44	,	4.028024449	,	-0.643304453	),
  (	44	,	3.154750489	,	-1.105018294	),
  (	44	,	3.779233581	,	-0.789264483	),
  (	44	,	3.619133863	,	-0.601284087	),
  (	44	,	3.855673076	,	-0.613917862	),
  (	44	,	4.161862029	,	-0.29196502	),
  (	44	,	6.282834201	,	-1.144539705	),
  (	44	,	6.025213332	,	-0.92073509	),
  (	44	,	6.003708873	,	-0.567919619	),
  (	44	,	4.749832652	,	-1.111249199	),
  (	44	,	5.075516114	,	-0.781910162	),
  (	44	,	5.215314612	,	-0.730732364	),
  (	44	,	5.017950019	,	-0.686630998	),
  (	44	,	5.462100519	,	-0.469827783	),
  (	44	,	5.659582968	,	-0.339745928	),
  (	45	,	0.71319464	,	0.483579598	),
  (	45	,	1.207289207	,	0.720204967	),
  (	45	,	0.079959472	,	0.642018168	),
  (	45	,	0.532107348	,	1.237560132	),
  (	45	,	0.300119021	,	1.505468958	),
  (	45	,	2.650418409	,	0.615136048	),
  (	45	,	2.194028732	,	0.753762881	),
  (	45	,	2.394874545	,	0.900666996	),
  (	45	,	2.508129011	,	0.908465286	),
  (	45	,	4.108285859	,	0.343309899	),
  (	45	,	4.553916846	,	0.648319109	),
  (	45	,	3.785299468	,	1.321146837	),
  (	45	,	5.425610353	,	0.263095822	),
  (	45	,	5.439569283	,	0.281398081	),
  (	45	,	5.435226962	,	0.536163011	),
  (	45	,	5.442849926	,	0.636882239	),
  (	45	,	5.851332723	,	0.812216599	),
  (	45	,	5.776186542	,	1.12798168	),
  (	45	,	0.016321164	,	-0.302571219	),
  (	45	,	6.207809994	,	-0.253864518	),
  (	45	,	0.459875747	,	0.159839414	),
  (	45	,	0.274633001	,	0.137711921	),
  (	45	,	6.090771315	,	-0.158612951	),
  (	45	,	6.083884672	,	-0.105598767	),
  (	45	,	6.143405091	,	0.111329179	),
  (	45	,	5.885404819	,	-0.000356612	),
  (	45	,	5.869880592	,	0.024040449	),
  (	45	,	1.723761134	,	-0.400809246	),
  (	45	,	1.696537079	,	-0.122750401	),
  (	45	,	1.674502346	,	0.080161853	),
  (	45	,	1.714366024	,	0.127983878	),
  (	45	,	1.749595167	,	0.172712949	),
  (	45	,	1.546263055	,	0.35387642	),
  (	45	,	1.541682366	,	0.481923722	),
  (	45	,	2.930661823	,	-0.398398676	),
  (	45	,	2.640348939	,	-0.228018424	),
  (	45	,	2.952480132	,	-0.063736936	),
  (	45	,	3.041013226	,	-0.01437192	),
  (	45	,	2.860642647	,	0.431962469	),
  (	45	,	4.542281115	,	-0.368514809	),
  (	45	,	5.068990577	,	-0.278468296	),
  (	45	,	5.403271439	,	-0.019290316	),
  (	45	,	4.918225904	,	-0.082868005	),
  (	45	,	4.324655852	,	-0.289951397	),
  (	45	,	4.705854681	,	0.526902697	),
  (	45	,	1.22415936	,	-0.730669469	),
  (	45	,	1.046870685	,	-0.419160012	),
  (	45	,	1.019763719	,	-0.429565215	),
  (	45	,	2.380800432	,	-1.231127944	),
  (	45	,	2.527881362	,	-1.070373918	),
  (	45	,	2.78949694	,	-0.970459491	),
  (	45	,	2.736453913	,	-0.54223385	),
  (	45	,	2.064114566	,	-0.865909154	),
  (	45	,	2.175340819	,	-0.639813124	),
  (	45	,	1.995643548	,	-0.610312249	),
  (	45	,	1.91247157	,	-0.641127697	),
  (	45	,	1.894787553	,	-0.459937459	),
  (	45	,	2.296748728	,	-0.236454203	),
  (	45	,	4.376593744	,	-1.352977445	),
  (	45	,	4.307400734	,	-0.829990182	),
  (	45	,	4.606180656	,	-0.811682093	),
  (	45	,	4.610055918	,	-0.674338736	),
  (	45	,	4.083575896	,	-0.784674429	),
  (	45	,	4.347506263	,	-0.615320325	),
  (	45	,	4.242472277	,	-0.487410147	),
  (	45	,	4.32901535	,	-0.374654583	),
  (	45	,	3.38005374	,	-1.032306489	),
  (	45	,	3.343949977	,	-0.985917652	),
  (	45	,	3.457023193	,	-1.045813466	),
  (	45	,	3.672719513	,	-0.795931808	),
  (	45	,	3.779425723	,	-0.792018216	),
  (	45	,	3.62952356	,	-0.575858991	),
  (	45	,	4.221108069	,	-0.364234115	),
  (	45	,	3.980314186	,	-0.345433917	),
  (	45	,	3.721460565	,	-0.179293106	),
  (	45	,	5.87886826	,	-1.133875811	),
  (	45	,	5.750510914	,	-0.959801924	),
  (	45	,	5.584492838	,	-0.932876524	),
  (	45	,	5.889424422	,	-0.763567575	),
  (	45	,	6.051392522	,	-0.759575073	),
  (	45	,	5.988767805	,	-0.573789136	),
  (	45	,	5.796177279	,	-0.575760541	),
  (	45	,	4.84928254	,	-1.086966925	),
  (	45	,	5.134363144	,	-0.434303941	),
  (	45	,	5.59485997	,	-0.293817624	),
  (	45	,	5.312993587	,	-0.218309287	),
  (	46	,	3.681858978	,	-1.053713866	),
  (	46	,	0.784155102	,	0.155461226	),
  (	46	,	1.067696463	,	0.385395288	),
  (	46	,	0.836160993	,	0.344294719	),
  (	46	,	0.495378921	,	0.336729509	),
  (	46	,	0.495375865	,	0.336769619	),
  (	46	,	1.570511906	,	0.801746328	),
  (	46	,	0.91880642	,	0.837676849	),
  (	46	,	1.1268086	,	0.877815408	),
  (	46	,	0.074567701	,	0.67512011	),
  (	46	,	0.913542413	,	0.864090611	),
  (	46	,	1.005135504	,	1.244977821	),
  (	46	,	0.650416118	,	1.17639437	),
  (	46	,	2.494598834	,	0.400862496	),
  (	46	,	2.853529084	,	0.753804088	),
  (	46	,	2.021589065	,	0.504084547	),
  (	46	,	1.949156527	,	0.858897266	),
  (	46	,	1.820712375	,	1.019658881	),
  (	46	,	2.583548766	,	0.943602011	),
  (	46	,	2.518008842	,	1.419411106	),
  (	46	,	3.939640446	,	0.036501798	),
  (	46	,	3.609553162	,	0.304687927	),
  (	46	,	3.816539064	,	0.519166353	),
  (	46	,	4.52768747	,	0.650866657	),
  (	46	,	3.724036257	,	0.903904286	),
  (	46	,	5.56097233	,	0.17463095	),
  (	46	,	5.692006718	,	0.30281365	),
  (	46	,	5.153299383	,	0.305010467	),
  (	46	,	5.149144372	,	0.314399245	),
  (	46	,	5.207461547	,	0.420272961	),
  (	46	,	5.681459324	,	0.893427112	),
  (	46	,	5.888437051	,	0.832641933	),
  (	46	,	6.076162633	,	0.862312586	),
  (	46	,	5.866559068	,	0.863525539	),
  (	46	,	5.112820204	,	0.601317303	),
  (	46	,	4.950209649	,	0.644002644	),
  (	46	,	5.045607772	,	0.665559853	),
  (	46	,	5.133196431	,	0.87655553	),
  (	46	,	5.497028908	,	0.829397261	),
  (	46	,	5.43385933	,	1.00492712	),
  (	46	,	6.055847999	,	1.315756179	),
  (	46	,	5.064374664	,	1.146939926	),
  (	46	,	6.234878532	,	-0.490978729	),
  (	46	,	6.135028294	,	-0.360278935	),
  (	46	,	0.580318692	,	0.154403944	),
  (	46	,	6.204833633	,	0.031048847	),
  (	46	,	5.774049863	,	-0.037619636	),
  (	46	,	5.853476576	,	0.213021095	),
  (	46	,	0.249605512	,	0.408709611	),
  (	46	,	6.132151153	,	0.408483003	),
  (	46	,	6.111438529	,	0.414347058	),
  (	46	,	0.168199583	,	0.511555914	),
  (	46	,	1.643019268	,	-0.613307035	),
  (	46	,	1.223661611	,	-0.343343648	),
  (	46	,	1.461908447	,	-0.104754983	),
  (	46	,	2.131891973	,	-0.052077284	),
  (	46	,	2.104277294	,	0.040758771	),
  (	46	,	1.955473402	,	0.15578114	),
  (	46	,	1.113560243	,	-0.13398251	),
  (	46	,	1.403953557	,	-0.006675117	),
  (	46	,	1.41697676	,	0.032226597	),
  (	46	,	1.162165453	,	0.272588236	),
  (	46	,	1.328935822	,	0.268848538	),
  (	46	,	1.449550726	,	0.324530104	),
  (	46	,	1.637886037	,	0.514806911	),
  (	46	,	3.055249819	,	-0.606408851	),
  (	46	,	3.039840521	,	-0.17108058	),
  (	46	,	2.49574128	,	-0.020676682	),
  (	46	,	2.65247368	,	0.174481553	),
  (	46	,	3.259119884	,	0.493367227	),
  (	46	,	4.615719197	,	-0.141701878	),
  (	46	,	4.566779495	,	-0.088783127	),
  (	46	,	4.566281882	,	0.072263723	),
  (	46	,	4.129611754	,	0.128326804	),
  (	46	,	4.299692871	,	0.2449195	),
  (	46	,	4.799050014	,	0.629450064	),
  (	46	,	0.137711566	,	-1.098960711	),
  (	46	,	0.543193666	,	-0.511324275	),
  (	46	,	0.720439839	,	-0.324147581	),
  (	46	,	2.18439203	,	-1.352354361	),
  (	46	,	2.378648346	,	-1.267156924	),
  (	46	,	2.42687925	,	-1.00428981	),
  (	46	,	2.340138785	,	-0.920196451	),
  (	46	,	3.031454951	,	-0.947085131	),
  (	46	,	2.814600694	,	-1.041690318	),
  (	46	,	1.788330313	,	-0.93588604	),
  (	46	,	1.615731107	,	-0.959382823	),
  (	46	,	1.887376854	,	-0.8160908	),
  (	46	,	1.98696845	,	-0.495139237	),
  (	46	,	2.001990135	,	-0.467777559	),
  (	46	,	1.999714011	,	-0.442700159	),
  (	46	,	1.981174735	,	-0.389134118	),
  (	46	,	2.356581158	,	-0.720005037	),
  (	46	,	2.536323668	,	-0.411749219	),
  (	46	,	2.093817609	,	-0.321132214	),
  (	46	,	3.782548722	,	-1.460281747	),
  (	46	,	4.093005108	,	-0.742933378	),
  (	46	,	4.037536873	,	-0.676031074	),
  (	46	,	4.113230362	,	-0.605814787	),
  (	46	,	3.160438711	,	-1.102449367	),
  (	46	,	3.430781302	,	-0.845845891	),
  (	46	,	3.373336361	,	-0.854224954	),
  (	46	,	3.31557571	,	-0.697913318	),
  (	46	,	3.635558488	,	-0.557243382	),
  (	46	,	4.004790162	,	-0.526194843	),
  (	46	,	4.160914995	,	-0.442044878	),
  (	46	,	4.1494271	,	-0.449447891	),
  (	46	,	3.748572028	,	-0.233366222	),
  (	46	,	3.914688714	,	-0.075878669	),
  (	46	,	4.960879777	,	-1.173443907	),
  (	46	,	5.428174493	,	-0.906198507	),
  (	46	,	4.813736696	,	-1.073270147	),
  (	47	,	0.874144425	,	0.506989286	),
  (	47	,	0.779996689	,	0.692240136	),
  (	47	,	1.523554395	,	0.683835679	),
  (	47	,	0.312687264	,	0.525160016	),
  (	47	,	0.183545694	,	0.881609289	),
  (	47	,	0.138642384	,	0.951591004	),
  (	47	,	0.915915074	,	1.027627952	),
  (	47	,	1.001475657	,	1.143642196	),
  (	47	,	0.872614911	,	1.145846768	),
  (	47	,	2.283251198	,	0.374691244	),
  (	47	,	2.463764828	,	0.456962017	),
  (	47	,	1.881196665	,	0.52787181	),
  (	47	,	2.403858997	,	1.108514207	),
  (	47	,	2.506623685	,	1.218778721	),
  (	47	,	4.526188476	,	0.577705087	),
  (	47	,	4.156903936	,	0.740995055	),
  (	47	,	4.201009761	,	0.803484605	),
  (	47	,	3.553703787	,	0.855493468	),
  (	47	,	4.633597704	,	1.25920237	),
  (	47	,	5.390057758	,	0.256114762	),
  (	47	,	5.302594549	,	0.446663339	),
  (	47	,	5.340105206	,	0.561823859	),
  (	47	,	5.930896074	,	0.681555108	),
  (	47	,	6.258679281	,	1.003553154	),
  (	47	,	5.862385363	,	0.911546206	),
  (	47	,	5.922649512	,	0.899619511	),
  (	47	,	5.099422903	,	0.430470864	),
  (	47	,	5.240798863	,	0.484391713	),
  (	47	,	5.46831882	,	0.774704156	),
  (	47	,	5.041982205	,	1.280306741	),
  (	47	,	0.06387689	,	-0.330449705	),
  (	47	,	6.050544553	,	-0.414397493	),
  (	47	,	6.166584382	,	-0.365026147	),
  (	47	,	0.00855925	,	-0.104970238	),
  (	47	,	0.478136728	,	-0.186524346	),
  (	47	,	0.21242709	,	0.132378565	),
  (	47	,	0.442575872	,	0.095777316	),
  (	47	,	5.662524632	,	-0.13708464	),
  (	47	,	1.804444758	,	-0.352979244	),
  (	47	,	1.736123281	,	-0.318305149	),
  (	47	,	1.398222952	,	-0.370704844	),
  (	47	,	1.597652184	,	-0.260667787	),
  (	47	,	2.263503341	,	0.058317103	),
  (	47	,	1.779626354	,	0.04209849	),
  (	47	,	1.315276342	,	-0.125208457	),
  (	47	,	1.415806335	,	-0.041836262	),
  (	47	,	1.302662943	,	0.029914394	),
  (	47	,	0.918994595	,	-0.088577246	),
  (	47	,	1.286729239	,	0.177149924	),
  (	47	,	1.194902989	,	0.259081188	),
  (	47	,	1.218577552	,	0.277818632	),
  (	47	,	1.762730648	,	0.230865815	),
  (	47	,	1.587899541	,	0.351481995	),
  (	47	,	1.489181726	,	0.288573086	),
  (	47	,	1.322513592	,	0.376810944	),
  (	47	,	1.562044475	,	0.452980966	),
  (	47	,	2.901642461	,	0.128031776	),
  (	47	,	2.48339449	,	-0.0483309	),
  (	47	,	3.145402636	,	0.115438306	),
  (	47	,	3.089157836	,	0.352886632	),
  (	47	,	4.711483941	,	-0.415675816	),
  (	47	,	4.839788124	,	-0.254222354	),
  (	47	,	4.714517435	,	-0.064412953	),
  (	47	,	4.957699724	,	0.073370563	),
  (	47	,	5.122956701	,	0.128767777	),
  (	47	,	4.310091244	,	-0.146113658	),
  (	47	,	5.044949726	,	0.373332711	),
  (	47	,	4.584714123	,	0.455718697	),
  (	47	,	1.119110363	,	-1.035038187	),
  (	47	,	0.997458921	,	-0.656596189	),
  (	47	,	1.193393016	,	-0.519556264	),
  (	47	,	0.495856632	,	-0.808144545	),
  (	47	,	0.697276893	,	-0.748603506	),
  (	47	,	0.737808032	,	-0.565570293	),
  (	47	,	0.986738683	,	-0.211205359	),
  (	47	,	2.750368242	,	-1.256514945	),
  (	47	,	2.802275221	,	-1.125149989	),
  (	47	,	2.82242628	,	-1.123702405	),
  (	47	,	2.810477913	,	-1.11633006	),
  (	47	,	2.095846576	,	-1.109458971	),
  (	47	,	2.279495883	,	-0.927011052	),
  (	47	,	2.934770557	,	-1.052740931	),
  (	47	,	2.773273448	,	-1.004570177	),
  (	47	,	3.102942249	,	-0.78842675	),
  (	47	,	1.896455131	,	-0.842504083	),
  (	47	,	2.192693532	,	-0.846317418	),
  (	47	,	2.15570073	,	-0.704211631	),
  (	47	,	2.143953276	,	-0.69147365	),
  (	47	,	2.153263739	,	-0.626563536	),
  (	47	,	1.871214415	,	-0.692120808	),
  (	47	,	2.004750241	,	-0.66859919	),
  (	47	,	2.424924745	,	-0.652983482	),
  (	47	,	4.204196495	,	-1.00837102	),
  (	47	,	3.469918185	,	-1.184985277	),
  (	47	,	3.508155062	,	-1.126362509	),
  (	47	,	4.106685594	,	-0.779517381	),
  (	47	,	3.982953118	,	-0.776681397	),
  (	47	,	4.320596565	,	-0.438346573	),
  (	47	,	3.257274322	,	-1.101692505	),
  (	47	,	3.25734272	,	-0.897984205	),
  (	47	,	3.884583542	,	-0.488007933	),
  (	47	,	4.293955921	,	-0.349722829	),
  (	47	,	4.18088855	,	-0.249223747	),
  (	47	,	6.174441621	,	-0.743773465	),
  (	47	,	6.103524738	,	-0.56780059	),
  (	47	,	5.786263355	,	-0.690176882	),
  (	47	,	4.987787626	,	-0.734703729	),
  (	47	,	4.761382996	,	-0.802060409	),
  (	47	,	4.905783399	,	-0.622073443	),
  (	47	,	5.247589993	,	-0.483626286	),
  (	47	,	5.5760646	,	-0.56151981	),
  (	47	,	5.623133985	,	-0.380607754	),
  (	47	,	5.326151461	,	-0.2226898	),
  (	47	,	5.539661045	,	-0.198475317	),
  (	47	,	5.444281107	,	-0.087754812	),
  (	48	,	0.732662258	,	0.51044338	),
  (	48	,	0.748372214	,	0.611900288	),
  (	48	,	1.38830998	,	0.582425132	),
  (	48	,	1.392598913	,	0.699779937	),
  (	48	,	1.141243068	,	0.811554276	),
  (	48	,	0.346741725	,	0.475846208	),
  (	48	,	0.560656973	,	0.660760461	),
  (	48	,	0.54067359	,	0.738807993	),
  (	48	,	0.213082845	,	0.889561307	),
  (	48	,	0.837493105	,	1.298403758	),
  (	48	,	2.384680465	,	0.671115953	),
  (	48	,	2.731052461	,	0.58984635	),
  (	48	,	2.762971945	,	0.705559101	),
  (	48	,	2.963262594	,	0.666455154	),
  (	48	,	2.505521684	,	0.635254473	),
  (	48	,	2.131286509	,	0.898960376	),
  (	48	,	2.269843371	,	1.122737505	),
  (	48	,	1.653029411	,	1.209844633	),
  (	48	,	1.832928544	,	1.343507601	),
  (	48	,	4.198804004	,	0.398015612	),
  (	48	,	4.143375326	,	0.454971421	),
  (	48	,	3.842893807	,	0.286555744	),
  (	48	,	3.86258502	,	0.296076116	),
  (	48	,	3.946365157	,	0.470324578	),
  (	48	,	3.86147535	,	0.472549389	),
  (	48	,	3.735697732	,	0.896538098	),
  (	48	,	3.47991495	,	0.708127803	),
  (	48	,	5.542916779	,	0.176811012	),
  (	48	,	5.628464221	,	0.412576033	),
  (	48	,	5.690432646	,	0.501624476	),
  (	48	,	5.404082156	,	0.370030994	),
  (	48	,	5.197019685	,	0.394617868	),
  (	48	,	5.304787758	,	0.485450819	),
  (	48	,	5.463429376	,	0.472924044	),
  (	48	,	5.941784031	,	0.511510995	),
  (	48	,	5.852625096	,	0.494461664	),
  (	48	,	5.820150321	,	0.693158542	),
  (	48	,	5.936379415	,	0.772768673	),
  (	48	,	6.152430912	,	1.021871967	),
  (	48	,	6.050244724	,	1.037070144	),
  (	48	,	5.27712115	,	0.64297427	),
  (	48	,	5.313596301	,	0.663799034	),
  (	48	,	5.526592964	,	0.831621297	),
  (	48	,	5.663245593	,	1.08353377	),
  (	48	,	5.248288027	,	1.184622956	),
  (	48	,	5.680747841	,	1.244631002	),
  (	48	,	0.495483816	,	0.055635985	),
  (	48	,	5.893308893	,	-0.186369435	),
  (	48	,	6.05194906	,	0.164225141	),
  (	48	,	6.148606062	,	0.222717046	),
  (	48	,	1.540752914	,	-0.589941307	),
  (	48	,	1.813507715	,	-0.351443326	),
  (	48	,	1.478661654	,	-0.125893603	),
  (	48	,	1.571041224	,	-0.053664865	),
  (	48	,	1.845305387	,	-0.073988283	),
  (	48	,	1.962606934	,	0.209551739	),
  (	48	,	1.48721782	,	-0.01970116	),
  (	48	,	1.366992008	,	0.049938493	),
  (	48	,	1.180556316	,	0.282635776	),
  (	48	,	1.15235034	,	0.304453543	),
  (	48	,	1.623395423	,	0.281526582	),
  (	48	,	1.52519183	,	0.220804983	),
  (	48	,	1.809231138	,	0.229990062	),
  (	48	,	1.429576758	,	0.382871388	),
  (	48	,	1.451799253	,	0.561856401	),
  (	48	,	3.293652035	,	0.394956912	),
  (	48	,	4.747660992	,	-0.496673794	),
  (	48	,	4.665155134	,	-0.553326481	),
  (	48	,	4.658110304	,	-0.485740158	),
  (	48	,	4.58766742	,	-0.418230124	),
  (	48	,	4.896844046	,	-0.1579967	),
  (	48	,	5.089895576	,	0.005908897	),
  (	48	,	4.406243282	,	-0.188210196	),
  (	48	,	4.713538252	,	0.076245621	),
  (	48	,	4.951273421	,	0.395231283	),
  (	48	,	0.913685589	,	-1.098421824	),
  (	48	,	1.051111108	,	-1.084879896	),
  (	48	,	1.041727499	,	-1.071637113	),
  (	48	,	0.722342594	,	-1.180127287	),
  (	48	,	1.333035707	,	-1.003073632	),
  (	48	,	1.526429084	,	-0.980302082	),
  (	48	,	1.328243556	,	-0.619299949	),
  (	48	,	0.947252047	,	-0.702926631	),
  (	48	,	0.972283922	,	-0.651252246	),
  (	48	,	0.137105556	,	-0.851779629	),
  (	48	,	0.180315492	,	-0.804334962	),
  (	48	,	0.636825997	,	-0.214510429	),
  (	48	,	3.139944187	,	-1.36522959	),
  (	48	,	2.908321474	,	-1.0895052	),
  (	48	,	2.807961126	,	-1.057086601	),
  (	48	,	2.342987365	,	-1.033745837	),
  (	48	,	2.274244723	,	-0.825838432	),
  (	48	,	3.106037797	,	-1.138058616	),
  (	48	,	2.737581476	,	-1.005986479	),
  (	48	,	2.703566863	,	-0.9604423	),
  (	48	,	2.656987273	,	-0.904277026	),
  (	48	,	2.865482008	,	-0.648191401	),
  (	48	,	2.581677026	,	-0.812408018	),
  (	48	,	2.483797581	,	-0.627468516	),
  (	48	,	2.144273748	,	-0.750268995	),
  (	48	,	2.084220589	,	-0.529437352	),
  (	48	,	2.284952474	,	-0.126252545	),
  (	48	,	4.424389795	,	-0.739357306	),
  (	48	,	4.217108758	,	-0.788417406	),
  (	48	,	4.203636434	,	-0.673744831	),
  (	48	,	4.268627243	,	-0.49942114	),
  (	48	,	4.27883243	,	-0.421836669	),
  (	48	,	3.41889509	,	-0.864415212	),
  (	48	,	4.076159944	,	-0.175687667	),
  (	48	,	4.910703936	,	-1.132235219	),
  (	48	,	5.391255686	,	-1.057373516	),
  (	48	,	6.18654959	,	-0.793992833	),
  (	48	,	5.58838396	,	-0.712259162	),
  (	48	,	4.967483818	,	-0.923954419	),
  (	48	,	4.850955397	,	-0.80136785	),
  (	48	,	5.010627466	,	-0.706804018	),
  (	48	,	5.002208614	,	-0.646904872	),
  (	48	,	5.002206409	,	-0.646898321	),
  (	48	,	4.858579067	,	-0.738495121	),
  (	48	,	5.22266846	,	-0.474206168	),
  (	48	,	5.52888449	,	-0.436439818	),
  (	48	,	5.465738527	,	-0.156791966	),
  (	49	,	1.891688257	,	-0.779070541	),
  (	49	,	2.896024052	,	1.077743858	),
  (	49	,	0.850415416	,	0.367285947	),
  (	49	,	0.514548435	,	0.411827385	),
  (	49	,	0.78195822	,	0.372459855	),
  (	49	,	1.367587497	,	0.671672065	),
  (	49	,	0.970305039	,	0.592800957	),
  (	49	,	1.112162357	,	0.706569854	),
  (	49	,	0.834654906	,	0.691353044	),
  (	49	,	0.321793424	,	0.429063977	),
  (	49	,	0.438867072	,	0.708200385	),
  (	49	,	0.382534687	,	0.792482815	),
  (	49	,	0.24722617	,	1.032898798	),
  (	49	,	0.231544158	,	1.0668351	),
  (	49	,	0.907798732	,	0.856305483	),
  (	49	,	0.533649448	,	0.950986625	),
  (	49	,	1.035959878	,	1.100819448	),
  (	49	,	0.409842397	,	1.033792117	),
  (	49	,	0.506152565	,	1.198782335	),
  (	49	,	2.704079304	,	0.33980559	),
  (	49	,	2.786942688	,	0.558091583	),
  (	49	,	2.959090208	,	0.550239741	),
  (	49	,	1.822200581	,	0.787040001	),
  (	49	,	2.426841464	,	0.942866599	),
  (	49	,	2.723281647	,	1.144347407	),
  (	49	,	2.401544175	,	1.171698988	),
  (	49	,	3.889438116	,	0.333360823	),
  (	49	,	3.710562054	,	0.437925126	),
  (	49	,	4.195080099	,	0.520998448	),
  (	49	,	4.098806892	,	0.639414622	),
  (	49	,	4.403630958	,	0.802554257	),
  (	49	,	4.591413211	,	0.962956301	),
  (	49	,	4.386436428	,	0.991037088	),
  (	49	,	3.5811405	,	0.954373283	),
  (	49	,	3.916423202	,	1.150742378	),
  (	49	,	4.611821806	,	1.200091874	),
  (	49	,	4.310883457	,	1.200234576	),
  (	49	,	3.627809064	,	1.129634259	),
  (	49	,	5.125080698	,	0.345111569	),
  (	49	,	6.0396692	,	0.873594103	),
  (	49	,	6.278863043	,	0.973106549	),
  (	49	,	5.146002132	,	0.526279089	),
  (	49	,	5.079460943	,	0.516991196	),
  (	49	,	5.383917552	,	0.61524279	),
  (	49	,	5.217935869	,	0.67171964	),
  (	49	,	5.294026279	,	0.817087506	),
  (	49	,	5.367146811	,	0.854366848	),
  (	49	,	4.854525889	,	0.99563251	),
  (	49	,	4.935816812	,	1.036525438	),
  (	49	,	5.449520516	,	0.804843171	),
  (	49	,	5.582307785	,	1.132228214	),
  (	49	,	5.115593067	,	1.215606209	),
  (	49	,	0.010177064	,	-0.518717727	),
  (	49	,	6.064652169	,	-0.391960594	),
  (	49	,	5.949767495	,	-0.328655464	),
  (	49	,	0.023279863	,	-0.099605935	),
  (	49	,	6.138912094	,	0.021902812	),
  (	49	,	6.000572976	,	0.153872897	),
  (	49	,	0.311780494	,	0.367122648	),
  (	49	,	6.273401411	,	0.438796404	),
  (	49	,	1.603640052	,	-0.650186082	),
  (	49	,	1.929572562	,	-0.331903086	),
  (	49	,	1.315225297	,	-0.349973874	),
  (	49	,	1.639511909	,	-0.239432808	),
  (	49	,	1.578825661	,	-0.184968301	),
  (	49	,	1.69656288	,	-0.12277362	),
  (	49	,	1.622560532	,	-0.114324118	),
  (	49	,	2.099736214	,	-0.024314704	),
  (	49	,	1.692792066	,	-0.083115477	),
  (	49	,	1.308691863	,	-0.218829791	),
  (	49	,	1.408626222	,	0.061862054	),
  (	49	,	1.163287856	,	0.256800262	),
  (	49	,	1.351318584	,	0.272221842	),
  (	49	,	3.483563388	,	-0.319719565	),
  (	49	,	3.075111892	,	-0.32028271	),
  (	49	,	3.718695514	,	0.042049226	),
  (	49	,	3.312826688	,	-0.139551893	),
  (	49	,	3.552327214	,	0.063858241	),
  (	49	,	2.523965205	,	0.081139293	),
  (	49	,	2.618921218	,	0.140395466	),
  (	49	,	3.324357401	,	0.178634422	),
  (	49	,	3.077389205	,	0.144128267	),
  (	49	,	2.946129012	,	0.403091947	),
  (	49	,	3.23978853	,	0.451099567	),
  (	49	,	4.791161634	,	-0.471983676	),
  (	49	,	4.815629653	,	-0.155929598	),
  (	49	,	5.135155033	,	-0.122653042	),
  (	49	,	5.210902493	,	0.147670402	),
  (	49	,	4.285080351	,	0.017966332	),
  (	49	,	4.744268518	,	0.152438318	),
  (	49	,	4.712636516	,	0.292357347	),
  (	49	,	4.474062513	,	0.222367963	),
  (	49	,	4.718964884	,	0.376922144	),
  (	49	,	0.501525028	,	-1.180659274	),
  (	49	,	1.545096357	,	-1.101057711	),
  (	49	,	1.181740889	,	-0.784591327	),
  (	49	,	0.969742166	,	-0.557427902	),
  (	49	,	0.671273651	,	-0.492747707	),
  (	49	,	0.663598704	,	-0.266081256	),
  (	49	,	0.854485637	,	-0.153927687	),
  (	49	,	0.696239407	,	-0.207226686	),
  (	49	,	2.718208645	,	-1.167649976	),
  (	49	,	2.133674549	,	-1.069964767	),
  (	49	,	2.505185286	,	-0.894572323	),
  (	49	,	2.314993826	,	-0.812087119	),
  (	49	,	2.311660212	,	-0.790769851	),
  (	49	,	1.890285471	,	-0.788598127	),
  (	49	,	2.043483039	,	-0.821670823	),
  (	49	,	2.15535763	,	-0.633942452	),
  (	49	,	1.906000458	,	-0.638661148	),
  (	49	,	1.96659182	,	-0.540393611	),
  (	49	,	2.022571936	,	-0.495859907	),
  (	49	,	1.904951825	,	-0.486613692	),
  (	49	,	1.914071588	,	-0.428629721	),
  (	49	,	1.96287052	,	-0.401849166	),
  (	49	,	2.45742423	,	-0.503243015	),
  (	49	,	2.336684831	,	-0.483151754	),
  (	49	,	2.391315215	,	-0.451316602	),
  (	49	,	2.54905567	,	-0.484666067	),
  (	49	,	2.143573908	,	-0.22561762	),
  (	49	,	3.654918041	,	-1.111546628	),
  (	49	,	4.337508355	,	-0.768736064	),
  (	49	,	4.62687448	,	-0.862485954	),
  (	49	,	4.669564247	,	-0.69971029	),
  (	49	,	4.471632025	,	-0.595557697	),
  (	49	,	4.202825876	,	-0.859219072	),
  (	49	,	4.100505026	,	-0.600602683	),
  (	49	,	3.34073744	,	-1.064332793	),
  (	49	,	3.324596854	,	-1.0417146	),
  (	49	,	3.606970436	,	-0.897674487	),
  (	49	,	3.755560968	,	-0.788671881	),
  (	49	,	3.32740749	,	-0.85195318	),
  (	49	,	3.362747953	,	-0.593402235	),
  (	49	,	3.895795217	,	-0.659792106	),
  (	49	,	3.861484293	,	-0.614213696	),
  (	49	,	3.788119501	,	-0.514729171	),
  (	49	,	4.212536565	,	-0.34561027	),
  (	49	,	3.931226298	,	-0.14868441	),
  (	49	,	5.77512904	,	-0.991409762	),
  (	49	,	5.217850695	,	-0.459006754	),
  (	49	,	5.503419068	,	-0.563005191	),
  (	49	,	5.517003655	,	-0.346539792	),
  (	49	,	5.68393857	,	-0.329280428	),
  (	49	,	5.361912187	,	-0.310908704	),
  (	50	,	0.996023573	,	0.194484457	),
  (	50	,	1.122507727	,	0.35915707	),
  (	50	,	1.276848542	,	0.640591028	),
  (	50	,	1.30576118	,	0.661297691	),
  (	50	,	0.878949191	,	0.756244955	),
  (	50	,	1.548306747	,	0.972271556	),
  (	50	,	0.598179042	,	0.597295647	),
  (	50	,	0.189659811	,	0.820728682	),
  (	50	,	0.15768872	,	0.945417571	),
  (	50	,	0.868861147	,	0.874319191	),
  (	50	,	0.635407936	,	0.877525859	),
  (	50	,	0.809568949	,	0.989709956	),
  (	50	,	0.986279997	,	1.1055779	),
  (	50	,	0.374980705	,	1.189096249	),
  (	50	,	2.5091846	,	0.691527951	),
  (	50	,	2.751588058	,	0.977040764	),
  (	50	,	2.066015771	,	0.467147309	),
  (	50	,	2.003482195	,	0.603597273	),
  (	50	,	1.913460782	,	0.863323335	),
  (	50	,	2.020240139	,	1.024682726	),
  (	50	,	1.793114343	,	1.179353311	),
  (	50	,	1.805126472	,	1.202328777	),
  (	50	,	2.367291606	,	1.180361645	),
  (	50	,	3.76718911	,	0.147420181	),
  (	50	,	4.150670306	,	0.366135963	),
  (	50	,	3.958872547	,	0.434029411	),
  (	50	,	4.664694953	,	0.886321548	),
  (	50	,	4.150532116	,	0.62229649	),
  (	50	,	4.227928175	,	0.636926112	),
  (	50	,	4.065666868	,	0.713826596	),
  (	50	,	4.591015905	,	0.963153342	),
  (	50	,	3.629371	,	0.601161433	),
  (	50	,	3.434720278	,	0.482134198	),
  (	50	,	3.566830006	,	0.633468314	),
  (	50	,	3.555234803	,	0.648954398	),
  (	50	,	3.743718812	,	0.619759465	),
  (	50	,	3.246423602	,	0.899932524	),
  (	50	,	3.406599034	,	0.983778458	),
  (	50	,	4.179118505	,	0.955576621	),
  (	50	,	4.433327654	,	1.136822748	),
  (	50	,	4.265129764	,	1.322209946	),
  (	50	,	5.729318675	,	0.45247886	),
  (	50	,	5.298289788	,	0.265255236	),
  (	50	,	5.404116224	,	0.420901976	),
  (	50	,	5.266053628	,	0.412149502	),
  (	50	,	5.578304778	,	0.767000391	),
  (	50	,	6.008625056	,	0.849696628	),
  (	50	,	5.299414046	,	0.642399634	),
  (	50	,	5.216911838	,	0.915228752	),
  (	50	,	4.905856826	,	0.692381931	),
  (	50	,	4.898408273	,	0.969349428	),
  (	50	,	6.230450038	,	1.183451881	),
  (	50	,	5.802391618	,	1.262592561	),
  (	50	,	5.966801149	,	1.451313821	),
  (	50	,	5.997142898	,	1.472121386	),
  (	50	,	0.192814106	,	-0.185185312	),
  (	50	,	6.203615126	,	-0.310957061	),
  (	50	,	0.049139367	,	-0.269999814	),
  (	50	,	6.19498481	,	-0.248229359	),
  (	50	,	6.104125552	,	-0.167740172	),
  (	50	,	0.007961465	,	-0.052841152	),
  (	50	,	0.23129278	,	-0.019973007	),
  (	50	,	5.881152597	,	0.081917748	),
  (	50	,	6.052419096	,	0.444501335	),
  (	50	,	1.509702638	,	-0.56385633	),
  (	50	,	1.376220622	,	-0.470256464	),
  (	50	,	1.592548882	,	-0.287708128	),
  (	50	,	1.463378806	,	-0.09452787	),
  (	50	,	1.462910987	,	-0.094067899	),
  (	50	,	2.058177039	,	0.030837182	),
  (	50	,	1.717543849	,	-0.02129784	),
  (	50	,	1.777311615	,	0.140275142	),
  (	50	,	1.216890593	,	-0.211589555	),
  (	50	,	1.438731863	,	-0.019066242	),
  (	50	,	1.022293575	,	-0.051569814	),
  (	50	,	0.869911807	,	0.05883245	),
  (	50	,	1.276414903	,	0.248713975	),
  (	50	,	1.537811574	,	0.032377297	),
  (	50	,	1.531709214	,	0.651099493	),
  (	50	,	2.90303166	,	-0.476363981	),
  (	50	,	3.523161864	,	-0.278789076	),
  (	50	,	3.37874839	,	-0.166488623	),
  (	50	,	3.542851905	,	-0.109190117	),
  (	50	,	3.788230416	,	-0.038885608	),
  (	50	,	3.480206263	,	0.095469056	),
  (	50	,	2.750160012	,	-0.011121161	),
  (	50	,	3.012069296	,	-0.052422916	),
  (	50	,	2.887770244	,	-0.043368571	),
  (	50	,	2.883045021	,	0.106487457	),
  (	50	,	3.398692532	,	0.303856186	),
  (	50	,	3.231974109	,	0.310554922	),
  (	50	,	3.259349629	,	0.468195711	),
  (	50	,	3.256786905	,	0.475919121	),
  (	50	,	4.734295394	,	-0.516270511	),
  (	50	,	4.640075561	,	-0.378448538	),
  (	50	,	4.908007917	,	0.035952663	),
  (	50	,	4.957805883	,	0.0733444	),
  (	50	,	5.004629736	,	0.193227428	),
  (	50	,	4.2411494	,	-0.175656209	),
  (	50	,	4.523066866	,	-0.007778936	),
  (	50	,	0.743818813	,	-1.310168587	),
  (	50	,	1.526685734	,	-1.167643745	),
  (	50	,	0.006928681	,	-1.345072076	),
  (	50	,	0.780153783	,	-1.118254318	),
  (	50	,	1.385303036	,	-0.609077303	),
  (	50	,	1.094541156	,	-0.732917765	),
  (	50	,	1.019491313	,	-0.606193175	),
  (	50	,	0.462993506	,	-0.934128484	),
  (	50	,	0.511260744	,	-0.827027856	),
  (	50	,	0.746290621	,	-0.3665918	),
  (	50	,	2.504039098	,	-1.412689808	),
  (	50	,	3.090299139	,	-1.166142066	),
  (	50	,	1.608904524	,	-1.20154189	),
  (	50	,	2.44758891	,	-1.089166347	),
  (	50	,	2.470942639	,	-0.931636375	),
  (	50	,	2.284946204	,	-0.869571416	),
  (	50	,	2.404509914	,	-0.783092098	),
  (	50	,	2.787068875	,	-1.032938061	),
  (	50	,	2.754757749	,	-0.937486636	),
  (	50	,	2.574148306	,	-0.798185556	),
  (	50	,	1.849573108	,	-0.865384914	),
  (	50	,	2.153745968	,	-0.82015738	),
  (	50	,	2.082642772	,	-0.769861486	),
  (	50	,	2.039487951	,	-0.672145633	),
  (	50	,	2.18755418	,	-0.636768144	),
  (	50	,	1.825692022	,	-0.59536122	),
  (	50	,	1.764852266	,	-0.542282464	),
  (	50	,	1.913910913	,	-0.641280943	),
  (	50	,	2.44997441	,	-0.453183618	),
  (	50	,	2.475366566	,	-0.389993186	),
  (	50	,	2.532059511	,	-0.250148082	),
  (	50	,	2.442467133	,	-0.208999105	),
  (	50	,	2.445569368	,	-0.166781779	),
  (	50	,	3.744726289	,	-1.413860011	),
  (	50	,	4.277563412	,	-1.37350442	),
  (	50	,	3.762865013	,	-1.398166845	),
  (	50	,	4.313081243	,	-1.223190209	),
  (	50	,	4.546532724	,	-1.182822271	),
  (	50	,	4.392406659	,	-1.171286711	),
  (	50	,	4.000940554	,	-1.063905268	),
  (	50	,	3.730427813	,	-0.996343349	),
  (	50	,	3.70841801	,	-0.93269659	),
  (	50	,	4.286816988	,	-0.865203878	),
  (	50	,	4.458779806	,	-0.561016389	),
  (	50	,	3.465521226	,	-1.031564653	),
  (	50	,	3.531764602	,	-0.893000918	),
  (	50	,	3.455924827	,	-0.659781612	),
  (	50	,	3.990790046	,	-0.550112363	),
  (	50	,	4.159703628	,	-0.351984014	),
  (	50	,	4.110012588	,	-0.343473247	),
  (	50	,	3.765940017	,	-0.484413174	),
  (	50	,	4.032566554	,	-0.180176211	),
  (	50	,	5.40001378	,	-1.073908463	),
  (	50	,	6.272668365	,	-1.122223298	),
  (	50	,	6.227627204	,	-0.876619893	),
  (	50	,	5.827727909	,	-0.721632074	),
  (	50	,	5.706070723	,	-0.53927739	),
  (	50	,	5.073910668	,	-0.949886815	),
  (	50	,	5.251521145	,	-0.662200291	),
  (	50	,	4.852156978	,	-0.798618233	),
  (	50	,	4.968596657	,	-0.647656956	),
  (	50	,	5.04200131	,	-0.440815885	),
  (	50	,	5.227047258	,	-0.270390543	),
  (	51	,	0.918075655	,	0.1978562	),
  (	51	,	0.680127746	,	0.097617763	),
  (	51	,	0.552247515	,	0.395284964	),
  (	51	,	0.564717377	,	0.452733647	),
  (	51	,	0.867125512	,	0.597296998	),
  (	51	,	0.773565212	,	0.557353644	),
  (	51	,	1.076028382	,	0.481702852	),
  (	51	,	1.376217145	,	0.570507739	),
  (	51	,	1.396330347	,	0.592679438	),
  (	51	,	1.404150123	,	0.729622856	),
  (	51	,	1.264968017	,	0.654298658	),
  (	51	,	1.001575021	,	0.577554192	),
  (	51	,	1.338126047	,	0.900529309	),
  (	51	,	0.707940003	,	0.701494208	),
  (	51	,	0.444258629	,	0.743725089	),
  (	51	,	0.581288729	,	0.771986907	),
  (	51	,	0.296794842	,	0.766926826	),
  (	51	,	0.045033834	,	0.804112795	),
  (	51	,	0.359282968	,	0.794628152	),
  (	51	,	0.239986759	,	1.029262318	),
  (	51	,	0.866686992	,	0.876539372	),
  (	51	,	0.916301343	,	0.967815151	),
  (	51	,	2.11653385	,	0.228948435	),
  (	51	,	2.033840277	,	0.323054148	),
  (	51	,	2.807416586	,	0.404714983	),
  (	51	,	2.88344829	,	0.684376561	),
  (	51	,	1.960613922	,	0.490750104	),
  (	51	,	1.742407711	,	0.741564046	),
  (	51	,	2.771099526	,	1.321439603	),
  (	51	,	3.846904487	,	0.142450051	),
  (	51	,	3.751366284	,	0.284617116	),
  (	51	,	3.936190083	,	0.436468401	),
  (	51	,	3.854656906	,	0.462996456	),
  (	51	,	4.285193084	,	0.539180049	),
  (	51	,	4.357848841	,	0.853963861	),
  (	51	,	3.404586805	,	0.537299182	),
  (	51	,	3.42843454	,	0.624811101	),
  (	51	,	3.482980434	,	0.867117571	),
  (	51	,	4.367331363	,	1.127289533	),
  (	51	,	3.703784145	,	1.353463413	),
  (	51	,	5.18789517	,	0.334093691	),
  (	51	,	5.715279147	,	0.526636159	),
  (	51	,	6.032767817	,	0.74626431	),
  (	51	,	5.940565912	,	0.702065949	),
  (	51	,	6.098815496	,	0.855479136	),
  (	51	,	5.649545502	,	0.672558399	),
  (	51	,	5.659009935	,	0.705350447	),
  (	51	,	6.226727383	,	1.023677244	),
  (	51	,	5.073882103	,	0.458364237	),
  (	51	,	5.108389218	,	0.488085934	),
  (	51	,	5.176766235	,	0.588603301	),
  (	51	,	5.16739323	,	0.651960793	),
  (	51	,	5.088299175	,	0.633868532	),
  (	51	,	5.235638496	,	0.646520288	),
  (	51	,	5.454533331	,	0.768995914	),
  (	51	,	4.818107868	,	0.689530766	),
  (	51	,	4.980474195	,	0.819156347	),
  (	51	,	4.944629712	,	0.885022742	),
  (	51	,	4.816707805	,	1.026274098	),
  (	51	,	4.773126	,	1.123948964	),
  (	51	,	5.809805	,	1.036977116	),
  (	51	,	5.78204194	,	1.086987456	),
  (	51	,	6.102669917	,	1.18877015	),
  (	51	,	5.206709632	,	1.003975207	),
  (	51	,	4.825803622	,	1.144295358	),
  (	51	,	4.949761992	,	1.244376002	),
  (	51	,	0.121857284	,	-0.576089713	),
  (	51	,	6.24547067	,	-0.330027651	),
  (	51	,	6.277387858	,	-0.062072003	),
  (	51	,	0.393542889	,	0.107224368	),
  (	51	,	5.78437906	,	0.088300299	),
  (	51	,	0.063728325	,	0.352673636	),
  (	51	,	1.742182408	,	-0.246890927	),
  (	51	,	1.411546431	,	-0.24307829	),
  (	51	,	1.656811312	,	-0.136535637	),
  (	51	,	1.566747855	,	-0.166828572	),
  (	51	,	1.940237346	,	-0.282771558	),
  (	51	,	2.033079577	,	-0.254185626	),
  (	51	,	1.877223837	,	-0.073925111	),
  (	51	,	1.110005716	,	-0.179025584	),
  (	51	,	1.338497974	,	-0.081248053	),
  (	51	,	1.494332086	,	0.025735396	),
  (	51	,	1.151321533	,	0.165125182	),
  (	51	,	1.108020011	,	0.161680588	),
  (	51	,	1.110917841	,	0.174730444	),
  (	51	,	1.173031548	,	0.227721808	),
  (	51	,	1.218042354	,	0.27575145	),
  (	51	,	1.64255556	,	0.214212257	),
  (	51	,	1.585877305	,	0.343662768	),
  (	51	,	1.415600249	,	0.303399056	),
  (	51	,	1.271371167	,	0.328813206	),
  (	51	,	1.341572495	,	0.325419747	),
  (	51	,	1.588773517	,	0.406014904	),
  (	51	,	1.522868621	,	0.428781417	),
  (	51	,	1.482382585	,	0.451986831	),
  (	51	,	3.456021851	,	-0.282753871	),
  (	51	,	3.231291375	,	-0.387743962	),
  (	51	,	3.145310856	,	-0.343113121	),
  (	51	,	3.12420241	,	-0.299339359	),
  (	51	,	2.987170905	,	-0.18952801	),
  (	51	,	3.770726683	,	0.101581016	),
  (	51	,	3.527412497	,	0.240415415	),
  (	51	,	2.786329528	,	-0.294548596	),
  (	51	,	2.585297204	,	-0.141462743	),
  (	51	,	2.74661162	,	-0.047807469	),
  (	51	,	2.882241839	,	0.063135335	),
  (	51	,	3.211409283	,	0.260034026	),
  (	51	,	3.374132315	,	0.370791507	),
  (	51	,	3.36716901	,	0.480675127	),
  (	51	,	4.948749116	,	-0.39697332	),
  (	51	,	5.051132719	,	-0.330791939	),
  (	51	,	4.962587376	,	-0.360522017	),
  (	51	,	4.849563806	,	-0.321190334	),
  (	51	,	4.951143474	,	-0.272325175	),
  (	51	,	4.725838183	,	-0.142778652	),
  (	51	,	5.159720385	,	-0.281418044	),
  (	51	,	4.902287172	,	-0.144429151	),
  (	51	,	4.961372804	,	-0.102042445	),
  (	51	,	5.034018113	,	0.04003247	),
  (	51	,	4.803440771	,	0.058944081	),
  (	51	,	5.145205181	,	0.094208351	),
  (	51	,	4.455209938	,	-0.073708547	),
  (	51	,	4.15064319	,	-0.053942673	),
  (	51	,	4.331033671	,	0.200494541	),
  (	51	,	4.751141102	,	0.34985279	),
  (	51	,	4.913429968	,	0.465344824	),
  (	51	,	4.541795442	,	0.427595622	),
  (	51	,	1.36903155	,	-1.172599345	),
  (	51	,	0.330739986	,	-1.20209795	),
  (	51	,	1.230716834	,	-0.64826508	),
  (	51	,	0.142842358	,	-1.100113291	),
  (	51	,	0.32817308	,	-0.79465588	),
  (	51	,	0.49901554	,	-0.741714972	),
  (	51	,	0.64589842	,	-0.590113306	),
  (	51	,	0.390970983	,	-0.377502629	),
  (	51	,	0.865546627	,	-0.392891801	),
  (	51	,	0.943748036	,	-0.304858873	),
  (	51	,	2.248237578	,	-1.016211999	),
  (	51	,	2.24855694	,	-1.012448906	),
  (	51	,	2.268748385	,	-0.925976834	),
  (	51	,	2.205753367	,	-0.902811563	),
  (	51	,	3.046110948	,	-1.079074817	),
  (	51	,	2.82288183	,	-0.990599899	),
  (	51	,	3.082521764	,	-0.706815707	),
  (	51	,	3.004510983	,	-0.744804322	),
  (	51	,	2.715406741	,	-0.726921653	),
  (	51	,	2.419057672	,	-0.754460405	),
  (	51	,	2.780419388	,	-0.478438224	),
  (	51	,	1.851383374	,	-0.990469155	),
  (	51	,	2.13680211	,	-0.83666065	),
  (	51	,	2.136274739	,	-0.770087184	),
  (	51	,	2.222928938	,	-0.780594323	),
  (	51	,	2.039962307	,	-0.813470535	),
  (	51	,	2.187697693	,	-0.576907101	),
  (	51	,	1.905087066	,	-0.406933409	),
  (	51	,	2.267650055	,	-0.515949338	),
  (	51	,	2.592685401	,	-0.452597915	),
  (	51	,	2.54044947	,	-0.417373597	),
  (	51	,	2.276443276	,	-0.278276301	),
  (	51	,	3.478510148	,	-1.165591717	),
  (	51	,	4.003996569	,	-1.110210965	),
  (	51	,	3.763875002	,	-1.020302679	),
  (	51	,	4.023559785	,	-0.83651392	),
  (	51	,	4.556259937	,	-0.770785721	),
  (	51	,	4.698383258	,	-0.773920737	),
  (	51	,	4.702774529	,	-0.728088527	),
  (	51	,	4.255347789	,	-0.826803269	),
  (	51	,	4.175228537	,	-0.592825135	),
  (	51	,	4.300426598	,	-0.409233236	),
  (	51	,	3.379888049	,	-0.997782699	),
  (	51	,	3.390612701	,	-0.893588705	),
  (	51	,	3.608200887	,	-0.632716917	),
  (	51	,	3.658723211	,	-0.435851825	),
  (	51	,	4.077268249	,	-0.160284355	),
  (	51	,	5.419037522	,	-1.165196504	),
  (	51	,	5.451903715	,	-0.806807158	),
  (	51	,	5.958697184	,	-0.933751141	),
  (	51	,	5.949390911	,	-0.722828034	),
  (	51	,	5.803919937	,	-0.56807526	),
  (	51	,	5.127847585	,	-0.839493873	),
  (	51	,	4.818434869	,	-0.769871856	),
  (	51	,	4.903425691	,	-0.668876784	),
  (	51	,	5.23142452	,	-0.45719902	),
  (	51	,	5.084476557	,	-0.427761853	),
  (	51	,	5.454016558	,	-0.589569906	),
  (	51	,	5.355195992	,	-0.317856129	),
  (	51	,	5.407344247	,	-0.261011592	),
  (	51	,	5.176465457	,	-0.344907488	),
  (	52	,	0.719787601	,	0.217208958	),
  (	52	,	0.878022093	,	0.36908353	),
  (	52	,	1.00001928	,	0.421259288	),
  (	52	,	0.781295361	,	0.614062277	),
  (	52	,	1.136003082	,	0.477351332	),
  (	52	,	1.136252154	,	0.603302324	),
  (	52	,	1.391904126	,	0.589017086	),
  (	52	,	1.548821826	,	1.04524708	),
  (	52	,	1.120140823	,	0.935702405	),
  (	52	,	1.411381539	,	1.00433263	),
  (	52	,	1.335790105	,	1.029261216	),
  (	52	,	0.310286382	,	0.548463887	),
  (	52	,	0.593139762	,	0.582218637	),
  (	52	,	0.43349305	,	0.774685942	),
  (	52	,	0.123179853	,	0.774827831	),
  (	52	,	0.349423045	,	1.016333231	),
  (	52	,	0.789200688	,	0.913707085	),
  (	52	,	1.066625389	,	1.032458529	),
  (	52	,	0.449149322	,	1.23259389	),
  (	52	,	1.407377435	,	1.382864097	),
  (	52	,	2.382253273	,	0.088876693	),
  (	52	,	2.495571289	,	0.197209091	),
  (	52	,	2.389994136	,	0.186193746	),
  (	52	,	2.147695084	,	0.307991458	),
  (	52	,	2.877413727	,	0.705647768	),
  (	52	,	2.979385848	,	0.758914965	),
  (	52	,	2.607870757	,	0.716552819	),
  (	52	,	2.416418823	,	0.754289576	),
  (	52	,	2.568244983	,	0.80320691	),
  (	52	,	2.771429956	,	0.996284435	),
  (	52	,	1.935016626	,	0.437210725	),
  (	52	,	2.109742278	,	0.485097333	),
  (	52	,	1.883459274	,	0.686273429	),
  (	52	,	1.792299422	,	0.729203403	),
  (	52	,	1.9681803	,	1.438346397	),
  (	52	,	4.07883894	,	0.183918903	),
  (	52	,	4.224021585	,	0.297525073	),
  (	52	,	3.620313242	,	0.371130665	),
  (	52	,	4.313771307	,	0.730972421	),
  (	52	,	3.463229884	,	0.700801879	),
  (	52	,	3.254367941	,	0.68099924	),
  (	52	,	4.130623498	,	1.092561539	),
  (	52	,	4.666378099	,	1.34328562	),
  (	52	,	3.293135322	,	1.222110057	),
  (	52	,	3.194827246	,	1.354661393	),
  (	52	,	4.064041171	,	1.350001981	),
  (	52	,	5.597685704	,	0.118878118	),
  (	52	,	5.29813263	,	0.500816721	),
  (	52	,	5.431787672	,	0.441033208	),
  (	52	,	5.441851697	,	0.599942564	),
  (	52	,	5.986645468	,	0.755947157	),
  (	52	,	6.222249133	,	0.810185756	),
  (	52	,	5.617150979	,	0.647810539	),
  (	52	,	6.12976382	,	1.087038747	),
  (	52	,	4.974249304	,	0.561046185	),
  (	52	,	5.152385334	,	0.794574629	),
  (	52	,	5.006050057	,	0.630066067	),
  (	52	,	4.745020607	,	0.758546171	),
  (	52	,	5.034917978	,	1.007134743	),
  (	52	,	5.502946506	,	0.805570468	),
  (	52	,	5.928232788	,	1.10975604	),
  (	52	,	5.915731994	,	1.28531899	),
  (	52	,	5.218196348	,	1.02705336	),
  (	52	,	5.373465399	,	1.308202923	),
  (	52	,	5.756283175	,	1.277210713	),
  (	52	,	5.014204197	,	1.336218389	),
  (	52	,	5.817182378	,	1.502872953	),
  (	52	,	0.132543724	,	-0.415171727	),
  (	52	,	6.214254161	,	-0.318993197	),
  (	52	,	0.019642866	,	-0.183427201	),
  (	52	,	0.373595399	,	-0.254799072	),
  (	52	,	0.339457547	,	0.063081737	),
  (	52	,	6.072595108	,	0.152194105	),
  (	52	,	0.213708532	,	0.295645685	),
  (	52	,	6.213344501	,	0.512449096	),
  (	52	,	1.551160436	,	-0.647879922	),
  (	52	,	1.814191312	,	-0.400403227	),
  (	52	,	1.775224421	,	-0.25177968	),
  (	52	,	1.318449354	,	-0.458594928	),
  (	52	,	1.396190794	,	-0.214946616	),
  (	52	,	1.589230927	,	-0.117092854	),
  (	52	,	1.533125119	,	-0.131213986	),
  (	52	,	2.008816278	,	-0.266409009	),
  (	52	,	1.980072745	,	-0.25348946	),
  (	52	,	2.09323615	,	-0.064221211	),
  (	52	,	1.658032688	,	-0.05139089	),
  (	52	,	2.034483025	,	0.187938383	),
  (	52	,	1.944507095	,	0.1618973	),
  (	52	,	1.150518909	,	-0.065377508	),
  (	52	,	1.347087983	,	-0.077773537	),
  (	52	,	1.451630642	,	-0.027782908	),
  (	52	,	1.455273324	,	-0.020177407	),
  (	52	,	1.186290561	,	-0.000769069	),
  (	52	,	1.209634583	,	0.017423325	),
  (	52	,	0.979603619	,	-0.020300448	),
  (	52	,	1.053894858	,	-0.027048568	),
  (	52	,	0.841158468	,	-0.020884212	),
  (	52	,	1.286226554	,	0.199423194	),
  (	52	,	1.171289473	,	0.285532435	),
  (	52	,	1.565672986	,	0.009651624	),
  (	52	,	1.517194062	,	0.242592324	),
  (	52	,	1.755825922	,	0.307958213	),
  (	52	,	1.393109175	,	0.385647682	),
  (	52	,	1.724389862	,	0.489079949	),
  (	52	,	3.442896752	,	-0.403491573	),
  (	52	,	2.981700092	,	-0.327775615	),
  (	52	,	3.23034932	,	0.057807564	),
  (	52	,	3.001694889	,	0.049849925	),
  (	52	,	2.518551319	,	0.11930653	),
  (	52	,	2.61023689	,	0.217200894	),
  (	52	,	3.267740652	,	0.452262748	),
  (	52	,	3.21289588	,	0.417925426	),
  (	52	,	3.247657793	,	0.455505176	),
  (	52	,	3.213589895	,	0.577019354	),
  (	52	,	4.763538093	,	-0.413668413	),
  (	52	,	4.82300288	,	-0.358523061	),
  (	52	,	4.370184202	,	-0.309659413	),
  (	52	,	5.063861536	,	-0.094517319	),
  (	52	,	5.365368819	,	-0.050364701	),
  (	52	,	5.396241802	,	-0.044506973	),
  (	52	,	4.051934246	,	0.032146205	),
  (	52	,	4.01130608	,	0.030749935	),
  (	52	,	4.39723979	,	0.091568229	),
  (	52	,	4.800960601	,	0.383289667	),
  (	52	,	4.464255117	,	0.245943303	),
  (	52	,	4.5392294	,	0.315148621	),
  (	52	,	4.722791684	,	0.363614394	),
  (	52	,	4.738705488	,	0.387791702	),
  (	52	,	4.804093511	,	0.503881484	),
  (	52	,	4.743033822	,	0.533415937	),
  (	52	,	4.764321744	,	0.54812971	),
  (	52	,	1.052897562	,	-1.066015088	),
  (	52	,	0.801147953	,	-1.042628551	),
  (	52	,	0.579921857	,	-0.536231121	),
  (	52	,	0.993364045	,	-0.416685849	),
  (	52	,	0.509077022	,	-0.393169548	),
  (	52	,	0.770662026	,	-0.06479761	),
  (	52	,	0.779728527	,	-0.048578404	),
  (	52	,	2.264947105	,	-1.228485186	),
  (	52	,	2.753403547	,	-1.27795519	),
  (	52	,	3.097710382	,	-1.225671341	),
  (	52	,	2.819905502	,	-1.125990188	),
  (	52	,	2.820853407	,	-1.121603931	),
  (	52	,	2.93542747	,	-1.119973091	),
  (	52	,	2.676934285	,	-1.158422686	),
  (	52	,	2.435157302	,	-0.891003667	),
  (	52	,	2.214851883	,	-0.926565665	),
  (	52	,	2.363796799	,	-0.910863424	),
  (	52	,	2.35126004	,	-0.824394237	),
  (	52	,	3.069682955	,	-1.090645554	),
  (	52	,	3.058222538	,	-1.083676586	),
  (	52	,	2.995811878	,	-1.066660691	),
  (	52	,	2.917170573	,	-1.081181948	),
  (	52	,	3.079332938	,	-0.797442626	),
  (	52	,	2.911536468	,	-0.744180327	),
  (	52	,	2.424302816	,	-0.673173737	),
  (	52	,	1.988205162	,	-0.91688981	),
  (	52	,	1.816305442	,	-0.850343378	),
  (	52	,	2.277428944	,	-0.792565892	),
  (	52	,	2.270313441	,	-0.702736323	),
  (	52	,	2.019993811	,	-0.788486745	),
  (	52	,	2.081143698	,	-0.759224116	),
  (	52	,	1.913571139	,	-0.684347401	),
  (	52	,	1.777427204	,	-0.661999312	),
  (	52	,	2.060598355	,	-0.60569525	),
  (	52	,	1.899575776	,	-0.535577837	),
  (	52	,	2.259627489	,	-0.458237701	),
  (	52	,	2.595604539	,	-0.331780455	),
  (	52	,	2.501087602	,	-0.368537034	),
  (	52	,	2.265107548	,	-0.395468963	),
  (	52	,	2.152568744	,	-0.275556958	),
  (	52	,	2.269024946	,	-0.217736118	),
  (	52	,	2.309775438	,	-0.06009489	),
  (	52	,	3.238110049	,	-1.178483831	),
  (	52	,	4.247601754	,	-0.953484265	),
  (	52	,	4.263034322	,	-0.873854026	),
  (	52	,	4.552114009	,	-0.828478456	),
  (	52	,	4.413771892	,	-0.719608648	),
  (	52	,	4.186621847	,	-0.728579992	),
  (	52	,	4.203370794	,	-0.451438269	),
  (	52	,	3.585534936	,	-0.952244649	),
  (	52	,	3.630630621	,	-0.921738329	),
  (	52	,	3.297602901	,	-0.715968008	),
  (	52	,	3.865890285	,	-0.44408031	),
  (	52	,	4.102750425	,	-0.415705934	),
  (	52	,	3.620984154	,	-0.316505596	),
  (	52	,	3.712496445	,	-0.284524942	),
  (	52	,	3.887809778	,	-0.040142809	),
  (	52	,	5.979425897	,	-1.398426432	),
  (	52	,	5.518379052	,	-1.344363183	),
  (	52	,	5.90359117	,	-1.081794517	),
  (	52	,	5.223361943	,	-1.028024315	),
  (	52	,	6.036654999	,	-0.606481482	),
  (	52	,	5.796379596	,	-0.594183118	),
  (	52	,	4.787112375	,	-0.977793488	),
  (	52	,	5.268212057	,	-0.922942571	),
  (	52	,	5.447576878	,	-0.767758227	),
  (	52	,	4.853571628	,	-0.692970097	),
  (	52	,	4.812241308	,	-0.640007623	),
  (	52	,	4.860579773	,	-0.576249099	),
  (	52	,	5.254872616	,	-0.559489691	),
  (	52	,	5.730374288	,	-0.23652145	),
  (	53	,	1.132773673	,	0.380014087	),
  (	53	,	0.884674364	,	0.362015615	),
  (	53	,	1.004945434	,	0.446436077	),
  (	53	,	0.738678989	,	0.304808769	),
  (	53	,	0.512044884	,	0.310972595	),
  (	53	,	0.579469177	,	0.370202066	),
  (	53	,	0.606284256	,	0.499909098	),
  (	53	,	0.701127431	,	0.472299297	),
  (	53	,	1.1581145	,	0.387457419	),
  (	53	,	1.077761341	,	0.506169296	),
  (	53	,	1.42963422	,	0.601712894	),
  (	53	,	1.416563057	,	0.652496106	),
  (	53	,	1.234414121	,	0.756858354	),
  (	53	,	1.029614654	,	0.835511337	),
  (	53	,	1.221342623	,	0.926410707	),
  (	53	,	1.256668603	,	0.990582568	),
  (	53	,	0.607716671	,	0.826936139	),
  (	53	,	0.09216726	,	0.66267247	),
  (	53	,	0.298622913	,	0.958347933	),
  (	53	,	0.886718405	,	0.858930586	),
  (	53	,	0.856098378	,	0.889027802	),
  (	53	,	0.62115077	,	0.974690311	),
  (	53	,	1.034709882	,	1.066549688	),
  (	53	,	1.36299041	,	1.290609705	),
  (	53	,	0.522011591	,	1.127857742	),
  (	53	,	0.308304012	,	1.200410173	),
  (	53	,	1.310504942	,	1.417107714	),
  (	53	,	1.091029163	,	1.408456893	),
  (	53	,	2.495643522	,	0.16957055	),
  (	53	,	2.344199325	,	0.2674352	),
  (	53	,	2.075477745	,	0.347035865	),
  (	53	,	2.004845369	,	0.308478454	),
  (	53	,	2.181939946	,	0.474992866	),
  (	53	,	2.818114439	,	0.535502656	),
  (	53	,	2.861188119	,	0.584802923	),
  (	53	,	2.523582247	,	0.702318128	),
  (	53	,	2.59930362	,	0.869522704	),
  (	53	,	2.807961388	,	0.806401617	),
  (	53	,	1.96267413	,	0.487225575	),
  (	53	,	1.740177886	,	0.696429687	),
  (	53	,	1.758773302	,	0.777094597	),
  (	53	,	1.679435884	,	0.860235739	),
  (	53	,	2.02488473	,	0.880232563	),
  (	53	,	1.772532426	,	1.037451819	),
  (	53	,	1.648957347	,	1.073644002	),
  (	53	,	2.41877289	,	1.072035351	),
  (	53	,	2.805910852	,	1.205605798	),
  (	53	,	2.009257745	,	1.518783352	),
  (	53	,	4.109340016	,	0.224231276	),
  (	53	,	4.194188892	,	0.311008881	),
  (	53	,	3.990188176	,	0.50901647	),
  (	53	,	4.022146069	,	0.574803048	),
  (	53	,	4.414612455	,	0.430336606	),
  (	53	,	4.4575976	,	0.58587684	),
  (	53	,	4.492270356	,	0.711694269	),
  (	53	,	4.061947155	,	0.712670122	),
  (	53	,	3.650227698	,	0.479821488	),
  (	53	,	3.150760742	,	0.751297377	),
  (	53	,	4.59005699	,	1.189196597	),
  (	53	,	3.990935218	,	1.175374437	),
  (	53	,	3.383650469	,	1.142113181	),
  (	53	,	3.27295726	,	1.207781006	),
  (	53	,	4.001597187	,	1.253564721	),
  (	53	,	3.356361005	,	1.455832223	),
  (	53	,	5.406762735	,	0.176041209	),
  (	53	,	5.439525199	,	0.281394403	),
  (	53	,	5.258498604	,	0.348919742	),
  (	53	,	5.474053011	,	0.489697774	),
  (	53	,	6.11701198	,	0.555231333	),
  (	53	,	5.951969686	,	0.729883747	),
  (	53	,	6.192158168	,	0.880897666	),
  (	53	,	6.005823161	,	0.868013757	),
  (	53	,	5.006608424	,	0.567264948	),
  (	53	,	5.317368553	,	0.610564007	),
  (	53	,	5.241922312	,	0.874492534	),
  (	53	,	4.930038533	,	0.56812175	),
  (	53	,	4.87218322	,	0.584144978	),
  (	53	,	4.906032869	,	0.691378235	),
  (	53	,	4.806389632	,	0.857339699	),
  (	53	,	4.975184415	,	0.881975691	),
  (	53	,	5.195095675	,	0.924806591	),
  (	53	,	5.614998407	,	0.852337534	),
  (	53	,	5.420166344	,	0.878599548	),
  (	53	,	5.744979398	,	1.110475292	),
  (	53	,	5.618948874	,	1.166036247	),
  (	53	,	0.195206201	,	-0.384069563	),
  (	53	,	6.120236268	,	-0.262484966	),
  (	53	,	0.218689919	,	-0.185806411	),
  (	53	,	0.324649402	,	-0.138245701	),
  (	53	,	0.448222025	,	-0.064410184	),
  (	53	,	0.153830792	,	-0.062708298	),
  (	53	,	0.321731516	,	0.132208543	),
  (	53	,	5.805949176	,	-0.201845199	),
  (	53	,	5.847721403	,	-0.136504037	),
  (	53	,	5.924321218	,	-0.073807977	),
  (	53	,	6.094901316	,	-0.134854511	),
  (	53	,	6.110158818	,	0.093914297	),
  (	53	,	5.694156854	,	-0.158518497	),
  (	53	,	5.670372344	,	0.039147388	),
  (	53	,	5.848860393	,	0.101046032	),
  (	53	,	6.06512337	,	0.171426815	),
  (	53	,	5.988294231	,	0.171670046	),
  (	53	,	0.286601773	,	0.374775062	),
  (	53	,	6.122077206	,	0.214915718	),
  (	53	,	6.250407695	,	0.333707681	),
  (	53	,	0.1314413	,	0.519255772	),
  (	53	,	1.493362232	,	-0.605061319	),
  (	53	,	1.585029857	,	-0.458741439	),
  (	53	,	1.771463643	,	-0.258243327	),
  (	53	,	1.784434236	,	-0.264325644	),
  (	53	,	1.266214246	,	-0.283036487	),
  (	53	,	1.696576471	,	-0.122778268	),
  (	53	,	1.599792462	,	-0.073196777	),
  (	53	,	2.058487152	,	-0.242592274	),
  (	53	,	1.995244259	,	-0.071748105	),
  (	53	,	2.300557191	,	-0.033109236	),
  (	53	,	1.778578705	,	-0.157053352	),
  (	53	,	1.972654408	,	0.033413869	),
  (	53	,	1.95491927	,	0.121154955	),
  (	53	,	1.979236142	,	0.276226065	),
  (	53	,	1.174237632	,	-0.227737094	),
  (	53	,	1.211273488	,	-0.043179331	),
  (	53	,	1.46458436	,	-0.08475332	),
  (	53	,	1.415817711	,	-0.015540289	),
  (	53	,	1.458566714	,	0.065742769	),
  (	53	,	1.063531403	,	0.094868561	),
  (	53	,	0.984691453	,	0.105590718	),
  (	53	,	1.137118191	,	0.263462788	),
  (	53	,	1.709573824	,	0.201491366	),
  (	53	,	1.890940466	,	0.282022106	),
  (	53	,	1.928352784	,	0.356806274	),
  (	53	,	1.638073448	,	0.281750266	),
  (	53	,	1.635570159	,	0.334320975	),
  (	53	,	1.795728261	,	0.379799298	),
  (	53	,	1.427541587	,	0.313497463	),
  (	53	,	1.463687862	,	0.419567968	),
  (	53	,	1.343053935	,	0.356364013	),
  (	53	,	3.092506539	,	-0.466872991	),
  (	53	,	2.851408094	,	-0.351516051	),
  (	53	,	3.584951096	,	-0.15189096	),
  (	53	,	3.34062396	,	0.133925378	),
  (	53	,	3.476546651	,	0.164505699	),
  (	53	,	2.781859795	,	-0.233607337	),
  (	53	,	2.694899835	,	-0.140828695	),
  (	53	,	2.769826009	,	0.12137273	),
  (	53	,	2.832918399	,	0.184045351	),
  (	53	,	3.141365904	,	0.063794515	),
  (	53	,	3.08885492	,	0.143919037	),
  (	53	,	3.294872939	,	0.320743001	),
  (	53	,	4.952904551	,	-0.395692002	),
  (	53	,	4.77877759	,	-0.361776735	),
  (	53	,	4.517502275	,	-0.464445217	),
  (	53	,	4.517483281	,	-0.46442652	),
  (	53	,	4.865285325	,	-0.191589039	),
  (	53	,	5.107987632	,	-0.048676564	),
  (	53	,	5.196867168	,	0.181772042	),
  (	53	,	5.219574941	,	0.199382253	),
  (	53	,	5.013450492	,	0.10598794	),
  (	53	,	5.051928315	,	0.202379988	),
  (	53	,	5.083229903	,	0.208547273	),
  (	53	,	4.128110906	,	-0.031492799	),
  (	53	,	4.94047548	,	0.373938035	),
  (	53	,	4.531820362	,	0.189609009	),
  (	53	,	4.718932518	,	0.376915056	),
  (	53	,	0.212077081	,	-1.307664777	),
  (	53	,	0.737534797	,	-1.096177138	),
  (	53	,	0.701019443	,	-0.952074865	),
  (	53	,	1.240729638	,	-1.042528102	),
  (	53	,	1.33068197	,	-0.865296709	),
  (	53	,	0.997427381	,	-0.656628816	),
  (	53	,	0.221173427	,	-0.889882487	),
  (	53	,	0.295829147	,	-0.724081842	),
  (	53	,	1.08776443	,	-0.285987043	),
  (	53	,	0.621983436	,	-0.415680966	),
  (	53	,	0.804060847	,	-0.1326578	),
  (	53	,	2.432193364	,	-1.307148849	),
  (	53	,	2.190699451	,	-1.281067684	),
  (	53	,	2.180852455	,	-1.248166195	),
  (	53	,	2.981699188	,	-1.133672789	),
  (	53	,	2.991926694	,	-1.116538341	),
  (	53	,	2.776555773	,	-1.039599479	),
  (	53	,	1.61553808	,	-1.304712489	),
  (	53	,	1.795289334	,	-1.238542053	),
  (	53	,	2.174308773	,	-1.145163595	),
  (	53	,	2.160996612	,	-1.098086593	),
  (	53	,	2.35354833	,	-1.031171116	),
  (	53	,	2.266293637	,	-0.932697089	),
  (	53	,	2.245915895	,	-0.871688583	),
  (	53	,	2.278831553	,	-0.839487028	),
  (	53	,	3.018603419	,	-1.038743863	),
  (	53	,	3.018405417	,	-1.037459479	),
  (	53	,	2.847128483	,	-0.999033085	),
  (	53	,	2.676370607	,	-0.894185654	),
  (	53	,	2.761751008	,	-0.820362574	),
  (	53	,	3.036557878	,	-0.831509469	),
  (	53	,	2.981068518	,	-0.631194425	),
  (	53	,	2.644987325	,	-0.826768442	),
  (	53	,	2.613055384	,	-0.626417581	),
  (	53	,	2.766409717	,	-0.414428766	),
  (	53	,	1.619875557	,	-1.144736846	),
  (	53	,	1.601591357	,	-1.084810366	),
  (	53	,	1.922682502	,	-0.909070795	),
  (	53	,	1.947629842	,	-0.890439677	),
  (	53	,	2.123507607	,	-0.790039612	),
  (	53	,	2.207250429	,	-0.735708265	),
  (	53	,	2.092081166	,	-0.685863147	),
  (	53	,	2.069015334	,	-0.62617632	),
  (	53	,	1.739340282	,	-0.841598588	),
  (	53	,	1.788570808	,	-0.813532275	),
  (	53	,	1.886102181	,	-0.706838765	),
  (	53	,	1.850249207	,	-0.73891612	),
  (	53	,	1.792770108	,	-0.599822724	),
  (	53	,	1.959543166	,	-0.677396512	),
  (	53	,	2.012638658	,	-0.672535101	),
  (	53	,	1.98029611	,	-0.634223858	),
  (	53	,	1.935270733	,	-0.56203143	),
  (	53	,	1.933001723	,	-0.557174442	),
  (	53	,	2.09044585	,	-0.406842862	),
  (	53	,	3.512942501	,	-1.307055106	),
  (	53	,	4.064495705	,	-1.280892233	),
  (	53	,	4.169123161	,	-1.197349012	),
  (	53	,	3.162384942	,	-1.335504037	),
  (	53	,	3.751798131	,	-1.069425984	),
  (	53	,	3.161861276	,	-1.192565476	),
  (	53	,	3.586723897	,	-1.02602912	),
  (	53	,	4.009103667	,	-1.055860641	),
  (	53	,	4.616786364	,	-0.951230165	),
  (	53	,	4.643205772	,	-0.904698031	),
  (	53	,	4.497294672	,	-0.777686341	),
  (	53	,	3.997095385	,	-0.724157795	),
  (	53	,	4.034978665	,	-0.693080881	),
  (	53	,	4.046116031	,	-0.641717817	),
  (	53	,	4.295816815	,	-0.655654761	),
  (	53	,	4.236924905	,	-0.513420483	),
  (	53	,	3.328504258	,	-1.100581088	),
  (	53	,	3.385728982	,	-0.991972073	),
  (	53	,	3.241172122	,	-1.006639817	),
  (	53	,	3.224462189	,	-0.962428453	),
  (	53	,	3.177563642	,	-0.849845466	),
  (	53	,	3.157612723	,	-0.740627503	),
  (	53	,	3.2445186	,	-0.618068641	),
  (	53	,	3.477073972	,	-0.549892783	),
  (	53	,	3.908428329	,	-0.590894939	),
  (	53	,	4.182597464	,	-0.433394227	),
  (	53	,	4.162165886	,	-0.42818744	),
  (	53	,	4.162307694	,	-0.418499635	),
  (	53	,	3.720897047	,	-0.475800146	),
  (	53	,	3.886342421	,	-0.279212219	),
  (	53	,	6.248709599	,	-1.431500413	),
  (	53	,	5.847016141	,	-1.403943664	),
  (	53	,	5.556016627	,	-1.223936657	),
  (	53	,	5.410789648	,	-1.056846582	),
  (	53	,	5.460702774	,	-0.900733265	),
  (	53	,	5.831327735	,	-0.726533047	),
  (	53	,	5.910996018	,	-0.361444376	),
  (	53	,	5.001825949	,	-0.913535374	),
  (	53	,	5.200401194	,	-0.695940514	),
  (	53	,	4.770035306	,	-0.721451978	),
  (	53	,	4.809726333	,	-0.674693677	),
  (	53	,	4.959680629	,	-0.651765781	),
  (	53	,	5.53514147	,	-0.369906621	),
  (	53	,	5.576131669	,	-0.313900003	),
  (	53	,	5.679057784	,	-0.245214659	),
  (	54	,	0.63188869	,	0.185187363	),
  (	54	,	0.748283562	,	0.263228751	),
  (	54	,	1.132002306	,	0.368997642	),
  (	54	,	0.996354114	,	0.408772197	),
  (	54	,	0.98089331	,	0.423925733	),
  (	54	,	0.447184495	,	0.353670646	),
  (	54	,	0.809156384	,	0.440785169	),
  (	54	,	0.646495399	,	0.517817048	),
  (	54	,	1.16627615	,	0.401359964	),
  (	54	,	1.145734635	,	0.447313884	),
  (	54	,	1.031830953	,	0.612276692	),
  (	54	,	0.926924852	,	0.803834808	),
  (	54	,	0.863022855	,	0.76837863	),
  (	54	,	0.925653844	,	0.838164366	),
  (	54	,	1.032417738	,	0.884785516	),
  (	54	,	0.577569844	,	0.528881139	),
  (	54	,	0.663680558	,	0.630890365	),
  (	54	,	0.630135107	,	0.872774468	),
  (	54	,	0.160450615	,	0.776476271	),
  (	54	,	0.488645443	,	0.962502412	),
  (	54	,	0.197592083	,	0.963794523	),
  (	54	,	0.108178077	,	1.07915521	),
  (	54	,	0.969331097	,	1.103343678	),
  (	54	,	0.893066232	,	1.127238232	),
  (	54	,	1.00020808	,	1.236925603	),
  (	54	,	0.208432347	,	1.306335615	),
  (	54	,	0.689541393	,	1.270920164	),
  (	54	,	0.547703815	,	1.328455917	),
  (	54	,	0.545997317	,	1.348808892	),
  (	54	,	1.170330279	,	1.462723389	),
  (	54	,	2.207456739	,	0.132024275	),
  (	54	,	2.58258257	,	0.425759235	),
  (	54	,	2.397030503	,	0.384766595	),
  (	54	,	2.368139736	,	0.426783189	),
  (	54	,	2.354199595	,	0.565806386	),
  (	54	,	3.006620963	,	0.686561179	),
  (	54	,	2.85174165	,	0.952689074	),
  (	54	,	1.953623844	,	0.374276054	),
  (	54	,	2.039874574	,	0.583210498	),
  (	54	,	1.928764496	,	0.641590463	),
  (	54	,	2.321054955	,	0.763178831	),
  (	54	,	2.036169432	,	0.654803659	),
  (	54	,	1.774733011	,	0.760589479	),
  (	54	,	1.902014201	,	1.040838834	),
  (	54	,	2.559210188	,	0.997076902	),
  (	54	,	2.800954494	,	1.146957388	),
  (	54	,	3.037113778	,	1.209898439	),
  (	54	,	2.392803081	,	1.167153187	),
  (	54	,	2.543602012	,	1.26104281	),
  (	54	,	2.115251414	,	1.387174879	),
  (	54	,	2.753518657	,	1.440922703	),
  (	54	,	4.039519073	,	0.269269087	),
  (	54	,	4.419892117	,	0.553296429	),
  (	54	,	4.683157864	,	0.69827677	),
  (	54	,	4.080795904	,	0.68085516	),
  (	54	,	4.346865219	,	0.923708684	),
  (	54	,	4.603339352	,	1.079857457	),
  (	54	,	3.834638685	,	0.775002534	),
  (	54	,	3.272283939	,	1.019383487	),
  (	54	,	4.113928705	,	0.913873679	),
  (	54	,	4.216389664	,	1.183517784	),
  (	54	,	3.527515801	,	1.046255562	),
  (	54	,	3.71783375	,	1.211820562	),
  (	54	,	4.236024352	,	1.324314862	),
  (	54	,	5.401007607	,	0.198576851	),
  (	54	,	5.384134292	,	0.227372412	),
  (	54	,	5.47864068	,	0.239484596	),
  (	54	,	5.716595677	,	0.301688626	),
  (	54	,	5.303636996	,	0.41030688	),
  (	54	,	5.618515601	,	0.481863411	),
  (	54	,	5.528536917	,	0.676698822	),
  (	54	,	5.785906961	,	0.785646621	),
  (	54	,	5.673138152	,	0.755272826	),
  (	54	,	5.626290963	,	0.812299098	),
  (	54	,	5.808329896	,	0.887040251	),
  (	54	,	5.928162347	,	0.99126693	),
  (	54	,	5.051538242	,	0.40187067	),
  (	54	,	4.961241116	,	0.574220026	),
  (	54	,	5.19482855	,	0.675846442	),
  (	54	,	5.223907349	,	0.704551491	),
  (	54	,	5.125542385	,	0.74023415	),
  (	54	,	5.14628739	,	0.747323652	),
  (	54	,	5.134013555	,	0.780061044	),
  (	54	,	4.995652602	,	0.931950047	),
  (	54	,	5.025142675	,	0.992385967	),
  (	54	,	5.811181945	,	0.992049564	),
  (	54	,	4.914711097	,	1.316579424	),
  (	54	,	5.685686709	,	1.262218762	),
  (	54	,	0.051223244	,	-0.613173325	),
  (	54	,	0.093903164	,	-0.505830833	),
  (	54	,	6.104810673	,	-0.234908291	),
  (	54	,	0.063103223	,	-0.135794575	),
  (	54	,	5.780486189	,	-0.015823921	),
  (	54	,	6.062943571	,	0.151444914	),
  (	54	,	6.223805052	,	0.060853355	),
  (	54	,	6.210635382	,	0.180320736	),
  (	54	,	6.250974869	,	0.191068114	),
  (	54	,	0.376352391	,	0.334621955	),
  (	54	,	0.122399617	,	0.312296445	),
  (	54	,	1.660698315	,	-0.595925216	),
  (	54	,	1.473679361	,	-0.500724418	),
  (	54	,	1.650333725	,	-0.348488534	),
  (	54	,	1.648005253	,	-0.293492653	),
  (	54	,	1.815625589	,	-0.245103334	),
  (	54	,	1.707741077	,	-0.216283926	),
  (	54	,	1.861741147	,	-0.197118494	),
  (	54	,	1.841057539	,	-0.09986801	),
  (	54	,	1.730445776	,	-0.090953413	),
  (	54	,	1.848454062	,	0.191143895	),
  (	54	,	1.941544513	,	0.203669721	),
  (	54	,	1.293301777	,	-0.090257422	),
  (	54	,	1.392713945	,	0.04529974	),
  (	54	,	1.015320106	,	-0.093572517	),
  (	54	,	0.962718811	,	-0.090944704	),
  (	54	,	1.171708961	,	0.024097474	),
  (	54	,	1.217826653	,	0.13737462	),
  (	54	,	1.24804517	,	0.204300045	),
  (	54	,	1.106328511	,	0.134670457	),
  (	54	,	1.221979174	,	0.212887011	),
  (	54	,	1.645455188	,	0.173520112	),
  (	54	,	1.462330147	,	0.173398703	),
  (	54	,	1.843123475	,	0.422639219	),
  (	54	,	1.360016774	,	0.280050753	),
  (	54	,	1.599530093	,	0.671642336	),
  (	54	,	3.023351781	,	-0.542573645	),
  (	54	,	3.473155059	,	-0.348086695	),
  (	54	,	2.917889394	,	-0.490102554	),
  (	54	,	3.232909933	,	-0.236765431	),
  (	54	,	3.547237647	,	-0.177417403	),
  (	54	,	3.437850737	,	-0.18745673	),
  (	54	,	3.75044215	,	-0.039549386	),
  (	54	,	3.642065912	,	-0.026237023	),
  (	54	,	2.662039987	,	-0.223693348	),
  (	54	,	2.939823541	,	-0.001212707	),
  (	54	,	2.955241825	,	0.03507359	),
  (	54	,	3.345126174	,	0.289337162	),
  (	54	,	4.848003981	,	-0.575772045	),
  (	54	,	5.010310335	,	-0.336679181	),
  (	54	,	4.529171322	,	-0.423887387	),
  (	54	,	5.127433436	,	-0.184314834	),
  (	54	,	5.029510632	,	-0.138571561	),
  (	54	,	5.40797934	,	0.00848861	),
  (	54	,	4.986879653	,	-0.064558987	),
  (	54	,	5.064050702	,	-0.015570659	),
  (	54	,	5.055092825	,	0.018941225	),
  (	54	,	5.159921724	,	0.206412071	),
  (	54	,	4.207847397	,	-0.19849793	),
  (	54	,	4.20784547	,	-0.198503833	),
  (	54	,	4.388767773	,	0.149796559	),
  (	54	,	4.970244233	,	0.237737896	),
  (	54	,	5.085362788	,	0.34553751	),
  (	54	,	4.567608885	,	0.350481087	),
  (	54	,	4.538574474	,	0.44571407	),
  (	54	,	4.663602531	,	0.447198709	),
  (	54	,	4.85565022	,	0.533272922	),
  (	54	,	1.528380628	,	-1.385108988	),
  (	54	,	0.795258916	,	-1.254932573	),
  (	54	,	1.448173265	,	-1.332367742	),
  (	54	,	1.235112377	,	-1.237975774	),
  (	54	,	0.865219629	,	-1.090863331	),
  (	54	,	0.686832649	,	-0.917052699	),
  (	54	,	1.423842088	,	-1.028213364	),
  (	54	,	1.548255634	,	-0.918632882	),
  (	54	,	1.531034054	,	-0.909480715	),
  (	54	,	0.531038435	,	-0.780403719	),
  (	54	,	0.460990337	,	-0.437256631	),
  (	54	,	0.741348285	,	-0.487676944	),
  (	54	,	1.137304449	,	-0.360230546	),
  (	54	,	2.274691713	,	-1.378167416	),
  (	54	,	3.05210431	,	-1.141406327	),
  (	54	,	2.793353766	,	-1.136211738	),
  (	54	,	2.315121681	,	-1.165745479	),
  (	54	,	1.831898551	,	-1.185337236	),
  (	54	,	2.092760937	,	-1.057442371	),
  (	54	,	2.533815043	,	-1.012003915	),
  (	54	,	2.487462054	,	-0.899142723	),
  (	54	,	2.279031385	,	-0.926767887	),
  (	54	,	2.329329479	,	-0.829396975	),
  (	54	,	3.131405709	,	-1.089936851	),
  (	54	,	3.041216648	,	-1.069597709	),
  (	54	,	3.133968528	,	-0.98292233	),
  (	54	,	2.934537934	,	-0.856970004	),
  (	54	,	2.804201977	,	-1.033509632	),
  (	54	,	3.026477876	,	-0.708367906	),
  (	54	,	2.901184224	,	-0.624908861	),
  (	54	,	2.503420566	,	-0.855298962	),
  (	54	,	2.559113744	,	-0.781123188	),
  (	54	,	2.427682329	,	-0.772582086	),
  (	54	,	2.490130475	,	-0.706274712	),
  (	54	,	2.720456347	,	-0.663403373	),
  (	54	,	1.699396463	,	-0.99226406	),
  (	54	,	1.836335669	,	-0.897141928	),
  (	54	,	1.879678587	,	-0.854002263	),
  (	54	,	2.221275647	,	-0.83651672	),
  (	54	,	2.085063368	,	-0.795476744	),
  (	54	,	2.106377531	,	-0.720990644	),
  (	54	,	2.023288785	,	-0.714449367	),
  (	54	,	2.113024904	,	-0.570282546	),
  (	54	,	2.311943769	,	-0.572133598	),
  (	54	,	2.231904556	,	-0.341691823	),
  (	54	,	2.126248984	,	-0.358740853	),
  (	54	,	2.049401721	,	-0.300706654	),
  (	54	,	2.429013807	,	-0.152624756	),
  (	54	,	4.54700932	,	-1.223882209	),
  (	54	,	4.310785018	,	-1.118018865	),
  (	54	,	4.323276501	,	-1.075708806	),
  (	54	,	3.175718549	,	-1.31540027	),
  (	54	,	3.513444317	,	-1.125480781	),
  (	54	,	3.947976934	,	-1.117556872	),
  (	54	,	3.862820401	,	-1.097396933	),
  (	54	,	3.912734226	,	-1.095736499	),
  (	54	,	3.907656795	,	-1.049203842	),
  (	54	,	4.096387633	,	-0.914079881	),
  (	54	,	3.797605649	,	-0.864275107	),
  (	54	,	3.910797546	,	-0.921699756	),
  (	54	,	4.464311603	,	-0.929177245	),
  (	54	,	4.564041615	,	-0.883720487	),
  (	54	,	4.327090194	,	-0.729847179	),
  (	54	,	3.950204651	,	-0.716758696	),
  (	54	,	4.231880942	,	-0.585490352	),
  (	54	,	3.493403178	,	-0.920625192	),
  (	54	,	3.796712045	,	-0.791010214	),
  (	54	,	3.180467261	,	-0.719628169	),
  (	54	,	3.265395188	,	-0.681398395	),
  (	54	,	3.517431906	,	-0.693863497	),
  (	54	,	3.940025177	,	-0.569735584	),
  (	54	,	4.078059135	,	-0.489516749	),
  (	54	,	4.070631329	,	-0.294138997	),
  (	54	,	3.955900203	,	-0.283737828	),
  (	54	,	5.867507243	,	-1.261176596	),
  (	54	,	5.243610062	,	-1.036307834	),
  (	54	,	5.195618238	,	-1.033125914	),
  (	54	,	5.183734882	,	-0.983729791	),
  (	54	,	5.520643193	,	-0.955171563	),
  (	54	,	6.278526774	,	-0.920580469	),
  (	54	,	5.554762637	,	-0.688108401	),
  (	54	,	5.802905073	,	-0.593669693	),
  (	54	,	5.822039847	,	-0.484623724	),
  (	54	,	5.853801473	,	-0.37697051	),
  (	54	,	4.968081615	,	-1.050693842	),
  (	54	,	4.942172429	,	-0.909456891	),
  (	54	,	5.383984375	,	-0.776955851	),
  (	54	,	5.438167882	,	-0.684159559	),
  (	54	,	5.23537522	,	-0.605599271	),
  (	54	,	4.742198638	,	-0.757917124	),
  (	54	,	4.920713631	,	-0.705222861	),
  (	54	,	5.510723675	,	-0.674259187	),
  (	54	,	5.525760813	,	-0.564466793	),
  (	54	,	5.565994918	,	-0.360440403	),
  (	54	,	5.410731896	,	-0.316581981	),
  (	55	,	0.795764384	,	0.07597296	),
  (	55	,	0.692967337	,	0.383296944	),
  (	55	,	0.757961981	,	0.669105238	),
  (	55	,	1.094452579	,	0.462175592	),
  (	55	,	1.161113112	,	0.548697506	),
  (	55	,	1.397328625	,	0.717082827	),
  (	55	,	1.509274439	,	0.869632933	),
  (	55	,	0.964869328	,	0.655894798	),
  (	55	,	1.131073126	,	0.873507603	),
  (	55	,	1.13530124	,	0.888737222	),
  (	55	,	1.221598488	,	0.933268913	),
  (	55	,	1.287405062	,	0.964452283	),
  (	55	,	0.353969292	,	0.501567309	),
  (	55	,	0.274098613	,	0.55508534	),
  (	55	,	0.536537775	,	0.580916867	),
  (	55	,	0.615105306	,	0.875304897	),
  (	55	,	0.583031077	,	0.891246127	),
  (	55	,	0.179416481	,	0.688683204	),
  (	55	,	0.393142627	,	0.82042651	),
  (	55	,	0.1058612	,	0.907918346	),
  (	55	,	0.247766082	,	1.053529931	),
  (	55	,	0.028112363	,	1.120434424	),
  (	55	,	0.911380857	,	0.870015398	),
  (	55	,	1.137388378	,	1.136914636	),
  (	55	,	0.446568925	,	1.187573727	),
  (	55	,	0.311666802	,	1.120545815	),
  (	55	,	0.22134695	,	1.121329845	),
  (	55	,	0.312813474	,	1.134791557	),
  (	55	,	0.429849254	,	1.274787499	),
  (	55	,	0.874138961	,	1.356719431	),
  (	55	,	2.630278248	,	0.383086194	),
  (	55	,	2.128276152	,	0.376665482	),
  (	55	,	2.337261736	,	0.487422573	),
  (	55	,	2.342849441	,	0.574387304	),
  (	55	,	2.6888466	,	0.511561513	),
  (	55	,	2.622329448	,	0.557121114	),
  (	55	,	3.084554001	,	0.970891133	),
  (	55	,	1.937930596	,	0.709864552	),
  (	55	,	1.963222203	,	0.866937918	),
  (	55	,	1.778751288	,	0.851537718	),
  (	55	,	1.665785402	,	0.932905715	),
  (	55	,	1.687795314	,	1.019575903	),
  (	55	,	2.425259122	,	0.990320885	),
  (	55	,	2.198272884	,	0.928847274	),
  (	55	,	2.24535628	,	1.136988718	),
  (	55	,	4.086226405	,	0.174695007	),
  (	55	,	3.729973362	,	0.176268916	),
  (	55	,	3.749291553	,	0.226964082	),
  (	55	,	3.780618894	,	0.335575928	),
  (	55	,	4.322118068	,	0.35742135	),
  (	55	,	4.286342065	,	0.589900113	),
  (	55	,	4.540752991	,	0.566542864	),
  (	55	,	4.553900971	,	0.64833459	),
  (	55	,	4.485642705	,	0.627184922	),
  (	55	,	4.170438762	,	0.662308939	),
  (	55	,	4.092050408	,	0.704307546	),
  (	55	,	4.346697781	,	0.923283439	),
  (	55	,	4.354630105	,	0.97766397	),
  (	55	,	3.699791262	,	0.765400851	),
  (	55	,	3.701345342	,	0.863215102	),
  (	55	,	3.33851081	,	0.793083686	),
  (	55	,	3.228035563	,	0.854935339	),
  (	55	,	3.575748517	,	0.923656093	),
  (	55	,	3.954396502	,	0.952188838	),
  (	55	,	4.691386824	,	1.256726216	),
  (	55	,	4.283956138	,	1.20618515	),
  (	55	,	3.223750749	,	1.31179974	),
  (	55	,	5.493739007	,	0.074924079	),
  (	55	,	5.662546719	,	0.337175021	),
  (	55	,	5.698818425	,	0.4005332	),
  (	55	,	5.226204144	,	0.293028386	),
  (	55	,	5.33223045	,	0.426664165	),
  (	55	,	5.309227154	,	0.430589886	),
  (	55	,	5.212070581	,	0.424453491	),
  (	55	,	5.282062419	,	0.469567841	),
  (	55	,	5.490249096	,	0.389660026	),
  (	55	,	5.397772578	,	0.461846661	),
  (	55	,	6.157960158	,	0.684790664	),
  (	55	,	6.005650778	,	0.726124069	),
  (	55	,	5.819903323	,	0.793088791	),
  (	55	,	6.021756221	,	0.993884024	),
  (	55	,	5.230028539	,	0.540767126	),
  (	55	,	5.126247046	,	0.514227544	),
  (	55	,	5.309821773	,	0.704503218	),
  (	55	,	5.201012817	,	0.820781413	),
  (	55	,	4.94681303	,	0.645277873	),
  (	55	,	4.90604729	,	0.691381675	),
  (	55	,	4.780658353	,	0.735819486	),
  (	55	,	5.632998206	,	1.055215695	),
  (	55	,	5.768645001	,	1.012297	),
  (	55	,	5.781443244	,	1.09582373	),
  (	55	,	5.77653903	,	1.101657508	),
  (	55	,	6.036874203	,	1.173023258	),
  (	55	,	5.242429527	,	1.131338015	),
  (	55	,	4.912141857	,	1.293046637	),
  (	55	,	5.889977784	,	1.375740807	),
  (	55	,	6.19868005	,	-0.55978811	),
  (	55	,	0.209520497	,	-0.379130218	),
  (	55	,	0.053092495	,	-0.313085058	),
  (	55	,	5.967058237	,	-0.342342983	),
  (	55	,	6.206670634	,	-0.269621548	),
  (	55	,	0.620491029	,	-0.015449295	),
  (	55	,	0.661053189	,	0.039568648	),
  (	55	,	0.537545289	,	0.002245515	),
  (	55	,	6.043926069	,	-0.134280187	),
  (	55	,	5.746229284	,	0.210772895	),
  (	55	,	0.043797329	,	0.194531505	),
  (	55	,	0.286656478	,	0.374640807	),
  (	55	,	6.186965866	,	0.321154283	),
  (	55	,	6.129804742	,	0.565223062	),
  (	55	,	1.589720997	,	-0.561500081	),
  (	55	,	1.599308892	,	-0.403363519	),
  (	55	,	1.609911051	,	-0.391436674	),
  (	55	,	1.826478729	,	-0.443559972	),
  (	55	,	1.837390841	,	-0.440095187	),
  (	55	,	1.821966064	,	-0.429877671	),
  (	55	,	1.403987592	,	-0.432371662	),
  (	55	,	1.444815533	,	-0.364144651	),
  (	55	,	1.239770835	,	-0.325795493	),
  (	55	,	1.664223269	,	-0.205481668	),
  (	55	,	1.676259675	,	-0.201242031	),
  (	55	,	1.753797085	,	-0.160009122	),
  (	55	,	1.461786598	,	-0.104881643	),
  (	55	,	1.903461469	,	-0.272023384	),
  (	55	,	2.087151449	,	0.038841436	),
  (	55	,	1.882306419	,	-0.005270848	),
  (	55	,	1.808210467	,	-0.019670531	),
  (	55	,	1.689607065	,	0.005221709	),
  (	55	,	1.19640213	,	-0.15657402	),
  (	55	,	1.196393381	,	-0.143663685	),
  (	55	,	1.412430376	,	-0.002789485	),
  (	55	,	1.0586145	,	-0.004724072	),
  (	55	,	1.06538713	,	0.049324516	),
  (	55	,	1.3433881	,	0.148321985	),
  (	55	,	1.349702821	,	0.171557704	),
  (	55	,	1.241074286	,	0.194535049	),
  (	55	,	1.064423909	,	0.143072512	),
  (	55	,	1.180827649	,	0.239533675	),
  (	55	,	1.18093837	,	0.273871983	),
  (	55	,	1.518453651	,	0.112643343	),
  (	55	,	1.639515897	,	0.219057328	),
  (	55	,	1.37910981	,	0.197943259	),
  (	55	,	1.456934097	,	0.249678704	),
  (	55	,	1.430123939	,	0.27705181	),
  (	55	,	1.455286927	,	0.323588054	),
  (	55	,	1.344385217	,	0.423506555	),
  (	55	,	1.477571334	,	0.532192085	),
  (	55	,	3.258796557	,	-0.572997166	),
  (	55	,	3.061884431	,	-0.567225583	),
  (	55	,	3.189859642	,	-0.411942408	),
  (	55	,	3.118512567	,	-0.448782845	),
  (	55	,	3.306121135	,	-0.473674534	),
  (	55	,	3.465255445	,	-0.347841284	),
  (	55	,	2.822490247	,	-0.301889695	),
  (	55	,	3.288971811	,	-0.164969855	),
  (	55	,	3.519961439	,	-0.221793148	),
  (	55	,	3.276894769	,	0.428776832	),
  (	55	,	3.057741087	,	0.372669828	),
  (	55	,	3.058907029	,	0.596884917	),
  (	55	,	4.708410111	,	-0.528015925	),
  (	55	,	4.724831769	,	-0.423811105	),
  (	55	,	4.929108475	,	-0.354728124	),
  (	55	,	4.971556245	,	-0.224110781	),
  (	55	,	4.602313818	,	-0.196209507	),
  (	55	,	4.72583056	,	-0.142774694	),
  (	55	,	5.151884838	,	-0.284377354	),
  (	55	,	5.19575268	,	-0.187854755	),
  (	55	,	5.337118515	,	0.093247809	),
  (	55	,	4.962304214	,	0.044248657	),
  (	55	,	4.831107941	,	0.003421836	),
  (	55	,	4.872306504	,	0.116427393	),
  (	55	,	4.493353251	,	-0.183679364	),
  (	55	,	4.427001518	,	-0.107409799	),
  (	55	,	4.249214795	,	-0.20660888	),
  (	55	,	4.192252221	,	-0.146807575	),
  (	55	,	4.241687572	,	-0.149183466	),
  (	55	,	4.309760297	,	-0.132627505	),
  (	55	,	4.576365802	,	0.005772823	),
  (	55	,	4.413129808	,	0.021220909	),
  (	55	,	4.146436685	,	0.038330544	),
  (	55	,	4.408372045	,	0.126494843	),
  (	55	,	4.871492416	,	0.159201885	),
  (	55	,	4.811957451	,	0.311135025	),
  (	55	,	4.973144336	,	0.457805568	),
  (	55	,	0.043771467	,	-1.435082796	),
  (	55	,	0.661886432	,	-1.380725648	),
  (	55	,	1.320848892	,	-1.244668009	),
  (	55	,	1.34201828	,	-1.106538589	),
  (	55	,	1.142728482	,	-1.106279874	),
  (	55	,	1.207581417	,	-1.083456601	),
  (	55	,	0.020468819	,	-1.246810529	),
  (	55	,	0.090104139	,	-1.215183484	),
  (	55	,	0.185338434	,	-1.14262768	),
  (	55	,	0.632221424	,	-1.052657992	),
  (	55	,	0.709356108	,	-0.886605781	),
  (	55	,	1.233826283	,	-0.8810613	),
  (	55	,	1.321255986	,	-0.857850537	),
  (	55	,	1.511701694	,	-0.813272392	),
  (	55	,	0.44567464	,	-0.564212883	),
  (	55	,	0.272459778	,	-0.550684503	),
  (	55	,	0.774050026	,	-0.416477792	),
  (	55	,	0.619722181	,	-0.188113419	),
  (	55	,	0.814014788	,	-0.106266518	),
  (	55	,	0.784027624	,	-0.043024359	),
  (	55	,	2.341532392	,	-1.495099936	),
  (	55	,	2.621155375	,	-1.434912913	),
  (	55	,	2.461480053	,	-1.40998065	),
  (	55	,	1.817647969	,	-1.386143996	),
  (	55	,	2.431589804	,	-1.198864399	),
  (	55	,	2.985312103	,	-1.261115987	),
  (	55	,	2.909592839	,	-1.23705337	),
  (	55	,	2.655990607	,	-1.148690759	),
  (	55	,	2.743985629	,	-1.120017364	),
  (	55	,	2.213416691	,	-1.223356529	),
  (	55	,	2.319576968	,	-1.005893686	),
  (	55	,	2.546874892	,	-0.940576294	),
  (	55	,	2.418582189	,	-0.969869465	),
  (	55	,	2.270193133	,	-0.925290403	),
  (	55	,	2.297328558	,	-0.801323834	),
  (	55	,	3.060115302	,	-0.752160714	),
  (	55	,	2.991002233	,	-0.62941698	),
  (	55	,	2.362071468	,	-0.730667697	),
  (	55	,	2.747098901	,	-0.534193854	),
  (	55	,	1.846781377	,	-1.032851186	),
  (	55	,	2.311044174	,	-0.703719631	),
  (	55	,	1.605181971	,	-0.735728867	),
  (	55	,	1.711988479	,	-0.657941109	),
  (	55	,	1.735717627	,	-0.564426935	),
  (	55	,	2.021086943	,	-0.629191036	),
  (	55	,	2.031452241	,	-0.59621656	),
  (	55	,	1.954706479	,	-0.508865977	),
  (	55	,	2.046516458	,	-0.434797903	),
  (	55	,	2.027066243	,	-0.430643261	),
  (	55	,	1.914863029	,	-0.464010222	),
  (	55	,	1.950366937	,	-0.402926655	),
  (	55	,	2.135739068	,	-0.283597722	),
  (	55	,	2.477378679	,	-0.10597215	),
  (	55	,	2.429045297	,	-0.11088291	),
  (	55	,	4.278008689	,	-1.373010639	),
  (	55	,	4.229405744	,	-1.011151837	),
  (	55	,	3.870358261	,	-0.914274822	),
  (	55	,	4.395294698	,	-1.018252832	),
  (	55	,	4.443165733	,	-0.883860068	),
  (	55	,	4.318404142	,	-0.807097134	),
  (	55	,	4.42454315	,	-0.729659482	),
  (	55	,	4.347510096	,	-0.748028651	),
  (	55	,	4.272977251	,	-0.744801936	),
  (	55	,	4.055290876	,	-0.815640264	),
  (	55	,	4.009627237	,	-0.711891398	),
  (	55	,	4.113029383	,	-0.653190506	),
  (	55	,	4.130916364	,	-0.605326187	),
  (	55	,	4.293615387	,	-0.684046146	),
  (	55	,	3.762614772	,	-0.607143935	),
  (	55	,	3.453057878	,	-0.756926577	),
  (	55	,	3.87353121	,	-0.455313885	),
  (	55	,	3.902273232	,	-0.430091039	),
  (	55	,	4.119292578	,	-0.273550234	),
  (	55	,	3.732387254	,	-0.317663421	),
  (	55	,	3.880374513	,	-0.2469482	),
  (	55	,	5.536276928	,	-1.552583236	),
  (	55	,	4.951330516	,	-1.529026859	),
  (	55	,	5.868435022	,	-1.00879862	),
  (	55	,	4.815398209	,	-1.309767328	),
  (	55	,	5.189834243	,	-1.265420804	),
  (	55	,	5.017354073	,	-1.194237169	),
  (	55	,	5.839351967	,	-0.93604534	),
  (	55	,	5.63784391	,	-0.71871324	),
  (	55	,	5.743785452	,	-0.650200094	),
  (	55	,	5.284921362	,	-0.630276064	),
  (	55	,	4.925504241	,	-0.762362607	),
  (	55	,	4.928736335	,	-0.75807109	),
  (	55	,	5.060000638	,	-0.618222529	),
  (	55	,	5.17499009	,	-0.556912013	),
  (	55	,	4.993464442	,	-0.541876169	),
  (	55	,	5.681109504	,	-0.406024983	),
  (	55	,	5.320608093	,	-0.333682528	),
  (	55	,	5.463512947	,	-0.096117004	),
  (	56	,	0.970036223	,	0.343832737	),
  (	56	,	0.982458727	,	0.433521315	),
  (	56	,	0.602685224	,	0.347340282	),
  (	56	,	0.852332291	,	0.533315147	),
  (	56	,	1.408646873	,	0.716095972	),
  (	56	,	0.979677844	,	0.636344374	),
  (	56	,	0.986061025	,	0.797297287	),
  (	56	,	1.227856531	,	0.843003908	),
  (	56	,	0.44531997	,	0.615150523	),
  (	56	,	0.715960633	,	0.773128429	),
  (	56	,	0.489377126	,	0.886497945	),
  (	56	,	0.193883721	,	0.835385141	),
  (	56	,	1.120907101	,	1.079483487	),
  (	56	,	0.31544624	,	1.390572397	),
  (	56	,	0.23954833	,	1.460967738	),
  (	56	,	2.480364745	,	0.158070572	),
  (	56	,	2.289654601	,	0.175956075	),
  (	56	,	2.422646546	,	0.260777155	),
  (	56	,	2.547010581	,	0.244724641	),
  (	56	,	2.232248871	,	0.315800311	),
  (	56	,	2.237105829	,	0.356760215	),
  (	56	,	2.391100231	,	0.517564308	),
  (	56	,	2.805740282	,	0.459459817	),
  (	56	,	2.764227255	,	0.61066755	),
  (	56	,	2.493806389	,	0.612655866	),
  (	56	,	2.511674899	,	0.62497332	),
  (	56	,	2.481274352	,	0.795880311	),
  (	56	,	3.020920214	,	1.066082575	),
  (	56	,	2.025083009	,	0.450016055	),
  (	56	,	2.151761635	,	0.517601868	),
  (	56	,	1.985948618	,	0.540370855	),
  (	56	,	2.273373691	,	0.799965352	),
  (	56	,	1.958512077	,	0.840962823	),
  (	56	,	1.686115893	,	0.9823629	),
  (	56	,	1.614361762	,	1.028624145	),
  (	56	,	1.775112922	,	0.997785686	),
  (	56	,	1.639200533	,	1.047176858	),
  (	56	,	2.379760965	,	0.847011666	),
  (	56	,	3.065101349	,	1.164923106	),
  (	56	,	2.150302814	,	1.195098984	),
  (	56	,	1.626871417	,	1.146999033	),
  (	56	,	2.095245163	,	1.290106493	),
  (	56	,	1.772471857	,	1.388594704	),
  (	56	,	2.747445219	,	1.470471876	),
  (	56	,	3.9932644	,	0.08620856	),
  (	56	,	4.193318251	,	0.58116232	),
  (	56	,	4.299631555	,	0.652647323	),
  (	56	,	4.610413284	,	0.847986879	),
  (	56	,	4.275683268	,	0.693044947	),
  (	56	,	4.169194434	,	0.742922174	),
  (	56	,	4.165357194	,	0.752917873	),
  (	56	,	4.562677892	,	1.048045142	),
  (	56	,	3.606694073	,	0.95002889	),
  (	56	,	3.552272227	,	0.966011697	),
  (	56	,	3.950674215	,	0.840396451	),
  (	56	,	4.505323113	,	1.097369841	),
  (	56	,	3.402991237	,	1.162339805	),
  (	56	,	4.300942691	,	1.378192077	),
  (	56	,	5.444579824	,	0.104861428	),
  (	56	,	5.478780318	,	0.219366418	),
  (	56	,	5.251261144	,	0.279797143	),
  (	56	,	5.783928902	,	0.505515636	),
  (	56	,	5.726847374	,	0.502534642	),
  (	56	,	5.890622705	,	0.568498111	),
  (	56	,	5.815427037	,	0.60395801	),
  (	56	,	5.916104653	,	0.691748935	),
  (	56	,	6.17246574	,	0.702252727	),
  (	56	,	6.054782535	,	0.809606266	),
  (	56	,	5.772430108	,	0.779283178	),
  (	56	,	4.979813851	,	0.45887055	),
  (	56	,	5.003122869	,	0.499673517	),
  (	56	,	5.263716972	,	0.627784679	),
  (	56	,	5.316617544	,	0.645770949	),
  (	56	,	5.356284483	,	0.670902325	),
  (	56	,	5.418993635	,	0.728096961	),
  (	56	,	5.195068506	,	0.708598506	),
  (	56	,	4.860501128	,	0.913741325	),
  (	56	,	5.724759152	,	0.973837206	),
  (	56	,	5.812093248	,	1.060447577	),
  (	56	,	5.877782275	,	1.136772131	),
  (	56	,	6.140448848	,	1.228009331	),
  (	56	,	5.806017129	,	1.224047384	),
  (	56	,	6.089586788	,	1.237230237	),
  (	56	,	5.44347558	,	1.405897647	),
  (	56	,	5.359247994	,	1.421096289	),
  (	56	,	6.13945677	,	1.523805479	),
  (	56	,	6.202784977	,	-0.314640443	),
  (	56	,	0.412911595	,	-0.273604489	),
  (	56	,	0.378997418	,	-0.227877942	),
  (	56	,	0.244450991	,	-0.196638882	),
  (	56	,	0.288357494	,	-0.171728385	),
  (	56	,	0.462457181	,	-0.100068492	),
  (	56	,	0.663907512	,	-0.018066055	),
  (	56	,	0.619345227	,	0.006904871	),
  (	56	,	0.298286703	,	0.098585035	),
  (	56	,	0.423664309	,	0.211915262	),
  (	56	,	5.832894135	,	-0.223950021	),
  (	56	,	6.089325469	,	-0.061023594	),
  (	56	,	6.059279834	,	0.037146651	),
  (	56	,	5.703879527	,	0.046881274	),
  (	56	,	5.682171687	,	0.099136467	),
  (	56	,	5.89033414	,	0.077329073	),
  (	56	,	0.089873907	,	0.142948383	),
  (	56	,	0.296511095	,	0.361954131	),
  (	56	,	0.142224396	,	0.354196913	),
  (	56	,	6.010357623	,	0.362491922	),
  (	56	,	1.554866167	,	-0.547726097	),
  (	56	,	1.713256706	,	-0.559036116	),
  (	56	,	1.604369203	,	-0.334500567	),
  (	56	,	1.774345028	,	-0.176406631	),
  (	56	,	1.325964272	,	-0.425658068	),
  (	56	,	1.25492945	,	-0.295541484	),
  (	56	,	1.415792558	,	-0.296285235	),
  (	56	,	1.653015066	,	-0.163889476	),
  (	56	,	1.468672454	,	-0.105849849	),
  (	56	,	1.989957572	,	-0.252946522	),
  (	56	,	2.041783417	,	-0.21279342	),
  (	56	,	2.144786428	,	-0.135659458	),
  (	56	,	2.099765363	,	0.085171189	),
  (	56	,	1.895140714	,	0.05430422	),
  (	56	,	1.30830563	,	-0.179144837	),
  (	56	,	1.195166658	,	-0.117616925	),
  (	56	,	1.402942397	,	-0.00726896	),
  (	56	,	1.43951686	,	0.03122835	),
  (	56	,	1.445316997	,	0.057458456	),
  (	56	,	1.28011359	,	0.043774849	),
  (	56	,	1.286289353	,	0.135767551	),
  (	56	,	1.054916764	,	0.174498387	),
  (	56	,	1.462676239	,	0.178722255	),
  (	56	,	1.537508595	,	0.247343939	),
  (	56	,	1.470716975	,	0.297405753	),
  (	56	,	1.51597774	,	0.30943138	),
  (	56	,	1.695448268	,	0.532202248	),
  (	56	,	3.048521176	,	-0.230402116	),
  (	56	,	3.503823172	,	-0.309542487	),
  (	56	,	3.694468294	,	-0.162551018	),
  (	56	,	3.324633857	,	0.118796506	),
  (	56	,	3.47870605	,	0.238692028	),
  (	56	,	2.753240727	,	-0.237163731	),
  (	56	,	2.984680313	,	0.02457008	),
  (	56	,	3.047606625	,	0.141970913	),
  (	56	,	3.122724994	,	0.273088744	),
  (	56	,	3.270093189	,	0.420780217	),
  (	56	,	2.949016924	,	0.232259555	),
  (	56	,	4.552516308	,	-0.491188804	),
  (	56	,	4.91460443	,	-0.390817325	),
  (	56	,	4.800299581	,	-0.276319985	),
  (	56	,	4.436628885	,	-0.404050559	),
  (	56	,	5.164262662	,	-0.270018619	),
  (	56	,	5.138120858	,	-0.249631222	),
  (	56	,	5.212546944	,	-0.143596426	),
  (	56	,	5.139085169	,	-0.081123135	),
  (	56	,	5.213070197	,	0.00477399	),
  (	56	,	4.995838518	,	-0.070364819	),
  (	56	,	4.841908993	,	-0.034654203	),
  (	56	,	5.04625999	,	0.084381687	),
  (	56	,	5.059953503	,	0.215980862	),
  (	56	,	4.474752508	,	-0.015569554	),
  (	56	,	4.140557064	,	-0.066644702	),
  (	56	,	4.231731341	,	-0.060506466	),
  (	56	,	4.01876069	,	0.012472389	),
  (	56	,	4.125050659	,	0.095072853	),
  (	56	,	4.331013557	,	0.096363432	),
  (	56	,	4.966534103	,	0.303003955	),
  (	56	,	5.088598504	,	0.350767383	),
  (	56	,	4.504972126	,	0.184742635	),
  (	56	,	4.514524149	,	0.251156132	),
  (	56	,	4.633749411	,	0.278434743	),
  (	56	,	4.656252242	,	0.308869891	),
  (	56	,	4.43037049	,	0.321721634	),
  (	56	,	4.428429075	,	0.365794969	),
  (	56	,	4.796070098	,	0.426664855	),
  (	56	,	4.69240465	,	0.454658757	),
  (	56	,	4.589459133	,	0.495807632	),
  (	56	,	0.855104673	,	-1.350675766	),
  (	56	,	0.293719009	,	-1.078183552	),
  (	56	,	1.452967771	,	-1.120981975	),
  (	56	,	1.393514234	,	-0.883213142	),
  (	56	,	1.44058966	,	-0.821676089	),
  (	56	,	1.432286837	,	-0.649791074	),
  (	56	,	1.131325566	,	-0.772625262	),
  (	56	,	0.155719105	,	-0.837786177	),
  (	56	,	0.274102767	,	-0.809784376	),
  (	56	,	0.529017452	,	-0.523643902	),
  (	56	,	0.914555697	,	-0.221215244	),
  (	56	,	0.797205371	,	-0.134137092	),
  (	56	,	2.558451688	,	-1.340002887	),
  (	56	,	2.181693225	,	-1.248000095	),
  (	56	,	2.669366499	,	-1.013346861	),
  (	56	,	1.681957233	,	-1.216300856	),
  (	56	,	2.406617279	,	-0.813041613	),
  (	56	,	2.938753382	,	-1.040553466	),
  (	56	,	3.107409844	,	-0.994619483	),
  (	56	,	2.781403562	,	-1.02508971	),
  (	56	,	2.757431328	,	-0.786562754	),
  (	56	,	2.49722424	,	-0.709465564	),
  (	56	,	2.430153707	,	-0.687690705	),
  (	56	,	2.835937271	,	-0.59442664	),
  (	56	,	2.804389741	,	-0.57099601	),
  (	56	,	2.697083393	,	-0.506004534	),
  (	56	,	2.061650425	,	-0.948884966	),
  (	56	,	1.775335483	,	-0.894765546	),
  (	56	,	1.897027066	,	-0.817681007	),
  (	56	,	2.13435453	,	-0.849703467	),
  (	56	,	2.216524892	,	-0.612849689	),
  (	56	,	1.733244038	,	-0.645607213	),
  (	56	,	1.721719053	,	-0.571005919	),
  (	56	,	1.769413515	,	-0.540161048	),
  (	56	,	1.940501621	,	-0.555169005	),
  (	56	,	1.959488164	,	-0.549013969	),
  (	56	,	1.874993789	,	-0.440364199	),
  (	56	,	1.935064177	,	-0.4858006	),
  (	56	,	2.290156244	,	-0.648341376	),
  (	56	,	2.399566201	,	-0.529982144	),
  (	56	,	2.203745993	,	-0.419682185	),
  (	56	,	1.992658684	,	-0.34387025	),
  (	56	,	2.394165969	,	-0.149915701	),
  (	56	,	2.319420849	,	-0.125266849	),
  (	56	,	4.11601686	,	-1.47418552	),
  (	56	,	3.581814024	,	-1.497251712	),
  (	56	,	3.91771758	,	-1.338017748	),
  (	56	,	4.103070127	,	-1.281889368	),
  (	56	,	3.51611298	,	-1.232677974	),
  (	56	,	3.43881758	,	-1.139805308	),
  (	56	,	4.555387477	,	-1.097187563	),
  (	56	,	4.670821061	,	-0.935714487	),
  (	56	,	4.391046298	,	-1.021081698	),
  (	56	,	4.370611477	,	-0.866583375	),
  (	56	,	4.567814546	,	-0.800115243	),
  (	56	,	4.383871917	,	-0.712789421	),
  (	56	,	4.517439427	,	-0.585530741	),
  (	56	,	4.175273665	,	-0.592793153	),
  (	56	,	4.274085757	,	-0.539420979	),
  (	56	,	4.224262015	,	-0.459488018	),
  (	56	,	3.279785522	,	-1.037143599	),
  (	56	,	3.436711714	,	-0.933051476	),
  (	56	,	3.64425207	,	-0.910380687	),
  (	56	,	3.62935209	,	-0.818538078	),
  (	56	,	3.433523781	,	-0.625920735	),
  (	56	,	3.844183921	,	-0.630673009	),
  (	56	,	3.871906921	,	-0.447229437	),
  (	56	,	4.190133761	,	-0.28860832	),
  (	56	,	4.096775746	,	-0.336891024	),
  (	56	,	4.069283626	,	-0.343318972	),
  (	56	,	3.773439893	,	-0.432953973	),
  (	56	,	5.837421471	,	-1.352830175	),
  (	56	,	5.884546761	,	-1.177914975	),
  (	56	,	6.042651699	,	-1.201131863	),
  (	56	,	5.244178151	,	-1.168401196	),
  (	56	,	6.148004232	,	-1.101490338	),
  (	56	,	6.041732788	,	-0.941878071	),
  (	56	,	6.137501664	,	-0.920150574	),
  (	56	,	6.100664926	,	-0.712534391	),
  (	56	,	6.051470866	,	-0.678797777	),
  (	56	,	6.01962199	,	-0.514213748	),
  (	56	,	5.763241071	,	-0.49661141	),
  (	56	,	4.757904294	,	-1.082115921	),
  (	56	,	5.119747503	,	-0.790144539	),
  (	56	,	5.045582152	,	-0.793530688	),
  (	56	,	5.333987574	,	-0.733913544	),
  (	56	,	4.829763927	,	-0.839810918	),
  (	56	,	4.957963344	,	-0.745445421	),
  (	56	,	4.742199057	,	-0.757925938	),
  (	56	,	4.858060347	,	-0.675898392	),
  (	56	,	4.908532975	,	-0.692655413	),
  (	56	,	5.091744866	,	-0.51912328	),
  (	56	,	5.470173116	,	-0.694824956	),
  (	56	,	5.603203534	,	-0.363949278	),
  (	56	,	5.700837762	,	-0.198374483	),
  (	56	,	5.566501009	,	-0.264792134	),
  (	56	,	5.603353707	,	-0.224764381	),
  (	57	,	0.927642102	,	0.163591742	),
  (	57	,	0.717983151	,	0.267240402	),
  (	57	,	0.769869513	,	0.31454693	),
  (	57	,	1.087205819	,	0.342241557	),
  (	57	,	1.127436996	,	0.376626445	),
  (	57	,	1.033540683	,	0.392300828	),
  (	57	,	1.066226943	,	0.420727526	),
  (	57	,	0.985712053	,	0.428551466	),
  (	57	,	0.708457315	,	0.34926037	),
  (	57	,	0.592151837	,	0.437076952	),
  (	57	,	0.83879567	,	0.475721623	),
  (	57	,	0.909080663	,	0.590046152	),
  (	57	,	0.679723957	,	0.605406029	),
  (	57	,	1.227535986	,	0.499422201	),
  (	57	,	1.154040655	,	0.595689957	),
  (	57	,	1.277561729	,	0.743276925	),
  (	57	,	1.011834675	,	0.599679215	),
  (	57	,	1.084792377	,	0.663894273	),
  (	57	,	1.440637135	,	1.100730049	),
  (	57	,	0.252357836	,	0.506008879	),
  (	57	,	0.365122103	,	0.658247654	),
  (	57	,	0.494315225	,	0.710868466	),
  (	57	,	0.439233191	,	0.755681962	),
  (	57	,	0.162984741	,	0.617837519	),
  (	57	,	0.310540889	,	0.658409514	),
  (	57	,	0.170890455	,	0.861399714	),
  (	57	,	0.299143858	,	1.016887465	),
  (	57	,	0.109553733	,	0.925840477	),
  (	57	,	0.022267703	,	1.070130905	),
  (	57	,	0.007054761	,	1.068539438	),
  (	57	,	0.784657782	,	0.824159328	),
  (	57	,	0.711435468	,	0.961778827	),
  (	57	,	0.767757898	,	1.073750172	),
  (	57	,	1.14230634	,	1.060022788	),
  (	57	,	1.274480369	,	1.108367301	),
  (	57	,	0.536702141	,	1.123817553	),
  (	57	,	0.199184107	,	1.308785952	),
  (	57	,	1.165229619	,	1.410645317	),
  (	57	,	1.178073131	,	1.454576431	),
  (	57	,	2.282913393	,	0.221323137	),
  (	57	,	2.338415449	,	0.202910846	),
  (	57	,	2.345671873	,	0.271947242	),
  (	57	,	2.546233747	,	0.523140916	),
  (	57	,	2.323804883	,	0.566782917	),
  (	57	,	3.047071065	,	0.761403101	),
  (	57	,	2.880864269	,	0.794583614	),
  (	57	,	2.071311834	,	0.830158927	),
  (	57	,	1.730264018	,	0.670998255	),
  (	57	,	1.575055858	,	0.836043751	),
  (	57	,	1.901697155	,	0.824470367	),
  (	57	,	1.932373987	,	0.96483856	),
  (	57	,	2.373676147	,	0.947432789	),
  (	57	,	2.172236772	,	1.039712737	),
  (	57	,	4.133319037	,	0.246364421	),
  (	57	,	4.165116619	,	0.354498423	),
  (	57	,	3.726623007	,	0.226178319	),
  (	57	,	3.659294633	,	0.378665057	),
  (	57	,	4.014863235	,	0.516895122	),
  (	57	,	4.041684539	,	0.599283406	),
  (	57	,	3.885481172	,	0.650531508	),
  (	57	,	3.925309379	,	0.685314352	),
  (	57	,	4.286907323	,	0.588242731	),
  (	57	,	4.545393264	,	0.697682302	),
  (	57	,	4.327486247	,	0.795844573	),
  (	57	,	4.642519146	,	0.939014874	),
  (	57	,	4.473857876	,	0.950690236	),
  (	57	,	4.295355017	,	0.963513223	),
  (	57	,	3.608431053	,	0.672694235	),
  (	57	,	3.385934042	,	0.668727783	),
  (	57	,	3.288415707	,	0.580275921	),
  (	57	,	3.638352128	,	0.937741531	),
  (	57	,	4.014634009	,	0.906848548	),
  (	57	,	3.889614511	,	1.034891926	),
  (	57	,	4.264084086	,	1.042925009	),
  (	57	,	3.349168571	,	1.16570995	),
  (	57	,	4.204150502	,	1.340309644	),
  (	57	,	5.490940277	,	0.189177053	),
  (	57	,	5.764345857	,	0.228976973	),
  (	57	,	5.731762969	,	0.343279811	),
  (	57	,	5.722809949	,	0.346042532	),
  (	57	,	5.793782001	,	0.378779266	),
  (	57	,	5.236228476	,	0.305719117	),
  (	57	,	5.535525327	,	0.52718529	),
  (	57	,	5.471159917	,	0.583605466	),
  (	57	,	6.002808679	,	0.634451484	),
  (	57	,	6.139748215	,	0.748957937	),
  (	57	,	6.185161374	,	0.775431671	),
  (	57	,	6.106460797	,	0.84867836	),
  (	57	,	5.687280838	,	0.668174197	),
  (	57	,	5.823907293	,	0.749684405	),
  (	57	,	5.682719075	,	0.716928862	),
  (	57	,	5.608325226	,	0.815324899	),
  (	57	,	5.767630705	,	0.92296964	),
  (	57	,	6.270706948	,	0.972246476	),
  (	57	,	6.094298253	,	0.928721671	),
  (	57	,	5.97677533	,	0.975692099	),
  (	57	,	6.234473118	,	1.085847944	),
  (	57	,	5.164934653	,	0.449806703	),
  (	57	,	5.201197084	,	0.436194962	),
  (	57	,	5.383968491	,	0.814962066	),
  (	57	,	4.951802583	,	0.726104157	),
  (	57	,	5.093883508	,	0.913160647	),
  (	57	,	4.93745464	,	0.924619393	),
  (	57	,	4.97734628	,	0.971419693	),
  (	57	,	4.876267031	,	1.091300629	),
  (	57	,	5.468595879	,	0.788568581	),
  (	57	,	5.582783762	,	0.864117912	),
  (	57	,	5.64153232	,	0.872275556	),
  (	57	,	5.542557468	,	0.934852027	),
  (	57	,	5.667782818	,	1.003372415	),
  (	57	,	5.372620813	,	0.859052326	),
  (	57	,	5.549290653	,	1.046963344	),
  (	57	,	5.873099747	,	1.235185868	),
  (	57	,	5.260227155	,	1.082032774	),
  (	57	,	5.32156522	,	1.086599771	),
  (	57	,	5.424419898	,	1.163396091	),
  (	57	,	5.900383855	,	1.330401089	),
  (	57	,	5.421837326	,	1.440442944	),
  (	57	,	0.050500393	,	-0.485195076	),
  (	57	,	0.229852034	,	-0.418976845	),
  (	57	,	0.201593262	,	-0.39308574	),
  (	57	,	6.222176861	,	-0.325997168	),
  (	57	,	0.065053506	,	-0.16702155	),
  (	57	,	6.230585497	,	-0.048198339	),
  (	57	,	0.418806241	,	-0.268782155	),
  (	57	,	0.525559812	,	-0.148771532	),
  (	57	,	0.597716925	,	-0.112100076	),
  (	57	,	0.275059668	,	-0.084427017	),
  (	57	,	5.967776802	,	-0.245332049	),
  (	57	,	5.992932803	,	-0.202746154	),
  (	57	,	6.106057183	,	-0.089439035	),
  (	57	,	6.019029735	,	0.016797887	),
  (	57	,	5.608101941	,	-0.062085485	),
  (	57	,	5.665930013	,	0.100739468	),
  (	57	,	0.141358819	,	0.121396314	),
  (	57	,	0.205189036	,	0.208978993	),
  (	57	,	0.284006594	,	0.260865751	),
  (	57	,	0.203105863	,	0.270092557	),
  (	57	,	0.378283367	,	0.335801784	),
  (	57	,	0.304646518	,	0.343105038	),
  (	57	,	0.174214534	,	0.374168945	),
  (	57	,	0.23985593	,	0.41238882	),
  (	57	,	6.16741987	,	0.392675766	),
  (	57	,	1.601606736	,	-0.598857785	),
  (	57	,	1.65667861	,	-0.600333585	),
  (	57	,	1.695823024	,	-0.564984373	),
  (	57	,	1.482788587	,	-0.569491078	),
  (	57	,	1.803413702	,	-0.332183921	),
  (	57	,	1.653624584	,	-0.365220262	),
  (	57	,	1.498198264	,	-0.323890675	),
  (	57	,	1.386098999	,	-0.235971392	),
  (	57	,	1.70969866	,	-0.142390323	),
  (	57	,	1.634551161	,	-0.079734355	),
  (	57	,	1.950986196	,	-0.311800494	),
  (	57	,	2.033473885	,	-0.118214075	),
  (	57	,	2.209813362	,	-0.069602085	),
  (	57	,	2.201635404	,	-0.06547468	),
  (	57	,	1.712104631	,	-0.102435222	),
  (	57	,	1.785791634	,	-0.039654981	),
  (	57	,	1.750087198	,	0.008644311	),
  (	57	,	1.638718821	,	-0.008965857	),
  (	57	,	1.977431803	,	0.057433125	),
  (	57	,	1.971383801	,	0.298198573	),
  (	57	,	1.218815687	,	-0.250630164	),
  (	57	,	1.345372437	,	-0.151241046	),
  (	57	,	1.092468485	,	-0.12084543	),
  (	57	,	1.189557089	,	-0.056019005	),
  (	57	,	0.865599128	,	-0.016243934	),
  (	57	,	1.012308533	,	0.114055138	),
  (	57	,	1.196149992	,	0.097190092	),
  (	57	,	1.134311499	,	0.244958229	),
  (	57	,	1.178736211	,	0.27292903	),
  (	57	,	1.149390236	,	0.292815317	),
  (	57	,	1.609913661	,	0.043625955	),
  (	57	,	1.403794566	,	0.147105825	),
  (	57	,	1.636865549	,	0.241748701	),
  (	57	,	1.515030085	,	0.252865699	),
  (	57	,	1.869104465	,	0.278030281	),
  (	57	,	1.623253957	,	0.345408707	),
  (	57	,	1.766087316	,	0.505634919	),
  (	57	,	1.290827578	,	0.262500815	),
  (	57	,	1.738273653	,	0.505870441	),
  (	57	,	1.427408141	,	0.527239016	),
  (	57	,	1.401549231	,	0.516091992	),
  (	57	,	3.333613455	,	-0.494351098	),
  (	57	,	3.419846218	,	-0.359248241	),
  (	57	,	2.905801183	,	-0.476264887	),
  (	57	,	3.144836214	,	-0.182377779	),
  (	57	,	3.603835077	,	-0.216882939	),
  (	57	,	3.863732785	,	0.012517765	),
  (	57	,	3.498043133	,	0.036422747	),
  (	57	,	3.591249011	,	0.061738997	),
  (	57	,	3.576070011	,	0.187556967	),
  (	57	,	2.893955115	,	-0.197295677	),
  (	57	,	2.852418737	,	-0.037159782	),
  (	57	,	2.558617601	,	0.031159485	),
  (	57	,	2.820529276	,	0.24773543	),
  (	57	,	2.758471194	,	0.246744906	),
  (	57	,	2.690766721	,	0.239602845	),
  (	57	,	3.354978224	,	0.246483227	),
  (	57	,	3.271276939	,	0.36470204	),
  (	57	,	3.312283992	,	0.36760966	),
  (	57	,	2.991503391	,	0.287220072	),
  (	57	,	2.820503991	,	0.329714296	),
  (	57	,	2.918270065	,	0.430371129	),
  (	57	,	4.602033071	,	-0.568657434	),
  (	57	,	4.720707066	,	-0.397591337	),
  (	57	,	4.88042854	,	-0.410240307	),
  (	57	,	4.774629787	,	-0.378969043	),
  (	57	,	4.95462316	,	-0.285848624	),
  (	57	,	4.85921848	,	-0.259245212	),
  (	57	,	4.371593833	,	-0.347740408	),
  (	57	,	4.813628763	,	-0.209699369	),
  (	57	,	4.596744571	,	-0.100277307	),
  (	57	,	4.698406904	,	-0.071242212	),
  (	57	,	5.088440146	,	-0.262728881	),
  (	57	,	5.293723208	,	-0.017619133	),
  (	57	,	5.206809615	,	-0.054355913	),
  (	57	,	5.151873539	,	-0.010841617	),
  (	57	,	5.045950066	,	0.253852148	),
  (	57	,	4.256978873	,	-0.146134317	),
  (	57	,	4.070828351	,	-0.020711696	),
  (	57	,	3.995996716	,	0.006496535	),
  (	57	,	4.313434954	,	0.011598203	),
  (	57	,	4.323678405	,	0.03462557	),
  (	57	,	4.24663979	,	0.08763414	),
  (	57	,	4.222060877	,	0.172642395	),
  (	57	,	4.758955101	,	0.058018714	),
  (	57	,	4.83447277	,	0.108104599	),
  (	57	,	4.795980189	,	0.126707134	),
  (	57	,	5.040905291	,	0.370571267	),
  (	57	,	4.809016343	,	0.406412312	),
  (	57	,	4.803798623	,	0.521142976	),
  (	57	,	4.747444035	,	0.635299412	),
  (	57	,	1.288007755	,	-1.307887391	),
  (	57	,	1.111813668	,	-1.085440006	),
  (	57	,	0.240007797	,	-1.21348183	),
  (	57	,	0.863283713	,	-1.092066614	),
  (	57	,	1.26936698	,	-0.933069442	),
  (	57	,	1.477966343	,	-0.710474742	),
  (	57	,	1.452369648	,	-0.672186434	),
  (	57	,	1.071764028	,	-0.482603684	),
  (	57	,	0.447224799	,	-0.93796723	),
  (	57	,	0.462954282	,	-0.886912961	),
  (	57	,	0.150422	,	-0.914078302	),
  (	57	,	0.369487941	,	-0.724185843	),
  (	57	,	0.124123455	,	-0.696652989	),
  (	57	,	0.405502252	,	-0.643421899	),
  (	57	,	0.445272208	,	-0.642846964	),
  (	57	,	0.744704007	,	-0.622667657	),
  (	57	,	0.87877086	,	-0.412514166	),
  (	57	,	0.975480593	,	-0.18301151	),
  (	57	,	0.522597653	,	-0.363454841	),
  (	57	,	0.43138858	,	-0.371321046	),
  (	57	,	1.745535971	,	-1.410456857	),
  (	57	,	2.494085098	,	-1.275502383	),
  (	57	,	2.474422814	,	-1.249678946	),
  (	57	,	3.04230927	,	-1.324644838	),
  (	57	,	2.809335119	,	-1.121356781	),
  (	57	,	2.049378893	,	-1.155337738	),
  (	57	,	1.597662579	,	-1.152605411	),
  (	57	,	2.089343466	,	-1.061585754	),
  (	57	,	2.084843474	,	-1.052472707	),
  (	57	,	2.412601281	,	-1.036966809	),
  (	57	,	2.257204801	,	-1.097002544	),
  (	57	,	2.329187212	,	-1.053373275	),
  (	57	,	2.451449473	,	-0.968904838	),
  (	57	,	2.136108662	,	-0.978870418	),
  (	57	,	2.250892379	,	-0.889586828	),
  (	57	,	2.273677366	,	-0.85386144	),
  (	57	,	3.136329821	,	-1.122937219	),
  (	57	,	3.086255782	,	-1.006991499	),
  (	57	,	2.899494638	,	-0.832153441	),
  (	57	,	3.032248583	,	-0.857571383	),
  (	57	,	3.043695103	,	-0.833345275	),
  (	57	,	2.595532523	,	-0.876921704	),
  (	57	,	2.593095053	,	-0.790345703	),
  (	57	,	2.522110939	,	-0.753828441	),
  (	57	,	1.710299471	,	-1.025447697	),
  (	57	,	1.670840274	,	-0.983843777	),
  (	57	,	1.707412412	,	-0.904520966	),
  (	57	,	1.992868074	,	-0.852247047	),
  (	57	,	2.143173127	,	-0.845820699	),
  (	57	,	2.157217018	,	-0.799962184	),
  (	57	,	2.221481308	,	-0.770743985	),
  (	57	,	2.047333112	,	-0.817820364	),
  (	57	,	2.064105274	,	-0.634667204	),
  (	57	,	1.574366307	,	-0.893881871	),
  (	57	,	1.6830534	,	-0.840848007	),
  (	57	,	1.849836181	,	-0.761056541	),
  (	57	,	1.863651994	,	-0.713720842	),
  (	57	,	1.904723079	,	-0.668790553	),
  (	57	,	1.725272555	,	-0.641927398	),
  (	57	,	1.718381934	,	-0.632356098	),
  (	57	,	1.790660007	,	-0.553373247	),
  (	57	,	2.006245305	,	-0.667773204	),
  (	57	,	2.005948304	,	-0.665654261	),
  (	57	,	2.001593255	,	-0.636989222	),
  (	57	,	1.877632712	,	-0.479817238	),
  (	57	,	1.94351513	,	-0.440133036	),
  (	57	,	2.395762466	,	-0.319891263	),
  (	57	,	2.203124101	,	-0.404105536	),
  (	57	,	2.140893214	,	-0.240834526	),
  (	57	,	2.398049015	,	-0.153374255	),
  (	57	,	2.249159486	,	-0.139315451	),
  (	57	,	3.381532925	,	-1.485681948	),
  (	57	,	3.688406819	,	-1.340360307	),
  (	57	,	4.448691076	,	-1.20895905	),
  (	57	,	4.34477604	,	-1.143113995	),
  (	57	,	4.184289057	,	-1.135120671	),
  (	57	,	4.312060675	,	-1.022763632	),
  (	57	,	4.257858609	,	-1.010767212	),
  (	57	,	3.774732051	,	-1.190233583	),
  (	57	,	3.737817689	,	-1.162178815	),
  (	57	,	3.999471416	,	-1.062975691	),
  (	57	,	4.028992825	,	-1.035343924	),
  (	57	,	4.15001438	,	-0.960900863	),
  (	57	,	4.145666513	,	-0.928690453	),
  (	57	,	3.976148863	,	-0.965971476	),
  (	57	,	3.979163539	,	-0.850743094	),
  (	57	,	3.868005582	,	-0.828005571	),
  (	57	,	4.55667698	,	-1.058958967	),
  (	57	,	4.469839407	,	-1.007270125	),
  (	57	,	4.451044588	,	-0.952909226	),
  (	57	,	4.261752278	,	-0.939181189	),
  (	57	,	4.369171579	,	-0.851075088	),
  (	57	,	4.533953552	,	-0.813942867	),
  (	57	,	4.532605469	,	-0.770211349	),
  (	57	,	4.39298791	,	-0.687260945	),
  (	57	,	4.504125697	,	-0.689535004	),
  (	57	,	4.525017032	,	-0.570080777	),
  (	57	,	4.084942694	,	-0.774877624	),
  (	57	,	3.964744469	,	-0.748188992	),
  (	57	,	3.962774497	,	-0.70832706	),
  (	57	,	4.438312941	,	-0.580488774	),
  (	57	,	4.300419613	,	-0.409220589	),
  (	57	,	3.261497809	,	-1.029600068	),
  (	57	,	3.611244067	,	-0.87826177	),
  (	57	,	3.363962691	,	-0.921315764	),
  (	57	,	3.828098303	,	-0.805181167	),
  (	57	,	3.825476708	,	-0.701827166	),
  (	57	,	3.382982247	,	-0.749022352	),
  (	57	,	3.245192921	,	-0.679133573	),
  (	57	,	3.200132103	,	-0.679443776	),
  (	57	,	3.252250191	,	-0.614119589	),
  (	57	,	3.675570444	,	-0.478740462	),
  (	57	,	3.545615522	,	-0.5007859	),
  (	57	,	3.874452661	,	-0.465063882	),
  (	57	,	3.853796793	,	-0.436294178	),
  (	57	,	4.169155051	,	-0.458431151	),
  (	57	,	3.610322481	,	-0.311716843	),
  (	57	,	3.912892199	,	-0.199135643	),
  (	57	,	3.790395762	,	-0.120443622	),
  (	57	,	5.71998734	,	-1.443721328	),
  (	57	,	5.451090591	,	-1.200382764	),
  (	57	,	5.860564428	,	-0.801610401	),
  (	57	,	5.982275793	,	-0.683416627	),
  (	57	,	5.708401615	,	-0.825639671	),
  (	57	,	5.756532421	,	-0.670120902	),
  (	57	,	5.615706959	,	-0.742599912	),
  (	57	,	5.604314189	,	-0.71570228	),
  (	57	,	5.884616812	,	-0.682997903	),
  (	57	,	5.929136122	,	-0.577376575	),
  (	57	,	5.819550632	,	-0.439488624	),
  (	57	,	5.340210491	,	-0.740416109	),
  (	57	,	4.885110029	,	-0.753741034	),
  (	57	,	4.781737351	,	-0.771546682	),
  (	57	,	4.836533833	,	-0.680607808	),
  (	57	,	5.131389108	,	-0.431432515	),
  (	57	,	5.085425894	,	-0.418225185	),
  (	57	,	5.064227142	,	-0.3909945	),
  (	57	,	5.555783897	,	-0.482062282	),
  (	57	,	5.411965797	,	-0.58349161	),
  (	57	,	5.798783003	,	-0.323228873	),
  (	57	,	5.244617159	,	-0.238012954	),
  (	57	,	5.484262053	,	-0.169255357	),
  (	57	,	5.577133687	,	-0.078878256	),
  (	58	,	0.839674249	,	0.116254295	),
  (	58	,	0.683470639	,	0.217241777	),
  (	58	,	0.891463418	,	0.43151087	),
  (	58	,	0.472041334	,	0.295925957	),
  (	58	,	0.882257	,	0.481840977	),
  (	58	,	0.827342764	,	0.507489296	),
  (	58	,	0.892282609	,	0.585309583	),
  (	58	,	0.643424608	,	0.555033656	),
  (	58	,	1.169440185	,	0.377333383	),
  (	58	,	1.198313601	,	0.505464837	),
  (	58	,	1.261937131	,	0.548673168	),
  (	58	,	1.355761721	,	0.819624551	),
  (	58	,	0.927933156	,	0.61892405	),
  (	58	,	0.931938023	,	0.696371602	),
  (	58	,	1.003879164	,	0.78483357	),
  (	58	,	0.918988956	,	0.839563012	),
  (	58	,	1.236389891	,	0.872205312	),
  (	58	,	1.292057278	,	0.922752804	),
  (	58	,	1.186958322	,	0.940921162	),
  (	58	,	0.41136212	,	0.649909233	),
  (	58	,	0.306773321	,	0.734455228	),
  (	58	,	0.058946095	,	0.716184581	),
  (	58	,	0.074834938	,	0.836839661	),
  (	58	,	0.138244954	,	0.922222189	),
  (	58	,	1.019821999	,	1.01184612	),
  (	58	,	1.388498756	,	1.278766113	),
  (	58	,	0.428156601	,	1.011899793	),
  (	58	,	0.45086226	,	1.056818683	),
  (	58	,	0.470296007	,	1.114406544	),
  (	58	,	0.812124836	,	1.386116186	),
  (	58	,	0.926578099	,	1.481960624	),
  (	58	,	2.211034538	,	0.220852018	),
  (	58	,	2.231866833	,	0.42028918	),
  (	58	,	2.516391166	,	0.543869927	),
  (	58	,	2.20985176	,	0.486820829	),
  (	58	,	2.72333722	,	0.588499026	),
  (	58	,	2.749359893	,	0.679371172	),
  (	58	,	2.539471073	,	0.693899608	),
  (	58	,	2.788556381	,	0.936678903	),
  (	58	,	2.638083915	,	0.940587307	),
  (	58	,	2.808772921	,	0.998307827	),
  (	58	,	2.842242045	,	1.035325187	),
  (	58	,	1.882267162	,	0.468731897	),
  (	58	,	1.85961065	,	0.601678334	),
  (	58	,	2.000797624	,	0.611715957	),
  (	58	,	2.245935565	,	0.63563735	),
  (	58	,	1.817473172	,	0.807634248	),
  (	58	,	1.92548981	,	0.789381833	),
  (	58	,	2.012383934	,	0.840037845	),
  (	58	,	1.891021951	,	0.897602703	),
  (	58	,	2.327289198	,	1.081448173	),
  (	58	,	2.341455227	,	1.127538594	),
  (	58	,	2.617382602	,	0.991549677	),
  (	58	,	2.6966554	,	1.136354034	),
  (	58	,	2.26540806	,	1.134839551	),
  (	58	,	2.179662331	,	1.32220939	),
  (	58	,	3.847232834	,	0.203503272	),
  (	58	,	3.866326019	,	0.264101448	),
  (	58	,	4.176744519	,	0.251590721	),
  (	58	,	3.580861947	,	0.348295798	),
  (	58	,	3.883243648	,	0.4994404	),
  (	58	,	3.940515089	,	0.614458056	),
  (	58	,	4.26186367	,	0.50876602	),
  (	58	,	4.252808527	,	0.590933722	),
  (	58	,	4.539386614	,	0.807058741	),
  (	58	,	4.118921728	,	0.567506737	),
  (	58	,	4.025701928	,	0.690825129	),
  (	58	,	4.093991027	,	0.816757676	),
  (	58	,	4.47385555	,	0.950703372	),
  (	58	,	3.512959327	,	0.416337253	),
  (	58	,	3.615647654	,	0.544376399	),
  (	58	,	3.492027436	,	0.700758786	),
  (	58	,	3.471147431	,	0.713060376	),
  (	58	,	3.232570429	,	1.009910882	),
  (	58	,	3.911233846	,	0.866152467	),
  (	58	,	4.083847399	,	0.953482183	),
  (	58	,	3.79005718	,	0.869951079	),
  (	58	,	3.832108131	,	0.942882907	),
  (	58	,	3.565620219	,	1.243410958	),
  (	58	,	3.885007778	,	1.44007789	),
  (	58	,	3.355855159	,	1.45591816	),
  (	58	,	4.585076791	,	1.517879946	),
  (	58	,	5.792224782	,	0.33991659	),
  (	58	,	5.602439608	,	0.4236658	),
  (	58	,	5.589768662	,	0.416350721	),
  (	58	,	5.232381703	,	0.403194218	),
  (	58	,	5.243603514	,	0.432848703	),
  (	58	,	5.288399232	,	0.462141165	),
  (	58	,	5.287473277	,	0.467903922	),
  (	58	,	5.604986481	,	0.456832907	),
  (	58	,	5.620579384	,	0.562447778	),
  (	58	,	5.460571256	,	0.493063694	),
  (	58	,	5.799839579	,	0.578957926	),
  (	58	,	5.993760879	,	0.781017373	),
  (	58	,	5.685877699	,	0.718288093	),
  (	58	,	5.610291008	,	0.639965452	),
  (	58	,	6.05525774	,	0.860389549	),
  (	58	,	6.226602356	,	1.002714493	),
  (	58	,	6.079807321	,	0.99781176	),
  (	58	,	6.119746474	,	1.049527175	),
  (	58	,	6.063865779	,	1.035550876	),
  (	58	,	5.256071193	,	0.562319291	),
  (	58	,	5.339571618	,	0.654087419	),
  (	58	,	5.181285546	,	0.670339243	),
  (	58	,	5.332375451	,	0.79927807	),
  (	58	,	5.353975182	,	0.861909155	),
  (	58	,	5.201601254	,	0.836566486	),
  (	58	,	4.903759097	,	0.557209255	),
  (	58	,	4.929531304	,	0.572691268	),
  (	58	,	4.907884008	,	0.656152387	),
  (	58	,	4.965599004	,	0.66787125	),
  (	58	,	5.110851187	,	0.878023204	),
  (	58	,	5.12398637	,	0.894224839	),
  (	58	,	4.916237584	,	0.924813763	),
  (	58	,	5.490493238	,	0.776186359	),
  (	58	,	5.479591981	,	0.827593737	),
  (	58	,	5.49124624	,	0.880724862	),
  (	58	,	5.495280958	,	1.037400596	),
  (	58	,	5.704700398	,	1.059286972	),
  (	58	,	5.286557085	,	1.083483881	),
  (	58	,	4.713089867	,	1.396349479	),
  (	58	,	0.146970187	,	-0.51589276	),
  (	58	,	0.040804739	,	-0.488483893	),
  (	58	,	0.163066766	,	-0.432271247	),
  (	58	,	0.215678901	,	-0.236701494	),
  (	58	,	5.998484573	,	-0.284009974	),
  (	58	,	0.295721395	,	-0.170788003	),
  (	58	,	0.256258849	,	-0.198619789	),
  (	58	,	0.579461709	,	-0.041785035	),
  (	58	,	0.602287945	,	0.030724431	),
  (	58	,	0.573110933	,	0.1495576	),
  (	58	,	0.334239319	,	-0.043647392	),
  (	58	,	0.326460108	,	-0.016971022	),
  (	58	,	5.773878924	,	-0.113836499	),
  (	58	,	5.864809104	,	-0.084422581	),
  (	58	,	6.237186394	,	0.018778674	),
  (	58	,	6.180146085	,	0.036698091	),
  (	58	,	5.886709759	,	0.159329332	),
  (	58	,	6.017884761	,	0.204702628	),
  (	58	,	5.774062703	,	0.198732418	),
  (	58	,	6.248123488	,	0.051143178	),
  (	58	,	0.010875141	,	0.148093587	),
  (	58	,	0.024873565	,	0.233808268	),
  (	58	,	0.160520678	,	0.265842458	),
  (	58	,	0.238182147	,	0.334900013	),
  (	58	,	0.039464215	,	0.317855696	),
  (	58	,	0.089043169	,	0.539927961	),
  (	58	,	6.112266739	,	0.530831746	),
  (	58	,	6.169541031	,	0.546727637	),
  (	58	,	1.548431165	,	-0.697393642	),
  (	58	,	1.594591434	,	-0.619828109	),
  (	58	,	1.57634556	,	-0.591876359	),
  (	58	,	1.597380595	,	-0.519390965	),
  (	58	,	1.705060792	,	-0.484669816	),
  (	58	,	1.613566685	,	-0.397480427	),
  (	58	,	1.864781128	,	-0.416098678	),
  (	58	,	1.883616624	,	-0.364475451	),
  (	58	,	1.810978181	,	-0.356133531	),
  (	58	,	1.641167778	,	-0.290038828	),
  (	58	,	1.30471601	,	-0.285798302	),
  (	58	,	1.612574782	,	-0.254545959	),
  (	58	,	1.525454922	,	-0.252793517	),
  (	58	,	1.477564901	,	-0.114737173	),
  (	58	,	1.917568988	,	-0.286167901	),
  (	58	,	1.924099318	,	-0.250637891	),
  (	58	,	1.960488319	,	-0.033255531	),
  (	58	,	2.242861236	,	-0.037549543	),
  (	58	,	1.781617877	,	-0.023023805	),
  (	58	,	1.689740075	,	-0.004817766	),
  (	58	,	1.724663537	,	0.015537071	),
  (	58	,	1.690087948	,	0.050760781	),
  (	58	,	1.761229573	,	0.068635402	),
  (	58	,	1.773865589	,	0.149873546	),
  (	58	,	1.982104136	,	0.058847048	),
  (	58	,	1.801283073	,	0.146261601	),
  (	58	,	1.817019286	,	0.173773972	),
  (	58	,	2.016089091	,	0.247984005	),
  (	58	,	1.137579431	,	-0.132514333	),
  (	58	,	1.373286173	,	0.089992725	),
  (	58	,	0.98150011	,	-0.005178992	),
  (	58	,	0.959280937	,	0.053353453	),
  (	58	,	1.096687084	,	0.09639627	),
  (	58	,	1.143460723	,	0.245690871	),
  (	58	,	1.474885879	,	0.131620673	),
  (	58	,	1.529266463	,	0.249675378	),
  (	58	,	1.717414228	,	0.247043739	),
  (	58	,	1.788221335	,	0.282792355	),
  (	58	,	1.548738681	,	0.344695168	),
  (	58	,	1.297530273	,	0.299387959	),
  (	58	,	1.214153361	,	0.361015681	),
  (	58	,	1.43673437	,	0.438949383	),
  (	58	,	1.30095666	,	0.437206333	),
  (	58	,	1.613264927	,	0.403405732	),
  (	58	,	1.531388741	,	0.488132698	),
  (	58	,	3.020609837	,	-0.510683615	),
  (	58	,	3.283818651	,	-0.241893611	),
  (	58	,	3.288071588	,	-0.223923089	),
  (	58	,	3.009132183	,	-0.426975804	),
  (	58	,	3.546764295	,	-0.268135667	),
  (	58	,	3.597548908	,	-0.282378824	),
  (	58	,	3.440655162	,	-0.156814806	),
  (	58	,	3.916326218	,	-0.002928592	),
  (	58	,	3.401897847	,	-0.066529565	),
  (	58	,	2.777449592	,	-0.213508092	),
  (	58	,	2.837472434	,	-0.155297211	),
  (	58	,	2.909868841	,	0.034119953	),
  (	58	,	2.506922811	,	-0.103242392	),
  (	58	,	2.770860441	,	0.150977988	),
  (	58	,	3.185455078	,	0.10135356	),
  (	58	,	3.119999852	,	0.147376461	),
  (	58	,	3.431219438	,	0.394721601	),
  (	58	,	3.194626126	,	0.358524438	),
  (	58	,	3.356651709	,	0.480882342	),
  (	58	,	3.012794149	,	0.32131461	),
  (	58	,	3.230280511	,	0.46458435	),
  (	58	,	3.217987733	,	0.505053647	),
  (	58	,	3.14881194	,	0.629043317	),
  (	58	,	3.09661224	,	0.609675167	),
  (	58	,	4.678476362	,	-0.60736127	),
  (	58	,	4.637566246	,	-0.644824488	),
  (	58	,	4.82155684	,	-0.536811936	),
  (	58	,	4.697982737	,	-0.489835821	),
  (	58	,	4.907982503	,	-0.436525415	),
  (	58	,	4.860267941	,	-0.419443338	),
  (	58	,	4.855165811	,	-0.259455172	),
  (	58	,	4.451290481	,	-0.436148609	),
  (	58	,	4.746434497	,	-0.299389501	),
  (	58	,	4.849520703	,	-0.188424956	),
  (	58	,	5.03204179	,	-0.214375134	),
  (	58	,	4.919565055	,	-0.099577569	),
  (	58	,	4.876448908	,	-0.005403894	),
  (	58	,	4.954369795	,	0.115448125	),
  (	58	,	5.100796161	,	0.034037827	),
  (	58	,	5.097874231	,	0.051137031	),
  (	58	,	5.254047459	,	0.127025902	),
  (	58	,	5.102342068	,	0.254745698	),
  (	58	,	5.041099366	,	0.263258076	),
  (	58	,	4.221976468	,	-0.222452469	),
  (	58	,	4.696273176	,	0.011699834	),
  (	58	,	4.587401815	,	0.047553848	),
  (	58	,	4.370763592	,	0.020622829	),
  (	58	,	4.36613659	,	0.073647958	),
  (	58	,	4.294297741	,	0.121271108	),
  (	58	,	4.755588574	,	0.054427904	),
  (	58	,	4.754127459	,	0.069695565	),
  (	58	,	4.60161134	,	0.16731833	),
  (	58	,	5.003167947	,	0.423257828	),
  (	58	,	4.847971475	,	0.29545645	),
  (	58	,	4.866023708	,	0.317709776	),
  (	58	,	4.841522293	,	0.416543357	),
  (	58	,	4.55760438	,	0.284502811	),
  (	58	,	4.596235417	,	0.336081393	),
  (	58	,	4.614291365	,	0.424289872	),
  (	58	,	4.478069071	,	0.385436604	),
  (	58	,	4.555782649	,	0.400727911	),
  (	58	,	4.635904411	,	0.428711086	),
  (	58	,	4.825750341	,	0.520610091	),
  (	58	,	4.670424789	,	0.511773602	),
  (	58	,	4.755950166	,	0.636457807	),
  (	58	,	0.818327979	,	-1.378613943	),
  (	58	,	1.471386409	,	-1.404323955	),
  (	58	,	0.92006344	,	-1.160464141	),
  (	58	,	0.585751909	,	-1.184050185	),
  (	58	,	0.915935073	,	-0.74410829	),
  (	58	,	1.271781264	,	-0.609231179	),
  (	58	,	0.994553354	,	-0.52655693	),
  (	58	,	1.222215756	,	-0.427295782	),
  (	58	,	0.182290209	,	-0.986127093	),
  (	58	,	0.522050005	,	-0.733583266	),
  (	58	,	0.132822086	,	-0.841519541	),
  (	58	,	0.005827891	,	-0.878551407	),
  (	58	,	0.027680815	,	-0.85652854	),
  (	58	,	0.267502165	,	-0.679215517	),
  (	58	,	0.419514109	,	-0.521976723	),
  (	58	,	0.783690418	,	-0.441106626	),
  (	58	,	1.097832783	,	-0.355275746	),
  (	58	,	0.942311121	,	-0.195358811	),
  (	58	,	0.680677718	,	-0.136694302	),
  (	58	,	1.944430708	,	-1.380453425	),
  (	58	,	2.432362193	,	-1.304360296	),
  (	58	,	2.659458329	,	-1.198739242	),
  (	58	,	2.578399415	,	-1.095107825	),
  (	58	,	1.870587571	,	-1.230393341	),
  (	58	,	1.669582194	,	-1.221447841	),
  (	58	,	2.046886226	,	-0.984545016	),
  (	58	,	2.467228236	,	-1.081233125	),
  (	58	,	2.33523983	,	-0.959344717	),
  (	58	,	2.32409245	,	-0.844025293	),
  (	58	,	3.09994142	,	-1.093437895	),
  (	58	,	3.038495927	,	-1.065565748	),
  (	58	,	2.980734058	,	-0.99098593	),
  (	58	,	2.783988803	,	-0.999310885	),
  (	58	,	2.734995043	,	-0.957789246	),
  (	58	,	2.676742386	,	-0.903308094	),
  (	58	,	2.87973748	,	-0.764577107	),
  (	58	,	2.922948714	,	-0.564923537	),
  (	58	,	2.591091298	,	-0.892678387	),
  (	58	,	2.6857424	,	-0.752459368	),
  (	58	,	2.417873944	,	-0.770488281	),
  (	58	,	2.771639787	,	-0.690497139	),
  (	58	,	2.876428507	,	-0.588839332	),
  (	58	,	2.746628891	,	-0.517730454	),
  (	58	,	1.676514972	,	-1.052103813	),
  (	58	,	1.777232892	,	-0.969352608	),
  (	58	,	1.999725441	,	-0.84825437	),
  (	58	,	1.911442953	,	-0.767714893	),
  (	58	,	2.098021372	,	-0.945116925	),
  (	58	,	2.116481998	,	-0.926908409	),
  (	58	,	2.153612342	,	-0.876086801	),
  (	58	,	2.203275087	,	-0.746474296	),
  (	58	,	2.241176262	,	-0.678038697	),
  (	58	,	2.034072625	,	-0.662065524	),
  (	58	,	2.027064435	,	-0.662227049	),
  (	58	,	2.174201589	,	-0.618748887	),
  (	58	,	1.897839115	,	-0.723025859	),
  (	58	,	1.61518287	,	-0.704297534	),
  (	58	,	1.645062623	,	-0.658632512	),
  (	58	,	1.949129107	,	-0.595866825	),
  (	58	,	1.897397161	,	-0.471905584	),
  (	58	,	1.88584312	,	-0.452782448	),
  (	58	,	2.4866916	,	-0.464076243	),
  (	58	,	2.636954385	,	-0.423859877	),
  (	58	,	2.649229928	,	-0.299186475	),
  (	58	,	2.49730063	,	-0.338598075	),
  (	58	,	2.187567626	,	-0.350447109	),
  (	58	,	2.038583949	,	-0.393038343	),
  (	58	,	2.058248041	,	-0.36954599	),
  (	58	,	2.060860538	,	-0.259114646	),
  (	58	,	2.21088113	,	-0.218773254	),
  (	58	,	3.975630735	,	-1.479827168	),
  (	58	,	4.338544345	,	-1.238977454	),
  (	58	,	4.36936222	,	-1.19199361	),
  (	58	,	4.171757284	,	-1.055627429	),
  (	58	,	3.358669174	,	-1.256397821	),
  (	58	,	3.877868358	,	-1.162278213	),
  (	58	,	3.153047136	,	-1.207634089	),
  (	58	,	3.565762342	,	-1.076734836	),
  (	58	,	4.028090842	,	-1.058670389	),
  (	58	,	3.723105422	,	-0.936643834	),
  (	58	,	4.0218263	,	-0.843335146	),
  (	58	,	4.356506673	,	-0.757447879	),
  (	58	,	4.630668881	,	-0.818941749	),
  (	58	,	4.595117008	,	-0.718605954	),
  (	58	,	4.428664189	,	-0.718218179	),
  (	58	,	4.220519802	,	-0.641513653	),
  (	58	,	4.242313867	,	-0.495980926	),
  (	58	,	3.374439877	,	-1.052930905	),
  (	58	,	3.365428252	,	-1.052953569	),
  (	58	,	3.637778979	,	-0.931542415	),
  (	58	,	3.500568776	,	-0.910764417	),
  (	58	,	3.566537402	,	-0.810321685	),
  (	58	,	3.82364956	,	-0.807133293	),
  (	58	,	3.820193444	,	-0.724618652	),
  (	58	,	3.729359167	,	-0.730204234	),
  (	58	,	3.432130344	,	-0.725857082	),
  (	58	,	3.180403917	,	-0.773639642	),
  (	58	,	3.298738528	,	-0.69585704	),
  (	58	,	3.563983617	,	-0.462426454	),
  (	58	,	3.602414751	,	-0.455811602	),
  (	58	,	4.165483173	,	-0.440589337	),
  (	58	,	4.226874884	,	-0.413391587	),
  (	58	,	4.215432165	,	-0.412010491	),
  (	58	,	4.241129913	,	-0.339649951	),
  (	58	,	4.178641563	,	-0.366226422	),
  (	58	,	3.998472777	,	-0.390943191	),
  (	58	,	3.746506225	,	-0.326660746	),
  (	58	,	4.019167473	,	-0.101664137	),
  (	58	,	3.932799326	,	-0.048084998	),
  (	58	,	6.14388056	,	-1.526851203	),
  (	58	,	5.538871359	,	-1.277153717	),
  (	58	,	5.719375458	,	-1.215262428	),
  (	58	,	5.623255536	,	-1.213103414	),
  (	58	,	5.230287263	,	-1.207150892	),
  (	58	,	4.924573964	,	-1.135829284	),
  (	58	,	5.566580579	,	-0.929617944	),
  (	58	,	6.095439809	,	-1.082128204	),
  (	58	,	6.131903329	,	-0.992204335	),
  (	58	,	6.00740422	,	-0.837220538	),
  (	58	,	5.958896559	,	-0.812405747	),
  (	58	,	5.643483714	,	-0.782757897	),
  (	58	,	5.525827545	,	-0.72232281	),
  (	58	,	6.057816946	,	-0.503071749	),
  (	58	,	6.027166956	,	-0.503599234	),
  (	58	,	5.779715249	,	-0.468139681	),
  (	58	,	5.862199507	,	-0.432190355	),
  (	58	,	4.780781404	,	-1.100526789	),
  (	58	,	5.117736229	,	-0.928264996	),
  (	58	,	5.102473519	,	-0.758275654	),
  (	58	,	5.237479096	,	-0.588271265	),
  (	58	,	4.941266967	,	-0.813238377	),
  (	58	,	5.01765079	,	-0.731158838	),
  (	58	,	4.988567215	,	-0.667641655	),
  (	58	,	4.814842832	,	-0.632471632	),
  (	58	,	5.104522939	,	-0.470993469	),
  (	58	,	5.089032822	,	-0.380075498	),
  (	58	,	5.458571229	,	-0.661714565	),
  (	58	,	5.483788617	,	-0.458966323	),
  (	58	,	5.451072763	,	-0.449970094	),
  (	58	,	5.655679394	,	-0.456782027	),
  (	58	,	5.821987639	,	-0.367813949	),
  (	58	,	5.649848399	,	-0.350532798	),
  (	58	,	5.60781968	,	-0.170164622	),
  (	58	,	5.377375326	,	-0.171960681	),
  (	59	,	0.831856624	,	0.20721348	),
  (	59	,	0.81330053	,	0.230153401	),
  (	59	,	0.539567026	,	0.452661011	),
  (	59	,	0.592421255	,	0.449989266	),
  (	59	,	0.777081529	,	0.360733629	),
  (	59	,	0.73638452	,	0.439614144	),
  (	59	,	0.79369681	,	0.461855831	),
  (	59	,	1.262390584	,	0.568767053	),
  (	59	,	1.154648076	,	0.59269941	),
  (	59	,	1.388681383	,	0.746859535	),
  (	59	,	1.270398182	,	0.850681142	),
  (	59	,	1.142591544	,	0.986222155	),
  (	59	,	1.397906876	,	1.093513264	),
  (	59	,	0.474237256	,	0.57058776	),
  (	59	,	0.623237911	,	0.722489655	),
  (	59	,	0.506854404	,	0.65016854	),
  (	59	,	0.51731006	,	0.858783018	),
  (	59	,	0.159068754	,	1.052890844	),
  (	59	,	0.132352709	,	1.046805159	),
  (	59	,	0.817320278	,	1.118016516	),
  (	59	,	1.206029825	,	1.121575523	),
  (	59	,	1.494179831	,	1.146637676	),
  (	59	,	1.001858463	,	1.104732889	),
  (	59	,	0.986205303	,	1.17287544	),
  (	59	,	0.561456094	,	1.019684147	),
  (	59	,	0.25534497	,	1.158055696	),
  (	59	,	0.020536104	,	1.172278471	),
  (	59	,	0.398111877	,	1.226339524	),
  (	59	,	1.091245403	,	1.511900785	),
  (	59	,	2.480485927	,	0.142908967	),
  (	59	,	2.256254102	,	0.168521158	),
  (	59	,	2.299173902	,	0.211352409	),
  (	59	,	2.558601773	,	0.206126275	),
  (	59	,	2.097834071	,	0.302093391	),
  (	59	,	2.183995821	,	0.419266124	),
  (	59	,	2.139995185	,	0.445144795	),
  (	59	,	2.693173158	,	0.403267695	),
  (	59	,	2.756995409	,	0.565130835	),
  (	59	,	2.71880877	,	0.591808129	),
  (	59	,	2.714735684	,	0.719574309	),
  (	59	,	3.032868398	,	0.95618632	),
  (	59	,	2.841309173	,	0.987546943	),
  (	59	,	3.006632172	,	1.078264799	),
  (	59	,	1.886871341	,	0.421117871	),
  (	59	,	1.939750127	,	0.482373412	),
  (	59	,	1.911294486	,	0.713551352	),
  (	59	,	1.991970942	,	0.805994048	),
  (	59	,	1.735028442	,	0.99235231	),
  (	59	,	1.772549095	,	1.037455969	),
  (	59	,	2.261799298	,	0.932031009	),
  (	59	,	2.709848509	,	1.199868848	),
  (	59	,	2.100273864	,	1.030574633	),
  (	59	,	2.178540308	,	1.090956722	),
  (	59	,	1.967324621	,	1.19494578	),
  (	59	,	1.838521501	,	1.235835984	),
  (	59	,	2.508469019	,	1.260217699	),
  (	59	,	3.910497963	,	0.252134675	),
  (	59	,	3.914749757	,	0.286026263	),
  (	59	,	4.109858289	,	0.322264814	),
  (	59	,	4.007311166	,	0.359059739	),
  (	59	,	3.842919101	,	0.286545534	),
  (	59	,	3.635584061	,	0.312988229	),
  (	59	,	3.963627479	,	0.45903983	),
  (	59	,	4.240279248	,	0.635733806	),
  (	59	,	4.567387587	,	0.60556119	),
  (	59	,	4.712113582	,	0.794144692	),
  (	59	,	4.5672533	,	0.842296437	),
  (	59	,	4.184263594	,	0.639557989	),
  (	59	,	4.098775942	,	0.639432832	),
  (	59	,	4.545522415	,	0.932362687	),
  (	59	,	3.582456671	,	0.392622199	),
  (	59	,	3.60507171	,	0.717128688	),
  (	59	,	3.360526256	,	0.65479682	),
  (	59	,	3.429007171	,	0.790088382	),
  (	59	,	3.211957526	,	0.709650079	),
  (	59	,	3.261950461	,	0.972369016	),
  (	59	,	3.348052189	,	1.095738515	),
  (	59	,	3.880350923	,	0.804870155	),
  (	59	,	3.933321125	,	1.050767343	),
  (	59	,	4.330290233	,	1.061565514	),
  (	59	,	4.091262551	,	1.209228461	),
  (	59	,	4.633724702	,	1.259342005	),
  (	59	,	3.584477908	,	1.131363045	),
  (	59	,	3.520882827	,	1.372598155	),
  (	59	,	5.51776197	,	0.096043192	),
  (	59	,	5.499798706	,	0.337357602	),
  (	59	,	5.668058979	,	0.353698697	),
  (	59	,	5.406518536	,	0.276426842	),
  (	59	,	5.348019244	,	0.373667826	),
  (	59	,	5.218626351	,	0.290331083	),
  (	59	,	5.253844309	,	0.297880139	),
  (	59	,	5.526167026	,	0.544274333	),
  (	59	,	5.406118334	,	0.529425016	),
  (	59	,	5.415069331	,	0.563867202	),
  (	59	,	5.901131508	,	0.694286152	),
  (	59	,	6.112545884	,	0.666400127	),
  (	59	,	5.979337301	,	0.73222467	),
  (	59	,	5.961067036	,	0.777479246	),
  (	59	,	5.906549533	,	0.988293127	),
  (	59	,	5.251893415	,	0.521733964	),
  (	59	,	4.948970754	,	0.487104434	),
  (	59	,	5.025530164	,	0.545998984	),
  (	59	,	4.995861125	,	0.554029233	),
  (	59	,	5.303161404	,	0.588669408	),
  (	59	,	5.221745191	,	0.632692302	),
  (	59	,	5.315035342	,	0.710908145	),
  (	59	,	5.263217714	,	0.927947208	),
  (	59	,	4.886400611	,	0.910996134	),
  (	59	,	4.960004134	,	1.009051407	),
  (	59	,	5.482863051	,	0.784084065	),
  (	59	,	5.444646582	,	0.834821369	),
  (	59	,	5.482193396	,	0.885378336	),
  (	59	,	5.593817626	,	0.862005409	),
  (	59	,	5.614506949	,	0.923254196	),
  (	59	,	5.36449676	,	0.978575189	),
  (	59	,	5.581830504	,	1.023172636	),
  (	59	,	5.73727121	,	0.988051974	),
  (	59	,	5.983785877	,	1.076816478	),
  (	59	,	6.224772804	,	1.165569698	),
  (	59	,	5.740025811	,	1.140063143	),
  (	59	,	6.085189208	,	1.295580946	),
  (	59	,	5.323697253	,	1.202191565	),
  (	59	,	5.167517068	,	1.210157313	),
  (	59	,	4.958600665	,	1.138965016	),
  (	59	,	5.521743585	,	1.36356628	),
  (	59	,	5.876107353	,	1.375066989	),
  (	59	,	4.842195762	,	1.353451665	),
  (	59	,	0.035153872	,	-0.585196697	),
  (	59	,	0.070474842	,	-0.5488462	),
  (	59	,	0.040811601	,	-0.488482506	),
  (	59	,	6.28084948	,	-0.514613882	),
  (	59	,	6.114140314	,	-0.471009347	),
  (	59	,	6.02181175	,	-0.439207456	),
  (	59	,	6.241977285	,	-0.251356169	),
  (	59	,	6.185710099	,	-0.227941005	),
  (	59	,	0.443961118	,	-0.197685	),
  (	59	,	0.408925476	,	-0.122625394	),
  (	59	,	0.539634123	,	-0.071627281	),
  (	59	,	0.688086735	,	-0.059279674	),
  (	59	,	0.703539752	,	-0.012156519	),
  (	59	,	0.211202377	,	0.092025716	),
  (	59	,	5.764315395	,	0.010552988	),
  (	59	,	5.681781644	,	0.022430905	),
  (	59	,	5.87577454	,	0.076689608	),
  (	59	,	5.760164834	,	0.117241637	),
  (	59	,	5.76462034	,	0.144114609	),
  (	59	,	5.9379727	,	0.253942095	),
  (	59	,	6.204401408	,	0.126541067	),
  (	59	,	0.323437129	,	0.281579119	),
  (	59	,	6.068122889	,	0.307076448	),
  (	59	,	6.142136229	,	0.439247415	),
  (	59	,	0.009576755	,	0.472553043	),
  (	59	,	0.081329931	,	0.550078516	),
  (	59	,	6.172516419	,	0.584641248	),
  (	59	,	1.538307683	,	-0.656789445	),
  (	59	,	1.675219218	,	-0.446418502	),
  (	59	,	1.616950293	,	-0.473939558	),
  (	59	,	1.5266886	,	-0.40093239	),
  (	59	,	1.775978508	,	-0.36678728	),
  (	59	,	1.729536099	,	-0.325674506	),
  (	59	,	1.493271717	,	-0.39049383	),
  (	59	,	1.422431092	,	-0.343752112	),
  (	59	,	1.287677301	,	-0.292180674	),
  (	59	,	1.288538861	,	-0.286538541	),
  (	59	,	1.259004018	,	-0.284998565	),
  (	59	,	1.547798595	,	-0.205495068	),
  (	59	,	1.418207339	,	-0.180275421	),
  (	59	,	1.472429667	,	-0.103644679	),
  (	59	,	1.942258188	,	-0.240017334	),
  (	59	,	2.051531015	,	-0.160281313	),
  (	59	,	2.062967337	,	-0.094744132	),
  (	59	,	1.895736343	,	-0.180052295	),
  (	59	,	1.834322499	,	-0.14672632	),
  (	59	,	1.930433782	,	-0.10442111	),
  (	59	,	2.295292852	,	-0.035750135	),
  (	59	,	1.850430024	,	-0.092921155	),
  (	59	,	1.928842071	,	0.00309114	),
  (	59	,	1.792588785	,	-0.009462706	),
  (	59	,	1.687120871	,	-0.026310645	),
  (	59	,	2.01404816	,	0.063261907	),
  (	59	,	2.074863412	,	0.154674885	),
  (	59	,	1.89604836	,	0.211458953	),
  (	59	,	1.239571238	,	-0.148415072	),
  (	59	,	1.259320989	,	-0.099060906	),
  (	59	,	1.066304732	,	-0.223265651	),
  (	59	,	1.045025541	,	-0.2194697	),
  (	59	,	1.094309842	,	-0.153934544	),
  (	59	,	1.330415398	,	-0.053052522	),
  (	59	,	1.28650478	,	0.008152964	),
  (	59	,	0.87752939	,	0.064148761	),
  (	59	,	1.086583059	,	0.233842125	),
  (	59	,	1.167099259	,	0.195690355	),
  (	59	,	1.213701086	,	0.279832046	),
  (	59	,	1.646120065	,	0.089031529	),
  (	59	,	1.592493805	,	0.072581988	),
  (	59	,	1.592479797	,	0.094596189	),
  (	59	,	1.555381768	,	0.165968495	),
  (	59	,	1.565939915	,	0.223547045	),
  (	59	,	1.658369241	,	0.255708455	),
  (	59	,	1.513019091	,	0.276154163	),
  (	59	,	1.633962563	,	0.312522511	),
  (	59	,	1.797682879	,	0.411926684	),
  (	59	,	1.812131512	,	0.442892372	),
  (	59	,	1.343571596	,	0.378819759	),
  (	59	,	1.712395792	,	0.566442725	),
  (	59	,	1.471084939	,	0.469917968	),
  (	59	,	1.471089334	,	0.469913653	),
  (	59	,	1.416516514	,	0.543549771	),
  (	59	,	1.548899886	,	0.553273715	),
  (	59	,	3.243516402	,	-0.433553944	),
  (	59	,	3.020583007	,	-0.510724013	),
  (	59	,	3.35292066	,	-0.48167288	),
  (	59	,	3.27375753	,	-0.413580387	),
  (	59	,	3.251523774	,	-0.2026468	),
  (	59	,	3.102485139	,	-0.093084418	),
  (	59	,	3.554682929	,	-0.230633824	),
  (	59	,	3.558386218	,	-0.094171338	),
  (	59	,	3.510545781	,	-0.090132926	),
  (	59	,	3.302112571	,	-0.101788324	),
  (	59	,	3.223068507	,	-0.013740961	),
  (	59	,	3.500080206	,	0.089962553	),
  (	59	,	3.343979406	,	0.166443794	),
  (	59	,	3.466762114	,	0.19776814	),
  (	59	,	3.530866483	,	0.18881066	),
  (	59	,	2.854905285	,	-0.240121997	),
  (	59	,	2.665689403	,	-0.14693516	),
  (	59	,	2.662171675	,	-0.146750111	),
  (	59	,	2.730279847	,	-0.123201424	),
  (	59	,	2.720269686	,	-0.071104788	),
  (	59	,	3.029720106	,	0.053397477	),
  (	59	,	2.467023979	,	-0.089316173	),
  (	59	,	2.72818331	,	0.153319719	),
  (	59	,	3.200190728	,	0.179110605	),
  (	59	,	3.30290954	,	0.298266532	),
  (	59	,	3.193305555	,	0.451517844	),
  (	59	,	3.038182551	,	0.484877117	),
  (	59	,	3.061130526	,	0.5540767	),
  (	59	,	4.756446743	,	-0.536319871	),
  (	59	,	4.706502021	,	-0.501941402	),
  (	59	,	4.72929293	,	-0.425175212	),
  (	59	,	4.984924357	,	-0.433680372	),
  (	59	,	4.956784294	,	-0.404460033	),
  (	59	,	4.948015476	,	-0.372801917	),
  (	59	,	4.998999772	,	-0.273327217	),
  (	59	,	4.844155931	,	-0.326890211	),
  (	59	,	4.778782278	,	-0.35583745	),
  (	59	,	4.916252464	,	-0.176715762	),
  (	59	,	4.696319783	,	-0.275989489	),
  (	59	,	4.658337846	,	-0.257016407	),
  (	59	,	4.73910667	,	-0.145282186	),
  (	59	,	5.255124204	,	-0.012394083	),
  (	59	,	4.915183552	,	-0.016787332	),
  (	59	,	4.989625588	,	0.031734941	),
  (	59	,	5.173449506	,	0.132874635	),
  (	59	,	5.089391584	,	0.227315452	),
  (	59	,	5.15348672	,	0.241128224	),
  (	59	,	5.136898274	,	0.28733182	),
  (	59	,	4.318743364	,	-0.253960058	),
  (	59	,	4.522708867	,	0.021126595	),
  (	59	,	4.405110059	,	0.23144741	),
  (	59	,	4.386780742	,	0.274801017	),
  (	59	,	4.682861844	,	0.106498235	),
  (	59	,	4.824293127	,	0.140184177	),
  (	59	,	4.957174179	,	0.315979566	),
  (	59	,	4.925712885	,	0.337347574	),
  (	59	,	4.466535015	,	0.237454076	),
  (	59	,	4.597443699	,	0.28478819	),
  (	59	,	4.661833457	,	0.358935245	),
  (	59	,	4.454816111	,	0.395001825	),
  (	59	,	4.532664864	,	0.503054811	),
  (	59	,	4.694267156	,	0.392074441	),
  (	59	,	4.746530946	,	0.455488258	),
  (	59	,	4.746534635	,	0.455557781	),
  (	59	,	4.639765262	,	0.424609341	),
  (	59	,	4.58551656	,	0.54381398	),
  (	59	,	0.425326721	,	-1.479505746	),
  (	59	,	1.138695564	,	-1.423823033	),
  (	59	,	1.12570424	,	-1.399991458	),
  (	59	,	0.916210412	,	-1.367501038	),
  (	59	,	0.591143821	,	-1.182398456	),
  (	59	,	0.840173729	,	-1.000448107	),
  (	59	,	0.927573252	,	-0.879263089	),
  (	59	,	1.42719533	,	-0.714587697	),
  (	59	,	0.982901611	,	-0.826579826	),
  (	59	,	1.022698576	,	-0.704361766	),
  (	59	,	1.23549194	,	-0.536968539	),
  (	59	,	1.050160932	,	-0.532162588	),
  (	59	,	0.004693378	,	-0.851893782	),
  (	59	,	0.684937781	,	-0.603530911	),
  (	59	,	0.870840613	,	-0.421026779	),
  (	59	,	0.988106619	,	-0.512046985	),
  (	59	,	0.866946593	,	-0.323937136	),
  (	59	,	0.492487189	,	-0.295477512	),
  (	59	,	0.637064736	,	-0.267761988	),
  (	59	,	0.699018158	,	-0.164993288	),
  (	59	,	2.200446609	,	-1.412192217	),
  (	59	,	2.800625265	,	-1.392480329	),
  (	59	,	2.480578601	,	-1.164161164	),
  (	59	,	2.047319232	,	-1.052129078	),
  (	59	,	2.072076873	,	-1.000118906	),
  (	59	,	2.422923126	,	-1.019069277	),
  (	59	,	2.538573507	,	-0.963661484	),
  (	59	,	2.186904276	,	-1.011823053	),
  (	59	,	2.234379237	,	-0.928720916	),
  (	59	,	2.194394915	,	-0.909728314	),
  (	59	,	2.415418666	,	-0.826209353	),
  (	59	,	2.300840844	,	-0.805563427	),
  (	59	,	2.357811435	,	-0.753528353	),
  (	59	,	2.996672078	,	-0.927814172	),
  (	59	,	2.833569704	,	-1.03539627	),
  (	59	,	2.699238561	,	-0.979297075	),
  (	59	,	2.706474297	,	-0.83250568	),
  (	59	,	3.033459719	,	-0.826808353	),
  (	59	,	3.02290418	,	-0.705737613	),
  (	59	,	2.503410418	,	-0.855306183	),
  (	59	,	2.580149174	,	-0.806231095	),
  (	59	,	2.698583098	,	-0.727251936	),
  (	59	,	2.451541952	,	-0.736445256	),
  (	59	,	2.410770374	,	-0.76119333	),
  (	59	,	2.407164462	,	-0.685194821	),
  (	59	,	2.518360866	,	-0.561625759	),
  (	59	,	2.828455129	,	-0.553057493	),
  (	59	,	1.903534372	,	-0.816365677	),
  (	59	,	2.090160763	,	-0.789165025	),
  (	59	,	2.146751817	,	-0.814096639	),
  (	59	,	2.148993152	,	-0.807463015	),
  (	59	,	2.271492572	,	-0.788732952	),
  (	59	,	2.224245359	,	-0.808638866	),
  (	59	,	2.314088724	,	-0.734605013	),
  (	59	,	2.075963947	,	-0.765240216	),
  (	59	,	2.058059066	,	-0.748539437	),
  (	59	,	2.156282963	,	-0.560960467	),
  (	59	,	1.64566676	,	-0.650199957	),
  (	59	,	1.675587639	,	-0.640664659	),
  (	59	,	2.047463103	,	-0.61511033	),
  (	59	,	2.025274466	,	-0.62939909	),
  (	59	,	1.886832015	,	-0.637818975	),
  (	59	,	2.048967577	,	-0.581001656	),
  (	59	,	1.891969131	,	-0.477457742	),
  (	59	,	1.923855174	,	-0.470607026	),
  (	59	,	2.019356593	,	-0.459921041	),
  (	59	,	1.977295727	,	-0.431280981	),
  (	59	,	1.982290969	,	-0.40969284	),
  (	59	,	1.953527702	,	-0.398968416	),
  (	59	,	2.227373563	,	-0.561285141	),
  (	59	,	2.517644061	,	-0.441507353	),
  (	59	,	2.50206937	,	-0.399043468	),
  (	59	,	2.483647756	,	-0.362139698	),
  (	59	,	2.408455143	,	-0.344655646	),
  (	59	,	1.978011266	,	-0.338821	),
  (	59	,	2.350693435	,	-0.281543328	),
  (	59	,	2.364768907	,	-0.008415882	),
  (	59	,	3.935067776	,	-1.452590109	),
  (	59	,	3.947848153	,	-1.449294065	),
  (	59	,	4.109857841	,	-1.327885815	),
  (	59	,	3.989473221	,	-1.223118611	),
  (	59	,	4.214653099	,	-1.26362558	),
  (	59	,	3.968435052	,	-1.170839449	),
  (	59	,	3.459308497	,	-1.155873972	),
  (	59	,	3.578683972	,	-1.127073429	),
  (	59	,	4.587545716	,	-0.993458704	),
  (	59	,	4.569305588	,	-0.883667039	),
  (	59	,	4.247142876	,	-0.969377501	),
  (	59	,	4.435221568	,	-0.912528674	),
  (	59	,	4.64563156	,	-0.745765422	),
  (	59	,	4.144969802	,	-0.853683852	),
  (	59	,	4.23806107	,	-0.717691082	),
  (	59	,	3.99756312	,	-0.758957299	),
  (	59	,	4.359337993	,	-0.64957116	),
  (	59	,	3.5907304	,	-0.990788506	),
  (	59	,	3.329876118	,	-0.980461592	),
  (	59	,	3.461809438	,	-0.884880229	),
  (	59	,	3.707002729	,	-0.898927677	),
  (	59	,	3.783858719	,	-0.805204302	),
  (	59	,	3.753161783	,	-0.751517632	),
  (	59	,	3.593927825	,	-0.734217041	),
  (	59	,	3.577084401	,	-0.699040828	),
  (	59	,	3.293015494	,	-0.779716328	),
  (	59	,	3.478580459	,	-0.767587218	),
  (	59	,	3.52091785	,	-0.724268952	),
  (	59	,	3.452021236	,	-0.737106221	),
  (	59	,	3.202868973	,	-0.798032151	),
  (	59	,	3.368258265	,	-0.692556434	),
  (	59	,	3.572245667	,	-0.515943789	),
  (	59	,	3.955581421	,	-0.539633439	),
  (	59	,	3.93619688	,	-0.489754129	),
  (	59	,	4.166998952	,	-0.338297843	),
  (	59	,	4.050286443	,	-0.291761792	),
  (	59	,	3.665174172	,	-0.436525181	),
  (	59	,	5.869484879	,	-1.229271169	),
  (	59	,	5.715962104	,	-1.129451401	),
  (	59	,	5.785126712	,	-1.040852298	),
  (	59	,	5.298462905	,	-0.915357859	),
  (	59	,	5.499332583	,	-0.894732504	),
  (	59	,	6.140298184	,	-1.02059215	),
  (	59	,	6.026317398	,	-0.889245711	),
  (	59	,	5.920953049	,	-0.708455671	),
  (	59	,	5.551153515	,	-0.70285946	),
  (	59	,	5.612922845	,	-0.660249459	),
  (	59	,	5.00441462	,	-0.842980638	),
  (	59	,	5.239501426	,	-0.787368507	),
  (	59	,	4.883602588	,	-0.836181442	),
  (	59	,	4.842998643	,	-0.824155434	),
  (	59	,	4.760795061	,	-0.721857249	),
  (	59	,	5.12315911	,	-0.698736605	),
  (	59	,	5.081104344	,	-0.486354273	),
  (	59	,	5.598184196	,	-0.395649484	),
  (	59	,	5.302871443	,	-0.47183639	),
  (	59	,	5.437429863	,	-0.375492988	),
  (	59	,	5.366448251	,	-0.324347595	),
  (	59	,	5.135875707	,	-0.318193718	),
  (	59	,	5.48765948	,	-0.27980296	),
  (	59	,	5.515585649	,	-0.101632438	),
  (	60	,	0.681251982	,	0.120375924	),
  (	60	,	0.767107795	,	0.319946254	),
  (	60	,	1.05076055	,	0.317541851	),
  (	60	,	0.817805407	,	0.312065702	),
  (	60	,	0.892017221	,	0.363088262	),
  (	60	,	1.003208543	,	0.388228454	),
  (	60	,	1.034385315	,	0.404488318	),
  (	60	,	0.580574571	,	0.266681389	),
  (	60	,	0.569977541	,	0.340341786	),
  (	60	,	0.505495311	,	0.411500744	),
  (	60	,	0.656856689	,	0.440428477	),
  (	60	,	0.55336163	,	0.448627553	),
  (	60	,	0.649292527	,	0.522413273	),
  (	60	,	1.149909581	,	0.366201551	),
  (	60	,	1.095122083	,	0.586198677	),
  (	60	,	1.425992797	,	0.600249453	),
  (	60	,	1.286547164	,	0.769000396	),
  (	60	,	0.862905651	,	0.685622125	),
  (	60	,	0.999790174	,	0.767302921	),
  (	60	,	1.019475361	,	0.849107475	),
  (	60	,	1.46863639	,	0.949958012	),
  (	60	,	1.511924064	,	0.979394428	),
  (	60	,	0.679132242	,	0.651220176	),
  (	60	,	0.684851448	,	0.676015529	),
  (	60	,	0.27446858	,	0.721607864	),
  (	60	,	0.081610341	,	0.764299263	),
  (	60	,	0.201503547	,	0.782980181	),
  (	60	,	0.077307565	,	0.897676441	),
  (	60	,	0.073959829	,	1.07395627	),
  (	60	,	0.01844661	,	1.087124792	),
  (	60	,	0.898658581	,	0.857315733	),
  (	60	,	0.854336146	,	0.99729189	),
  (	60	,	0.93221968	,	0.959492275	),
  (	60	,	0.602144234	,	1.010543192	),
  (	60	,	1.121969254	,	1.009849942	),
  (	60	,	0.971765142	,	1.046663584	),
  (	60	,	1.193430467	,	1.265851986	),
  (	60	,	0.517292682	,	1.076828262	),
  (	60	,	0.407659869	,	1.018003274	),
  (	60	,	0.719204659	,	1.183759248	),
  (	60	,	0.53613778	,	1.132742742	),
  (	60	,	0.280646871	,	1.074773944	),
  (	60	,	1.260317545	,	1.325408102	),
  (	60	,	0.836461528	,	1.421932191	),
  (	60	,	2.517823356	,	0.286895974	),
  (	60	,	2.219281825	,	0.248024188	),
  (	60	,	2.100961559	,	0.28719871	),
  (	60	,	2.196333359	,	0.319954229	),
  (	60	,	2.362312684	,	0.562908792	),
  (	60	,	2.340947337	,	0.701643375	),
  (	60	,	2.857835726	,	0.594013866	),
  (	60	,	2.616250965	,	0.517402245	),
  (	60	,	2.788684615	,	0.661648854	),
  (	60	,	2.920444049	,	0.633715411	),
  (	60	,	2.993014024	,	0.974780219	),
  (	60	,	1.950138709	,	0.353560039	),
  (	60	,	1.902201174	,	0.48690161	),
  (	60	,	2.00819097	,	0.66923724	),
  (	60	,	1.787598313	,	0.569089375	),
  (	60	,	1.739474218	,	0.687486865	),
  (	60	,	1.592851653	,	0.750153317	),
  (	60	,	1.583060244	,	0.87101316	),
  (	60	,	1.997948446	,	0.85126076	),
  (	60	,	2.342352066	,	0.796417058	),
  (	60	,	2.432641123	,	0.817116267	),
  (	60	,	2.183569786	,	1.007812114	),
  (	60	,	2.979511562	,	1.12278345	),
  (	60	,	2.540509149	,	1.208414322	),
  (	60	,	2.800389893	,	1.194561497	),
  (	60	,	2.425432464	,	1.273146653	),
  (	60	,	1.747437405	,	1.361282521	),
  (	60	,	3.769974257	,	0.14388273	),
  (	60	,	3.842814033	,	0.236216619	),
  (	60	,	4.086205921	,	0.28133046	),
  (	60	,	4.256313653	,	0.328252816	),
  (	60	,	3.735310808	,	0.330069462	),
  (	60	,	3.807167681	,	0.388516092	),
  (	60	,	3.884526537	,	0.417344225	),
  (	60	,	4.028257128	,	0.528609857	),
  (	60	,	3.795336978	,	0.554861778	),
  (	60	,	4.325028597	,	0.38738465	),
  (	60	,	4.370355462	,	0.469782759	),
  (	60	,	4.409788751	,	0.520221936	),
  (	60	,	4.595096035	,	0.71982656	),
  (	60	,	4.203289592	,	0.639343492	),
  (	60	,	4.095283491	,	0.880048194	),
  (	60	,	3.564764709	,	0.42958273	),
  (	60	,	3.635378981	,	0.500007719	),
  (	60	,	3.856043394	,	0.706149603	),
  (	60	,	3.831895758	,	0.761702577	),
  (	60	,	3.447248264	,	0.671939356	),
  (	60	,	3.594994908	,	0.908694776	),
  (	60	,	3.353919709	,	1.052780668	),
  (	60	,	3.322946743	,	1.094546909	),
  (	60	,	3.943479701	,	0.831726442	),
  (	60	,	4.134828004	,	0.966504954	),
  (	60	,	4.155082331	,	0.974366518	),
  (	60	,	3.816417241	,	0.861646369	),
  (	60	,	3.807068765	,	0.966876176	),
  (	60	,	4.025695849	,	1.082921658	),
  (	60	,	4.292568367	,	1.076810699	),
  (	60	,	4.025773277	,	1.10550565	),
  (	60	,	4.061914435	,	1.120662481	),
  (	60	,	4.252303974	,	1.280986674	),
  (	60	,	3.207651352	,	1.225217909	),
  (	60	,	3.164587362	,	1.342247067	),
  (	60	,	4.536205016	,	1.398644119	),
  (	60	,	5.368196017	,	0.190170352	),
  (	60	,	5.404993197	,	0.232392809	),
  (	60	,	5.683444912	,	0.188918894	),
  (	60	,	5.690413827	,	0.501640944	),
  (	60	,	5.323267452	,	0.236458145	),
  (	60	,	5.406935689	,	0.380788089	),
  (	60	,	5.886870094	,	0.467105409	),
  (	60	,	5.782231321	,	0.465547363	),
  (	60	,	5.879323087	,	0.694815316	),
  (	60	,	6.101620081	,	0.729086848	),
  (	60	,	5.999775268	,	0.647113472	),
  (	60	,	6.011258497	,	0.686066874	),
  (	60	,	6.06696479	,	0.759969302	),
  (	60	,	6.228865637	,	0.817381688	),
  (	60	,	5.709364774	,	0.674545045	),
  (	60	,	5.582303551	,	0.667369664	),
  (	60	,	6.263828597	,	1.002031372	),
  (	60	,	5.160692072	,	0.565953334	),
  (	60	,	5.165553863	,	0.596252511	),
  (	60	,	5.130418075	,	0.644803706	),
  (	60	,	5.364007263	,	0.636254747	),
  (	60	,	5.408580845	,	0.708244559	),
  (	60	,	5.408581095	,	0.708248939	),
  (	60	,	5.213318479	,	0.645697391	),
  (	60	,	5.305847405	,	0.795506136	),
  (	60	,	5.233111332	,	0.798879288	),
  (	60	,	5.23274233	,	0.908543517	),
  (	60	,	4.921637659	,	0.554260867	),
  (	60	,	4.937573962	,	0.637727354	),
  (	60	,	4.86608766	,	0.601406967	),
  (	60	,	4.914047786	,	0.723296032	),
  (	60	,	4.769461562	,	0.676726006	),
  (	60	,	4.951426336	,	0.852741073	),
  (	60	,	5.14299695	,	0.959493349	),
  (	60	,	5.630169505	,	0.924293363	),
  (	60	,	5.316325595	,	0.96685792	),
  (	60	,	5.859985667	,	1.089424837	),
  (	60	,	5.839057113	,	1.096144699	),
  (	60	,	5.813579764	,	1.104635075	),
  (	60	,	5.693646992	,	1.090142414	),
  (	60	,	6.192298577	,	1.314110371	),
  (	60	,	5.328457012	,	1.11666545	),
  (	60	,	5.525642785	,	1.246706052	),
  (	60	,	5.921993423	,	1.315487184	),
  (	60	,	6.262577474	,	-0.557134329	),
  (	60	,	0.033962894	,	-0.392852724	),
  (	60	,	0.208223334	,	-0.31522558	),
  (	60	,	0.018898684	,	-0.288493496	),
  (	60	,	6.227613129	,	-0.207899862	),
  (	60	,	6.251960999	,	-0.157026001	),
  (	60	,	0.368012367	,	-0.120683269	),
  (	60	,	0.524292895	,	0.054022006	),
  (	60	,	0.131072354	,	-0.0690699	),
  (	60	,	0.110841779	,	0.033852472	),
  (	60	,	0.483736515	,	0.192739977	),
  (	60	,	0.41851659	,	0.304280449	),
  (	60	,	5.866280402	,	-0.23613035	),
  (	60	,	5.833215509	,	-0.157779952	),
  (	60	,	5.834235121	,	-0.094021502	),
  (	60	,	6.000369564	,	-0.087055907	),
  (	60	,	6.170407464	,	-0.021775731	),
  (	60	,	6.260391063	,	0.001906154	),
  (	60	,	5.734167637	,	-0.074644668	),
  (	60	,	5.651783673	,	-0.069522385	),
  (	60	,	5.805936103	,	0.202879849	),
  (	60	,	6.195568928	,	0.168899423	),
  (	60	,	6.054031518	,	0.368856235	),
  (	60	,	6.238062406	,	0.503397734	),
  (	60	,	1.744067226	,	-0.531833624	),
  (	60	,	1.462842926	,	-0.577336066	),
  (	60	,	1.576110574	,	-0.443626027	),
  (	60	,	1.74360068	,	-0.413568004	),
  (	60	,	1.87429154	,	-0.28334552	),
  (	60	,	1.695692682	,	-0.304838259	),
  (	60	,	1.790544303	,	-0.298181986	),
  (	60	,	1.739177689	,	-0.294501933	),
  (	60	,	1.7042326	,	-0.229478781	),
  (	60	,	1.393622042	,	-0.477678172	),
  (	60	,	1.331992689	,	-0.456452833	),
  (	60	,	1.321003305	,	-0.397846768	),
  (	60	,	1.24385185	,	-0.371467166	),
  (	60	,	1.299156356	,	-0.248395139	),
  (	60	,	1.337851141	,	-0.229031146	),
  (	60	,	1.677012044	,	-0.226228095	),
  (	60	,	1.638146888	,	-0.157704215	),
  (	60	,	1.594581393	,	-0.178763775	),
  (	60	,	1.536451489	,	-0.157807056	),
  (	60	,	1.638406847	,	-0.085782137	),
  (	60	,	1.954161459	,	-0.201705538	),
  (	60	,	1.960739197	,	-0.180234806	),
  (	60	,	1.88984191	,	-0.19637206	),
  (	60	,	1.961001669	,	-0.131782605	),
  (	60	,	2.206059614	,	0.036689208	),
  (	60	,	1.681111662	,	-0.016535236	),
  (	60	,	1.78486489	,	0.017489027	),
  (	60	,	1.73398742	,	0.107082736	),
  (	60	,	2.007637082	,	0.091299046	),
  (	60	,	1.884327433	,	0.098692563	),
  (	60	,	1.91897114	,	0.12466081	),
  (	60	,	2.143597898	,	0.171410922	),
  (	60	,	1.863607621	,	0.085704825	),
  (	60	,	1.866738764	,	0.130393302	),
  (	60	,	1.857255449	,	0.160320923	),
  (	60	,	1.846986048	,	0.159495063	),
  (	60	,	1.437252139	,	-0.060151996	),
  (	60	,	1.358397816	,	-0.043472158	),
  (	60	,	1.488301667	,	0.005898355	),
  (	60	,	1.421499437	,	0.009079924	),
  (	60	,	1.137461797	,	0.106997263	),
  (	60	,	1.162178757	,	0.149927554	),
  (	60	,	1.171084962	,	0.257276356	),
  (	60	,	1.563848101	,	0.03206262	),
  (	60	,	1.639167826	,	0.105872548	),
  (	60	,	1.706755049	,	0.196373274	),
  (	60	,	1.471844384	,	0.156239355	),
  (	60	,	1.527360221	,	0.172284839	),
  (	60	,	1.513496917	,	0.16618824	),
  (	60	,	1.620822172	,	0.238035672	),
  (	60	,	1.74443429	,	0.226590444	),
  (	60	,	1.842595263	,	0.267660938	),
  (	60	,	1.790816524	,	0.234103354	),
  (	60	,	1.833746145	,	0.280630961	),
  (	60	,	1.855747812	,	0.395097002	),
  (	60	,	1.68227397	,	0.407133972	),
  (	60	,	1.743373734	,	0.493283441	),
  (	60	,	1.441797336	,	0.268085613	),
  (	60	,	1.431289086	,	0.300874043	),
  (	60	,	1.520064605	,	0.364238543	),
  (	60	,	1.299445163	,	0.417979552	),
  (	60	,	1.624618702	,	0.570606744	),
  (	60	,	1.480497909	,	0.509900885	),
  (	60	,	1.486140408	,	0.547302899	),
  (	60	,	3.105346958	,	-0.538204406	),
  (	60	,	3.321652608	,	-0.227152215	),
  (	60	,	3.321634367	,	-0.227134399	),
  (	60	,	3.378551874	,	-0.203304622	),
  (	60	,	3.517655006	,	-0.020812113	),
  (	60	,	3.724906019	,	-0.01477303	),
  (	60	,	3.795403241	,	0.014468535	),
  (	60	,	3.649761949	,	0.018337692	),
  (	60	,	3.309018575	,	0.032367826	),
  (	60	,	3.671044876	,	0.155245836	),
  (	60	,	3.443568805	,	0.174925021	),
  (	60	,	3.458139461	,	0.201688267	),
  (	60	,	2.787462244	,	-0.217181776	),
  (	60	,	2.861068097	,	0.012861616	),
  (	60	,	2.941018756	,	0.140672702	),
  (	60	,	2.583949658	,	0.042844139	),
  (	60	,	2.673864785	,	0.080540569	),
  (	60	,	2.862443963	,	0.107954233	),
  (	60	,	2.738639953	,	0.170385251	),
  (	60	,	3.092034766	,	0.249307541	),
  (	60	,	3.009368698	,	0.269006234	),
  (	60	,	3.188576415	,	0.47615098	),
  (	60	,	4.707713786	,	-0.643298312	),
  (	60	,	4.760047791	,	-0.589922569	),
  (	60	,	4.685828993	,	-0.606549863	),
  (	60	,	4.78920091	,	-0.595285325	),
  (	60	,	4.833797308	,	-0.520400451	),
  (	60	,	4.571129459	,	-0.51879538	),
  (	60	,	4.589079187	,	-0.458495817	),
  (	60	,	4.877789739	,	-0.373469005	),
  (	60	,	4.88206899	,	-0.367443089	),
  (	60	,	4.805689957	,	-0.329170007	),
  (	60	,	4.842328482	,	-0.254501883	),
  (	60	,	4.614665054	,	-0.271765646	),
  (	60	,	4.421876444	,	-0.356321228	),
  (	60	,	4.617085403	,	-0.190700443	),
  (	60	,	4.739691469	,	-0.082928782	),
  (	60	,	5.084849136	,	-0.242542503	),
  (	60	,	5.235043611	,	-0.17383536	),
  (	60	,	5.210410481	,	-0.149650528	),
  (	60	,	4.934810781	,	-0.170590346	),
  (	60	,	4.851797723	,	-0.017505683	),
  (	60	,	5.107498188	,	0.060116577	),
  (	60	,	5.06095612	,	0.201325826	),
  (	60	,	4.347485024	,	-0.040609175	),
  (	60	,	4.38729738	,	0.017806042	),
  (	60	,	3.934912818	,	-0.002450545	),
  (	60	,	4.119104137	,	0.043881356	),
  (	60	,	4.192503643	,	0.07728082	),
  (	60	,	4.225737114	,	0.148951091	),
  (	60	,	4.810951642	,	0.209959387	),
  (	60	,	4.555136507	,	0.154505731	),
  (	60	,	4.968874166	,	0.242711129	),
  (	60	,	5.029221385	,	0.376198937	),
  (	60	,	4.529489656	,	0.302252751	),
  (	60	,	4.46068325	,	0.445168988	),
  (	60	,	4.73781605	,	0.562528981	),
  (	60	,	4.763668776	,	0.583762913	),
  (	60	,	0.058165487	,	-1.483422601	),
  (	60	,	0.42740396	,	-1.448172238	),
  (	60	,	1.464347706	,	-1.37568057	),
  (	60	,	1.193624877	,	-1.096482281	),
  (	60	,	1.168351422	,	-1.09120023	),
  (	60	,	1.124304388	,	-1.104010949	),
  (	60	,	0.234029581	,	-1.09731179	),
  (	60	,	0.44418731	,	-1.06097884	),
  (	60	,	0.721951769	,	-1.111855267	),
  (	60	,	0.623572272	,	-0.891717812	),
  (	60	,	1.40659934	,	-0.97972734	),
  (	60	,	1.547605683	,	-0.86615306	),
  (	60	,	1.411104668	,	-0.692518261	),
  (	60	,	1.372182835	,	-0.627915368	),
  (	60	,	1.453538598	,	-0.613301038	),
  (	60	,	1.401852827	,	-0.599433253	),
  (	60	,	0.918996789	,	-0.826849546	),
  (	60	,	0.905649845	,	-0.62275589	),
  (	60	,	0.176610389	,	-1.037624709	),
  (	60	,	0.435503236	,	-0.980756601	),
  (	60	,	0.483915113	,	-0.87626285	),
  (	60	,	0.199698129	,	-0.829929111	),
  (	60	,	0.196120429	,	-0.74485809	),
  (	60	,	0.317476894	,	-0.660723842	),
  (	60	,	0.186378717	,	-0.671315151	),
  (	60	,	0.400207261	,	-0.528546888	),
  (	60	,	0.757365326	,	-0.670847967	),
  (	60	,	0.864147977	,	-0.502606389	),
  (	60	,	0.690775778	,	-0.526994866	),
  (	60	,	0.681349719	,	-0.524384551	),
  (	60	,	0.954674104	,	-0.487695095	),
  (	60	,	0.9076398	,	-0.196993795	),
  (	60	,	0.67505874	,	-0.137180948	),
  (	60	,	0.790502941	,	-0.133753367	),
  (	60	,	2.294737171	,	-1.387603272	),
  (	60	,	2.737618205	,	-1.146760122	),
  (	60	,	2.727017454	,	-1.022348543	),
  (	60	,	2.626725779	,	-1.054542963	),
  (	60	,	2.579608511	,	-1.037180692	),
  (	60	,	2.674796822	,	-1.04576753	),
  (	60	,	1.885099433	,	-1.102874821	),
  (	60	,	2.078296843	,	-1.056384199	),
  (	60	,	2.325921105	,	-0.988715614	),
  (	60	,	2.384846849	,	-0.973934837	),
  (	60	,	2.535268229	,	-0.999372001	),
  (	60	,	2.437813388	,	-0.899902594	),
  (	60	,	3.119774611	,	-1.104430138	),
  (	60	,	2.897259568	,	-1.011511304	),
  (	60	,	2.939377761	,	-0.929066053	),
  (	60	,	2.684650969	,	-0.959480584	),
  (	60	,	2.867266691	,	-0.886015119	),
  (	60	,	2.757373233	,	-0.786614209	),
  (	60	,	2.937583447	,	-0.774441182	),
  (	60	,	2.986115346	,	-0.744716231	),
  (	60	,	2.858043093	,	-0.737420967	),
  (	60	,	2.605697555	,	-0.918719493	),
  (	60	,	2.608000079	,	-0.84498518	),
  (	60	,	2.577403126	,	-0.81914758	),
  (	60	,	2.453931874	,	-0.803676597	),
  (	60	,	1.706830662	,	-1.080000278	),
  (	60	,	2.002784841	,	-0.929794339	),
  (	60	,	2.095457274	,	-0.854883387	),
  (	60	,	2.096500067	,	-0.852972964	),
  (	60	,	2.030255752	,	-0.763626662	),
  (	60	,	2.155386068	,	-0.63426529	),
  (	60	,	2.101487049	,	-0.65072317	),
  (	60	,	2.15643877	,	-0.619415028	),
  (	60	,	1.643195175	,	-0.68529514	),
  (	60	,	1.750722234	,	-0.704236346	),
  (	60	,	1.796404673	,	-0.632344807	),
  (	60	,	1.707011062	,	-0.615381974	),
  (	60	,	1.768783176	,	-0.554942297	),
  (	60	,	2.006982421	,	-0.655885231	),
  (	60	,	1.98347266	,	-0.471444465	),
  (	60	,	1.982337589	,	-0.409715651	),
  (	60	,	2.493789212	,	-0.556269116	),
  (	60	,	2.47290371	,	-0.502440567	),
  (	60	,	2.249194316	,	-0.468505	),
  (	60	,	2.194019104	,	-0.459862654	),
  (	60	,	2.114859671	,	-0.344320917	),
  (	60	,	2.189984286	,	-0.306941276	),
  (	60	,	2.207519446	,	-0.260567009	),
  (	60	,	2.335284039	,	-0.318368041	),
  (	60	,	2.396304242	,	-0.215682525	),
  (	60	,	4.454861205	,	-1.50734135	),
  (	60	,	3.897443327	,	-1.277404429	),
  (	60	,	3.98181595	,	-1.270088568	),
  (	60	,	4.378027113	,	-1.176920567	),
  (	60	,	4.430570555	,	-1.104265611	),
  (	60	,	4.263345297	,	-1.185809328	),
  (	60	,	4.047201991	,	-1.12628963	),
  (	60	,	4.169316003	,	-1.050306677	),
  (	60	,	3.503201025	,	-1.259199382	),
  (	60	,	3.416865652	,	-1.247487318	),
  (	60	,	3.455141803	,	-1.22071828	),
  (	60	,	3.629372401	,	-1.211280729	),
  (	60	,	3.90390512	,	-1.151763056	),
  (	60	,	3.642577295	,	-1.180753786	),
  (	60	,	3.23846005	,	-1.192193664	),
  (	60	,	3.862336019	,	-0.970432589	),
  (	60	,	3.811515545	,	-0.959907486	),
  (	60	,	3.996344111	,	-0.839045353	),
  (	60	,	3.959425726	,	-0.856756859	),
  (	60	,	3.911863356	,	-0.835652371	),
  (	60	,	4.675698634	,	-1.050062774	),
  (	60	,	4.551465741	,	-0.986556531	),
  (	60	,	4.572587165	,	-0.912766084	),
  (	60	,	4.277897382	,	-0.962371158	),
  (	60	,	4.617008926	,	-0.74840568	),
  (	60	,	4.42636876	,	-0.741397421	),
  (	60	,	4.37987241	,	-0.66595944	),
  (	60	,	4.467398201	,	-0.665892223	),
  (	60	,	4.478236611	,	-0.649747056	),
  (	60	,	4.507208183	,	-0.566155916	),
  (	60	,	4.208900961	,	-0.66084706	),
  (	60	,	4.083579071	,	-0.784664605	),
  (	60	,	4.177249448	,	-0.631555362	),
  (	60	,	4.312017705	,	-0.648915061	),
  (	60	,	4.37098353	,	-0.578509523	),
  (	60	,	4.488951596	,	-0.530653235	),
  (	60	,	4.385149846	,	-0.497587449	),
  (	60	,	4.296412319	,	-0.518453757	),
  (	60	,	4.253760826	,	-0.444659583	),
  (	60	,	3.265155953	,	-1.122963457	),
  (	60	,	3.261203592	,	-1.113329128	),
  (	60	,	3.280923324	,	-1.108385298	),
  (	60	,	3.195549567	,	-1.09869831	),
  (	60	,	3.376405055	,	-1.053764326	),
  (	60	,	3.610489355	,	-0.877013892	),
  (	60	,	3.57789211	,	-0.871789643	),
  (	60	,	3.27207179	,	-0.986545	),
  (	60	,	3.328463579	,	-0.976460255	),
  (	60	,	3.451267669	,	-0.917467632	),
  (	60	,	3.49484159	,	-0.818207989	),
  (	60	,	3.763998761	,	-0.843341206	),
  (	60	,	3.638809389	,	-0.822542145	),
  (	60	,	3.680273397	,	-0.722975778	),
  (	60	,	3.749823908	,	-0.645827507	),
  (	60	,	3.381429343	,	-0.770624507	),
  (	60	,	3.629567092	,	-0.575868565	),
  (	60	,	3.984267971	,	-0.629917133	),
  (	60	,	3.971974669	,	-0.459592238	),
  (	60	,	3.880354367	,	-0.423267976	),
  (	60	,	3.866399628	,	-0.404103929	),
  (	60	,	3.916071416	,	-0.373979543	),
  (	60	,	4.091923394	,	-0.403908701	),
  (	60	,	4.060831441	,	-0.28989002	),
  (	60	,	3.748111365	,	-0.450519994	),
  (	60	,	3.902467754	,	-0.2076664	),
  (	60	,	4.031141416	,	-0.215892955	),
  (	60	,	5.897513005	,	-1.500404166	),
  (	60	,	5.381267549	,	-1.413105812	),
  (	60	,	6.27246532	,	-1.434136516	),
  (	60	,	6.216374651	,	-1.37516917	),
  (	60	,	6.16680845	,	-1.350628744	),
  (	60	,	5.772967035	,	-1.328526512	),
  (	60	,	5.69623806	,	-1.239339654	),
  (	60	,	5.738605586	,	-1.08013213	),
  (	60	,	5.761355248	,	-0.975352598	),
  (	60	,	4.767188079	,	-1.285857401	),
  (	60	,	4.989430485	,	-1.200011971	),
  (	60	,	5.237661799	,	-1.168510868	),
  (	60	,	4.902730788	,	-1.126640682	),
  (	60	,	5.535069805	,	-1.115758221	),
  (	60	,	6.214252429	,	-1.124065564	),
  (	60	,	6.271563234	,	-1.098796617	),
  (	60	,	6.127074598	,	-0.905676297	),
  (	60	,	6.064773738	,	-0.748072066	),
  (	60	,	6.038814948	,	-0.72393644	),
  (	60	,	6.086753136	,	-0.717437942	),
  (	60	,	5.638472265	,	-0.592445944	),
  (	60	,	5.889479749	,	-0.473111835	),
  (	60	,	5.203828266	,	-0.959425055	),
  (	60	,	5.095496134	,	-0.948153672	),
  (	60	,	4.843063941	,	-1.003971144	),
  (	60	,	5.361560535	,	-0.621267632	),
  (	60	,	4.786632584	,	-0.891310547	),
  (	60	,	4.928193188	,	-0.799530166	),
  (	60	,	4.851740487	,	-0.759348112	),
  (	60	,	5.524056461	,	-0.525790739	),
  (	60	,	5.416620079	,	-0.55150145	),
  (	60	,	5.616670891	,	-0.369947386	),
  (	60	,	5.689840453	,	-0.257423917	),
  (	60	,	5.685729116	,	-0.251319952	),
  (	60	,	5.412876994	,	-0.281410857	),
  (	60	,	5.29025298	,	-0.22024059	),
  (	60	,	5.475077035	,	-0.312815658	),
  (	60	,	5.492096322	,	-0.252780473	),
  (	61	,	0.721477166	,	0.082228541	),
  (	61	,	0.768954188	,	0.146275017	),
  (	61	,	0.683224288	,	0.134912937	),
  (	61	,	1.017403113	,	0.302411126	),
  (	61	,	1.156084865	,	0.332341548	),
  (	61	,	1.070509887	,	0.384112024	),
  (	61	,	0.979438873	,	0.365273584	),
  (	61	,	1.002369069	,	0.413844368	),
  (	61	,	0.963300139	,	0.442081086	),
  (	61	,	0.667159849	,	0.262408095	),
  (	61	,	0.735377112	,	0.319108411	),
  (	61	,	0.521848793	,	0.367539581	),
  (	61	,	0.87235534	,	0.47247151	),
  (	61	,	0.786265653	,	0.665521397	),
  (	61	,	1.206409821	,	0.407368547	),
  (	61	,	1.277522923	,	0.486898928	),
  (	61	,	1.180891349	,	0.566492636	),
  (	61	,	1.229785785	,	0.668103293	),
  (	61	,	1.388913139	,	0.589348171	),
  (	61	,	1.380129269	,	0.598868198	),
  (	61	,	1.310328972	,	0.687567006	),
  (	61	,	1.240132636	,	0.711854745	),
  (	61	,	1.568015911	,	0.87134726	),
  (	61	,	0.838456055	,	0.739596837	),
  (	61	,	1.537144298	,	1.029114974	),
  (	61	,	1.393927414	,	1.014337135	),
  (	61	,	1.315985725	,	1.065990474	),
  (	61	,	1.471536098	,	1.119702649	),
  (	61	,	0.51369175	,	0.485270651	),
  (	61	,	0.306847255	,	0.444307942	),
  (	61	,	0.667046675	,	0.602877334	),
  (	61	,	0.571071406	,	0.681366789	),
  (	61	,	0.613886808	,	0.825728188	),
  (	61	,	0.137134844	,	0.586108829	),
  (	61	,	0.262060269	,	0.78039053	),
  (	61	,	0.219505687	,	0.785438171	),
  (	61	,	0.376622834	,	0.758473447	),
  (	61	,	0.420854223	,	0.850370749	),
  (	61	,	0.484128252	,	0.906395197	),
  (	61	,	0.277580129	,	1.065956493	),
  (	61	,	0.011353551	,	1.153644526	),
  (	61	,	0.880881799	,	0.856441212	),
  (	61	,	0.74915829	,	0.817543108	),
  (	61	,	0.99281831	,	0.976017858	),
  (	61	,	0.711198645	,	0.934203003	),
  (	61	,	1.073611472	,	1.198691997	),
  (	61	,	1.329337225	,	1.292710377	),
  (	61	,	0.687677555	,	1.147471514	),
  (	61	,	0.183505156	,	1.154492323	),
  (	61	,	0.137103488	,	1.16098585	),
  (	61	,	0.21015936	,	1.268410603	),
  (	61	,	0.750401806	,	1.202330188	),
  (	61	,	0.732151052	,	1.42153554	),
  (	61	,	0.564681353	,	1.418882687	),
  (	61	,	2.409484895	,	0.06749094	),
  (	61	,	2.368178974	,	0.127379006	),
  (	61	,	2.250802706	,	0.115528393	),
  (	61	,	2.243718791	,	0.147517359	),
  (	61	,	2.081261961	,	0.275587184	),
  (	61	,	2.183194874	,	0.362110526	),
  (	61	,	2.219239142	,	0.421402354	),
  (	61	,	2.098460532	,	0.443189491	),
  (	61	,	2.394524248	,	0.464720779	),
  (	61	,	2.364101408	,	0.486982443	),
  (	61	,	2.331091695	,	0.53370352	),
  (	61	,	2.394787072	,	0.591342376	),
  (	61	,	2.329696424	,	0.62025825	),
  (	61	,	2.690128708	,	0.410210588	),
  (	61	,	2.690826776	,	0.442802789	),
  (	61	,	2.835702346	,	0.488241217	),
  (	61	,	2.899507314	,	0.667437781	),
  (	61	,	3.01294867	,	0.753525117	),
  (	61	,	2.921851805	,	0.754116341	),
  (	61	,	2.537646737	,	0.545899595	),
  (	61	,	2.490234258	,	0.587397182	),
  (	61	,	2.666916503	,	0.652782718	),
  (	61	,	2.737833266	,	0.726066123	),
  (	61	,	2.438401772	,	0.642301919	),
  (	61	,	2.95263406	,	0.863522039	),
  (	61	,	3.124026191	,	0.987830915	),
  (	61	,	1.896741999	,	0.434314044	),
  (	61	,	2.055294007	,	0.58003743	),
  (	61	,	1.847922517	,	0.511928332	),
  (	61	,	2.231107787	,	0.650392315	),
  (	61	,	2.238004019	,	0.66348992	),
  (	61	,	1.819540592	,	0.587845233	),
  (	61	,	1.819202033	,	0.8151527	),
  (	61	,	1.701910965	,	0.814817651	),
  (	61	,	1.941468102	,	0.905599372	),
  (	61	,	2.055532343	,	0.944740013	),
  (	61	,	1.70511473	,	1.015088411	),
  (	61	,	1.667046943	,	1.036238592	),
  (	61	,	2.154762505	,	0.9852733	),
  (	61	,	2.750812927	,	1.121502054	),
  (	61	,	2.921929282	,	1.173036216	),
  (	61	,	2.851343584	,	1.219172062	),
  (	61	,	2.101838504	,	1.052855999	),
  (	61	,	2.307410549	,	1.164271456	),
  (	61	,	2.224270431	,	1.174563158	),
  (	61	,	1.694022662	,	1.231074937	),
  (	61	,	1.747676525	,	1.252253896	),
  (	61	,	2.610890644	,	1.271983545	),
  (	61	,	4.122037345	,	0.301318059	),
  (	61	,	4.238877125	,	0.290871769	),
  (	61	,	4.227085607	,	0.300291203	),
  (	61	,	4.239549965	,	0.41006019	),
  (	61	,	3.959020735	,	0.321864537	),
  (	61	,	3.74143879	,	0.266397177	),
  (	61	,	3.964483089	,	0.438228253	),
  (	61	,	3.806282848	,	0.465604397	),
  (	61	,	4.380161268	,	0.594096118	),
  (	61	,	4.467566801	,	0.607203222	),
  (	61	,	4.395302772	,	0.737204992	),
  (	61	,	4.240246973	,	0.739578558	),
  (	61	,	4.184750629	,	0.870581771	),
  (	61	,	4.346682317	,	0.81355641	),
  (	61	,	3.607252999	,	0.448581506	),
  (	61	,	3.626593226	,	0.605001298	),
  (	61	,	3.483952439	,	0.595128448	),
  (	61	,	3.486599863	,	0.613101159	),
  (	61	,	3.678260909	,	0.889625206	),
  (	61	,	3.337842601	,	0.685563263	),
  (	61	,	3.381319166	,	0.823737251	),
  (	61	,	3.245354733	,	0.742512516	),
  (	61	,	3.518051092	,	0.803338806	),
  (	61	,	3.387199964	,	0.94421457	),
  (	61	,	3.217929532	,	0.928358347	),
  (	61	,	3.250905908	,	0.990958554	),
  (	61	,	4.090754178	,	0.951354184	),
  (	61	,	4.612688209	,	1.264593996	),
  (	61	,	3.411120716	,	1.110210807	),
  (	61	,	3.51743381	,	1.263468343	),
  (	61	,	4.376902238	,	1.352898894	),
  (	61	,	3.589464399	,	1.362487083	),
  (	61	,	5.521538553	,	0.103972866	),
  (	61	,	5.498082644	,	0.131186114	),
  (	61	,	5.589773175	,	0.128358174	),
  (	61	,	5.543697863	,	0.175388769	),
  (	61	,	5.633752842	,	0.21183705	),
  (	61	,	5.452543658	,	0.218965539	),
  (	61	,	5.692080708	,	0.257805266	),
  (	61	,	5.613182738	,	0.338170762	),
  (	61	,	5.624311592	,	0.387104929	),
  (	61	,	5.324813125	,	0.310541286	),
  (	61	,	5.404339237	,	0.413301998	),
  (	61	,	5.59101425	,	0.569197994	),
  (	61	,	5.413161743	,	0.520210358	),
  (	61	,	5.556431985	,	0.639371138	),
  (	61	,	5.819134398	,	0.499303774	),
  (	61	,	6.108108191	,	0.734401625	),
  (	61	,	5.969821872	,	0.653036819	),
  (	61	,	5.995730762	,	0.704713706	),
  (	61	,	5.720680298	,	0.690045259	),
  (	61	,	5.679171777	,	0.712179573	),
  (	61	,	5.573651011	,	0.744969016	),
  (	61	,	5.655059092	,	0.791936013	),
  (	61	,	5.972511719	,	0.949718819	),
  (	61	,	5.859960451	,	0.999805678	),
  (	61	,	5.100513795	,	0.432297094	),
  (	61	,	5.111025227	,	0.464560323	),
  (	61	,	5.162509695	,	0.535430733	),
  (	61	,	5.147624637	,	0.593045182	),
  (	61	,	5.491313469	,	0.731989816	),
  (	61	,	5.165093748	,	0.72907964	),
  (	61	,	5.255537347	,	0.841766423	),
  (	61	,	4.878667128	,	0.692343901	),
  (	61	,	4.905852657	,	0.692392098	),
  (	61	,	4.968849884	,	0.709985616	),
  (	61	,	5.078656131	,	0.757262986	),
  (	61	,	5.047736621	,	0.820324552	),
  (	61	,	5.156616394	,	0.881809394	),
  (	61	,	5.648137974	,	0.902308368	),
  (	61	,	5.57212068	,	0.942442296	),
  (	61	,	5.623798971	,	0.967240429	),
  (	61	,	5.507170489	,	0.989071469	),
  (	61	,	5.481572037	,	0.992874978	),
  (	61	,	5.411824994	,	1.05603863	),
  (	61	,	5.831341969	,	0.998682162	),
  (	61	,	5.819921919	,	1.102389845	),
  (	61	,	5.90381625	,	1.220226761	),
  (	61	,	6.174034499	,	1.250389474	),
  (	61	,	5.208031227	,	1.042119406	),
  (	61	,	5.294729046	,	1.058384384	),
  (	61	,	5.22935005	,	1.108876525	),
  (	61	,	5.312587013	,	1.166853061	),
  (	61	,	4.87044008	,	1.143004039	),
  (	61	,	5.068758967	,	1.389327656	),
  (	61	,	5.556077334	,	1.417748309	),
  (	61	,	0.214828102	,	-0.421271124	),
  (	61	,	0.157568824	,	-0.398680208	),
  (	61	,	6.063904028	,	-0.490237735	),
  (	61	,	0.046766628	,	-0.219565365	),
  (	61	,	6.250447716	,	-0.248730832	),
  (	61	,	6.200938847	,	-0.203865427	),
  (	61	,	0.045010134	,	-0.091608701	),
  (	61	,	0.573208264	,	-0.175464005	),
  (	61	,	0.243065265	,	-0.128237346	),
  (	61	,	0.657779533	,	0.004457456	),
  (	61	,	0.47313012	,	0.064325561	),
  (	61	,	0.177612325	,	-0.075955673	),
  (	61	,	0.155121376	,	-0.008832123	),
  (	61	,	0.521118268	,	0.214581335	),
  (	61	,	0.392187465	,	0.320366557	),
  (	61	,	5.875542284	,	-0.292202778	),
  (	61	,	5.813821357	,	-0.247737195	),
  (	61	,	5.908156492	,	-0.027480566	),
  (	61	,	6.02450631	,	0.05255574	),
  (	61	,	0.065377771	,	0.15395181	),
  (	61	,	6.24545952	,	0.162540926	),
  (	61	,	0.171695261	,	0.370845971	),
  (	61	,	0.244235085	,	0.474894684	),
  (	61	,	0.181531047	,	0.429855757	),
  (	61	,	6.080035744	,	0.193120162	),
  (	61	,	5.929211275	,	0.340716175	),
  (	61	,	0.090572007	,	0.574406477	),
  (	61	,	6.238167317	,	0.635735307	),
  (	61	,	1.514405093	,	-0.499842082	),
  (	61	,	1.619786073	,	-0.462198893	),
  (	61	,	1.601157929	,	-0.380696834	),
  (	61	,	1.831086609	,	-0.377041077	),
  (	61	,	1.636857489	,	-0.353812602	),
  (	61	,	1.490911418	,	-0.291920068	),
  (	61	,	1.391256475	,	-0.316421704	),
  (	61	,	1.341372431	,	-0.218026803	),
  (	61	,	1.471080321	,	-0.205524302	),
  (	61	,	1.516027615	,	-0.183836755	),
  (	61	,	1.410699206	,	-0.146880168	),
  (	61	,	1.496177727	,	-0.11861064	),
  (	61	,	1.445779475	,	-0.117083321	),
  (	61	,	1.618880358	,	-0.117884392	),
  (	61	,	1.621970779	,	-0.081428096	),
  (	61	,	1.631461317	,	-0.065296672	),
  (	61	,	1.551177164	,	-0.080576303	),
  (	61	,	1.474322026	,	-0.08402058	),
  (	61	,	1.520984841	,	-0.071492827	),
  (	61	,	2.031062709	,	-0.256400653	),
  (	61	,	1.978198313	,	-0.250250601	),
  (	61	,	2.009714052	,	-0.142865804	),
  (	61	,	1.972629861	,	-0.155028726	),
  (	61	,	2.201767581	,	-0.082333997	),
  (	61	,	2.241544859	,	0.083024578	),
  (	61	,	1.686747	,	-0.080239951	),
  (	61	,	1.80947306	,	-0.030656592	),
  (	61	,	1.711814629	,	0.08475332	),
  (	61	,	1.992185846	,	0.102317554	),
  (	61	,	1.917125414	,	0.047832697	),
  (	61	,	1.900915777	,	0.139238239	),
  (	61	,	2.01525777	,	0.235275492	),
  (	61	,	1.364859478	,	-0.105721641	),
  (	61	,	1.463336218	,	-0.077218989	),
  (	61	,	1.321029779	,	-0.073480163	),
  (	61	,	1.481431352	,	-0.062215559	),
  (	61	,	1.486242481	,	-0.049309425	),
  (	61	,	1.457633209	,	-0.018077149	),
  (	61	,	1.512239326	,	0.02037172	),
  (	61	,	0.953331482	,	-0.129019934	),
  (	61	,	1.042275406	,	-0.095489717	),
  (	61	,	1.14079106	,	-0.001728716	),
  (	61	,	0.945912945	,	0.010238741	),
  (	61	,	1.034237009	,	0.105409271	),
  (	61	,	0.986791888	,	0.118737398	),
  (	61	,	1.272882061	,	0.174097043	),
  (	61	,	1.186237114	,	0.276658868	),
  (	61	,	1.669429426	,	0.219388073	),
  (	61	,	1.585686293	,	0.203872508	),
  (	61	,	1.556952072	,	0.201073579	),
  (	61	,	1.649743509	,	0.251028824	),
  (	61	,	1.843741598	,	0.291023019	),
  (	61	,	1.422859451	,	0.291472106	),
  (	61	,	1.304591401	,	0.253826642	),
  (	61	,	1.412092614	,	0.291455599	),
  (	61	,	1.44965115	,	0.297719306	),
  (	61	,	1.537591203	,	0.346759007	),
  (	61	,	1.455810694	,	0.357341467	),
  (	61	,	1.498038919	,	0.404990968	),
  (	61	,	1.351554157	,	0.489216949	),
  (	61	,	1.621142254	,	0.426207564	),
  (	61	,	1.557424208	,	0.42323673	),
  (	61	,	1.575192609	,	0.481228224	),
  (	61	,	3.187692382	,	-0.660966314	),
  (	61	,	3.219202319	,	-0.629959244	),
  (	61	,	3.312009557	,	-0.530971979	),
  (	61	,	3.039418603	,	-0.58591231	),
  (	61	,	3.324057527	,	-0.3448593	),
  (	61	,	3.310627991	,	-0.318521327	),
  (	61	,	3.207012497	,	-0.363799917	),
  (	61	,	3.216005329	,	-0.291360374	),
  (	61	,	2.934359871	,	-0.322885144	),
  (	61	,	2.998282591	,	-0.215663052	),
  (	61	,	2.880642338	,	-0.245804661	),
  (	61	,	3.543210051	,	-0.326882665	),
  (	61	,	3.50512002	,	-0.085949512	),
  (	61	,	3.737195644	,	-0.055789919	),
  (	61	,	3.878563818	,	-0.014792121	),
  (	61	,	3.331988398	,	-0.027532694	),
  (	61	,	3.631626762	,	0.212320665	),
  (	61	,	2.702121813	,	-0.218658264	),
  (	61	,	2.83495998	,	-0.171964219	),
  (	61	,	2.743364149	,	-0.065320205	),
  (	61	,	2.96232531	,	0.028798071	),
  (	61	,	2.579745888	,	-0.074063693	),
  (	61	,	2.557638145	,	0.117083538	),
  (	61	,	2.602418946	,	0.155915395	),
  (	61	,	2.988785565	,	0.199495066	),
  (	61	,	3.094676343	,	0.283485117	),
  (	61	,	3.347666732	,	0.208706596	),
  (	61	,	3.294905559	,	0.381899733	),
  (	61	,	3.031235126	,	0.293161452	),
  (	61	,	4.740309739	,	-0.628662798	),
  (	61	,	4.691156986	,	-0.636620698	),
  (	61	,	4.681672504	,	-0.621767982	),
  (	61	,	4.683270169	,	-0.606167514	),
  (	61	,	4.688182033	,	-0.601558447	),
  (	61	,	4.678919923	,	-0.600687863	),
  (	61	,	4.690139265	,	-0.43436203	),
  (	61	,	5.069532444	,	-0.319552956	),
  (	61	,	5.004158325	,	-0.283255886	),
  (	61	,	4.780076194	,	-0.325706031	),
  (	61	,	4.787410495	,	-0.303233642	),
  (	61	,	4.504770963	,	-0.484546389	),
  (	61	,	4.450423541	,	-0.437943425	),
  (	61	,	4.55836363	,	-0.374227525	),
  (	61	,	4.710698607	,	-0.084155248	),
  (	61	,	5.359975216	,	-0.05860683	),
  (	61	,	5.343435404	,	0.01864778	),
  (	61	,	5.398768009	,	0.001690739	),
  (	61	,	4.88694759	,	-0.135979464	),
  (	61	,	5.071754909	,	-0.004406877	),
  (	61	,	5.212734715	,	0.12462266	),
  (	61	,	4.400189469	,	-0.260219331	),
  (	61	,	4.257985702	,	-0.259165819	),
  (	61	,	4.354708346	,	-0.114110956	),
  (	61	,	4.486487362	,	-0.018844692	),
  (	61	,	4.473627228	,	0.012221481	),
  (	61	,	4.39457427	,	0.036031055	),
  (	61	,	4.007429369	,	-0.008049928	),
  (	61	,	4.367052718	,	0.216333503	),
  (	61	,	4.732559129	,	0.033492073	),
  (	61	,	4.806084026	,	0.094869828	),
  (	61	,	5.089720957	,	0.347166322	),
  (	61	,	4.85537346	,	0.412191876	),
  (	61	,	4.663509557	,	0.336064796	),
  (	61	,	4.723308547	,	0.400084897	),
  (	61	,	4.610345628	,	0.537301909	),
  (	61	,	1.303972482	,	-1.439381677	),
  (	61	,	0.470202769	,	-1.399347531	),
  (	61	,	1.460606743	,	-1.287023645	),
  (	61	,	0.89711749	,	-1.210141119	),
  (	61	,	0.863888476	,	-1.168092276	),
  (	61	,	0.41567336	,	-1.014729217	),
  (	61	,	0.610453781	,	-0.976418628	),
  (	61	,	0.861507188	,	-0.833420764	),
  (	61	,	0.798191736	,	-0.819868442	),
  (	61	,	1.537362945	,	-0.997573213	),
  (	61	,	1.446880956	,	-0.80154371	),
  (	61	,	1.564798206	,	-0.768546817	),
  (	61	,	0.994085053	,	-0.630162811	),
  (	61	,	1.164784155	,	-0.420300445	),
  (	61	,	1.14796805	,	-0.43445184	),
  (	61	,	0.435495361	,	-0.980811737	),
  (	61	,	0.563536464	,	-0.75951417	),
  (	61	,	0.58700492	,	-0.718498613	),
  (	61	,	0.668096693	,	-0.604758202	),
  (	61	,	0.364405071	,	-0.540108387	),
  (	61	,	0.792535458	,	-0.490342742	),
  (	61	,	0.777097737	,	-0.411996236	),
  (	61	,	0.997430194	,	-0.364827846	),
  (	61	,	1.026542715	,	-0.211172414	),
  (	61	,	0.58040106	,	-0.366516389	),
  (	61	,	0.639617281	,	-0.349797333	),
  (	61	,	0.61995534	,	-0.308270127	),
  (	61	,	0.536588005	,	-0.267137866	),
  (	61	,	0.704975132	,	-0.253928152	),
  (	61	,	0.79384793	,	-0.173859834	),
  (	61	,	0.85527447	,	-0.103301111	),
  (	61	,	2.282887663	,	-1.380030211	),
  (	61	,	2.361182442	,	-1.198760544	),
  (	61	,	3.003299265	,	-1.26491045	),
  (	61	,	3.020873728	,	-1.168703693	),
  (	61	,	2.963806316	,	-1.127171741	),
  (	61	,	2.604883879	,	-1.20605287	),
  (	61	,	2.472829518	,	-1.133229365	),
  (	61	,	2.633560339	,	-1.080079763	),
  (	61	,	2.025512419	,	-1.218615834	),
  (	61	,	2.288541254	,	-1.148857955	),
  (	61	,	2.08223252	,	-1.104735736	),
  (	61	,	2.359519776	,	-1.064018604	),
  (	61	,	2.100432917	,	-0.951474723	),
  (	61	,	2.20966693	,	-0.921664449	),
  (	61	,	2.347141866	,	-0.847755982	),
  (	61	,	2.335772049	,	-0.78612458	),
  (	61	,	3.071262306	,	-1.097434879	),
  (	61	,	2.87644228	,	-1.070248098	),
  (	61	,	3.116246879	,	-1.001997288	),
  (	61	,	2.827824752	,	-1.045786319	),
  (	61	,	2.76109548	,	-1.023927536	),
  (	61	,	2.901901981	,	-0.862056846	),
  (	61	,	2.760062043	,	-0.778742592	),
  (	61	,	2.625314305	,	-0.931379322	),
  (	61	,	2.545820542	,	-0.894098745	),
  (	61	,	2.632575661	,	-0.813956235	),
  (	61	,	2.459438441	,	-0.818711444	),
  (	61	,	2.426299843	,	-0.783629889	),
  (	61	,	2.462099823	,	-0.688106668	),
  (	61	,	2.603126709	,	-0.583260116	),
  (	61	,	2.49388398	,	-0.623360912	),
  (	61	,	1.837317603	,	-1.028678075	),
  (	61	,	1.688902554	,	-1.012328543	),
  (	61	,	1.921412742	,	-0.912990621	),
  (	61	,	1.963470602	,	-0.9189295	),
  (	61	,	1.771051565	,	-0.914720548	),
  (	61	,	2.052481449	,	-0.881561586	),
  (	61	,	2.082763277	,	-0.835848907	),
  (	61	,	2.117687137	,	-0.81992702	),
  (	61	,	1.59115199	,	-0.786745	),
  (	61	,	1.772391406	,	-0.659302591	),
  (	61	,	2.10778573	,	-0.56659472	),
  (	61	,	1.822605089	,	-0.480619422	),
  (	61	,	1.924538757	,	-0.451892913	),
  (	61	,	1.905193835	,	-0.406847826	),
  (	61	,	1.93856811	,	-0.399902657	),
  (	61	,	1.943131002	,	-0.383668093	),
  (	61	,	2.324779184	,	-0.675860616	),
  (	61	,	2.421439232	,	-0.656286881	),
  (	61	,	2.312721522	,	-0.514225345	),
  (	61	,	2.314132008	,	-0.499472457	),
  (	61	,	2.294323581	,	-0.443103857	),
  (	61	,	2.614085748	,	-0.418019127	),
  (	61	,	2.714923225	,	-0.346736017	),
  (	61	,	2.441512014	,	-0.276373501	),
  (	61	,	2.488717441	,	-0.271884074	),
  (	61	,	2.204855596	,	-0.367313791	),
  (	61	,	2.17471102	,	-0.220592712	),
  (	61	,	2.430930356	,	-0.254366107	),
  (	61	,	2.220276489	,	-0.170144253	),
  (	61	,	4.587847247	,	-1.411263414	),
  (	61	,	3.66756876	,	-1.371655026	),
  (	61	,	3.465733108	,	-1.369166882	),
  (	61	,	4.508564139	,	-1.172812646	),
  (	61	,	4.41523764	,	-1.141018677	),
  (	61	,	4.041548517	,	-1.192218743	),
  (	61	,	4.135916465	,	-1.14218764	),
  (	61	,	4.299476969	,	-1.10174187	),
  (	61	,	4.358429021	,	-1.0644875	),
  (	61	,	4.101242931	,	-1.045623672	),
  (	61	,	3.281961061	,	-1.274109504	),
  (	61	,	3.713313434	,	-1.216833937	),
  (	61	,	3.801661303	,	-1.181894929	),
  (	61	,	3.7835109	,	-1.148806201	),
  (	61	,	3.668970009	,	-1.156613665	),
  (	61	,	3.293901173	,	-1.182581332	),
  (	61	,	3.216216665	,	-1.146559635	),
  (	61	,	3.530485735	,	-1.128806474	),
  (	61	,	3.894646346	,	-1.113692619	),
  (	61	,	3.871181683	,	-0.911153973	),
  (	61	,	3.724806686	,	-0.953398481	),
  (	61	,	3.811360121	,	-0.919432924	),
  (	61	,	4.458398502	,	-1.029016635	),
  (	61	,	4.550597152	,	-1.012473112	),
  (	61	,	4.604752601	,	-0.931186558	),
  (	61	,	4.568137964	,	-0.906679753	),
  (	61	,	4.673925304	,	-0.927298077	),
  (	61	,	4.614018741	,	-0.873717376	),
  (	61	,	4.466710691	,	-0.823106582	),
  (	61	,	4.425141296	,	-0.729984917	),
  (	61	,	4.380343944	,	-0.717565875	),
  (	61	,	4.445665318	,	-0.656605013	),
  (	61	,	4.518635959	,	-0.673623792	),
  (	61	,	4.559866586	,	-0.605562755	),
  (	61	,	4.188363251	,	-0.942844005	),
  (	61	,	4.278426523	,	-0.688194658	),
  (	61	,	4.171834611	,	-0.695766632	),
  (	61	,	4.120622998	,	-0.729884231	),
  (	61	,	4.075461752	,	-0.699295368	),
  (	61	,	4.095866097	,	-0.682908152	),
  (	61	,	4.251501942	,	-0.576154482	),
  (	61	,	4.204373464	,	-0.558518038	),
  (	61	,	4.370309917	,	-0.427047546	),
  (	61	,	3.494173061	,	-0.973905324	),
  (	61	,	3.148065751	,	-1.003632273	),
  (	61	,	3.467604679	,	-0.85447175	),
  (	61	,	3.649151984	,	-0.813211403	),
  (	61	,	3.703867878	,	-0.758710345	),
  (	61	,	3.322147878	,	-0.805385198	),
  (	61	,	3.345668778	,	-0.581468307	),
  (	61	,	3.405755603	,	-0.584789083	),
  (	61	,	3.932311592	,	-0.664248551	),
  (	61	,	3.903566765	,	-0.581205435	),
  (	61	,	3.987589225	,	-0.457164873	),
  (	61	,	4.164798052	,	-0.477152246	),
  (	61	,	4.093989299	,	-0.366811431	),
  (	61	,	3.985103267	,	-0.342918963	),
  (	61	,	3.730726921	,	-0.511067509	),
  (	61	,	3.922147696	,	-0.194507427	),
  (	61	,	5.419561429	,	-1.329603307	),
  (	61	,	4.761543112	,	-1.32459293	),
  (	61	,	4.856043911	,	-1.290953866	),
  (	61	,	5.196837269	,	-1.145044005	),
  (	61	,	5.193937546	,	-1.065716881	),
  (	61	,	5.945529629	,	-0.824024266	),
  (	61	,	5.919237408	,	-0.552642246	),
  (	61	,	5.935726219	,	-0.535123717	),
  (	61	,	5.038160033	,	-0.78878068	),
  (	61	,	4.749484627	,	-0.798787186	),
  (	61	,	4.847865883	,	-0.731538234	),
  (	61	,	5.164547316	,	-0.655177221	),
  (	61	,	5.188852505	,	-0.502474193	),
  (	61	,	5.031905178	,	-0.452159899	),
  (	61	,	5.462791635	,	-0.579065554	),
  (	61	,	5.347023276	,	-0.50026782	),
  (	61	,	5.505445902	,	-0.469164759	),
  (	61	,	5.314633656	,	-0.38065848	),
  (	61	,	5.201953857	,	-0.332405358	),
  (	61	,	5.326644844	,	-0.258045086	),
  (	61	,	5.531584361	,	-0.304668652	),
  (	61	,	5.457207608	,	-0.218958461	),
  (	61	,	5.589729697	,	-0.079587835	),
  (	61	,	5.460401546	,	-0.098202689	),
  (	62	,	0.788618041	,	0.189720103	),
  (	62	,	1.009084786	,	0.227694159	),
  (	62	,	1.080810009	,	0.264637779	),
  (	62	,	1.08206285	,	0.302637118	),
  (	62	,	1.136304489	,	0.327116244	),
  (	62	,	1.144843273	,	0.363402	),
  (	62	,	1.103283624	,	0.391187152	),
  (	62	,	0.657302541	,	0.346536202	),
  (	62	,	0.413724284	,	0.32218874	),
  (	62	,	0.651141582	,	0.409609189	),
  (	62	,	0.578694354	,	0.421806739	),
  (	62	,	0.85777039	,	0.561706495	),
  (	62	,	0.783937261	,	0.716154217	),
  (	62	,	1.293004344	,	0.63125968	),
  (	62	,	1.443434952	,	0.723644017	),
  (	62	,	1.323442214	,	0.723292998	),
  (	62	,	1.251146145	,	0.703582632	),
  (	62	,	1.467239732	,	0.83278645	),
  (	62	,	1.135515433	,	0.729684912	),
  (	62	,	1.150160722	,	0.740503499	),
  (	62	,	1.126331057	,	0.735497415	),
  (	62	,	0.913850264	,	0.819217186	),
  (	62	,	0.980358915	,	0.804590732	),
  (	62	,	0.996150815	,	0.885523277	),
  (	62	,	1.192999105	,	0.751607368	),
  (	62	,	1.373302863	,	0.928758498	),
  (	62	,	1.36592172	,	1.07948711	),
  (	62	,	1.523132465	,	1.096209477	),
  (	62	,	0.44354788	,	0.524420383	),
  (	62	,	0.505745577	,	0.650619589	),
  (	62	,	0.474086908	,	0.662399277	),
  (	62	,	0.584853401	,	0.828751889	),
  (	62	,	0.254112099	,	0.592546074	),
  (	62	,	0.020112093	,	0.734651378	),
  (	62	,	0.007552891	,	0.739445908	),
  (	62	,	0.071384724	,	0.760874384	),
  (	62	,	0.224985636	,	0.900090393	),
  (	62	,	0.144760387	,	0.95809351	),
  (	62	,	0.185523898	,	1.025439657	),
  (	62	,	0.843860399	,	0.840844346	),
  (	62	,	0.952645533	,	0.993659226	),
  (	62	,	0.602468965	,	1.003849031	),
  (	62	,	1.112777316	,	1.002872569	),
  (	62	,	1.147413346	,	1.040493314	),
  (	62	,	1.076208233	,	1.143550577	),
  (	62	,	0.455102337	,	1.004201801	),
  (	62	,	0.396511828	,	1.153628075	),
  (	62	,	0.58680038	,	1.161069803	),
  (	62	,	0.332477448	,	1.252166449	),
  (	62	,	0.537436833	,	1.288935795	),
  (	62	,	0.040808166	,	1.391277131	),
  (	62	,	0.365556493	,	1.374029388	),
  (	62	,	2.290838331	,	0.0991444	),
  (	62	,	2.681225291	,	0.369443001	),
  (	62	,	2.573636646	,	0.369649614	),
  (	62	,	2.142307635	,	0.255330396	),
  (	62	,	2.207081072	,	0.297495166	),
  (	62	,	2.147719585	,	0.308005983	),
  (	62	,	2.115139816	,	0.328852911	),
  (	62	,	2.121912036	,	0.395062637	),
  (	62	,	2.323825286	,	0.494437801	),
  (	62	,	2.261578242	,	0.572502689	),
  (	62	,	2.422656943	,	0.60447475	),
  (	62	,	2.881279707	,	0.748936063	),
  (	62	,	3.048029728	,	0.81740793	),
  (	62	,	2.542559005	,	0.612488507	),
  (	62	,	2.702825971	,	0.844669475	),
  (	62	,	1.934994841	,	0.400467424	),
  (	62	,	2.011383288	,	0.401747618	),
  (	62	,	2.00363788	,	0.422763076	),
  (	62	,	1.911431992	,	0.540279106	),
  (	62	,	1.864765209	,	0.59357043	),
  (	62	,	2.019010216	,	0.593415568	),
  (	62	,	2.32201152	,	0.733078417	),
  (	62	,	1.802154452	,	0.678395414	),
  (	62	,	1.81184537	,	0.766373747	),
  (	62	,	1.578292504	,	0.854502352	),
  (	62	,	1.621456659	,	0.850160373	),
  (	62	,	1.993093435	,	0.973104848	),
  (	62	,	1.909223885	,	0.90985645	),
  (	62	,	1.735195973	,	1.07301685	),
  (	62	,	2.322141786	,	0.790853955	),
  (	62	,	2.45096974	,	0.989586703	),
  (	62	,	2.265840465	,	0.919987638	),
  (	62	,	2.605900786	,	1.002129242	),
  (	62	,	2.814638286	,	1.176550679	),
  (	62	,	2.528382528	,	1.174117112	),
  (	62	,	2.138298556	,	1.016614879	),
  (	62	,	2.036231195	,	1.142419166	),
  (	62	,	2.184595132	,	1.263741568	),
  (	62	,	2.477752239	,	1.310715486	),
  (	62	,	2.562567078	,	1.381192498	),
  (	62	,	3.018617712	,	1.415941868	),
  (	62	,	3.924308705	,	0.079721801	),
  (	62	,	4.159107924	,	0.230256554	),
  (	62	,	4.137396759	,	0.240652156	),
  (	62	,	4.067320316	,	0.280233856	),
  (	62	,	4.105824403	,	0.27967983	),
  (	62	,	4.16987094	,	0.324991859	),
  (	62	,	3.979659004	,	0.331195224	),
  (	62	,	3.832011219	,	0.319359073	),
  (	62	,	3.898119199	,	0.334305644	),
  (	62	,	3.841312743	,	0.383555973	),
  (	62	,	3.988522693	,	0.554799156	),
  (	62	,	3.909427409	,	0.563742055	),
  (	62	,	3.879445722	,	0.659942916	),
  (	62	,	4.530819562	,	0.67739534	),
  (	62	,	4.631063771	,	0.904396675	),
  (	62	,	4.017295359	,	0.77551373	),
  (	62	,	4.052388375	,	0.823822225	),
  (	62	,	4.197922143	,	0.923552983	),
  (	62	,	4.421315069	,	0.827590002	),
  (	62	,	4.501518568	,	0.86824	),
  (	62	,	4.692300203	,	0.976900104	),
  (	62	,	4.272504758	,	0.855881275	),
  (	62	,	4.376312705	,	0.97198568	),
  (	62	,	3.589811844	,	0.610674992	),
  (	62	,	3.605483482	,	0.672013355	),
  (	62	,	3.740903341	,	0.895481828	),
  (	62	,	3.445716551	,	0.672543803	),
  (	62	,	4.080881243	,	0.941119163	),
  (	62	,	4.130205866	,	0.968226966	),
  (	62	,	4.048535553	,	1.058894654	),
  (	62	,	3.944288651	,	1.150514967	),
  (	62	,	3.973861588	,	1.183000931	),
  (	62	,	3.620520947	,	1.073179238	),
  (	62	,	3.799393834	,	1.102801137	),
  (	62	,	3.475283429	,	1.193946693	),
  (	62	,	3.398110477	,	1.31724416	),
  (	62	,	3.588366376	,	1.444296884	),
  (	62	,	5.58011314	,	0.195537788	),
  (	62	,	5.811315566	,	0.279958402	),
  (	62	,	5.713543933	,	0.357137049	),
  (	62	,	5.586077844	,	0.384430147	),
  (	62	,	5.401415134	,	0.318854404	),
  (	62	,	5.371128976	,	0.359652267	),
  (	62	,	5.20266393	,	0.325884476	),
  (	62	,	5.250271785	,	0.322900891	),
  (	62	,	5.285512023	,	0.381788212	),
  (	62	,	5.603053792	,	0.441786259	),
  (	62	,	5.503085297	,	0.628771898	),
  (	62	,	5.812536323	,	0.435471161	),
  (	62	,	5.795742814	,	0.445814041	),
  (	62	,	5.932254766	,	0.656118627	),
  (	62	,	6.270360386	,	0.74452635	),
  (	62	,	5.941127154	,	0.725176344	),
  (	62	,	5.681126114	,	0.619770087	),
  (	62	,	5.786662574	,	0.789737797	),
  (	62	,	5.580349803	,	0.716291663	),
  (	62	,	5.785127583	,	0.841797856	),
  (	62	,	5.916186105	,	0.873900117	),
  (	62	,	5.935459322	,	0.93978644	),
  (	62	,	5.182803652	,	0.443032761	),
  (	62	,	5.04145088	,	0.532782711	),
  (	62	,	5.063859628	,	0.614111137	),
  (	62	,	5.057176589	,	0.653546865	),
  (	62	,	5.108493873	,	0.632305344	),
  (	62	,	5.094644883	,	0.662198231	),
  (	62	,	5.269544716	,	0.600792365	),
  (	62	,	5.335274931	,	0.716033057	),
  (	62	,	5.410738674	,	0.758493579	),
  (	62	,	5.205533815	,	0.834401261	),
  (	62	,	5.023870966	,	0.705617708	),
  (	62	,	4.939808405	,	0.72227374	),
  (	62	,	4.884963426	,	0.714451424	),
  (	62	,	5.059744913	,	0.949036192	),
  (	62	,	5.062625652	,	1.006098473	),
  (	62	,	4.922994194	,	0.851160232	),
  (	62	,	4.902122838	,	0.940238107	),
  (	62	,	4.758345478	,	0.947509075	),
  (	62	,	4.905703466	,	1.065493346	),
  (	62	,	5.482219649	,	0.858630801	),
  (	62	,	5.514349409	,	0.930017827	),
  (	62	,	5.573003359	,	0.973860487	),
  (	62	,	5.429579783	,	0.985908474	),
  (	62	,	5.422132314	,	1.057690185	),
  (	62	,	5.754755271	,	1.09428812	),
  (	62	,	6.055402794	,	1.110613153	),
  (	62	,	6.193088168	,	1.291589074	),
  (	62	,	5.219926587	,	0.989376998	),
  (	62	,	5.016790367	,	1.151545858	),
  (	62	,	4.779086879	,	1.200007734	),
  (	62	,	5.47484824	,	1.325156487	),
  (	62	,	5.566335694	,	1.344119925	),
  (	62	,	4.712679382	,	1.396294163	),
  (	62	,	4.817800081	,	1.451681585	),
  (	62	,	5.60614163	,	1.405421856	),
  (	62	,	5.36458038	,	1.415336567	),
  (	62	,	5.98235978	,	1.490066365	),
  (	62	,	5.362763539	,	1.459536684	),
  (	62	,	6.25987231	,	-0.703365028	),
  (	62	,	0.0598004	,	-0.454185007	),
  (	62	,	0.118883521	,	-0.445884287	),
  (	62	,	0.095002842	,	-0.350079981	),
  (	62	,	0.130328775	,	-0.259431749	),
  (	62	,	6.173334438	,	-0.266103472	),
  (	62	,	6.033322924	,	-0.364278354	),
  (	62	,	6.106042342	,	-0.315473551	),
  (	62	,	0.031870189	,	-0.303458256	),
  (	62	,	0.03617739	,	-0.154014029	),
  (	62	,	6.240640159	,	-0.174072076	),
  (	62	,	6.252328497	,	-0.055078683	),
  (	62	,	0.574199968	,	-0.031863579	),
  (	62	,	0.54020137	,	-0.005943877	),
  (	62	,	0.312952768	,	-0.039291367	),
  (	62	,	0.278469677	,	0.023851089	),
  (	62	,	0.307871805	,	0.04268341	),
  (	62	,	0.206796023	,	0.117649722	),
  (	62	,	0.210719168	,	0.12740836	),
  (	62	,	0.417893482	,	0.255889079	),
  (	62	,	0.434947868	,	0.286334688	),
  (	62	,	5.875547968	,	-0.292200673	),
  (	62	,	5.842552689	,	-0.232216999	),
  (	62	,	5.862281158	,	-0.125565493	),
  (	62	,	5.8056825	,	-0.074470267	),
  (	62	,	6.028056637	,	-0.082229471	),
  (	62	,	5.999534219	,	0.01858662	),
  (	62	,	5.705652099	,	-0.10326548	),
  (	62	,	5.831843574	,	-0.027863378	),
  (	62	,	5.661682803	,	-0.006820013	),
  (	62	,	5.613286948	,	0.019237577	),
  (	62	,	5.66241132	,	0.115512468	),
  (	62	,	5.829390514	,	0.149216883	),
  (	62	,	5.942672952	,	0.253356346	),
  (	62	,	6.261938218	,	0.123409484	),
  (	62	,	0.123635753	,	0.177823807	),
  (	62	,	0.206080902	,	0.341713877	),
  (	62	,	0.065157378	,	0.38893181	),
  (	62	,	6.185735877	,	0.293660034	),
  (	62	,	0.061251051	,	0.5795525	),
  (	62	,	1.689409184	,	-0.451307275	),
  (	62	,	1.493098369	,	-0.532943711	),
  (	62	,	1.471639515	,	-0.486452619	),
  (	62	,	1.554396573	,	-0.39862885	),
  (	62	,	1.791649693	,	-0.449917149	),
  (	62	,	1.806084487	,	-0.428281833	),
  (	62	,	1.892837055	,	-0.399780835	),
  (	62	,	1.891069266	,	-0.395744901	),
  (	62	,	1.833196994	,	-0.351830226	),
  (	62	,	1.80363958	,	-0.33043606	),
  (	62	,	1.645250969	,	-0.39648701	),
  (	62	,	1.637541392	,	-0.322495014	),
  (	62	,	1.73126445	,	-0.232499817	),
  (	62	,	1.35866067	,	-0.206798598	),
  (	62	,	1.702515163	,	-0.175955832	),
  (	62	,	1.654274028	,	-0.149853986	),
  (	62	,	1.441405919	,	-0.129762104	),
  (	62	,	1.566513953	,	-0.163749007	),
  (	62	,	1.612710326	,	-0.09968303	),
  (	62	,	2.048493047	,	-0.233054327	),
  (	62	,	2.122567927	,	-0.161345648	),
  (	62	,	1.873337882	,	-0.180581252	),
  (	62	,	1.901193885	,	-0.184718728	),
  (	62	,	1.894810212	,	-0.173616891	),
  (	62	,	1.945401715	,	-0.100792402	),
  (	62	,	1.894467017	,	-0.068099839	),
  (	62	,	2.194320704	,	-0.131651563	),
  (	62	,	2.192574471	,	-0.107846467	),
  (	62	,	1.739379656	,	0.028161078	),
  (	62	,	1.828015505	,	0.062872528	),
  (	62	,	1.73607189	,	0.08651021	),
  (	62	,	1.958204549	,	0.263714364	),
  (	62	,	1.122770003	,	-0.112961429	),
  (	62	,	1.422615775	,	-0.096316068	),
  (	62	,	1.394466065	,	-0.024642138	),
  (	62	,	1.457643265	,	-0.025664395	),
  (	62	,	1.317022521	,	0.012600354	),
  (	62	,	1.360291386	,	0.018097962	),
  (	62	,	1.416342251	,	0.041070353	),
  (	62	,	1.022286738	,	-0.051537106	),
  (	62	,	0.955647053	,	-0.098221248	),
  (	62	,	0.997678248	,	0.003976393	),
  (	62	,	0.91960611	,	0.108011312	),
  (	62	,	1.106436827	,	0.178238234	),
  (	62	,	1.529346885	,	0.035337107	),
  (	62	,	1.528114407	,	0.077198314	),
  (	62	,	1.505478075	,	0.069952056	),
  (	62	,	1.675680736	,	0.155071589	),
  (	62	,	1.724792294	,	0.17432852	),
  (	62	,	1.470765007	,	0.192595339	),
  (	62	,	1.843181736	,	0.309895533	),
  (	62	,	1.653832593	,	0.302382349	),
  (	62	,	1.692723558	,	0.357729833	),
  (	62	,	1.427816299	,	0.266294559	),
  (	62	,	1.249143502	,	0.326973558	),
  (	62	,	1.612424264	,	0.387292716	),
  (	62	,	1.575886974	,	0.541654545	),
  (	62	,	1.595077593	,	0.586412993	),
  (	62	,	3.167525219	,	-0.622976306	),
  (	62	,	3.069390505	,	-0.649093607	),
  (	62	,	3.112987279	,	-0.612031833	),
  (	62	,	3.128767617	,	-0.581465056	),
  (	62	,	3.030193893	,	-0.572915298	),
  (	62	,	3.122694783	,	-0.497022535	),
  (	62	,	3.368317585	,	-0.466666938	),
  (	62	,	3.497176845	,	-0.340152761	),
  (	62	,	3.229628345	,	-0.387042763	),
  (	62	,	3.385445031	,	-0.267507134	),
  (	62	,	3.024863505	,	-0.284150293	),
  (	62	,	2.877673447	,	-0.285427125	),
  (	62	,	3.053675748	,	-0.25252474	),
  (	62	,	3.207812882	,	-0.180064076	),
  (	62	,	3.022875643	,	-0.136616071	),
  (	62	,	3.602286306	,	-0.275197202	),
  (	62	,	3.445953227	,	-0.180282116	),
  (	62	,	3.536167872	,	-0.112926048	),
  (	62	,	3.784765754	,	-0.10682752	),
  (	62	,	3.751067924	,	0.006706489	),
  (	62	,	3.406003783	,	-0.058785571	),
  (	62	,	3.373628189	,	-0.062013694	),
  (	62	,	3.183871816	,	0.033102646	),
  (	62	,	3.623354116	,	0.095944591	),
  (	62	,	2.904082353	,	-0.193548108	),
  (	62	,	2.667283676	,	-0.127700631	),
  (	62	,	2.953836202	,	-0.124522738	),
  (	62	,	2.84091002	,	-0.053978547	),
  (	62	,	2.83038027	,	-0.034188197	),
  (	62	,	2.893938174	,	-0.013144388	),
  (	62	,	2.895536974	,	-1.42586E-05	),
  (	62	,	2.484502242	,	-0.038487472	),
  (	62	,	2.590571786	,	0.103996932	),
  (	62	,	2.713277755	,	0.261375164	),
  (	62	,	3.446133174	,	0.294061943	),
  (	62	,	3.408453575	,	0.298852486	),
  (	62	,	3.43110763	,	0.369190866	),
  (	62	,	3.160257656	,	0.37453219	),
  (	62	,	3.238365453	,	0.432385008	),
  (	62	,	3.230130967	,	0.453820609	),
  (	62	,	3.138504155	,	0.578872176	),
  (	62	,	4.733503611	,	-0.626602395	),
  (	62	,	4.825443162	,	-0.592465877	),
  (	62	,	4.788318651	,	-0.500074626	),
  (	62	,	4.808393861	,	-0.496197059	),
  (	62	,	4.592005509	,	-0.598292559	),
  (	62	,	4.743757956	,	-0.374267446	),
  (	62	,	4.96726809	,	-0.393212339	),
  (	62	,	5.068517541	,	-0.335706113	),
  (	62	,	5.005336975	,	-0.327044871	),
  (	62	,	4.834305748	,	-0.310675003	),
  (	62	,	4.480639731	,	-0.462741154	),
  (	62	,	4.471338476	,	-0.357702965	),
  (	62	,	4.486576895	,	-0.30734016	),
  (	62	,	4.517513347	,	-0.254543285	),
  (	62	,	5.18385104	,	-0.23917613	),
  (	62	,	5.273169131	,	-0.175629568	),
  (	62	,	5.407122014	,	-0.042113966	),
  (	62	,	5.271040857	,	-0.011844762	),
  (	62	,	4.929170298	,	-0.103200375	),
  (	62	,	4.936530096	,	-0.057910125	),
  (	62	,	5.05186793	,	0.035457185	),
  (	62	,	4.958382608	,	-0.031415863	),
  (	62	,	4.928898236	,	0.014592432	),
  (	62	,	4.786065921	,	-0.05252225	),
  (	62	,	5.193625405	,	0.137922774	),
  (	62	,	5.240278051	,	0.14935897	),
  (	62	,	5.273678415	,	0.187201507	),
  (	62	,	5.186688672	,	0.206225086	),
  (	62	,	5.135083637	,	0.196754687	),
  (	62	,	5.168661109	,	0.232176274	),
  (	62	,	4.287611284	,	-0.036301312	),
  (	62	,	4.6800548	,	0.022775059	),
  (	62	,	4.645055535	,	0.045021856	),
  (	62	,	4.521441182	,	0.038154359	),
  (	62	,	4.227974186	,	0.060293418	),
  (	62	,	4.030535014	,	-0.017847528	),
  (	62	,	4.228906723	,	0.111240014	),
  (	62	,	4.736243192	,	0.043485365	),
  (	62	,	4.631836229	,	0.110184999	),
  (	62	,	4.565418293	,	0.132568294	),
  (	62	,	4.791142542	,	0.240453657	),
  (	62	,	4.939421165	,	0.243745341	),
  (	62	,	5.039834034	,	0.352609854	),
  (	62	,	4.7914894	,	0.316457915	),
  (	62	,	4.607638416	,	0.366451786	),
  (	62	,	4.471051364	,	0.342069119	),
  (	62	,	4.519050277	,	0.414391753	),
  (	62	,	4.672276391	,	0.389490992	),
  (	62	,	4.649865725	,	0.54986015	),
  (	62	,	1.440897892	,	-1.479773951	),
  (	62	,	0.983481845	,	-1.250665128	),
  (	62	,	0.623361648	,	-1.285360128	),
  (	62	,	1.470072924	,	-1.161694751	),
  (	62	,	1.156663893	,	-1.068805369	),
  (	62	,	1.041596402	,	-0.996622953	),
  (	62	,	0.093730689	,	-1.351355063	),
  (	62	,	0.145716175	,	-1.243832113	),
  (	62	,	0.371274816	,	-1.123461274	),
  (	62	,	0.505165751	,	-1.062216232	),
  (	62	,	0.716349059	,	-0.917531865	),
  (	62	,	1.286697336	,	-1.021841116	),
  (	62	,	1.128657711	,	-0.922573857	),
  (	62	,	1.165452373	,	-0.819421104	),
  (	62	,	1.315869959	,	-0.693206694	),
  (	62	,	1.266539753	,	-0.721176851	),
  (	62	,	1.01908254	,	-0.818453337	),
  (	62	,	0.917283746	,	-0.722062509	),
  (	62	,	1.18103032	,	-0.622266929	),
  (	62	,	1.319380993	,	-0.554504088	),
  (	62	,	1.207979023	,	-0.536108027	),
  (	62	,	1.24978228	,	-0.490216287	),
  (	62	,	1.128470581	,	-0.400891878	),
  (	62	,	0.186374676	,	-1.051790599	),
  (	62	,	0.399897073	,	-0.795445829	),
  (	62	,	0.510575966	,	-0.903461299	),
  (	62	,	0.707342088	,	-0.669920143	),
  (	62	,	0.192904074	,	-0.670570423	),
  (	62	,	0.429602248	,	-0.637553015	),
  (	62	,	0.394370609	,	-0.457413128	),
  (	62	,	0.842229494	,	-0.627334898	),
  (	62	,	0.742847656	,	-0.625586934	),
  (	62	,	0.900483682	,	-0.47677348	),
  (	62	,	0.717082096	,	-0.567666061	),
  (	62	,	0.819648366	,	-0.485747455	),
  (	62	,	0.850866555	,	-0.455541585	),
  (	62	,	0.757434662	,	-0.390549721	),
  (	62	,	1.172214256	,	-0.339635138	),
  (	62	,	0.93647871	,	-0.17223289	),
  (	62	,	0.914770236	,	-0.118770909	),
  (	62	,	0.780110181	,	-0.17063402	),
  (	62	,	2.876345859	,	-1.476442977	),
  (	62	,	2.311840702	,	-1.266256981	),
  (	62	,	2.965341904	,	-1.311483236	),
  (	62	,	2.725939591	,	-1.29104896	),
  (	62	,	2.852299999	,	-1.234302748	),
  (	62	,	2.749527052	,	-1.169102131	),
  (	62	,	3.044727514	,	-1.180199562	),
  (	62	,	2.855767127	,	-1.079078512	),
  (	62	,	2.601242573	,	-1.245977857	),
  (	62	,	2.561758108	,	-1.135734938	),
  (	62	,	2.481776304	,	-1.08686785	),
  (	62	,	2.631077745	,	-1.050315609	),
  (	62	,	2.207226241	,	-1.1274917	),
  (	62	,	2.114969021	,	-1.096699658	),
  (	62	,	2.092945658	,	-1.050815156	),
  (	62	,	2.031527234	,	-0.989994175	),
  (	62	,	2.10105063	,	-0.967865393	),
  (	62	,	2.461313778	,	-1.075982217	),
  (	62	,	2.488790034	,	-1.018603958	),
  (	62	,	2.441456682	,	-0.963184579	),
  (	62	,	2.4608648	,	-0.902981941	),
  (	62	,	2.303845531	,	-0.922406317	),
  (	62	,	2.458393014	,	-0.842765497	),
  (	62	,	2.859220428	,	-1.056210568	),
  (	62	,	2.850785958	,	-1.027884241	),
  (	62	,	3.057413491	,	-0.941932756	),
  (	62	,	2.788118246	,	-1.026546125	),
  (	62	,	2.763828173	,	-1.015609291	),
  (	62	,	2.789924946	,	-0.970526725	),
  (	62	,	2.880382494	,	-0.90439104	),
  (	62	,	2.991276893	,	-0.65882081	),
  (	62	,	2.639938071	,	-0.895590204	),
  (	62	,	2.664374734	,	-0.728084089	),
  (	62	,	2.678044518	,	-0.704170586	),
  (	62	,	2.422707358	,	-0.795093558	),
  (	62	,	2.483890607	,	-0.670267883	),
  (	62	,	2.57202615	,	-0.649030406	),
  (	62	,	2.519698848	,	-0.629994222	),
  (	62	,	2.882748124	,	-0.55568943	),
  (	62	,	2.756785651	,	-0.492830842	),
  (	62	,	2.77052973	,	-0.404497605	),
  (	62	,	1.679572039	,	-1.114009753	),
  (	62	,	1.789037485	,	-1.051532794	),
  (	62	,	1.965746502	,	-0.949444696	),
  (	62	,	1.899580546	,	-0.916269654	),
  (	62	,	1.673896601	,	-0.910730277	),
  (	62	,	1.864102375	,	-0.907012264	),
  (	62	,	2.090925592	,	-0.872259588	),
  (	62	,	2.091016971	,	-0.872205866	),
  (	62	,	2.114930108	,	-0.882968802	),
  (	62	,	2.123599663	,	-0.846437898	),
  (	62	,	2.296832545	,	-0.717772505	),
  (	62	,	2.220352753	,	-0.743290619	),
  (	62	,	2.266146839	,	-0.638900509	),
  (	62	,	2.056603435	,	-0.752153089	),
  (	62	,	2.038087363	,	-0.686453423	),
  (	62	,	2.187785094	,	-0.69151123	),
  (	62	,	1.826901611	,	-0.798795761	),
  (	62	,	1.608219665	,	-0.77416112	),
  (	62	,	1.599955365	,	-0.738253306	),
  (	62	,	1.977539784	,	-0.699152366	),
  (	62	,	1.937192944	,	-0.625485973	),
  (	62	,	1.981873378	,	-0.584039315	),
  (	62	,	1.944803205	,	-0.553944614	),
  (	62	,	1.858809471	,	-0.535042425	),
  (	62	,	1.885246791	,	-0.537931652	),
  (	62	,	1.893487963	,	-0.529528756	),
  (	62	,	1.814760951	,	-0.554842491	),
  (	62	,	1.80455976	,	-0.498166921	),
  (	62	,	1.82441797	,	-0.474107977	),
  (	62	,	2.490449332	,	-0.556574299	),
  (	62	,	2.394260532	,	-0.467181343	),
  (	62	,	2.594124451	,	-0.392480394	),
  (	62	,	2.635648636	,	-0.315928655	),
  (	62	,	2.655471921	,	-0.272479347	),
  (	62	,	2.499875912	,	-0.235912597	),
  (	62	,	2.290388673	,	-0.369447761	),
  (	62	,	2.008111918	,	-0.343145202	),
  (	62	,	2.341221815	,	-0.291626009	),
  (	62	,	2.494293696	,	-0.184168771	),
  (	62	,	2.410446425	,	-0.124088216	),
  (	62	,	2.331269339	,	-0.094845501	),
  (	62	,	3.646178378	,	-1.442800069	),
  (	62	,	3.701960436	,	-1.306362193	),
  (	62	,	3.927805073	,	-1.346707004	),
  (	62	,	3.926679797	,	-1.30956966	),
  (	62	,	4.52298462	,	-1.300852983	),
  (	62	,	4.017204195	,	-1.177776097	),
  (	62	,	4.135928123	,	-1.142194717	),
  (	62	,	4.201326034	,	-1.091559982	),
  (	62	,	4.166437926	,	-1.060177234	),
  (	62	,	4.193615958	,	-0.95256918	),
  (	62	,	3.388236728	,	-1.259871187	),
  (	62	,	3.213124904	,	-1.267364072	),
  (	62	,	3.528960162	,	-1.215224488	),
  (	62	,	3.829886054	,	-1.185671283	),
  (	62	,	3.311205109	,	-1.172740107	),
  (	62	,	3.476442471	,	-1.136883744	),
  (	62	,	3.315813327	,	-1.160839014	),
  (	62	,	3.230899055	,	-1.149172557	),
  (	62	,	3.501989575	,	-1.064165276	),
  (	62	,	3.572756012	,	-1.005706821	),
  (	62	,	3.680194737	,	-0.981112169	),
  (	62	,	3.769069804	,	-0.92810178	),
  (	62	,	4.573331768	,	-1.1001927	),
  (	62	,	4.605850606	,	-1.044512695	),
  (	62	,	4.424426755	,	-1.010726688	),
  (	62	,	4.534401553	,	-1.041868523	),
  (	62	,	4.646642678	,	-1.004360648	),
  (	62	,	4.702406682	,	-0.993028345	),
  (	62	,	4.662792485	,	-0.966938457	),
  (	62	,	4.575593259	,	-0.962893873	),
  (	62	,	4.501400877	,	-0.85300235	),
  (	62	,	4.383664463	,	-0.927684047	),
  (	62	,	4.433777511	,	-0.88444309	),
  (	62	,	4.45254674	,	-0.849073321	),
  (	62	,	4.589423469	,	-0.803493962	),
  (	62	,	4.675476103	,	-0.7116204	),
  (	62	,	4.577188092	,	-0.767490805	),
  (	62	,	4.423128791	,	-0.751385118	),
  (	62	,	4.435752643	,	-0.712503897	),
  (	62	,	4.417675197	,	-0.710755678	),
  (	62	,	4.411321224	,	-0.654753231	),
  (	62	,	4.576841205	,	-0.641902901	),
  (	62	,	4.550567264	,	-0.649630057	),
  (	62	,	4.521957298	,	-0.624001951	),
  (	62	,	4.47883275	,	-0.618737715	),
  (	62	,	4.453278698	,	-0.62717682	),
  (	62	,	4.519771607	,	-0.527282223	),
  (	62	,	4.146350243	,	-0.792413485	),
  (	62	,	4.286895797	,	-0.766411458	),
  (	62	,	4.192697527	,	-0.705727965	),
  (	62	,	4.021185337	,	-0.711215885	),
  (	62	,	4.134119453	,	-0.66179042	),
  (	62	,	4.084893905	,	-0.577581263	),
  (	62	,	4.207535019	,	-0.579692616	),
  (	62	,	3.169429762	,	-1.146847194	),
  (	62	,	3.203908508	,	-1.124140729	),
  (	62	,	3.189931216	,	-1.069495022	),
  (	62	,	3.163200087	,	-1.064097478	),
  (	62	,	3.465344505	,	-1.024229461	),
  (	62	,	3.650125666	,	-0.954804019	),
  (	62	,	3.237396457	,	-0.983918689	),
  (	62	,	3.373130997	,	-0.959101063	),
  (	62	,	3.484463455	,	-0.895107357	),
  (	62	,	3.522702764	,	-0.861866551	),
  (	62	,	3.503206917	,	-0.836767228	),
  (	62	,	3.662105253	,	-0.879118291	),
  (	62	,	3.836114833	,	-0.813078442	),
  (	62	,	3.870646226	,	-0.668307623	),
  (	62	,	3.801243496	,	-0.678401187	),
  (	62	,	3.565263649	,	-0.770445917	),
  (	62	,	3.590644202	,	-0.72259029	),
  (	62	,	3.630349301	,	-0.551862019	),
  (	62	,	3.622024247	,	-0.507568642	),
  (	62	,	3.971152911	,	-0.677059512	),
  (	62	,	3.87739564	,	-0.639401662	),
  (	62	,	4.090504977	,	-0.45867286	),
  (	62	,	3.990530218	,	-0.310121925	),
  (	62	,	4.018724207	,	-0.271366313	),
  (	62	,	4.173772774	,	-0.258826689	),
  (	62	,	3.922058737	,	-0.087091736	),
  (	62	,	5.344725403	,	-1.454043857	),
  (	62	,	5.403148405	,	-1.418766376	),
  (	62	,	6.058087983	,	-1.38720404	),
  (	62	,	4.896708985	,	-1.427822937	),
  (	62	,	4.840359786	,	-1.400332561	),
  (	62	,	6.188973816	,	-1.341629667	),
  (	62	,	5.998061846	,	-1.223008125	),
  (	62	,	5.663809595	,	-1.13139631	),
  (	62	,	5.743159458	,	-1.010537505	),
  (	62	,	4.929372013	,	-1.274016833	),
  (	62	,	5.110254925	,	-1.194398918	),
  (	62	,	5.260452868	,	-1.175053015	),
  (	62	,	5.299020371	,	-1.106810579	),
  (	62	,	4.974451059	,	-1.163330421	),
  (	62	,	5.461339289	,	-1.089603062	),
  (	62	,	5.612356533	,	-0.954000245	),
  (	62	,	5.474162383	,	-0.885361069	),
  (	62	,	6.125722429	,	-0.939143897	),
  (	62	,	6.112309913	,	-0.878023815	),
  (	62	,	5.937689359	,	-1.002209221	),
  (	62	,	5.993641119	,	-0.848209893	),
  (	62	,	6.139863811	,	-0.875408031	),
  (	62	,	6.094093403	,	-0.776483503	),
  (	62	,	6.065730608	,	-0.708461578	),
  (	62	,	5.658426398	,	-0.576794817	),
  (	62	,	5.983637492	,	-0.515507421	),
  (	62	,	5.816123087	,	-0.459509992	),
  (	62	,	5.914951594	,	-0.418724364	),
  (	62	,	4.823772252	,	-1.099945714	),
  (	62	,	4.944518549	,	-0.906376101	),
  (	62	,	4.830505777	,	-0.926946687	),
  (	62	,	4.912811313	,	-0.88789812	),
  (	62	,	4.991471915	,	-0.890460542	),
  (	62	,	5.004354296	,	-0.87830832	),
  (	62	,	4.943812637	,	-0.844066634	),
  (	62	,	5.320223763	,	-0.830454928	),
  (	62	,	5.19337866	,	-0.830034344	),
  (	62	,	5.237148253	,	-0.658019316	),
  (	62	,	4.943638447	,	-0.813083655	),
  (	62	,	4.962139164	,	-0.766499664	),
  (	62	,	4.983539656	,	-0.731477708	),
  (	62	,	4.793849897	,	-0.738072291	),
  (	62	,	5.083563645	,	-0.511552253	),
  (	62	,	5.023555475	,	-0.514914579	),
  (	62	,	5.149245994	,	-0.408916125	),
  (	62	,	5.1090203	,	-0.371971344	),
  (	62	,	5.508513619	,	-0.672513022	),
  (	62	,	5.497780182	,	-0.630588068	),
  (	62	,	5.5558943	,	-0.635710114	),
  (	62	,	5.807771601	,	-0.370587151	),
  (	62	,	5.242086377	,	-0.396842458	),
  (	62	,	5.391060526	,	-0.288434446	),
  (	62	,	5.133167147	,	-0.329047136	),
  (	62	,	5.496053387	,	-0.332230583	),
  (	62	,	5.597867865	,	-0.162656488	),
  (	63	,	0.805621742	,	0.032526027	),
  (	63	,	0.904567236	,	0.222271721	),
  (	63	,	0.890857479	,	0.220425497	),
  (	63	,	0.652706438	,	0.166951922	),
  (	63	,	0.708959444	,	0.187475675	),
  (	63	,	0.834986797	,	0.227729811	),
  (	63	,	1.101843835	,	0.301546176	),
  (	63	,	1.049880339	,	0.301879855	),
  (	63	,	0.909503362	,	0.397991689	),
  (	63	,	0.992007024	,	0.420902813	),
  (	63	,	0.534876038	,	0.235212738	),
  (	63	,	0.572470878	,	0.452684451	),
  (	63	,	0.830998682	,	0.469433146	),
  (	63	,	0.683803932	,	0.55165791	),
  (	63	,	0.855352616	,	0.605423647	),
  (	63	,	0.776839853	,	0.673955567	),
  (	63	,	1.23582272	,	0.420428584	),
  (	63	,	1.246636572	,	0.412384143	),
  (	63	,	1.21905302	,	0.440140683	),
  (	63	,	1.012612305	,	0.543989781	),
  (	63	,	1.45576359	,	0.606073898	),
  (	63	,	1.469887894	,	0.701314529	),
  (	63	,	1.338779986	,	0.75354062	),
  (	63	,	1.083208084	,	0.658445287	),
  (	63	,	0.951221024	,	0.743207854	),
  (	63	,	0.850610746	,	0.74182893	),
  (	63	,	0.808738739	,	0.708292087	),
  (	63	,	0.977852042	,	0.846896215	),
  (	63	,	0.922792308	,	0.858872486	),
  (	63	,	1.307999978	,	0.927736343	),
  (	63	,	1.496744986	,	0.987537369	),
  (	63	,	1.16507314	,	1.005051613	),
  (	63	,	1.337347359	,	1.067603732	),
  (	63	,	0.373481398	,	0.410350638	),
  (	63	,	0.281273601	,	0.517630929	),
  (	63	,	0.29683262	,	0.558714095	),
  (	63	,	0.332992522	,	0.577956706	),
  (	63	,	0.401975541	,	0.607373342	),
  (	63	,	0.573420102	,	0.550238119	),
  (	63	,	0.690696022	,	0.658449914	),
  (	63	,	0.691439403	,	0.664779596	),
  (	63	,	0.678346749	,	0.692269892	),
  (	63	,	0.429917099	,	0.792374152	),
  (	63	,	0.607285078	,	0.811092587	),
  (	63	,	0.49237855	,	0.898404606	),
  (	63	,	0.233309738	,	0.653065839	),
  (	63	,	0.251594379	,	0.800047362	),
  (	63	,	0.003176245	,	0.789819772	),
  (	63	,	0.279426726	,	0.916328241	),
  (	63	,	0.223720367	,	1.078709099	),
  (	63	,	0.014958856	,	1.110736496	),
  (	63	,	0.770365928	,	0.823167281	),
  (	63	,	0.820589464	,	0.911294878	),
  (	63	,	0.645179961	,	0.882601613	),
  (	63	,	0.633847356	,	0.988027616	),
  (	63	,	0.810139587	,	0.978585268	),
  (	63	,	1.471601233	,	1.164075724	),
  (	63	,	1.321412203	,	1.166240205	),
  (	63	,	1.010970943	,	1.195678701	),
  (	63	,	1.268011051	,	1.238160669	),
  (	63	,	1.107183948	,	1.258834708	),
  (	63	,	1.319169815	,	1.296249928	),
  (	63	,	0.457147316	,	0.99639547	),
  (	63	,	0.446349308	,	1.02324617	),
  (	63	,	0.449300768	,	1.07199885	),
  (	63	,	0.374253826	,	1.238831039	),
  (	63	,	0.737076048	,	1.215352163	),
  (	63	,	0.536470286	,	1.35989467	),
  (	63	,	2.28636328	,	0.075651592	),
  (	63	,	2.362836727	,	0.09845329	),
  (	63	,	2.512751268	,	0.250970927	),
  (	63	,	2.092578606	,	0.231117518	),
  (	63	,	2.151097114	,	0.288227268	),
  (	63	,	2.270887589	,	0.341119856	),
  (	63	,	2.087956086	,	0.288304964	),
  (	63	,	2.059247455	,	0.337281769	),
  (	63	,	2.044480445	,	0.403886079	),
  (	63	,	2.211245942	,	0.470093129	),
  (	63	,	2.211263583	,	0.470113107	),
  (	63	,	2.101937148	,	0.437895282	),
  (	63	,	2.401344977	,	0.383910507	),
  (	63	,	2.402647605	,	0.540404578	),
  (	63	,	2.331084856	,	0.53370822	),
  (	63	,	2.292302456	,	0.535776225	),
  (	63	,	2.270252177	,	0.557487548	),
  (	63	,	2.314895388	,	0.580923664	),
  (	63	,	2.856672382	,	0.444897108	),
  (	63	,	2.802072797	,	0.553214604	),
  (	63	,	2.678327872	,	0.473609111	),
  (	63	,	2.654048466	,	0.551588132	),
  (	63	,	2.877824395	,	0.629937309	),
  (	63	,	2.863398167	,	0.733168809	),
  (	63	,	2.542582403	,	0.845277482	),
  (	63	,	2.640563478	,	0.914051664	),
  (	63	,	3.009477929	,	0.990253412	),
  (	63	,	3.056318969	,	1.011776068	),
  (	63	,	2.707518798	,	0.946261551	),
  (	63	,	2.006695092	,	0.558669566	),
  (	63	,	2.203831718	,	0.611062911	),
  (	63	,	2.239942906	,	0.635936164	),
  (	63	,	2.07553871	,	0.618064815	),
  (	63	,	2.20222759	,	0.733130831	),
  (	63	,	2.125659783	,	0.755031672	),
  (	63	,	1.802309953	,	0.624617943	),
  (	63	,	1.828433054	,	0.664123428	),
  (	63	,	1.802604552	,	0.782597516	),
  (	63	,	1.585211257	,	0.748930604	),
  (	63	,	1.630816554	,	0.89312037	),
  (	63	,	1.622131887	,	0.9188579	),
  (	63	,	1.855066142	,	0.833831695	),
  (	63	,	2.062134458	,	0.963581207	),
  (	63	,	1.820463759	,	1.004670825	),
  (	63	,	1.802417809	,	1.037569133	),
  (	63	,	2.446636536	,	0.894779054	),
  (	63	,	2.550823121	,	1.134189058	),
  (	63	,	2.010726737	,	0.996283052	),
  (	63	,	2.10535906	,	1.10113194	),
  (	63	,	1.943274512	,	1.418206959	),
  (	63	,	2.201501061	,	1.438685351	),
  (	63	,	4.083583894	,	0.196621344	),
  (	63	,	4.024673442	,	0.219344209	),
  (	63	,	4.160785291	,	0.280557808	),
  (	63	,	4.276364396	,	0.368827457	),
  (	63	,	4.082113771	,	0.308145925	),
  (	63	,	4.04762819	,	0.438104316	),
  (	63	,	3.646974106	,	0.245333299	),
  (	63	,	3.659359016	,	0.255670887	),
  (	63	,	3.766022802	,	0.442242442	),
  (	63	,	3.986038276	,	0.401147813	),
  (	63	,	4.367723953	,	0.433866509	),
  (	63	,	4.428932624	,	0.449082729	),
  (	63	,	4.677823643	,	0.697825362	),
  (	63	,	4.484521336	,	0.707134399	),
  (	63	,	4.385995838	,	0.754275914	),
  (	63	,	4.032080236	,	0.790128848	),
  (	63	,	4.471667141	,	0.851781123	),
  (	63	,	4.496447633	,	0.914704534	),
  (	63	,	4.596879623	,	1.00458977	),
  (	63	,	4.447779275	,	0.989406993	),
  (	63	,	3.546533184	,	0.424907575	),
  (	63	,	3.670306158	,	0.477988528	),
  (	63	,	3.751570434	,	0.677082551	),
  (	63	,	3.816340426	,	0.639239745	),
  (	63	,	3.539785915	,	0.734894357	),
  (	63	,	3.378150515	,	0.585290868	),
  (	63	,	3.445457528	,	0.653156115	),
  (	63	,	3.390867422	,	0.805930633	),
  (	63	,	3.354060448	,	0.845907281	),
  (	63	,	3.272640836	,	0.899469569	),
  (	63	,	3.272809317	,	1.025689404	),
  (	63	,	3.929804854	,	0.82514895	),
  (	63	,	3.803555971	,	1.051137932	),
  (	63	,	4.228264595	,	1.011209898	),
  (	63	,	4.170574474	,	1.028207502	),
  (	63	,	4.460455615	,	1.127499898	),
  (	63	,	4.45787665	,	1.314180656	),
  (	63	,	3.579469028	,	0.998464171	),
  (	63	,	3.189565036	,	1.426105242	),
  (	63	,	5.453303486	,	0.137257554	),
  (	63	,	5.55660824	,	0.278942255	),
  (	63	,	5.416061494	,	0.254519193	),
  (	63	,	5.703222789	,	0.300090933	),
  (	63	,	5.652470373	,	0.426770168	),
  (	63	,	5.335799154	,	0.253963697	),
  (	63	,	5.651912796	,	0.492137065	),
  (	63	,	5.596844213	,	0.529008226	),
  (	63	,	5.334692644	,	0.545673808	),
  (	63	,	5.399742849	,	0.551044696	),
  (	63	,	5.462908839	,	0.573320455	),
  (	63	,	5.5286241	,	0.676558779	),
  (	63	,	5.511231723	,	0.674698421	),
  (	63	,	5.880767229	,	0.555717162	),
  (	63	,	5.917241489	,	0.620937383	),
  (	63	,	5.946878147	,	0.659781522	),
  (	63	,	5.842222114	,	0.659203743	),
  (	63	,	5.91609132	,	0.69164109	),
  (	63	,	5.863928151	,	0.673251576	),
  (	63	,	6.106285077	,	0.60725548	),
  (	63	,	6.198909319	,	0.640901052	),
  (	63	,	6.15516727	,	0.67478567	),
  (	63	,	6.263801124	,	0.826513815	),
  (	63	,	5.99167127	,	0.701051579	),
  (	63	,	5.95195308	,	0.688796827	),
  (	63	,	6.111857694	,	0.769967873	),
  (	63	,	6.202227387	,	0.864152508	),
  (	63	,	5.854918189	,	0.734402175	),
  (	63	,	5.797452416	,	0.798358596	),
  (	63	,	5.661256913	,	0.780098664	),
  (	63	,	5.683869856	,	0.865686734	),
  (	63	,	6.083526923	,	0.883448193	),
  (	63	,	5.791989658	,	0.930389815	),
  (	63	,	5.966354256	,	1.020722269	),
  (	63	,	6.234761006	,	1.046832315	),
  (	63	,	5.991120876	,	1.048961283	),
  (	63	,	5.10224476	,	0.35394632	),
  (	63	,	5.131875785	,	0.394195052	),
  (	63	,	5.085121	,	0.434733489	),
  (	63	,	5.04396497	,	0.487405969	),
  (	63	,	4.995884821	,	0.536396012	),
  (	63	,	4.982069815	,	0.586801226	),
  (	63	,	4.978203546	,	0.589959202	),
  (	63	,	5.072607662	,	0.584998495	),
  (	63	,	5.306050109	,	0.678895121	),
  (	63	,	5.324361021	,	0.687712963	),
  (	63	,	5.258555323	,	0.671589539	),
  (	63	,	5.189992399	,	0.675618309	),
  (	63	,	5.157272407	,	0.702571456	),
  (	63	,	5.198129697	,	0.826890741	),
  (	63	,	5.290651381	,	0.898206777	),
  (	63	,	4.951827027	,	0.592863288	),
  (	63	,	4.902640976	,	0.638040198	),
  (	63	,	4.970718839	,	0.684471323	),
  (	63	,	4.872784726	,	0.754361721	),
  (	63	,	4.726128979	,	0.845862306	),
  (	63	,	5.121204155	,	0.859788224	),
  (	63	,	5.010950266	,	0.914995017	),
  (	63	,	4.891026307	,	1.095191132	),
  (	63	,	5.565941227	,	0.837303841	),
  (	63	,	5.453765177	,	0.814393828	),
  (	63	,	5.439504319	,	0.812129296	),
  (	63	,	5.388005714	,	0.905026317	),
  (	63	,	5.448536766	,	0.906006441	),
  (	63	,	5.587475217	,	1.060397052	),
  (	63	,	5.786756613	,	0.983378092	),
  (	63	,	5.886798526	,	1.019344228	),
  (	63	,	5.972247803	,	1.098476605	),
  (	63	,	5.747305569	,	1.154642685	),
  (	63	,	5.90481461	,	1.228254697	),
  (	63	,	5.804329075	,	1.258576326	),
  (	63	,	5.259367176	,	0.983352469	),
  (	63	,	5.2157804	,	1.016648474	),
  (	63	,	5.256679112	,	1.115098854	),
  (	63	,	5.109466614	,	1.239001876	),
  (	63	,	5.815792022	,	1.279454461	),
  (	63	,	0.029835097	,	-0.40330839	),
  (	63	,	6.254164561	,	-0.422881639	),
  (	63	,	0.177006278	,	-0.415516348	),
  (	63	,	0.216232521	,	-0.40774785	),
  (	63	,	0.198431572	,	-0.22483743	),
  (	63	,	0.191265513	,	-0.209670308	),
  (	63	,	6.027428809	,	-0.397779315	),
  (	63	,	6.159706072	,	-0.372966808	),
  (	63	,	6.098482475	,	-0.204428754	),
  (	63	,	6.233187345	,	-0.111361793	),
  (	63	,	0.033754371	,	-0.04448262	),
  (	63	,	0.286294361	,	-0.174176195	),
  (	63	,	0.366725676	,	-0.139763837	),
  (	63	,	0.63256512	,	-0.048521539	),
  (	63	,	0.706008328	,	-0.056092764	),
  (	63	,	0.106871839	,	-0.038734992	),
  (	63	,	0.28308419	,	0.098718637	),
  (	63	,	0.325967137	,	0.122085331	),
  (	63	,	5.89175241	,	-0.254573155	),
  (	63	,	5.971226902	,	-0.184226847	),
  (	63	,	5.896193865	,	-0.114417406	),
  (	63	,	5.6996854	,	-0.161894694	),
  (	63	,	5.804756724	,	-0.067970137	),
  (	63	,	5.733250025	,	0.119814123	),
  (	63	,	6.015755249	,	0.12810053	),
  (	63	,	5.850915785	,	0.142888258	),
  (	63	,	5.768414686	,	0.191529264	),
  (	63	,	6.252990285	,	0.036486949	),
  (	63	,	0.072285106	,	0.143816063	),
  (	63	,	0.079789991	,	0.195581977	),
  (	63	,	0.306267465	,	0.273558686	),
  (	63	,	0.363969448	,	0.357249825	),
  (	63	,	0.12309911	,	0.287018966	),
  (	63	,	6.120327649	,	0.363528254	),
  (	63	,	5.991004792	,	0.293930969	),
  (	63	,	6.048913865	,	0.323203513	),
  (	63	,	5.933174493	,	0.343499352	),
  (	63	,	0.066220255	,	0.476184082	),
  (	63	,	0.02890764	,	0.506499249	),
  (	63	,	0.021435406	,	0.60493473	),
  (	63	,	0.037866486	,	0.639248846	),
  (	63	,	1.489852085	,	-0.58295444	),
  (	63	,	1.466828771	,	-0.501049726	),
  (	63	,	1.768842161	,	-0.409493817	),
  (	63	,	1.757397163	,	-0.391789788	),
  (	63	,	1.730861182	,	-0.394700577	),
  (	63	,	1.853472545	,	-0.38452975	),
  (	63	,	1.941015461	,	-0.331826645	),
  (	63	,	1.915638188	,	-0.336504367	),
  (	63	,	1.876912385	,	-0.326125365	),
  (	63	,	1.611535596	,	-0.316367749	),
  (	63	,	1.735207143	,	-0.226648305	),
  (	63	,	1.429463432	,	-0.373072687	),
  (	63	,	1.393168239	,	-0.323232295	),
  (	63	,	1.480345672	,	-0.311530889	),
  (	63	,	1.37008123	,	-0.254938107	),
  (	63	,	1.325877678	,	-0.250807418	),
  (	63	,	1.652884514	,	-0.262233341	),
  (	63	,	1.572079958	,	-0.225154118	),
  (	63	,	1.687504997	,	-0.131109695	),
  (	63	,	1.463633307	,	-0.094542496	),
  (	63	,	1.55154992	,	-0.083579928	),
  (	63	,	1.966946633	,	-0.170638543	),
  (	63	,	1.928739424	,	-0.156718143	),
  (	63	,	2.182611706	,	-0.015880973	),
  (	63	,	2.180926367	,	0.068904143	),
  (	63	,	1.792037661	,	-0.140341548	),
  (	63	,	1.810699718	,	-0.048932037	),
  (	63	,	1.672497927	,	0.065701698	),
  (	63	,	1.754000092	,	0.110748905	),
  (	63	,	2.082459911	,	0.150814791	),
  (	63	,	2.046536835	,	0.233382271	),
  (	63	,	1.829698401	,	0.127704233	),
  (	63	,	1.826694989	,	0.133031442	),
  (	63	,	1.813294776	,	0.145286666	),
  (	63	,	1.849437124	,	0.21981018	),
  (	63	,	1.981305739	,	0.184446013	),
  (	63	,	1.94903857	,	0.192139252	),
  (	63	,	1.939326106	,	0.270826108	),
  (	63	,	1.184338214	,	-0.238141752	),
  (	63	,	1.192793479	,	-0.188236083	),
  (	63	,	1.032507961	,	-0.170183241	),
  (	63	,	1.07312659	,	-0.15456921	),
  (	63	,	1.196579486	,	-0.119346968	),
  (	63	,	1.204398831	,	-0.063035636	),
  (	63	,	1.368140209	,	-0.14220565	),
  (	63	,	1.375787996	,	-0.024583854	),
  (	63	,	1.464324436	,	-0.056772916	),
  (	63	,	1.547818398	,	0.016905562	),
  (	63	,	1.420734387	,	-0.026027898	),
  (	63	,	1.431276822	,	0.022658854	),
  (	63	,	1.249669825	,	-0.051572717	),
  (	63	,	1.352867597	,	-0.009872811	),
  (	63	,	1.332539489	,	0.02055301	),
  (	63	,	1.220803751	,	-0.018370062	),
  (	63	,	1.25988209	,	0.06262967	),
  (	63	,	1.443323397	,	0.103816186	),
  (	63	,	0.959903816	,	-0.01956975	),
  (	63	,	1.106694988	,	-0.020067096	),
  (	63	,	1.342325788	,	0.165267465	),
  (	63	,	1.19468987	,	0.164294838	),
  (	63	,	1.138311294	,	0.241978379	),
  (	63	,	1.712115546	,	0.203736916	),
  (	63	,	1.751287602	,	0.286192621	),
  (	63	,	1.741353359	,	0.384508595	),
  (	63	,	1.83026259	,	0.45228615	),
  (	63	,	1.827294941	,	0.455212116	),
  (	63	,	1.392963796	,	0.351411375	),
  (	63	,	1.264206724	,	0.277580104	),
  (	63	,	1.376456864	,	0.388943157	),
  (	63	,	1.400576998	,	0.487943762	),
  (	63	,	1.57818538	,	0.390969991	),
  (	63	,	1.641993019	,	0.418355044	),
  (	63	,	1.598610136	,	0.515088138	),
  (	63	,	1.489420768	,	0.514649262	),
  (	63	,	1.438493663	,	0.50939421	),
  (	63	,	1.583546823	,	0.569574715	),
  (	63	,	1.59757852	,	0.617596712	),
  (	63	,	1.53880801	,	0.591972513	),
  (	63	,	3.185404129	,	-0.605712737	),
  (	63	,	3.252014807	,	-0.484311688	),
  (	63	,	3.29858864	,	-0.35827827	),
  (	63	,	3.287195871	,	-0.345447302	),
  (	63	,	2.890307395	,	-0.468313204	),
  (	63	,	3.099384796	,	-0.27687111	),
  (	63	,	3.071431558	,	-0.116543536	),
  (	63	,	3.609443204	,	-0.169467937	),
  (	63	,	3.862385644	,	-0.024740893	),
  (	63	,	3.799392406	,	0.083290556	),
  (	63	,	3.68233473	,	0.085537747	),
  (	63	,	3.26314026	,	-0.080551472	),
  (	63	,	3.366800471	,	0.053353359	),
  (	63	,	3.307716368	,	0.05728807	),
  (	63	,	3.346840702	,	0.103846855	),
  (	63	,	3.493674372	,	0.051350967	),
  (	63	,	3.587533308	,	0.146394684	),
  (	63	,	2.776281109	,	-0.285261806	),
  (	63	,	2.661371332	,	-0.211105048	),
  (	63	,	2.688458398	,	-0.1955366	),
  (	63	,	3.093664144	,	-0.005561501	),
  (	63	,	2.981450251	,	0.002303482	),
  (	63	,	2.851055075	,	-0.039367486	),
  (	63	,	2.471263285	,	-0.025553506	),
  (	63	,	2.498828156	,	0.032531557	),
  (	63	,	2.71838101	,	0.114178702	),
  (	63	,	2.609824109	,	0.145103032	),
  (	63	,	3.2784106	,	0.132721437	),
  (	63	,	3.322976826	,	0.181972695	),
  (	63	,	3.376469941	,	0.216739486	),
  (	63	,	3.370479005	,	0.281388823	),
  (	63	,	3.406177146	,	0.320676682	),
  (	63	,	3.251781803	,	0.417586078	),
  (	63	,	3.225889895	,	0.402029711	),
  (	63	,	3.288069224	,	0.423816944	),
  (	63	,	2.811023113	,	0.344854149	),
  (	63	,	3.072734965	,	0.440143672	),
  (	63	,	3.222442642	,	0.527931101	),
  (	63	,	3.10301361	,	0.582506352	),
  (	63	,	4.703500181	,	-0.683064013	),
  (	63	,	4.720263853	,	-0.634915897	),
  (	63	,	4.685154992	,	-0.607131479	),
  (	63	,	4.681062383	,	-0.595416874	),
  (	63	,	4.835009868	,	-0.467006213	),
  (	63	,	4.629380004	,	-0.56224917	),
  (	63	,	4.662053404	,	-0.470802281	),
  (	63	,	4.895044075	,	-0.415974994	),
  (	63	,	4.98755542	,	-0.335901814	),
  (	63	,	4.477626343	,	-0.376382591	),
  (	63	,	4.558004685	,	-0.321940198	),
  (	63	,	4.404605086	,	-0.273455978	),
  (	63	,	4.537372285	,	-0.309913649	),
  (	63	,	4.56856065	,	-0.218391713	),
  (	63	,	5.057087167	,	-0.271198357	),
  (	63	,	5.188155107	,	-0.189732301	),
  (	63	,	5.284717425	,	-0.154328269	),
  (	63	,	5.322042249	,	-0.018819653	),
  (	63	,	5.485467854	,	0.008086879	),
  (	63	,	5.017210765	,	-0.007472742	),
  (	63	,	4.967184406	,	0.108894352	),
  (	63	,	4.833857883	,	0.065423708	),
  (	63	,	5.105854399	,	0.050685534	),
  (	63	,	5.143557374	,	0.059018232	),
  (	63	,	5.198009065	,	0.168070782	),
  (	63	,	5.201288644	,	0.202912014	),
  (	63	,	5.158379627	,	0.212811548	),
  (	63	,	5.094464691	,	0.249275752	),
  (	63	,	5.080512535	,	0.295617003	),
  (	63	,	4.271721418	,	-0.259579403	),
  (	63	,	4.245261699	,	-0.073668884	),
  (	63	,	4.262629754	,	-0.06899811	),
  (	63	,	4.523510253	,	-0.108996344	),
  (	63	,	4.583208377	,	-0.018562771	),
  (	63	,	4.425181906	,	-0.028149688	),
  (	63	,	4.368528217	,	-0.017460157	),
  (	63	,	4.205198302	,	0.087038632	),
  (	63	,	4.305880556	,	0.040977264	),
  (	63	,	4.213367006	,	0.14130642	),
  (	63	,	4.165539239	,	0.149755081	),
  (	63	,	4.303058651	,	0.199100013	),
  (	63	,	4.348990516	,	0.270477673	),
  (	63	,	4.661502678	,	0.066396819	),
  (	63	,	4.699008849	,	0.113232055	),
  (	63	,	4.716233102	,	0.109401479	),
  (	63	,	4.620600438	,	0.232645172	),
  (	63	,	4.639814272	,	0.249501251	),
  (	63	,	4.643829762	,	0.251504953	),
  (	63	,	4.630284073	,	0.264911967	),
  (	63	,	4.825487562	,	0.261207709	),
  (	63	,	5.008908346	,	0.294110251	),
  (	63	,	5.084899641	,	0.353806273	),
  (	63	,	5.009356919	,	0.378726911	),
  (	63	,	4.923024676	,	0.410408914	),
  (	63	,	4.467903327	,	0.236780422	),
  (	63	,	4.457357266	,	0.260921617	),
  (	63	,	4.498814641	,	0.423031292	),
  (	63	,	4.821360488	,	0.478128025	),
  (	63	,	4.799078421	,	0.517776572	),
  (	63	,	4.624940618	,	0.544587123	),
  (	63	,	4.715033588	,	0.579685119	),
  (	63	,	4.70674134	,	0.633335453	),
  (	63	,	1.214579795	,	-1.355354327	),
  (	63	,	0.505520181	,	-1.367433563	),
  (	63	,	0.408618916	,	-1.370184221	),
  (	63	,	0.890293819	,	-1.215176262	),
  (	63	,	1.33586024	,	-1.274740192	),
  (	63	,	0.52223632	,	-1.15307823	),
  (	63	,	0.646100379	,	-1.122241913	),
  (	63	,	0.751891324	,	-1.09797883	),
  (	63	,	0.707474189	,	-0.812016146	),
  (	63	,	1.441052279	,	-1.115741315	),
  (	63	,	1.417082379	,	-0.913092661	),
  (	63	,	1.369598649	,	-0.908109656	),
  (	63	,	1.417757859	,	-0.771883028	),
  (	63	,	1.498822465	,	-0.687779887	),
  (	63	,	1.247570335	,	-0.68690492	),
  (	63	,	0.899704622	,	-0.726698368	),
  (	63	,	0.254699959	,	-1.059346349	),
  (	63	,	0.270659758	,	-0.994877253	),
  (	63	,	0.155145593	,	-0.956828328	),
  (	63	,	0.196391336	,	-0.937501378	),
  (	63	,	0.569524611	,	-0.886964299	),
  (	63	,	0.506832413	,	-0.869808347	),
  (	63	,	0.63081914	,	-0.712787228	),
  (	63	,	0.494760607	,	-0.673599822	),
  (	63	,	0.173954888	,	-0.781840699	),
  (	63	,	0.13292267	,	-0.714528515	),
  (	63	,	0.442690275	,	-0.665536512	),
  (	63	,	0.783821555	,	-0.567356467	),
  (	63	,	0.933513783	,	-0.542441925	),
  (	63	,	0.882576358	,	-0.44659146	),
  (	63	,	1.062087196	,	-0.351575754	),
  (	63	,	0.561824495	,	-0.310307396	),
  (	63	,	0.752877388	,	-0.222896484	),
  (	63	,	0.857812831	,	-0.159773361	),
  (	63	,	0.834759144	,	-0.066526987	),
  (	63	,	2.237035352	,	-1.280308623	),
  (	63	,	2.789310402	,	-1.300154949	),
  (	63	,	2.811419563	,	-1.23673552	),
  (	63	,	2.825293176	,	-1.211917068	),
  (	63	,	2.955358856	,	-1.183744517	),
  (	63	,	2.789819106	,	-1.118960562	),
  (	63	,	2.529641336	,	-1.098559029	),
  (	63	,	2.701256506	,	-1.128812173	),
  (	63	,	2.741490046	,	-1.102429414	),
  (	63	,	2.676253085	,	-1.076149346	),
  (	63	,	2.819937268	,	-1.057718638	),
  (	63	,	2.688034776	,	-1.045510902	),
  (	63	,	2.556571171	,	-1.026137336	),
  (	63	,	2.186578331	,	-1.118863211	),
  (	63	,	2.131091411	,	-1.11353378	),
  (	63	,	2.016597043	,	-1.023301572	),
  (	63	,	2.412230823	,	-1.063196757	),
  (	63	,	2.33393933	,	-1.016471744	),
  (	63	,	2.56853009	,	-0.984571457	),
  (	63	,	2.369668128	,	-0.9346292	),
  (	63	,	2.374065924	,	-0.828008749	),
  (	63	,	2.320561137	,	-0.770578316	),
  (	63	,	3.035586749	,	-1.069675048	),
  (	63	,	2.908100499	,	-1.024071791	),
  (	63	,	2.936273738	,	-0.868057849	),
  (	63	,	2.811644657	,	-1.047080755	),
  (	63	,	2.798162104	,	-1.041558301	),
  (	63	,	2.780606191	,	-0.939951288	),
  (	63	,	2.822087119	,	-0.862544027	),
  (	63	,	2.771459606	,	-0.762087054	),
  (	63	,	3.138016212	,	-0.902279386	),
  (	63	,	2.932885974	,	-0.807506057	),
  (	63	,	2.977459096	,	-0.779222173	),
  (	63	,	3.138000727	,	-0.799924239	),
  (	63	,	3.039830219	,	-0.649911102	),
  (	63	,	2.821407961	,	-0.753861115	),
  (	63	,	2.787455956	,	-0.746189627	),
  (	63	,	2.954831704	,	-0.663474743	),
  (	63	,	2.602131223	,	-0.895985127	),
  (	63	,	2.651131744	,	-0.842309698	),
  (	63	,	2.515121617	,	-0.850870853	),
  (	63	,	2.471712414	,	-0.706887315	),
  (	63	,	2.414795251	,	-0.673986531	),
  (	63	,	2.445615867	,	-0.655926932	),
  (	63	,	2.542458284	,	-0.61962082	),
  (	63	,	2.554142847	,	-0.527136746	),
  (	63	,	2.659507383	,	-0.625816577	),
  (	63	,	2.719306215	,	-0.526432064	),
  (	63	,	2.670557476	,	-0.499268527	),
  (	63	,	2.676123887	,	-0.471738418	),
  (	63	,	1.736617675	,	-1.073951318	),
  (	63	,	1.983826016	,	-0.898398837	),
  (	63	,	2.072606629	,	-0.917750833	),
  (	63	,	2.139522076	,	-0.859353245	),
  (	63	,	2.230428466	,	-0.835429171	),
  (	63	,	2.1777018	,	-0.841209866	),
  (	63	,	2.159206852	,	-0.81133089	),
  (	63	,	2.238518377	,	-0.798537699	),
  (	63	,	2.228145792	,	-0.78081284	),
  (	63	,	2.304470855	,	-0.74112621	),
  (	63	,	2.081150752	,	-0.740130683	),
  (	63	,	2.023336261	,	-0.666746751	),
  (	63	,	2.132037931	,	-0.657660435	),
  (	63	,	1.858941682	,	-0.669905494	),
  (	63	,	1.617333	,	-0.790318927	),
  (	63	,	1.67875144	,	-0.703088537	),
  (	63	,	1.732376234	,	-0.665776645	),
  (	63	,	1.820781451	,	-0.619714849	),
  (	63	,	1.973839984	,	-0.627640971	),
  (	63	,	1.958487299	,	-0.555858841	),
  (	63	,	1.827045217	,	-0.541016906	),
  (	63	,	1.862590207	,	-0.43564377	),
  (	63	,	1.910263512	,	-0.467705506	),
  (	63	,	1.901483301	,	-0.414344224	),
  (	63	,	2.298686888	,	-0.604283747	),
  (	63	,	2.442582101	,	-0.595216392	),
  (	63	,	2.603936861	,	-0.463375536	),
  (	63	,	2.511365372	,	-0.341798733	),
  (	63	,	2.583055096	,	-0.288594501	),
  (	63	,	2.170252181	,	-0.284229836	),
  (	63	,	2.133433782	,	-0.197914612	),
  (	63	,	2.354728518	,	-0.335255502	),
  (	63	,	2.423457071	,	-0.262236409	),
  (	63	,	2.529809416	,	-0.184485577	),
  (	63	,	2.500322211	,	-0.148450962	),
  (	63	,	2.30419079	,	-0.114477209	),
  (	63	,	3.151700028	,	-1.494555934	),
  (	63	,	3.485430147	,	-1.395847636	),
  (	63	,	3.84841834	,	-1.344104878	),
  (	63	,	3.79440422	,	-1.339178468	),
  (	63	,	3.574423451	,	-1.320932958	),
  (	63	,	4.061464556	,	-1.250603131	),
  (	63	,	3.904736537	,	-1.21930542	),
  (	63	,	4.702331299	,	-1.32955628	),
  (	63	,	4.221084828	,	-0.980717374	),
  (	63	,	3.487673286	,	-1.257264759	),
  (	63	,	3.711069643	,	-1.227062328	),
  (	63	,	3.338089293	,	-1.201323544	),
  (	63	,	3.197369009	,	-1.224379872	),
  (	63	,	3.549979602	,	-1.145509235	),
  (	63	,	3.704186036	,	-1.034575735	),
  (	63	,	3.493198326	,	-1.043233059	),
  (	63	,	3.968113942	,	-1.11078115	),
  (	63	,	3.91232437	,	-1.088464584	),
  (	63	,	3.988015684	,	-1.070639403	),
  (	63	,	3.854858784	,	-1.09897672	),
  (	63	,	3.848168572	,	-1.023044105	),
  (	63	,	3.861192555	,	-1.02063008	),
  (	63	,	4.05114186	,	-0.900554459	),
  (	63	,	3.690376659	,	-0.954163489	),
  (	63	,	3.76701848	,	-0.886143793	),
  (	63	,	3.957240478	,	-0.90809238	),
  (	63	,	3.924602862	,	-0.753282669	),
  (	63	,	4.494678488	,	-1.076440577	),
  (	63	,	4.318614739	,	-1.008038333	),
  (	63	,	4.676361319	,	-0.795883521	),
  (	63	,	4.681329294	,	-0.733000757	),
  (	63	,	4.472791607	,	-0.79416611	),
  (	63	,	4.475935478	,	-0.769776122	),
  (	63	,	4.37972996	,	-0.717668697	),
  (	63	,	4.140097255	,	-0.915221531	),
  (	63	,	4.112956866	,	-0.863758064	),
  (	63	,	4.151784943	,	-0.821370097	),
  (	63	,	4.05943566	,	-0.731628199	),
  (	63	,	4.076855871	,	-0.686777658	),
  (	63	,	4.006220493	,	-0.716652272	),
  (	63	,	4.066913584	,	-0.674098942	),
  (	63	,	4.200388187	,	-0.508516864	),
  (	63	,	4.325710182	,	-0.463173406	),
  (	63	,	3.16730697	,	-1.144008855	),
  (	63	,	3.162328237	,	-1.034165836	),
  (	63	,	3.361167071	,	-0.845777835	),
  (	63	,	3.521664508	,	-0.857720008	),
  (	63	,	3.553846452	,	-0.842509127	),
  (	63	,	3.503935662	,	-0.847580961	),
  (	63	,	3.368872016	,	-0.83940335	),
  (	63	,	3.791134597	,	-0.837622414	),
  (	63	,	3.782261445	,	-0.695934886	),
  (	63	,	3.824019096	,	-0.691107151	),
  (	63	,	3.832411963	,	-0.677089268	),
  (	63	,	3.176846707	,	-0.885994021	),
  (	63	,	3.251272935	,	-0.742017471	),
  (	63	,	3.272339622	,	-0.728431368	),
  (	63	,	3.333483115	,	-0.634413171	),
  (	63	,	3.640198337	,	-0.498641864	),
  (	63	,	3.935574042	,	-0.599678478	),
  (	63	,	3.911781695	,	-0.569623476	),
  (	63	,	3.809889459	,	-0.536083871	),
  (	63	,	3.914895468	,	-0.50890083	),
  (	63	,	4.098710569	,	-0.404050553	),
  (	63	,	4.223105326	,	-0.4269512	),
  (	63	,	4.060527441	,	-0.361785021	),
  (	63	,	4.065401712	,	-0.351948255	),
  (	63	,	3.871258642	,	-0.372189079	),
  (	63	,	3.826548476	,	-0.214740544	),
  (	63	,	4.96619965	,	-1.45599271	),
  (	63	,	5.645766767	,	-1.443092403	),
  (	63	,	5.66774059	,	-1.386537904	),
  (	63	,	5.87241661	,	-1.309269188	),
  (	63	,	5.608189719	,	-1.253129303	),
  (	63	,	5.392475874	,	-1.214939217	),
  (	63	,	6.215310777	,	-1.230279064	),
  (	63	,	5.576367518	,	-1.128910036	),
  (	63	,	5.753048476	,	-1.029952575	),
  (	63	,	5.046084576	,	-1.207611381	),
  (	63	,	5.155799078	,	-1.149385061	),
  (	63	,	5.048401677	,	-1.138441138	),
  (	63	,	4.790997806	,	-1.190827444	),
  (	63	,	5.212746809	,	-1.067630466	),
  (	63	,	6.083077915	,	-1.094372924	),
  (	63	,	5.916172045	,	-1.01026319	),
  (	63	,	5.945984743	,	-0.772269784	),
  (	63	,	6.158617356	,	-0.782670879	),
  (	63	,	6.213524251	,	-0.786848521	),
  (	63	,	5.918804366	,	-0.70830969	),
  (	63	,	6.015204189	,	-0.620010806	),
  (	63	,	5.82758534	,	-0.775825188	),
  (	63	,	5.585743391	,	-0.785779826	),
  (	63	,	5.746654402	,	-0.658806174	),
  (	63	,	6.003314839	,	-0.552105361	),
  (	63	,	5.87381304	,	-0.41333688	),
  (	63	,	4.798221302	,	-1.115064278	),
  (	63	,	4.909582682	,	-1.066315088	),
  (	63	,	5.029912077	,	-0.881159339	),
  (	63	,	5.348539498	,	-0.712038296	),
  (	63	,	5.147392436	,	-0.790259161	),
  (	63	,	5.242302626	,	-0.71234925	),
  (	63	,	4.760705298	,	-0.829264096	),
  (	63	,	5.022323432	,	-0.680761544	),
  (	63	,	5.004154829	,	-0.65996498	),
  (	63	,	4.856458951	,	-0.696256797	),
  (	63	,	4.858057056	,	-0.675795026	),
  (	63	,	4.967002619	,	-0.541685769	),
  (	63	,	5.006974734	,	-0.499807446	),
  (	63	,	5.147955079	,	-0.408892984	),
  (	63	,	5.010155088	,	-0.430353423	),
  (	63	,	5.723370825	,	-0.325040916	),
  (	63	,	5.686404792	,	-0.342451868	),
  (	63	,	5.563718776	,	-0.302732821	),
  (	63	,	5.379422786	,	-0.435357357	),
  (	63	,	5.371561059	,	-0.262783702	),
  (	63	,	5.307460277	,	-0.21532544	),
  (	63	,	5.501547736	,	-0.305973875	),
  (	63	,	5.670002964	,	-0.184607744	),
  (	63	,	5.385199769	,	-0.239469718	),
  (	64	,	0.772642961	,	0.078560445	),
  (	64	,	0.699278845	,	0.106673505	),
  (	64	,	0.676614973	,	0.130379177	),
  (	64	,	0.755713446	,	0.287683056	),
  (	64	,	0.957445964	,	0.288615792	),
  (	64	,	0.934372438	,	0.311203944	),
  (	64	,	0.976469519	,	0.343212882	),
  (	64	,	0.986324554	,	0.428087118	),
  (	64	,	1.019164529	,	0.448246197	),
  (	64	,	0.6584586	,	0.308980573	),
  (	64	,	0.480587597	,	0.388777361	),
  (	64	,	0.641931164	,	0.471446077	),
  (	64	,	0.714947417	,	0.447474299	),
  (	64	,	0.874525639	,	0.447889522	),
  (	64	,	0.829676613	,	0.485540355	),
  (	64	,	0.854274879	,	0.573460206	),
  (	64	,	0.68553126	,	0.574061477	),
  (	64	,	0.728928995	,	0.620539002	),
  (	64	,	1.151900715	,	0.424131076	),
  (	64	,	1.327510911	,	0.532228799	),
  (	64	,	1.135187173	,	0.55768655	),
  (	64	,	1.027059015	,	0.541851977	),
  (	64	,	1.426174283	,	0.580534507	),
  (	64	,	1.426391254	,	0.618844783	),
  (	64	,	0.994035984	,	0.561911632	),
  (	64	,	1.052638415	,	0.645587982	),
  (	64	,	0.927859165	,	0.782879958	),
  (	64	,	0.85554075	,	0.791435357	),
  (	64	,	0.924227355	,	0.86221168	),
  (	64	,	1.27916225	,	0.922250618	),
  (	64	,	1.489372611	,	0.933357102	),
  (	64	,	1.569919534	,	0.952019703	),
  (	64	,	1.257164685	,	0.970436976	),
  (	64	,	1.088099274	,	0.956933073	),
  (	64	,	1.375280752	,	1.036823348	),
  (	64	,	1.501594473	,	1.072968039	),
  (	64	,	1.336058836	,	1.030113476	),
  (	64	,	0.442047991	,	0.44934253	),
  (	64	,	0.38009342	,	0.600000155	),
  (	64	,	0.686559307	,	0.696316836	),
  (	64	,	0.470369759	,	0.80685458	),
  (	64	,	0.476728607	,	0.835958551	),
  (	64	,	0.05230436	,	0.84041917	),
  (	64	,	0.005765805	,	0.872341346	),
  (	64	,	0.336346363	,	0.783682741	),
  (	64	,	0.316642329	,	0.791291631	),
  (	64	,	0.234732773	,	0.919599155	),
  (	64	,	0.027384967	,	1.019917263	),
  (	64	,	0.002226716	,	1.039509689	),
  (	64	,	0.819384885	,	0.825692719	),
  (	64	,	0.91709727	,	1.03612547	),
  (	64	,	0.739636994	,	0.99630915	),
  (	64	,	0.769736344	,	1.122812961	),
  (	64	,	1.539926753	,	1.195048518	),
  (	64	,	1.031922163	,	1.253522774	),
  (	64	,	1.482341841	,	1.309765907	),
  (	64	,	1.372662285	,	1.33470078	),
  (	64	,	0.319246323	,	1.076975391	),
  (	64	,	0.353828911	,	1.128494488	),
  (	64	,	0.150172238	,	1.165013115	),
  (	64	,	0.264082394	,	1.238886172	),
  (	64	,	0.145400827	,	1.238866954	),
  (	64	,	0.135088495	,	1.34423803	),
  (	64	,	0.070837486	,	1.343043512	),
  (	64	,	0.35776119	,	1.330614281	),
  (	64	,	0.333822115	,	1.394699988	),
  (	64	,	0.332692275	,	1.520973243	),
  (	64	,	2.408224846	,	0.09544428	),
  (	64	,	2.341434589	,	0.073942025	),
  (	64	,	2.32304618	,	0.093204921	),
  (	64	,	2.434103896	,	0.200732582	),
  (	64	,	2.346159794	,	0.163846432	),
  (	64	,	2.19876629	,	0.185561677	),
  (	64	,	2.343702055	,	0.299210919	),
  (	64	,	2.735831459	,	0.337974017	),
  (	64	,	2.132388771	,	0.23807716	),
  (	64	,	2.147691494	,	0.308003156	),
  (	64	,	2.25203669	,	0.267270527	),
  (	64	,	2.315840809	,	0.328680955	),
  (	64	,	2.449802521	,	0.574248256	),
  (	64	,	2.347377839	,	0.527683104	),
  (	64	,	2.831584021	,	0.513402377	),
  (	64	,	2.776636756	,	0.63402048	),
  (	64	,	2.995092939	,	0.583826301	),
  (	64	,	3.045081033	,	0.883451424	),
  (	64	,	2.502398176	,	0.636813359	),
  (	64	,	1.86494729	,	0.491776339	),
  (	64	,	1.763693827	,	0.630225431	),
  (	64	,	1.806202718	,	0.67203604	),
  (	64	,	1.803032912	,	0.670847237	),
  (	64	,	1.870136898	,	0.653538492	),
  (	64	,	1.603284835	,	0.730492721	),
  (	64	,	1.590367597	,	0.900120241	),
  (	64	,	1.781142347	,	0.972208738	),
  (	64	,	1.781179669	,	0.972213905	),
  (	64	,	2.282021681	,	0.818567254	),
  (	64	,	2.326087299	,	1.030723905	),
  (	64	,	2.385508472	,	1.035755548	),
  (	64	,	2.68400472	,	1.046945898	),
  (	64	,	2.884554413	,	1.106901098	),
  (	64	,	2.831061779	,	1.136777255	),
  (	64	,	2.970987027	,	1.171122517	),
  (	64	,	2.932958129	,	1.191569773	),
  (	64	,	2.576058809	,	1.144814349	),
  (	64	,	1.952283186	,	1.157700805	),
  (	64	,	1.736171966	,	1.286228535	),
  (	64	,	2.513757715	,	1.297104951	),
  (	64	,	2.267657153	,	1.285068222	),
  (	64	,	2.255011914	,	1.30417202	),
  (	64	,	2.879522744	,	1.35734303	),
  (	64	,	2.42324076	,	1.46923761	),
  (	64	,	1.57665512	,	1.486708204	),
  (	64	,	3.960466157	,	0.095956469	),
  (	64	,	3.771224987	,	0.1410905	),
  (	64	,	3.965783197	,	0.231006952	),
  (	64	,	4.220944531	,	0.380871589	),
  (	64	,	4.039940877	,	0.340001655	),
  (	64	,	3.863039021	,	0.329606932	),
  (	64	,	3.729262272	,	0.381761914	),
  (	64	,	4.012073562	,	0.567492832	),
  (	64	,	3.814411008	,	0.567834572	),
  (	64	,	4.410097644	,	0.568174097	),
  (	64	,	4.257676719	,	0.478600898	),
  (	64	,	4.288895217	,	0.564316587	),
  (	64	,	4.606388473	,	0.651036022	),
  (	64	,	4.70746609	,	0.793713033	),
  (	64	,	4.40554128	,	0.758002933	),
  (	64	,	4.096348669	,	0.605191563	),
  (	64	,	3.986300296	,	0.667839187	),
  (	64	,	3.988830729	,	0.736028091	),
  (	64	,	4.320119765	,	0.85452525	),
  (	64	,	4.486736539	,	0.887368158	),
  (	64	,	4.456172842	,	1.058525186	),
  (	64	,	3.594305605	,	0.396192732	),
  (	64	,	3.579047502	,	0.541273258	),
  (	64	,	3.648481892	,	0.559079929	),
  (	64	,	3.437830322	,	0.480934574	),
  (	64	,	3.507672595	,	0.646362569	),
  (	64	,	3.553338382	,	0.67700302	),
  (	64	,	3.714284332	,	0.563674241	),
  (	64	,	3.742943568	,	0.837788389	),
  (	64	,	3.312991282	,	0.62747971	),
  (	64	,	3.310760333	,	0.713395843	),
  (	64	,	3.499660319	,	0.766260253	),
  (	64	,	3.525517639	,	0.920581505	),
  (	64	,	3.276142146	,	0.926383569	),
  (	64	,	3.20583188	,	0.932607975	),
  (	64	,	3.16628354	,	1.098381345	),
  (	64	,	3.881983091	,	0.850350599	),
  (	64	,	3.848706027	,	1.069218454	),
  (	64	,	4.349870702	,	1.100817794	),
  (	64	,	4.242990734	,	1.171881956	),
  (	64	,	4.434352611	,	1.276319542	),
  (	64	,	3.431240294	,	1.082829588	),
  (	64	,	3.142895935	,	1.41114961	),
  (	64	,	3.335494199	,	1.407097064	),
  (	64	,	3.161002164	,	1.493788222	),
  (	64	,	3.215551371	,	1.508588403	),
  (	64	,	3.208434682	,	1.530662174	),
  (	64	,	5.444550476	,	0.057709877	),
  (	64	,	5.454093208	,	0.096771253	),
  (	64	,	5.534738744	,	0.121987639	),
  (	64	,	5.804614863	,	0.342358364	),
  (	64	,	5.862863385	,	0.363872594	),
  (	64	,	5.666877151	,	0.445037862	),
  (	64	,	5.324746236	,	0.254282162	),
  (	64	,	5.385067623	,	0.366260122	),
  (	64	,	5.30724111	,	0.376965461	),
  (	64	,	5.375489307	,	0.450379616	),
  (	64	,	5.244827531	,	0.435255233	),
  (	64	,	5.525680558	,	0.469916399	),
  (	64	,	5.559621925	,	0.521870187	),
  (	64	,	5.393677344	,	0.451738807	),
  (	64	,	5.54605765	,	0.633547244	),
  (	64	,	5.897343567	,	0.51561451	),
  (	64	,	5.80698285	,	0.533248334	),
  (	64	,	5.876345689	,	0.653515284	),
  (	64	,	6.053941958	,	0.572908985	),
  (	64	,	6.173139657	,	0.663645415	),
  (	64	,	6.025367185	,	0.675578375	),
  (	64	,	6.033395885	,	0.768969541	),
  (	64	,	6.099639921	,	0.793930127	),
  (	64	,	6.152830036	,	0.857535546	),
  (	64	,	5.514668145	,	0.726542172	),
  (	64	,	5.681654076	,	0.798759632	),
  (	64	,	5.990281987	,	0.879860219	),
  (	64	,	6.052660942	,	0.921825099	),
  (	64	,	5.944358783	,	0.94088413	),
  (	64	,	5.91608684	,	0.978615936	),
  (	64	,	6.033308644	,	0.96405712	),
  (	64	,	6.052690669	,	1.042439437	),
  (	64	,	6.017678585	,	1.04396235	),
  (	64	,	6.233669962	,	1.13230605	),
  (	64	,	5.191970911	,	0.496365666	),
  (	64	,	5.136330874	,	0.511969092	),
  (	64	,	5.177441803	,	0.574013539	),
  (	64	,	5.174274294	,	0.611087047	),
  (	64	,	5.17342235	,	0.62990842	),
  (	64	,	5.057361669	,	0.582740542	),
  (	64	,	5.135388402	,	0.669923862	),
  (	64	,	5.307848701	,	0.646756072	),
  (	64	,	5.3119959	,	0.691037724	),
  (	64	,	5.399147829	,	0.668956144	),
  (	64	,	5.414911005	,	0.682115076	),
  (	64	,	5.202276607	,	0.635863961	),
  (	64	,	5.151714089	,	0.751849827	),
  (	64	,	5.295823866	,	0.757106989	),
  (	64	,	5.318138668	,	0.808473762	),
  (	64	,	5.32296621	,	0.817465996	),
  (	64	,	5.304585244	,	0.87673132	),
  (	64	,	5.181211587	,	0.836140354	),
  (	64	,	5.221821394	,	0.888417858	),
  (	64	,	5.258302494	,	0.904771912	),
  (	64	,	4.894290659	,	0.551832177	),
  (	64	,	4.896236476	,	0.606436873	),
  (	64	,	5.001607509	,	0.722806607	),
  (	64	,	4.787034262	,	0.714488919	),
  (	64	,	5.156838542	,	0.881677417	),
  (	64	,	4.816239458	,	0.930273803	),
  (	64	,	5.495216883	,	0.738701914	),
  (	64	,	5.510049977	,	0.800213726	),
  (	64	,	5.514031219	,	0.817909018	),
  (	64	,	5.635047891	,	0.918389619	),
  (	64	,	5.662051003	,	0.943214087	),
  (	64	,	5.675471291	,	0.95769992	),
  (	64	,	5.37279707	,	0.912980958	),
  (	64	,	5.424605192	,	0.996826627	),
  (	64	,	5.351144279	,	0.988532468	),
  (	64	,	5.374628325	,	0.990994429	),
  (	64	,	5.507169548	,	0.989079325	),
  (	64	,	5.617429724	,	1.042833684	),
  (	64	,	5.539154964	,	1.104718717	),
  (	64	,	5.451054458	,	1.117747752	),
  (	64	,	5.684344436	,	1.034471508	),
  (	64	,	5.712972306	,	1.069408642	),
  (	64	,	5.739266943	,	1.07410693	),
  (	64	,	5.652394884	,	1.190653254	),
  (	64	,	5.702921403	,	1.224360828	),
  (	64	,	6.096945158	,	1.314215741	),
  (	64	,	5.162889114	,	1.012574264	),
  (	64	,	5.178150629	,	1.19446781	),
  (	64	,	5.060446547	,	1.123832617	),
  (	64	,	4.969290203	,	1.213551357	),
  (	64	,	5.068397801	,	1.336217045	),
  (	64	,	0.065334685	,	-0.609195062	),
  (	64	,	0.01893479	,	-0.510836932	),
  (	64	,	0.059948806	,	-0.458758416	),
  (	64	,	6.21547901	,	-0.45809279	),
  (	64	,	0.288534554	,	-0.418752222	),
  (	64	,	0.293292359	,	-0.418818882	),
  (	64	,	0.072891289	,	-0.352732312	),
  (	64	,	0.01292025	,	-0.349857147	),
  (	64	,	0.037344502	,	-0.306802399	),
  (	64	,	6.126697139	,	-0.326160626	),
  (	64	,	6.044132094	,	-0.298093642	),
  (	64	,	6.064262925	,	-0.253257872	),
  (	64	,	6.019615622	,	-0.228130373	),
  (	64	,	6.085392949	,	-0.186557932	),
  (	64	,	6.14796494	,	-0.161726789	),
  (	64	,	0.035786996	,	-0.042720975	),
  (	64	,	0.369426559	,	-0.273328993	),
  (	64	,	0.383015688	,	-0.190266483	),
  (	64	,	0.426016729	,	-0.164117201	),
  (	64	,	0.351081942	,	-0.19616653	),
  (	64	,	0.236900886	,	-0.152559209	),
  (	64	,	0.370060665	,	-0.049720628	),
  (	64	,	0.692085386	,	0.060096124	),
  (	64	,	0.198108191	,	-0.080789723	),
  (	64	,	0.348215711	,	-0.008885598	),
  (	64	,	0.116176075	,	-0.00086442	),
  (	64	,	0.077656312	,	0.029475129	),
  (	64	,	0.438879744	,	0.152905666	),
  (	64	,	0.32183066	,	0.132258835	),
  (	64	,	0.261051981	,	0.113153037	),
  (	64	,	0.290426432	,	0.226128723	),
  (	64	,	5.927012341	,	-0.137838719	),
  (	64	,	5.948249807	,	-0.121527425	),
  (	64	,	5.937606418	,	-0.062039194	),
  (	64	,	5.896187936	,	-0.050815936	),
  (	64	,	6.111613161	,	-0.10312055	),
  (	64	,	6.013788612	,	-0.041809165	),
  (	64	,	6.024147089	,	0.0032458	),
  (	64	,	5.751832724	,	-0.094695444	),
  (	64	,	5.736021568	,	-0.057622174	),
  (	64	,	5.919306403	,	0.204145566	),
  (	64	,	0.010483985	,	0.156325652	),
  (	64	,	0.161963503	,	0.419120137	),
  (	64	,	0.21768119	,	0.483634645	),
  (	64	,	0.217660089	,	0.48364348	),
  (	64	,	0.158543725	,	0.475684004	),
  (	64	,	6.169409297	,	0.363740977	),
  (	64	,	6.072934244	,	0.468559731	),
  (	64	,	6.249973193	,	0.378231375	),
  (	64	,	6.268747102	,	0.395283054	),
  (	64	,	0.058461201	,	0.471018879	),
  (	64	,	6.159773946	,	0.495732644	),
  (	64	,	1.545633481	,	-0.508718111	),
  (	64	,	1.533606769	,	-0.400155972	),
  (	64	,	1.83400349	,	-0.386050053	),
  (	64	,	1.626524309	,	-0.310026301	),
  (	64	,	1.502872984	,	-0.391377623	),
  (	64	,	1.493307167	,	-0.30596202	),
  (	64	,	1.199978662	,	-0.347686847	),
  (	64	,	1.382320338	,	-0.299189678	),
  (	64	,	1.581983326	,	-0.253021633	),
  (	64	,	1.514639434	,	-0.283409164	),
  (	64	,	1.673764516	,	-0.172346097	),
  (	64	,	1.684158039	,	-0.137794155	),
  (	64	,	1.486888955	,	-0.181665565	),
  (	64	,	1.481410132	,	-0.169413756	),
  (	64	,	1.467169573	,	-0.09857483	),
  (	64	,	1.547139762	,	-0.070942803	),
  (	64	,	1.960698872	,	-0.261803687	),
  (	64	,	2.036558795	,	-0.221226097	),
  (	64	,	2.054779175	,	-0.194234752	),
  (	64	,	1.861390654	,	-0.216315158	),
  (	64	,	1.858021686	,	-0.186053306	),
  (	64	,	1.849863504	,	-0.176692955	),
  (	64	,	1.929939997	,	-0.051996737	),
  (	64	,	2.182901195	,	-0.09303087	),
  (	64	,	2.09760378	,	-0.050298818	),
  (	64	,	2.020612945	,	0.003303166	),
  (	64	,	2.05421319	,	0.057196685	),
  (	64	,	2.078679509	,	0.078287125	),
  (	64	,	1.833893124	,	-0.093664864	),
  (	64	,	1.688669072	,	-0.076020746	),
  (	64	,	1.738088281	,	-0.044398517	),
  (	64	,	1.694188057	,	0.033380672	),
  (	64	,	1.69840961	,	0.046180043	),
  (	64	,	1.664298077	,	0.039589885	),
  (	64	,	1.79618996	,	0.053089191	),
  (	64	,	1.735167112	,	0.047190538	),
  (	64	,	1.75890133	,	0.052948659	),
  (	64	,	1.747652105	,	0.111199376	),
  (	64	,	1.885497879	,	0.095544969	),
  (	64	,	2.086096173	,	0.125898402	),
  (	64	,	2.102447727	,	0.155581499	),
  (	64	,	1.821366479	,	0.207825707	),
  (	64	,	1.948058347	,	0.185145814	),
  (	64	,	1.920360141	,	0.264291774	),
  (	64	,	1.264057409	,	-0.240346935	),
  (	64	,	1.46397349	,	-0.076166883	),
  (	64	,	1.398183368	,	-0.09368137	),
  (	64	,	1.435308289	,	-0.057726237	),
  (	64	,	1.312627187	,	-0.100554869	),
  (	64	,	1.451387746	,	0.000206943	),
  (	64	,	1.457174571	,	0.024567964	),
  (	64	,	1.311890232	,	-0.036059299	),
  (	64	,	1.301065292	,	-0.038617942	),
  (	64	,	1.2971527	,	-0.018630364	),
  (	64	,	1.317724692	,	0.028080905	),
  (	64	,	1.38179317	,	0.033986379	),
  (	64	,	1.402030457	,	0.070020316	),
  (	64	,	1.411608919	,	0.092907354	),
  (	64	,	1.425268244	,	0.119876787	),
  (	64	,	1.169638752	,	0.032438843	),
  (	64	,	1.273374278	,	0.238323546	),
  (	64	,	1.116027833	,	0.268790245	),
  (	64	,	1.722515821	,	0.132164539	),
  (	64	,	1.694340856	,	0.179831637	),
  (	64	,	1.652270618	,	0.157898335	),
  (	64	,	1.683683673	,	0.194181999	),
  (	64	,	1.545586975	,	0.184766847	),
  (	64	,	1.750945212	,	0.192043161	),
  (	64	,	1.777578579	,	0.317531711	),
  (	64	,	1.70678453	,	0.295629112	),
  (	64	,	1.71177604	,	0.310398692	),
  (	64	,	1.433700024	,	0.238741375	),
  (	64	,	1.481138664	,	0.379830885	),
  (	64	,	1.287069239	,	0.340080645	),
  (	64	,	1.292673511	,	0.429213452	),
  (	64	,	1.644878788	,	0.414356921	),
  (	64	,	1.55579874	,	0.505137622	),
  (	64	,	1.663293997	,	0.515578194	),
  (	64	,	1.411018952	,	0.505037866	),
  (	64	,	1.538773786	,	0.690708024	),
  (	64	,	3.123768428	,	-0.692714842	),
  (	64	,	3.20099413	,	-0.589799603	),
  (	64	,	3.085388074	,	-0.626696726	),
  (	64	,	3.04132291	,	-0.575762279	),
  (	64	,	3.02110126	,	-0.466817343	),
  (	64	,	3.136816377	,	-0.452197732	),
  (	64	,	3.350564182	,	-0.433738711	),
  (	64	,	3.018497621	,	-0.362614154	),
  (	64	,	3.063308292	,	-0.354206643	),
  (	64	,	3.053620997	,	-0.290078679	),
  (	64	,	3.103885406	,	-0.212711879	),
  (	64	,	3.090927853	,	-0.180010833	),
  (	64	,	3.887724014	,	-0.004493501	),
  (	64	,	3.7666865	,	0.021611464	),
  (	64	,	3.349100192	,	-0.109991449	),
  (	64	,	3.279667538	,	-0.088180785	),
  (	64	,	3.47973126	,	-0.01179999	),
  (	64	,	3.534298074	,	0.125295176	),
  (	64	,	3.676210641	,	0.169045726	),
  (	64	,	2.705214696	,	-0.158118103	),
  (	64	,	2.634063631	,	-0.167095182	),
  (	64	,	3.114700565	,	0.009636608	),
  (	64	,	2.845882713	,	0.017888645	),
  (	64	,	2.992507268	,	0.067367304	),
  (	64	,	2.482890256	,	-0.021937132	),
  (	64	,	2.576536714	,	0.075807001	),
  (	64	,	2.807140908	,	0.08285844	),
  (	64	,	2.647620011	,	0.097937789	),
  (	64	,	3.137464026	,	0.009265753	),
  (	64	,	3.046307404	,	0.155052116	),
  (	64	,	3.101966968	,	0.214312859	),
  (	64	,	3.187523864	,	0.293377359	),
  (	64	,	3.460989673	,	0.326841984	),
  (	64	,	3.018283442	,	0.250684853	),
  (	64	,	2.930964273	,	0.251328521	),
  (	64	,	2.863560791	,	0.390111347	),
  (	64	,	2.860675366	,	0.431949994	),
  (	64	,	4.710996171	,	-0.724086194	),
  (	64	,	4.656194491	,	-0.665186302	),
  (	64	,	4.686074054	,	-0.607917295	),
  (	64	,	4.658981682	,	-0.392312409	),
  (	64	,	4.934224614	,	-0.386807314	),
  (	64	,	5.016962499	,	-0.345649123	),
  (	64	,	4.85351738	,	-0.255594125	),
  (	64	,	4.568055798	,	-0.452802321	),
  (	64	,	4.560129506	,	-0.423130818	),
  (	64	,	4.619653367	,	-0.382449347	),
  (	64	,	4.812900045	,	-0.178357242	),
  (	64	,	4.788322953	,	-0.170326051	),
  (	64	,	4.682108925	,	-0.190236996	),
  (	64	,	4.64163147	,	-0.12356377	),
  (	64	,	4.782051456	,	-0.063145725	),
  (	64	,	5.212577327	,	-0.143766822	),
  (	64	,	4.943779582	,	-0.167122537	),
  (	64	,	5.348162628	,	-0.04888048	),
  (	64	,	5.174336362	,	-0.050326156	),
  (	64	,	5.197524023	,	-0.04295729	),
  (	64	,	5.23327453	,	0.024052918	),
  (	64	,	5.359387419	,	0.05126371	),
  (	64	,	4.898274294	,	-0.12345963	),
  (	64	,	4.90374144	,	-0.119004085	),
  (	64	,	4.858028617	,	-0.103182657	),
  (	64	,	4.817367529	,	-0.062543685	),
  (	64	,	4.782606664	,	0.041492077	),
  (	64	,	4.958598485	,	0.043129662	),
  (	64	,	4.922021683	,	0.074028477	),
  (	64	,	4.852517037	,	0.063872517	),
  (	64	,	4.910802582	,	0.095995422	),
  (	64	,	5.186695645	,	0.206223301	),
  (	64	,	4.43939058	,	-0.191357664	),
  (	64	,	4.625989975	,	-0.037565755	),
  (	64	,	4.408574938	,	-0.046332807	),
  (	64	,	4.480624908	,	-0.028908685	),
  (	64	,	4.42994061	,	0.23770788	),
  (	64	,	4.353720432	,	0.238876123	),
  (	64	,	4.343417055	,	0.297706563	),
  (	64	,	4.713530891	,	0.010986222	),
  (	64	,	4.858073247	,	0.144307009	),
  (	64	,	4.591298296	,	0.208220709	),
  (	64	,	4.701260202	,	0.192762315	),
  (	64	,	4.687232324	,	0.194244681	),
  (	64	,	4.671925605	,	0.208502675	),
  (	64	,	4.749748157	,	0.249315316	),
  (	64	,	4.756656537	,	0.287569256	),
  (	64	,	4.916111755	,	0.326476728	),
  (	64	,	5.077958102	,	0.353680039	),
  (	64	,	4.98674256	,	0.343149257	),
  (	64	,	4.714400348	,	0.340440027	),
  (	64	,	4.726537383	,	0.342313992	),
  (	64	,	4.770325896	,	0.381890307	),
  (	64	,	4.907307679	,	0.411710843	),
  (	64	,	4.557768368	,	0.272378212	),
  (	64	,	4.563624353	,	0.295269385	),
  (	64	,	4.564100118	,	0.469124911	),
  (	64	,	4.736398711	,	0.377804814	),
  (	64	,	4.732766999	,	0.41785789	),
  (	64	,	4.828811829	,	0.461625136	),
  (	64	,	4.719366357	,	0.581393541	),
  (	64	,	0.819488048	,	-1.208899417	),
  (	64	,	1.278845645	,	-1.263719569	),
  (	64	,	1.426788816	,	-1.197691373	),
  (	64	,	1.030053043	,	-1.107646673	),
  (	64	,	1.118543047	,	-1.063750488	),
  (	64	,	0.336265139	,	-1.158859315	),
  (	64	,	0.671557929	,	-0.891753784	),
  (	64	,	0.831016132	,	-0.850574519	),
  (	64	,	1.515043305	,	-0.94877368	),
  (	64	,	1.175203652	,	-0.811840198	),
  (	64	,	1.476069984	,	-0.883849853	),
  (	64	,	1.466282019	,	-0.825781632	),
  (	64	,	1.326014009	,	-0.728567623	),
  (	64	,	1.210045842	,	-0.730814705	),
  (	64	,	1.286802108	,	-0.691647008	),
  (	64	,	1.397770054	,	-0.605609317	),
  (	64	,	1.328356663	,	-0.623166775	),
  (	64	,	0.898547687	,	-0.626938284	),
  (	64	,	0.194315277	,	-1.090787873	),
  (	64	,	0.043064138	,	-1.087282028	),
  (	64	,	0.404065139	,	-0.86792129	),
  (	64	,	0.481454096	,	-0.834547544	),
  (	64	,	0.745248146	,	-0.696949999	),
  (	64	,	0.468092222	,	-0.72884211	),
  (	64	,	0.413835429	,	-0.556630951	),
  (	64	,	0.244023111	,	-0.484780455	),
  (	64	,	0.774681297	,	-0.666556005	),
  (	64	,	0.844882924	,	-0.520180612	),
  (	64	,	0.773244401	,	-0.521073539	),
  (	64	,	0.648343134	,	-0.542842062	),
  (	64	,	0.781507378	,	-0.504532487	),
  (	64	,	0.741100827	,	-0.428673847	),
  (	64	,	0.924569759	,	-0.447053064	),
  (	64	,	1.067627546	,	-0.355732161	),
  (	64	,	1.126907077	,	-0.361547083	),
  (	64	,	1.017595197	,	-0.321741242	),
  (	64	,	0.656883937	,	-0.393493822	),
  (	64	,	0.670508974	,	-0.349109014	),
  (	64	,	0.957412538	,	-0.182177187	),
  (	64	,	0.887042019	,	-0.136059264	),
  (	64	,	0.754194908	,	-0.164775764	),
  (	64	,	0.794809163	,	-0.113368126	),
  (	64	,	0.78909928	,	-0.050240428	),
  (	64	,	2.960866276	,	-1.390484833	),
  (	64	,	2.091175713	,	-1.278354401	),
  (	64	,	2.409474664	,	-1.338027566	),
  (	64	,	2.47754066	,	-1.25281146	),
  (	64	,	2.867846043	,	-1.310737618	),
  (	64	,	2.966369129	,	-1.273363013	),
  (	64	,	2.967349187	,	-1.256538458	),
  (	64	,	2.811879749	,	-1.264371097	),
  (	64	,	2.852278525	,	-1.234300297	),
  (	64	,	2.822200501	,	-1.207938333	),
  (	64	,	2.826957065	,	-1.121596514	),
  (	64	,	2.907723333	,	-1.131671799	),
  (	64	,	2.540392682	,	-1.167883888	),
  (	64	,	2.434124756	,	-1.170256791	),
  (	64	,	2.652653323	,	-1.085967749	),
  (	64	,	2.809415419	,	-1.049253041	),
  (	64	,	2.66856308	,	-1.026735046	),
  (	64	,	2.626569984	,	-1.00093987	),
  (	64	,	2.623222853	,	-0.979069502	),
  (	64	,	1.766823306	,	-1.229300212	),
  (	64	,	1.701915162	,	-1.144374378	),
  (	64	,	2.019726455	,	-1.016301482	),
  (	64	,	2.473059681	,	-1.039844281	),
  (	64	,	2.265514717	,	-1.052732913	),
  (	64	,	2.555493561	,	-0.998083831	),
  (	64	,	2.587454775	,	-0.966444285	),
  (	64	,	2.516615096	,	-0.924029431	),
  (	64	,	2.263455047	,	-0.926599138	),
  (	64	,	2.223095547	,	-0.946171476	),
  (	64	,	2.39959627	,	-0.909010744	),
  (	64	,	3.139090937	,	-1.096606779	),
  (	64	,	2.948348838	,	-1.001049616	),
  (	64	,	2.82628932	,	-1.045020248	),
  (	64	,	2.787096649	,	-1.034324191	),
  (	64	,	2.843920833	,	-0.999590218	),
  (	64	,	2.672010328	,	-0.910414841	),
  (	64	,	2.740322738	,	-0.86229944	),
  (	64	,	3.127310292	,	-0.821565082	),
  (	64	,	2.859946623	,	-0.750848764	),
  (	64	,	2.732139577	,	-0.745932179	),
  (	64	,	2.728328481	,	-0.741197554	),
  (	64	,	2.684957178	,	-0.637353445	),
  (	64	,	2.604464355	,	-0.479529095	),
  (	64	,	1.864320871	,	-1.042246975	),
  (	64	,	1.763710111	,	-0.954616075	),
  (	64	,	1.716690847	,	-0.913313099	),
  (	64	,	1.847472777	,	-0.914993651	),
  (	64	,	2.056140558	,	-0.824080838	),
  (	64	,	2.154436694	,	-0.812950903	),
  (	64	,	2.320966206	,	-0.71535013	),
  (	64	,	2.311995195	,	-0.683144907	),
  (	64	,	2.231452818	,	-0.681796259	),
  (	64	,	2.239827308	,	-0.669693805	),
  (	64	,	2.013071573	,	-0.778977729	),
  (	64	,	2.042656321	,	-0.709521115	),
  (	64	,	2.047437459	,	-0.710367013	),
  (	64	,	2.029291011	,	-0.661267542	),
  (	64	,	2.150503452	,	-0.66190688	),
  (	64	,	2.142513289	,	-0.650874127	),
  (	64	,	2.148744629	,	-0.645583211	),
  (	64	,	2.164121327	,	-0.62662816	),
  (	64	,	2.179443048	,	-0.603711079	),
  (	64	,	2.134405868	,	-0.618805259	),
  (	64	,	2.119474753	,	-0.585896462	),
  (	64	,	1.700889711	,	-0.876841493	),
  (	64	,	1.842448146	,	-0.757540773	),
  (	64	,	1.801117347	,	-0.767517374	),
  (	64	,	1.696060374	,	-0.716890027	),
  (	64	,	1.706050687	,	-0.714121974	),
  (	64	,	1.771742125	,	-0.690106657	),
  (	64	,	1.760117147	,	-0.684049762	),
  (	64	,	2.000770962	,	-0.676868974	),
  (	64	,	2.071115702	,	-0.608191222	),
  (	64	,	1.90657039	,	-0.539257716	),
  (	64	,	1.892752942	,	-0.542511197	),
  (	64	,	1.835684124	,	-0.497241858	),
  (	64	,	2.004726581	,	-0.468849525	),
  (	64	,	2.055130478	,	-0.428107517	),
  (	64	,	2.013203629	,	-0.389847557	),
  (	64	,	2.281798199	,	-0.627326557	),
  (	64	,	2.338437293	,	-0.415701937	),
  (	64	,	2.447505608	,	-0.272595439	),
  (	64	,	2.532185305	,	-0.187957657	),
  (	64	,	2.183648227	,	-0.400111148	),
  (	64	,	2.132470081	,	-0.355404074	),
  (	64	,	2.051172974	,	-0.340749409	),
  (	64	,	2.193790237	,	-0.227854799	),
  (	64	,	2.323528702	,	-0.230958464	),
  (	64	,	2.495496392	,	-0.180994029	),
  (	64	,	2.521375801	,	-0.164486836	),
  (	64	,	2.178389894	,	-0.177421231	),
  (	64	,	2.257814039	,	-0.086114026	),
  (	64	,	3.771500856	,	-1.445975717	),
  (	64	,	4.098452331	,	-1.359941615	),
  (	64	,	3.439760018	,	-1.369144466	),
  (	64	,	3.889897524	,	-1.346976047	),
  (	64	,	3.881684967	,	-1.203165109	),
  (	64	,	4.102349357	,	-1.225714474	),
  (	64	,	4.367008896	,	-1.054998392	),
  (	64	,	3.572498912	,	-1.229498167	),
  (	64	,	3.777151936	,	-1.154937249	),
  (	64	,	3.455246013	,	-1.104846046	),
  (	64	,	3.693200358	,	-1.042239178	),
  (	64	,	3.961664525	,	-1.139272173	),
  (	64	,	3.953345813	,	-0.853177368	),
  (	64	,	4.668249051	,	-1.077127047	),
  (	64	,	4.512651721	,	-0.992892836	),
  (	64	,	4.455462611	,	-0.987075585	),
  (	64	,	4.535713208	,	-0.87378148	),
  (	64	,	4.207793126	,	-0.937424462	),
  (	64	,	4.246746613	,	-0.936739268	),
  (	64	,	4.264476353	,	-0.9265388	),
  (	64	,	4.366554179	,	-0.898449168	),
  (	64	,	4.297451764	,	-0.791499777	),
  (	64	,	4.376672387	,	-0.80407877	),
  (	64	,	4.567801591	,	-0.800118742	),
  (	64	,	4.578991817	,	-0.672246691	),
  (	64	,	4.429015018	,	-0.734623852	),
  (	64	,	4.424326158	,	-0.732939559	),
  (	64	,	4.530620735	,	-0.568159764	),
  (	64	,	4.19784023	,	-0.892227796	),
  (	64	,	4.175964241	,	-0.84060004	),
  (	64	,	4.25597768	,	-0.748736922	),
  (	64	,	4.012188991	,	-0.647485134	),
  (	64	,	4.42702914	,	-0.533850299	),
  (	64	,	4.379227952	,	-0.560357293	),
  (	64	,	4.172364229	,	-0.554767717	),
  (	64	,	4.248820846	,	-0.426248256	),
  (	64	,	3.296379368	,	-1.079347556	),
  (	64	,	3.45980218	,	-1.044009517	),
  (	64	,	3.596536489	,	-0.890337554	),
  (	64	,	3.266157768	,	-0.984529642	),
  (	64	,	3.390165409	,	-0.952730927	),
  (	64	,	3.302055658	,	-0.878520462	),
  (	64	,	3.698695993	,	-0.85004906	),
  (	64	,	3.69216311	,	-0.752096171	),
  (	64	,	3.670936649	,	-0.702005195	),
  (	64	,	3.191840369	,	-0.896397118	),
  (	64	,	3.160254263	,	-0.898366067	),
  (	64	,	3.258421604	,	-0.85370606	),
  (	64	,	3.464285014	,	-0.752916932	),
  (	64	,	3.459444345	,	-0.745251108	),
  (	64	,	3.543420533	,	-0.670190165	),
  (	64	,	3.469523051	,	-0.634803497	),
  (	64	,	3.504373748	,	-0.579272245	),
  (	64	,	3.63839031	,	-0.616360132	),
  (	64	,	3.920908865	,	-0.696521291	),
  (	64	,	3.912131533	,	-0.687941471	),
  (	64	,	3.923637359	,	-0.661154734	),
  (	64	,	4.008533068	,	-0.544706388	),
  (	64	,	3.847811582	,	-0.539887215	),
  (	64	,	3.984978756	,	-0.419026823	),
  (	64	,	3.955153782	,	-0.384534205	),
  (	64	,	4.251974916	,	-0.368401415	),
  (	64	,	4.01816004	,	-0.316935816	),
  (	64	,	4.152309689	,	-0.246678534	),
  (	64	,	4.172390851	,	-0.251326504	),
  (	64	,	3.682140731	,	-0.391329799	),
  (	64	,	3.654113157	,	-0.401819681	),
  (	64	,	3.739643128	,	-0.324382693	),
  (	64	,	3.936338325	,	-0.132214063	),
  (	64	,	4.835046805	,	-1.47283682	),
  (	64	,	5.914265104	,	-1.374824413	),
  (	64	,	5.811551668	,	-1.328480044	),
  (	64	,	5.547319784	,	-1.266140962	),
  (	64	,	5.504182427	,	-1.19048117	),
  (	64	,	6.058890968	,	-1.284320356	),
  (	64	,	5.974664458	,	-1.227800058	),
  (	64	,	6.10138864	,	-1.177592041	),
  (	64	,	5.987214551	,	-1.102855209	),
  (	64	,	5.952771965	,	-1.055915036	),
  (	64	,	5.231126336	,	-1.200142366	),
  (	64	,	5.148163378	,	-1.163886566	),
  (	64	,	5.395857531	,	-1.101678419	),
  (	64	,	4.897292599	,	-1.128237537	),
  (	64	,	5.284525906	,	-1.003990162	),
  (	64	,	5.141888931	,	-1.012007613	),
  (	64	,	5.672296294	,	-0.913836297	),
  (	64	,	5.269086744	,	-0.9602063	),
  (	64	,	6.121528061	,	-1.048172531	),
  (	64	,	6.052996843	,	-0.88465255	),
  (	64	,	6.222206357	,	-0.701322519	),
  (	64	,	6.12504872	,	-0.752661737	),
  (	64	,	5.823576118	,	-0.722342118	),
  (	64	,	5.604031194	,	-0.813581816	),
  (	64	,	5.977691269	,	-0.572566154	),
  (	64	,	5.94445464	,	-0.512449384	),
  (	64	,	5.79759618	,	-0.578149474	),
  (	64	,	5.832129252	,	-0.452009687	),
  (	64	,	5.833761983	,	-0.403880883	),
  (	64	,	5.104555682	,	-0.967649054	),
  (	64	,	5.107613274	,	-0.961853271	),
  (	64	,	5.080474485	,	-0.763094425	),
  (	64	,	5.330534325	,	-0.87268482	),
  (	64	,	5.237815155	,	-0.861336757	),
  (	64	,	5.237917598	,	-0.751246037	),
  (	64	,	4.934820806	,	-0.71667958	),
  (	64	,	4.963600364	,	-0.695041357	),
  (	64	,	4.978865617	,	-0.646849432	),
  (	64	,	4.823042769	,	-0.628178974	),
  (	64	,	4.941975781	,	-0.51277768	),
  (	64	,	5.042070527	,	-0.422021731	),
  (	64	,	5.566643602	,	-0.631996881	),
  (	64	,	5.649996497	,	-0.518296907	),
  (	64	,	5.387789184	,	-0.531864996	),
  (	64	,	5.371021228	,	-0.508112626	),
  (	64	,	5.754047523	,	-0.369712242	),
  (	64	,	5.539472197	,	-0.358797865	),
  (	64	,	5.714571931	,	-0.222053628	),
  (	64	,	5.364804576	,	-0.39081025	),
  (	64	,	5.211081799	,	-0.41790031	),
  (	64	,	5.57294695	,	-0.231762101	),
  (	64	,	5.500254053	,	-0.082575353	),
  (	64	,	5.510850812	,	-0.01613968	),
  (	65	,	0.793569271	,	0.093135288	),
  (	65	,	0.823125416	,	0.147857111	),
  (	65	,	0.689470295	,	0.134302806	),
  (	65	,	0.950321954	,	0.269310542	),
  (	65	,	0.821844704	,	0.328033815	),
  (	65	,	0.955572437	,	0.365044596	),
  (	65	,	1.036025434	,	0.426940391	),
  (	65	,	0.564567121	,	0.300596625	),
  (	65	,	0.539786526	,	0.318576814	),
  (	65	,	0.457839756	,	0.350504358	),
  (	65	,	0.606352092	,	0.404354071	),
  (	65	,	0.800689526	,	0.493401294	),
  (	65	,	0.862472509	,	0.54326238	),
  (	65	,	0.728561108	,	0.62803029	),
  (	65	,	1.175177152	,	0.478290832	),
  (	65	,	1.173153609	,	0.529906216	),
  (	65	,	1.112069492	,	0.655242737	),
  (	65	,	1.43124097	,	0.589262397	),
  (	65	,	1.335240891	,	0.627207828	),
  (	65	,	1.390470213	,	0.706247942	),
  (	65	,	1.455076104	,	0.734939353	),
  (	65	,	1.531296498	,	0.899095361	),
  (	65	,	1.083058774	,	0.753825232	),
  (	65	,	0.895162437	,	0.720076381	),
  (	65	,	1.569764402	,	0.965520167	),
  (	65	,	1.076052574	,	0.942616634	),
  (	65	,	1.367982678	,	1.094166826	),
  (	65	,	1.560267708	,	1.153593091	),
  (	65	,	0.45306765	,	0.561856759	),
  (	65	,	0.318487603	,	0.524715791	),
  (	65	,	0.288794939	,	0.561670266	),
  (	65	,	0.375919533	,	0.603519419	),
  (	65	,	0.364916689	,	0.597718055	),
  (	65	,	0.383019689	,	0.703991535	),
  (	65	,	0.655712189	,	0.590505098	),
  (	65	,	0.50161573	,	0.648009791	),
  (	65	,	0.501334449	,	0.710379561	),
  (	65	,	0.608132839	,	0.854442928	),
  (	65	,	0.126293016	,	0.644020641	),
  (	65	,	0.381550365	,	0.717353718	),
  (	65	,	0.087641623	,	0.852861233	),
  (	65	,	0.341078607	,	0.827629531	),
  (	65	,	0.240356996	,	0.849599205	),
  (	65	,	0.271868266	,	0.890726148	),
  (	65	,	0.282658944	,	0.890287805	),
  (	65	,	0.363733243	,	1.014779551	),
  (	65	,	0.222366993	,	0.898984821	),
  (	65	,	0.245298885	,	1.012229003	),
  (	65	,	0.802613036	,	0.835112607	),
  (	65	,	0.756387948	,	0.847704638	),
  (	65	,	0.771628808	,	0.894674908	),
  (	65	,	1.000644428	,	0.996898954	),
  (	65	,	0.958857289	,	0.984069499	),
  (	65	,	0.932388083	,	1.010004153	),
  (	65	,	0.931733394	,	1.025641569	),
  (	65	,	0.75426589	,	0.924981709	),
  (	65	,	0.627717764	,	0.966298834	),
  (	65	,	0.567800919	,	0.939733834	),
  (	65	,	0.597172721	,	0.995801746	),
  (	65	,	0.749457413	,	1.017776201	),
  (	65	,	0.909292535	,	1.051657267	),
  (	65	,	1.088471439	,	1.045592806	),
  (	65	,	1.351498476	,	1.133036741	),
  (	65	,	0.833434243	,	1.132651613	),
  (	65	,	0.861867275	,	1.145955497	),
  (	65	,	1.327387351	,	1.287421051	),
  (	65	,	0.496594041	,	0.97036021	),
  (	65	,	0.573718188	,	1.00610448	),
  (	65	,	0.543968485	,	1.136267234	),
  (	65	,	0.248396972	,	1.200357847	),
  (	65	,	0.203570341	,	1.209958531	),
  (	65	,	0.58188065	,	1.292022977	),
  (	65	,	0.957389438	,	1.3219068	),
  (	65	,	0.579579687	,	1.390881204	),
  (	65	,	0.350465423	,	1.353874904	),
  (	65	,	0.118362412	,	1.397173239	),
  (	65	,	0.301933127	,	1.396460818	),
  (	65	,	0.173497077	,	1.439797178	),
  (	65	,	0.409934443	,	1.553611972	),
  (	65	,	2.260572781	,	0.167107226	),
  (	65	,	2.236921489	,	0.175684252	),
  (	65	,	2.241656792	,	0.231377989	),
  (	65	,	2.317016937	,	0.267928601	),
  (	65	,	2.563153151	,	0.201903245	),
  (	65	,	2.642776092	,	0.275017362	),
  (	65	,	2.448935633	,	0.268280072	),
  (	65	,	2.46763045	,	0.289470114	),
  (	65	,	2.415625653	,	0.371460751	),
  (	65	,	2.504479048	,	0.409338207	),
  (	65	,	2.53788693	,	0.45226111	),
  (	65	,	2.097894409	,	0.345857192	),
  (	65	,	2.029623218	,	0.354581904	),
  (	65	,	2.021828656	,	0.390946618	),
  (	65	,	2.501509219	,	0.495109939	),
  (	65	,	2.323364765	,	0.493214511	),
  (	65	,	2.377644971	,	0.565074859	),
  (	65	,	2.436611992	,	0.617217136	),
  (	65	,	2.35843267	,	0.656319955	),
  (	65	,	2.363515911	,	0.693122952	),
  (	65	,	2.697294946	,	0.478491624	),
  (	65	,	2.447771278	,	0.666507703	),
  (	65	,	2.876726582	,	0.905517613	),
  (	65	,	3.061848565	,	0.962934066	),
  (	65	,	2.765161694	,	0.933701992	),
  (	65	,	2.974994461	,	0.996144797	),
  (	65	,	3.128003233	,	1.074231052	),
  (	65	,	1.999448329	,	0.425172464	),
  (	65	,	2.214876401	,	0.796752376	),
  (	65	,	2.135339713	,	0.740545103	),
  (	65	,	2.070340332	,	0.827041642	),
  (	65	,	1.717888737	,	0.576378456	),
  (	65	,	1.759422481	,	0.648341393	),
  (	65	,	1.811877909	,	0.799812841	),
  (	65	,	1.57216508	,	0.778272772	),
  (	65	,	1.692308093	,	0.827372942	),
  (	65	,	1.763627051	,	0.93016515	),
  (	65	,	2.464971549	,	0.900133297	),
  (	65	,	2.544315061	,	0.948821571	),
  (	65	,	2.23645564	,	0.927019906	),
  (	65	,	2.174078459	,	0.944982248	),
  (	65	,	2.265289566	,	1.046130359	),
  (	65	,	2.596423324	,	1.066677224	),
  (	65	,	2.468486194	,	1.115975637	),
  (	65	,	2.163513534	,	1.053841128	),
  (	65	,	1.929838003	,	1.045489025	),
  (	65	,	1.593298051	,	1.319221967	),
  (	65	,	2.554803083	,	1.3637077	),
  (	65	,	2.405095203	,	1.410728708	),
  (	65	,	2.168118811	,	1.467080369	),
  (	65	,	4.102274151	,	0.21036232	),
  (	65	,	4.224054084	,	0.29765173	),
  (	65	,	3.737375557	,	0.351180953	),
  (	65	,	3.930791905	,	0.384768804	),
  (	65	,	3.914159073	,	0.376209582	),
  (	65	,	4.059543714	,	0.546040025	),
  (	65	,	3.753086705	,	0.531087723	),
  (	65	,	3.862544591	,	0.57225636	),
  (	65	,	3.955716946	,	0.636283514	),
  (	65	,	4.324254409	,	0.614791322	),
  (	65	,	4.557277597	,	0.644938143	),
  (	65	,	4.465881268	,	0.618086608	),
  (	65	,	4.472766263	,	0.764667757	),
  (	65	,	4.409569613	,	0.731239445	),
  (	65	,	4.656247718	,	0.830991208	),
  (	65	,	4.540349464	,	0.841052329	),
  (	65	,	4.063875415	,	0.639076977	),
  (	65	,	4.177858672	,	0.692815969	),
  (	65	,	4.200353341	,	0.824507288	),
  (	65	,	4.346889181	,	0.923705195	),
  (	65	,	4.584661166	,	1.010139472	),
  (	65	,	4.56438562	,	1.0236705	),
  (	65	,	3.456362182	,	0.423377969	),
  (	65	,	3.580757306	,	0.489830548	),
  (	65	,	3.430308352	,	0.506654475	),
  (	65	,	3.788556644	,	0.631757598	),
  (	65	,	3.776395346	,	0.670082774	),
  (	65	,	3.736747931	,	0.693676837	),
  (	65	,	3.727986755	,	0.72462622	),
  (	65	,	3.810655099	,	0.64504761	),
  (	65	,	3.794430844	,	0.729449581	),
  (	65	,	3.813902511	,	0.816579073	),
  (	65	,	3.620449699	,	0.639366111	),
  (	65	,	3.588732495	,	0.727355125	),
  (	65	,	3.674809485	,	0.798539018	),
  (	65	,	3.289031241	,	0.582671	),
  (	65	,	3.335544277	,	0.769743121	),
  (	65	,	3.579590518	,	0.881737244	),
  (	65	,	3.528904056	,	0.885196724	),
  (	65	,	3.415051245	,	1.042245005	),
  (	65	,	3.25113387	,	1.113568796	),
  (	65	,	4.042781956	,	0.94283032	),
  (	65	,	4.05329448	,	0.963337791	),
  (	65	,	3.7477934	,	0.957553011	),
  (	65	,	4.202555222	,	1.036909234	),
  (	65	,	4.434964837	,	1.135151179	),
  (	65	,	4.610558189	,	1.214213416	),
  (	65	,	4.326090648	,	1.267331182	),
  (	65	,	3.623570829	,	1.021707671	),
  (	65	,	3.446303325	,	1.08610208	),
  (	65	,	3.210056207	,	1.266254232	),
  (	65	,	3.184281528	,	1.303087345	),
  (	65	,	3.99183702	,	1.203330361	),
  (	65	,	4.669493453	,	1.366708042	),
  (	65	,	3.6954459	,	1.301908736	),
  (	65	,	3.811898316	,	1.390346844	),
  (	65	,	3.457596833	,	1.404490545	),
  (	65	,	5.511083917	,	0.02673278	),
  (	65	,	5.54129796	,	0.051378072	),
  (	65	,	5.604302407	,	0.177576708	),
  (	65	,	5.390860798	,	0.121249733	),
  (	65	,	5.358714082	,	0.147263298	),
  (	65	,	5.40993869	,	0.196354065	),
  (	65	,	5.530783191	,	0.273288144	),
  (	65	,	5.805414455	,	0.366133725	),
  (	65	,	5.700263666	,	0.446173888	),
  (	65	,	5.698244626	,	0.44651419	),
  (	65	,	5.321019383	,	0.230673828	),
  (	65	,	5.419115767	,	0.305812994	),
  (	65	,	5.351118706	,	0.302212866	),
  (	65	,	5.246321153	,	0.386614506	),
  (	65	,	5.284244913	,	0.368871793	),
  (	65	,	5.312455794	,	0.508723563	),
  (	65	,	5.473235876	,	0.497802096	),
  (	65	,	5.655876157	,	0.524573283	),
  (	65	,	5.420870528	,	0.618826312	),
  (	65	,	5.901814533	,	0.353084273	),
  (	65	,	5.920205334	,	0.622251998	),
  (	65	,	6.277838508	,	0.810062847	),
  (	65	,	6.168501986	,	0.786413328	),
  (	65	,	6.107348545	,	0.844410445	),
  (	65	,	5.70783353	,	0.638447499	),
  (	65	,	5.785074374	,	0.787361116	),
  (	65	,	5.589518365	,	0.70412676	),
  (	65	,	5.569754201	,	0.737431083	),
  (	65	,	5.643076996	,	0.800303089	),
  (	65	,	5.782597746	,	0.815848776	),
  (	65	,	5.746658933	,	0.849426748	),
  (	65	,	5.978487348	,	0.884479044	),
  (	65	,	6.204251619	,	0.999374114	),
  (	65	,	6.236063569	,	1.029100966	),
  (	65	,	6.272536687	,	1.047609078	),
  (	65	,	5.847312134	,	0.993407046	),
  (	65	,	5.877340288	,	0.984951934	),
  (	65	,	6.027981847	,	0.996677566	),
  (	65	,	5.065403699	,	0.387440661	),
  (	65	,	5.009240645	,	0.431550956	),
  (	65	,	5.080547288	,	0.490219862	),
  (	65	,	5.165881479	,	0.473601368	),
  (	65	,	5.244391045	,	0.543104403	),
  (	65	,	5.187306942	,	0.583590031	),
  (	65	,	5.024442565	,	0.466625108	),
  (	65	,	5.043780878	,	0.479195879	),
  (	65	,	4.937528829	,	0.502370428	),
  (	65	,	5.05991821	,	0.651518576	),
  (	65	,	5.354362997	,	0.599155078	),
  (	65	,	5.371194615	,	0.644651546	),
  (	65	,	5.241470465	,	0.647505898	),
  (	65	,	5.297430421	,	0.638874843	),
  (	65	,	5.336028417	,	0.750209635	),
  (	65	,	5.379419946	,	0.753834922	),
  (	65	,	5.407839879	,	0.797038059	),
  (	65	,	5.146871613	,	0.8021115	),
  (	65	,	4.734261622	,	0.732111854	),
  (	65	,	4.780186336	,	0.789037524	),
  (	65	,	4.91739864	,	0.808345978	),
  (	65	,	4.743389804	,	0.867613189	),
  (	65	,	4.799362042	,	0.896182363	),
  (	65	,	4.742457929	,	0.887036489	),
  (	65	,	5.076275016	,	0.87740137	),
  (	65	,	5.086671803	,	1.012768363	),
  (	65	,	4.852841931	,	0.909587911	),
  (	65	,	4.908405844	,	0.958136403	),
  (	65	,	4.947017565	,	1.003327787	),
  (	65	,	4.963173559	,	1.016223904	),
  (	65	,	4.760904201	,	1.054345777	),
  (	65	,	5.508272636	,	0.781749511	),
  (	65	,	5.543671167	,	0.832386302	),
  (	65	,	5.481265287	,	0.891427908	),
  (	65	,	5.444932499	,	0.914658333	),
  (	65	,	5.343063027	,	0.934658989	),
  (	65	,	5.325482933	,	0.93542101	),
  (	65	,	5.345435429	,	1.04021676	),
  (	65	,	5.573329148	,	1.022963013	),
  (	65	,	5.81175112	,	1.031230154	),
  (	65	,	5.88317948	,	1.118493137	),
  (	65	,	6.056091613	,	1.120894298	),
  (	65	,	5.164684253	,	0.995586167	),
  (	65	,	5.246196549	,	1.128084845	),
  (	65	,	5.230319297	,	1.228142021	),
  (	65	,	4.900766604	,	1.2355676	),
  (	65	,	5.366938234	,	1.265914107	),
  (	65	,	5.234273962	,	1.33484494	),
  (	65	,	4.91152033	,	1.395270133	),
  (	65	,	5.040230665	,	1.456700634	),
  (	65	,	0.101276785	,	-0.541675998	),
  (	65	,	6.270696024	,	-0.464664056	),
  (	65	,	6.238792947	,	-0.442117873	),
  (	65	,	6.267910498	,	-0.431744704	),
  (	65	,	0.115030741	,	-0.326266843	),
  (	65	,	6.09620447	,	-0.496353722	),
  (	65	,	6.023190172	,	-0.447278042	),
  (	65	,	6.276012641	,	-0.276591731	),
  (	65	,	6.237493964	,	-0.2768351	),
  (	65	,	0.453404284	,	-0.083177585	),
  (	65	,	0.351579798	,	-0.056670256	),
  (	65	,	0.591106522	,	-0.165222695	),
  (	65	,	0.609471055	,	-0.075844049	),
  (	65	,	0.551916482	,	0.000618908	),
  (	65	,	0.287200116	,	0.085652046	),
  (	65	,	0.360487845	,	0.030124802	),
  (	65	,	0.38565273	,	0.138950949	),
  (	65	,	0.461242726	,	0.149384155	),
  (	65	,	5.890614041	,	-0.225411342	),
  (	65	,	5.897860298	,	-0.190340965	),
  (	65	,	6.027466546	,	-0.123241362	),
  (	65	,	5.997685577	,	-0.125748616	),
  (	65	,	5.731665912	,	-0.179971642	),
  (	65	,	5.815131097	,	-0.082395583	),
  (	65	,	6.150277077	,	-0.07913937	),
  (	65	,	6.032479304	,	-0.114742273	),
  (	65	,	6.00954393	,	-0.083952149	),
  (	65	,	6.140277164	,	0.019589195	),
  (	65	,	6.014390151	,	-0.024613464	),
  (	65	,	6.010689834	,	0.066505161	),
  (	65	,	6.038892636	,	0.115477933	),
  (	65	,	5.754858255	,	-0.076355844	),
  (	65	,	5.83843194	,	-0.004154452	),
  (	65	,	5.788596719	,	0.042575104	),
  (	65	,	5.606264075	,	-0.059318535	),
  (	65	,	5.610627575	,	0.009327787	),
  (	65	,	5.871633029	,	0.321917294	),
  (	65	,	0.09785408	,	0.235316517	),
  (	65	,	0.252672636	,	0.239037026	),
  (	65	,	0.156685084	,	0.230485285	),
  (	65	,	0.254445659	,	0.373578469	),
  (	65	,	0.120080383	,	0.27969867	),
  (	65	,	0.24105314	,	0.428599942	),
  (	65	,	6.207846645	,	0.285113459	),
  (	65	,	5.957981605	,	0.338016998	),
  (	65	,	6.084050924	,	0.519615461	),
  (	65	,	0.038712012	,	0.444419572	),
  (	65	,	0.021540833	,	0.465106928	),
  (	65	,	0.14319523	,	0.493584058	),
  (	65	,	0.039282319	,	0.4930119	),
  (	65	,	6.180683428	,	0.574287326	),
  (	65	,	6.27803943	,	0.565166993	),
  (	65	,	1.515431365	,	-0.622622754	),
  (	65	,	1.672100966	,	-0.610811219	),
  (	65	,	1.707801723	,	-0.573663404	),
  (	65	,	1.672199095	,	-0.55484568	),
  (	65	,	1.629952316	,	-0.513052129	),
  (	65	,	1.678684262	,	-0.502322543	),
  (	65	,	1.456767132	,	-0.520966673	),
  (	65	,	1.61349219	,	-0.466020245	),
  (	65	,	1.630807196	,	-0.416455895	),
  (	65	,	1.803655411	,	-0.43082723	),
  (	65	,	1.787799013	,	-0.420208217	),
  (	65	,	1.871094483	,	-0.419642873	),
  (	65	,	1.820579182	,	-0.387512704	),
  (	65	,	1.656470295	,	-0.385771013	),
  (	65	,	1.674617659	,	-0.345319361	),
  (	65	,	1.674508462	,	-0.263042803	),
  (	65	,	1.50304588	,	-0.351270455	),
  (	65	,	1.393231903	,	-0.323051717	),
  (	65	,	1.600749487	,	-0.195016003	),
  (	65	,	1.713829544	,	-0.194889581	),
  (	65	,	1.427155158	,	-0.207716962	),
  (	65	,	1.562922477	,	-0.017351395	),
  (	65	,	1.996859505	,	-0.252038699	),
  (	65	,	1.957265055	,	-0.17529614	),
  (	65	,	2.058099202	,	-0.223741938	),
  (	65	,	1.990895193	,	-0.145059148	),
  (	65	,	1.835456287	,	-0.160621992	),
  (	65	,	1.819512802	,	-0.142757105	),
  (	65	,	1.967213257	,	-0.091219892	),
  (	65	,	1.926743388	,	-0.102924884	),
  (	65	,	2.105011117	,	-0.110605332	),
  (	65	,	2.187498404	,	-0.027962804	),
  (	65	,	2.218687825	,	-0.043933009	),
  (	65	,	2.025134713	,	0.041981503	),
  (	65	,	2.060017399	,	0.057190958	),
  (	65	,	2.170871606	,	0.154745232	),
  (	65	,	1.807039677	,	-0.102146047	),
  (	65	,	1.799349247	,	-0.092788191	),
  (	65	,	1.840808798	,	-0.023494897	),
  (	65	,	1.67125987	,	-0.057193563	),
  (	65	,	1.696777399	,	0.002232551	),
  (	65	,	1.640170745	,	0.02040683	),
  (	65	,	1.683262767	,	0.039646313	),
  (	65	,	1.840977223	,	0.096990047	),
  (	65	,	1.727883532	,	0.078504755	),
  (	65	,	1.740194729	,	0.082040634	),
  (	65	,	1.803681553	,	0.191912246	),
  (	65	,	2.010559642	,	0.240352853	),
  (	65	,	1.178826996	,	-0.237231495	),
  (	65	,	1.141555794	,	-0.109680725	),
  (	65	,	1.137285345	,	-0.109019847	),
  (	65	,	1.372411773	,	-0.143187976	),
  (	65	,	1.463303623	,	-0.078437935	),
  (	65	,	1.356860096	,	-0.039359982	),
  (	65	,	1.490829858	,	-0.050552122	),
  (	65	,	1.478236219	,	-0.045284151	),
  (	65	,	1.426745986	,	-0.041201245	),
  (	65	,	1.45352077	,	-0.029973546	),
  (	65	,	1.420339922	,	-0.009493308	),
  (	65	,	1.459479052	,	-0.00021596	),
  (	65	,	1.347986214	,	0.056174307	),
  (	65	,	1.441347597	,	0.073384471	),
  (	65	,	1.291421782	,	0.09422896	),
  (	65	,	1.017263033	,	-0.115781147	),
  (	65	,	0.958354959	,	-0.059227278	),
  (	65	,	1.165066501	,	0.036287527	),
  (	65	,	1.114728459	,	0.107968087	),
  (	65	,	1.187187239	,	0.094423971	),
  (	65	,	1.292185492	,	0.137957477	),
  (	65	,	1.045796529	,	0.180299114	),
  (	65	,	1.107546738	,	0.222592441	),
  (	65	,	1.56166628	,	0.021368567	),
  (	65	,	1.580766706	,	0.029566244	),
  (	65	,	1.639664572	,	0.074763122	),
  (	65	,	1.518450422	,	0.11264061	),
  (	65	,	1.644859368	,	0.123090282	),
  (	65	,	1.609123494	,	0.151309074	),
  (	65	,	1.627475498	,	0.179548548	),
  (	65	,	1.661852508	,	0.205184418	),
  (	65	,	1.505437759	,	0.224942284	),
  (	65	,	1.68192798	,	0.256946698	),
  (	65	,	1.708780636	,	0.277566813	),
  (	65	,	1.694998234	,	0.283407831	),
  (	65	,	1.664313336	,	0.310025799	),
  (	65	,	1.629938406	,	0.326031204	),
  (	65	,	1.734223141	,	0.42919168	),
  (	65	,	1.449682108	,	0.297683017	),
  (	65	,	1.400379973	,	0.345824474	),
  (	65	,	1.443054669	,	0.392037832	),
  (	65	,	1.491877262	,	0.407117436	),
  (	65	,	1.328022127	,	0.371366817	),
  (	65	,	1.203006379	,	0.347000788	),
  (	65	,	1.465745747	,	0.482795179	),
  (	65	,	1.486587819	,	0.557119393	),
  (	65	,	1.454979143	,	0.572481872	),
  (	65	,	1.533400145	,	0.560681681	),
  (	65	,	1.592799915	,	0.662600684	),
  (	65	,	3.281534909	,	-0.567822788	),
  (	65	,	3.144661893	,	-0.381137503	),
  (	65	,	3.392703635	,	-0.397125066	),
  (	65	,	3.26299713	,	-0.290280013	),
  (	65	,	2.773536957	,	-0.324088412	),
  (	65	,	3.15407244	,	-0.134102833	),
  (	65	,	3.692663719	,	-0.155185552	),
  (	65	,	3.594952867	,	-0.095976413	),
  (	65	,	3.7365543	,	-0.115568747	),
  (	65	,	3.727790255	,	-0.103797315	),
  (	65	,	3.664409174	,	-0.061962447	),
  (	65	,	3.715441592	,	0.023782021	),
  (	65	,	3.685361791	,	0.040099545	),
  (	65	,	3.608196723	,	0.110821576	),
  (	65	,	3.680950428	,	0.13170336	),
  (	65	,	3.680644184	,	0.188226995	),
  (	65	,	2.803533053	,	-0.243899832	),
  (	65	,	2.656220427	,	-0.189975981	),
  (	65	,	3.047345223	,	-0.042512838	),
  (	65	,	3.00150419	,	-0.029669259	),
  (	65	,	2.798632163	,	-0.030409238	),
  (	65	,	2.815027407	,	0.043421612	),
  (	65	,	2.485084485	,	-0.074124352	),
  (	65	,	2.38673204	,	0.025526883	),
  (	65	,	2.723677351	,	0.041326985	),
  (	65	,	2.668772177	,	0.233087887	),
  (	65	,	3.157896038	,	0.096990968	),
  (	65	,	3.28578546	,	0.179693837	),
  (	65	,	3.352068736	,	0.236541479	),
  (	65	,	3.475536536	,	0.345321957	),
  (	65	,	3.354408871	,	0.433530966	),
  (	65	,	2.913222151	,	0.407077651	),
  (	65	,	3.22464142	,	0.453930291	),
  (	65	,	3.226614866	,	0.491415759	),
  (	65	,	3.047947927	,	0.586879766	),
  (	65	,	3.133372147	,	0.563278439	),
  (	65	,	4.75329489	,	-0.64005722	),
  (	65	,	4.681538574	,	-0.611195672	),
  (	65	,	4.683552353	,	-0.609035917	),
  (	65	,	4.764617567	,	-0.504427828	),
  (	65	,	4.788311598	,	-0.493753712	),
  (	65	,	4.80630022	,	-0.434853877	),
  (	65	,	4.639500484	,	-0.486667534	),
  (	65	,	4.71239518	,	-0.354994934	),
  (	65	,	4.941340445	,	-0.465151177	),
  (	65	,	4.840524013	,	-0.440811661	),
  (	65	,	4.910098749	,	-0.366551008	),
  (	65	,	4.981296509	,	-0.396108813	),
  (	65	,	4.987788858	,	-0.333410985	),
  (	65	,	4.788642342	,	-0.322248223	),
  (	65	,	4.980988553	,	-0.266732165	),
  (	65	,	4.521309527	,	-0.463453978	),
  (	65	,	4.503938668	,	-0.440791243	),
  (	65	,	4.604651133	,	-0.384738552	),
  (	65	,	4.694571811	,	-0.328162058	),
  (	65	,	4.458675983	,	-0.329616707	),
  (	65	,	4.36583529	,	-0.356194603	),
  (	65	,	4.530531341	,	-0.284694616	),
  (	65	,	4.718433864	,	-0.299444614	),
  (	65	,	4.641723955	,	-0.235784744	),
  (	65	,	4.820188675	,	-0.123501336	),
  (	65	,	4.541689823	,	-0.186690348	),
  (	65	,	4.572922419	,	-0.143279031	),
  (	65	,	5.129337061	,	-0.213859546	),
  (	65	,	5.25819772	,	-0.202449896	),
  (	65	,	5.441320468	,	-0.043407233	),
  (	65	,	5.207089894	,	0.07680088	),
  (	65	,	4.84432805	,	-0.099907615	),
  (	65	,	5.005387957	,	0.01118556	),
  (	65	,	4.86776274	,	0.086145668	),
  (	65	,	4.886310893	,	0.128426258	),
  (	65	,	5.102036949	,	0.004293521	),
  (	65	,	5.128733628	,	0.050858526	),
  (	65	,	5.034114433	,	0.096264174	),
  (	65	,	5.202214054	,	0.180667841	),
  (	65	,	4.984484489	,	0.146146253	),
  (	65	,	5.073698675	,	0.173030096	),
  (	65	,	4.361806824	,	-0.166776704	),
  (	65	,	4.219545829	,	-0.245589299	),
  (	65	,	4.213853521	,	-0.109800445	),
  (	65	,	4.537829107	,	-0.103303377	),
  (	65	,	4.48945438	,	-0.067790477	),
  (	65	,	4.550318357	,	-0.041694667	),
  (	65	,	4.624954695	,	-0.011158175	),
  (	65	,	4.621383108	,	0.035393387	),
  (	65	,	4.1310056	,	-0.106820373	),
  (	65	,	4.250871542	,	0.103004149	),
  (	65	,	4.459245024	,	0.14749225	),
  (	65	,	4.864196564	,	0.190101768	),
  (	65	,	4.583138024	,	0.20811512	),
  (	65	,	4.716547165	,	0.263420254	),
  (	65	,	4.874492736	,	0.282719461	),
  (	65	,	5.056248552	,	0.34226755	),
  (	65	,	4.968737991	,	0.345476987	),
  (	65	,	4.98214806	,	0.388588981	),
  (	65	,	4.812957	,	0.291258592	),
  (	65	,	4.911329423	,	0.383705179	),
  (	65	,	4.925873706	,	0.419853458	),
  (	65	,	4.416037866	,	0.261349989	),
  (	65	,	4.527373109	,	0.403006809	),
  (	65	,	4.439758274	,	0.442492526	),
  (	65	,	4.700339418	,	0.418812917	),
  (	65	,	4.801497026	,	0.505857156	),
  (	65	,	4.858054312	,	0.539168125	),
  (	65	,	4.628109235	,	0.54606037	),
  (	65	,	4.659451222	,	0.598261309	),
  (	65	,	0.971076976	,	-1.488099095	),
  (	65	,	1.309948937	,	-1.366593101	),
  (	65	,	0.944663366	,	-1.366994986	),
  (	65	,	1.376243476	,	-1.284360511	),
  (	65	,	1.079365849	,	-1.120850649	),
  (	65	,	0.696081929	,	-1.121924953	),
  (	65	,	0.422142329	,	-1.017020077	),
  (	65	,	0.892749235	,	-0.891209175	),
  (	65	,	0.543625104	,	-0.957869212	),
  (	65	,	0.759688282	,	-0.887872541	),
  (	65	,	1.46152474	,	-1.067726726	),
  (	65	,	1.330857535	,	-0.949587482	),
  (	65	,	1.269455988	,	-0.933037374	),
  (	65	,	1.529258647	,	-0.920972055	),
  (	65	,	1.499615999	,	-0.799922715	),
  (	65	,	1.23804176	,	-0.716714394	),
  (	65	,	1.02349261	,	-0.919626207	),
  (	65	,	1.157675667	,	-0.770744956	),
  (	65	,	1.130310631	,	-0.591746606	),
  (	65	,	0.039454212	,	-0.94250997	),
  (	65	,	0.390556956	,	-0.816051482	),
  (	65	,	0.369565592	,	-0.777172499	),
  (	65	,	0.567590888	,	-0.764727111	),
  (	65	,	0.620456532	,	-0.753973498	),
  (	65	,	0.47915511	,	-0.67022118	),
  (	65	,	0.664306515	,	-0.635775098	),
  (	65	,	0.125339507	,	-0.881965266	),
  (	65	,	0.213562927	,	-0.815025028	),
  (	65	,	0.001394384	,	-0.773023552	),
  (	65	,	0.41818603	,	-0.697214648	),
  (	65	,	0.379469174	,	-0.567989332	),
  (	65	,	0.534378676	,	-0.517761994	),
  (	65	,	0.462602364	,	-0.477332609	),
  (	65	,	0.276161998	,	-0.515327308	),
  (	65	,	0.875957495	,	-0.464368432	),
  (	65	,	0.750236013	,	-0.537801937	),
  (	65	,	0.606363832	,	-0.45278378	),
  (	65	,	0.623799509	,	-0.320371011	),
  (	65	,	0.834608169	,	-0.279689601	),
  (	65	,	0.833782178	,	-0.23150433	),
  (	65	,	0.808044032	,	-0.14440995	),
  (	65	,	2.815534552	,	-1.404461458	),
  (	65	,	2.975515358	,	-1.354522559	),
  (	65	,	2.578778216	,	-1.397327797	),
  (	65	,	2.542307139	,	-1.25996613	),
  (	65	,	2.812314261	,	-1.236657394	),
  (	65	,	3.118663066	,	-1.158491187	),
  (	65	,	2.825967848	,	-1.126560274	),
  (	65	,	2.493853347	,	-1.164465866	),
  (	65	,	2.701234907	,	-1.128803574	),
  (	65	,	2.767268988	,	-1.064434931	),
  (	65	,	2.594277387	,	-1.019643497	),
  (	65	,	1.940018071	,	-1.247393154	),
  (	65	,	2.135884806	,	-1.039195782	),
  (	65	,	2.04345208	,	-0.985605128	),
  (	65	,	2.406567087	,	-1.01173851	),
  (	65	,	2.377130491	,	-1.009715346	),
  (	65	,	2.214207248	,	-0.960125885	),
  (	65	,	2.27915295	,	-0.973444673	),
  (	65	,	2.244855312	,	-0.891742432	),
  (	65	,	2.398736627	,	-0.862621805	),
  (	65	,	3.047080773	,	-1.10606346	),
  (	65	,	3.007428535	,	-1.109225377	),
  (	65	,	3.016149014	,	-1.069510797	),
  (	65	,	2.906390456	,	-0.893842836	),
  (	65	,	2.774294885	,	-1.016205002	),
  (	65	,	2.750522233	,	-0.996188514	),
  (	65	,	2.690717773	,	-0.893688117	),
  (	65	,	3.077057299	,	-0.856428954	),
  (	65	,	2.949143329	,	-0.836377945	),
  (	65	,	2.944812646	,	-0.763296984	),
  (	65	,	2.955002398	,	-0.731892964	),
  (	65	,	2.95678694	,	-0.606282817	),
  (	65	,	2.721286326	,	-0.732219653	),
  (	65	,	2.640920743	,	-0.635028928	),
  (	65	,	2.500736171	,	-0.682926352	),
  (	65	,	2.41427279	,	-0.737800534	),
  (	65	,	2.459800967	,	-0.6589791	),
  (	65	,	2.915848342	,	-0.523120269	),
  (	65	,	2.676461831	,	-0.576504405	),
  (	65	,	2.775401057	,	-0.46558428	),
  (	65	,	2.711701427	,	-0.413829994	),
  (	65	,	1.800990344	,	-1.035694508	),
  (	65	,	1.674567664	,	-1.021780269	),
  (	65	,	1.826745393	,	-0.972666507	),
  (	65	,	1.965575286	,	-0.883291036	),
  (	65	,	1.806569219	,	-0.883312039	),
  (	65	,	2.087218513	,	-0.897940035	),
  (	65	,	2.107172357	,	-0.843429318	),
  (	65	,	2.240585617	,	-0.819792104	),
  (	65	,	2.299859195	,	-0.786702035	),
  (	65	,	2.318941592	,	-0.741840882	),
  (	65	,	2.302405178	,	-0.728472093	),
  (	65	,	2.209129638	,	-0.681706742	),
  (	65	,	2.048447902	,	-0.781051529	),
  (	65	,	2.109634986	,	-0.749590128	),
  (	65	,	2.137131588	,	-0.744221661	),
  (	65	,	2.023701989	,	-0.7035302	),
  (	65	,	2.035739418	,	-0.69916936	),
  (	65	,	2.015708859	,	-0.672444907	),
  (	65	,	2.157635863	,	-0.712545528	),
  (	65	,	1.860298695	,	-0.761149562	),
  (	65	,	1.590303674	,	-0.78600717	),
  (	65	,	1.574507427	,	-0.748230027	),
  (	65	,	1.840390185	,	-0.620426847	),
  (	65	,	1.818465448	,	-0.616821974	),
  (	65	,	1.708600958	,	-0.644716401	),
  (	65	,	1.727436937	,	-0.629873861	),
  (	65	,	1.682061569	,	-0.611990246	),
  (	65	,	1.767330764	,	-0.533833053	),
  (	65	,	1.956438413	,	-0.659916919	),
  (	65	,	2.150088026	,	-0.522037361	),
  (	65	,	2.078593953	,	-0.528567265	),
  (	65	,	1.856734945	,	-0.606980512	),
  (	65	,	1.936909823	,	-0.527385922	),
  (	65	,	1.863137618	,	-0.46524764	),
  (	65	,	1.954910374	,	-0.468427499	),
  (	65	,	1.995269328	,	-0.414958259	),
  (	65	,	1.92372179	,	-0.398814749	),
  (	65	,	2.365379463	,	-0.687693965	),
  (	65	,	2.213395598	,	-0.552794021	),
  (	65	,	2.352974981	,	-0.502757326	),
  (	65	,	2.361391717	,	-0.465376092	),
  (	65	,	2.401495882	,	-0.404509042	),
  (	65	,	2.587269218	,	-0.477024887	),
  (	65	,	2.486357092	,	-0.407453307	),
  (	65	,	2.219184993	,	-0.402664254	),
  (	65	,	2.130708327	,	-0.412207775	),
  (	65	,	2.311466949	,	-0.367371482	),
  (	65	,	2.236441375	,	-0.262321313	),
  (	65	,	2.47506754	,	-0.160984832	),
  (	65	,	2.501624532	,	-0.125495558	),
  (	65	,	2.27836462	,	-0.208847846	),
  (	65	,	2.260318046	,	-0.204967074	),
  (	65	,	2.295603849	,	-0.192102371	),
  (	65	,	4.188434041	,	-1.361837323	),
  (	65	,	4.025110867	,	-1.298517069	),
  (	65	,	4.504417137	,	-1.234325203	),
  (	65	,	4.345087779	,	-1.254795527	),
  (	65	,	4.437572524	,	-1.241136714	),
  (	65	,	4.490614154	,	-1.2016055	),
  (	65	,	4.37557088	,	-1.091773043	),
  (	65	,	4.159914499	,	-1.092692336	),
  (	65	,	3.658727042	,	-1.148443138	),
  (	65	,	3.169219798	,	-1.198193263	),
  (	65	,	3.251931906	,	-1.14791261	),
  (	65	,	3.595177885	,	-1.033864377	),
  (	65	,	3.973830823	,	-1.072023232	),
  (	65	,	3.879483915	,	-0.989054698	),
  (	65	,	3.790526052	,	-1.033192925	),
  (	65	,	3.84210379	,	-0.98507832	),
  (	65	,	3.832279481	,	-0.87094058	),
  (	65	,	3.918901653	,	-0.852860399	),
  (	65	,	3.837105617	,	-0.856191947	),
  (	65	,	4.696726728	,	-1.147099269	),
  (	65	,	4.439674805	,	-1.05767346	),
  (	65	,	4.240996823	,	-0.948639613	),
  (	65	,	4.458322156	,	-0.892408295	),
  (	65	,	4.389966006	,	-0.812140286	),
  (	65	,	4.282383512	,	-0.841052806	),
  (	65	,	4.634113018	,	-0.88158	),
  (	65	,	4.600163229	,	-0.846947275	),
  (	65	,	4.525169484	,	-0.781534386	),
  (	65	,	4.613990315	,	-0.664383801	),
  (	65	,	4.606436187	,	-0.653453163	),
  (	65	,	4.425256001	,	-0.73040746	),
  (	65	,	4.417082444	,	-0.730499461	),
  (	65	,	4.549434672	,	-0.659815485	),
  (	65	,	4.504156702	,	-0.677586961	),
  (	65	,	4.519730418	,	-0.588821918	),
  (	65	,	4.105751891	,	-0.833157204	),
  (	65	,	4.054923822	,	-0.674317407	),
  (	65	,	4.02080606	,	-0.667044765	),
  (	65	,	4.095167522	,	-0.683486016	),
  (	65	,	4.182300804	,	-0.654569326	),
  (	65	,	4.16919826	,	-0.54250889	),
  (	65	,	3.265628292	,	-1.078523928	),
  (	65	,	3.178296416	,	-1.061982835	),
  (	65	,	3.649184238	,	-0.94479156	),
  (	65	,	3.605152872	,	-0.954407862	),
  (	65	,	3.278072323	,	-0.996259694	),
  (	65	,	3.370269825	,	-0.939509832	),
  (	65	,	3.286462342	,	-0.909018615	),
  (	65	,	3.733476485	,	-0.785428071	),
  (	65	,	3.84112196	,	-0.799255977	),
  (	65	,	3.872599443	,	-0.760211466	),
  (	65	,	3.576529294	,	-0.693727241	),
  (	65	,	3.628558659	,	-0.63589456	),
  (	65	,	3.28984948	,	-0.871096541	),
  (	65	,	3.424350339	,	-0.719013541	),
  (	65	,	3.209201826	,	-0.731546612	),
  (	65	,	3.244617616	,	-0.685955094	),
  (	65	,	3.331129944	,	-0.701237331	),
  (	65	,	3.454232612	,	-0.463414896	),
  (	65	,	3.541056388	,	-0.490659395	),
  (	65	,	3.598691078	,	-0.445078019	),
  (	65	,	3.954180669	,	-0.632937544	),
  (	65	,	4.065904121	,	-0.5738864	),
  (	65	,	3.894444219	,	-0.53367894	),
  (	65	,	4.205857645	,	-0.431554934	),
  (	65	,	4.272257062	,	-0.352873573	),
  (	65	,	4.23207087	,	-0.320112692	),
  (	65	,	4.116420927	,	-0.262565463	),
  (	65	,	3.722880633	,	-0.46447465	),
  (	65	,	3.817235531	,	-0.35673479	),
  (	65	,	3.891450366	,	-0.320361154	),
  (	65	,	3.767410239	,	-0.204455753	),
  (	65	,	3.956730675	,	-0.28770838	),
  (	65	,	3.991753331	,	-0.09603663	),
  (	65	,	5.64333071	,	-1.396952958	),
  (	65	,	5.76776917	,	-1.355467794	),
  (	65	,	4.921022998	,	-1.359039334	),
  (	65	,	5.973046603	,	-1.112095358	),
  (	65	,	5.319106689	,	-1.103593599	),
  (	65	,	5.409930699	,	-1.097957209	),
  (	65	,	5.711189569	,	-0.982166941	),
  (	65	,	5.325606086	,	-0.960823223	),
  (	65	,	5.500947447	,	-0.937926402	),
  (	65	,	5.531574293	,	-0.792021802	),
  (	65	,	5.542149804	,	-0.757173046	),
  (	65	,	5.564299508	,	-0.706963364	),
  (	65	,	5.691929362	,	-0.672888118	),
  (	65	,	5.668411827	,	-0.58781193	),
  (	65	,	5.966047049	,	-0.59623116	),
  (	65	,	5.968763998	,	-0.452263778	),
  (	65	,	5.803234884	,	-0.493793205	),
  (	65	,	4.991719245	,	-1.011591848	),
  (	65	,	4.910466306	,	-0.992780156	),
  (	65	,	5.203931059	,	-0.959519692	),
  (	65	,	5.150098457	,	-0.949770997	),
  (	65	,	5.187636974	,	-0.923077532	),
  (	65	,	5.053444533	,	-0.931790344	),
  (	65	,	4.863001568	,	-0.923136318	),
  (	65	,	5.072940842	,	-0.894155589	),
  (	65	,	5.290077858	,	-0.746664945	),
  (	65	,	5.414567838	,	-0.73996075	),
  (	65	,	5.423101728	,	-0.690432876	),
  (	65	,	5.388377943	,	-0.664795475	),
  (	65	,	5.26013449	,	-0.575956336	),
  (	65	,	4.739239396	,	-0.903102273	),
  (	65	,	4.970621975	,	-0.690014766	),
  (	65	,	4.904957105	,	-0.640861119	),
  (	65	,	5.016101825	,	-0.631196713	),
  (	65	,	5.046385714	,	-0.585074833	),
  (	65	,	5.231376896	,	-0.533003056	),
  (	65	,	5.624597954	,	-0.545217156	),
  (	65	,	5.416649535	,	-0.453787058	),
  (	65	,	5.401238693	,	-0.438240481	),
  (	65	,	5.511623411	,	-0.484011889	),
  (	65	,	5.639841454	,	-0.42918296	),
  (	65	,	5.769190589	,	-0.312481735	),
  (	65	,	5.411441717	,	-0.414876323	),
  (	65	,	5.451284681	,	-0.314789222	),
  (	65	,	5.259720426	,	-0.221054755	),
  (	65	,	5.467656308	,	-0.201993017	),
  (	65	,	5.544848285	,	-0.163266489	),
  (	65	,	5.336404656	,	-0.168508479	),
  (	65	,	5.471492994	,	-0.120246418	),
  (	65	,	5.50016507	,	-0.095599204	),
  (	65	,	5.48166413	,	-0.06216234	),
  (	66	,	0.765877784	,	0.035224027	),
  (	66	,	0.643073251	,	0.17796972	),
  (	66	,	0.805805418	,	0.276728659	),
  (	66	,	0.903447791	,	0.327363405	),
  (	66	,	0.998984977	,	0.416378483	),
  (	66	,	1.00078519	,	0.425522425	),
  (	66	,	0.716979607	,	0.31003462	),
  (	66	,	0.465085499	,	0.303909285	),
  (	66	,	0.685098051	,	0.430173273	),
  (	66	,	0.587469319	,	0.500743331	),
  (	66	,	0.922175715	,	0.481215111	),
  (	66	,	0.945380775	,	0.510054659	),
  (	66	,	0.743662796	,	0.558026588	),
  (	66	,	0.744329885	,	0.6448543	),
  (	66	,	0.739355811	,	0.651468404	),
  (	66	,	1.238323006	,	0.57360629	),
  (	66	,	1.393631629	,	0.593155435	),
  (	66	,	1.366966885	,	0.651642439	),
  (	66	,	1.353997483	,	0.651039309	),
  (	66	,	1.443178794	,	0.695088839	),
  (	66	,	1.508942336	,	0.70698435	),
  (	66	,	1.515142164	,	0.742221142	),
  (	66	,	1.327630911	,	0.798992819	),
  (	66	,	0.994304763	,	0.586427772	),
  (	66	,	1.038703024	,	0.607614325	),
  (	66	,	1.045739888	,	0.677543271	),
  (	66	,	1.040598329	,	0.677885699	),
  (	66	,	0.922867853	,	0.711389534	),
  (	66	,	0.92458852	,	0.850585876	),
  (	66	,	1.529622068	,	0.9934224	),
  (	66	,	1.451106135	,	0.998668848	),
  (	66	,	1.236113349	,	1.038836492	),
  (	66	,	0.323251041	,	0.497928488	),
  (	66	,	0.3377228	,	0.554048611	),
  (	66	,	0.319700976	,	0.595128762	),
  (	66	,	0.343756397	,	0.652512983	),
  (	66	,	0.609216689	,	0.695249096	),
  (	66	,	0.730940563	,	0.77269485	),
  (	66	,	0.418362356	,	0.716918773	),
  (	66	,	0.450646514	,	0.791030118	),
  (	66	,	0.455713357	,	0.805285809	),
  (	66	,	0.56094834	,	0.775957737	),
  (	66	,	0.593255369	,	0.834469896	),
  (	66	,	0.542014675	,	0.907006936	),
  (	66	,	0.085921227	,	0.71086099	),
  (	66	,	0.089517177	,	0.8546635	),
  (	66	,	0.358708347	,	0.760685173	),
  (	66	,	0.384872702	,	0.768803429	),
  (	66	,	0.333395206	,	0.839193151	),
  (	66	,	0.275017519	,	0.82686816	),
  (	66	,	0.437281665	,	0.940178272	),
  (	66	,	0.293033905	,	0.933719067	),
  (	66	,	0.201809722	,	0.965260502	),
  (	66	,	0.116320524	,	0.988575781	),
  (	66	,	0.021453092	,	1.021578769	),
  (	66	,	0.203798996	,	1.039771845	),
  (	66	,	0.046155696	,	1.041497092	),
  (	66	,	0.069433491	,	1.064652554	),
  (	66	,	0.03729376	,	1.103118201	),
  (	66	,	0.839692735	,	0.832963457	),
  (	66	,	0.711357751	,	0.842386884	),
  (	66	,	0.699656187	,	0.864988537	),
  (	66	,	0.854393761	,	0.889343956	),
  (	66	,	0.897974035	,	0.941103222	),
  (	66	,	0.950051154	,	0.990289061	),
  (	66	,	0.545706785	,	0.970786504	),
  (	66	,	0.619259812	,	0.999077221	),
  (	66	,	0.693655873	,	1.092424623	),
  (	66	,	0.824244838	,	1.088816543	),
  (	66	,	1.399219758	,	1.164955693	),
  (	66	,	1.103315747	,	1.195571588	),
  (	66	,	0.583347793	,	1.022074921	),
  (	66	,	0.445272827	,	1.065317593	),
  (	66	,	0.611794047	,	1.122892623	),
  (	66	,	0.289665687	,	1.095389022	),
  (	66	,	0.016848174	,	1.164346407	),
  (	66	,	0.007265799	,	1.284767621	),
  (	66	,	0.873175647	,	1.217040328	),
  (	66	,	0.917710291	,	1.254261712	),
  (	66	,	0.939013708	,	1.280142328	),
  (	66	,	1.247991937	,	1.337098555	),
  (	66	,	1.4374079	,	1.360962536	),
  (	66	,	1.125133092	,	1.405615915	),
  (	66	,	0.424866209	,	1.296795932	),
  (	66	,	1.447788441	,	1.499901001	),
  (	66	,	2.348060282	,	0.026904899	),
  (	66	,	2.398834936	,	0.201828834	),
  (	66	,	2.336041633	,	0.300743232	),
  (	66	,	2.352605352	,	0.316504714	),
  (	66	,	2.348795094	,	0.319537088	),
  (	66	,	2.15700608	,	0.227733528	),
  (	66	,	2.148365852	,	0.244417339	),
  (	66	,	2.156291517	,	0.308505371	),
  (	66	,	2.269756353	,	0.348560416	),
  (	66	,	2.26939018	,	0.349200311	),
  (	66	,	2.154145124	,	0.403828351	),
  (	66	,	2.238383905	,	0.420353375	),
  (	66	,	2.098812878	,	0.411599425	),
  (	66	,	2.118907221	,	0.480483188	),
  (	66	,	2.458845329	,	0.439523582	),
  (	66	,	2.492717647	,	0.477994563	),
  (	66	,	2.298012015	,	0.502039632	),
  (	66	,	2.391391658	,	0.567934491	),
  (	66	,	2.43662078	,	0.617223401	),
  (	66	,	2.349458712	,	0.62487322	),
  (	66	,	2.611144956	,	0.484482524	),
  (	66	,	2.689840161	,	0.500592165	),
  (	66	,	2.721386132	,	0.516892509	),
  (	66	,	2.934468479	,	0.625055269	),
  (	66	,	2.939429849	,	0.717137412	),
  (	66	,	3.027857093	,	0.64254767	),
  (	66	,	3.048762459	,	0.787292232	),
  (	66	,	3.012497242	,	0.814330872	),
  (	66	,	3.014503686	,	0.836508348	),
  (	66	,	2.665914169	,	0.709679275	),
  (	66	,	2.609038863	,	0.792624953	),
  (	66	,	2.505958357	,	0.818593578	),
  (	66	,	2.742818971	,	0.789099425	),
  (	66	,	2.740464346	,	0.851350409	),
  (	66	,	2.881645947	,	0.898879291	),
  (	66	,	2.949932289	,	0.921072409	),
  (	66	,	2.706315825	,	0.93863263	),
  (	66	,	2.820329844	,	1.001217006	),
  (	66	,	1.907027524	,	0.46580378	),
  (	66	,	1.957672854	,	0.480892478	),
  (	66	,	1.838194769	,	0.565739468	),
  (	66	,	1.868466298	,	0.590483234	),
  (	66	,	1.971898278	,	0.678861551	),
  (	66	,	2.102767352	,	0.618073704	),
  (	66	,	2.086879947	,	0.76755075	),
  (	66	,	1.995330463	,	0.698568625	),
  (	66	,	2.059763806	,	0.801676392	),
  (	66	,	1.752436223	,	0.627127333	),
  (	66	,	1.924447954	,	0.744481775	),
  (	66	,	1.706285015	,	0.693845482	),
  (	66	,	1.607385671	,	0.716551769	),
  (	66	,	1.583414811	,	0.757091157	),
  (	66	,	1.745179339	,	0.768191585	),
  (	66	,	1.650564733	,	0.80912655	),
  (	66	,	1.647484729	,	0.810252175	),
  (	66	,	1.582812159	,	0.834445249	),
  (	66	,	1.593212446	,	1.036601301	),
  (	66	,	1.747602451	,	1.080754039	),
  (	66	,	2.3535954	,	0.798282297	),
  (	66	,	2.445603387	,	0.915443231	),
  (	66	,	2.486173808	,	0.972932874	),
  (	66	,	2.264550297	,	0.923713167	),
  (	66	,	2.183763862	,	0.935031224	),
  (	66	,	2.520362359	,	1.050923145	),
  (	66	,	2.74849073	,	1.145390175	),
  (	66	,	2.556566031	,	1.110954692	),
  (	66	,	2.696584429	,	1.275365327	),
  (	66	,	2.035292449	,	1.096592137	),
  (	66	,	2.237906629	,	1.209857552	),
  (	66	,	1.893548856	,	1.253438178	),
  (	66	,	2.191108869	,	1.30586764	),
  (	66	,	2.65540241	,	1.464652475	),
  (	66	,	3.898142648	,	0.274109178	),
  (	66	,	4.157957459	,	0.303741175	),
  (	66	,	4.054404217	,	0.28616489	),
  (	66	,	4.074807211	,	0.299097279	),
  (	66	,	3.848030224	,	0.368669618	),
  (	66	,	3.82276946	,	0.405798612	),
  (	66	,	3.672225824	,	0.308361276	),
  (	66	,	3.876315167	,	0.425289061	),
  (	66	,	4.019117406	,	0.435597074	),
  (	66	,	4.087968287	,	0.523438054	),
  (	66	,	4.460564644	,	0.556484903	),
  (	66	,	4.244466245	,	0.465485342	),
  (	66	,	4.239667184	,	0.581942814	),
  (	66	,	4.584413508	,	0.678624028	),
  (	66	,	4.627863009	,	0.758713132	),
  (	66	,	4.638608434	,	0.769420767	),
  (	66	,	4.698467362	,	0.791517781	),
  (	66	,	4.677553665	,	0.814069897	),
  (	66	,	4.441147465	,	0.741976653	),
  (	66	,	4.668998458	,	0.844638897	),
  (	66	,	4.624244103	,	0.868823012	),
  (	66	,	4.083286139	,	0.669750271	),
  (	66	,	4.219300499	,	0.829120346	),
  (	66	,	4.374097514	,	0.871542119	),
  (	66	,	4.561403846	,	0.921365262	),
  (	66	,	4.314129048	,	0.897235128	),
  (	66	,	4.277846488	,	0.908252122	),
  (	66	,	4.552595193	,	0.99504407	),
  (	66	,	4.52253048	,	1.058903623	),
  (	66	,	3.605067133	,	0.539242837	),
  (	66	,	3.237302988	,	0.823481991	),
  (	66	,	3.494342961	,	0.767776839	),
  (	66	,	3.600725132	,	0.97523496	),
  (	66	,	3.192857024	,	0.995785204	),
  (	66	,	3.329502858	,	1.067365891	),
  (	66	,	3.963317464	,	0.873621102	),
  (	66	,	3.881352175	,	0.896654471	),
  (	66	,	3.731873743	,	0.916924424	),
  (	66	,	3.814751917	,	0.995948376	),
  (	66	,	4.559512723	,	1.174724249	),
  (	66	,	4.055053677	,	1.083840027	),
  (	66	,	4.047775876	,	1.0869127	),
  (	66	,	4.268032272	,	1.196507993	),
  (	66	,	4.4464131	,	1.20752279	),
  (	66	,	4.68814584	,	1.311991388	),
  (	66	,	3.587145383	,	1.139230331	),
  (	66	,	3.625799388	,	1.192319762	),
  (	66	,	3.673226681	,	1.198668499	),
  (	66	,	3.462447898	,	1.270582101	),
  (	66	,	3.424454983	,	1.274527372	),
  (	66	,	3.256739765	,	1.255409521	),
  (	66	,	4.243463111	,	1.312678355	),
  (	66	,	4.322453629	,	1.351729893	),
  (	66	,	4.354053139	,	1.377395995	),
  (	66	,	4.524331759	,	1.554000656	),
  (	66	,	5.518551919	,	0.039606801	),
  (	66	,	5.478936044	,	0.079112251	),
  (	66	,	5.383882862	,	0.175576617	),
  (	66	,	5.348281354	,	0.17550565	),
  (	66	,	5.51101083	,	0.257088056	),
  (	66	,	5.735009946	,	0.222546446	),
  (	66	,	5.792312016	,	0.314167704	),
  (	66	,	5.734668815	,	0.344144777	),
  (	66	,	5.743877616	,	0.370707247	),
  (	66	,	5.726004333	,	0.371289636	),
  (	66	,	5.648612378	,	0.397134842	),
  (	66	,	5.639381671	,	0.408312956	),
  (	66	,	5.604193854	,	0.428100138	),
  (	66	,	5.349553506	,	0.242800078	),
  (	66	,	5.328744425	,	0.263617995	),
  (	66	,	5.456859108	,	0.31505639	),
  (	66	,	5.413818712	,	0.347978586	),
  (	66	,	5.364059398	,	0.350595737	),
  (	66	,	5.150781108	,	0.357391754	),
  (	66	,	5.222928199	,	0.366488249	),
  (	66	,	5.279384738	,	0.365047967	),
  (	66	,	5.257702137	,	0.405098261	),
  (	66	,	5.307780446	,	0.484784409	),
  (	66	,	5.467778925	,	0.517466671	),
  (	66	,	5.399804547	,	0.550157312	),
  (	66	,	5.384484753	,	0.605262933	),
  (	66	,	6.024472484	,	0.542499953	),
  (	66	,	6.032545469	,	0.554696213	),
  (	66	,	5.958407249	,	0.5312805	),
  (	66	,	5.940766484	,	0.540456433	),
  (	66	,	5.831553606	,	0.485271331	),
  (	66	,	5.779550803	,	0.574941048	),
  (	66	,	5.761526098	,	0.57606901	),
  (	66	,	5.891093839	,	0.544816821	),
  (	66	,	5.889323273	,	0.623525129	),
  (	66	,	6.162816812	,	0.610032149	),
  (	66	,	6.052303668	,	0.62197549	),
  (	66	,	6.196122362	,	0.657152722	),
  (	66	,	6.057200268	,	0.777751301	),
  (	66	,	6.05323799	,	0.804040484	),
  (	66	,	6.023887662	,	0.791939152	),
  (	66	,	6.104474329	,	0.787783804	),
  (	66	,	6.241192552	,	0.900965672	),
  (	66	,	5.714505251	,	0.718181095	),
  (	66	,	5.777528455	,	0.773967839	),
  (	66	,	5.597184789	,	0.674292276	),
  (	66	,	5.568848079	,	0.772103893	),
  (	66	,	5.699710006	,	0.751553315	),
  (	66	,	5.807937382	,	0.849580141	),
  (	66	,	5.638653869	,	0.845501741	),
  (	66	,	5.926658333	,	0.788590873	),
  (	66	,	5.890954471	,	0.861428219	),
  (	66	,	6.017769324	,	0.918998791	),
  (	66	,	6.209421081	,	0.927687808	),
  (	66	,	5.849727282	,	0.889783009	),
  (	66	,	5.900580038	,	0.943125675	),
  (	66	,	5.956185695	,	1.014841024	),
  (	66	,	6.036043757	,	1.022130778	),
  (	66	,	6.093166417	,	1.081457032	),
  (	66	,	5.089859965	,	0.353585301	),
  (	66	,	5.151599306	,	0.413955199	),
  (	66	,	5.156910946	,	0.477909113	),
  (	66	,	5.21464464	,	0.52700028	),
  (	66	,	5.248265737	,	0.557788358	),
  (	66	,	5.16102735	,	0.511941614	),
  (	66	,	5.234471131	,	0.555478159	),
  (	66	,	4.999431467	,	0.522230446	),
  (	66	,	5.077030183	,	0.579852106	),
  (	66	,	5.120828444	,	0.676525882	),
  (	66	,	5.373886869	,	0.599171603	),
  (	66	,	5.239247109	,	0.638611228	),
  (	66	,	5.322406761	,	0.648083778	),
  (	66	,	5.31871136	,	0.680750504	),
  (	66	,	5.473226836	,	0.710400739	),
  (	66	,	5.469164447	,	0.740197126	),
  (	66	,	5.349715671	,	0.705143182	),
  (	66	,	5.332203619	,	0.717890645	),
  (	66	,	5.312277618	,	0.745640583	),
  (	66	,	5.402940355	,	0.773752116	),
  (	66	,	5.195763818	,	0.660194453	),
  (	66	,	5.229760162	,	0.665069909	),
  (	66	,	5.162595188	,	0.674948767	),
  (	66	,	5.226977533	,	0.737588413	),
  (	66	,	5.169729792	,	0.71063932	),
  (	66	,	5.125739237	,	0.766999695	),
  (	66	,	5.26736674	,	0.876670578	),
  (	66	,	4.92939915	,	0.552038036	),
  (	66	,	4.887811866	,	0.669634307	),
  (	66	,	4.767846133	,	0.718142288	),
  (	66	,	4.804538689	,	0.867875902	),
  (	66	,	5.055486352	,	0.865155584	),
  (	66	,	5.041031513	,	0.873906124	),
  (	66	,	4.96978121	,	0.886787696	),
  (	66	,	4.983424849	,	0.912123494	),
  (	66	,	5.126994511	,	0.916328839	),
  (	66	,	5.110436391	,	0.972701742	),
  (	66	,	5.541322245	,	0.794169381	),
  (	66	,	5.512786703	,	0.878812339	),
  (	66	,	5.491252476	,	0.880733572	),
  (	66	,	5.606535303	,	0.860849444	),
  (	66	,	5.724717078	,	0.973755313	),
  (	66	,	5.370721619	,	0.858930916	),
  (	66	,	5.438226211	,	0.924929852	),
  (	66	,	5.406169357	,	0.977463901	),
  (	66	,	5.50615242	,	0.996092433	),
  (	66	,	5.756884092	,	1.006329669	),
  (	66	,	5.790826766	,	1.026961789	),
  (	66	,	5.907446465	,	1.078233575	),
  (	66	,	5.762441576	,	1.090617486	),
  (	66	,	6.061847489	,	1.138153598	),
  (	66	,	6.064723202	,	1.173597089	),
  (	66	,	5.776094673	,	1.127984545	),
  (	66	,	5.712170115	,	1.165732603	),
  (	66	,	6.260586682	,	1.298700406	),
  (	66	,	6.250276995	,	1.318504079	),
  (	66	,	6.147741568	,	1.312931061	),
  (	66	,	5.149681907	,	1.056047268	),
  (	66	,	5.118911039	,	1.049967864	),
  (	66	,	5.08957034	,	1.091832978	),
  (	66	,	5.357567786	,	1.147652126	),
  (	66	,	5.257319653	,	1.187296751	),
  (	66	,	5.750207838	,	1.308938328	),
  (	66	,	5.839618383	,	1.334968811	),
  (	66	,	5.595318809	,	1.345475452	),
  (	66	,	6.267805335	,	1.451959737	),
  (	66	,	6.179163184	,	-0.46908009	),
  (	66	,	0.36000173	,	-0.333037676	),
  (	66	,	0.168124991	,	-0.354241359	),
  (	66	,	0.123697351	,	-0.354922514	),
  (	66	,	0.076557352	,	-0.332504678	),
  (	66	,	0.199383838	,	-0.286657453	),
  (	66	,	6.126386181	,	-0.380044595	),
  (	66	,	6.187422825	,	-0.263472699	),
  (	66	,	6.001799088	,	-0.351500553	),
  (	66	,	5.995626851	,	-0.33467	),
  (	66	,	6.097628335	,	-0.282258764	),
  (	66	,	0.099808179	,	-0.213087479	),
  (	66	,	0.081635636	,	-0.140568825	),
  (	66	,	6.143948881	,	-0.19983864	),
  (	66	,	6.176434527	,	-0.130276817	),
  (	66	,	0.511162276	,	-0.17879343	),
  (	66	,	0.406048329	,	-0.157334605	),
  (	66	,	0.306298682	,	-0.155446073	),
  (	66	,	0.514833976	,	-0.035944012	),
  (	66	,	0.582492681	,	0.087484243	),
  (	66	,	0.022100098	,	-0.008786125	),
  (	66	,	0.223864842	,	0.05907158	),
  (	66	,	0.131529058	,	0.084826678	),
  (	66	,	0.379141071	,	0.061706631	),
  (	66	,	0.422044893	,	0.136687042	),
  (	66	,	0.388557827	,	0.127299176	),
  (	66	,	0.407120316	,	0.143265579	),
  (	66	,	0.55066884	,	0.143955178	),
  (	66	,	5.915848101	,	-0.304746995	),
  (	66	,	6.158961528	,	-0.071361891	),
  (	66	,	6.149883045	,	-0.031265304	),
  (	66	,	6.234416605	,	0.038644627	),
  (	66	,	6.160836367	,	-0.018950375	),
  (	66	,	6.124073829	,	0.005086235	),
  (	66	,	6.044489041	,	0.022811069	),
  (	66	,	5.726227807	,	-0.055409409	),
  (	66	,	5.799528753	,	0.047715068	),
  (	66	,	5.661346312	,	0.081724556	),
  (	66	,	6.015241644	,	0.163296728	),
  (	66	,	5.950314992	,	0.190909277	),
  (	66	,	5.975734833	,	0.182881933	),
  (	66	,	6.007682254	,	0.206791715	),
  (	66	,	5.921380582	,	0.219502968	),
  (	66	,	5.902096141	,	0.227672424	),
  (	66	,	5.804824427	,	0.255336296	),
  (	66	,	5.902626796	,	0.276868322	),
  (	66	,	0.091232081	,	0.191579835	),
  (	66	,	6.219323532	,	0.177670796	),
  (	66	,	0.152369866	,	0.233363955	),
  (	66	,	0.122058726	,	0.340582064	),
  (	66	,	0.113712725	,	0.351629763	),
  (	66	,	0.209083944	,	0.365217854	),
  (	66	,	6.043635851	,	0.289051655	),
  (	66	,	6.049921606	,	0.347510562	),
  (	66	,	6.085141208	,	0.420675471	),
  (	66	,	6.119457598	,	0.452361585	),
  (	66	,	6.078394802	,	0.513846775	),
  (	66	,	0.001744098	,	0.469803213	),
  (	66	,	0.065960085	,	0.550401633	),
  (	66	,	6.280943018	,	0.588578994	),
  (	66	,	0.056013872	,	0.657878112	),
  (	66	,	8.86185E-05	,	0.678222086	),
  (	66	,	1.555849314	,	-0.405180054	),
  (	66	,	1.766559811	,	-0.477166505	),
  (	66	,	1.807363786	,	-0.417627939	),
  (	66	,	1.813170552	,	-0.384625698	),
  (	66	,	1.725755012	,	-0.385878261	),
  (	66	,	1.882422128	,	-0.302484304	),
  (	66	,	1.716722531	,	-0.365195813	),
  (	66	,	1.648188186	,	-0.334905865	),
  (	66	,	1.790175036	,	-0.301804785	),
  (	66	,	1.687345238	,	-0.254879414	),
  (	66	,	1.41022891	,	-0.466095149	),
  (	66	,	1.340245273	,	-0.33841838	),
  (	66	,	1.404335014	,	-0.240081183	),
  (	66	,	1.344867834	,	-0.263463004	),
  (	66	,	1.343159655	,	-0.219794171	),
  (	66	,	1.379578043	,	-0.198138648	),
  (	66	,	1.657870009	,	-0.244223493	),
  (	66	,	1.662821612	,	-0.206250928	),
  (	66	,	1.637966145	,	-0.207769888	),
  (	66	,	1.437380965	,	-0.126726582	),
  (	66	,	1.462968467	,	-0.094037181	),
  (	66	,	1.462864269	,	-0.094026358	),
  (	66	,	1.601233552	,	-0.108261523	),
  (	66	,	1.509919461	,	-0.074507446	),
  (	66	,	1.569178223	,	-0.025204146	),
  (	66	,	2.049304984	,	-0.24583601	),
  (	66	,	1.992674388	,	-0.252088509	),
  (	66	,	1.840559297	,	-0.197238413	),
  (	66	,	1.909071669	,	-0.116586354	),
  (	66	,	2.248925873	,	0.0478829	),
  (	66	,	2.119819708	,	-0.010005907	),
  (	66	,	2.054649774	,	0.001389383	),
  (	66	,	1.7957542	,	-0.121588102	),
  (	66	,	1.899455865	,	-0.002814537	),
  (	66	,	1.8515155	,	0.02597838	),
  (	66	,	1.68330623	,	-0.06787698	),
  (	66	,	1.682405015	,	-0.052210391	),
  (	66	,	1.626396161	,	-0.043717425	),
  (	66	,	1.677983861	,	-0.024753467	),
  (	66	,	1.6421425	,	0.01885532	),
  (	66	,	1.681223368	,	0.026205863	),
  (	66	,	1.839972968	,	0.084091399	),
  (	66	,	1.984306523	,	0.047567985	),
  (	66	,	1.908065182	,	0.116604131	),
  (	66	,	2.048747387	,	0.223648689	),
  (	66	,	1.968494955	,	0.195527239	),
  (	66	,	1.959955426	,	0.222701518	),
  (	66	,	1.994455416	,	0.295034594	),
  (	66	,	1.193984749	,	-0.144088997	),
  (	66	,	1.46127352	,	-0.071740449	),
  (	66	,	1.497298141	,	-0.028160251	),
  (	66	,	1.458434228	,	-0.050294696	),
  (	66	,	1.438568224	,	-0.014013995	),
  (	66	,	1.433042344	,	0.000354002	),
  (	66	,	1.493536948	,	0.041314454	),
  (	66	,	1.427927616	,	0.040861557	),
  (	66	,	1.284853537	,	-0.056302932	),
  (	66	,	1.360001027	,	0.008980822	),
  (	66	,	1.282512552	,	0.027389694	),
  (	66	,	1.36915695	,	0.009778712	),
  (	66	,	1.424713282	,	0.051240537	),
  (	66	,	1.427410656	,	0.067291941	),
  (	66	,	1.311466482	,	0.063105307	),
  (	66	,	1.004752337	,	-0.026570912	),
  (	66	,	1.089588819	,	0.057984742	),
  (	66	,	0.912210895	,	0.056701528	),
  (	66	,	0.888589095	,	0.085208382	),
  (	66	,	0.937317767	,	0.11200799	),
  (	66	,	1.160744306	,	0.076329303	),
  (	66	,	1.127528987	,	0.165580406	),
  (	66	,	1.138040351	,	0.161005261	),
  (	66	,	1.106193042	,	0.155161487	),
  (	66	,	1.13281967	,	0.176647484	),
  (	66	,	1.182988711	,	0.263626325	),
  (	66	,	1.159007777	,	0.278220187	),
  (	66	,	1.181514888	,	0.281843607	),
  (	66	,	1.193958779	,	0.284893919	),
  (	66	,	1.545769911	,	0.056291749	),
  (	66	,	1.702102878	,	0.157597975	),
  (	66	,	1.734917496	,	0.189421835	),
  (	66	,	1.628438411	,	0.18544256	),
  (	66	,	1.708922115	,	0.205812892	),
  (	66	,	1.654155631	,	0.222471799	),
  (	66	,	1.460503015	,	0.098801834	),
  (	66	,	1.462643909	,	0.167782858	),
  (	66	,	1.546966078	,	0.205301562	),
  (	66	,	1.647395354	,	0.245369955	),
  (	66	,	1.518586732	,	0.216740951	),
  (	66	,	1.771087233	,	0.221544309	),
  (	66	,	1.876691948	,	0.370772466	),
  (	66	,	1.67935683	,	0.28024474	),
  (	66	,	1.642339784	,	0.299874408	),
  (	66	,	1.618921729	,	0.31643581	),
  (	66	,	1.743257966	,	0.429364863	),
  (	66	,	1.678697801	,	0.437182469	),
  (	66	,	1.446858708	,	0.260557703	),
  (	66	,	1.541636077	,	0.354285101	),
  (	66	,	1.496158979	,	0.331268348	),
  (	66	,	1.397594788	,	0.341702499	),
  (	66	,	1.492546224	,	0.395494524	),
  (	66	,	1.333146956	,	0.345691175	),
  (	66	,	1.334697834	,	0.461288298	),
  (	66	,	1.62454513	,	0.399828756	),
  (	66	,	1.679351986	,	0.518484246	),
  (	66	,	1.468273354	,	0.45274516	),
  (	66	,	1.416506598	,	0.544959073	),
  (	66	,	1.454117912	,	0.563552572	),
  (	66	,	1.473773154	,	0.585718597	),
  (	66	,	3.117241311	,	-0.65883692	),
  (	66	,	3.199251638	,	-0.595597674	),
  (	66	,	3.245428634	,	-0.529454486	),
  (	66	,	3.085981671	,	-0.528626952	),
  (	66	,	3.059254592	,	-0.509546801	),
  (	66	,	3.049999222	,	-0.431493666	),
  (	66	,	3.272806445	,	-0.233760931	),
  (	66	,	2.934685225	,	-0.379596837	),
  (	66	,	2.840955641	,	-0.319956849	),
  (	66	,	2.851651305	,	-0.269587685	),
  (	66	,	2.883977427	,	-0.275638812	),
  (	66	,	2.895540504	,	-0.234484151	),
  (	66	,	2.908992651	,	-0.226950948	),
  (	66	,	3.187201503	,	-0.135678716	),
  (	66	,	3.203792839	,	-0.099759554	),
  (	66	,	3.220827235	,	-0.068916647	),
  (	66	,	3.167755708	,	-0.054658965	),
  (	66	,	3.146080093	,	-0.030869286	),
  (	66	,	3.684200806	,	-0.16157804	),
  (	66	,	3.391221767	,	-0.210609286	),
  (	66	,	3.44369048	,	-0.166471189	),
  (	66	,	3.743816749	,	-0.131668276	),
  (	66	,	3.751952354	,	-0.117745887	),
  (	66	,	3.683701889	,	-0.09392517	),
  (	66	,	3.828698871	,	0.039737907	),
  (	66	,	3.620402787	,	0.146759676	),
  (	66	,	3.569777079	,	0.24961385	),
  (	66	,	2.825828663	,	-0.266372436	),
  (	66	,	2.710675633	,	-0.240620963	),
  (	66	,	2.780265212	,	-0.20505606	),
  (	66	,	2.753162902	,	-0.133300596	),
  (	66	,	2.703245915	,	-0.089124601	),
  (	66	,	2.734118943	,	-0.017243767	),
  (	66	,	2.847510764	,	-0.003522481	),
  (	66	,	2.580280408	,	-0.107888348	),
  (	66	,	2.583955603	,	0.001316686	),
  (	66	,	2.636051093	,	0.055857587	),
  (	66	,	2.709768463	,	0.039963127	),
  (	66	,	2.819118866	,	0.111228604	),
  (	66	,	2.878389826	,	0.204311293	),
  (	66	,	3.239895172	,	0.092591222	),
  (	66	,	3.262465287	,	0.150277478	),
  (	66	,	3.03567081	,	0.190435271	),
  (	66	,	3.028873752	,	0.192400786	),
  (	66	,	3.218992081	,	0.264319726	),
  (	66	,	3.369376986	,	0.297995788	),
  (	66	,	3.375164134	,	0.33998725	),
  (	66	,	3.29477015	,	0.320743339	),
  (	66	,	3.31191492	,	0.39548052	),
  (	66	,	2.864840308	,	0.445062278	),
  (	66	,	3.26653902	,	0.45774543	),
  (	66	,	3.19403577	,	0.498045176	),
  (	66	,	3.141395915	,	0.594022335	),
  (	66	,	3.11157293	,	0.657610085	),
  (	66	,	4.702273773	,	-0.682457974	),
  (	66	,	4.75601993	,	-0.571083585	),
  (	66	,	4.869443447	,	-0.518348557	),
  (	66	,	4.751225473	,	-0.444589209	),
  (	66	,	4.725603488	,	-0.396512634	),
  (	66	,	4.750101531	,	-0.374365612	),
  (	66	,	4.976000021	,	-0.43531794	),
  (	66	,	4.966954314	,	-0.434183428	),
  (	66	,	4.939896518	,	-0.382608704	),
  (	66	,	5.028591697	,	-0.378012783	),
  (	66	,	4.971772125	,	-0.324047782	),
  (	66	,	4.866660632	,	-0.363734958	),
  (	66	,	4.899653989	,	-0.336577046	),
  (	66	,	4.761459009	,	-0.346317685	),
  (	66	,	4.894373133	,	-0.254194082	),
  (	66	,	4.878520833	,	-0.244430686	),
  (	66	,	4.54523746	,	-0.434698273	),
  (	66	,	4.468101247	,	-0.448517491	),
  (	66	,	4.431138739	,	-0.376458572	),
  (	66	,	4.4377889	,	-0.341036574	),
  (	66	,	4.433280788	,	-0.293321034	),
  (	66	,	4.444885145	,	-0.259527983	),
  (	66	,	4.75481537	,	-0.243202173	),
  (	66	,	4.680296506	,	-0.107226204	),
  (	66	,	5.157665543	,	-0.160469861	),
  (	66	,	5.215591066	,	-0.117548969	),
  (	66	,	5.071695584	,	-0.143138346	),
  (	66	,	5.129075055	,	-0.13021136	),
  (	66	,	5.074870001	,	-0.129167816	),
  (	66	,	5.083386919	,	-0.085250992	),
  (	66	,	5.45104094	,	-0.009835151	),
  (	66	,	5.310198023	,	0.156438052	),
  (	66	,	4.924701661	,	-0.104791201	),
  (	66	,	4.879926201	,	-0.055736961	),
  (	66	,	4.997353258	,	-0.026391759	),
  (	66	,	5.056434515	,	0.005918727	),
  (	66	,	4.739106513	,	-0.007787868	),
  (	66	,	4.885240749	,	0.091879511	),
  (	66	,	4.877355943	,	0.10268586	),
  (	66	,	5.121525104	,	0.095391336	),
  (	66	,	5.270199981	,	0.164061683	),
  (	66	,	5.056564557	,	0.167862299	),
  (	66	,	5.132410582	,	0.251166622	),
  (	66	,	5.011670976	,	0.251940162	),
  (	66	,	5.146200311	,	0.289219891	),
  (	66	,	4.427336995	,	-0.205818904	),
  (	66	,	4.214952778	,	-0.10715964	),
  (	66	,	4.314516749	,	-0.141883514	),
  (	66	,	4.321873346	,	-0.131151731	),
  (	66	,	4.677441132	,	-0.021586478	),
  (	66	,	4.563888842	,	-0.028822818	),
  (	66	,	4.645155837	,	0.045016238	),
  (	66	,	4.36890212	,	0.021735296	),
  (	66	,	4.536877351	,	0.037344875	),
  (	66	,	4.532969763	,	0.106211994	),
  (	66	,	4.501879918	,	0.137791221	),
  (	66	,	4.017645098	,	-0.042141523	),
  (	66	,	4.080030137	,	0.029130217	),
  (	66	,	4.126214614	,	0.015551226	),
  (	66	,	4.452732618	,	0.114901718	),
  (	66	,	4.477471809	,	0.169888534	),
  (	66	,	4.47772288	,	0.182455222	),
  (	66	,	4.328157554	,	0.164309548	),
  (	66	,	4.238954203	,	0.169505398	),
  (	66	,	4.398877646	,	0.237192925	),
  (	66	,	4.746392442	,	0.171896852	),
  (	66	,	4.746449401	,	0.228134906	),
  (	66	,	4.75665278	,	0.287564531	),
  (	66	,	4.874747804	,	0.199341826	),
  (	66	,	4.929280686	,	0.278109567	),
  (	66	,	4.957011079	,	0.314077089	),
  (	66	,	4.974048662	,	0.398189481	),
  (	66	,	4.862166122	,	0.357205451	),
  (	66	,	4.867316174	,	0.411995466	),
  (	66	,	4.497554188	,	0.217587811	),
  (	66	,	4.439819529	,	0.242331911	),
  (	66	,	4.544650311	,	0.292013028	),
  (	66	,	4.440577082	,	0.425530945	),
  (	66	,	4.629882295	,	0.427843513	),
  (	66	,	4.752413884	,	0.531810479	),
  (	66	,	4.544492842	,	0.501923403	),
  (	66	,	4.754330892	,	0.67115807	),
  (	66	,	0.442298855	,	-1.381393847	),
  (	66	,	1.426796349	,	-1.197697951	),
  (	66	,	1.050383349	,	-1.242090775	),
  (	66	,	0.51438167	,	-1.141877348	),
  (	66	,	0.273648904	,	-1.142424023	),
  (	66	,	0.979853876	,	-0.947252439	),
  (	66	,	0.879460668	,	-0.833861661	),
  (	66	,	1.533203147	,	-1.117594341	),
  (	66	,	1.456226615	,	-0.958224536	),
  (	66	,	1.525280832	,	-0.783222583	),
  (	66	,	0.969361694	,	-0.802114825	),
  (	66	,	1.106520079	,	-0.704371998	),
  (	66	,	0.908414776	,	-0.625760797	),
  (	66	,	1.148117635	,	-0.620372619	),
  (	66	,	1.25588311	,	-0.5239431	),
  (	66	,	1.198326357	,	-0.419583858	),
  (	66	,	0.305967163	,	-1.006970981	),
  (	66	,	0.162784576	,	-0.949351682	),
  (	66	,	0.608303965	,	-0.730388502	),
  (	66	,	0.691228799	,	-0.663067665	),
  (	66	,	0.558916127	,	-0.730952613	),
  (	66	,	0.56640127	,	-0.713257536	),
  (	66	,	0.470349482	,	-0.648552894	),
  (	66	,	0.218441666	,	-0.757382339	),
  (	66	,	0.081643034	,	-0.754602944	),
  (	66	,	0.289922502	,	-0.622398162	),
  (	66	,	0.516813779	,	-0.577127005	),
  (	66	,	0.477026667	,	-0.54231861	),
  (	66	,	0.391454709	,	-0.447112411	),
  (	66	,	0.431241817	,	-0.436718916	),
  (	66	,	0.856037107	,	-0.538039666	),
  (	66	,	0.831611728	,	-0.414312869	),
  (	66	,	0.729480107	,	-0.392455405	),
  (	66	,	1.072407449	,	-0.35801304	),
  (	66	,	1.09957972	,	-0.301507553	),
  (	66	,	1.065295987	,	-0.289535385	),
  (	66	,	0.965921564	,	-0.341811647	),
  (	66	,	1.031757341	,	-0.237321363	),
  (	66	,	0.960762082	,	-0.265754961	),
  (	66	,	0.965307849	,	-0.205986894	),
  (	66	,	0.655508	,	-0.439582597	),
  (	66	,	0.565395411	,	-0.424919253	),
  (	66	,	0.536082476	,	-0.416904167	),
  (	66	,	0.727601549	,	-0.37767887	),
  (	66	,	0.553582241	,	-0.334040463	),
  (	66	,	0.856793727	,	-0.100017991	),
  (	66	,	1.775780509	,	-1.518871614	),
  (	66	,	3.058724298	,	-1.45036638	),
  (	66	,	2.846961248	,	-1.388573942	),
  (	66	,	3.070079627	,	-1.4047022	),
  (	66	,	3.067130664	,	-1.384159047	),
  (	66	,	2.772502131	,	-1.331842205	),
  (	66	,	3.064158638	,	-1.312964822	),
  (	66	,	2.929931705	,	-1.246796351	),
  (	66	,	2.868162511	,	-1.204941457	),
  (	66	,	2.98167737	,	-1.133664772	),
  (	66	,	2.513640971	,	-1.133590669	),
  (	66	,	2.485120715	,	-1.088400881	),
  (	66	,	2.703950909	,	-1.136858866	),
  (	66	,	2.806298327	,	-1.067591949	),
  (	66	,	2.7147334	,	-1.016922681	),
  (	66	,	2.722027107	,	-1.011488286	),
  (	66	,	1.634933841	,	-1.285021934	),
  (	66	,	1.761096876	,	-1.27616541	),
  (	66	,	1.978169375	,	-1.200238516	),
  (	66	,	2.285969336	,	-1.19051363	),
  (	66	,	2.273625421	,	-1.166164306	),
  (	66	,	2.027766008	,	-1.153166898	),
  (	66	,	2.168053123	,	-1.120273228	),
  (	66	,	1.958508634	,	-1.125909586	),
  (	66	,	2.172613426	,	-1.032659146	),
  (	66	,	2.382934154	,	-1.125731615	),
  (	66	,	2.458535379	,	-1.052473233	),
  (	66	,	2.424165164	,	-1.004920078	),
  (	66	,	2.433441014	,	-0.951112722	),
  (	66	,	2.205677626	,	-1.014615646	),
  (	66	,	2.272087791	,	-1.004356126	),
  (	66	,	2.20415263	,	-0.968183225	),
  (	66	,	2.223575484	,	-0.963264773	),
  (	66	,	2.320233454	,	-0.974047552	),
  (	66	,	2.231812875	,	-0.949359799	),
  (	66	,	2.212027696	,	-0.919878584	),
  (	66	,	2.358955252	,	-0.89981396	),
  (	66	,	2.324252776	,	-0.909819348	),
  (	66	,	3.103265282	,	-1.079418854	),
  (	66	,	2.930722002	,	-1.052623443	),
  (	66	,	2.906394115	,	-1.046322385	),
  (	66	,	2.901431139	,	-1.044734617	),
  (	66	,	2.93239875	,	-1.019680106	),
  (	66	,	2.90796338	,	-0.889361728	),
  (	66	,	2.825859689	,	-1.00299511	),
  (	66	,	2.734639546	,	-0.831827724	),
  (	66	,	3.103272685	,	-0.766777666	),
  (	66	,	2.9332307	,	-0.56607518	),
  (	66	,	2.564462916	,	-0.871675831	),
  (	66	,	2.550892163	,	-0.847336475	),
  (	66	,	2.492831492	,	-0.836928008	),
  (	66	,	2.58154181	,	-0.811791453	),
  (	66	,	2.693633923	,	-0.817423521	),
  (	66	,	2.682713017	,	-0.728253429	),
  (	66	,	2.678825265	,	-0.703556753	),
  (	66	,	2.653015979	,	-0.651590151	),
  (	66	,	2.46584051	,	-0.767531517	),
  (	66	,	2.573728539	,	-0.633003529	),
  (	66	,	2.509759645	,	-0.625242614	),
  (	66	,	2.796271091	,	-0.623809906	),
  (	66	,	2.699281317	,	-0.642359709	),
  (	66	,	2.679728622	,	-0.415630456	),
  (	66	,	1.67125373	,	-1.111478295	),
  (	66	,	1.677446053	,	-1.107055512	),
  (	66	,	1.692141995	,	-1.084717771	),
  (	66	,	1.625498059	,	-1.072923067	),
  (	66	,	1.641964925	,	-1.033508931	),
  (	66	,	1.826508858	,	-0.984279789	),
  (	66	,	1.888324855	,	-1.003404001	),
  (	66	,	1.921525502	,	-0.982519509	),
  (	66	,	1.989788987	,	-0.975423262	),
  (	66	,	1.892216889	,	-0.936679777	),
  (	66	,	1.978571494	,	-0.882861109	),
  (	66	,	2.020725646	,	-0.872543997	),
  (	66	,	1.763493314	,	-0.955229622	),
  (	66	,	2.127973895	,	-0.855393073	),
  (	66	,	2.105090554	,	-0.779583778	),
  (	66	,	2.237931254	,	-0.830872341	),
  (	66	,	2.275827689	,	-0.785255853	),
  (	66	,	2.294196373	,	-0.772272838	),
  (	66	,	2.248034771	,	-0.697610729	),
  (	66	,	2.078695773	,	-0.710978991	),
  (	66	,	2.000146651	,	-0.697991032	),
  (	66	,	2.035730707	,	-0.659259422	),
  (	66	,	2.195982799	,	-0.668218864	),
  (	66	,	2.238272926	,	-0.604477648	),
  (	66	,	2.103568295	,	-0.646643754	),
  (	66	,	2.154110476	,	-0.585897553	),
  (	66	,	2.163658788	,	-0.539761216	),
  (	66	,	1.748779406	,	-0.83115119	),
  (	66	,	1.611767719	,	-0.865025469	),
  (	66	,	1.800568419	,	-0.741842815	),
  (	66	,	1.808356002	,	-0.739416265	),
  (	66	,	1.731604843	,	-0.725307958	),
  (	66	,	1.704653691	,	-0.705952368	),
  (	66	,	1.68915729	,	-0.661395764	),
  (	66	,	1.755244717	,	-0.670184874	),
  (	66	,	1.72526307	,	-0.641928898	),
  (	66	,	1.997310921	,	-0.663399761	),
  (	66	,	1.9697306	,	-0.63099263	),
  (	66	,	1.970963493	,	-0.62636011	),
  (	66	,	1.934377072	,	-0.634254365	),
  (	66	,	1.916491617	,	-0.588650916	),
  (	66	,	2.010283278	,	-0.487737793	),
  (	66	,	2.070069196	,	-0.490529969	),
  (	66	,	1.836215483	,	-0.584073979	),
  (	66	,	1.886712147	,	-0.479525887	),
  (	66	,	1.987752153	,	-0.46475523	),
  (	66	,	1.983043493	,	-0.455828617	),
  (	66	,	2.023062323	,	-0.445125486	),
  (	66	,	2.032715461	,	-0.423347572	),
  (	66	,	1.948999535	,	-0.41386271	),
  (	66	,	1.990212246	,	-0.386774952	),
  (	66	,	2.324100662	,	-0.637836791	),
  (	66	,	2.460170497	,	-0.615186325	),
  (	66	,	2.497145592	,	-0.499643488	),
  (	66	,	2.414488219	,	-0.517738209	),
  (	66	,	2.257988912	,	-0.588978237	),
  (	66	,	2.245068076	,	-0.568972448	),
  (	66	,	2.237607997	,	-0.549701168	),
  (	66	,	2.198341567	,	-0.505625699	),
  (	66	,	2.222935399	,	-0.477036004	),
  (	66	,	2.515705642	,	-0.431138792	),
  (	66	,	2.673086271	,	-0.334295288	),
  (	66	,	2.710198406	,	-0.313900125	),
  (	66	,	2.216104757	,	-0.456108437	),
  (	66	,	2.16815059	,	-0.372114575	),
  (	66	,	2.263132821	,	-0.344473744	),
  (	66	,	2.220453552	,	-0.365655202	),
  (	66	,	2.214625997	,	-0.363797437	),
  (	66	,	2.040473354	,	-0.279089741	),
  (	66	,	2.214156687	,	-0.260668522	),
  (	66	,	2.441555752	,	-0.19748176	),
  (	66	,	2.455883446	,	-0.17172075	),
  (	66	,	2.26564978	,	-0.222311715	),
  (	66	,	2.273404961	,	-0.157986864	),
  (	66	,	2.207915189	,	-0.183549329	),
  (	66	,	2.261674834	,	-0.116279876	),
  (	66	,	4.050223526	,	-1.538220882	),
  (	66	,	3.223346001	,	-1.543130198	),
  (	66	,	3.253447132	,	-1.503612757	),
  (	66	,	3.268151127	,	-1.462631527	),
  (	66	,	4.57596242	,	-1.444776764	),
  (	66	,	3.202419311	,	-1.371376395	),
  (	66	,	3.548167816	,	-1.35385973	),
  (	66	,	3.522530694	,	-1.303618734	),
  (	66	,	3.752263275	,	-1.290993098	),
  (	66	,	3.932992266	,	-1.247752564	),
  (	66	,	4.269037611	,	-1.274850113	),
  (	66	,	4.30874706	,	-1.209970561	),
  (	66	,	4.393545882	,	-1.188599587	),
  (	66	,	4.555136165	,	-1.14672011	),
  (	66	,	4.416953706	,	-1.181273565	),
  (	66	,	4.442986579	,	-1.138040662	),
  (	66	,	4.158020248	,	-1.137124669	),
  (	66	,	4.193932179	,	-1.113110897	),
  (	66	,	4.085332776	,	-1.145175064	),
  (	66	,	4.327295387	,	-1.12527495	),
  (	66	,	4.232360248	,	-1.098991424	),
  (	66	,	3.312808951	,	-1.315466046	),
  (	66	,	3.250071587	,	-1.267178324	),
  (	66	,	3.470668353	,	-1.216137152	),
  (	66	,	3.783819321	,	-1.161831828	),
  (	66	,	3.701143485	,	-1.103182628	),
  (	66	,	3.440319478	,	-1.183276771	),
  (	66	,	3.242720162	,	-1.180362117	),
  (	66	,	3.425346751	,	-1.124719817	),
  (	66	,	3.605412606	,	-1.089986335	),
  (	66	,	3.666439844	,	-1.073050562	),
  (	66	,	3.931511083	,	-1.127072455	),
  (	66	,	3.983787113	,	-1.077633114	),
  (	66	,	3.96161752	,	-1.066897204	),
  (	66	,	3.819140575	,	-1.047473746	),
  (	66	,	3.887045881	,	-0.931456624	),
  (	66	,	3.981615245	,	-0.841585201	),
  (	66	,	4.000777993	,	-0.806386515	),
  (	66	,	3.830622581	,	-0.838170318	),
  (	66	,	4.656199392	,	-1.047103182	),
  (	66	,	4.640616526	,	-0.995225623	),
  (	66	,	4.262874643	,	-0.937189279	),
  (	66	,	4.572385144	,	-0.820762595	),
  (	66	,	4.451621915	,	-0.785201973	),
  (	66	,	4.42467058	,	-0.729401704	),
  (	66	,	4.517663538	,	-0.666942925	),
  (	66	,	4.549352197	,	-0.626750007	),
  (	66	,	4.46780855	,	-0.660504282	),
  (	66	,	4.123298204	,	-0.886375778	),
  (	66	,	4.226208949	,	-0.682301448	),
  (	66	,	4.07275581	,	-0.706706175	),
  (	66	,	3.947561507	,	-0.713168954	),
  (	66	,	4.023799433	,	-0.656868355	),
  (	66	,	4.133897909	,	-0.701526364	),
  (	66	,	4.102645963	,	-0.544787063	),
  (	66	,	4.342511487	,	-0.623515838	),
  (	66	,	4.432974964	,	-0.584804428	),
  (	66	,	4.382040121	,	-0.479203038	),
  (	66	,	4.194576811	,	-0.556570365	),
  (	66	,	4.154795893	,	-0.521630375	),
  (	66	,	4.233578771	,	-0.469656891	),
  (	66	,	4.233139174	,	-0.429048309	),
  (	66	,	3.194005435	,	-1.125919018	),
  (	66	,	3.261499042	,	-1.017812463	),
  (	66	,	3.585548683	,	-0.952270549	),
  (	66	,	3.569841867	,	-0.878773454	),
  (	66	,	3.425684003	,	-0.822349033	),
  (	66	,	3.480810033	,	-0.830601117	),
  (	66	,	3.531093721	,	-0.794784748	),
  (	66	,	3.496900975	,	-0.761564757	),
  (	66	,	3.773875488	,	-0.81207873	),
  (	66	,	3.666561067	,	-0.805071422	),
  (	66	,	3.77959698	,	-0.738605306	),
  (	66	,	3.814120976	,	-0.734772026	),
  (	66	,	3.800206026	,	-0.712882553	),
  (	66	,	3.84100453	,	-0.712824451	),
  (	66	,	3.580658421	,	-0.773710945	),
  (	66	,	3.736340814	,	-0.58017025	),
  (	66	,	3.745448262	,	-0.579812992	),
  (	66	,	3.247862104	,	-0.826814024	),
  (	66	,	3.249553758	,	-0.722300755	),
  (	66	,	3.522265135	,	-0.700969576	),
  (	66	,	3.678409986	,	-0.552982755	),
  (	66	,	3.54551384	,	-0.516010138	),
  (	66	,	3.627350638	,	-0.425716517	),
  (	66	,	3.584530444	,	-0.409275874	),
  (	66	,	3.896926173	,	-0.667713021	),
  (	66	,	4.053427196	,	-0.503827159	),
  (	66	,	3.951274474	,	-0.533202871	),
  (	66	,	3.985745086	,	-0.441740578	),
  (	66	,	3.952278283	,	-0.450113549	),
  (	66	,	4.128632801	,	-0.489765777	),
  (	66	,	4.093948569	,	-0.492302309	),
  (	66	,	4.26287498	,	-0.371830355	),
  (	66	,	4.241042472	,	-0.339472605	),
  (	66	,	4.25271873	,	-0.32352328	),
  (	66	,	3.74861197	,	-0.473702222	),
  (	66	,	3.719340553	,	-0.425221523	),
  (	66	,	3.866690525	,	-0.369597937	),
  (	66	,	3.678553931	,	-0.303112846	),
  (	66	,	3.688027417	,	-0.285116707	),
  (	66	,	3.684602314	,	-0.261307938	),
  (	66	,	3.865736788	,	-0.269820004	),
  (	66	,	3.874270104	,	-0.224111803	),
  (	66	,	3.919238664	,	-0.194688552	),
  (	66	,	4.095713975	,	-0.153442864	),
  (	66	,	3.772875908	,	-0.203676532	),
  (	66	,	3.937890128	,	-0.136842822	),
  (	66	,	5.958264273	,	-1.55017602	),
  (	66	,	4.719231771	,	-1.487296967	),
  (	66	,	6.104937127	,	-1.387053296	),
  (	66	,	5.21867444	,	-1.419822686	),
  (	66	,	4.956744204	,	-1.408968466	),
  (	66	,	4.736181771	,	-1.422214729	),
  (	66	,	5.334999114	,	-1.378133243	),
  (	66	,	5.577518104	,	-1.315053413	),
  (	66	,	5.418166124	,	-1.31513923	),
  (	66	,	6.063908458	,	-1.184670778	),
  (	66	,	5.97059987	,	-1.076595668	),
  (	66	,	4.971952154	,	-1.229924194	),
  (	66	,	5.079300217	,	-1.193300706	),
  (	66	,	5.32962963	,	-1.165001455	),
  (	66	,	5.398239996	,	-1.135046331	),
  (	66	,	5.317704475	,	-1.080481461	),
  (	66	,	5.461364434	,	-1.08960088	),
  (	66	,	5.566233145	,	-1.005858619	),
  (	66	,	5.689676713	,	-1.000520713	),
  (	66	,	5.674775589	,	-0.972810167	),
  (	66	,	5.624348765	,	-0.937348076	),
  (	66	,	6.088556099	,	-0.989463751	),
  (	66	,	6.052617351	,	-0.865790246	),
  (	66	,	6.034248278	,	-0.835112624	),
  (	66	,	6.193591525	,	-0.813978793	),
  (	66	,	6.103278127	,	-0.827903962	),
  (	66	,	6.143610102	,	-0.620368318	),
  (	66	,	6.107433353	,	-0.588321094	),
  (	66	,	5.647383474	,	-0.749178031	),
  (	66	,	5.908320014	,	-0.560987227	),
  (	66	,	6.068401683	,	-0.515318466	),
  (	66	,	5.932982609	,	-0.494380965	),
  (	66	,	5.741823396	,	-0.534176511	),
  (	66	,	5.958304845	,	-0.440466562	),
  (	66	,	4.85852667	,	-1.024674537	),
  (	66	,	4.755838774	,	-1.030445905	),
  (	66	,	4.917401103	,	-0.874321268	),
  (	66	,	5.059817155	,	-0.900116675	),
  (	66	,	4.950367915	,	-0.8705575	),
  (	66	,	5.11480721	,	-0.777475571	),
  (	66	,	5.318601112	,	-0.832710658	),
  (	66	,	5.39217882	,	-0.77383428	),
  (	66	,	5.41668534	,	-0.735377262	),
  (	66	,	5.307518294	,	-0.636236811	),
  (	66	,	5.353246475	,	-0.652817933	),
  (	66	,	5.30772443	,	-0.614322563	),
  (	66	,	4.768838719	,	-0.882427784	),
  (	66	,	4.819524693	,	-0.866624354	),
  (	66	,	4.799779223	,	-0.851117721	),
  (	66	,	4.950126125	,	-0.79388562	),
  (	66	,	5.070865359	,	-0.733321832	),
  (	66	,	4.839861392	,	-0.765253228	),
  (	66	,	4.840146428	,	-0.678084904	),
  (	66	,	4.883858785	,	-0.596316466	),
  (	66	,	5.067990508	,	-0.610582649	),
  (	66	,	5.222112725	,	-0.533552364	),
  (	66	,	5.144084305	,	-0.499290434	),
  (	66	,	5.019840789	,	-0.523730994	),
  (	66	,	4.942313369	,	-0.536412627	),
  (	66	,	5.538685059	,	-0.640654956	),
  (	66	,	5.438059742	,	-0.630421882	),
  (	66	,	5.580237637	,	-0.502066256	),
  (	66	,	5.469063898	,	-0.536149052	),
  (	66	,	5.305122793	,	-0.523690112	),
  (	66	,	5.467339413	,	-0.415102688	),
  (	66	,	5.651674098	,	-0.409356783	),
  (	66	,	5.800966775	,	-0.412929108	),
  (	66	,	5.60308064	,	-0.397012937	),
  (	66	,	5.716899341	,	-0.29399967	),
  (	66	,	5.252295013	,	-0.39436485	),
  (	66	,	5.361331773	,	-0.27474097	),
  (	66	,	5.205908157	,	-0.254879962	),
  (	66	,	5.288193751	,	-0.216290433	),
  (	66	,	5.548794836	,	-0.252590572	),
  (	66	,	5.476574055	,	-0.023960748	),
  (	67	,	1.093927013	,	0.321542691	),
  (	67	,	0.82613894	,	0.362348502	),
  (	67	,	0.954168391	,	0.395479325	),
  (	67	,	0.99530937	,	0.43612669	),
  (	67	,	0.557483015	,	0.31467394	),
  (	67	,	0.530377053	,	0.408327202	),
  (	67	,	0.756624491	,	0.552301561	),
  (	67	,	0.793627548	,	0.678553229	),
  (	67	,	1.179575523	,	0.490999669	),
  (	67	,	1.3292146	,	0.483381924	),
  (	67	,	1.359780675	,	0.521913095	),
  (	67	,	1.329133913	,	0.564086701	),
  (	67	,	1.07743793	,	0.583748539	),
  (	67	,	1.186602346	,	0.641272681	),
  (	67	,	1.416974559	,	0.631807165	),
  (	67	,	1.399396508	,	0.653427576	),
  (	67	,	1.553091504	,	0.721224911	),
  (	67	,	1.479793845	,	0.721828694	),
  (	67	,	1.429656214	,	0.756912275	),
  (	67	,	1.233914506	,	0.670670595	),
  (	67	,	1.310685288	,	0.692103941	),
  (	67	,	1.222520481	,	0.711899952	),
  (	67	,	1.249867776	,	0.739126986	),
  (	67	,	1.396432183	,	0.775366826	),
  (	67	,	1.399110192	,	0.819671739	),
  (	67	,	1.554393478	,	0.904149194	),
  (	67	,	1.51407402	,	0.899204137	),
  (	67	,	0.989084152	,	0.563568825	),
  (	67	,	1.003829449	,	0.661018195	),
  (	67	,	0.98444001	,	0.675030204	),
  (	67	,	1.108254036	,	0.662652424	),
  (	67	,	0.926308362	,	0.71419966	),
  (	67	,	0.923074973	,	0.835353537	),
  (	67	,	0.930934101	,	0.836883633	),
  (	67	,	1.348583543	,	0.857339308	),
  (	67	,	1.200318158	,	1.002162134	),
  (	67	,	1.351185985	,	1.090470568	),
  (	67	,	1.516414411	,	1.110011666	),
  (	67	,	0.333629905	,	0.411712632	),
  (	67	,	0.683312529	,	0.740025977	),
  (	67	,	0.514608634	,	0.727706715	),
  (	67	,	0.514817775	,	0.82197119	),
  (	67	,	0.230778494	,	0.672802885	),
  (	67	,	0.33718093	,	0.689065171	),
  (	67	,	0.256207399	,	0.820942473	),
  (	67	,	0.141579313	,	0.759126215	),
  (	67	,	0.136202511	,	0.767011149	),
  (	67	,	0.01370246	,	0.746091132	),
  (	67	,	0.066747785	,	0.771494438	),
  (	67	,	0.054860579	,	0.780285103	),
  (	67	,	0.055870101	,	0.804514897	),
  (	67	,	0.022521478	,	0.789393073	),
  (	67	,	0.21649925	,	0.833635429	),
  (	67	,	0.36787658	,	0.752970418	),
  (	67	,	0.278768658	,	0.831514538	),
  (	67	,	0.268130395	,	0.864709509	),
  (	67	,	0.292376317	,	0.993689525	),
  (	67	,	0.341347335	,	1.00885547	),
  (	67	,	0.045795238	,	0.997726585	),
  (	67	,	0.169393933	,	1.044162891	),
  (	67	,	0.250150605	,	1.0720124	),
  (	67	,	0.104196563	,	1.063967911	),
  (	67	,	0.0576678	,	1.082815263	),
  (	67	,	0.789295375	,	0.913712326	),
  (	67	,	0.625431362	,	0.909019988	),
  (	67	,	0.668958551	,	0.912962497	),
  (	67	,	0.75427451	,	0.924976127	),
  (	67	,	0.582759141	,	0.926047002	),
  (	67	,	0.651957214	,	0.969288101	),
  (	67	,	0.606825561	,	0.997202438	),
  (	67	,	0.729378656	,	1.057159375	),
  (	67	,	1.067346354	,	0.96108683	),
  (	67	,	1.122902577	,	0.997947293	),
  (	67	,	1.030519837	,	1.040968076	),
  (	67	,	1.281349839	,	1.073053125	),
  (	67	,	0.857035773	,	1.158550694	),
  (	67	,	1.350958488	,	1.21542933	),
  (	67	,	1.418034158	,	1.286433059	),
  (	67	,	0.569098272	,	1.046837794	),
  (	67	,	0.516228988	,	1.040666619	),
  (	67	,	0.428522418	,	1.088243957	),
  (	67	,	0.426674261	,	1.129914912	),
  (	67	,	0.563586974	,	1.24878912	),
  (	67	,	0.309201982	,	1.182988323	),
  (	67	,	0.341693387	,	1.183619005	),
  (	67	,	0.412443774	,	1.20338588	),
  (	67	,	0.268355051	,	1.210534887	),
  (	67	,	0.292016746	,	1.237985031	),
  (	67	,	1.078536246	,	1.291542049	),
  (	67	,	1.140259943	,	1.32829995	),
  (	67	,	1.244599026	,	1.390277014	),
  (	67	,	0.533011656	,	1.317760235	),
  (	67	,	0.440200636	,	1.360814369	),
  (	67	,	0.346814476	,	1.41187131	),
  (	67	,	1.500156679	,	1.495196293	),
  (	67	,	1.201696455	,	1.492730717	),
  (	67	,	0.59679234	,	1.458416861	),
  (	67	,	2.4428148	,	0.091035578	),
  (	67	,	2.293285335	,	0.081399216	),
  (	67	,	2.298456662	,	0.112032437	),
  (	67	,	2.525314319	,	0.188098988	),
  (	67	,	2.266346729	,	0.139930115	),
  (	67	,	2.32249838	,	0.14069603	),
  (	67	,	2.23361994	,	0.171286615	),
  (	67	,	2.353783963	,	0.228190191	),
  (	67	,	2.409788419	,	0.26174936	),
  (	67	,	2.578870586	,	0.228048022	),
  (	67	,	2.522085182	,	0.25039667	),
  (	67	,	2.550362787	,	0.32922326	),
  (	67	,	2.666628824	,	0.361198876	),
  (	67	,	2.438997368	,	0.309002249	),
  (	67	,	2.525973644	,	0.354256929	),
  (	67	,	2.562882617	,	0.41272956	),
  (	67	,	2.0979662	,	0.221280266	),
  (	67	,	2.173981641	,	0.273630559	),
  (	67	,	2.270529535	,	0.343303473	),
  (	67	,	2.26766188	,	0.345197584	),
  (	67	,	2.232658518	,	0.331395947	),
  (	67	,	2.274404883	,	0.357389519	),
  (	67	,	2.077408224	,	0.412311301	),
  (	67	,	2.138979496	,	0.451067507	),
  (	67	,	2.374365152	,	0.486917172	),
  (	67	,	2.287114053	,	0.644336868	),
  (	67	,	2.386135967	,	0.668082733	),
  (	67	,	2.700940973	,	0.431309032	),
  (	67	,	2.856171011	,	0.517136607	),
  (	67	,	2.68389972	,	0.549220923	),
  (	67	,	2.602813538	,	0.56521983	),
  (	67	,	2.783234987	,	0.594784833	),
  (	67	,	2.730328162	,	0.618283209	),
  (	67	,	2.978811263	,	0.701194261	),
  (	67	,	3.120195698	,	0.811174015	),
  (	67	,	2.698899389	,	0.751327537	),
  (	67	,	2.700795723	,	0.81612556	),
  (	67	,	2.462539173	,	0.638562371	),
  (	67	,	2.447766534	,	0.666512344	),
  (	67	,	2.500999108	,	0.794360295	),
  (	67	,	2.449539579	,	0.791855166	),
  (	67	,	2.612494546	,	0.87484691	),
  (	67	,	2.847206458	,	0.916354467	),
  (	67	,	3.011630807	,	0.948795067	),
  (	67	,	2.930055586	,	0.9450897	),
  (	67	,	2.935385415	,	0.958085856	),
  (	67	,	2.677907862	,	0.881331616	),
  (	67	,	3.085427519	,	1.071659669	),
  (	67	,	3.049176379	,	1.123066631	),
  (	67	,	3.126896945	,	1.138701292	),
  (	67	,	1.949655806	,	0.375865549	),
  (	67	,	2.136222226	,	0.507769017	),
  (	67	,	1.908992542	,	0.553232783	),
  (	67	,	1.97839118	,	0.649051863	),
  (	67	,	1.92956289	,	0.680601916	),
  (	67	,	2.11245634	,	0.576497017	),
  (	67	,	2.230428436	,	0.702053799	),
  (	67	,	2.244914555	,	0.822742081	),
  (	67	,	2.05624002	,	0.647201304	),
  (	67	,	1.989377909	,	0.751025607	),
  (	67	,	1.78781572	,	0.654721865	),
  (	67	,	1.873736032	,	0.638147117	),
  (	67	,	1.90987246	,	0.67851512	),
  (	67	,	1.829695956	,	0.738530958	),
  (	67	,	1.703530485	,	0.722594101	),
  (	67	,	1.596427212	,	0.842108689	),
  (	67	,	1.95858826	,	0.808334777	),
  (	67	,	1.945457261	,	0.847314851	),
  (	67	,	1.980329388	,	0.895597898	),
  (	67	,	2.003669584	,	0.940733097	),
  (	67	,	1.728028461	,	0.984115201	),
  (	67	,	1.584202546	,	0.995151718	),
  (	67	,	1.671615913	,	0.994416094	),
  (	67	,	1.729004587	,	1.014130744	),
  (	67	,	1.858870913	,	1.043738913	),
  (	67	,	1.599814003	,	1.107479443	),
  (	67	,	1.576257538	,	1.143627254	),
  (	67	,	2.408280063	,	0.880342119	),
  (	67	,	2.536300793	,	0.975049959	),
  (	67	,	2.227774674	,	0.944555701	),
  (	67	,	2.175035012	,	0.952316541	),
  (	67	,	2.14371622	,	0.951895606	),
  (	67	,	2.833887326	,	1.1136965	),
  (	67	,	2.894878871	,	1.222262816	),
  (	67	,	2.078882314	,	0.986185604	),
  (	67	,	2.105715768	,	0.99960616	),
  (	67	,	2.120758811	,	1.034087112	),
  (	67	,	2.193595402	,	1.05821446	),
  (	67	,	2.13957405	,	1.21694641	),
  (	67	,	1.834118374	,	1.175137736	),
  (	67	,	2.443130352	,	1.291825594	),
  (	67	,	2.807783294	,	1.403718507	),
  (	67	,	2.775202573	,	1.404895898	),
  (	67	,	2.077853403	,	1.400908821	),
  (	67	,	1.746534537	,	1.389275502	),
  (	67	,	1.765002156	,	1.433176374	),
  (	67	,	3.996334591	,	0.112830295	),
  (	67	,	4.061925463	,	0.149733033	),
  (	67	,	3.851535979	,	0.256712127	),
  (	67	,	4.115377842	,	0.238542433	),
  (	67	,	4.086119495	,	0.263570664	),
  (	67	,	4.246085869	,	0.376402616	),
  (	67	,	3.72885544	,	0.243927278	),
  (	67	,	3.573721813	,	0.318787383	),
  (	67	,	3.770054552	,	0.478449633	),
  (	67	,	3.762197138	,	0.512598658	),
  (	67	,	4.455652342	,	0.474661592	),
  (	67	,	4.485546072	,	0.544648623	),
  (	67	,	4.252771332	,	0.590915801	),
  (	67	,	4.335815811	,	0.664824533	),
  (	67	,	4.590252801	,	0.598152075	),
  (	67	,	4.555471967	,	0.673399306	),
  (	67	,	4.674136142	,	0.699397607	),
  (	67	,	4.642889469	,	0.786005719	),
  (	67	,	4.537190706	,	0.790795266	),
  (	67	,	4.136560748	,	0.553885636	),
  (	67	,	4.241625533	,	0.681644803	),
  (	67	,	3.98800867	,	0.751336216	),
  (	67	,	4.664559574	,	0.945874533	),
  (	67	,	3.626256064	,	0.606893929	),
  (	67	,	3.52747532	,	0.710859359	),
  (	67	,	3.78499368	,	0.716017164	),
  (	67	,	3.826315312	,	0.747537882	),
  (	67	,	3.735174484	,	0.795289723	),
  (	67	,	3.26181038	,	0.721780651	),
  (	67	,	3.56337365	,	0.863703248	),
  (	67	,	3.574643015	,	0.904154736	),
  (	67	,	3.94054092	,	0.779195114	),
  (	67	,	3.881996558	,	0.8503592	),
  (	67	,	3.996132888	,	0.889038208	),
  (	67	,	4.097851443	,	1.010972431	),
  (	67	,	4.229941882	,	0.974402182	),
  (	67	,	3.703417272	,	1.035634672	),
  (	67	,	3.654424761	,	1.073279108	),
  (	67	,	3.516722413	,	1.104144323	),
  (	67	,	3.521517447	,	1.129852233	),
  (	67	,	3.811781952	,	1.141370779	),
  (	67	,	3.396031422	,	1.133165773	),
  (	67	,	4.433870088	,	1.355297746	),
  (	67	,	3.554841155	,	1.335992123	),
  (	67	,	5.518270239	,	0.051353076	),
  (	67	,	5.526876004	,	0.066383051	),
  (	67	,	5.447214099	,	0.0636879	),
  (	67	,	5.426530704	,	0.09407641	),
  (	67	,	5.626832427	,	0.11486626	),
  (	67	,	5.621767385	,	0.143037844	),
  (	67	,	5.600717615	,	0.245220945	),
  (	67	,	5.497128123	,	0.293638987	),
  (	67	,	5.724100963	,	0.193582077	),
  (	67	,	5.701866663	,	0.239453104	),
  (	67	,	5.781652197	,	0.258584628	),
  (	67	,	5.655222806	,	0.263219674	),
  (	67	,	5.771114562	,	0.279014165	),
  (	67	,	5.755210601	,	0.331962857	),
  (	67	,	5.624316517	,	0.31251732	),
  (	67	,	5.649483572	,	0.319901717	),
  (	67	,	5.689633585	,	0.39819701	),
  (	67	,	5.636698112	,	0.416177278	),
  (	67	,	5.340307547	,	0.280070035	),
  (	67	,	5.2597391	,	0.270536407	),
  (	67	,	5.271367686	,	0.290849094	),
  (	67	,	5.349523042	,	0.346720376	),
  (	67	,	5.354829558	,	0.357381197	),
  (	67	,	5.376272845	,	0.398359279	),
  (	67	,	5.141287458	,	0.362734576	),
  (	67	,	5.295666424	,	0.423055201	),
  (	67	,	5.251897243	,	0.400394275	),
  (	67	,	5.237104906	,	0.457063907	),
  (	67	,	5.543755838	,	0.391905957	),
  (	67	,	5.549312926	,	0.518565468	),
  (	67	,	5.322514196	,	0.518831108	),
  (	67	,	5.442849771	,	0.636886609	),
  (	67	,	5.508038209	,	0.689562718	),
  (	67	,	5.497480354	,	0.702674459	),
  (	67	,	5.88277294	,	0.432712976	),
  (	67	,	5.882563859	,	0.471563052	),
  (	67	,	5.851222499	,	0.470106254	),
  (	67	,	5.93008907	,	0.652323402	),
  (	67	,	5.85923678	,	0.639827425	),
  (	67	,	5.918289436	,	0.660470673	),
  (	67	,	6.106073667	,	0.625265189	),
  (	67	,	6.064469056	,	0.688866799	),
  (	67	,	6.128644902	,	0.717555201	),
  (	67	,	6.126748808	,	0.726281312	),
  (	67	,	6.205708766	,	0.785251466	),
  (	67	,	5.955428076	,	0.684184538	),
  (	67	,	6.030937869	,	0.777941004	),
  (	67	,	6.096792282	,	0.788255878	),
  (	67	,	6.187144786	,	0.806330826	),
  (	67	,	6.209382423	,	0.90651182	),
  (	67	,	5.697387405	,	0.625829342	),
  (	67	,	5.662772116	,	0.686214315	),
  (	67	,	5.799964874	,	0.78271907	),
  (	67	,	5.799240274	,	0.782863145	),
  (	67	,	5.812079894	,	0.821974281	),
  (	67	,	5.601661592	,	0.65190523	),
  (	67	,	5.599825373	,	0.652870368	),
  (	67	,	5.580695345	,	0.693757829	),
  (	67	,	5.651132164	,	0.762766972	),
  (	67	,	5.671882943	,	0.775486911	),
  (	67	,	5.795677569	,	0.86912073	),
  (	67	,	5.691619384	,	0.817913644	),
  (	67	,	5.716133586	,	0.919741606	),
  (	67	,	6.061873986	,	0.866566637	),
  (	67	,	6.216897671	,	0.973887983	),
  (	67	,	5.835825704	,	0.857428181	),
  (	67	,	5.887747911	,	0.946769893	),
  (	67	,	5.955143457	,	0.916599105	),
  (	67	,	6.206943842	,	1.076505532	),
  (	67	,	6.036201765	,	1.054971141	),
  (	67	,	6.109700007	,	1.081582155	),
  (	67	,	6.111163453	,	1.085826182	),
  (	67	,	6.136355217	,	1.066166434	),
  (	67	,	6.190762461	,	1.084459155	),
  (	67	,	5.154149913	,	0.391874398	),
  (	67	,	5.177788061	,	0.438667684	),
  (	67	,	5.192052659	,	0.472726157	),
  (	67	,	4.974115061	,	0.47063911	),
  (	67	,	5.052792008	,	0.541434873	),
  (	67	,	5.043829472	,	0.545254562	),
  (	67	,	5.059106053	,	0.557917151	),
  (	67	,	5.110627247	,	0.584173381	),
  (	67	,	5.168951081	,	0.600640772	),
  (	67	,	5.138598478	,	0.611257318	),
  (	67	,	5.079349155	,	0.636218573	),
  (	67	,	5.336174015	,	0.684361604	),
  (	67	,	5.383508041	,	0.729062321	),
  (	67	,	5.382864671	,	0.788463059	),
  (	67	,	5.366897797	,	0.801622994	),
  (	67	,	5.225009459	,	0.67122373	),
  (	67	,	5.161539993	,	0.710728718	),
  (	67	,	5.123866059	,	0.731767042	),
  (	67	,	5.298640934	,	0.73485919	),
  (	67	,	4.901216972	,	0.685914449	),
  (	67	,	4.894264949	,	0.71065525	),
  (	67	,	4.927694857	,	0.763313814	),
  (	67	,	4.816912183	,	0.676128155	),
  (	67	,	4.817905703	,	0.741184712	),
  (	67	,	4.859845126	,	0.806677996	),
  (	67	,	5.026874125	,	0.870222242	),
  (	67	,	4.996719049	,	0.871324206	),
  (	67	,	5.139761413	,	0.860192522	),
  (	67	,	5.130972644	,	0.876833729	),
  (	67	,	5.107597057	,	0.97976302	),
  (	67	,	4.920386508	,	0.856519146	),
  (	67	,	4.833274421	,	1.039332802	),
  (	67	,	5.474513635	,	0.806886647	),
  (	67	,	5.442574796	,	0.795517213	),
  (	67	,	5.433863842	,	0.809041091	),
  (	67	,	5.452462391	,	0.895598126	),
  (	67	,	5.695037982	,	0.912241143	),
  (	67	,	5.730482329	,	0.942427191	),
  (	67	,	5.336450277	,	0.954220795	),
  (	67	,	5.276880944	,	0.977850318	),
  (	67	,	5.553582291	,	1.048907551	),
  (	67	,	5.578682999	,	1.067868827	),
  (	67	,	5.581224432	,	1.079633189	),
  (	67	,	5.849671666	,	1.019447725	),
  (	67	,	5.776592345	,	1.043960959	),
  (	67	,	6.161871218	,	1.147365612	),
  (	67	,	5.947529942	,	1.140332609	),
  (	67	,	5.727234803	,	1.094533722	),
  (	67	,	5.723024139	,	1.147598614	),
  (	67	,	6.135702435	,	1.233697974	),
  (	67	,	6.248256116	,	1.354353375	),
  (	67	,	5.275026339	,	1.083440211	),
  (	67	,	5.125914886	,	1.107134782	),
  (	67	,	4.962360195	,	1.089024211	),
  (	67	,	4.848731972	,	1.142082516	),
  (	67	,	4.786467419	,	1.199753094	),
  (	67	,	5.430365584	,	1.217394397	),
  (	67	,	5.377441575	,	1.231015078	),
  (	67	,	5.728110474	,	1.286349993	),
  (	67	,	5.862978446	,	1.365604672	),
  (	67	,	5.735336077	,	1.401647855	),
  (	67	,	6.026851664	,	1.409910817	),
  (	67	,	4.965236478	,	1.344782695	),
  (	67	,	6.1275703	,	1.508277216	),
  (	67	,	0.013668721	,	-0.421412642	),
  (	67	,	6.270826658	,	-0.363617269	),
  (	67	,	0.232176301	,	-0.432433241	),
  (	67	,	0.169361462	,	-0.438216615	),
  (	67	,	0.163067135	,	-0.432272862	),
  (	67	,	0.268982043	,	-0.283898822	),
  (	67	,	0.079772183	,	-0.36893584	),
  (	67	,	0.100685376	,	-0.278246524	),
  (	67	,	0.176616126	,	-0.288274748	),
  (	67	,	0.157300921	,	-0.261335784	),
  (	67	,	6.222208523	,	-0.326020652	),
  (	67	,	6.137419305	,	-0.379449448	),
  (	67	,	0.078507593	,	-0.234845265	),
  (	67	,	6.156730845	,	-0.109751203	),
  (	67	,	0.466759679	,	-0.242402625	),
  (	67	,	0.518225954	,	-0.197249604	),
  (	67	,	0.541965489	,	-0.206992283	),
  (	67	,	0.456963129	,	-0.118091198	),
  (	67	,	0.487078335	,	-0.119977337	),
  (	67	,	0.427032018	,	-0.060052457	),
  (	67	,	0.413885945	,	-0.06150727	),
  (	67	,	0.58421678	,	-0.158205223	),
  (	67	,	0.560818955	,	-0.116551795	),
  (	67	,	0.713328174	,	-0.044181483	),
  (	67	,	0.773064038	,	0.007815009	),
  (	67	,	0.577107203	,	0.047920511	),
  (	67	,	0.574754954	,	0.060260959	),
  (	67	,	0.33593498	,	-0.039795836	),
  (	67	,	0.360328179	,	-0.007849731	),
  (	67	,	0.377240452	,	-0.006966709	),
  (	67	,	0.329846859	,	0.015925691	),
  (	67	,	0.296699158	,	0.034732206	),
  (	67	,	0.316366363	,	0.043124609	),
  (	67	,	0.163671407	,	0.054714981	),
  (	67	,	0.544765306	,	0.135012588	),
  (	67	,	0.311904278	,	0.179626945	),
  (	67	,	0.385758622	,	0.298085285	),
  (	67	,	0.365865511	,	0.310984194	),
  (	67	,	5.91713465	,	-0.286026559	),
  (	67	,	5.79270391	,	-0.252914498	),
  (	67	,	6.047024171	,	-0.138522579	),
  (	67	,	5.801038783	,	-0.13180352	),
  (	67	,	5.943292739	,	-0.089051902	),
  (	67	,	6.176174781	,	0.02291556	),
  (	67	,	6.008798096	,	-0.056637956	),
  (	67	,	5.988871434	,	0.061997844	),
  (	67	,	6.028922334	,	0.061619602	),
  (	67	,	5.691505956	,	-0.082570136	),
  (	67	,	5.570472968	,	-0.0280627	),
  (	67	,	5.561572243	,	0.001608557	),
  (	67	,	5.538229076	,	-0.004100638	),
  (	67	,	5.596396652	,	0.050936462	),
  (	67	,	5.688298701	,	0.131393026	),
  (	67	,	5.864344248	,	0.266710565	),
  (	67	,	5.855961241	,	0.273168512	),
  (	67	,	0.179744681	,	0.163264063	),
  (	67	,	0.073135419	,	0.178806332	),
  (	67	,	6.231711221	,	0.143909656	),
  (	67	,	6.273457956	,	0.200264444	),
  (	67	,	6.265355244	,	0.2658179	),
  (	67	,	0.245008836	,	0.243507158	),
  (	67	,	0.107496368	,	0.249852715	),
  (	67	,	0.376969171	,	0.350296957	),
  (	67	,	0.239852956	,	0.412393573	),
  (	67	,	6.064793099	,	0.251780506	),
  (	67	,	6.11285326	,	0.301118728	),
  (	67	,	6.145268503	,	0.347067605	),
  (	67	,	5.997798734	,	0.295689855	),
  (	67	,	6.062306626	,	0.327001624	),
  (	67	,	6.082429351	,	0.342675533	),
  (	67	,	6.148330502	,	0.4022546	),
  (	67	,	6.163123176	,	0.416146389	),
  (	67	,	6.178170599	,	0.428671871	),
  (	67	,	6.091058158	,	0.432334615	),
  (	67	,	6.117239814	,	0.464403877	),
  (	67	,	6.090204044	,	0.493018464	),
  (	67	,	0.021914453	,	0.483015171	),
  (	67	,	0.142139549	,	0.481374045	),
  (	67	,	0.107606257	,	0.54756152	),
  (	67	,	6.2611093	,	0.514446068	),
  (	67	,	6.252348631	,	0.644962467	),
  (	67	,	1.556907355	,	-0.558088926	),
  (	67	,	1.553260633	,	-0.550335965	),
  (	67	,	1.535859535	,	-0.51399069	),
  (	67	,	1.802072753	,	-0.470507407	),
  (	67	,	1.84880587	,	-0.437796231	),
  (	67	,	1.826469861	,	-0.416798338	),
  (	67	,	1.738268206	,	-0.411555139	),
  (	67	,	1.916837115	,	-0.305865916	),
  (	67	,	1.875654137	,	-0.283349297	),
  (	67	,	1.660616786	,	-0.412568364	),
  (	67	,	1.708204314	,	-0.373594437	),
  (	67	,	1.702556207	,	-0.33536571	),
  (	67	,	1.674262698	,	-0.287405504	),
  (	67	,	1.773907641	,	-0.253483975	),
  (	67	,	1.703861777	,	-0.261002857	),
  (	67	,	1.707821583	,	-0.219208037	),
  (	67	,	1.355872473	,	-0.452220137	),
  (	67	,	1.40400666	,	-0.432371608	),
  (	67	,	1.504668097	,	-0.378024958	),
  (	67	,	1.544440666	,	-0.3427634	),
  (	67	,	1.463645418	,	-0.274677767	),
  (	67	,	1.301030729	,	-0.292868484	),
  (	67	,	1.404649825	,	-0.30724058	),
  (	67	,	1.366727169	,	-0.225858371	),
  (	67	,	1.609024934	,	-0.138517872	),
  (	67	,	1.457528158	,	-0.122592517	),
  (	67	,	1.609168081	,	-0.119054413	),
  (	67	,	2.004525006	,	-0.294042444	),
  (	67	,	1.902136689	,	-0.283358745	),
  (	67	,	2.00865583	,	-0.205122569	),
  (	67	,	1.92545109	,	-0.154965973	),
  (	67	,	1.946287576	,	-0.079193814	),
  (	67	,	2.213456074	,	-0.111874708	),
  (	67	,	2.098997007	,	-0.112041406	),
  (	67	,	2.169269021	,	-0.058709505	),
  (	67	,	2.152698323	,	-0.020347933	),
  (	67	,	2.306552112	,	-0.018236178	),
  (	67	,	2.087874642	,	0.05123937	),
  (	67	,	2.169913268	,	0.07363901	),
  (	67	,	1.672810777	,	-0.081814191	),
  (	67	,	1.757502301	,	-0.072271905	),
  (	67	,	1.770785014	,	-0.012505159	),
  (	67	,	1.93082913	,	-0.004527795	),
  (	67	,	1.930652997	,	0.012225819	),
  (	67	,	1.834412639	,	0.033711227	),
  (	67	,	1.684929804	,	-0.061355051	),
  (	67	,	1.696391769	,	-0.009990503	),
  (	67	,	1.688519955	,	0.014679146	),
  (	67	,	1.710941717	,	0.105341707	),
  (	67	,	2.054475985	,	0.07783916	),
  (	67	,	2.04632211	,	0.075636984	),
  (	67	,	1.987143284	,	0.13229406	),
  (	67	,	2.025602625	,	0.224448335	),
  (	67	,	1.997692135	,	0.250289928	),
  (	67	,	1.229149678	,	-0.217741571	),
  (	67	,	1.200944116	,	-0.169933468	),
  (	67	,	1.099284993	,	-0.15424272	),
  (	67	,	1.032052028	,	-0.189420075	),
  (	67	,	1.317797328	,	-0.096015387	),
  (	67	,	1.478121382	,	-0.045373197	),
  (	67	,	1.475802354	,	-0.020406152	),
  (	67	,	1.448653019	,	-0.004966377	),
  (	67	,	1.445321167	,	0.057466726	),
  (	67	,	1.268664972	,	0.020029765	),
  (	67	,	1.25864885	,	0.047401302	),
  (	67	,	1.408316499	,	0.048797701	),
  (	67	,	1.399449688	,	0.044417231	),
  (	67	,	0.942276785	,	-0.089447358	),
  (	67	,	0.920950049	,	-0.008400359	),
  (	67	,	0.888394327	,	0.015872668	),
  (	67	,	1.006613319	,	0.027296195	),
  (	67	,	1.018855859	,	0.036983376	),
  (	67	,	1.186131021	,	0.100606397	),
  (	67	,	1.002585258	,	0.164188809	),
  (	67	,	1.17826078	,	0.179100002	),
  (	67	,	1.152972136	,	0.212194067	),
  (	67	,	1.194591924	,	0.231286902	),
  (	67	,	1.20725082	,	0.276968396	),
  (	67	,	1.141370736	,	0.251495942	),
  (	67	,	1.173731493	,	0.282026057	),
  (	67	,	1.627489725	,	0.10500198	),
  (	67	,	1.49835894	,	0.093525143	),
  (	67	,	1.659309831	,	0.134718156	),
  (	67	,	1.697344292	,	0.192318098	),
  (	67	,	1.400133597	,	0.16973084	),
  (	67	,	1.530702502	,	0.252082556	),
  (	67	,	1.76908088	,	0.170440533	),
  (	67	,	1.6897534	,	0.259865951	),
  (	67	,	1.622531805	,	0.381672493	),
  (	67	,	1.682985765	,	0.377775496	),
  (	67	,	1.772261685	,	0.40791018	),
  (	67	,	1.785339998	,	0.4745564	),
  (	67	,	1.751212304	,	0.492124	),
  (	67	,	1.347572047	,	0.346618196	),
  (	67	,	1.436721758	,	0.43892924	),
  (	67	,	1.333556435	,	0.402490365	),
  (	67	,	1.499460275	,	0.444003588	),
  (	67	,	1.516594421	,	0.446255679	),
  (	67	,	1.69708092	,	0.470661454	),
  (	67	,	1.691190293	,	0.56832245	),
  (	67	,	1.47897762	,	0.46457177	),
  (	67	,	1.507499739	,	0.546719251	),
  (	67	,	1.629736509	,	0.648548658	),
  (	67	,	3.112275394	,	-0.638399836	),
  (	67	,	3.207503798	,	-0.510289619	),
  (	67	,	3.100652134	,	-0.476088979	),
  (	67	,	3.283587231	,	-0.370227202	),
  (	67	,	3.298143055	,	-0.210643381	),
  (	67	,	2.931992426	,	-0.467853169	),
  (	67	,	2.858816253	,	-0.360671223	),
  (	67	,	2.896816764	,	-0.342955703	),
  (	67	,	3.128232467	,	-0.240079959	),
  (	67	,	3.137909708	,	-0.182835267	),
  (	67	,	3.159069755	,	-0.179700657	),
  (	67	,	3.243070017	,	-0.08682494	),
  (	67	,	3.131783932	,	-0.149200551	),
  (	67	,	3.704503542	,	-0.180369309	),
  (	67	,	3.479158731	,	-0.200424466	),
  (	67	,	3.365787417	,	-0.18043654	),
  (	67	,	3.531007939	,	-0.023820896	),
  (	67	,	3.738546448	,	-0.155065231	),
  (	67	,	3.870653331	,	0.016942064	),
  (	67	,	3.764550718	,	-0.011121656	),
  (	67	,	3.730127723	,	0.058218949	),
  (	67	,	3.37562183	,	-0.07374191	),
  (	67	,	3.420436755	,	-0.063937773	),
  (	67	,	3.350406739	,	0.062355259	),
  (	67	,	3.533344529	,	0.019105171	),
  (	67	,	3.485643365	,	0.064359566	),
  (	67	,	3.534118223	,	0.104962934	),
  (	67	,	3.60071181	,	0.180205223	),
  (	67	,	3.558550142	,	0.178103771	),
  (	67	,	3.620999406	,	0.230245405	),
  (	67	,	3.510329967	,	0.216980747	),
  (	67	,	2.776340575	,	-0.184719211	),
  (	67	,	2.7207238	,	-0.06357911	),
  (	67	,	3.032424378	,	-0.076124233	),
  (	67	,	3.026428826	,	0.043614283	),
  (	67	,	2.996447445	,	0.052610435	),
  (	67	,	2.520976652	,	-0.055339639	),
  (	67	,	2.72042128	,	-0.015751475	),
  (	67	,	2.608097849	,	-0.033888982	),
  (	67	,	2.732109636	,	0.068635641	),
  (	67	,	2.803972213	,	0.062539855	),
  (	67	,	2.719383572	,	0.09937476	),
  (	67	,	2.78777293	,	0.281474025	),
  (	67	,	3.303583096	,	0.15353472	),
  (	67	,	3.458353985	,	0.327281089	),
  (	67	,	3.474231891	,	0.332516275	),
  (	67	,	3.232395558	,	0.27124121	),
  (	67	,	3.237731032	,	0.292247481	),
  (	67	,	3.361030197	,	0.399033858	),
  (	67	,	3.267003566	,	0.45202637	),
  (	67	,	2.959864772	,	0.209163889	),
  (	67	,	2.949442359	,	0.224177302	),
  (	67	,	2.962695162	,	0.249021576	),
  (	67	,	3.032774768	,	0.356772148	),
  (	67	,	3.0634172	,	0.387649111	),
  (	67	,	2.909178232	,	0.309572237	),
  (	67	,	2.838810566	,	0.408518966	),
  (	67	,	3.149170601	,	0.385616876	),
  (	67	,	3.262190603	,	0.452250467	),
  (	67	,	3.228175615	,	0.496795656	),
  (	67	,	3.22224507	,	0.571574914	),
  (	67	,	3.12078877	,	0.641514107	),
  (	67	,	3.129538022	,	0.704123632	),
  (	67	,	4.69900497	,	-0.70346583	),
  (	67	,	4.6955091	,	-0.611719463	),
  (	67	,	4.698574361	,	-0.570529246	),
  (	67	,	4.696105292	,	-0.566795745	),
  (	67	,	4.771827045	,	-0.557936107	),
  (	67	,	4.838732106	,	-0.463945783	),
  (	67	,	4.63871132	,	-0.576854384	),
  (	67	,	4.625198073	,	-0.562015314	),
  (	67	,	4.589295493	,	-0.58823496	),
  (	67	,	4.581899719	,	-0.588461924	),
  (	67	,	4.66566226	,	-0.534031296	),
  (	67	,	4.674033108	,	-0.533318266	),
  (	67	,	4.863124268	,	-0.422760813	),
  (	67	,	4.913184729	,	-0.342194962	),
  (	67	,	4.88646875	,	-0.350314379	),
  (	67	,	4.761459751	,	-0.346310722	),
  (	67	,	4.790284718	,	-0.328095789	),
  (	67	,	4.925131405	,	-0.324651602	),
  (	67	,	4.932821319	,	-0.236881454	),
  (	67	,	4.512713019	,	-0.470975164	),
  (	67	,	4.471205661	,	-0.447606294	),
  (	67	,	4.644323278	,	-0.387374705	),
  (	67	,	4.540333607	,	-0.337454932	),
  (	67	,	4.369049375	,	-0.315201294	),
  (	67	,	4.569117426	,	-0.276694507	),
  (	67	,	4.800034137	,	-0.139301671	),
  (	67	,	4.830843648	,	-0.140330467	),
  (	67	,	4.762344861	,	-0.090844677	),
  (	67	,	4.769841241	,	-0.070013124	),
  (	67	,	4.686475912	,	-0.028264825	),
  (	67	,	5.098930971	,	-0.263585419	),
  (	67	,	5.148161441	,	-0.264724714	),
  (	67	,	5.089427105	,	-0.253967284	),
  (	67	,	5.187276622	,	-0.215016997	),
  (	67	,	4.985398538	,	-0.187131826	),
  (	67	,	5.041261318	,	-0.105587042	),
  (	67	,	5.245484203	,	-0.087089002	),
  (	67	,	5.263062305	,	-0.071183402	),
  (	67	,	5.343744825	,	0.023883537	),
  (	67	,	5.37710177	,	0.037224301	),
  (	67	,	5.234644035	,	-0.034393721	),
  (	67	,	5.293031003	,	-0.005773524	),
  (	67	,	5.384335466	,	0.085496621	),
  (	67	,	5.306232562	,	0.079943647	),
  (	67	,	5.346920327	,	0.115921022	),
  (	67	,	5.280179652	,	0.147344386	),
  (	67	,	5.063432319	,	-0.022853403	),
  (	67	,	4.786916144	,	0.017549884	),
  (	67	,	4.772909739	,	0.041772544	),
  (	67	,	4.843660761	,	0.070952841	),
  (	67	,	4.822117835	,	0.088742518	),
  (	67	,	4.910814213	,	0.095989046	),
  (	67	,	5.046525386	,	0.115132573	),
  (	67	,	5.169182792	,	0.152304083	),
  (	67	,	5.185846793	,	0.186646333	),
  (	67	,	5.131851704	,	0.19460646	),
  (	67	,	5.075140571	,	0.260419142	),
  (	67	,	4.278101938	,	-0.22533733	),
  (	67	,	4.358067651	,	-0.150424133	),
  (	67	,	4.367423583	,	-0.145030255	),
  (	67	,	4.187428416	,	-0.127446265	),
  (	67	,	4.580565431	,	-0.103322143	),
  (	67	,	4.665775893	,	0.034242406	),
  (	67	,	4.621975381	,	0.062043144	),
  (	67	,	4.076845603	,	-0.099397464	),
  (	67	,	4.248313728	,	-0.025745339	),
  (	67	,	4.314032917	,	0.000945647	),
  (	67	,	4.266117958	,	0.026122286	),
  (	67	,	4.086519042	,	-0.009803194	),
  (	67	,	4.303775125	,	0.043771915	),
  (	67	,	4.30894739	,	0.050100271	),
  (	67	,	4.352687562	,	0.092108562	),
  (	67	,	4.747823455	,	0.038722211	),
  (	67	,	4.767684043	,	0.049092661	),
  (	67	,	4.792712922	,	0.226551208	),
  (	67	,	4.571606192	,	0.147336188	),
  (	67	,	4.679755898	,	0.294966061	),
  (	67	,	4.95458937	,	0.251061615	),
  (	67	,	4.940638286	,	0.253689138	),
  (	67	,	4.911758322	,	0.274461029	),
  (	67	,	5.029053802	,	0.29402396	),
  (	67	,	5.042063003	,	0.32317258	),
  (	67	,	4.97894703	,	0.337015313	),
  (	67	,	4.968471944	,	0.359941499	),
  (	67	,	4.980191566	,	0.3636009	),
  (	67	,	4.990369866	,	0.371202687	),
  (	67	,	4.814159002	,	0.256562849	),
  (	67	,	4.840442143	,	0.313877181	),
  (	67	,	4.846319716	,	0.36325902	),
  (	67	,	4.823499163	,	0.396307657	),
  (	67	,	4.79149236	,	0.40660631	),
  (	67	,	4.59769313	,	0.25902585	),
  (	67	,	4.562645254	,	0.28595841	),
  (	67	,	4.464418442	,	0.253249157	),
  (	67	,	4.600922584	,	0.288055339	),
  (	67	,	4.657983006	,	0.329681811	),
  (	67	,	4.606747706	,	0.346336376	),
  (	67	,	4.467505822	,	0.343665282	),
  (	67	,	4.751146489	,	0.435748802	),
  (	67	,	4.669848111	,	0.441412794	),
  (	67	,	4.887059935	,	0.538428963	),
  (	67	,	4.776676915	,	0.509734542	),
  (	67	,	4.723631992	,	0.533305418	),
  (	67	,	4.609226126	,	0.481120059	),
  (	67	,	4.608258571	,	0.49192606	),
  (	67	,	4.636519166	,	0.513456713	),
  (	67	,	4.732987751	,	0.699603762	),
  (	67	,	0.5690551	,	-1.337334816	),
  (	67	,	1.280672151	,	-1.163704172	),
  (	67	,	1.243391557	,	-1.103567055	),
  (	67	,	0.069433772	,	-1.324907877	),
  (	67	,	0.634599486	,	-1.160539611	),
  (	67	,	0.491228301	,	-1.18585613	),
  (	67	,	0.670036765	,	-1.092341671	),
  (	67	,	0.159829525	,	-1.136637072	),
  (	67	,	0.194888152	,	-1.145890227	),
  (	67	,	0.456189979	,	-1.064978037	),
  (	67	,	0.524841784	,	-0.960153694	),
  (	67	,	0.754463265	,	-1.142412072	),
  (	67	,	0.829279871	,	-1.115501749	),
  (	67	,	0.928793001	,	-1.064939574	),
  (	67	,	0.760676038	,	-0.975268905	),
  (	67	,	1.54548354	,	-1.125419583	),
  (	67	,	1.377272302	,	-0.910748209	),
  (	67	,	1.23805988	,	-0.912160668	),
  (	67	,	1.217682525	,	-0.901857609	),
  (	67	,	1.271691551	,	-0.902779793	),
  (	67	,	1.558753487	,	-0.932454344	),
  (	67	,	1.566560501	,	-0.894011276	),
  (	67	,	1.545420553	,	-0.878925804	),
  (	67	,	1.439184746	,	-0.821637061	),
  (	67	,	1.377865361	,	-0.609581352	),
  (	67	,	1.06315047	,	-0.835345905	),
  (	67	,	0.981059168	,	-0.838836894	),
  (	67	,	1.084580008	,	-0.800488724	),
  (	67	,	1.17005643	,	-0.732336922	),
  (	67	,	1.156018395	,	-0.606644024	),
  (	67	,	1.094163617	,	-0.61564692	),
  (	67	,	0.991950253	,	-0.521890537	),
  (	67	,	1.116020155	,	-0.405570256	),
  (	67	,	0.443689421	,	-0.873340616	),
  (	67	,	0.753668011	,	-0.722428255	),
  (	67	,	0.486247918	,	-0.695271173	),
  (	67	,	0.002508012	,	-0.926732243	),
  (	67	,	0.147166937	,	-0.610964327	),
  (	67	,	0.387130367	,	-0.589296509	),
  (	67	,	0.2816152	,	-0.58526057	),
  (	67	,	0.315861194	,	-0.537606702	),
  (	67	,	0.41390624	,	-0.413635877	),
  (	67	,	0.381304099	,	-0.38988585	),
  (	67	,	0.731123181	,	-0.620479653	),
  (	67	,	0.936196161	,	-0.556320405	),
  (	67	,	0.937569098	,	-0.446500586	),
  (	67	,	1.077606705	,	-0.383869955	),
  (	67	,	0.880082393	,	-0.354733856	),
  (	67	,	0.629785549	,	-0.451121462	),
  (	67	,	0.487683026	,	-0.273099882	),
  (	67	,	2.752477875	,	-1.50256615	),
  (	67	,	2.842718532	,	-1.324403859	),
  (	67	,	2.008506067	,	-1.368108836	),
  (	67	,	2.259906189	,	-1.301562866	),
  (	67	,	2.463595818	,	-1.223053209	),
  (	67	,	2.158567086	,	-1.288173048	),
  (	67	,	2.64850892	,	-1.247529699	),
  (	67	,	3.025619188	,	-1.225130202	),
  (	67	,	2.785071673	,	-1.135194501	),
  (	67	,	2.797351762	,	-1.125288896	),
  (	67	,	2.678296555	,	-1.187868145	),
  (	67	,	2.523592994	,	-1.124032797	),
  (	67	,	2.744818184	,	-1.137535622	),
  (	67	,	2.751747873	,	-1.07087101	),
  (	67	,	2.630311256	,	-1.084838043	),
  (	67	,	2.676332187	,	-0.987624109	),
  (	67	,	2.620492863	,	-0.993894278	),
  (	67	,	2.596608154	,	-1.001519809	),
  (	67	,	1.749526534	,	-1.252718271	),
  (	67	,	1.859818539	,	-1.201442677	),
  (	67	,	2.109019903	,	-1.221233146	),
  (	67	,	1.755907088	,	-1.184080899	),
  (	67	,	2.078087248	,	-1.066384524	),
  (	67	,	2.080645779	,	-1.031938113	),
  (	67	,	2.10424934	,	-0.969365736	),
  (	67	,	2.268866179	,	-1.03928932	),
  (	67	,	2.343355868	,	-1.033698054	),
  (	67	,	2.528294314	,	-0.955626125	),
  (	67	,	2.518554894	,	-0.936691306	),
  (	67	,	2.406940051	,	-0.943122454	),
  (	67	,	2.202091631	,	-0.966288419	),
  (	67	,	2.186053939	,	-0.911547633	),
  (	67	,	2.243442831	,	-0.926271164	),
  (	67	,	2.399303055	,	-0.82861526	),
  (	67	,	2.38982851	,	-0.778982631	),
  (	67	,	3.033461315	,	-1.062812978	),
  (	67	,	2.77376326	,	-1.015656964	),
  (	67	,	2.74037223	,	-0.998301208	),
  (	67	,	2.851675333	,	-0.984722678	),
  (	67	,	2.882411962	,	-0.926974606	),
  (	67	,	2.82709699	,	-0.91186583	),
  (	67	,	2.912815751	,	-0.848925128	),
  (	67	,	2.844416691	,	-0.857967293	),
  (	67	,	2.830435515	,	-0.833389299	),
  (	67	,	2.704664964	,	-0.837083511	),
  (	67	,	2.743244553	,	-0.765120604	),
  (	67	,	3.053854461	,	-0.881146062	),
  (	67	,	2.88952978	,	-0.717581079	),
  (	67	,	3.00187126	,	-0.616604903	),
  (	67	,	2.9109316	,	-0.568756362	),
  (	67	,	2.60154235	,	-0.935830387	),
  (	67	,	2.644687165	,	-0.910849368	),
  (	67	,	2.615535145	,	-0.784620947	),
  (	67	,	2.682980724	,	-0.739722973	),
  (	67	,	2.600924565	,	-0.712524953	),
  (	67	,	2.63714011	,	-0.697710431	),
  (	67	,	2.430221372	,	-0.785606541	),
  (	67	,	2.484365965	,	-0.753813367	),
  (	67	,	2.410751244	,	-0.7611907	),
  (	67	,	2.4767931	,	-0.610997066	),
  (	67	,	2.701674798	,	-0.604168347	),
  (	67	,	2.894044956	,	-0.557825293	),
  (	67	,	2.914223707	,	-0.526661609	),
  (	67	,	2.707720784	,	-0.555247473	),
  (	67	,	2.752621902	,	-0.462227261	),
  (	67	,	2.712224909	,	-0.393196526	),
  (	67	,	1.669036729	,	-1.051005908	),
  (	67	,	1.955599189	,	-1.01356234	),
  (	67	,	1.580205849	,	-1.048886548	),
  (	67	,	1.774529249	,	-0.954606619	),
  (	67	,	1.648737267	,	-0.920364877	),
  (	67	,	1.795698369	,	-0.842868793	),
  (	67	,	1.855597982	,	-0.878943541	),
  (	67	,	1.893528681	,	-0.880892001	),
  (	67	,	2.135843404	,	-0.904822792	),
  (	67	,	2.161532939	,	-0.880505855	),
  (	67	,	2.106091857	,	-0.871794709	),
  (	67	,	2.090084143	,	-0.844325177	),
  (	67	,	2.093370545	,	-0.825601212	),
  (	67	,	2.076221969	,	-0.802502831	),
  (	67	,	2.163683401	,	-0.808296169	),
  (	67	,	2.155860314	,	-0.777990585	),
  (	67	,	2.147194664	,	-0.757480031	),
  (	67	,	2.23254009	,	-0.824510697	),
  (	67	,	2.236964451	,	-0.821038654	),
  (	67	,	2.29003971	,	-0.777398716	),
  (	67	,	2.329341431	,	-0.705942455	),
  (	67	,	2.257243549	,	-0.700705121	),
  (	67	,	2.244873488	,	-0.656437448	),
  (	67	,	2.027504482	,	-0.820451675	),
  (	67	,	2.05385129	,	-0.778065244	),
  (	67	,	2.085294567	,	-0.71182082	),
  (	67	,	1.977554858	,	-0.75199918	),
  (	67	,	2.171927161	,	-0.629497951	),
  (	67	,	2.105846192	,	-0.635319798	),
  (	67	,	2.116447269	,	-0.586276789	),
  (	67	,	1.60149088	,	-0.78698967	),
  (	67	,	1.71553054	,	-0.674138806	),
  (	67	,	2.038727961	,	-0.629599838	),
  (	67	,	1.931180263	,	-0.559307837	),
  (	67	,	2.073581985	,	-0.539611522	),
  (	67	,	1.83125221	,	-0.584259776	),
  (	67	,	1.936770247	,	-0.51120201	),
  (	67	,	1.937895865	,	-0.503140786	),
  (	67	,	1.833309064	,	-0.543520626	),
  (	67	,	2.004935236	,	-0.469825138	),
  (	67	,	1.916426781	,	-0.435558714	),
  (	67	,	2.323186762	,	-0.567395688	),
  (	67	,	2.410142536	,	-0.505229177	),
  (	67	,	2.485660425	,	-0.46416073	),
  (	67	,	2.172814057	,	-0.523662889	),
  (	67	,	2.211531141	,	-0.509908324	),
  (	67	,	2.244903032	,	-0.472950366	),
  (	67	,	2.369924873	,	-0.445132805	),
  (	67	,	2.634108082	,	-0.441859585	),
  (	67	,	2.467969751	,	-0.442215868	),
  (	67	,	2.691131297	,	-0.36075589	),
  (	67	,	2.690187207	,	-0.336990608	),
  (	67	,	2.501467267	,	-0.373362902	),
  (	67	,	2.607790405	,	-0.288369078	),
  (	67	,	2.596179864	,	-0.282633544	),
  (	67	,	2.508237231	,	-0.211721661	),
  (	67	,	2.11421997	,	-0.44854691	),
  (	67	,	2.178916086	,	-0.351931738	),
  (	67	,	2.206339249	,	-0.304375262	),
  (	67	,	2.301031281	,	-0.297629482	),
  (	67	,	2.04968591	,	-0.352704969	),
  (	67	,	2.049354913	,	-0.340437222	),
  (	67	,	2.003279365	,	-0.32599873	),
  (	67	,	2.02014225	,	-0.297778839	),
  (	67	,	2.040958396	,	-0.279505507	),
  (	67	,	2.326030938	,	-0.295882542	),
  (	67	,	2.33834084	,	-0.269476074	),
  (	67	,	2.394339554	,	-0.284101134	),
  (	67	,	2.417505005	,	-0.256475366	),
  (	67	,	2.430155254	,	-0.193794196	),
  (	67	,	2.206191877	,	-0.156312312	),
  (	67	,	2.218008973	,	-0.153878166	),
  (	67	,	4.198676783	,	-1.283094986	),
  (	67	,	3.739012492	,	-1.355496824	),
  (	67	,	3.966313736	,	-1.262004131	),
  (	67	,	4.482488329	,	-1.330368555	),
  (	67	,	4.450204384	,	-1.281465335	),
  (	67	,	4.414580133	,	-1.286704684	),
  (	67	,	4.283130491	,	-1.25443938	),
  (	67	,	4.538761377	,	-1.222546274	),
  (	67	,	4.628345124	,	-1.184281375	),
  (	67	,	4.288764732	,	-1.167405718	),
  (	67	,	4.072934747	,	-1.069426748	),
  (	67	,	4.276085284	,	-1.128338702	),
  (	67	,	4.118632917	,	-1.052211139	),
  (	67	,	4.206693549	,	-1.032820001	),
  (	67	,	4.271098961	,	-1.010542289	),
  (	67	,	4.199552316	,	-0.992312106	),
  (	67	,	3.141939311	,	-1.364724867	),
  (	67	,	3.1579125	,	-1.295280742	),
  (	67	,	3.481591413	,	-1.195476263	),
  (	67	,	3.729158434	,	-1.146707402	),
  (	67	,	3.152365794	,	-1.247716764	),
  (	67	,	3.325216235	,	-1.211390607	),
  (	67	,	3.189678856	,	-1.191380345	),
  (	67	,	3.54284236	,	-1.140082268	),
  (	67	,	3.606764508	,	-1.097980214	),
  (	67	,	3.569752567	,	-1.019531237	),
  (	67	,	3.835309016	,	-1.032218899	),
  (	67	,	4.03934167	,	-0.926035449	),
  (	67	,	4.057769992	,	-0.912857657	),
  (	67	,	3.827535301	,	-0.926087458	),
  (	67	,	3.741222689	,	-0.973285587	),
  (	67	,	3.732187314	,	-0.933925317	),
  (	67	,	3.862905887	,	-0.895616461	),
  (	67	,	3.924028433	,	-0.900174748	),
  (	67	,	4.000558464	,	-0.835396386	),
  (	67	,	3.977515687	,	-0.790239004	),
  (	67	,	3.911848825	,	-0.835651022	),
  (	67	,	3.925869845	,	-0.764667693	),
  (	67	,	4.683161272	,	-1.142999806	),
  (	67	,	4.669289639	,	-1.122333517	),
  (	67	,	4.532873972	,	-1.097371302	),
  (	67	,	4.554170656	,	-1.023902558	),
  (	67	,	4.67498794	,	-0.939672349	),
  (	67	,	4.402137398	,	-0.923993348	),
  (	67	,	4.426704421	,	-0.867617775	),
  (	67	,	4.446632349	,	-0.853031745	),
  (	67	,	4.342063629	,	-0.789669944	),
  (	67	,	4.559095879	,	-0.806378149	),
  (	67	,	4.53528421	,	-0.771838951	),
  (	67	,	4.52168116	,	-0.738956011	),
  (	67	,	4.645765595	,	-0.803596238	),
  (	67	,	4.700056162	,	-0.732662281	),
  (	67	,	4.425842111	,	-0.729894687	),
  (	67	,	4.434229484	,	-0.709649794	),
  (	67	,	4.513687131	,	-0.694059142	),
  (	67	,	4.507998013	,	-0.662394291	),
  (	67	,	4.221167811	,	-0.845132785	),
  (	67	,	4.130637341	,	-0.850619623	),
  (	67	,	4.192201474	,	-0.682229181	),
  (	67	,	4.224012688	,	-0.632368143	),
  (	67	,	4.029158914	,	-0.805303306	),
  (	67	,	4.021109819	,	-0.784321025	),
  (	67	,	3.993865748	,	-0.770556686	),
  (	67	,	4.02539808	,	-0.773060104	),
  (	67	,	3.999501907	,	-0.739502053	),
  (	67	,	4.106392463	,	-0.697837518	),
  (	67	,	4.374160974	,	-0.647167196	),
  (	67	,	4.366074955	,	-0.622859713	),
  (	67	,	4.272940136	,	-0.619435423	),
  (	67	,	4.429402907	,	-0.548084891	),
  (	67	,	4.250734751	,	-0.552666225	),
  (	67	,	4.260542885	,	-0.423800149	),
  (	67	,	3.296475932	,	-1.077582702	),
  (	67	,	3.154415605	,	-1.085163478	),
  (	67	,	3.331258739	,	-1.028046858	),
  (	67	,	3.33611479	,	-0.999847158	),
  (	67	,	3.590623037	,	-0.886458711	),
  (	67	,	3.427436706	,	-0.909588749	),
  (	67	,	3.507523202	,	-0.869575932	),
  (	67	,	3.518042575	,	-0.851488824	),
  (	67	,	3.766663158	,	-0.827582751	),
  (	67	,	3.829293292	,	-0.752433364	),
  (	67	,	3.772872895	,	-0.773380252	),
  (	67	,	3.670168201	,	-0.771400323	),
  (	67	,	3.622969494	,	-0.696402511	),
  (	67	,	3.72155518	,	-0.712679662	),
  (	67	,	3.774343807	,	-0.653578085	),
  (	67	,	3.637022301	,	-0.622460337	),
  (	67	,	3.637018053	,	-0.622456868	),
  (	67	,	3.155170785	,	-0.841161015	),
  (	67	,	3.382082233	,	-0.738115866	),
  (	67	,	3.394732021	,	-0.679232784	),
  (	67	,	3.19169526	,	-0.772886278	),
  (	67	,	3.550846719	,	-0.69718247	),
  (	67	,	3.616757036	,	-0.623177608	),
  (	67	,	3.564147999	,	-0.601581453	),
  (	67	,	3.554906287	,	-0.581385637	),
  (	67	,	3.646598573	,	-0.546024964	),
  (	67	,	3.656386831	,	-0.453751671	),
  (	67	,	3.405812913	,	-0.576861706	),
  (	67	,	3.525701497	,	-0.460806525	),
  (	67	,	3.466470263	,	-0.423838965	),
  (	67	,	3.507894927	,	-0.365205342	),
  (	67	,	3.94259982	,	-0.627318098	),
  (	67	,	4.026275613	,	-0.512114826	),
  (	67	,	4.138360814	,	-0.415984823	),
  (	67	,	4.179248165	,	-0.410631012	),
  (	67	,	4.262907527	,	-0.350883319	),
  (	67	,	4.027477299	,	-0.264136413	),
  (	67	,	3.777747244	,	-0.468666996	),
  (	67	,	3.890261112	,	-0.310516018	),
  (	67	,	3.776445052	,	-0.34854347	),
  (	67	,	3.624069381	,	-0.347282915	),
  (	67	,	3.769740527	,	-0.281032088	),
  (	67	,	3.775546608	,	-0.233056319	),
  (	67	,	4.095705444	,	-0.153500044	),
  (	67	,	3.98478041	,	-0.192114687	),
  (	67	,	3.858147265	,	-0.144014364	),
  (	67	,	3.938974222	,	-0.052910531	),
  (	67	,	5.637678305	,	-1.480218525	),
  (	67	,	6.074678639	,	-1.412194235	),
  (	67	,	5.045633968	,	-1.322963766	),
  (	67	,	5.603728339	,	-1.217086607	),
  (	67	,	5.389145717	,	-1.242477146	),
  (	67	,	6.139727174	,	-1.162057094	),
  (	67	,	6.065988964	,	-1.166881772	),
  (	67	,	5.739786713	,	-1.223748321	),
  (	67	,	5.740275481	,	-1.222927638	),
  (	67	,	5.664842206	,	-1.21527849	),
  (	67	,	5.851545167	,	-1.091679322	),
  (	67	,	5.849496684	,	-1.003736045	),
  (	67	,	5.191875779	,	-1.166106764	),
  (	67	,	5.272379985	,	-1.158108627	),
  (	67	,	4.775227397	,	-1.234843541	),
  (	67	,	5.049255091	,	-1.163454217	),
  (	67	,	4.960714267	,	-1.096099341	),
  (	67	,	5.079803389	,	-1.099522062	),
  (	67	,	5.64305579	,	-0.920449455	),
  (	67	,	5.590623719	,	-0.871606439	),
  (	67	,	5.532251617	,	-0.854171854	),
  (	67	,	5.487523938	,	-0.770321026	),
  (	67	,	5.985376418	,	-1.045127574	),
  (	67	,	5.962373016	,	-0.867213995	),
  (	67	,	5.963485243	,	-0.819246346	),
  (	67	,	6.24214547	,	-0.826880027	),
  (	67	,	6.147988904	,	-0.776639416	),
  (	67	,	6.17340891	,	-0.744981962	),
  (	67	,	5.924497885	,	-0.695637625	),
  (	67	,	6.094818634	,	-0.718975844	),
  (	67	,	6.000660227	,	-0.635100199	),
  (	67	,	5.742388367	,	-0.915669867	),
  (	67	,	5.803078071	,	-0.839644692	),
  (	67	,	5.741772026	,	-0.819055259	),
  (	67	,	5.695512718	,	-0.86391051	),
  (	67	,	5.671048613	,	-0.740814847	),
  (	67	,	6.00572875	,	-0.550942246	),
  (	67	,	6.051788821	,	-0.524439438	),
  (	67	,	5.928635073	,	-0.501752429	),
  (	67	,	5.778773612	,	-0.522141651	),
  (	67	,	5.76325046	,	-0.496614903	),
  (	67	,	5.8944022	,	-0.455081901	),
  (	67	,	4.746445907	,	-1.126620929	),
  (	67	,	4.774655426	,	-1.111601669	),
  (	67	,	5.055742787	,	-0.979911731	),
  (	67	,	5.012912293	,	-0.97251892	),
  (	67	,	4.740717462	,	-1.022256412	),
  (	67	,	5.271584078	,	-0.917658026	),
  (	67	,	5.295065632	,	-0.832758525	),
  (	67	,	5.275545501	,	-0.821498118	),
  (	67	,	5.446784207	,	-0.77138679	),
  (	67	,	5.400628545	,	-0.719564149	),
  (	67	,	5.148403484	,	-0.68823994	),
  (	67	,	5.225915123	,	-0.664263999	),
  (	67	,	5.327033701	,	-0.622620714	),
  (	67	,	4.893513243	,	-0.839424767	),
  (	67	,	4.89727567	,	-0.833589805	),
  (	67	,	4.940149123	,	-0.727965184	),
  (	67	,	5.016350126	,	-0.69511906	),
  (	67	,	4.713567622	,	-0.829973601	),
  (	67	,	4.804115518	,	-0.764012433	),
  (	67	,	4.803668485	,	-0.654283635	),
  (	67	,	4.978788852	,	-0.646838379	),
  (	67	,	4.954085227	,	-0.652519423	),
  (	67	,	5.106187869	,	-0.56010517	),
  (	67	,	5.214539908	,	-0.576765356	),
  (	67	,	4.95871722	,	-0.553079136	),
  (	67	,	5.58392865	,	-0.459987238	),
  (	67	,	5.602215952	,	-0.43986915	),
  (	67	,	5.457581583	,	-0.559466138	),
  (	67	,	5.325281668	,	-0.509587518	),
  (	67	,	5.433291178	,	-0.475553873	),
  (	67	,	5.413132904	,	-0.465048854	),
  (	67	,	5.47208333	,	-0.487389333	),
  (	67	,	5.610403255	,	-0.415775885	),
  (	67	,	5.628660256	,	-0.334197995	),
  (	67	,	5.475031112	,	-0.327994302	),
  (	67	,	5.338254587	,	-0.24882175	),
  (	67	,	5.497406961	,	-0.227794743	),
  (	67	,	5.620976297	,	-0.20191017	),
  (	67	,	5.560091488	,	-0.185099241	),
  (	67	,	5.568892635	,	-0.160825816	),
  (	67	,	5.406583541	,	-0.086034374	),
  (	68	,	0.800535343	,	0.108669322	),
  (	68	,	0.925896336	,	0.201447833	),
  (	68	,	0.706863132	,	0.18403955	),
  (	68	,	0.640369312	,	0.184397614	),
  (	68	,	0.787689302	,	0.314243109	),
  (	68	,	0.846115793	,	0.331148286	),
  (	68	,	1.003425361	,	0.416232623	),
  (	68	,	0.992618746	,	0.423905795	),
  (	68	,	0.990433274	,	0.427951147	),
  (	68	,	1.009765729	,	0.43917442	),
  (	68	,	0.946695688	,	0.405107301	),
  (	68	,	0.980081913	,	0.486893187	),
  (	68	,	0.531628502	,	0.262970588	),
  (	68	,	0.62201133	,	0.294440938	),
  (	68	,	0.744887101	,	0.334404672	),
  (	68	,	0.485019166	,	0.358041126	),
  (	68	,	0.620071736	,	0.399219404	),
  (	68	,	0.598530208	,	0.414821945	),
  (	68	,	0.780535835	,	0.377299073	),
  (	68	,	0.796049093	,	0.464398415	),
  (	68	,	0.765182853	,	0.483844701	),
  (	68	,	0.901423624	,	0.501159923	),
  (	68	,	0.938209672	,	0.558793608	),
  (	68	,	0.769110919	,	0.509006534	),
  (	68	,	0.741795336	,	0.5327768	),
  (	68	,	0.611192614	,	0.526877256	),
  (	68	,	0.679960889	,	0.606069621	),
  (	68	,	0.778040036	,	0.566556428	),
  (	68	,	0.745613859	,	0.617740464	),
  (	68	,	0.803535861	,	0.664611661	),
  (	68	,	1.351453138	,	0.520084475	),
  (	68	,	1.067783779	,	0.568473508	),
  (	68	,	1.071642305	,	0.597578966	),
  (	68	,	1.184212333	,	0.698307672	),
  (	68	,	1.433091776	,	0.605584535	),
  (	68	,	1.420261604	,	0.59666426	),
  (	68	,	1.419019302	,	0.608329149	),
  (	68	,	1.369302639	,	0.646337657	),
  (	68	,	1.354004145	,	0.651045188	),
  (	68	,	1.435619566	,	0.737756087	),
  (	68	,	1.56824124	,	0.796211845	),
  (	68	,	1.560421637	,	0.801128269	),
  (	68	,	1.302345209	,	0.651508533	),
  (	68	,	1.332797367	,	0.818845123	),
  (	68	,	1.55804245	,	0.855728509	),
  (	68	,	1.430785528	,	0.841709433	),
  (	68	,	0.860410353	,	0.706557078	),
  (	68	,	0.908893633	,	0.774528165	),
  (	68	,	1.073540708	,	0.818998885	),
  (	68	,	0.94237199	,	0.821890359	),
  (	68	,	0.903587996	,	0.841341778	),
  (	68	,	1.028174722	,	0.918764331	),
  (	68	,	1.275663879	,	0.801796176	),
  (	68	,	1.51677052	,	0.951109672	),
  (	68	,	1.513682958	,	0.993506936	),
  (	68	,	1.514826855	,	1.02600191	),
  (	68	,	1.29660103	,	1.031841209	),
  (	68	,	0.391331064	,	0.398391189	),
  (	68	,	0.477577278	,	0.462033232	),
  (	68	,	0.532913277	,	0.495677245	),
  (	68	,	0.55335201	,	0.510846713	),
  (	68	,	0.45545345	,	0.567500959	),
  (	68	,	0.418177794	,	0.590521424	),
  (	68	,	0.363476243	,	0.637298483	),
  (	68	,	0.650683912	,	0.65152453	),
  (	68	,	0.571132623	,	0.681432233	),
  (	68	,	0.664845818	,	0.702884612	),
  (	68	,	0.713807974	,	0.759878072	),
  (	68	,	0.434626164	,	0.800690583	),
  (	68	,	0.140649955	,	0.610755504	),
  (	68	,	0.153412372	,	0.642841807	),
  (	68	,	0.28191785	,	0.697972847	),
  (	68	,	0.333721277	,	0.749430397	),
  (	68	,	0.253790615	,	0.688971671	),
  (	68	,	0.246575914	,	0.750120202	),
  (	68	,	0.163360404	,	0.703932456	),
  (	68	,	0.105101056	,	0.772564862	),
  (	68	,	0.016128451	,	0.84538242	),
  (	68	,	0.073734025	,	0.863272625	),
  (	68	,	0.386479827	,	0.737698549	),
  (	68	,	0.357207643	,	0.874793113	),
  (	68	,	0.310564038	,	0.806057146	),
  (	68	,	0.293356364	,	0.864904236	),
  (	68	,	0.274439975	,	0.90404674	),
  (	68	,	0.416273785	,	0.931055582	),
  (	68	,	0.337888525	,	1.005869555	),
  (	68	,	0.303596289	,	1.000942053	),
  (	68	,	0.179813247	,	0.911017647	),
  (	68	,	0.135571744	,	0.972183719	),
  (	68	,	0.269493578	,	1.009091318	),
  (	68	,	0.749974903	,	0.78355027	),
  (	68	,	0.759291067	,	0.823111492	),
  (	68	,	0.760867344	,	0.893029239	),
  (	68	,	0.944073285	,	0.975407849	),
  (	68	,	0.938182031	,	1.047923629	),
  (	68	,	0.611522408	,	0.889382178	),
  (	68	,	0.664124618	,	0.967921446	),
  (	68	,	0.607515676	,	0.997791166	),
  (	68	,	0.822207727	,	0.995050079	),
  (	68	,	0.888140875	,	1.024890547	),
  (	68	,	0.878415341	,	1.082088308	),
  (	68	,	0.803737032	,	1.076885927	),
  (	68	,	1.203079851	,	1.036738435	),
  (	68	,	1.013789184	,	1.08812182	),
  (	68	,	1.073963637	,	1.083881314	),
  (	68	,	1.355743917	,	1.109970979	),
  (	68	,	1.335612856	,	1.203796241	),
  (	68	,	1.399038144	,	1.251655926	),
  (	68	,	1.474234714	,	1.250599317	),
  (	68	,	0.527133831	,	1.046483729	),
  (	68	,	0.45100569	,	1.040781817	),
  (	68	,	0.67951832	,	1.193240102	),
  (	68	,	0.485559339	,	1.131932223	),
  (	68	,	0.094705714	,	1.183734451	),
  (	68	,	0.218338483	,	1.235241216	),
  (	68	,	0.11280912	,	1.253270879	),
  (	68	,	0.282891539	,	1.298038225	),
  (	68	,	0.671862947	,	1.244311687	),
  (	68	,	0.765648299	,	1.280566164	),
  (	68	,	0.851393672	,	1.289238685	),
  (	68	,	1.434670039	,	1.366588843	),
  (	68	,	0.86113631	,	1.376628238	),
  (	68	,	0.452946033	,	1.302092159	),
  (	68	,	0.22230081	,	1.360544044	),
  (	68	,	0.264040006	,	1.405784156	),
  (	68	,	0.277866739	,	1.476666702	),
  (	68	,	2.387954171	,	0.045059878	),
  (	68	,	2.370346234	,	0.118963149	),
  (	68	,	2.44916602	,	0.228828349	),
  (	68	,	2.26989609	,	0.114596984	),
  (	68	,	2.577941967	,	0.206689811	),
  (	68	,	2.508887418	,	0.220859854	),
  (	68	,	2.700707456	,	0.309023799	),
  (	68	,	2.658688719	,	0.354865461	),
  (	68	,	2.615671902	,	0.372132981	),
  (	68	,	2.464199356	,	0.345328322	),
  (	68	,	2.553611723	,	0.409705146	),
  (	68	,	2.521252518	,	0.430575553	),
  (	68	,	2.259234311	,	0.336274848	),
  (	68	,	2.329672517	,	0.348491589	),
  (	68	,	2.270388051	,	0.337702417	),
  (	68	,	2.273017309	,	0.341739749	),
  (	68	,	2.268248386	,	0.341049842	),
  (	68	,	2.248521129	,	0.341909616	),
  (	68	,	2.224530707	,	0.457149986	),
  (	68	,	2.339738533	,	0.426685413	),
  (	68	,	2.542689673	,	0.525543721	),
  (	68	,	2.450683245	,	0.563113529	),
  (	68	,	2.257448451	,	0.493824422	),
  (	68	,	2.299996591	,	0.491509234	),
  (	68	,	2.744648102	,	0.518838909	),
  (	68	,	2.964981978	,	0.572909675	),
  (	68	,	3.020329565	,	0.632631427	),
  (	68	,	3.043905775	,	0.780446682	),
  (	68	,	2.829143245	,	0.65572571	),
  (	68	,	2.969374757	,	0.785364875	),
  (	68	,	3.015797358	,	0.851535527	),
  (	68	,	2.584651781	,	0.661729906	),
  (	68	,	2.709890373	,	0.73041008	),
  (	68	,	2.693437869	,	0.72374069	),
  (	68	,	2.700321859	,	0.768751831	),
  (	68	,	2.421467341	,	0.673869169	),
  (	68	,	2.527139055	,	0.753000221	),
  (	68	,	2.667346315	,	0.86307796	),
  (	68	,	2.500720262	,	0.862869123	),
  (	68	,	2.750003744	,	0.882593372	),
  (	68	,	2.780921446	,	0.984911984	),
  (	68	,	1.975900936	,	0.399462428	),
  (	68	,	2.050544722	,	0.492159578	),
  (	68	,	1.871312608	,	0.592258229	),
  (	68	,	2.1388926	,	0.618776219	),
  (	68	,	2.093763636	,	0.629749962	),
  (	68	,	2.14394956	,	0.675979674	),
  (	68	,	2.008116041	,	0.718439179	),
  (	68	,	2.153132254	,	0.842657724	),
  (	68	,	1.820851463	,	0.65266087	),
  (	68	,	1.678351964	,	0.615313147	),
  (	68	,	1.851291579	,	0.655613658	),
  (	68	,	1.663726644	,	0.738973746	),
  (	68	,	1.571496987	,	0.891525371	),
  (	68	,	1.900790211	,	0.792542394	),
  (	68	,	1.890255487	,	0.830886132	),
  (	68	,	1.967624484	,	0.907546467	),
  (	68	,	1.932286167	,	0.964889661	),
  (	68	,	1.721535408	,	0.966093528	),
  (	68	,	1.703334778	,	1.04975454	),
  (	68	,	1.640899623	,	1.033494582	),
  (	68	,	1.619777027	,	1.05511061	),
  (	68	,	2.602439801	,	0.946731004	),
  (	68	,	2.246630325	,	0.847069725	),
  (	68	,	2.657824106	,	1.116180457	),
  (	68	,	2.937056331	,	1.175008682	),
  (	68	,	2.69583314	,	1.240237619	),
  (	68	,	2.168432969	,	1.033047803	),
  (	68	,	2.051327537	,	1.053170666	),
  (	68	,	1.656290914	,	1.214204603	),
  (	68	,	1.858181674	,	1.234504251	),
  (	68	,	2.417501505	,	1.250625646	),
  (	68	,	3.044315198	,	1.354300697	),
  (	68	,	1.983838582	,	1.411914106	),
  (	68	,	2.296753849	,	1.435343904	),
  (	68	,	1.796766903	,	1.512914361	),
  (	68	,	3.95803345	,	0.041233269	),
  (	68	,	3.999410443	,	0.16952302	),
  (	68	,	3.98277666	,	0.186782671	),
  (	68	,	3.907249044	,	0.216952423	),
  (	68	,	3.865303904	,	0.228653601	),
  (	68	,	4.140099651	,	0.222068189	),
  (	68	,	4.071326347	,	0.279460888	),
  (	68	,	4.129445834	,	0.270992757	),
  (	68	,	3.982436186	,	0.336640462	),
  (	68	,	3.917154039	,	0.331385388	),
  (	68	,	3.701248052	,	0.424378125	),
  (	68	,	3.88308	,	0.431454661	),
  (	68	,	3.942733519	,	0.603283233	),
  (	68	,	3.924442829	,	0.691937711	),
  (	68	,	4.259817529	,	0.403566246	),
  (	68	,	4.403695261	,	0.522992449	),
  (	68	,	4.232705609	,	0.466753473	),
  (	68	,	4.207219954	,	0.596534399	),
  (	68	,	4.650846232	,	0.678604297	),
  (	68	,	4.651190436	,	0.686309468	),
  (	68	,	4.703410143	,	0.757771916	),
  (	68	,	4.50148497	,	0.791059828	),
  (	68	,	4.061237104	,	0.601537965	),
  (	68	,	4.05990221	,	0.642365025	),
  (	68	,	4.210284415	,	0.683416396	),
  (	68	,	4.192788754	,	0.683777931	),
  (	68	,	4.229297849	,	0.717254642	),
  (	68	,	4.234213852	,	0.764726105	),
  (	68	,	4.051444477	,	0.675856565	),
  (	68	,	4.356963503	,	0.852805585	),
  (	68	,	4.304551556	,	0.837033311	),
  (	68	,	4.295429187	,	0.912624245	),
  (	68	,	4.664654665	,	1.09605437	),
  (	68	,	3.46272951	,	0.643809625	),
  (	68	,	3.801937947	,	0.757164941	),
  (	68	,	3.859239632	,	0.788642324	),
  (	68	,	3.79281341	,	0.772521093	),
  (	68	,	3.635260284	,	0.704029086	),
  (	68	,	3.613206845	,	0.733859751	),
  (	68	,	3.72394369	,	0.903867243	),
  (	68	,	3.287738738	,	0.664428674	),
  (	68	,	3.15236451	,	0.751897191	),
  (	68	,	3.358158304	,	0.850672897	),
  (	68	,	3.384412145	,	0.959255814	),
  (	68	,	4.084370885	,	0.908799497	),
  (	68	,	3.734997728	,	0.989400651	),
  (	68	,	4.232161909	,	1.044958248	),
  (	68	,	4.134381928	,	1.039665986	),
  (	68	,	4.432131686	,	1.177722643	),
  (	68	,	4.312493413	,	1.170138011	),
  (	68	,	4.67492786	,	1.301475763	),
  (	68	,	4.593183306	,	1.295515405	),
  (	68	,	3.7094672	,	1.201892433	),
  (	68	,	3.46210478	,	1.174397578	),
  (	68	,	3.387826871	,	1.151818267	),
  (	68	,	3.390151724	,	1.173610748	),
  (	68	,	3.302489586	,	1.224953778	),
  (	68	,	3.145422579	,	1.225883432	),
  (	68	,	3.193105843	,	1.351597366	),
  (	68	,	3.928794153	,	1.25255328	),
  (	68	,	3.580871457	,	1.341177222	),
  (	68	,	3.8967075	,	1.364439971	),
  (	68	,	3.621625586	,	1.378734939	),
  (	68	,	4.054176315	,	1.404106028	),
  (	68	,	5.476588922	,	0.031646199	),
  (	68	,	5.532740897	,	0.089911784	),
  (	68	,	5.343493579	,	0.15005343	),
  (	68	,	5.43194642	,	0.214897046	),
  (	68	,	5.523144199	,	0.267500703	),
  (	68	,	5.752852054	,	0.244726328	),
  (	68	,	5.822000826	,	0.299999344	),
  (	68	,	5.817038652	,	0.31903845	),
  (	68	,	5.795853886	,	0.42160903	),
  (	68	,	5.611773694	,	0.315295116	),
  (	68	,	5.581504716	,	0.311049158	),
  (	68	,	5.623036908	,	0.452411074	),
  (	68	,	5.292932867	,	0.20682843	),
  (	68	,	5.414451876	,	0.306674093	),
  (	68	,	5.394224848	,	0.293474128	),
  (	68	,	5.465055933	,	0.314634539	),
  (	68	,	5.36723477	,	0.343263557	),
  (	68	,	5.228300291	,	0.287869097	),
  (	68	,	5.239772049	,	0.349160612	),
  (	68	,	5.195631107	,	0.352757427	),
  (	68	,	5.163632509	,	0.39261081	),
  (	68	,	5.329948487	,	0.398786082	),
  (	68	,	5.523643656	,	0.365587211	),
  (	68	,	5.490423756	,	0.402234216	),
  (	68	,	5.579200707	,	0.43038697	),
  (	68	,	5.549926581	,	0.534407995	),
  (	68	,	5.604161361	,	0.539947018	),
  (	68	,	5.41359801	,	0.455165456	),
  (	68	,	5.490201213	,	0.530511866	),
  (	68	,	5.329769018	,	0.533903615	),
  (	68	,	5.554024499	,	0.624784296	),
  (	68	,	5.425368927	,	0.621123651	),
  (	68	,	5.817139554	,	0.452730799	),
  (	68	,	6.063019167	,	0.517834367	),
  (	68	,	5.732997711	,	0.494646235	),
  (	68	,	6.125233418	,	0.567782795	),
  (	68	,	6.029495103	,	0.604098808	),
  (	68	,	5.906095242	,	0.712426842	),
  (	68	,	6.165128126	,	0.80500996	),
  (	68	,	5.708937183	,	0.572401456	),
  (	68	,	5.855059119	,	0.709763128	),
  (	68	,	5.565227452	,	0.733514529	),
  (	68	,	5.628752451	,	0.794022925	),
  (	68	,	5.619547484	,	0.812651453	),
  (	68	,	5.626995972	,	0.810294893	),
  (	68	,	5.59091151	,	0.815590756	),
  (	68	,	5.797540727	,	0.836595105	),
  (	68	,	5.642510605	,	0.843051117	),
  (	68	,	5.636131012	,	0.847959151	),
  (	68	,	5.882015606	,	0.770050817	),
  (	68	,	5.990070683	,	0.812422102	),
  (	68	,	5.961832927	,	0.80660293	),
  (	68	,	5.983085098	,	0.850555175	),
  (	68	,	6.269776347	,	0.974597116	),
  (	68	,	5.868924601	,	0.894586891	),
  (	68	,	5.890014023	,	0.914844949	),
  (	68	,	5.860452343	,	0.976742257	),
  (	68	,	5.891845575	,	0.998772055	),
  (	68	,	6.042865634	,	0.98943639	),
  (	68	,	6.126682698	,	1.004183499	),
  (	68	,	6.110166032	,	1.051992675	),
  (	68	,	6.243854819	,	1.116746171	),
  (	68	,	6.206172845	,	1.126005533	),
  (	68	,	5.095930002	,	0.353382571	),
  (	68	,	5.16097764	,	0.398833939	),
  (	68	,	5.051273566	,	0.391672013	),
  (	68	,	5.126837877	,	0.475176254	),
  (	68	,	5.097368996	,	0.514001227	),
  (	68	,	5.240260133	,	0.545074237	),
  (	68	,	5.136480812	,	0.497406619	),
  (	68	,	5.183602862	,	0.549889922	),
  (	68	,	5.063312262	,	0.56023118	),
  (	68	,	4.979958054	,	0.515202907	),
  (	68	,	5.038932852	,	0.556070504	),
  (	68	,	5.117808195	,	0.545173785	),
  (	68	,	5.120080148	,	0.579509143	),
  (	68	,	5.106348349	,	0.588669656	),
  (	68	,	5.186821634	,	0.616305413	),
  (	68	,	5.140101347	,	0.615380666	),
  (	68	,	5.017555892	,	0.622401524	),
  (	68	,	5.102914638	,	0.633347699	),
  (	68	,	5.339838021	,	0.646227871	),
  (	68	,	5.261972649	,	0.624624189	),
  (	68	,	5.299955805	,	0.641444629	),
  (	68	,	5.217125169	,	0.701149833	),
  (	68	,	5.133625464	,	0.762815033	),
  (	68	,	5.288621072	,	0.833168747	),
  (	68	,	4.904747948	,	0.672530742	),
  (	68	,	5.049819197	,	0.682789418	),
  (	68	,	4.975574887	,	0.710067899	),
  (	68	,	4.954972536	,	0.734095583	),
  (	68	,	5.125436991	,	0.840620324	),
  (	68	,	5.027691187	,	0.826849674	),
  (	68	,	5.157752124	,	0.968011191	),
  (	68	,	5.067669039	,	1.008225869	),
  (	68	,	4.776453369	,	0.987654279	),
  (	68	,	4.879964405	,	1.059614271	),
  (	68	,	5.481178916	,	0.757897491	),
  (	68	,	5.505606227	,	0.771196645	),
  (	68	,	5.480262397	,	0.774471789	),
  (	68	,	5.546914504	,	0.797165094	),
  (	68	,	5.430625379	,	0.825485515	),
  (	68	,	5.403035537	,	0.83898465	),
  (	68	,	5.452528291	,	0.874883351	),
  (	68	,	5.5958888	,	0.863786941	),
  (	68	,	5.368346904	,	0.868819241	),
  (	68	,	5.379908785	,	0.869893075	),
  (	68	,	5.464413126	,	0.960826876	),
  (	68	,	5.313824887	,	0.948112109	),
  (	68	,	5.302228911	,	0.971386206	),
  (	68	,	5.451171834	,	1.025358609	),
  (	68	,	5.878182572	,	1.080562693	),
  (	68	,	6.003820711	,	1.089648894	),
  (	68	,	5.748257701	,	1.154345088	),
  (	68	,	5.771924638	,	1.15304177	),
  (	68	,	6.163134711	,	1.256651356	),
  (	68	,	6.0117812	,	1.276416973	),
  (	68	,	6.048784983	,	1.319144954	),
  (	68	,	5.18475523	,	1.037139414	),
  (	68	,	5.109912745	,	1.022470463	),
  (	68	,	5.193939141	,	1.06830452	),
  (	68	,	5.376601401	,	1.141433852	),
  (	68	,	5.124315267	,	1.249740501	),
  (	68	,	4.795868593	,	1.248226615	),
  (	68	,	4.946067024	,	1.322741571	),
  (	68	,	5.72563209	,	1.388442098	),
  (	68	,	5.393115142	,	1.386322193	),
  (	68	,	5.29898453	,	1.405542611	),
  (	68	,	4.817718622	,	1.382704575	),
  (	68	,	5.353003263	,	1.421296326	),
  (	68	,	6.281132835	,	1.513312059	),
  (	68	,	4.779909505	,	1.512466631	),
  (	68	,	5.817175666	,	1.504847869	),
  (	68	,	0.007396384	,	-0.700729134	),
  (	68	,	6.26258497	,	-0.556485294	),
  (	68	,	0.130101809	,	-0.560532306	),
  (	68	,	6.18322638	,	-0.556256487	),
  (	68	,	6.090108945	,	-0.520940837	),
  (	68	,	6.135740596	,	-0.478647504	),
  (	68	,	6.177022005	,	-0.479811199	),
  (	68	,	6.258565738	,	-0.471987711	),
  (	68	,	0.18140208	,	-0.439768051	),
  (	68	,	6.104531046	,	-0.495460274	),
  (	68	,	6.160720879	,	-0.449317609	),
  (	68	,	6.032865468	,	-0.323614696	),
  (	68	,	6.099679106	,	-0.240773079	),
  (	68	,	0.052579239	,	-0.241087475	),
  (	68	,	6.264688224	,	-0.229564203	),
  (	68	,	0.18694635	,	-0.173168681	),
  (	68	,	6.261662857	,	-0.165117616	),
  (	68	,	6.28178216	,	-0.10286012	),
  (	68	,	0.388161289	,	-0.31306651	),
  (	68	,	0.55056496	,	-0.179357178	),
  (	68	,	0.349286703	,	-0.172513727	),
  (	68	,	0.317621909	,	-0.118393883	),
  (	68	,	0.374896611	,	-0.14843276	),
  (	68	,	0.392247604	,	-0.097668243	),
  (	68	,	0.374698099	,	-0.068548994	),
  (	68	,	0.762648504	,	-0.000837614	),
  (	68	,	0.589748606	,	0.012567909	),
  (	68	,	0.566606351	,	0.065786792	),
  (	68	,	0.256400178	,	-0.10268418	),
  (	68	,	0.234273805	,	-0.078986969	),
  (	68	,	0.157242017	,	-0.097240511	),
  (	68	,	0.252364704	,	-0.030822563	),
  (	68	,	0.114648001	,	0.066771918	),
  (	68	,	0.536513199	,	0.192313536	),
  (	68	,	5.823451881	,	-0.276128701	),
  (	68	,	5.908417763	,	-0.167699465	),
  (	68	,	5.947459812	,	-0.145062468	),
  (	68	,	5.718539922	,	-0.1567804	),
  (	68	,	5.749359535	,	-0.149474987	),
  (	68	,	6.095516204	,	-0.124973767	),
  (	68	,	6.114579346	,	-0.081558614	),
  (	68	,	6.109839722	,	-0.068414943	),
  (	68	,	6.038679859	,	-0.083681543	),
  (	68	,	5.646701613	,	-0.076238471	),
  (	68	,	5.722768343	,	0.013446636	),
  (	68	,	5.595719579	,	-0.054633666	),
  (	68	,	5.670266609	,	-0.000891197	),
  (	68	,	5.64925189	,	0.031923679	),
  (	68	,	5.529920862	,	-0.013351639	),
  (	68	,	5.822795796	,	0.139208901	),
  (	68	,	5.849934678	,	0.244907135	),
  (	68	,	6.247813723	,	0.082822922	),
  (	68	,	6.264112996	,	0.143522261	),
  (	68	,	0.078270262	,	0.222901825	),
  (	68	,	6.282300246	,	0.196758719	),
  (	68	,	0.014065832	,	0.306338465	),
  (	68	,	6.252717843	,	0.312407452	),
  (	68	,	0.225077304	,	0.223133728	),
  (	68	,	0.187091345	,	0.290804525	),
  (	68	,	0.086993981	,	0.283629787	),
  (	68	,	0.057411897	,	0.295325383	),
  (	68	,	0.118155995	,	0.437064484	),
  (	68	,	6.045607514	,	0.26108372	),
  (	68	,	6.032670371	,	0.283310685	),
  (	68	,	6.098266522	,	0.319473759	),
  (	68	,	6.120959398	,	0.358819963	),
  (	68	,	5.996522349	,	0.310578319	),
  (	68	,	6.034822629	,	0.365094526	),
  (	68	,	5.980605478	,	0.334075721	),
  (	68	,	6.031645695	,	0.407369577	),
  (	68	,	6.265617038	,	0.369417276	),
  (	68	,	0.052471281	,	0.409659785	),
  (	68	,	0.007484537	,	0.423293257	),
  (	68	,	6.263042902	,	0.452998891	),
  (	68	,	6.158842883	,	0.500317708	),
  (	68	,	6.117757298	,	0.500809227	),
  (	68	,	6.176379409	,	0.561959196	),
  (	68	,	6.280938946	,	0.588591372	),
  (	68	,	6.275999522	,	0.611094119	),
  (	68	,	0.000930273	,	0.668530133	),
  (	68	,	6.257306533	,	0.685611168	),
  (	68	,	1.584489986	,	-0.643553561	),
  (	68	,	1.62527622	,	-0.638157084	),
  (	68	,	1.616749792	,	-0.607667322	),
  (	68	,	1.597389626	,	-0.579779568	),
  (	68	,	1.527841545	,	-0.572631686	),
  (	68	,	1.473937195	,	-0.605449912	),
  (	68	,	1.475304754	,	-0.47491727	),
  (	68	,	1.882113423	,	-0.38053853	),
  (	68	,	1.835147874	,	-0.360242298	),
  (	68	,	1.819631876	,	-0.33928417	),
  (	68	,	1.71010585	,	-0.315245064	),
  (	68	,	1.621926053	,	-0.317404217	),
  (	68	,	1.667225501	,	-0.273384329	),
  (	68	,	1.377637461	,	-0.399581146	),
  (	68	,	1.482417054	,	-0.356660051	),
  (	68	,	1.384796576	,	-0.310228715	),
  (	68	,	1.419544972	,	-0.219114071	),
  (	68	,	1.560125476	,	-0.315122262	),
  (	68	,	1.599761362	,	-0.288305076	),
  (	68	,	1.620374727	,	-0.275643172	),
  (	68	,	1.615637308	,	-0.26283568	),
  (	68	,	1.704113179	,	-0.210853584	),
  (	68	,	1.631671524	,	-0.126502208	),
  (	68	,	1.503399665	,	-0.119803324	),
  (	68	,	1.661737296	,	-0.080210853	),
  (	68	,	1.580170504	,	-0.089658061	),
  (	68	,	1.601066457	,	-0.058314138	),
  (	68	,	1.952912583	,	-0.322744867	),
  (	68	,	1.983041877	,	-0.242069638	),
  (	68	,	1.942170329	,	-0.25976084	),
  (	68	,	1.945757804	,	-0.247466506	),
  (	68	,	2.076835712	,	-0.220044427	),
  (	68	,	2.046833917	,	-0.19514465	),
  (	68	,	2.056612611	,	-0.164142494	),
  (	68	,	1.840588252	,	-0.189932861	),
  (	68	,	1.824488259	,	-0.18004267	),
  (	68	,	1.975807531	,	-0.035507948	),
  (	68	,	1.969121875	,	-0.019651203	),
  (	68	,	2.239172536	,	-0.091154143	),
  (	68	,	2.292437414	,	0.003450286	),
  (	68	,	2.206993766	,	0.027470764	),
  (	68	,	2.119680476	,	0.037787271	),
  (	68	,	1.781802981	,	-0.135343091	),
  (	68	,	1.807039453	,	-0.102139294	),
  (	68	,	1.841811841	,	-0.065534288	),
  (	68	,	1.798935636	,	-0.090298747	),
  (	68	,	1.792107552	,	-0.074459942	),
  (	68	,	1.88081278	,	-0.068034145	),
  (	68	,	1.890656034	,	-0.00452967	),
  (	68	,	1.686073582	,	-0.013556692	),
  (	68	,	1.683615491	,	0.014184043	),
  (	68	,	1.710096654	,	0.08626916	),
  (	68	,	1.674531017	,	0.080213162	),
  (	68	,	1.690637414	,	0.090328036	),
  (	68	,	1.729758434	,	0.106171743	),
  (	68	,	1.704091317	,	0.102398334	),
  (	68	,	1.985118315	,	0.057191365	),
  (	68	,	2.010690623	,	0.07105538	),
  (	68	,	2.021756684	,	0.086317978	),
  (	68	,	1.923037794	,	0.062511244	),
  (	68	,	1.960495458	,	0.114881633	),
  (	68	,	2.097045462	,	0.220640259	),
  (	68	,	1.837675256	,	0.205504711	),
  (	68	,	1.951067924	,	0.208653561	),
  (	68	,	1.9721675	,	0.220976631	),
  (	68	,	1.997744113	,	0.245067479	),
  (	68	,	1.1351269	,	-0.286885792	),
  (	68	,	1.350431397	,	-0.037261912	),
  (	68	,	1.434463192	,	0.028692259	),
  (	68	,	1.482736742	,	0.026035263	),
  (	68	,	1.315227229	,	-0.012166362	),
  (	68	,	1.232095858	,	-0.016232293	),
  (	68	,	1.400063071	,	0.051121384	),
  (	68	,	1.014535881	,	-0.08820756	),
  (	68	,	0.961619581	,	-0.056172745	),
  (	68	,	1.000601543	,	-0.025369031	),
  (	68	,	1.090041877	,	-0.062368643	),
  (	68	,	1.097495825	,	-0.007374165	),
  (	68	,	1.100230945	,	0.012840315	),
  (	68	,	1.012920704	,	-0.020051726	),
  (	68	,	0.981944742	,	0.045743115	),
  (	68	,	1.25357895	,	0.101021335	),
  (	68	,	1.265626164	,	0.146744078	),
  (	68	,	1.312096636	,	0.190473794	),
  (	68	,	1.088450565	,	0.117367405	),
  (	68	,	1.061058168	,	0.155031882	),
  (	68	,	1.176850541	,	0.183641428	),
  (	68	,	1.205704038	,	0.199185304	),
  (	68	,	1.148781776	,	0.198578304	),
  (	68	,	1.120549003	,	0.282991985	),
  (	68	,	1.613641013	,	0.050073957	),
  (	68	,	1.61615908	,	0.050647181	),
  (	68	,	1.610593155	,	0.131135417	),
  (	68	,	1.680824871	,	0.123668615	),
  (	68	,	1.687095474	,	0.228646241	),
  (	68	,	1.521876608	,	0.209389828	),
  (	68	,	1.572046314	,	0.220109609	),
  (	68	,	1.592495407	,	0.251102897	),
  (	68	,	1.553639263	,	0.242977093	),
  (	68	,	1.530903189	,	0.24518621	),
  (	68	,	1.572562522	,	0.284469451	),
  (	68	,	1.601037114	,	0.285652691	),
  (	68	,	1.833910685	,	0.271140343	),
  (	68	,	1.80930706	,	0.276422691	),
  (	68	,	1.753374873	,	0.248124879	),
  (	68	,	1.723053193	,	0.282843804	),
  (	68	,	1.728032829	,	0.293160005	),
  (	68	,	1.884000305	,	0.296288813	),
  (	68	,	1.80796976	,	0.369327935	),
  (	68	,	1.656619054	,	0.279482132	),
  (	68	,	1.691987995	,	0.362840364	),
  (	68	,	1.653294132	,	0.411954163	),
  (	68	,	1.766877929	,	0.398587292	),
  (	68	,	1.78522286	,	0.404949439	),
  (	68	,	1.797556591	,	0.447904929	),
  (	68	,	1.737977271	,	0.426735649	),
  (	68	,	1.353379825	,	0.236459215	),
  (	68	,	1.329490496	,	0.259335258	),
  (	68	,	1.436923692	,	0.320541295	),
  (	68	,	1.41883451	,	0.359253254	),
  (	68	,	1.209714606	,	0.323636384	),
  (	68	,	1.280933362	,	0.406935587	),
  (	68	,	1.569314966	,	0.377062836	),
  (	68	,	1.616606041	,	0.401388569	),
  (	68	,	1.456124813	,	0.571575416	),
  (	68	,	1.647436953	,	0.613474029	),
  (	68	,	1.518168455	,	0.613645111	),
  (	68	,	1.492014899	,	0.621884247	),
  (	68	,	3.168139227	,	-0.575305435	),
  (	68	,	3.339127614	,	-0.502062855	),
  (	68	,	3.462063709	,	-0.328583924	),
  (	68	,	3.445740438	,	-0.288244674	),
  (	68	,	3.185635906	,	-0.306090337	),
  (	68	,	3.238936407	,	-0.271495762	),
  (	68	,	3.297408864	,	-0.293668856	),
  (	68	,	3.012191823	,	-0.450270391	),
  (	68	,	2.893242346	,	-0.446366443	),
  (	68	,	3.041220337	,	-0.400513637	),
  (	68	,	2.993376479	,	-0.359232176	),
  (	68	,	2.99280018	,	-0.240006029	),
  (	68	,	2.948134681	,	-0.219783156	),
  (	68	,	3.243314775	,	-0.206161675	),
  (	68	,	2.96931829	,	-0.17967261	),
  (	68	,	3.517296486	,	-0.294229661	),
  (	68	,	3.665528543	,	-0.142453211	),
  (	68	,	3.64322289	,	-0.140657433	),
  (	68	,	3.614134633	,	-0.119336813	),
  (	68	,	3.501626929	,	-0.108265179	),
  (	68	,	3.790863566	,	-0.091079758	),
  (	68	,	3.872128745	,	0.035525305	),
  (	68	,	3.334383014	,	-0.049613134	),
  (	68	,	3.475054439	,	-0.024273306	),
  (	68	,	3.464295107	,	0.025414216	),
  (	68	,	3.265099492	,	0.076732316	),
  (	68	,	3.619321657	,	0.110717362	),
  (	68	,	3.629683502	,	0.176902273	),
  (	68	,	3.619799151	,	0.22707566	),
  (	68	,	3.556229728	,	0.218410114	),
  (	68	,	2.719608655	,	-0.233480356	),
  (	68	,	2.76289459	,	-0.233948877	),
  (	68	,	2.599448872	,	-0.154225617	),
  (	68	,	2.769998923	,	-0.068082185	),
  (	68	,	2.734845586	,	-0.076591158	),
  (	68	,	2.952260481	,	-0.069234658	),
  (	68	,	2.988736792	,	-0.038617773	),
  (	68	,	2.940360241	,	0.039587464	),
  (	68	,	2.991741284	,	0.057610314	),
  (	68	,	2.97333594	,	0.115801651	),
  (	68	,	2.655902913	,	0.020261768	),
  (	68	,	2.469916079	,	-0.021554232	),
  (	68	,	2.541150594	,	-0.004874455	),
  (	68	,	2.616755379	,	0.05907914	),
  (	68	,	2.604053261	,	0.07403211	),
  (	68	,	2.724546336	,	0.041767721	),
  (	68	,	2.755888279	,	0.049648167	),
  (	68	,	2.658344152	,	0.107702249	),
  (	68	,	2.736688537	,	0.197522316	),
  (	68	,	3.094103064	,	0.09044879	),
  (	68	,	2.975063499	,	0.160016156	),
  (	68	,	3.002114114	,	0.208968222	),
  (	68	,	3.225963415	,	0.253793472	),
  (	68	,	3.076966472	,	0.248941914	),
  (	68	,	3.476998427	,	0.296973706	),
  (	68	,	3.469584185	,	0.330198154	),
  (	68	,	3.330562911	,	0.455994601	),
  (	68	,	2.949337359	,	0.220146306	),
  (	68	,	2.809189034	,	0.319616635	),
  (	68	,	3.248260356	,	0.446495833	),
  (	68	,	3.246562335	,	0.451188201	),
  (	68	,	4.800877702	,	-0.618348365	),
  (	68	,	4.703427675	,	-0.628458058	),
  (	68	,	4.793965447	,	-0.446892271	),
  (	68	,	4.633778362	,	-0.584751857	),
  (	68	,	4.734973087	,	-0.425835615	),
  (	68	,	4.699841462	,	-0.417818932	),
  (	68	,	4.72382957	,	-0.36194047	),
  (	68	,	4.913385593	,	-0.479944737	),
  (	68	,	4.857426644	,	-0.420791922	),
  (	68	,	5.073113193	,	-0.360299416	),
  (	68	,	4.966245371	,	-0.356462611	),
  (	68	,	4.971557538	,	-0.336491736	),
  (	68	,	4.92876231	,	-0.334096964	),
  (	68	,	5.012313387	,	-0.330788399	),
  (	68	,	4.905011254	,	-0.337158699	),
  (	68	,	4.794074596	,	-0.324974388	),
  (	68	,	4.822577242	,	-0.243970004	),
  (	68	,	4.51182278	,	-0.485142252	),
  (	68	,	4.529165973	,	-0.423839283	),
  (	68	,	4.529661394	,	-0.420162475	),
  (	68	,	4.449445447	,	-0.318510757	),
  (	68	,	4.356678383	,	-0.318009761	),
  (	68	,	4.509980398	,	-0.27158214	),
  (	68	,	4.521556593	,	-0.265703192	),
  (	68	,	4.553582799	,	-0.279922788	),
  (	68	,	4.49737634	,	-0.221682759	),
  (	68	,	4.78930783	,	-0.269316822	),
  (	68	,	4.686760124	,	-0.197877745	),
  (	68	,	4.724481039	,	-0.09351831	),
  (	68	,	4.636410367	,	-0.084645304	),
  (	68	,	5.253529835	,	-0.130371704	),
  (	68	,	5.143146809	,	-0.177271233	),
  (	68	,	5.224698506	,	-0.116918521	),
  (	68	,	5.036444915	,	-0.152180218	),
  (	68	,	5.102278307	,	-0.122943713	),
  (	68	,	5.150270512	,	-0.095078232	),
  (	68	,	5.195894782	,	-0.081928049	),
  (	68	,	5.355791172	,	-0.036713864	),
  (	68	,	5.198669546	,	0.071359028	),
  (	68	,	5.249994871	,	0.082559549	),
  (	68	,	5.002922252	,	-0.023495905	),
  (	68	,	5.055007072	,	0.007394808	),
  (	68	,	4.992422238	,	0.058131089	),
  (	68	,	4.879572512	,	-0.019425441	),
  (	68	,	4.873399089	,	0.06614648	),
  (	68	,	5.109830189	,	0.035110648	),
  (	68	,	5.094988325	,	0.082201126	),
  (	68	,	5.166305815	,	0.166114055	),
  (	68	,	5.232501995	,	0.19731959	),
  (	68	,	5.187508177	,	0.203943931	),
  (	68	,	4.971086329	,	0.176993359	),
  (	68	,	4.94960442	,	0.188642046	),
  (	68	,	4.982086123	,	0.218879645	),
  (	68	,	5.128885395	,	0.272456189	),
  (	68	,	4.225680959	,	-0.176328337	),
  (	68	,	4.582942652	,	-0.076260572	),
  (	68	,	4.532787034	,	-0.049058552	),
  (	68	,	4.677859686	,	0.019392077	),
  (	68	,	4.466690494	,	-0.002549284	),
  (	68	,	4.506903584	,	0.006135237	),
  (	68	,	4.419872971	,	-0.000640991	),
  (	68	,	4.393351665	,	0.039141963	),
  (	68	,	4.233320083	,	0.027937757	),
  (	68	,	4.083251117	,	0.021424937	),
  (	68	,	3.987261168	,	-0.023647214	),
  (	68	,	4.007180972	,	0.016393641	),
  (	68	,	4.13402132	,	0.026978469	),
  (	68	,	4.385112654	,	0.106227168	),
  (	68	,	4.411860951	,	0.164121661	),
  (	68	,	4.25294649	,	0.137151682	),
  (	68	,	4.226348415	,	0.150324729	),
  (	68	,	4.224108604	,	0.17593329	),
  (	68	,	4.335257863	,	0.180970889	),
  (	68	,	4.744457954	,	0.043317042	),
  (	68	,	4.68827063	,	0.065135687	),
  (	68	,	4.651835023	,	0.096519257	),
  (	68	,	4.71292142	,	0.114387002	),
  (	68	,	4.60054214	,	0.229698409	),
  (	68	,	4.697722361	,	0.324848987	),
  (	68	,	4.880697204	,	0.263261364	),
  (	68	,	4.918914983	,	0.295108178	),
  (	68	,	5.012014593	,	0.294098428	),
  (	68	,	4.995466752	,	0.334133155	),
  (	68	,	4.817513971	,	0.356967263	),
  (	68	,	4.807541617	,	0.375380644	),
  (	68	,	4.802467237	,	0.397889064	),
  (	68	,	4.911008506	,	0.348540211	),
  (	68	,	4.872159833	,	0.385849001	),
  (	68	,	4.927229865	,	0.437144234	),
  (	68	,	4.888504428	,	0.456070264	),
  (	68	,	4.486633852	,	0.280890438	),
  (	68	,	4.433833431	,	0.268495629	),
  (	68	,	4.514112359	,	0.454687505	),
  (	68	,	4.520316975	,	0.473569169	),
  (	68	,	4.827263189	,	0.457759423	),
  (	68	,	4.878190474	,	0.49968725	),
  (	68	,	4.633965821	,	0.482504544	),
  (	68	,	4.672919598	,	0.523526095	),
  (	68	,	4.619998199	,	0.571407759	),
  (	68	,	4.704021326	,	0.569812648	),
  (	68	,	4.655172504	,	0.629841941	),
  (	68	,	4.659792553	,	0.638006646	),
  (	68	,	1.1468889	,	-1.446861273	),
  (	68	,	1.363242598	,	-1.423166231	),
  (	68	,	0.586071386	,	-1.332687966	),
  (	68	,	0.071033745	,	-1.393672817	),
  (	68	,	0.722663604	,	-1.243301996	),
  (	68	,	0.701069489	,	-1.208345354	),
  (	68	,	1.470646499	,	-1.286309393	),
  (	68	,	1.51757062	,	-1.268890682	),
  (	68	,	0.935569983	,	-1.147800221	),
  (	68	,	0.85164238	,	-1.124764844	),
  (	68	,	1.216586771	,	-1.088707213	),
  (	68	,	0.160718999	,	-1.331853745	),
  (	68	,	0.046488309	,	-1.278003921	),
  (	68	,	0.228677288	,	-1.213077681	),
  (	68	,	0.745564705	,	-1.178487715	),
  (	68	,	0.505301495	,	-0.961190883	),
  (	68	,	0.760730915	,	-1.12461356	),
  (	68	,	0.748737922	,	-1.10899696	),
  (	68	,	0.671360991	,	-1.064347424	),
  (	68	,	0.831886822	,	-1.008971279	),
  (	68	,	0.774991225	,	-0.960156717	),
  (	68	,	1.541324669	,	-1.079302051	),
  (	68	,	1.455499192	,	-0.996283655	),
  (	68	,	1.511753039	,	-0.928869413	),
  (	68	,	1.41679325	,	-0.913038193	),
  (	68	,	1.213547738	,	-1.015844675	),
  (	68	,	1.55735049	,	-0.768092604	),
  (	68	,	1.541915713	,	-0.749117128	),
  (	68	,	1.341425948	,	-0.782284049	),
  (	68	,	1.359598382	,	-0.65266978	),
  (	68	,	1.344975027	,	-0.623401751	),
  (	68	,	1.048328129	,	-0.899976982	),
  (	68	,	0.991903674	,	-0.885831563	),
  (	68	,	1.010974157	,	-0.825831348	),
  (	68	,	1.07957664	,	-0.74903745	),
  (	68	,	0.977852359	,	-0.709666207	),
  (	68	,	1.026510011	,	-0.676476773	),
  (	68	,	1.00629405	,	-0.635745252	),
  (	68	,	1.247165192	,	-0.593497322	),
  (	68	,	1.142146851	,	-0.659422644	),
  (	68	,	1.113448782	,	-0.649208006	),
  (	68	,	1.273682711	,	-0.597576268	),
  (	68	,	1.289377105	,	-0.449031328	),
  (	68	,	1.06274878	,	-0.451131523	),
  (	68	,	1.201217007	,	-0.428180885	),
  (	68	,	0.411117304	,	-0.994859767	),
  (	68	,	0.0621555	,	-0.961150407	),
  (	68	,	0.355226939	,	-0.889017834	),
  (	68	,	0.429835849	,	-0.749235638	),
  (	68	,	0.624434055	,	-0.655831307	),
  (	68	,	0.33247929	,	-0.733210458	),
  (	68	,	0.268640155	,	-0.666984215	),
  (	68	,	0.052058757	,	-0.736047995	),
  (	68	,	0.099502463	,	-0.685261629	),
  (	68	,	0.133039691	,	-0.68973787	),
  (	68	,	0.174422802	,	-0.592752224	),
  (	68	,	0.433535824	,	-0.585816072	),
  (	68	,	0.358467311	,	-0.646672717	),
  (	68	,	0.508667403	,	-0.560918784	),
  (	68	,	0.399246769	,	-0.523333348	),
  (	68	,	0.520669169	,	-0.461327876	),
  (	68	,	0.383932568	,	-0.384616359	),
  (	68	,	0.771466488	,	-0.617458703	),
  (	68	,	0.889002329	,	-0.570846028	),
  (	68	,	0.664061992	,	-0.569088196	),
  (	68	,	0.698309366	,	-0.53466625	),
  (	68	,	0.765741507	,	-0.44165735	),
  (	68	,	0.756179415	,	-0.385558593	),
  (	68	,	1.01019327	,	-0.371433163	),
  (	68	,	1.114591964	,	-0.287022229	),
  (	68	,	0.654170542	,	-0.395896793	),
  (	68	,	0.616228969	,	-0.347588782	),
  (	68	,	0.469703199	,	-0.363822299	),
  (	68	,	0.574038502	,	-0.309672997	),
  (	68	,	0.629011162	,	-0.283690153	),
  (	68	,	0.571889907	,	-0.263040568	),
  (	68	,	0.700072193	,	-0.252184774	),
  (	68	,	0.777585482	,	-0.209542503	),
  (	68	,	0.715265447	,	-0.138106628	),
  (	68	,	2.165393105	,	-1.510704185	),
  (	68	,	2.635927292	,	-1.423580052	),
  (	68	,	2.788276329	,	-1.311745322	),
  (	68	,	2.039856828	,	-1.424121295	),
  (	68	,	1.719323716	,	-1.355913305	),
  (	68	,	1.986912901	,	-1.296345771	),
  (	68	,	2.214647269	,	-1.315249218	),
  (	68	,	2.356612368	,	-1.298521296	),
  (	68	,	2.252975217	,	-1.233539489	),
  (	68	,	3.135404987	,	-1.358310689	),
  (	68	,	3.035717995	,	-1.271325808	),
  (	68	,	2.892491341	,	-1.260864617	),
  (	68	,	3.042287475	,	-1.216044831	),
  (	68	,	2.795583886	,	-1.12840973	),
  (	68	,	2.839065892	,	-1.069354791	),
  (	68	,	2.596562753	,	-1.207572287	),
  (	68	,	2.694462266	,	-1.141960638	),
  (	68	,	2.605972018	,	-1.125541007	),
  (	68	,	2.703855619	,	-1.032293916	),
  (	68	,	2.558829272	,	-1.035898345	),
  (	68	,	2.654217329	,	-1.015758536	),
  (	68	,	1.616351217	,	-1.345744104	),
  (	68	,	1.636677579	,	-1.251442643	),
  (	68	,	1.991074035	,	-1.205262313	),
  (	68	,	2.084592474	,	-1.063366018	),
  (	68	,	2.445773838	,	-1.081981883	),
  (	68	,	2.284235089	,	-1.076681003	),
  (	68	,	2.291145476	,	-1.024932311	),
  (	68	,	2.38809132	,	-1.002928274	),
  (	68	,	2.534799792	,	-0.959641313	),
  (	68	,	2.522232253	,	-0.946300861	),
  (	68	,	2.473922401	,	-0.849870207	),
  (	68	,	2.293920527	,	-0.974836213	),
  (	68	,	2.323082486	,	-0.965892804	),
  (	68	,	2.103098394	,	-0.954030522	),
  (	68	,	2.181489794	,	-0.906550395	),
  (	68	,	2.161677427	,	-0.908630485	),
  (	68	,	2.409549444	,	-0.800206432	),
  (	68	,	2.303888099	,	-0.865252095	),
  (	68	,	2.324760838	,	-0.827187709	),
  (	68	,	2.272810609	,	-0.84169339	),
  (	68	,	2.279711336	,	-0.829409113	),
  (	68	,	3.057015372	,	-1.092019303	),
  (	68	,	3.043695806	,	-1.062961032	),
  (	68	,	3.021767218	,	-1.042273138	),
  (	68	,	2.893328874	,	-1.063092527	),
  (	68	,	2.840419783	,	-1.046452599	),
  (	68	,	2.870206096	,	-1.042523092	),
  (	68	,	2.927406049	,	-1.020235859	),
  (	68	,	2.98426793	,	-1.010206137	),
  (	68	,	3.094516643	,	-1.006907297	),
  (	68	,	3.138946756	,	-0.997770726	),
  (	68	,	3.004745848	,	-0.957902443	),
  (	68	,	2.89745507	,	-0.945929498	),
  (	68	,	2.978088005	,	-0.931479481	),
  (	68	,	2.79877927	,	-0.978583207	),
  (	68	,	2.844770032	,	-0.96234441	),
  (	68	,	2.687564082	,	-0.968998504	),
  (	68	,	2.701081506	,	-0.885162052	),
  (	68	,	2.883409296	,	-0.90888088	),
  (	68	,	2.895942144	,	-0.896270658	),
  (	68	,	3.12889818	,	-0.90932316	),
  (	68	,	3.108012575	,	-0.895614671	),
  (	68	,	3.129953917	,	-0.861497602	),
  (	68	,	3.139802124	,	-0.813902725	),
  (	68	,	2.904930521	,	-0.828024664	),
  (	68	,	2.853321997	,	-0.6362917	),
  (	68	,	3.023129917	,	-0.631973395	),
  (	68	,	2.95104063	,	-0.605068628	),
  (	68	,	2.622252921	,	-0.881001697	),
  (	68	,	2.657665728	,	-0.843103885	),
  (	68	,	2.570643901	,	-0.758916835	),
  (	68	,	2.68349862	,	-0.776109298	),
  (	68	,	2.64074631	,	-0.736045719	),
  (	68	,	2.680078567	,	-0.682490628	),
  (	68	,	2.664649687	,	-0.679122049	),
  (	68	,	2.471427767	,	-0.737421606	),
  (	68	,	2.454835146	,	-0.694202461	),
  (	68	,	2.524955091	,	-0.691402188	),
  (	68	,	2.812859496	,	-0.644563734	),
  (	68	,	2.799092896	,	-0.623626345	),
  (	68	,	2.849343014	,	-0.619400711	),
  (	68	,	2.908792245	,	-0.501394762	),
  (	68	,	2.806922319	,	-0.554316314	),
  (	68	,	2.777641756	,	-0.502161552	),
  (	68	,	2.641739118	,	-0.608817465	),
  (	68	,	2.669559594	,	-0.599247328	),
  (	68	,	2.630303105	,	-0.533675408	),
  (	68	,	2.718299709	,	-0.424705265	),
  (	68	,	1.937977653	,	-1.020860407	),
  (	68	,	1.916821319	,	-1.013194728	),
  (	68	,	2.016700384	,	-0.963054022	),
  (	68	,	2.010925635	,	-0.954813679	),
  (	68	,	1.991576663	,	-0.945746848	),
  (	68	,	2.03742897	,	-0.913629501	),
  (	68	,	1.921445376	,	-0.912951792	),
  (	68	,	2.021770113	,	-0.91041772	),
  (	68	,	2.025470053	,	-0.880618604	),
  (	68	,	1.801107833	,	-0.944053418	),
  (	68	,	1.668157358	,	-0.930867114	),
  (	68	,	1.679032557	,	-0.921641738	),
  (	68	,	1.769041064	,	-0.911077626	),
  (	68	,	1.923488576	,	-0.89717561	),
  (	68	,	1.925834965	,	-0.846954033	),
  (	68	,	1.834313286	,	-0.857571088	),
  (	68	,	2.169994044	,	-0.83636201	),
  (	68	,	2.258742712	,	-0.807785026	),
  (	68	,	2.283282317	,	-0.678584333	),
  (	68	,	2.24356244	,	-0.644127072	),
  (	68	,	2.102485581	,	-0.778414678	),
  (	68	,	2.06837456	,	-0.727852507	),
  (	68	,	1.98465845	,	-0.773112363	),
  (	68	,	2.038194552	,	-0.724376099	),
  (	68	,	1.666068832	,	-0.894266193	),
  (	68	,	1.658551944	,	-0.850724783	),
  (	68	,	1.668475613	,	-0.802157868	),
  (	68	,	1.733690553	,	-0.758367153	),
  (	68	,	1.823918738	,	-0.804522663	),
  (	68	,	1.788796877	,	-0.793266588	),
  (	68	,	1.840360074	,	-0.713783333	),
  (	68	,	1.604756325	,	-0.780670568	),
  (	68	,	1.677274155	,	-0.747736056	),
  (	68	,	1.674443121	,	-0.646025777	),
  (	68	,	1.745114177	,	-0.666004296	),
  (	68	,	1.722301714	,	-0.593572008	),
  (	68	,	1.786911375	,	-0.567969314	),
  (	68	,	1.757213958	,	-0.5709441	),
  (	68	,	1.96484314	,	-0.715399061	),
  (	68	,	1.96657367	,	-0.65168841	),
  (	68	,	1.997292043	,	-0.615699991	),
  (	68	,	1.95888953	,	-0.60944008	),
  (	68	,	1.998226461	,	-0.5608012	),
  (	68	,	2.064841399	,	-0.609791713	),
  (	68	,	2.016338989	,	-0.52684981	),
  (	68	,	2.102911229	,	-0.474987378	),
  (	68	,	1.807875507	,	-0.555042762	),
  (	68	,	1.885346365	,	-0.477084258	),
  (	68	,	1.839402614	,	-0.475129559	),
  (	68	,	1.98039018	,	-0.498598477	),
  (	68	,	2.042937999	,	-0.428952066	),
  (	68	,	1.991988742	,	-0.442139775	),
  (	68	,	1.922224295	,	-0.466002156	),
  (	68	,	2.45942233	,	-0.5794564	),
  (	68	,	2.538889748	,	-0.528892647	),
  (	68	,	2.490016215	,	-0.502073806	),
  (	68	,	2.304895321	,	-0.499842283	),
  (	68	,	2.204258481	,	-0.557460515	),
  (	68	,	2.568728152	,	-0.461014626	),
  (	68	,	2.610282161	,	-0.438620375	),
  (	68	,	2.488115112	,	-0.423659814	),
  (	68	,	2.546040701	,	-0.355451962	),
  (	68	,	2.649098504	,	-0.370981531	),
  (	68	,	2.648085812	,	-0.304457942	),
  (	68	,	2.526362359	,	-0.307598217	),
  (	68	,	2.581725297	,	-0.197934129	),
  (	68	,	2.298421512	,	-0.327386828	),
  (	68	,	2.240821831	,	-0.28116541	),
  (	68	,	2.050685679	,	-0.415358289	),
  (	68	,	2.078519342	,	-0.357152894	),
  (	68	,	2.114211989	,	-0.308322914	),
  (	68	,	1.981890014	,	-0.351463702	),
  (	68	,	2.055579442	,	-0.318473193	),
  (	68	,	2.126096366	,	-0.303138426	),
  (	68	,	2.203354192	,	-0.266930533	),
  (	68	,	2.203506024	,	-0.222787292	),
  (	68	,	2.372555586	,	-0.305374812	),
  (	68	,	2.258283704	,	-0.219658754	),
  (	68	,	2.336531836	,	-0.139125939	),
  (	68	,	2.372439109	,	-0.090256876	),
  (	68	,	2.347357297	,	-0.08481586	),
  (	68	,	4.520013377	,	-1.528338618	),
  (	68	,	4.389064642	,	-1.452812468	),
  (	68	,	3.964077102	,	-1.401742647	),
  (	68	,	4.192188662	,	-1.264720518	),
  (	68	,	3.889911442	,	-1.307829822	),
  (	68	,	3.958133645	,	-1.254979012	),
  (	68	,	4.064219583	,	-1.240270002	),
  (	68	,	3.996689842	,	-1.228956153	),
  (	68	,	3.968907717	,	-1.199419171	),
  (	68	,	4.366780062	,	-1.261862811	),
  (	68	,	4.470490751	,	-1.191690716	),
  (	68	,	4.434350803	,	-1.075833001	),
  (	68	,	4.389269308	,	-1.076236376	),
  (	68	,	4.002185584	,	-1.153527944	),
  (	68	,	4.110378435	,	-1.120157684	),
  (	68	,	4.226094603	,	-1.09924256	),
  (	68	,	4.374884151	,	-1.078352363	),
  (	68	,	4.140542548	,	-1.053606003	),
  (	68	,	4.224066338	,	-1.029237211	),
  (	68	,	4.228718204	,	-0.978396233	),
  (	68	,	3.610942696	,	-1.243219905	),
  (	68	,	3.577955712	,	-1.2354811	),
  (	68	,	3.238650592	,	-1.282883138	),
  (	68	,	3.168567809	,	-1.283808359	),
  (	68	,	3.837661865	,	-1.190374486	),
  (	68	,	3.767878885	,	-1.163177369	),
  (	68	,	3.392194098	,	-1.186139921	),
  (	68	,	3.653631183	,	-1.090643189	),
  (	68	,	3.96518546	,	-1.075713061	),
  (	68	,	3.934143632	,	-0.981925969	),
  (	68	,	4.017369084	,	-0.979700208	),
  (	68	,	3.980043958	,	-0.90943679	),
  (	68	,	3.914034677	,	-0.897926293	),
  (	68	,	3.91134701	,	-0.780236535	),
  (	68	,	4.579226491	,	-1.077982138	),
  (	68	,	4.639589031	,	-1.007474089	),
  (	68	,	4.681256236	,	-0.980088845	),
  (	68	,	4.335392422	,	-0.928525098	),
  (	68	,	4.398632586	,	-0.801892988	),
  (	68	,	4.336589687	,	-0.839700018	),
  (	68	,	4.646098864	,	-0.832785245	),
  (	68	,	4.563954637	,	-0.868038674	),
  (	68	,	4.537224575	,	-0.847371118	),
  (	68	,	4.558440803	,	-0.785537339	),
  (	68	,	4.535667179	,	-0.796568088	),
  (	68	,	4.54996241	,	-0.796119628	),
  (	68	,	4.547526473	,	-0.717703873	),
  (	68	,	4.431336501	,	-0.756008699	),
  (	68	,	4.441151739	,	-0.682697756	),
  (	68	,	4.13690379	,	-0.882958469	),
  (	68	,	4.170106175	,	-0.777239018	),
  (	68	,	4.154838581	,	-0.790360626	),
  (	68	,	4.238135691	,	-0.791224973	),
  (	68	,	4.181800802	,	-0.769359689	),
  (	68	,	4.168120549	,	-0.743604208	),
  (	68	,	4.18863282	,	-0.709531755	),
  (	68	,	4.036887381	,	-0.824100218	),
  (	68	,	4.067629047	,	-0.78657684	),
  (	68	,	3.998864434	,	-0.776739335	),
  (	68	,	4.132388053	,	-0.619775424	),
  (	68	,	4.034759941	,	-0.626872012	),
  (	68	,	4.364263459	,	-0.58893755	),
  (	68	,	4.400022332	,	-0.544608831	),
  (	68	,	4.470079192	,	-0.498894392	),
  (	68	,	4.370420151	,	-0.485375179	),
  (	68	,	4.188428836	,	-0.58268612	),
  (	68	,	4.296412432	,	-0.518435134	),
  (	68	,	4.18827022	,	-0.543996368	),
  (	68	,	4.40582384	,	-0.430065437	),
  (	68	,	4.299637805	,	-0.409460418	),
  (	68	,	3.273910983	,	-1.064474567	),
  (	68	,	3.360613175	,	-1.054188792	),
  (	68	,	3.377196304	,	-1.053051822	),
  (	68	,	3.165053835	,	-1.099133555	),
  (	68	,	3.281852298	,	-0.979644368	),
  (	68	,	3.325318077	,	-0.955755773	),
  (	68	,	3.240978462	,	-0.912687533	),
  (	68	,	3.299563866	,	-0.91486316	),
  (	68	,	3.482297868	,	-0.768913925	),
  (	68	,	3.649667238	,	-0.90819317	),
  (	68	,	3.69874672	,	-0.870340752	),
  (	68	,	3.713353378	,	-0.851422443	),
  (	68	,	3.65122635	,	-0.809589083	),
  (	68	,	3.72145296	,	-0.726805241	),
  (	68	,	3.549502916	,	-0.757872045	),
  (	68	,	3.615880441	,	-0.64799643	),
  (	68	,	3.220936924	,	-0.912917037	),
  (	68	,	3.236607766	,	-0.871773469	),
  (	68	,	3.395446198	,	-0.821438939	),
  (	68	,	3.233699858	,	-0.742847475	),
  (	68	,	3.287673459	,	-0.722813864	),
  (	68	,	3.709765428	,	-0.534439773	),
  (	68	,	3.458942004	,	-0.556332228	),
  (	68	,	3.563973816	,	-0.462475261	),
  (	68	,	3.53303232	,	-0.406334257	),
  (	68	,	4.027135466	,	-0.465806169	),
  (	68	,	3.832801014	,	-0.615696764	),
  (	68	,	3.902312412	,	-0.494769721	),
  (	68	,	3.969988263	,	-0.418637352	),
  (	68	,	4.14767996	,	-0.45884396	),
  (	68	,	4.248431228	,	-0.373498803	),
  (	68	,	4.094615508	,	-0.347562974	),
  (	68	,	3.980218829	,	-0.333474085	),
  (	68	,	4.056045038	,	-0.304400906	),
  (	68	,	4.176080058	,	-0.279857405	),
  (	68	,	4.115258163	,	-0.227886865	),
  (	68	,	3.609420628	,	-0.336079169	),
  (	68	,	3.64056215	,	-0.299850605	),
  (	68	,	3.786286329	,	-0.233167491	),
  (	68	,	4.067918179	,	-0.1821966	),
  (	68	,	3.85469535	,	-0.169296141	),
  (	68	,	4.016914685	,	-0.089357475	),
  (	68	,	5.734994179	,	-1.484114115	),
  (	68	,	5.934152629	,	-1.453019593	),
  (	68	,	5.976425628	,	-1.34479516	),
  (	68	,	5.806325363	,	-1.324384911	),
  (	68	,	5.240071782	,	-1.291766068	),
  (	68	,	5.53613916	,	-1.330160644	),
  (	68	,	5.316491342	,	-1.273734249	),
  (	68	,	5.395683695	,	-1.240433944	),
  (	68	,	5.489915622	,	-1.206832696	),
  (	68	,	6.230529319	,	-1.161818903	),
  (	68	,	5.967247216	,	-1.144243087	),
  (	68	,	5.794033669	,	-1.226715607	),
  (	68	,	4.974084991	,	-1.255464111	),
  (	68	,	5.096811068	,	-1.215295828	),
  (	68	,	5.310872381	,	-1.17732686	),
  (	68	,	5.14211896	,	-1.15041971	),
  (	68	,	5.033329333	,	-1.098214993	),
  (	68	,	5.222728426	,	-1.01099785	),
  (	68	,	5.57966749	,	-1.070859785	),
  (	68	,	5.532060814	,	-0.94626653	),
  (	68	,	5.313352131	,	-0.906126268	),
  (	68	,	5.51627348	,	-0.880264859	),
  (	68	,	5.575780703	,	-0.850304727	),
  (	68	,	5.438675155	,	-0.886725864	),
  (	68	,	5.507451451	,	-0.750542676	),
  (	68	,	6.255529548	,	-1.150984372	),
  (	68	,	6.238451666	,	-1.09676013	),
  (	68	,	6.067001906	,	-1.057051085	),
  (	68	,	6.012639649	,	-1.031311881	),
  (	68	,	6.174248127	,	-0.99179102	),
  (	68	,	6.123342456	,	-0.969591159	),
  (	68	,	6.149155505	,	-0.951227478	),
  (	68	,	5.9303664	,	-0.919649359	),
  (	68	,	5.960922005	,	-0.854847549	),
  (	68	,	6.000691248	,	-0.846333959	),
  (	68	,	5.858799987	,	-0.801945095	),
  (	68	,	6.279532024	,	-0.737169793	),
  (	68	,	6.160405049	,	-0.728715808	),
  (	68	,	5.968081921	,	-0.667110915	),
  (	68	,	6.032598854	,	-0.635668131	),
  (	68	,	5.716095678	,	-0.832961778	),
  (	68	,	5.685602452	,	-0.759157681	),
  (	68	,	5.86718229	,	-0.723274352	),
  (	68	,	5.75340477	,	-0.769043612	),
  (	68	,	5.814121661	,	-0.701685032	),
  (	68	,	5.540262684	,	-0.771607471	),
  (	68	,	5.929432352	,	-0.671558449	),
  (	68	,	5.898147398	,	-0.61593484	),
  (	68	,	5.810349384	,	-0.601531879	),
  (	68	,	5.770707741	,	-0.560836808	),
  (	68	,	5.077232304	,	-0.941538356	),
  (	68	,	4.862578287	,	-0.944018472	),
  (	68	,	4.892806874	,	-0.880919383	),
  (	68	,	5.236606173	,	-0.876445755	),
  (	68	,	5.34978541	,	-0.814373335	),
  (	68	,	5.247348476	,	-0.788819423	),
  (	68	,	5.285133949	,	-0.762051149	),
  (	68	,	5.32431313	,	-0.603631758	),
  (	68	,	4.880495802	,	-0.850341429	),
  (	68	,	4.847368961	,	-0.838019046	),
  (	68	,	4.89011219	,	-0.820778893	),
  (	68	,	4.779779098	,	-0.85261798	),
  (	68	,	5.02726038	,	-0.655949486	),
  (	68	,	4.772565634	,	-0.808313597	),
  (	68	,	4.805064135	,	-0.68106084	),
  (	68	,	4.910100591	,	-0.625825468	),
  (	68	,	4.927446119	,	-0.606501066	),
  (	68	,	5.133892449	,	-0.570563202	),
  (	68	,	5.172308356	,	-0.539361055	),
  (	68	,	5.063358115	,	-0.55532086	),
  (	68	,	5.012503125	,	-0.437716812	),
  (	68	,	5.159098068	,	-0.433879924	),
  (	68	,	5.12500997	,	-0.416415683	),
  (	68	,	5.535698797	,	-0.650008304	),
  (	68	,	5.592989096	,	-0.509046723	),
  (	68	,	5.357012911	,	-0.538808761	),
  (	68	,	5.680042518	,	-0.438103453	),
  (	68	,	5.604022722	,	-0.426256382	),
  (	68	,	5.745481232	,	-0.312362572	),
  (	68	,	5.526977339	,	-0.352214296	),
  (	68	,	5.695741376	,	-0.223111607	),
  (	68	,	5.366352601	,	-0.324403065	),
  (	68	,	5.362579361	,	-0.311999001	),
  (	68	,	5.234100941	,	-0.387661831	),
  (	68	,	5.273021596	,	-0.262373713	),
  (	68	,	5.502756612	,	-0.236142329	),
  (	68	,	5.536860625	,	-0.097428243	),
  (	68	,	5.471966029	,	-0.079274494	),
  (	69	,	0.758223158	,	0.162938039	),
  (	69	,	0.694025789	,	0.185642798	),
  (	69	,	0.73299667	,	0.270662838	),
  (	69	,	0.988023019	,	0.235775726	),
  (	69	,	0.956809406	,	0.242440298	),
  (	69	,	1.067525489	,	0.30574151	),
  (	69	,	1.141188077	,	0.321443579	),
  (	69	,	1.141142533	,	0.367210768	),
  (	69	,	0.827189517	,	0.338256738	),
  (	69	,	0.892628796	,	0.384673849	),
  (	69	,	0.985300343	,	0.403988379	),
  (	69	,	1.051331382	,	0.404938648	),
  (	69	,	1.013103287	,	0.439158634	),
  (	69	,	0.965633232	,	0.500955958	),
  (	69	,	0.670255605	,	0.329520004	),
  (	69	,	0.487754295	,	0.319206061	),
  (	69	,	0.413725686	,	0.352075682	),
  (	69	,	0.430321284	,	0.37346882	),
  (	69	,	0.601946317	,	0.506271455	),
  (	69	,	1.198860499	,	0.396052186	),
  (	69	,	1.238747426	,	0.400453654	),
  (	69	,	1.358995411	,	0.537653956	),
  (	69	,	1.223387523	,	0.523109566	),
  (	69	,	1.274854954	,	0.543904553	),
  (	69	,	1.10380656	,	0.567801	),
  (	69	,	1.207036084	,	0.644941141	),
  (	69	,	1.188083041	,	0.646525684	),
  (	69	,	1.372949391	,	0.548061861	),
  (	69	,	1.48184223	,	0.663031102	),
  (	69	,	1.478001905	,	0.730227622	),
  (	69	,	1.391562482	,	0.717248176	),
  (	69	,	1.280982686	,	0.642379312	),
  (	69	,	1.241779869	,	0.667675709	),
  (	69	,	1.307738542	,	0.730827056	),
  (	69	,	1.380779055	,	0.810112918	),
  (	69	,	1.015185323	,	0.565633911	),
  (	69	,	0.970669812	,	0.574885815	),
  (	69	,	1.00453567	,	0.607715831	),
  (	69	,	1.047956768	,	0.698371742	),
  (	69	,	1.03528935	,	0.730953355	),
  (	69	,	0.955331786	,	0.742417172	),
  (	69	,	0.984010649	,	0.733155369	),
  (	69	,	0.953165812	,	0.858799117	),
  (	69	,	1.028053708	,	0.911543169	),
  (	69	,	1.192762633	,	0.751041447	),
  (	69	,	1.166818254	,	0.817705161	),
  (	69	,	1.243185709	,	0.913499461	),
  (	69	,	1.500878308	,	0.957569733	),
  (	69	,	1.401886482	,	0.946888778	),
  (	69	,	1.122269265	,	0.887775544	),
  (	69	,	1.152927762	,	0.906472074	),
  (	69	,	1.255879299	,	0.930269587	),
  (	69	,	1.295139891	,	0.974311809	),
  (	69	,	1.439282491	,	1.051883915	),
  (	69	,	1.485636938	,	1.081212833	),
  (	69	,	1.510625209	,	1.130432325	),
  (	69	,	0.390055553	,	0.441138832	),
  (	69	,	0.577590486	,	0.528888552	),
  (	69	,	0.505313648	,	0.529784426	),
  (	69	,	0.233945232	,	0.514680575	),
  (	69	,	0.414372058	,	0.577999456	),
  (	69	,	0.404894575	,	0.625566807	),
  (	69	,	0.672557856	,	0.676052776	),
  (	69	,	0.549905237	,	0.724883483	),
  (	69	,	0.508485231	,	0.731154159	),
  (	69	,	0.436634801	,	0.710062578	),
  (	69	,	0.588059557	,	0.814847961	),
  (	69	,	0.230641938	,	0.702424065	),
  (	69	,	0.063548922	,	0.716157839	),
  (	69	,	0.026488734	,	0.705436241	),
  (	69	,	0.118716517	,	0.872414859	),
  (	69	,	0.426505686	,	0.844963388	),
  (	69	,	0.452055494	,	0.89912154	),
  (	69	,	0.452243048	,	0.923030503	),
  (	69	,	0.339285613	,	0.988405743	),
  (	69	,	0.186021185	,	0.913455099	),
  (	69	,	0.0529528	,	0.93591253	),
  (	69	,	0.08976069	,	0.987102577	),
  (	69	,	0.048559418	,	1.005100551	),
  (	69	,	0.291907123	,	1.044728662	),
  (	69	,	0.196526697	,	1.09132992	),
  (	69	,	0.780268216	,	0.756848553	),
  (	69	,	0.797937771	,	0.82222691	),
  (	69	,	0.738184129	,	0.824106178	),
  (	69	,	0.90604595	,	0.865678775	),
  (	69	,	1.001205852	,	0.919009936	),
  (	69	,	0.985426692	,	0.961041398	),
  (	69	,	0.836519299	,	0.910421253	),
  (	69	,	0.965171422	,	1.027029833	),
  (	69	,	0.660820393	,	1.012722765	),
  (	69	,	0.613986248	,	0.975797326	),
  (	69	,	0.78447878	,	1.069711285	),
  (	69	,	0.752198672	,	1.106696126	),
  (	69	,	0.77656297	,	1.124327657	),
  (	69	,	1.214100002	,	1.062627345	),
  (	69	,	1.266098522	,	1.110466999	),
  (	69	,	1.298209497	,	1.139316787	),
  (	69	,	1.270696696	,	1.189769477	),
  (	69	,	1.453198202	,	1.187027146	),
  (	69	,	1.478039067	,	1.228087919	),
  (	69	,	1.12507129	,	1.170912587	),
  (	69	,	1.177515574	,	1.210875791	),
  (	69	,	1.49666961	,	1.291297215	),
  (	69	,	0.438588138	,	1.030663906	),
  (	69	,	0.416279337	,	1.100987388	),
  (	69	,	0.650388092	,	1.176385357	),
  (	69	,	0.403792841	,	1.222067905	),
  (	69	,	0.254001219	,	1.230393167	),
  (	69	,	0.164769612	,	1.272255052	),
  (	69	,	1.038663692	,	1.26928313	),
  (	69	,	1.088070663	,	1.284050525	),
  (	69	,	1.423234676	,	1.368592977	),
  (	69	,	0.514355048	,	1.314859448	),
  (	69	,	0.500453597	,	1.364781405	),
  (	69	,	0.854127357	,	1.398531406	),
  (	69	,	0.569437421	,	1.42212758	),
  (	69	,	0.687015262	,	1.46319048	),
  (	69	,	2.336273333	,	0.097142549	),
  (	69	,	2.288642755	,	0.092256766	),
  (	69	,	2.312373685	,	0.114268031	),
  (	69	,	2.311744688	,	0.122430082	),
  (	69	,	2.459480547	,	0.09109713	),
  (	69	,	2.536152169	,	0.156994461	),
  (	69	,	2.245163433	,	0.096062197	),
  (	69	,	2.306707732	,	0.218985338	),
  (	69	,	2.408325002	,	0.314926596	),
  (	69	,	2.109558941	,	0.21259709	),
  (	69	,	2.192703999	,	0.282086534	),
  (	69	,	2.177929053	,	0.281377869	),
  (	69	,	2.315497844	,	0.314219811	),
  (	69	,	2.292883385	,	0.328427337	),
  (	69	,	2.27206539	,	0.344165528	),
  (	69	,	1.996254067	,	0.330167476	),
  (	69	,	2.356039781	,	0.461371629	),
  (	69	,	2.33408916	,	0.457211562	),
  (	69	,	2.44021273	,	0.458177768	),
  (	69	,	2.432983856	,	0.478606851	),
  (	69	,	2.268659285	,	0.571194032	),
  (	69	,	2.221857323	,	0.570588081	),
  (	69	,	2.573399357	,	0.542391039	),
  (	69	,	2.729296251	,	0.631885861	),
  (	69	,	2.751510523	,	0.633083939	),
  (	69	,	2.937928719	,	0.583695729	),
  (	69	,	2.961854756	,	0.619406352	),
  (	69	,	3.070122304	,	0.728193033	),
  (	69	,	3.01271634	,	0.76059674	),
  (	69	,	2.882848896	,	0.745802413	),
  (	69	,	3.001265018	,	0.788628752	),
  (	69	,	2.572072506	,	0.641360742	),
  (	69	,	2.575369514	,	0.691704528	),
  (	69	,	2.63495828	,	0.663566753	),
  (	69	,	2.448942364	,	0.692308645	),
  (	69	,	2.510546874	,	0.697492354	),
  (	69	,	2.548677538	,	0.733915713	),
  (	69	,	2.600971513	,	0.912261731	),
  (	69	,	2.815836182	,	0.795282634	),
  (	69	,	2.845623767	,	0.877289573	),
  (	69	,	2.889794129	,	1.023919078	),
  (	69	,	2.955931252	,	1.051940886	),
  (	69	,	1.895613228	,	0.431289179	),
  (	69	,	1.983246377	,	0.500675308	),
  (	69	,	2.06538361	,	0.489598073	),
  (	69	,	2.017260269	,	0.526527483	),
  (	69	,	2.055137862	,	0.551755379	),
  (	69	,	1.88277208	,	0.460868045	),
  (	69	,	1.857846717	,	0.547916047	),
  (	69	,	1.889621989	,	0.557901814	),
  (	69	,	2.028673054	,	0.690305845	),
  (	69	,	2.159042431	,	0.751098126	),
  (	69	,	1.806966985	,	0.567429228	),
  (	69	,	1.850310039	,	0.63378893	),
  (	69	,	1.70835517	,	0.648877689	),
  (	69	,	1.720559504	,	0.664550738	),
  (	69	,	1.885031475	,	0.765201209	),
  (	69	,	1.746872959	,	0.715055781	),
  (	69	,	1.590443234	,	0.772471953	),
  (	69	,	1.766171418	,	0.776765499	),
  (	69	,	1.619941113	,	0.836127764	),
  (	69	,	1.950298247	,	0.755000519	),
  (	69	,	1.955395103	,	0.811950794	),
  (	69	,	1.957927193	,	0.836365866	),
  (	69	,	1.857300429	,	0.920803467	),
  (	69	,	1.831461605	,	0.917559902	),
  (	69	,	1.837948152	,	0.957425809	),
  (	69	,	1.738050405	,	0.99818183	),
  (	69	,	1.729621437	,	1.041339776	),
  (	69	,	1.763160786	,	1.098908796	),
  (	69	,	2.341196183	,	0.798734246	),
  (	69	,	2.440207426	,	0.819321369	),
  (	69	,	2.369488418	,	0.871759895	),
  (	69	,	2.37935518	,	0.88703409	),
  (	69	,	2.143101031	,	0.929293105	),
  (	69	,	2.135759957	,	0.964392902	),
  (	69	,	2.242386371	,	1.022885741	),
  (	69	,	2.344919394	,	1.016110523	),
  (	69	,	2.78523911	,	1.049346538	),
  (	69	,	2.688026865	,	1.04982212	),
  (	69	,	3.114167311	,	1.28727781	),
  (	69	,	1.972379422	,	1.077862298	),
  (	69	,	1.87461037	,	1.061016382	),
  (	69	,	1.841098244	,	1.111369628	),
  (	69	,	1.574309799	,	1.169610075	),
  (	69	,	1.84024612	,	1.215557695	),
  (	69	,	1.661123507	,	1.259182358	),
  (	69	,	2.28138101	,	1.277042859	),
  (	69	,	2.550079614	,	1.301800046	),
  (	69	,	2.525052505	,	1.31258134	),
  (	69	,	2.689071938	,	1.377885873	),
  (	69	,	1.927892677	,	1.310553228	),
  (	69	,	2.084197104	,	1.353961301	),
  (	69	,	1.715073895	,	1.378450693	),
  (	69	,	3.931445061	,	0.050560392	),
  (	69	,	3.899340375	,	0.10894058	),
  (	69	,	3.978452031	,	0.178315522	),
  (	69	,	3.880889616	,	0.175293333	),
  (	69	,	3.767184636	,	0.147391456	),
  (	69	,	4.143264581	,	0.219192858	),
  (	69	,	3.725509449	,	0.209396776	),
  (	69	,	3.693523106	,	0.296187842	),
  (	69	,	3.88107602	,	0.340519231	),
  (	69	,	3.632659548	,	0.291973758	),
  (	69	,	3.622005467	,	0.325133325	),
  (	69	,	3.730751909	,	0.413397426	),
  (	69	,	3.725891816	,	0.507985172	),
  (	69	,	3.979641942	,	0.38943941	),
  (	69	,	3.995454658	,	0.447546388	),
  (	69	,	3.880070383	,	0.438964368	),
  (	69	,	4.00502879	,	0.586331621	),
  (	69	,	3.903395428	,	0.52471196	),
  (	69	,	3.937943774	,	0.552989867	),
  (	69	,	3.963232234	,	0.588291107	),
  (	69	,	4.269050334	,	0.451981751	),
  (	69	,	4.414962735	,	0.500327574	),
  (	69	,	4.334892469	,	0.532308819	),
  (	69	,	4.191891627	,	0.550962941	),
  (	69	,	4.277378586	,	0.645342896	),
  (	69	,	4.558165536	,	0.570207515	),
  (	69	,	4.465583565	,	0.600105778	),
  (	69	,	4.698061194	,	0.785176924	),
  (	69	,	4.699669998	,	0.800350406	),
  (	69	,	4.62297505	,	0.767970175	),
  (	69	,	4.461985541	,	0.821837269	),
  (	69	,	4.094448089	,	0.761038387	),
  (	69	,	4.01811333	,	0.796999133	),
  (	69	,	4.006616459	,	0.796216375	),
  (	69	,	4.05522354	,	0.832756556	),
  (	69	,	4.150250597	,	0.92340062	),
  (	69	,	4.425777322	,	0.8122546	),
  (	69	,	4.482754212	,	0.84473313	),
  (	69	,	4.433599293	,	0.873341758	),
  (	69	,	4.455980306	,	0.918123265	),
  (	69	,	4.679327167	,	1.054120729	),
  (	69	,	4.449865809	,	1.020365933	),
  (	69	,	4.486038628	,	1.067444137	),
  (	69	,	3.648417231	,	0.452366079	),
  (	69	,	3.463358351	,	0.567761949	),
  (	69	,	3.405258873	,	0.554650418	),
  (	69	,	3.549019902	,	0.58743509	),
  (	69	,	3.546722408	,	0.609243446	),
  (	69	,	3.566840171	,	0.633467838	),
  (	69	,	3.469459774	,	0.618646391	),
  (	69	,	3.768581554	,	0.712872322	),
  (	69	,	3.812418462	,	0.750632997	),
  (	69	,	3.666898056	,	0.68120065	),
  (	69	,	3.636154292	,	0.736264576	),
  (	69	,	3.557130885	,	0.771385515	),
  (	69	,	3.59289261	,	0.79447952	),
  (	69	,	3.699825185	,	0.841434885	),
  (	69	,	3.660498634	,	0.926882469	),
  (	69	,	3.326109866	,	0.587963536	),
  (	69	,	3.188662133	,	0.696237685	),
  (	69	,	3.504145064	,	0.82034147	),
  (	69	,	3.567954436	,	0.885141475	),
  (	69	,	3.350161357	,	0.875403046	),
  (	69	,	3.925146158	,	0.940037693	),
  (	69	,	3.867604859	,	0.988142478	),
  (	69	,	3.742854718	,	0.967354278	),
  (	69	,	4.052018514	,	1.07733432	),
  (	69	,	3.942020885	,	1.047643621	),
  (	69	,	4.01369674	,	1.090386666	),
  (	69	,	3.961182252	,	1.101601308	),
  (	69	,	4.22977289	,	1.106670582	),
  (	69	,	4.434726313	,	1.088561329	),
  (	69	,	4.63118204	,	1.172025714	),
  (	69	,	4.160906337	,	1.199388412	),
  (	69	,	4.209805516	,	1.226300374	),
  (	69	,	4.371841339	,	1.289581398	),
  (	69	,	4.419719481	,	1.315851701	),
  (	69	,	3.565057994	,	1.169999319	),
  (	69	,	3.752072866	,	1.183028386	),
  (	69	,	4.00280503	,	1.292335526	),
  (	69	,	4.434892573	,	1.41126692	),
  (	69	,	3.625997836	,	1.409665449	),
  (	69	,	4.097023605	,	1.488524487	),
  (	69	,	5.509642126	,	0.058470537	),
  (	69	,	5.590991506	,	0.180327736	),
  (	69	,	5.386654449	,	0.120045612	),
  (	69	,	5.338315894	,	0.180872247	),
  (	69	,	5.532506382	,	0.256103676	),
  (	69	,	5.417625164	,	0.241009038	),
  (	69	,	5.73930033	,	0.363881637	),
  (	69	,	5.824205618	,	0.393106658	),
  (	69	,	5.616068014	,	0.281407854	),
  (	69	,	5.323977095	,	0.200176852	),
  (	69	,	5.363162251	,	0.221326879	),
  (	69	,	5.3204323	,	0.25081827	),
  (	69	,	5.324381158	,	0.271278544	),
  (	69	,	5.371695064	,	0.275894778	),
  (	69	,	5.24615632	,	0.242760496	),
  (	69	,	5.304769491	,	0.26733412	),
  (	69	,	5.413099859	,	0.273031776	),
  (	69	,	5.378796094	,	0.29264265	),
  (	69	,	5.367937982	,	0.338960534	),
  (	69	,	5.3596796	,	0.351037873	),
  (	69	,	5.373582396	,	0.382140625	),
  (	69	,	5.253399794	,	0.298854586	),
  (	69	,	5.252151376	,	0.375185518	),
  (	69	,	5.158854717	,	0.322286982	),
  (	69	,	5.137338737	,	0.331201213	),
  (	69	,	5.355315366	,	0.415225724	),
  (	69	,	5.261027096	,	0.397884864	),
  (	69	,	5.222160057	,	0.41498781	),
  (	69	,	5.315768546	,	0.447646558	),
  (	69	,	5.318212417	,	0.47108412	),
  (	69	,	5.466775655	,	0.43484063	),
  (	69	,	5.427078969	,	0.415232901	),
  (	69	,	5.417924744	,	0.422063384	),
  (	69	,	5.480494066	,	0.481284948	),
  (	69	,	5.606853122	,	0.478533775	),
  (	69	,	5.586549028	,	0.584429925	),
  (	69	,	5.456783548	,	0.539532571	),
  (	69	,	5.469674207	,	0.551983435	),
  (	69	,	5.458230409	,	0.606573188	),
  (	69	,	5.450669566	,	0.620697734	),
  (	69	,	5.485650179	,	0.616306794	),
  (	69	,	5.837198929	,	0.470130098	),
  (	69	,	6.041499789	,	0.546413935	),
  (	69	,	5.832403951	,	0.509172007	),
  (	69	,	5.93876057	,	0.632915467	),
  (	69	,	5.932030283	,	0.651942071	),
  (	69	,	6.091246035	,	0.617834212	),
  (	69	,	6.129261744	,	0.63463942	),
  (	69	,	6.245305642	,	0.701586711	),
  (	69	,	6.169614304	,	0.766274707	),
  (	69	,	6.189117206	,	0.741965621	),
  (	69	,	6.216685498	,	0.763517415	),
  (	69	,	6.264129514	,	0.809103275	),
  (	69	,	5.910134365	,	0.711655827	),
  (	69	,	6.010170616	,	0.750716328	),
  (	69	,	6.149884388	,	0.810964456	),
  (	69	,	6.264832025	,	0.841595508	),
  (	69	,	6.274945401	,	0.880507718	),
  (	69	,	6.263753859	,	0.920411884	),
  (	69	,	5.630567494	,	0.783216936	),
  (	69	,	5.740324979	,	0.929270267	),
  (	69	,	5.974663124	,	0.889693942	),
  (	69	,	6.017956498	,	0.912858318	),
  (	69	,	5.93227937	,	0.89284054	),
  (	69	,	6.071105892	,	0.886128779	),
  (	69	,	6.124539228	,	0.943018477	),
  (	69	,	5.966033389	,	0.931686417	),
  (	69	,	5.962452328	,	0.957698395	),
  (	69	,	6.271511183	,	1.065107742	),
  (	69	,	6.10869946	,	1.06726635	),
  (	69	,	6.049650226	,	1.07233007	),
  (	69	,	6.106017207	,	1.095015412	),
  (	69	,	6.19541593	,	1.112218154	),
  (	69	,	5.209277649	,	0.464141048	),
  (	69	,	5.248155714	,	0.497676777	),
  (	69	,	5.283577371	,	0.537381255	),
  (	69	,	5.223504774	,	0.537168278	),
  (	69	,	5.254390932	,	0.545299607	),
  (	69	,	5.208884391	,	0.60360155	),
  (	69	,	4.988577946	,	0.450750178	),
  (	69	,	5.039555267	,	0.488013755	),
  (	69	,	5.01513965	,	0.533481986	),
  (	69	,	5.013781909	,	0.603906013	),
  (	69	,	5.126624731	,	0.589843275	),
  (	69	,	5.028320786	,	0.63150005	),
  (	69	,	5.07315404	,	0.655917239	),
  (	69	,	5.309798533	,	0.549868204	),
  (	69	,	5.301016144	,	0.573670043	),
  (	69	,	5.334326845	,	0.610700698	),
  (	69	,	5.404747934	,	0.674286205	),
  (	69	,	5.481694252	,	0.74645278	),
  (	69	,	5.408543999	,	0.737349366	),
  (	69	,	5.386958908	,	0.717304568	),
  (	69	,	5.390015325	,	0.731123521	),
  (	69	,	5.20824268	,	0.721793061	),
  (	69	,	5.155983776	,	0.698523339	),
  (	69	,	5.325287957	,	0.765405611	),
  (	69	,	5.295562308	,	0.815275992	),
  (	69	,	5.377473278	,	0.841536919	),
  (	69	,	5.360391473	,	0.853794161	),
  (	69	,	5.282072775	,	0.841792634	),
  (	69	,	5.218106733	,	0.821875485	),
  (	69	,	4.956261468	,	0.625011275	),
  (	69	,	5.016808479	,	0.659629807	),
  (	69	,	5.056955418	,	0.704423986	),
  (	69	,	4.954237733	,	0.701223831	),
  (	69	,	4.944987156	,	0.715503317	),
  (	69	,	4.945724075	,	0.748791489	),
  (	69	,	4.970243827	,	0.763077544	),
  (	69	,	4.815947991	,	0.669250487	),
  (	69	,	4.817109216	,	0.766333852	),
  (	69	,	4.854770627	,	0.804467704	),
  (	69	,	4.903969896	,	0.831054951	),
  (	69	,	4.762940052	,	0.842804327	),
  (	69	,	4.806161038	,	0.895370247	),
  (	69	,	4.809243384	,	0.899574368	),
  (	69	,	5.087382209	,	0.784179948	),
  (	69	,	5.105011236	,	0.819370773	),
  (	69	,	5.110639536	,	0.828700402	),
  (	69	,	5.026853597	,	0.870190867	),
  (	69	,	5.011520416	,	0.879016609	),
  (	69	,	5.177285031	,	0.872842847	),
  (	69	,	5.106002439	,	0.988629676	),
  (	69	,	5.130948754	,	0.994532102	),
  (	69	,	4.862978196	,	0.903767631	),
  (	69	,	4.723348156	,	1.023241798	),
  (	69	,	4.967927461	,	1.058847825	),
  (	69	,	4.939440922	,	1.041386936	),
  (	69	,	4.931865312	,	1.061817452	),
  (	69	,	4.741509187	,	1.120875733	),
  (	69	,	5.49311005	,	0.769001947	),
  (	69	,	5.497154502	,	0.785336277	),
  (	69	,	5.623485678	,	0.869087735	),
  (	69	,	5.634378558	,	0.910990765	),
  (	69	,	5.682805144	,	1.00768373	),
  (	69	,	5.398349749	,	0.924552393	),
  (	69	,	5.42574897	,	0.965023111	),
  (	69	,	5.294701004	,	0.962221122	),
  (	69	,	5.309370189	,	0.978087754	),
  (	69	,	5.495538385	,	0.976336697	),
  (	69	,	5.586904013	,	1.059189917	),
  (	69	,	5.803969454	,	0.978848681	),
  (	69	,	5.744125576	,	1.043621501	),
  (	69	,	5.777977004	,	1.04487942	),
  (	69	,	5.923879709	,	1.112985605	),
  (	69	,	6.041212828	,	1.103762161	),
  (	69	,	5.984262289	,	1.099065958	),
  (	69	,	5.620318346	,	1.083786983	),
  (	69	,	5.625827475	,	1.170263666	),
  (	69	,	5.790955904	,	1.263149819	),
  (	69	,	5.18987816	,	1.103115335	),
  (	69	,	5.283756734	,	1.191574601	),
  (	69	,	5.035560394	,	1.171388286	),
  (	69	,	4.853377837	,	1.182928216	),
  (	69	,	5.531304202	,	1.191258778	),
  (	69	,	5.601411872	,	1.213603601	),
  (	69	,	5.557937667	,	1.22221069	),
  (	69	,	5.390826284	,	1.216133024	),
  (	69	,	5.873068391	,	1.408510305	),
  (	69	,	5.246649069	,	1.39069508	),
  (	69	,	4.947579265	,	1.437630746	),
  (	69	,	5.233080167	,	1.477741457	),
  (	69	,	4.926798049	,	1.464416397	),
  (	69	,	0.07988314	,	-0.637217188	),
  (	69	,	6.246790109	,	-0.605485945	),
  (	69	,	0.07286853	,	-0.570523714	),
  (	69	,	0.057008494	,	-0.392176339	),
  (	69	,	6.200791354	,	-0.421681314	),
  (	69	,	0.212451755	,	-0.497346022	),
  (	69	,	0.090799785	,	-0.412424924	),
  (	69	,	0.120549867	,	-0.351413164	),
  (	69	,	0.173333707	,	-0.194633057	),
  (	69	,	6.060017176	,	-0.450834216	),
  (	69	,	6.251182262	,	-0.323966237	),
  (	69	,	5.999197301	,	-0.390436412	),
  (	69	,	5.966507299	,	-0.306318579	),
  (	69	,	0.0640445	,	-0.258405119	),
  (	69	,	0.064583448	,	-0.247453366	),
  (	69	,	6.241506627	,	-0.254450088	),
  (	69	,	0.135251775	,	-0.176013512	),
  (	69	,	6.161934498	,	-0.201492138	),
  (	69	,	6.239976881	,	-0.193790002	),
  (	69	,	0.399530009	,	-0.332018693	),
  (	69	,	0.477280482	,	-0.186822227	),
  (	69	,	0.554333775	,	-0.150211932	),
  (	69	,	0.339059208	,	-0.133680856	),
  (	69	,	0.370926709	,	-0.103785372	),
  (	69	,	0.704694871	,	0.009527688	),
  (	69	,	0.638237336	,	0.109819636	),
  (	69	,	0.548949075	,	0.12266975	),
  (	69	,	0.217802171	,	-0.003912819	),
  (	69	,	0.06513469	,	-0.052841473	),
  (	69	,	0.166131519	,	-0.008789476	),
  (	69	,	0.462146761	,	0.059646343	),
  (	69	,	0.499030599	,	0.153258887	),
  (	69	,	0.497227321	,	0.185215018	),
  (	69	,	0.426230071	,	0.210808252	),
  (	69	,	5.989892965	,	-0.175559478	),
  (	69	,	6.022840534	,	-0.15499805	),
  (	69	,	5.805536302	,	-0.188847895	),
  (	69	,	5.875563012	,	-0.128765474	),
  (	69	,	5.877893017	,	-0.022849313	),
  (	69	,	6.067901668	,	-0.10402623	),
  (	69	,	6.08977989	,	0.022830595	),
  (	69	,	6.082510617	,	0.087214392	),
  (	69	,	6.078472906	,	0.156441832	),
  (	69	,	5.711721816	,	-0.094318469	),
  (	69	,	5.704672107	,	-0.080437457	),
  (	69	,	5.727952171	,	-0.069672121	),
  (	69	,	5.533386235	,	-0.017272367	),
  (	69	,	5.530720516	,	-0.002860782	),
  (	69	,	5.593078486	,	0.023762556	),
  (	69	,	5.593907978	,	0.075844415	),
  (	69	,	5.61682263	,	0.09409599	),
  (	69	,	5.929036597	,	0.079066122	),
  (	69	,	5.841947921	,	0.283754321	),
  (	69	,	6.161933941	,	0.123650492	),
  (	69	,	0.134324794	,	0.279908915	),
  (	69	,	0.269350046	,	0.441430955	),
  (	69	,	6.219871561	,	0.356315311	),
  (	69	,	5.915917925	,	0.353839895	),
  (	69	,	6.109497629	,	0.403014262	),
  (	69	,	6.17406485	,	0.426308787	),
  (	69	,	6.251199946	,	0.379476116	),
  (	69	,	0.026218054	,	0.49352536	),
  (	69	,	0.028763366	,	0.498349313	),
  (	69	,	0.124246519	,	0.566142984	),
  (	69	,	6.196006343	,	0.480229453	),
  (	69	,	0.022762832	,	0.620826786	),
  (	69	,	1.58411984	,	-0.655317785	),
  (	69	,	1.512770699	,	-0.632358615	),
  (	69	,	1.545095648	,	-0.626623869	),
  (	69	,	1.539464209	,	-0.603200521	),
  (	69	,	1.682822448	,	-0.518415054	),
  (	69	,	1.640403044	,	-0.519905522	),
  (	69	,	1.676466903	,	-0.461552929	),
  (	69	,	1.463652065	,	-0.58064453	),
  (	69	,	1.506295841	,	-0.55273362	),
  (	69	,	1.52674455	,	-0.534440839	),
  (	69	,	1.54746136	,	-0.465304406	),
  (	69	,	1.65337813	,	-0.436554106	),
  (	69	,	1.595925997	,	-0.422294013	),
  (	69	,	1.510727042	,	-0.412669872	),
  (	69	,	1.554119687	,	-0.368654296	),
  (	69	,	1.789396171	,	-0.477067281	),
  (	69	,	1.762305751	,	-0.44566786	),
  (	69	,	1.83798538	,	-0.452885952	),
  (	69	,	1.854854634	,	-0.374371837	),
  (	69	,	1.770118035	,	-0.299805629	),
  (	69	,	1.749496736	,	-0.212620579	),
  (	69	,	1.50000209	,	-0.374001822	),
  (	69	,	1.43268151	,	-0.391527795	),
  (	69	,	1.451667936	,	-0.284817977	),
  (	69	,	1.385755475	,	-0.265631509	),
  (	69	,	1.578011639	,	-0.272086001	),
  (	69	,	1.521321027	,	-0.249832372	),
  (	69	,	1.647526385	,	-0.187186245	),
  (	69	,	1.607551091	,	-0.194541199	),
  (	69	,	1.660974238	,	-0.172631071	),
  (	69	,	1.627192149	,	-0.152351825	),
  (	69	,	1.610561558	,	-0.144889524	),
  (	69	,	1.546778626	,	-0.146832319	),
  (	69	,	1.460841385	,	-0.125671353	),
  (	69	,	1.463994281	,	-0.091932984	),
  (	69	,	1.570877922	,	-0.141503966	),
  (	69	,	1.650604388	,	-0.098687206	),
  (	69	,	1.648850843	,	-0.076496409	),
  (	69	,	1.981895663	,	-0.282513773	),
  (	69	,	1.99230109	,	-0.252804074	),
  (	69	,	1.948646486	,	-0.230191318	),
  (	69	,	1.967764959	,	-0.176410015	),
  (	69	,	2.061558869	,	-0.241961477	),
  (	69	,	2.118333592	,	-0.176680944	),
  (	69	,	1.8677514	,	-0.208100135	),
  (	69	,	1.823796357	,	-0.188250877	),
  (	69	,	1.820188076	,	-0.188922532	),
  (	69	,	1.997787597	,	-0.12144057	),
  (	69	,	2.215176136	,	-0.077057352	),
  (	69	,	2.223150049	,	-0.016757134	),
  (	69	,	2.088953031	,	0.098144343	),
  (	69	,	1.751322173	,	-0.125117379	),
  (	69	,	1.754586759	,	-0.106714462	),
  (	69	,	1.720724358	,	-0.053653134	),
  (	69	,	1.796323204	,	-0.041935008	),
  (	69	,	1.915173562	,	0.001376073	),
  (	69	,	1.922121126	,	0.007043829	),
  (	69	,	1.695755322	,	-0.012586211	),
  (	69	,	1.67007795	,	0.073479748	),
  (	69	,	1.79665303	,	0.08873942	),
  (	69	,	1.789853796	,	0.099021129	),
  (	69	,	1.740087613	,	0.120460657	),
  (	69	,	1.99706377	,	0.033656667	),
  (	69	,	1.972414366	,	0.047565918	),
  (	69	,	2.042283669	,	0.09441586	),
  (	69	,	1.876077099	,	0.13481926	),
  (	69	,	1.933052322	,	0.268064608	),
  (	69	,	1.891043899	,	0.240207946	),
  (	69	,	1.90564667	,	0.281824936	),
  (	69	,	1.978374611	,	0.272953495	),
  (	69	,	1.169890978	,	-0.264942803	),
  (	69	,	1.13400326	,	-0.216404796	),
  (	69	,	1.19164347	,	-0.218927787	),
  (	69	,	1.341449678	,	-0.151025574	),
  (	69	,	1.237381765	,	-0.153526559	),
  (	69	,	1.23735111	,	-0.153493047	),
  (	69	,	1.159358572	,	-0.173252817	),
  (	69	,	1.132353031	,	-0.141713985	),
  (	69	,	1.07986904	,	-0.104845845	),
  (	69	,	1.193486581	,	-0.121962252	),
  (	69	,	1.194416449	,	-0.092679014	),
  (	69	,	1.459102728	,	-0.083850519	),
  (	69	,	1.327759065	,	-0.105265073	),
  (	69	,	1.416652534	,	-0.04359582	),
  (	69	,	1.41664641	,	-0.04359415	),
  (	69	,	1.475917326	,	-0.071704896	),
  (	69	,	1.447435972	,	-0.056138501	),
  (	69	,	1.487629572	,	-0.026305093	),
  (	69	,	1.46264337	,	-0.012834341	),
  (	69	,	1.559541607	,	0.000479243	),
  (	69	,	1.413085382	,	-0.015125441	),
  (	69	,	1.438263814	,	-0.000372627	),
  (	69	,	1.489845443	,	0.065939778	),
  (	69	,	1.291618251	,	0.028368603	),
  (	69	,	1.447594544	,	0.092649155	),
  (	69	,	1.312443807	,	0.079715861	),
  (	69	,	1.344263209	,	0.137835351	),
  (	69	,	1.136564298	,	-0.022977389	),
  (	69	,	1.058722645	,	-0.01398207	),
  (	69	,	1.013541039	,	-0.011442387	),
  (	69	,	1.05804936	,	0.067146199	),
  (	69	,	0.961971567	,	0.089462089	),
  (	69	,	1.212592992	,	0.127716784	),
  (	69	,	1.231553356	,	0.1681342	),
  (	69	,	1.273888062	,	0.172307808	),
  (	69	,	1.270645557	,	0.193172576	),
  (	69	,	0.99708383	,	0.168354664	),
  (	69	,	1.109656413	,	0.215507549	),
  (	69	,	1.234766267	,	0.258563666	),
  (	69	,	1.193592097	,	0.314448752	),
  (	69	,	1.165361387	,	0.317780456	),
  (	69	,	1.610042806	,	0.043568431	),
  (	69	,	1.638444988	,	0.069083077	),
  (	69	,	1.548649067	,	0.102287891	),
  (	69	,	1.701862788	,	0.138249215	),
  (	69	,	1.603949843	,	0.182496394	),
  (	69	,	1.665695512	,	0.224482316	),
  (	69	,	1.438987377	,	0.214162449	),
  (	69	,	1.434936694	,	0.219027564	),
  (	69	,	1.617873523	,	0.2384025	),
  (	69	,	1.624160972	,	0.23887802	),
  (	69	,	1.63503201	,	0.27990374	),
  (	69	,	1.599904726	,	0.271248366	),
  (	69	,	1.548627633	,	0.248179598	),
  (	69	,	1.834327711	,	0.266825028	),
  (	69	,	1.775098474	,	0.292732865	),
  (	69	,	1.933282299	,	0.31892595	),
  (	69	,	1.686986302	,	0.270939486	),
  (	69	,	1.639251042	,	0.319350441	),
  (	69	,	1.620478786	,	0.364868015	),
  (	69	,	1.682250128	,	0.409141373	),
  (	69	,	1.730955504	,	0.403136533	),
  (	69	,	1.736054776	,	0.411975196	),
  (	69	,	1.311459562	,	0.251051233	),
  (	69	,	1.307867526	,	0.277795792	),
  (	69	,	1.506184255	,	0.326452479	),
  (	69	,	1.385437165	,	0.351355419	),
  (	69	,	1.316579446	,	0.46550308	),
  (	69	,	1.384298588	,	0.504487352	),
  (	69	,	1.600514738	,	0.41257117	),
  (	69	,	1.565911447	,	0.449890477	),
  (	69	,	1.571233895	,	0.475980228	),
  (	69	,	1.650848878	,	0.474898182	),
  (	69	,	1.703296488	,	0.492393124	),
  (	69	,	1.652084419	,	0.519777669	),
  (	69	,	1.642107539	,	0.525384932	),
  (	69	,	1.631919656	,	0.580220949	),
  (	69	,	1.498280114	,	0.509637556	),
  (	69	,	1.487734973	,	0.57414324	),
  (	69	,	1.505834955	,	0.586879869	),
  (	69	,	1.582262122	,	0.568829148	),
  (	69	,	1.571844152	,	0.578348553	),
  (	69	,	1.653253829	,	0.614489942	),
  (	69	,	1.542328238	,	0.651699523	),
  (	69	,	1.591139222	,	0.673262587	),
  (	69	,	1.536900061	,	0.672997524	),
  (	69	,	3.17052126	,	-0.66078346	),
  (	69	,	3.092083715	,	-0.628091185	),
  (	69	,	3.174687261	,	-0.548230868	),
  (	69	,	3.228508506	,	-0.466649672	),
  (	69	,	3.009056506	,	-0.489226258	),
  (	69	,	3.174989709	,	-0.41848734	),
  (	69	,	3.21043923	,	-0.407607723	),
  (	69	,	3.321482454	,	-0.487090106	),
  (	69	,	3.441144715	,	-0.403291062	),
  (	69	,	3.398866238	,	-0.376065165	),
  (	69	,	3.358716598	,	-0.277215822	),
  (	69	,	3.332689095	,	-0.209690224	),
  (	69	,	3.296725169	,	-0.209810125	),
  (	69	,	2.968399722	,	-0.494490068	),
  (	69	,	2.960986415	,	-0.424869453	),
  (	69	,	2.946515299	,	-0.342738745	),
  (	69	,	3.073502422	,	-0.36121015	),
  (	69	,	2.995709266	,	-0.3727412	),
  (	69	,	2.918847818	,	-0.338881971	),
  (	69	,	3.069642449	,	-0.262546676	),
  (	69	,	3.171200924	,	-0.213643244	),
  (	69	,	3.263410433	,	-0.151464028	),
  (	69	,	2.977871002	,	-0.154332726	),
  (	69	,	3.029687208	,	-0.096464337	),
  (	69	,	3.165954229	,	-0.102029594	),
  (	69	,	3.128505311	,	-0.083474394	),
  (	69	,	3.479873742	,	-0.271372314	),
  (	69	,	3.646860492	,	-0.166852545	),
  (	69	,	3.391688386	,	-0.155523287	),
  (	69	,	3.568250591	,	-0.056482149	),
  (	69	,	3.741012172	,	-0.157477569	),
  (	69	,	3.761073714	,	-0.034699164	),
  (	69	,	3.712292065	,	0.013951119	),
  (	69	,	3.397575076	,	-0.050680136	),
  (	69	,	3.310544189	,	-0.076333203	),
  (	69	,	3.568032128	,	0.041577436	),
  (	69	,	3.548054813	,	0.102158193	),
  (	69	,	3.615360476	,	0.138929074	),
  (	69	,	3.574575681	,	0.183422557	),
  (	69	,	3.391280905	,	0.144754484	),
  (	69	,	2.802251429	,	-0.240661868	),
  (	69	,	2.714766347	,	-0.234044953	),
  (	69	,	2.772320124	,	-0.224448324	),
  (	69	,	2.651851257	,	-0.133183226	),
  (	69	,	2.710143715	,	-0.094504947	),
  (	69	,	2.915932278	,	-0.03321689	),
  (	69	,	2.920048566	,	-0.023270447	),
  (	69	,	2.943627287	,	-0.022183866	),
  (	69	,	3.056077733	,	0.016617659	),
  (	69	,	2.898645794	,	-0.022309891	),
  (	69	,	2.863104762	,	0.007556163	),
  (	69	,	2.630302756	,	-0.018647962	),
  (	69	,	2.446129342	,	0.003169087	),
  (	69	,	2.428904015	,	0.012721944	),
  (	69	,	2.431258576	,	0.033678354	),
  (	69	,	2.77115108	,	0.03847666	),
  (	69	,	2.820111186	,	0.222487867	),
  (	69	,	2.715014571	,	0.15645648	),
  (	69	,	3.009237511	,	0.132631078	),
  (	69	,	3.034837237	,	0.195274335	),
  (	69	,	3.110052251	,	0.269407132	),
  (	69	,	3.131575113	,	0.30487147	),
  (	69	,	3.3474394	,	0.27212362	),
  (	69	,	3.381935933	,	0.342333577	),
  (	69	,	3.450835079	,	0.370592137	),
  (	69	,	3.43122404	,	0.388860459	),
  (	69	,	2.899671764	,	0.221080021	),
  (	69	,	3.125621174	,	0.465649326	),
  (	69	,	3.12415151	,	0.616807672	),
  (	69	,	3.125373796	,	0.618688324	),
  (	69	,	4.719068041	,	-0.664660738	),
  (	69	,	4.781540704	,	-0.638333046	),
  (	69	,	4.793144043	,	-0.605387769	),
  (	69	,	4.779824593	,	-0.603790019	),
  (	69	,	4.6872552	,	-0.606112486	),
  (	69	,	4.689691685	,	-0.602875197	),
  (	69	,	4.683008257	,	-0.604248557	),
  (	69	,	4.659124242	,	-0.598834965	),
  (	69	,	4.817393501	,	-0.59924483	),
  (	69	,	4.790278948	,	-0.582873108	),
  (	69	,	4.78076109	,	-0.57755887	),
  (	69	,	4.828805835	,	-0.530470681	),
  (	69	,	4.786382788	,	-0.483747163	),
  (	69	,	4.561827648	,	-0.517853691	),
  (	69	,	4.622245939	,	-0.515414438	),
  (	69	,	4.684336955	,	-0.476171559	),
  (	69	,	4.760765301	,	-0.449635819	),
  (	69	,	4.713232062	,	-0.42384646	),
  (	69	,	4.696482817	,	-0.383210591	),
  (	69	,	4.882709084	,	-0.40460423	),
  (	69	,	5.012326792	,	-0.404748462	),
  (	69	,	4.992673576	,	-0.399620179	),
  (	69	,	4.963695353	,	-0.334285012	),
  (	69	,	4.957780598	,	-0.326543932	),
  (	69	,	4.857112918	,	-0.320589735	),
  (	69	,	4.936364733	,	-0.299398809	),
  (	69	,	4.877582208	,	-0.300742745	),
  (	69	,	4.527639938	,	-0.464766988	),
  (	69	,	4.55556473	,	-0.416164125	),
  (	69	,	4.676648026	,	-0.340787846	),
  (	69	,	4.495309134	,	-0.339227043	),
  (	69	,	4.387334118	,	-0.334002749	),
  (	69	,	4.603845309	,	-0.238029331	),
  (	69	,	4.606400331	,	-0.106814912	),
  (	69	,	4.723185254	,	-0.055101726	),
  (	69	,	5.201622874	,	-0.190113274	),
  (	69	,	5.170123481	,	-0.1845392	),
  (	69	,	5.001151354	,	-0.168114918	),
  (	69	,	5.022272826	,	-0.129638333	),
  (	69	,	5.022062039	,	-0.115574919	),
  (	69	,	4.993399024	,	-0.099219365	),
  (	69	,	5.303502083	,	-0.131447226	),
  (	69	,	5.32514563	,	-0.111044043	),
  (	69	,	5.291155725	,	-0.111112184	),
  (	69	,	5.284417986	,	-0.106249931	),
  (	69	,	5.375985799	,	-0.091494418	),
  (	69	,	5.339153257	,	-0.091913588	),
  (	69	,	5.411430304	,	-0.04635011	),
  (	69	,	5.259284064	,	0.007931435	),
  (	69	,	5.181684223	,	0.01897717	),
  (	69	,	5.290902124	,	0.015130314	),
  (	69	,	5.258542774	,	0.036967071	),
  (	69	,	5.303810366	,	0.049681306	),
  (	69	,	5.350553201	,	0.051611684	),
  (	69	,	4.877137619	,	-0.083888918	),
  (	69	,	4.908441312	,	-0.0065198	),
  (	69	,	5.012895878	,	-0.039916569	),
  (	69	,	4.8260826	,	0.013622433	),
  (	69	,	4.959438039	,	0.074430268	),
  (	69	,	4.955652813	,	0.125232186	),
  (	69	,	5.182623422	,	0.100914793	),
  (	69	,	5.118742719	,	0.087779147	),
  (	69	,	5.132185934	,	0.104847767	),
  (	69	,	5.123350661	,	0.135886643	),
  (	69	,	5.245464919	,	0.187428681	),
  (	69	,	4.996626515	,	0.168286476	),
  (	69	,	5.013310912	,	0.197107186	),
  (	69	,	5.14069982	,	0.300950498	),
  (	69	,	5.082214946	,	0.295954116	),
  (	69	,	4.332472271	,	-0.184348131	),
  (	69	,	4.363449669	,	-0.10614986	),
  (	69	,	4.653111267	,	0.018227303	),
  (	69	,	4.623025674	,	0.059207872	),
  (	69	,	4.546885943	,	0.087272761	),
  (	69	,	4.50022162	,	0.081860776	),
  (	69	,	4.211221429	,	-0.061567281	),
  (	69	,	4.208395952	,	0.011722662	),
  (	69	,	4.403292332	,	0.225307569	),
  (	69	,	4.305232338	,	0.161840326	),
  (	69	,	4.214405105	,	0.17341643	),
  (	69	,	4.305379811	,	0.191816463	),
  (	69	,	4.35010201	,	0.252641211	),
  (	69	,	4.305087794	,	0.278774692	),
  (	69	,	4.693301088	,	0.036214923	),
  (	69	,	4.769390431	,	0.052020938	),
  (	69	,	4.770938322	,	0.207419205	),
  (	69	,	4.561030868	,	0.155758039	),
  (	69	,	4.610344743	,	0.24108817	),
  (	69	,	4.744472425	,	0.277777393	),
  (	69	,	4.770248175	,	0.284015705	),
  (	69	,	4.90375813	,	0.190260828	),
  (	69	,	4.875326599	,	0.198197615	),
  (	69	,	4.923475533	,	0.268677959	),
  (	69	,	4.898335263	,	0.265277979	),
  (	69	,	5.050686174	,	0.380722858	),
  (	69	,	4.525505024	,	0.229226031	),
  (	69	,	4.63295954	,	0.375256511	),
  (	69	,	4.418678598	,	0.315240936	),
  (	69	,	4.487936982	,	0.427363857	),
  (	69	,	4.531301745	,	0.450442738	),
  (	69	,	4.633104851	,	0.414574896	),
  (	69	,	4.806038855	,	0.437323948	),
  (	69	,	4.862182677	,	0.519081479	),
  (	69	,	4.870557565	,	0.533808104	),
  (	69	,	4.729355438	,	0.530149192	),
  (	69	,	4.592047801	,	0.461460051	),
  (	69	,	4.643815397	,	0.57990464	),
  (	69	,	4.646189766	,	0.614666194	),
  (	69	,	1.340951856	,	-1.463613748	),
  (	69	,	1.057978601	,	-1.372407939	),
  (	69	,	0.892779289	,	-1.339483384	),
  (	69	,	0.073369849	,	-1.374975952	),
  (	69	,	0.194568664	,	-1.362792409	),
  (	69	,	0.713017806	,	-1.207060586	),
  (	69	,	1.314052465	,	-1.297491306	),
  (	69	,	0.920125545	,	-1.082240254	),
  (	69	,	1.165474392	,	-1.096058281	),
  (	69	,	1.057971943	,	-1.070868132	),
  (	69	,	1.04556474	,	-0.985631588	),
  (	69	,	0.240023566	,	-1.296806685	),
  (	69	,	0.168750562	,	-1.276491519	),
  (	69	,	0.554066313	,	-1.150972278	),
  (	69	,	0.823984548	,	-1.126866756	),
  (	69	,	0.908826238	,	-1.010237387	),
  (	69	,	0.612520592	,	-0.991070425	),
  (	69	,	0.694333139	,	-0.923880659	),
  (	69	,	0.802507016	,	-0.766162331	),
  (	69	,	1.492075755	,	-1.098050969	),
  (	69	,	1.436793726	,	-1.087591465	),
  (	69	,	1.461909686	,	-1.027493008	),
  (	69	,	1.296450208	,	-1.0134946	),
  (	69	,	1.402309501	,	-0.900155359	),
  (	69	,	1.261343789	,	-0.989015661	),
  (	69	,	1.381560484	,	-0.801343871	),
  (	69	,	1.398953002	,	-0.759805821	),
  (	69	,	1.518297285	,	-0.709526491	),
  (	69	,	1.346066342	,	-0.719279327	),
  (	69	,	1.25909574	,	-0.767592402	),
  (	69	,	1.02374129	,	-0.810128149	),
  (	69	,	1.109017552	,	-0.805175339	),
  (	69	,	1.031885303	,	-0.68001808	),
  (	69	,	0.906398747	,	-0.765425985	),
  (	69	,	0.851289848	,	-0.796984279	),
  (	69	,	0.845763185	,	-0.677357065	),
  (	69	,	1.231047257	,	-0.656477629	),
  (	69	,	1.162868504	,	-0.57275132	),
  (	69	,	1.10304989	,	-0.415758215	),
  (	69	,	1.180551487	,	-0.401851809	),
  (	69	,	0.062602178	,	-1.095576016	),
  (	69	,	0.171007551	,	-1.011733832	),
  (	69	,	0.243837832	,	-0.928391207	),
  (	69	,	0.193040065	,	-0.861946527	),
  (	69	,	0.354776076	,	-0.868148996	),
  (	69	,	0.712695866	,	-0.707343691	),
  (	69	,	0.599245367	,	-0.628015425	),
  (	69	,	0.097554213	,	-0.889980911	),
  (	69	,	0.240833038	,	-0.827411774	),
  (	69	,	0.379477234	,	-0.728632069	),
  (	69	,	0.289995668	,	-0.695620954	),
  (	69	,	0.149784032	,	-0.740562791	),
  (	69	,	0.360932312	,	-0.638732817	),
  (	69	,	0.36946399	,	-0.595849492	),
  (	69	,	0.364693481	,	-0.425035375	),
  (	69	,	0.78113432	,	-0.596712831	),
  (	69	,	0.860840087	,	-0.410505455	),
  (	69	,	1.021022969	,	-0.403854329	),
  (	69	,	0.968621212	,	-0.430266432	),
  (	69	,	1.104155944	,	-0.403668826	),
  (	69	,	1.116404251	,	-0.386619285	),
  (	69	,	1.076062385	,	-0.31504781	),
  (	69	,	0.838877182	,	-0.359879387	),
  (	69	,	0.887013116	,	-0.304372245	),
  (	69	,	0.534888627	,	-0.383375408	),
  (	69	,	0.573941812	,	-0.331208886	),
  (	69	,	0.732741344	,	-0.217484972	),
  (	69	,	0.853158822	,	-0.153068498	),
  (	69	,	0.814007669	,	-0.178932102	),
  (	69	,	0.694414361	,	-0.171590647	),
  (	69	,	0.783681793	,	-0.125318911	),
  (	69	,	0.734001779	,	-0.063170065	),
  (	69	,	2.697388389	,	-1.447068281	),
  (	69	,	2.803865346	,	-1.317090864	),
  (	69	,	2.567107486	,	-1.322561339	),
  (	69	,	1.694034792	,	-1.348977092	),
  (	69	,	1.986885744	,	-1.29633986	),
  (	69	,	2.29351549	,	-1.34521975	),
  (	69	,	2.28948857	,	-1.305296242	),
  (	69	,	2.584991326	,	-1.255647428	),
  (	69	,	2.220457212	,	-1.258058933	),
  (	69	,	2.265613843	,	-1.209056492	),
  (	69	,	2.351524511	,	-1.189253061	),
  (	69	,	2.900740921	,	-1.311706646	),
  (	69	,	3.018534367	,	-1.289844638	),
  (	69	,	2.932543049	,	-1.242979318	),
  (	69	,	2.73500902	,	-1.277019564	),
  (	69	,	3.135048274	,	-1.234645461	),
  (	69	,	2.573955808	,	-1.194140424	),
  (	69	,	2.663166719	,	-1.173966925	),
  (	69	,	2.637920875	,	-1.128314062	),
  (	69	,	2.66338736	,	-1.123714401	),
  (	69	,	2.790278793	,	-1.064402831	),
  (	69	,	2.728249795	,	-1.027517404	),
  (	69	,	2.614046876	,	-1.105589185	),
  (	69	,	2.08433087	,	-1.150323215	),
  (	69	,	2.123196039	,	-1.108555148	),
  (	69	,	1.92720787	,	-1.081252649	),
  (	69	,	2.353319827	,	-1.107702917	),
  (	69	,	2.416690923	,	-1.069532782	),
  (	69	,	2.29110962	,	-1.02492467	),
  (	69	,	2.553807375	,	-0.946794824	),
  (	69	,	2.439770826	,	-0.983761121	),
  (	69	,	2.394985299	,	-0.935381099	),
  (	69	,	2.478169644	,	-0.934054883	),
  (	69	,	2.235720895	,	-0.865705902	),
  (	69	,	2.400274461	,	-0.860267583	),
  (	69	,	2.415190692	,	-0.856865453	),
  (	69	,	2.29651804	,	-0.82990108	),
  (	69	,	2.377275416	,	-0.817088376	),
  (	69	,	3.083148091	,	-1.130379783	),
  (	69	,	3.062594353	,	-1.051225851	),
  (	69	,	2.976922227	,	-1.019034471	),
  (	69	,	2.961504836	,	-1.0155437	),
  (	69	,	2.997652419	,	-0.98227204	),
  (	69	,	2.953986014	,	-0.956047258	),
  (	69	,	2.940209454	,	-0.922516595	),
  (	69	,	2.743654613	,	-0.99890201	),
  (	69	,	2.763081484	,	-0.966683635	),
  (	69	,	2.792367153	,	-0.912529525	),
  (	69	,	2.683972036	,	-0.96951635	),
  (	69	,	2.727567537	,	-0.874531527	),
  (	69	,	2.875732167	,	-0.934432807	),
  (	69	,	2.81732656	,	-0.828329749	),
  (	69	,	2.708777823	,	-0.83018253	),
  (	69	,	2.793607691	,	-0.823100832	),
  (	69	,	3.106982174	,	-0.862212428	),
  (	69	,	3.13397738	,	-0.837368742	),
  (	69	,	2.954720569	,	-0.722396751	),
  (	69	,	3.041088033	,	-0.679972588	),
  (	69	,	3.054208921	,	-0.66511863	),
  (	69	,	3.039448137	,	-0.630435825	),
  (	69	,	2.883487788	,	-0.706824904	),
  (	69	,	2.945865625	,	-0.689003691	),
  (	69	,	2.957072904	,	-0.637638773	),
  (	69	,	3.033530774	,	-0.621547718	),
  (	69	,	2.593485663	,	-0.813965185	),
  (	69	,	2.557557901	,	-0.801419978	),
  (	69	,	2.489500946	,	-0.79535341	),
  (	69	,	2.437049878	,	-0.681440916	),
  (	69	,	2.549308025	,	-0.690646879	),
  (	69	,	2.558078708	,	-0.584829645	),
  (	69	,	2.563933192	,	-0.580217776	),
  (	69	,	2.53689595	,	-0.582876342	),
  (	69	,	2.764250986	,	-0.702296529	),
  (	69	,	2.767578823	,	-0.652522214	),
  (	69	,	2.789339405	,	-0.640135162	),
  (	69	,	2.909776538	,	-0.533292511	),
  (	69	,	2.821790148	,	-0.454620025	),
  (	69	,	2.632792335	,	-0.580117578	),
  (	69	,	2.643097744	,	-0.539163523	),
  (	69	,	2.728793856	,	-0.509528173	),
  (	69	,	2.601673058	,	-0.542648957	),
  (	69	,	2.640680784	,	-0.492130508	),
  (	69	,	2.63900814	,	-0.491984088	),
  (	69	,	2.778166107	,	-0.482693372	),
  (	69	,	2.812020154	,	-0.418623005	),
  (	69	,	2.711187547	,	-0.442843123	),
  (	69	,	2.761588863	,	-0.393181135	),
  (	69	,	1.623979861	,	-1.143716299	),
  (	69	,	1.701353337	,	-1.040053759	),
  (	69	,	1.900155308	,	-1.021760975	),
  (	69	,	1.989936083	,	-0.999993786	),
  (	69	,	2.043133067	,	-0.954945124	),
  (	69	,	1.884619846	,	-0.980092578	),
  (	69	,	1.922697238	,	-0.911039263	),
  (	69	,	1.975576376	,	-0.934714308	),
  (	69	,	1.952201377	,	-0.897144873	),
  (	69	,	2.003986345	,	-0.856108009	),
  (	69	,	1.649738364	,	-0.934777026	),
  (	69	,	1.757606176	,	-0.880548559	),
  (	69	,	1.865157035	,	-0.911134993	),
  (	69	,	1.844651079	,	-0.871405978	),
  (	69	,	1.908919606	,	-0.819897408	),
  (	69	,	2.109633247	,	-0.863909518	),
  (	69	,	2.126318578	,	-0.844472642	),
  (	69	,	2.173016503	,	-0.821906953	),
  (	69	,	2.125338463	,	-0.834157565	),
  (	69	,	2.095814775	,	-0.793372785	),
  (	69	,	2.232324407	,	-0.799094858	),
  (	69	,	2.270457852	,	-0.73982682	),
  (	69	,	2.302404532	,	-0.680537719	),
  (	69	,	2.228662102	,	-0.724571815	),
  (	69	,	2.040231616	,	-0.820529782	),
  (	69	,	2.142929325	,	-0.711362746	),
  (	69	,	2.018833373	,	-0.742941373	),
  (	69	,	1.980239562	,	-0.752476542	),
  (	69	,	2.008578354	,	-0.688035318	),
  (	69	,	2.03093166	,	-0.656177013	),
  (	69	,	2.146271794	,	-0.624357251	),
  (	69	,	2.170630133	,	-0.573688405	),
  (	69	,	2.153579616	,	-0.553868585	),
  (	69	,	1.630555202	,	-0.901772558	),
  (	69	,	1.842819604	,	-0.744075049	),
  (	69	,	1.882232356	,	-0.682456483	),
  (	69	,	1.601307142	,	-0.806443544	),
  (	69	,	1.706383201	,	-0.763002958	),
  (	69	,	1.657187422	,	-0.689169686	),
  (	69	,	1.783814322	,	-0.609761088	),
  (	69	,	1.940757429	,	-0.65085077	),
  (	69	,	2.045066559	,	-0.551833603	),
  (	69	,	2.134151174	,	-0.529235881	),
  (	69	,	2.125023604	,	-0.513221127	),
  (	69	,	2.010953273	,	-0.552591189	),
  (	69	,	2.009035419	,	-0.524987803	),
  (	69	,	1.913468929	,	-0.564557665	),
  (	69	,	1.831471673	,	-0.495668082	),
  (	69	,	1.957764015	,	-0.508219568	),
  (	69	,	1.931738533	,	-0.453983324	),
  (	69	,	1.912028202	,	-0.389894706	),
  (	69	,	1.994039168	,	-0.373390386	),
  (	69	,	2.317935051	,	-0.674274195	),
  (	69	,	2.294460141	,	-0.661082893	),
  (	69	,	2.301203468	,	-0.603887125	),
  (	69	,	2.36868636	,	-0.566186258	),
  (	69	,	2.418842268	,	-0.568230554	),
  (	69	,	2.397964718	,	-0.52040019	),
  (	69	,	2.378485531	,	-0.506463824	),
  (	69	,	2.253040171	,	-0.563070552	),
  (	69	,	2.393718257	,	-0.45098274	),
  (	69	,	2.47252268	,	-0.421807661	),
  (	69	,	2.742849005	,	-0.34077535	),
  (	69	,	2.614989179	,	-0.355293359	),
  (	69	,	2.629417493	,	-0.356468639	),
  (	69	,	2.386354907	,	-0.31767984	),
  (	69	,	2.167447469	,	-0.381913782	),
  (	69	,	2.139156792	,	-0.393282079	),
  (	69	,	2.268458585	,	-0.302012549	),
  (	69	,	2.066654534	,	-0.406900796	),
  (	69	,	2.05871027	,	-0.361647127	),
  (	69	,	2.074700007	,	-0.332440471	),
  (	69	,	2.236754061	,	-0.251640837	),
  (	69	,	2.188664413	,	-0.192783864	),
  (	69	,	2.428004044	,	-0.241448375	),
  (	69	,	2.335618726	,	-0.198476298	),
  (	69	,	2.33279457	,	-0.198573076	),
  (	69	,	2.311144116	,	-0.150769962	),
  (	69	,	2.190170895	,	-0.187589315	),
  (	69	,	2.292011451	,	-0.121799381	),
  (	69	,	2.259459232	,	-0.118797195	),
  (	69	,	2.362828415	,	-0.077770399	),
  (	69	,	3.812550117	,	-1.3954832	),
  (	69	,	3.994440569	,	-1.38119743	),
  (	69	,	3.543782402	,	-1.390344204	),
  (	69	,	3.181394968	,	-1.374994212	),
  (	69	,	3.847959749	,	-1.311433673	),
  (	69	,	4.012001042	,	-1.25300889	),
  (	69	,	4.526614249	,	-1.168532654	),
  (	69	,	4.583300061	,	-1.167102309	),
  (	69	,	4.389292299	,	-1.182465201	),
  (	69	,	4.50543886	,	-1.111521492	),
  (	69	,	4.046759318	,	-1.154038991	),
  (	69	,	4.01321667	,	-1.160575831	),
  (	69	,	4.131404336	,	-1.014480311	),
  (	69	,	3.149637843	,	-1.279301515	),
  (	69	,	3.812793652	,	-1.180152108	),
  (	69	,	3.728819679	,	-1.154608542	),
  (	69	,	3.730757042	,	-1.076986842	),
  (	69	,	3.25038021	,	-1.13814695	),
  (	69	,	3.360773111	,	-1.093294694	),
  (	69	,	3.455427055	,	-1.066698803	),
  (	69	,	3.556917605	,	-1.09311518	),
  (	69	,	3.589600645	,	-1.077528737	),
  (	69	,	3.74833786	,	-1.036457968	),
  (	69	,	3.529557653	,	-1.08388945	),
  (	69	,	3.54108323	,	-1.074815235	),
  (	69	,	3.499923184	,	-1.05042641	),
  (	69	,	3.966500084	,	-1.080143395	),
  (	69	,	3.909387236	,	-1.063009607	),
  (	69	,	3.880077534	,	-1.036855214	),
  (	69	,	4.102314723	,	-0.993350103	),
  (	69	,	4.108113998	,	-0.93185477	),
  (	69	,	4.028039389	,	-0.902965296	),
  (	69	,	4.018978074	,	-0.833577475	),
  (	69	,	4.007982762	,	-0.835654168	),
  (	69	,	3.853928211	,	-0.830262205	),
  (	69	,	3.898055373	,	-0.80033419	),
  (	69	,	4.670602293	,	-1.080785563	),
  (	69	,	4.550052765	,	-1.020560717	),
  (	69	,	4.548765726	,	-0.947474901	),
  (	69	,	4.424591777	,	-0.95012957	),
  (	69	,	4.274808653	,	-0.890721598	),
  (	69	,	4.246370408	,	-0.870655014	),
  (	69	,	4.369100649	,	-0.851079095	),
  (	69	,	4.354577662	,	-0.805549485	),
  (	69	,	4.613248559	,	-0.859488571	),
  (	69	,	4.640925103	,	-0.802351997	),
  (	69	,	4.672515304	,	-0.7388077	),
  (	69	,	4.69525995	,	-0.73868583	),
  (	69	,	4.663137131	,	-0.696366432	),
  (	69	,	4.666192975	,	-0.680395239	),
  (	69	,	4.615755656	,	-0.660822086	),
  (	69	,	4.452942791	,	-0.793283013	),
  (	69	,	4.393986595	,	-0.689998914	),
  (	69	,	4.418304434	,	-0.656237977	),
  (	69	,	4.529525155	,	-0.66609002	),
  (	69	,	4.584977247	,	-0.65340046	),
  (	69	,	4.571408255	,	-0.649012239	),
  (	69	,	4.117372084	,	-0.901109817	),
  (	69	,	4.16627239	,	-0.87857424	),
  (	69	,	4.157614358	,	-0.883413769	),
  (	69	,	4.119729337	,	-0.876432768	),
  (	69	,	4.095819917	,	-0.797770461	),
  (	69	,	4.168635245	,	-0.777127953	),
  (	69	,	4.105256993	,	-0.778821732	),
  (	69	,	4.103318114	,	-0.77298201	),
  (	69	,	4.20947623	,	-0.688267865	),
  (	69	,	4.221867854	,	-0.640877423	),
  (	69	,	4.176065784	,	-0.627057223	),
  (	69	,	4.119275688	,	-0.551592382	),
  (	69	,	4.356844634	,	-0.68333964	),
  (	69	,	4.464983502	,	-0.551779624	),
  (	69	,	4.380150882	,	-0.467916655	),
  (	69	,	4.416853357	,	-0.446816317	),
  (	69	,	4.23036546	,	-0.569836962	),
  (	69	,	4.320828447	,	-0.487232132	),
  (	69	,	3.17325113	,	-1.128909082	),
  (	69	,	3.228399854	,	-1.09701241	),
  (	69	,	3.234756072	,	-1.087019617	),
  (	69	,	3.267752356	,	-1.07985136	),
  (	69	,	3.375583378	,	-1.053429585	),
  (	69	,	3.164025487	,	-1.067786694	),
  (	69	,	3.195776974	,	-1.048380685	),
  (	69	,	3.378809579	,	-1.019807098	),
  (	69	,	3.60923051	,	-0.912272749	),
  (	69	,	3.509999795	,	-0.905391164	),
  (	69	,	3.154758534	,	-0.999377953	),
  (	69	,	3.34269906	,	-0.953162832	),
  (	69	,	3.192373352	,	-0.949766764	),
  (	69	,	3.211079255	,	-0.943470538	),
  (	69	,	3.450647128	,	-0.923410438	),
  (	69	,	3.483737183	,	-0.798746239	),
  (	69	,	3.601701995	,	-0.851571721	),
  (	69	,	3.818683853	,	-0.810915025	),
  (	69	,	3.865728602	,	-0.783089501	),
  (	69	,	3.796811829	,	-0.765572052	),
  (	69	,	3.887623522	,	-0.747396751	),
  (	69	,	3.873675916	,	-0.696848186	),
  (	69	,	3.773101448	,	-0.711314319	),
  (	69	,	3.583266586	,	-0.803348354	),
  (	69	,	3.590281984	,	-0.771278344	),
  (	69	,	3.64658196	,	-0.732950546	),
  (	69	,	3.562377684	,	-0.740286415	),
  (	69	,	3.540295835	,	-0.741151726	),
  (	69	,	3.71259278	,	-0.559826552	),
  (	69	,	3.255113401	,	-0.865476242	),
  (	69	,	3.3396533	,	-0.840732366	),
  (	69	,	3.490481846	,	-0.718911163	),
  (	69	,	3.352225549	,	-0.780490509	),
  (	69	,	3.411093196	,	-0.691428967	),
  (	69	,	3.398492315	,	-0.682524176	),
  (	69	,	3.439871951	,	-0.632227549	),
  (	69	,	3.189797499	,	-0.792778558	),
  (	69	,	3.240871515	,	-0.683797543	),
  (	69	,	3.453596941	,	-0.613132333	),
  (	69	,	3.556987177	,	-0.56221601	),
  (	69	,	3.517421648	,	-0.568059527	),
  (	69	,	3.641781259	,	-0.6038504	),
  (	69	,	3.367797873	,	-0.544577221	),
  (	69	,	3.383937656	,	-0.524823628	),
  (	69	,	3.413759791	,	-0.493688105	),
  (	69	,	3.995302058	,	-0.481645224	),
  (	69	,	3.849386324	,	-0.57196609	),
  (	69	,	3.921114638	,	-0.482710481	),
  (	69	,	3.913712944	,	-0.458763439	),
  (	69	,	4.160904578	,	-0.442045483	),
  (	69	,	4.165633412	,	-0.397348834	),
  (	69	,	4.210811454	,	-0.323578751	),
  (	69	,	3.990109547	,	-0.321641123	),
  (	69	,	4.144599934	,	-0.31244884	),
  (	69	,	4.107048611	,	-0.243828729	),
  (	69	,	3.667813394	,	-0.458454615	),
  (	69	,	3.641322923	,	-0.388259545	),
  (	69	,	3.694399032	,	-0.247924183	),
  (	69	,	3.702203531	,	-0.206463426	),
  (	69	,	3.918640678	,	-0.303062378	),
  (	69	,	3.978620358	,	-0.282040167	),
  (	69	,	3.789681265	,	-0.17461046	),
  (	69	,	3.933925908	,	-0.05523745	),
  (	69	,	5.746797646	,	-1.330136911	),
  (	69	,	5.768852634	,	-1.320854142	),
  (	69	,	5.126892333	,	-1.426857084	),
  (	69	,	4.900259789	,	-1.362513141	),
  (	69	,	5.967005869	,	-1.212556865	),
  (	69	,	4.944632775	,	-1.285082651	),
  (	69	,	5.018422153	,	-1.248756291	),
  (	69	,	5.440096966	,	-1.132891572	),
  (	69	,	5.240451945	,	-1.131139672	),
  (	69	,	5.53011147	,	-1.047059176	),
  (	69	,	5.649958453	,	-0.904562935	),
  (	69	,	5.591108378	,	-0.903264527	),
  (	69	,	5.582183309	,	-0.821262135	),
  (	69	,	6.190384755	,	-1.097559345	),
  (	69	,	6.27672448	,	-0.999740736	),
  (	69	,	5.960637763	,	-0.961041585	),
  (	69	,	5.861732912	,	-0.814518912	),
  (	69	,	5.919811398	,	-0.758712338	),
  (	69	,	5.891636379	,	-0.738118459	),
  (	69	,	6.234335445	,	-0.831650377	),
  (	69	,	6.209437041	,	-0.808297433	),
  (	69	,	6.163970795	,	-0.787516687	),
  (	69	,	6.247044795	,	-0.712584784	),
  (	69	,	5.709751492	,	-0.833842088	),
  (	69	,	5.809567218	,	-0.765194543	),
  (	69	,	5.608580273	,	-0.78822574	),
  (	69	,	5.578350385	,	-0.756329741	),
  (	69	,	5.572566697	,	-0.67850235	),
  (	69	,	5.867057775	,	-0.682896757	),
  (	69	,	5.759262269	,	-0.550230168	),
  (	69	,	4.813068299	,	-1.060276163	),
  (	69	,	4.802729339	,	-1.044403432	),
  (	69	,	5.151780132	,	-0.946151477	),
  (	69	,	4.919234061	,	-0.866219282	),
  (	69	,	5.087315277	,	-0.86993335	),
  (	69	,	4.994552808	,	-0.844810743	),
  (	69	,	4.959063404	,	-0.855080419	),
  (	69	,	4.969315636	,	-0.846588245	),
  (	69	,	5.090657831	,	-0.812956042	),
  (	69	,	5.21930731	,	-0.66892693	),
  (	69	,	5.200075697	,	-0.651650151	),
  (	69	,	4.911442757	,	-0.842366342	),
  (	69	,	4.933564158	,	-0.833914339	),
  (	69	,	4.787855774	,	-0.666327266	),
  (	69	,	4.908679783	,	-0.69379209	),
  (	69	,	4.926415201	,	-0.57090402	),
  (	69	,	4.867038869	,	-0.574051482	),
  (	69	,	5.121248477	,	-0.596865429	),
  (	69	,	5.11589214	,	-0.538777709	),
  (	69	,	5.129519983	,	-0.362736217	),
  (	69	,	5.501659465	,	-0.629252721	),
  (	69	,	5.500736652	,	-0.615967765	),
  (	69	,	5.504031315	,	-0.57413681	),
  (	69	,	5.541854521	,	-0.518730898	),
  (	69	,	5.434070377	,	-0.531948034	),
  (	69	,	5.461159067	,	-0.488609146	),
  (	69	,	5.414332706	,	-0.498279792	),
  (	69	,	5.460961128	,	-0.475514487	),
  (	69	,	5.668747348	,	-0.47659981	),
  (	69	,	5.650137763	,	-0.353484413	),
  (	69	,	5.578224363	,	-0.354924415	),
  (	69	,	5.530509007	,	-0.333160211	),
  (	69	,	5.631621018	,	-0.249433013	),
  (	69	,	5.6086835	,	-0.249186806	),
  (	69	,	5.35825797	,	-0.446913959	),
  (	69	,	5.320767048	,	-0.365659057	),
  (	69	,	5.40215653	,	-0.422876624	),
  (	69	,	5.446427144	,	-0.33615859	),
  (	69	,	5.362451531	,	-0.30429683	),
  (	69	,	5.183626734	,	-0.365779508	),
  (	69	,	5.567573564	,	-0.230438479	),
  (	69	,	5.582185778	,	-0.227729774	),
  (	69	,	5.613061159	,	-0.211130917	),
  (	69	,	5.509074556	,	-0.174454899	),
  (	69	,	5.531428486	,	-0.035816482	),
  (	70	,	0.757629836	,	0.034352808	),
  (	70	,	0.764179124	,	0.060855818	),
  (	70	,	0.860235751	,	0.118676903	),
  (	70	,	0.910212392	,	0.198797749	),
  (	70	,	0.652700096	,	0.157191779	),
  (	70	,	0.673842691	,	0.202538835	),
  (	70	,	1.044266152	,	0.243903256	),
  (	70	,	1.023083337	,	0.289984542	),
  (	70	,	1.05207254	,	0.352532222	),
  (	70	,	0.915033068	,	0.292555686	),
  (	70	,	0.922195424	,	0.313079946	),
  (	70	,	0.87640764	,	0.35795426	),
  (	70	,	1.01059285	,	0.384515919	),
  (	70	,	1.001979925	,	0.393278081	),
  (	70	,	0.992001777	,	0.415441198	),
  (	70	,	1.007379741	,	0.418201058	),
  (	70	,	0.997028991	,	0.424904093	),
  (	70	,	0.98067195	,	0.487302744	),
  (	70	,	0.607133527	,	0.34360013	),
  (	70	,	0.518840409	,	0.3204064	),
  (	70	,	0.489442966	,	0.420928951	),
  (	70	,	0.590885532	,	0.423591573	),
  (	70	,	0.555639747	,	0.475385402	),
  (	70	,	0.847740118	,	0.400617905	),
  (	70	,	0.922113179	,	0.481214474	),
  (	70	,	0.940877455	,	0.552927978	),
  (	70	,	0.903375347	,	0.600907907	),
  (	70	,	0.706927472	,	0.539925786	),
  (	70	,	0.6729816	,	0.58979506	),
  (	70	,	0.80979729	,	0.642256118	),
  (	70	,	1.110205716	,	0.413579814	),
  (	70	,	1.308544564	,	0.47691884	),
  (	70	,	1.355173608	,	0.537518096	),
  (	70	,	1.258029562	,	0.510252574	),
  (	70	,	1.089302311	,	0.552442426	),
  (	70	,	1.07621732	,	0.565225335	),
  (	70	,	1.271871274	,	0.62507783	),
  (	70	,	1.166337823	,	0.637395921	),
  (	70	,	1.438634988	,	0.617410335	),
  (	70	,	1.335785746	,	0.591990947	),
  (	70	,	1.362446225	,	0.699903733	),
  (	70	,	1.522204848	,	0.689988605	),
  (	70	,	1.497634003	,	0.727725403	),
  (	70	,	1.507536475	,	0.910362022	),
  (	70	,	1.086233941	,	0.724381751	),
  (	70	,	0.948534719	,	0.69969672	),
  (	70	,	0.919592267	,	0.736569063	),
  (	70	,	0.847104303	,	0.700207233	),
  (	70	,	0.866310778	,	0.780500185	),
  (	70	,	0.991651394	,	0.769227703	),
  (	70	,	1.085541342	,	0.876162659	),
  (	70	,	1.027188874	,	0.855919339	),
  (	70	,	0.991259509	,	0.902437598	),
  (	70	,	1.00538728	,	0.915981734	),
  (	70	,	1.24074773	,	0.840816617	),
  (	70	,	1.296099576	,	0.871290239	),
  (	70	,	1.154303003	,	0.887407835	),
  (	70	,	1.186891237	,	0.940952176	),
  (	70	,	1.204317946	,	0.968861935	),
  (	70	,	1.56542437	,	1.053815173	),
  (	70	,	0.33197752	,	0.449760022	),
  (	70	,	0.378428062	,	0.475535551	),
  (	70	,	0.273127126	,	0.484294267	),
  (	70	,	0.297815456	,	0.503829787	),
  (	70	,	0.320903739	,	0.518990545	),
  (	70	,	0.318015083	,	0.559820707	),
  (	70	,	0.385370103	,	0.533324489	),
  (	70	,	0.38271202	,	0.557911017	),
  (	70	,	0.626047336	,	0.618562171	),
  (	70	,	0.654191445	,	0.683068761	),
  (	70	,	0.760278518	,	0.743304588	),
  (	70	,	0.628518474	,	0.734823367	),
  (	70	,	0.6534986	,	0.803397908	),
  (	70	,	0.490311988	,	0.653257944	),
  (	70	,	0.5145632	,	0.711396239	),
  (	70	,	0.447748948	,	0.704717443	),
  (	70	,	0.588505139	,	0.851411429	),
  (	70	,	0.53378386	,	0.817553628	),
  (	70	,	0.476724262	,	0.835949217	),
  (	70	,	0.454788101	,	0.841444693	),
  (	70	,	0.191423807	,	0.581383063	),
  (	70	,	0.245427741	,	0.614854989	),
  (	70	,	0.349424748	,	0.732516773	),
  (	70	,	0.26204736	,	0.780353404	),
  (	70	,	0.142766369	,	0.677949931	),
  (	70	,	0.100165873	,	0.676389961	),
  (	70	,	0.033295211	,	0.700710921	),
  (	70	,	0.168820705	,	0.819551143	),
  (	70	,	0.378404105	,	0.762562367	),
  (	70	,	0.339014977	,	0.778973657	),
  (	70	,	0.419106638	,	0.822301365	),
  (	70	,	0.261777307	,	0.83810556	),
  (	70	,	0.259787569	,	0.854620218	),
  (	70	,	0.307930119	,	0.890352779	),
  (	70	,	0.452837749	,	0.975243666	),
  (	70	,	0.416396844	,	0.978146985	),
  (	70	,	0.304874552	,	0.955379497	),
  (	70	,	0.280431215	,	0.946034976	),
  (	70	,	0.212429336	,	0.909329237	),
  (	70	,	0.154847144	,	0.94603009	),
  (	70	,	0.160452484	,	0.959186061	),
  (	70	,	0.112118904	,	0.959829787	),
  (	70	,	0.114312169	,	0.990979148	),
  (	70	,	0.027388382	,	1.019924784	),
  (	70	,	0.271093465	,	0.98311941	),
  (	70	,	0.277591292	,	1.028158052	),
  (	70	,	0.010012011	,	1.059468804	),
  (	70	,	0.837685603	,	0.805093012	),
  (	70	,	0.889201238	,	0.848304122	),
  (	70	,	0.718007045	,	0.817524866	),
  (	70	,	0.753400549	,	0.852006666	),
  (	70	,	0.674879421	,	0.87381172	),
  (	70	,	0.732705396	,	0.970636217	),
  (	70	,	0.61618015	,	0.951379883	),
  (	70	,	1.028759131	,	0.993420647	),
  (	70	,	1.0421041	,	1.002702732	),
  (	70	,	1.29702912	,	1.077795445	),
  (	70	,	1.372887725	,	1.101772119	),
  (	70	,	0.959880667	,	1.114731597	),
  (	70	,	1.191708416	,	1.180387987	),
  (	70	,	1.433354951	,	1.296906974	),
  (	70	,	0.468184208	,	1.012660432	),
  (	70	,	0.504898786	,	1.034516659	),
  (	70	,	0.609733477	,	1.047712131	),
  (	70	,	0.391730422	,	1.137449705	),
  (	70	,	0.635602265	,	1.074243613	),
  (	70	,	0.224414262	,	1.113191312	),
  (	70	,	0.195552024	,	1.172124384	),
  (	70	,	0.302020222	,	1.216259273	),
  (	70	,	0.334247181	,	1.292011457	),
  (	70	,	0.192198522	,	1.236099256	),
  (	70	,	0.89052597	,	1.294509871	),
  (	70	,	1.032377373	,	1.292941762	),
  (	70	,	1.079627567	,	1.302647854	),
  (	70	,	0.982270044	,	1.301015576	),
  (	70	,	0.674222129	,	1.338978101	),
  (	70	,	0.174497191	,	1.341652478	),
  (	70	,	0.27188774	,	1.428997886	),
  (	70	,	2.344091357	,	0.044066335	),
  (	70	,	2.211011533	,	0.133528725	),
  (	70	,	2.203553779	,	0.164517408	),
  (	70	,	2.174595065	,	0.159722956	),
  (	70	,	2.271294217	,	0.190661202	),
  (	70	,	2.326516146	,	0.303132668	),
  (	70	,	2.523166632	,	0.222290538	),
  (	70	,	2.556324102	,	0.326088465	),
  (	70	,	2.688972817	,	0.309627753	),
  (	70	,	2.488800292	,	0.380700448	),
  (	70	,	2.545452912	,	0.352436564	),
  (	70	,	2.575106213	,	0.428693894	),
  (	70	,	2.11862621	,	0.23569067	),
  (	70	,	2.112267011	,	0.238898641	),
  (	70	,	2.263505442	,	0.41337902	),
  (	70	,	2.251653909	,	0.419771934	),
  (	70	,	1.994439546	,	0.351788409	),
  (	70	,	2.157448965	,	0.361418987	),
  (	70	,	2.21072946	,	0.428192588	),
  (	70	,	2.461495046	,	0.452355099	),
  (	70	,	2.26687998	,	0.567501926	),
  (	70	,	2.271372677	,	0.580795191	),
  (	70	,	2.29348784	,	0.650854617	),
  (	70	,	2.372707588	,	0.676175153	),
  (	70	,	2.721949301	,	0.446242143	),
  (	70	,	2.984019259	,	0.64986929	),
  (	70	,	3.114712552	,	0.714057466	),
  (	70	,	3.062066691	,	0.719726897	),
  (	70	,	3.120601815	,	0.811051091	),
  (	70	,	3.135158032	,	0.833663934	),
  (	70	,	2.827490559	,	0.693630679	),
  (	70	,	3.001653203	,	0.777819671	),
  (	70	,	2.987023245	,	0.848329904	),
  (	70	,	2.590139378	,	0.610581028	),
  (	70	,	2.530557822	,	0.616729164	),
  (	70	,	2.560006312	,	0.78737874	),
  (	70	,	2.740403029	,	0.854582939	),
  (	70	,	2.847130107	,	0.917435246	),
  (	70	,	3.098993351	,	0.946888558	),
  (	70	,	2.700887	,	0.897194798	),
  (	70	,	2.864280152	,	1.003612124	),
  (	70	,	3.134367665	,	1.072758309	),
  (	70	,	2.950981707	,	1.046206305	),
  (	70	,	1.961369777	,	0.342663269	),
  (	70	,	1.974731765	,	0.373631401	),
  (	70	,	1.888545341	,	0.449399131	),
  (	70	,	2.0498628	,	0.458388937	),
  (	70	,	1.892964761	,	0.497313596	),
  (	70	,	1.964490821	,	0.712896583	),
  (	70	,	2.145132959	,	0.566406377	),
  (	70	,	2.181354952	,	0.696118671	),
  (	70	,	2.252608485	,	0.743157993	),
  (	70	,	1.75732961	,	0.568258759	),
  (	70	,	1.813096816	,	0.66174361	),
  (	70	,	1.713348102	,	0.615990455	),
  (	70	,	1.76785062	,	0.687087357	),
  (	70	,	1.648243992	,	0.688948705	),
  (	70	,	1.605018811	,	0.744656971	),
  (	70	,	1.746271097	,	0.773751937	),
  (	70	,	1.715489828	,	0.81116349	),
  (	70	,	1.654042678	,	0.827177913	),
  (	70	,	1.809755726	,	0.853554225	),
  (	70	,	1.884735433	,	0.868993669	),
  (	70	,	1.857319421	,	0.920785462	),
  (	70	,	2.004321703	,	0.881881863	),
  (	70	,	2.014972904	,	0.955843014	),
  (	70	,	1.919337809	,	1.034154411	),
  (	70	,	1.739250868	,	1.072985741	),
  (	70	,	1.684096605	,	1.022823083	),
  (	70	,	2.3260874	,	0.914386118	),
  (	70	,	2.484264984	,	0.981575066	),
  (	70	,	2.152695199	,	0.986590439	),
  (	70	,	2.676811966	,	1.012182665	),
  (	70	,	2.611749569	,	1.028898672	),
  (	70	,	2.10432813	,	1.064539952	),
  (	70	,	1.996397467	,	1.056598707	),
  (	70	,	2.037698528	,	1.117912656	),
  (	70	,	1.970481714	,	1.090859537	),
  (	70	,	2.430473928	,	1.345199713	),
  (	70	,	1.893333627	,	1.37449324	),
  (	70	,	3.906836384	,	0.118415404	),
  (	70	,	4.049491477	,	0.207028097	),
  (	70	,	3.825443386	,	0.224764224	),
  (	70	,	3.919436544	,	0.245003478	),
  (	70	,	4.205501265	,	0.310718971	),
  (	70	,	4.094004693	,	0.427985207	),
  (	70	,	3.707171862	,	0.272640392	),
  (	70	,	3.892626084	,	0.354139202	),
  (	70	,	3.650418773	,	0.277358843	),
  (	70	,	3.6525639	,	0.365712528	),
  (	70	,	3.623262372	,	0.37134946	),
  (	70	,	3.790713543	,	0.451234036	),
  (	70	,	3.679878018	,	0.392622699	),
  (	70	,	3.755737198	,	0.455103661	),
  (	70	,	3.943662591	,	0.472654193	),
  (	70	,	4.07066869	,	0.547317737	),
  (	70	,	4.017873558	,	0.54944839	),
  (	70	,	3.895976738	,	0.570564232	),
  (	70	,	4.360550118	,	0.384065816	),
  (	70	,	4.266331791	,	0.55512904	),
  (	70	,	4.213884045	,	0.562826787	),
  (	70	,	4.526692081	,	0.550098768	),
  (	70	,	4.5411624	,	0.570276628	),
  (	70	,	4.518808023	,	0.605760709	),
  (	70	,	4.487792838	,	0.611469739	),
  (	70	,	4.617777211	,	0.641361341	),
  (	70	,	4.71070659	,	0.754608835	),
  (	70	,	4.502236865	,	0.728327876	),
  (	70	,	4.354884938	,	0.690745392	),
  (	70	,	4.422417269	,	0.747395227	),
  (	70	,	4.659983587	,	0.830490826	),
  (	70	,	4.113202826	,	0.553420896	),
  (	70	,	4.261979848	,	0.69880433	),
  (	70	,	4.189655602	,	0.772817213	),
  (	70	,	4.014420824	,	0.715330355	),
  (	70	,	4.080427177	,	0.753420584	),
  (	70	,	4.036644631	,	0.821362216	),
  (	70	,	4.135434341	,	0.798189375	),
  (	70	,	4.09707764	,	0.819020464	),
  (	70	,	4.33253297	,	0.87514136	),
  (	70	,	4.507768402	,	0.944917143	),
  (	70	,	4.627750855	,	1.000256463	),
  (	70	,	4.257680864	,	0.929147685	),
  (	70	,	4.52075986	,	1.059662061	),
  (	70	,	4.626439598	,	1.111362598	),
  (	70	,	3.556903529	,	0.392707823	),
  (	70	,	3.648083124	,	0.500431671	),
  (	70	,	3.438467564	,	0.433389612	),
  (	70	,	3.397110366	,	0.494271042	),
  (	70	,	3.450360299	,	0.598655755	),
  (	70	,	3.737475285	,	0.562144021	),
  (	70	,	3.46040306	,	0.668049463	),
  (	70	,	3.459351919	,	0.74397824	),
  (	70	,	3.388762718	,	0.760126226	),
  (	70	,	3.229831293	,	0.661515904	),
  (	70	,	3.277177071	,	0.690836575	),
  (	70	,	3.526403265	,	0.882919943	),
  (	70	,	3.565749981	,	0.917920193	),
  (	70	,	3.63611413	,	0.913208342	),
  (	70	,	3.625882118	,	0.930100557	),
  (	70	,	3.655219895	,	0.940906347	),
  (	70	,	3.462831184	,	0.989743718	),
  (	70	,	3.237915387	,	1.074972168	),
  (	70	,	3.892322394	,	0.811163702	),
  (	70	,	4.052881372	,	1.002627459	),
  (	70	,	3.745992907	,	0.908152395	),
  (	70	,	4.002453927	,	1.095561928	),
  (	70	,	3.857446237	,	1.066361989	),
  (	70	,	4.204895598	,	1.03130712	),
  (	70	,	4.666432323	,	1.198858453	),
  (	70	,	4.160351768	,	1.139499165	),
  (	70	,	3.963303854	,	1.148231443	),
  (	70	,	4.426480021	,	1.229824655	),
  (	70	,	3.713292084	,	1.021865979	),
  (	70	,	3.276714497	,	1.150134097	),
  (	70	,	3.203078609	,	1.153825515	),
  (	70	,	4.206242819	,	1.276690788	),
  (	70	,	4.099946184	,	1.395975253	),
  (	70	,	4.05729588	,	1.435768074	),
  (	70	,	5.672461836	,	0.160305747	),
  (	70	,	5.419675959	,	0.113578469	),
  (	70	,	5.436485018	,	0.12879103	),
  (	70	,	5.480723634	,	0.161618673	),
  (	70	,	5.366547676	,	0.179803254	),
  (	70	,	5.723232461	,	0.336968481	),
  (	70	,	5.562233462	,	0.287614611	),
  (	70	,	5.67834628	,	0.382994008	),
  (	70	,	5.691168335	,	0.502327209	),
  (	70	,	5.300836755	,	0.18277771	),
  (	70	,	5.335253784	,	0.217175306	),
  (	70	,	5.247718917	,	0.21570046	),
  (	70	,	5.248062055	,	0.254516162	),
  (	70	,	5.434391974	,	0.315729707	),
  (	70	,	5.431375712	,	0.357607587	),
  (	70	,	5.345856441	,	0.375046053	),
  (	70	,	5.254467608	,	0.309530691	),
  (	70	,	5.249272009	,	0.319312995	),
  (	70	,	5.213035876	,	0.391463051	),
  (	70	,	5.326316924	,	0.388802597	),
  (	70	,	5.444536906	,	0.456891342	),
  (	70	,	5.625437869	,	0.498850221	),
  (	70	,	5.632223123	,	0.557771407	),
  (	70	,	5.419420486	,	0.546497674	),
  (	70	,	5.440156032	,	0.565832748	),
  (	70	,	5.496545959	,	0.677587594	),
  (	70	,	5.832324543	,	0.39960903	),
  (	70	,	5.984054944	,	0.460611442	),
  (	70	,	5.773728987	,	0.527146066	),
  (	70	,	5.803693699	,	0.614594578	),
  (	70	,	5.932153457	,	0.676287074	),
  (	70	,	6.066266991	,	0.567004869	),
  (	70	,	6.065667844	,	0.589355273	),
  (	70	,	6.048456018	,	0.64263344	),
  (	70	,	6.134908316	,	0.686601411	),
  (	70	,	6.13681588	,	0.704857714	),
  (	70	,	6.160301032	,	0.769218962	),
  (	70	,	6.078218421	,	0.734121767	),
  (	70	,	5.934537444	,	0.709825306	),
  (	70	,	6.002989375	,	0.773323748	),
  (	70	,	6.255146929	,	0.899239302	),
  (	70	,	5.718181991	,	0.56997678	),
  (	70	,	5.73931082	,	0.630867911	),
  (	70	,	5.688079011	,	0.668537544	),
  (	70	,	5.807848808	,	0.751024617	),
  (	70	,	5.62478386	,	0.784055211	),
  (	70	,	5.74685367	,	0.813191453	),
  (	70	,	5.78866834	,	0.904182678	),
  (	70	,	5.698707803	,	0.884431294	),
  (	70	,	5.928871505	,	0.773427139	),
  (	70	,	5.957718311	,	0.781076346	),
  (	70	,	5.950234034	,	0.827491502	),
  (	70	,	5.938683178	,	0.903355912	),
  (	70	,	5.94835712	,	0.984515929	),
  (	70	,	6.158525641	,	1.032646858	),
  (	70	,	6.252995873	,	1.059492955	),
  (	70	,	6.004182316	,	1.015709514	),
  (	70	,	6.031944799	,	1.044626136	),
  (	70	,	5.113946774	,	0.365286814	),
  (	70	,	5.1361145	,	0.384075887	),
  (	70	,	5.162334141	,	0.429282204	),
  (	70	,	5.034793782	,	0.44957646	),
  (	70	,	5.114217539	,	0.446745486	),
  (	70	,	5.057505004	,	0.475798654	),
  (	70	,	5.18369061	,	0.48644195	),
  (	70	,	5.224618653	,	0.500801492	),
  (	70	,	5.252240445	,	0.523414334	),
  (	70	,	5.221562896	,	0.540135569	),
  (	70	,	5.186673355	,	0.513166772	),
  (	70	,	5.210515761	,	0.589593044	),
  (	70	,	4.979860126	,	0.495883169	),
  (	70	,	5.012873735	,	0.528851267	),
  (	70	,	5.043703595	,	0.541660391	),
  (	70	,	4.969178576	,	0.52677515	),
  (	70	,	4.963515102	,	0.575778197	),
  (	70	,	4.970019471	,	0.578003386	),
  (	70	,	4.975967415	,	0.588905362	),
  (	70	,	5.012381995	,	0.606681323	),
  (	70	,	5.078766864	,	0.571140652	),
  (	70	,	5.193795154	,	0.630031411	),
  (	70	,	5.131810089	,	0.614594122	),
  (	70	,	5.084590959	,	0.650047797	),
  (	70	,	5.136910659	,	0.673596691	),
  (	70	,	5.298426261	,	0.526692686	),
  (	70	,	5.358444544	,	0.591455831	),
  (	70	,	5.231020788	,	0.619553766	),
  (	70	,	5.251215186	,	0.628756619	),
  (	70	,	5.266983248	,	0.642746285	),
  (	70	,	5.248104938	,	0.659958386	),
  (	70	,	5.287430731	,	0.703891314	),
  (	70	,	5.414396477	,	0.71911906	),
  (	70	,	5.352618016	,	0.689334083	),
  (	70	,	5.344256824	,	0.700813499	),
  (	70	,	5.346949376	,	0.743601856	),
  (	70	,	5.282848867	,	0.719896841	),
  (	70	,	5.162137001	,	0.698083588	),
  (	70	,	5.302688929	,	0.798331848	),
  (	70	,	5.214551218	,	0.829748319	),
  (	70	,	4.927934663	,	0.588195678	),
  (	70	,	4.961866554	,	0.636519447	),
  (	70	,	4.910316201	,	0.63821933	),
  (	70	,	4.866670357	,	0.678842614	),
  (	70	,	5.063428011	,	0.696843102	),
  (	70	,	5.074572573	,	0.750041049	),
  (	70	,	4.977833947	,	0.737428653	),
  (	70	,	4.992785247	,	0.765859391	),
  (	70	,	4.956530852	,	0.771934298	),
  (	70	,	4.761330843	,	0.682433651	),
  (	70	,	4.748885488	,	0.769912876	),
  (	70	,	4.899336916	,	0.830348715	),
  (	70	,	5.087723584	,	0.785627276	),
  (	70	,	5.188288603	,	0.938420796	),
  (	70	,	5.176697029	,	0.949557208	),
  (	70	,	5.068446646	,	0.91414261	),
  (	70	,	5.036769484	,	0.976345781	),
  (	70	,	4.946895861	,	1.047509178	),
  (	70	,	5.477894032	,	0.756898779	),
  (	70	,	5.576540374	,	0.817814751	),
  (	70	,	5.45892151	,	0.897405418	),
  (	70	,	5.67196425	,	0.898439497	),
  (	70	,	5.602362369	,	0.901588325	),
  (	70	,	5.692622699	,	1.016233121	),
  (	70	,	5.63318245	,	1.037047668	),
  (	70	,	5.497033828	,	0.963736337	),
  (	70	,	5.384068033	,	1.077626813	),
  (	70	,	5.774198834	,	0.957838069	),
  (	70	,	5.892860297	,	1.075537275	),
  (	70	,	5.747780837	,	1.069804609	),
  (	70	,	5.854990419	,	1.10200272	),
  (	70	,	5.802090583	,	1.119145969	),
  (	70	,	5.949088187	,	1.093822696	),
  (	70	,	6.054989787	,	1.145229157	),
  (	70	,	6.128711735	,	1.114445247	),
  (	70	,	5.968512073	,	1.135548973	),
  (	70	,	5.683940718	,	1.112138239	),
  (	70	,	5.70832514	,	1.137444006	),
  (	70	,	5.6312963	,	1.191942943	),
  (	70	,	5.973491292	,	1.196784172	),
  (	70	,	5.204549298	,	1.120080562	),
  (	70	,	5.422774724	,	1.157620077	),
  (	70	,	5.266531252	,	1.157290585	),
  (	70	,	5.184426203	,	1.226425876	),
  (	70	,	4.735023976	,	1.168421194	),
  (	70	,	5.145101643	,	1.198215394	),
  (	70	,	5.056806701	,	1.283712861	),
  (	70	,	4.943712307	,	1.252925314	),
  (	70	,	4.72481315	,	1.322793557	),
  (	70	,	5.729915329	,	1.256455729	),
  (	70	,	5.539611115	,	1.312970417	),
  (	70	,	5.596743552	,	1.336154235	),
  (	70	,	5.481260461	,	1.321565971	),
  (	70	,	5.550435086	,	1.331864885	),
  (	70	,	6.159558655	,	1.358211435	),
  (	70	,	6.100048122	,	1.394070691	),
  (	70	,	5.931587216	,	1.420560839	),
  (	70	,	5.294100129	,	1.390178553	),
  (	70	,	5.513517586	,	1.416528818	),
  (	70	,	5.345312089	,	1.451814146	),
  (	70	,	0.015011941	,	-0.632701944	),
  (	70	,	0.17695994	,	-0.513489838	),
  (	70	,	0.123192988	,	-0.506851446	),
  (	70	,	0.018321269	,	-0.52595308	),
  (	70	,	6.251250321	,	-0.436071886	),
  (	70	,	0.142489948	,	-0.442617052	),
  (	70	,	0.25145704	,	-0.331587962	),
  (	70	,	0.062589314	,	-0.369985169	),
  (	70	,	0.087485921	,	-0.308931686	),
  (	70	,	0.184329572	,	-0.206037192	),
  (	70	,	6.042486611	,	-0.473614278	),
  (	70	,	6.145389963	,	-0.443674248	),
  (	70	,	6.10208393	,	-0.328846669	),
  (	70	,	6.143304075	,	-0.267022953	),
  (	70	,	6.138983869	,	-0.266123446	),
  (	70	,	0.009972617	,	-0.233999932	),
  (	70	,	0.124600458	,	-0.196128214	),
  (	70	,	6.162895531	,	-0.191964163	),
  (	70	,	0.048701407	,	-0.057970607	),
  (	70	,	0.008921607	,	-0.048279192	),
  (	70	,	0.322977735	,	-0.235183667	),
  (	70	,	0.38514645	,	-0.213736093	),
  (	70	,	0.559949255	,	-0.175253545	),
  (	70	,	0.223971597	,	-0.164156582	),
  (	70	,	0.439704772	,	-0.045766153	),
  (	70	,	0.354705916	,	-0.107508252	),
  (	70	,	0.524671071	,	-0.058789814	),
  (	70	,	0.677745492	,	-0.062197325	),
  (	70	,	0.740159731	,	0.016070694	),
  (	70	,	0.536134862	,	-0.041504247	),
  (	70	,	0.556604162	,	-0.01081777	),
  (	70	,	0.413731425	,	0.016456447	),
  (	70	,	0.53684105	,	0.058636287	),
  (	70	,	0.523490304	,	0.105336991	),
  (	70	,	0.150320268	,	-0.11352488	),
  (	70	,	0.060179968	,	0.024146448	),
  (	70	,	0.456397801	,	0.056262975	),
  (	70	,	0.461334394	,	0.064004025	),
  (	70	,	0.46753872	,	0.189266362	),
  (	70	,	0.254491062	,	0.119454946	),
  (	70	,	0.290708816	,	0.145905448	),
  (	70	,	0.273634867	,	0.159397321	),
  (	70	,	0.298293749	,	0.17293064	),
  (	70	,	0.315541173	,	0.214351894	),
  (	70	,	0.361696109	,	0.198377296	),
  (	70	,	0.354834699	,	0.201354151	),
  (	70	,	0.433103034	,	0.249326752	),
  (	70	,	0.433075695	,	0.290166832	),
  (	70	,	0.401668614	,	0.295761246	),
  (	70	,	5.940349536	,	-0.213454127	),
  (	70	,	5.876067345	,	-0.195970531	),
  (	70	,	5.961332237	,	-0.194892577	),
  (	70	,	5.934721243	,	-0.163343955	),
  (	70	,	5.992838007	,	-0.104517051	),
  (	70	,	5.797954126	,	-0.232138269	),
  (	70	,	5.866928826	,	-0.020706719	),
  (	70	,	6.167463714	,	-0.076818449	),
  (	70	,	6.150125771	,	-0.018082738	),
  (	70	,	6.138005439	,	0.043257919	),
  (	70	,	5.910550061	,	0.010378705	),
  (	70	,	6.121252315	,	0.049187154	),
  (	70	,	6.127302752	,	0.064844782	),
  (	70	,	6.070406464	,	0.087341637	),
  (	70	,	5.700819267	,	-0.038617435	),
  (	70	,	5.861948806	,	0.01062191	),
  (	70	,	5.53191035	,	0.020131256	),
  (	70	,	5.536440975	,	0.031197519	),
  (	70	,	5.553439745	,	0.046121983	),
  (	70	,	5.946703424	,	0.086722969	),
  (	70	,	5.962388585	,	0.13234698	),
  (	70	,	5.987990141	,	0.181761384	),
  (	70	,	5.792412154	,	0.168790287	),
  (	70	,	5.853305982	,	0.250803245	),
  (	70	,	5.866120068	,	0.283839108	),
  (	70	,	6.269177623	,	0.082469764	),
  (	70	,	0.112135882	,	0.134230009	),
  (	70	,	0.149145917	,	0.179735965	),
  (	70	,	6.171583109	,	0.095479177	),
  (	70	,	6.176051473	,	0.148695464	),
  (	70	,	6.174892238	,	0.220987819	),
  (	70	,	0.143691823	,	0.282174798	),
  (	70	,	0.329303295	,	0.356298017	),
  (	70	,	6.023742689	,	0.235068585	),
  (	70	,	6.167938641	,	0.311000155	),
  (	70	,	6.218022327	,	0.373319748	),
  (	70	,	5.985472536	,	0.263298798	),
  (	70	,	6.05378172	,	0.359213191	),
  (	70	,	6.167429117	,	0.424857022	),
  (	70	,	6.133341161	,	0.435522702	),
  (	70	,	6.088511407	,	0.44806696	),
  (	70	,	6.228595446	,	0.446445883	),
  (	70	,	0.099631678	,	0.51407302	),
  (	70	,	6.176279871	,	0.541382653	),
  (	70	,	6.266283659	,	0.584464979	),
  (	70	,	1.539359541	,	-0.672406893	),
  (	70	,	1.569249167	,	-0.61701379	),
  (	70	,	1.729904573	,	-0.55652766	),
  (	70	,	1.634084681	,	-0.516692016	),
  (	70	,	1.713794694	,	-0.478285344	),
  (	70	,	1.45416575	,	-0.598717542	),
  (	70	,	1.430481398	,	-0.565797855	),
  (	70	,	1.436017829	,	-0.525634871	),
  (	70	,	1.645905507	,	-0.42018433	),
  (	70	,	1.600222803	,	-0.435048177	),
  (	70	,	1.535476886	,	-0.440161984	),
  (	70	,	1.552826404	,	-0.378564386	),
  (	70	,	1.82827503	,	-0.462065484	),
  (	70	,	1.839837979	,	-0.410176849	),
  (	70	,	1.7560605	,	-0.405484287	),
  (	70	,	1.792792197	,	-0.364954493	),
  (	70	,	1.773388735	,	-0.346935088	),
  (	70	,	1.920211056	,	-0.361355086	),
  (	70	,	1.938580887	,	-0.320230101	),
  (	70	,	1.915771012	,	-0.300434132	),
  (	70	,	1.836375483	,	-0.339369037	),
  (	70	,	1.844911124	,	-0.291458964	),
  (	70	,	1.699192829	,	-0.394287722	),
  (	70	,	1.704497066	,	-0.389588939	),
  (	70	,	1.645550041	,	-0.390508539	),
  (	70	,	1.722479396	,	-0.358794695	),
  (	70	,	1.700089363	,	-0.296903263	),
  (	70	,	1.677051872	,	-0.28317308	),
  (	70	,	1.672492172	,	-0.258927237	),
  (	70	,	1.778512719	,	-0.305581142	),
  (	70	,	1.801033032	,	-0.282956367	),
  (	70	,	1.754033395	,	-0.279378232	),
  (	70	,	1.782226941	,	-0.224111261	),
  (	70	,	1.458499617	,	-0.328332346	),
  (	70	,	1.418080446	,	-0.338138885	),
  (	70	,	1.265858882	,	-0.275840999	),
  (	70	,	1.326207029	,	-0.254053613	),
  (	70	,	1.336788387	,	-0.256503083	),
  (	70	,	1.692897921	,	-0.229695741	),
  (	70	,	1.658558238	,	-0.137394449	),
  (	70	,	1.649956478	,	-0.11737565	),
  (	70	,	1.434258113	,	-0.146200126	),
  (	70	,	1.477691648	,	-0.147846749	),
  (	70	,	1.465646287	,	-0.098234062	),
  (	70	,	1.473112724	,	-0.086116597	),
  (	70	,	1.591362059	,	-0.027586074	),
  (	70	,	1.936856871	,	-0.303924446	),
  (	70	,	1.946296723	,	-0.273434555	),
  (	70	,	2.031033837	,	-0.256324284	),
  (	70	,	1.991669898	,	-0.254732228	),
  (	70	,	1.864715723	,	-0.174273456	),
  (	70	,	1.947880652	,	-0.176095325	),
  (	70	,	1.817688009	,	-0.145451663	),
  (	70	,	1.874214135	,	-0.105486375	),
  (	70	,	1.920356055	,	-0.06832109	),
  (	70	,	2.142271289	,	-0.117768354	),
  (	70	,	2.116109202	,	-0.061012161	),
  (	70	,	2.292254875	,	-0.045398212	),
  (	70	,	2.310887403	,	0.025873323	),
  (	70	,	2.270242166	,	0.03350868	),
  (	70	,	2.00253036	,	-0.004546542	),
  (	70	,	2.103666351	,	0.051672269	),
  (	70	,	1.797094187	,	-0.037979188	),
  (	70	,	1.732656182	,	-0.038031556	),
  (	70	,	1.948523416	,	-0.00819567	),
  (	70	,	1.881431194	,	0.055703751	),
  (	70	,	1.7646298	,	0.054830745	),
  (	70	,	1.76955067	,	0.080182029	),
  (	70	,	1.719759428	,	0.050597148	),
  (	70	,	2.037703944	,	0.08595859	),
  (	70	,	2.054289231	,	0.102267812	),
  (	70	,	2.139334356	,	0.160013603	),
  (	70	,	2.125408362	,	0.174186665	),
  (	70	,	2.076041374	,	0.182271549	),
  (	70	,	1.869126676	,	0.137555352	),
  (	70	,	1.875574954	,	0.162469101	),
  (	70	,	1.316822607	,	-0.190829825	),
  (	70	,	1.322228148	,	-0.151201004	),
  (	70	,	1.295817736	,	-0.147634916	),
  (	70	,	1.077765281	,	-0.1745583	),
  (	70	,	1.078884001	,	-0.170307524	),
  (	70	,	1.103649189	,	-0.111511332	),
  (	70	,	1.261983835	,	-0.08703033	),
  (	70	,	1.101034908	,	-0.076972931	),
  (	70	,	1.159158962	,	-0.024627358	),
  (	70	,	1.325207253	,	-0.044330002	),
  (	70	,	1.368560521	,	-0.063216391	),
  (	70	,	1.404865248	,	-0.051725681	),
  (	70	,	1.466531814	,	-0.077244362	),
  (	70	,	1.484963452	,	-0.059813983	),
  (	70	,	1.455728377	,	-0.06044448	),
  (	70	,	1.472971029	,	-0.024821006	),
  (	70	,	1.26072619	,	0.064395902	),
  (	70	,	1.4379718	,	0.054941699	),
  (	70	,	1.311364591	,	0.06308776	),
  (	70	,	0.959004092	,	-0.118281397	),
  (	70	,	0.833062541	,	0.040415793	),
  (	70	,	0.872795839	,	0.025894428	),
  (	70	,	1.024108687	,	0.036478141	),
  (	70	,	1.012306346	,	0.114051817	),
  (	70	,	1.169758393	,	0.142327101	),
  (	70	,	1.28691555	,	0.150097768	),
  (	70	,	1.34290094	,	0.190154814	),
  (	70	,	1.060262672	,	0.160698225	),
  (	70	,	1.072036187	,	0.175181377	),
  (	70	,	1.134103677	,	0.288369162	),
  (	70	,	1.200085311	,	0.300217838	),
  (	70	,	1.1759546	,	0.311767162	),
  (	70	,	1.193576613	,	0.31445052	),
  (	70	,	1.563053918	,	0.032399335	),
  (	70	,	1.623221505	,	0.118356042	),
  (	70	,	1.584612121	,	0.133118816	),
  (	70	,	1.568447907	,	0.146875795	),
  (	70	,	1.750390296	,	0.165212095	),
  (	70	,	1.623063547	,	0.12900252	),
  (	70	,	1.602029904	,	0.159969476	),
  (	70	,	1.68286173	,	0.195821675	),
  (	70	,	1.655549686	,	0.234465075	),
  (	70	,	1.476383725	,	0.148130731	),
  (	70	,	1.55988343	,	0.245400228	),
  (	70	,	1.496474009	,	0.247460381	),
  (	70	,	1.504855584	,	0.280753742	),
  (	70	,	1.734695314	,	0.212556403	),
  (	70	,	1.856933355	,	0.252602611	),
  (	70	,	1.682938337	,	0.245963602	),
  (	70	,	1.773044452	,	0.328778052	),
  (	70	,	1.816341844	,	0.309566474	),
  (	70	,	1.822625343	,	0.312448518	),
  (	70	,	1.810541983	,	0.376491331	),
  (	70	,	1.864370904	,	0.421816086	),
  (	70	,	1.680294367	,	0.296613126	),
  (	70	,	1.711723896	,	0.310316033	),
  (	70	,	1.68497162	,	0.327351031	),
  (	70	,	1.703284651	,	0.393481903	),
  (	70	,	1.655102777	,	0.409618263	),
  (	70	,	1.76496804	,	0.361160637	),
  (	70	,	1.809525417	,	0.423153085	),
  (	70	,	1.769697451	,	0.482989001	),
  (	70	,	1.431837429	,	0.286908484	),
  (	70	,	1.531862798	,	0.323780561	),
  (	70	,	1.508212471	,	0.36119606	),
  (	70	,	1.447110406	,	0.318415177	),
  (	70	,	1.440990859	,	0.358691407	),
  (	70	,	1.455224438	,	0.42984888	),
  (	70	,	1.362911022	,	0.4617023	),
  (	70	,	1.518155129	,	0.430865627	),
  (	70	,	1.602795367	,	0.465691166	),
  (	70	,	1.586352966	,	0.463020169	),
  (	70	,	1.571155552	,	0.49088459	),
  (	70	,	1.667067652	,	0.522972075	),
  (	70	,	1.496492429	,	0.581445743	),
  (	70	,	1.572579613	,	0.60227573	),
  (	70	,	1.639073097	,	0.630914332	),
  (	70	,	1.6032184	,	0.633111941	),
  (	70	,	1.514111868	,	0.598854228	),
  (	70	,	3.177902747	,	-0.605191163	),
  (	70	,	3.290791246	,	-0.560122301	),
  (	70	,	3.279668948	,	-0.540736445	),
  (	70	,	3.284857091	,	-0.524379475	),
  (	70	,	3.251669888	,	-0.453542979	),
  (	70	,	3.219803697	,	-0.419112995	),
  (	70	,	3.062904145	,	-0.425615611	),
  (	70	,	3.388131531	,	-0.461821804	),
  (	70	,	3.350542499	,	-0.436603696	),
  (	70	,	3.395362293	,	-0.402389501	),
  (	70	,	3.379406328	,	-0.350777125	),
  (	70	,	3.333286926	,	-0.229371163	),
  (	70	,	3.000332384	,	-0.45135398	),
  (	70	,	3.182976376	,	-0.206965141	),
  (	70	,	3.304577131	,	-0.144870004	),
  (	70	,	3.052167292	,	-0.230127955	),
  (	70	,	3.019169315	,	-0.112942236	),
  (	70	,	3.191193438	,	-0.047117293	),
  (	70	,	3.133344543	,	-0.076271234	),
  (	70	,	3.57781664	,	-0.287047289	),
  (	70	,	3.598621725	,	-0.248297288	),
  (	70	,	3.539597849	,	-0.234725117	),
  (	70	,	3.647238249	,	-0.170260362	),
  (	70	,	3.492096546	,	-0.197295317	),
  (	70	,	3.479545305	,	-0.184065605	),
  (	70	,	3.738602339	,	-0.09850779	),
  (	70	,	3.754545968	,	0.003164541	),
  (	70	,	3.647764905	,	-0.063915998	),
  (	70	,	3.61565905	,	-0.049576644	),
  (	70	,	3.70649897	,	0.048826934	),
  (	70	,	3.314020457	,	-0.106475567	),
  (	70	,	3.387872202	,	-0.016667536	),
  (	70	,	3.384365263	,	0.000964476	),
  (	70	,	3.392199052	,	0.024920552	),
  (	70	,	3.30680128	,	0.074846546	),
  (	70	,	3.682411095	,	0.196912808	),
  (	70	,	3.629611591	,	0.208346588	),
  (	70	,	3.442019531	,	0.090801035	),
  (	70	,	3.472252614	,	0.138806171	),
  (	70	,	3.402371933	,	0.166260001	),
  (	70	,	2.568792613	,	-0.173114033	),
  (	70	,	2.601119932	,	-0.133435443	),
  (	70	,	2.732784231	,	-0.112177289	),
  (	70	,	2.708474534	,	-0.093935711	),
  (	70	,	2.924367716	,	-0.128990402	),
  (	70	,	2.891192888	,	-0.061308533	),
  (	70	,	2.867267928	,	-0.005448631	),
  (	70	,	2.566555891	,	-0.126463523	),
  (	70	,	2.464783366	,	-0.07475673	),
  (	70	,	2.650959433	,	0.016026854	),
  (	70	,	2.484075677	,	-0.055246221	),
  (	70	,	2.421061825	,	-0.02770108	),
  (	70	,	2.432768031	,	0.009681675	),
  (	70	,	2.592298337	,	0.086315398	),
  (	70	,	2.747582994	,	0.026009972	),
  (	70	,	2.731339704	,	0.051123876	),
  (	70	,	2.600175103	,	0.133989304	),
  (	70	,	3.133879758	,	0.060772036	),
  (	70	,	3.19251485	,	0.070790018	),
  (	70	,	3.292190545	,	0.134991017	),
  (	70	,	2.994550857	,	0.151135319	),
  (	70	,	3.146952932	,	0.216033505	),
  (	70	,	3.126087345	,	0.247594534	),
  (	70	,	3.475867001	,	0.329925152	),
  (	70	,	3.453737316	,	0.382550029	),
  (	70	,	3.416437475	,	0.395097476	),
  (	70	,	3.255277153	,	0.276879181	),
  (	70	,	3.344668329	,	0.421384201	),
  (	70	,	2.917663784	,	0.300190124	),
  (	70	,	3.054994028	,	0.413785677	),
  (	70	,	2.896126843	,	0.449853515	),
  (	70	,	2.910683098	,	0.445705142	),
  (	70	,	2.957192325	,	0.477560405	),
  (	70	,	3.192943948	,	0.407051745	),
  (	70	,	3.321050447	,	0.531229518	),
  (	70	,	3.074970067	,	0.500390025	),
  (	70	,	3.014672529	,	0.496573777	),
  (	70	,	2.991648806	,	0.523378946	),
  (	70	,	3.069683207	,	0.554347992	),
  (	70	,	4.673566718	,	-0.616925745	),
  (	70	,	4.687815739	,	-0.608744262	),
  (	70	,	4.647092901	,	-0.620149341	),
  (	70	,	4.682753689	,	-0.559070423	),
  (	70	,	4.8052146	,	-0.540032605	),
  (	70	,	4.881239871	,	-0.524086418	),
  (	70	,	4.839792699	,	-0.510680783	),
  (	70	,	4.874071651	,	-0.497663276	),
  (	70	,	4.778210467	,	-0.520511744	),
  (	70	,	4.804921591	,	-0.455269459	),
  (	70	,	4.640771636	,	-0.570073836	),
  (	70	,	4.578066165	,	-0.550377269	),
  (	70	,	4.539861843	,	-0.51252003	),
  (	70	,	4.725064286	,	-0.485667221	),
  (	70	,	4.6702912	,	-0.472320437	),
  (	70	,	4.729612883	,	-0.424333955	),
  (	70	,	4.707826277	,	-0.393005516	),
  (	70	,	4.92127087	,	-0.353857579	),
  (	70	,	5.035913103	,	-0.385032391	),
  (	70	,	5.053524341	,	-0.329237286	),
  (	70	,	4.944120367	,	-0.325277378	),
  (	70	,	4.849013174	,	-0.330044749	),
  (	70	,	4.922681329	,	-0.256712214	),
  (	70	,	4.503737812	,	-0.471988632	),
  (	70	,	4.474608958	,	-0.385243997	),
  (	70	,	4.594505475	,	-0.305360169	),
  (	70	,	4.428103902	,	-0.410372679	),
  (	70	,	4.436624609	,	-0.404047617	),
  (	70	,	4.636776971	,	-0.271560733	),
  (	70	,	4.809167998	,	-0.130880316	),
  (	70	,	4.750151602	,	-0.050743673	),
  (	70	,	5.096744817	,	-0.320431403	),
  (	70	,	5.078104329	,	-0.300126974	),
  (	70	,	5.103485835	,	-0.220728843	),
  (	70	,	5.193066728	,	-0.174656541	),
  (	70	,	5.134955207	,	-0.177284056	),
  (	70	,	4.969921307	,	-0.219698278	),
  (	70	,	5.061658954	,	-0.115682304	),
  (	70	,	5.271445655	,	-0.118009084	),
  (	70	,	5.302205278	,	-0.061156971	),
  (	70	,	5.436788878	,	-0.00594198	),
  (	70	,	5.361801145	,	-0.030278728	),
  (	70	,	5.317263577	,	0.011188655	),
  (	70	,	5.223861689	,	0.006144614	),
  (	70	,	5.23044513	,	0.029081222	),
  (	70	,	5.290896713	,	0.015118987	),
  (	70	,	5.237533767	,	0.058151271	),
  (	70	,	5.261878965	,	0.083348377	),
  (	70	,	4.915771132	,	-0.141716059	),
  (	70	,	4.907345112	,	-0.114077466	),
  (	70	,	4.893801096	,	-0.054426907	),
  (	70	,	4.93530616	,	-0.056924304	),
  (	70	,	4.87599603	,	-0.050963439	),
  (	70	,	4.988683006	,	0.010054487	),
  (	70	,	5.026786631	,	0.045772165	),
  (	70	,	4.849253288	,	-0.008412035	),
  (	70	,	4.874519594	,	0.016603274	),
  (	70	,	4.881092485	,	0.084726439	),
  (	70	,	4.871577592	,	0.086479346	),
  (	70	,	4.846281081	,	0.07872817	),
  (	70	,	5.229635619	,	0.138244078	),
  (	70	,	5.218353267	,	0.178149545	),
  (	70	,	5.248514757	,	0.19044457	),
  (	70	,	5.160787067	,	0.146313326	),
  (	70	,	4.999475042	,	0.114254417	),
  (	70	,	5.036603674	,	0.204425953	),
  (	70	,	5.132116031	,	0.212258731	),
  (	70	,	5.089968883	,	0.206843242	),
  (	70	,	5.013438556	,	0.2579746	),
  (	70	,	5.032029841	,	0.262420886	),
  (	70	,	5.123901802	,	0.283877045	),
  (	70	,	5.09682489	,	0.311479335	),
  (	70	,	4.288683705	,	-0.297041004	),
  (	70	,	4.329001508	,	-0.216974143	),
  (	70	,	4.318849159	,	-0.194247776	),
  (	70	,	4.348146822	,	-0.154532011	),
  (	70	,	4.247369666	,	-0.070714845	),
  (	70	,	4.563996774	,	-0.114876486	),
  (	70	,	4.590051527	,	0.000740998	),
  (	70	,	4.416249947	,	-0.04883972	),
  (	70	,	4.495352612	,	0.00840615	),
  (	70	,	4.357033327	,	-0.021495613	),
  (	70	,	4.527451365	,	0.030411496	),
  (	70	,	4.529486137	,	0.054933598	),
  (	70	,	4.507258669	,	0.135254506	),
  (	70	,	4.196139416	,	-0.065680774	),
  (	70	,	4.231070365	,	0.014306275	),
  (	70	,	4.32559081	,	0.022845447	),
  (	70	,	4.3658794	,	0.073428328	),
  (	70	,	4.369882751	,	0.085027315	),
  (	70	,	4.319045042	,	0.104210201	),
  (	70	,	4.438967696	,	0.108407775	),
  (	70	,	4.456261484	,	0.129650074	),
  (	70	,	4.300838629	,	0.1635455	),
  (	70	,	4.215178062	,	0.232491572	),
  (	70	,	4.703007808	,	0.039332115	),
  (	70	,	4.736927669	,	0.081244208	),
  (	70	,	4.677487442	,	0.07831801	),
  (	70	,	4.888565689	,	0.154783024	),
  (	70	,	4.843079674	,	0.182968547	),
  (	70	,	4.790353397	,	0.207305029	),
  (	70	,	4.795727604	,	0.212812594	),
  (	70	,	4.669424549	,	0.17187969	),
  (	70	,	4.606998269	,	0.210260094	),
  (	70	,	4.643911791	,	0.240578182	),
  (	70	,	4.933868772	,	0.191574891	),
  (	70	,	4.954434839	,	0.230776296	),
  (	70	,	4.985704115	,	0.254241889	),
  (	70	,	4.872529959	,	0.269622383	),
  (	70	,	4.868981444	,	0.296272781	),
  (	70	,	4.913429477	,	0.322672519	),
  (	70	,	4.995504204	,	0.274644649	),
  (	70	,	5.070463947	,	0.309853862	),
  (	70	,	4.979842903	,	0.375486974	),
  (	70	,	5.022945135	,	0.409801831	),
  (	70	,	5.011836115	,	0.422008537	),
  (	70	,	4.981089669	,	0.436785628	),
  (	70	,	4.83353695	,	0.43105242	),
  (	70	,	4.584030151	,	0.305810728	),
  (	70	,	4.587210261	,	0.340716104	),
  (	70	,	4.510166136	,	0.374047356	),
  (	70	,	4.541248175	,	0.375585996	),
  (	70	,	4.548603095	,	0.434206501	),
  (	70	,	4.49981527	,	0.423288141	),
  (	70	,	4.535227687	,	0.489143888	),
  (	70	,	4.739807485	,	0.42609948	),
  (	70	,	4.762710387	,	0.446128671	),
  (	70	,	4.654252044	,	0.449402137	),
  (	70	,	4.729419995	,	0.465145164	),
  (	70	,	4.827960468	,	0.461831093	),
  (	70	,	4.875919909	,	0.516364232	),
  (	70	,	4.781723413	,	0.530579411	),
  (	70	,	4.753223854	,	0.522763416	),
  (	70	,	4.543285943	,	0.545537283	),
  (	70	,	4.602245808	,	0.60653009	),
  (	70	,	1.483433615	,	-1.499487132	),
  (	70	,	0.508948567	,	-1.422427249	),
  (	70	,	1.130551827	,	-1.387900228	),
  (	70	,	0.527828009	,	-1.376553482	),
  (	70	,	0.66883431	,	-1.324588447	),
  (	70	,	0.830461023	,	-1.296695065	),
  (	70	,	0.949797176	,	-1.305900405	),
  (	70	,	0.67082527	,	-1.262731868	),
  (	70	,	0.693276357	,	-1.233595549	),
  (	70	,	1.196673508	,	-1.277727364	),
  (	70	,	1.491004912	,	-1.176399107	),
  (	70	,	1.271218081	,	-1.188032211	),
  (	70	,	0.936553125	,	-1.091827675	),
  (	70	,	1.047154192	,	-1.080268613	),
  (	70	,	0.221972544	,	-1.24182224	),
  (	70	,	0.531620662	,	-1.110419858	),
  (	70	,	0.333769862	,	-1.176890487	),
  (	70	,	0.356969279	,	-1.158622306	),
  (	70	,	0.410132005	,	-1.090415688	),
  (	70	,	0.762712182	,	-1.117036136	),
  (	70	,	0.850351554	,	-1.038706474	),
  (	70	,	0.996645621	,	-0.947603019	),
  (	70	,	0.936881879	,	-0.948096378	),
  (	70	,	0.737334264	,	-0.786970068	),
  (	70	,	1.443139829	,	-0.997631938	),
  (	70	,	1.252776119	,	-1.032135294	),
  (	70	,	1.152781483	,	-0.996091833	),
  (	70	,	1.15844834	,	-0.926972605	),
  (	70	,	1.238426993	,	-0.843431186	),
  (	70	,	1.229462761	,	-0.824826891	),
  (	70	,	1.540949347	,	-0.836973571	),
  (	70	,	1.535553493	,	-0.71742129	),
  (	70	,	1.28311401	,	-0.6660667	),
  (	70	,	1.375084269	,	-0.639713157	),
  (	70	,	1.412182038	,	-0.651647031	),
  (	70	,	1.07711347	,	-0.866177995	),
  (	70	,	0.967603165	,	-0.833840114	),
  (	70	,	1.101862196	,	-0.774371134	),
  (	70	,	1.080463467	,	-0.646853248	),
  (	70	,	0.958877124	,	-0.704276892	),
  (	70	,	0.832141545	,	-0.681576809	),
  (	70	,	1.056231795	,	-0.601829162	),
  (	70	,	1.000762871	,	-0.629932584	),
  (	70	,	0.946223588	,	-0.589582391	),
  (	70	,	1.163385445	,	-0.707368825	),
  (	70	,	1.306034765	,	-0.562676117	),
  (	70	,	1.240298268	,	-0.481327814	),
  (	70	,	1.195740145	,	-0.49654459	),
  (	70	,	1.176111365	,	-0.458596808	),
  (	70	,	1.18681215	,	-0.361277344	),
  (	70	,	0.157163063	,	-1.042264491	),
  (	70	,	0.073795212	,	-0.918913634	),
  (	70	,	0.235570629	,	-0.851568975	),
  (	70	,	0.299169882	,	-0.81450716	),
  (	70	,	0.512277261	,	-0.629317898	),
  (	70	,	0.108083702	,	-0.890914349	),
  (	70	,	0.159912738	,	-0.857537008	),
  (	70	,	0.03989771	,	-0.875576577	),
  (	70	,	0.059998994	,	-0.849701958	),
  (	70	,	0.343551067	,	-0.756301113	),
  (	70	,	0.22632851	,	-0.76286572	),
  (	70	,	0.367437712	,	-0.555232654	),
  (	70	,	0.379956528	,	-0.527720558	),
  (	70	,	0.381440416	,	-0.355203062	),
  (	70	,	0.735287238	,	-0.589629822	),
  (	70	,	0.762823874	,	-0.585117603	),
  (	70	,	0.875911836	,	-0.458791798	),
  (	70	,	0.710528392	,	-0.491334387	),
  (	70	,	1.022283571	,	-0.482908368	),
  (	70	,	0.994765939	,	-0.459520308	),
  (	70	,	0.984153203	,	-0.452310261	),
  (	70	,	0.914493277	,	-0.409724287	),
  (	70	,	0.915502978	,	-0.39279242	),
  (	70	,	0.882583478	,	-0.368269845	),
  (	70	,	0.842144952	,	-0.349528568	),
  (	70	,	0.851954377	,	-0.349398611	),
  (	70	,	0.625653114	,	-0.471164501	),
  (	70	,	0.688272319	,	-0.401279133	),
  (	70	,	0.691833183	,	-0.357034949	),
  (	70	,	0.891909316	,	-0.244222306	),
  (	70	,	0.917274618	,	-0.203277124	),
  (	70	,	0.960722466	,	-0.157762173	),
  (	70	,	0.671615732	,	-0.215327675	),
  (	70	,	2.244381784	,	-1.441053821	),
  (	70	,	2.523484338	,	-1.426096609	),
  (	70	,	2.757003001	,	-1.429791944	),
  (	70	,	2.159959939	,	-1.38436803	),
  (	70	,	1.989983044	,	-1.354969336	),
  (	70	,	2.232900981	,	-1.306466806	),
  (	70	,	2.494766059	,	-1.229926152	),
  (	70	,	2.275650913	,	-1.284816004	),
  (	70	,	2.370578985	,	-1.232319972	),
  (	70	,	3.061064888	,	-1.344859697	),
  (	70	,	2.989692957	,	-1.285120801	),
  (	70	,	3.087879303	,	-1.181454153	),
  (	70	,	2.848250184	,	-1.190492821	),
  (	70	,	2.864940547	,	-1.077024541	),
  (	70	,	2.590902976	,	-1.219901256	),
  (	70	,	2.537799346	,	-1.195637054	),
  (	70	,	2.663790053	,	-1.184053735	),
  (	70	,	2.674518448	,	-1.13736918	),
  (	70	,	2.466477763	,	-1.139175751	),
  (	70	,	2.732424791	,	-1.104767747	),
  (	70	,	2.685751629	,	-1.091476077	),
  (	70	,	2.777454436	,	-1.033066014	),
  (	70	,	2.608484241	,	-1.080913672	),
  (	70	,	2.639945424	,	-0.993053817	),
  (	70	,	1.790796009	,	-1.22149167	),
  (	70	,	1.881814974	,	-1.22380411	),
  (	70	,	1.933428805	,	-1.23283844	),
  (	70	,	1.811933175	,	-1.230264699	),
  (	70	,	1.654798233	,	-1.217961972	),
  (	70	,	1.600650069	,	-1.174314914	),
  (	70	,	2.130238143	,	-1.066000046	),
  (	70	,	2.086367518	,	-1.061453634	),
  (	70	,	1.91784698	,	-1.067179941	),
  (	70	,	2.050380085	,	-1.048094027	),
  (	70	,	2.262229522	,	-1.096820996	),
  (	70	,	2.519902771	,	-1.045273923	),
  (	70	,	2.48538754	,	-1.017508732	),
  (	70	,	2.436542784	,	-0.9996019	),
  (	70	,	2.467912223	,	-0.929428954	),
  (	70	,	2.171056568	,	-1.024462033	),
  (	70	,	2.247844462	,	-0.946074624	),
  (	70	,	2.387804054	,	-0.893813886	),
  (	70	,	2.281082646	,	-0.816930505	),
  (	70	,	2.89187916	,	-1.042676787	),
  (	70	,	2.957440661	,	-1.033369511	),
  (	70	,	2.922052887	,	-1.026911738	),
  (	70	,	2.917798173	,	-0.995985551	),
  (	70	,	2.922040161	,	-0.954953244	),
  (	70	,	2.915671495	,	-0.914576798	),
  (	70	,	2.937782278	,	-0.874802347	),
  (	70	,	2.844608694	,	-1.019541722	),
  (	70	,	2.824455924	,	-1.000516976	),
  (	70	,	2.804308425	,	-0.99269841	),
  (	70	,	2.789825292	,	-0.97720684	),
  (	70	,	2.856319193	,	-0.970735544	),
  (	70	,	2.704694282	,	-0.900027135	),
  (	70	,	2.774462818	,	-0.859243605	),
  (	70	,	2.764336689	,	-0.819883218	),
  (	70	,	2.753054358	,	-0.774364718	),
  (	70	,	2.95160572	,	-0.80074883	),
  (	70	,	2.96924017	,	-0.798120764	),
  (	70	,	3.060624596	,	-0.715918689	),
  (	70	,	3.009393561	,	-0.67119878	),
  (	70	,	2.833651693	,	-0.739448383	),
  (	70	,	2.856187742	,	-0.676391789	),
  (	70	,	2.950161098	,	-0.715963478	),
  (	70	,	2.983601934	,	-0.62987527	),
  (	70	,	2.956832541	,	-0.585548267	),
  (	70	,	2.662668853	,	-0.838005749	),
  (	70	,	2.480851969	,	-0.794085781	),
  (	70	,	2.444573731	,	-0.788421392	),
  (	70	,	2.404027529	,	-0.755163831	),
  (	70	,	2.556888235	,	-0.625951261	),
  (	70	,	2.554288187	,	-0.570423799	),
  (	70	,	2.561553699	,	-0.545731268	),
  (	70	,	2.733297055	,	-0.68699671	),
  (	70	,	2.726854059	,	-0.66851897	),
  (	70	,	2.782494097	,	-0.623432623	),
  (	70	,	2.669904104	,	-0.61653297	),
  (	70	,	2.780366503	,	-0.554362834	),
  (	70	,	2.831619247	,	-0.487256133	),
  (	70	,	2.805059747	,	-0.411008221	),
  (	70	,	1.832529728	,	-1.070486215	),
  (	70	,	1.873679845	,	-1.05383201	),
  (	70	,	1.664244051	,	-1.047580654	),
  (	70	,	1.739398843	,	-1.050390756	),
  (	70	,	1.867980649	,	-1.000612841	),
  (	70	,	2.014980117	,	-0.982883453	),
  (	70	,	2.037510724	,	-0.875883417	),
  (	70	,	1.630461115	,	-0.993414677	),
  (	70	,	1.57339733	,	-1.014069643	),
  (	70	,	1.665386866	,	-0.983708733	),
  (	70	,	1.593101808	,	-0.981449079	),
  (	70	,	1.738275558	,	-0.923835482	),
  (	70	,	1.822808282	,	-0.918934477	),
  (	70	,	1.984126321	,	-0.780017337	),
  (	70	,	2.077782334	,	-0.896023244	),
  (	70	,	2.035054151	,	-0.859413234	),
  (	70	,	2.083340506	,	-0.808551471	),
  (	70	,	2.119342401	,	-0.788385214	),
  (	70	,	2.222924189	,	-0.780572186	),
  (	70	,	2.221337869	,	-0.766528331	),
  (	70	,	2.302955101	,	-0.73779978	),
  (	70	,	2.298289543	,	-0.696523655	),
  (	70	,	2.19454341	,	-0.754467953	),
  (	70	,	2.243062315	,	-0.727433585	),
  (	70	,	2.235248078	,	-0.730109801	),
  (	70	,	2.201679397	,	-0.711168165	),
  (	70	,	2.227796159	,	-0.707061245	),
  (	70	,	2.302663552	,	-0.679656644	),
  (	70	,	2.287737475	,	-0.654969315	),
  (	70	,	2.045780129	,	-0.755923403	),
  (	70	,	2.146379005	,	-0.729349509	),
  (	70	,	2.128126823	,	-0.72976119	),
  (	70	,	2.013343986	,	-0.761579787	),
  (	70	,	2.050195622	,	-0.714092644	),
  (	70	,	2.177102968	,	-0.68205835	),
  (	70	,	2.155757216	,	-0.644937059	),
  (	70	,	2.19903428	,	-0.574158398	),
  (	70	,	1.74892703	,	-0.832082039	),
  (	70	,	1.670798939	,	-0.796372401	),
  (	70	,	1.871727882	,	-0.791179218	),
  (	70	,	1.84995353	,	-0.761115353	),
  (	70	,	1.899788583	,	-0.734573569	),
  (	70	,	1.856793649	,	-0.709301397	),
  (	70	,	1.908705448	,	-0.679158566	),
  (	70	,	1.599841572	,	-0.719425449	),
  (	70	,	1.98081782	,	-0.69648157	),
  (	70	,	1.940731916	,	-0.650824693	),
  (	70	,	2.050054175	,	-0.629951569	),
  (	70	,	1.958528259	,	-0.55583315	),
  (	70	,	2.020437143	,	-0.482902587	),
  (	70	,	1.828262587	,	-0.571110408	),
  (	70	,	1.90291021	,	-0.531196888	),
  (	70	,	1.953996787	,	-0.495170523	),
  (	70	,	1.989266577	,	-0.411002574	),
  (	70	,	2.014808584	,	-0.391018116	),
  (	70	,	1.96365242	,	-0.340804557	),
  (	70	,	2.365419305	,	-0.707811816	),
  (	70	,	2.340158932	,	-0.647908425	),
  (	70	,	2.314257857	,	-0.627104086	),
  (	70	,	2.49042482	,	-0.556607516	),
  (	70	,	2.247940378	,	-0.593830794	),
  (	70	,	2.291396781	,	-0.562865587	),
  (	70	,	2.212505752	,	-0.561707208	),
  (	70	,	2.354931767	,	-0.48549159	),
  (	70	,	2.289403194	,	-0.415191027	),
  (	70	,	2.360071177	,	-0.421559336	),
  (	70	,	2.62557427	,	-0.415508676	),
  (	70	,	2.550819509	,	-0.397092969	),
  (	70	,	2.667380706	,	-0.330874678	),
  (	70	,	2.713941851	,	-0.314761842	),
  (	70	,	2.473196107	,	-0.334319519	),
  (	70	,	2.438952022	,	-0.293230599	),
  (	70	,	2.454533538	,	-0.265900481	),
  (	70	,	2.562290552	,	-0.300298874	),
  (	70	,	2.602786071	,	-0.234990065	),
  (	70	,	2.594339312	,	-0.22607547	),
  (	70	,	2.572403641	,	-0.205685325	),
  (	70	,	2.124322549	,	-0.473233095	),
  (	70	,	2.242873507	,	-0.438066854	),
  (	70	,	2.072620193	,	-0.409547756	),
  (	70	,	2.131455831	,	-0.346626014	),
  (	70	,	2.12048787	,	-0.347188129	),
  (	70	,	2.229183362	,	-0.276367147	),
  (	70	,	2.175649144	,	-0.254232964	),
  (	70	,	2.181213159	,	-0.224395556	),
  (	70	,	2.351491003	,	-0.278989373	),
  (	70	,	2.322768959	,	-0.22356651	),
  (	70	,	2.423271601	,	-0.148052267	),
  (	70	,	2.281561846	,	-0.171142069	),
  (	70	,	2.208289384	,	-0.148618151	),
  (	70	,	2.279881384	,	-0.14832754	),
  (	70	,	2.336533305	,	-0.139106474	),
  (	70	,	2.334259951	,	-0.062054687	),
  (	70	,	4.306643234	,	-1.440944504	),
  (	70	,	3.724312998	,	-1.475582235	),
  (	70	,	4.375896651	,	-1.379234403	),
  (	70	,	4.097244776	,	-1.365467281	),
  (	70	,	3.784138823	,	-1.372188518	),
  (	70	,	3.585154433	,	-1.311010691	),
  (	70	,	4.035871204	,	-1.257447277	),
  (	70	,	3.954820292	,	-1.259609827	),
  (	70	,	3.993470093	,	-1.230819582	),
  (	70	,	3.932457005	,	-1.186533083	),
  (	70	,	4.709582305	,	-1.358282832	),
  (	70	,	4.48309371	,	-1.147517778	),
  (	70	,	4.242756464	,	-1.080869901	),
  (	70	,	3.227713746	,	-1.340437239	),
  (	70	,	3.311363631	,	-1.327603803	),
  (	70	,	3.497107691	,	-1.178741996	),
  (	70	,	3.696086503	,	-1.107331007	),
  (	70	,	3.159694801	,	-1.213387419	),
  (	70	,	3.382315522	,	-1.202650484	),
  (	70	,	3.467705689	,	-1.10969911	),
  (	70	,	3.483375565	,	-1.107396738	),
  (	70	,	3.464615883	,	-1.09351706	),
  (	70	,	3.609256773	,	-1.092396702	),
  (	70	,	3.536123517	,	-1.023887234	),
  (	70	,	3.905571784	,	-1.079908521	),
  (	70	,	3.827504127	,	-1.08229483	),
  (	70	,	4.031062727	,	-1.000609121	),
  (	70	,	4.120154165	,	-0.980273203	),
  (	70	,	4.092952305	,	-0.951591124	),
  (	70	,	4.061388042	,	-0.931559968	),
  (	70	,	3.791765235	,	-0.979773315	),
  (	70	,	3.795967134	,	-0.979677314	),
  (	70	,	4.650549308	,	-1.1226901	),
  (	70	,	4.540551012	,	-1.037434577	),
  (	70	,	4.499267595	,	-1.012737265	),
  (	70	,	4.53087145	,	-0.876352345	),
  (	70	,	4.464640113	,	-0.843633084	),
  (	70	,	4.366565556	,	-0.850956161	),
  (	70	,	4.337584209	,	-0.845812829	),
  (	70	,	4.379639239	,	-0.822151671	),
  (	70	,	4.493719901	,	-0.820854017	),
  (	70	,	4.495738856	,	-0.815739551	),
  (	70	,	4.599711454	,	-0.785509842	),
  (	70	,	4.529228114	,	-0.760577002	),
  (	70	,	4.583962707	,	-0.754440569	),
  (	70	,	4.642985176	,	-0.677293253	),
  (	70	,	4.603761773	,	-0.677175214	),
  (	70	,	4.607714225	,	-0.665015803	),
  (	70	,	4.483671369	,	-0.81471247	),
  (	70	,	4.486753492	,	-0.716013157	),
  (	70	,	4.391989617	,	-0.726243956	),
  (	70	,	4.511246984	,	-0.668374991	),
  (	70	,	4.560650926	,	-0.600922968	),
  (	70	,	4.534699967	,	-0.547369629	),
  (	70	,	4.131148078	,	-0.910122201	),
  (	70	,	4.250445839	,	-0.854039035	),
  (	70	,	4.168445525	,	-0.757327197	),
  (	70	,	4.198270674	,	-0.745279934	),
  (	70	,	4.209319628	,	-0.660018723	),
  (	70	,	3.961972143	,	-0.762930787	),
  (	70	,	4.001108903	,	-0.671038966	),
  (	70	,	4.197865044	,	-0.64130471	),
  (	70	,	4.063503293	,	-0.590270468	),
  (	70	,	4.076073189	,	-0.578953073	),
  (	70	,	4.318244579	,	-0.717520468	),
  (	70	,	4.348894369	,	-0.626858641	),
  (	70	,	4.289690338	,	-0.653187897	),
  (	70	,	4.296688714	,	-0.609013203	),
  (	70	,	4.293268884	,	-0.579442145	),
  (	70	,	4.426327969	,	-0.58425866	),
  (	70	,	4.388661603	,	-0.46512391	),
  (	70	,	4.185902092	,	-0.576173522	),
  (	70	,	4.268503644	,	-0.489423189	),
  (	70	,	4.180013872	,	-0.553777418	),
  (	70	,	4.239221552	,	-0.473874505	),
  (	70	,	4.308756192	,	-0.511178319	),
  (	70	,	4.312062888	,	-0.44425395	),
  (	70	,	4.393236434	,	-0.445559552	),
  (	70	,	3.194688636	,	-1.107484425	),
  (	70	,	3.435702282	,	-1.044761737	),
  (	70	,	3.349511843	,	-1.017486335	),
  (	70	,	3.640767829	,	-0.949671128	),
  (	70	,	3.510730293	,	-0.898924645	),
  (	70	,	3.219785702	,	-1.009675625	),
  (	70	,	3.188277429	,	-0.985105693	),
  (	70	,	3.507569757	,	-0.835850289	),
  (	70	,	3.532553006	,	-0.835592977	),
  (	70	,	3.444663424	,	-0.84691577	),
  (	70	,	3.695604146	,	-0.830590294	),
  (	70	,	3.821536856	,	-0.817090757	),
  (	70	,	3.786299927	,	-0.773712274	),
  (	70	,	3.849132886	,	-0.746815963	),
  (	70	,	3.743223706	,	-0.74335837	),
  (	70	,	3.766741547	,	-0.737454802	),
  (	70	,	3.80126879	,	-0.704877726	),
  (	70	,	3.594597634	,	-0.701239681	),
  (	70	,	3.618379699	,	-0.707144358	),
  (	70	,	3.785293074	,	-0.618677504	),
  (	70	,	3.675548904	,	-0.631451801	),
  (	70	,	3.770970022	,	-0.577475504	),
  (	70	,	3.184252839	,	-0.903799052	),
  (	70	,	3.218035491	,	-0.853919321	),
  (	70	,	3.321176761	,	-0.769711095	),
  (	70	,	3.465922727	,	-0.747916619	),
  (	70	,	3.272519469	,	-0.749263458	),
  (	70	,	3.247253212	,	-0.679174081	),
  (	70	,	3.301431248	,	-0.686373785	),
  (	70	,	3.397638017	,	-0.633122648	),
  (	70	,	3.572858217	,	-0.577901775	),
  (	70	,	3.640177262	,	-0.501665496	),
  (	70	,	3.432320965	,	-0.551735511	),
  (	70	,	3.483624407	,	-0.494506106	),
  (	70	,	3.386039871	,	-0.5494673	),
  (	70	,	3.769606167	,	-0.517950212	),
  (	70	,	3.7612862	,	-0.494076098	),
  (	70	,	3.916229083	,	-0.444044058	),
  (	70	,	3.953945669	,	-0.421184383	),
  (	70	,	4.136178267	,	-0.453558955	),
  (	70	,	4.071669589	,	-0.427442165	),
  (	70	,	4.126459648	,	-0.397122479	),
  (	70	,	4.090711	,	-0.386015591	),
  (	70	,	4.051945773	,	-0.274022613	),
  (	70	,	3.799031938	,	-0.392017576	),
  (	70	,	3.763705966	,	-0.362286244	),
  (	70	,	3.741369213	,	-0.348436806	),
  (	70	,	3.9894446	,	-0.248004578	),
  (	70	,	3.835388651	,	-0.184213988	),
  (	70	,	3.860440114	,	-0.169373648	),
  (	70	,	3.936021055	,	-0.145640517	),
  (	70	,	5.634619048	,	-1.449208923	),
  (	70	,	5.421788577	,	-1.473185016	),
  (	70	,	5.498366129	,	-1.214424316	),
  (	70	,	6.127468631	,	-1.259525673	),
  (	70	,	5.918302695	,	-1.269084143	),
  (	70	,	6.228176868	,	-1.193704019	),
  (	70	,	5.95403405	,	-1.116207058	),
  (	70	,	5.954291953	,	-1.091677984	),
  (	70	,	5.775187262	,	-0.976993639	),
  (	70	,	4.971792049	,	-1.315805719	),
  (	70	,	4.914217633	,	-1.270845046	),
  (	70	,	5.299619118	,	-1.124515233	),
  (	70	,	4.978915509	,	-1.097205941	),
  (	70	,	5.179689538	,	-1.090029731	),
  (	70	,	5.295805979	,	-1.074251654	),
  (	70	,	5.541958843	,	-1.117461974	),
  (	70	,	5.543208478	,	-1.036861932	),
  (	70	,	5.689774822	,	-0.999784325	),
  (	70	,	5.620734841	,	-0.912849564	),
  (	70	,	5.532776826	,	-0.811457062	),
  (	70	,	6.099996438	,	-1.064725764	),
  (	70	,	6.257940824	,	-1.039203822	),
  (	70	,	6.093066613	,	-0.969126023	),
  (	70	,	6.149809396	,	-0.919415182	),
  (	70	,	6.079227791	,	-0.866008552	),
  (	70	,	5.878933552	,	-1.012301089	),
  (	70	,	5.914706252	,	-0.900659506	),
  (	70	,	5.894850859	,	-0.862796801	),
  (	70	,	5.919505005	,	-0.84309974	),
  (	70	,	5.907557721	,	-0.779998938	),
  (	70	,	5.893607551	,	-0.769577943	),
  (	70	,	6.180956647	,	-0.783530746	),
  (	70	,	6.154758566	,	-0.732852613	),
  (	70	,	6.003535887	,	-0.717270847	),
  (	70	,	5.753046096	,	-0.728169292	),
  (	70	,	5.671738805	,	-0.752794731	),
  (	70	,	5.705374357	,	-0.662390426	),
  (	70	,	5.763887408	,	-0.63803269	),
  (	70	,	5.734795794	,	-0.629396113	),
  (	70	,	5.674297265	,	-0.602759071	),
  (	70	,	5.65150442	,	-0.599180149	),
  (	70	,	5.700259585	,	-0.570982316	),
  (	70	,	5.964263165	,	-0.579143059	),
  (	70	,	6.037698946	,	-0.531360503	),
  (	70	,	5.779231595	,	-0.45174476	),
  (	70	,	5.824116612	,	-0.418962547	),
  (	70	,	4.886027939	,	-1.027460623	),
  (	70	,	4.955697464	,	-0.984773797	),
  (	70	,	5.046671442	,	-0.915216124	),
  (	70	,	5.131063314	,	-0.92517131	),
  (	70	,	4.732892728	,	-1.033408226	),
  (	70	,	4.822699139	,	-0.996506364	),
  (	70	,	4.763524816	,	-0.966247271	),
  (	70	,	4.863793497	,	-0.885261436	),
  (	70	,	5.238902971	,	-0.865833145	),
  (	70	,	5.199828607	,	-0.889758544	),
  (	70	,	5.420391071	,	-0.78339431	),
  (	70	,	5.385550627	,	-0.758318649	),
  (	70	,	5.381629388	,	-0.724766505	),
  (	70	,	5.251644866	,	-0.678112334	),
  (	70	,	5.295175976	,	-0.671065586	),
  (	70	,	5.360551941	,	-0.600565071	),
  (	70	,	5.228242179	,	-0.640313447	),
  (	70	,	5.259688707	,	-0.605055382	),
  (	70	,	4.847925256	,	-0.834710352	),
  (	70	,	4.875707527	,	-0.821607543	),
  (	70	,	4.79828122	,	-0.797617026	),
  (	70	,	4.913759987	,	-0.771844327	),
  (	70	,	4.913366861	,	-0.742924799	),
  (	70	,	5.031505158	,	-0.675114624	),
  (	70	,	4.781507533	,	-0.75343772	),
  (	70	,	4.751190051	,	-0.744506289	),
  (	70	,	4.899513805	,	-0.685665249	),
  (	70	,	4.918849911	,	-0.655351503	),
  (	70	,	4.841681254	,	-0.592261797	),
  (	70	,	4.922904805	,	-0.591812056	),
  (	70	,	5.158395759	,	-0.639381371	),
  (	70	,	5.042213735	,	-0.644891129	),
  (	70	,	5.268262136	,	-0.518723041	),
  (	70	,	5.118408633	,	-0.529933988	),
  (	70	,	4.954257808	,	-0.509865097	),
  (	70	,	5.086427502	,	-0.391861708	),
  (	70	,	5.433187563	,	-0.613773212	),
  (	70	,	5.608018957	,	-0.608374498	),
  (	70	,	5.510623743	,	-0.508071722	),
  (	70	,	5.456335182	,	-0.436045772	),
  (	70	,	5.756517507	,	-0.415975662	),
  (	70	,	5.722151036	,	-0.406159284	),
  (	70	,	5.559008288	,	-0.387675884	),
  (	70	,	5.538183838	,	-0.352437877	),
  (	70	,	5.617287617	,	-0.23714796	),
  (	70	,	5.398979992	,	-0.264376635	),
  (	70	,	5.271839932	,	-0.328190538	),
  (	70	,	5.215926684	,	-0.336724999	),
  (	70	,	5.199761652	,	-0.257904926	),
  (	70	,	5.538883852	,	-0.28999858	),
  (	70	,	5.584230166	,	-0.244651897	),
  (	70	,	5.63902562	,	-0.2141057	),
  (	70	,	5.571835707	,	-0.176891715	),
  (	70	,	5.42614066	,	-0.20318344	),
  (	70	,	5.384474665	,	-0.215438501	),
  (	70	,	5.492340484	,	-0.067044422	),
  (	70	,	5.513025338	,	-0.027571448	),
  (	71	,	0.704067858	,	0.077272462	),
  (	71	,	0.802211799	,	0.107052343	),
  (	71	,	0.822330953	,	0.133393423	),
  (	71	,	0.680879777	,	0.1122624	),
  (	71	,	0.763236515	,	0.309527761	),
  (	71	,	0.9309276	,	0.240546094	),
  (	71	,	1.095441789	,	0.290544928	),
  (	71	,	1.034926899	,	0.372164932	),
  (	71	,	0.890185151	,	0.347444769	),
  (	71	,	1.021165595	,	0.383012938	),
  (	71	,	0.991716445	,	0.414106675	),
  (	71	,	0.956059613	,	0.431140664	),
  (	71	,	0.605958224	,	0.226762552	),
  (	71	,	0.534154988	,	0.221391742	),
  (	71	,	0.68754385	,	0.359099118	),
  (	71	,	0.584085863	,	0.342336729	),
  (	71	,	0.551978896	,	0.424690376	),
  (	71	,	0.910963656	,	0.530148492	),
  (	71	,	0.948859327	,	0.543151721	),
  (	71	,	0.815358692	,	0.532791474	),
  (	71	,	0.680993631	,	0.513192123	),
  (	71	,	0.731482407	,	0.517987252	),
  (	71	,	0.766583316	,	0.541802798	),
  (	71	,	0.791878113	,	0.565706921	),
  (	71	,	0.800812054	,	0.670379883	),
  (	71	,	1.358313716	,	0.518882742	),
  (	71	,	1.05344991	,	0.497447933	),
  (	71	,	1.43870774	,	0.612761138	),
  (	71	,	1.393016969	,	0.608954337	),
  (	71	,	1.413081684	,	0.635270816	),
  (	71	,	1.35091817	,	0.675190005	),
  (	71	,	1.275577029	,	0.639518981	),
  (	71	,	1.216880765	,	0.737222166	),
  (	71	,	1.410273926	,	0.820680727	),
  (	71	,	1.478934198	,	0.862475119	),
  (	71	,	1.036674775	,	0.636880609	),
  (	71	,	0.945893987	,	0.599474247	),
  (	71	,	0.938572432	,	0.673443599	),
  (	71	,	1.092378551	,	0.684615157	),
  (	71	,	1.13104917	,	0.739684536	),
  (	71	,	1.06189561	,	0.852431619	),
  (	71	,	0.983755353	,	0.831826885	),
  (	71	,	0.918261572	,	0.821408411	),
  (	71	,	0.952151913	,	0.856660022	),
  (	71	,	1.041251335	,	0.942278382	),
  (	71	,	1.272960615	,	0.799889143	),
  (	71	,	1.198893911	,	0.874836047	),
  (	71	,	1.287921403	,	0.900667133	),
  (	71	,	1.412506181	,	0.978936824	),
  (	71	,	1.479561798	,	0.983652328	),
  (	71	,	1.152321468	,	0.933658957	),
  (	71	,	1.49056556	,	1.058066458	),
  (	71	,	1.385177232	,	1.050352021	),
  (	71	,	1.531604879	,	1.147625353	),
  (	71	,	0.417302847	,	0.493398457	),
  (	71	,	0.514959991	,	0.497764359	),
  (	71	,	0.493825882	,	0.502982056	),
  (	71	,	0.260090852	,	0.567089422	),
  (	71	,	0.305220774	,	0.591343685	),
  (	71	,	0.634620045	,	0.611597171	),
  (	71	,	0.640569689	,	0.621584158	),
  (	71	,	0.625215403	,	0.667635328	),
  (	71	,	0.646507423	,	0.67790369	),
  (	71	,	0.752126053	,	0.733403331	),
  (	71	,	0.657473507	,	0.701051927	),
  (	71	,	0.602190613	,	0.748768024	),
  (	71	,	0.659997122	,	0.809742519	),
  (	71	,	0.662813632	,	0.813065541	),
  (	71	,	0.563136615	,	0.732435257	),
  (	71	,	0.528956301	,	0.719293349	),
  (	71	,	0.524695412	,	0.775271328	),
  (	71	,	0.436204506	,	0.727221317	),
  (	71	,	0.496997116	,	0.871668973	),
  (	71	,	0.500688621	,	0.877823616	),
  (	71	,	0.547367697	,	0.883887084	),
  (	71	,	0.226681374	,	0.591489215	),
  (	71	,	0.183361673	,	0.710136726	),
  (	71	,	0.293986992	,	0.663729114	),
  (	71	,	0.267563215	,	0.793284884	),
  (	71	,	0.094187189	,	0.666488972	),
  (	71	,	0.087274324	,	0.667160507	),
  (	71	,	0.038543981	,	0.706762389	),
  (	71	,	0.006808113	,	0.779730735	),
  (	71	,	0.081495387	,	0.77893873	),
  (	71	,	0.203469454	,	0.818451725	),
  (	71	,	0.156256988	,	0.855579854	),
  (	71	,	0.089677379	,	0.794278702	),
  (	71	,	0.079215329	,	0.806589927	),
  (	71	,	0.396975949	,	0.861195097	),
  (	71	,	0.232667714	,	0.866654005	),
  (	71	,	0.352016883	,	0.900498371	),
  (	71	,	0.45022971	,	0.846776843	),
  (	71	,	0.508877545	,	0.930338878	),
  (	71	,	0.486266204	,	0.958615285	),
  (	71	,	0.298351396	,	0.946514643	),
  (	71	,	0.348464494	,	1.015923692	),
  (	71	,	0.050698082	,	1.01598778	),
  (	71	,	0.199691929	,	0.990908287	),
  (	71	,	0.288267134	,	1.00804022	),
  (	71	,	0.168237319	,	1.052865933	),
  (	71	,	0.090434086	,	1.080002632	),
  (	71	,	0.810588088	,	0.762751304	),
  (	71	,	0.845786295	,	0.865137145	),
  (	71	,	0.8222681	,	0.893020126	),
  (	71	,	0.873124501	,	0.889569605	),
  (	71	,	0.895797073	,	1.024414938	),
  (	71	,	0.957938798	,	1.037519255	),
  (	71	,	0.690325144	,	0.881237574	),
  (	71	,	0.609251984	,	0.917369755	),
  (	71	,	0.589610213	,	0.961472322	),
  (	71	,	0.658199723	,	0.969490972	),
  (	71	,	0.738445443	,	0.995416559	),
  (	71	,	0.709464941	,	1.075002132	),
  (	71	,	0.826279725	,	1.122237942	),
  (	71	,	1.125423258	,	1.026091859	),
  (	71	,	1.152651841	,	1.082669386	),
  (	71	,	1.192572879	,	1.119977228	),
  (	71	,	1.081477998	,	1.087865489	),
  (	71	,	1.081324617	,	1.087915189	),
  (	71	,	1.500765587	,	1.162835697	),
  (	71	,	1.249704823	,	1.131146496	),
  (	71	,	1.258075878	,	1.182682924	),
  (	71	,	1.56258794	,	1.214826027	),
  (	71	,	1.484509983	,	1.221414248	),
  (	71	,	1.470140302	,	1.297103464	),
  (	71	,	0.501518478	,	0.987550489	),
  (	71	,	0.449259883	,	1.014308933	),
  (	71	,	0.43248999	,	1.066031241	),
  (	71	,	0.323150916	,	1.062610688	),
  (	71	,	0.676868018	,	1.152777427	),
  (	71	,	0.420599288	,	1.180103864	),
  (	71	,	0.181435154	,	1.149609933	),
  (	71	,	0.023277902	,	1.202261242	),
  (	71	,	0.403239154	,	1.193953617	),
  (	71	,	0.343699946	,	1.263642187	),
  (	71	,	0.080558038	,	1.331275769	),
  (	71	,	0.877272833	,	1.286290857	),
  (	71	,	0.847737854	,	1.295784887	),
  (	71	,	0.804090014	,	1.311606408	),
  (	71	,	0.780774154	,	1.345297711	),
  (	71	,	0.997782597	,	1.363435542	),
  (	71	,	0.51849035	,	1.276743003	),
  (	71	,	0.487852463	,	1.319283095	),
  (	71	,	0.593154665	,	1.381936115	),
  (	71	,	0.562580623	,	1.384848601	),
  (	71	,	0.479447062	,	1.411735053	),
  (	71	,	0.438624154	,	1.421218348	),
  (	71	,	1.471540217	,	1.463655724	),
  (	71	,	0.504911988	,	1.430452218	),
  (	71	,	2.458698741	,	0.134625534	),
  (	71	,	2.480791029	,	0.216162975	),
  (	71	,	2.297454717	,	0.147968178	),
  (	71	,	2.223576794	,	0.146907544	),
  (	71	,	2.328973879	,	0.241385533	),
  (	71	,	2.533293633	,	0.227817677	),
  (	71	,	2.527608272	,	0.232349551	),
  (	71	,	2.473761768	,	0.24963097	),
  (	71	,	2.688973554	,	0.30962044	),
  (	71	,	2.449675022	,	0.289689527	),
  (	71	,	2.427957683	,	0.328299282	),
  (	71	,	2.517425384	,	0.401967912	),
  (	71	,	2.27692859	,	0.346868031	),
  (	71	,	2.296577805	,	0.359822833	),
  (	71	,	2.217088906	,	0.369094837	),
  (	71	,	2.043681757	,	0.320034722	),
  (	71	,	2.09675092	,	0.328873695	),
  (	71	,	2.069182652	,	0.368354159	),
  (	71	,	2.053652576	,	0.421688537	),
  (	71	,	2.11115065	,	0.385207568	),
  (	71	,	2.38867262	,	0.401092386	),
  (	71	,	2.390602421	,	0.447262489	),
  (	71	,	2.431670544	,	0.584688585	),
  (	71	,	2.287452127	,	0.55960081	),
  (	71	,	2.34445202	,	0.566272174	),
  (	71	,	2.380418674	,	0.631464402	),
  (	71	,	2.770005689	,	0.488011027	),
  (	71	,	2.748435567	,	0.498836275	),
  (	71	,	2.794068662	,	0.480406424	),
  (	71	,	2.67344313	,	0.49291487	),
  (	71	,	2.749217491	,	0.70633003	),
  (	71	,	2.827614943	,	0.717504152	),
  (	71	,	3.001740732	,	0.783275242	),
  (	71	,	3.088503653	,	0.869576043	),
  (	71	,	2.472641193	,	0.636298197	),
  (	71	,	2.494534594	,	0.635805901	),
  (	71	,	2.63207561	,	0.874569931	),
  (	71	,	2.512590463	,	0.846341139	),
  (	71	,	2.847744154	,	0.908811896	),
  (	71	,	2.922486566	,	0.944337732	),
  (	71	,	1.953352218	,	0.386440846	),
  (	71	,	2.024437774	,	0.423136648	),
  (	71	,	1.987055001	,	0.499648042	),
  (	71	,	2.050401277	,	0.477576269	),
  (	71	,	2.044132231	,	0.50203063	),
  (	71	,	2.078069535	,	0.521017518	),
  (	71	,	1.907457012	,	0.577544303	),
  (	71	,	1.99990964	,	0.579215536	),
  (	71	,	1.946520024	,	0.556702555	),
  (	71	,	1.926471653	,	0.657327079	),
  (	71	,	1.964251209	,	0.666175789	),
  (	71	,	1.952883956	,	0.674846112	),
  (	71	,	2.216858997	,	0.626429023	),
  (	71	,	2.109410021	,	0.648155226	),
  (	71	,	2.229927098	,	0.699099766	),
  (	71	,	2.051741715	,	0.694128002	),
  (	71	,	2.114765156	,	0.693604046	),
  (	71	,	2.052421815	,	0.799219975	),
  (	71	,	2.164922579	,	0.816851608	),
  (	71	,	2.14759396	,	0.854501369	),
  (	71	,	1.75655396	,	0.678783214	),
  (	71	,	1.764042017	,	0.708985175	),
  (	71	,	1.858605075	,	0.638313261	),
  (	71	,	1.823440958	,	0.727890822	),
  (	71	,	1.77233207	,	0.737671522	),
  (	71	,	1.867961997	,	0.76864207	),
  (	71	,	1.673981831	,	0.707230282	),
  (	71	,	1.612948325	,	0.752947048	),
  (	71	,	1.666885042	,	0.768963475	),
  (	71	,	1.72748867	,	0.762808555	),
  (	71	,	1.636996245	,	0.852313602	),
  (	71	,	1.621454595	,	0.850197027	),
  (	71	,	1.584555069	,	0.93447478	),
  (	71	,	1.985855312	,	0.849645932	),
  (	71	,	1.849961545	,	0.821177951	),
  (	71	,	1.892041332	,	0.824961806	),
  (	71	,	1.890012636	,	0.951095186	),
  (	71	,	1.803953281	,	0.899155899	),
  (	71	,	2.371631791	,	0.926913111	),
  (	71	,	2.454524892	,	0.864719493	),
  (	71	,	2.516394018	,	0.994318194	),
  (	71	,	2.272049454	,	0.8976414	),
  (	71	,	2.114467823	,	0.936865925	),
  (	71	,	2.099632199	,	0.950511894	),
  (	71	,	2.177223042	,	0.98182912	),
  (	71	,	2.352240301	,	1.105704484	),
  (	71	,	2.739128868	,	1.040166198	),
  (	71	,	2.593100775	,	1.04580574	),
  (	71	,	2.523244666	,	1.22637506	),
  (	71	,	2.228507782	,	1.195807775	),
  (	71	,	1.656536975	,	1.198638714	),
  (	71	,	2.521708018	,	1.275490268	),
  (	71	,	2.626647283	,	1.304787793	),
  (	71	,	2.858902565	,	1.34543259	),
  (	71	,	2.950214781	,	1.366747687	),
  (	71	,	2.092697273	,	1.393845047	),
  (	71	,	1.71654386	,	1.364296162	),
  (	71	,	2.368050243	,	1.444173005	),
  (	71	,	2.72575197	,	1.445161219	),
  (	71	,	2.51745326	,	1.447319968	),
  (	71	,	3.899282032	,	0.039050041	),
  (	71	,	3.958933654	,	0.15635247	),
  (	71	,	3.882485559	,	0.183131902	),
  (	71	,	3.905252853	,	0.261443072	),
  (	71	,	3.896186111	,	0.264107416	),
  (	71	,	4.087163642	,	0.26048421	),
  (	71	,	4.100059085	,	0.284738605	),
  (	71	,	4.200875332	,	0.388131359	),
  (	71	,	4.138520922	,	0.391219258	),
  (	71	,	3.770726404	,	0.284030301	),
  (	71	,	3.8894138	,	0.333369214	),
  (	71	,	3.748384351	,	0.332755383	),
  (	71	,	3.685986977	,	0.450591288	),
  (	71	,	3.909572488	,	0.425613517	),
  (	71	,	3.940546525	,	0.493356871	),
  (	71	,	4.00701605	,	0.468461361	),
  (	71	,	4.00551018	,	0.538126552	),
  (	71	,	3.824019831	,	0.479704472	),
  (	71	,	3.789787638	,	0.493762504	),
  (	71	,	3.895265663	,	0.557194868	),
  (	71	,	4.349806458	,	0.399103807	),
  (	71	,	4.310571335	,	0.453514158	),
  (	71	,	4.310793084	,	0.570712288	),
  (	71	,	4.326273037	,	0.584922454	),
  (	71	,	4.376720117	,	0.637214487	),
  (	71	,	4.630488818	,	0.727017269	),
  (	71	,	4.616647002	,	0.760942777	),
  (	71	,	4.396611618	,	0.655549157	),
  (	71	,	4.540050083	,	0.77130342	),
  (	71	,	4.197659569	,	0.698534144	),
  (	71	,	4.303802385	,	0.712253448	),
  (	71	,	4.033934088	,	0.651844275	),
  (	71	,	4.113001563	,	0.798705769	),
  (	71	,	4.228738421	,	0.875823415	),
  (	71	,	4.433462936	,	0.826781478	),
  (	71	,	4.320760576	,	0.8368935	),
  (	71	,	4.434455841	,	0.919760611	),
  (	71	,	4.676378338	,	0.979482287	),
  (	71	,	4.337084919	,	0.911724851	),
  (	71	,	4.387909996	,	0.965405881	),
  (	71	,	4.294777489	,	0.96568583	),
  (	71	,	4.484655521	,	0.973342121	),
  (	71	,	3.499363857	,	0.434276662	),
  (	71	,	3.695421526	,	0.496337733	),
  (	71	,	3.671176122	,	0.55088406	),
  (	71	,	3.500484406	,	0.528689913	),
  (	71	,	3.384831728	,	0.558513533	),
  (	71	,	3.495816601	,	0.660731342	),
  (	71	,	3.747781196	,	0.676622256	),
  (	71	,	3.673142614	,	0.705461834	),
  (	71	,	3.715879307	,	0.738986783	),
  (	71	,	3.622147779	,	0.742763306	),
  (	71	,	3.398785226	,	0.695414709	),
  (	71	,	3.42036372	,	0.750623552	),
  (	71	,	3.325924527	,	0.800704994	),
  (	71	,	3.322571588	,	0.860286265	),
  (	71	,	3.266594071	,	0.866304449	),
  (	71	,	3.542740378	,	0.824395582	),
  (	71	,	3.581082283	,	0.921040488	),
  (	71	,	3.351998691	,	0.91547892	),
  (	71	,	3.307137827	,	0.957367555	),
  (	71	,	3.25741321	,	0.962715242	),
  (	71	,	3.927241748	,	0.778178116	),
  (	71	,	3.737230621	,	0.965134254	),
  (	71	,	3.941652444	,	0.977987212	),
  (	71	,	4.008842728	,	1.021080298	),
  (	71	,	3.927186167	,	1.142773214	),
  (	71	,	4.395000943	,	1.108842019	),
  (	71	,	4.691447213	,	1.215017758	),
  (	71	,	4.626371672	,	1.206915425	),
  (	71	,	4.193004197	,	1.133591385	),
  (	71	,	4.190329404	,	1.180322854	),
  (	71	,	4.533307807	,	1.235483383	),
  (	71	,	4.521362405	,	1.253012013	),
  (	71	,	4.452623723	,	1.312920959	),
  (	71	,	3.521948929	,	1.129573047	),
  (	71	,	3.230539294	,	1.158744939	),
  (	71	,	3.184343363	,	1.350723984	),
  (	71	,	3.913059917	,	1.307268145	),
  (	71	,	4.167062154	,	1.319019014	),
  (	71	,	4.275278018	,	1.328950366	),
  (	71	,	4.343070094	,	1.357083799	),
  (	71	,	4.396631923	,	1.387604968	),
  (	71	,	4.087569014	,	1.406994223	),
  (	71	,	4.1216372	,	1.412533002	),
  (	71	,	3.79331322	,	1.410387798	),
  (	71	,	4.045581213	,	1.4804733	),
  (	71	,	3.841030253	,	1.522187469	),
  (	71	,	5.483784232	,	0.029910944	),
  (	71	,	5.488251609	,	0.073225032	),
  (	71	,	5.615221217	,	0.186188063	),
  (	71	,	5.410511249	,	0.14742576	),
  (	71	,	5.462588433	,	0.153111315	),
  (	71	,	5.37220204	,	0.196534423	),
  (	71	,	5.450857098	,	0.254918526	),
  (	71	,	5.509943714	,	0.278678405	),
  (	71	,	5.728934246	,	0.278070864	),
  (	71	,	5.713163641	,	0.275084953	),
  (	71	,	5.795154036	,	0.306455532	),
  (	71	,	5.841557756	,	0.34839833	),
  (	71	,	5.744754311	,	0.369338032	),
  (	71	,	5.610240564	,	0.272578016	),
  (	71	,	5.649555585	,	0.347954752	),
  (	71	,	5.540394005	,	0.335293156	),
  (	71	,	5.700595115	,	0.387017113	),
  (	71	,	5.679479604	,	0.377023991	),
  (	71	,	5.274507297	,	0.213422985	),
  (	71	,	5.252685402	,	0.261501859	),
  (	71	,	5.317077599	,	0.30302692	),
  (	71	,	5.359560856	,	0.327582617	),
  (	71	,	5.193460991	,	0.309095418	),
  (	71	,	5.16847194	,	0.324433131	),
  (	71	,	5.127457645	,	0.331697599	),
  (	71	,	5.20745423	,	0.420269954	),
  (	71	,	5.308311974	,	0.373580132	),
  (	71	,	5.318314073	,	0.370185832	),
  (	71	,	5.307308274	,	0.388986368	),
  (	71	,	5.34258527	,	0.423725379	),
  (	71	,	5.281662792	,	0.437188168	),
  (	71	,	5.281935609	,	0.496271803	),
  (	71	,	5.493681385	,	0.390090536	),
  (	71	,	5.425064782	,	0.450726362	),
  (	71	,	5.487616309	,	0.460867296	),
  (	71	,	5.454554634	,	0.477831967	),
  (	71	,	5.513023843	,	0.507757634	),
  (	71	,	5.606007111	,	0.451698959	),
  (	71	,	5.37933588	,	0.474941932	),
  (	71	,	5.44488409	,	0.481629608	),
  (	71	,	5.387584737	,	0.567334959	),
  (	71	,	5.492241266	,	0.552354334	),
  (	71	,	5.49769922	,	0.567152554	),
  (	71	,	5.410192804	,	0.617689065	),
  (	71	,	5.923452119	,	0.418901082	),
  (	71	,	5.824173449	,	0.42437829	),
  (	71	,	5.87334234	,	0.452521661	),
  (	71	,	5.910595857	,	0.464226415	),
  (	71	,	5.753778587	,	0.520281653	),
  (	71	,	5.771028162	,	0.582580992	),
  (	71	,	5.868874708	,	0.572312976	),
  (	71	,	5.848901792	,	0.650970959	),
  (	71	,	6.098640372	,	0.541574857	),
  (	71	,	6.098603694	,	0.594221986	),
  (	71	,	6.202433044	,	0.707800653	),
  (	71	,	6.200628232	,	0.730430664	),
  (	71	,	6.247611568	,	0.748917068	),
  (	71	,	6.205694141	,	0.781126765	),
  (	71	,	5.985712794	,	0.721046993	),
  (	71	,	5.922122124	,	0.747181565	),
  (	71	,	6.015985682	,	0.76513011	),
  (	71	,	6.168957782	,	0.814731622	),
  (	71	,	6.200656256	,	0.806656485	),
  (	71	,	6.281215473	,	0.887195587	),
  (	71	,	6.177195964	,	0.894726953	),
  (	71	,	6.279681835	,	0.934851922	),
  (	71	,	5.760830209	,	0.604400231	),
  (	71	,	5.671873952	,	0.689666762	),
  (	71	,	5.764438957	,	0.684970545	),
  (	71	,	5.825287217	,	0.763983067	),
  (	71	,	5.582131544	,	0.677302158	),
  (	71	,	5.574613381	,	0.684336837	),
  (	71	,	5.781167139	,	0.824402605	),
  (	71	,	5.673160797	,	0.867131913	),
  (	71	,	5.724341777	,	0.845388044	),
  (	71	,	5.969617131	,	0.865380772	),
  (	71	,	6.05238125	,	0.876021813	),
  (	71	,	6.133092987	,	0.924664413	),
  (	71	,	6.176096925	,	0.912653297	),
  (	71	,	6.1635582	,	0.937003567	),
  (	71	,	5.99645118	,	0.983195465	),
  (	71	,	5.930166576	,	1.028478614	),
  (	71	,	6.151728552	,	1.021863621	),
  (	71	,	6.256276163	,	1.062091942	),
  (	71	,	5.120033472	,	0.381160671	),
  (	71	,	5.150452966	,	0.409807841	),
  (	71	,	5.03667389	,	0.43656176	),
  (	71	,	5.122599976	,	0.454880927	),
  (	71	,	5.232285963	,	0.480186918	),
  (	71	,	5.18862696	,	0.483983072	),
  (	71	,	5.202218773	,	0.493083849	),
  (	71	,	5.146523127	,	0.530723387	),
  (	71	,	5.156038261	,	0.537714088	),
  (	71	,	4.993191705	,	0.476836452	),
  (	71	,	5.030626291	,	0.510189138	),
  (	71	,	5.047164564	,	0.578183793	),
  (	71	,	4.980729942	,	0.565352251	),
  (	71	,	5.102280766	,	0.551625289	),
  (	71	,	5.155912729	,	0.577406273	),
  (	71	,	5.173495763	,	0.629867466	),
  (	71	,	5.128493185	,	0.605419773	),
  (	71	,	5.034734926	,	0.635723799	),
  (	71	,	5.099162747	,	0.697098162	),
  (	71	,	5.308692866	,	0.619042394	),
  (	71	,	5.295110282	,	0.634049725	),
  (	71	,	5.311819167	,	0.667337771	),
  (	71	,	5.263990936	,	0.682404492	),
  (	71	,	5.274422224	,	0.694611981	),
  (	71	,	5.29675109	,	0.683456165	),
  (	71	,	5.311075693	,	0.708453609	),
  (	71	,	5.477277474	,	0.742000026	),
  (	71	,	5.427509006	,	0.736879958	),
  (	71	,	5.165236219	,	0.668851153	),
  (	71	,	5.186843272	,	0.696679527	),
  (	71	,	5.249742111	,	0.723869788	),
  (	71	,	5.12393947	,	0.723073044	),
  (	71	,	5.322506925	,	0.791745233	),
  (	71	,	5.332899994	,	0.882109742	),
  (	71	,	4.931042995	,	0.582099277	),
  (	71	,	5.006127819	,	0.716529342	),
  (	71	,	5.020292381	,	0.73342624	),
  (	71	,	4.92447235	,	0.789976764	),
  (	71	,	4.959073916	,	0.816220088	),
  (	71	,	4.855757883	,	0.677758881	),
  (	71	,	4.759659421	,	0.778385058	),
  (	71	,	4.717115701	,	0.827340443	),
  (	71	,	4.784894413	,	0.839591388	),
  (	71	,	4.777563877	,	0.85798362	),
  (	71	,	4.736445791	,	0.906654871	),
  (	71	,	5.109531548	,	0.808642615	),
  (	71	,	5.109856963	,	0.84791829	),
  (	71	,	5.111531279	,	0.964569118	),
  (	71	,	5.105981582	,	0.967325454	),
  (	71	,	5.122085044	,	0.98541627	),
  (	71	,	4.778978893	,	0.944921259	),
  (	71	,	4.98327988	,	1.049442452	),
  (	71	,	4.879950602	,	1.108859666	),
  (	71	,	4.735303896	,	1.147090809	),
  (	71	,	5.493037338	,	0.807254487	),
  (	71	,	5.53690674	,	0.825034795	),
  (	71	,	5.509068466	,	0.838294359	),
  (	71	,	5.471054233	,	0.864520769	),
  (	71	,	5.655581332	,	0.881430147	),
  (	71	,	5.737781889	,	0.941364476	),
  (	71	,	5.726657622	,	0.954400664	),
  (	71	,	5.729570608	,	0.981094802	),
  (	71	,	5.583656819	,	0.926038621	),
  (	71	,	5.548664681	,	0.938048114	),
  (	71	,	5.380459322	,	0.950453845	),
  (	71	,	5.381688972	,	0.956477392	),
  (	71	,	5.420467668	,	1.001564396	),
  (	71	,	5.455482247	,	0.991320233	),
  (	71	,	5.506143795	,	1.008196402	),
  (	71	,	5.470257095	,	1.035111015	),
  (	71	,	5.398013693	,	1.071008905	),
  (	71	,	5.524007225	,	1.098191129	),
  (	71	,	5.844361337	,	1.049776796	),
  (	71	,	5.674692874	,	1.042885331	),
  (	71	,	5.732540638	,	1.092827804	),
  (	71	,	5.830760121	,	1.087618746	),
  (	71	,	5.872088461	,	1.105287794	),
  (	71	,	5.782419456	,	1.109652801	),
  (	71	,	6.032957019	,	1.105506298	),
  (	71	,	6.088911144	,	1.1216656	),
  (	71	,	6.125511264	,	1.140454071	),
  (	71	,	6.140447027	,	1.145291371	),
  (	71	,	5.989578884	,	1.186660171	),
  (	71	,	6.217491458	,	1.217451473	),
  (	71	,	6.133279047	,	1.20350966	),
  (	71	,	5.723834954	,	1.132716764	),
  (	71	,	5.834653504	,	1.154169008	),
  (	71	,	5.736542747	,	1.182529482	),
  (	71	,	5.791180365	,	1.233847412	),
  (	71	,	5.973542711	,	1.196797488	),
  (	71	,	5.890514094	,	1.224722679	),
  (	71	,	5.053576752	,	1.063955562	),
  (	71	,	4.985172347	,	1.094417677	),
  (	71	,	4.986042522	,	1.192499028	),
  (	71	,	4.916437159	,	1.182836791	),
  (	71	,	4.869099089	,	1.263276055	),
  (	71	,	4.968199177	,	1.293858042	),
  (	71	,	5.485594536	,	1.205277471	),
  (	71	,	5.548730651	,	1.229433275	),
  (	71	,	5.447301236	,	1.187411143	),
  (	71	,	5.632992975	,	1.236098073	),
  (	71	,	5.725945347	,	1.265188187	),
  (	71	,	5.593661222	,	1.257668762	),
  (	71	,	6.154758558	,	1.359507934	),
  (	71	,	5.547807096	,	1.378381238	),
  (	71	,	5.255391561	,	1.289966129	),
  (	71	,	5.270824193	,	1.358289404	),
  (	71	,	5.326442012	,	1.437588296	),
  (	71	,	5.751677118	,	1.446340116	),
  (	71	,	6.159099413	,	1.504089612	),
  (	71	,	0.047056673	,	-0.608434373	),
  (	71	,	6.272896361	,	-0.579257074	),
  (	71	,	0.101970849	,	-0.520937574	),
  (	71	,	0.112405537	,	-0.483638401	),
  (	71	,	6.212767488	,	-0.58342665	),
  (	71	,	6.236598448	,	-0.486154703	),
  (	71	,	0.06004853	,	-0.405183372	),
  (	71	,	6.037252406	,	-0.467979645	),
  (	71	,	5.989059567	,	-0.332279023	),
  (	71	,	6.044819693	,	-0.294932643	),
  (	71	,	0.063114468	,	-0.251897543	),
  (	71	,	0.088040318	,	-0.227963929	),
  (	71	,	0.097026285	,	-0.090618587	),
  (	71	,	6.166385937	,	-0.220074319	),
  (	71	,	6.18809762	,	-0.150580926	),
  (	71	,	0.043271632	,	-0.044704261	),
  (	71	,	6.282202287	,	-0.004891874	),
  (	71	,	0.352026846	,	-0.242424704	),
  (	71	,	0.516886836	,	-0.123537413	),
  (	71	,	0.288442609	,	-0.191735691	),
  (	71	,	0.381670223	,	-0.162269747	),
  (	71	,	0.390682033	,	-0.165614809	),
  (	71	,	0.384054398	,	-0.035526128	),
  (	71	,	0.625567354	,	-0.108087872	),
  (	71	,	0.63241167	,	-0.067950056	),
  (	71	,	0.505706426	,	0.032301629	),
  (	71	,	0.564483178	,	0.104483423	),
  (	71	,	0.605162115	,	0.142780299	),
  (	71	,	0.223350225	,	-0.087966423	),
  (	71	,	0.247750954	,	-0.047650689	),
  (	71	,	0.129388715	,	-0.04957931	),
  (	71	,	0.138228719	,	-0.031307	),
  (	71	,	0.063747376	,	0.022632732	),
  (	71	,	0.197178899	,	0.004414376	),
  (	71	,	0.373843933	,	0.051870614	),
  (	71	,	0.360950009	,	0.082695506	),
  (	71	,	0.272677383	,	0.153962852	),
  (	71	,	5.86142308	,	-0.260971452	),
  (	71	,	5.995730044	,	-0.212768593	),
  (	71	,	5.930915157	,	-0.175018308	),
  (	71	,	5.818230692	,	-0.2081526	),
  (	71	,	5.729117923	,	-0.184357071	),
  (	71	,	5.917913812	,	-0.133767261	),
  (	71	,	5.9017254	,	-0.112869879	),
  (	71	,	5.874079565	,	-0.048686605	),
  (	71	,	6.165046166	,	-0.052653253	),
  (	71	,	5.946426319	,	0.004046107	),
  (	71	,	5.947069251	,	0.02124413	),
  (	71	,	5.994637616	,	0.032167498	),
  (	71	,	6.12769436	,	0.107971673	),
  (	71	,	5.666590596	,	-0.072441807	),
  (	71	,	5.647235697	,	-0.059529002	),
  (	71	,	5.621536435	,	-0.050361158	),
  (	71	,	5.563518658	,	-0.044888315	),
  (	71	,	5.740573916	,	0.041202383	),
  (	71	,	5.752896589	,	0.065903373	),
  (	71	,	5.634439958	,	0.066641123	),
  (	71	,	5.675828497	,	0.068014683	),
  (	71	,	5.936111513	,	0.079833897	),
  (	71	,	5.779295138	,	0.178725753	),
  (	71	,	5.790312101	,	0.205380475	),
  (	71	,	5.838432714	,	0.243477177	),
  (	71	,	0.069619412	,	0.074194128	),
  (	71	,	6.246833407	,	0.081996951	),
  (	71	,	0.087634376	,	0.109829105	),
  (	71	,	6.231873524	,	0.125017401	),
  (	71	,	6.216934075	,	0.125519465	),
  (	71	,	0.162743085	,	0.199605149	),
  (	71	,	0.137886793	,	0.279612859	),
  (	71	,	0.359163982	,	0.326074474	),
  (	71	,	0.335285644	,	0.367414957	),
  (	71	,	0.263834706	,	0.370866969	),
  (	71	,	0.141945458	,	0.328023251	),
  (	71	,	0.139254735	,	0.342835003	),
  (	71	,	0.164414548	,	0.368257586	),
  (	71	,	0.203980554	,	0.377413313	),
  (	71	,	0.142519096	,	0.404804505	),
  (	71	,	6.148083625	,	0.279471625	),
  (	71	,	6.152424187	,	0.376108746	),
  (	71	,	6.045311416	,	0.430275212	),
  (	71	,	6.102021301	,	0.48177089	),
  (	71	,	6.086686337	,	0.489926375	),
  (	71	,	0.061750153	,	0.458299576	),
  (	71	,	6.236515481	,	0.398883578	),
  (	71	,	0.006916247	,	0.496082869	),
  (	71	,	0.033102947	,	0.552725927	),
  (	71	,	6.238867347	,	0.483119832	),
  (	71	,	6.189677099	,	0.611441818	),
  (	71	,	0.045985659	,	0.578243004	),
  (	71	,	0.072937881	,	0.639307676	),
  (	71	,	1.579994927	,	-0.680484678	),
  (	71	,	1.519865456	,	-0.583499945	),
  (	71	,	1.645980646	,	-0.470065087	),
  (	71	,	1.46872119	,	-0.611926579	),
  (	71	,	1.497675504	,	-0.583375217	),
  (	71	,	1.523328877	,	-0.567308691	),
  (	71	,	1.422510987	,	-0.562155659	),
  (	71	,	1.536475232	,	-0.452789791	),
  (	71	,	1.77270319	,	-0.515938466	),
  (	71	,	1.845289479	,	-0.429054504	),
  (	71	,	1.751941442	,	-0.354612941	),
  (	71	,	1.753850304	,	-0.353430934	),
  (	71	,	1.86909405	,	-0.364065358	),
  (	71	,	1.944132158	,	-0.339252363	),
  (	71	,	1.833687405	,	-0.345599087	),
  (	71	,	1.793926373	,	-0.331848542	),
  (	71	,	1.7127822	,	-0.366898978	),
  (	71	,	1.766484106	,	-0.324118508	),
  (	71	,	1.767873856	,	-0.318844252	),
  (	71	,	1.73992077	,	-0.28380638	),
  (	71	,	1.754412677	,	-0.265571936	),
  (	71	,	1.825632377	,	-0.280204605	),
  (	71	,	1.758583805	,	-0.239080094	),
  (	71	,	1.279340603	,	-0.362542801	),
  (	71	,	1.425292106	,	-0.241892974	),
  (	71	,	1.355109933	,	-0.20330743	),
  (	71	,	1.560583888	,	-0.268886964	),
  (	71	,	1.629315851	,	-0.268504821	),
  (	71	,	1.606164724	,	-0.277533017	),
  (	71	,	1.589199725	,	-0.245812401	),
  (	71	,	1.589062601	,	-0.238926853	),
  (	71	,	1.535994995	,	-0.270631765	),
  (	71	,	1.555397484	,	-0.196842861	),
  (	71	,	1.643635143	,	-0.210268714	),
  (	71	,	1.635858865	,	-0.153662597	),
  (	71	,	1.487508342	,	-0.195483572	),
  (	71	,	1.444275334	,	-0.175986333	),
  (	71	,	1.462858499	,	-0.105291052	),
  (	71	,	1.463637334	,	-0.103189715	),
  (	71	,	1.557322805	,	-0.146328621	),
  (	71	,	1.58030918	,	-0.127226338	),
  (	71	,	1.597142319	,	-0.102630484	),
  (	71	,	1.543282632	,	-0.099568408	),
  (	71	,	1.550788262	,	-0.084226462	),
  (	71	,	1.585273511	,	-0.043260575	),
  (	71	,	1.992270759	,	-0.252783485	),
  (	71	,	1.902841724	,	-0.253248242	),
  (	71	,	1.963080512	,	-0.244160902	),
  (	71	,	1.998513506	,	-0.141830487	),
  (	71	,	1.869845842	,	-0.224901822	),
  (	71	,	1.841874134	,	-0.105112439	),
  (	71	,	1.972088859	,	-0.103719313	),
  (	71	,	2.032055022	,	-0.099108334	),
  (	71	,	2.022928995	,	-0.08216855	),
  (	71	,	2.022553935	,	-0.081693235	),
  (	71	,	2.029841305	,	-0.077741585	),
  (	71	,	1.881356379	,	-0.082087981	),
  (	71	,	1.954751833	,	-0.050305138	),
  (	71	,	1.945837951	,	-0.039248913	),
  (	71	,	2.167670888	,	-0.15733223	),
  (	71	,	2.10649307	,	-0.110346152	),
  (	71	,	2.090322475	,	-0.075620104	),
  (	71	,	2.127943325	,	-0.059458528	),
  (	71	,	2.29656827	,	0.011287485	),
  (	71	,	2.198835669	,	-0.026147446	),
  (	71	,	2.000616382	,	0.0088141	),
  (	71	,	2.191226574	,	0.03754699	),
  (	71	,	1.7713452	,	-0.128088836	),
  (	71	,	1.749826916	,	-0.132167066	),
  (	71	,	1.834128378	,	-0.101694247	),
  (	71	,	1.825918784	,	-0.052774301	),
  (	71	,	1.767961075	,	-0.000753818	),
  (	71	,	1.779330015	,	0.005938146	),
  (	71	,	1.671596648	,	-0.061362125	),
  (	71	,	1.735931829	,	0.009198611	),
  (	71	,	1.687396653	,	0.007925739	),
  (	71	,	1.634596806	,	0.039967505	),
  (	71	,	1.754396378	,	0.056691225	),
  (	71	,	1.793285596	,	0.101962993	),
  (	71	,	1.721742284	,	0.086701642	),
  (	71	,	1.709007598	,	0.10068827	),
  (	71	,	1.751861347	,	0.106653932	),
  (	71	,	1.755302838	,	0.129115629	),
  (	71	,	1.774471082	,	0.145962188	),
  (	71	,	1.985275342	,	0.077483983	),
  (	71	,	1.965938487	,	0.091710332	),
  (	71	,	2.073377835	,	0.16318712	),
  (	71	,	1.950768227	,	0.157842576	),
  (	71	,	1.939101002	,	0.178819573	),
  (	71	,	1.783434665	,	0.154743581	),
  (	71	,	1.795930425	,	0.164758022	),
  (	71	,	1.836858797	,	0.185439112	),
  (	71	,	1.869683518	,	0.190682433	),
  (	71	,	1.978582529	,	0.192188818	),
  (	71	,	1.920557443	,	0.281700731	),
  (	71	,	1.164526348	,	-0.325609587	),
  (	71	,	1.12677052	,	-0.255495089	),
  (	71	,	1.257643021	,	-0.165923389	),
  (	71	,	1.207917637	,	-0.147663441	),
  (	71	,	1.272677325	,	-0.146629477	),
  (	71	,	1.085490145	,	-0.151325857	),
  (	71	,	1.233391274	,	-0.100484017	),
  (	71	,	1.302185793	,	-0.065145689	),
  (	71	,	1.402694074	,	-0.026986818	),
  (	71	,	1.372772735	,	-0.00982386	),
  (	71	,	1.458058298	,	-0.03319274	),
  (	71	,	1.494650609	,	-0.000282386	),
  (	71	,	1.521778885	,	0.012663662	),
  (	71	,	1.427488461	,	-0.023864948	),
  (	71	,	1.461457472	,	-0.002144751	),
  (	71	,	1.242242068	,	0.009911346	),
  (	71	,	1.39546994	,	0.04385872	),
  (	71	,	1.426390563	,	0.063087907	),
  (	71	,	1.40870153	,	0.061997935	),
  (	71	,	1.405810717	,	0.094159458	),
  (	71	,	1.313798179	,	0.0648786	),
  (	71	,	1.35249753	,	0.14263552	),
  (	71	,	0.994751685	,	-0.04994097	),
  (	71	,	1.068532252	,	-0.042362672	),
  (	71	,	0.971363031	,	0.150698703	),
  (	71	,	1.142197653	,	0.041698127	),
  (	71	,	1.122202743	,	0.087693586	),
  (	71	,	1.114510286	,	0.108190772	),
  (	71	,	1.320010374	,	0.129571913	),
  (	71	,	1.085162148	,	0.176262685	),
  (	71	,	1.164365756	,	0.297199778	),
  (	71	,	1.153549726	,	0.298080757	),
  (	71	,	1.175237229	,	0.306214658	),
  (	71	,	1.641617277	,	0.089258366	),
  (	71	,	1.53784336	,	0.108372737	),
  (	71	,	1.505382026	,	0.110834869	),
  (	71	,	1.54670623	,	0.140574248	),
  (	71	,	1.701401542	,	0.124126974	),
  (	71	,	1.711694096	,	0.153900562	),
  (	71	,	1.640352655	,	0.179445805	),
  (	71	,	1.599016122	,	0.187625155	),
  (	71	,	1.652935312	,	0.194864325	),
  (	71	,	1.677974515	,	0.19646261	),
  (	71	,	1.426807454	,	0.12514107	),
  (	71	,	1.531762673	,	0.200694805	),
  (	71	,	1.443806432	,	0.177374375	),
  (	71	,	1.557022087	,	0.285449495	),
  (	71	,	1.789120846	,	0.210453557	),
  (	71	,	1.72402753	,	0.221111743	),
  (	71	,	1.723273405	,	0.292582609	),
  (	71	,	1.835440117	,	0.29599194	),
  (	71	,	1.860041043	,	0.309697755	),
  (	71	,	1.722008525	,	0.339099507	),
  (	71	,	1.655337497	,	0.406216488	),
  (	71	,	1.779328718	,	0.378587319	),
  (	71	,	1.824729896	,	0.392290009	),
  (	71	,	1.835535157	,	0.409106553	),
  (	71	,	1.819486379	,	0.430094894	),
  (	71	,	1.84184463	,	0.443760672	),
  (	71	,	1.787747659	,	0.44478174	),
  (	71	,	1.793358486	,	0.449579063	),
  (	71	,	1.729785719	,	0.476091542	),
  (	71	,	1.484901064	,	0.267906628	),
  (	71	,	1.259726074	,	0.326494757	),
  (	71	,	1.259825843	,	0.372028421	),
  (	71	,	1.385481158	,	0.419038681	),
  (	71	,	1.461973618	,	0.423952557	),
  (	71	,	1.352938698	,	0.480940891	),
  (	71	,	1.346473161	,	0.493464483	),
  (	71	,	1.584392196	,	0.359297794	),
  (	71	,	1.572854968	,	0.399673284	),
  (	71	,	1.560390502	,	0.429576325	),
  (	71	,	1.551907654	,	0.483729099	),
  (	71	,	1.660706331	,	0.439630781	),
  (	71	,	1.662718426	,	0.512635244	),
  (	71	,	1.708727668	,	0.561403104	),
  (	71	,	1.566135286	,	0.523312034	),
  (	71	,	1.489456457	,	0.51477145	),
  (	71	,	3.134331227	,	-0.714662199	),
  (	71	,	3.16871389	,	-0.675019118	),
  (	71	,	3.149291573	,	-0.604761191	),
  (	71	,	3.241948088	,	-0.434080231	),
  (	71	,	3.04461838	,	-0.54487584	),
  (	71	,	3.138848407	,	-0.524660444	),
  (	71	,	3.07149437	,	-0.519191006	),
  (	71	,	3.130741091	,	-0.472222901	),
  (	71	,	3.172219382	,	-0.414795389	),
  (	71	,	3.121973563	,	-0.433842147	),
  (	71	,	3.330167613	,	-0.43616816	),
  (	71	,	3.498382637	,	-0.32711313	),
  (	71	,	3.377228893	,	-0.314815681	),
  (	71	,	3.209696186	,	-0.358303377	),
  (	71	,	3.318743703	,	-0.246088585	),
  (	71	,	3.263895255	,	-0.252220306	),
  (	71	,	3.331612359	,	-0.241898087	),
  (	71	,	3.344513791	,	-0.20616033	),
  (	71	,	2.948329701	,	-0.399956129	),
  (	71	,	3.086516291	,	-0.32080986	),
  (	71	,	2.989973217	,	-0.324756403	),
  (	71	,	2.87519676	,	-0.342177111	),
  (	71	,	3.092258576	,	-0.250367125	),
  (	71	,	3.225964395	,	-0.155592941	),
  (	71	,	3.071423748	,	-0.159393758	),
  (	71	,	3.103120085	,	-0.139482821	),
  (	71	,	3.22080136	,	-0.069010145	),
  (	71	,	3.191162064	,	-0.065961363	),
  (	71	,	3.532059155	,	-0.326887467	),
  (	71	,	3.499851397	,	-0.251679695	),
  (	71	,	3.610304673	,	-0.117033087	),
  (	71	,	3.454329796	,	-0.195854923	),
  (	71	,	3.549155609	,	-0.133039185	),
  (	71	,	3.509996737	,	-0.07522328	),
  (	71	,	3.778334061	,	0.017322426	),
  (	71	,	3.650692138	,	0.052124123	),
  (	71	,	3.791470114	,	0.06492151	),
  (	71	,	3.809401893	,	0.092898468	),
  (	71	,	3.360103742	,	-0.133205569	),
  (	71	,	3.32468591	,	-0.130910449	),
  (	71	,	3.27614311	,	-0.070873779	),
  (	71	,	3.303551136	,	-0.040546105	),
  (	71	,	3.176541033	,	0.010840964	),
  (	71	,	3.202360749	,	0.039445842	),
  (	71	,	3.34682722	,	0.158194264	),
  (	71	,	3.493116351	,	0.084248418	),
  (	71	,	3.593571634	,	0.250726169	),
  (	71	,	3.515379597	,	0.271643856	),
  (	71	,	2.737646578	,	-0.319165225	),
  (	71	,	2.756006638	,	-0.259793341	),
  (	71	,	2.672092255	,	-0.262988058	),
  (	71	,	2.781402157	,	-0.216312852	),
  (	71	,	2.803237096	,	-0.15231735	),
  (	71	,	2.629116485	,	-0.232065864	),
  (	71	,	2.589041765	,	-0.172852438	),
  (	71	,	2.571245191	,	-0.154200662	),
  (	71	,	2.759693998	,	-0.106034398	),
  (	71	,	2.986083072	,	-0.103159302	),
  (	71	,	3.002223443	,	-0.015673054	),
  (	71	,	3.064903453	,	0.041222489	),
  (	71	,	2.833046347	,	-0.070230884	),
  (	71	,	2.981250532	,	0.114942561	),
  (	71	,	2.491104863	,	-0.098807524	),
  (	71	,	2.406320135	,	0.005080862	),
  (	71	,	2.448468192	,	0.051330322	),
  (	71	,	2.520573681	,	0.029604626	),
  (	71	,	2.562462998	,	0.149579501	),
  (	71	,	2.841133215	,	0.20208369	),
  (	71	,	2.724129549	,	0.184791237	),
  (	71	,	2.743686414	,	0.250344051	),
  (	71	,	3.138968159	,	0.031876997	),
  (	71	,	3.323998574	,	0.172546658	),
  (	71	,	3.039344886	,	0.106564221	),
  (	71	,	3.006258298	,	0.175199185	),
  (	71	,	3.172925897	,	0.226633879	),
  (	71	,	3.093728558	,	0.281565703	),
  (	71	,	3.339838938	,	0.250867046	),
  (	71	,	3.370152502	,	0.298593294	),
  (	71	,	3.351065408	,	0.328762137	),
  (	71	,	3.20802852	,	0.295091878	),
  (	71	,	3.380128969	,	0.385852329	),
  (	71	,	3.358936287	,	0.461311719	),
  (	71	,	3.017365242	,	0.309788786	),
  (	71	,	2.873796614	,	0.342467677	),
  (	71	,	2.958429552	,	0.387112003	),
  (	71	,	3.084925608	,	0.414001791	),
  (	71	,	3.231868567	,	0.472177092	),
  (	71	,	3.203138537	,	0.572191292	),
  (	71	,	3.038950696	,	0.436852029	),
  (	71	,	3.038183176	,	0.48487369	),
  (	71	,	3.091885719	,	0.502652757	),
  (	71	,	3.010995035	,	0.522957376	),
  (	71	,	3.11451067	,	0.586694893	),
  (	71	,	4.736594369	,	-0.654010782	),
  (	71	,	4.708791408	,	-0.673236723	),
  (	71	,	4.713484433	,	-0.652896739	),
  (	71	,	4.709007033	,	-0.644705782	),
  (	71	,	4.763349094	,	-0.61130982	),
  (	71	,	4.662075806	,	-0.665555424	),
  (	71	,	4.661123574	,	-0.626494201	),
  (	71	,	4.685055884	,	-0.607277428	),
  (	71	,	4.803709977	,	-0.58178137	),
  (	71	,	4.741898614	,	-0.495043627	),
  (	71	,	4.774262809	,	-0.480017704	),
  (	71	,	4.614750822	,	-0.599552766	),
  (	71	,	4.623492564	,	-0.564093534	),
  (	71	,	4.611932767	,	-0.560755018	),
  (	71	,	4.617266663	,	-0.489510338	),
  (	71	,	4.72392449	,	-0.423336522	),
  (	71	,	4.72954396	,	-0.398588762	),
  (	71	,	4.994977625	,	-0.440367978	),
  (	71	,	4.897498208	,	-0.35451114	),
  (	71	,	5.00460749	,	-0.392658521	),
  (	71	,	4.93490927	,	-0.354219208	),
  (	71	,	4.922803215	,	-0.335084859	),
  (	71	,	5.01324488	,	-0.326076543	),
  (	71	,	4.866833873	,	-0.336301011	),
  (	71	,	4.851530202	,	-0.33379623	),
  (	71	,	4.867778483	,	-0.323769692	),
  (	71	,	4.784775637	,	-0.358570568	),
  (	71	,	4.779058298	,	-0.331486297	),
  (	71	,	4.736627707	,	-0.344776046	),
  (	71	,	4.943677553	,	-0.28591133	),
  (	71	,	4.832481873	,	-0.26831663	),
  (	71	,	4.876214654	,	-0.215551488	),
  (	71	,	4.909054651	,	-0.199931034	),
  (	71	,	4.505827992	,	-0.377096868	),
  (	71	,	4.49890225	,	-0.360506992	),
  (	71	,	4.410989851	,	-0.288799893	),
  (	71	,	4.519027621	,	-0.171198359	),
  (	71	,	4.690262476	,	-0.203008587	),
  (	71	,	4.799930196	,	-0.167504165	),
  (	71	,	4.6903964	,	-0.134989573	),
  (	71	,	4.682965272	,	-0.103482506	),
  (	71	,	4.680175464	,	-0.091842635	),
  (	71	,	5.139166617	,	-0.243585508	),
  (	71	,	5.135793663	,	-0.229913002	),
  (	71	,	5.051273695	,	-0.278681196	),
  (	71	,	5.057790353	,	-0.277653552	),
  (	71	,	5.199998397	,	-0.227466925	),
  (	71	,	5.152011327	,	-0.131122314	),
  (	71	,	5.047817488	,	-0.191492535	),
  (	71	,	4.951983342	,	-0.183545839	),
  (	71	,	5.009162643	,	-0.136975301	),
  (	71	,	5.072651464	,	-0.064896822	),
  (	71	,	5.130585257	,	-0.042867509	),
  (	71	,	5.110599178	,	-0.036830467	),
  (	71	,	5.303149282	,	-0.096634281	),
  (	71	,	5.229626703	,	-0.06202447	),
  (	71	,	5.291786685	,	-0.052289385	),
  (	71	,	5.365787171	,	0.052293632	),
  (	71	,	5.264986715	,	0.132225739	),
  (	71	,	4.932013096	,	-0.138014584	),
  (	71	,	4.918068947	,	-0.102949709	),
  (	71	,	4.979242111	,	-0.077473675	),
  (	71	,	4.997140709	,	-0.016333177	),
  (	71	,	4.967331493	,	0.020910016	),
  (	71	,	4.955909508	,	0.060209402	),
  (	71	,	4.932421263	,	0.13016571	),
  (	71	,	5.062869191	,	0.083377392	),
  (	71	,	5.02265337	,	0.092060763	),
  (	71	,	5.038526469	,	0.10556678	),
  (	71	,	5.112609121	,	0.10069084	),
  (	71	,	5.113863667	,	0.13068336	),
  (	71	,	5.114738964	,	0.162913892	),
  (	71	,	5.18424727	,	0.234815318	),
  (	71	,	5.006660276	,	0.107560121	),
  (	71	,	5.091762478	,	0.210520932	),
  (	71	,	5.107382757	,	0.223691172	),
  (	71	,	5.168779819	,	0.230912445	),
  (	71	,	5.093929724	,	0.319322776	),
  (	71	,	4.313005804	,	-0.233867401	),
  (	71	,	4.368251682	,	-0.206624346	),
  (	71	,	4.429351841	,	-0.116083505	),
  (	71	,	4.229728823	,	-0.227815125	),
  (	71	,	4.134828647	,	-0.165462887	),
  (	71	,	4.248812507	,	-0.141686862	),
  (	71	,	4.272376286	,	-0.120024993	),
  (	71	,	4.551273226	,	-0.124003571	),
  (	71	,	4.56633029	,	0.01434881	),
  (	71	,	4.54271262	,	0.025218675	),
  (	71	,	4.144991106	,	-0.068440272	),
  (	71	,	4.140265483	,	-0.017475448	),
  (	71	,	4.254548302	,	-0.030971505	),
  (	71	,	4.28295385	,	0.001335276	),
  (	71	,	4.170931937	,	-0.037783507	),
  (	71	,	4.133280266	,	-0.004713508	),
  (	71	,	4.251485651	,	0.046194827	),
  (	71	,	4.009549774	,	-0.027789705	),
  (	71	,	3.996764986	,	0.013882501	),
  (	71	,	4.164475665	,	0.092404453	),
  (	71	,	4.077637087	,	0.082564013	),
  (	71	,	4.146015495	,	0.103927253	),
  (	71	,	4.318725182	,	0.135242977	),
  (	71	,	4.492838898	,	0.175191637	),
  (	71	,	4.461733865	,	0.171389974	),
  (	71	,	4.406820146	,	0.164434396	),
  (	71	,	4.339155001	,	0.151389257	),
  (	71	,	4.168543473	,	0.160977136	),
  (	71	,	4.130860074	,	0.170804228	),
  (	71	,	4.230092755	,	0.205040958	),
  (	71	,	4.245351543	,	0.223417471	),
  (	71	,	4.751109068	,	0.034834259	),
  (	71	,	4.67347447	,	0.091265868	),
  (	71	,	4.654287031	,	0.100779059	),
  (	71	,	4.713303883	,	0.154564411	),
  (	71	,	4.742267382	,	0.154896803	),
  (	71	,	4.673428559	,	0.148895049	),
  (	71	,	4.6489259	,	0.194512315	),
  (	71	,	4.576237473	,	0.18385232	),
  (	71	,	4.719169273	,	0.1969738	),
  (	71	,	4.911914474	,	0.200660479	),
  (	71	,	4.888286654	,	0.210384863	),
  (	71	,	4.893360467	,	0.213568819	),
  (	71	,	4.920501122	,	0.234611865	),
  (	71	,	4.926995162	,	0.255830242	),
  (	71	,	4.951517914	,	0.267778866	),
  (	71	,	4.840930968	,	0.241806526	),
  (	71	,	4.868986363	,	0.296266344	),
  (	71	,	4.992368031	,	0.306421075	),
  (	71	,	5.065818053	,	0.334160405	),
  (	71	,	4.950398021	,	0.35980491	),
  (	71	,	4.796481201	,	0.276216098	),
  (	71	,	4.857444521	,	0.330129747	),
  (	71	,	4.932337563	,	0.420742742	),
  (	71	,	4.930247421	,	0.46120889	),
  (	71	,	4.546375495	,	0.203718654	),
  (	71	,	4.436018385	,	0.24679692	),
  (	71	,	4.444618637	,	0.269746329	),
  (	71	,	4.52266517	,	0.31450115	),
  (	71	,	4.589783208	,	0.293632061	),
  (	71	,	4.406743555	,	0.268376273	),
  (	71	,	4.41461891	,	0.359089686	),
  (	71	,	4.52555228	,	0.451585741	),
  (	71	,	4.535245241	,	0.476190349	),
  (	71	,	4.668845499	,	0.427048177	),
  (	71	,	4.892474445	,	0.528737046	),
  (	71	,	4.774035419	,	0.492464147	),
  (	71	,	4.701068935	,	0.582952483	),
  (	71	,	4.671045382	,	0.643086123	),
  (	71	,	4.699945514	,	0.659788235	),
  (	71	,	1.107315574	,	-1.47455422	),
  (	71	,	0.173321053	,	-1.495763893	),
  (	71	,	0.944285572	,	-1.380535571	),
  (	71	,	0.497866158	,	-1.352473564	),
  (	71	,	0.571122661	,	-1.325732258	),
  (	71	,	0.531768202	,	-1.299324804	),
  (	71	,	0.807197538	,	-1.297118346	),
  (	71	,	1.407333126	,	-1.288076378	),
  (	71	,	1.198106073	,	-1.269436979	),
  (	71	,	1.105029646	,	-1.229061219	),
  (	71	,	1.434444068	,	-1.142275501	),
  (	71	,	1.15162543	,	-1.164774877	),
  (	71	,	0.877238408	,	-1.196122908	),
  (	71	,	1.184186367	,	-1.043127796	),
  (	71	,	1.050460409	,	-1.023839264	),
  (	71	,	0.535063918	,	-1.229048275	),
  (	71	,	0.689297505	,	-1.174623962	),
  (	71	,	0.186275785	,	-1.145084312	),
  (	71	,	0.033530745	,	-1.150744945	),
  (	71	,	0.229526502	,	-1.112488994	),
  (	71	,	0.781638395	,	-0.969803056	),
  (	71	,	0.951955279	,	-1.043289406	),
  (	71	,	0.958422586	,	-0.981476882	),
  (	71	,	0.655638588	,	-1.008961835	),
  (	71	,	0.62654766	,	-0.970687906	),
  (	71	,	0.783546245	,	-0.940880052	),
  (	71	,	0.721163018	,	-0.807860642	),
  (	71	,	1.446883919	,	-1.074093911	),
  (	71	,	1.475995887	,	-1.031777411	),
  (	71	,	1.398313052	,	-1.060804831	),
  (	71	,	1.300413065	,	-1.015925991	),
  (	71	,	1.224220226	,	-0.847148996	),
  (	71	,	1.53767469	,	-0.908537291	),
  (	71	,	1.519399103	,	-0.853788489	),
  (	71	,	1.490268509	,	-0.842131207	),
  (	71	,	1.427271065	,	-0.782987245	),
  (	71	,	1.51621594	,	-0.725887207	),
  (	71	,	1.43006827	,	-0.68455186	),
  (	71	,	1.352807565	,	-0.707893477	),
  (	71	,	0.973394157	,	-0.88382751	),
  (	71	,	1.044312971	,	-0.766505661	),
  (	71	,	0.941739597	,	-0.762992779	),
  (	71	,	0.839640397	,	-0.775271896	),
  (	71	,	0.888328581	,	-0.699460504	),
  (	71	,	0.935920151	,	-0.60794659	),
  (	71	,	1.181979272	,	-0.718628764	),
  (	71	,	1.261857188	,	-0.598857789	),
  (	71	,	1.104103137	,	-0.572376317	),
  (	71	,	1.071685284	,	-0.541944206	),
  (	71	,	1.232070546	,	-0.404532879	),
  (	71	,	1.133186377	,	-0.43676549	),
  (	71	,	0.267565331	,	-1.062198094	),
  (	71	,	0.306554219	,	-0.992453823	),
  (	71	,	0.422391586	,	-0.851784902	),
  (	71	,	0.281005718	,	-0.836715021	),
  (	71	,	0.359580394	,	-0.761003813	),
  (	71	,	0.575541465	,	-0.823283254	),
  (	71	,	0.722344409	,	-0.747685057	),
  (	71	,	0.630211128	,	-0.652084464	),
  (	71	,	0.150183666	,	-0.792828334	),
  (	71	,	0.278932211	,	-0.709446167	),
  (	71	,	0.12822281	,	-0.709746605	),
  (	71	,	0.110695487	,	-0.685233218	),
  (	71	,	0.456463209	,	-0.600501222	),
  (	71	,	0.363410924	,	-0.585523738	),
  (	71	,	0.203419805	,	-0.526931672	),
  (	71	,	0.411852234	,	-0.492824832	),
  (	71	,	0.387454676	,	-0.432805789	),
  (	71	,	0.857596715	,	-0.622929113	),
  (	71	,	0.849405456	,	-0.620596226	),
  (	71	,	0.735816812	,	-0.652763716	),
  (	71	,	0.838111029	,	-0.505840599	),
  (	71	,	0.84372806	,	-0.481252507	),
  (	71	,	0.714106995	,	-0.576752005	),
  (	71	,	0.76189131	,	-0.539146085	),
  (	71	,	0.716668432	,	-0.4449726	),
  (	71	,	0.9594512	,	-0.497632553	),
  (	71	,	0.999213658	,	-0.454356702	),
  (	71	,	1.031843301	,	-0.439531311	),
  (	71	,	0.92694497	,	-0.429635999	),
  (	71	,	1.059346832	,	-0.394358133	),
  (	71	,	1.112665699	,	-0.282410778	),
  (	71	,	0.962866678	,	-0.339863211	),
  (	71	,	0.871686784	,	-0.328893966	),
  (	71	,	0.958237014	,	-0.303080223	),
  (	71	,	0.968244018	,	-0.250686122	),
  (	71	,	0.987076919	,	-0.172485744	),
  (	71	,	0.684322609	,	-0.351198799	),
  (	71	,	0.721285425	,	-0.356075583	),
  (	71	,	0.606051801	,	-0.340946885	),
  (	71	,	0.680435521	,	-0.30774986	),
  (	71	,	0.679104602	,	-0.260852172	),
  (	71	,	0.521495571	,	-0.242118962	),
  (	71	,	0.817291156	,	-0.240220011	),
  (	71	,	0.919253472	,	-0.169820162	),
  (	71	,	0.759729407	,	-0.182252661	),
  (	71	,	0.678095027	,	-0.163201964	),
  (	71	,	0.594598702	,	-0.171417835	),
  (	71	,	0.85720124	,	-0.074831128	),
  (	71	,	0.785620654	,	-0.031495366	),
  (	71	,	2.917633021	,	-1.505013153	),
  (	71	,	2.262883801	,	-1.292820231	),
  (	71	,	3.067972922	,	-1.264413486	),
  (	71	,	3.048360993	,	-1.263076088	),
  (	71	,	2.771162811	,	-1.210413693	),
  (	71	,	3.070083118	,	-1.195179228	),
  (	71	,	2.94685157	,	-1.160852079	),
  (	71	,	2.787531474	,	-1.125701341	),
  (	71	,	2.799440379	,	-1.118866351	),
  (	71	,	2.887770805	,	-1.12231481	),
  (	71	,	2.552880056	,	-1.217575319	),
  (	71	,	2.666904978	,	-1.184944728	),
  (	71	,	2.431375322	,	-1.181177462	),
  (	71	,	2.535532654	,	-1.153311471	),
  (	71	,	2.52563072	,	-1.12554383	),
  (	71	,	2.643655901	,	-1.114134863	),
  (	71	,	2.669611384	,	-1.074109057	),
  (	71	,	2.805880696	,	-1.064421773	),
  (	71	,	2.609779355	,	-1.092317735	),
  (	71	,	2.614574559	,	-1.014527223	),
  (	71	,	2.111350624	,	-1.203173874	),
  (	71	,	1.813758098	,	-1.195645465	),
  (	71	,	2.087289602	,	-1.062166255	),
  (	71	,	2.017376658	,	-1.023984693	),
  (	71	,	2.350816564	,	-1.126269452	),
  (	71	,	2.32287037	,	-0.981608901	),
  (	71	,	2.376033425	,	-0.983335651	),
  (	71	,	2.499233623	,	-0.996482943	),
  (	71	,	2.495353902	,	-0.994642998	),
  (	71	,	2.42072937	,	-0.971115979	),
  (	71	,	2.471663047	,	-0.957737575	),
  (	71	,	2.473517161	,	-0.948615902	),
  (	71	,	2.456983838	,	-0.939338305	),
  (	71	,	2.252213578	,	-0.989822485	),
  (	71	,	2.205103092	,	-0.972994199	),
  (	71	,	2.149130583	,	-0.945029834	),
  (	71	,	2.186698165	,	-0.917826665	),
  (	71	,	2.166485397	,	-0.920834658	),
  (	71	,	2.152213852	,	-0.911693158	),
  (	71	,	2.226449539	,	-0.892470993	),
  (	71	,	2.345202348	,	-0.885745806	),
  (	71	,	2.280187312	,	-0.840612898	),
  (	71	,	2.287085844	,	-0.822330229	),
  (	71	,	2.285471489	,	-0.816795678	),
  (	71	,	3.128322518	,	-1.103904739	),
  (	71	,	3.044756783	,	-1.105198235	),
  (	71	,	3.038934435	,	-1.076259664	),
  (	71	,	2.997576546	,	-1.071096534	),
  (	71	,	3.131860636	,	-1.055074604	),
  (	71	,	3.043588947	,	-1.073114661	),
  (	71	,	3.059445376	,	-1.06711458	),
  (	71	,	3.043706841	,	-1.053566298	),
  (	71	,	3.000733534	,	-1.05585171	),
  (	71	,	2.926482763	,	-1.053907759	),
  (	71	,	2.957870637	,	-1.03386978	),
  (	71	,	2.955966373	,	-1.031583033	),
  (	71	,	3.064265372	,	-1.004699771	),
  (	71	,	3.058600921	,	-0.96994647	),
  (	71	,	3.069835696	,	-0.918385229	),
  (	71	,	2.979761119	,	-0.886394577	),
  (	71	,	2.833561154	,	-1.035393752	),
  (	71	,	2.77104173	,	-1.006656262	),
  (	71	,	2.788188241	,	-0.961914603	),
  (	71	,	2.725594565	,	-0.948096153	),
  (	71	,	2.810670279	,	-0.906239617	),
  (	71	,	2.756445843	,	-0.776406429	),
  (	71	,	2.747309472	,	-0.751377462	),
  (	71	,	2.994894676	,	-0.760325325	),
  (	71	,	3.043608123	,	-0.686942776	),
  (	71	,	2.86944201	,	-0.800684718	),
  (	71	,	2.870990016	,	-0.733727243	),
  (	71	,	2.820673501	,	-0.744266411	),
  (	71	,	2.818016622	,	-0.715119771	),
  (	71	,	2.953465755	,	-0.670181496	),
  (	71	,	2.917569179	,	-0.688919645	),
  (	71	,	2.953790704	,	-0.609597172	),
  (	71	,	2.945396996	,	-0.581497674	),
  (	71	,	2.647954685	,	-0.89147354	),
  (	71	,	2.636942475	,	-0.845532715	),
  (	71	,	2.519715294	,	-0.872479255	),
  (	71	,	2.736494885	,	-0.733965585	),
  (	71	,	2.598075612	,	-0.725827549	),
  (	71	,	2.484071544	,	-0.777350576	),
  (	71	,	2.484789641	,	-0.777234226	),
  (	71	,	2.434712906	,	-0.796503331	),
  (	71	,	2.511903469	,	-0.771226521	),
  (	71	,	2.539548585	,	-0.737968826	),
  (	71	,	2.420453317	,	-0.758599336	),
  (	71	,	2.563801426	,	-0.666536294	),
  (	71	,	2.923327706	,	-0.520007835	),
  (	71	,	2.807230706	,	-0.560899493	),
  (	71	,	2.642176557	,	-0.582805789	),
  (	71	,	2.722364489	,	-0.517400081	),
  (	71	,	1.656505024	,	-1.113926725	),
  (	71	,	1.713791093	,	-1.079096053	),
  (	71	,	1.932713104	,	-0.969991092	),
  (	71	,	2.001118405	,	-0.981385653	),
  (	71	,	2.073721246	,	-0.923315392	),
  (	71	,	2.022373175	,	-0.946687561	),
  (	71	,	1.73487272	,	-0.965926913	),
  (	71	,	1.888256266	,	-0.893814668	),
  (	71	,	2.100217356	,	-0.866040661	),
  (	71	,	2.117816068	,	-0.851835656	),
  (	71	,	2.177173287	,	-0.823986616	),
  (	71	,	2.063140761	,	-0.881769129	),
  (	71	,	2.094609614	,	-0.785846015	),
  (	71	,	2.133026625	,	-0.823346913	),
  (	71	,	2.184172871	,	-0.772394972	),
  (	71	,	2.282516896	,	-0.795201804	),
  (	71	,	2.297513022	,	-0.742920592	),
  (	71	,	2.301373646	,	-0.740939808	),
  (	71	,	2.260612741	,	-0.663382222	),
  (	71	,	2.071468087	,	-0.774153393	),
  (	71	,	1.992414513	,	-0.785175019	),
  (	71	,	2.10800241	,	-0.717781446	),
  (	71	,	2.005808384	,	-0.755370533	),
  (	71	,	2.02071202	,	-0.67829881	),
  (	71	,	2.180601662	,	-0.653062145	),
  (	71	,	2.166024341	,	-0.631853771	),
  (	71	,	2.227460892	,	-0.640907792	),
  (	71	,	2.159603437	,	-0.622880945	),
  (	71	,	2.15480894	,	-0.614502128	),
  (	71	,	1.660023706	,	-0.857032367	),
  (	71	,	1.735011417	,	-0.864421885	),
  (	71	,	1.777524746	,	-0.847589766	),
  (	71	,	1.767908112	,	-0.824191491	),
  (	71	,	1.714623079	,	-0.847277713	),
  (	71	,	1.786896314	,	-0.795290844	),
  (	71	,	1.787035488	,	-0.723059337	),
  (	71	,	1.590460909	,	-0.788830312	),
  (	71	,	1.675956283	,	-0.640588507	),
  (	71	,	1.739486654	,	-0.663158147	),
  (	71	,	1.725980742	,	-0.632852804	),
  (	71	,	1.772499898	,	-0.597648054	),
  (	71	,	1.897092614	,	-0.650054403	),
  (	71	,	1.988992377	,	-0.582809055	),
  (	71	,	1.929188606	,	-0.568756057	),
  (	71	,	2.081524698	,	-0.600016103	),
  (	71	,	2.071940728	,	-0.550384567	),
  (	71	,	2.015941996	,	-0.559898399	),
  (	71	,	2.044687234	,	-0.536792547	),
  (	71	,	2.074159753	,	-0.493647569	),
  (	71	,	1.935887072	,	-0.531435675	),
  (	71	,	1.896339482	,	-0.535023397	),
  (	71	,	1.90840085	,	-0.50843491	),
  (	71	,	1.90729394	,	-0.499171085	),
  (	71	,	1.783913329	,	-0.519124637	),
  (	71	,	1.785781996	,	-0.505684316	),
  (	71	,	1.994294255	,	-0.468043267	),
  (	71	,	2.001289566	,	-0.45931292	),
  (	71	,	2.033552613	,	-0.403900931	),
  (	71	,	1.906063732	,	-0.439108023	),
  (	71	,	1.896743606	,	-0.409966872	),
  (	71	,	1.942257809	,	-0.36955312	),
  (	71	,	2.303222959	,	-0.582911969	),
  (	71	,	2.37045353	,	-0.586442032	),
  (	71	,	2.488525973	,	-0.583007848	),
  (	71	,	2.424157395	,	-0.5816161	),
  (	71	,	2.294859125	,	-0.561363512	),
  (	71	,	2.193713506	,	-0.551655141	),
  (	71	,	2.182011392	,	-0.542759538	),
  (	71	,	2.19278388	,	-0.51823099	),
  (	71	,	2.171488734	,	-0.518241525	),
  (	71	,	2.256108489	,	-0.461056325	),
  (	71	,	2.355719824	,	-0.396037541	),
  (	71	,	2.558476148	,	-0.476066041	),
  (	71	,	2.578995695	,	-0.40172873	),
  (	71	,	2.557405281	,	-0.344318226	),
  (	71	,	2.729696795	,	-0.342079508	),
  (	71	,	2.674786749	,	-0.343638901	),
  (	71	,	2.598748435	,	-0.304901411	),
  (	71	,	2.635540721	,	-0.315922104	),
  (	71	,	2.457607093	,	-0.367176156	),
  (	71	,	2.454320104	,	-0.312312466	),
  (	71	,	2.484673916	,	-0.305524955	),
  (	71	,	2.551928611	,	-0.309034995	),
  (	71	,	2.562015786	,	-0.187516141	),
  (	71	,	2.56163723	,	-0.18366168	),
  (	71	,	2.209124297	,	-0.473777808	),
  (	71	,	2.202944937	,	-0.413445846	),
  (	71	,	2.212918337	,	-0.409072353	),
  (	71	,	2.199718416	,	-0.333991969	),
  (	71	,	2.01996244	,	-0.383894751	),
  (	71	,	2.159544623	,	-0.3015136	),
  (	71	,	2.187391499	,	-0.261380144	),
  (	71	,	2.40057552	,	-0.29430747	),
  (	71	,	2.387809677	,	-0.232253262	),
  (	71	,	2.479860551	,	-0.174304129	),
  (	71	,	2.444986994	,	-0.167732744	),
  (	71	,	2.467238737	,	-0.111781876	),
  (	71	,	2.295802736	,	-0.189018514	),
  (	71	,	2.188560888	,	-0.151333853	),
  (	71	,	2.236587869	,	-0.10296695	),
  (	71	,	2.315196291	,	-0.08201836	),
  (	71	,	2.314368124	,	-0.073277898	),
  (	71	,	3.819820859	,	-1.566813062	),
  (	71	,	3.558356243	,	-1.497917013	),
  (	71	,	4.493616673	,	-1.436733416	),
  (	71	,	4.286354755	,	-1.409281284	),
  (	71	,	4.454546027	,	-1.330286982	),
  (	71	,	4.008103768	,	-1.369599653	),
  (	71	,	4.288711707	,	-1.326010586	),
  (	71	,	3.483617416	,	-1.375724947	),
  (	71	,	3.821856062	,	-1.345872499	),
  (	71	,	3.282551517	,	-1.392490004	),
  (	71	,	3.635087257	,	-1.278783303	),
  (	71	,	3.971279335	,	-1.317058903	),
  (	71	,	3.965423928	,	-1.234136756	),
  (	71	,	3.858176416	,	-1.216053936	),
  (	71	,	3.874418873	,	-1.195894808	),
  (	71	,	4.223540608	,	-1.255674982	),
  (	71	,	4.263940308	,	-1.239032359	),
  (	71	,	4.423659079	,	-1.224715839	),
  (	71	,	4.543196133	,	-1.109721643	),
  (	71	,	4.348189479	,	-1.169459837	),
  (	71	,	4.156508929	,	-1.18053549	),
  (	71	,	4.278529258	,	-1.196191464	),
  (	71	,	4.188065145	,	-1.131919066	),
  (	71	,	4.08611998	,	-1.161433569	),
  (	71	,	4.054668122	,	-1.150005895	),
  (	71	,	4.025318503	,	-1.155609497	),
  (	71	,	4.125344545	,	-1.147550358	),
  (	71	,	4.107736174	,	-1.135656624	),
  (	71	,	4.23585835	,	-0.978636552	),
  (	71	,	4.186152067	,	-1.024966549	),
  (	71	,	3.481884807	,	-1.280109539	),
  (	71	,	3.560389426	,	-1.279806304	),
  (	71	,	3.375724384	,	-1.243958528	),
  (	71	,	3.545402375	,	-1.208320862	),
  (	71	,	3.378514685	,	-1.22237226	),
  (	71	,	3.822496484	,	-1.117283751	),
  (	71	,	3.575133565	,	-1.181099966	),
  (	71	,	3.635965784	,	-1.160861196	),
  (	71	,	3.392606989	,	-1.145743093	),
  (	71	,	3.20391528	,	-1.161493786	),
  (	71	,	3.551020097	,	-1.153286705	),
  (	71	,	3.530320825	,	-1.114812436	),
  (	71	,	3.589885242	,	-1.080220525	),
  (	71	,	3.64215862	,	-1.070489905	),
  (	71	,	3.648066137	,	-0.976567411	),
  (	71	,	3.981495263	,	-1.100147226	),
  (	71	,	3.965814268	,	-1.03222668	),
  (	71	,	3.884527076	,	-1.029338971	),
  (	71	,	4.055911629	,	-1.018430797	),
  (	71	,	3.782911802	,	-1.033892324	),
  (	71	,	3.763903153	,	-1.020341782	),
  (	71	,	3.775941704	,	-0.960252455	),
  (	71	,	4.006244014	,	-0.836009748	),
  (	71	,	3.998044904	,	-0.838537819	),
  (	71	,	3.939891736	,	-0.83674684	),
  (	71	,	3.893837879	,	-0.816115521	),
  (	71	,	3.92659686	,	-0.807181377	),
  (	71	,	3.924035543	,	-0.758746929	),
  (	71	,	4.603531767	,	-1.084044417	),
  (	71	,	4.595405608	,	-1.022020428	),
  (	71	,	4.512846239	,	-1.094923495	),
  (	71	,	4.540543829	,	-1.037435471	),
  (	71	,	4.507236627	,	-1.022721541	),
  (	71	,	4.511166552	,	-0.991360746	),
  (	71	,	4.700259059	,	-0.966588225	),
  (	71	,	4.558797797	,	-0.952298007	),
  (	71	,	4.462527036	,	-0.952280538	),
  (	71	,	4.51928974	,	-0.891571956	),
  (	71	,	4.416336128	,	-1.004967679	),
  (	71	,	4.34296163	,	-0.93632215	),
  (	71	,	4.350850503	,	-0.914236378	),
  (	71	,	4.284385035	,	-0.969563475	),
  (	71	,	4.32083569	,	-0.915265832	),
  (	71	,	4.28309862	,	-0.903236068	),
  (	71	,	4.670854972	,	-0.84274509	),
  (	71	,	4.651070761	,	-0.854065263	),
  (	71	,	4.509659998	,	-0.825882581	),
  (	71	,	4.568659842	,	-0.82268886	),
  (	71	,	4.567282924	,	-0.799781727	),
  (	71	,	4.595602901	,	-0.794322851	),
  (	71	,	4.644797572	,	-0.766289122	),
  (	71	,	4.600589488	,	-0.707404565	),
  (	71	,	4.653538037	,	-0.685301014	),
  (	71	,	4.482692923	,	-0.775670208	),
  (	71	,	4.418000357	,	-0.750351332	),
  (	71	,	4.485902037	,	-0.726319523	),
  (	71	,	4.419127945	,	-0.729300587	),
  (	71	,	4.347953087	,	-0.703423146	),
  (	71	,	4.555946251	,	-0.607368987	),
  (	71	,	4.166698315	,	-0.93347061	),
  (	71	,	4.146423149	,	-0.855927492	),
  (	71	,	4.222534792	,	-0.812025475	),
  (	71	,	4.062171342	,	-0.836369814	),
  (	71	,	4.137828994	,	-0.774085173	),
  (	71	,	4.277120795	,	-0.691672184	),
  (	71	,	4.276951606	,	-0.689417965	),
  (	71	,	4.17170432	,	-0.710434568	),
  (	71	,	4.233190294	,	-0.700381015	),
  (	71	,	4.036539854	,	-0.666180646	),
  (	71	,	3.999159411	,	-0.690469692	),
  (	71	,	3.988793133	,	-0.671813766	),
  (	71	,	4.133668132	,	-0.716060157	),
  (	71	,	4.041687843	,	-0.638766743	),
  (	71	,	4.298212054	,	-0.548420497	),
  (	71	,	4.405005522	,	-0.552421977	),
  (	71	,	4.420558121	,	-0.531097047	),
  (	71	,	4.212335217	,	-0.54903071	),
  (	71	,	4.126704308	,	-0.524325677	),
  (	71	,	4.20305324	,	-0.466323323	),
  (	71	,	4.385767876	,	-0.404641072	),
  (	71	,	4.281814115	,	-0.413785336	),
  (	71	,	4.279205089	,	-0.381192601	),
  (	71	,	3.253989845	,	-1.117403583	),
  (	71	,	3.214146692	,	-1.103010766	),
  (	71	,	3.244687396	,	-1.075631245	),
  (	71	,	3.405683576	,	-1.053749157	),
  (	71	,	3.351206428	,	-1.040099103	),
  (	71	,	3.182575151	,	-1.043170343	),
  (	71	,	3.387286105	,	-0.969723875	),
  (	71	,	3.483240608	,	-1.00007958	),
  (	71	,	3.454008483	,	-0.993248949	),
  (	71	,	3.473686824	,	-0.995912752	),
  (	71	,	3.4741381	,	-0.914813945	),
  (	71	,	3.260600207	,	-0.972758731	),
  (	71	,	3.307918459	,	-0.976185625	),
  (	71	,	3.32769854	,	-0.951875283	),
  (	71	,	3.373716679	,	-0.928961675	),
  (	71	,	3.463894271	,	-0.788654518	),
  (	71	,	3.647172275	,	-0.884202275	),
  (	71	,	3.750319717	,	-0.804600154	),
  (	71	,	3.630495032	,	-0.8354172	),
  (	71	,	3.831987909	,	-0.80062156	),
  (	71	,	3.764952825	,	-0.691571281	),
  (	71	,	3.781376645	,	-0.689810334	),
  (	71	,	3.584957339	,	-0.794021124	),
  (	71	,	3.683532764	,	-0.72977568	),
  (	71	,	3.596017218	,	-0.758193634	),
  (	71	,	3.586754719	,	-0.753058277	),
  (	71	,	3.670177639	,	-0.653979865	),
  (	71	,	3.693552365	,	-0.609098065	),
  (	71	,	3.183525816	,	-0.91008501	),
  (	71	,	3.357022766	,	-0.711658972	),
  (	71	,	3.467435312	,	-0.674596135	),
  (	71	,	3.202852312	,	-0.798038415	),
  (	71	,	3.373816277	,	-0.687489561	),
  (	71	,	3.58262169	,	-0.601533169	),
  (	71	,	3.516694786	,	-0.612189599	),
  (	71	,	3.518756715	,	-0.593609168	),
  (	71	,	3.640452192	,	-0.566284867	),
  (	71	,	3.624476433	,	-0.544659541	),
  (	71	,	3.647334218	,	-0.533691347	),
  (	71	,	3.578553606	,	-0.48132473	),
  (	71	,	3.650014145	,	-0.482376268	),
  (	71	,	3.413958599	,	-0.510779923	),
  (	71	,	3.546932222	,	-0.46404305	),
  (	71	,	3.877012902	,	-0.625552572	),
  (	71	,	3.902646902	,	-0.595907807	),
  (	71	,	3.924750999	,	-0.536021602	),
  (	71	,	3.882589708	,	-0.565967043	),
  (	71	,	3.776299717	,	-0.504332304	),
  (	71	,	3.838343723	,	-0.466421293	),
  (	71	,	3.841547731	,	-0.458249094	),
  (	71	,	3.900311174	,	-0.418428403	),
  (	71	,	3.858462163	,	-0.421122598	),
  (	71	,	4.071629423	,	-0.427418606	),
  (	71	,	4.067720613	,	-0.416787922	),
  (	71	,	4.233868977	,	-0.386715843	),
  (	71	,	4.274246449	,	-0.328610889	),
  (	71	,	3.981269648	,	-0.315729516	),
  (	71	,	4.094904917	,	-0.253377194	),
  (	71	,	3.793989132	,	-0.454018466	),
  (	71	,	3.805396088	,	-0.409221094	),
  (	71	,	3.851720461	,	-0.337051106	),
  (	71	,	3.776281485	,	-0.348471321	),
  (	71	,	3.633100865	,	-0.326533321	),
  (	71	,	3.658636229	,	-0.246476627	),
  (	71	,	4.049869087	,	-0.163182242	),
  (	71	,	3.848616831	,	-0.213539423	),
  (	71	,	5.538795198	,	-1.431652393	),
  (	71	,	6.256376844	,	-1.448740584	),
  (	71	,	5.889826935	,	-1.365079282	),
  (	71	,	4.837110886	,	-1.350303614	),
  (	71	,	5.188748728	,	-1.342312422	),
  (	71	,	5.449551706	,	-1.200641358	),
  (	71	,	5.488114328	,	-1.19423971	),
  (	71	,	6.083139335	,	-1.222736051	),
  (	71	,	5.800651105	,	-1.237510816	),
  (	71	,	5.826288765	,	-1.233133973	),
  (	71	,	5.932007481	,	-1.187881336	),
  (	71	,	6.029759205	,	-1.101047071	),
  (	71	,	5.70126161	,	-1.179780997	),
  (	71	,	5.81945757	,	-1.189029599	),
  (	71	,	5.792230888	,	-1.187240468	),
  (	71	,	5.838277654	,	-1.096265487	),
  (	71	,	5.885808046	,	-1.048140866	),
  (	71	,	4.772231902	,	-1.318611565	),
  (	71	,	5.097160662	,	-1.275680687	),
  (	71	,	4.859827648	,	-1.252597498	),
  (	71	,	5.368158409	,	-1.205490953	),
  (	71	,	5.330245886	,	-1.174828869	),
  (	71	,	5.280363002	,	-1.110436235	),
  (	71	,	5.29894989	,	-1.086977976	),
  (	71	,	5.04823132	,	-1.172284783	),
  (	71	,	4.861796569	,	-1.156792735	),
  (	71	,	4.72794069	,	-1.161317276	),
  (	71	,	5.192601269	,	-1.034354171	),
  (	71	,	5.496413703	,	-1.097415293	),
  (	71	,	5.40773176	,	-1.07400026	),
  (	71	,	5.691092236	,	-0.968190799	),
  (	71	,	5.724234113	,	-0.953866956	),
  (	71	,	5.467866013	,	-0.902618445	),
  (	71	,	5.563386914	,	-0.856914935	),
  (	71	,	5.556653408	,	-0.829916142	),
  (	71	,	5.560078807	,	-0.799069843	),
  (	71	,	5.442785776	,	-0.800312896	),
  (	71	,	5.507814768	,	-0.750459894	),
  (	71	,	6.23919354	,	-1.145656226	),
  (	71	,	6.139892322	,	-1.094969268	),
  (	71	,	6.276029964	,	-1.099603039	),
  (	71	,	6.266366099	,	-1.097329324	),
  (	71	,	6.025837432	,	-1.019927579	),
  (	71	,	6.00990015	,	-0.992657904	),
  (	71	,	5.900046373	,	-0.755081945	),
  (	71	,	6.231320782	,	-0.888218708	),
  (	71	,	6.24399169	,	-0.849268502	),
  (	71	,	6.227906737	,	-0.842593712	),
  (	71	,	6.191255759	,	-0.796079726	),
  (	71	,	6.108635667	,	-0.82973128	),
  (	71	,	6.212946317	,	-0.793479233	),
  (	71	,	5.991981313	,	-0.787977341	),
  (	71	,	6.03757524	,	-0.712391828	),
  (	71	,	5.965329616	,	-0.727659302	),
  (	71	,	6.106172033	,	-0.683447943	),
  (	71	,	5.726241899	,	-0.722789557	),
  (	71	,	5.649050567	,	-0.639611654	),
  (	71	,	5.679557126	,	-0.56778066	),
  (	71	,	5.909903843	,	-0.605198312	),
  (	71	,	5.834495849	,	-0.60669486	),
  (	71	,	5.971073568	,	-0.481102304	),
  (	71	,	5.843932043	,	-0.492332775	),
  (	71	,	5.809558814	,	-0.473902508	),
  (	71	,	4.975041889	,	-1.050754128	),
  (	71	,	4.864651285	,	-0.914342207	),
  (	71	,	5.039698579	,	-0.854558756	),
  (	71	,	5.111067741	,	-0.807616817	),
  (	71	,	4.988049067	,	-0.821216009	),
  (	71	,	5.004601579	,	-0.80233613	),
  (	71	,	5.065852305	,	-0.791926201	),
  (	71	,	5.082972423	,	-0.771345751	),
  (	71	,	5.242186827	,	-0.827240621	),
  (	71	,	5.282472485	,	-0.81568751	),
  (	71	,	5.315682955	,	-0.74805653	),
  (	71	,	5.218915958	,	-0.768158824	),
  (	71	,	5.168192695	,	-0.726217194	),
  (	71	,	5.309481129	,	-0.713941841	),
  (	71	,	5.336373608	,	-0.617454218	),
  (	71	,	5.253647871	,	-0.661116497	),
  (	71	,	5.25170001	,	-0.655008217	),
  (	71	,	5.251380439	,	-0.638730064	),
  (	71	,	4.725727367	,	-0.901455713	),
  (	71	,	4.948123312	,	-0.825098188	),
  (	71	,	4.98304188	,	-0.709699991	),
  (	71	,	4.732582865	,	-0.709260914	),
  (	71	,	4.923135579	,	-0.691208968	),
  (	71	,	4.960846186	,	-0.581710247	),
  (	71	,	4.84849382	,	-0.642441631	),
  (	71	,	4.831886509	,	-0.628597997	),
  (	71	,	4.861114583	,	-0.575281021	),
  (	71	,	5.058653116	,	-0.64393548	),
  (	71	,	5.140032675	,	-0.574440032	),
  (	71	,	5.182773776	,	-0.497265133	),
  (	71	,	5.037925906	,	-0.520653385	),
  (	71	,	4.946625886	,	-0.558367646	),
  (	71	,	4.999415991	,	-0.507562189	),
  (	71	,	5.016639519	,	-0.473239046	),
  (	71	,	5.064442911	,	-0.42256771	),
  (	71	,	5.466015626	,	-0.68257476	),
  (	71	,	5.538379712	,	-0.662056733	),
  (	71	,	5.525711949	,	-0.604387448	),
  (	71	,	5.573829744	,	-0.536614146	),
  (	71	,	5.584431223	,	-0.474889362	),
  (	71	,	5.424768176	,	-0.513568491	),
  (	71	,	5.383574149	,	-0.511252809	),
  (	71	,	5.438692777	,	-0.468949492	),
  (	71	,	5.502392564	,	-0.518867928	),
  (	71	,	5.715513836	,	-0.478290159	),
  (	71	,	5.791231077	,	-0.388170785	),
  (	71	,	5.77022269	,	-0.296092041	),
  (	71	,	5.6591323	,	-0.32714634	),
  (	71	,	5.581778956	,	-0.282390383	),
  (	71	,	5.627245342	,	-0.244824599	),
  (	71	,	5.701565303	,	-0.204181802	),
  (	71	,	5.361375026	,	-0.418603999	),
  (	71	,	5.469584859	,	-0.333597402	),
  (	71	,	5.362550942	,	-0.364800264	),
  (	71	,	5.345395392	,	-0.33918218	),
  (	71	,	5.400990154	,	-0.298845343	),
  (	71	,	5.179924111	,	-0.298070046	),
  (	71	,	5.327701093	,	-0.19168406	),
  (	71	,	5.446361569	,	-0.288358562	),
  (	71	,	5.433436053	,	-0.27573079	),
  (	71	,	5.465143222	,	-0.230434675	),
  (	71	,	5.506499409	,	-0.204142328	),
  (	71	,	5.618400788	,	-0.203634229	),
  (	71	,	5.530238285	,	-0.143727416	),
  (	71	,	5.59368407	,	-0.162809308	),
  (	71	,	5.39426597	,	-0.216091888	),
  (	71	,	5.360099006	,	-0.163543191	),
  (	72	,	0.747608533	,	0.037919733	),
  (	72	,	0.702248583	,	0.085010113	),
  (	72	,	0.918216257	,	0.182537524	),
  (	72	,	0.832610355	,	0.174637366	),
  (	72	,	0.703064664	,	0.105982142	),
  (	72	,	0.63054466	,	0.169519944	),
  (	72	,	0.847098136	,	0.272102493	),
  (	72	,	0.774401194	,	0.28437426	),
  (	72	,	0.92920531	,	0.289685594	),
  (	72	,	0.971330144	,	0.301831125	),
  (	72	,	1.094842693	,	0.278320358	),
  (	72	,	1.121463564	,	0.343393998	),
  (	72	,	1.141376126	,	0.369811315	),
  (	72	,	1.11050845	,	0.391855321	),
  (	72	,	1.085874769	,	0.416628675	),
  (	72	,	0.907673211	,	0.357168405	),
  (	72	,	0.874361239	,	0.346844635	),
  (	72	,	0.961494792	,	0.373601094	),
  (	72	,	0.984498552	,	0.424732146	),
  (	72	,	1.03999322	,	0.420289468	),
  (	72	,	0.931114812	,	0.407849099	),
  (	72	,	0.935689016	,	0.426981007	),
  (	72	,	0.935687957	,	0.426985916	),
  (	72	,	0.762846675	,	0.355576426	),
  (	72	,	0.68489657	,	0.430188449	),
  (	72	,	0.636469114	,	0.439118211	),
  (	72	,	0.641262477	,	0.45449427	),
  (	72	,	0.583333536	,	0.446728983	),
  (	72	,	0.599626196	,	0.501686607	),
  (	72	,	0.800587046	,	0.402500011	),
  (	72	,	0.893683557	,	0.500074192	),
  (	72	,	0.842891751	,	0.542254692	),
  (	72	,	0.73624905	,	0.543042116	),
  (	72	,	0.708203427	,	0.598558729	),
  (	72	,	0.826711594	,	0.651028638	),
  (	72	,	0.716421693	,	0.612869744	),
  (	72	,	0.751315294	,	0.647412456	),
  (	72	,	0.730690874	,	0.659575183	),
  (	72	,	0.804877254	,	0.703239464	),
  (	72	,	0.790584947	,	0.712031723	),
  (	72	,	1.17941595	,	0.346279411	),
  (	72	,	1.187398698	,	0.377555445	),
  (	72	,	1.150766527	,	0.400809682	),
  (	72	,	1.231343724	,	0.400417895	),
  (	72	,	1.281108744	,	0.44272376	),
  (	72	,	1.290514896	,	0.533215983	),
  (	72	,	1.214111859	,	0.558483199	),
  (	72	,	1.371132812	,	0.530578069	),
  (	72	,	1.396318097	,	0.572211986	),
  (	72	,	1.458587167	,	0.717738539	),
  (	72	,	1.404776544	,	0.738029353	),
  (	72	,	1.458046598	,	0.766849744	),
  (	72	,	1.493700893	,	0.751530953	),
  (	72	,	1.483738204	,	0.756147736	),
  (	72	,	1.252429865	,	0.720907363	),
  (	72	,	1.375587313	,	0.823271757	),
  (	72	,	1.389913508	,	0.853872502	),
  (	72	,	0.932236459	,	0.663457663	),
  (	72	,	1.14320464	,	0.696964988	),
  (	72	,	1.153926684	,	0.728322748	),
  (	72	,	1.096165631	,	0.728621542	),
  (	72	,	1.122811842	,	0.806650368	),
  (	72	,	0.895901291	,	0.714768756	),
  (	72	,	1.106912463	,	0.856849819	),
  (	72	,	1.001628821	,	0.837448991	),
  (	72	,	1.181941003	,	0.778462505	),
  (	72	,	1.213435944	,	0.806927055	),
  (	72	,	1.439394728	,	0.932581334	),
  (	72	,	1.560656869	,	0.9713931	),
  (	72	,	1.558275128	,	0.976450694	),
  (	72	,	1.34290447	,	0.973179155	),
  (	72	,	0.42503875	,	0.439235256	),
  (	72	,	0.51514008	,	0.543392018	),
  (	72	,	0.257661318	,	0.482709251	),
  (	72	,	0.241822821	,	0.498450306	),
  (	72	,	0.409749874	,	0.621479725	),
  (	72	,	0.432530247	,	0.637799427	),
  (	72	,	0.455471513	,	0.657435474	),
  (	72	,	0.323003119	,	0.602010056	),
  (	72	,	0.398976956	,	0.676613398	),
  (	72	,	0.662175964	,	0.69747639	),
  (	72	,	0.615423251	,	0.749511434	),
  (	72	,	0.445340688	,	0.761661249	),
  (	72	,	0.617819146	,	0.778415206	),
  (	72	,	0.484518362	,	0.82762554	),
  (	72	,	0.515108669	,	0.866424979	),
  (	72	,	0.264085726	,	0.659586398	),
  (	72	,	0.295742526	,	0.724541729	),
  (	72	,	0.224723259	,	0.719631741	),
  (	72	,	0.039557367	,	0.712821624	),
  (	72	,	0.027661984	,	0.713819301	),
  (	72	,	0.041277729	,	0.8096194	),
  (	72	,	0.115032229	,	0.856065629	),
  (	72	,	0.05685346	,	0.871382761	),
  (	72	,	0.044831847	,	0.912023969	),
  (	72	,	0.304835289	,	0.856149372	),
  (	72	,	0.339469231	,	0.855357369	),
  (	72	,	0.388392832	,	0.902095427	),
  (	72	,	0.407704547	,	0.958968903	),
  (	72	,	0.309700819	,	0.990899519	),
  (	72	,	0.209367526	,	0.897878922	),
  (	72	,	0.141805672	,	0.902828024	),
  (	72	,	0.140451519	,	0.939250297	),
  (	72	,	0.143098435	,	0.944566972	),
  (	72	,	0.024706845	,	0.972320832	),
  (	72	,	0.051249448	,	0.999576552	),
  (	72	,	0.249768488	,	0.959099213	),
  (	72	,	0.237817924	,	0.982960048	),
  (	72	,	0.231667662	,	0.998661042	),
  (	72	,	0.264181585	,	1.018645479	),
  (	72	,	0.141212572	,	1.018197001	),
  (	72	,	0.084274195	,	1.032170803	),
  (	72	,	0.060811822	,	1.047184646	),
  (	72	,	0.00301628	,	1.085168893	),
  (	72	,	0.129177948	,	1.083223087	),
  (	72	,	0.080631133	,	1.085641551	),
  (	72	,	0.040525388	,	1.135705801	),
  (	72	,	0.766343638	,	0.843694033	),
  (	72	,	0.899169761	,	0.868224355	),
  (	72	,	0.858786246	,	0.89392312	),
  (	72	,	1.001150349	,	0.996967146	),
  (	72	,	0.749585283	,	0.925578662	),
  (	72	,	0.591131282	,	0.91648905	),
  (	72	,	0.662743334	,	1.007013691	),
  (	72	,	0.623986021	,	1.001592071	),
  (	72	,	0.580095453	,	0.998380587	),
  (	72	,	0.639516386	,	1.041241167	),
  (	72	,	0.784578095	,	1.006413274	),
  (	72	,	0.846872462	,	1.039578553	),
  (	72	,	0.705475403	,	1.029349484	),
  (	72	,	0.671852783	,	1.033443993	),
  (	72	,	1.088237989	,	1.022065101	),
  (	72	,	1.20578652	,	1.07097484	),
  (	72	,	1.012299571	,	1.053073667	),
  (	72	,	1.299365603	,	1.182912955	),
  (	72	,	1.370657398	,	1.177771139	),
  (	72	,	1.425863918	,	1.225709638	),
  (	72	,	1.537147801	,	1.244236077	),
  (	72	,	0.931312474	,	1.144096628	),
  (	72	,	1.318159769	,	1.207062818	),
  (	72	,	0.424905881	,	1.023415372	),
  (	72	,	0.394033685	,	1.043394641	),
  (	72	,	0.392072263	,	1.051582532	),
  (	72	,	0.447739701	,	1.056761223	),
  (	72	,	0.545521201	,	1.123740369	),
  (	72	,	0.445745808	,	1.165745414	),
  (	72	,	0.511315191	,	1.251835007	),
  (	72	,	0.248378629	,	1.126300812	),
  (	72	,	0.210296461	,	1.136550234	),
  (	72	,	0.382350051	,	1.153260729	),
  (	72	,	0.236081369	,	1.159519859	),
  (	72	,	0.003838596	,	1.16672001	),
  (	72	,	0.093249368	,	1.169465058	),
  (	72	,	0.155419564	,	1.185531673	),
  (	72	,	0.343423683	,	1.271957175	),
  (	72	,	0.987117921	,	1.249973251	),
  (	72	,	0.901804412	,	1.2602264	),
  (	72	,	0.727215792	,	1.316115466	),
  (	72	,	1.134668903	,	1.362744818	),
  (	72	,	1.061092246	,	1.364893757	),
  (	72	,	1.100581989	,	1.37933455	),
  (	72	,	1.17639999	,	1.412527095	),
  (	72	,	0.578079326	,	1.390912968	),
  (	72	,	0.606462107	,	1.496388785	),
  (	72	,	2.364832069	,	0.046621242	),
  (	72	,	2.306223131	,	0.044740914	),
  (	72	,	2.395601168	,	0.131128164	),
  (	72	,	2.406143748	,	0.156657434	),
  (	72	,	2.212204704	,	0.1260321	),
  (	72	,	2.306529379	,	0.182091457	),
  (	72	,	2.183779712	,	0.164060359	),
  (	72	,	2.32933798	,	0.306218507	),
  (	72	,	2.554628873	,	0.1784053	),
  (	72	,	2.546388189	,	0.18357378	),
  (	72	,	2.492926589	,	0.224426096	),
  (	72	,	2.65788408	,	0.323411885	),
  (	72	,	2.513429999	,	0.349862226	),
  (	72	,	2.433685975	,	0.402800333	),
  (	72	,	2.596612045	,	0.429985221	),
  (	72	,	2.498983078	,	0.471008811	),
  (	72	,	2.516832843	,	0.484475522	),
  (	72	,	2.150254943	,	0.19520952	),
  (	72	,	2.159811286	,	0.2806253	),
  (	72	,	2.202417833	,	0.299862889	),
  (	72	,	2.045938804	,	0.317475547	),
  (	72	,	2.018978724	,	0.387879553	),
  (	72	,	2.0931277	,	0.404615566	),
  (	72	,	2.108828175	,	0.458455612	),
  (	72	,	2.176912219	,	0.459636793	),
  (	72	,	2.173411451	,	0.46119463	),
  (	72	,	2.132907579	,	0.479620882	),
  (	72	,	2.419305222	,	0.436525701	),
  (	72	,	2.389483356	,	0.544548906	),
  (	72	,	2.370368929	,	0.573888915	),
  (	72	,	2.371241064	,	0.660429859	),
  (	72	,	2.346473461	,	0.667731611	),
  (	72	,	2.758873636	,	0.426597575	),
  (	72	,	2.623690155	,	0.502383575	),
  (	72	,	2.718729844	,	0.61466197	),
  (	72	,	2.933791181	,	0.607099573	),
  (	72	,	2.905114679	,	0.670105795	),
  (	72	,	2.960434408	,	0.738555957	),
  (	72	,	2.898564338	,	0.678378643	),
  (	72	,	2.816039484	,	0.720950116	),
  (	72	,	2.771339601	,	0.731446882	),
  (	72	,	2.87546191	,	0.788846574	),
  (	72	,	2.885665347	,	0.812689408	),
  (	72	,	2.541973539	,	0.575871022	),
  (	72	,	2.585276638	,	0.620021832	),
  (	72	,	2.449674524	,	0.703085612	),
  (	72	,	2.904953039	,	0.875672129	),
  (	72	,	2.920280005	,	0.896732052	),
  (	72	,	3.013804423	,	0.990412514	),
  (	72	,	2.73308964	,	0.949589545	),
  (	72	,	2.818699735	,	0.993457759	),
  (	72	,	3.05911302	,	1.061898247	),
  (	72	,	2.962941146	,	1.085295476	),
  (	72	,	3.055651987	,	1.089021067	),
  (	72	,	1.965204042	,	0.345802833	),
  (	72	,	1.99695861	,	0.389902631	),
  (	72	,	2.047752921	,	0.427406481	),
  (	72	,	1.917735509	,	0.468148108	),
  (	72	,	1.966367109	,	0.487094246	),
  (	72	,	2.057057845	,	0.509077989	),
  (	72	,	2.096708047	,	0.509710569	),
  (	72	,	2.083672236	,	0.569965396	),
  (	72	,	1.921523438	,	0.490824509	),
  (	72	,	1.923467996	,	0.518959194	),
  (	72	,	1.95212971	,	0.68617117	),
  (	72	,	1.9149553	,	0.674981963	),
  (	72	,	2.13587796	,	0.562363973	),
  (	72	,	2.172227792	,	0.62357751	),
  (	72	,	2.185139208	,	0.624455469	),
  (	72	,	2.120721768	,	0.633067526	),
  (	72	,	2.110387936	,	0.634336252	),
  (	72	,	2.12846466	,	0.673357466	),
  (	72	,	2.193218242	,	0.705873122	),
  (	72	,	2.217081085	,	0.807189777	),
  (	72	,	2.060102521	,	0.631267439	),
  (	72	,	2.060629421	,	0.633027554	),
  (	72	,	2.032018868	,	0.690222641	),
  (	72	,	2.088204218	,	0.759285665	),
  (	72	,	1.740423617	,	0.576271528	),
  (	72	,	1.696075775	,	0.608501254	),
  (	72	,	1.849928187	,	0.708294957	),
  (	72	,	1.841411756	,	0.77577981	),
  (	72	,	1.739565718	,	0.725733816	),
  (	72	,	1.676782033	,	0.754507013	),
  (	72	,	1.678905309	,	0.760061561	),
  (	72	,	1.630656993	,	0.727753398	),
  (	72	,	1.620952883	,	0.753377539	),
  (	72	,	1.591042422	,	0.813063282	),
  (	72	,	2.034328072	,	0.890566873	),
  (	72	,	1.696647774	,	0.915406634	),
  (	72	,	1.654415352	,	0.986571356	),
  (	72	,	1.764577907	,	0.99366641	),
  (	72	,	1.682667669	,	1.019702698	),
  (	72	,	2.343656242	,	0.775089882	),
  (	72	,	2.464288282	,	0.877520818	),
  (	72	,	2.34288673	,	0.99289888	),
  (	72	,	2.96171277	,	1.163858242	),
  (	72	,	3.132863273	,	1.183541148	),
  (	72	,	2.825736383	,	1.14522166	),
  (	72	,	2.56346287	,	1.103865787	),
  (	72	,	2.569037766	,	1.132623758	),
  (	72	,	2.557111357	,	1.145406901	),
  (	72	,	2.916277255	,	1.255918891	),
  (	72	,	2.701736766	,	1.264259504	),
  (	72	,	2.11694928	,	1.008317732	),
  (	72	,	2.04182305	,	1.052358437	),
  (	72	,	2.162898473	,	1.15497191	),
  (	72	,	2.000499998	,	1.156018511	),
  (	72	,	2.199130019	,	1.202963847	),
  (	72	,	2.038023609	,	1.206966363	),
  (	72	,	2.039875587	,	1.225326064	),
  (	72	,	1.876861229	,	1.084473702	),
  (	72	,	1.638884518	,	1.154509628	),
  (	72	,	1.851140261	,	1.316174448	),
  (	72	,	2.384011653	,	1.194595293	),
  (	72	,	2.373518879	,	1.244511961	),
  (	72	,	2.528497463	,	1.269675381	),
  (	72	,	2.842161798	,	1.326354632	),
  (	72	,	2.203006982	,	1.343292879	),
  (	72	,	2.315951439	,	1.364237527	),
  (	72	,	2.451317747	,	1.545845339	),
  (	72	,	3.94170635	,	0.015524534	),
  (	72	,	3.910756379	,	0.059618032	),
  (	72	,	3.968303536	,	0.06746853	),
  (	72	,	3.944911859	,	0.095864285	),
  (	72	,	3.87850276	,	0.103914009	),
  (	72	,	4.033152409	,	0.1480297	),
  (	72	,	4.092755917	,	0.178676093	),
  (	72	,	3.995016702	,	0.176737948	),
  (	72	,	3.972916221	,	0.203745477	),
  (	72	,	3.88205763	,	0.13939476	),
  (	72	,	3.864176972	,	0.142407846	),
  (	72	,	3.863106164	,	0.184988027	),
  (	72	,	3.904442807	,	0.267478571	),
  (	72	,	3.938093063	,	0.280223464	),
  (	72	,	4.116235336	,	0.204393969	),
  (	72	,	4.090139315	,	0.21470791	),
  (	72	,	4.054111415	,	0.227463461	),
  (	72	,	3.977483246	,	0.349820735	),
  (	72	,	3.808421372	,	0.245404375	),
  (	72	,	3.711976862	,	0.266873415	),
  (	72	,	3.898716213	,	0.347111514	),
  (	72	,	3.757502743	,	0.334758394	),
  (	72	,	3.921789207	,	0.421843494	),
  (	72	,	3.882130226	,	0.401989252	),
  (	72	,	3.916917382	,	0.430646504	),
  (	72	,	4.007007308	,	0.46846129	),
  (	72	,	3.902108042	,	0.558803527	),
  (	72	,	3.973453103	,	0.577335334	),
  (	72	,	4.281198042	,	0.388156874	),
  (	72	,	4.381543443	,	0.410459412	),
  (	72	,	4.414690782	,	0.443315996	),
  (	72	,	4.347760306	,	0.539977814	),
  (	72	,	4.370204706	,	0.538884401	),
  (	72	,	4.347481142	,	0.590301798	),
  (	72	,	4.321848797	,	0.589067957	),
  (	72	,	4.402899512	,	0.61010551	),
  (	72	,	4.257927119	,	0.63799511	),
  (	72	,	4.509293387	,	0.680415572	),
  (	72	,	4.601952554	,	0.714004275	),
  (	72	,	4.646609349	,	0.873436384	),
  (	72	,	4.166741484	,	0.599740044	),
  (	72	,	4.1037191	,	0.646067606	),
  (	72	,	4.103413666	,	0.654795078	),
  (	72	,	4.246450206	,	0.664492079	),
  (	72	,	4.223651792	,	0.792037063	),
  (	72	,	3.992186317	,	0.668485764	),
  (	72	,	4.103078265	,	0.765271219	),
  (	72	,	4.080574132	,	0.872561578	),
  (	72	,	4.4069088	,	0.814184495	),
  (	72	,	4.4998725	,	0.903284447	),
  (	72	,	4.499198194	,	0.988881199	),
  (	72	,	3.569247072	,	0.393164616	),
  (	72	,	3.596144657	,	0.481456534	),
  (	72	,	3.63632232	,	0.589690145	),
  (	72	,	3.526929114	,	0.543656677	),
  (	72	,	3.727105946	,	0.621399982	),
  (	72	,	3.827271446	,	0.62709202	),
  (	72	,	3.61076386	,	0.661362511	),
  (	72	,	3.747554482	,	0.848090655	),
  (	72	,	3.334224899	,	0.624284296	),
  (	72	,	3.447113389	,	0.675856933	),
  (	72	,	3.205367163	,	0.686649898	),
  (	72	,	3.250435882	,	0.747958509	),
  (	72	,	3.336030199	,	0.752700937	),
  (	72	,	3.495559997	,	0.825012003	),
  (	72	,	3.530039363	,	0.835090921	),
  (	72	,	3.562916375	,	0.919566761	),
  (	72	,	3.588895229	,	0.972632783	),
  (	72	,	3.445058041	,	0.991935684	),
  (	72	,	3.334560903	,	0.90334733	),
  (	72	,	3.894353954	,	0.972937429	),
  (	72	,	3.742723415	,	0.905100592	),
  (	72	,	3.775443216	,	0.935224802	),
  (	72	,	3.739605354	,	0.951945875	),
  (	72	,	3.735612562	,	0.989823867	),
  (	72	,	3.928734694	,	0.97072194	),
  (	72	,	3.9211227	,	1.0762915	),
  (	72	,	4.355299794	,	1.067658234	),
  (	72	,	4.368141248	,	1.087478758	),
  (	72	,	4.427667092	,	1.083841795	),
  (	72	,	4.541977178	,	1.161745424	),
  (	72	,	4.145739886	,	1.130968926	),
  (	72	,	4.077981776	,	1.183411174	),
  (	72	,	4.434534449	,	1.296466002	),
  (	72	,	3.594802394	,	1.049737287	),
  (	72	,	3.533762202	,	1.120160385	),
  (	72	,	3.884941476	,	1.145736484	),
  (	72	,	3.46008036	,	1.174776764	),
  (	72	,	3.167864688	,	1.19901572	),
  (	72	,	3.276369084	,	1.244416905	),
  (	72	,	3.378258425	,	1.316140364	),
  (	72	,	3.96671121	,	1.215675596	),
  (	72	,	4.091761553	,	1.241867618	),
  (	72	,	3.905178846	,	1.306923943	),
  (	72	,	4.325396816	,	1.392583793	),
  (	72	,	3.304349114	,	1.382570575	),
  (	72	,	4.057457163	,	1.409722095	),
  (	72	,	3.885477277	,	1.409354324	),
  (	72	,	4.27547632	,	1.460795382	),
  (	72	,	3.890656365	,	1.464985625	),
  (	72	,	5.446140596	,	0.047390948	),
  (	72	,	5.489044286	,	0.140714235	),
  (	72	,	5.556617853	,	0.125094185	),
  (	72	,	5.573808387	,	0.143710504	),
  (	72	,	5.638272594	,	0.190430136	),
  (	72	,	5.551039203	,	0.20562439	),
  (	72	,	5.578867339	,	0.201908173	),
  (	72	,	5.399888913	,	0.113461781	),
  (	72	,	5.452641377	,	0.243708257	),
  (	72	,	5.484796565	,	0.298407579	),
  (	72	,	5.674753797	,	0.185217282	),
  (	72	,	5.566297513	,	0.29194162	),
  (	72	,	5.710640607	,	0.391437025	),
  (	72	,	5.685021175	,	0.407039514	),
  (	72	,	5.758827557	,	0.417844312	),
  (	72	,	5.691846198	,	0.509531913	),
  (	72	,	5.337751079	,	0.268117276	),
  (	72	,	5.239761716	,	0.233519748	),
  (	72	,	5.240942645	,	0.25347681	),
  (	72	,	5.287597803	,	0.277080349	),
  (	72	,	5.295239845	,	0.283881204	),
  (	72	,	5.275848313	,	0.295075193	),
  (	72	,	5.375052853	,	0.296560135	),
  (	72	,	5.42797762	,	0.373512854	),
  (	72	,	5.236591261	,	0.307366124	),
  (	72	,	5.19663909	,	0.294221376	),
  (	72	,	5.276232219	,	0.332888949	),
  (	72	,	5.139707536	,	0.324498383	),
  (	72	,	5.196210349	,	0.349756627	),
  (	72	,	5.20709571	,	0.354953867	),
  (	72	,	5.221281403	,	0.416934179	),
  (	72	,	5.287668835	,	0.46942151	),
  (	72	,	5.308669276	,	0.497817473	),
  (	72	,	5.567385896	,	0.44389959	),
  (	72	,	5.58870189	,	0.566392636	),
  (	72	,	5.40763059	,	0.454952433	),
  (	72	,	5.408434207	,	0.465962639	),
  (	72	,	5.368725665	,	0.485773995	),
  (	72	,	5.397342251	,	0.56463848	),
  (	72	,	5.425332223	,	0.59112112	),
  (	72	,	5.382187618	,	0.574347131	),
  (	72	,	5.510518814	,	0.564611636	),
  (	72	,	5.475804654	,	0.589292193	),
  (	72	,	5.555626178	,	0.588056097	),
  (	72	,	5.559270909	,	0.659412515	),
  (	72	,	5.463141106	,	0.604887905	),
  (	72	,	5.474662753	,	0.647057909	),
  (	72	,	5.477651747	,	0.703367992	),
  (	72	,	5.495484056	,	0.714890855	),
  (	72	,	5.921950452	,	0.409688418	),
  (	72	,	6.070169226	,	0.524353422	),
  (	72	,	5.984599813	,	0.57273871	),
  (	72	,	5.988947853	,	0.616756346	),
  (	72	,	5.787556916	,	0.438973165	),
  (	72	,	5.779422956	,	0.447823564	),
  (	72	,	5.777006272	,	0.494772434	),
  (	72	,	6.075572043	,	0.645210189	),
  (	72	,	6.252650004	,	0.721619234	),
  (	72	,	6.187446716	,	0.751849537	),
  (	72	,	5.990425721	,	0.673975029	),
  (	72	,	6.068645959	,	0.794304202	),
  (	72	,	6.261910441	,	0.833018959	),
  (	72	,	6.086923415	,	0.811999848	),
  (	72	,	6.17549932	,	0.878105744	),
  (	72	,	5.740331944	,	0.610463432	),
  (	72	,	5.769476124	,	0.64547012	),
  (	72	,	5.676959155	,	0.605195083	),
  (	72	,	5.619502428	,	0.618007118	),
  (	72	,	5.767074794	,	0.724993399	),
  (	72	,	5.771540685	,	0.747253949	),
  (	72	,	5.829470593	,	0.786953963	),
  (	72	,	5.552293483	,	0.673111766	),
  (	72	,	5.60073185	,	0.698457549	),
  (	72	,	5.640319828	,	0.738189484	),
  (	72	,	5.635734034	,	0.745268776	),
  (	72	,	5.599663614	,	0.776989998	),
  (	72	,	5.601792217	,	0.823176029	),
  (	72	,	5.819080326	,	0.863439457	),
  (	72	,	5.665684641	,	0.869089305	),
  (	72	,	5.682580814	,	0.887639805	),
  (	72	,	5.927851457	,	0.779621152	),
  (	72	,	5.913440815	,	0.788074692	),
  (	72	,	5.926221111	,	0.799824938	),
  (	72	,	5.968648682	,	0.907212742	),
  (	72	,	6.147354513	,	0.936663921	),
  (	72	,	6.278847931	,	0.973119361	),
  (	72	,	6.069887313	,	0.92604026	),
  (	72	,	6.280856092	,	1.006542408	),
  (	72	,	5.848505036	,	0.905145138	),
  (	72	,	5.958562469	,	0.923108116	),
  (	72	,	6.004717333	,	0.985246461	),
  (	72	,	5.785665144	,	0.935902732	),
  (	72	,	5.833847865	,	0.980463133	),
  (	72	,	6.107918973	,	0.999089542	),
  (	72	,	6.065711607	,	1.002659482	),
  (	72	,	6.188795803	,	1.023704565	),
  (	72	,	6.04366712	,	1.025074414	),
  (	72	,	6.008018216	,	1.046529428	),
  (	72	,	6.241325758	,	1.112535894	),
  (	72	,	5.091916274	,	0.368374774	),
  (	72	,	5.172308363	,	0.417881483	),
  (	72	,	5.206607256	,	0.490431444	),
  (	72	,	5.169718648	,	0.510764857	),
  (	72	,	5.162911161	,	0.527654096	),
  (	72	,	5.151706131	,	0.54814678	),
  (	72	,	5.214553802	,	0.535602128	),
  (	72	,	5.199726748	,	0.543517265	),
  (	72	,	5.236501121	,	0.572287544	),
  (	72	,	5.219099673	,	0.577260402	),
  (	72	,	4.959498025	,	0.492171313	),
  (	72	,	4.991322022	,	0.596050598	),
  (	72	,	5.007190958	,	0.60027296	),
  (	72	,	5.142857463	,	0.565595217	),
  (	72	,	5.132497802	,	0.584011452	),
  (	72	,	5.309304008	,	0.565133549	),
  (	72	,	5.299286415	,	0.651947358	),
  (	72	,	5.294345359	,	0.676583561	),
  (	72	,	5.278924572	,	0.683065443	),
  (	72	,	5.457038375	,	0.739704572	),
  (	72	,	5.360038019	,	0.686421532	),
  (	72	,	5.32215614	,	0.718002798	),
  (	72	,	5.346987173	,	0.731474108	),
  (	72	,	5.401729029	,	0.7478183	),
  (	72	,	5.399104036	,	0.750337903	),
  (	72	,	5.238386689	,	0.684297398	),
  (	72	,	5.243638105	,	0.770020901	),
  (	72	,	5.177930448	,	0.77402839	),
  (	72	,	5.174288563	,	0.811325557	),
  (	72	,	5.300389782	,	0.827995402	),
  (	72	,	4.90900932	,	0.611012758	),
  (	72	,	4.935010076	,	0.600287418	),
  (	72	,	4.922039594	,	0.647061686	),
  (	72	,	4.936870694	,	0.686274738	),
  (	72	,	5.049030257	,	0.681180951	),
  (	72	,	5.042804719	,	0.704407779	),
  (	72	,	4.973995285	,	0.754925025	),
  (	72	,	4.994046069	,	0.801486109	),
  (	72	,	4.937066891	,	0.787731913	),
  (	72	,	4.856998916	,	0.707423242	),
  (	72	,	4.845677258	,	0.715160073	),
  (	72	,	4.723353902	,	0.772019252	),
  (	72	,	4.853539878	,	0.798914586	),
  (	72	,	4.79224339	,	0.809952759	),
  (	72	,	5.079169593	,	0.784242721	),
  (	72	,	5.019821458	,	0.845514583	),
  (	72	,	5.027423185	,	1.006615337	),
  (	72	,	4.73856504	,	1.001116934	),
  (	72	,	4.960756257	,	0.990469186	),
  (	72	,	4.883967368	,	1.038959942	),
  (	72	,	5.501413048	,	0.812949475	),
  (	72	,	5.476630703	,	0.808957435	),
  (	72	,	5.530056835	,	0.825148631	),
  (	72	,	5.458304057	,	0.838294423	),
  (	72	,	5.460995734	,	0.866625337	),
  (	72	,	5.655836831	,	0.884516461	),
  (	72	,	5.57963183	,	0.873874703	),
  (	72	,	5.564027702	,	0.89503749	),
  (	72	,	5.628175815	,	0.923870285	),
  (	72	,	5.619949406	,	0.93007314	),
  (	72	,	5.666242262	,	0.935155271	),
  (	72	,	5.685128566	,	0.95228198	),
  (	72	,	5.561514746	,	0.992802772	),
  (	72	,	5.387305667	,	0.858306094	),
  (	72	,	5.347456208	,	0.954418585	),
  (	72	,	5.471548809	,	0.997900139	),
  (	72	,	5.582519354	,	1.01799344	),
  (	72	,	5.559227982	,	1.017477339	),
  (	72	,	5.62452869	,	1.072210711	),
  (	72	,	5.549285691	,	1.046959424	),
  (	72	,	5.441140214	,	1.019564406	),
  (	72	,	5.375940151	,	1.054559574	),
  (	72	,	5.825397414	,	1.031736939	),
  (	72	,	5.797117143	,	1.034797574	),
  (	72	,	5.863600113	,	1.021616944	),
  (	72	,	5.912297589	,	1.061618026	),
  (	72	,	5.780285191	,	1.070548933	),
  (	72	,	5.755178553	,	1.076207356	),
  (	72	,	6.066826441	,	1.126252621	),
  (	72	,	5.976025281	,	1.161583904	),
  (	72	,	5.759831434	,	1.14201705	),
  (	72	,	5.56226138	,	1.130106263	),
  (	72	,	5.648009033	,	1.164592532	),
  (	72	,	5.873984909	,	1.20503593	),
  (	72	,	5.902949047	,	1.292823459	),
  (	72	,	5.269840552	,	1.008796727	),
  (	72	,	5.231740196	,	1.008964894	),
  (	72	,	5.28828991	,	1.041824573	),
  (	72	,	5.21344728	,	1.05793054	),
  (	72	,	5.32918308	,	1.107094041	),
  (	72	,	5.213399175	,	1.129597257	),
  (	72	,	5.276748376	,	1.197284385	),
  (	72	,	4.989374479	,	1.083751255	),
  (	72	,	4.798243431	,	1.176966038	),
  (	72	,	4.774530956	,	1.236293034	),
  (	72	,	5.077023848	,	1.204530367	),
  (	72	,	5.005197649	,	1.257932778	),
  (	72	,	5.668731165	,	1.244564372	),
  (	72	,	5.814064668	,	1.334514977	),
  (	72	,	5.698012843	,	1.365419357	),
  (	72	,	5.976304832	,	1.402681805	),
  (	72	,	5.952054422	,	1.403894304	),
  (	72	,	5.858387155	,	1.430116984	),
  (	72	,	5.127652817	,	1.298133879	),
  (	72	,	5.402175503	,	1.340999292	),
  (	72	,	5.691533973	,	1.466753478	),
  (	72	,	5.5534711	,	1.470590548	),
  (	72	,	0.023280753	,	-0.678181459	),
  (	72	,	0.030053976	,	-0.678542337	),
  (	72	,	0.124101292	,	-0.511120746	),
  (	72	,	0.119416906	,	-0.492936686	),
  (	72	,	6.103916055	,	-0.533252229	),
  (	72	,	0.032211002	,	-0.442573381	),
  (	72	,	0.247923086	,	-0.442674016	),
  (	72	,	0.168423049	,	-0.411889156	),
  (	72	,	0.125865249	,	-0.429990767	),
  (	72	,	0.050570846	,	-0.324641712	),
  (	72	,	0.108328557	,	-0.322402816	),
  (	72	,	6.093335333	,	-0.405365744	),
  (	72	,	5.97463613	,	-0.403041187	),
  (	72	,	6.095457082	,	-0.329399786	),
  (	72	,	6.104446613	,	-0.212414012	),
  (	72	,	0.0722802	,	-0.233945769	),
  (	72	,	0.036094635	,	-0.258737544	),
  (	72	,	0.024093336	,	-0.1678655	),
  (	72	,	0.043885026	,	-0.156626937	),
  (	72	,	0.085560811	,	-0.126098859	),
  (	72	,	0.023872927	,	-0.133791254	),
  (	72	,	6.281101914	,	-0.049632781	),
  (	72	,	0.399744361	,	-0.213945281	),
  (	72	,	0.487242354	,	-0.230973884	),
  (	72	,	0.48111719	,	-0.224919419	),
  (	72	,	0.527206545	,	-0.14786628	),
  (	72	,	0.447392476	,	-0.151133254	),
  (	72	,	0.481116617	,	-0.117003736	),
  (	72	,	0.424415876	,	-0.006122412	),
  (	72	,	0.557578047	,	0.104451694	),
  (	72	,	0.177986171	,	-0.12624409	),
  (	72	,	0.150526184	,	-0.079351506	),
  (	72	,	0.128676215	,	-0.060549526	),
  (	72	,	0.264738466	,	-0.028950589	),
  (	72	,	0.251594537	,	0.031166278	),
  (	72	,	0.09195162	,	-0.050781523	),
  (	72	,	0.086601866	,	-0.043260431	),
  (	72	,	0.429056599	,	0.045135105	),
  (	72	,	0.382502364	,	0.09341394	),
  (	72	,	0.413975933	,	0.144422339	),
  (	72	,	0.53179272	,	0.137253174	),
  (	72	,	0.547110359	,	0.17587509	),
  (	72	,	0.495229835	,	0.221345046	),
  (	72	,	0.278319784	,	0.11806709	),
  (	72	,	0.375122209	,	0.181636535	),
  (	72	,	0.357673083	,	0.219983786	),
  (	72	,	5.79144804	,	-0.182331888	),
  (	72	,	5.800818824	,	-0.14286201	),
  (	72	,	5.814555994	,	-0.139875375	),
  (	72	,	5.943329412	,	-0.060624047	),
  (	72	,	6.146953882	,	-0.094065316	),
  (	72	,	6.082933903	,	-0.045991655	),
  (	72	,	6.091080654	,	-0.024852006	),
  (	72	,	6.052127922	,	0.053273569	),
  (	72	,	6.043233027	,	0.073727377	),
  (	72	,	6.028620415	,	0.077853602	),
  (	72	,	6.10778214	,	0.139310013	),
  (	72	,	5.657236844	,	-0.088184529	),
  (	72	,	5.783739495	,	0.010951749	),
  (	72	,	5.813229555	,	0.047708012	),
  (	72	,	5.52639864	,	-0.00183256	),
  (	72	,	5.748748754	,	0.072562667	),
  (	72	,	5.985146405	,	0.083531913	),
  (	72	,	5.824085003	,	0.074746101	),
  (	72	,	5.811556612	,	0.120362347	),
  (	72	,	5.757532141	,	0.184595127	),
  (	72	,	5.786536049	,	0.176163315	),
  (	72	,	5.966237677	,	0.246491089	),
  (	72	,	5.834969813	,	0.22513307	),
  (	72	,	5.844215084	,	0.271323632	),
  (	72	,	6.244410579	,	0.039058148	),
  (	72	,	0.023430969	,	0.062938306	),
  (	72	,	0.068263582	,	0.101994126	),
  (	72	,	0.137977794	,	0.159892473	),
  (	72	,	0.0171795	,	0.250955977	),
  (	72	,	6.22043693	,	0.22955435	),
  (	72	,	0.214141756	,	0.258469568	),
  (	72	,	0.292866079	,	0.351703106	),
  (	72	,	0.040684293	,	0.306008843	),
  (	72	,	0.07790457	,	0.35302635	),
  (	72	,	0.039584937	,	0.347754062	),
  (	72	,	0.073818235	,	0.405895309	),
  (	72	,	0.208363706	,	0.458877409	),
  (	72	,	0.169988427	,	0.459433856	),
  (	72	,	6.260468913	,	0.327193288	),
  (	72	,	5.964844468	,	0.300771517	),
  (	72	,	5.995736347	,	0.347164551	),
  (	72	,	6.111422678	,	0.369817811	),
  (	72	,	6.127479631	,	0.414687055	),
  (	72	,	6.107303924	,	0.415824616	),
  (	72	,	6.043445146	,	0.427986954	),
  (	72	,	6.068110973	,	0.462912517	),
  (	72	,	0.025947033	,	0.428808035	),
  (	72	,	6.233097687	,	0.447740525	),
  (	72	,	0.035027117	,	0.547876065	),
  (	72	,	6.193849447	,	0.493022029	),
  (	72	,	6.22395203	,	0.5009714	),
  (	72	,	6.099460907	,	0.531599054	),
  (	72	,	6.19523348	,	0.610080939	),
  (	72	,	6.233397841	,	0.633109233	),
  (	72	,	1.578054421	,	-0.611627559	),
  (	72	,	1.71677872	,	-0.562455915	),
  (	72	,	1.750257935	,	-0.534865745	),
  (	72	,	1.723093665	,	-0.525204245	),
  (	72	,	1.673301111	,	-0.52116796	),
  (	72	,	1.719737685	,	-0.517138316	),
  (	72	,	1.662170707	,	-0.517863615	),
  (	72	,	1.487342818	,	-0.518723329	),
  (	72	,	1.7873657	,	-0.421384937	),
  (	72	,	1.717682169	,	-0.459538588	),
  (	72	,	1.759462166	,	-0.381569853	),
  (	72	,	1.771323946	,	-0.362593094	),
  (	72	,	1.853947561	,	-0.363553149	),
  (	72	,	1.923796386	,	-0.360394994	),
  (	72	,	1.930267212	,	-0.357908024	),
  (	72	,	1.819737969	,	-0.298427329	),
  (	72	,	1.876873273	,	-0.273750042	),
  (	72	,	1.874465467	,	-0.266043368	),
  (	72	,	1.686264463	,	-0.337286146	),
  (	72	,	1.656697234	,	-0.305891055	),
  (	72	,	1.789550248	,	-0.219644971	),
  (	72	,	1.801665776	,	-0.212136021	),
  (	72	,	1.375218425	,	-0.494541283	),
  (	72	,	1.372313773	,	-0.457435408	),
  (	72	,	1.395276611	,	-0.452512761	),
  (	72	,	1.394166481	,	-0.438503253	),
  (	72	,	1.500484763	,	-0.371399794	),
  (	72	,	1.448299456	,	-0.291086987	),
  (	72	,	1.212943021	,	-0.361072824	),
  (	72	,	1.215098628	,	-0.342797792	),
  (	72	,	1.340171365	,	-0.301960301	),
  (	72	,	1.402203907	,	-0.254039409	),
  (	72	,	1.546337207	,	-0.274574864	),
  (	72	,	1.516064788	,	-0.266200532	),
  (	72	,	1.490442427	,	-0.267693021	),
  (	72	,	1.601038463	,	-0.210576302	),
  (	72	,	1.533098244	,	-0.203264506	),
  (	72	,	1.734566979	,	-0.143738843	),
  (	72	,	1.66546441	,	-0.143748349	),
  (	72	,	1.491560704	,	-0.214864766	),
  (	72	,	1.494710952	,	-0.185507437	),
  (	72	,	1.519194337	,	-0.146322063	),
  (	72	,	1.42274669	,	-0.187758395	),
  (	72	,	1.406351724	,	-0.151252833	),
  (	72	,	1.627726094	,	-0.0861426	),
  (	72	,	1.563644923	,	-0.081193836	),
  (	72	,	1.959552015	,	-0.329434646	),
  (	72	,	1.93001718	,	-0.284683869	),
  (	72	,	1.969306582	,	-0.261200618	),
  (	72	,	1.987025173	,	-0.268474379	),
  (	72	,	1.898676878	,	-0.254982932	),
  (	72	,	1.905830804	,	-0.238780839	),
  (	72	,	2.073826074	,	-0.194630161	),
  (	72	,	2.103156295	,	-0.163304169	),
  (	72	,	2.043191884	,	-0.118222134	),
  (	72	,	1.857472821	,	-0.223608757	),
  (	72	,	1.882107639	,	-0.182017025	),
  (	72	,	1.851905222	,	-0.182463067	),
  (	72	,	1.805303882	,	-0.166079971	),
  (	72	,	1.997179118	,	-0.134865008	),
  (	72	,	1.923488531	,	-0.107083862	),
  (	72	,	1.909069259	,	-0.101624706	),
  (	72	,	1.920191554	,	-0.087117329	),
  (	72	,	1.967792938	,	-0.037784846	),
  (	72	,	2.178342431	,	-0.131913797	),
  (	72	,	2.201543965	,	-0.020065924	),
  (	72	,	2.193834357	,	-0.015143034	),
  (	72	,	2.247797269	,	0.006325248	),
  (	72	,	2.060099074	,	-0.053304	),
  (	72	,	2.051262991	,	-0.029362884	),
  (	72	,	2.083183102	,	-0.011098832	),
  (	72	,	2.06255143	,	0.059056396	),
  (	72	,	2.140957922	,	0.051474533	),
  (	72	,	2.216246819	,	0.056173806	),
  (	72	,	2.15043908	,	0.086017127	),
  (	72	,	2.172888013	,	0.108807913	),
  (	72	,	1.773821342	,	-0.155660694	),
  (	72	,	1.746702651	,	-0.110761969	),
  (	72	,	1.80778072	,	-0.111513736	),
  (	72	,	1.798572361	,	-0.098530923	),
  (	72	,	1.81889309	,	-0.064447307	),
  (	72	,	1.794672645	,	-0.06132731	),
  (	72	,	1.720470831	,	-0.085523346	),
  (	72	,	1.688486398	,	-0.077829506	),
  (	72	,	1.744349951	,	-0.024088305	),
  (	72	,	1.84838826	,	-0.043182585	),
  (	72	,	1.8487146	,	-0.00972049	),
  (	72	,	1.847402704	,	0.006002971	),
  (	72	,	1.848199633	,	0.04253884	),
  (	72	,	1.703645975	,	-0.052745773	),
  (	72	,	1.71523577	,	0.022223243	),
  (	72	,	1.674611746	,	0.046525375	),
  (	72	,	1.770780132	,	0.043620313	),
  (	72	,	1.738684882	,	0.08041052	),
  (	72	,	1.679160686	,	0.085027811	),
  (	72	,	1.732490605	,	0.096332417	),
  (	72	,	1.965609916	,	0.039483506	),
  (	72	,	1.965369508	,	0.057716825	),
  (	72	,	2.022483112	,	0.060829245	),
  (	72	,	1.985537051	,	0.092445872	),
  (	72	,	1.967608631	,	0.149259495	),
  (	72	,	2.002113258	,	0.139036916	),
  (	72	,	2.040079587	,	0.156596314	),
  (	72	,	2.040033364	,	0.168138387	),
  (	72	,	2.072722753	,	0.219378252	),
  (	72	,	1.892934934	,	0.186588181	),
  (	72	,	1.960063117	,	0.202132369	),
  (	72	,	1.960107451	,	0.250599913	),
  (	72	,	1.93335745	,	0.303854394	),
  (	72	,	1.945615237	,	0.316731628	),
  (	72	,	1.168460496	,	-0.194155048	),
  (	72	,	1.272580244	,	-0.179600684	),
  (	72	,	1.216826202	,	-0.143552794	),
  (	72	,	1.023559452	,	-0.166161997	),
  (	72	,	1.135580043	,	-0.045876911	),
  (	72	,	1.373086287	,	-0.123424805	),
  (	72	,	1.464138999	,	-0.084431091	),
  (	72	,	1.396494505	,	-0.090903814	),
  (	72	,	1.346228888	,	-0.049298279	),
  (	72	,	1.483819848	,	-0.024879012	),
  (	72	,	1.460853017	,	-0.016639645	),
  (	72	,	1.521418594	,	-0.03116402	),
  (	72	,	1.521744412	,	-0.026209768	),
  (	72	,	1.55314762	,	0.014593552	),
  (	72	,	1.519503414	,	0.028092646	),
  (	72	,	1.481929348	,	0.014551818	),
  (	72	,	1.368014138	,	0.034341795	),
  (	72	,	1.425709144	,	0.071247679	),
  (	72	,	1.34436713	,	0.065424799	),
  (	72	,	1.320963685	,	0.060347772	),
  (	72	,	1.360393424	,	0.076839513	),
  (	72	,	1.291260943	,	0.081491147	),
  (	72	,	1.028967579	,	-0.079014215	),
  (	72	,	0.895959002	,	-0.081248899	),
  (	72	,	0.96342589	,	-0.040739797	),
  (	72	,	1.070060482	,	-0.017663949	),
  (	72	,	1.070181975	,	-0.009938813	),
  (	72	,	1.061669613	,	0.053718565	),
  (	72	,	0.868469855	,	-0.049635281	),
  (	72	,	0.955213907	,	0.048229611	),
  (	72	,	0.984946401	,	0.125469213	),
  (	72	,	1.188605182	,	0.017104853	),
  (	72	,	1.164351957	,	0.123834373	),
  (	72	,	1.316825151	,	0.198534636	),
  (	72	,	1.110796166	,	0.186773755	),
  (	72	,	1.182267575	,	0.187652427	),
  (	72	,	1.124511376	,	0.241499155	),
  (	72	,	1.146417425	,	0.262776769	),
  (	72	,	1.600956567	,	0.037925355	),
  (	72	,	1.588114937	,	0.049991747	),
  (	72	,	1.57742952	,	0.050774783	),
  (	72	,	1.574381872	,	0.050893972	),
  (	72	,	1.577438827	,	0.055614175	),
  (	72	,	1.503205746	,	0.075732219	),
  (	72	,	1.486816525	,	0.088617102	),
  (	72	,	1.507199931	,	0.109919082	),
  (	72	,	1.750376633	,	0.156810731	),
  (	72	,	1.614193347	,	0.165242106	),
  (	72	,	1.681336419	,	0.196050241	),
  (	72	,	1.677558434	,	0.227154978	),
  (	72	,	1.499276893	,	0.12022606	),
  (	72	,	1.520679958	,	0.131794	),
  (	72	,	1.503998274	,	0.216685	),
  (	72	,	1.483142693	,	0.227288486	),
  (	72	,	1.58194592	,	0.227333972	),
  (	72	,	1.615869784	,	0.241042771	),
  (	72	,	1.607910984	,	0.24384087	),
  (	72	,	1.846722625	,	0.250209832	),
  (	72	,	1.824347857	,	0.248336609	),
  (	72	,	1.831903896	,	0.278223989	),
  (	72	,	1.869094557	,	0.281605118	),
  (	72	,	1.645428953	,	0.276643316	),
  (	72	,	1.637850521	,	0.28677187	),
  (	72	,	1.710382939	,	0.387212769	),
  (	72	,	1.682367731	,	0.391960442	),
  (	72	,	1.681235827	,	0.413805519	),
  (	72	,	1.776821933	,	0.387355008	),
  (	72	,	1.859620288	,	0.433889845	),
  (	72	,	1.768855365	,	0.430615263	),
  (	72	,	1.719664468	,	0.386134802	),
  (	72	,	1.814864677	,	0.476227164	),
  (	72	,	1.411661457	,	0.279958775	),
  (	72	,	1.489536647	,	0.305818949	),
  (	72	,	1.533553354	,	0.321910934	),
  (	72	,	1.52373042	,	0.368892542	),
  (	72	,	1.46626505	,	0.341200635	),
  (	72	,	1.286802569	,	0.285997465	),
  (	72	,	1.288603165	,	0.290076968	),
  (	72	,	1.267116532	,	0.300238909	),
  (	72	,	1.3705029	,	0.37042252	),
  (	72	,	1.33815383	,	0.39288588	),
  (	72	,	1.589128226	,	0.444075307	),
  (	72	,	1.482910791	,	0.422819093	),
  (	72	,	1.530051979	,	0.480047089	),
  (	72	,	1.69153922	,	0.534857981	),
  (	72	,	1.72782928	,	0.54941372	),
  (	72	,	1.680811828	,	0.563248383	),
  (	72	,	1.450627669	,	0.470915026	),
  (	72	,	1.550597936	,	0.522968591	),
  (	72	,	1.51927125	,	0.532937324	),
  (	72	,	1.436750434	,	0.561981546	),
  (	72	,	1.488992931	,	0.591994886	),
  (	72	,	1.58545681	,	0.547864039	),
  (	72	,	1.598117997	,	0.558453037	),
  (	72	,	1.605413667	,	0.629453788	),
  (	72	,	1.569562783	,	0.64948778	),
  (	72	,	1.60655089	,	0.662922607	),
  (	72	,	3.20312492	,	-0.641042202	),
  (	72	,	3.060318681	,	-0.621402461	),
  (	72	,	3.133119617	,	-0.552417587	),
  (	72	,	3.054103103	,	-0.583814213	),
  (	72	,	3.132442147	,	-0.483654444	),
  (	72	,	3.341765759	,	-0.379929274	),
  (	72	,	3.444855792	,	-0.351225538	),
  (	72	,	3.408743431	,	-0.362638286	),
  (	72	,	3.428531935	,	-0.318691111	),
  (	72	,	3.451774568	,	-0.298277989	),
  (	72	,	3.179601044	,	-0.321759342	),
  (	72	,	3.297168856	,	-0.299334553	),
  (	72	,	3.394904949	,	-0.261552189	),
  (	72	,	3.382084355	,	-0.234795339	),
  (	72	,	2.932276521	,	-0.456178835	),
  (	72	,	3.040184598	,	-0.426547327	),
  (	72	,	3.059394746	,	-0.309022107	),
  (	72	,	3.038939538	,	-0.294100195	),
  (	72	,	3.028420197	,	-0.280055047	),
  (	72	,	2.849561662	,	-0.360062312	),
  (	72	,	3.002920517	,	-0.277267718	),
  (	72	,	3.013516016	,	-0.227776244	),
  (	72	,	2.935834774	,	-0.243190552	),
  (	72	,	2.946961781	,	-0.202255723	),
  (	72	,	3.242639434	,	-0.127393215	),
  (	72	,	3.09437914	,	-0.128467281	),
  (	72	,	3.157257388	,	-0.095638183	),
  (	72	,	3.452952058	,	-0.243693395	),
  (	72	,	3.553033851	,	-0.201371721	),
  (	72	,	3.499985757	,	-0.219555025	),
  (	72	,	3.626343804	,	-0.238750234	),
  (	72	,	3.625253859	,	-0.135863174	),
  (	72	,	3.660824005	,	-0.120877163	),
  (	72	,	3.468506684	,	-0.19847156	),
  (	72	,	3.467756432	,	-0.181002718	),
  (	72	,	3.538030964	,	-0.053225407	),
  (	72	,	3.796089956	,	-0.074130021	),
  (	72	,	3.720821402	,	-0.057985446	),
  (	72	,	3.867197597	,	-0.014549412	),
  (	72	,	3.789605171	,	0.048680505	),
  (	72	,	3.561509948	,	-0.016255375	),
  (	72	,	3.387023757	,	-0.084893152	),
  (	72	,	3.387878544	,	-0.016672497	),
  (	72	,	3.268831281	,	-0.042404491	),
  (	72	,	3.311485524	,	-0.014907938	),
  (	72	,	3.295454396	,	0.03946835	),
  (	72	,	3.382380704	,	0.053225168	),
  (	72	,	3.270160553	,	0.084447764	),
  (	72	,	3.491728108	,	0.057377057	),
  (	72	,	3.486782212	,	0.064974685	),
  (	72	,	3.537136172	,	0.162607478	),
  (	72	,	3.671461356	,	0.162290367	),
  (	72	,	3.394049556	,	0.162985018	),
  (	72	,	3.38377744	,	0.200646019	),
  (	72	,	3.545645824	,	0.251228886	),
  (	72	,	2.826186532	,	-0.263714629	),
  (	72	,	2.698266034	,	-0.232216472	),
  (	72	,	2.876724956	,	-0.180212855	),
  (	72	,	2.77942792	,	-0.154291925	),
  (	72	,	2.679690126	,	-0.139515555	),
  (	72	,	2.950461743	,	-0.060594859	),
  (	72	,	2.964315898	,	-0.028901945	),
  (	72	,	2.840306764	,	0.062669105	),
  (	72	,	2.577349513	,	-0.128847815	),
  (	72	,	2.526662753	,	-0.049559775	),
  (	72	,	2.515292797	,	-0.048483929	),
  (	72	,	2.451079522	,	-0.048745448	),
  (	72	,	2.388349903	,	0.010473925	),
  (	72	,	2.553750749	,	0.15503345	),
  (	72	,	2.751154835	,	0.037523565	),
  (	72	,	2.814520331	,	0.057709368	),
  (	72	,	2.82445725	,	0.110759464	),
  (	72	,	2.636056591	,	0.202956517	),
  (	72	,	2.743253157	,	0.231934801	),
  (	72	,	2.698047915	,	0.220275133	),
  (	72	,	2.743324845	,	0.299036648	),
  (	72	,	3.287941111	,	0.134032667	),
  (	72	,	3.229204698	,	0.241814901	),
  (	72	,	3.042531925	,	0.109433777	),
  (	72	,	3.080963589	,	0.125208459	),
  (	72	,	3.063342384	,	0.21439692	),
  (	72	,	3.104091606	,	0.20603922	),
  (	72	,	3.443075315	,	0.325082211	),
  (	72	,	3.224946536	,	0.288804199	),
  (	72	,	3.376902841	,	0.467398665	),
  (	72	,	2.96315918	,	0.233712747	),
  (	72	,	2.968986503	,	0.302137742	),
  (	72	,	3.031226827	,	0.293146249	),
  (	72	,	3.179216801	,	0.462394822	),
  (	72	,	3.121550781	,	0.445445721	),
  (	72	,	3.231824233	,	0.472159027	),
  (	72	,	3.046002721	,	0.556422714	),
  (	72	,	3.124397828	,	0.709431052	),
  (	72	,	4.746886085	,	-0.67309429	),
  (	72	,	4.765205839	,	-0.594611606	),
  (	72	,	4.683549606	,	-0.611161671	),
  (	72	,	4.640103028	,	-0.61606066	),
  (	72	,	4.712130143	,	-0.5830857	),
  (	72	,	4.708439836	,	-0.528022549	),
  (	72	,	4.843414892	,	-0.576804859	),
  (	72	,	4.868273474	,	-0.522508314	),
  (	72	,	4.853035389	,	-0.509464648	),
  (	72	,	4.751260192	,	-0.523475781	),
  (	72	,	4.625929394	,	-0.562984619	),
  (	72	,	4.628275147	,	-0.561222935	),
  (	72	,	4.678720844	,	-0.546781487	),
  (	72	,	4.547245299	,	-0.532350031	),
  (	72	,	4.526255741	,	-0.526469516	),
  (	72	,	4.73407405	,	-0.430761869	),
  (	72	,	4.730761694	,	-0.392714981	),
  (	72	,	4.845408963	,	-0.405800795	),
  (	72	,	5.083788759	,	-0.323981674	),
  (	72	,	4.947179913	,	-0.345527235	),
  (	72	,	4.835078949	,	-0.401417111	),
  (	72	,	4.85413626	,	-0.331136035	),
  (	72	,	4.764538048	,	-0.356455294	),
  (	72	,	4.798937359	,	-0.3098105	),
  (	72	,	4.804184994	,	-0.26582623	),
  (	72	,	4.91143247	,	-0.306216365	),
  (	72	,	4.921768125	,	-0.292804922	),
  (	72	,	4.865678729	,	-0.296453541	),
  (	72	,	4.898544899	,	-0.270914737	),
  (	72	,	4.960088635	,	-0.259315511	),
  (	72	,	4.856526267	,	-0.289029807	),
  (	72	,	4.575583246	,	-0.445248345	),
  (	72	,	4.678889657	,	-0.333740369	),
  (	72	,	4.601369137	,	-0.318014613	),
  (	72	,	4.357121747	,	-0.32857186	),
  (	72	,	4.470186069	,	-0.221250465	),
  (	72	,	4.738695357	,	-0.14151249	),
  (	72	,	4.742635203	,	-0.056427001	),
  (	72	,	5.123922935	,	-0.285783271	),
  (	72	,	5.103185905	,	-0.268061138	),
  (	72	,	5.109320021	,	-0.254175942	),
  (	72	,	5.149091074	,	-0.245129175	),
  (	72	,	5.109318441	,	-0.200446846	),
  (	72	,	5.162053489	,	-0.144998089	),
  (	72	,	4.988215835	,	-0.195299235	),
  (	72	,	5.075278501	,	-0.186805875	),
  (	72	,	4.947713958	,	-0.163543244	),
  (	72	,	5.064967974	,	-0.07858419	),
  (	72	,	5.264802769	,	-0.077101056	),
  (	72	,	5.30945595	,	-0.060953623	),
  (	72	,	5.402424249	,	-0.076479007	),
  (	72	,	5.392135207	,	-2.41248E-05	),
  (	72	,	5.411810307	,	0.060062493	),
  (	72	,	5.285359115	,	-0.002210413	),
  (	72	,	5.153956498	,	-0.040377605	),
  (	72	,	5.131340261	,	0.004356381	),
  (	72	,	5.269730008	,	0.042638979	),
  (	72	,	5.300962017	,	0.059462145	),
  (	72	,	5.363378855	,	0.077785658	),
  (	72	,	5.343124973	,	0.096157486	),
  (	72	,	4.896952326	,	-0.128060519	),
  (	72	,	4.870039179	,	-0.117672868	),
  (	72	,	4.988560137	,	-0.097023834	),
  (	72	,	4.931198902	,	-0.06323589	),
  (	72	,	4.877985775	,	-0.045216187	),
  (	72	,	5.06631561	,	-0.020533689	),
  (	72	,	4.979516935	,	0.035487872	),
  (	72	,	4.989858943	,	0.044431857	),
  (	72	,	4.892772578	,	0.079550382	),
  (	72	,	4.882191733	,	0.109447195	),
  (	72	,	5.174717018	,	0.074147936	),
  (	72	,	5.267826831	,	0.192919694	),
  (	72	,	5.01087415	,	0.228601714	),
  (	72	,	5.065376552	,	0.236950658	),
  (	72	,	5.056008514	,	0.287774891	),
  (	72	,	4.331183496	,	-0.279050211	),
  (	72	,	4.470465339	,	-0.193532899	),
  (	72	,	4.170048	,	-0.150937346	),
  (	72	,	4.201798184	,	-0.140468501	),
  (	72	,	4.202135745	,	-0.101834985	),
  (	72	,	4.699616037	,	0.001162265	),
  (	72	,	4.585236582	,	0.019536197	),
  (	72	,	4.385971873	,	-0.053843376	),
  (	72	,	4.399231197	,	0.019030061	),
  (	72	,	4.176328321	,	-0.109897306	),
  (	72	,	4.087907836	,	-0.105186689	),
  (	72	,	4.260013982	,	-0.028761758	),
  (	72	,	4.03929193	,	-0.021896369	),
  (	72	,	4.051556809	,	0.010595821	),
  (	72	,	4.144545968	,	0.043645409	),
  (	72	,	4.313458822	,	0.027695383	),
  (	72	,	4.389358413	,	0.070541381	),
  (	72	,	4.326284771	,	0.144767872	),
  (	72	,	4.477296142	,	0.150502003	),
  (	72	,	4.421020204	,	0.18979429	),
  (	72	,	4.295265734	,	0.178970875	),
  (	72	,	4.336444467	,	0.233776132	),
  (	72	,	4.63354889	,	0.076213875	),
  (	72	,	4.727009934	,	0.146946996	),
  (	72	,	4.552393083	,	0.165225077	),
  (	72	,	4.572196452	,	0.198802678	),
  (	72	,	4.73735431	,	0.209506335	),
  (	72	,	4.734232107	,	0.295425674	),
  (	72	,	4.949597132	,	0.233693438	),
  (	72	,	4.898900455	,	0.259048728	),
  (	72	,	4.991779818	,	0.287332352	),
  (	72	,	4.972904678	,	0.283646004	),
  (	72	,	5.047536022	,	0.33119132	),
  (	72	,	5.082135623	,	0.348009817	),
  (	72	,	4.982753499	,	0.333795874	),
  (	72	,	4.994442123	,	0.407172161	),
  (	72	,	4.864159208	,	0.375006127	),
  (	72	,	4.850921453	,	0.382264625	),
  (	72	,	4.782862971	,	0.367216183	),
  (	72	,	4.900459455	,	0.376243349	),
  (	72	,	4.926034614	,	0.369433452	),
  (	72	,	4.927163255	,	0.483809105	),
  (	72	,	4.905939094	,	0.49046038	),
  (	72	,	4.634943848	,	0.300690231	),
  (	72	,	4.696723906	,	0.34712374	),
  (	72	,	4.412183749	,	0.275669676	),
  (	72	,	4.491845848	,	0.385568571	),
  (	72	,	4.493995002	,	0.461734399	),
  (	72	,	4.487045513	,	0.492755396	),
  (	72	,	4.527285967	,	0.504632532	),
  (	72	,	4.768534219	,	0.398368148	),
  (	72	,	4.767092324	,	0.426762701	),
  (	72	,	4.677669534	,	0.424191716	),
  (	72	,	4.723412701	,	0.459175494	),
  (	72	,	4.7151981	,	0.516148447	),
  (	72	,	4.803242654	,	0.480506101	),
  (	72	,	4.588945061	,	0.529131687	),
  (	72	,	4.678451795	,	0.55874859	),
  (	72	,	4.76555372	,	0.581048842	),
  (	72	,	4.758008009	,	0.613857704	),
  (	72	,	4.706613548	,	0.621894518	),
  (	72	,	0.054888256	,	-1.54222279	),
  (	72	,	1.117056939	,	-1.469233234	),
  (	72	,	0.504856718	,	-1.479186268	),
  (	72	,	1.46455468	,	-1.424392289	),
  (	72	,	0.995701045	,	-1.303655299	),
  (	72	,	0.406759057	,	-1.394980611	),
  (	72	,	0.034930722	,	-1.371806905	),
  (	72	,	0.044220956	,	-1.366608038	),
  (	72	,	0.73626689	,	-1.288773922	),
  (	72	,	0.814716217	,	-1.257068873	),
  (	72	,	1.29638436	,	-1.134736762	),
  (	72	,	1.361591216	,	-1.137523594	),
  (	72	,	0.061412205	,	-1.30745812	),
  (	72	,	0.348002215	,	-1.202485802	),
  (	72	,	0.658333005	,	-1.117807105	),
  (	72	,	0.116519504	,	-1.209639749	),
  (	72	,	0.338531216	,	-1.138159597	),
  (	72	,	0.19596368	,	-1.1029937	),
  (	72	,	0.503198707	,	-1.052655812	),
  (	72	,	0.372348842	,	-1.038446131	),
  (	72	,	0.678615084	,	-0.887561579	),
  (	72	,	0.646567079	,	-0.877944987	),
  (	72	,	1.429632017	,	-1.054469353	),
  (	72	,	1.260057097	,	-1.051717192	),
  (	72	,	1.318952909	,	-0.978702384	),
  (	72	,	1.404641467	,	-0.947230607	),
  (	72	,	1.129234572	,	-0.944840381	),
  (	72	,	1.30679396	,	-0.863207254	),
  (	72	,	1.1530725	,	-0.814107827	),
  (	72	,	1.445024173	,	-0.738263411	),
  (	72	,	1.472025456	,	-0.663622254	),
  (	72	,	1.32223921	,	-0.741730642	),
  (	72	,	1.279688211	,	-0.665740969	),
  (	72	,	1.384266425	,	-0.685702515	),
  (	72	,	1.425702431	,	-0.638524357	),
  (	72	,	1.427866027	,	-0.604135079	),
  (	72	,	1.306114125	,	-0.643515937	),
  (	72	,	1.369092017	,	-0.625275603	),
  (	72	,	1.38054191	,	-0.585347278	),
  (	72	,	1.380570575	,	-0.567470214	),
  (	72	,	1.368431273	,	-0.559674276	),
  (	72	,	1.039581617	,	-0.865853482	),
  (	72	,	1.060275192	,	-0.84419266	),
  (	72	,	1.003753043	,	-0.792124088	),
  (	72	,	1.034237943	,	-0.698775228	),
  (	72	,	1.119130129	,	-0.678662402	),
  (	72	,	1.109733328	,	-0.667757275	),
  (	72	,	1.063513538	,	-0.647003913	),
  (	72	,	0.882067119	,	-0.816183105	),
  (	72	,	0.837603737	,	-0.687065991	),
  (	72	,	0.837231354	,	-0.681087158	),
  (	72	,	0.895418758	,	-0.648437339	),
  (	72	,	0.978083738	,	-0.668107865	),
  (	72	,	1.004771772	,	-0.563484756	),
  (	72	,	1.108084386	,	-0.646303939	),
  (	72	,	1.101813918	,	-0.630978098	),
  (	72	,	1.167968026	,	-0.565636672	),
  (	72	,	1.148846576	,	-0.561157855	),
  (	72	,	1.359182216	,	-0.527533839	),
  (	72	,	1.209049927	,	-0.531087349	),
  (	72	,	1.270278757	,	-0.441741349	),
  (	72	,	1.108195278	,	-0.559241246	),
  (	72	,	0.992098818	,	-0.514330809	),
  (	72	,	1.23607775	,	-0.4123939	),
  (	72	,	1.141108605	,	-0.449051376	),
  (	72	,	1.090764112	,	-0.437060937	),
  (	72	,	0.432543424	,	-0.984882233	),
  (	72	,	0.431135006	,	-0.932690617	),
  (	72	,	0.385349464	,	-0.855312068	),
  (	72	,	0.427885444	,	-0.804312531	),
  (	72	,	0.411670595	,	-0.797451046	),
  (	72	,	0.381743297	,	-0.80016439	),
  (	72	,	0.566193266	,	-0.902867635	),
  (	72	,	0.712705462	,	-0.707335146	),
  (	72	,	0.521115601	,	-0.710827338	),
  (	72	,	0.590883619	,	-0.71678616	),
  (	72	,	0.188901156	,	-0.788562607	),
  (	72	,	0.183086572	,	-0.75267045	),
  (	72	,	0.294705275	,	-0.728625078	),
  (	72	,	0.264373986	,	-0.632477055	),
  (	72	,	0.163164662	,	-0.650804671	),
  (	72	,	0.317558596	,	-0.61445448	),
  (	72	,	0.457968528	,	-0.501382034	),
  (	72	,	0.47384806	,	-0.458212754	),
  (	72	,	0.406974937	,	-0.422004234	),
  (	72	,	0.331150143	,	-0.418410157	),
  (	72	,	0.869591539	,	-0.610942171	),
  (	72	,	0.84002755	,	-0.565425234	),
  (	72	,	0.859218732	,	-0.547202709	),
  (	72	,	0.836969808	,	-0.508994877	),
  (	72	,	1.01590532	,	-0.388790115	),
  (	72	,	1.090285728	,	-0.336621112	),
  (	72	,	0.960837468	,	-0.341957218	),
  (	72	,	0.824247688	,	-0.33107472	),
  (	72	,	1.018876814	,	-0.26128634	),
  (	72	,	0.932669198	,	-0.264047431	),
  (	72	,	0.906214096	,	-0.25074535	),
  (	72	,	0.502098107	,	-0.434405532	),
  (	72	,	0.589207307	,	-0.410868837	),
  (	72	,	0.674555215	,	-0.382771575	),
  (	72	,	0.651543881	,	-0.367187065	),
  (	72	,	0.683142652	,	-0.255811513	),
  (	72	,	0.551246349	,	-0.269591848	),
  (	72	,	0.763156211	,	-0.2447803	),
  (	72	,	0.800811182	,	-0.191564358	),
  (	72	,	0.863874501	,	-0.182266234	),
  (	72	,	0.649159679	,	-0.198042969	),
  (	72	,	0.693859314	,	-0.155828896	),
  (	72	,	0.715664797	,	-0.1048817	),
  (	72	,	0.743323219	,	-0.08702955	),
  (	72	,	0.737591531	,	-0.073738409	),
  (	72	,	0.816871372	,	-0.031465787	),
  (	72	,	2.501373879	,	-1.501161858	),
  (	72	,	2.90690762	,	-1.496598545	),
  (	72	,	2.458210436	,	-1.359403061	),
  (	72	,	1.60172049	,	-1.414815236	),
  (	72	,	2.193881754	,	-1.333965661	),
  (	72	,	1.777962182	,	-1.341309724	),
  (	72	,	1.978554207	,	-1.345347098	),
  (	72	,	2.274944667	,	-1.266902841	),
  (	72	,	2.40563469	,	-1.208663662	),
  (	72	,	3.075583351	,	-1.27671723	),
  (	72	,	2.779522304	,	-1.251250838	),
  (	72	,	2.753793385	,	-1.181629002	),
  (	72	,	2.944846865	,	-1.192545792	),
  (	72	,	3.029067853	,	-1.141614699	),
  (	72	,	2.803078031	,	-1.123969923	),
  (	72	,	2.900872946	,	-1.127756094	),
  (	72	,	2.820588011	,	-1.104794425	),
  (	72	,	2.837101217	,	-1.093199077	),
  (	72	,	2.819622505	,	-1.081085496	),
  (	72	,	2.555476384	,	-1.223793173	),
  (	72	,	2.511920019	,	-1.19049088	),
  (	72	,	2.627927844	,	-1.150486139	),
  (	72	,	2.738299808	,	-1.099948402	),
  (	72	,	2.797786451	,	-1.046736848	),
  (	72	,	2.64876298	,	-1.068396384	),
  (	72	,	2.577107899	,	-1.056404617	),
  (	72	,	2.599231943	,	-1.031605354	),
  (	72	,	1.906578024	,	-1.252259193	),
  (	72	,	2.111205386	,	-1.22761428	),
  (	72	,	1.78914247	,	-1.157034669	),
  (	72	,	1.639117735	,	-1.157016648	),
  (	72	,	2.173299126	,	-1.052674881	),
  (	72	,	2.086603935	,	-1.061182125	),
  (	72	,	2.341677024	,	-1.109073295	),
  (	72	,	2.341808362	,	-1.100401472	),
  (	72	,	2.496040528	,	-1.068749931	),
  (	72	,	2.503363481	,	-1.058150358	),
  (	72	,	2.396538238	,	-1.034457597	),
  (	72	,	2.440555026	,	-1.028511872	),
  (	72	,	2.391493693	,	-1.014543068	),
  (	72	,	2.49881007	,	-0.956976968	),
  (	72	,	2.466680913	,	-0.950572766	),
  (	72	,	2.413547553	,	-0.933834027	),
  (	72	,	2.483913535	,	-0.914980498	),
  (	72	,	2.485438697	,	-0.883199871	),
  (	72	,	2.250887781	,	-0.983880811	),
  (	72	,	2.294977971	,	-0.959238462	),
  (	72	,	2.268877497	,	-0.929576187	),
  (	72	,	2.355127421	,	-0.898906627	),
  (	72	,	2.380229099	,	-0.877670862	),
  (	72	,	2.356270853	,	-0.864948766	),
  (	72	,	2.428919962	,	-0.865310896	),
  (	72	,	2.44353466	,	-0.819437787	),
  (	72	,	2.330942045	,	-0.759199072	),
  (	72	,	3.055499734	,	-1.089650627	),
  (	72	,	3.109506521	,	-1.086209537	),
  (	72	,	3.01854775	,	-1.057780625	),
  (	72	,	3.014434801	,	-1.052748918	),
  (	72	,	3.004462369	,	-1.014768728	),
  (	72	,	3.007868904	,	-1.009366166	),
  (	72	,	2.935370979	,	-1.041570587	),
  (	72	,	2.850346763	,	-1.061417731	),
  (	72	,	2.830178758	,	-1.051102597	),
  (	72	,	2.955018544	,	-1.043177933	),
  (	72	,	2.970989733	,	-1.024568243	),
  (	72	,	3.117349736	,	-0.994310324	),
  (	72	,	3.050734275	,	-1.007745084	),
  (	72	,	3.032762281	,	-0.979519455	),
  (	72	,	3.032754119	,	-0.929249757	),
  (	72	,	2.79638328	,	-1.011166486	),
  (	72	,	2.735486223	,	-1.005432077	),
  (	72	,	2.859827217	,	-0.943866266	),
  (	72	,	2.732575934	,	-0.940582938	),
  (	72	,	2.706112739	,	-0.918072509	),
  (	72	,	2.686975609	,	-0.875769476	),
  (	72	,	2.805689836	,	-0.856203029	),
  (	72	,	2.829952506	,	-0.843870945	),
  (	72	,	2.792388458	,	-0.860088754	),
  (	72	,	2.802851543	,	-0.824151214	),
  (	72	,	3.09687382	,	-0.885245124	),
  (	72	,	3.046385641	,	-0.798480095	),
  (	72	,	3.017635838	,	-0.780832255	),
  (	72	,	3.103857802	,	-0.751881508	),
  (	72	,	3.077957385	,	-0.707144741	),
  (	72	,	3.006005592	,	-0.758856403	),
  (	72	,	3.014795266	,	-0.731752264	),
  (	72	,	3.049011102	,	-0.703423661	),
  (	72	,	2.856748472	,	-0.733357587	),
  (	72	,	2.833324304	,	-0.683648788	),
  (	72	,	2.808257301	,	-0.681696341	),
  (	72	,	2.898451782	,	-0.640909808	),
  (	72	,	2.60581747	,	-0.870400899	),
  (	72	,	2.660764395	,	-0.828089908	),
  (	72	,	2.54147923	,	-0.817949786	),
  (	72	,	2.588611189	,	-0.778144688	),
  (	72	,	2.663867392	,	-0.790768722	),
  (	72	,	2.680626729	,	-0.747150596	),
  (	72	,	2.600464982	,	-0.690340793	),
  (	72	,	2.634344928	,	-0.685544798	),
  (	72	,	2.623423201	,	-0.68854389	),
  (	72	,	2.507642389	,	-0.782190105	),
  (	72	,	2.434445409	,	-0.652711346	),
  (	72	,	2.77271057	,	-0.652078197	),
  (	72	,	2.777678563	,	-0.580719336	),
  (	72	,	2.626743883	,	-0.596438805	),
  (	72	,	2.606110235	,	-0.573477501	),
  (	72	,	2.612441985	,	-0.511465039	),
  (	72	,	2.592185081	,	-0.488675464	),
  (	72	,	2.778794899	,	-0.395585817	),
  (	72	,	2.747588161	,	-0.384747174	),
  (	72	,	1.579056736	,	-1.132035986	),
  (	72	,	1.828763818	,	-1.061894601	),
  (	72	,	1.765995365	,	-1.068563652	),
  (	72	,	1.658050483	,	-1.070395359	),
  (	72	,	1.689475548	,	-1.059911728	),
  (	72	,	1.57623103	,	-1.055672309	),
  (	72	,	2.017581813	,	-0.979931868	),
  (	72	,	1.93600995	,	-0.936701969	),
  (	72	,	1.924346766	,	-0.887572901	),
  (	72	,	1.838289223	,	-0.880809756	),
  (	72	,	2.135933646	,	-0.917597012	),
  (	72	,	2.101309929	,	-0.883233655	),
  (	72	,	2.139196195	,	-0.855820242	),
  (	72	,	2.210437013	,	-0.863888591	),
  (	72	,	2.221253078	,	-0.836523846	),
  (	72	,	2.084072902	,	-0.813205167	),
  (	72	,	2.143751729	,	-0.799675746	),
  (	72	,	2.251636538	,	-0.811606114	),
  (	72	,	2.308440382	,	-0.763776367	),
  (	72	,	2.33005839	,	-0.741516096	),
  (	72	,	2.329780456	,	-0.730017993	),
  (	72	,	2.294190853	,	-0.708875213	),
  (	72	,	2.306951679	,	-0.684754352	),
  (	72	,	2.240414194	,	-0.726365092	),
  (	72	,	2.169852125	,	-0.742140111	),
  (	72	,	2.209171827	,	-0.681728872	),
  (	72	,	2.286439502	,	-0.676820563	),
  (	72	,	2.265597668	,	-0.65397405	),
  (	72	,	2.036655549	,	-0.816842364	),
  (	72	,	1.990684475	,	-0.784660776	),
  (	72	,	2.098307144	,	-0.751539973	),
  (	72	,	2.107205865	,	-0.70515665	),
  (	72	,	2.018078714	,	-0.684188958	),
  (	72	,	2.090584844	,	-0.6880134	),
  (	72	,	2.030505585	,	-0.686701423	),
  (	72	,	2.038404142	,	-0.682481492	),
  (	72	,	2.052649476	,	-0.632538665	),
  (	72	,	2.166037793	,	-0.693821609	),
  (	72	,	2.131928629	,	-0.689387643	),
  (	72	,	2.12197041	,	-0.678870016	),
  (	72	,	2.173864509	,	-0.652309405	),
  (	72	,	2.152440368	,	-0.634282074	),
  (	72	,	2.152764715	,	-0.633735427	),
  (	72	,	2.088419344	,	-0.6461526	),
  (	72	,	2.095467494	,	-0.628168455	),
  (	72	,	2.107017433	,	-0.578638031	),
  (	72	,	1.652738343	,	-0.878931324	),
  (	72	,	1.774756078	,	-0.834343175	),
  (	72	,	1.858611977	,	-0.738751439	),
  (	72	,	1.813431675	,	-0.590039033	),
  (	72	,	1.705447619	,	-0.610868994	),
  (	72	,	1.989351159	,	-0.653550579	),
  (	72	,	1.929772793	,	-0.626844906	),
  (	72	,	1.950264752	,	-0.598849543	),
  (	72	,	1.978416045	,	-0.582937683	),
  (	72	,	2.081933045	,	-0.580319284	),
  (	72	,	2.088465559	,	-0.481321051	),
  (	72	,	2.067430332	,	-0.458358963	),
  (	72	,	1.868306296	,	-0.548525916	),
  (	72	,	1.903818745	,	-0.559233523	),
  (	72	,	1.926292931	,	-0.492028132	),
  (	72	,	1.897689455	,	-0.505524358	),
  (	72	,	1.811853547	,	-0.506826209	),
  (	72	,	1.876266006	,	-0.501749876	),
  (	72	,	1.994383345	,	-0.478597903	),
  (	72	,	1.963646982	,	-0.438883471	),
  (	72	,	1.947013885	,	-0.364882877	),
  (	72	,	2.359251724	,	-0.670545776	),
  (	72	,	2.336219491	,	-0.582970422	),
  (	72	,	2.518868329	,	-0.540531755	),
  (	72	,	2.47044058	,	-0.524206492	),
  (	72	,	2.228975866	,	-0.587211967	),
  (	72	,	2.29079666	,	-0.540668555	),
  (	72	,	2.207874607	,	-0.561469764	),
  (	72	,	2.196983359	,	-0.537583912	),
  (	72	,	2.164138866	,	-0.526820897	),
  (	72	,	2.26754197	,	-0.507591846	),
  (	72	,	2.398793542	,	-0.450348336	),
  (	72	,	2.358953564	,	-0.370282355	),
  (	72	,	2.551658905	,	-0.482245242	),
  (	72	,	2.481183985	,	-0.443902248	),
  (	72	,	2.510691854	,	-0.395948229	),
  (	72	,	2.66413333	,	-0.324688819	),
  (	72	,	2.665427844	,	-0.274176229	),
  (	72	,	2.439665979	,	-0.393622753	),
  (	72	,	2.469402534	,	-0.313239226	),
  (	72	,	2.474056337	,	-0.279482898	),
  (	72	,	2.530917012	,	-0.226846536	),
  (	72	,	2.197047202	,	-0.485595962	),
  (	72	,	2.099791585	,	-0.443545305	),
  (	72	,	2.204806182	,	-0.386416982	),
  (	72	,	2.231395491	,	-0.340440196	),
  (	72	,	2.25566305	,	-0.326052439	),
  (	72	,	2.266654648	,	-0.31883471	),
  (	72	,	2.066763521	,	-0.404692484	),
  (	72	,	2.100107559	,	-0.389853457	),
  (	72	,	2.021696128	,	-0.389184211	),
  (	72	,	2.06873668	,	-0.319936933	),
  (	72	,	2.075166003	,	-0.271905164	),
  (	72	,	2.134871695	,	-0.271750209	),
  (	72	,	2.346826448	,	-0.329679396	),
  (	72	,	2.376667382	,	-0.300843071	),
  (	72	,	2.350837985	,	-0.292318236	),
  (	72	,	2.327785881	,	-0.198823273	),
  (	72	,	2.49352458	,	-0.210534308	),
  (	72	,	2.46097026	,	-0.095410492	),
  (	72	,	2.260004436	,	-0.155016638	),
  (	72	,	2.264292826	,	-0.119527258	),
  (	72	,	2.280345302	,	-0.076976297	),
  (	72	,	2.337333548	,	-0.048705032	),
  (	72	,	4.036068026	,	-1.335607827	),
  (	72	,	3.627876798	,	-1.276599481	),
  (	72	,	3.820040875	,	-1.286210509	),
  (	72	,	4.547043609	,	-1.315103952	),
  (	72	,	4.430432809	,	-1.209161515	),
  (	72	,	4.310452434	,	-1.21931188	),
  (	72	,	4.357661797	,	-1.199409166	),
  (	72	,	4.401376931	,	-1.170822196	),
  (	72	,	4.063491544	,	-1.150928515	),
  (	72	,	4.084917257	,	-1.136469524	),
  (	72	,	4.132105511	,	-1.095995628	),
  (	72	,	4.076390791	,	-1.061302859	),
  (	72	,	4.338667862	,	-1.08689305	),
  (	72	,	4.327780086	,	-1.087170705	),
  (	72	,	4.335316976	,	-1.084228759	),
  (	72	,	4.293570117	,	-1.022868224	),
  (	72	,	4.205113161	,	-1.055897748	),
  (	72	,	4.123721391	,	-1.069861827	),
  (	72	,	4.157867495	,	-1.030831797	),
  (	72	,	3.248344472	,	-1.347650584	),
  (	72	,	3.466332072	,	-1.311984673	),
  (	72	,	3.583264047	,	-1.254333498	),
  (	72	,	3.275591238	,	-1.275639811	),
  (	72	,	3.27376248	,	-1.273834027	),
  (	72	,	3.514749162	,	-1.196040459	),
  (	72	,	3.48944544	,	-1.175730924	),
  (	72	,	3.634576561	,	-1.222555625	),
  (	72	,	3.726698684	,	-1.190154141	),
  (	72	,	3.901522862	,	-1.159270161	),
  (	72	,	3.873762838	,	-1.157712054	),
  (	72	,	3.880822469	,	-1.146359521	),
  (	72	,	3.648131166	,	-1.115120702	),
  (	72	,	3.30056261	,	-1.172355245	),
  (	72	,	3.149200372	,	-1.207732319	),
  (	72	,	3.665589926	,	-1.09575604	),
  (	72	,	3.490813712	,	-1.091293813	),
  (	72	,	3.489085496	,	-1.058284124	),
  (	72	,	4.016621357	,	-1.039235146	),
  (	72	,	4.099696964	,	-0.967385666	),
  (	72	,	4.11923909	,	-0.90590952	),
  (	72	,	4.038673781	,	-0.896069518	),
  (	72	,	3.747437305	,	-1.024272409	),
  (	72	,	3.807222172	,	-0.992878788	),
  (	72	,	3.882425274	,	-0.920572603	),
  (	72	,	3.764321949	,	-0.967457209	),
  (	72	,	3.894221817	,	-0.842069972	),
  (	72	,	3.847758379	,	-0.825109231	),
  (	72	,	3.912040941	,	-0.819439358	),
  (	72	,	3.92625083	,	-0.805649164	),
  (	72	,	4.5666527	,	-1.098217692	),
  (	72	,	4.656686859	,	-1.051703611	),
  (	72	,	4.621043346	,	-1.06362151	),
  (	72	,	4.501801531	,	-1.026517627	),
  (	72	,	4.45285361	,	-1.000059308	),
  (	72	,	4.574475403	,	-0.942847209	),
  (	72	,	4.521880214	,	-0.865018168	),
  (	72	,	4.486096699	,	-0.85318606	),
  (	72	,	4.359208773	,	-1.016831995	),
  (	72	,	4.224484549	,	-0.926402684	),
  (	72	,	4.409580157	,	-0.873449084	),
  (	72	,	4.389797391	,	-0.811335553	),
  (	72	,	4.397456906	,	-0.792210895	),
  (	72	,	4.305860233	,	-0.838532755	),
  (	72	,	4.307330114	,	-0.829890403	),
  (	72	,	4.371318239	,	-0.791845458	),
  (	72	,	4.365224608	,	-0.777961996	),
  (	72	,	4.661285971	,	-0.824756444	),
  (	72	,	4.565676993	,	-0.848492408	),
  (	72	,	4.589969854	,	-0.80445841	),
  (	72	,	4.647127033	,	-0.770119698	),
  (	72	,	4.473779515	,	-0.821510161	),
  (	72	,	4.427444686	,	-0.760265383	),
  (	72	,	4.42524711	,	-0.72678913	),
  (	72	,	4.406101817	,	-0.733068606	),
  (	72	,	4.428436098	,	-0.707291888	),
  (	72	,	4.437112014	,	-0.707073824	),
  (	72	,	4.429217701	,	-0.67043771	),
  (	72	,	4.410264724	,	-0.667703215	),
  (	72	,	4.54098097	,	-0.66358507	),
  (	72	,	4.53339379	,	-0.610704661	),
  (	72	,	4.560300302	,	-0.603221928	),
  (	72	,	4.56104071	,	-0.59776276	),
  (	72	,	4.486513179	,	-0.610941456	),
  (	72	,	4.210319373	,	-0.872925541	),
  (	72	,	4.112121434	,	-0.859009121	),
  (	72	,	4.081106126	,	-0.866902416	),
  (	72	,	4.073390318	,	-0.829699751	),
  (	72	,	4.259260819	,	-0.752683883	),
  (	72	,	4.181991695	,	-0.777127293	),
  (	72	,	4.254074747	,	-0.691639592	),
  (	72	,	4.086010714	,	-0.768127962	),
  (	72	,	3.973651878	,	-0.763242215	),
  (	72	,	4.15185171	,	-0.570478861	),
  (	72	,	4.324837252	,	-0.599220655	),
  (	72	,	4.387733874	,	-0.59081169	),
  (	72	,	4.360152955	,	-0.522276216	),
  (	72	,	4.364091727	,	-0.505103679	),
  (	72	,	4.230015244	,	-0.541984856	),
  (	72	,	3.326821771	,	-1.064975409	),
  (	72	,	3.280658667	,	-1.017362735	),
  (	72	,	3.612669965	,	-0.976697338	),
  (	72	,	3.643316689	,	-0.960305143	),
  (	72	,	3.430704212	,	-0.970606833	),
  (	72	,	3.513999054	,	-0.905646785	),
  (	72	,	3.516960438	,	-0.898486168	),
  (	72	,	3.259298669	,	-0.919841101	),
  (	72	,	3.359143793	,	-0.878318651	),
  (	72	,	3.340994344	,	-0.875814538	),
  (	72	,	3.49917068	,	-0.895046224	),
  (	72	,	3.545867592	,	-0.775805474	),
  (	72	,	3.7854402	,	-0.806580591	),
  (	72	,	3.655647711	,	-0.85554536	),
  (	72	,	3.640466489	,	-0.849851739	),
  (	72	,	3.691966372	,	-0.779974038	),
  (	72	,	3.756150786	,	-0.740454156	),
  (	72	,	3.569450686	,	-0.746389702	),
  (	72	,	3.650875965	,	-0.66879724	),
  (	72	,	3.730746528	,	-0.713851126	),
  (	72	,	3.736349829	,	-0.559517241	),
  (	72	,	3.158474426	,	-0.933720181	),
  (	72	,	3.317719294	,	-0.862217606	),
  (	72	,	3.164870899	,	-0.877386705	),
  (	72	,	3.232783386	,	-0.828238149	),
  (	72	,	3.499597054	,	-0.751373259	),
  (	72	,	3.419926748	,	-0.712990047	),
  (	72	,	3.281165619	,	-0.716549545	),
  (	72	,	3.228726892	,	-0.721863719	),
  (	72	,	3.242982935	,	-0.654318302	),
  (	72	,	3.403615268	,	-0.631501701	),
  (	72	,	3.368249404	,	-0.612303493	),
  (	72	,	3.710527447	,	-0.525128541	),
  (	72	,	3.591068243	,	-0.526787528	),
  (	72	,	3.407993122	,	-0.586834653	),
  (	72	,	3.565596505	,	-0.412184004	),
  (	72	,	3.501366575	,	-0.451007468	),
  (	72	,	3.495365618	,	-0.427085056	),
  (	72	,	3.55839283	,	-0.384405815	),
  (	72	,	3.957987308	,	-0.662278311	),
  (	72	,	3.899863799	,	-0.693723222	),
  (	72	,	3.920025784	,	-0.652100889	),
  (	72	,	3.927018832	,	-0.62885689	),
  (	72	,	3.969244647	,	-0.625975997	),
  (	72	,	3.978328981	,	-0.5871107	),
  (	72	,	3.958529663	,	-0.574392143	),
  (	72	,	3.915339312	,	-0.573058767	),
  (	72	,	4.052512463	,	-0.549354642	),
  (	72	,	4.085007725	,	-0.506126476	),
  (	72	,	4.016538649	,	-0.493706611	),
  (	72	,	3.811178192	,	-0.581474216	),
  (	72	,	3.792447143	,	-0.508123853	),
  (	72	,	3.966079437	,	-0.462464698	),
  (	72	,	3.876725381	,	-0.444812071	),
  (	72	,	4.201291262	,	-0.436584885	),
  (	72	,	4.13666761	,	-0.440098409	),
  (	72	,	4.197184726	,	-0.383633065	),
  (	72	,	4.176620277	,	-0.374997279	),
  (	72	,	4.224217007	,	-0.318418459	),
  (	72	,	4.067366693	,	-0.383395838	),
  (	72	,	4.040821722	,	-0.373153783	),
  (	72	,	4.044101141	,	-0.349154426	),
  (	72	,	4.013523376	,	-0.341215619	),
  (	72	,	4.079676123	,	-0.299131987	),
  (	72	,	4.138246554	,	-0.235607119	),
  (	72	,	3.753059896	,	-0.489550434	),
  (	72	,	3.813817129	,	-0.293557745	),
  (	72	,	3.643499993	,	-0.335405887	),
  (	72	,	3.797099549	,	-0.266127211	),
  (	72	,	3.722620562	,	-0.241904158	),
  (	72	,	3.725042583	,	-0.206620867	),
  (	72	,	3.940553543	,	-0.30775791	),
  (	72	,	3.842064023	,	-0.245162768	),
  (	72	,	3.880373004	,	-0.246939589	),
  (	72	,	3.880842069	,	-0.148432435	),
  (	72	,	3.821421062	,	-0.149668136	),
  (	72	,	3.990156136	,	-0.058721115	),
  (	72	,	5.021013711	,	-1.333528316	),
  (	72	,	5.674424031	,	-1.292814375	),
  (	72	,	5.449856099	,	-1.265937215	),
  (	72	,	5.31669992	,	-1.270740224	),
  (	72	,	5.396632798	,	-1.212145027	),
  (	72	,	5.899914713	,	-1.206163079	),
  (	72	,	5.937601269	,	-1.181391506	),
  (	72	,	6.156918698	,	-1.205631409	),
  (	72	,	6.194558085	,	-1.156350347	),
  (	72	,	6.17505685	,	-1.129036395	),
  (	72	,	5.605491292	,	-1.190787255	),
  (	72	,	5.710435308	,	-1.143239394	),
  (	72	,	5.699949233	,	-1.091704267	),
  (	72	,	5.69083987	,	-1.084100282	),
  (	72	,	5.904394877	,	-1.054749301	),
  (	72	,	4.897830119	,	-1.227023897	),
  (	72	,	5.146884458	,	-1.214793463	),
  (	72	,	5.146115169	,	-1.210173836	),
  (	72	,	5.008186574	,	-1.202252863	),
  (	72	,	5.369353609	,	-1.12033229	),
  (	72	,	5.036105878	,	-1.177298285	),
  (	72	,	5.076229958	,	-1.144567674	),
  (	72	,	4.967549029	,	-1.117044828	),
  (	72	,	5.114684796	,	-1.051909451	),
  (	72	,	5.146785189	,	-1.016334792	),
  (	72	,	5.564508178	,	-1.028524203	),
  (	72	,	5.605849624	,	-0.999332226	),
  (	72	,	5.724582094	,	-0.973528064	),
  (	72	,	5.548282981	,	-0.986413119	),
  (	72	,	5.584432404	,	-0.932877371	),
  (	72	,	5.547438805	,	-0.913490417	),
  (	72	,	5.594101703	,	-0.905397712	),
  (	72	,	5.476592383	,	-0.909676467	),
  (	72	,	5.58162405	,	-0.865884175	),
  (	72	,	5.597073722	,	-0.845760147	),
  (	72	,	5.578320412	,	-0.820351709	),
  (	72	,	5.450860446	,	-0.841673802	),
  (	72	,	5.517582881	,	-0.807320577	),
  (	72	,	5.522576972	,	-0.784511764	),
  (	72	,	6.125607436	,	-0.939252415	),
  (	72	,	6.05293124	,	-0.88466469	),
  (	72	,	5.896943673	,	-0.889031132	),
  (	72	,	6.234887582	,	-0.817548481	),
  (	72	,	6.123087159	,	-0.726076332	),
  (	72	,	5.646241508	,	-0.813516216	),
  (	72	,	5.714899915	,	-0.813519894	),
  (	72	,	5.827275353	,	-0.761568189	),
  (	72	,	5.786083028	,	-0.76735919	),
  (	72	,	5.805954731	,	-0.658867225	),
  (	72	,	5.628077238	,	-0.759353597	),
  (	72	,	5.730111183	,	-0.643973629	),
  (	72	,	5.678038312	,	-0.621075378	),
  (	72	,	5.92950399	,	-0.683383079	),
  (	72	,	5.850081415	,	-0.602431604	),
  (	72	,	5.77393477	,	-0.521936007	),
  (	72	,	5.779884114	,	-0.496281989	),
  (	72	,	5.793350296	,	-0.491268388	),
  (	72	,	5.771313641	,	-0.477655055	),
  (	72	,	5.79783132	,	-0.449781384	),
  (	72	,	5.938801687	,	-0.41052945	),
  (	72	,	4.769686965	,	-1.049693102	),
  (	72	,	4.888449591	,	-1.025903798	),
  (	72	,	5.113605252	,	-0.945363258	),
  (	72	,	5.206206075	,	-0.926653039	),
  (	72	,	5.074473084	,	-0.95187848	),
  (	72	,	5.159882926	,	-0.884316542	),
  (	72	,	5.083995824	,	-0.891876683	),
  (	72	,	4.722773821	,	-1.049595461	),
  (	72	,	4.784281642	,	-1.002644846	),
  (	72	,	4.764110958	,	-0.984380641	),
  (	72	,	4.782713684	,	-0.988750031	),
  (	72	,	4.801216892	,	-0.981149951	),
  (	72	,	4.872480247	,	-0.981355194	),
  (	72	,	4.906594106	,	-0.939021322	),
  (	72	,	4.930352491	,	-0.909703457	),
  (	72	,	4.792411968	,	-0.948281373	),
  (	72	,	4.951352857	,	-0.854300247	),
  (	72	,	5.052667952	,	-0.821607629	),
  (	72	,	5.258375904	,	-0.80454628	),
  (	72	,	5.280050998	,	-0.766101446	),
  (	72	,	5.193143659	,	-0.792023914	),
  (	72	,	5.234729634	,	-0.652316192	),
  (	72	,	5.214352505	,	-0.631841636	),
  (	72	,	5.295740287	,	-0.59548067	),
  (	72	,	5.277074391	,	-0.591218281	),
  (	72	,	4.790015876	,	-0.908274818	),
  (	72	,	4.79566899	,	-0.906956449	),
  (	72	,	4.777870354	,	-0.878045006	),
  (	72	,	4.849853952	,	-0.87591308	),
  (	72	,	5.003562167	,	-0.747265416	),
  (	72	,	4.94044168	,	-0.714154659	),
  (	72	,	5.029060126	,	-0.654919959	),
  (	72	,	4.772652343	,	-0.754059567	),
  (	72	,	4.843608357	,	-0.765065738	),
  (	72	,	4.892240533	,	-0.73594525	),
  (	72	,	4.827669883	,	-0.742405499	),
  (	72	,	4.874968616	,	-0.712161685	),
  (	72	,	4.866289697	,	-0.692800686	),
  (	72	,	4.766879676	,	-0.686653522	),
  (	72	,	4.773981917	,	-0.670417287	),
  (	72	,	4.915966298	,	-0.693438206	),
  (	72	,	4.935556595	,	-0.683729567	),
  (	72	,	4.923418573	,	-0.646010246	),
  (	72	,	4.985289379	,	-0.604454044	),
  (	72	,	4.967484081	,	-0.597159277	),
  (	72	,	4.854434741	,	-0.616968629	),
  (	72	,	5.072047778	,	-0.557400176	),
  (	72	,	5.204305802	,	-0.558100783	),
  (	72	,	5.238598058	,	-0.498927934	),
  (	72	,	5.068698366	,	-0.516714137	),
  (	72	,	5.070479056	,	-0.515276734	),
  (	72	,	4.916533172	,	-0.517174259	),
  (	72	,	5.035007992	,	-0.469090189	),
  (	72	,	5.430953043	,	-0.625308461	),
  (	72	,	5.498716067	,	-0.597502945	),
  (	72	,	5.580914167	,	-0.564724139	),
  (	72	,	5.536947031	,	-0.497044722	),
  (	72	,	5.343814438	,	-0.507510551	),
  (	72	,	5.528615303	,	-0.404019978	),
  (	72	,	5.822012756	,	-0.367823282	),
  (	72	,	5.822165304	,	-0.335963601	),
  (	72	,	5.786752568	,	-0.259983831	),
  (	72	,	5.634912159	,	-0.335760233	),
  (	72	,	5.509802225	,	-0.335955825	),
  (	72	,	5.577469476	,	-0.304774323	),
  (	72	,	5.458092674	,	-0.371980275	),
  (	72	,	5.46405286	,	-0.342846933	),
  (	72	,	5.325325798	,	-0.342913194	),
  (	72	,	5.416276298	,	-0.3033121	),
  (	72	,	5.377917115	,	-0.289893138	),
  (	72	,	5.37024451	,	-0.275262504	),
  (	72	,	5.341715184	,	-0.246337682	),
  (	72	,	5.301938221	,	-0.233597141	),
  (	72	,	5.43039619	,	-0.247590998	),
  (	72	,	5.585721553	,	-0.235659385	),
  (	72	,	5.605118022	,	-0.117210997	),
  (	72	,	5.596470832	,	-0.098323033	),
  (	72	,	5.401493209	,	-0.192567919	),
  (	72	,	5.343943336	,	-0.153055881	),
  (	72	,	5.563510606	,	-0.096903592	),
  (	72	,	5.446555225	,	-0.080993802	),
  (	72	,	5.513019467	,	-0.040534136	),
  (	73	,	0.894816889	,	0.191572922	),
  (	73	,	0.872083114	,	0.233472682	),
  (	73	,	0.62907727	,	0.179286124	),
  (	73	,	0.776298546	,	0.310901263	),
  (	73	,	0.998919555	,	0.287259803	),
  (	73	,	0.911074838	,	0.359957069	),
  (	73	,	0.956530457	,	0.38123128	),
  (	73	,	0.992252427	,	0.417384452	),
  (	73	,	0.973489622	,	0.448222538	),
  (	73	,	0.643744475	,	0.290479111	),
  (	73	,	0.55879597	,	0.275838167	),
  (	73	,	0.532847987	,	0.385783014	),
  (	73	,	0.552872399	,	0.450833134	),
  (	73	,	0.886112167	,	0.469507241	),
  (	73	,	0.631337952	,	0.510418949	),
  (	73	,	0.63494458	,	0.521505373	),
  (	73	,	1.152992453	,	0.379363508	),
  (	73	,	1.179731265	,	0.411703256	),
  (	73	,	1.230753337	,	0.419065839	),
  (	73	,	1.149777129	,	0.425949562	),
  (	73	,	1.215156142	,	0.470170468	),
  (	73	,	1.24718948	,	0.500220386	),
  (	73	,	1.262165799	,	0.516115082	),
  (	73	,	1.153727146	,	0.598902114	),
  (	73	,	1.132294532	,	0.663195108	),
  (	73	,	1.184263642	,	0.69828865	),
  (	73	,	1.452500272	,	0.633895087	),
  (	73	,	1.380916328	,	0.629571537	),
  (	73	,	1.3594653	,	0.627575467	),
  (	73	,	1.324869286	,	0.650457455	),
  (	73	,	1.366689873	,	0.701508801	),
  (	73	,	1.446203482	,	0.668797229	),
  (	73	,	1.400243208	,	0.713574684	),
  (	73	,	1.330714285	,	0.730948535	),
  (	73	,	1.288260177	,	0.757774306	),
  (	73	,	1.315423416	,	0.774888346	),
  (	73	,	1.366307235	,	0.777840481	),
  (	73	,	1.519493648	,	0.815446324	),
  (	73	,	1.498621391	,	0.916104757	),
  (	73	,	0.998009316	,	0.598828012	),
  (	73	,	1.097156032	,	0.714068556	),
  (	73	,	1.052783903	,	0.699775264	),
  (	73	,	1.082248999	,	0.753608147	),
  (	73	,	1.113673124	,	0.781343785	),
  (	73	,	0.857613411	,	0.674282153	),
  (	73	,	0.909768859	,	0.701113826	),
  (	73	,	0.964005986	,	0.718890701	),
  (	73	,	0.921802575	,	0.728263346	),
  (	73	,	0.925709403	,	0.746115538	),
  (	73	,	0.808600425	,	0.717696121	),
  (	73	,	0.90997836	,	0.763643657	),
  (	73	,	0.952580319	,	0.781933588	),
  (	73	,	0.907268645	,	0.833145951	),
  (	73	,	1.334800953	,	0.873466125	),
  (	73	,	1.361038827	,	0.932915845	),
  (	73	,	1.054276087	,	0.940137626	),
  (	73	,	1.139088087	,	0.98981476	),
  (	73	,	1.225334385	,	1.010188743	),
  (	73	,	1.406481473	,	1.034560372	),
  (	73	,	1.49134373	,	1.104696099	),
  (	73	,	0.354518935	,	0.390512622	),
  (	73	,	0.371827312	,	0.498563791	),
  (	73	,	0.519753155	,	0.579575698	),
  (	73	,	0.446808588	,	0.575291374	),
  (	73	,	0.274186654	,	0.459013774	),
  (	73	,	0.324406518	,	0.533057058	),
  (	73	,	0.2821904	,	0.579151549	),
  (	73	,	0.483830787	,	0.625611776	),
  (	73	,	0.368238187	,	0.643736193	),
  (	73	,	0.61036804	,	0.546931076	),
  (	73	,	0.633830186	,	0.647845267	),
  (	73	,	0.604771233	,	0.7029962	),
  (	73	,	0.662515473	,	0.66534902	),
  (	73	,	0.651396461	,	0.667155983	),
  (	73	,	0.623540033	,	0.723960381	),
  (	73	,	0.668270923	,	0.748672068	),
  (	73	,	0.700818862	,	0.769535843	),
  (	73	,	0.500173238	,	0.70957937	),
  (	73	,	0.432412874	,	0.718395391	),
  (	73	,	0.602962857	,	0.840343707	),
  (	73	,	0.522601796	,	0.863563516	),
  (	73	,	0.495168625	,	0.862975219	),
  (	73	,	0.509934637	,	0.916112561	),
  (	73	,	0.279161793	,	0.619058765	),
  (	73	,	0.157567347	,	0.667621455	),
  (	73	,	0.376485029	,	0.738468136	),
  (	73	,	0.35037759	,	0.759397276	),
  (	73	,	0.214975909	,	0.717009377	),
  (	73	,	0.234254426	,	0.756818493	),
  (	73	,	0.254265455	,	0.795817419	),
  (	73	,	0.137088535	,	0.680338832	),
  (	73	,	0.054971324	,	0.77346719	),
  (	73	,	0.100584954	,	0.777111939	),
  (	73	,	0.158554382	,	0.779095199	),
  (	73	,	0.186815556	,	0.801619953	),
  (	73	,	0.191940298	,	0.856440527	),
  (	73	,	0.058224538	,	0.867835663	),
  (	73	,	0.390282103	,	0.73795116	),
  (	73	,	0.363470158	,	0.791205992	),
  (	73	,	0.310883534	,	0.81384295	),
  (	73	,	0.318343988	,	0.823712075	),
  (	73	,	0.279087736	,	0.852785695	),
  (	73	,	0.325494448	,	0.862709058	),
  (	73	,	0.252770691	,	0.909957608	),
  (	73	,	0.250177799	,	0.911758599	),
  (	73	,	0.420918199	,	0.954627128	),
  (	73	,	0.353746943	,	0.953449039	),
  (	73	,	0.339639051	,	0.967704401	),
  (	73	,	0.323654203	,	1.026463171	),
  (	73	,	0.155279809	,	0.933557474	),
  (	73	,	0.28039584	,	0.996872236	),
  (	73	,	0.175997453	,	1.037842068	),
  (	73	,	0.262007008	,	1.056095943	),
  (	73	,	0.005935575	,	1.061844251	),
  (	73	,	0.133927277	,	1.088282353	),
  (	73	,	0.838576531	,	0.809584868	),
  (	73	,	0.766046709	,	0.825617891	),
  (	73	,	0.915711202	,	0.858933459	),
  (	73	,	0.874390624	,	0.900907164	),
  (	73	,	0.795904431	,	0.948815443	),
  (	73	,	0.917249699	,	0.966476597	),
  (	73	,	0.687670493	,	0.876807107	),
  (	73	,	0.726919608	,	0.943834049	),
  (	73	,	0.701108874	,	1.000221437	),
  (	73	,	0.789309548	,	1.041365351	),
  (	73	,	0.754680528	,	1.05542333	),
  (	73	,	0.770109182	,	1.09274311	),
  (	73	,	1.053092	,	0.978079937	),
  (	73	,	1.210998532	,	1.048774534	),
  (	73	,	1.124569265	,	1.08815393	),
  (	73	,	1.461395797	,	1.135306931	),
  (	73	,	1.223260822	,	1.126733724	),
  (	73	,	1.280319981	,	1.1520264	),
  (	73	,	1.090991137	,	1.193342596	),
  (	73	,	1.001984844	,	1.172255765	),
  (	73	,	1.007971836	,	1.206067947	),
  (	73	,	1.429673809	,	1.301263091	),
  (	73	,	1.352728432	,	1.320892163	),
  (	73	,	0.422422443	,	1.040666783	),
  (	73	,	0.389448483	,	1.047820048	),
  (	73	,	0.406807219	,	1.059178055	),
  (	73	,	0.40820784	,	1.091293549	),
  (	73	,	0.593077032	,	1.103681384	),
  (	73	,	0.605388013	,	1.124427171	),
  (	73	,	0.62154525	,	1.138685123	),
  (	73	,	0.588676284	,	1.157519716	),
  (	73	,	0.750971727	,	1.145551009	),
  (	73	,	0.681910138	,	1.178327907	),
  (	73	,	0.708507664	,	1.187945963	),
  (	73	,	0.499912282	,	1.189461753	),
  (	73	,	0.59645168	,	1.174325336	),
  (	73	,	0.498891321	,	1.207454767	),
  (	73	,	0.458181472	,	1.21304863	),
  (	73	,	0.508449769	,	1.225287194	),
  (	73	,	0.287469786	,	1.151411097	),
  (	73	,	0.13209764	,	1.130082987	),
  (	73	,	0.008623319	,	1.159559316	),
  (	73	,	0.36710763	,	1.27142251	),
  (	73	,	0.355697001	,	1.301668519	),
  (	73	,	0.17639428	,	1.234089501	),
  (	73	,	0.898125247	,	1.277702764	),
  (	73	,	0.706590555	,	1.250116225	),
  (	73	,	1.278206538	,	1.321369305	),
  (	73	,	1.457504494	,	1.393691328	),
  (	73	,	0.526390927	,	1.325625518	),
  (	73	,	0.457020012	,	1.324217201	),
  (	73	,	0.212846975	,	1.369509617	),
  (	73	,	0.040814733	,	1.39128172	),
  (	73	,	0.345263255	,	1.411305012	),
  (	73	,	0.011755543	,	1.448155317	),
  (	73	,	0.764891051	,	1.398125256	),
  (	73	,	0.888013546	,	1.433783812	),
  (	73	,	0.83728352	,	1.446942268	),
  (	73	,	0.166839365	,	1.477855233	),
  (	73	,	2.329430881	,	0.031834739	),
  (	73	,	2.376530054	,	0.061803722	),
  (	73	,	2.414718666	,	0.066751138	),
  (	73	,	2.414579686	,	0.10149982	),
  (	73	,	2.364128969	,	0.098638368	),
  (	73	,	2.434066227	,	0.138685029	),
  (	73	,	2.218988178	,	0.121550239	),
  (	73	,	2.546473732	,	0.2346006	),
  (	73	,	2.651393904	,	0.264540575	),
  (	73	,	2.718292484	,	0.333898841	),
  (	73	,	2.644951557	,	0.375502945	),
  (	73	,	2.59014173	,	0.447975375	),
  (	73	,	2.527297006	,	0.44274621	),
  (	73	,	2.068037574	,	0.279882126	),
  (	73	,	2.097393201	,	0.3184441	),
  (	73	,	2.109968765	,	0.354970834	),
  (	73	,	2.08172144	,	0.365942015	),
  (	73	,	2.063925022	,	0.389810933	),
  (	73	,	2.223842019	,	0.424892583	),
  (	73	,	2.343478629	,	0.381536246	),
  (	73	,	2.331557966	,	0.469906002	),
  (	73	,	2.321986942	,	0.521044576	),
  (	73	,	2.281010655	,	0.55610225	),
  (	73	,	2.295438739	,	0.586197134	),
  (	73	,	2.284477762	,	0.640794394	),
  (	73	,	2.326473971	,	0.646980857	),
  (	73	,	2.851782101	,	0.457409506	),
  (	73	,	2.893718689	,	0.504925697	),
  (	73	,	2.919246837	,	0.524303026	),
  (	73	,	2.88773292	,	0.521354433	),
  (	73	,	2.577636144	,	0.547907251	),
  (	73	,	2.724328277	,	0.596488167	),
  (	73	,	2.965705586	,	0.664977409	),
  (	73	,	3.125790548	,	0.733279712	),
  (	73	,	2.931330454	,	0.747531433	),
  (	73	,	3.107724245	,	0.871475685	),
  (	73	,	3.012864732	,	0.854087766	),
  (	73	,	2.570199916	,	0.594895581	),
  (	73	,	2.528393959	,	0.615108154	),
  (	73	,	2.738997501	,	0.719701471	),
  (	73	,	2.632867269	,	0.733204607	),
  (	73	,	2.538673428	,	0.761611248	),
  (	73	,	2.662839783	,	0.864060675	),
  (	73	,	2.793068007	,	0.817522046	),
  (	73	,	2.809721109	,	0.869190577	),
  (	73	,	2.886736923	,	0.919827278	),
  (	73	,	2.798173568	,	0.924509779	),
  (	73	,	2.920177743	,	1.0101353	),
  (	73	,	2.894442761	,	1.076061806	),
  (	73	,	3.043924421	,	1.094552831	),
  (	73	,	1.966324993	,	0.357646554	),
  (	73	,	1.905935911	,	0.428237741	),
  (	73	,	1.874422381	,	0.449028388	),
  (	73	,	1.882695007	,	0.531847977	),
  (	73	,	1.879374609	,	0.569303638	),
  (	73	,	1.88199319	,	0.577910164	),
  (	73	,	1.972312753	,	0.62138881	),
  (	73	,	1.91955453	,	0.586679613	),
  (	73	,	1.916815951	,	0.602961122	),
  (	73	,	1.938568537	,	0.633740655	),
  (	73	,	1.997544653	,	0.678562466	),
  (	73	,	2.179600129	,	0.611661563	),
  (	73	,	2.130670189	,	0.672384202	),
  (	73	,	2.287501581	,	0.734797485	),
  (	73	,	2.21126704	,	0.696248641	),
  (	73	,	2.076558064	,	0.685683301	),
  (	73	,	1.713697869	,	0.611959932	),
  (	73	,	1.696273115	,	0.636669486	),
  (	73	,	1.771443038	,	0.680157966	),
  (	73	,	1.748411158	,	0.70107543	),
  (	73	,	1.800331257	,	0.696891489	),
  (	73	,	1.677639038	,	0.651296961	),
  (	73	,	1.641054152	,	0.656880561	),
  (	73	,	1.656879515	,	0.670817759	),
  (	73	,	1.71782451	,	0.688460119	),
  (	73	,	1.685813167	,	0.732331315	),
  (	73	,	1.714013146	,	0.818957321	),
  (	73	,	1.677242056	,	0.891464716	),
  (	73	,	1.983583158	,	0.841098279	),
  (	73	,	1.965928103	,	0.853102913	),
  (	73	,	1.893145501	,	0.8464646	),
  (	73	,	1.808786743	,	0.873444608	),
  (	73	,	2.056527594	,	0.955257152	),
  (	73	,	1.773015556	,	0.879300699	),
  (	73	,	1.718976698	,	0.915614766	),
  (	73	,	1.768193135	,	0.926523965	),
  (	73	,	1.64665988	,	1.002067461	),
  (	73	,	1.74413292	,	1.013944937	),
  (	73	,	1.772466714	,	1.037478759	),
  (	73	,	1.766536187	,	1.037587159	),
  (	73	,	1.676277382	,	1.048673462	),
  (	73	,	1.667378377	,	1.077900797	),
  (	73	,	2.391557019	,	0.827702297	),
  (	73	,	2.343956999	,	0.885605832	),
  (	73	,	2.334188868	,	0.921436704	),
  (	73	,	2.573310804	,	0.923116853	),
  (	73	,	2.220351567	,	0.940066282	),
  (	73	,	2.220603166	,	0.989025567	),
  (	73	,	2.412205575	,	0.993820928	),
  (	73	,	2.399018765	,	1.032426383	),
  (	73	,	2.275089475	,	1.030975993	),
  (	73	,	2.230183285	,	1.045667419	),
  (	73	,	2.31119085	,	1.121632011	),
  (	73	,	2.569254096	,	1.048882732	),
  (	73	,	2.663234888	,	1.098064059	),
  (	73	,	2.949725377	,	1.132850875	),
  (	73	,	3.007010266	,	1.177371516	),
  (	73	,	3.103772984	,	1.201372864	),
  (	73	,	2.754639389	,	1.157371526	),
  (	73	,	2.640733372	,	1.174250796	),
  (	73	,	2.422896016	,	1.171786794	),
  (	73	,	2.516231406	,	1.215382069	),
  (	73	,	3.074876968	,	1.276652563	),
  (	73	,	2.818121371	,	1.261662481	),
  (	73	,	2.754902844	,	1.279862289	),
  (	73	,	2.074813084	,	1.082871671	),
  (	73	,	2.007026246	,	1.039575893	),
  (	73	,	2.096131918	,	1.130048104	),
  (	73	,	2.02141389	,	1.210142688	),
  (	73	,	2.18514856	,	1.178565145	),
  (	73	,	2.069692061	,	1.240562477	),
  (	73	,	1.756181712	,	1.155365423	),
  (	73	,	1.58070854	,	1.167618683	),
  (	73	,	1.84813902	,	1.252422294	),
  (	73	,	1.872263289	,	1.255927413	),
  (	73	,	1.850291405	,	1.312937057	),
  (	73	,	2.432637854	,	1.219522619	),
  (	73	,	2.348727117	,	1.233152112	),
  (	73	,	2.404375873	,	1.24554689	),
  (	73	,	2.5217752	,	1.27547665	),
  (	73	,	2.294874696	,	1.279197715	),
  (	73	,	2.923565697	,	1.357633732	),
  (	73	,	2.927360351	,	1.426465005	),
  (	73	,	2.229069571	,	1.365340612	),
  (	73	,	3.953035187	,	0.073888849	),
  (	73	,	3.954489466	,	0.096871502	),
  (	73	,	3.928349839	,	0.133487046	),
  (	73	,	4.017389235	,	0.155569798	),
  (	73	,	4.096402216	,	0.185279335	),
  (	73	,	4.042637234	,	0.175160684	),
  (	73	,	4.035296136	,	0.19184542	),
  (	73	,	4.008569585	,	0.181996837	),
  (	73	,	3.817969554	,	0.228560547	),
  (	73	,	3.965155806	,	0.217972665	),
  (	73	,	3.997322785	,	0.235097071	),
  (	73	,	3.917363217	,	0.262822187	),
  (	73	,	4.122471654	,	0.292120905	),
  (	73	,	4.299026964	,	0.335792559	),
  (	73	,	4.244885599	,	0.333384254	),
  (	73	,	4.026360328	,	0.330207554	),
  (	73	,	4.021127154	,	0.424870632	),
  (	73	,	4.206442093	,	0.440862825	),
  (	73	,	3.746319887	,	0.183442039	),
  (	73	,	3.682287765	,	0.222109457	),
  (	73	,	3.678046238	,	0.261369445	),
  (	73	,	3.66982355	,	0.38355401	),
  (	73	,	3.730909164	,	0.347326481	),
  (	73	,	3.745281903	,	0.371826646	),
  (	73	,	3.895935019	,	0.461901794	),
  (	73	,	4.095886978	,	0.550683299	),
  (	73	,	4.040413466	,	0.566776279	),
  (	73	,	3.998317064	,	0.646988881	),
  (	73	,	3.851332277	,	0.641525433	),
  (	73	,	3.931404461	,	0.699598676	),
  (	73	,	4.284199986	,	0.380697145	),
  (	73	,	4.35379776	,	0.471999917	),
  (	73	,	4.313275711	,	0.50746831	),
  (	73	,	4.413319105	,	0.490821484	),
  (	73	,	4.360855426	,	0.509958125	),
  (	73	,	4.191963254	,	0.559195907	),
  (	73	,	4.323700986	,	0.540019961	),
  (	73	,	4.348171678	,	0.6290121	),
  (	73	,	4.451318909	,	0.599318236	),
  (	73	,	4.425783931	,	0.757584934	),
  (	73	,	4.13534008	,	0.5761698	),
  (	73	,	4.084162959	,	0.694695093	),
  (	73	,	4.043604716	,	0.795944743	),
  (	73	,	4.352428324	,	0.760350162	),
  (	73	,	4.297005533	,	0.779987012	),
  (	73	,	4.383290824	,	0.870265453	),
  (	73	,	4.359088985	,	0.887152227	),
  (	73	,	4.404290164	,	0.923572573	),
  (	73	,	4.587803877	,	0.948688865	),
  (	73	,	4.613055449	,	0.972869596	),
  (	73	,	4.300191358	,	0.892532207	),
  (	73	,	4.398298611	,	1.003375489	),
  (	73	,	4.475350739	,	0.979753296	),
  (	73	,	4.502555098	,	1.01173251	),
  (	73	,	4.424551119	,	1.053518355	),
  (	73	,	4.604072678	,	1.09016173	),
  (	73	,	3.676205475	,	0.552587426	),
  (	73	,	3.401427807	,	0.489837511	),
  (	73	,	3.486426333	,	0.498616157	),
  (	73	,	3.350209064	,	0.51543486	),
  (	73	,	3.763954422	,	0.567289865	),
  (	73	,	3.694399295	,	0.607000082	),
  (	73	,	3.675399659	,	0.630260248	),
  (	73	,	3.909524886	,	0.717973656	),
  (	73	,	3.747895779	,	0.733115862	),
  (	73	,	3.615940138	,	0.73892481	),
  (	73	,	3.725622449	,	0.808527796	),
  (	73	,	3.770298661	,	0.864504225	),
  (	73	,	3.659785803	,	0.813257285	),
  (	73	,	3.316745534	,	0.596313885	),
  (	73	,	3.214469643	,	0.691029424	),
  (	73	,	3.297748304	,	0.692608541	),
  (	73	,	3.30975693	,	0.789182794	),
  (	73	,	3.652095723	,	0.952699973	),
  (	73	,	3.314265007	,	1.062635582	),
  (	73	,	3.148656201	,	1.133402412	),
  (	73	,	4.095617249	,	0.975624313	),
  (	73	,	3.884341082	,	0.914814759	),
  (	73	,	3.879473214	,	0.946517754	),
  (	73	,	3.837119056	,	0.932703208	),
  (	73	,	3.965075584	,	1.126576777	),
  (	73	,	4.292570923	,	1.076813318	),
  (	73	,	4.533110777	,	1.112171939	),
  (	73	,	4.394205135	,	1.174023112	),
  (	73	,	4.215377541	,	1.129011276	),
  (	73	,	4.095243543	,	1.148252302	),
  (	73	,	4.122286206	,	1.198700473	),
  (	73	,	4.552071795	,	1.254368423	),
  (	73	,	4.300006344	,	1.245892005	),
  (	73	,	4.366416947	,	1.268360097	),
  (	73	,	3.688296765	,	0.98647259	),
  (	73	,	3.550707191	,	1.051767446	),
  (	73	,	3.862717294	,	1.140227648	),
  (	73	,	3.658563151	,	1.132611941	),
  (	73	,	3.757371569	,	1.183384822	),
  (	73	,	3.706379313	,	1.214583306	),
  (	73	,	3.269795282	,	1.167518897	),
  (	73	,	3.157264885	,	1.204625232	),
  (	73	,	3.399438952	,	1.232147432	),
  (	73	,	3.288666601	,	1.312707594	),
  (	73	,	4.634701456	,	1.401193448	),
  (	73	,	3.781768665	,	1.370075416	),
  (	73	,	3.212273508	,	1.398445823	),
  (	73	,	3.58516745	,	1.399819799	),
  (	73	,	3.293626346	,	1.496310727	),
  (	73	,	5.454062179	,	0.042477092	),
  (	73	,	5.528692374	,	0.095007369	),
  (	73	,	5.556495275	,	0.125978062	),
  (	73	,	5.446993624	,	0.132542598	),
  (	73	,	5.509446059	,	0.203454656	),
  (	73	,	5.659708491	,	0.204545003	),
  (	73	,	5.61422413	,	0.238904104	),
  (	73	,	5.716559158	,	0.339013636	),
  (	73	,	5.749355276	,	0.354340712	),
  (	73	,	5.65138106	,	0.373571311	),
  (	73	,	5.577099352	,	0.385961821	),
  (	73	,	5.574330322	,	0.393420845	),
  (	73	,	5.695678605	,	0.471230765	),
  (	73	,	5.343304525	,	0.281759345	),
  (	73	,	5.218532071	,	0.262619738	),
  (	73	,	5.247178265	,	0.272062524	),
  (	73	,	5.384432879	,	0.317395998	),
  (	73	,	5.367418343	,	0.339119492	),
  (	73	,	5.335241156	,	0.346444171	),
  (	73	,	5.413124078	,	0.382698701	),
  (	73	,	5.376681262	,	0.364067082	),
  (	73	,	5.359017085	,	0.386194196	),
  (	73	,	5.209949921	,	0.266895813	),
  (	73	,	5.186800886	,	0.329291325	),
  (	73	,	5.184488843	,	0.397286494	),
  (	73	,	5.274011932	,	0.386641292	),
  (	73	,	5.307665243	,	0.390890461	),
  (	73	,	5.334352164	,	0.458985775	),
  (	73	,	5.213528898	,	0.434387943	),
  (	73	,	5.513042151	,	0.418812347	),
  (	73	,	5.512323167	,	0.477022239	),
  (	73	,	5.568838632	,	0.459899848	),
  (	73	,	5.580820172	,	0.519114813	),
  (	73	,	5.341364457	,	0.506189044	),
  (	73	,	5.477696973	,	0.570533354	),
  (	73	,	5.560312004	,	0.598548101	),
  (	73	,	5.57361512	,	0.600765644	),
  (	73	,	5.414155683	,	0.611558095	),
  (	73	,	5.460766596	,	0.663041194	),
  (	73	,	5.504058383	,	0.708915347	),
  (	73	,	5.940352095	,	0.416199497	),
  (	73	,	5.938479004	,	0.439996887	),
  (	73	,	5.947062991	,	0.488492431	),
  (	73	,	5.967862548	,	0.525859464	),
  (	73	,	5.80865022	,	0.484094464	),
  (	73	,	5.764783439	,	0.468275275	),
  (	73	,	5.843019011	,	0.503489457	),
  (	73	,	5.762886066	,	0.548902102	),
  (	73	,	5.737359402	,	0.564417071	),
  (	73	,	5.790390811	,	0.602520713	),
  (	73	,	5.94679212	,	0.653578199	),
  (	73	,	5.843466194	,	0.584803314	),
  (	73	,	5.843812592	,	0.60278979	),
  (	73	,	5.914306912	,	0.690903138	),
  (	73	,	6.014613563	,	0.615785392	),
  (	73	,	6.060444293	,	0.679197203	),
  (	73	,	6.16750536	,	0.726725604	),
  (	73	,	6.167164488	,	0.74783743	),
  (	73	,	6.048270922	,	0.729368349	),
  (	73	,	6.064965271	,	0.837048935	),
  (	73	,	6.104864753	,	0.85380617	),
  (	73	,	6.187250617	,	0.855136449	),
  (	73	,	5.742999442	,	0.582338091	),
  (	73	,	5.737679145	,	0.606906962	),
  (	73	,	5.660793363	,	0.616578316	),
  (	73	,	5.629124961	,	0.619109914	),
  (	73	,	5.728169925	,	0.67780543	),
  (	73	,	5.599420459	,	0.686780412	),
  (	73	,	5.597310992	,	0.714404695	),
  (	73	,	5.547378638	,	0.718815683	),
  (	73	,	5.638487063	,	0.807341467	),
  (	73	,	5.630062468	,	0.844577187	),
  (	73	,	5.711904777	,	0.86702904	),
  (	73	,	5.781939594	,	0.902336114	),
  (	73	,	5.939192295	,	0.785551384	),
  (	73	,	5.947525974	,	0.823248789	),
  (	73	,	5.906312143	,	0.812716569	),
  (	73	,	5.952831232	,	0.862403046	),
  (	73	,	5.985391097	,	0.925521218	),
  (	73	,	6.049905896	,	0.891464843	),
  (	73	,	6.242313115	,	0.945932212	),
  (	73	,	6.20033639	,	1.009475113	),
  (	73	,	6.211064985	,	1.013750748	),
  (	73	,	5.870424824	,	0.879672376	),
  (	73	,	5.818045212	,	0.927716103	),
  (	73	,	5.984570465	,	1.02989264	),
  (	73	,	5.142780852	,	0.402164086	),
  (	73	,	5.123566082	,	0.442482722	),
  (	73	,	5.149702303	,	0.47115666	),
  (	73	,	5.112096906	,	0.471004018	),
  (	73	,	5.204737588	,	0.50601734	),
  (	73	,	5.226860971	,	0.5039516	),
  (	73	,	5.129233263	,	0.545880908	),
  (	73	,	5.154210837	,	0.536188296	),
  (	73	,	5.194294121	,	0.536972267	),
  (	73	,	5.229644349	,	0.580806934	),
  (	73	,	5.080217541	,	0.541877458	),
  (	73	,	4.961472272	,	0.558522654	),
  (	73	,	5.021143505	,	0.552129437	),
  (	73	,	5.078025007	,	0.690987921	),
  (	73	,	5.298244709	,	0.558466017	),
  (	73	,	5.316292396	,	0.56042932	),
  (	73	,	5.284353919	,	0.56351337	),
  (	73	,	5.288489804	,	0.60176956	),
  (	73	,	5.294196166	,	0.621335393	),
  (	73	,	5.268253001	,	0.623401126	),
  (	73	,	5.261888049	,	0.622594455	),
  (	73	,	5.264268386	,	0.632262116	),
  (	73	,	5.236822183	,	0.635547429	),
  (	73	,	5.308178511	,	0.633137884	),
  (	73	,	5.318287478	,	0.668104285	),
  (	73	,	5.445396527	,	0.685699252	),
  (	73	,	5.450330263	,	0.749704795	),
  (	73	,	5.33766462	,	0.711379044	),
  (	73	,	5.379344046	,	0.7313213	),
  (	73	,	5.356471331	,	0.733655537	),
  (	73	,	5.369430049	,	0.773446954	),
  (	73	,	5.217425862	,	0.704967898	),
  (	73	,	5.258556997	,	0.712331564	),
  (	73	,	5.244096808	,	0.713120304	),
  (	73	,	5.270978992	,	0.739758333	),
  (	73	,	5.145755726	,	0.775553694	),
  (	73	,	5.303164489	,	0.767955587	),
  (	73	,	5.254512406	,	0.895139816	),
  (	73	,	5.235536368	,	0.91018721	),
  (	73	,	4.923951686	,	0.589465174	),
  (	73	,	4.918597502	,	0.595127818	),
  (	73	,	4.894210097	,	0.595134959	),
  (	73	,	4.939391218	,	0.654786521	),
  (	73	,	4.936799759	,	0.674166134	),
  (	73	,	4.876105859	,	0.659398646	),
  (	73	,	5.049018029	,	0.720205777	),
  (	73	,	5.066020317	,	0.745023304	),
  (	73	,	4.933693622	,	0.767204516	),
  (	73	,	4.954784782	,	0.82799117	),
  (	73	,	4.823153787	,	0.670920907	),
  (	73	,	4.790084517	,	0.703430206	),
  (	73	,	4.866159562	,	0.725745113	),
  (	73	,	4.732017671	,	0.748059172	),
  (	73	,	4.733391726	,	0.749756513	),
  (	73	,	4.837151957	,	0.810239129	),
  (	73	,	4.812720732	,	0.80919041	),
  (	73	,	4.716998197	,	0.845882617	),
  (	73	,	5.134002585	,	0.846766669	),
  (	73	,	4.979027757	,	0.838375292	),
  (	73	,	4.919618719	,	0.862750191	),
  (	73	,	4.932134382	,	0.947728805	),
  (	73	,	4.828655918	,	1.042058895	),
  (	73	,	4.849035209	,	1.091500374	),
  (	73	,	4.713550243	,	1.109183617	),
  (	73	,	5.482111026	,	0.766208339	),
  (	73	,	5.494293339	,	0.781744748	),
  (	73	,	5.472039111	,	0.787320669	),
  (	73	,	5.529303916	,	0.833122024	),
  (	73	,	5.426820737	,	0.808401712	),
  (	73	,	5.435471669	,	0.884426787	),
  (	73	,	5.498270458	,	0.849616914	),
  (	73	,	5.530974983	,	0.900312401	),
  (	73	,	5.458805423	,	0.914478645	),
  (	73	,	5.622260557	,	0.880435726	),
  (	73	,	5.582470389	,	0.913232547	),
  (	73	,	5.681461279	,	0.912671044	),
  (	73	,	5.726913576	,	0.960626471	),
  (	73	,	5.558939836	,	0.919995053	),
  (	73	,	5.607145417	,	1.013786451	),
  (	73	,	5.396739799	,	0.871087615	),
  (	73	,	5.383336739	,	0.921997166	),
  (	73	,	5.412910916	,	0.961797929	),
  (	73	,	5.295682329	,	0.927228201	),
  (	73	,	5.295346548	,	0.936528925	),
  (	73	,	5.343525548	,	0.96766212	),
  (	73	,	5.514719923	,	0.963949919	),
  (	73	,	5.817044474	,	1.034973135	),
  (	73	,	5.797808514	,	1.06504181	),
  (	73	,	5.765655754	,	1.08165443	),
  (	73	,	6.060517525	,	1.097959896	),
  (	73	,	6.073862728	,	1.129563316	),
  (	73	,	6.076223541	,	1.13101717	),
  (	73	,	6.08644205	,	1.141854817	),
  (	73	,	6.154629413	,	1.123858203	),
  (	73	,	6.108845751	,	1.131818731	),
  (	73	,	6.180537719	,	1.184184765	),
  (	73	,	5.981254787	,	1.164794177	),
  (	73	,	6.10263853	,	1.188758172	),
  (	73	,	5.854513903	,	1.164245018	),
  (	73	,	5.738804936	,	1.147106109	),
  (	73	,	5.599983217	,	1.135058079	),
  (	73	,	5.648974289	,	1.16539396	),
  (	73	,	5.888352418	,	1.229337696	),
  (	73	,	5.181473982	,	0.993275095	),
  (	73	,	5.21350892	,	1.040265997	),
  (	73	,	5.184281413	,	1.071827549	),
  (	73	,	5.332983364	,	1.213220143	),
  (	73	,	5.315286814	,	1.235450755	),
  (	73	,	4.822201977	,	1.131651286	),
  (	73	,	5.12866413	,	1.218337825	),
  (	73	,	5.049993717	,	1.245236643	),
  (	73	,	5.294211597	,	1.272294216	),
  (	73	,	5.462170755	,	1.302695583	),
  (	73	,	6.05448073	,	1.406199453	),
  (	73	,	4.817894802	,	1.353706024	),
  (	73	,	4.826526742	,	1.389785646	),
  (	73	,	4.75675506	,	1.44757703	),
  (	73	,	5.387719298	,	1.43137268	),
  (	73	,	5.970062036	,	1.479619853	),
  (	73	,	6.14227537	,	1.510741247	),
  (	73	,	5.451434081	,	1.465073148	),
  (	73	,	5.283719051	,	1.475585319	),
  (	73	,	5.273413914	,	1.485695445	),
  (	73	,	0.008759995	,	-0.661516846	),
  (	73	,	0.008379971	,	-0.649790566	),
  (	73	,	0.022553727	,	-0.566693275	),
  (	73	,	6.247932907	,	-0.578088352	),
  (	73	,	0.04634245	,	-0.545894837	),
  (	73	,	6.200905801	,	-0.559745337	),
  (	73	,	6.262122243	,	-0.373149455	),
  (	73	,	0.241648665	,	-0.430403994	),
  (	73	,	0.163063008	,	-0.432263299	),
  (	73	,	0.215817361	,	-0.405118882	),
  (	73	,	0.214252461	,	-0.369161452	),
  (	73	,	0.256262088	,	-0.342656814	),
  (	73	,	0.139970567	,	-0.318036001	),
  (	73	,	0.110758162	,	-0.304177152	),
  (	73	,	0.120774145	,	-0.286394996	),
  (	73	,	0.060768437	,	-0.306223864	),
  (	73	,	6.088239538	,	-0.433745623	),
  (	73	,	6.044323221	,	-0.424983332	),
  (	73	,	6.194582445	,	-0.39328541	),
  (	73	,	6.160161919	,	-0.370889199	),
  (	73	,	6.237075799	,	-0.377234	),
  (	73	,	6.24204743	,	-0.353139718	),
  (	73	,	6.24293718	,	-0.319267574	),
  (	73	,	6.241789159	,	-0.228824483	),
  (	73	,	6.276957537	,	-0.246528298	),
  (	73	,	6.178480846	,	-0.153003024	),
  (	73	,	6.199469713	,	-0.138133733	),
  (	73	,	0.038046152	,	-0.038791559	),
  (	73	,	0.418410523	,	-0.306023669	),
  (	73	,	0.363718927	,	-0.313006173	),
  (	73	,	0.416458718	,	-0.233538489	),
  (	73	,	0.391321265	,	-0.230808558	),
  (	73	,	0.397049081	,	-0.086560581	),
  (	73	,	0.322319287	,	-0.084609562	),
  (	73	,	0.597584293	,	-0.114813477	),
  (	73	,	0.630020506	,	-0.054188968	),
  (	73	,	0.563521592	,	-0.040705904	),
  (	73	,	0.764601548	,	0.007616842	),
  (	73	,	0.643551303	,	-0.01311615	),
  (	73	,	0.701580714	,	0.050589849	),
  (	73	,	0.685740033	,	0.042155557	),
  (	73	,	0.486451469	,	-0.073662516	),
  (	73	,	0.486982942	,	-0.046042038	),
  (	73	,	0.553293088	,	0.025171373	),
  (	73	,	0.525183506	,	0.076611936	),
  (	73	,	0.118206085	,	-0.087335929	),
  (	73	,	0.187764051	,	-0.067304364	),
  (	73	,	0.224908883	,	-0.054859222	),
  (	73	,	0.077693831	,	-0.032510355	),
  (	73	,	0.146107084	,	-0.01062858	),
  (	73	,	0.072680615	,	0.032300707	),
  (	73	,	0.079109776	,	0.066266279	),
  (	73	,	0.232668631	,	0.071313906	),
  (	73	,	0.42187795	,	0.117248517	),
  (	73	,	0.474195035	,	0.134107498	),
  (	73	,	0.541067083	,	0.14127654	),
  (	73	,	0.559925078	,	0.154461427	),
  (	73	,	0.545453273	,	0.176557295	),
  (	73	,	0.330638914	,	0.17078177	),
  (	73	,	0.300771179	,	0.169827454	),
  (	73	,	0.292641084	,	0.201621212	),
  (	73	,	0.290641765	,	0.24232739	),
  (	73	,	0.400172825	,	0.190058067	),
  (	73	,	0.372273059	,	0.283738017	),
  (	73	,	0.359400619	,	0.29365693	),
  (	73	,	0.360920247	,	0.300147702	),
  (	73	,	5.957974597	,	-0.271986104	),
  (	73	,	5.953123918	,	-0.256146532	),
  (	73	,	5.835744273	,	-0.27889917	),
  (	73	,	5.823375986	,	-0.263584963	),
  (	73	,	5.833492069	,	-0.255815092	),
  (	73	,	6.078014131	,	-0.16703775	),
  (	73	,	6.044551314	,	-0.135345332	),
  (	73	,	5.947296484	,	-0.176323947	),
  (	73	,	5.981116735	,	-0.127618864	),
  (	73	,	5.726839417	,	-0.164377948	),
  (	73	,	5.779330376	,	-0.152154151	),
  (	73	,	5.93502337	,	-0.114052209	),
  (	73	,	6.175175174	,	-0.067256932	),
  (	73	,	6.217739183	,	-0.011524274	),
  (	73	,	6.157141204	,	0.041242332	),
  (	73	,	6.055250121	,	-0.005167444	),
  (	73	,	5.945938845	,	0.001236894	),
  (	73	,	6.081095064	,	0.038464158	),
  (	73	,	6.018392588	,	0.076062364	),
  (	73	,	5.693802718	,	-0.157711097	),
  (	73	,	5.674200616	,	-0.121738692	),
  (	73	,	5.736013538	,	-0.052308766	),
  (	73	,	5.818168025	,	-0.028876541	),
  (	73	,	5.599872297	,	0.048278429	),
  (	73	,	5.591032547	,	0.051906599	),
  (	73	,	5.688288363	,	0.009338708	),
  (	73	,	5.693280684	,	0.052220725	),
  (	73	,	5.750966792	,	0.103676975	),
  (	73	,	5.676852129	,	0.08762618	),
  (	73	,	5.891205998	,	0.002413377	),
  (	73	,	5.900794438	,	0.04513048	),
  (	73	,	5.858074187	,	0.112978237	),
  (	73	,	5.852932037	,	0.125404585	),
  (	73	,	5.867464195	,	0.171221773	),
  (	73	,	5.742063279	,	0.176224397	),
  (	73	,	5.793004515	,	0.187684789	),
  (	73	,	5.829448012	,	0.205248804	),
  (	73	,	5.788233295	,	0.217213736	),
  (	73	,	5.882309259	,	0.213780401	),
  (	73	,	5.919712523	,	0.229612841	),
  (	73	,	5.834959941	,	0.262608425	),
  (	73	,	0.006049097	,	0.118532525	),
  (	73	,	0.137461942	,	0.201270075	),
  (	73	,	0.075971415	,	0.154933397	),
  (	73	,	0.089472571	,	0.190548539	),
  (	73	,	0.091591962	,	0.222907587	),
  (	73	,	6.140545627	,	0.140797975	),
  (	73	,	6.136831487	,	0.150836591	),
  (	73	,	6.282552583	,	0.203745325	),
  (	73	,	0.017473601	,	0.211982311	),
  (	73	,	0.011081216	,	0.283731164	),
  (	73	,	0.287733812	,	0.268464891	),
  (	73	,	0.250894204	,	0.375000849	),
  (	73	,	0.077839155	,	0.285026576	),
  (	73	,	0.178840481	,	0.366874522	),
  (	73	,	0.175978517	,	0.419820392	),
  (	73	,	0.185370316	,	0.482458671	),
  (	73	,	6.045516641	,	0.252240305	),
  (	73	,	6.027285283	,	0.259543934	),
  (	73	,	6.162812771	,	0.303757865	),
  (	73	,	6.190796114	,	0.406802059	),
  (	73	,	5.988068439	,	0.277196567	),
  (	73	,	6.043267614	,	0.325177296	),
  (	73	,	5.91574096	,	0.344119457	),
  (	73	,	6.084692211	,	0.356784046	),
  (	73	,	6.129408807	,	0.444995901	),
  (	73	,	6.033331894	,	0.403699432	),
  (	73	,	0.052463222	,	0.499266542	),
  (	73	,	0.08005476	,	0.530503168	),
  (	73	,	0.035610753	,	0.54766648	),
  (	73	,	0.091203226	,	0.575566996	),
  (	73	,	0.097711184	,	0.620225737	),
  (	73	,	6.178141173	,	0.486334843	),
  (	73	,	6.233373273	,	0.495167296	),
  (	73	,	6.168297327	,	0.521406384	),
  (	73	,	6.126344826	,	0.517885828	),
  (	73	,	6.128359269	,	0.536032233	),
  (	73	,	6.174031038	,	0.555633543	),
  (	73	,	6.209572407	,	0.606430992	),
  (	73	,	1.575388797	,	-0.64702074	),
  (	73	,	1.529240516	,	-0.656611084	),
  (	73	,	1.555668095	,	-0.583540592	),
  (	73	,	1.728561596	,	-0.503274562	),
  (	73	,	1.636369385	,	-0.512524102	),
  (	73	,	1.627458957	,	-0.49678013	),
  (	73	,	1.46138387	,	-0.553173152	),
  (	73	,	1.42728233	,	-0.550929095	),
  (	73	,	1.515671339	,	-0.473588344	),
  (	73	,	1.579993004	,	-0.478708297	),
  (	73	,	1.6548097	,	-0.435893843	),
  (	73	,	1.509326578	,	-0.403878976	),
  (	73	,	1.758858761	,	-0.51028737	),
  (	73	,	1.759139357	,	-0.494850679	),
  (	73	,	1.800684745	,	-0.455820475	),
  (	73	,	1.836053266	,	-0.447568396	),
  (	73	,	1.854815611	,	-0.352599503	),
  (	73	,	1.907078284	,	-0.369830254	),
  (	73	,	1.896024819	,	-0.348910536	),
  (	73	,	1.841113282	,	-0.307953828	),
  (	73	,	1.821824664	,	-0.294773829	),
  (	73	,	1.683211576	,	-0.366049369	),
  (	73	,	1.766006422	,	-0.332537064	),
  (	73	,	1.835403448	,	-0.268758345	),
  (	73	,	1.727208846	,	-0.281046604	),
  (	73	,	1.785752187	,	-0.221096519	),
  (	73	,	1.365125079	,	-0.474338397	),
  (	73	,	1.428611906	,	-0.463999761	),
  (	73	,	1.35141415	,	-0.392595096	),
  (	73	,	1.523709917	,	-0.338591083	),
  (	73	,	1.536812151	,	-0.332550855	),
  (	73	,	1.252074336	,	-0.370207182	),
  (	73	,	1.303520405	,	-0.310784711	),
  (	73	,	1.429177724	,	-0.237011432	),
  (	73	,	1.577647595	,	-0.286211594	),
  (	73	,	1.596662531	,	-0.231217489	),
  (	73	,	1.568051623	,	-0.224015848	),
  (	73	,	1.694236502	,	-0.227819228	),
  (	73	,	1.659306741	,	-0.189932766	),
  (	73	,	1.727451662	,	-0.198518712	),
  (	73	,	1.665545779	,	-0.168998328	),
  (	73	,	1.685200149	,	-0.128481462	),
  (	73	,	1.494622331	,	-0.203233484	),
  (	73	,	1.548558271	,	-0.160241851	),
  (	73	,	1.502270942	,	-0.174842378	),
  (	73	,	1.466529461	,	-0.129092202	),
  (	73	,	1.462514276	,	-0.103444128	),
  (	73	,	1.609828879	,	-0.035554778	),
  (	73	,	1.94657472	,	-0.316279468	),
  (	73	,	1.960618337	,	-0.302727902	),
  (	73	,	2.017227631	,	-0.280460285	),
  (	73	,	2.004745347	,	-0.201829305	),
  (	73	,	1.999263907	,	-0.185233593	),
  (	73	,	1.84957467	,	-0.228586506	),
  (	73	,	1.881888838	,	-0.210170098	),
  (	73	,	1.852833802	,	-0.201132686	),
  (	73	,	1.879642965	,	-0.162943638	),
  (	73	,	1.921231141	,	-0.149222303	),
  (	73	,	1.824386989	,	-0.157554343	),
  (	73	,	1.878645726	,	-0.137375574	),
  (	73	,	1.826544491	,	-0.125424045	),
  (	73	,	2.021267275	,	-0.072104805	),
  (	73	,	1.937408366	,	-0.069444536	),
  (	73	,	1.909335562	,	-0.065415335	),
  (	73	,	1.989745526	,	-0.054995261	),
  (	73	,	2.21474408	,	-0.089870439	),
  (	73	,	2.224941132	,	0.000334711	),
  (	73	,	2.187197156	,	0.018547809	),
  (	73	,	1.977579435	,	0.002867314	),
  (	73	,	2.019509657	,	0.028092461	),
  (	73	,	2.132064965	,	0.033075577	),
  (	73	,	2.163374901	,	0.048893508	),
  (	73	,	2.218113246	,	0.116949155	),
  (	73	,	1.750349884	,	-0.09956805	),
  (	73	,	1.682709063	,	-0.084340017	),
  (	73	,	1.75678768	,	-0.066946117	),
  (	73	,	1.787819036	,	-0.023385383	),
  (	73	,	1.867271403	,	-0.081642821	),
  (	73	,	1.836673781	,	-0.011681479	),
  (	73	,	1.855067263	,	0.005760869	),
  (	73	,	1.870182574	,	0.072885738	),
  (	73	,	1.737030439	,	-0.025219119	),
  (	73	,	1.638560354	,	0.014572829	),
  (	73	,	1.594264898	,	0.010694398	),
  (	73	,	1.593235717	,	0.015121947	),
  (	73	,	1.67082474	,	0.065637422	),
  (	73	,	1.677874505	,	0.073069085	),
  (	73	,	1.802001164	,	0.047882943	),
  (	73	,	1.736096923	,	0.039607865	),
  (	73	,	1.825143068	,	0.067993935	),
  (	73	,	1.806855801	,	0.116721684	),
  (	73	,	1.809332462	,	0.117357717	),
  (	73	,	1.707608612	,	0.050813215	),
  (	73	,	1.703820406	,	0.075614852	),
  (	73	,	1.711099282	,	0.084186482	),
  (	73	,	1.971448528	,	0.020331561	),
  (	73	,	1.98772544	,	0.069596154	),
  (	73	,	1.94637949	,	0.097386175	),
  (	73	,	1.899134772	,	0.101551159	),
  (	73	,	2.095764778	,	0.156632731	),
  (	73	,	2.049317277	,	0.212031651	),
  (	73	,	1.914497504	,	0.14811997	),
  (	73	,	1.900234638	,	0.165760147	),
  (	73	,	1.906784231	,	0.165159958	),
  (	73	,	1.816134906	,	0.15263539	),
  (	73	,	1.846617886	,	0.157479543	),
  (	73	,	1.803081212	,	0.184838632	),
  (	73	,	1.842660622	,	0.219593672	),
  (	73	,	1.875788686	,	0.22946912	),
  (	73	,	1.946217028	,	0.246141969	),
  (	73	,	1.93643122	,	0.291035047	),
  (	73	,	1.948028084	,	0.323178875	),
  (	73	,	1.186618505	,	-0.220480562	),
  (	73	,	1.313579072	,	-0.195617783	),
  (	73	,	1.306565641	,	-0.159981181	),
  (	73	,	1.08795506	,	-0.138390928	),
  (	73	,	1.089445866	,	-0.137743381	),
  (	73	,	1.16399377	,	-0.120121937	),
  (	73	,	1.226458151	,	-0.117766652	),
  (	73	,	1.369188229	,	-0.117780048	),
  (	73	,	1.389388043	,	-0.09881261	),
  (	73	,	1.462061529	,	-0.082586184	),
  (	73	,	1.377721135	,	-0.083713963	),
  (	73	,	1.418167523	,	-0.049139452	),
  (	73	,	1.346641157	,	-0.057703183	),
  (	73	,	1.427338244	,	-0.018896921	),
  (	73	,	1.387608404	,	-0.000657904	),
  (	73	,	1.434693797	,	0.037781474	),
  (	73	,	1.24718087	,	-0.050765334	),
  (	73	,	1.364067358	,	0.001402758	),
  (	73	,	1.301486292	,	0.007915801	),
  (	73	,	1.292571998	,	0.055428056	),
  (	73	,	1.295855143	,	0.057353633	),
  (	73	,	1.259506878	,	0.063692349	),
  (	73	,	1.360291384	,	0.018089875	),
  (	73	,	1.355033087	,	0.092763184	),
  (	73	,	0.998293289	,	-0.122437377	),
  (	73	,	1.041382043	,	-0.063969282	),
  (	73	,	1.117118264	,	0.007919497	),
  (	73	,	1.095872731	,	0.040461774	),
  (	73	,	1.045859047	,	0.031325156	),
  (	73	,	1.061830998	,	0.055639109	),
  (	73	,	0.90242882	,	0.000457305	),
  (	73	,	0.830347253	,	-0.029579339	),
  (	73	,	0.83632534	,	-0.008627959	),
  (	73	,	0.837910761	,	0.001880064	),
  (	73	,	1.032495876	,	0.053370176	),
  (	73	,	0.950472078	,	0.072353792	),
  (	73	,	0.919726679	,	0.093671116	),
  (	73	,	1.160368169	,	0.0180073	),
  (	73	,	1.231456439	,	0.05218329	),
  (	73	,	1.158958351	,	0.098530247	),
  (	73	,	1.176568348	,	0.090131349	),
  (	73	,	1.266621454	,	0.121299645	),
  (	73	,	1.252761208	,	0.175434699	),
  (	73	,	1.322201983	,	0.210481972	),
  (	73	,	1.28600277	,	0.215581282	),
  (	73	,	1.277078467	,	0.216152991	),
  (	73	,	1.154975664	,	0.175341136	),
  (	73	,	1.217990179	,	0.226937067	),
  (	73	,	1.632797667	,	0.068107229	),
  (	73	,	1.634071297	,	0.079290607	),
  (	73	,	1.627390051	,	0.127016154	),
  (	73	,	1.675604297	,	0.160072952	),
  (	73	,	1.494442607	,	0.183928662	),
  (	73	,	1.541170749	,	0.206183986	),
  (	73	,	1.568458122	,	0.217624673	),
  (	73	,	1.662482939	,	0.256645658	),
  (	73	,	1.633216005	,	0.252959733	),
  (	73	,	1.613959048	,	0.259229552	),
  (	73	,	1.615552536	,	0.277616341	),
  (	73	,	1.503262481	,	0.262905997	),
  (	73	,	1.576675622	,	0.330934829	),
  (	73	,	1.566054684	,	0.328471671	),
  (	73	,	1.728192738	,	0.239005012	),
  (	73	,	1.789766242	,	0.287168058	),
  (	73	,	1.777270488	,	0.319790825	),
  (	73	,	1.858468782	,	0.264966011	),
  (	73	,	1.881821053	,	0.267593034	),
  (	73	,	1.850743633	,	0.325831091	),
  (	73	,	1.818674595	,	0.365945654	),
  (	73	,	1.900494436	,	0.383388956	),
  (	73	,	1.708606968	,	0.293708587	),
  (	73	,	1.670398716	,	0.306724668	),
  (	73	,	1.645640274	,	0.330127252	),
  (	73	,	1.663478647	,	0.368830488	),
  (	73	,	1.633956479	,	0.380162288	),
  (	73	,	1.766787766	,	0.364088121	),
  (	73	,	1.785714637	,	0.389395309	),
  (	73	,	1.383570609	,	0.219308081	),
  (	73	,	1.439742385	,	0.281890873	),
  (	73	,	1.520535014	,	0.304270835	),
  (	73	,	1.521692016	,	0.318399023	),
  (	73	,	1.535314745	,	0.340711445	),
  (	73	,	1.513834311	,	0.353984157	),
  (	73	,	1.23423061	,	0.326722173	),
  (	73	,	1.389836187	,	0.380347324	),
  (	73	,	1.535209045	,	0.408104309	),
  (	73	,	1.509374967	,	0.452278676	),
  (	73	,	1.505023347	,	0.459760441	),
  (	73	,	1.566843132	,	0.481044647	),
  (	73	,	1.751039332	,	0.518596545	),
  (	73	,	1.723656224	,	0.548636501	),
  (	73	,	1.486132092	,	0.505742906	),
  (	73	,	1.525570644	,	0.480849395	),
  (	73	,	1.526839978	,	0.554763503	),
  (	73	,	1.57222287	,	0.557471168	),
  (	73	,	1.552632125	,	0.644662821	),
  (	73	,	1.603634739	,	0.66465866	),
  (	73	,	3.130726441	,	-0.671884962	),
  (	73	,	3.19604044	,	-0.583026918	),
  (	73	,	3.089492984	,	-0.61480614	),
  (	73	,	3.147760135	,	-0.594291363	),
  (	73	,	3.238206445	,	-0.61979981	),
  (	73	,	3.047113054	,	-0.586529606	),
  (	73	,	3.03270564	,	-0.536243783	),
  (	73	,	3.086773817	,	-0.545499717	),
  (	73	,	3.055541848	,	-0.497361691	),
  (	73	,	3.410428296	,	-0.430511285	),
  (	73	,	3.462078823	,	-0.328562036	),
  (	73	,	3.431530178	,	-0.260332729	),
  (	73	,	3.239514024	,	-0.423009311	),
  (	73	,	3.260469532	,	-0.321344926	),
  (	73	,	3.174169799	,	-0.317486514	),
  (	73	,	3.387803826	,	-0.260927271	),
  (	73	,	3.358813474	,	-0.263177075	),
  (	73	,	3.25499665	,	-0.260890939	),
  (	73	,	2.966151847	,	-0.491994786	),
  (	73	,	2.937422719	,	-0.461901336	),
  (	73	,	3.009626493	,	-0.436366318	),
  (	73	,	2.974762896	,	-0.385809097	),
  (	73	,	3.069084273	,	-0.345984143	),
  (	73	,	2.908358538	,	-0.369431644	),
  (	73	,	2.882522727	,	-0.337594689	),
  (	73	,	2.84898073	,	-0.301533713	),
  (	73	,	2.822950391	,	-0.274573822	),
  (	73	,	2.941643145	,	-0.29471348	),
  (	73	,	2.936263015	,	-0.223148934	),
  (	73	,	3.191236404	,	-0.293060967	),
  (	73	,	3.102521725	,	-0.232534411	),
  (	73	,	3.128166453	,	-0.211325299	),
  (	73	,	3.243949372	,	-0.106786359	),
  (	73	,	3.0348944	,	-0.21663158	),
  (	73	,	3.009066256	,	-0.1756285	),
  (	73	,	3.184329693	,	-0.091204731	),
  (	73	,	3.121694454	,	-0.089615731	),
  (	73	,	3.628462709	,	-0.227156088	),
  (	73	,	3.658433265	,	-0.210492406	),
  (	73	,	3.719989837	,	-0.172790713	),
  (	73	,	3.599509821	,	-0.133244948	),
  (	73	,	3.489498674	,	-0.203734245	),
  (	73	,	3.530123137	,	-0.103942487	),
  (	73	,	3.593218173	,	-0.074606762	),
  (	73	,	3.517468858	,	-0.063898906	),
  (	73	,	3.74361724	,	-0.13904749	),
  (	73	,	3.827268849	,	-0.067935506	),
  (	73	,	3.856188037	,	-0.043733298	),
  (	73	,	3.853760898	,	0.031844922	),
  (	73	,	3.7458995	,	0.064128383	),
  (	73	,	3.672058773	,	0.074226137	),
  (	73	,	3.656229551	,	0.089318822	),
  (	73	,	3.399038653	,	-0.10630868	),
  (	73	,	3.42407139	,	0.005138059	),
  (	73	,	3.291627949	,	-0.024565938	),
  (	73	,	3.255094757	,	0.035639902	),
  (	73	,	3.408342262	,	0.076072399	),
  (	73	,	3.509445507	,	0.024428639	),
  (	73	,	3.506597321	,	0.047555175	),
  (	73	,	3.67564866	,	0.180243507	),
  (	73	,	3.635801533	,	0.22238275	),
  (	73	,	3.490438798	,	0.148124731	),
  (	73	,	2.820507577	,	-0.234918753	),
  (	73	,	2.708867319	,	-0.270139546	),
  (	73	,	2.831643657	,	-0.158828026	),
  (	73	,	2.848420247	,	-0.119089107	),
  (	73	,	2.633910161	,	-0.224754015	),
  (	73	,	2.632603852	,	-0.187227574	),
  (	73	,	2.677920981	,	-0.128873482	),
  (	73	,	2.708079463	,	-0.108085704	),
  (	73	,	3.019395629	,	-0.031107575	),
  (	73	,	3.008088089	,	-0.01481446	),
  (	73	,	2.884421837	,	0.000821642	),
  (	73	,	2.906134623	,	0.021128319	),
  (	73	,	2.971346686	,	0.085178055	),
  (	73	,	2.943241529	,	0.104593523	),
  (	73	,	2.506927211	,	-0.060874575	),
  (	73	,	2.490101053	,	-0.070954472	),
  (	73	,	2.622297153	,	-0.055663032	),
  (	73	,	2.624935088	,	-0.017770393	),
  (	73	,	2.416880113	,	0.049964021	),
  (	73	,	2.758963922	,	0.08108083	),
  (	73	,	2.890902862	,	0.160097609	),
  (	73	,	2.877827593	,	0.173324268	),
  (	73	,	2.59229628	,	0.140923965	),
  (	73	,	2.633496874	,	0.172768375	),
  (	73	,	2.745356436	,	0.177245492	),
  (	73	,	3.121507334	,	0.01912319	),
  (	73	,	3.077896568	,	0.12269403	),
  (	73	,	3.185796874	,	0.286701058	),
  (	73	,	3.141921834	,	0.338928505	),
  (	73	,	3.354873251	,	0.211104632	),
  (	73	,	3.491805117	,	0.310062574	),
  (	73	,	3.364982413	,	0.334431549	),
  (	73	,	3.37632387	,	0.332618127	),
  (	73	,	3.410306972	,	0.371209361	),
  (	73	,	3.417232484	,	0.415852753	),
  (	73	,	3.277086027	,	0.414923594	),
  (	73	,	2.982913498	,	0.299185999	),
  (	73	,	2.97787641	,	0.304331272	),
  (	73	,	3.066252274	,	0.318383557	),
  (	73	,	3.052610323	,	0.331555231	),
  (	73	,	3.025921504	,	0.343478605	),
  (	73	,	3.160241864	,	0.374521992	),
  (	73	,	3.261796414	,	0.490590362	),
  (	73	,	3.091057802	,	0.495969102	),
  (	73	,	3.007703456	,	0.530991947	),
  (	73	,	3.015086387	,	0.564056676	),
  (	73	,	3.078685138	,	0.62647768	),
  (	73	,	3.121426987	,	0.67643271	),
  (	73	,	4.687982679	,	-0.674174983	),
  (	73	,	4.710088979	,	-0.628685637	),
  (	73	,	4.676871536	,	-0.617242534	),
  (	73	,	4.666508876	,	-0.617465054	),
  (	73	,	4.730510049	,	-0.594339034	),
  (	73	,	4.832494021	,	-0.583131767	),
  (	73	,	4.805467661	,	-0.561654656	),
  (	73	,	4.825451254	,	-0.554226866	),
  (	73	,	4.861928762	,	-0.539011898	),
  (	73	,	4.737128425	,	-0.510994152	),
  (	73	,	4.595016633	,	-0.576967838	),
  (	73	,	4.594829396	,	-0.517505147	),
  (	73	,	4.565177608	,	-0.495967761	),
  (	73	,	4.626858503	,	-0.50480577	),
  (	73	,	4.70910767	,	-0.512955476	),
  (	73	,	4.727210017	,	-0.459369835	),
  (	73	,	4.73336853	,	-0.446903985	),
  (	73	,	4.752946429	,	-0.418676667	),
  (	73	,	4.668563277	,	-0.422496975	),
  (	73	,	4.673688723	,	-0.400056314	),
  (	73	,	4.933282263	,	-0.467235766	),
  (	73	,	4.949665091	,	-0.432301435	),
  (	73	,	4.925385711	,	-0.325192872	),
  (	73	,	4.959967979	,	-0.304457631	),
  (	73	,	4.80860267	,	-0.400060638	),
  (	73	,	4.874349372	,	-0.335268015	),
  (	73	,	4.765817915	,	-0.339166851	),
  (	73	,	4.827558449	,	-0.272798306	),
  (	73	,	4.955633943	,	-0.285351368	),
  (	73	,	4.872924677	,	-0.278300879	),
  (	73	,	4.869478299	,	-0.245491846	),
  (	73	,	4.902313693	,	-0.197868422	),
  (	73	,	4.540085378	,	-0.463381703	),
  (	73	,	4.551651399	,	-0.438034605	),
  (	73	,	4.470065858	,	-0.408244264	),
  (	73	,	4.657948978	,	-0.36368178	),
  (	73	,	4.545969714	,	-0.35900421	),
  (	73	,	4.47547709	,	-0.37144431	),
  (	73	,	4.593901712	,	-0.235308773	),
  (	73	,	4.455732257	,	-0.236829482	),
  (	73	,	4.727066798	,	-0.307354536	),
  (	73	,	4.777677927	,	-0.268514675	),
  (	73	,	4.809543907	,	-0.251130244	),
  (	73	,	4.764422005	,	-0.098156246	),
  (	73	,	5.094914185	,	-0.320284475	),
  (	73	,	5.136435028	,	-0.251873619	),
  (	73	,	5.026190636	,	-0.254547674	),
  (	73	,	5.035277932	,	-0.24502939	),
  (	73	,	5.199833506	,	-0.191097608	),
  (	73	,	5.273078444	,	-0.179996562	),
  (	73	,	5.138760344	,	-0.174085212	),
  (	73	,	5.015222107	,	-0.234871683	),
  (	73	,	5.063251101	,	-0.184313065	),
  (	73	,	5.357153436	,	-0.098685974	),
  (	73	,	5.421240417	,	-0.040612613	),
  (	73	,	5.398216575	,	-0.022878255	),
  (	73	,	5.355619303	,	-0.027210381	),
  (	73	,	5.337741309	,	-0.007895003	),
  (	73	,	5.141575299	,	0.006031861	),
  (	73	,	5.374430605	,	0.077070404	),
  (	73	,	5.285482263	,	0.152141842	),
  (	73	,	4.92762975	,	-0.145085434	),
  (	73	,	4.90249787	,	-0.146055216	),
  (	73	,	4.917079619	,	-0.132280878	),
  (	73	,	4.968903726	,	-0.098346088	),
  (	73	,	4.856896018	,	-0.090103709	),
  (	73	,	4.995741752	,	-0.070531249	),
  (	73	,	4.979384653	,	0.043296276	),
  (	73	,	4.810114159	,	-0.020985498	),
  (	73	,	4.849764353	,	-0.028536763	),
  (	73	,	4.903739595	,	0.150532728	),
  (	73	,	5.120862753	,	0.065647331	),
  (	73	,	5.09929639	,	0.064470205	),
  (	73	,	5.066063588	,	0.089205059	),
  (	73	,	5.054431064	,	0.089555783	),
  (	73	,	5.121564323	,	0.138195446	),
  (	73	,	5.201780101	,	0.130210546	),
  (	73	,	5.169193973	,	0.190459928	),
  (	73	,	5.002813942	,	0.120260857	),
  (	73	,	5.007577315	,	0.12188249	),
  (	73	,	5.036005172	,	0.135508917	),
  (	73	,	5.002045072	,	0.124894071	),
  (	73	,	5.077361084	,	0.151144902	),
  (	73	,	5.034808243	,	0.157658275	),
  (	73	,	5.039500811	,	0.181677994	),
  (	73	,	5.021437807	,	0.180566094	),
  (	73	,	5.032673247	,	0.19800313	),
  (	73	,	5.125338798	,	0.191160764	),
  (	73	,	5.080909472	,	0.21437744	),
  (	73	,	5.106709861	,	0.291664388	),
  (	73	,	5.132946841	,	0.277380315	),
  (	73	,	5.106925897	,	0.308841393	),
  (	73	,	4.314276262	,	-0.313897756	),
  (	73	,	4.306722492	,	-0.310126846	),
  (	73	,	4.31212942	,	-0.282957954	),
  (	73	,	4.317200205	,	-0.236847043	),
  (	73	,	4.228212928	,	-0.168388137	),
  (	73	,	4.163616002	,	-0.193561378	),
  (	73	,	4.401970703	,	-0.07882338	),
  (	73	,	4.262111242	,	-0.095938872	),
  (	73	,	4.266272113	,	-0.070461162	),
  (	73	,	4.296374898	,	-0.043427058	),
  (	73	,	4.67753534	,	0.019186298	),
  (	73	,	4.35085738	,	0.004448618	),
  (	73	,	4.24632252	,	-0.009062761	),
  (	73	,	4.19799615	,	-0.014333127	),
  (	73	,	4.110353669	,	0.007975301	),
  (	73	,	3.977534143	,	-0.039447223	),
  (	73	,	4.027447054	,	0.008104439	),
  (	73	,	4.176782076	,	0.059435601	),
  (	73	,	4.182151133	,	0.082989474	),
  (	73	,	4.113999626	,	0.120146325	),
  (	73	,	4.349623275	,	0.124043735	),
  (	73	,	4.303139647	,	0.148567003	),
  (	73	,	4.481760543	,	0.157235007	),
  (	73	,	4.449706251	,	0.190512494	),
  (	73	,	4.41710893	,	0.196204519	),
  (	73	,	4.34340586	,	0.298464517	),
  (	73	,	4.703894019	,	0.047471694	),
  (	73	,	4.787609326	,	0.100417039	),
  (	73	,	4.754790008	,	0.108326166	),
  (	73	,	4.695021566	,	0.090083598	),
  (	73	,	4.652096681	,	0.09875339	),
  (	73	,	4.709995405	,	0.112030037	),
  (	73	,	4.744172964	,	0.116955328	),
  (	73	,	4.811950606	,	0.125781225	),
  (	73	,	4.809681383	,	0.131747215	),
  (	73	,	4.885443501	,	0.152415246	),
  (	73	,	4.89027664	,	0.153471666	),
  (	73	,	4.715588251	,	0.166926722	),
  (	73	,	4.846144394	,	0.220107728	),
  (	73	,	4.624822769	,	0.136153349	),
  (	73	,	4.66003884	,	0.17072875	),
  (	73	,	4.548587441	,	0.177956545	),
  (	73	,	4.583109562	,	0.187930041	),
  (	73	,	4.603461043	,	0.22929756	),
  (	73	,	4.610097376	,	0.231411467	),
  (	73	,	4.707071603	,	0.259052554	),
  (	73	,	4.962012801	,	0.23339461	),
  (	73	,	4.961941337	,	0.25888584	),
  (	73	,	4.919595213	,	0.270748186	),
  (	73	,	4.989770707	,	0.301601172	),
  (	73	,	4.901066789	,	0.339754663	),
  (	73	,	4.726975084	,	0.341313805	),
  (	73	,	4.816140396	,	0.413351595	),
  (	73	,	4.940367674	,	0.454245016	),
  (	73	,	4.512439175	,	0.210128147	),
  (	73	,	4.591963521	,	0.251038845	),
  (	73	,	4.540492286	,	0.264577923	),
  (	73	,	4.490004888	,	0.261117286	),
  (	73	,	4.477931078	,	0.265798404	),
  (	73	,	4.529011727	,	0.298880203	),
  (	73	,	4.595254498	,	0.292677718	),
  (	73	,	4.425140305	,	0.272679206	),
  (	73	,	4.434735754	,	0.284230365	),
  (	73	,	4.455152056	,	0.289610213	),
  (	73	,	4.461607765	,	0.33834963	),
  (	73	,	4.378604538	,	0.361560641	),
  (	73	,	4.455480265	,	0.375190559	),
  (	73	,	4.546654451	,	0.369224987	),
  (	73	,	4.737818252	,	0.374298476	),
  (	73	,	4.718882546	,	0.42324118	),
  (	73	,	4.743201109	,	0.40847053	),
  (	73	,	4.760642246	,	0.465495071	),
  (	73	,	4.745121124	,	0.46102853	),
  (	73	,	4.732688481	,	0.473249046	),
  (	73	,	4.814849451	,	0.48011442	),
  (	73	,	4.82955081	,	0.540503292	),
  (	73	,	4.73413153	,	0.507557707	),
  (	73	,	4.787024235	,	0.585308078	),
  (	73	,	4.62191771	,	0.5280153	),
  (	73	,	4.567379602	,	0.544863625	),
  (	73	,	4.664275856	,	0.646842714	),
  (	73	,	4.680563416	,	0.67754741	),
  (	73	,	1.405656853	,	-1.414394783	),
  (	73	,	0.868125279	,	-1.291314841	),
  (	73	,	1.419413279	,	-1.321119118	),
  (	73	,	1.250634197	,	-1.196348553	),
  (	73	,	0.875202294	,	-1.148170259	),
  (	73	,	1.091372218	,	-1.075113929	),
  (	73	,	0.31497212	,	-1.289917733	),
  (	73	,	0.305555429	,	-1.273339446	),
  (	73	,	0.57560573	,	-1.238326471	),
  (	73	,	0.505603249	,	-1.193664033	),
  (	73	,	0.713178746	,	-1.164388246	),
  (	73	,	0.646309199	,	-1.1442925	),
  (	73	,	0.071587723	,	-1.228577016	),
  (	73	,	0.023792547	,	-1.186120696	),
  (	73	,	0.094069027	,	-1.157235755	),
  (	73	,	0.503222872	,	-1.052653833	),
  (	73	,	0.759330286	,	-1.132707581	),
  (	73	,	0.81961359	,	-1.079575187	),
  (	73	,	0.818868359	,	-1.077132622	),
  (	73	,	0.958663033	,	-0.923566756	),
  (	73	,	0.705166937	,	-0.982573888	),
  (	73	,	0.551854655	,	-0.961376136	),
  (	73	,	0.593613017	,	-0.923081449	),
  (	73	,	0.750371216	,	-0.870405636	),
  (	73	,	1.548738633	,	-1.040361765	),
  (	73	,	1.459153204	,	-0.918544711	),
  (	73	,	1.3677601	,	-0.969872274	),
  (	73	,	1.418881376	,	-0.948020689	),
  (	73	,	1.38634834	,	-0.95071896	),
  (	73	,	1.21694131	,	-1.02940251	),
  (	73	,	1.099472582	,	-0.932218828	),
  (	73	,	1.130629916	,	-0.830211456	),
  (	73	,	1.180245329	,	-0.757655702	),
  (	73	,	1.180038429	,	-0.754201861	),
  (	73	,	1.508948892	,	-0.820421452	),
  (	73	,	1.454940126	,	-0.86182132	),
  (	73	,	1.396300174	,	-0.821157031	),
  (	73	,	1.505697905	,	-0.729229576	),
  (	73	,	1.507110537	,	-0.686128139	),
  (	73	,	1.261770342	,	-0.739753702	),
  (	73	,	1.267427491	,	-0.672983688	),
  (	73	,	1.098316202	,	-0.821795339	),
  (	73	,	1.113485995	,	-0.668364057	),
  (	73	,	0.838825462	,	-0.705272305	),
  (	73	,	0.852792606	,	-0.693977061	),
  (	73	,	0.947177544	,	-0.633417865	),
  (	73	,	0.954275303	,	-0.614427968	),
  (	73	,	0.916147942	,	-0.623933662	),
  (	73	,	1.167371946	,	-0.706372833	),
  (	73	,	1.206144596	,	-0.660199065	),
  (	73	,	1.152855873	,	-0.699049994	),
  (	73	,	1.199556685	,	-0.62092062	),
  (	73	,	1.179728648	,	-0.531347737	),
  (	73	,	1.318268589	,	-0.547147343	),
  (	73	,	1.006086118	,	-0.535643249	),
  (	73	,	0.9905372	,	-0.524569058	),
  (	73	,	1.170429741	,	-0.397374955	),
  (	73	,	1.169031239	,	-0.375322402	),
  (	73	,	0.098496033	,	-1.065258029	),
  (	73	,	0.35113686	,	-1.000735064	),
  (	73	,	0.302705487	,	-0.987773722	),
  (	73	,	0.394118808	,	-0.916187335	),
  (	73	,	0.432568109	,	-0.851290064	),
  (	73	,	0.436798829	,	-0.851044002	),
  (	73	,	0.060607493	,	-0.994826529	),
  (	73	,	0.14615202	,	-0.965660419	),
  (	73	,	0.536580587	,	-0.925652563	),
  (	73	,	0.664319053	,	-0.80060725	),
  (	73	,	0.469632694	,	-0.807341693	),
  (	73	,	0.48625989	,	-0.793621421	),
  (	73	,	0.516919165	,	-0.7185566	),
  (	73	,	0.472802649	,	-0.724207078	),
  (	73	,	0.579746972	,	-0.602813966	),
  (	73	,	0.582542386	,	-0.581808383	),
  (	73	,	0.562641045	,	-0.554063244	),
  (	73	,	0.276244552	,	-0.715953739	),
  (	73	,	0.28520291	,	-0.702845946	),
  (	73	,	0.005596397	,	-0.724096482	),
  (	73	,	0.091166565	,	-0.684869497	),
  (	73	,	0.114415473	,	-0.69202114	),
  (	73	,	0.099765962	,	-0.65281345	),
  (	73	,	0.224138239	,	-0.672458664	),
  (	73	,	0.185990343	,	-0.628703911	),
  (	73	,	0.356276249	,	-0.580013066	),
  (	73	,	0.485422389	,	-0.539346744	),
  (	73	,	0.414604106	,	-0.522025312	),
  (	73	,	0.410549392	,	-0.502367298	),
  (	73	,	0.401981191	,	-0.412754673	),
  (	73	,	0.379844126	,	-0.357643909	),
  (	73	,	0.767273245	,	-0.674579459	),
  (	73	,	0.823390452	,	-0.618434376	),
  (	73	,	0.71653432	,	-0.6336849	),
  (	73	,	0.947501189	,	-0.520636156	),
  (	73	,	0.840487669	,	-0.543305179	),
  (	73	,	0.820104721	,	-0.529076372	),
  (	73	,	0.685423763	,	-0.506029626	),
  (	73	,	0.752802402	,	-0.487952332	),
  (	73	,	0.97723148	,	-0.49966715	),
  (	73	,	1.034974838	,	-0.429901781	),
  (	73	,	0.891303407	,	-0.424127517	),
  (	73	,	1.138142019	,	-0.337469463	),
  (	73	,	1.116054341	,	-0.325334461	),
  (	73	,	1.062963673	,	-0.351840093	),
  (	73	,	1.047219217	,	-0.335921984	),
  (	73	,	1.097055969	,	-0.278700597	),
  (	73	,	0.977085479	,	-0.333529044	),
  (	73	,	0.950146951	,	-0.270266537	),
  (	73	,	0.959453173	,	-0.191061106	),
  (	73	,	0.57027354	,	-0.492519405	),
  (	73	,	0.559143529	,	-0.481209847	),
  (	73	,	0.526682395	,	-0.426252273	),
  (	73	,	0.602414033	,	-0.41238845	),
  (	73	,	0.720021166	,	-0.386890739	),
  (	73	,	0.726226457	,	-0.37804957	),
  (	73	,	0.680636899	,	-0.373563623	),
  (	73	,	0.564111342	,	-0.341566967	),
  (	73	,	0.540606583	,	-0.305672377	),
  (	73	,	0.785063596	,	-0.238820375	),
  (	73	,	0.644204112	,	-0.120933272	),
  (	73	,	0.757375336	,	-0.135275647	),
  (	73	,	1.687670766	,	-1.548867646	),
  (	73	,	2.240976013	,	-1.399033038	),
  (	73	,	2.706284176	,	-1.425029719	),
  (	73	,	2.766103201	,	-1.405275408	),
  (	73	,	1.605772938	,	-1.431928691	),
  (	73	,	2.129958782	,	-1.373487585	),
  (	73	,	2.342801384	,	-1.290178222	),
  (	73	,	2.203514598	,	-1.307459467	),
  (	73	,	2.34372646	,	-1.239477719	),
  (	73	,	2.90951852	,	-1.236221624	),
  (	73	,	2.707254959	,	-1.258907426	),
  (	73	,	2.676744993	,	-1.250855318	),
  (	73	,	2.956621808	,	-1.188881193	),
  (	73	,	2.916604186	,	-1.141941875	),
  (	73	,	2.553650588	,	-1.166031909	),
  (	73	,	2.70551473	,	-1.172300445	),
  (	73	,	2.655938315	,	-1.143383813	),
  (	73	,	2.40833918	,	-1.181964775	),
  (	73	,	2.418925582	,	-1.13540454	),
  (	73	,	2.512823377	,	-1.126666842	),
  (	73	,	2.710904926	,	-1.137877038	),
  (	73	,	2.761805548	,	-1.049176514	),
  (	73	,	2.721423893	,	-1.033336775	),
  (	73	,	2.643026383	,	-1.067657066	),
  (	73	,	2.010549443	,	-1.25249774	),
  (	73	,	1.950796018	,	-1.197553643	),
  (	73	,	2.196593015	,	-1.226069513	),
  (	73	,	2.183081423	,	-1.205349183	),
  (	73	,	2.133422655	,	-1.204128639	),
  (	73	,	2.22405004	,	-1.171808377	),
  (	73	,	1.890470657	,	-1.132254581	),
  (	73	,	1.584465508	,	-1.174782164	),
  (	73	,	1.913956067	,	-1.106304992	),
  (	73	,	2.056122407	,	-1.098331875	),
  (	73	,	2.132533288	,	-1.058118695	),
  (	73	,	2.145353152	,	-1.048513251	),
  (	73	,	1.933390925	,	-1.086840698	),
  (	73	,	2.018464992	,	-1.034916132	),
  (	73	,	1.895290108	,	-1.065866618	),
  (	73	,	2.054893381	,	-1.041021599	),
  (	73	,	2.103618679	,	-0.970475353	),
  (	73	,	2.386100896	,	-1.051761216	),
  (	73	,	2.318890802	,	-1.070966943	),
  (	73	,	2.50144328	,	-1.011652073	),
  (	73	,	2.498226047	,	-1.003939928	),
  (	73	,	2.552091711	,	-1.004778088	),
  (	73	,	2.476271737	,	-1.013941957	),
  (	73	,	2.469565203	,	-0.978942509	),
  (	73	,	2.469469521	,	-0.939676311	),
  (	73	,	2.446672549	,	-0.929477568	),
  (	73	,	2.394013328	,	-0.948942265	),
  (	73	,	2.236606366	,	-0.962085682	),
  (	73	,	2.272451986	,	-0.921564836	),
  (	73	,	2.171838706	,	-0.973459917	),
  (	73	,	2.370037437	,	-0.867366734	),
  (	73	,	2.362852764	,	-0.865322331	),
  (	73	,	2.439079666	,	-0.837171692	),
  (	73	,	2.285744601	,	-0.884108749	),
  (	73	,	2.283228097	,	-0.834382007	),
  (	73	,	2.25458171	,	-0.837728834	),
  (	73	,	2.345161314	,	-0.772576202	),
  (	73	,	2.3675087	,	-0.745386905	),
  (	73	,	3.112521217	,	-1.141522273	),
  (	73	,	3.064950519	,	-1.10204224	),
  (	73	,	3.046318767	,	-1.102992765	),
  (	73	,	3.056998027	,	-1.092028861	),
  (	73	,	3.050674404	,	-1.089475306	),
  (	73	,	3.054826373	,	-1.06789324	),
  (	73	,	3.04101058	,	-1.067840812	),
  (	73	,	3.043989209	,	-1.064356544	),
  (	73	,	2.955981654	,	-1.031579265	),
  (	73	,	2.967091859	,	-1.033026336	),
  (	73	,	2.914504633	,	-1.017363283	),
  (	73	,	2.880950641	,	-1.004618712	),
  (	73	,	2.871418274	,	-0.97361091	),
  (	73	,	3.134402495	,	-1.042925562	),
  (	73	,	3.090026003	,	-1.01615711	),
  (	73	,	2.907386204	,	-0.880476215	),
  (	73	,	2.809793788	,	-1.039301511	),
  (	73	,	2.817550397	,	-1.036861787	),
  (	73	,	2.75914996	,	-1.02181774	),
  (	73	,	2.730441298	,	-0.959727007	),
  (	73	,	2.670259801	,	-0.95967016	),
  (	73	,	2.757019103	,	-0.911619071	),
  (	73	,	2.681135285	,	-0.904330728	),
  (	73	,	2.718854193	,	-0.881860567	),
  (	73	,	2.810493567	,	-0.853407794	),
  (	73	,	2.901483309	,	-0.84119821	),
  (	73	,	2.837408464	,	-0.857172557	),
  (	73	,	2.738816728	,	-0.773919096	),
  (	73	,	2.78110809	,	-0.759624239	),
  (	73	,	2.754222349	,	-0.73704213	),
  (	73	,	3.139281148	,	-0.857660328	),
  (	73	,	3.049068166	,	-0.835162819	),
  (	73	,	2.95976685	,	-0.851499159	),
  (	73	,	2.941263316	,	-0.848238957	),
  (	73	,	2.951587559	,	-0.800747536	),
  (	73	,	2.991921369	,	-0.800765223	),
  (	73	,	3.095611383	,	-0.804030124	),
  (	73	,	2.999734647	,	-0.695977129	),
  (	73	,	2.927066631	,	-0.795597421	),
  (	73	,	2.898988099	,	-0.744864545	),
  (	73	,	2.779291066	,	-0.721539365	),
  (	73	,	2.977343187	,	-0.682509466	),
  (	73	,	2.637467543	,	-0.904051745	),
  (	73	,	2.602116781	,	-0.83346203	),
  (	73	,	2.529695198	,	-0.875072874	),
  (	73	,	2.669981325	,	-0.780654697	),
  (	73	,	2.708774992	,	-0.748265421	),
  (	73	,	2.705635213	,	-0.692938953	),
  (	73	,	2.6259086	,	-0.741511082	),
  (	73	,	2.48640767	,	-0.767226809	),
  (	73	,	2.477377181	,	-0.743131099	),
  (	73	,	2.430073196	,	-0.700163193	),
  (	73	,	2.42537553	,	-0.656753537	),
  (	73	,	2.567671808	,	-0.656873997	),
  (	73	,	2.594172825	,	-0.609239719	),
  (	73	,	2.508706581	,	-0.599824702	),
  (	73	,	2.825495118	,	-0.551580397	),
  (	73	,	2.861696188	,	-0.554775325	),
  (	73	,	2.86003446	,	-0.470872043	),
  (	73	,	2.654570318	,	-0.611103628	),
  (	73	,	2.674019225	,	-0.567504436	),
  (	73	,	2.788870664	,	-0.451198508	),
  (	73	,	2.720522958	,	-0.454763405	),
  (	73	,	2.72460051	,	-0.446204221	),
  (	73	,	2.723674606	,	-0.429456183	),
  (	73	,	1.571354794	,	-1.122417799	),
  (	73	,	1.729865996	,	-1.004241695	),
  (	73	,	1.821570902	,	-0.971584423	),
  (	73	,	1.964799639	,	-0.998508135	),
  (	73	,	2.063188887	,	-0.924527163	),
  (	73	,	1.934571181	,	-0.933891329	),
  (	73	,	1.726026357	,	-0.877830329	),
  (	73	,	1.85207586	,	-0.879160528	),
  (	73	,	2.011570545	,	-0.834811074	),
  (	73	,	1.989157762	,	-0.823021368	),
  (	73	,	1.823645461	,	-0.857769432	),
  (	73	,	1.916872859	,	-0.806958914	),
  (	73	,	1.915188774	,	-0.790572621	),
  (	73	,	2.131361983	,	-0.918335932	),
  (	73	,	2.145263019	,	-0.873852105	),
  (	73	,	2.090776303	,	-0.898249675	),
  (	73	,	2.211160931	,	-0.854447258	),
  (	73	,	2.081245535	,	-0.85983483	),
  (	73	,	2.094798742	,	-0.853559215	),
  (	73	,	2.111559933	,	-0.834542081	),
  (	73	,	2.036495909	,	-0.83971246	),
  (	73	,	2.090186986	,	-0.822762317	),
  (	73	,	2.095474416	,	-0.799235053	),
  (	73	,	2.193125595	,	-0.783053242	),
  (	73	,	2.249036061	,	-0.830278937	),
  (	73	,	2.243339234	,	-0.777453215	),
  (	73	,	2.306074347	,	-0.740030278	),
  (	73	,	2.307804645	,	-0.680154188	),
  (	73	,	2.210783985	,	-0.742188108	),
  (	73	,	2.17684072	,	-0.742231526	),
  (	73	,	2.258722324	,	-0.705730418	),
  (	73	,	2.265257272	,	-0.705448402	),
  (	73	,	2.265938962	,	-0.694632628	),
  (	73	,	2.24354611	,	-0.693399771	),
  (	73	,	2.234676954	,	-0.697308798	),
  (	73	,	2.230088094	,	-0.68174171	),
  (	73	,	2.071875975	,	-0.79698835	),
  (	73	,	2.081840825	,	-0.758938182	),
  (	73	,	2.114043777	,	-0.746280207	),
  (	73	,	2.011305657	,	-0.753713743	),
  (	73	,	2.013083649	,	-0.71846052	),
  (	73	,	1.993878703	,	-0.701485094	),
  (	73	,	2.090589657	,	-0.664108684	),
  (	73	,	2.045601098	,	-0.666792066	),
  (	73	,	2.188039277	,	-0.692962893	),
  (	73	,	2.142206088	,	-0.682041384	),
  (	73	,	2.16188501	,	-0.652264433	),
  (	73	,	2.199174754	,	-0.640815949	),
  (	73	,	2.092257364	,	-0.651048589	),
  (	73	,	2.129326592	,	-0.61454979	),
  (	73	,	1.58303135	,	-0.935194417	),
  (	73	,	1.785584471	,	-0.815234312	),
  (	73	,	1.600113745	,	-0.859076469	),
  (	73	,	1.744368611	,	-0.757522306	),
  (	73	,	1.828229331	,	-0.820712769	),
  (	73	,	1.821787233	,	-0.764254468	),
  (	73	,	1.888805015	,	-0.765941252	),
  (	73	,	1.783370411	,	-0.764478815	),
  (	73	,	1.831932341	,	-0.715606551	),
  (	73	,	1.83736812	,	-0.712004849	),
  (	73	,	1.908641659	,	-0.681109866	),
  (	73	,	1.643881485	,	-0.761730347	),
  (	73	,	1.683246881	,	-0.715159781	),
  (	73	,	1.715645652	,	-0.660116644	),
  (	73	,	1.684066973	,	-0.616752403	),
  (	73	,	1.936666721	,	-0.690066243	),
  (	73	,	1.916120834	,	-0.663884138	),
  (	73	,	1.898905424	,	-0.632255738	),
  (	73	,	2.074572984	,	-0.529746377	),
  (	73	,	2.099616306	,	-0.508955958	),
  (	73	,	1.999211542	,	-0.548963438	),
  (	73	,	2.017756152	,	-0.483977695	),
  (	73	,	2.105841223	,	-0.48073909	),
  (	73	,	2.068119854	,	-0.459873116	),
  (	73	,	1.824472671	,	-0.536634216	),
  (	73	,	1.832797979	,	-0.524969743	),
  (	73	,	1.828582513	,	-0.505482382	),
  (	73	,	1.841090165	,	-0.465863447	),
  (	73	,	1.990284916	,	-0.480032209	),
  (	73	,	1.916219085	,	-0.446208611	),
  (	73	,	1.930304815	,	-0.434654543	),
  (	73	,	1.896166179	,	-0.441610162	),
  (	73	,	1.889500909	,	-0.422803577	),
  (	73	,	2.00893966	,	-0.384770218	),
  (	73	,	2.391625435	,	-0.652033851	),
  (	73	,	2.44326345	,	-0.619550951	),
  (	73	,	2.420651383	,	-0.62765394	),
  (	73	,	2.29425937	,	-0.641285386	),
  (	73	,	2.312225854	,	-0.639068552	),
  (	73	,	2.472198892	,	-0.591625255	),
  (	73	,	2.446680588	,	-0.554319983	),
  (	73	,	2.488677685	,	-0.550647139	),
  (	73	,	2.519737413	,	-0.520150661	),
  (	73	,	2.486963879	,	-0.492933003	),
  (	73	,	2.407869737	,	-0.49418113	),
  (	73	,	2.445375757	,	-0.50836131	),
  (	73	,	2.268209269	,	-0.593585363	),
  (	73	,	2.278568108	,	-0.56254243	),
  (	73	,	2.228839505	,	-0.543398597	),
  (	73	,	2.197801489	,	-0.530440426	),
  (	73	,	2.183023986	,	-0.515591664	),
  (	73	,	2.410408118	,	-0.446818706	),
  (	73	,	2.346051842	,	-0.433562624	),
  (	73	,	2.650876278	,	-0.39251773	),
  (	73	,	2.569056445	,	-0.337090102	),
  (	73	,	2.658393718	,	-0.316587312	),
  (	73	,	2.469339612	,	-0.362364418	),
  (	73	,	2.458749404	,	-0.29088044	),
  (	73	,	2.182012311	,	-0.409486532	),
  (	73	,	2.111940185	,	-0.470768181	),
  (	73	,	2.152312506	,	-0.423987455	),
  (	73	,	2.188230433	,	-0.362931849	),
  (	73	,	2.233951489	,	-0.320989084	),
  (	73	,	2.036655371	,	-0.36357405	),
  (	73	,	2.095137577	,	-0.295895084	),
  (	73	,	2.227128529	,	-0.235068567	),
  (	73	,	2.162283638	,	-0.237788481	),
  (	73	,	2.335440044	,	-0.318640152	),
  (	73	,	2.342348704	,	-0.304270089	),
  (	73	,	2.334192151	,	-0.275391856	),
  (	73	,	2.443099609	,	-0.232231661	),
  (	73	,	2.432490539	,	-0.208780866	),
  (	73	,	2.394676344	,	-0.187767106	),
  (	73	,	2.377810018	,	-0.176655506	),
  (	73	,	2.421139293	,	-0.152855768	),
  (	73	,	2.479333557	,	-0.134753467	),
  (	73	,	2.35951363	,	-0.160422344	),
  (	73	,	2.286673015	,	-0.073341739	),
  (	73	,	2.391212765	,	-0.04322088	),
  (	73	,	2.336035063	,	-0.054943713	),
  (	73	,	3.470131573	,	-1.528241164	),
  (	73	,	3.5777891	,	-1.464474837	),
  (	73	,	4.702555184	,	-1.452747132	),
  (	73	,	4.640122204	,	-1.373449507	),
  (	73	,	3.35773467	,	-1.408521858	),
  (	73	,	3.80409597	,	-1.331232329	),
  (	73	,	4.085012464	,	-1.27128681	),
  (	73	,	4.035213549	,	-1.244828875	),
  (	73	,	3.81790287	,	-1.212187791	),
  (	73	,	4.618123987	,	-1.307454037	),
  (	73	,	4.461273158	,	-1.26727177	),
  (	73	,	4.635798573	,	-1.280949386	),
  (	73	,	4.293826999	,	-1.224272516	),
  (	73	,	4.60813075	,	-1.167016664	),
  (	73	,	4.34017914	,	-1.152164252	),
  (	73	,	4.057273277	,	-1.177837143	),
  (	73	,	3.96409694	,	-1.160224191	),
  (	73	,	4.375464058	,	-1.088562795	),
  (	73	,	4.187043861	,	-1.096328825	),
  (	73	,	4.250276976	,	-1.012970335	),
  (	73	,	4.231142588	,	-0.985113263	),
  (	73	,	3.364988824	,	-1.215538341	),
  (	73	,	3.872343746	,	-1.155044998	),
  (	73	,	3.743126657	,	-1.10677382	),
  (	73	,	3.167035402	,	-1.214279115	),
  (	73	,	3.168395718	,	-1.206461192	),
  (	73	,	3.287681857	,	-1.200053114	),
  (	73	,	3.355571962	,	-1.144817112	),
  (	73	,	3.459367304	,	-1.074166831	),
  (	73	,	3.673465689	,	-1.051697698	),
  (	73	,	3.525670907	,	-1.065742329	),
  (	73	,	3.527130263	,	-1.039042434	),
  (	73	,	3.61574019	,	-1.038396662	),
  (	73	,	3.670890748	,	-0.99882887	),
  (	73	,	3.641790003	,	-0.972819409	),
  (	73	,	3.948278945	,	-1.105253529	),
  (	73	,	3.861473659	,	-1.073756121	),
  (	73	,	3.8900414	,	-1.06342934	),
  (	73	,	3.946611863	,	-1.007028593	),
  (	73	,	3.946173467	,	-0.993389392	),
  (	73	,	3.878901585	,	-1.014373174	),
  (	73	,	4.129078845	,	-1.009018211	),
  (	73	,	4.117547398	,	-1.00272771	),
  (	73	,	4.015192269	,	-1.001789251	),
  (	73	,	4.163676595	,	-0.935201087	),
  (	73	,	4.008876844	,	-0.948835953	),
  (	73	,	3.975646139	,	-0.916931297	),
  (	73	,	3.818546696	,	-0.987205233	),
  (	73	,	3.737325222	,	-1.000031757	),
  (	73	,	3.748750241	,	-0.975330343	),
  (	73	,	3.753479907	,	-0.973738705	),
  (	73	,	3.806925603	,	-0.907060741	),
  (	73	,	3.990073747	,	-0.820970582	),
  (	73	,	3.893209194	,	-0.784133981	),
  (	73	,	4.659010142	,	-1.10938575	),
  (	73	,	4.615996858	,	-1.037301806	),
  (	73	,	4.450216217	,	-1.035509823	),
  (	73	,	4.599809662	,	-0.958147719	),
  (	73	,	4.689433773	,	-0.975612956	),
  (	73	,	4.535715728	,	-0.961967536	),
  (	73	,	4.570840257	,	-0.928908058	),
  (	73	,	4.354514819	,	-1.023302372	),
  (	73	,	4.362210961	,	-0.994742212	),
  (	73	,	4.273240686	,	-0.95145353	),
  (	73	,	4.271887946	,	-0.862304157	),
  (	73	,	4.463132902	,	-0.875466315	),
  (	73	,	4.415169481	,	-0.857222661	),
  (	73	,	4.384625624	,	-0.831561812	),
  (	73	,	4.310896188	,	-0.807233448	),
  (	73	,	4.368093443	,	-0.83332734	),
  (	73	,	4.314591035	,	-0.78212799	),
  (	73	,	4.671277199	,	-0.863862371	),
  (	73	,	4.541534534	,	-0.79274792	),
  (	73	,	4.711129166	,	-0.833613054	),
  (	73	,	4.61906681	,	-0.745850111	),
  (	73	,	4.615985355	,	-0.742987696	),
  (	73	,	4.70360285	,	-0.732052052	),
  (	73	,	4.655051849	,	-0.704961266	),
  (	73	,	4.596692195	,	-0.740014606	),
  (	73	,	4.58894975	,	-0.716276386	),
  (	73	,	4.546388714	,	-0.736209	),
  (	73	,	4.62117195	,	-0.659322989	),
  (	73	,	4.462809071	,	-0.78285183	),
  (	73	,	4.422127346	,	-0.735157405	),
  (	73	,	4.455393224	,	-0.734292043	),
  (	73	,	4.406663494	,	-0.752372975	),
  (	73	,	4.424794825	,	-0.716972326	),
  (	73	,	4.458114123	,	-0.58235493	),
  (	73	,	4.114039768	,	-0.772080237	),
  (	73	,	4.185215403	,	-0.676295002	),
  (	73	,	4.190412211	,	-0.680573699	),
  (	73	,	4.048574406	,	-0.709644411	),
  (	73	,	4.006770873	,	-0.722940107	),
  (	73	,	3.941598298	,	-0.720324357	),
  (	73	,	4.050132167	,	-0.65203322	),
  (	73	,	4.132512659	,	-0.619909745	),
  (	73	,	4.350423523	,	-0.675030016	),
  (	73	,	4.289969248	,	-0.609561311	),
  (	73	,	4.232468122	,	-0.622089059	),
  (	73	,	4.403987629	,	-0.593714318	),
  (	73	,	4.430805183	,	-0.567294699	),
  (	73	,	4.459047143	,	-0.487628673	),
  (	73	,	4.386519854	,	-0.537677577	),
  (	73	,	4.273996945	,	-0.539335802	),
  (	73	,	4.15918616	,	-0.537198831	),
  (	73	,	4.187309282	,	-0.52505465	),
  (	73	,	4.186432456	,	-0.471524418	),
  (	73	,	4.399234099	,	-0.428072415	),
  (	73	,	4.300423506	,	-0.408500745	),
  (	73	,	3.192812119	,	-1.133575919	),
  (	73	,	3.159335158	,	-1.12641641	),
  (	73	,	3.165714133	,	-1.121785817	),
  (	73	,	3.349277597	,	-1.048611124	),
  (	73	,	3.152088016	,	-1.08931964	),
  (	73	,	3.197739798	,	-1.041181582	),
  (	73	,	3.271406751	,	-1.030163748	),
  (	73	,	3.362552088	,	-1.015188956	),
  (	73	,	3.419160823	,	-0.988646763	),
  (	73	,	3.633847293	,	-0.952601064	),
  (	73	,	3.656196132	,	-0.937317023	),
  (	73	,	3.576881726	,	-0.945065421	),
  (	73	,	3.438368662	,	-0.984101043	),
  (	73	,	3.510729901	,	-0.940983685	),
  (	73	,	3.432316875	,	-0.95130811	),
  (	73	,	3.611414467	,	-0.874849449	),
  (	73	,	3.568909986	,	-0.883158462	),
  (	73	,	3.167886048	,	-0.946973776	),
  (	73	,	3.45519115	,	-0.921748506	),
  (	73	,	3.485068618	,	-0.870540761	),
  (	73	,	3.544881343	,	-0.82505616	),
  (	73	,	3.404627295	,	-0.848295225	),
  (	73	,	3.680525257	,	-0.90860856	),
  (	73	,	3.727072963	,	-0.892947312	),
  (	73	,	3.658482918	,	-0.845878654	),
  (	73	,	3.642031651	,	-0.84010925	),
  (	73	,	3.655087183	,	-0.82047359	),
  (	73	,	3.801771975	,	-0.821565416	),
  (	73	,	3.848628139	,	-0.8080523	),
  (	73	,	3.914798014	,	-0.735440543	),
  (	73	,	3.904774181	,	-0.72196251	),
  (	73	,	3.589821011	,	-0.753735951	),
  (	73	,	3.647627084	,	-0.687829349	),
  (	73	,	3.780625648	,	-0.580325465	),
  (	73	,	3.683158735	,	-0.650382063	),
  (	73	,	3.685363299	,	-0.622130488	),
  (	73	,	3.699180449	,	-0.609983677	),
  (	73	,	3.290579077	,	-0.873716956	),
  (	73	,	3.174512198	,	-0.795541296	),
  (	73	,	3.173800242	,	-0.754794071	),
  (	73	,	3.268727791	,	-0.607978955	),
  (	73	,	3.499159697	,	-0.678146073	),
  (	73	,	3.546671866	,	-0.643216033	),
  (	73	,	3.601813939	,	-0.6270192	),
  (	73	,	3.567322151	,	-0.611720341	),
  (	73	,	3.644554871	,	-0.560238349	),
  (	73	,	3.628693314	,	-0.546638173	),
  (	73	,	3.570891658	,	-0.520782687	),
  (	73	,	3.419816347	,	-0.597780911	),
  (	73	,	3.422598483	,	-0.495799345	),
  (	73	,	3.527755927	,	-0.478052172	),
  (	73	,	3.496737896	,	-0.397829569	),
  (	73	,	3.966422782	,	-0.672552558	),
  (	73	,	3.904769042	,	-0.635833054	),
  (	73	,	4.023616497	,	-0.561816565	),
  (	73	,	3.950137456	,	-0.523433241	),
  (	73	,	4.017264927	,	-0.453636545	),
  (	73	,	3.856067421	,	-0.523543151	),
  (	73	,	3.848245103	,	-0.489839417	),
  (	73	,	3.946855327	,	-0.493937527	),
  (	73	,	4.000294928	,	-0.419052218	),
  (	73	,	3.953997556	,	-0.407065206	),
  (	73	,	3.86592694	,	-0.444100833	),
  (	73	,	4.115458272	,	-0.443587512	),
  (	73	,	4.080875912	,	-0.449148746	),
  (	73	,	4.198500981	,	-0.395975467	),
  (	73	,	4.182271958	,	-0.36466018	),
  (	73	,	3.969804725	,	-0.358155153	),
  (	73	,	3.98954901	,	-0.330798601	),
  (	73	,	4.113606487	,	-0.279497524	),
  (	73	,	4.114701282	,	-0.190862348	),
  (	73	,	3.844573811	,	-0.394770507	),
  (	73	,	3.822826997	,	-0.387067046	),
  (	73	,	3.881005337	,	-0.347382637	),
  (	73	,	3.845929265	,	-0.347811725	),
  (	73	,	3.799872876	,	-0.361604435	),
  (	73	,	3.616984821	,	-0.362125393	),
  (	73	,	3.676275432	,	-0.345749808	),
  (	73	,	3.661101025	,	-0.32503026	),
  (	73	,	3.696736763	,	-0.282577819	),
  (	73	,	3.883820752	,	-0.270978239	),
  (	73	,	3.887985066	,	-0.262278545	),
  (	73	,	3.88598363	,	-0.209759358	),
  (	73	,	4.000341313	,	-0.227577117	),
  (	73	,	4.011480981	,	-0.159642903	),
  (	73	,	3.920810255	,	-0.152146809	),
  (	73	,	5.576451708	,	-1.487043705	),
  (	73	,	5.714329496	,	-1.43875086	),
  (	73	,	5.594709442	,	-1.452290952	),
  (	73	,	5.527212101	,	-1.408464605	),
  (	73	,	5.961984445	,	-1.316364784	),
  (	73	,	5.031580897	,	-1.358982763	),
  (	73	,	5.418272527	,	-1.315063559	),
  (	73	,	6.19433307	,	-1.269330347	),
  (	73	,	6.228183081	,	-1.244546603	),
  (	73	,	6.23762204	,	-1.15642333	),
  (	73	,	6.070169262	,	-1.102874776	),
  (	73	,	6.020260784	,	-1.095583291	),
  (	73	,	5.806126479	,	-1.192572234	),
  (	73	,	5.632212233	,	-1.085039093	),
  (	73	,	5.867207044	,	-1.145310066	),
  (	73	,	5.725398548	,	-1.083029097	),
  (	73	,	5.746261234	,	-1.079424096	),
  (	73	,	5.1734007	,	-1.232676076	),
  (	73	,	5.36119368	,	-1.182604681	),
  (	73	,	5.023969326	,	-1.149766645	),
  (	73	,	4.91690607	,	-1.138819983	),
  (	73	,	5.152565608	,	-1.016999212	),
  (	73	,	5.469101747	,	-1.120452431	),
  (	73	,	5.672722567	,	-1.002560399	),
  (	73	,	5.326043906	,	-1.025025121	),
  (	73	,	5.515833673	,	-0.837077595	),
  (	73	,	5.4321623	,	-0.881181728	),
  (	73	,	5.432166304	,	-0.881177711	),
  (	73	,	5.49763203	,	-0.750761317	),
  (	73	,	6.214654915	,	-1.122939239	),
  (	73	,	6.008736627	,	-1.001846247	),
  (	73	,	6.250344859	,	-1.021892367	),
  (	73	,	6.091518482	,	-0.905338278	),
  (	73	,	5.95521189	,	-0.991819349	),
  (	73	,	5.977826999	,	-0.964018883	),
  (	73	,	5.969329919	,	-0.899065304	),
  (	73	,	6.266265065	,	-0.921328224	),
  (	73	,	6.195918131	,	-0.826003791	),
  (	73	,	6.204448613	,	-0.73773503	),
  (	73	,	6.107345541	,	-0.717037474	),
  (	73	,	6.032100534	,	-0.79070469	),
  (	73	,	6.018105014	,	-0.788700002	),
  (	73	,	6.003664843	,	-0.74267919	),
  (	73	,	6.023139209	,	-0.71822975	),
  (	73	,	5.971222503	,	-0.75828454	),
  (	73	,	5.955143013	,	-0.711542716	),
  (	73	,	6.168760284	,	-0.632923646	),
  (	73	,	6.173697427	,	-0.612356191	),
  (	73	,	5.76661648	,	-0.926718769	),
  (	73	,	5.744031615	,	-0.89732803	),
  (	73	,	5.662367203	,	-0.795639853	),
  (	73	,	5.797353851	,	-0.75121841	),
  (	73	,	5.674452681	,	-0.718794745	),
  (	73	,	5.681957709	,	-0.567346362	),
  (	73	,	5.904822914	,	-0.613289212	),
  (	73	,	5.933990886	,	-0.613917773	),
  (	73	,	5.795905341	,	-0.603123509	),
  (	73	,	5.836507672	,	-0.554420391	),
  (	73	,	5.775521661	,	-0.51219405	),
  (	73	,	5.757448403	,	-0.507135216	),
  (	73	,	5.835043412	,	-0.478052812	),
  (	73	,	5.757754618	,	-0.482244717	),
  (	73	,	5.867685425	,	-0.468797709	),
  (	73	,	5.880253726	,	-0.461096207	),
  (	73	,	5.86549565	,	-0.37693959	),
  (	73	,	4.988169142	,	-0.994798466	),
  (	73	,	5.122975918	,	-0.979135565	),
  (	73	,	4.731794499	,	-1.032849087	),
  (	73	,	5.028302114	,	-0.904180957	),
  (	73	,	5.003138435	,	-0.897405702	),
  (	73	,	5.073155358	,	-0.775924791	),
  (	73	,	5.327783137	,	-0.872966962	),
  (	73	,	5.388313584	,	-0.732813787	),
  (	73	,	5.340768995	,	-0.72947126	),
  (	73	,	5.306883671	,	-0.723938397	),
  (	73	,	5.331112437	,	-0.711318667	),
  (	73	,	5.183077363	,	-0.797929253	),
  (	73	,	5.181072821	,	-0.75652443	),
  (	73	,	5.2521584	,	-0.629361884	),
  (	73	,	5.323118081	,	-0.569266138	),
  (	73	,	4.948677462	,	-0.824900904	),
  (	73	,	4.939916469	,	-0.777310296	),
  (	73	,	4.914430161	,	-0.731608937	),
  (	73	,	4.73970842	,	-0.811159961	),
  (	73	,	4.755186163	,	-0.784449707	),
  (	73	,	4.81492309	,	-0.738683348	),
  (	73	,	4.772092768	,	-0.717804992	),
  (	73	,	4.783884068	,	-0.706372374	),
  (	73	,	4.947085749	,	-0.633346857	),
  (	73	,	4.933958929	,	-0.598738801	),
  (	73	,	4.871328904	,	-0.61867221	),
  (	73	,	4.889532959	,	-0.590910079	),
  (	73	,	5.095152196	,	-0.699842497	),
  (	73	,	5.103675966	,	-0.53755404	),
  (	73	,	5.197464658	,	-0.479476539	),
  (	73	,	5.029756773	,	-0.590728507	),
  (	73	,	5.046984693	,	-0.556499623	),
  (	73	,	5.044985799	,	-0.531620782	),
  (	73	,	4.957363151	,	-0.514463886	),
  (	73	,	5.116757736	,	-0.489128731	),
  (	73	,	5.08489665	,	-0.426071892	),
  (	73	,	5.114969084	,	-0.375540552	),
  (	73	,	5.089645463	,	-0.370814556	),
  (	73	,	5.510609978	,	-0.682368483	),
  (	73	,	5.474299927	,	-0.696925986	),
  (	73	,	5.520237429	,	-0.649821821	),
  (	73	,	5.409976824	,	-0.628910294	),
  (	73	,	5.605401633	,	-0.61030083	),
  (	73	,	5.461324457	,	-0.513872315	),
  (	73	,	5.378702556	,	-0.499086286	),
  (	73	,	5.430552063	,	-0.492266303	),
  (	73	,	5.392678541	,	-0.467281579	),
  (	73	,	5.529988145	,	-0.476331919	),
  (	73	,	5.53793709	,	-0.412365098	),
  (	73	,	5.636785596	,	-0.443536552	),
  (	73	,	5.872163214	,	-0.353202815	),
  (	73	,	5.589648944	,	-0.36340743	),
  (	73	,	5.680022846	,	-0.345687799	),
  (	73	,	5.660772486	,	-0.321871995	),
  (	73	,	5.737788383	,	-0.266307832	),
  (	73	,	5.766344287	,	-0.272481872	),
  (	73	,	5.752633039	,	-0.2210325	),
  (	73	,	5.644708043	,	-0.282773674	),
  (	73	,	5.678727987	,	-0.259028228	),
  (	73	,	5.275642406	,	-0.457703897	),
  (	73	,	5.343411375	,	-0.450887304	),
  (	73	,	5.360296669	,	-0.421740805	),
  (	73	,	5.258679187	,	-0.467980829	),
  (	73	,	5.310639817	,	-0.372069131	),
  (	73	,	5.369871855	,	-0.36145471	),
  (	73	,	5.361910888	,	-0.310917475	),
  (	73	,	5.406483623	,	-0.289021748	),
  (	73	,	5.182174296	,	-0.297953155	),
  (	73	,	5.238156216	,	-0.277282799	),
  (	73	,	5.240813492	,	-0.243321763	),
  (	73	,	5.518960967	,	-0.299551358	),
  (	73	,	5.462944137	,	-0.199659662	),
  (	73	,	5.471828148	,	-0.190666001	),
  (	73	,	5.474978859	,	-0.155047168	),
  (	73	,	5.32977662	,	-0.177051081	),
  (	73	,	5.38183545	,	-0.108548125	),
  (	73	,	5.427754085	,	-0.097568456	),
  (	73	,	5.428892413	,	-0.068337349	),
  (	74	,	0.791620158	,	0.020178996	),
  (	74	,	0.797026785	,	0.090549955	),
  (	74	,	0.760745956	,	0.134043063	),
  (	74	,	0.905532717	,	0.102453406	),
  (	74	,	0.872374191	,	0.151838914	),
  (	74	,	0.822126197	,	0.188419535	),
  (	74	,	0.680775695	,	0.240070157	),
  (	74	,	0.812825704	,	0.203596707	),
  (	74	,	0.839567572	,	0.288269513	),
  (	74	,	0.7892772	,	0.262334675	),
  (	74	,	1.075050566	,	0.251373841	),
  (	74	,	0.911828985	,	0.261741042	),
  (	74	,	1.155042927	,	0.330093324	),
  (	74	,	1.089643842	,	0.42014939	),
  (	74	,	0.871775662	,	0.332942326	),
  (	74	,	0.887156427	,	0.366004173	),
  (	74	,	1.003836433	,	0.394290882	),
  (	74	,	0.988097497	,	0.423324177	),
  (	74	,	0.947675884	,	0.453597407	),
  (	74	,	0.983753229	,	0.500357295	),
  (	74	,	0.962753255	,	0.502184883	),
  (	74	,	0.579061307	,	0.242922642	),
  (	74	,	0.551936364	,	0.234953093	),
  (	74	,	0.760493886	,	0.358940607	),
  (	74	,	0.692119692	,	0.34431149	),
  (	74	,	0.664117217	,	0.384092567	),
  (	74	,	0.571195833	,	0.415373357	),
  (	74	,	0.5597462	,	0.433178947	),
  (	74	,	0.542596595	,	0.452391135	),
  (	74	,	0.781797668	,	0.348885534	),
  (	74	,	0.78804423	,	0.398442433	),
  (	74	,	0.729788551	,	0.400729617	),
  (	74	,	0.920916988	,	0.484003435	),
  (	74	,	0.859839928	,	0.501937789	),
  (	74	,	0.634717193	,	0.565619925	),
  (	74	,	0.692745619	,	0.583271822	),
  (	74	,	0.836642504	,	0.655957384	),
  (	74	,	0.739343987	,	0.592300165	),
  (	74	,	1.183420937	,	0.407461115	),
  (	74	,	1.134777078	,	0.411872247	),
  (	74	,	1.101373569	,	0.411450801	),
  (	74	,	1.092051716	,	0.418540386	),
  (	74	,	1.110620138	,	0.458238002	),
  (	74	,	1.262144711	,	0.494815049	),
  (	74	,	1.258291816	,	0.519633915	),
  (	74	,	1.289390008	,	0.572186329	),
  (	74	,	1.113422292	,	0.521868967	),
  (	74	,	1.150115024	,	0.626625648	),
  (	74	,	1.397093223	,	0.640093051	),
  (	74	,	1.407552347	,	0.657569951	),
  (	74	,	1.334398257	,	0.62563069	),
  (	74	,	1.311416631	,	0.639268404	),
  (	74	,	1.396598084	,	0.694450763	),
  (	74	,	1.384077025	,	0.688770411	),
  (	74	,	1.483114364	,	0.662490541	),
  (	74	,	1.495706956	,	0.666680244	),
  (	74	,	1.497868128	,	0.717729221	),
  (	74	,	1.466869588	,	0.773642511	),
  (	74	,	1.568819679	,	0.812184451	),
  (	74	,	1.269235154	,	0.659049552	),
  (	74	,	1.301224881	,	0.69911189	),
  (	74	,	1.312006175	,	0.702188739	),
  (	74	,	1.321896122	,	0.742969651	),
  (	74	,	1.222109592	,	0.694436413	),
  (	74	,	1.228822098	,	0.735055356	),
  (	74	,	1.306178769	,	0.756135303	),
  (	74	,	1.272097361	,	0.760581196	),
  (	74	,	1.51550829	,	0.874204645	),
  (	74	,	1.005754661	,	0.594321822	),
  (	74	,	1.013670231	,	0.597288023	),
  (	74	,	0.927946855	,	0.622364773	),
  (	74	,	0.911141418	,	0.624938185	),
  (	74	,	0.994873334	,	0.707395702	),
  (	74	,	1.080266495	,	0.664499081	),
  (	74	,	1.065190001	,	0.689563029	),
  (	74	,	1.014693407	,	0.704512407	),
  (	74	,	1.035987178	,	0.756008433	),
  (	74	,	1.086074719	,	0.806823909	),
  (	74	,	0.921331562	,	0.683253318	),
  (	74	,	0.869699518	,	0.681638847	),
  (	74	,	0.845855642	,	0.765544626	),
  (	74	,	0.882275923	,	0.747380985	),
  (	74	,	0.879194385	,	0.792153457	),
  (	74	,	0.996478478	,	0.74841418	),
  (	74	,	1.053451745	,	0.828164571	),
  (	74	,	1.064362475	,	0.849310944	),
  (	74	,	0.952341551	,	0.830371645	),
  (	74	,	0.912494611	,	0.843041549	),
  (	74	,	0.934698057	,	0.848531775	),
  (	74	,	0.99339329	,	0.899344572	),
  (	74	,	1.326668933	,	0.83190697	),
  (	74	,	1.341159332	,	0.877998434	),
  (	74	,	1.370222981	,	0.897617825	),
  (	74	,	1.48661309	,	0.917520383	),
  (	74	,	1.336783887	,	0.94954992	),
  (	74	,	1.542155582	,	1.011647065	),
  (	74	,	1.138645241	,	0.877112337	),
  (	74	,	1.249390124	,	0.971363368	),
  (	74	,	1.109911036	,	0.951627595	),
  (	74	,	0.359588203	,	0.385483523	),
  (	74	,	0.395545848	,	0.452308231	),
  (	74	,	0.43301496	,	0.48443401	),
  (	74	,	0.381114612	,	0.519595132	),
  (	74	,	0.233860123	,	0.507545267	),
  (	74	,	0.257912926	,	0.566459651	),
  (	74	,	0.302050362	,	0.592389638	),
  (	74	,	0.456599817	,	0.64469168	),
  (	74	,	0.389273509	,	0.639273955	),
  (	74	,	0.385851206	,	0.64700273	),
  (	74	,	0.633411295	,	0.591085975	),
  (	74	,	0.673241734	,	0.613480128	),
  (	74	,	0.518252743	,	0.638837243	),
  (	74	,	0.5799685	,	0.70978484	),
  (	74	,	0.582457059	,	0.711921316	),
  (	74	,	0.682052495	,	0.701706173	),
  (	74	,	0.629522822	,	0.695139868	),
  (	74	,	0.685174371	,	0.73412639	),
  (	74	,	0.513619056	,	0.657458632	),
  (	74	,	0.437583624	,	0.69093387	),
  (	74	,	0.570167957	,	0.891065373	),
  (	74	,	0.202480496	,	0.540043272	),
  (	74	,	0.224325465	,	0.569962758	),
  (	74	,	0.218049872	,	0.610412531	),
  (	74	,	0.223425706	,	0.663956513	),
  (	74	,	0.194691937	,	0.709986938	),
  (	74	,	0.279576735	,	0.675242205	),
  (	74	,	0.294451521	,	0.720096556	),
  (	74	,	0.319014996	,	0.727000128	),
  (	74	,	0.342756042	,	0.755397275	),
  (	74	,	0.293900551	,	0.759627317	),
  (	74	,	0.297475164	,	0.781839389	),
  (	74	,	0.000653587	,	0.819257238	),
  (	74	,	0.216080337	,	0.811771383	),
  (	74	,	0.126317768	,	0.844978047	),
  (	74	,	0.158204063	,	0.847457192	),
  (	74	,	0.073574874	,	0.813569855	),
  (	74	,	0.344931093	,	0.797718619	),
  (	74	,	0.318086061	,	0.900623847	),
  (	74	,	0.273411825	,	0.922421718	),
  (	74	,	0.453280671	,	0.866668439	),
  (	74	,	0.469952987	,	0.942554665	),
  (	74	,	0.437247279	,	0.950256236	),
  (	74	,	0.433229022	,	0.952958576	),
  (	74	,	0.454799293	,	0.957948293	),
  (	74	,	0.351732917	,	0.959264011	),
  (	74	,	0.407334971	,	0.97420267	),
  (	74	,	0.099464956	,	0.95374227	),
  (	74	,	0.113909153	,	0.968498624	),
  (	74	,	0.214811064	,	0.996146031	),
  (	74	,	0.162632294	,	1.012573679	),
  (	74	,	0.120757053	,	1.021958641	),
  (	74	,	0.094716333	,	1.076720461	),
  (	74	,	0.005519082	,	1.053397756	),
  (	74	,	0.153538448	,	1.099372034	),
  (	74	,	0.026425227	,	1.111419469	),
  (	74	,	0.011525376	,	1.153669118	),
  (	74	,	0.807480567	,	0.918535977	),
  (	74	,	0.874291461	,	0.96930571	),
  (	74	,	0.663702439	,	0.8758215	),
  (	74	,	0.70305752	,	0.982097202	),
  (	74	,	0.662551964	,	1.004089013	),
  (	74	,	0.654393424	,	1.009161707	),
  (	74	,	0.596785431	,	0.995349807	),
  (	74	,	0.640368173	,	1.00669146	),
  (	74	,	0.785707118	,	0.963209847	),
  (	74	,	0.835702437	,	1.058279972	),
  (	74	,	0.802013258	,	1.052649187	),
  (	74	,	0.746708095	,	1.054488461	),
  (	74	,	0.708642378	,	1.088360675	),
  (	74	,	0.698221194	,	1.092608294	),
  (	74	,	0.81019962	,	1.137195744	),
  (	74	,	1.078653642	,	0.99023695	),
  (	74	,	1.128345492	,	1.055814859	),
  (	74	,	1.059934543	,	1.089457365	),
  (	74	,	1.412301912	,	1.119172839	),
  (	74	,	1.363050469	,	1.181221198	),
  (	74	,	1.282134153	,	1.190635455	),
  (	74	,	0.925649159	,	1.086781406	),
  (	74	,	0.902706425	,	1.15559518	),
  (	74	,	1.21035092	,	1.191752885	),
  (	74	,	1.385475662	,	1.300891502	),
  (	74	,	0.609519039	,	1.047424353	),
  (	74	,	0.326228025	,	1.063581695	),
  (	74	,	0.331917811	,	1.080481877	),
  (	74	,	0.404568985	,	1.109921268	),
  (	74	,	0.520331122	,	1.170127704	),
  (	74	,	0.592308539	,	1.181067623	),
  (	74	,	0.307799666	,	1.120053181	),
  (	74	,	0.051669461	,	1.154122294	),
  (	74	,	0.151087903	,	1.178384538	),
  (	74	,	0.232883751	,	1.220965471	),
  (	74	,	0.388573041	,	1.295108581	),
  (	74	,	0.01482429	,	1.277136169	),
  (	74	,	0.038129533	,	1.29529473	),
  (	74	,	0.049642934	,	1.29999876	),
  (	74	,	0.196884162	,	1.325352993	),
  (	74	,	0.645432886	,	1.286522694	),
  (	74	,	0.754486652	,	1.27892856	),
  (	74	,	0.872442398	,	1.313139191	),
  (	74	,	0.818489567	,	1.323024077	),
  (	74	,	1.0795674	,	1.312014797	),
  (	74	,	1.211800377	,	1.378571008	),
  (	74	,	1.208113511	,	1.411659453	),
  (	74	,	0.357709714	,	1.338843137	),
  (	74	,	0.50644416	,	1.412109207	),
  (	74	,	0.485395852	,	1.420253987	),
  (	74	,	2.361004594	,	0.022342824	),
  (	74	,	2.379125036	,	0.042133187	),
  (	74	,	2.300232426	,	0.076060973	),
  (	74	,	2.321534272	,	0.077948417	),
  (	74	,	2.475197236	,	0.108774111	),
  (	74	,	2.441317532	,	0.170870778	),
  (	74	,	2.267771705	,	0.10056952	),
  (	74	,	2.250822962	,	0.115572436	),
  (	74	,	2.300581517	,	0.132804659	),
  (	74	,	2.252271449	,	0.240463583	),
  (	74	,	2.383287816	,	0.276850106	),
  (	74	,	2.363730195	,	0.29811925	),
  (	74	,	2.681395426	,	0.28166596	),
  (	74	,	2.463964364	,	0.309106301	),
  (	74	,	2.463180925	,	0.316624774	),
  (	74	,	2.395627626	,	0.304899062	),
  (	74	,	2.153605536	,	0.18931009	),
  (	74	,	2.18989128	,	0.237783691	),
  (	74	,	2.130992235	,	0.229570579	),
  (	74	,	2.106228339	,	0.260914863	),
  (	74	,	2.323832058	,	0.317502307	),
  (	74	,	2.268667995	,	0.34126263	),
  (	74	,	2.004057718	,	0.351659302	),
  (	74	,	2.123061949	,	0.391938707	),
  (	74	,	2.177965708	,	0.421927662	),
  (	74	,	2.118903679	,	0.480499959	),
  (	74	,	2.336367776	,	0.460935416	),
  (	74	,	2.448602904	,	0.439163777	),
  (	74	,	2.460225037	,	0.602971387	),
  (	74	,	2.254581454	,	0.452690117	),
  (	74	,	2.350476704	,	0.564955055	),
  (	74	,	2.33428704	,	0.571484325	),
  (	74	,	2.341608557	,	0.580453345	),
  (	74	,	2.343457335	,	0.611270709	),
  (	74	,	2.266553124	,	0.619937348	),
  (	74	,	2.308221802	,	0.669251361	),
  (	74	,	2.732569066	,	0.431363546	),
  (	74	,	2.900083551	,	0.548675955	),
  (	74	,	2.708976691	,	0.535190006	),
  (	74	,	2.72315494	,	0.596782629	),
  (	74	,	2.68848349	,	0.6137338	),
  (	74	,	2.665689271	,	0.636488784	),
  (	74	,	2.762633558	,	0.684543047	),
  (	74	,	2.923093311	,	0.567775054	),
  (	74	,	3.000846425	,	0.662134824	),
  (	74	,	2.935364058	,	0.625352907	),
  (	74	,	3.011897404	,	0.662417139	),
  (	74	,	2.97403571	,	0.705647067	),
  (	74	,	3.005672401	,	0.746877891	),
  (	74	,	2.847965483	,	0.70111239	),
  (	74	,	3.073903347	,	0.846771816	),
  (	74	,	2.925410195	,	0.834238894	),
  (	74	,	3.070885902	,	0.914468062	),
  (	74	,	2.543455414	,	0.563123416	),
  (	74	,	2.575935976	,	0.626107568	),
  (	74	,	2.536696935	,	0.679793554	),
  (	74	,	2.557302802	,	0.695308429	),
  (	74	,	2.643861275	,	0.690835127	),
  (	74	,	2.690074295	,	0.786160057	),
  (	74	,	2.692236437	,	0.825672941	),
  (	74	,	2.489870821	,	0.781370179	),
  (	74	,	2.541256682	,	0.851279289	),
  (	74	,	2.542646366	,	0.89480407	),
  (	74	,	2.759691048	,	0.771115608	),
  (	74	,	2.809977592	,	0.806450362	),
  (	74	,	2.780219805	,	0.812413247	),
  (	74	,	2.767867486	,	0.857081109	),
  (	74	,	2.805049509	,	0.886614466	),
  (	74	,	2.992878315	,	0.909873444	),
  (	74	,	2.971154356	,	0.903390476	),
  (	74	,	2.825286705	,	1.04935493	),
  (	74	,	3.016407904	,	1.041977832	),
  (	74	,	2.879025146	,	1.028110539	),
  (	74	,	2.918880473	,	1.033502235	),
  (	74	,	2.93289402	,	1.068220691	),
  (	74	,	1.944245104	,	0.357704891	),
  (	74	,	1.956550976	,	0.376104731	),
  (	74	,	2.011715613	,	0.435719108	),
  (	74	,	1.954834494	,	0.457756568	),
  (	74	,	1.973153834	,	0.47341445	),
  (	74	,	2.073173584	,	0.495390497	),
  (	74	,	1.836825851	,	0.473986338	),
  (	74	,	1.902548156	,	0.510596683	),
  (	74	,	1.833106151	,	0.519621094	),
  (	74	,	1.948918353	,	0.551870196	),
  (	74	,	1.91554425	,	0.613620826	),
  (	74	,	2.18871835	,	0.592308036	),
  (	74	,	2.218061119	,	0.587917402	),
  (	74	,	2.232204585	,	0.610279356	),
  (	74	,	2.291541005	,	0.761816228	),
  (	74	,	2.069024793	,	0.641261066	),
  (	74	,	2.10112004	,	0.722330052	),
  (	74	,	2.023636848	,	0.764358815	),
  (	74	,	1.727827437	,	0.563573907	),
  (	74	,	1.789863564	,	0.612056082	),
  (	74	,	1.67210723	,	0.619945125	),
  (	74	,	1.881277608	,	0.698865113	),
  (	74	,	1.78614444	,	0.763734295	),
  (	74	,	1.78903256	,	0.806072453	),
  (	74	,	1.683013627	,	0.664107653	),
  (	74	,	1.648371975	,	0.701423518	),
  (	74	,	1.675074391	,	0.712246549	),
  (	74	,	1.621128967	,	0.764431692	),
  (	74	,	1.590697392	,	0.795623929	),
  (	74	,	1.756985454	,	0.833130503	),
  (	74	,	1.665721457	,	0.79606253	),
  (	74	,	1.668633257	,	0.806248295	),
  (	74	,	1.646498063	,	0.86368457	),
  (	74	,	1.981611244	,	0.80547914	),
  (	74	,	1.882888415	,	0.970618677	),
  (	74	,	1.90038731	,	1.043265463	),
  (	74	,	1.69694892	,	0.909764594	),
  (	74	,	1.749657385	,	0.979115533	),
  (	74	,	1.735191043	,	0.966201813	),
  (	74	,	1.680753186	,	0.901159927	),
  (	74	,	1.659437285	,	0.946826235	),
  (	74	,	1.646895917	,	1.026715772	),
  (	74	,	1.618297679	,	1.032697645	),
  (	74	,	1.757833169	,	0.989480667	),
  (	74	,	1.748773529	,	0.9928069	),
  (	74	,	1.846719913	,	1.011069954	),
  (	74	,	1.579986813	,	1.135503489	),
  (	74	,	2.384013463	,	0.865881964	),
  (	74	,	2.387719481	,	0.901111367	),
  (	74	,	2.482671819	,	0.873206315	),
  (	74	,	2.505918311	,	0.94328687	),
  (	74	,	2.254445204	,	0.861778545	),
  (	74	,	2.182189657	,	0.928471007	),
  (	74	,	2.126788328	,	0.965189692	),
  (	74	,	2.411895896	,	1.076445705	),
  (	74	,	2.350871623	,	1.151936501	),
  (	74	,	2.649560556	,	1.063251743	),
  (	74	,	2.904250394	,	1.131044039	),
  (	74	,	3.028645416	,	1.138670812	),
  (	74	,	3.122731783	,	1.173993149	),
  (	74	,	2.509925199	,	1.062754658	),
  (	74	,	2.659523725	,	1.198408613	),
  (	74	,	2.059777238	,	1.038474091	),
  (	74	,	1.99215872	,	1.136143886	),
  (	74	,	1.969628308	,	1.154269833	),
  (	74	,	1.948606785	,	1.275535165	),
  (	74	,	1.764873377	,	1.336669586	),
  (	74	,	2.256566591	,	1.216472438	),
  (	74	,	2.319053374	,	1.226955481	),
  (	74	,	2.349106206	,	1.363899793	),
  (	74	,	2.044682082	,	1.292289865	),
  (	74	,	1.950229575	,	1.319680438	),
  (	74	,	2.256918939	,	1.34472905	),
  (	74	,	1.936459218	,	1.407193458	),
  (	74	,	1.725469578	,	1.406268087	),
  (	74	,	2.356519088	,	1.443725744	),
  (	74	,	3.041905979	,	1.494309747	),
  (	74	,	2.943031645	,	1.494703169	),
  (	74	,	2.082443345	,	1.419859888	),
  (	74	,	3.955198521	,	0.05252011	),
  (	74	,	3.929522478	,	0.150062717	),
  (	74	,	4.069790976	,	0.191452158	),
  (	74	,	4.032771269	,	0.18421814	),
  (	74	,	4.059619472	,	0.209439875	),
  (	74	,	3.782085022	,	0.146289111	),
  (	74	,	4.095996974	,	0.213857335	),
  (	74	,	4.289477747	,	0.340445181	),
  (	74	,	4.213355065	,	0.382090947	),
  (	74	,	4.056755729	,	0.282604662	),
  (	74	,	4.117023408	,	0.400014959	),
  (	74	,	4.119404122	,	0.426915058	),
  (	74	,	3.670977513	,	0.239684537	),
  (	74	,	3.776482178	,	0.359295598	),
  (	74	,	3.580889103	,	0.349307309	),
  (	74	,	3.732559665	,	0.48405296	),
  (	74	,	3.958794287	,	0.399823792	),
  (	74	,	3.943664567	,	0.454458724	),
  (	74	,	3.961935461	,	0.497739228	),
  (	74	,	3.974515164	,	0.510142561	),
  (	74	,	3.966059504	,	0.580594125	),
  (	74	,	3.937847731	,	0.580746815	),
  (	74	,	4.352971161	,	0.391736118	),
  (	74	,	4.369071974	,	0.391585784	),
  (	74	,	4.428419264	,	0.491089579	),
  (	74	,	4.475137371	,	0.517023666	),
  (	74	,	4.385518794	,	0.494942774	),
  (	74	,	4.184862574	,	0.513671096	),
  (	74	,	4.368024193	,	0.6318275	),
  (	74	,	4.290429951	,	0.621537711	),
  (	74	,	4.485169723	,	0.560341299	),
  (	74	,	4.492344722	,	0.582143368	),
  (	74	,	4.579167942	,	0.60979413	),
  (	74	,	4.539885825	,	0.617339655	),
  (	74	,	4.556116544	,	0.644427443	),
  (	74	,	4.479793639	,	0.616508244	),
  (	74	,	4.457401006	,	0.745731415	),
  (	74	,	4.50462288	,	0.763380854	),
  (	74	,	4.58271437	,	0.827333719	),
  (	74	,	4.509328122	,	0.791894088	),
  (	74	,	4.59474915	,	0.861236342	),
  (	74	,	4.115666244	,	0.547748122	),
  (	74	,	4.181833901	,	0.660213003	),
  (	74	,	4.247523564	,	0.695069228	),
  (	74	,	4.078785712	,	0.769133043	),
  (	74	,	4.040373399	,	0.773220165	),
  (	74	,	4.03820282	,	0.801948122	),
  (	74	,	4.131597876	,	0.820065707	),
  (	74	,	4.195526016	,	0.822795366	),
  (	74	,	4.305972516	,	0.784602336	),
  (	74	,	4.460478938	,	0.865576325	),
  (	74	,	4.297892222	,	0.902627535	),
  (	74	,	4.693697384	,	1.071564009	),
  (	74	,	4.599622898	,	1.048741379	),
  (	74	,	4.457199007	,	1.021996278	),
  (	74	,	4.553684149	,	1.064628789	),
  (	74	,	4.709029097	,	1.119501036	),
  (	74	,	3.575410348	,	0.465731122	),
  (	74	,	3.463967412	,	0.448514636	),
  (	74	,	3.616110969	,	0.486617605	),
  (	74	,	3.680259543	,	0.480137903	),
  (	74	,	3.656241528	,	0.568993601	),
  (	74	,	3.455904624	,	0.559992689	),
  (	74	,	3.489392571	,	0.629765721	),
  (	74	,	3.544621892	,	0.642595436	),
  (	74	,	3.725272393	,	0.54446075	),
  (	74	,	3.756141356	,	0.635166961	),
  (	74	,	3.767829093	,	0.686380892	),
  (	74	,	3.708803998	,	0.711713738	),
  (	74	,	3.697269507	,	0.734754834	),
  (	74	,	3.768207184	,	0.862278545	),
  (	74	,	3.295101493	,	0.635742161	),
  (	74	,	3.453469518	,	0.711962676	),
  (	74	,	3.224962479	,	0.703591543	),
  (	74	,	3.57969932	,	0.928369857	),
  (	74	,	3.359815748	,	0.955667768	),
  (	74	,	3.170980952	,	1.005317758	),
  (	74	,	3.396899979	,	1.077164564	),
  (	74	,	3.147673831	,	1.154063132	),
  (	74	,	3.917028538	,	0.776084016	),
  (	74	,	3.982528043	,	0.847899769	),
  (	74	,	4.042480008	,	0.908490368	),
  (	74	,	3.844247915	,	0.911677794	),
  (	74	,	3.811241943	,	0.923462656	),
  (	74	,	3.694373375	,	0.930480657	),
  (	74	,	3.91539398	,	1.006163757	),
  (	74	,	3.870461753	,	1.042139246	),
  (	74	,	4.331449252	,	1.097028996	),
  (	74	,	4.514158493	,	1.105717813	),
  (	74	,	4.415318975	,	1.185341903	),
  (	74	,	4.538065722	,	1.217428771	),
  (	74	,	4.710704896	,	1.250258686	),
  (	74	,	4.299356971	,	1.170634856	),
  (	74	,	4.181571567	,	1.237372341	),
  (	74	,	4.336771787	,	1.187049509	),
  (	74	,	3.652365195	,	1.095936247	),
  (	74	,	3.773828676	,	1.098442094	),
  (	74	,	3.757492182	,	1.140807292	),
  (	74	,	3.734985056	,	1.131903067	),
  (	74	,	3.776661993	,	1.151705841	),
  (	74	,	3.661592284	,	1.123737728	),
  (	74	,	3.49395583	,	1.206056945	),
  (	74	,	3.163302147	,	1.339744468	),
  (	74	,	4.002391907	,	1.242867639	),
  (	74	,	3.870992824	,	1.327188909	),
  (	74	,	4.418880983	,	1.341333513	),
  (	74	,	4.450912678	,	1.363086697	),
  (	74	,	4.534586256	,	1.384135481	),
  (	74	,	3.546480629	,	1.327537418	),
  (	74	,	3.291067561	,	1.400635832	),
  (	74	,	3.403509753	,	1.411522568	),
  (	74	,	3.378217132	,	1.440206566	),
  (	74	,	3.5109623	,	1.454018979	),
  (	74	,	3.469503595	,	1.479206068	),
  (	74	,	3.618256275	,	1.496584093	),
  (	74	,	5.503764185	,	0.018664479	),
  (	74	,	5.511178701	,	0.029565391	),
  (	74	,	5.49378125	,	0.074938045	),
  (	74	,	5.476489105	,	0.131390613	),
  (	74	,	5.579048119	,	0.15637054	),
  (	74	,	5.577568302	,	0.178887051	),
  (	74	,	5.623802646	,	0.193467601	),
  (	74	,	5.623811963	,	0.193469658	),
  (	74	,	5.443876189	,	0.1217525	),
  (	74	,	5.353953759	,	0.158687632	),
  (	74	,	5.409957558	,	0.234215727	),
  (	74	,	5.387913524	,	0.235001186	),
  (	74	,	5.482574791	,	0.256270433	),
  (	74	,	5.497668658	,	0.32496163	),
  (	74	,	5.68877357	,	0.193754197	),
  (	74	,	5.772314616	,	0.275454832	),
  (	74	,	5.746653022	,	0.308608186	),
  (	74	,	5.731877306	,	0.356021206	),
  (	74	,	5.79815907	,	0.386393671	),
  (	74	,	5.578650221	,	0.313944482	),
  (	74	,	5.567020136	,	0.344077922	),
  (	74	,	5.520039675	,	0.325608906	),
  (	74	,	5.619102754	,	0.379366123	),
  (	74	,	5.591079943	,	0.399494045	),
  (	74	,	5.702293368	,	0.347739	),
  (	74	,	5.708015685	,	0.426978176	),
  (	74	,	5.716857962	,	0.446735907	),
  (	74	,	5.669591952	,	0.427511371	),
  (	74	,	5.691469164	,	0.510772032	),
  (	74	,	5.303205407	,	0.177218006	),
  (	74	,	5.345285385	,	0.233633527	),
  (	74	,	5.331682037	,	0.237232963	),
  (	74	,	5.319558306	,	0.251051082	),
  (	74	,	5.362759882	,	0.28369046	),
  (	74	,	5.265324123	,	0.225787799	),
  (	74	,	5.266665279	,	0.232552796	),
  (	74	,	5.258215462	,	0.240227252	),
  (	74	,	5.26881005	,	0.290549797	),
  (	74	,	5.43859342	,	0.295020749	),
  (	74	,	5.472378129	,	0.344775729	),
  (	74	,	5.447136693	,	0.370591934	),
  (	74	,	5.376196392	,	0.325112629	),
  (	74	,	5.272427961	,	0.352904543	),
  (	74	,	5.186845662	,	0.343149808	),
  (	74	,	5.207215359	,	0.354783061	),
  (	74	,	5.180613438	,	0.379985997	),
  (	74	,	5.318959	,	0.357163045	),
  (	74	,	5.282904148	,	0.357561965	),
  (	74	,	5.300476083	,	0.383543214	),
  (	74	,	5.303618393	,	0.414374927	),
  (	74	,	5.344101551	,	0.439464099	),
  (	74	,	5.344205342	,	0.456002066	),
  (	74	,	5.239146124	,	0.41536854	),
  (	74	,	5.224320852	,	0.420402513	),
  (	74	,	5.299293321	,	0.433621793	),
  (	74	,	5.307432847	,	0.462346004	),
  (	74	,	5.279793628	,	0.493388515	),
  (	74	,	5.498579989	,	0.3483951	),
  (	74	,	5.508097523	,	0.407084379	),
  (	74	,	5.447758297	,	0.401630947	),
  (	74	,	5.462143962	,	0.407210856	),
  (	74	,	5.439945846	,	0.426953248	),
  (	74	,	5.404964378	,	0.432457143	),
  (	74	,	5.425460235	,	0.446845296	),
  (	74	,	5.509512535	,	0.462651957	),
  (	74	,	5.676706717	,	0.528787662	),
  (	74	,	5.608325284	,	0.514203868	),
  (	74	,	5.650645792	,	0.554732968	),
  (	74	,	5.641106219	,	0.572060414	),
  (	74	,	5.580561902	,	0.561659249	),
  (	74	,	5.441683891	,	0.561514013	),
  (	74	,	5.374424084	,	0.528153252	),
  (	74	,	5.319654618	,	0.514855622	),
  (	74	,	5.353661579	,	0.530050274	),
  (	74	,	5.335417885	,	0.550647022	),
  (	74	,	5.373423256	,	0.577670668	),
  (	74	,	5.57048823	,	0.633921177	),
  (	74	,	5.519443531	,	0.618362357	),
  (	74	,	5.463916694	,	0.689429055	),
  (	74	,	5.487286192	,	0.692244654	),
  (	74	,	5.491044327	,	0.721829469	),
  (	74	,	5.942096545	,	0.390770058	),
  (	74	,	5.835582782	,	0.460540225	),
  (	74	,	5.919454197	,	0.484927036	),
  (	74	,	5.873534155	,	0.497733773	),
  (	74	,	5.886692507	,	0.506655814	),
  (	74	,	5.999286378	,	0.488859929	),
  (	74	,	6.055407817	,	0.531272064	),
  (	74	,	5.911387253	,	0.522854662	),
  (	74	,	5.998465538	,	0.549406632	),
  (	74	,	5.971016854	,	0.542808712	),
  (	74	,	5.817293715	,	0.476796805	),
  (	74	,	5.864044556	,	0.545620742	),
  (	74	,	5.823196195	,	0.516131159	),
  (	74	,	5.748619243	,	0.511552497	),
  (	74	,	5.774453119	,	0.524250843	),
  (	74	,	5.808453219	,	0.632761695	),
  (	74	,	6.102767084	,	0.588649997	),
  (	74	,	6.114710524	,	0.637065262	),
  (	74	,	6.184883864	,	0.625083197	),
  (	74	,	6.172755029	,	0.659744248	),
  (	74	,	6.246317006	,	0.734480864	),
  (	74	,	6.108746159	,	0.728760179	),
  (	74	,	6.003710188	,	0.72142874	),
  (	74	,	5.9762133	,	0.744051178	),
  (	74	,	5.926045864	,	0.717693569	),
  (	74	,	6.026867295	,	0.771411636	),
  (	74	,	6.201754568	,	0.817861059	),
  (	74	,	6.279894599	,	0.881900293	),
  (	74	,	6.072154579	,	0.822007493	),
  (	74	,	5.714148365	,	0.581403328	),
  (	74	,	5.686596438	,	0.663529736	),
  (	74	,	5.708567034	,	0.679912375	),
  (	74	,	5.751671434	,	0.754658373	),
  (	74	,	5.802178434	,	0.753746737	),
  (	74	,	5.663680146	,	0.716997325	),
  (	74	,	5.628670053	,	0.724491179	),
  (	74	,	5.565823606	,	0.784604914	),
  (	74	,	5.716737193	,	0.765987753	),
  (	74	,	5.738822534	,	0.775248145	),
  (	74	,	5.798973218	,	0.846818096	),
  (	74	,	5.811766158	,	0.876088364	),
  (	74	,	5.672000328	,	0.857529177	),
  (	74	,	5.985812989	,	0.815687591	),
  (	74	,	5.989243832	,	0.88496614	),
  (	74	,	5.981151387	,	0.908664112	),
  (	74	,	6.136326386	,	0.927938144	),
  (	74	,	6.215032019	,	0.963531789	),
  (	74	,	6.257152844	,	0.985925956	),
  (	74	,	6.27352599	,	0.99727555	),
  (	74	,	6.170413779	,	0.968460895	),
  (	74	,	6.183723083	,	0.975228198	),
  (	74	,	5.862646798	,	0.893532792	),
  (	74	,	5.880564815	,	0.898719229	),
  (	74	,	5.920129146	,	0.949866818	),
  (	74	,	5.872033151	,	0.939278713	),
  (	74	,	5.872486028	,	0.941512052	),
  (	74	,	5.81349119	,	0.961634264	),
  (	74	,	5.827176235	,	0.974217093	),
  (	74	,	5.918669872	,	1.019727516	),
  (	74	,	6.166909324	,	1.054373632	),
  (	74	,	6.260067218	,	1.079292221	),
  (	74	,	6.249504038	,	1.079967016	),
  (	74	,	6.032831123	,	1.040304127	),
  (	74	,	6.113533968	,	1.055415725	),
  (	74	,	6.231291196	,	1.113822182	),
  (	74	,	5.12748246	,	0.386740084	),
  (	74	,	5.090883383	,	0.377917342	),
  (	74	,	5.06998246	,	0.392810467	),
  (	74	,	5.19634742	,	0.429821061	),
  (	74	,	5.185197812	,	0.43649857	),
  (	74	,	5.148090365	,	0.428248505	),
  (	74	,	5.059411906	,	0.393933099	),
  (	74	,	5.068661598	,	0.446364946	),
  (	74	,	5.067846195	,	0.446872968	),
  (	74	,	5.057873344	,	0.470050731	),
  (	74	,	5.098264711	,	0.436251044	),
  (	74	,	5.086109015	,	0.455600279	),
  (	74	,	5.199423804	,	0.45772341	),
  (	74	,	5.171786601	,	0.548454375	),
  (	74	,	5.234237502	,	0.574123761	),
  (	74	,	4.997510093	,	0.452394472	),
  (	74	,	5.044637719	,	0.468943268	),
  (	74	,	5.027624917	,	0.562917122	),
  (	74	,	4.992893222	,	0.594932689	),
  (	74	,	5.095858778	,	0.582482836	),
  (	74	,	5.085510866	,	0.596804519	),
  (	74	,	5.120338431	,	0.628701471	),
  (	74	,	5.037404486	,	0.603270382	),
  (	74	,	5.090851015	,	0.69745939	),
  (	74	,	5.325493211	,	0.558914691	),
  (	74	,	5.321159553	,	0.559327844	),
  (	74	,	5.262073497	,	0.624778051	),
  (	74	,	5.273511856	,	0.640046738	),
  (	74	,	5.223865062	,	0.611411472	),
  (	74	,	5.244846974	,	0.616667867	),
  (	74	,	5.227211104	,	0.634042143	),
  (	74	,	5.288822152	,	0.669419179	),
  (	74	,	5.39907879	,	0.664944691	),
  (	74	,	5.449828777	,	0.678323779	),
  (	74	,	5.486516657	,	0.727620927	),
  (	74	,	5.441786186	,	0.740191361	),
  (	74	,	5.380087457	,	0.723855361	),
  (	74	,	5.385514968	,	0.756783238	),
  (	74	,	5.38975576	,	0.775078667	),
  (	74	,	5.361704556	,	0.79794327	),
  (	74	,	5.174554446	,	0.696192157	),
  (	74	,	5.2435682	,	0.729832907	),
  (	74	,	5.237112795	,	0.736839888	),
  (	74	,	5.165034453	,	0.693638136	),
  (	74	,	5.19421438	,	0.762034377	),
  (	74	,	5.173298291	,	0.784764881	),
  (	74	,	5.151540827	,	0.781723321	),
  (	74	,	5.30841752	,	0.791318132	),
  (	74	,	5.250019151	,	0.878061783	),
  (	74	,	5.232138382	,	0.884238647	),
  (	74	,	4.882453123	,	0.562507382	),
  (	74	,	4.888454684	,	0.587897794	),
  (	74	,	4.912363389	,	0.602458658	),
  (	74	,	4.824914692	,	0.616844721	),
  (	74	,	4.897100402	,	0.637948842	),
  (	74	,	5.025677945	,	0.69738789	),
  (	74	,	5.027813899	,	0.719731945	),
  (	74	,	5.019758665	,	0.743534054	),
  (	74	,	4.981424585	,	0.724142483	),
  (	74	,	4.962928465	,	0.734826271	),
  (	74	,	5.018692725	,	0.777718136	),
  (	74	,	4.961320052	,	0.800339646	),
  (	74	,	4.857433296	,	0.7009238	),
  (	74	,	4.84748948	,	0.717445783	),
  (	74	,	4.751179839	,	0.760317088	),
  (	74	,	4.899676705	,	0.784091702	),
  (	74	,	4.891539357	,	0.772676443	),
  (	74	,	4.850964714	,	0.802656725	),
  (	74	,	4.822332	,	0.870293332	),
  (	74	,	4.782445025	,	0.881958674	),
  (	74	,	4.754615309	,	0.879682876	),
  (	74	,	5.110769564	,	0.750266432	),
  (	74	,	5.06109896	,	0.785961546	),
  (	74	,	5.133405735	,	0.799320164	),
  (	74	,	5.10603067	,	0.805430416	),
  (	74	,	5.037192976	,	0.850307972	),
  (	74	,	5.049717678	,	0.870043514	),
  (	74	,	5.201671376	,	0.912484386	),
  (	74	,	5.149900793	,	0.973796828	),
  (	74	,	5.016534046	,	1.020462845	),
  (	74	,	4.833125536	,	0.941621742	),
  (	74	,	4.862650825	,	1.008831405	),
  (	74	,	4.913241109	,	1.041738961	),
  (	74	,	4.906566124	,	1.053284887	),
  (	74	,	4.755518766	,	1.080031176	),
  (	74	,	5.483862276	,	0.748697824	),
  (	74	,	5.529417515	,	0.779709927	),
  (	74	,	5.527784007	,	0.797187227	),
  (	74	,	5.471150055	,	0.774688911	),
  (	74	,	5.479929261	,	0.82204087	),
  (	74	,	5.490174132	,	0.831085772	),
  (	74	,	5.557554335	,	0.796069876	),
  (	74	,	5.522804107	,	0.834350052	),
  (	74	,	5.469103781	,	0.842427556	),
  (	74	,	5.423290351	,	0.856132403	),
  (	74	,	5.603249617	,	0.852061646	),
  (	74	,	5.583805014	,	0.967786958	),
  (	74	,	5.361981788	,	0.859820992	),
  (	74	,	5.450390261	,	0.946568958	),
  (	74	,	5.468580065	,	0.951542004	),
  (	74	,	5.376855424	,	0.94520637	),
  (	74	,	5.306962346	,	0.907549614	),
  (	74	,	5.488237557	,	0.96844493	),
  (	74	,	5.466026791	,	0.987594302	),
  (	74	,	5.517849318	,	1.051672412	),
  (	74	,	5.616894313	,	1.083867226	),
  (	74	,	5.470262583	,	1.078211286	),
  (	74	,	5.515705751	,	1.106181715	),
  (	74	,	5.557604255	,	1.124053181	),
  (	74	,	5.478092758	,	1.146458571	),
  (	74	,	5.769984789	,	0.976444915	),
  (	74	,	5.796970364	,	1.034873518	),
  (	74	,	5.705756465	,	1.041967795	),
  (	74	,	5.723780118	,	1.081107597	),
  (	74	,	5.878902371	,	1.116250347	),
  (	74	,	5.896236956	,	1.11382834	),
  (	74	,	5.807550604	,	1.106531137	),
  (	74	,	6.113888997	,	1.12993757	),
  (	74	,	6.241091636	,	1.167769223	),
  (	74	,	6.174800795	,	1.177956703	),
  (	74	,	5.926187328	,	1.154430632	),
  (	74	,	5.659999383	,	1.087428118	),
  (	74	,	5.741665757	,	1.104110947	),
  (	74	,	5.646921089	,	1.112670494	),
  (	74	,	5.603712361	,	1.099444698	),
  (	74	,	5.851060731	,	1.168766046	),
  (	74	,	5.746796886	,	1.152436887	),
  (	74	,	5.815875172	,	1.203987115	),
  (	74	,	5.544093033	,	1.154675951	),
  (	74	,	5.674648416	,	1.235450555	),
  (	74	,	5.729648725	,	1.216434429	),
  (	74	,	5.92242736	,	1.207918623	),
  (	74	,	6.170338889	,	1.27259983	),
  (	74	,	6.004889515	,	1.271250327	),
  (	74	,	5.79568528	,	1.270048826	),
  (	74	,	6.099666523	,	1.286105547	),
  (	74	,	6.195083338	,	1.322110245	),
  (	74	,	5.299975255	,	1.028683271	),
  (	74	,	5.214248985	,	1.164974705	),
  (	74	,	5.355263018	,	1.200216436	),
  (	74	,	5.047872077	,	1.103175444	),
  (	74	,	4.989311589	,	1.144712773	),
  (	74	,	4.860464633	,	1.158144089	),
  (	74	,	4.918080866	,	1.304213963	),
  (	74	,	5.504837882	,	1.189673234	),
  (	74	,	5.608106468	,	1.230069895	),
  (	74	,	5.301186913	,	1.267206332	),
  (	74	,	5.869298642	,	1.351446354	),
  (	74	,	5.940905794	,	1.354641072	),
  (	74	,	5.950906562	,	1.370402508	),
  (	74	,	5.565836267	,	1.371798742	),
  (	74	,	6.017731231	,	1.402272158	),
  (	74	,	5.554605521	,	1.410326678	),
  (	74	,	5.527583225	,	1.414073226	),
  (	74	,	5.85911864	,	1.484608087	),
  (	74	,	4.738566808	,	1.477525732	),
  (	74	,	5.486357279	,	1.519008679	),
  (	74	,	6.274416886	,	-0.679871604	),
  (	74	,	0.092699118	,	-0.624814641	),
  (	74	,	6.210650588	,	-0.577405584	),
  (	74	,	6.195305889	,	-0.571517184	),
  (	74	,	6.167247628	,	-0.546103463	),
  (	74	,	0.005901551	,	-0.501348113	),
  (	74	,	0.038805434	,	-0.387106159	),
  (	74	,	0.141256598	,	-0.430156111	),
  (	74	,	0.309930272	,	-0.328208823	),
  (	74	,	0.291205064	,	-0.270708314	),
  (	74	,	0.0279977	,	-0.314826743	),
  (	74	,	0.102180695	,	-0.329724496	),
  (	74	,	0.200663094	,	-0.290638916	),
  (	74	,	6.094082786	,	-0.500634389	),
  (	74	,	5.947334515	,	-0.377993891	),
  (	74	,	5.934317043	,	-0.335070755	),
  (	74	,	6.11412256	,	-0.231593613	),
  (	74	,	6.066535786	,	-0.23813922	),
  (	74	,	6.090671387	,	-0.230104689	),
  (	74	,	6.081617535	,	-0.233782784	),
  (	74	,	6.264939293	,	-0.243759546	),
  (	74	,	0.122217593	,	-0.20348633	),
  (	74	,	6.176121313	,	-0.184222108	),
  (	74	,	6.224601887	,	-0.157034093	),
  (	74	,	6.125037507	,	-0.147658914	),
  (	74	,	0.458735995	,	-0.25416261	),
  (	74	,	0.348908233	,	-0.27601969	),
  (	74	,	0.311054828	,	-0.235676417	),
  (	74	,	0.308557934	,	-0.084511031	),
  (	74	,	0.58339577	,	-0.052921683	),
  (	74	,	0.773078892	,	-0.010025693	),
  (	74	,	0.645766455	,	0.034222426	),
  (	74	,	0.666286501	,	0.018041239	),
  (	74	,	0.436845309	,	-0.004229566	),
  (	74	,	0.475629326	,	0.023239135	),
  (	74	,	0.458516023	,	0.043686402	),
  (	74	,	0.587373138	,	0.029278576	),
  (	74	,	0.598754547	,	0.032470445	),
  (	74	,	0.58705563	,	0.116081659	),
  (	74	,	0.617556817	,	0.135302689	),
  (	74	,	0.207760789	,	-0.040523482	),
  (	74	,	0.352931256	,	-0.022873278	),
  (	74	,	0.104709258	,	-0.060655978	),
  (	74	,	0.079890855	,	-0.035165135	),
  (	74	,	0.078802029	,	0.010763594	),
  (	74	,	0.119281881	,	0.049114909	),
  (	74	,	0.287359265	,	0.08567067	),
  (	74	,	0.370489368	,	0.058456634	),
  (	74	,	0.447661292	,	0.178798503	),
  (	74	,	0.499207699	,	0.199016581	),
  (	74	,	0.309391894	,	0.166950575	),
  (	74	,	0.413908003	,	0.219187965	),
  (	74	,	0.338375894	,	0.248578578	),
  (	74	,	5.945186815	,	-0.219209391	),
  (	74	,	5.844997175	,	-0.291555954	),
  (	74	,	6.047091432	,	-0.182177627	),
  (	74	,	6.048829989	,	-0.167666206	),
  (	74	,	5.864849453	,	-0.177986854	),
  (	74	,	5.968285627	,	-0.073848718	),
  (	74	,	5.873531524	,	-0.090372213	),
  (	74	,	5.820054818	,	-0.077691528	),
  (	74	,	5.865064646	,	-0.035988636	),
  (	74	,	6.052781924	,	-0.134301719	),
  (	74	,	6.215734718	,	-0.05542529	),
  (	74	,	6.229511951	,	-0.013305483	),
  (	74	,	6.224614889	,	0.009247338	),
  (	74	,	6.155227414	,	0.015315553	),
  (	74	,	6.186408216	,	0.05881849	),
  (	74	,	5.980544139	,	0.070996039	),
  (	74	,	6.062297209	,	0.037428338	),
  (	74	,	6.021346162	,	0.090050775	),
  (	74	,	6.065511618	,	0.128498062	),
  (	74	,	5.788220034	,	0.032436256	),
  (	74	,	5.652178293	,	0.017017232	),
  (	74	,	5.527771981	,	-0.016816191	),
  (	74	,	5.576230378	,	0.050462504	),
  (	74	,	5.639776966	,	0.085053044	),
  (	74	,	5.973115037	,	0.07491552	),
  (	74	,	5.944391136	,	0.090298362	),
  (	74	,	5.918716234	,	0.113658833	),
  (	74	,	5.989130689	,	0.178367179	),
  (	74	,	5.959863642	,	0.195482113	),
  (	74	,	5.788210321	,	0.09066531	),
  (	74	,	5.749534019	,	0.182214579	),
  (	74	,	0.012164848	,	0.037166864	),
  (	74	,	6.176739163	,	0.146299371	),
  (	74	,	6.267156217	,	0.174745723	),
  (	74	,	6.175264536	,	0.191260819	),
  (	74	,	6.252643497	,	0.208114046	),
  (	74	,	6.256588353	,	0.314010056	),
  (	74	,	0.228994057	,	0.238214285	),
  (	74	,	0.156356559	,	0.289176699	),
  (	74	,	0.26396625	,	0.32622957	),
  (	74	,	0.138985763	,	0.315986908	),
  (	74	,	0.137503407	,	0.363543048	),
  (	74	,	0.065184165	,	0.37597684	),
  (	74	,	0.081422146	,	0.399330568	),
  (	74	,	0.228949485	,	0.373666568	),
  (	74	,	0.22522071	,	0.394853804	),
  (	74	,	0.19728216	,	0.411736215	),
  (	74	,	0.220969465	,	0.446539782	),
  (	74	,	0.214507937	,	0.501244478	),
  (	74	,	6.034361903	,	0.287239181	),
  (	74	,	6.197116974	,	0.317897901	),
  (	74	,	6.241751562	,	0.307374039	),
  (	74	,	6.275855366	,	0.343717507	),
  (	74	,	6.111565695	,	0.346286055	),
  (	74	,	6.116598189	,	0.360194451	),
  (	74	,	6.029710829	,	0.346232288	),
  (	74	,	6.045772669	,	0.353273486	),
  (	74	,	6.038150524	,	0.376951764	),
  (	74	,	5.901214178	,	0.342501327	),
  (	74	,	5.943034733	,	0.385714414	),
  (	74	,	6.101040843	,	0.481712708	),
  (	74	,	0.06702455	,	0.498929983	),
  (	74	,	0.04557848	,	0.500085273	),
  (	74	,	0.124187451	,	0.589900274	),
  (	74	,	6.183337524	,	0.535441992	),
  (	74	,	6.168273657	,	0.541328855	),
  (	74	,	6.155713414	,	0.590541696	),
  (	74	,	0.092296828	,	0.626201231	),
  (	74	,	6.2783256	,	0.682611941	),
  (	74	,	1.64258701	,	-0.61838314	),
  (	74	,	1.604363218	,	-0.604582404	),
  (	74	,	1.516023465	,	-0.636826943	),
  (	74	,	1.535613879	,	-0.626742646	),
  (	74	,	1.594677784	,	-0.58471829	),
  (	74	,	1.687046894	,	-0.583207655	),
  (	74	,	1.689110482	,	-0.56142751	),
  (	74	,	1.614978377	,	-0.520431965	),
  (	74	,	1.67302462	,	-0.460410806	),
  (	74	,	1.472731999	,	-0.542132091	),
  (	74	,	1.399499423	,	-0.509740638	),
  (	74	,	1.473324987	,	-0.499623447	),
  (	74	,	1.591395166	,	-0.489752245	),
  (	74	,	1.620819732	,	-0.472256817	),
  (	74	,	1.66147009	,	-0.424117386	),
  (	74	,	1.585700989	,	-0.380323651	),
  (	74	,	1.782945153	,	-0.492453683	),
  (	74	,	1.747847784	,	-0.493331791	),
  (	74	,	1.814636005	,	-0.445370397	),
  (	74	,	1.772032981	,	-0.362231367	),
  (	74	,	1.934734111	,	-0.353085465	),
  (	74	,	1.955153342	,	-0.333673938	),
  (	74	,	1.877126927	,	-0.335070282	),
  (	74	,	1.800648888	,	-0.369734944	),
  (	74	,	1.844328154	,	-0.306855257	),
  (	74	,	1.84609124	,	-0.279352154	),
  (	74	,	1.866953856	,	-0.274027059	),
  (	74	,	1.729360473	,	-0.34020144	),
  (	74	,	1.741226795	,	-0.31740247	),
  (	74	,	1.691285567	,	-0.267142407	),
  (	74	,	1.453117334	,	-0.44273918	),
  (	74	,	1.43463801	,	-0.423438833	),
  (	74	,	1.380666258	,	-0.402451338	),
  (	74	,	1.483956326	,	-0.414063531	),
  (	74	,	1.486421433	,	-0.354281263	),
  (	74	,	1.3300741	,	-0.353346198	),
  (	74	,	1.220061425	,	-0.370836929	),
  (	74	,	1.420919001	,	-0.229210409	),
  (	74	,	1.422784506	,	-0.225229762	),
  (	74	,	1.329207955	,	-0.225637905	),
  (	74	,	1.38116063	,	-0.196556239	),
  (	74	,	1.542493075	,	-0.28388888	),
  (	74	,	1.714730509	,	-0.15645352	),
  (	74	,	1.711523891	,	-0.129292321	),
  (	74	,	1.631611695	,	-0.119086583	),
  (	74	,	1.549506	,	-0.171212802	),
  (	74	,	1.421049224	,	-0.166727018	),
  (	74	,	1.597398517	,	-0.133029017	),
  (	74	,	1.639623644	,	-0.108358033	),
  (	74	,	1.503285641	,	-0.081956784	),
  (	74	,	1.538015694	,	-0.039887935	),
  (	74	,	1.986196903	,	-0.306255304	),
  (	74	,	1.897195641	,	-0.270111732	),
  (	74	,	1.963023051	,	-0.250597517	),
  (	74	,	1.96054622	,	-0.229321946	),
  (	74	,	1.955996669	,	-0.196616578	),
  (	74	,	2.075569787	,	-0.239673534	),
  (	74	,	2.080218721	,	-0.225764743	),
  (	74	,	2.074909593	,	-0.186094764	),
  (	74	,	2.047355164	,	-0.183247491	),
  (	74	,	2.059239544	,	-0.168526814	),
  (	74	,	1.876011016	,	-0.237646197	),
  (	74	,	1.850238868	,	-0.214468541	),
  (	74	,	1.917107315	,	-0.153294202	),
  (	74	,	1.794203439	,	-0.176021321	),
  (	74	,	1.85600094	,	-0.141950643	),
  (	74	,	1.863091015	,	-0.095498208	),
  (	74	,	1.969407599	,	-0.081659665	),
  (	74	,	2.007088326	,	-0.062822062	),
  (	74	,	1.928721002	,	-0.097227896	),
  (	74	,	1.892558921	,	-0.089981059	),
  (	74	,	1.925859327	,	-0.057396653	),
  (	74	,	1.960205468	,	-0.079267573	),
  (	74	,	2.183805044	,	-0.115665734	),
  (	74	,	2.185496561	,	-0.084928222	),
  (	74	,	2.09650042	,	-0.085168118	),
  (	74	,	2.166119855	,	-0.056304394	),
  (	74	,	2.052986005	,	-0.062792485	),
  (	74	,	2.082477612	,	0.019670349	),
  (	74	,	2.102798059	,	0.079262942	),
  (	74	,	2.086112836	,	0.087467209	),
  (	74	,	1.787198333	,	-0.129368802	),
  (	74	,	1.782830073	,	-0.071147783	),
  (	74	,	1.708683414	,	-0.093702304	),
  (	74	,	1.703692567	,	-0.08197528	),
  (	74	,	1.720639021	,	-0.050714247	),
  (	74	,	1.761042699	,	-0.023506214	),
  (	74	,	1.767633032	,	-0.017819814	),
  (	74	,	1.834225455	,	-0.042447944	),
  (	74	,	1.858253335	,	-0.017833085	),
  (	74	,	1.913760273	,	0.004862499	),
  (	74	,	1.814724284	,	-0.027667952	),
  (	74	,	1.638196069	,	-0.024432625	),
  (	74	,	1.641685071	,	0.000265994	),
  (	74	,	1.709320529	,	0.03519198	),
  (	74	,	1.645246164	,	0.029444011	),
  (	74	,	1.751572575	,	0.016707255	),
  (	74	,	1.795966603	,	0.046262722	),
  (	74	,	1.753669343	,	0.045060139	),
  (	74	,	1.755619309	,	0.050073937	),
  (	74	,	1.786739927	,	0.064431286	),
  (	74	,	1.851692964	,	0.079797006	),
  (	74	,	1.713528112	,	0.066575319	),
  (	74	,	1.76037235	,	0.102080109	),
  (	74	,	1.789388526	,	0.109192952	),
  (	74	,	1.800525281	,	0.136523553	),
  (	74	,	1.737464378	,	0.124760048	),
  (	74	,	1.951787265	,	0.025353268	),
  (	74	,	1.968842553	,	0.037875929	),
  (	74	,	1.957818253	,	0.039851062	),
  (	74	,	1.9198292	,	0.042941146	),
  (	74	,	2.022945848	,	0.10969099	),
  (	74	,	1.944973442	,	0.077584093	),
  (	74	,	1.924052768	,	0.108865816	),
  (	74	,	1.957516953	,	0.14848173	),
  (	74	,	2.083159829	,	0.119583521	),
  (	74	,	2.055313057	,	0.129818519	),
  (	74	,	2.041312686	,	0.128130457	),
  (	74	,	2.114051962	,	0.161757632	),
  (	74	,	2.003194789	,	0.155793958	),
  (	74	,	2.069071635	,	0.234238162	),
  (	74	,	1.915917634	,	0.180029625	),
  (	74	,	2.003082034	,	0.207188151	),
  (	74	,	1.937315218	,	0.190348289	),
  (	74	,	1.965397082	,	0.24198678	),
  (	74	,	2.053050882	,	0.259031603	),
  (	74	,	2.024107044	,	0.266294036	),
  (	74	,	1.137473673	,	-0.29373696	),
  (	74	,	1.213849413	,	-0.231402421	),
  (	74	,	1.212989708	,	-0.22739922	),
  (	74	,	1.329918417	,	-0.204212898	),
  (	74	,	1.262381602	,	-0.157243524	),
  (	74	,	1.27551984	,	-0.137809025	),
  (	74	,	1.299860619	,	-0.106506735	),
  (	74	,	1.072951561	,	-0.179695749	),
  (	74	,	1.148989623	,	-0.134469422	),
  (	74	,	1.235379797	,	-0.112942139	),
  (	74	,	1.211754739	,	-0.046193254	),
  (	74	,	1.159331482	,	-0.038962616	),
  (	74	,	1.459708518	,	-0.078320019	),
  (	74	,	1.401929409	,	-0.101429503	),
  (	74	,	1.394970635	,	-0.085125409	),
  (	74	,	1.339213975	,	-0.090160273	),
  (	74	,	1.346328652	,	-0.052526296	),
  (	74	,	1.430134952	,	-0.037445722	),
  (	74	,	1.453520166	,	-0.029965919	),
  (	74	,	1.52591151	,	-0.006133458	),
  (	74	,	1.431633996	,	-0.029147034	),
  (	74	,	1.462382882	,	-0.00470541	),
  (	74	,	1.409800743	,	0.022505065	),
  (	74	,	1.474327461	,	0.016905184	),
  (	74	,	1.446433374	,	0.02949685	),
  (	74	,	1.197503785	,	0.007091126	),
  (	74	,	1.336842867	,	0.046656572	),
  (	74	,	1.466831739	,	0.080802024	),
  (	74	,	1.385519321	,	0.095683976	),
  (	74	,	0.923575751	,	-0.061045128	),
  (	74	,	1.002008798	,	-0.040643023	),
  (	74	,	0.974648444	,	-0.036129539	),
  (	74	,	0.955177265	,	-0.02662709	),
  (	74	,	1.162615594	,	-0.008924758	),
  (	74	,	0.849113257	,	-0.040713529	),
  (	74	,	0.950508983	,	0.002461586	),
  (	74	,	0.831643271	,	0.003704943	),
  (	74	,	0.818836967	,	0.024538367	),
  (	74	,	0.904218257	,	0.039793842	),
  (	74	,	0.932645053	,	0.120881039	),
  (	74	,	0.990731061	,	0.156295925	),
  (	74	,	1.11461746	,	0.069976974	),
  (	74	,	1.182748705	,	0.118519995	),
  (	74	,	1.259620886	,	0.136836397	),
  (	74	,	1.328525139	,	0.136662724	),
  (	74	,	1.331762571	,	0.15606922	),
  (	74	,	1.251238427	,	0.157384614	),
  (	74	,	1.264993181	,	0.238916683	),
  (	74	,	1.060134263	,	0.142069984	),
  (	74	,	1.02433067	,	0.160174573	),
  (	74	,	1.187599338	,	0.187802949	),
  (	74	,	1.142124362	,	0.237101919	),
  (	74	,	1.199812646	,	0.296603427	),
  (	74	,	1.585780526	,	0.067404386	),
  (	74	,	1.627792894	,	0.061244068	),
  (	74	,	1.624049766	,	0.081571708	),
  (	74	,	1.5204879	,	0.082098742	),
  (	74	,	1.528897942	,	0.086511303	),
  (	74	,	1.54217502	,	0.109182846	),
  (	74	,	1.709402331	,	0.118424048	),
  (	74	,	1.751677994	,	0.171984292	),
  (	74	,	1.621807993	,	0.135771895	),
  (	74	,	1.624314923	,	0.180351659	),
  (	74	,	1.681444205	,	0.188651767	),
  (	74	,	1.634146522	,	0.205893091	),
  (	74	,	1.653672273	,	0.22168138	),
  (	74	,	1.475674209	,	0.104771989	),
  (	74	,	1.462924268	,	0.151855457	),
  (	74	,	1.489775034	,	0.160541172	),
  (	74	,	1.462717622	,	0.169245565	),
  (	74	,	1.38355923	,	0.173263239	),
  (	74	,	1.416727804	,	0.201211355	),
  (	74	,	1.514921385	,	0.215362924	),
  (	74	,	1.466696654	,	0.217053795	),
  (	74	,	1.618731991	,	0.209349577	),
  (	74	,	1.584990974	,	0.220219305	),
  (	74	,	1.547288175	,	0.200455873	),
  (	74	,	1.601989796	,	0.252186177	),
  (	74	,	1.564980162	,	0.289684449	),
  (	74	,	1.768206134	,	0.23275592	),
  (	74	,	1.824846503	,	0.248694773	),
  (	74	,	1.684320226	,	0.264414182	),
  (	74	,	1.723327259	,	0.267566911	),
  (	74	,	1.729972106	,	0.274885027	),
  (	74	,	1.711927542	,	0.274124208	),
  (	74	,	1.89317222	,	0.289378142	),
  (	74	,	1.954113456	,	0.332385799	),
  (	74	,	1.901158241	,	0.346400938	),
  (	74	,	1.896154671	,	0.358085184	),
  (	74	,	1.628307411	,	0.331773026	),
  (	74	,	1.642924721	,	0.331850753	),
  (	74	,	1.602640683	,	0.363379687	),
  (	74	,	1.76884293	,	0.412704633	),
  (	74	,	1.84280603	,	0.442687153	),
  (	74	,	1.740500233	,	0.485273436	),
  (	74	,	1.756444207	,	0.512694137	),
  (	74	,	1.391384969	,	0.236790445	),
  (	74	,	1.425198502	,	0.283078569	),
  (	74	,	1.26890439	,	0.28292256	),
  (	74	,	1.283048718	,	0.297174067	),
  (	74	,	1.202822137	,	0.34851565	),
  (	74	,	1.292578645	,	0.376505688	),
  (	74	,	1.292031341	,	0.394028959	),
  (	74	,	1.331686331	,	0.415369572	),
  (	74	,	1.388649604	,	0.502301949	),
  (	74	,	1.605872087	,	0.371674781	),
  (	74	,	1.57728283	,	0.41371047	),
  (	74	,	1.484857286	,	0.428258062	),
  (	74	,	1.673345766	,	0.473298441	),
  (	74	,	1.736956248	,	0.539126262	),
  (	74	,	1.440346429	,	0.515717762	),
  (	74	,	1.452967068	,	0.556265398	),
  (	74	,	1.438803499	,	0.581975641	),
  (	74	,	3.203986682	,	-0.589556763	),
  (	74	,	3.281941179	,	-0.481120385	),
  (	74	,	3.10269171	,	-0.472640036	),
  (	74	,	3.086311303	,	-0.453112356	),
  (	74	,	3.424661067	,	-0.375590888	),
  (	74	,	3.391058167	,	-0.386974158	),
  (	74	,	3.402523875	,	-0.354161645	),
  (	74	,	3.387174042	,	-0.342633324	),
  (	74	,	3.348184961	,	-0.331691836	),
  (	74	,	3.290647765	,	-0.31757202	),
  (	74	,	2.925747217	,	-0.453725245	),
  (	74	,	2.981475291	,	-0.413753493	),
  (	74	,	2.939490986	,	-0.401403499	),
  (	74	,	3.070821351	,	-0.367185183	),
  (	74	,	3.045948769	,	-0.31750389	),
  (	74	,	2.820780435	,	-0.344886358	),
  (	74	,	2.907865359	,	-0.28852342	),
  (	74	,	2.991951817	,	-0.253724341	),
  (	74	,	3.224563346	,	-0.23636094	),
  (	74	,	3.278700352	,	-0.160251904	),
  (	74	,	3.192516761	,	-0.184492478	),
  (	74	,	3.042704831	,	-0.215510866	),
  (	74	,	3.06190779	,	-0.158414602	),
  (	74	,	3.03982692	,	-0.162544845	),
  (	74	,	3.173215948	,	-0.118079638	),
  (	74	,	3.230085635	,	-0.078719768	),
  (	74	,	3.139693967	,	-0.033488759	),
  (	74	,	3.521981352	,	-0.312923196	),
  (	74	,	3.486184647	,	-0.220750951	),
  (	74	,	3.428960563	,	-0.2463025	),
  (	74	,	3.495896659	,	-0.174511946	),
  (	74	,	3.480777816	,	-0.152430465	),
  (	74	,	3.392384806	,	-0.170379364	),
  (	74	,	3.723269468	,	-0.147386861	),
  (	74	,	3.719822912	,	-0.051878212	),
  (	74	,	3.833102149	,	-0.063027519	),
  (	74	,	3.774522271	,	0.098003324	),
  (	74	,	3.781707268	,	0.103572906	),
  (	74	,	3.769956449	,	0.101631985	),
  (	74	,	3.693189722	,	0.122253967	),
  (	74	,	3.705274026	,	0.128890594	),
  (	74	,	3.319077796	,	-0.147471395	),
  (	74	,	3.340269235	,	-0.083966091	),
  (	74	,	3.383136502	,	-0.078604293	),
  (	74	,	3.339199574	,	-0.067858412	),
  (	74	,	3.459078584	,	-0.03069128	),
  (	74	,	3.604584987	,	0.0892804	),
  (	74	,	3.474943143	,	0.113520454	),
  (	74	,	3.559888815	,	0.144737076	),
  (	74	,	3.450453914	,	0.232246929	),
  (	74	,	3.491323033	,	0.271640872	),
  (	74	,	2.820644256	,	-0.262394341	),
  (	74	,	2.691213663	,	-0.228630965	),
  (	74	,	2.729114216	,	-0.222751336	),
  (	74	,	2.81784774	,	-0.186988391	),
  (	74	,	2.658930116	,	-0.233216874	),
  (	74	,	2.683145966	,	-0.209667439	),
  (	74	,	2.717024174	,	-0.163975905	),
  (	74	,	2.841864305	,	-0.082668107	),
  (	74	,	2.77254547	,	-0.093580542	),
  (	74	,	2.76306206	,	-0.093611292	),
  (	74	,	2.941814559	,	-0.145347812	),
  (	74	,	2.892730005	,	-0.045996127	),
  (	74	,	3.058393054	,	-0.011771957	),
  (	74	,	3.000077502	,	0.016676458	),
  (	74	,	3.003772122	,	0.048563571	),
  (	74	,	3.03793142	,	0.057610397	),
  (	74	,	2.897163243	,	0.063508758	),
  (	74	,	2.906650417	,	0.124618241	),
  (	74	,	2.590551369	,	-0.067404479	),
  (	74	,	2.509418973	,	-0.093711098	),
  (	74	,	2.55337344	,	-0.008115984	),
  (	74	,	2.575245924	,	-0.003989861	),
  (	74	,	2.483418796	,	-0.04801249	),
  (	74	,	2.489643623	,	0.0219437	),
  (	74	,	2.493728892	,	0.025570001	),
  (	74	,	2.457687999	,	0.0611122	),
  (	74	,	2.55094715	,	0.058529073	),
  (	74	,	2.491896192	,	0.05375343	),
  (	74	,	2.486656639	,	0.098713819	),
  (	74	,	2.531478867	,	0.144480658	),
  (	74	,	2.737985511	,	0.062192738	),
  (	74	,	2.807112527	,	0.08284149	),
  (	74	,	2.785807392	,	0.103210885	),
  (	74	,	2.911303849	,	0.178235278	),
  (	74	,	2.802461346	,	0.180735436	),
  (	74	,	2.640139207	,	0.139468262	),
  (	74	,	2.659548536	,	0.167431787	),
  (	74	,	2.612588849	,	0.182540575	),
  (	74	,	2.646883285	,	0.223087059	),
  (	74	,	2.746385189	,	0.212700923	),
  (	74	,	2.742066591	,	0.274991285	),
  (	74	,	3.162170755	,	0.062359099	),
  (	74	,	3.160416358	,	0.086073818	),
  (	74	,	3.063558271	,	0.08286081	),
  (	74	,	3.228509205	,	0.098990906	),
  (	74	,	3.320060958	,	0.154097913	),
  (	74	,	3.057343296	,	0.151356716	),
  (	74	,	3.457113687	,	0.30573154	),
  (	74	,	3.492513891	,	0.306845399	),
  (	74	,	3.47303542	,	0.373180077	),
  (	74	,	3.368097728	,	0.334618996	),
  (	74	,	3.397651195	,	0.384690888	),
  (	74	,	3.350981572	,	0.420548341	),
  (	74	,	3.023023012	,	0.314201631	),
  (	74	,	3.108923053	,	0.356224665	),
  (	74	,	2.833746345	,	0.299261773	),
  (	74	,	2.912557939	,	0.369149823	),
  (	74	,	2.80355902	,	0.317995426	),
  (	74	,	2.765638585	,	0.354372274	),
  (	74	,	3.018805543	,	0.424314333	),
  (	74	,	2.992197366	,	0.466827248	),
  (	74	,	2.956941077	,	0.44436398	),
  (	74	,	3.176905226	,	0.541916816	),
  (	74	,	3.234032262	,	0.605392721	),
  (	74	,	3.077988811	,	0.475041772	),
  (	74	,	3.191932994	,	0.597915403	),
  (	74	,	3.102184526	,	0.586504989	),
  (	74	,	3.128984804	,	0.703175745	),
  (	74	,	4.713725268	,	-0.685047083	),
  (	74	,	4.735229746	,	-0.658326642	),
  (	74	,	4.721833463	,	-0.63458898	),
  (	74	,	4.759055866	,	-0.591996573	),
  (	74	,	4.684381536	,	-0.608515342	),
  (	74	,	4.659820879	,	-0.593809968	),
  (	74	,	4.724237019	,	-0.591478466	),
  (	74	,	4.819789286	,	-0.563586982	),
  (	74	,	4.783598751	,	-0.54666227	),
  (	74	,	4.767479735	,	-0.492816138	),
  (	74	,	4.601787925	,	-0.556277829	),
  (	74	,	4.661246867	,	-0.570224424	),
  (	74	,	4.622709959	,	-0.522897141	),
  (	74	,	4.599068322	,	-0.530775762	),
  (	74	,	4.524352312	,	-0.529733394	),
  (	74	,	4.71441861	,	-0.520533457	),
  (	74	,	4.643874353	,	-0.413278035	),
  (	74	,	4.712448346	,	-0.393543948	),
  (	74	,	4.920167862	,	-0.493575004	),
  (	74	,	4.899861047	,	-0.4183113	),
  (	74	,	4.862588601	,	-0.345310226	),
  (	74	,	4.786461192	,	-0.331056224	),
  (	74	,	4.912609598	,	-0.320514615	),
  (	74	,	4.896388699	,	-0.296900475	),
  (	74	,	4.953479181	,	-0.256404246	),
  (	74	,	4.916468159	,	-0.252501405	),
  (	74	,	4.851313726	,	-0.264988515	),
  (	74	,	4.923286951	,	-0.198834762	),
  (	74	,	4.912471448	,	-0.183135029	),
  (	74	,	4.522418873	,	-0.441664521	),
  (	74	,	4.551898063	,	-0.401594389	),
  (	74	,	4.485220066	,	-0.436299749	),
  (	74	,	4.500184239	,	-0.356480758	),
  (	74	,	4.456034546	,	-0.356688501	),
  (	74	,	4.470182085	,	-0.3053116	),
  (	74	,	4.502847956	,	-0.255178598	),
  (	74	,	4.442553825	,	-0.250847042	),
  (	74	,	4.706730084	,	-0.294222188	),
  (	74	,	4.682214499	,	-0.238244327	),
  (	74	,	4.736483751	,	-0.192339032	),
  (	74	,	4.81413845	,	-0.214683692	),
  (	74	,	4.79080127	,	-0.224625458	),
  (	74	,	4.861644746	,	-0.134605697	),
  (	74	,	4.764847227	,	-0.152387669	),
  (	74	,	4.819293874	,	-0.142687207	),
  (	74	,	4.561581521	,	-0.154086201	),
  (	74	,	4.642636265	,	-0.103491729	),
  (	74	,	4.6883805	,	-0.060448701	),
  (	74	,	5.145305026	,	-0.295095097	),
  (	74	,	5.108486803	,	-0.282165232	),
  (	74	,	5.077241116	,	-0.275978438	),
  (	74	,	5.194292688	,	-0.243019193	),
  (	74	,	5.191395384	,	-0.199129395	),
  (	74	,	5.201216379	,	-0.180712919	),
  (	74	,	5.297110207	,	-0.167866345	),
  (	74	,	5.002185538	,	-0.207698782	),
  (	74	,	4.958417626	,	-0.197632108	),
  (	74	,	5.108904654	,	-0.113715266	),
  (	74	,	5.105430239	,	-0.007767462	),
  (	74	,	5.289462083	,	-0.141241033	),
  (	74	,	5.315251852	,	-0.082533356	),
  (	74	,	5.453428382	,	-0.005659044	),
  (	74	,	5.360774614	,	0.015417276	),
  (	74	,	5.186463493	,	-0.031879581	),
  (	74	,	5.177452419	,	-0.024031307	),
  (	74	,	5.172189965	,	-0.026162715	),
  (	74	,	5.138063003	,	-0.002253897	),
  (	74	,	5.13951646	,	0.026166578	),
  (	74	,	5.318944183	,	0.038980251	),
  (	74	,	5.304142238	,	0.136293674	),
  (	74	,	4.941150066	,	-0.065025914	),
  (	74	,	4.84827978	,	-0.101047633	),
  (	74	,	4.883523442	,	-0.034077946	),
  (	74	,	4.902730558	,	-0.027210536	),
  (	74	,	4.972554714	,	-0.049487984	),
  (	74	,	5.052526683	,	-0.016470216	),
  (	74	,	4.977493399	,	-0.00794309	),
  (	74	,	4.955765729	,	0.004627191	),
  (	74	,	4.980990527	,	0.045181004	),
  (	74	,	4.99913096	,	0.074675312	),
  (	74	,	4.85101524	,	-0.042209317	),
  (	74	,	4.821269499	,	-0.027564045	),
  (	74	,	4.770281753	,	-0.030013609	),
  (	74	,	4.974111046	,	0.080472267	),
  (	74	,	4.973577364	,	0.107465109	),
  (	74	,	4.956771008	,	0.124376948	),
  (	74	,	4.873791594	,	0.111973441	),
  (	74	,	5.112241305	,	0.087636943	),
  (	74	,	5.022576058	,	0.090403945	),
  (	74	,	5.236586923	,	0.135448795	),
  (	74	,	5.200130713	,	0.14087775	),
  (	74	,	5.220979892	,	0.144091724	),
  (	74	,	5.040630073	,	0.178240657	),
  (	74	,	4.990593304	,	0.163534703	),
  (	74	,	5.015059808	,	0.178742778	),
  (	74	,	5.015937292	,	0.19399457	),
  (	74	,	4.983840923	,	0.191373794	),
  (	74	,	4.991639108	,	0.197268932	),
  (	74	,	5.100725255	,	0.224417074	),
  (	74	,	5.153682515	,	0.229869979	),
  (	74	,	5.150360362	,	0.285069843	),
  (	74	,	5.04413884	,	0.282065318	),
  (	74	,	4.374621165	,	-0.195037297	),
  (	74	,	4.32849193	,	-0.169225831	),
  (	74	,	4.457489815	,	-0.117573628	),
  (	74	,	4.251087653	,	-0.181768762	),
  (	74	,	4.286045201	,	-0.152571431	),
  (	74	,	4.334472322	,	-0.074391741	),
  (	74	,	4.368280602	,	-0.049922817	),
  (	74	,	4.250345397	,	-0.072580089	),
  (	74	,	4.586014874	,	-0.049337302	),
  (	74	,	4.588092728	,	0.029185415	),
  (	74	,	4.590424675	,	0.049281658	),
  (	74	,	4.474113132	,	0.060015231	),
  (	74	,	4.487047087	,	0.077197369	),
  (	74	,	4.244472873	,	-0.030053413	),
  (	74	,	4.033236713	,	-0.00949542	),
  (	74	,	4.117987053	,	0.042583993	),
  (	74	,	4.121165182	,	0.058811994	),
  (	74	,	4.135578009	,	0.075018361	),
  (	74	,	4.084317767	,	0.107922418	),
  (	74	,	4.346072425	,	0.024099058	),
  (	74	,	4.286182361	,	0.05384133	),
  (	74	,	4.328698884	,	0.058680546	),
  (	74	,	4.32170654	,	0.07275489	),
  (	74	,	4.411240949	,	0.095799134	),
  (	74	,	4.411542312	,	0.172420489	),
  (	74	,	4.207674613	,	0.104912209	),
  (	74	,	4.204753904	,	0.19955049	),
  (	74	,	4.221188421	,	0.232768562	),
  (	74	,	4.737661446	,	0.034648873	),
  (	74	,	4.850782675	,	0.126217503	),
  (	74	,	4.765496408	,	0.143583009	),
  (	74	,	4.771887992	,	0.188951245	),
  (	74	,	4.791808355	,	0.198902756	),
  (	74	,	4.796322965	,	0.218757824	),
  (	74	,	4.786530985	,	0.210620642	),
  (	74	,	4.626576592	,	0.114571683	),
  (	74	,	4.635485871	,	0.164926869	),
  (	74	,	4.545892433	,	0.169922269	),
  (	74	,	4.649260808	,	0.227233897	),
  (	74	,	4.705157206	,	0.253255225	),
  (	74	,	4.677370541	,	0.267496779	),
  (	74	,	4.677369205	,	0.267500632	),
  (	74	,	4.704166658	,	0.264241859	),
  (	74	,	4.696710758	,	0.31986547	),
  (	74	,	4.913179619	,	0.171362662	),
  (	74	,	4.931642765	,	0.201109345	),
  (	74	,	4.894897957	,	0.213900022	),
  (	74	,	4.983270082	,	0.251848187	),
  (	74	,	4.948559491	,	0.261905853	),
  (	74	,	4.970723185	,	0.264065054	),
  (	74	,	4.852790354	,	0.239763133	),
  (	74	,	4.843246577	,	0.278282373	),
  (	74	,	4.886512463	,	0.307228297	),
  (	74	,	4.901375102	,	0.305251772	),
  (	74	,	5.023004002	,	0.275544383	),
  (	74	,	5.001810709	,	0.276833473	),
  (	74	,	5.040278813	,	0.282693103	),
  (	74	,	5.007144866	,	0.323976076	),
  (	74	,	5.075432205	,	0.353929002	),
  (	74	,	5.067077589	,	0.36586908	),
  (	74	,	4.979194288	,	0.351814681	),
  (	74	,	4.950060968	,	0.355348601	),
  (	74	,	4.81874751	,	0.2732374	),
  (	74	,	4.859696367	,	0.309484688	),
  (	74	,	4.75921273	,	0.322963282	),
  (	74	,	4.812494693	,	0.365885216	),
  (	74	,	4.823602733	,	0.384557268	),
  (	74	,	4.961668185	,	0.455458724	),
  (	74	,	4.933267532	,	0.497855577	),
  (	74	,	4.570783284	,	0.287229705	),
  (	74	,	4.449950924	,	0.31077656	),
  (	74	,	4.399986148	,	0.299033249	),
  (	74	,	4.462114453	,	0.361730331	),
  (	74	,	4.373944986	,	0.376867342	),
  (	74	,	4.515819929	,	0.343504068	),
  (	74	,	4.545828767	,	0.413404128	),
  (	74	,	4.477014374	,	0.407046862	),
  (	74	,	4.67982459	,	0.474616089	),
  (	74	,	4.713562227	,	0.501253142	),
  (	74	,	4.839762785	,	0.51581739	),
  (	74	,	4.736150124	,	0.500656152	),
  (	74	,	4.748195017	,	0.541032656	),
  (	74	,	4.708289743	,	0.52445335	),
  (	74	,	4.63830894	,	0.517539328	),
  (	74	,	4.718545959	,	0.534863108	),
  (	74	,	4.692416371	,	0.56615683	),
  (	74	,	4.699922907	,	0.643342641	),
  (	74	,	1.20766019	,	-1.457280995	),
  (	74	,	0.033271758	,	-1.501658668	),
  (	74	,	0.449128248	,	-1.455034479	),
  (	74	,	0.643481968	,	-1.321914501	),
  (	74	,	0.050657983	,	-1.39929387	),
  (	74	,	0.572884819	,	-1.300293346	),
  (	74	,	1.28049049	,	-1.269986686	),
  (	74	,	1.120389349	,	-1.216957457	),
  (	74	,	1.295235657	,	-1.237876192	),
  (	74	,	1.257094861	,	-1.107941852	),
  (	74	,	1.253865904	,	-1.072963602	),
  (	74	,	0.869006765	,	-1.147169082	),
  (	74	,	1.106818912	,	-1.012668204	),
  (	74	,	0.019678372	,	-1.272302774	),
  (	74	,	0.357690917	,	-1.216821853	),
  (	74	,	0.644810855	,	-1.213418403	),
  (	74	,	0.609914443	,	-1.188294098	),
  (	74	,	0.696285869	,	-1.168628109	),
  (	74	,	0.521873766	,	-1.142277651	),
  (	74	,	0.543665443	,	-1.136840485	),
  (	74	,	0.252492053	,	-1.161707303	),
  (	74	,	0.245977167	,	-1.11626649	),
  (	74	,	0.430240369	,	-1.145051395	),
  (	74	,	0.723534575	,	-1.094746759	),
  (	74	,	0.820912277	,	-1.067263389	),
  (	74	,	0.798196909	,	-1.06111961	),
  (	74	,	0.921903545	,	-0.964278108	),
  (	74	,	0.998553948	,	-0.959926363	),
  (	74	,	0.592218879	,	-0.911171007	),
  (	74	,	0.841696473	,	-0.823016371	),
  (	74	,	1.544912109	,	-1.047614464	),
  (	74	,	1.367069658	,	-1.039963283	),
  (	74	,	1.528367801	,	-0.960854012	),
  (	74	,	1.476671756	,	-0.959132117	),
  (	74	,	1.223028316	,	-1.028744296	),
  (	74	,	1.152737814	,	-0.996100764	),
  (	74	,	1.236986151	,	-0.917100461	),
  (	74	,	1.139099206	,	-0.851914991	),
  (	74	,	1.323235893	,	-0.863800422	),
  (	74	,	1.274235689	,	-0.817730879	),
  (	74	,	1.204615604	,	-0.787776394	),
  (	74	,	1.46028857	,	-0.854299662	),
  (	74	,	1.528872809	,	-0.854972161	),
  (	74	,	1.447447821	,	-0.855532339	),
  (	74	,	1.262478677	,	-0.740257994	),
  (	74	,	1.356916131	,	-0.609184524	),
  (	74	,	1.047334324	,	-0.739846715	),
  (	74	,	1.002786677	,	-0.745735246	),
  (	74	,	1.018638042	,	-0.719463819	),
  (	74	,	0.892630795	,	-0.796982819	),
  (	74	,	0.843269175	,	-0.722214365	),
  (	74	,	0.890576148	,	-0.719638005	),
  (	74	,	0.905750526	,	-0.696047445	),
  (	74	,	0.998257911	,	-0.705092786	),
  (	74	,	1.006793759	,	-0.680358559	),
  (	74	,	0.898775446	,	-0.62759156	),
  (	74	,	0.973752934	,	-0.541388732	),
  (	74	,	1.179421767	,	-0.668018789	),
  (	74	,	1.198733157	,	-0.607703711	),
  (	74	,	1.241299246	,	-0.487798955	),
  (	74	,	1.108532803	,	-0.525564285	),
  (	74	,	1.191900844	,	-0.446105289	),
  (	74	,	0.055987156	,	-1.010761474	),
  (	74	,	0.107857361	,	-0.942201926	),
  (	74	,	0.264714596	,	-0.917741635	),
  (	74	,	0.428784802	,	-0.83661818	),
  (	74	,	0.640343622	,	-0.802849196	),
  (	74	,	0.569421656	,	-0.793197471	),
  (	74	,	0.540763283	,	-0.792598416	),
  (	74	,	0.690309491	,	-0.73136178	),
  (	74	,	0.746580305	,	-0.714942567	),
  (	74	,	0.676296609	,	-0.735011359	),
  (	74	,	0.525641592	,	-0.729123376	),
  (	74	,	0.550823182	,	-0.690085159	),
  (	74	,	0.646952273	,	-0.634265311	),
  (	74	,	0.020237801	,	-0.900297247	),
  (	74	,	0.279422294	,	-0.70739597	),
  (	74	,	0.320473387	,	-0.690100302	),
  (	74	,	0.06431954	,	-0.803432293	),
  (	74	,	0.043405395	,	-0.779574092	),
  (	74	,	0.166270493	,	-0.725922003	),
  (	74	,	0.147485502	,	-0.696814795	),
  (	74	,	0.146357629	,	-0.665205443	),
  (	74	,	0.208080139	,	-0.547213135	),
  (	74	,	0.441585131	,	-0.582908902	),
  (	74	,	0.422430578	,	-0.563691963	),
  (	74	,	0.231425775	,	-0.529824253	),
  (	74	,	0.342183884	,	-0.401661113	),
  (	74	,	0.375612657	,	-0.397906511	),
  (	74	,	0.790090644	,	-0.577874496	),
  (	74	,	0.911556047	,	-0.587396487	),
  (	74	,	0.933340379	,	-0.534560879	),
  (	74	,	0.814446698	,	-0.523384469	),
  (	74	,	0.733689253	,	-0.548446745	),
  (	74	,	0.671287919	,	-0.522424525	),
  (	74	,	0.694170701	,	-0.485588278	),
  (	74	,	0.693377238	,	-0.449352063	),
  (	74	,	0.963509079	,	-0.488168385	),
  (	74	,	0.989154188	,	-0.442564152	),
  (	74	,	1.090739863	,	-0.33166476	),
  (	74	,	1.130172617	,	-0.311556257	),
  (	74	,	1.004573732	,	-0.327180449	),
  (	74	,	0.890683527	,	-0.365324202	),
  (	74	,	0.94429573	,	-0.338186931	),
  (	74	,	0.852983357	,	-0.317215495	),
  (	74	,	1.025281076	,	-0.260159101	),
  (	74	,	0.909569698	,	-0.230550359	),
  (	74	,	0.619776841	,	-0.486270561	),
  (	74	,	0.581337217	,	-0.399173939	),
  (	74	,	0.735838775	,	-0.363397374	),
  (	74	,	0.518848435	,	-0.368826778	),
  (	74	,	0.447660601	,	-0.35207848	),
  (	74	,	0.468022905	,	-0.305146594	),
  (	74	,	0.618843693	,	-0.249316805	),
  (	74	,	0.651851346	,	-0.225334184	),
  (	74	,	0.70469632	,	-0.263561908	),
  (	74	,	0.856324542	,	-0.209195337	),
  (	74	,	0.976347298	,	-0.167604388	),
  (	74	,	0.926138619	,	-0.123751597	),
  (	74	,	0.849572119	,	-0.116979248	),
  (	74	,	0.751523035	,	-0.144289366	),
  (	74	,	2.429346438	,	-1.477599288	),
  (	74	,	2.640751236	,	-1.379888624	),
  (	74	,	2.276522833	,	-1.379646802	),
  (	74	,	2.445301902	,	-1.321446944	),
  (	74	,	2.277953511	,	-1.302175573	),
  (	74	,	2.133435583	,	-1.251781674	),
  (	74	,	2.324854449	,	-1.218772423	),
  (	74	,	2.886238389	,	-1.320590777	),
  (	74	,	2.88862317	,	-1.282605129	),
  (	74	,	2.853612198	,	-1.259347331	),
  (	74	,	2.74945319	,	-1.237227141	),
  (	74	,	2.888727571	,	-1.252222263	),
  (	74	,	2.866909328	,	-1.198469735	),
  (	74	,	2.72372928	,	-1.220293244	),
  (	74	,	2.950177238	,	-1.190284859	),
  (	74	,	3.045872008	,	-1.145911482	),
  (	74	,	2.842044884	,	-1.16613898	),
  (	74	,	2.80122585	,	-1.10841034	),
  (	74	,	2.845064598	,	-1.07214099	),
  (	74	,	2.61012839	,	-1.257765185	),
  (	74	,	2.643520953	,	-1.192022406	),
  (	74	,	2.400382583	,	-1.143000158	),
  (	74	,	2.507083129	,	-1.117547253	),
  (	74	,	2.734666399	,	-1.123147647	),
  (	74	,	2.751342671	,	-1.070523255	),
  (	74	,	2.67764352	,	-1.05179046	),
  (	74	,	2.61791126	,	-1.055866111	),
  (	74	,	1.988242596	,	-1.230870575	),
  (	74	,	1.80036025	,	-1.230629004	),
  (	74	,	2.129018873	,	-1.197563419	),
  (	74	,	2.305498838	,	-1.141976378	),
  (	74	,	2.231228349	,	-1.143587311	),
  (	74	,	2.105342598	,	-1.152298613	),
  (	74	,	2.232438802	,	-1.088020683	),
  (	74	,	1.880569187	,	-1.186149979	),
  (	74	,	1.706140362	,	-1.16711177	),
  (	74	,	1.73845778	,	-1.153406577	),
  (	74	,	1.630498486	,	-1.16377942	),
  (	74	,	2.060020085	,	-1.122145465	),
  (	74	,	2.067807062	,	-1.057383815	),
  (	74	,	2.084392123	,	-1.003199556	),
  (	74	,	2.095301585	,	-0.96369507	),
  (	74	,	2.372883521	,	-1.12896809	),
  (	74	,	2.430048256	,	-1.11308516	),
  (	74	,	2.29821891	,	-1.102906254	),
  (	74	,	2.311075815	,	-1.102732079	),
  (	74	,	2.450316676	,	-1.061692956	),
  (	74	,	2.404473899	,	-1.063841681	),
  (	74	,	2.38963831	,	-1.032966709	),
  (	74	,	2.52428618	,	-1.0327991	),
  (	74	,	2.501452195	,	-1.011644382	),
  (	74	,	2.555646392	,	-0.912548957	),
  (	74	,	2.479887109	,	-0.866643938	),
  (	74	,	2.238785892	,	-0.984306298	),
  (	74	,	2.211272231	,	-0.966264313	),
  (	74	,	2.334401193	,	-0.954682396	),
  (	74	,	2.269146516	,	-0.939892406	),
  (	74	,	2.278373523	,	-0.924457584	),
  (	74	,	2.115564287	,	-0.959742667	),
  (	74	,	2.234373659	,	-0.928720952	),
  (	74	,	2.254795237	,	-0.916586528	),
  (	74	,	2.269532708	,	-0.906550023	),
  (	74	,	2.217712234	,	-0.903563004	),
  (	74	,	2.212303825	,	-0.892330481	),
  (	74	,	2.256538423	,	-0.862632135	),
  (	74	,	2.338026447	,	-0.900376765	),
  (	74	,	2.342997595	,	-0.867096882	),
  (	74	,	2.327273355	,	-0.773759901	),
  (	74	,	2.343652845	,	-0.75496218	),
  (	74	,	3.105879706	,	-1.127407487	),
  (	74	,	3.028638621	,	-1.041637871	),
  (	74	,	3.050623024	,	-1.022723233	),
  (	74	,	2.918289693	,	-1.074415323	),
  (	74	,	2.915189961	,	-1.061608968	),
  (	74	,	2.968603787	,	-1.066343644	),
  (	74	,	2.911348229	,	-1.044982623	),
  (	74	,	2.909940324	,	-1.026137539	),
  (	74	,	2.863521101	,	-1.013221191	),
  (	74	,	2.98140309	,	-1.02603303	),
  (	74	,	3.133295406	,	-1.040089179	),
  (	74	,	3.119917799	,	-0.979083752	),
  (	74	,	3.058700369	,	-0.952055983	),
  (	74	,	2.954165991	,	-0.970797432	),
  (	74	,	2.926266489	,	-0.866611877	),
  (	74	,	2.813252886	,	-1.039608297	),
  (	74	,	2.846669883	,	-1.016693569	),
  (	74	,	2.830236901	,	-1.006581079	),
  (	74	,	2.849853281	,	-1.009183423	),
  (	74	,	2.773890694	,	-1.016566788	),
  (	74	,	2.771027575	,	-0.967089763	),
  (	74	,	2.748531179	,	-0.95955267	),
  (	74	,	2.679521619	,	-0.959820894	),
  (	74	,	2.714633244	,	-0.860334386	),
  (	74	,	2.865298997	,	-0.883278149	),
  (	74	,	2.79615233	,	-0.838195976	),
  (	74	,	2.778278277	,	-0.824754754	),
  (	74	,	2.715577392	,	-0.837260127	),
  (	74	,	2.749117561	,	-0.752755715	),
  (	74	,	3.098278456	,	-0.902347291	),
  (	74	,	3.074574875	,	-0.857719713	),
  (	74	,	2.974365962	,	-0.85124866	),
  (	74	,	2.965047112	,	-0.827219932	),
  (	74	,	3.01575085	,	-0.784834803	),
  (	74	,	2.957699134	,	-0.794227675	),
  (	74	,	2.974160028	,	-0.760226536	),
  (	74	,	2.943225029	,	-0.747928917	),
  (	74	,	3.029310853	,	-0.718285927	),
  (	74	,	2.907423951	,	-0.774470997	),
  (	74	,	2.821434417	,	-0.743691813	),
  (	74	,	2.94737059	,	-0.716582611	),
  (	74	,	2.963476118	,	-0.706855687	),
  (	74	,	2.92593383	,	-0.568347563	),
  (	74	,	2.631831862	,	-0.908374048	),
  (	74	,	2.585728111	,	-0.902562528	),
  (	74	,	2.606488055	,	-0.864915506	),
  (	74	,	2.525517787	,	-0.881531393	),
  (	74	,	2.669745401	,	-0.713389743	),
  (	74	,	2.594655629	,	-0.756096381	),
  (	74	,	2.466399454	,	-0.819304235	),
  (	74	,	2.438490669	,	-0.785537598	),
  (	74	,	2.392340506	,	-0.723026525	),
  (	74	,	2.501381709	,	-0.674344902	),
  (	74	,	2.493696484	,	-0.641416421	),
  (	74	,	2.535814127	,	-0.628808171	),
  (	74	,	2.479425651	,	-0.60919236	),
  (	74	,	2.582776362	,	-0.575609607	),
  (	74	,	2.745033586	,	-0.664258076	),
  (	74	,	2.835818992	,	-0.624906396	),
  (	74	,	2.691566294	,	-0.595633213	),
  (	74	,	2.933533348	,	-0.519802577	),
  (	74	,	2.85351063	,	-0.466806628	),
  (	74	,	2.688072354	,	-0.499400506	),
  (	74	,	2.636736225	,	-0.495306068	),
  (	74	,	2.775394942	,	-0.465580989	),
  (	74	,	2.800715963	,	-0.454600946	),
  (	74	,	2.791250742	,	-0.393233644	),
  (	74	,	2.747355737	,	-0.388284186	),
  (	74	,	1.721604173	,	-1.073301408	),
  (	74	,	1.846794451	,	-1.032851526	),
  (	74	,	1.841507152	,	-1.000349553	),
  (	74	,	1.982988301	,	-0.943614064	),
  (	74	,	2.044483737	,	-0.919509981	),
  (	74	,	2.036204315	,	-0.89006395	),
  (	74	,	1.744121536	,	-0.932903674	),
  (	74	,	1.593738038	,	-0.949603971	),
  (	74	,	1.64784497	,	-0.942103105	),
  (	74	,	1.729880139	,	-0.878280238	),
  (	74	,	1.849643927	,	-0.884208089	),
  (	74	,	1.903845493	,	-0.873509076	),
  (	74	,	1.962429176	,	-0.814883809	),
  (	74	,	2.124948734	,	-0.906510274	),
  (	74	,	2.180520432	,	-0.864577714	),
  (	74	,	2.177951879	,	-0.806433768	),
  (	74	,	2.069996679	,	-0.875643068	),
  (	74	,	2.089327825	,	-0.832223444	),
  (	74	,	2.074328298	,	-0.825768947	),
  (	74	,	2.127900134	,	-0.824752512	),
  (	74	,	2.155867316	,	-0.818863314	),
  (	74	,	2.137458055	,	-0.759712559	),
  (	74	,	2.243554772	,	-0.796507915	),
  (	74	,	2.239093446	,	-0.762420326	),
  (	74	,	2.30974204	,	-0.756960121	),
  (	74	,	2.303385119	,	-0.756669496	),
  (	74	,	2.311124405	,	-0.747409772	),
  (	74	,	2.289651882	,	-0.744135582	),
  (	74	,	2.289312904	,	-0.720422823	),
  (	74	,	2.308357033	,	-0.68791587	),
  (	74	,	2.198221235	,	-0.733629753	),
  (	74	,	2.19098403	,	-0.715430942	),
  (	74	,	2.257204576	,	-0.710196837	),
  (	74	,	2.253164422	,	-0.671165147	),
  (	74	,	2.07663295	,	-0.778772858	),
  (	74	,	2.07596286	,	-0.765236357	),
  (	74	,	2.060538491	,	-0.738666889	),
  (	74	,	2.070209565	,	-0.727076914	),
  (	74	,	2.097434582	,	-0.701567903	),
  (	74	,	1.982923764	,	-0.7400009	),
  (	74	,	2.086018217	,	-0.655894753	),
  (	74	,	2.024760184	,	-0.677499171	),
  (	74	,	2.199773708	,	-0.619749838	),
  (	74	,	2.125569458	,	-0.634963164	),
  (	74	,	2.100903227	,	-0.617477625	),
  (	74	,	2.13035225	,	-0.581892759	),
  (	74	,	1.778886703	,	-0.825539316	),
  (	74	,	1.768115038	,	-0.81774411	),
  (	74	,	1.591625716	,	-0.845759631	),
  (	74	,	1.711850806	,	-0.790813261	),
  (	74	,	1.713085606	,	-0.771801003	),
  (	74	,	1.742913072	,	-0.757949992	),
  (	74	,	1.802024082	,	-0.743990808	),
  (	74	,	1.795214167	,	-0.70773691	),
  (	74	,	1.853057902	,	-0.706577282	),
  (	74	,	1.597827859	,	-0.799646522	),
  (	74	,	1.609083987	,	-0.764665937	),
  (	74	,	1.572091478	,	-0.768047343	),
  (	74	,	1.612932612	,	-0.732694152	),
  (	74	,	1.797826223	,	-0.591929929	),
  (	74	,	1.728784448	,	-0.630742004	),
  (	74	,	1.789747626	,	-0.591415906	),
  (	74	,	1.995754989	,	-0.635615973	),
  (	74	,	1.874096665	,	-0.628156683	),
  (	74	,	1.9603743	,	-0.596403379	),
  (	74	,	2.068568547	,	-0.593799599	),
  (	74	,	2.087297298	,	-0.586593134	),
  (	74	,	2.112203273	,	-0.509169729	),
  (	74	,	2.007447334	,	-0.526549261	),
  (	74	,	2.077939576	,	-0.491873902	),
  (	74	,	1.886706031	,	-0.558188681	),
  (	74	,	1.872494822	,	-0.557344792	),
  (	74	,	1.87845589	,	-0.535161252	),
  (	74	,	1.791766888	,	-0.545872101	),
  (	74	,	1.874990303	,	-0.486655665	),
  (	74	,	1.944113749	,	-0.464702758	),
  (	74	,	1.927226697	,	-0.422938338	),
  (	74	,	1.905049658	,	-0.415856676	),
  (	74	,	1.948860168	,	-0.402857112	),
  (	74	,	1.921521328	,	-0.38544846	),
  (	74	,	1.965446177	,	-0.363166221	),
  (	74	,	2.346285828	,	-0.676184065	),
  (	74	,	2.373523849	,	-0.641210084	),
  (	74	,	2.406093498	,	-0.623917637	),
  (	74	,	2.296674992	,	-0.591699065	),
  (	74	,	2.334499073	,	-0.595919062	),
  (	74	,	2.455782108	,	-0.620009094	),
  (	74	,	2.475029539	,	-0.589775124	),
  (	74	,	2.412635071	,	-0.5422064	),
  (	74	,	2.426558498	,	-0.504160468	),
  (	74	,	2.31127694	,	-0.493158266	),
  (	74	,	2.190880142	,	-0.499582517	),
  (	74	,	2.250489899	,	-0.497048721	),
  (	74	,	2.217494476	,	-0.481094932	),
  (	74	,	2.368591659	,	-0.492121259	),
  (	74	,	2.364085362	,	-0.463585585	),
  (	74	,	2.401903884	,	-0.458792851	),
  (	74	,	2.295839817	,	-0.464480626	),
  (	74	,	2.332170807	,	-0.410529738	),
  (	74	,	2.564189171	,	-0.495321412	),
  (	74	,	2.654436167	,	-0.344833316	),
  (	74	,	2.695072178	,	-0.376790135	),
  (	74	,	2.714095706	,	-0.359114456	),
  (	74	,	2.730783778	,	-0.354741885	),
  (	74	,	2.665781862	,	-0.295498888	),
  (	74	,	2.464473398	,	-0.415851423	),
  (	74	,	2.422669491	,	-0.34201511	),
  (	74	,	2.427883632	,	-0.339623811	),
  (	74	,	2.465274975	,	-0.300524075	),
  (	74	,	2.483980759	,	-0.239752512	),
  (	74	,	2.499812443	,	-0.244359855	),
  (	74	,	2.18040487	,	-0.472666201	),
  (	74	,	2.238736176	,	-0.429473622	),
  (	74	,	2.100403527	,	-0.43552281	),
  (	74	,	2.241663023	,	-0.407611212	),
  (	74	,	2.229984828	,	-0.354372781	),
  (	74	,	2.16415949	,	-0.338738551	),
  (	74	,	2.142634448	,	-0.33116015	),
  (	74	,	2.079827351	,	-0.288533484	),
  (	74	,	2.079275539	,	-0.270950543	),
  (	74	,	2.098920117	,	-0.246758909	),
  (	74	,	2.129444327	,	-0.235764207	),
  (	74	,	2.352847313	,	-0.288024311	),
  (	74	,	2.392869394	,	-0.264350712	),
  (	74	,	2.309320464	,	-0.271661449	),
  (	74	,	2.38991082	,	-0.209798639	),
  (	74	,	2.453857574	,	-0.105778456	),
  (	74	,	2.259696107	,	-0.221760035	),
  (	74	,	2.309819589	,	-0.189962398	),
  (	74	,	2.201992761	,	-0.201141126	),
  (	74	,	2.224612717	,	-0.182670841	),
  (	74	,	2.360712007	,	-0.16091561	),
  (	74	,	2.41156631	,	-0.052940762	),
  (	74	,	2.311329493	,	-0.099387643	),
  (	74	,	2.363319799	,	-0.025768327	),
  (	74	,	3.822730174	,	-1.468666641	),
  (	74	,	3.678717763	,	-1.447234435	),
  (	74	,	3.90803905	,	-1.376771135	),
  (	74	,	4.704335017	,	-1.42164445	),
  (	74	,	4.262870669	,	-1.410232199	),
  (	74	,	4.348749772	,	-1.349941338	),
  (	74	,	4.224544325	,	-1.348948457	),
  (	74	,	3.190254442	,	-1.462205297	),
  (	74	,	3.782710188	,	-1.335514411	),
  (	74	,	3.596964294	,	-1.285205575	),
  (	74	,	4.015785721	,	-1.318842452	),
  (	74	,	4.097637607	,	-1.261833752	),
  (	74	,	3.97292478	,	-1.250786415	),
  (	74	,	3.821912118	,	-1.221217805	),
  (	74	,	4.672807865	,	-1.327480314	),
  (	74	,	4.548838633	,	-1.229452207	),
  (	74	,	4.228964283	,	-1.240446317	),
  (	74	,	4.316409588	,	-1.241351733	),
  (	74	,	4.374974707	,	-1.231865164	),
  (	74	,	4.700546591	,	-1.240843371	),
  (	74	,	4.650160504	,	-1.198124334	),
  (	74	,	4.484770795	,	-1.172652876	),
  (	74	,	4.512220441	,	-1.151271154	),
  (	74	,	4.44489093	,	-1.077604318	),
  (	74	,	4.400437078	,	-1.073187931	),
  (	74	,	4.247544974	,	-1.134215048	),
  (	74	,	4.218247674	,	-1.126813017	),
  (	74	,	4.105627374	,	-1.102954734	),
  (	74	,	4.234376785	,	-1.098212985	),
  (	74	,	3.385320629	,	-1.274659698	),
  (	74	,	3.600366745	,	-1.248488474	),
  (	74	,	3.339807423	,	-1.251599679	),
  (	74	,	3.527252086	,	-1.184547549	),
  (	74	,	3.469557057	,	-1.184738065	),
  (	74	,	3.876871794	,	-1.161103118	),
  (	74	,	3.739596912	,	-1.157460355	),
  (	74	,	3.838164851	,	-1.12947157	),
  (	74	,	3.662377596	,	-1.184042967	),
  (	74	,	3.758171835	,	-1.121229499	),
  (	74	,	3.773184698	,	-1.111906601	),
  (	74	,	3.73123725	,	-1.08066369	),
  (	74	,	3.337954727	,	-1.204799914	),
  (	74	,	3.270389439	,	-1.166935598	),
  (	74	,	3.204581516	,	-1.161073149	),
  (	74	,	3.632669529	,	-1.105773492	),
  (	74	,	3.554900682	,	-1.105412371	),
  (	74	,	3.9339587	,	-1.115738732	),
  (	74	,	3.883432488	,	-1.087877529	),
  (	74	,	4.010580141	,	-1.049531746	),
  (	74	,	3.990338914	,	-1.042580063	),
  (	74	,	3.853147145	,	-1.085725123	),
  (	74	,	3.853494863	,	-1.01694239	),
  (	74	,	3.852225022	,	-1.013802943	),
  (	74	,	3.930264557	,	-1.04391768	),
  (	74	,	4.076991907	,	-0.996116115	),
  (	74	,	4.022990941	,	-0.997374101	),
  (	74	,	4.023988637	,	-0.935583688	),
  (	74	,	4.04865977	,	-0.937273988	),
  (	74	,	4.062493551	,	-0.918881353	),
  (	74	,	3.761402648	,	-1.017373931	),
  (	74	,	3.886556261	,	-0.960092771	),
  (	74	,	3.870597159	,	-0.938556345	),
  (	74	,	3.726811142	,	-0.941291206	),
  (	74	,	3.75555412	,	-0.913263412	),
  (	74	,	3.92339595	,	-0.852185654	),
  (	74	,	4.523229308	,	-1.063889359	),
  (	74	,	4.499748781	,	-0.989273311	),
  (	74	,	4.603094877	,	-0.993347297	),
  (	74	,	4.624119541	,	-0.948699137	),
  (	74	,	4.598289707	,	-0.920779119	),
  (	74	,	4.395699591	,	-1.041429865	),
  (	74	,	4.367334845	,	-1.027457817	),
  (	74	,	4.245716015	,	-0.948766144	),
  (	74	,	4.316975605	,	-0.900040615	),
  (	74	,	4.346247071	,	-0.894303435	),
  (	74	,	4.409595621	,	-0.873437202	),
  (	74	,	4.392329982	,	-0.821878568	),
  (	74	,	4.396072878	,	-0.79343651	),
  (	74	,	4.712206381	,	-0.915833925	),
  (	74	,	4.694881588	,	-0.854153797	),
  (	74	,	4.53092519	,	-0.834574496	),
  (	74	,	4.532184974	,	-0.816799856	),
  (	74	,	4.540592106	,	-0.803658817	),
  (	74	,	4.695909178	,	-0.815106318	),
  (	74	,	4.658217877	,	-0.7940462	),
  (	74	,	4.620686444	,	-0.753051588	),
  (	74	,	4.570776292	,	-0.759986934	),
  (	74	,	4.600098273	,	-0.716044492	),
  (	74	,	4.625830179	,	-0.684256876	),
  (	74	,	4.476818663	,	-0.774449407	),
  (	74	,	4.465292011	,	-0.699669327	),
  (	74	,	4.441313867	,	-0.663165229	),
  (	74	,	4.38387331	,	-0.687556396	),
  (	74	,	4.418034595	,	-0.670836761	),
  (	74	,	4.529997634	,	-0.692737892	),
  (	74	,	4.463702711	,	-0.658333749	),
  (	74	,	4.164906247	,	-0.894267753	),
  (	74	,	4.153999666	,	-0.794215586	),
  (	74	,	4.282933585	,	-0.784434055	),
  (	74	,	4.220317164	,	-0.734255871	),
  (	74	,	4.201586316	,	-0.758200105	),
  (	74	,	4.14187603	,	-0.729397601	),
  (	74	,	4.217219594	,	-0.705989068	),
  (	74	,	4.197432405	,	-0.655101218	),
  (	74	,	4.100478392	,	-0.74643384	),
  (	74	,	4.089225593	,	-0.715913866	),
  (	74	,	3.990330306	,	-0.757248211	),
  (	74	,	4.040933427	,	-0.696195988	),
  (	74	,	4.152078209	,	-0.65339959	),
  (	74	,	4.113164654	,	-0.561753289	),
  (	74	,	4.12237733	,	-0.535573703	),
  (	74	,	4.375441679	,	-0.651761258	),
  (	74	,	4.366710529	,	-0.648459039	),
  (	74	,	4.268351969	,	-0.609377594	),
  (	74	,	4.443299323	,	-0.586590251	),
  (	74	,	4.461315077	,	-0.563043066	),
  (	74	,	4.484352246	,	-0.542413283	),
  (	74	,	4.425902337	,	-0.450812415	),
  (	74	,	4.230409204	,	-0.569832891	),
  (	74	,	4.176689536	,	-0.48246014	),
  (	74	,	4.224216965	,	-0.483988007	),
  (	74	,	4.319628117	,	-0.43891547	),
  (	74	,	3.230010057	,	-1.128316385	),
  (	74	,	3.241959487	,	-1.129758703	),
  (	74	,	3.26501151	,	-1.078034313	),
  (	74	,	3.41029024	,	-1.058915926	),
  (	74	,	3.390275552	,	-1.042703542	),
  (	74	,	3.434106196	,	-1.02634962	),
  (	74	,	3.16246065	,	-1.082048872	),
  (	74	,	3.249393316	,	-1.062977934	),
  (	74	,	3.26606042	,	-1.062826583	),
  (	74	,	3.527300832	,	-0.97354575	),
  (	74	,	3.641584734	,	-0.96118751	),
  (	74	,	3.649188548	,	-0.94478212	),
  (	74	,	3.573128122	,	-0.960358875	),
  (	74	,	3.508734176	,	-0.938868512	),
  (	74	,	3.183674633	,	-1.018394848	),
  (	74	,	3.1900083	,	-0.984390664	),
  (	74	,	3.281346676	,	-0.982417577	),
  (	74	,	3.39538929	,	-0.945721085	),
  (	74	,	3.358336649	,	-0.931339598	),
  (	74	,	3.152565904	,	-0.987166414	),
  (	74	,	3.28676892	,	-0.88401563	),
  (	74	,	3.802570166	,	-0.833029294	),
  (	74	,	3.740051729	,	-0.818746113	),
  (	74	,	3.812934006	,	-0.810969946	),
  (	74	,	3.803875166	,	-0.782025114	),
  (	74	,	3.841964414	,	-0.708745601	),
  (	74	,	3.81765925	,	-0.649337059	),
  (	74	,	3.598177188	,	-0.824094459	),
  (	74	,	3.615713252	,	-0.819847235	),
  (	74	,	3.594792132	,	-0.793035	),
  (	74	,	3.639742979	,	-0.64339865	),
  (	74	,	3.725262289	,	-0.639162544	),
  (	74	,	3.816739835	,	-0.618960614	),
  (	74	,	3.751320269	,	-0.643299615	),
  (	74	,	3.696316277	,	-0.619451137	),
  (	74	,	3.729420248	,	-0.54193985	),
  (	74	,	3.196547891	,	-0.921142499	),
  (	74	,	3.228551683	,	-0.843284507	),
  (	74	,	3.284408356	,	-0.79342748	),
  (	74	,	3.476566044	,	-0.720524296	),
  (	74	,	3.375266628	,	-0.75180241	),
  (	74	,	3.331409204	,	-0.721200266	),
  (	74	,	3.505434305	,	-0.691638751	),
  (	74	,	3.509788076	,	-0.663809079	),
  (	74	,	3.531433105	,	-0.620839664	),
  (	74	,	3.468424734	,	-0.604438651	),
  (	74	,	3.62309494	,	-0.542231343	),
  (	74	,	3.433637907	,	-0.595550946	),
  (	74	,	3.44271836	,	-0.584713146	),
  (	74	,	3.389202722	,	-0.477903126	),
  (	74	,	3.584265981	,	-0.463059547	),
  (	74	,	3.493940319	,	-0.414754595	),
  (	74	,	3.863035024	,	-0.630898619	),
  (	74	,	4.049323947	,	-0.585479715	),
  (	74	,	4.042412294	,	-0.546653746	),
  (	74	,	3.847443468	,	-0.518322389	),
  (	74	,	3.77523251	,	-0.490979349	),
  (	74	,	3.8396831	,	-0.473592902	),
  (	74	,	4.012825957	,	-0.423592285	),
  (	74	,	3.836965179	,	-0.436834964	),
  (	74	,	3.843449819	,	-0.419888401	),
  (	74	,	3.953399179	,	-0.391024433	),
  (	74	,	4.154207243	,	-0.462915592	),
  (	74	,	4.088933166	,	-0.462379875	),
  (	74	,	4.193741653	,	-0.423532517	),
  (	74	,	4.096036167	,	-0.402290754	),
  (	74	,	4.253752374	,	-0.390612773	),
  (	74	,	4.193574771	,	-0.36923794	),
  (	74	,	4.276454613	,	-0.350053174	),
  (	74	,	4.202392235	,	-0.346286516	),
  (	74	,	4.155172205	,	-0.32176737	),
  (	74	,	4.050522031	,	-0.370177146	),
  (	74	,	4.095802605	,	-0.308313103	),
  (	74	,	4.182001878	,	-0.234625259	),
  (	74	,	4.047836996	,	-0.261001137	),
  (	74	,	4.075600705	,	-0.248353741	),
  (	74	,	3.741772523	,	-0.470513495	),
  (	74	,	3.721648898	,	-0.445137215	),
  (	74	,	3.80985839	,	-0.41919424	),
  (	74	,	3.687416904	,	-0.39483158	),
  (	74	,	3.850148344	,	-0.408855834	),
  (	74	,	3.867929514	,	-0.391028953	),
  (	74	,	3.834966148	,	-0.389703906	),
  (	74	,	3.749963745	,	-0.323299493	),
  (	74	,	3.841972372	,	-0.282913524	),
  (	74	,	3.622628402	,	-0.364238552	),
  (	74	,	3.704484217	,	-0.335905643	),
  (	74	,	3.548206299	,	-0.348898505	),
  (	74	,	3.53829926	,	-0.341392577	),
  (	74	,	3.597653674	,	-0.313059438	),
  (	74	,	3.63140867	,	-0.256153659	),
  (	74	,	3.784533701	,	-0.258992872	),
  (	74	,	3.910978251	,	-0.293231723	),
  (	74	,	3.98087344	,	-0.28642758	),
  (	74	,	3.926539599	,	-0.190786173	),
  (	74	,	4.003493457	,	-0.183272247	),
  (	74	,	3.900188728	,	-0.158580706	),
  (	74	,	3.866885173	,	-0.136084415	),
  (	74	,	3.96875734	,	-0.094166904	),
  (	74	,	3.996918902	,	-0.085488155	),
  (	74	,	5.027552357	,	-1.457081119	),
  (	74	,	4.939140932	,	-1.454146903	),
  (	74	,	4.830017846	,	-1.383516679	),
  (	74	,	5.189682333	,	-1.283222659	),
  (	74	,	5.594958342	,	-1.249156507	),
  (	74	,	5.376685068	,	-1.254271686	),
  (	74	,	5.405881341	,	-1.240832511	),
  (	74	,	6.111355431	,	-1.320038108	),
  (	74	,	5.917158235	,	-1.238551913	),
  (	74	,	6.058991364	,	-1.11479297	),
  (	74	,	5.841749947	,	-1.19231108	),
  (	74	,	5.779841941	,	-1.129729565	),
  (	74	,	5.831520572	,	-1.105467213	),
  (	74	,	5.79297382	,	-1.035343649	),
  (	74	,	4.787688768	,	-1.336648037	),
  (	74	,	5.004451967	,	-1.304766246	),
  (	74	,	4.946757861	,	-1.30827124	),
  (	74	,	5.109534082	,	-1.291288503	),
  (	74	,	5.19775452	,	-1.27052257	),
  (	74	,	4.883248181	,	-1.235749082	),
  (	74	,	5.385996356	,	-1.16467477	),
  (	74	,	5.387557861	,	-1.104998024	),
  (	74	,	5.297546218	,	-1.090642419	),
  (	74	,	4.777128815	,	-1.166144736	),
  (	74	,	4.992071902	,	-1.113251187	),
  (	74	,	4.926446242	,	-1.104260904	),
  (	74	,	5.14699415	,	-1.126365081	),
  (	74	,	5.188529257	,	-1.078882534	),
  (	74	,	5.049027761	,	-1.078871809	),
  (	74	,	5.51772805	,	-1.028581183	),
  (	74	,	5.689389237	,	-0.951204698	),
  (	74	,	5.657947392	,	-0.887443567	),
  (	74	,	5.477481434	,	-0.935309794	),
  (	74	,	5.5252132	,	-0.84694877	),
  (	74	,	5.44222621	,	-0.823320182	),
  (	74	,	5.521938983	,	-0.759608525	),
  (	74	,	6.22936524	,	-1.13866187	),
  (	74	,	6.20652779	,	-1.065729836	),
  (	74	,	6.147138433	,	-1.037364142	),
  (	74	,	6.139131699	,	-1.019694691	),
  (	74	,	5.982976695	,	-1.031443082	),
  (	74	,	6.14454711	,	-0.985011419	),
  (	74	,	5.968840159	,	-1.024243474	),
  (	74	,	5.834848816	,	-0.94808857	),
  (	74	,	5.806873457	,	-0.967926091	),
  (	74	,	6.022019121	,	-0.902357957	),
  (	74	,	6.024857116	,	-0.863095874	),
  (	74	,	5.898325042	,	-0.812971214	),
  (	74	,	5.966601327	,	-0.784788599	),
  (	74	,	6.264555551	,	-0.939316601	),
  (	74	,	6.193564875	,	-0.813976574	),
  (	74	,	6.142870925	,	-0.878662616	),
  (	74	,	6.099954861	,	-0.839731338	),
  (	74	,	6.224532196	,	-0.725844608	),
  (	74	,	6.073966718	,	-0.767729384	),
  (	74	,	6.128039177	,	-0.649279574	),
  (	74	,	5.761924514	,	-0.740925217	),
  (	74	,	5.778707143	,	-0.678525384	),
  (	74	,	5.613943931	,	-0.804038627	),
  (	74	,	5.656558405	,	-0.703896207	),
  (	74	,	5.55804908	,	-0.752763604	),
  (	74	,	5.62792612	,	-0.657868901	),
  (	74	,	5.746662341	,	-0.657270654	),
  (	74	,	5.746174891	,	-0.617145595	),
  (	74	,	5.839361599	,	-0.638718416	),
  (	74	,	5.77389575	,	-0.548823466	),
  (	74	,	5.888003687	,	-0.50020552	),
  (	74	,	5.866771636	,	-0.407839229	),
  (	74	,	5.840232683	,	-0.407211073	),
  (	74	,	4.922294356	,	-1.086123285	),
  (	74	,	4.988849918	,	-1.010972506	),
  (	74	,	4.792283712	,	-1.068296146	),
  (	74	,	4.818812795	,	-1.040498364	),
  (	74	,	4.883786057	,	-1.031882286	),
  (	74	,	4.975480081	,	-0.960200651	),
  (	74	,	5.038747294	,	-1.01244875	),
  (	74	,	5.216257183	,	-0.941558037	),
  (	74	,	4.831597844	,	-0.936092356	),
  (	74	,	4.825023194	,	-0.936218064	),
  (	74	,	4.835413069	,	-0.916300831	),
  (	74	,	4.888701796	,	-0.91107406	),
  (	74	,	5.117670922	,	-0.816434855	),
  (	74	,	5.131901855	,	-0.805496807	),
  (	74	,	4.976966222	,	-0.842723848	),
  (	74	,	5.05004346	,	-0.792817153	),
  (	74	,	5.365328248	,	-0.805495191	),
  (	74	,	5.448058424	,	-0.750626478	),
  (	74	,	5.190462606	,	-0.659407478	),
  (	74	,	4.747437806	,	-0.911721216	),
  (	74	,	4.91119876	,	-0.845781458	),
  (	74	,	4.742950734	,	-0.842072268	),
  (	74	,	5.064030963	,	-0.697939296	),
  (	74	,	4.922404847	,	-0.760493665	),
  (	74	,	4.961408661	,	-0.679186912	),
  (	74	,	4.76905411	,	-0.683520661	),
  (	74	,	4.81541843	,	-0.678120032	),
  (	74	,	4.945440562	,	-0.650564003	),
  (	74	,	4.981383487	,	-0.643867832	),
  (	74	,	4.879635732	,	-0.570490563	),
  (	74	,	5.156679808	,	-0.643810311	),
  (	74	,	5.059352118	,	-0.639823705	),
  (	74	,	5.078193903	,	-0.610289569	),
  (	74	,	4.978560909	,	-0.580001845	),
  (	74	,	5.074297341	,	-0.50727473	),
  (	74	,	5.001768194	,	-0.476250279	),
  (	74	,	5.009683826	,	-0.468353124	),
  (	74	,	5.044826793	,	-0.447973537	),
  (	74	,	5.148408421	,	-0.3850697	),
  (	74	,	5.505833788	,	-0.638340098	),
  (	74	,	5.470146026	,	-0.631745755	),
  (	74	,	5.531635323	,	-0.542031082	),
  (	74	,	5.550684287	,	-0.533888255	),
  (	74	,	5.351815611	,	-0.507440894	),
  (	74	,	5.454522249	,	-0.477660692	),
  (	74	,	5.412168769	,	-0.42097439	),
  (	74	,	5.447017937	,	-0.396921671	),
  (	74	,	5.692138929	,	-0.434780583	),
  (	74	,	5.631903567	,	-0.448717474	),
  (	74	,	5.686919199	,	-0.421347118	),
  (	74	,	5.821159954	,	-0.373698425	),
  (	74	,	5.840607173	,	-0.361984744	),
  (	74	,	5.833417478	,	-0.34951746	),
  (	74	,	5.740554978	,	-0.368965654	),
  (	74	,	5.770240586	,	-0.296084909	),
  (	74	,	5.667276994	,	-0.3425297	),
  (	74	,	5.661971447	,	-0.335644452	),
  (	74	,	5.680964786	,	-0.300570374	),
  (	74	,	5.749948302	,	-0.263955032	),
  (	74	,	5.664611943	,	-0.260224787	),
  (	74	,	5.276595761	,	-0.496380138	),
  (	74	,	5.322160196	,	-0.440340101	),
  (	74	,	5.425532174	,	-0.391897048	),
  (	74	,	5.39499449	,	-0.359286226	),
  (	74	,	5.447319472	,	-0.317680943	),
  (	74	,	5.422140135	,	-0.316072897	),
  (	74	,	5.257667477	,	-0.372005062	),
  (	74	,	5.281473437	,	-0.338318708	),
  (	74	,	5.112550091	,	-0.338359131	),
  (	74	,	5.306005792	,	-0.284419319	),
  (	74	,	5.25150822	,	-0.269014646	),
  (	74	,	5.479444607	,	-0.298705968	),
  (	74	,	5.529133167	,	-0.243007019	),
  (	74	,	5.508406348	,	-0.217246154	),
  (	74	,	5.658876008	,	-0.177579354	),
  (	74	,	5.623813807	,	-0.156923932	),
  (	74	,	5.569774575	,	-0.159834218	),
  (	74	,	5.360573522	,	-0.20588479	),
  (	74	,	5.361652329	,	-0.204673317	),
  (	74	,	5.388966869	,	-0.167214323	),
  (	74	,	5.521927565	,	-0.076134094	),
  (	74	,	5.511432597	,	-0.022841266	),
  (	74	,	2.644989043	,	-0.826761635	),
  (	75	,	0.747640158	,	0.053350811	),
  (	75	,	0.768250459	,	0.107774938	),
  (	75	,	0.861513866	,	0.133618344	),
  (	75	,	0.96662828	,	0.175957589	),
  (	75	,	0.895254528	,	0.217907819	),
  (	75	,	0.875132543	,	0.21549008	),
  (	75	,	0.704220348	,	0.148822163	),
  (	75	,	0.672911148	,	0.156883488	),
  (	75	,	0.637861821	,	0.185633415	),
  (	75	,	0.779993452	,	0.237432181	),
  (	75	,	0.824736241	,	0.224444606	),
  (	75	,	1.071278928	,	0.249338613	),
  (	75	,	1.165122446	,	0.346329579	),
  (	75	,	0.969817981	,	0.397689181	),
  (	75	,	1.005607638	,	0.427524124	),
  (	75	,	0.635134883	,	0.20890316	),
  (	75	,	0.623928629	,	0.307140774	),
  (	75	,	0.601081477	,	0.322103397	),
  (	75	,	0.693755814	,	0.25936212	),
  (	75	,	0.723083543	,	0.29707738	),
  (	75	,	0.730684159	,	0.338082889	),
  (	75	,	0.472748408	,	0.297109172	),
  (	75	,	0.530175715	,	0.31335	),
  (	75	,	0.573314322	,	0.373103462	),
  (	75	,	0.514694014	,	0.411949618	),
  (	75	,	0.553862433	,	0.459432745	),
  (	75	,	0.584861682	,	0.464730561	),
  (	75	,	0.803958179	,	0.37477137	),
  (	75	,	0.831928429	,	0.382089277	),
  (	75	,	0.865383653	,	0.420303084	),
  (	75	,	0.917480764	,	0.524316799	),
  (	75	,	0.832840072	,	0.562455872	),
  (	75	,	0.661187538	,	0.481173308	),
  (	75	,	0.699480171	,	0.520043761	),
  (	75	,	0.668172108	,	0.522978628	),
  (	75	,	0.602628835	,	0.52093174	),
  (	75	,	0.69136246	,	0.537804719	),
  (	75	,	0.700037808	,	0.56409788	),
  (	75	,	0.786642796	,	0.543228058	),
  (	75	,	0.776825953	,	0.550072094	),
  (	75	,	0.818843338	,	0.639071664	),
  (	75	,	0.790883295	,	0.630374912	),
  (	75	,	1.162002675	,	0.374725116	),
  (	75	,	1.188408888	,	0.439566245	),
  (	75	,	1.215159601	,	0.470191691	),
  (	75	,	1.209297048	,	0.487394759	),
  (	75	,	1.139937361	,	0.477351385	),
  (	75	,	1.289227837	,	0.561205247	),
  (	75	,	1.0849415	,	0.451652128	),
  (	75	,	1.0432312	,	0.474683465	),
  (	75	,	1.071446747	,	0.549728187	),
  (	75	,	1.145658597	,	0.566671393	),
  (	75	,	1.17463256	,	0.615502146	),
  (	75	,	1.235182745	,	0.592184219	),
  (	75	,	1.43014601	,	0.592468349	),
  (	75	,	1.37101391	,	0.702362341	),
  (	75	,	1.475953632	,	0.658767537	),
  (	75	,	1.479476642	,	0.662817511	),
  (	75	,	1.470963504	,	0.73003685	),
  (	75	,	1.481048568	,	0.744919657	),
  (	75	,	1.47166557	,	0.769181774	),
  (	75	,	1.314925342	,	0.800904876	),
  (	75	,	1.513454063	,	0.828460162	),
  (	75	,	1.500263792	,	0.832758393	),
  (	75	,	1.386717264	,	0.805086222	),
  (	75	,	1.431053382	,	0.844410359	),
  (	75	,	1.447715313	,	0.85407453	),
  (	75	,	1.498314186	,	0.884916135	),
  (	75	,	0.974767695	,	0.595440355	),
  (	75	,	0.96044401	,	0.595445656	),
  (	75	,	0.929952282	,	0.617827207	),
  (	75	,	0.946473962	,	0.611773057	),
  (	75	,	0.926452795	,	0.664303194	),
  (	75	,	1.060984987	,	0.647889283	),
  (	75	,	1.10879334	,	0.67141536	),
  (	75	,	1.054945549	,	0.697947188	),
  (	75	,	1.13677667	,	0.754647344	),
  (	75	,	1.127989592	,	0.763177855	),
  (	75	,	0.866283227	,	0.671222088	),
  (	75	,	0.940742658	,	0.748510287	),
  (	75	,	0.926219233	,	0.782617477	),
  (	75	,	0.912934509	,	0.786258599	),
  (	75	,	0.89722453	,	0.794395735	),
  (	75	,	0.975178749	,	0.753418449	),
  (	75	,	0.998783824	,	0.887319029	),
  (	75	,	0.997717147	,	0.896678165	),
  (	75	,	1.195879552	,	0.752013932	),
  (	75	,	1.173875131	,	0.745527075	),
  (	75	,	1.224361108	,	0.769637885	),
  (	75	,	1.245569111	,	0.828619159	),
  (	75	,	1.158399188	,	0.805359291	),
  (	75	,	1.377648888	,	0.882473227	),
  (	75	,	1.353188992	,	0.937412349	),
  (	75	,	1.458543549	,	0.982122361	),
  (	75	,	1.192417485	,	0.921619108	),
  (	75	,	1.084922416	,	0.931323609	),
  (	75	,	1.1640035	,	0.97116674	),
  (	75	,	1.341767516	,	0.969355846	),
  (	75	,	1.316535823	,	0.969964	),
  (	75	,	1.323508722	,	1.054558943	),
  (	75	,	0.380013496	,	0.444005354	),
  (	75	,	0.39850707	,	0.513344641	),
  (	75	,	0.457505301	,	0.49668772	),
  (	75	,	0.445488351	,	0.514977993	),
  (	75	,	0.358636241	,	0.553375027	),
  (	75	,	0.252625005	,	0.51523722	),
  (	75	,	0.231823925	,	0.529692903	),
  (	75	,	0.318674542	,	0.578653398	),
  (	75	,	0.291442489	,	0.613405938	),
  (	75	,	0.412866383	,	0.612813619	),
  (	75	,	0.397243562	,	0.689310398	),
  (	75	,	0.586147719	,	0.536248279	),
  (	75	,	0.627815652	,	0.590929233	),
  (	75	,	0.636314025	,	0.646012243	),
  (	75	,	0.590455559	,	0.68363249	),
  (	75	,	0.581301158	,	0.706979814	),
  (	75	,	0.734061033	,	0.761355921	),
  (	75	,	0.678783501	,	0.779114075	),
  (	75	,	0.524870303	,	0.673652993	),
  (	75	,	0.448037688	,	0.672218226	),
  (	75	,	0.565681148	,	0.748002443	),
  (	75	,	0.40825686	,	0.713862118	),
  (	75	,	0.463901916	,	0.76280731	),
  (	75	,	0.656331454	,	0.835205727	),
  (	75	,	0.584845557	,	0.828755882	),
  (	75	,	0.60753364	,	0.875172675	),
  (	75	,	0.505211391	,	0.902124694	),
  (	75	,	0.236344294	,	0.574009312	),
  (	75	,	0.288587407	,	0.619873623	),
  (	75	,	0.25326507	,	0.654489172	),
  (	75	,	0.086294412	,	0.645113675	),
  (	75	,	0.053392217	,	0.696413501	),
  (	75	,	0.059538085	,	0.749608243	),
  (	75	,	0.016333895	,	0.733450024	),
  (	75	,	0.07997491	,	0.777689776	),
  (	75	,	0.150585321	,	0.836291301	),
  (	75	,	0.010324827	,	0.881387973	),
  (	75	,	0.024360054	,	0.928021026	),
  (	75	,	0.373929195	,	0.78167068	),
  (	75	,	0.378900909	,	0.79722161	),
  (	75	,	0.422278706	,	0.843263708	),
  (	75	,	0.262769855	,	0.82586126	),
  (	75	,	0.264386295	,	0.825900279	),
  (	75	,	0.30923068	,	0.85808049	),
  (	75	,	0.307788372	,	0.909824033	),
  (	75	,	0.438889328	,	0.95891862	),
  (	75	,	0.43504539	,	0.973618431	),
  (	75	,	0.349920627	,	0.909864496	),
  (	75	,	0.153728444	,	0.904731353	),
  (	75	,	0.138479355	,	0.941808145	),
  (	75	,	0.193713789	,	0.945135486	),
  (	75	,	0.148423588	,	0.958710839	),
  (	75	,	0.071683546	,	0.941528525	),
  (	75	,	0.130022255	,	0.995373165	),
  (	75	,	0.12611553	,	0.998496885	),
  (	75	,	0.235990041	,	0.995083348	),
  (	75	,	0.179300177	,	0.997833299	),
  (	75	,	0.186096981	,	1.005244587	),
  (	75	,	0.176336456	,	1.038711863	),
  (	75	,	0.183098494	,	1.045709482	),
  (	75	,	0.105991111	,	1.05510458	),
  (	75	,	0.021852141	,	1.141883305	),
  (	75	,	0.007921884	,	1.15726011	),
  (	75	,	0.830528856	,	0.801811116	),
  (	75	,	0.862438738	,	0.81941298	),
  (	75	,	0.736689653	,	0.858419182	),
  (	75	,	0.744177835	,	0.912510534	),
  (	75	,	0.899638184	,	0.844457732	),
  (	75	,	0.91147796	,	0.856435298	),
  (	75	,	0.92113261	,	0.881065444	),
  (	75	,	0.898963523	,	0.897432485	),
  (	75	,	0.917591732	,	0.923184589	),
  (	75	,	0.898534527	,	0.930655297	),
  (	75	,	0.944381498	,	0.92382599	),
  (	75	,	0.833407408	,	0.927523821	),
  (	75	,	0.68418463	,	0.906894057	),
  (	75	,	0.64783503	,	0.926216966	),
  (	75	,	0.61522268	,	0.96705081	),
  (	75	,	0.597598785	,	0.989929637	),
  (	75	,	0.638388229	,	0.998822726	),
  (	75	,	0.600238602	,	1.012634336	),
  (	75	,	0.859555501	,	1.048375363	),
  (	75	,	0.666121861	,	1.077462555	),
  (	75	,	0.808390846	,	1.100069983	),
  (	75	,	1.059102913	,	1.028859441	),
  (	75	,	1.083864646	,	1.062498156	),
  (	75	,	1.09914781	,	1.100264419	),
  (	75	,	1.261431664	,	1.073503864	),
  (	75	,	0.901382002	,	1.102960953	),
  (	75	,	0.959844172	,	1.121988732	),
  (	75	,	1.015333532	,	1.143741089	),
  (	75	,	0.838136652	,	1.135935197	),
  (	75	,	0.87658881	,	1.194797278	),
  (	75	,	1.014870719	,	1.17908554	),
  (	75	,	1.041671704	,	1.187238926	),
  (	75	,	0.911502835	,	1.209217916	),
  (	75	,	1.36332957	,	1.269612592	),
  (	75	,	1.511951255	,	1.302171188	),
  (	75	,	0.473786184	,	1.020281619	),
  (	75	,	0.465927524	,	1.032462959	),
  (	75	,	0.542256867	,	1.051454473	),
  (	75	,	0.537558475	,	1.059482397	),
  (	75	,	0.352863942	,	1.063758102	),
  (	75	,	0.454630049	,	1.079482642	),
  (	75	,	0.678547659	,	1.103803276	),
  (	75	,	0.583813225	,	1.131932649	),
  (	75	,	0.623465671	,	1.200120916	),
  (	75	,	0.274183545	,	1.09273555	),
  (	75	,	0.186899369	,	1.122094448	),
  (	75	,	0.112886678	,	1.141157477	),
  (	75	,	0.136306446	,	1.217973743	),
  (	75	,	0.006962073	,	1.260767274	),
  (	75	,	0.299680153	,	1.233624045	),
  (	75	,	0.217849879	,	1.242251556	),
  (	75	,	0.084213472	,	1.276227686	),
  (	75	,	0.25264478	,	1.317613611	),
  (	75	,	0.061288314	,	1.326921449	),
  (	75	,	0.80888306	,	1.29058672	),
  (	75	,	0.844126305	,	1.296713639	),
  (	75	,	1.132198671	,	1.30264019	),
  (	75	,	0.844360422	,	1.364689661	),
  (	75	,	1.001380232	,	1.401893077	),
  (	75	,	0.503759519	,	1.330370015	),
  (	75	,	0.345452257	,	1.340354503	),
  (	75	,	0.358036958	,	1.379245414	),
  (	75	,	1.063565666	,	1.428978545	),
  (	75	,	1.138389037	,	1.430779916	),
  (	75	,	1.248459248	,	1.466591442	),
  (	75	,	2.312148255	,	0.041225663	),
  (	75	,	2.304721449	,	0.045027034	),
  (	75	,	2.332255299	,	0.095371413	),
  (	75	,	2.3411221	,	0.116225503	),
  (	75	,	2.35324763	,	0.15677019	),
  (	75	,	2.462964702	,	0.110833106	),
  (	75	,	2.462971523	,	0.110826628	),
  (	75	,	2.285027587	,	0.163008514	),
  (	75	,	2.296885248	,	0.184861544	),
  (	75	,	2.216757751	,	0.204315343	),
  (	75	,	2.221594557	,	0.219072636	),
  (	75	,	2.23484969	,	0.223450119	),
  (	75	,	2.392003594	,	0.208525502	),
  (	75	,	2.607352259	,	0.287264103	),
  (	75	,	2.663273243	,	0.365570098	),
  (	75	,	2.485124649	,	0.308082601	),
  (	75	,	2.446212953	,	0.333192923	),
  (	75	,	2.462277729	,	0.41153357	),
  (	75	,	2.564395044	,	0.359620412	),
  (	75	,	2.540994253	,	0.446632007	),
  (	75	,	2.153732603	,	0.181175574	),
  (	75	,	2.145969897	,	0.234659761	),
  (	75	,	2.190180166	,	0.257751543	),
  (	75	,	2.145963531	,	0.28836447	),
  (	75	,	2.304298072	,	0.303592503	),
  (	75	,	2.265004347	,	0.343423625	),
  (	75	,	2.229687814	,	0.331060354	),
  (	75	,	2.250384519	,	0.345070265	),
  (	75	,	2.190675993	,	0.348348552	),
  (	75	,	2.202691721	,	0.351735279	),
  (	75	,	2.25273875	,	0.355024628	),
  (	75	,	2.025601545	,	0.352568448	),
  (	75	,	2.077127817	,	0.413503854	),
  (	75	,	2.184641924	,	0.442199586	),
  (	75	,	2.100959979	,	0.417353907	),
  (	75	,	2.135470463	,	0.433296386	),
  (	75	,	2.377998611	,	0.398510536	),
  (	75	,	2.388659606	,	0.401057173	),
  (	75	,	2.367303757	,	0.451258833	),
  (	75	,	2.315905173	,	0.468214501	),
  (	75	,	2.296149849	,	0.481610061	),
  (	75	,	2.292997488	,	0.496466802	),
  (	75	,	2.362932875	,	0.714545582	),
  (	75	,	2.824734196	,	0.469677359	),
  (	75	,	2.817715243	,	0.568930391	),
  (	75	,	2.649136761	,	0.515085189	),
  (	75	,	2.64337755	,	0.610902509	),
  (	75	,	2.731636281	,	0.685340504	),
  (	75	,	2.998495355	,	0.578122405	),
  (	75	,	2.887481156	,	0.640162946	),
  (	75	,	3.018970397	,	0.723264159	),
  (	75	,	2.856861748	,	0.641557459	),
  (	75	,	2.822652998	,	0.750960407	),
  (	75	,	2.895702937	,	0.773687405	),
  (	75	,	3.118290471	,	0.854033477	),
  (	75	,	2.546927955	,	0.595108462	),
  (	75	,	2.60850666	,	0.613038866	),
  (	75	,	2.517162669	,	0.621318021	),
  (	75	,	2.690584035	,	0.720397435	),
  (	75	,	2.476307072	,	0.74637515	),
  (	75	,	2.407562195	,	0.782325657	),
  (	75	,	2.576510119	,	0.786847203	),
  (	75	,	2.640779234	,	0.882283268	),
  (	75	,	2.588704887	,	0.883503735	),
  (	75	,	2.772988357	,	0.796804739	),
  (	75	,	2.84726831	,	0.798975725	),
  (	75	,	2.755581774	,	0.81810762	),
  (	75	,	2.905450288	,	0.913273801	),
  (	75	,	2.77640477	,	0.909482371	),
  (	75	,	2.840946527	,	0.981530076	),
  (	75	,	2.6943821	,	0.975606984	),
  (	75	,	2.908959818	,	0.978980524	),
  (	75	,	2.930942186	,	1.02799889	),
  (	75	,	1.986143255	,	0.402226135	),
  (	75	,	1.98463203	,	0.435494954	),
  (	75	,	1.907903639	,	0.460132604	),
  (	75	,	2.042539847	,	0.573454812	),
  (	75	,	1.87324492	,	0.526173205	),
  (	75	,	1.854354805	,	0.52992234	),
  (	75	,	1.891565225	,	0.561041224	),
  (	75	,	1.961378338	,	0.613722706	),
  (	75	,	1.998936297	,	0.667740881	),
  (	75	,	2.163435838	,	0.561598503	),
  (	75	,	2.180759124	,	0.614378808	),
  (	75	,	2.080062539	,	0.637774777	),
  (	75	,	2.259924557	,	0.691931585	),
  (	75	,	2.055569027	,	0.649466821	),
  (	75	,	2.062397319	,	0.690070719	),
  (	75	,	2.111658386	,	0.76514235	),
  (	75	,	2.004640414	,	0.709848504	),
  (	75	,	1.966353013	,	0.731120532	),
  (	75	,	2.106210329	,	0.848098778	),
  (	75	,	2.131092029	,	0.855576278	),
  (	75	,	1.767872629	,	0.538012322	),
  (	75	,	1.725113789	,	0.658251823	),
  (	75	,	1.750379023	,	0.684771987	),
  (	75	,	1.781815168	,	0.720860483	),
  (	75	,	1.809810417	,	0.749581887	),
  (	75	,	1.647593131	,	0.69566095	),
  (	75	,	1.714772731	,	0.694373128	),
  (	75	,	1.607081987	,	0.795072644	),
  (	75	,	1.615294495	,	0.816089848	),
  (	75	,	1.691396329	,	0.851321798	),
  (	75	,	1.636150597	,	0.809758738	),
  (	75	,	1.625745151	,	0.827643352	),
  (	75	,	1.612899358	,	0.856307437	),
  (	75	,	1.631816978	,	0.907758834	),
  (	75	,	1.95561332	,	0.802687239	),
  (	75	,	1.819177722	,	0.890210023	),
  (	75	,	1.900349301	,	0.897952449	),
  (	75	,	1.850240117	,	0.895107609	),
  (	75	,	1.843374764	,	0.931722417	),
  (	75	,	2.069280334	,	0.95494608	),
  (	75	,	1.724251278	,	0.922648408	),
  (	75	,	1.661691682	,	0.910158277	),
  (	75	,	1.594454778	,	1.025132018	),
  (	75	,	1.882674704	,	1.051117683	),
  (	75	,	1.667137949	,	1.060769793	),
  (	75	,	1.64633552	,	1.131525014	),
  (	75	,	2.375630474	,	0.758202709	),
  (	75	,	2.294156427	,	0.853096384	),
  (	75	,	2.218061363	,	0.867202036	),
  (	75	,	2.204161992	,	0.94128452	),
  (	75	,	2.28216287	,	1.063426158	),
  (	75	,	2.351869153	,	1.107034804	),
  (	75	,	2.646264113	,	0.973362424	),
  (	75	,	2.616205278	,	0.985666704	),
  (	75	,	2.863190638	,	1.126411492	),
  (	75	,	2.514808803	,	1.095904866	),
  (	75	,	2.875568468	,	1.221538311	),
  (	75	,	2.6958878	,	1.240159072	),
  (	75	,	2.89489769	,	1.316691725	),
  (	75	,	2.066996109	,	1.016019387	),
  (	75	,	2.161328749	,	1.047491177	),
  (	75	,	1.998754412	,	1.073962436	),
  (	75	,	2.238707139	,	1.174475889	),
  (	75	,	1.989993836	,	1.160125971	),
  (	75	,	2.17105235	,	1.224819719	),
  (	75	,	2.079441645	,	1.253970629	),
  (	75	,	1.82391855	,	1.100265852	),
  (	75	,	1.902548316	,	1.130641564	),
  (	75	,	1.645703576	,	1.147037026	),
  (	75	,	1.973074476	,	1.245532651	),
  (	75	,	1.600155952	,	1.267153032	),
  (	75	,	2.282045486	,	1.224597259	),
  (	75	,	2.506256732	,	1.24071691	),
  (	75	,	2.452299141	,	1.307472744	),
  (	75	,	2.87699146	,	1.390611377	),
  (	75	,	2.016913417	,	1.318834386	),
  (	75	,	1.968733396	,	1.343111923	),
  (	75	,	1.946984262	,	1.362137619	),
  (	75	,	1.943590239	,	1.365780346	),
  (	75	,	1.902427256	,	1.438856928	),
  (	75	,	2.336782981	,	1.396790705	),
  (	75	,	2.538365913	,	1.437545782	),
  (	75	,	3.023659602	,	1.47840478	),
  (	75	,	2.771554262	,	1.473051857	),
  (	75	,	2.31636826	,	1.484410145	),
  (	75	,	2.974924056	,	1.529580974	),
  (	75	,	3.944901831	,	0.095912063	),
  (	75	,	3.867095139	,	0.061150377	),
  (	75	,	3.914222824	,	0.094783385	),
  (	75	,	4.022989925	,	0.097679086	),
  (	75	,	4.031718628	,	0.155437758	),
  (	75	,	3.959906023	,	0.161027453	),
  (	75	,	3.963387053	,	0.176518087	),
  (	75	,	3.85189423	,	0.115037763	),
  (	75	,	3.869112916	,	0.127084046	),
  (	75	,	3.852457268	,	0.140956611	),
  (	75	,	3.783101176	,	0.174201628	),
  (	75	,	3.885902216	,	0.22312086	),
  (	75	,	3.867233969	,	0.253250177	),
  (	75	,	3.926819469	,	0.258889155	),
  (	75	,	3.941029578	,	0.313734035	),
  (	75	,	4.192725807	,	0.231630746	),
  (	75	,	4.153916674	,	0.265901467	),
  (	75	,	4.065778169	,	0.283343983	),
  (	75	,	4.057210631	,	0.322884732	),
  (	75	,	3.982665645	,	0.333272308	),
  (	75	,	3.70858527	,	0.198496689	),
  (	75	,	3.78519612	,	0.257511139	),
  (	75	,	3.802905373	,	0.307923574	),
  (	75	,	3.77344018	,	0.372760968	),
  (	75	,	3.656930358	,	0.286286153	),
  (	75	,	3.672243775	,	0.292479204	),
  (	75	,	3.623051742	,	0.370982453	),
  (	75	,	3.660399456	,	0.430954623	),
  (	75	,	3.661211404	,	0.450573514	),
  (	75	,	3.96840824	,	0.430681668	),
  (	75	,	3.876324846	,	0.425295134	),
  (	75	,	3.894206808	,	0.415414961	),
  (	75	,	3.915576871	,	0.441983936	),
  (	75	,	4.024827924	,	0.44722456	),
  (	75	,	4.025321961	,	0.597423073	),
  (	75	,	3.906549301	,	0.572883154	),
  (	75	,	3.979144164	,	0.641493552	),
  (	75	,	3.914398003	,	0.619415874	),
  (	75	,	4.266717912	,	0.412029717	),
  (	75	,	4.407254943	,	0.457436683	),
  (	75	,	4.450069947	,	0.476753287	),
  (	75	,	4.471373376	,	0.49028217	),
  (	75	,	4.255325706	,	0.605855407	),
  (	75	,	4.266693821	,	0.623075624	),
  (	75	,	4.271732194	,	0.659130742	),
  (	75	,	4.359609712	,	0.669245799	),
  (	75	,	4.330825515	,	0.700111306	),
  (	75	,	4.497731895	,	0.561617477	),
  (	75	,	4.489424421	,	0.581207603	),
  (	75	,	4.492452928	,	0.668351589	),
  (	75	,	4.634797182	,	0.664472301	),
  (	75	,	4.681607973	,	0.736746144	),
  (	75	,	4.67815524	,	0.747996377	),
  (	75	,	4.601960629	,	0.757419014	),
  (	75	,	4.450974859	,	0.682449012	),
  (	75	,	4.149321368	,	0.742910076	),
  (	75	,	4.181927862	,	0.754220459	),
  (	75	,	4.133732232	,	0.77839724	),
  (	75	,	4.158864305	,	0.803553371	),
  (	75	,	4.402985228	,	0.841872703	),
  (	75	,	4.62487266	,	0.99256344	),
  (	75	,	4.415095214	,	0.948255728	),
  (	75	,	4.34451394	,	1.008466763	),
  (	75	,	4.481890934	,	1.0169766	),
  (	75	,	3.538724261	,	0.46059616	),
  (	75	,	3.707735416	,	0.545541992	),
  (	75	,	3.679152882	,	0.572707003	),
  (	75	,	3.471483057	,	0.501642793	),
  (	75	,	3.463161272	,	0.52041611	),
  (	75	,	3.567628349	,	0.588840053	),
  (	75	,	3.712969741	,	0.556298512	),
  (	75	,	3.767522985	,	0.649383193	),
  (	75	,	3.843940049	,	0.665875819	),
  (	75	,	3.726189334	,	0.792794339	),
  (	75	,	3.637034523	,	0.9094992	),
  (	75	,	3.305882641	,	0.675160629	),
  (	75	,	3.430554254	,	0.714232846	),
  (	75	,	3.249084921	,	0.721383732	),
  (	75	,	3.176981907	,	0.692118005	),
  (	75	,	3.290184151	,	0.815896854	),
  (	75	,	3.208180933	,	0.822319271	),
  (	75	,	3.239985184	,	0.843917869	),
  (	75	,	3.19726596	,	0.906521497	),
  (	75	,	3.535206059	,	0.798230847	),
  (	75	,	3.428561612	,	0.833880187	),
  (	75	,	3.45929377	,	0.905824413	),
  (	75	,	3.595828014	,	0.971013956	),
  (	75	,	3.515737943	,	0.994324052	),
  (	75	,	3.29942143	,	0.99178839	),
  (	75	,	3.195214155	,	0.972249834	),
  (	75	,	3.215028248	,	0.982294802	),
  (	75	,	3.384118911	,	0.980819391	),
  (	75	,	3.391474962	,	1.006911152	),
  (	75	,	3.354464285	,	1.071267089	),
  (	75	,	3.25108532	,	1.059368022	),
  (	75	,	3.231460626	,	1.111255198	),
  (	75	,	3.98800466	,	0.837215417	),
  (	75	,	3.983737651	,	0.86874256	),
  (	75	,	3.933266434	,	0.858608835	),
  (	75	,	3.93799247	,	0.900927948	),
  (	75	,	4.120501199	,	0.92474475	),
  (	75	,	4.14201547	,	0.981503944	),
  (	75	,	3.964297627	,	0.929609733	),
  (	75	,	4.122014877	,	1.019865083	),
  (	75	,	3.854337743	,	0.938881154	),
  (	75	,	3.833712198	,	0.957368426	),
  (	75	,	3.761174112	,	0.934121703	),
  (	75	,	3.782382974	,	0.978020481	),
  (	75	,	3.945721785	,	1.039082693	),
  (	75	,	4.006686913	,	1.026152008	),
  (	75	,	4.032927881	,	1.056807888	),
  (	75	,	4.011246256	,	1.071192136	),
  (	75	,	3.901281001	,	1.038728695	),
  (	75	,	3.95979049	,	1.129573136	),
  (	75	,	3.940022517	,	1.148032329	),
  (	75	,	4.527513445	,	1.117594726	),
  (	75	,	4.60552177	,	1.209459448	),
  (	75	,	4.587150563	,	1.214746759	),
  (	75	,	4.542974098	,	1.218255776	),
  (	75	,	4.074696755	,	1.115392743	),
  (	75	,	4.080729537	,	1.139315519	),
  (	75	,	4.132033404	,	1.212612333	),
  (	75	,	4.395515161	,	1.206005759	),
  (	75	,	4.678873169	,	1.326464191	),
  (	75	,	4.476713685	,	1.310802893	),
  (	75	,	4.553448774	,	1.327407731	),
  (	75	,	3.838239706	,	1.157966331	),
  (	75	,	3.799974815	,	1.188251008	),
  (	75	,	3.363331998	,	1.099318122	),
  (	75	,	3.144314788	,	1.207513521	),
  (	75	,	3.280862247	,	1.195803424	),
  (	75	,	3.148705006	,	1.236564435	),
  (	75	,	3.482788386	,	1.181376824	),
  (	75	,	3.525851037	,	1.223929252	),
  (	75	,	3.522081891	,	1.227249456	),
  (	75	,	3.555850565	,	1.223807369	),
  (	75	,	3.515686138	,	1.261405625	),
  (	75	,	3.351001255	,	1.238241878	),
  (	75	,	3.313701535	,	1.274112861	),
  (	75	,	3.318559667	,	1.324805761	),
  (	75	,	4.00390728	,	1.20698509	),
  (	75	,	4.169932435	,	1.263480979	),
  (	75	,	4.020771836	,	1.282418175	),
  (	75	,	3.865246008	,	1.256048912	),
  (	75	,	4.614716703	,	1.382536942	),
  (	75	,	3.617688946	,	1.394892102	),
  (	75	,	4.055083863	,	1.40413491	),
  (	75	,	4.495772659	,	1.476524675	),
  (	75	,	4.116596384	,	1.447702598	),
  (	75	,	4.139527505	,	1.459438388	),
  (	75	,	3.312248936	,	1.459865582	),
  (	75	,	3.810437463	,	1.499907415	),
  (	75	,	5.502444726	,	0.018064671	),
  (	75	,	5.515742521	,	0.052218951	),
  (	75	,	5.478926294	,	0.07911418	),
  (	75	,	5.537136921	,	0.132453685	),
  (	75	,	5.507422244	,	0.125308827	),
  (	75	,	5.616364469	,	0.120625224	),
  (	75	,	5.570513832	,	0.131152606	),
  (	75	,	5.607285875	,	0.163783544	),
  (	75	,	5.55400832	,	0.134252023	),
  (	75	,	5.583555846	,	0.166246177	),
  (	75	,	5.532769352	,	0.163407244	),
  (	75	,	5.585352791	,	0.226244841	),
  (	75	,	5.426445446	,	0.114810919	),
  (	75	,	5.397718733	,	0.156693493	),
  (	75	,	5.444352768	,	0.182649495	),
  (	75	,	5.372117716	,	0.196512386	),
  (	75	,	5.571581293	,	0.243529226	),
  (	75	,	5.454842835	,	0.232096428	),
  (	75	,	5.482169866	,	0.258592994	),
  (	75	,	5.491405415	,	0.286873969	),
  (	75	,	5.679719411	,	0.262529109	),
  (	75	,	5.852024722	,	0.313623407	),
  (	75	,	5.749957463	,	0.346936109	),
  (	75	,	5.629182992	,	0.324254914	),
  (	75	,	5.681036168	,	0.330539197	),
  (	75	,	5.687572752	,	0.342694398	),
  (	75	,	5.659460382	,	0.345267187	),
  (	75	,	5.643323927	,	0.376821757	),
  (	75	,	5.550061097	,	0.309298552	),
  (	75	,	5.718321992	,	0.382977175	),
  (	75	,	5.770542741	,	0.411519219	),
  (	75	,	5.65432432	,	0.418265839	),
  (	75	,	5.623044645	,	0.430577336	),
  (	75	,	5.256852186	,	0.277568598	),
  (	75	,	5.310874478	,	0.277029072	),
  (	75	,	5.289689358	,	0.283041455	),
  (	75	,	5.309911001	,	0.292623333	),
  (	75	,	5.284373639	,	0.282582163	),
  (	75	,	5.478379813	,	0.356067698	),
  (	75	,	5.418642662	,	0.361521368	),
  (	75	,	5.252847249	,	0.367398574	),
  (	75	,	5.145387769	,	0.326093511	),
  (	75	,	5.195375216	,	0.385940544	),
  (	75	,	5.208255887	,	0.401233245	),
  (	75	,	5.252735971	,	0.407261194	),
  (	75	,	5.290772632	,	0.447751502	),
  (	75	,	5.288139141	,	0.466764579	),
  (	75	,	5.510010937	,	0.380655121	),
  (	75	,	5.508409736	,	0.485330508	),
  (	75	,	5.528937733	,	0.533999754	),
  (	75	,	5.554335849	,	0.537740715	),
  (	75	,	5.541576361	,	0.562095758	),
  (	75	,	5.588706357	,	0.566404162	),
  (	75	,	5.448152495	,	0.537428837	),
  (	75	,	5.363036906	,	0.494999911	),
  (	75	,	5.389245432	,	0.528011626	),
  (	75	,	5.40239748	,	0.533678519	),
  (	75	,	5.424666982	,	0.590472852	),
  (	75	,	5.400654629	,	0.582354541	),
  (	75	,	5.552260035	,	0.580133949	),
  (	75	,	5.955245596	,	0.425485021	),
  (	75	,	5.918240555	,	0.473363337	),
  (	75	,	5.868865348	,	0.464447659	),
  (	75	,	6.045379728	,	0.505948072	),
  (	75	,	6.058368536	,	0.508954563	),
  (	75	,	6.054848803	,	0.524543273	),
  (	75	,	6.055948589	,	0.54905714	),
  (	75	,	5.925095196	,	0.52226562	),
  (	75	,	5.982535493	,	0.600109298	),
  (	75	,	5.790034834	,	0.46465568	),
  (	75	,	5.767107267	,	0.460383255	),
  (	75	,	5.832903349	,	0.525192166	),
  (	75	,	5.809651768	,	0.560008441	),
  (	75	,	5.804455752	,	0.563535815	),
  (	75	,	5.816546653	,	0.586497224	),
  (	75	,	5.915391683	,	0.572277178	),
  (	75	,	5.917239566	,	0.641624056	),
  (	75	,	5.830678634	,	0.588737947	),
  (	75	,	5.923117964	,	0.688337474	),
  (	75	,	5.91755476	,	0.686568193	),
  (	75	,	5.891416597	,	0.714978364	),
  (	75	,	6.069262734	,	0.543683451	),
  (	75	,	6.103007404	,	0.629894785	),
  (	75	,	6.035848391	,	0.668434347	),
  (	75	,	6.247980038	,	0.711135657	),
  (	75	,	6.137842911	,	0.791312827	),
  (	75	,	6.161028153	,	0.800909909	),
  (	75	,	6.271699717	,	0.842662435	),
  (	75	,	6.251921387	,	0.846167503	),
  (	75	,	6.22619498	,	0.894114283	),
  (	75	,	6.207609295	,	0.897583477	),
  (	75	,	5.730610681	,	0.630524891	),
  (	75	,	5.701877462	,	0.657255215	),
  (	75	,	5.685133395	,	0.661567641	),
  (	75	,	5.810852352	,	0.670480914	),
  (	75	,	5.809155346	,	0.693093156	),
  (	75	,	5.754918412	,	0.727735631	),
  (	75	,	5.729357047	,	0.72611224	),
  (	75	,	5.82857104	,	0.766212625	),
  (	75	,	5.597762096	,	0.67559224	),
  (	75	,	5.560587653	,	0.684927912	),
  (	75	,	5.597500212	,	0.710300182	),
  (	75	,	5.641305168	,	0.705241051	),
  (	75	,	5.683531633	,	0.740728728	),
  (	75	,	5.54422446	,	0.67999963	),
  (	75	,	5.614620081	,	0.764669108	),
  (	75	,	5.625403719	,	0.773846119	),
  (	75	,	5.557135708	,	0.788342758	),
  (	75	,	5.750231544	,	0.817938679	),
  (	75	,	5.809123164	,	0.822886169	),
  (	75	,	5.73645627	,	0.841221976	),
  (	75	,	5.774688506	,	0.866815803	),
  (	75	,	5.677426423	,	0.829819478	),
  (	75	,	5.617745599	,	0.834306528	),
  (	75	,	5.691022249	,	0.859906011	),
  (	75	,	5.950041036	,	0.77720388	),
  (	75	,	5.94950429	,	0.80330809	),
  (	75	,	6.029290283	,	0.887501708	),
  (	75	,	5.877486364	,	0.799175154	),
  (	75	,	5.93540319	,	0.899680211	),
  (	75	,	5.96077005	,	0.909399605	),
  (	75	,	5.981677353	,	0.90081245	),
  (	75	,	5.982391732	,	0.912251284	),
  (	75	,	6.066610876	,	0.855537339	),
  (	75	,	6.065434893	,	0.872502696	),
  (	75	,	6.075236391	,	0.911575136	),
  (	75	,	6.225930628	,	0.957508743	),
  (	75	,	6.263751664	,	1.036996438	),
  (	75	,	5.849650565	,	0.858847031	),
  (	75	,	5.840865021	,	0.919020966	),
  (	75	,	5.976853674	,	0.95725673	),
  (	75	,	5.989080168	,	0.989777007	),
  (	75	,	5.810389268	,	0.915075656	),
  (	75	,	5.849429284	,	0.957160144	),
  (	75	,	5.910296139	,	1.015132246	),
  (	75	,	6.094941531	,	1.006142606	),
  (	75	,	6.021456379	,	1.008321243	),
  (	75	,	6.222687872	,	1.055455697	),
  (	75	,	6.05382494	,	1.029565112	),
  (	75	,	6.224552336	,	1.122268564	),
  (	75	,	5.14627175	,	0.388450266	),
  (	75	,	5.186122608	,	0.435672078	),
  (	75	,	5.053593917	,	0.426151559	),
  (	75	,	5.054778701	,	0.454781706	),
  (	75	,	5.062000009	,	0.465035027	),
  (	75	,	5.241444422	,	0.474549088	),
  (	75	,	5.226856852	,	0.475635658	),
  (	75	,	5.161746908	,	0.478368893	),
  (	75	,	5.183943618	,	0.483503071	),
  (	75	,	5.189386989	,	0.49879886	),
  (	75	,	5.24914827	,	0.494039385	),
  (	75	,	5.285865032	,	0.509057553	),
  (	75	,	5.281965927	,	0.512494812	),
  (	75	,	5.237118265	,	0.52221264	),
  (	75	,	5.223672869	,	0.538544351	),
  (	75	,	5.125482838	,	0.508809513	),
  (	75	,	5.137808447	,	0.516882787	),
  (	75	,	5.146917855	,	0.519212772	),
  (	75	,	5.219173956	,	0.584560463	),
  (	75	,	5.176057069	,	0.560531749	),
  (	75	,	5.214181608	,	0.609132763	),
  (	75	,	5.009222586	,	0.453994201	),
  (	75	,	5.010272773	,	0.472883016	),
  (	75	,	5.068811741	,	0.521948175	),
  (	75	,	5.073575017	,	0.528331984	),
  (	75	,	4.97090378	,	0.552949119	),
  (	75	,	5.277657304	,	0.587855447	),
  (	75	,	5.31412818	,	0.594988264	),
  (	75	,	5.251947918	,	0.668936142	),
  (	75	,	5.322467249	,	0.669205681	),
  (	75	,	5.31950841	,	0.685449502	),
  (	75	,	5.289303871	,	0.670960427	),
  (	75	,	5.398008018	,	0.63850793	),
  (	75	,	5.470145175	,	0.716450098	),
  (	75	,	5.486800704	,	0.740804937	),
  (	75	,	5.444030468	,	0.734235186	),
  (	75	,	5.347149965	,	0.694528391	),
  (	75	,	5.388451765	,	0.728113165	),
  (	75	,	5.229764619	,	0.665078543	),
  (	75	,	5.226654619	,	0.665338563	),
  (	75	,	5.17751613	,	0.689598835	),
  (	75	,	5.22743551	,	0.714310113	),
  (	75	,	5.241310697	,	0.751255815	),
  (	75	,	5.133228927	,	0.731168471	),
  (	75	,	5.169381127	,	0.784159604	),
  (	75	,	5.160907888	,	0.823951593	),
  (	75	,	5.155086045	,	0.826032742	),
  (	75	,	5.303393343	,	0.77036472	),
  (	75	,	5.196374132	,	0.867433628	),
  (	75	,	5.274026716	,	0.882907188	),
  (	75	,	4.889082308	,	0.552281673	),
  (	75	,	4.918036665	,	0.626150101	),
  (	75	,	4.923874493	,	0.636013104	),
  (	75	,	4.948995395	,	0.641119269	),
  (	75	,	4.933468497	,	0.686615273	),
  (	75	,	5.002423796	,	0.652551993	),
  (	75	,	5.02657317	,	0.688023387	),
  (	75	,	4.966920533	,	0.691876946	),
  (	75	,	4.949059799	,	0.719528355	),
  (	75	,	4.971735123	,	0.750722578	),
  (	75	,	4.943620172	,	0.76293985	),
  (	75	,	4.997853079	,	0.736138125	),
  (	75	,	5.006186039	,	0.75599997	),
  (	75	,	4.980135681	,	0.77469143	),
  (	75	,	4.86907983	,	0.751461349	),
  (	75	,	4.769645865	,	0.723866024	),
  (	75	,	4.771241898	,	0.756277069	),
  (	75	,	4.720954591	,	0.835743293	),
  (	75	,	4.915145114	,	0.76027987	),
  (	75	,	4.876362758	,	0.805472865	),
  (	75	,	4.832201662	,	0.869506389	),
  (	75	,	4.786135061	,	0.856863669	),
  (	75	,	4.722336331	,	0.901263953	),
  (	75	,	4.760481095	,	0.903034645	),
  (	75	,	5.041544411	,	0.791255698	),
  (	75	,	5.050747915	,	0.836931859	),
  (	75	,	5.125855156	,	0.811015412	),
  (	75	,	5.091132047	,	0.875213078	),
  (	75	,	5.004110358	,	0.853908225	),
  (	75	,	5.008137382	,	0.86368666	),
  (	75	,	4.983658	,	0.825322481	),
  (	75	,	4.96989282	,	0.860786349	),
  (	75	,	5.045631807	,	0.862622024	),
  (	75	,	5.14083887	,	0.894237099	),
  (	75	,	5.129219765	,	0.934554342	),
  (	75	,	5.149133932	,	0.975768666	),
  (	75	,	5.010564694	,	0.965703332	),
  (	75	,	5.07456911	,	0.981331852	),
  (	75	,	4.78225854	,	0.930207369	),
  (	75	,	4.903322338	,	1.011392725	),
  (	75	,	4.894232816	,	1.074194902	),
  (	75	,	4.801082082	,	1.12055578	),
  (	75	,	5.531789145	,	0.784774864	),
  (	75	,	5.509277656	,	0.778544641	),
  (	75	,	5.591545121	,	0.840685272	),
  (	75	,	5.60294016	,	0.847475151	),
  (	75	,	5.56954736	,	0.851589173	),
  (	75	,	5.462688844	,	0.815675855	),
  (	75	,	5.452197127	,	0.8863316	),
  (	75	,	5.660522167	,	0.891237728	),
  (	75	,	5.637855216	,	0.90570939	),
  (	75	,	5.669230127	,	0.913897019	),
  (	75	,	5.534015446	,	0.928978876	),
  (	75	,	5.57400019	,	0.990699744	),
  (	75	,	5.665504277	,	0.99437864	),
  (	75	,	5.673869198	,	1.004985759	),
  (	75	,	5.635842385	,	1.003609127	),
  (	75	,	5.385545464	,	0.868706047	),
  (	75	,	5.374634823	,	0.864678002	),
  (	75	,	5.368837793	,	0.912699442	),
  (	75	,	5.302423946	,	0.945032066	),
  (	75	,	5.334220537	,	0.958746837	),
  (	75	,	5.316312939	,	0.966875099	),
  (	75	,	5.346279925	,	1.047404954	),
  (	75	,	5.471037488	,	0.983719607	),
  (	75	,	5.627697836	,	1.053805981	),
  (	75	,	5.400935189	,	1.060393771	),
  (	75	,	5.422137947	,	1.103274847	),
  (	75	,	5.807228035	,	1.011272009	),
  (	75	,	5.757743763	,	0.992881093	),
  (	75	,	5.76869993	,	1.013151883	),
  (	75	,	5.811087477	,	1.042325285	),
  (	75	,	5.783488618	,	1.059939446	),
  (	75	,	5.737901052	,	1.082262779	),
  (	75	,	5.831754908	,	1.111993188	),
  (	75	,	5.844779763	,	1.130767855	),
  (	75	,	5.983775121	,	1.076816428	),
  (	75	,	6.015552777	,	1.10090351	),
  (	75	,	6.048218432	,	1.103271256	),
  (	75	,	6.028112974	,	1.104653269	),
  (	75	,	6.092913811	,	1.119039603	),
  (	75	,	6.015076938	,	1.111892232	),
  (	75	,	5.944088311	,	1.132230575	),
  (	75	,	5.907567472	,	1.148981696	),
  (	75	,	5.619276819	,	1.117257265	),
  (	75	,	5.66659135	,	1.123740887	),
  (	75	,	5.746048117	,	1.144822477	),
  (	75	,	5.729443507	,	1.195527659	),
  (	75	,	5.915231787	,	1.225969966	),
  (	75	,	5.866693268	,	1.239998194	),
  (	75	,	6.142352091	,	1.293629314	),
  (	75	,	5.227031485	,	1.062137249	),
  (	75	,	5.213004378	,	1.061571774	),
  (	75	,	5.297836597	,	1.130372114	),
  (	75	,	5.350054931	,	1.20997937	),
  (	75	,	5.234622623	,	1.21141221	),
  (	75	,	4.916251475	,	1.10419669	),
  (	75	,	4.906956851	,	1.131158237	),
  (	75	,	5.03843516	,	1.13922643	),
  (	75	,	4.94795669	,	1.17148578	),
  (	75	,	4.873556798	,	1.183414712	),
  (	75	,	5.064830277	,	1.258415494	),
  (	75	,	5.028190961	,	1.289666808	),
  (	75	,	4.825417984	,	1.251961504	),
  (	75	,	4.945998694	,	1.322719954	),
  (	75	,	5.447588633	,	1.215761352	),
  (	75	,	5.696159605	,	1.259537895	),
  (	75	,	5.416466977	,	1.273642347	),
  (	75	,	5.257318992	,	1.270297982	),
  (	75	,	5.604312052	,	1.325954609	),
  (	75	,	5.842914306	,	1.326681735	),
  (	75	,	6.089784717	,	1.34019139	),
  (	75	,	6.092204291	,	1.363981685	),
  (	75	,	5.53761357	,	1.372930063	),
  (	75	,	5.222791261	,	1.321451633	),
  (	75	,	5.176172198	,	1.386840991	),
  (	75	,	5.05653665	,	1.34028281	),
  (	75	,	4.78033438	,	1.379942984	),
  (	75	,	4.768156527	,	1.422034866	),
  (	75	,	4.811270176	,	1.455059837	),
  (	75	,	5.347515193	,	1.400107961	),
  (	75	,	5.773772049	,	1.537166554	),
  (	75	,	0.057725978	,	-0.660134092	),
  (	75	,	6.209532392	,	-0.642018142	),
  (	75	,	6.209172271	,	-0.50691526	),
  (	75	,	6.141629808	,	-0.476092747	),
  (	75	,	6.258530738	,	-0.471986665	),
  (	75	,	6.266256399	,	-0.38383285	),
  (	75	,	0.264720795	,	-0.350639235	),
  (	75	,	0.039218562	,	-0.370123228	),
  (	75	,	0.196315894	,	-0.211960518	),
  (	75	,	6.121104277	,	-0.409318527	),
  (	75	,	6.139292415	,	-0.396598839	),
  (	75	,	6.094816309	,	-0.370069888	),
  (	75	,	6.112716939	,	-0.323645948	),
  (	75	,	6.177145786	,	-0.267023347	),
  (	75	,	6.028265377	,	-0.391298652	),
  (	75	,	5.97746125	,	-0.354043471	),
  (	75	,	6.141091789	,	-0.225677666	),
  (	75	,	6.027561256	,	-0.249099284	),
  (	75	,	6.241568115	,	-0.261515975	),
  (	75	,	0.118311827	,	-0.172320463	),
  (	75	,	0.061844931	,	-0.125656497	),
  (	75	,	6.208120598	,	-0.197723112	),
  (	75	,	6.257227537	,	-0.162140404	),
  (	75	,	6.264608289	,	-0.158169039	),
  (	75	,	6.225799339	,	-0.155285206	),
  (	75	,	6.116713087	,	-0.17036937	),
  (	75	,	0.000852272	,	-0.006292223	),
  (	75	,	0.384402834	,	-0.301270124	),
  (	75	,	0.473919182	,	-0.25770375	),
  (	75	,	0.326851143	,	-0.276093498	),
  (	75	,	0.539245463	,	-0.165125414	),
  (	75	,	0.455649434	,	-0.197177442	),
  (	75	,	0.283898597	,	-0.240155298	),
  (	75	,	0.265441751	,	-0.163597657	),
  (	75	,	0.225247142	,	-0.153908731	),
  (	75	,	0.268661694	,	-0.118674398	),
  (	75	,	0.370081949	,	-0.121935044	),
  (	75	,	0.430846357	,	-0.100107915	),
  (	75	,	0.414981326	,	-0.04075921	),
  (	75	,	0.550837243	,	-0.076185984	),
  (	75	,	0.682607416	,	-0.011177536	),
  (	75	,	0.748090917	,	-0.012003901	),
  (	75	,	0.61879105	,	0.016930896	),
  (	75	,	0.467161297	,	-0.054378415	),
  (	75	,	0.595479699	,	0.039061713	),
  (	75	,	0.608591638	,	0.049225032	),
  (	75	,	0.565784506	,	0.073876349	),
  (	75	,	0.569601564	,	0.106445847	),
  (	75	,	0.266290515	,	-0.081136571	),
  (	75	,	0.244507969	,	-0.065240427	),
  (	75	,	0.320214103	,	-0.04452342	),
  (	75	,	0.262075902	,	-0.035244044	),
  (	75	,	0.293150131	,	-0.030230586	),
  (	75	,	0.34821881	,	-0.008878506	),
  (	75	,	0.336687333	,	0.035174231	),
  (	75	,	0.282424495	,	0.040377142	),
  (	75	,	0.286664814	,	0.073273305	),
  (	75	,	0.092587625	,	-0.057794662	),
  (	75	,	0.06286417	,	-0.038365586	),
  (	75	,	0.130578581	,	-0.019517936	),
  (	75	,	0.055302962	,	-0.021418331	),
  (	75	,	0.041312378	,	0.02171324	),
  (	75	,	0.171229468	,	0.054733457	),
  (	75	,	0.173270304	,	0.141767015	),
  (	75	,	0.50311562	,	0.112346719	),
  (	75	,	0.362655584	,	0.160349299	),
  (	75	,	0.357979805	,	0.275569058	),
  (	75	,	0.352060957	,	0.273946552	),
  (	75	,	5.892439861	,	-0.285299189	),
  (	75	,	5.921503091	,	-0.204747858	),
  (	75	,	5.957451324	,	-0.168330281	),
  (	75	,	6.001111252	,	-0.099304098	),
  (	75	,	5.777474132	,	-0.227236507	),
  (	75	,	5.832707711	,	-0.203318512	),
  (	75	,	5.813176026	,	-0.193130839	),
  (	75	,	5.764317776	,	-0.227387104	),
  (	75	,	5.850589296	,	-0.152990344	),
  (	75	,	5.921120337	,	-0.132081429	),
  (	75	,	5.862339233	,	-0.040173875	),
  (	75	,	6.066833618	,	-0.136361496	),
  (	75	,	6.137333971	,	-0.115327766	),
  (	75	,	5.980839815	,	-0.010083575	),
  (	75	,	6.031870134	,	0.007676431	),
  (	75	,	6.167055328	,	0.080969466	),
  (	75	,	6.153265766	,	0.087492761	),
  (	75	,	6.144760956	,	0.10601751	),
  (	75	,	6.039233224	,	0.057471923	),
  (	75	,	5.734292776	,	-0.093418338	),
  (	75	,	5.751426598	,	-0.06090898	),
  (	75	,	5.798300208	,	0.073925878	),
  (	75	,	5.561864916	,	-0.014519778	),
  (	75	,	5.570107276	,	-0.010852597	),
  (	75	,	5.577490066	,	0.020844207	),
  (	75	,	5.601542298	,	0.029342031	),
  (	75	,	5.609109747	,	0.035654574	),
  (	75	,	5.642589994	,	0.079642676	),
  (	75	,	5.690347411	,	0.124939096	),
  (	75	,	5.697479225	,	0.139407734	),
  (	75	,	5.893428074	,	0.075598801	),
  (	75	,	5.950916043	,	0.067878627	),
  (	75	,	5.910239217	,	0.073694495	),
  (	75	,	5.827841963	,	0.07454718	),
  (	75	,	5.966768844	,	0.134540162	),
  (	75	,	6.045085558	,	0.182343506	),
  (	75	,	5.868038733	,	0.152481503	),
  (	75	,	5.749219868	,	0.208519248	),
  (	75	,	5.782279877	,	0.219997958	),
  (	75	,	5.778674116	,	0.238201228	),
  (	75	,	6.270283229	,	0.052815825	),
  (	75	,	0.030839904	,	0.119998086	),
  (	75	,	0.1288724	,	0.181293169	),
  (	75	,	0.060061841	,	0.143004289	),
  (	75	,	0.038452602	,	0.140013819	),
  (	75	,	6.145876017	,	0.164534242	),
  (	75	,	0.015306812	,	0.215666875	),
  (	75	,	0.073137393	,	0.242893955	),
  (	75	,	0.020455128	,	0.261187505	),
  (	75	,	0.13826839	,	0.225364025	),
  (	75	,	0.283263224	,	0.283479452	),
  (	75	,	0.263342219	,	0.300651771	),
  (	75	,	0.331133786	,	0.357827066	),
  (	75	,	0.232588836	,	0.344987348	),
  (	75	,	0.254983289	,	0.427988109	),
  (	75	,	0.235659464	,	0.444855247	),
  (	75	,	0.15779519	,	0.419322637	),
  (	75	,	0.219231199	,	0.495129056	),
  (	75	,	6.176838378	,	0.254707444	),
  (	75	,	6.081619646	,	0.268207123	),
  (	75	,	6.206925661	,	0.325788153	),
  (	75	,	6.144490337	,	0.323552286	),
  (	75	,	5.936354403	,	0.349787864	),
  (	75	,	6.005663832	,	0.400655384	),
  (	75	,	6.118403272	,	0.411052138	),
  (	75	,	6.151868657	,	0.432355764	),
  (	75	,	6.225910861	,	0.496014436	),
  (	75	,	6.15420823	,	0.538113207	),
  (	75	,	6.096956861	,	0.521388115	),
  (	75	,	6.221498019	,	0.581027835	),
  (	75	,	6.201561312	,	0.568298246	),
  (	75	,	6.158992892	,	0.588145704	),
  (	75	,	6.172252669	,	0.599629309	),
  (	75	,	6.253443085	,	0.556935278	),
  (	75	,	6.229087863	,	0.60251366	),
  (	75	,	1.60270455	,	-0.64926569	),
  (	75	,	1.520020355	,	-0.609758649	),
  (	75	,	1.567620402	,	-0.562165423	),
  (	75	,	1.667105685	,	-0.611627164	),
  (	75	,	1.674030054	,	-0.581526919	),
  (	75	,	1.701740052	,	-0.544096844	),
  (	75	,	1.496144497	,	-0.592689332	),
  (	75	,	1.62369558	,	-0.454655516	),
  (	75	,	1.600715625	,	-0.403066112	),
  (	75	,	1.564660481	,	-0.376006923	),
  (	75	,	1.762321587	,	-0.481559787	),
  (	75	,	1.752987924	,	-0.482302886	),
  (	75	,	1.840433801	,	-0.409437315	),
  (	75	,	1.80567206	,	-0.422890416	),
  (	75	,	1.822030128	,	-0.404182126	),
  (	75	,	1.83278258	,	-0.401560302	),
  (	75	,	1.670982891	,	-0.428583057	),
  (	75	,	1.792250787	,	-0.363653877	),
  (	75	,	1.751731876	,	-0.385779101	),
  (	75	,	1.747155658	,	-0.373326458	),
  (	75	,	1.834635266	,	-0.395230002	),
  (	75	,	1.83560987	,	-0.360853767	),
  (	75	,	1.869512445	,	-0.324681759	),
  (	75	,	1.87142199	,	-0.317377308	),
  (	75	,	1.673374507	,	-0.33159703	),
  (	75	,	1.663848861	,	-0.293280581	),
  (	75	,	1.832045745	,	-0.262178607	),
  (	75	,	1.78751622	,	-0.262578012	),
  (	75	,	1.805577479	,	-0.230232234	),
  (	75	,	1.372820232	,	-0.470555587	),
  (	75	,	1.430051659	,	-0.447446323	),
  (	75	,	1.308842686	,	-0.437279699	),
  (	75	,	1.412127885	,	-0.389353916	),
  (	75	,	1.35010191	,	-0.403497666	),
  (	75	,	1.370414719	,	-0.3778608	),
  (	75	,	1.500108975	,	-0.342987684	),
  (	75	,	1.501287709	,	-0.319199948	),
  (	75	,	1.43778835	,	-0.367211105	),
  (	75	,	1.513978929	,	-0.290531859	),
  (	75	,	1.300582902	,	-0.384313796	),
  (	75	,	1.295027398	,	-0.281610609	),
  (	75	,	1.259466494	,	-0.282155027	),
  (	75	,	1.342621279	,	-0.301754874	),
  (	75	,	1.427532605	,	-0.288408816	),
  (	75	,	1.363986241	,	-0.260942356	),
  (	75	,	1.302910066	,	-0.258029368	),
  (	75	,	1.311945481	,	-0.235685381	),
  (	75	,	1.372093511	,	-0.181802493	),
  (	75	,	1.610789949	,	-0.245488256	),
  (	75	,	1.625296644	,	-0.237776975	),
  (	75	,	1.611170582	,	-0.230746856	),
  (	75	,	1.544520604	,	-0.246562529	),
  (	75	,	1.564315353	,	-0.189191146	),
  (	75	,	1.699392612	,	-0.200090261	),
  (	75	,	1.681469853	,	-0.158671577	),
  (	75	,	1.71777321	,	-0.125724184	),
  (	75	,	1.621766225	,	-0.178910445	),
  (	75	,	1.618953179	,	-0.127134062	),
  (	75	,	1.696088913	,	-0.12165049	),
  (	75	,	1.459440516	,	-0.183276483	),
  (	75	,	1.536010683	,	-0.171275741	),
  (	75	,	1.499479274	,	-0.155993484	),
  (	75	,	1.409660558	,	-0.141467448	),
  (	75	,	1.489522646	,	-0.121042036	),
  (	75	,	1.479341412	,	-0.090660905	),
  (	75	,	1.569953189	,	-0.115146914	),
  (	75	,	1.635082432	,	-0.077649011	),
  (	75	,	1.549520628	,	-0.033632379	),
  (	75	,	1.973400474	,	-0.323199809	),
  (	75	,	1.984912524	,	-0.247187142	),
  (	75	,	1.907194659	,	-0.259126383	),
  (	75	,	2.101988654	,	-0.149978078	),
  (	75	,	1.975262924	,	-0.168761951	),
  (	75	,	1.932086112	,	-0.16812018	),
  (	75	,	1.805516767	,	-0.196584418	),
  (	75	,	1.818008095	,	-0.142815667	),
  (	75	,	1.873351223	,	-0.144586425	),
  (	75	,	1.976517304	,	-0.119845064	),
  (	75	,	1.979026185	,	-0.108681711	),
  (	75	,	1.932815151	,	-0.067938376	),
  (	75	,	1.885696403	,	-0.095031534	),
  (	75	,	1.996147589	,	-0.035550558	),
  (	75	,	2.239672859	,	-0.092994887	),
  (	75	,	2.235339568	,	-0.089153192	),
  (	75	,	2.112585092	,	-0.084246326	),
  (	75	,	2.122487987	,	-0.041780957	),
  (	75	,	2.24502617	,	-0.012669989	),
  (	75	,	2.305165394	,	0.009685538	),
  (	75	,	2.206825191	,	-0.00719471	),
  (	75	,	2.217625528	,	0.004254107	),
  (	75	,	2.198072446	,	0.001034933	),
  (	75	,	2.219184237	,	0.021771158	),
  (	75	,	2.261681607	,	0.012061387	),
  (	75	,	2.134994726	,	-0.007842179	),
  (	75	,	2.007089822	,	-0.032716798	),
  (	75	,	2.046268873	,	0.011550977	),
  (	75	,	2.036014195	,	0.03242237	),
  (	75	,	2.158320599	,	0.02020057	),
  (	75	,	2.184667944	,	0.04650707	),
  (	75	,	2.162129913	,	0.049429538	),
  (	75	,	2.236717051	,	0.099794406	),
  (	75	,	2.090956969	,	0.091656421	),
  (	75	,	2.117987368	,	0.101708177	),
  (	75	,	1.790490773	,	-0.1080851	),
  (	75	,	1.788636603	,	-0.096223371	),
  (	75	,	1.724760112	,	-0.083599783	),
  (	75	,	1.746474758	,	-0.077864809	),
  (	75	,	1.675052049	,	-0.082535723	),
  (	75	,	1.727285667	,	-0.055664214	),
  (	75	,	1.700017405	,	-0.061991397	),
  (	75	,	1.860786055	,	-0.054380336	),
  (	75	,	1.837100412	,	-0.056767814	),
  (	75	,	1.847529813	,	-0.052803154	),
  (	75	,	1.905065025	,	0.032776556	),
  (	75	,	1.874031072	,	0.033512261	),
  (	75	,	1.872431686	,	0.039320098	),
  (	75	,	1.845151388	,	0.066128952	),
  (	75	,	1.663901358	,	-0.021306281	),
  (	75	,	1.655229072	,	-0.015965903	),
  (	75	,	1.601293624	,	0.001343342	),
  (	75	,	1.619012757	,	0.040674609	),
  (	75	,	1.665846996	,	0.040882309	),
  (	75	,	1.662634471	,	0.044830828	),
  (	75	,	1.747158771	,	0.044643669	),
  (	75	,	1.767013573	,	0.073908093	),
  (	75	,	1.831196483	,	0.058734578	),
  (	75	,	1.825430911	,	0.107637554	),
  (	75	,	1.807421602	,	0.116726754	),
  (	75	,	1.720724406	,	0.057707647	),
  (	75	,	1.699259008	,	0.074232122	),
  (	75	,	1.768151265	,	0.090988703	),
  (	75	,	1.764732416	,	0.090864468	),
  (	75	,	1.781978726	,	0.108437434	),
  (	75	,	1.984817046	,	0.058348133	),
  (	75	,	1.938635475	,	0.055464937	),
  (	75	,	2.021720712	,	0.05598393	),
  (	75	,	2.007637523	,	0.091295689	),
  (	75	,	2.059398975	,	0.093370655	),
  (	75	,	2.116276942	,	0.183258793	),
  (	75	,	1.907668312	,	0.19419148	),
  (	75	,	1.801842039	,	0.151220292	),
  (	75	,	1.8485676	,	0.187976706	),
  (	75	,	1.836707816	,	0.216422572	),
  (	75	,	1.83529362	,	0.22206516	),
  (	75	,	1.96394568	,	0.175360811	),
  (	75	,	1.326410955	,	-0.185618679	),
  (	75	,	1.320478509	,	-0.155233485	),
  (	75	,	1.275607877	,	-0.134554633	),
  (	75	,	1.119628684	,	-0.176026157	),
  (	75	,	1.141385713	,	-0.141522821	),
  (	75	,	1.141040686	,	-0.106002048	),
  (	75	,	1.09407616	,	-0.085100195	),
  (	75	,	1.381437405	,	-0.125715319	),
  (	75	,	1.354130472	,	-0.132555554	),
  (	75	,	1.461641015	,	-0.075996256	),
  (	75	,	1.517537052	,	-0.040094667	),
  (	75	,	1.484998397	,	-0.042509662	),
  (	75	,	1.483280364	,	-0.033627712	),
  (	75	,	1.484036838	,	-0.012301237	),
  (	75	,	1.4737777	,	-0.013583336	),
  (	75	,	1.5202888	,	-0.013257861	),
  (	75	,	1.457514649	,	-0.008313614	),
  (	75	,	1.434231679	,	0.021411554	),
  (	75	,	1.447258126	,	0.049442263	),
  (	75	,	1.453634599	,	0.054647838	),
  (	75	,	1.305058389	,	-0.037290083	),
  (	75	,	1.268956017	,	-0.001663265	),
  (	75	,	1.219424954	,	-0.001479137	),
  (	75	,	1.375310777	,	0.02716042	),
  (	75	,	1.431673533	,	0.061710203	),
  (	75	,	1.386153519	,	0.128322332	),
  (	75	,	1.351612156	,	0.125344205	),
  (	75	,	0.8951884	,	-0.078152058	),
  (	75	,	0.960614066	,	-0.033105253	),
  (	75	,	1.145232619	,	-0.009633846	),
  (	75	,	1.122637638	,	0.044149612	),
  (	75	,	0.871570918	,	0.020927593	),
  (	75	,	1.022999575	,	0.090311103	),
  (	75	,	0.961063938	,	0.1323836	),
  (	75	,	1.113142114	,	0.056661058	),
  (	75	,	1.160462072	,	0.089887554	),
  (	75	,	1.10271709	,	0.087804938	),
  (	75	,	1.269041575	,	0.139522391	),
  (	75	,	1.332276794	,	0.131989866	),
  (	75	,	1.322238845	,	0.163753664	),
  (	75	,	1.285815339	,	0.209886786	),
  (	75	,	1.041186843	,	0.192464601	),
  (	75	,	1.169583668	,	0.175790458	),
  (	75	,	1.208285171	,	0.266354363	),
  (	75	,	1.57032991	,	0.069655779	),
  (	75	,	1.576418489	,	0.158343978	),
  (	75	,	1.638842387	,	0.133556988	),
  (	75	,	1.681034645	,	0.159964017	),
  (	75	,	1.62973407	,	0.168052205	),
  (	75	,	1.623290503	,	0.200932897	),
  (	75	,	1.645443128	,	0.209060254	),
  (	75	,	1.670581549	,	0.215734871	),
  (	75	,	1.541559297	,	0.166832378	),
  (	75	,	1.545310568	,	0.178798087	),
  (	75	,	1.481679285	,	0.171886452	),
  (	75	,	1.462927935	,	0.170651463	),
  (	75	,	1.388350284	,	0.16085379	),
  (	75	,	1.444374144	,	0.211128285	),
  (	75	,	1.553484856	,	0.201093117	),
  (	75	,	1.634986618	,	0.254576905	),
  (	75	,	1.479712783	,	0.254063177	),
  (	75	,	1.60202101	,	0.288947269	),
  (	75	,	1.587474692	,	0.298909053	),
  (	75	,	1.548869304	,	0.30371984	),
  (	75	,	1.774942996	,	0.187353419	),
  (	75	,	1.713308587	,	0.262163815	),
  (	75	,	1.727276676	,	0.287043416	),
  (	75	,	1.72725789	,	0.300195221	),
  (	75	,	1.851537522	,	0.265963178	),
  (	75	,	1.920052587	,	0.340698644	),
  (	75	,	1.821926793	,	0.344321177	),
  (	75	,	1.888318479	,	0.372667692	),
  (	75	,	1.727422996	,	0.308791005	),
  (	75	,	1.735571047	,	0.321167296	),
  (	75	,	1.745479736	,	0.343083795	),
  (	75	,	1.621630583	,	0.303294146	),
  (	75	,	1.648672597	,	0.339589975	),
  (	75	,	1.575925179	,	0.338949191	),
  (	75	,	1.612944085	,	0.357576214	),
  (	75	,	1.620108082	,	0.376358974	),
  (	75	,	1.665020293	,	0.347181328	),
  (	75	,	1.802499899	,	0.441764128	),
  (	75	,	1.71941264	,	0.386021855	),
  (	75	,	1.745720448	,	0.41318296	),
  (	75	,	1.398042835	,	0.190069987	),
  (	75	,	1.347260905	,	0.205113675	),
  (	75	,	1.425955912	,	0.237053052	),
  (	75	,	1.422032889	,	0.269720115	),
  (	75	,	1.422638414	,	0.273523319	),
  (	75	,	1.428991667	,	0.279950261	),
  (	75	,	1.338307948	,	0.245810781	),
  (	75	,	1.344325008	,	0.276724639	),
  (	75	,	1.375104024	,	0.262890668	),
  (	75	,	1.417392152	,	0.300143265	),
  (	75	,	1.462053255	,	0.27295136	),
  (	75	,	1.457342807	,	0.271998232	),
  (	75	,	1.484818487	,	0.286088693	),
  (	75	,	1.508926645	,	0.327989249	),
  (	75	,	1.516866349	,	0.365481323	),
  (	75	,	1.411583002	,	0.324642134	),
  (	75	,	1.435390967	,	0.356773589	),
  (	75	,	1.467989844	,	0.383841988	),
  (	75	,	1.433039291	,	0.396927877	),
  (	75	,	1.307286738	,	0.452655389	),
  (	75	,	1.548545279	,	0.393048192	),
  (	75	,	1.57571605	,	0.406746229	),
  (	75	,	1.622883586	,	0.405039304	),
  (	75	,	1.523303617	,	0.447686843	),
  (	75	,	1.558110205	,	0.476764166	),
  (	75	,	1.583841909	,	0.50050824	),
  (	75	,	1.657988543	,	0.496138054	),
  (	75	,	1.700204559	,	0.502317107	),
  (	75	,	1.642223261	,	0.503560313	),
  (	75	,	1.597452761	,	0.505007023	),
  (	75	,	1.502521764	,	0.48400525	),
  (	75	,	1.49436631	,	0.520984741	),
  (	75	,	1.489342374	,	0.544299223	),
  (	75	,	1.504813424	,	0.588569198	),
  (	75	,	1.60182941	,	0.614594788	),
  (	75	,	1.474615901	,	0.621407622	),
  (	75	,	1.509921033	,	0.650678067	),
  (	75	,	1.579910334	,	0.67579442	),
  (	75	,	1.557376708	,	0.66823405	),
  (	75	,	1.564478842	,	0.67882242	),
  (	75	,	1.524387936	,	0.676105531	),
  (	75	,	1.567678956	,	0.698712343	),
  (	75	,	3.143074789	,	-0.638139802	),
  (	75	,	3.139537483	,	-0.616249798	),
  (	75	,	3.100992158	,	-0.578422333	),
  (	75	,	3.226830429	,	-0.568782153	),
  (	75	,	3.276521722	,	-0.535425061	),
  (	75	,	3.261316591	,	-0.501193052	),
  (	75	,	3.215164563	,	-0.464235467	),
  (	75	,	3.032615526	,	-0.524155714	),
  (	75	,	2.98052144	,	-0.504347876	),
  (	75	,	3.187306643	,	-0.435614801	),
  (	75	,	3.168966424	,	-0.397868049	),
  (	75	,	3.319864266	,	-0.483687364	),
  (	75	,	3.382363007	,	-0.435559237	),
  (	75	,	3.34693202	,	-0.386228698	),
  (	75	,	3.445777122	,	-0.387374994	),
  (	75	,	3.427814961	,	-0.385220559	),
  (	75	,	3.416294746	,	-0.294636123	),
  (	75	,	3.22111023	,	-0.363729295	),
  (	75	,	3.280715301	,	-0.366192977	),
  (	75	,	3.195294937	,	-0.346850062	),
  (	75	,	3.343960462	,	-0.317999338	),
  (	75	,	3.336693873	,	-0.310294183	),
  (	75	,	2.964612891	,	-0.496997494	),
  (	75	,	2.953389447	,	-0.475420857	),
  (	75	,	3.003661188	,	-0.415857614	),
  (	75	,	2.987962518	,	-0.398506595	),
  (	75	,	2.923789656	,	-0.446938679	),
  (	75	,	2.957392765	,	-0.386521454	),
  (	75	,	3.02362284	,	-0.409171633	),
  (	75	,	3.107564649	,	-0.335211304	),
  (	75	,	2.979926295	,	-0.359982188	),
  (	75	,	2.997778182	,	-0.335118422	),
  (	75	,	2.890457859	,	-0.373694635	),
  (	75	,	2.972062657	,	-0.245758815	),
  (	75	,	3.100866265	,	-0.224572233	),
  (	75	,	3.127461192	,	-0.187191872	),
  (	75	,	3.032130225	,	-0.210961768	),
  (	75	,	3.058028034	,	-0.173093385	),
  (	75	,	3.582266691	,	-0.223106967	),
  (	75	,	3.682480481	,	-0.170080634	),
  (	75	,	3.643240975	,	-0.14066123	),
  (	75	,	3.472768936	,	-0.215552891	),
  (	75	,	3.405535159	,	-0.158836981	),
  (	75	,	3.375538637	,	-0.158212693	),
  (	75	,	3.553023702	,	-0.150425457	),
  (	75	,	3.548175295	,	-0.147358465	),
  (	75	,	3.599516689	,	-0.104757845	),
  (	75	,	3.547174096	,	-0.042312581	),
  (	75	,	3.541494954	,	-0.040424712	),
  (	75	,	3.74672321	,	-0.122414324	),
  (	75	,	3.712967035	,	-0.104265349	),
  (	75	,	3.798307538	,	-0.07095174	),
  (	75	,	3.662848388	,	-0.094688627	),
  (	75	,	3.772514005	,	-0.040890186	),
  (	75	,	3.809015596	,	0.063869453	),
  (	75	,	3.708369545	,	-0.011369966	),
  (	75	,	3.69937438	,	-0.000977869	),
  (	75	,	3.666657284	,	0.046677185	),
  (	75	,	3.80576004	,	0.072296838	),
  (	75	,	3.27261903	,	-0.105136477	),
  (	75	,	3.464793046	,	-0.048991392	),
  (	75	,	3.423647976	,	-0.012713806	),
  (	75	,	3.513657254	,	0.014823338	),
  (	75	,	3.476972273	,	0.021645657	),
  (	75	,	3.471174487	,	0.053210154	),
  (	75	,	3.443198357	,	0.054882946	),
  (	75	,	3.281539461	,	-0.030928826	),
  (	75	,	3.530917213	,	0.067568362	),
  (	75	,	3.458660006	,	0.071004072	),
  (	75	,	3.553269524	,	0.246282474	),
  (	75	,	3.589036709	,	0.264363058	),
  (	75	,	3.48031792	,	0.240226416	),
  (	75	,	3.497978389	,	0.280669138	),
  (	75	,	3.533083573	,	0.295015656	),
  (	75	,	3.534379254	,	0.332710184	),
  (	75	,	2.688987577	,	-0.281731586	),
  (	75	,	2.757730308	,	-0.199401156	),
  (	75	,	2.853369872	,	-0.217025455	),
  (	75	,	2.800698408	,	-0.140608428	),
  (	75	,	2.684372197	,	-0.205772943	),
  (	75	,	2.742633789	,	-0.110013196	),
  (	75	,	2.723178136	,	-0.085999104	),
  (	75	,	2.678085973	,	-0.091102366	),
  (	75	,	2.721900448	,	-0.039723615	),
  (	75	,	2.960030547	,	-0.088459404	),
  (	75	,	3.066673399	,	-0.061878612	),
  (	75	,	3.076239259	,	-0.009050218	),
  (	75	,	3.02521625	,	0.058685959	),
  (	75	,	2.804780686	,	-0.03814078	),
  (	75	,	3.001677311	,	0.049421613	),
  (	75	,	2.554383202	,	-0.148051031	),
  (	75	,	2.598867775	,	-0.086855178	),
  (	75	,	2.614982986	,	-0.053668891	),
  (	75	,	2.73535906	,	-0.002596322	),
  (	75	,	2.575306484	,	0.001826602	),
  (	75	,	2.675673504	,	0.053625757	),
  (	75	,	2.58082063	,	0.058789645	),
  (	75	,	2.529242407	,	0.055768218	),
  (	75	,	2.63390721	,	0.069327797	),
  (	75	,	2.63890173	,	0.087336793	),
  (	75	,	2.612815348	,	0.083920761	),
  (	75	,	2.61253703	,	0.106718651	),
  (	75	,	2.561428284	,	0.123758122	),
  (	75	,	2.523637312	,	0.134545491	),
  (	75	,	2.74443637	,	0.046185623	),
  (	75	,	2.666428359	,	0.091671764	),
  (	75	,	2.707609381	,	0.112217151	),
  (	75	,	2.750882843	,	0.123206655	),
  (	75	,	2.895884346	,	0.132327289	),
  (	75	,	2.832028376	,	0.177287292	),
  (	75	,	2.612131316	,	0.19129925	),
  (	75	,	2.684142758	,	0.203753472	),
  (	75	,	2.733378974	,	0.183304229	),
  (	75	,	2.775561879	,	0.202713046	),
  (	75	,	2.717138901	,	0.267799483	),
  (	75	,	2.735289209	,	0.300528129	),
  (	75	,	3.222136007	,	0.140760915	),
  (	75	,	3.1729102	,	0.16864851	),
  (	75	,	3.181803985	,	0.299950354	),
  (	75	,	3.309948693	,	0.240946216	),
  (	75	,	3.271528144	,	0.255695037	),
  (	75	,	3.501272061	,	0.361230179	),
  (	75	,	3.199592034	,	0.384435954	),
  (	75	,	2.926098767	,	0.19724984	),
  (	75	,	2.912923569	,	0.24189464	),
  (	75	,	3.035477271	,	0.311977894	),
  (	75	,	3.086934845	,	0.349658499	),
  (	75	,	2.862048948	,	0.316831847	),
  (	75	,	2.879974851	,	0.384424964	),
  (	75	,	2.927178239	,	0.37237542	),
  (	75	,	2.99385772	,	0.396336252	),
  (	75	,	3.204677166	,	0.412949686	),
  (	75	,	3.07083425	,	0.419058422	),
  (	75	,	3.125245081	,	0.503676894	),
  (	75	,	3.235165353	,	0.436279289	),
  (	75	,	3.233438522	,	0.436901842	),
  (	75	,	3.220941398	,	0.476486488	),
  (	75	,	3.276910386	,	0.548452767	),
  (	75	,	3.199535335	,	0.528541152	),
  (	75	,	2.967874908	,	0.525700774	),
  (	75	,	2.979501984	,	0.555503023	),
  (	75	,	3.023931644	,	0.594308229	),
  (	75	,	3.142310245	,	0.641056622	),
  (	75	,	3.182879074	,	0.674245353	),
  (	75	,	4.712248781	,	-0.681779037	),
  (	75	,	4.700558022	,	-0.67688616	),
  (	75	,	4.701836592	,	-0.664808729	),
  (	75	,	4.78146652	,	-0.621988959	),
  (	75	,	4.721495404	,	-0.622549204	),
  (	75	,	4.773887748	,	-0.603836456	),
  (	75	,	4.676171291	,	-0.636482865	),
  (	75	,	4.687155337	,	-0.607784781	),
  (	75	,	4.663490969	,	-0.611862424	),
  (	75	,	4.653360643	,	-0.608868385	),
  (	75	,	4.691677772	,	-0.597524108	),
  (	75	,	4.78773425	,	-0.54624117	),
  (	75	,	4.778821278	,	-0.499401575	),
  (	75	,	4.833377987	,	-0.464869287	),
  (	75	,	4.789131446	,	-0.486346958	),
  (	75	,	4.801196541	,	-0.478357736	),
  (	75	,	4.790319573	,	-0.477430811	),
  (	75	,	4.631719653	,	-0.594696097	),
  (	75	,	4.564461969	,	-0.48170941	),
  (	75	,	4.739574598	,	-0.479842708	),
  (	75	,	4.752849988	,	-0.484063988	),
  (	75	,	4.696710507	,	-0.467293986	),
  (	75	,	4.731721186	,	-0.425610099	),
  (	75	,	4.769293795	,	-0.40347307	),
  (	75	,	4.675965428	,	-0.413250289	),
  (	75	,	4.722828487	,	-0.401964095	),
  (	75	,	4.723420673	,	-0.399777365	),
  (	75	,	4.709938998	,	-0.39212167	),
  (	75	,	4.719596768	,	-0.386270934	),
  (	75	,	4.936837706	,	-0.474109441	),
  (	75	,	4.956770382	,	-0.437124294	),
  (	75	,	4.931428814	,	-0.398776746	),
  (	75	,	4.976812478	,	-0.343102791	),
  (	75	,	4.935381803	,	-0.354304352	),
  (	75	,	4.872335734	,	-0.354545767	),
  (	75	,	4.749365931	,	-0.370936864	),
  (	75	,	4.720554275	,	-0.333464694	),
  (	75	,	4.77788699	,	-0.323744314	),
  (	75	,	4.74922356	,	-0.323797171	),
  (	75	,	4.82146177	,	-0.323562527	),
  (	75	,	4.782049495	,	-0.307317252	),
  (	75	,	4.779307222	,	-0.293766133	),
  (	75	,	4.921713134	,	-0.318151177	),
  (	75	,	4.903767979	,	-0.295691009	),
  (	75	,	4.877860198	,	-0.235148509	),
  (	75	,	4.886657075	,	-0.193866647	),
  (	75	,	4.567728326	,	-0.459576681	),
  (	75	,	4.585092204	,	-0.416115693	),
  (	75	,	4.470057337	,	-0.423073443	),
  (	75	,	4.4658645	,	-0.423093845	),
  (	75	,	4.599113248	,	-0.401982914	),
  (	75	,	4.68527206	,	-0.347098274	),
  (	75	,	4.65763743	,	-0.316029018	),
  (	75	,	4.567136412	,	-0.37471441	),
  (	75	,	4.643795988	,	-0.304330402	),
  (	75	,	4.537359771	,	-0.309915066	),
  (	75	,	4.530437345	,	-0.275748309	),
  (	75	,	4.518558386	,	-0.179722721	),
  (	75	,	4.766755047	,	-0.285896927	),
  (	75	,	4.714340846	,	-0.226686757	),
  (	75	,	4.799084022	,	-0.197008166	),
  (	75	,	4.653614893	,	-0.139394086	),
  (	75	,	4.780335447	,	-0.095562108	),
  (	75	,	4.763366185	,	-0.047586637	),
  (	75	,	5.145263236	,	-0.295122089	),
  (	75	,	5.068837045	,	-0.300994372	),
  (	75	,	5.148286092	,	-0.259170205	),
  (	75	,	5.081932815	,	-0.220182745	),
  (	75	,	5.199285413	,	-0.220276596	),
  (	75	,	5.06521502	,	-0.197237978	),
  (	75	,	5.061651417	,	-0.164264933	),
  (	75	,	5.08060065	,	-0.162989948	),
  (	75	,	5.045214746	,	-0.151670593	),
  (	75	,	4.995281595	,	-0.150987662	),
  (	75	,	4.970751928	,	-0.119418234	),
  (	75	,	5.108137845	,	-0.142883865	),
  (	75	,	5.079153051	,	-0.121774865	),
  (	75	,	5.314285424	,	-0.140783035	),
  (	75	,	5.298849687	,	-0.105546812	),
  (	75	,	5.307690474	,	-0.026179435	),
  (	75	,	5.447446827	,	0.030062706	),
  (	75	,	5.443576003	,	0.031970492	),
  (	75	,	5.32234123	,	-0.01583539	),
  (	75	,	5.391804606	,	0.057638068	),
  (	75	,	5.228917428	,	-0.038949084	),
  (	75	,	5.243199638	,	-0.003473533	),
  (	75	,	5.330263416	,	0.029162371	),
  (	75	,	5.325120365	,	0.132901662	),
  (	75	,	5.288492465	,	0.134118824	),
  (	75	,	4.935913414	,	-0.139809386	),
  (	75	,	4.944470208	,	-0.082590353	),
  (	75	,	4.971556193	,	0.024542821	),
  (	75	,	4.951959676	,	0.019571052	),
  (	75	,	4.950233774	,	0.033109831	),
  (	75	,	5.006051522	,	0.060091457	),
  (	75	,	4.81709525	,	-0.043137588	),
  (	75	,	4.863312847	,	0.054729682	),
  (	75	,	4.863018539	,	0.11278923	),
  (	75	,	5.095767901	,	0.037947906	),
  (	75	,	5.276907334	,	0.188250843	),
  (	75	,	5.212374135	,	0.17047329	),
  (	75	,	5.14866769	,	0.132072615	),
  (	75	,	5.230987901	,	0.201840594	),
  (	75	,	5.006230337	,	0.091085111	),
  (	75	,	5.021955345	,	0.141745254	),
  (	75	,	5.009938455	,	0.167226711	),
  (	75	,	5.014798253	,	0.20292326	),
  (	75	,	5.032203444	,	0.260800537	),
  (	75	,	5.141993216	,	0.301194702	),
  (	75	,	5.125267002	,	0.316397724	),
  (	75	,	4.267307559	,	-0.234660102	),
  (	75	,	4.266595305	,	-0.233398341	),
  (	75	,	4.25665946	,	-0.221308597	),
  (	75	,	4.207871712	,	-0.198473935	),
  (	75	,	4.325374562	,	-0.138248903	),
  (	75	,	4.327538805	,	-0.122580969	),
  (	75	,	4.28715334	,	-0.074184778	),
  (	75	,	4.535041654	,	-0.047983129	),
  (	75	,	4.647929114	,	-0.048210132	),
  (	75	,	4.599549928	,	-0.05333478	),
  (	75	,	4.382065726	,	-0.009717196	),
  (	75	,	4.404461478	,	0.015537379	),
  (	75	,	4.38385739	,	0.040711719	),
  (	75	,	4.12534794	,	-0.107255499	),
  (	75	,	4.109188485	,	-0.112476017	),
  (	75	,	4.159885062	,	-0.052871616	),
  (	75	,	4.209237122	,	-0.020251809	),
  (	75	,	4.188944671	,	0.010886034	),
  (	75	,	4.184847595	,	0.010396411	),
  (	75	,	3.982077218	,	-0.00666091	),
  (	75	,	4.004103495	,	-0.017187892	),
  (	75	,	4.111193005	,	0.136551475	),
  (	75	,	4.285879367	,	0.050184516	),
  (	75	,	4.376619754	,	0.060290352	),
  (	75	,	4.267418313	,	0.106086186	),
  (	75	,	4.451791968	,	0.188881457	),
  (	75	,	4.378840732	,	0.216746915	),
  (	75	,	4.216646626	,	0.094471564	),
  (	75	,	4.249186174	,	0.122067053	),
  (	75	,	4.258587425	,	0.199413764	),
  (	75	,	4.172217926	,	0.17972145	),
  (	75	,	4.222903268	,	0.215956948	),
  (	75	,	4.304051509	,	0.263446637	),
  (	75	,	4.313721599	,	0.331938369	),
  (	75	,	4.75111175	,	0.039147946	),
  (	75	,	4.792975391	,	0.089625318	),
  (	75	,	4.691798366	,	0.099554829	),
  (	75	,	4.663183259	,	0.099505008	),
  (	75	,	4.651089172	,	0.099385618	),
  (	75	,	4.650950044	,	0.103111854	),
  (	75	,	4.642839366	,	0.105799005	),
  (	75	,	4.815116691	,	0.093056064	),
  (	75	,	4.745191727	,	0.165740339	),
  (	75	,	4.783816924	,	0.188752704	),
  (	75	,	4.60247394	,	0.105127577	),
  (	75	,	4.555181675	,	0.150173576	),
  (	75	,	4.611301683	,	0.184559311	),
  (	75	,	4.607974946	,	0.197442245	),
  (	75	,	4.744438083	,	0.265895	),
  (	75	,	4.677662797	,	0.290293489	),
  (	75	,	4.921355952	,	0.194839203	),
  (	75	,	4.974097962	,	0.224972562	),
  (	75	,	4.872131511	,	0.226678219	),
  (	75	,	4.88615175	,	0.263361308	),
  (	75	,	4.910075709	,	0.309401259	),
  (	75	,	5.041661129	,	0.338941739	),
  (	75	,	4.99570401	,	0.33630471	),
  (	75	,	4.972474807	,	0.340102478	),
  (	75	,	5.004221514	,	0.386973359	),
  (	75	,	5.005316752	,	0.394175464	),
  (	75	,	4.811989176	,	0.261828426	),
  (	75	,	4.825908749	,	0.275029877	),
  (	75	,	4.790555576	,	0.313837369	),
  (	75	,	4.74507911	,	0.343244064	),
  (	75	,	4.804467154	,	0.365383592	),
  (	75	,	4.967491977	,	0.415416392	),
  (	75	,	4.513134934	,	0.253991119	),
  (	75	,	4.502902381	,	0.252858718	),
  (	75	,	4.447086293	,	0.245723171	),
  (	75	,	4.516613124	,	0.310694887	),
  (	75	,	4.600590568	,	0.335836858	),
  (	75	,	4.364217872	,	0.309049475	),
  (	75	,	4.604089062	,	0.424973888	),
  (	75	,	4.507916466	,	0.436075391	),
  (	75	,	4.528803349	,	0.50450834	),
  (	75	,	4.712835722	,	0.362001609	),
  (	75	,	4.734339988	,	0.399930145	),
  (	75	,	4.771071127	,	0.458039392	),
  (	75	,	4.632629448	,	0.428872369	),
  (	75	,	4.861290656	,	0.493839757	),
  (	75	,	4.746712963	,	0.520422181	),
  (	75	,	4.805445113	,	0.574906476	),
  (	75	,	4.794674579	,	0.5767499	),
  (	75	,	4.685458624	,	0.530062947	),
  (	75	,	4.684162048	,	0.622598397	),
  (	75	,	4.730342804	,	0.689067141	),
  (	75	,	1.261215142	,	-1.540620944	),
  (	75	,	0.6793832	,	-1.483827905	),
  (	75	,	1.337852381	,	-1.353858436	),
  (	75	,	1.110539999	,	-1.323099387	),
  (	75	,	0.273231347	,	-1.353526578	),
  (	75	,	0.459895326	,	-1.35013249	),
  (	75	,	0.672457637	,	-1.291949815	),
  (	75	,	0.850661756	,	-1.217938331	),
  (	75	,	1.406829135	,	-1.248015792	),
  (	75	,	1.268570061	,	-1.218786775	),
  (	75	,	1.488979941	,	-1.200265801	),
  (	75	,	1.425460442	,	-1.122668292	),
  (	75	,	1.24785588	,	-1.153288304	),
  (	75	,	1.073603897	,	-1.219480773	),
  (	75	,	0.993443247	,	-1.219788903	),
  (	75	,	0.868335168	,	-1.149972481	),
  (	75	,	0.93191324	,	-1.093273441	),
  (	75	,	0.973685111	,	-1.073526579	),
  (	75	,	0.928165071	,	-1.071535547	),
  (	75	,	0.350096518	,	-1.269714337	),
  (	75	,	0.382442544	,	-1.251466015	),
  (	75	,	0.592865532	,	-1.211811388	),
  (	75	,	0.659686176	,	-1.186263923	),
  (	75	,	0.339705794	,	-1.1712964	),
  (	75	,	0.166450658	,	-1.152657997	),
  (	75	,	0.093898072	,	-1.147582275	),
  (	75	,	0.297025521	,	-1.079865016	),
  (	75	,	0.398260249	,	-1.136519247	),
  (	75	,	0.572269298	,	-1.032394554	),
  (	75	,	0.359339866	,	-1.070398018	),
  (	75	,	0.399773562	,	-1.069001585	),
  (	75	,	0.427135069	,	-1.056124332	),
  (	75	,	0.349998354	,	-1.048493854	),
  (	75	,	0.784133801	,	-1.110519282	),
  (	75	,	0.772398677	,	-1.100166392	),
  (	75	,	0.922437649	,	-1.044701425	),
  (	75	,	0.800555747	,	-1.028577234	),
  (	75	,	0.746699736	,	-0.998198087	),
  (	75	,	0.978590693	,	-0.950803077	),
  (	75	,	0.837883138	,	-0.984387065	),
  (	75	,	0.620447026	,	-1.042997186	),
  (	75	,	0.656156944	,	-0.89671026	),
  (	75	,	0.803448878	,	-0.835255965	),
  (	75	,	0.780975848	,	-0.763572619	),
  (	75	,	0.785976425	,	-0.730838704	),
  (	75	,	1.452471829	,	-1.107514996	),
  (	75	,	1.479673968	,	-1.028996611	),
  (	75	,	1.39072952	,	-1.0992961	),
  (	75	,	1.300126682	,	-1.011722781	),
  (	75	,	1.422758777	,	-1.022089668	),
  (	75	,	1.502443591	,	-0.993369886	),
  (	75	,	1.528029841	,	-0.961339154	),
  (	75	,	1.47331737	,	-0.934365877	),
  (	75	,	1.342020065	,	-0.959732666	),
  (	75	,	1.344419372	,	-0.860394826	),
  (	75	,	1.349208571	,	-0.854853243	),
  (	75	,	1.152421823	,	-0.999255198	),
  (	75	,	1.276144445	,	-0.97209643	),
  (	75	,	1.321794151	,	-0.867480278	),
  (	75	,	1.260823676	,	-0.822648432	),
  (	75	,	1.229854036	,	-0.834726695	),
  (	75	,	1.225261914	,	-0.799238882	),
  (	75	,	1.15966309	,	-0.782855036	),
  (	75	,	1.498558688	,	-0.869912242	),
  (	75	,	1.468709625	,	-0.842724902	),
  (	75	,	1.450118942	,	-0.828594069	),
  (	75	,	1.513948114	,	-0.796681849	),
  (	75	,	1.526516976	,	-0.756853488	),
  (	75	,	1.505811373	,	-0.701603855	),
  (	75	,	1.379543247	,	-0.71993359	),
  (	75	,	1.399036454	,	-0.693853072	),
  (	75	,	1.419468863	,	-0.608201192	),
  (	75	,	1.414316318	,	-0.600656112	),
  (	75	,	1.033477549	,	-0.84611274	),
  (	75	,	1.052842506	,	-0.805247163	),
  (	75	,	1.095413997	,	-0.819295041	),
  (	75	,	0.964976349	,	-0.71154385	),
  (	75	,	0.922447548	,	-0.585477118	),
  (	75	,	1.125062707	,	-0.596667012	),
  (	75	,	1.267682496	,	-0.472997482	),
  (	75	,	1.091079436	,	-0.602094643	),
  (	75	,	1.059045435	,	-0.479669322	),
  (	75	,	1.206871353	,	-0.472076348	),
  (	75	,	1.217078961	,	-0.44865841	),
  (	75	,	1.199519146	,	-0.437017638	),
  (	75	,	1.094050362	,	-0.438016413	),
  (	75	,	0.006502225	,	-1.098214471	),
  (	75	,	0.202578656	,	-1.011028446	),
  (	75	,	0.217889062	,	-1.001578812	),
  (	75	,	0.340290741	,	-0.909417816	),
  (	75	,	0.023399589	,	-0.994065022	),
  (	75	,	0.178306549	,	-0.928693957	),
  (	75	,	0.398258099	,	-0.870998278	),
  (	75	,	0.355797285	,	-0.787788402	),
  (	75	,	0.533440919	,	-0.862355372	),
  (	75	,	0.612019442	,	-0.87793744	),
  (	75	,	0.565333321	,	-0.793550426	),
  (	75	,	0.691612025	,	-0.780731169	),
  (	75	,	0.632192968	,	-0.735816525	),
  (	75	,	0.526005428	,	-0.710946564	),
  (	75	,	0.080039712	,	-0.871022138	),
  (	75	,	0.167791257	,	-0.801121624	),
  (	75	,	0.365114778	,	-0.714828534	),
  (	75	,	0.214083157	,	-0.742843956	),
  (	75	,	0.186380656	,	-0.671312218	),
  (	75	,	0.425627553	,	-0.66557426	),
  (	75	,	0.434986782	,	-0.654036143	),
  (	75	,	0.350211407	,	-0.632559616	),
  (	75	,	0.511111287	,	-0.542530313	),
  (	75	,	0.433178506	,	-0.506535721	),
  (	75	,	0.479789907	,	-0.506861161	),
  (	75	,	0.400956782	,	-0.483511821	),
  (	75	,	0.435878513	,	-0.399916991	),
  (	75	,	0.384161247	,	-0.356640064	),
  (	75	,	0.951925694	,	-0.546277842	),
  (	75	,	0.895329778	,	-0.52086066	),
  (	75	,	0.872973111	,	-0.50360648	),
  (	75	,	0.712978915	,	-0.595006569	),
  (	75	,	0.66541265	,	-0.471292531	),
  (	75	,	0.768483056	,	-0.457267352	),
  (	75	,	0.824148879	,	-0.434354923	),
  (	75	,	0.773011375	,	-0.370836922	),
  (	75	,	1.062392916	,	-0.426912293	),
  (	75	,	0.983211598	,	-0.358213657	),
  (	75	,	1.05244635	,	-0.388787405	),
  (	75	,	1.055593427	,	-0.366880693	),
  (	75	,	1.044675037	,	-0.354879525	),
  (	75	,	1.108542703	,	-0.279131305	),
  (	75	,	0.913804587	,	-0.341282789	),
  (	75	,	0.881310785	,	-0.269805866	),
  (	75	,	0.966795778	,	-0.249572626	),
  (	75	,	0.563216798	,	-0.401251543	),
  (	75	,	0.696617237	,	-0.356559409	),
  (	75	,	0.698188353	,	-0.284635223	),
  (	75	,	0.519300905	,	-0.400021467	),
  (	75	,	0.572207904	,	-0.336975736	),
  (	75	,	0.57054492	,	-0.225613501	),
  (	75	,	0.809493764	,	-0.289871071	),
  (	75	,	0.93021545	,	-0.175329168	),
  (	75	,	0.832792537	,	-0.194182447	),
  (	75	,	0.711764045	,	-0.115936744	),
  (	75	,	0.860313236	,	-0.072254152	),
  (	75	,	0.803300461	,	-0.091513126	),
  (	75	,	0.743234449	,	-0.118803747	),
  (	75	,	0.735164247	,	-0.100155632	),
  (	75	,	0.75577542	,	-0.091617758	),
  (	75	,	2.278266839	,	-1.56138268	),
  (	75	,	1.883371696	,	-1.474267269	),
  (	75	,	2.007382727	,	-1.441316125	),
  (	75	,	2.872303906	,	-1.441300567	),
  (	75	,	1.778784425	,	-1.414853276	),
  (	75	,	2.250560828	,	-1.343917608	),
  (	75	,	1.987999115	,	-1.318496644	),
  (	75	,	2.3831418	,	-1.336336317	),
  (	75	,	2.389615764	,	-1.199996842	),
  (	75	,	2.355770978	,	-1.188456574	),
  (	75	,	2.934311542	,	-1.252263105	),
  (	75	,	3.055809258	,	-1.21600358	),
  (	75	,	2.96751753	,	-1.170232334	),
  (	75	,	3.003941417	,	-1.160456665	),
  (	75	,	2.88813039	,	-1.152131425	),
  (	75	,	2.956219965	,	-1.107871287	),
  (	75	,	2.58665594	,	-1.247119371	),
  (	75	,	2.623677578	,	-1.234436912	),
  (	75	,	2.672250047	,	-1.156927125	),
  (	75	,	2.706625675	,	-1.153025941	),
  (	75	,	2.613994921	,	-1.151625724	),
  (	75	,	2.525278165	,	-1.166905525	),
  (	75	,	2.506710066	,	-1.15404984	),
  (	75	,	2.465008466	,	-1.129365986	),
  (	75	,	2.49455326	,	-1.121148358	),
  (	75	,	2.523982397	,	-1.091805739	),
  (	75	,	2.770449094	,	-1.11934797	),
  (	75	,	2.756934116	,	-1.115971654	),
  (	75	,	2.710223408	,	-1.020734746	),
  (	75	,	2.633916377	,	-1.050684671	),
  (	75	,	2.581737196	,	-1.057560801	),
  (	75	,	2.545023256	,	-1.047708617	),
  (	75	,	2.573898753	,	-1.026419369	),
  (	75	,	2.556967943	,	-1.030545911	),
  (	75	,	2.665681541	,	-1.032437646	),
  (	75	,	2.657766835	,	-1.012996641	),
  (	75	,	2.603829521	,	-1.00626622	),
  (	75	,	2.019631103	,	-1.248639815	),
  (	75	,	2.009327823	,	-1.219042606	),
  (	75	,	1.752760934	,	-1.242981298	),
  (	75	,	1.735035661	,	-1.232273324	),
  (	75	,	1.74987941	,	-1.23308797	),
  (	75	,	2.128226277	,	-1.202510888	),
  (	75	,	1.999448806	,	-1.177192112	),
  (	75	,	2.01720225	,	-1.167694315	),
  (	75	,	1.706945191	,	-1.230733671	),
  (	75	,	1.862225351	,	-1.169656945	),
  (	75	,	1.886301563	,	-1.183056716	),
  (	75	,	1.880404635	,	-1.170537511	),
  (	75	,	1.837323117	,	-1.146786736	),
  (	75	,	1.768981045	,	-1.135236744	),
  (	75	,	1.850679587	,	-1.125561272	),
  (	75	,	2.180500916	,	-1.048997191	),
  (	75	,	2.116387888	,	-1.053967912	),
  (	75	,	2.361922586	,	-1.133138781	),
  (	75	,	2.385642842	,	-1.096936976	),
  (	75	,	2.310946956	,	-1.090982556	),
  (	75	,	2.370107052	,	-1.088233614	),
  (	75	,	2.498137704	,	-1.056333308	),
  (	75	,	2.469942278	,	-1.042730562	),
  (	75	,	2.417776336	,	-1.056544144	),
  (	75	,	2.406535308	,	-1.005640089	),
  (	75	,	2.327613844	,	-0.986448794	),
  (	75	,	2.530055665	,	-1.034702143	),
  (	75	,	2.535089215	,	-1.030456101	),
  (	75	,	2.501251695	,	-1.010243568	),
  (	75	,	2.450733277	,	-0.993148149	),
  (	75	,	2.489103906	,	-0.963982674	),
  (	75	,	2.581726498	,	-0.954005045	),
  (	75	,	2.529331875	,	-0.929525486	),
  (	75	,	2.50782948	,	-0.908059646	),
  (	75	,	2.514613539	,	-0.899078795	),
  (	75	,	2.430397957	,	-0.897777786	),
  (	75	,	2.237011498	,	-0.968132082	),
  (	75	,	2.200752205	,	-0.973711286	),
  (	75	,	2.264855986	,	-0.976378826	),
  (	75	,	2.171783218	,	-0.975485516	),
  (	75	,	2.212401216	,	-0.898382438	),
  (	75	,	2.238119622	,	-0.857917236	),
  (	75	,	2.329763737	,	-0.915820547	),
  (	75	,	2.349699144	,	-0.87702171	),
  (	75	,	2.450799166	,	-0.825890851	),
  (	75	,	2.438136464	,	-0.823879235	),
  (	75	,	2.319266089	,	-0.864944245	),
  (	75	,	2.291495201	,	-0.803525387	),
  (	75	,	3.114261365	,	-1.139517521	),
  (	75	,	3.061451029	,	-1.114032779	),
  (	75	,	3.053594308	,	-1.107913314	),
  (	75	,	2.988528236	,	-1.107098896	),
  (	75	,	3.035776994	,	-1.07473979	),
  (	75	,	3.057923981	,	-1.06431121	),
  (	75	,	2.993336869	,	-1.035902726	),
  (	75	,	3.054640589	,	-1.0297799	),
  (	75	,	3.006609959	,	-1.026111126	),
  (	75	,	3.001313896	,	-1.024167278	),
  (	75	,	2.901281114	,	-1.065551391	),
  (	75	,	2.960609876	,	-1.051455948	),
  (	75	,	2.986352128	,	-1.015451846	),
  (	75	,	2.966688431	,	-1.014990845	),
  (	75	,	2.93878097	,	-0.995742192	),
  (	75	,	2.864118108	,	-1.004459692	),
  (	75	,	2.878555977	,	-0.98097333	),
  (	75	,	3.132879454	,	-0.992480482	),
  (	75	,	2.976858676	,	-0.987902486	),
  (	75	,	3.009758788	,	-0.901679084	),
  (	75	,	2.777972004	,	-1.032675508	),
  (	75	,	2.81649237	,	-0.973743302	),
  (	75	,	2.701048377	,	-0.977743272	),
  (	75	,	2.84621911	,	-0.904085003	),
  (	75	,	2.852228537	,	-0.898830842	),
  (	75	,	2.896551776	,	-0.890627185	),
  (	75	,	2.776333467	,	-0.835135397	),
  (	75	,	2.739862217	,	-0.838123872	),
  (	75	,	2.799837952	,	-0.798807301	),
  (	75	,	3.135690401	,	-0.920988944	),
  (	75	,	3.061965771	,	-0.883575707	),
  (	75	,	3.053819446	,	-0.799438741	),
  (	75	,	2.936892159	,	-0.82126705	),
  (	75	,	2.949618241	,	-0.825646118	),
  (	75	,	3.113676847	,	-0.815794901	),
  (	75	,	3.105737364	,	-0.719898667	),
  (	75	,	3.097935884	,	-0.702953582	),
  (	75	,	3.013886821	,	-0.684787877	),
  (	75	,	2.867515479	,	-0.782077217	),
  (	75	,	2.904546818	,	-0.752559072	),
  (	75	,	2.897775249	,	-0.703518694	),
  (	75	,	2.948779962	,	-0.686301692	),
  (	75	,	2.979286327	,	-0.632550481	),
  (	75	,	2.972044634	,	-0.620006309	),
  (	75	,	2.896748919	,	-0.583719823	),
  (	75	,	2.572435588	,	-0.909793147	),
  (	75	,	2.559534923	,	-0.882716106	),
  (	75	,	2.629091405	,	-0.852803705	),
  (	75	,	2.675074092	,	-0.836356011	),
  (	75	,	2.614526948	,	-0.821915958	),
  (	75	,	2.529293234	,	-0.841891157	),
  (	75	,	2.582130466	,	-0.788157363	),
  (	75	,	2.55656733	,	-0.762336862	),
  (	75	,	2.679295562	,	-0.769553783	),
  (	75	,	2.657748245	,	-0.762623311	),
  (	75	,	2.644464288	,	-0.742198529	),
  (	75	,	2.71959991	,	-0.710270669	),
  (	75	,	2.619945884	,	-0.748507913	),
  (	75	,	2.593128353	,	-0.749041957	),
  (	75	,	2.590133045	,	-0.738459035	),
  (	75	,	2.590652873	,	-0.730361258	),
  (	75	,	2.481264718	,	-0.794131274	),
  (	75	,	2.47259142	,	-0.772125694	),
  (	75	,	2.449146136	,	-0.74742813	),
  (	75	,	2.385206441	,	-0.759056488	),
  (	75	,	2.495872055	,	-0.679590073	),
  (	75	,	2.565629207	,	-0.669567771	),
  (	75	,	2.618391439	,	-0.629065884	),
  (	75	,	2.60480798	,	-0.607820367	),
  (	75	,	2.596957096	,	-0.588012326	),
  (	75	,	2.746303591	,	-0.714931918	),
  (	75	,	2.791990656	,	-0.586653899	),
  (	75	,	2.755445854	,	-0.613113819	),
  (	75	,	2.769913874	,	-0.547106158	),
  (	75	,	2.866122103	,	-0.544630664	),
  (	75	,	2.917596419	,	-0.519190964	),
  (	75	,	2.819962686	,	-0.466456937	),
  (	75	,	2.617745754	,	-0.547151339	),
  (	75	,	2.64456793	,	-0.508211932	),
  (	75	,	2.633975154	,	-0.469657187	),
  (	75	,	2.816729365	,	-0.436785154	),
  (	75	,	1.648593846	,	-1.117536388	),
  (	75	,	1.724180795	,	-1.067670905	),
  (	75	,	1.841446712	,	-1.03778306	),
  (	75	,	1.618279615	,	-1.073370037	),
  (	75	,	1.814648369	,	-0.993757431	),
  (	75	,	1.9696995	,	-1.011240057	),
  (	75	,	2.049220781	,	-0.961309092	),
  (	75	,	1.847842773	,	-0.976477595	),
  (	75	,	1.903131687	,	-0.943206986	),
  (	75	,	2.033968778	,	-0.899729453	),
  (	75	,	1.574826244	,	-0.95908061	),
  (	75	,	1.74368325	,	-0.922101117	),
  (	75	,	1.916648191	,	-0.872266467	),
  (	75	,	1.993367742	,	-0.79292323	),
  (	75	,	1.818513391	,	-0.890398749	),
  (	75	,	1.893612324	,	-0.843046492	),
  (	75	,	1.894435406	,	-0.808538129	),
  (	75	,	1.95604612	,	-0.767301661	),
  (	75	,	2.104812396	,	-0.897807573	),
  (	75	,	2.162573767	,	-0.872540465	),
  (	75	,	2.169781443	,	-0.818440656	),
  (	75	,	2.191288143	,	-0.83396363	),
  (	75	,	2.125349844	,	-0.841066383	),
  (	75	,	2.12413716	,	-0.799960136	),
  (	75	,	2.24534182	,	-0.772664498	),
  (	75	,	2.301065969	,	-0.694634656	),
  (	75	,	2.243684466	,	-0.734829152	),
  (	75	,	2.219255004	,	-0.718624807	),
  (	75	,	2.19534884	,	-0.704779018	),
  (	75	,	2.188760243	,	-0.706071199	),
  (	75	,	2.250306072	,	-0.713292749	),
  (	75	,	2.022665777	,	-0.800474802	),
  (	75	,	2.03469279	,	-0.805636501	),
  (	75	,	2.038473261	,	-0.757376646	),
  (	75	,	2.070777186	,	-0.741281884	),
  (	75	,	2.085268583	,	-0.726775077	),
  (	75	,	2.084731765	,	-0.72493712	),
  (	75	,	2.121712664	,	-0.699870657	),
  (	75	,	2.024824438	,	-0.75009884	),
  (	75	,	1.990928628	,	-0.707408014	),
  (	75	,	2.048241881	,	-0.702586029	),
  (	75	,	2.072042537	,	-0.670557928	),
  (	75	,	2.048619501	,	-0.680698223	),
  (	75	,	2.15273867	,	-0.670875255	),
  (	75	,	2.143971667	,	-0.642298891	),
  (	75	,	2.16512447	,	-0.626257369	),
  (	75	,	2.150441656	,	-0.632299595	),
  (	75	,	2.106793753	,	-0.602933234	),
  (	75	,	2.096436506	,	-0.595572384	),
  (	75	,	2.141765672	,	-0.565125294	),
  (	75	,	2.152209786	,	-0.561229544	),
  (	75	,	1.660653584	,	-0.908790484	),
  (	75	,	1.588238783	,	-0.891838973	),
  (	75	,	1.739280978	,	-0.841550259	),
  (	75	,	1.740099124	,	-0.764884359	),
  (	75	,	1.902045304	,	-0.735484459	),
  (	75	,	1.879107736	,	-0.720212603	),
  (	75	,	1.897363742	,	-0.718529162	),
  (	75	,	1.781556947	,	-0.764462947	),
  (	75	,	1.793763912	,	-0.736592582	),
  (	75	,	1.846059426	,	-0.704365732	),
  (	75	,	1.891452044	,	-0.671795626	),
  (	75	,	1.860278834	,	-0.658155684	),
  (	75	,	1.619911441	,	-0.783903296	),
  (	75	,	1.610251901	,	-0.717645574	),
  (	75	,	1.789774528	,	-0.68164492	),
  (	75	,	1.725117464	,	-0.677340749	),
  (	75	,	1.820389525	,	-0.643794981	),
  (	75	,	1.855413876	,	-0.627268083	),
  (	75	,	1.822109158	,	-0.619012722	),
  (	75	,	1.807490222	,	-0.597300433	),
  (	75	,	1.709344735	,	-0.648791886	),
  (	75	,	1.767670268	,	-0.552471466	),
  (	75	,	1.940034655	,	-0.6679964	),
  (	75	,	1.941953476	,	-0.662670523	),
  (	75	,	2.018372152	,	-0.634859614	),
  (	75	,	2.05226704	,	-0.624662859	),
  (	75	,	2.021437955	,	-0.589972358	),
  (	75	,	2.020434707	,	-0.581405594	),
  (	75	,	2.009340094	,	-0.583379504	),
  (	75	,	1.956457531	,	-0.615408221	),
  (	75	,	1.965972801	,	-0.594992581	),
  (	75	,	1.95165178	,	-0.591499956	),
  (	75	,	1.940338789	,	-0.554712205	),
  (	75	,	1.946776053	,	-0.552285045	),
  (	75	,	2.040815663	,	-0.570221975	),
  (	75	,	2.000407611	,	-0.556064822	),
  (	75	,	1.995494591	,	-0.537425351	),
  (	75	,	2.005607436	,	-0.509474717	),
  (	75	,	1.89387552	,	-0.552267115	),
  (	75	,	1.853278633	,	-0.557552503	),
  (	75	,	1.913564415	,	-0.537539873	),
  (	75	,	1.891331454	,	-0.509326826	),
  (	75	,	1.837733615	,	-0.535196854	),
  (	75	,	1.882543634	,	-0.484011497	),
  (	75	,	2.020065533	,	-0.450988153	),
  (	75	,	1.993838343	,	-0.424060287	),
  (	75	,	2.033402727	,	-0.405961233	),
  (	75	,	1.893827843	,	-0.4133217	),
  (	75	,	1.983444135	,	-0.371867859	),
  (	75	,	1.938211147	,	-0.390299669	),
  (	75	,	2.393788432	,	-0.676907849	),
  (	75	,	2.335715018	,	-0.668943154	),
  (	75	,	2.301298644	,	-0.641420123	),
  (	75	,	2.330083866	,	-0.622200373	),
  (	75	,	2.330725919	,	-0.561218487	),
  (	75	,	2.518668768	,	-0.527285649	),
  (	75	,	2.252691931	,	-0.546955795	),
  (	75	,	2.297749319	,	-0.518853231	),
  (	75	,	2.214949142	,	-0.558391624	),
  (	75	,	2.361013516	,	-0.48024098	),
  (	75	,	2.569246332	,	-0.384301949	),
  (	75	,	2.526801464	,	-0.403083963	),
  (	75	,	2.514454938	,	-0.383924624	),
  (	75	,	2.644809775	,	-0.365625805	),
  (	75	,	2.650151189	,	-0.343980945	),
  (	75	,	2.599338943	,	-0.343429902	),
  (	75	,	2.579292264	,	-0.32565306	),
  (	75	,	2.477857136	,	-0.393194679	),
  (	75	,	2.421769932	,	-0.351165293	),
  (	75	,	2.4646841	,	-0.272943416	),
  (	75	,	2.604744937	,	-0.27743005	),
  (	75	,	2.611492224	,	-0.243331902	),
  (	75	,	2.537086158	,	-0.183304923	),
  (	75	,	2.170688228	,	-0.459058066	),
  (	75	,	2.212128315	,	-0.405839467	),
  (	75	,	2.105722069	,	-0.436979867	),
  (	75	,	2.094612092	,	-0.407548025	),
  (	75	,	2.247507786	,	-0.388430909	),
  (	75	,	2.211338934	,	-0.317183399	),
  (	75	,	2.079144857	,	-0.401501163	),
  (	75	,	2.122568319	,	-0.346050435	),
  (	75	,	2.09157404	,	-0.339749431	),
  (	75	,	2.017375635	,	-0.333474292	),
  (	75	,	2.167994372	,	-0.264450638	),
  (	75	,	2.220193037	,	-0.2803494	),
  (	75	,	2.2299334	,	-0.244557054	),
  (	75	,	2.173016197	,	-0.261362609	),
  (	75	,	2.098345258	,	-0.27470055	),
  (	75	,	2.11851337	,	-0.236884836	),
  (	75	,	2.328296247	,	-0.302974302	),
  (	75	,	2.342347965	,	-0.304290397	),
  (	75	,	2.412713507	,	-0.269117053	),
  (	75	,	2.270680445	,	-0.256508348	),
  (	75	,	2.302033796	,	-0.236083545	),
  (	75	,	2.392319452	,	-0.208428352	),
  (	75	,	2.35858383	,	-0.211898861	),
  (	75	,	2.478814907	,	-0.17496261	),
  (	75	,	2.426321959	,	-0.145741304	),
  (	75	,	2.44666937	,	-0.134917869	),
  (	75	,	2.227072402	,	-0.122873601	),
  (	75	,	2.364729033	,	-0.146164503	),
  (	75	,	2.390954294	,	-0.136223934	),
  (	75	,	2.370820579	,	-0.077519601	),
  (	75	,	2.378391589	,	-0.065989404	),
  (	75	,	2.296697277	,	-0.111892833	),
  (	75	,	2.305737446	,	-0.043999322	),
  (	75	,	2.384546082	,	-0.045367512	),
  (	75	,	3.431880012	,	-1.447763285	),
  (	75	,	3.972010929	,	-1.389505877	),
  (	75	,	4.506942081	,	-1.437945347	),
  (	75	,	4.309933088	,	-1.43050131	),
  (	75	,	4.544771495	,	-1.379943817	),
  (	75	,	4.54599656	,	-1.347275978	),
  (	75	,	4.083875258	,	-1.380312588	),
  (	75	,	4.225652024	,	-1.348072852	),
  (	75	,	4.277314498	,	-1.296882099	),
  (	75	,	4.193942953	,	-1.319809255	),
  (	75	,	3.422955621	,	-1.41633704	),
  (	75	,	3.236466084	,	-1.386955074	),
  (	75	,	3.552645602	,	-1.301423543	),
  (	75	,	3.94958784	,	-1.259949397	),
  (	75	,	4.305808918	,	-1.252594164	),
  (	75	,	4.66491977	,	-1.240848004	),
  (	75	,	4.621113871	,	-1.233846427	),
  (	75	,	4.576485334	,	-1.232794764	),
  (	75	,	4.608909152	,	-1.151876511	),
  (	75	,	3.977804019	,	-1.181764685	),
  (	75	,	4.333063348	,	-1.114280158	),
  (	75	,	4.201303937	,	-1.101843078	),
  (	75	,	4.288203789	,	-1.092039176	),
  (	75	,	4.387155288	,	-1.057035363	),
  (	75	,	4.307244126	,	-1.014418637	),
  (	75	,	4.178639191	,	-1.050705029	),
  (	75	,	4.269214848	,	-1.019159004	),
  (	75	,	4.180514934	,	-0.984258341	),
  (	75	,	4.211734127	,	-0.983317239	),
  (	75	,	3.27656788	,	-1.315992816	),
  (	75	,	3.318432419	,	-1.231272337	),
  (	75	,	3.470160408	,	-1.23007348	),
  (	75	,	3.510860936	,	-1.229254255	),
  (	75	,	3.493443255	,	-1.216156454	),
  (	75	,	3.41207336	,	-1.208279989	),
  (	75	,	3.762381516	,	-1.205771142	),
  (	75	,	3.734637112	,	-1.196256224	),
  (	75	,	3.680540158	,	-1.19561599	),
  (	75	,	3.654281511	,	-1.186924664	),
  (	75	,	3.666444087	,	-1.178198403	),
  (	75	,	3.64705008	,	-1.15866716	),
  (	75	,	3.601076304	,	-1.165089422	),
  (	75	,	3.169107668	,	-1.218209804	),
  (	75	,	3.263961019	,	-1.199628891	),
  (	75	,	3.296632996	,	-1.192948845	),
  (	75	,	3.183623234	,	-1.177297752	),
  (	75	,	3.249999664	,	-1.180405898	),
  (	75	,	3.328445511	,	-1.159906783	),
  (	75	,	3.324306236	,	-1.129729159	),
  (	75	,	3.388389595	,	-1.123310334	),
  (	75	,	3.571266464	,	-1.117981416	),
  (	75	,	3.543301291	,	-1.100288913	),
  (	75	,	3.59206161	,	-1.077026884	),
  (	75	,	3.671667255	,	-1.098701075	),
  (	75	,	3.694809651	,	-1.08863749	),
  (	75	,	3.618283135	,	-1.060333161	),
  (	75	,	3.483219901	,	-1.070377732	),
  (	75	,	3.998341849	,	-1.088447806	),
  (	75	,	3.889298309	,	-1.038534474	),
  (	75	,	3.958591666	,	-1.002514261	),
  (	75	,	3.914350924	,	-0.975864827	),
  (	75	,	4.039345108	,	-0.995086895	),
  (	75	,	4.109338122	,	-0.898343578	),
  (	75	,	4.019529469	,	-0.947574035	),
  (	75	,	3.98365598	,	-0.907101676	),
  (	75	,	4.060061616	,	-0.924727954	),
  (	75	,	4.04578116	,	-0.863147627	),
  (	75	,	4.034323481	,	-0.847918251	),
  (	75	,	3.807065256	,	-0.968025943	),
  (	75	,	3.714857771	,	-0.984069929	),
  (	75	,	3.829421799	,	-0.874171211	),
  (	75	,	3.923010448	,	-0.837020045	),
  (	75	,	3.920572472	,	-0.827910198	),
  (	75	,	3.906556379	,	-0.813872898	),
  (	75	,	3.917362309	,	-0.741714066	),
  (	75	,	4.677828918	,	-1.054075842	),
  (	75	,	4.577281491	,	-1.030311441	),
  (	75	,	4.527252023	,	-1.061943575	),
  (	75	,	4.519210237	,	-1.061136145	),
  (	75	,	4.43127014	,	-1.059024667	),
  (	75	,	4.43185966	,	-1.037033414	),
  (	75	,	4.458884682	,	-1.030575999	),
  (	75	,	4.543193439	,	-1.047483066	),
  (	75	,	4.688201125	,	-1.028203588	),
  (	75	,	4.682659439	,	-1.027374619	),
  (	75	,	4.710785584	,	-0.981844922	),
  (	75	,	4.658056765	,	-0.980282502	),
  (	75	,	4.696692836	,	-0.949077679	),
  (	75	,	4.637746694	,	-0.970890586	),
  (	75	,	4.507562848	,	-0.957357172	),
  (	75	,	4.529092216	,	-0.863104889	),
  (	75	,	4.500461316	,	-0.87474464	),
  (	75	,	4.350030416	,	-0.959673556	),
  (	75	,	4.359084473	,	-0.91578983	),
  (	75	,	4.266497172	,	-0.934689443	),
  (	75	,	4.3235852	,	-0.889616098	),
  (	75	,	4.23787145	,	-0.882137764	),
  (	75	,	4.362112349	,	-0.876381052	),
  (	75	,	4.395913786	,	-0.843335032	),
  (	75	,	4.396118511	,	-0.830610425	),
  (	75	,	4.340465903	,	-0.862116341	),
  (	75	,	4.339948098	,	-0.820381319	),
  (	75	,	4.348912385	,	-0.78817633	),
  (	75	,	4.678837569	,	-0.902571977	),
  (	75	,	4.628795535	,	-0.871958363	),
  (	75	,	4.633146848	,	-0.829245603	),
  (	75	,	4.639977883	,	-0.813113707	),
  (	75	,	4.63539038	,	-0.8080688	),
  (	75	,	4.499906384	,	-0.806030937	),
  (	75	,	4.578851614	,	-0.815002187	),
  (	75	,	4.599247434	,	-0.81333227	),
  (	75	,	4.580919779	,	-0.780891023	),
  (	75	,	4.635583346	,	-0.760503577	),
  (	75	,	4.670704542	,	-0.726902702	),
  (	75	,	4.66780168	,	-0.723306794	),
  (	75	,	4.664846517	,	-0.723652825	),
  (	75	,	4.601885259	,	-0.721243732	),
  (	75	,	4.588956064	,	-0.716277817	),
  (	75	,	4.614764051	,	-0.712330899	),
  (	75	,	4.587285316	,	-0.680990771	),
  (	75	,	4.472568114	,	-0.819811116	),
  (	75	,	4.482570795	,	-0.818416375	),
  (	75	,	4.42609352	,	-0.783513088	),
  (	75	,	4.470306296	,	-0.755915143	),
  (	75	,	4.426298088	,	-0.730109144	),
  (	75	,	4.436427907	,	-0.718281415	),
  (	75	,	4.41089813	,	-0.730079026	),
  (	75	,	4.416118746	,	-0.709954533	),
  (	75	,	4.431522952	,	-0.689492034	),
  (	75	,	4.463231801	,	-0.671255923	),
  (	75	,	4.45589895	,	-0.66677339	),
  (	75	,	4.400970469	,	-0.650182446	),
  (	75	,	4.399052834	,	-0.643747407	),
  (	75	,	4.479750299	,	-0.629678634	),
  (	75	,	4.168751164	,	-0.872289016	),
  (	75	,	4.283745212	,	-0.733105436	),
  (	75	,	4.133001392	,	-0.736628537	),
  (	75	,	4.061409369	,	-0.792808018	),
  (	75	,	3.988024193	,	-0.764354008	),
  (	75	,	3.991685858	,	-0.73861925	),
  (	75	,	3.970666232	,	-0.718717263	),
  (	75	,	4.206872691	,	-0.618710102	),
  (	75	,	4.068861313	,	-0.664470299	),
  (	75	,	4.143926192	,	-0.572615407	),
  (	75	,	4.116529952	,	-0.532937162	),
  (	75	,	4.331475755	,	-0.716192043	),
  (	75	,	4.326169744	,	-0.680932479	),
  (	75	,	4.3357651	,	-0.652459822	),
  (	75	,	4.332798647	,	-0.585255513	),
  (	75	,	4.293285561	,	-0.579468955	),
  (	75	,	4.282305309	,	-0.581219498	),
  (	75	,	4.300528153	,	-0.559849911	),
  (	75	,	4.486749925	,	-0.524506024	),
  (	75	,	4.476527255	,	-0.503921529	),
  (	75	,	4.407733817	,	-0.466748747	),
  (	75	,	4.188047555	,	-0.555633062	),
  (	75	,	4.187198699	,	-0.517190631	),
  (	75	,	4.295719494	,	-0.473880337	),
  (	75	,	4.2693834	,	-0.406216377	),
  (	75	,	3.245007235	,	-1.114744435	),
  (	75	,	3.182549149	,	-1.113874632	),
  (	75	,	3.193935577	,	-1.106206099	),
  (	75	,	3.259578825	,	-1.071373928	),
  (	75	,	3.338365082	,	-1.04851935	),
  (	75	,	3.220620594	,	-1.072853022	),
  (	75	,	3.608716186	,	-0.92995569	),
  (	75	,	3.438382778	,	-0.989325772	),
  (	75	,	3.495769557	,	-0.901832295	),
  (	75	,	3.160189442	,	-1.001201346	),
  (	75	,	3.202842325	,	-0.968359602	),
  (	75	,	3.456265947	,	-0.87382655	),
  (	75	,	3.540903198	,	-0.815685596	),
  (	75	,	3.525948069	,	-0.786605269	),
  (	75	,	3.475516967	,	-0.780238528	),
  (	75	,	3.772597671	,	-0.823409603	),
  (	75	,	3.644346409	,	-0.821917733	),
  (	75	,	3.661522003	,	-0.793591751	),
  (	75	,	3.724713342	,	-0.802612281	),
  (	75	,	3.801496862	,	-0.709582507	),
  (	75	,	3.633763235	,	-0.741479218	),
  (	75	,	3.636699409	,	-0.681676758	),
  (	75	,	3.7016704	,	-0.576884355	),
  (	75	,	3.715325843	,	-0.561446404	),
  (	75	,	3.163651348	,	-0.893459301	),
  (	75	,	3.25131957	,	-0.843152727	),
  (	75	,	3.164873288	,	-0.855335639	),
  (	75	,	3.405504443	,	-0.752034494	),
  (	75	,	3.480157752	,	-0.755714983	),
  (	75	,	3.496681263	,	-0.697957272	),
  (	75	,	3.40331337	,	-0.722408215	),
  (	75	,	3.149164203	,	-0.730050757	),
  (	75	,	3.218290239	,	-0.69821053	),
  (	75	,	3.554188728	,	-0.679106715	),
  (	75	,	3.575438432	,	-0.63252506	),
  (	75	,	3.567172107	,	-0.63830689	),
  (	75	,	3.568324613	,	-0.611999822	),
  (	75	,	3.588159514	,	-0.593068054	),
  (	75	,	3.580149828	,	-0.599664075	),
  (	75	,	3.585597726	,	-0.586384455	),
  (	75	,	3.498630052	,	-0.630279978	),
  (	75	,	3.541142314	,	-0.560963912	),
  (	75	,	3.657161216	,	-0.519140022	),
  (	75	,	3.684576057	,	-0.507242042	),
  (	75	,	3.653342783	,	-0.499779447	),
  (	75	,	3.477026329	,	-0.533931928	),
  (	75	,	3.367370963	,	-0.542512822	),
  (	75	,	3.391741034	,	-0.503833119	),
  (	75	,	3.539198244	,	-0.447801567	),
  (	75	,	3.527496857	,	-0.4400469	),
  (	75	,	3.495260092	,	-0.390658576	),
  (	75	,	3.9489707	,	-0.697876548	),
  (	75	,	3.916326364	,	-0.617568334	),
  (	75	,	3.931520141	,	-0.590613653	),
  (	75	,	4.036304073	,	-0.561233762	),
  (	75	,	3.993510994	,	-0.486200343	),
  (	75	,	3.883175446	,	-0.506748854	),
  (	75	,	3.958734286	,	-0.42226216	),
  (	75	,	3.894848015	,	-0.420939781	),
  (	75	,	3.950027306	,	-0.401658928	),
  (	75	,	4.213138122	,	-0.422783344	),
  (	75	,	4.071525949	,	-0.450316023	),
  (	75	,	4.11008111	,	-0.424119575	),
  (	75	,	4.062756265	,	-0.412896029	),
  (	75	,	4.269306248	,	-0.303477493	),
  (	75	,	4.213866613	,	-0.343501893	),
  (	75	,	4.10112959	,	-0.345038061	),
  (	75	,	4.101136382	,	-0.34503262	),
  (	75	,	4.118769409	,	-0.294421966	),
  (	75	,	4.092782007	,	-0.253606075	),
  (	75	,	3.709711875	,	-0.443325913	),
  (	75	,	3.742397654	,	-0.380986082	),
  (	75	,	3.876941988	,	-0.302648386	),
  (	75	,	3.687943417	,	-0.259310144	),
  (	75	,	3.638409221	,	-0.255939828	),
  (	75	,	3.95566322	,	-0.225273076	),
  (	75	,	3.917288367	,	-0.217078826	),
  (	75	,	4.058246606	,	-0.119466265	),
  (	75	,	3.761339692	,	-0.141223923	),
  (	75	,	4.004154436	,	-0.090800929	),
  (	75	,	3.904980243	,	-0.063360964	),
  (	75	,	5.598621019	,	-1.494677411	),
  (	75	,	4.98395925	,	-1.465027349	),
  (	75	,	5.500164421	,	-1.451182796	),
  (	75	,	5.572573492	,	-1.40228482	),
  (	75	,	5.280712505	,	-1.380735002	),
  (	75	,	5.27308678	,	-1.304769113	),
  (	75	,	5.720878742	,	-1.259070114	),
  (	75	,	5.608630677	,	-1.267032955	),
  (	75	,	5.997254	,	-1.306638846	),
  (	75	,	5.971387543	,	-1.238021972	),
  (	75	,	6.273913933	,	-1.169478806	),
  (	75	,	5.787438536	,	-1.199767222	),
  (	75	,	5.687859177	,	-1.187952605	),
  (	75	,	5.641190902	,	-1.119630456	),
  (	75	,	5.829999785	,	-1.004753887	),
  (	75	,	4.749824003	,	-1.310840054	),
  (	75	,	4.738927488	,	-1.291627563	),
  (	75	,	5.267538629	,	-1.213976587	),
  (	75	,	5.192540252	,	-1.210198573	),
  (	75	,	5.379789068	,	-1.193321556	),
  (	75	,	5.258446147	,	-1.100636945	),
  (	75	,	4.798743488	,	-1.16335382	),
  (	75	,	4.992089408	,	-1.113254479	),
  (	75	,	5.000209528	,	-1.112559037	),
  (	75	,	5.121630634	,	-1.100579868	),
  (	75	,	5.148027285	,	-1.014961081	),
  (	75	,	5.184873238	,	-1.007499171	),
  (	75	,	5.201522521	,	-0.989954819	),
  (	75	,	5.4730688	,	-1.096687086	),
  (	75	,	5.470493022	,	-1.042110139	),
  (	75	,	5.449121402	,	-1.033839831	),
  (	75	,	5.556883417	,	-0.959734871	),
  (	75	,	5.526188658	,	-0.959169553	),
  (	75	,	5.553608089	,	-0.899084574	),
  (	75	,	5.625388021	,	-0.878197604	),
  (	75	,	5.518020596	,	-0.894897018	),
  (	75	,	5.406313496	,	-0.860993988	),
  (	75	,	6.059041508	,	-1.042607394	),
  (	75	,	6.25218947	,	-1.026919249	),
  (	75	,	6.199603575	,	-0.98473221	),
  (	75	,	6.158717132	,	-0.97987255	),
  (	75	,	6.033343974	,	-0.924419309	),
  (	75	,	5.939603814	,	-0.99533008	),
  (	75	,	5.90930178	,	-0.947680083	),
  (	75	,	5.816042726	,	-0.976426325	),
  (	75	,	5.855875675	,	-0.940108064	),
  (	75	,	5.883947125	,	-0.903872697	),
  (	75	,	5.987827404	,	-0.830344357	),
  (	75	,	5.988400415	,	-0.802706042	),
  (	75	,	6.282177051	,	-0.890109846	),
  (	75	,	6.118406606	,	-0.753750998	),
  (	75	,	6.247302245	,	-0.744781983	),
  (	75	,	6.239160686	,	-0.738288377	),
  (	75	,	6.012178352	,	-0.66209151	),
  (	75	,	5.985446449	,	-0.626375563	),
  (	75	,	6.06675505	,	-0.698710625	),
  (	75	,	6.036640714	,	-0.670789854	),
  (	75	,	5.812116887	,	-0.668515804	),
  (	75	,	5.609921355	,	-0.815463176	),
  (	75	,	5.578189715	,	-0.790463624	),
  (	75	,	5.602765229	,	-0.698660438	),
  (	75	,	5.706519767	,	-0.689613345	),
  (	75	,	5.659103969	,	-0.626297602	),
  (	75	,	5.966714747	,	-0.607828824	),
  (	75	,	5.85540723	,	-0.602487916	),
  (	75	,	5.855914672	,	-0.601941887	),
  (	75	,	5.894933022	,	-0.541505824	),
  (	75	,	5.765943403	,	-0.590555538	),
  (	75	,	5.758692732	,	-0.499494677	),
  (	75	,	5.940156922	,	-0.442445387	),
  (	75	,	5.829928757	,	-0.401587494	),
  (	75	,	5.920066686	,	-0.368080593	),
  (	75	,	5.885346394	,	-0.385199455	),
  (	75	,	4.937458966	,	-1.062835488	),
  (	75	,	5.020600569	,	-1.047998315	),
  (	75	,	4.919132669	,	-1.053746437	),
  (	75	,	5.07744802	,	-0.976266126	),
  (	75	,	5.08082111	,	-0.975436422	),
  (	75	,	5.148911825	,	-0.87178351	),
  (	75	,	4.790262729	,	-0.985723883	),
  (	75	,	4.748470357	,	-0.971996059	),
  (	75	,	4.742431664	,	-0.945632029	),
  (	75	,	4.794586526	,	-0.937902656	),
  (	75	,	4.852599799	,	-0.892297285	),
  (	75	,	4.9892701	,	-0.878193935	),
  (	75	,	4.961798152	,	-0.827125142	),
  (	75	,	5.057719866	,	-0.803306078	),
  (	75	,	5.315932714	,	-0.891636976	),
  (	75	,	5.327185728	,	-0.794927491	),
  (	75	,	5.403534698	,	-0.777106496	),
  (	75	,	5.461496868	,	-0.71394581	),
  (	75	,	5.190016141	,	-0.798455362	),
  (	75	,	5.201541997	,	-0.796792861	),
  (	75	,	5.164930169	,	-0.770276667	),
  (	75	,	5.129225312	,	-0.7177003	),
  (	75	,	5.225600497	,	-0.658770705	),
  (	75	,	5.313783855	,	-0.701354509	),
  (	75	,	5.32161414	,	-0.553784469	),
  (	75	,	4.797764947	,	-0.861274114	),
  (	75	,	4.873969165	,	-0.841405261	),
  (	75	,	4.883684343	,	-0.811338076	),
  (	75	,	4.750490296	,	-0.86124269	),
  (	75	,	4.813973773	,	-0.844062325	),
  (	75	,	4.729313722	,	-0.854017154	),
  (	75	,	4.73884208	,	-0.832332092	),
  (	75	,	4.743413259	,	-0.826718125	),
  (	75	,	4.800493346	,	-0.801513148	),
  (	75	,	4.916572648	,	-0.764265963	),
  (	75	,	4.89000812	,	-0.770949162	),
  (	75	,	4.925499261	,	-0.789985661	),
  (	75	,	5.055882801	,	-0.690249682	),
  (	75	,	4.756443061	,	-0.801176817	),
  (	75	,	4.753663836	,	-0.801792326	),
  (	75	,	4.78303027	,	-0.803278399	),
  (	75	,	4.776692988	,	-0.795788091	),
  (	75	,	4.801720779	,	-0.769288738	),
  (	75	,	4.877028191	,	-0.726308504	),
  (	75	,	4.763801796	,	-0.751926164	),
  (	75	,	4.749953929	,	-0.731977505	),
  (	75	,	4.907263624	,	-0.723193797	),
  (	75	,	4.983503104	,	-0.611013169	),
  (	75	,	4.91565711	,	-0.556902099	),
  (	75	,	4.923468117	,	-0.556149709	),
  (	75	,	5.064897941	,	-0.676252932	),
  (	75	,	5.142431209	,	-0.603008555	),
  (	75	,	5.09977009	,	-0.628323079	),
  (	75	,	5.10926462	,	-0.570713443	),
  (	75	,	5.2388077	,	-0.561573596	),
  (	75	,	5.043037934	,	-0.585218558	),
  (	75	,	5.038173024	,	-0.510395157	),
  (	75	,	4.965937663	,	-0.538001259	),
  (	75	,	5.114043496	,	-0.492401387	),
  (	75	,	5.110653251	,	-0.449203241	),
  (	75	,	5.08167817	,	-0.393971843	),
  (	75	,	5.111239739	,	-0.367222463	),
  (	75	,	5.484126745	,	-0.59338399	),
  (	75	,	5.54294347	,	-0.57334346	),
  (	75	,	5.559037147	,	-0.517730625	),
  (	75	,	5.596733046	,	-0.513738232	),
  (	75	,	5.402470703	,	-0.540667341	),
  (	75	,	5.468056898	,	-0.550049913	),
  (	75	,	5.451021019	,	-0.526956603	),
  (	75	,	5.461460755	,	-0.519776513	),
  (	75	,	5.320604367	,	-0.51703531	),
  (	75	,	5.44252569	,	-0.461032573	),
  (	75	,	5.471691144	,	-0.423779322	),
  (	75	,	5.719320379	,	-0.48751156	),
  (	75	,	5.756509563	,	-0.39918651	),
  (	75	,	5.611755084	,	-0.427332688	),
  (	75	,	5.694505124	,	-0.393821355	),
  (	75	,	5.796398775	,	-0.288728213	),
  (	75	,	5.603599791	,	-0.412488625	),
  (	75	,	5.563472178	,	-0.380751196	),
  (	75	,	5.61283776	,	-0.366504815	),
  (	75	,	5.706127838	,	-0.317876117	),
  (	75	,	5.663330504	,	-0.300367888	),
  (	75	,	5.669066409	,	-0.242518071	),
  (	75	,	5.332470817	,	-0.383211913	),
  (	75	,	5.400588056	,	-0.391700569	),
  (	75	,	5.403651434	,	-0.366421578	),
  (	75	,	5.327707707	,	-0.319814666	),
  (	75	,	5.351736046	,	-0.303300799	),
  (	75	,	5.277694119	,	-0.359436178	),
  (	75	,	5.242754992	,	-0.294428764	),
  (	75	,	5.310189344	,	-0.321687169	),
  (	75	,	5.31211543	,	-0.276252957	),
  (	75	,	5.358384163	,	-0.244295242	),
  (	75	,	5.529030982	,	-0.278789285	),
  (	75	,	5.566802351	,	-0.159190113	),
  (	75	,	5.56311195	,	-0.14578242	),
  (	75	,	5.562836759	,	-0.123702358	),
  (	75	,	5.605624393	,	-0.097417179	),
  (	75	,	5.446026269	,	-0.170148184	),
  (	75	,	5.345658017	,	-0.204284616	),
  (	75	,	5.370946474	,	-0.175156454	),
  (	75	,	5.487618588	,	-0.134625077	),
  (	75	,	5.515582092	,	-0.101643672	),
  (	75	,	5.557229724	,	-0.112852097	),
  (	75	,	5.556701135	,	-0.103175151	),
  (	75	,	5.50509311	,	-0.072107408	),
  (	75	,	5.483582292	,	-0.064134594	),
  (	75	,	3.020927766	,	1.066089145	),
  (	76	,	0.828810931	,	0.053416588	),
  (	76	,	0.782671125	,	0.116096014	),
  (	76	,	0.635693491	,	0.183365175	),
  (	76	,	0.728162889	,	0.213986241	),
  (	76	,	0.785789555	,	0.185973264	),
  (	76	,	0.863385822	,	0.24167941	),
  (	76	,	0.865913402	,	0.26486076	),
  (	76	,	0.806464544	,	0.240810309	),
  (	76	,	0.764873104	,	0.284643421	),
  (	76	,	1.049893618	,	0.242463215	),
  (	76	,	0.953122702	,	0.264403703	),
  (	76	,	1.081716014	,	0.288512009	),
  (	76	,	1.07610012	,	0.334289261	),
  (	76	,	1.135421682	,	0.335683243	),
  (	76	,	0.944260208	,	0.350239898	),
  (	76	,	0.859357357	,	0.403630068	),
  (	76	,	0.874213839	,	0.41344898	),
  (	76	,	1.043083578	,	0.412388362	),
  (	76	,	1.003319325	,	0.424964679	),
  (	76	,	1.000425539	,	0.42578744	),
  (	76	,	0.925076317	,	0.412718392	),
  (	76	,	0.976165447	,	0.437734905	),
  (	76	,	0.97636499	,	0.460436209	),
  (	76	,	0.942843107	,	0.481591517	),
  (	76	,	0.7140587	,	0.306278035	),
  (	76	,	0.702974043	,	0.328123336	),
  (	76	,	0.440009382	,	0.338095591	),
  (	76	,	0.52061673	,	0.433347398	),
  (	76	,	0.54353108	,	0.443542371	),
  (	76	,	0.874612325	,	0.42835795	),
  (	76	,	0.730878188	,	0.412539665	),
  (	76	,	0.742783884	,	0.442152646	),
  (	76	,	0.784759431	,	0.476497802	),
  (	76	,	0.887497404	,	0.540769275	),
  (	76	,	0.896222106	,	0.553811144	),
  (	76	,	0.883653745	,	0.562689543	),
  (	76	,	0.64911358	,	0.518135496	),
  (	76	,	0.646624136	,	0.521387641	),
  (	76	,	0.614473067	,	0.501540047	),
  (	76	,	0.670032271	,	0.54817646	),
  (	76	,	0.715685112	,	0.564964317	),
  (	76	,	0.709879646	,	0.574233674	),
  (	76	,	0.829490405	,	0.669254293	),
  (	76	,	1.185066285	,	0.398717419	),
  (	76	,	1.133422311	,	0.414312104	),
  (	76	,	1.289690092	,	0.474768567	),
  (	76	,	1.269146817	,	0.49417195	),
  (	76	,	1.290688709	,	0.529493594	),
  (	76	,	1.276115175	,	0.558269851	),
  (	76	,	1.083432118	,	0.566534338	),
  (	76	,	1.207957095	,	0.653430871	),
  (	76	,	1.153376071	,	0.615037761	),
  (	76	,	1.099837161	,	0.61714039	),
  (	76	,	1.112526223	,	0.637076518	),
  (	76	,	1.39989509	,	0.598079938	),
  (	76	,	1.396859265	,	0.624581324	),
  (	76	,	1.396719393	,	0.686673391	),
  (	76	,	1.441452787	,	0.707000022	),
  (	76	,	1.463143997	,	0.754667942	),
  (	76	,	1.529873096	,	0.76814672	),
  (	76	,	1.496603991	,	0.782805583	),
  (	76	,	1.472583391	,	0.778231851	),
  (	76	,	1.328832244	,	0.763189265	),
  (	76	,	1.213534172	,	0.7350791	),
  (	76	,	1.33785996	,	0.78071514	),
  (	76	,	1.427818304	,	0.76803847	),
  (	76	,	1.40579193	,	0.786823292	),
  (	76	,	1.471910823	,	0.836702943	),
  (	76	,	1.369319712	,	0.819897941	),
  (	76	,	1.450178751	,	0.862085494	),
  (	76	,	1.450123739	,	0.862073949	),
  (	76	,	0.999732613	,	0.563116577	),
  (	76	,	0.950936113	,	0.653291619	),
  (	76	,	0.938978146	,	0.663488394	),
  (	76	,	1.107115817	,	0.692550238	),
  (	76	,	1.066362781	,	0.677120017	),
  (	76	,	0.892044049	,	0.698894591	),
  (	76	,	0.91173801	,	0.701386475	),
  (	76	,	0.918148553	,	0.750136982	),
  (	76	,	0.862130007	,	0.744818377	),
  (	76	,	0.902744405	,	0.761932624	),
  (	76	,	0.97654962	,	0.743537625	),
  (	76	,	0.985622806	,	0.795865708	),
  (	76	,	0.952859	,	0.781912863	),
  (	76	,	0.942804276	,	0.813053493	),
  (	76	,	1.081022961	,	0.898020421	),
  (	76	,	0.9803756	,	0.882137291	),
  (	76	,	1.196763781	,	0.80133485	),
  (	76	,	1.499402356	,	0.965667807	),
  (	76	,	1.53364942	,	0.964492675	),
  (	76	,	1.359183082	,	0.929116504	),
  (	76	,	1.38578372	,	0.968952308	),
  (	76	,	1.544869385	,	0.995627829	),
  (	76	,	1.562619102	,	1.036606842	),
  (	76	,	1.142134808	,	0.873277977	),
  (	76	,	1.256759936	,	0.927154303	),
  (	76	,	1.257531927	,	1.033950897	),
  (	76	,	1.313870629	,	1.023905373	),
  (	76	,	1.44760573	,	1.099295449	),
  (	76	,	1.416901764	,	1.10629495	),
  (	76	,	0.407873437	,	0.411727564	),
  (	76	,	0.497127803	,	0.44987504	),
  (	76	,	0.539090084	,	0.479648722	),
  (	76	,	0.255139776	,	0.467500484	),
  (	76	,	0.234870849	,	0.498432296	),
  (	76	,	0.302335861	,	0.60747628	),
  (	76	,	0.459634915	,	0.623299726	),
  (	76	,	0.402555394	,	0.667970943	),
  (	76	,	0.557973221	,	0.620527845	),
  (	76	,	0.667290878	,	0.651588824	),
  (	76	,	0.655402882	,	0.679831822	),
  (	76	,	0.664914723	,	0.699619461	),
  (	76	,	0.709005335	,	0.702688484	),
  (	76	,	0.714418333	,	0.724273166	),
  (	76	,	0.709465394	,	0.743355507	),
  (	76	,	0.656316076	,	0.792930313	),
  (	76	,	0.493833898	,	0.651369912	),
  (	76	,	0.485004654	,	0.663642666	),
  (	76	,	0.500500865	,	0.697245999	),
  (	76	,	0.506200498	,	0.751554968	),
  (	76	,	0.516510778	,	0.761346218	),
  (	76	,	0.550538827	,	0.817854419	),
  (	76	,	0.632950458	,	0.796686519	),
  (	76	,	0.625147853	,	0.805293431	),
  (	76	,	0.657079068	,	0.834445473	),
  (	76	,	0.51809987	,	0.792994916	),
  (	76	,	0.202672985	,	0.540203343	),
  (	76	,	0.183605782	,	0.569169639	),
  (	76	,	0.110371087	,	0.611514526	),
  (	76	,	0.113644647	,	0.625164413	),
  (	76	,	0.182623107	,	0.678867758	),
  (	76	,	0.178172463	,	0.701317378	),
  (	76	,	0.315411566	,	0.714029157	),
  (	76	,	0.259348465	,	0.700836403	),
  (	76	,	0.130285755	,	0.6688722	),
  (	76	,	0.033290845	,	0.699500729	),
  (	76	,	0.078023689	,	0.778031952	),
  (	76	,	0.035989718	,	0.815216496	),
  (	76	,	0.184848868	,	0.766848392	),
  (	76	,	0.135448466	,	0.877099646	),
  (	76	,	0.052853785	,	0.828873222	),
  (	76	,	0.018196797	,	0.870397528	),
  (	76	,	0.065740763	,	0.918734375	),
  (	76	,	0.420530227	,	0.825990568	),
  (	76	,	0.384461606	,	0.833437277	),
  (	76	,	0.265907626	,	0.888005516	),
  (	76	,	0.440746645	,	0.857025915	),
  (	76	,	0.501710093	,	0.945773494	),
  (	76	,	0.350858974	,	0.90466091	),
  (	76	,	0.368354724	,	0.998297479	),
  (	76	,	0.346487063	,	0.999620103	),
  (	76	,	0.226494696	,	0.886182689	),
  (	76	,	0.149272548	,	0.94363608	),
  (	76	,	0.161558437	,	0.963720989	),
  (	76	,	0.105783288	,	0.939369346	),
  (	76	,	0.050828898	,	0.976710739	),
  (	76	,	0.074525726	,	0.993257839	),
  (	76	,	0.055649889	,	0.998808297	),
  (	76	,	0.246526333	,	0.999837041	),
  (	76	,	0.214440878	,	1.009054515	),
  (	76	,	0.28103814	,	1.011959701	),
  (	76	,	0.80976089	,	0.775097176	),
  (	76	,	0.834437911	,	0.785727014	),
  (	76	,	0.815058828	,	0.79849693	),
  (	76	,	0.776235469	,	0.814389374	),
  (	76	,	0.844943544	,	0.817112746	),
  (	76	,	0.862726675	,	0.878962092	),
  (	76	,	0.699720281	,	0.921603625	),
  (	76	,	0.700567005	,	0.982121215	),
  (	76	,	0.596144839	,	0.920168139	),
  (	76	,	0.568992892	,	0.982564883	),
  (	76	,	0.633644798	,	0.964373051	),
  (	76	,	0.68363433	,	0.980817801	),
  (	76	,	0.623482244	,	0.999116268	),
  (	76	,	0.643272742	,	1.031575925	),
  (	76	,	0.634623914	,	1.047289283	),
  (	76	,	0.824002276	,	1.018356251	),
  (	76	,	0.90238291	,	1.054265643	),
  (	76	,	0.853645292	,	1.066883773	),
  (	76	,	0.711896571	,	1.027814535	),
  (	76	,	0.668573291	,	1.047186058	),
  (	76	,	0.69403521	,	1.092146281	),
  (	76	,	0.741630633	,	1.128019588	),
  (	76	,	0.768140136	,	1.148550791	),
  (	76	,	1.003840568	,	1.078561681	),
  (	76	,	1.075638086	,	1.112572264	),
  (	76	,	1.192318235	,	1.134250316	),
  (	76	,	1.246824126	,	1.104087622	),
  (	76	,	1.404420198	,	1.169793538	),
  (	76	,	1.395021958	,	1.186760582	),
  (	76	,	0.967799083	,	1.093421211	),
  (	76	,	0.942755737	,	1.10458619	),
  (	76	,	0.956090688	,	1.145983488	),
  (	76	,	1.109759508	,	1.213120674	),
  (	76	,	1.011113381	,	1.230596794	),
  (	76	,	1.371536677	,	1.21864087	),
  (	76	,	1.444123476	,	1.255315138	),
  (	76	,	1.165267571	,	1.252818817	),
  (	76	,	1.086691515	,	1.245182015	),
  (	76	,	1.127997992	,	1.263780022	),
  (	76	,	0.52209311	,	1.047332318	),
  (	76	,	0.505730993	,	1.088447903	),
  (	76	,	0.40644302	,	1.055043167	),
  (	76	,	0.42230455	,	1.106790687	),
  (	76	,	0.398370569	,	1.105623681	),
  (	76	,	0.613517219	,	1.114810533	),
  (	76	,	0.687536256	,	1.205267517	),
  (	76	,	0.535222134	,	1.244384521	),
  (	76	,	0.319805503	,	1.096567045	),
  (	76	,	0.079607199	,	1.273160413	),
  (	76	,	0.858108958	,	1.221363694	),
  (	76	,	0.705179325	,	1.216661667	),
  (	76	,	0.896418872	,	1.251133518	),
  (	76	,	0.92365864	,	1.36161216	),
  (	76	,	1.143640268	,	1.424745426	),
  (	76	,	0.549968406	,	1.301731587	),
  (	76	,	0.632008044	,	1.328756101	),
  (	76	,	0.618644692	,	1.365787335	),
  (	76	,	0.556510024	,	1.407867176	),
  (	76	,	0.218501456	,	1.430597695	),
  (	76	,	1.307342125	,	1.452047537	),
  (	76	,	0.906500485	,	1.45784397	),
  (	76	,	1.198211548	,	1.474318847	),
  (	76	,	2.309091059	,	0.060827745	),
  (	76	,	2.466927048	,	0.109225368	),
  (	76	,	2.475197653	,	0.108765885	),
  (	76	,	2.498172204	,	0.123279308	),
  (	76	,	2.50756336	,	0.142897963	),
  (	76	,	2.387504127	,	0.168796832	),
  (	76	,	2.171538774	,	0.159951389	),
  (	76	,	2.274513124	,	0.192836551	),
  (	76	,	2.242600126	,	0.184760285	),
  (	76	,	2.247410683	,	0.196931947	),
  (	76	,	2.377871542	,	0.232893721	),
  (	76	,	2.391565227	,	0.245085684	),
  (	76	,	2.391708414	,	0.256761169	),
  (	76	,	2.317705837	,	0.279244345	),
  (	76	,	2.603259355	,	0.256970291	),
  (	76	,	2.588690801	,	0.347977221	),
  (	76	,	2.472144364	,	0.332660579	),
  (	76	,	2.494652867	,	0.349149128	),
  (	76	,	2.493994706	,	0.353789014	),
  (	76	,	2.557868117	,	0.357604655	),
  (	76	,	2.591746763	,	0.483376476	),
  (	76	,	2.553301339	,	0.484175305	),
  (	76	,	2.157804731	,	0.177819759	),
  (	76	,	2.166596153	,	0.192743403	),
  (	76	,	2.107274681	,	0.225920712	),
  (	76	,	2.14506345	,	0.283053106	),
  (	76	,	2.138093539	,	0.296992886	),
  (	76	,	2.268761291	,	0.34106156	),
  (	76	,	2.270239416	,	0.340896064	),
  (	76	,	2.07180639	,	0.315906566	),
  (	76	,	2.103463466	,	0.344478071	),
  (	76	,	2.113886494	,	0.366662624	),
  (	76	,	2.188071295	,	0.382385781	),
  (	76	,	2.203123345	,	0.417931762	),
  (	76	,	2.2308091	,	0.449251749	),
  (	76	,	2.351085891	,	0.443383822	),
  (	76	,	2.468552061	,	0.571807908	),
  (	76	,	2.448653772	,	0.609952892	),
  (	76	,	2.311491629	,	0.513976568	),
  (	76	,	2.325655279	,	0.522923045	),
  (	76	,	2.235279814	,	0.511715952	),
  (	76	,	2.199539728	,	0.546302397	),
  (	76	,	2.279902167	,	0.596653827	),
  (	76	,	2.439077795	,	0.622775834	),
  (	76	,	2.311984107	,	0.588524258	),
  (	76	,	2.366302693	,	0.674681794	),
  (	76	,	2.340373514	,	0.677384709	),
  (	76	,	2.765415055	,	0.407545063	),
  (	76	,	2.848435433	,	0.486342712	),
  (	76	,	2.838636574	,	0.55898527	),
  (	76	,	2.677786594	,	0.45641393	),
  (	76	,	2.605971421	,	0.498489406	),
  (	76	,	2.627170371	,	0.550317516	),
  (	76	,	2.636612959	,	0.566398663	),
  (	76	,	2.753467951	,	0.681035495	),
  (	76	,	2.91729757	,	0.62850831	),
  (	76	,	2.900428128	,	0.667530038	),
  (	76	,	3.049229011	,	0.683691117	),
  (	76	,	3.053593313	,	0.788130326	),
  (	76	,	2.867175142	,	0.721699691	),
  (	76	,	2.909316928	,	0.769959686	),
  (	76	,	2.947332771	,	0.828672967	),
  (	76	,	2.716470427	,	0.743795741	),
  (	76	,	2.74863569	,	0.800269263	),
  (	76	,	2.765711284	,	0.858476167	),
  (	76	,	2.939031417	,	0.96718973	),
  (	76	,	2.960639702	,	0.980782167	),
  (	76	,	3.020846102	,	0.979058892	),
  (	76	,	2.749716798	,	0.889998639	),
  (	76	,	2.748009544	,	0.956890967	),
  (	76	,	2.890735027	,	0.960441705	),
  (	76	,	3.138318232	,	1.070485044	),
  (	76	,	3.04302357	,	1.085532146	),
  (	76	,	3.085192344	,	1.123874479	),
  (	76	,	1.967957067	,	0.356779297	),
  (	76	,	1.964570139	,	0.362755621	),
  (	76	,	2.014010084	,	0.386019818	),
  (	76	,	2.034057956	,	0.411001363	),
  (	76	,	1.926611478	,	0.456563547	),
  (	76	,	1.95395268	,	0.476330737	),
  (	76	,	1.983003804	,	0.49586047	),
  (	76	,	2.072147304	,	0.563469099	),
  (	76	,	2.038769501	,	0.57615062	),
  (	76	,	2.039295768	,	0.585799725	),
  (	76	,	1.887223736	,	0.463634664	),
  (	76	,	1.88852667	,	0.475155848	),
  (	76	,	1.888523755	,	0.475153681	),
  (	76	,	1.869102377	,	0.580632635	),
  (	76	,	1.945725448	,	0.573531752	),
  (	76	,	1.955554335	,	0.70958718	),
  (	76	,	2.136558438	,	0.623118159	),
  (	76	,	2.091855389	,	0.605277758	),
  (	76	,	2.229984248	,	0.668313191	),
  (	76	,	2.22831952	,	0.815936156	),
  (	76	,	2.100401451	,	0.713085135	),
  (	76	,	2.065518145	,	0.798337736	),
  (	76	,	2.175474113	,	0.820893661	),
  (	76	,	2.089829828	,	0.848674485	),
  (	76	,	2.043521308	,	0.868419057	),
  (	76	,	2.141300345	,	0.910058187	),
  (	76	,	1.730495922	,	0.582774433	),
  (	76	,	1.763637835	,	0.645665318	),
  (	76	,	1.872278494	,	0.77247863	),
  (	76	,	1.796801664	,	0.811577133	),
  (	76	,	1.742439593	,	0.733117592	),
  (	76	,	1.721944663	,	0.751628293	),
  (	76	,	1.575611319	,	0.731956397	),
  (	76	,	1.621007285	,	0.770294426	),
  (	76	,	1.619752237	,	0.784561136	),
  (	76	,	1.596124628	,	0.779982192	),
  (	76	,	1.769277673	,	0.771995116	),
  (	76	,	1.584462103	,	0.837535369	),
  (	76	,	1.640959862	,	0.910816006	),
  (	76	,	1.929682227	,	0.875256716	),
  (	76	,	1.995141944	,	0.939693571	),
  (	76	,	2.03342704	,	0.971139197	),
  (	76	,	1.932505791	,	0.96587703	),
  (	76	,	1.908233072	,	1.013147114	),
  (	76	,	1.750005528	,	0.93198043	),
  (	76	,	1.668674247	,	0.977608367	),
  (	76	,	1.642210601	,	0.990206648	),
  (	76	,	1.641459413	,	0.993669589	),
  (	76	,	1.770848929	,	1.093441832	),
  (	76	,	1.677935629	,	1.041943665	),
  (	76	,	1.653919274	,	1.039501131	),
  (	76	,	1.684632455	,	1.094147722	),
  (	76	,	2.453841654	,	0.844909232	),
  (	76	,	2.568129422	,	0.947099303	),
  (	76	,	2.421028372	,	0.970753275	),
  (	76	,	2.526414169	,	1.021858746	),
  (	76	,	2.233644753	,	0.883386729	),
  (	76	,	2.216220456	,	0.933002564	),
  (	76	,	2.106505727	,	0.944768856	),
  (	76	,	2.138938844	,	0.973961868	),
  (	76	,	2.230371819	,	0.959229958	),
  (	76	,	2.461758915	,	1.055000025	),
  (	76	,	2.342724427	,	1.143643822	),
  (	76	,	2.631907805	,	1.013981331	),
  (	76	,	2.633272445	,	1.091966029	),
  (	76	,	2.750073039	,	1.105645402	),
  (	76	,	3.008114989	,	1.168077535	),
  (	76	,	3.094363756	,	1.175104479	),
  (	76	,	2.591366884	,	1.130776466	),
  (	76	,	2.415969267	,	1.148373876	),
  (	76	,	2.492182369	,	1.17881561	),
  (	76	,	2.532976406	,	1.196189004	),
  (	76	,	2.945135308	,	1.256785266	),
  (	76	,	2.767316882	,	1.288652113	),
  (	76	,	2.061546503	,	0.995145519	),
  (	76	,	1.956507686	,	1.079962297	),
  (	76	,	1.931191115	,	1.097216583	),
  (	76	,	2.056335817	,	1.118556348	),
  (	76	,	2.199999087	,	1.08734736	),
  (	76	,	2.136088571	,	1.145992936	),
  (	76	,	2.209231849	,	1.223968467	),
  (	76	,	2.081854322	,	1.251055324	),
  (	76	,	1.886989893	,	1.086680958	),
  (	76	,	1.916787288	,	1.119026161	),
  (	76	,	1.940281391	,	1.149093248	),
  (	76	,	1.749660651	,	1.134235428	),
  (	76	,	1.640799743	,	1.235317805	),
  (	76	,	1.622712927	,	1.241469567	),
  (	76	,	1.942442774	,	1.171937993	),
  (	76	,	1.844283753	,	1.207909612	),
  (	76	,	1.945761877	,	1.288939643	),
  (	76	,	1.593760626	,	1.291535125	),
  (	76	,	2.457749032	,	1.210436912	),
  (	76	,	2.470482678	,	1.227827585	),
  (	76	,	2.533170932	,	1.252360877	),
  (	76	,	2.518267188	,	1.25802749	),
  (	76	,	2.30005405	,	1.263355761	),
  (	76	,	2.534492225	,	1.316503748	),
  (	76	,	2.979337286	,	1.350422138	),
  (	76	,	2.719842681	,	1.367337419	),
  (	76	,	1.730473826	,	1.360043209	),
  (	76	,	1.976942142	,	1.373333687	),
  (	76	,	1.775982648	,	1.400492248	),
  (	76	,	2.340300249	,	1.464097254	),
  (	76	,	2.674414927	,	1.438165031	),
  (	76	,	2.143084351	,	1.473184495	),
  (	76	,	1.844316253	,	1.477654461	),
  (	76	,	2.19684523	,	1.495606222	),
  (	76	,	3.977153886	,	0.049362973	),
  (	76	,	3.96002956	,	0.109417882	),
  (	76	,	3.882209325	,	0.06755301	),
  (	76	,	4.106207043	,	0.162359303	),
  (	76	,	3.977488927	,	0.14865061	),
  (	76	,	3.978901033	,	0.170634118	),
  (	76	,	3.796696257	,	0.145787724	),
  (	76	,	3.770338461	,	0.196296435	),
  (	76	,	3.821488962	,	0.193176446	),
  (	76	,	4.159297175	,	0.215603041	),
  (	76	,	4.174640606	,	0.217780674	),
  (	76	,	4.192726574	,	0.231622709	),
  (	76	,	4.196976339	,	0.235140315	),
  (	76	,	4.200230356	,	0.316150706	),
  (	76	,	4.123045144	,	0.374291261	),
  (	76	,	4.058654954	,	0.414605251	),
  (	76	,	4.057460475	,	0.415685714	),
  (	76	,	4.123141461	,	0.431245171	),
  (	76	,	4.13502438	,	0.496891726	),
  (	76	,	3.764795716	,	0.26073272	),
  (	76	,	3.788475205	,	0.281301121	),
  (	76	,	3.660142882	,	0.254172177	),
  (	76	,	3.865464082	,	0.293183055	),
  (	76	,	3.878375497	,	0.317643141	),
  (	76	,	3.872588105	,	0.332486041	),
  (	76	,	3.791542152	,	0.362470551	),
  (	76	,	3.850116946	,	0.371630187	),
  (	76	,	3.655893903	,	0.282773863	),
  (	76	,	3.706737603	,	0.357293924	),
  (	76	,	3.754851439	,	0.463781809	),
  (	76	,	3.921871811	,	0.437169306	),
  (	76	,	4.02633172	,	0.489687651	),
  (	76	,	3.789649123	,	0.493743797	),
  (	76	,	3.947606601	,	0.673792484	),
  (	76	,	4.296795188	,	0.390656373	),
  (	76	,	4.38528456	,	0.41394847	),
  (	76	,	4.428871177	,	0.50682252	),
  (	76	,	4.3692426	,	0.52836221	),
  (	76	,	4.379214203	,	0.570586246	),
  (	76	,	4.23289465	,	0.444847401	),
  (	76	,	4.237364628	,	0.469348266	),
  (	76	,	4.263641504	,	0.513624589	),
  (	76	,	4.183314161	,	0.523680739	),
  (	76	,	4.154046591	,	0.521533518	),
  (	76	,	4.236340299	,	0.540776434	),
  (	76	,	4.242409404	,	0.569947173	),
  (	76	,	4.4012422	,	0.626958457	),
  (	76	,	4.388648439	,	0.621877504	),
  (	76	,	4.532656236	,	0.573586763	),
  (	76	,	4.545037113	,	0.625246655	),
  (	76	,	4.528321021	,	0.629962351	),
  (	76	,	4.524322771	,	0.688872471	),
  (	76	,	4.525332553	,	0.697578875	),
  (	76	,	4.686313147	,	0.7443326	),
  (	76	,	4.558129135	,	0.684338028	),
  (	76	,	4.452914073	,	0.679073372	),
  (	76	,	4.402735614	,	0.727166249	),
  (	76	,	4.452660834	,	0.798999216	),
  (	76	,	4.474275064	,	0.809063047	),
  (	76	,	4.591200312	,	0.808617611	),
  (	76	,	4.61667137	,	0.795134219	),
  (	76	,	4.663395188	,	0.852343632	),
  (	76	,	4.610158593	,	0.845730086	),
  (	76	,	4.608948774	,	0.862988219	),
  (	76	,	4.704055649	,	0.911378087	),
  (	76	,	4.214151945	,	0.637538156	),
  (	76	,	4.236730614	,	0.751454925	),
  (	76	,	4.002530377	,	0.742917365	),
  (	76	,	4.128689688	,	0.741215825	),
  (	76	,	4.233590527	,	0.848426708	),
  (	76	,	4.080785747	,	0.86739949	),
  (	76	,	4.309063473	,	0.826265496	),
  (	76	,	4.653508925	,	0.935124332	),
  (	76	,	4.701571168	,	0.954090955	),
  (	76	,	4.289672518	,	0.87867151	),
  (	76	,	4.311048998	,	0.900453362	),
  (	76	,	4.393265381	,	0.967086406	),
  (	76	,	4.696846608	,	1.092916107	),
  (	76	,	4.582919941	,	1.113130643	),
  (	76	,	4.662968261	,	1.130394739	),
  (	76	,	3.589138533	,	0.406981467	),
  (	76	,	3.507141985	,	0.445896703	),
  (	76	,	3.640855601	,	0.522127033	),
  (	76	,	3.614290833	,	0.548051641	),
  (	76	,	3.420053991	,	0.541074292	),
  (	76	,	3.728703248	,	0.685503879	),
  (	76	,	3.743578439	,	0.696610211	),
  (	76	,	3.64185721	,	0.646888204	),
  (	76	,	3.647236252	,	0.688758742	),
  (	76	,	3.78617624	,	0.862133379	),
  (	76	,	3.638692828	,	0.835538083	),
  (	76	,	3.615466827	,	0.843979177	),
  (	76	,	3.649640066	,	0.855425914	),
  (	76	,	3.31084237	,	0.686050322	),
  (	76	,	3.428601731	,	0.69123067	),
  (	76	,	3.183522029	,	0.702524749	),
  (	76	,	3.143372146	,	0.778947236	),
  (	76	,	3.288400681	,	0.769616583	),
  (	76	,	3.264057867	,	0.781807644	),
  (	76	,	3.298168724	,	0.799031094	),
  (	76	,	3.233384843	,	0.794378812	),
  (	76	,	3.258647888	,	0.893709604	),
  (	76	,	3.612519503	,	0.876846392	),
  (	76	,	3.563111253	,	0.895257054	),
  (	76	,	3.629597921	,	0.922232697	),
  (	76	,	3.423750998	,	0.939994265	),
  (	76	,	3.315464884	,	0.902771153	),
  (	76	,	3.18237545	,	0.931896362	),
  (	76	,	3.327153733	,	0.994812931	),
  (	76	,	3.311585433	,	1.065155531	),
  (	76	,	3.230841204	,	1.070054203	),
  (	76	,	3.903266885	,	0.813210136	),
  (	76	,	3.959025936	,	0.920534949	),
  (	76	,	4.011649603	,	0.876412416	),
  (	76	,	4.034277668	,	0.946187585	),
  (	76	,	4.034286274	,	0.946185226	),
  (	76	,	3.983558856	,	0.978194724	),
  (	76	,	4.096761503	,	1.002895781	),
  (	76	,	3.804112103	,	0.890489236	),
  (	76	,	3.848504464	,	0.907664546	),
  (	76	,	3.967891309	,	0.996783149	),
  (	76	,	3.844180942	,	1.011534655	),
  (	76	,	3.791579369	,	1.053941937	),
  (	76	,	4.151585826	,	0.997318258	),
  (	76	,	4.267752549	,	1.089486353	),
  (	76	,	4.436676564	,	1.072944107	),
  (	76	,	4.434974377	,	1.13515299	),
  (	76	,	4.447524559	,	1.198672705	),
  (	76	,	4.565288092	,	1.182739377	),
  (	76	,	4.517096349	,	1.176141562	),
  (	76	,	4.609830868	,	1.195354287	),
  (	76	,	4.027424732	,	1.101834886	),
  (	76	,	4.095777587	,	1.201180837	),
  (	76	,	4.611196363	,	1.257593326	),
  (	76	,	4.283253174	,	1.230410013	),
  (	76	,	4.452619804	,	1.277480696	),
  (	76	,	4.549541398	,	1.303119897	),
  (	76	,	4.404885165	,	1.315622945	),
  (	76	,	3.677336095	,	1.076503926	),
  (	76	,	3.642281102	,	1.088685162	),
  (	76	,	3.763284801	,	1.064042438	),
  (	76	,	3.837005178	,	1.119699891	),
  (	76	,	3.659206628	,	1.153679866	),
  (	76	,	3.742677056	,	1.199952741	),
  (	76	,	3.645391139	,	1.220598341	),
  (	76	,	3.453064681	,	1.102107248	),
  (	76	,	3.319632981	,	1.113025744	),
  (	76	,	3.497255669	,	1.116147125	),
  (	76	,	3.473528987	,	1.146531565	),
  (	76	,	3.388869215	,	1.197572838	),
  (	76	,	3.395466776	,	1.199139551	),
  (	76	,	3.165844387	,	1.200683703	),
  (	76	,	3.298068316	,	1.204514199	),
  (	76	,	3.288102606	,	1.264994682	),
  (	76	,	3.949337065	,	1.28966026	),
  (	76	,	4.334219011	,	1.355900537	),
  (	76	,	4.663775821	,	1.384624158	),
  (	76	,	4.006363121	,	1.368231062	),
  (	76	,	3.835058576	,	1.392553009	),
  (	76	,	4.016581864	,	1.414477864	),
  (	76	,	4.188959238	,	1.455677252	),
  (	76	,	5.46711885	,	0.03428336	),
  (	76	,	5.479385831	,	0.133793796	),
  (	76	,	5.567725783	,	0.186496419	),
  (	76	,	5.625196098	,	0.208610229	),
  (	76	,	5.567022681	,	0.200337013	),
  (	76	,	5.389789624	,	0.10959802	),
  (	76	,	5.357747921	,	0.120080933	),
  (	76	,	5.405903824	,	0.148752318	),
  (	76	,	5.477255977	,	0.1696713	),
  (	76	,	5.453148742	,	0.200623093	),
  (	76	,	5.3374919	,	0.193468681	),
  (	76	,	5.360094561	,	0.204566709	),
  (	76	,	5.50104013	,	0.17445987	),
  (	76	,	5.443820802	,	0.226657141	),
  (	76	,	5.430801375	,	0.236584375	),
  (	76	,	5.468240395	,	0.285215903	),
  (	76	,	5.728318756	,	0.235422191	),
  (	76	,	5.641718334	,	0.21885413	),
  (	76	,	5.701653306	,	0.339938837	),
  (	76	,	5.781313398	,	0.395085088	),
  (	76	,	5.555713279	,	0.295292874	),
  (	76	,	5.703825224	,	0.384403738	),
  (	76	,	5.676916688	,	0.38737232	),
  (	76	,	5.677180754	,	0.466876176	),
  (	76	,	5.689369128	,	0.486018792	),
  (	76	,	5.675469338	,	0.501885085	),
  (	76	,	5.349394899	,	0.260807823	),
  (	76	,	5.264632365	,	0.221335431	),
  (	76	,	5.237415091	,	0.228653248	),
  (	76	,	5.286766287	,	0.255670045	),
  (	76	,	5.268042392	,	0.280583323	),
  (	76	,	5.243891942	,	0.288191692	),
  (	76	,	5.420028675	,	0.342574087	),
  (	76	,	5.385531169	,	0.340874241	),
  (	76	,	5.182155951	,	0.277641242	),
  (	76	,	5.187850883	,	0.290205906	),
  (	76	,	5.194695506	,	0.301397484	),
  (	76	,	5.203905149	,	0.327086282	),
  (	76	,	5.28492539	,	0.337980867	),
  (	76	,	5.220703788	,	0.334883765	),
  (	76	,	5.235680534	,	0.347136693	),
  (	76	,	5.149519815	,	0.31240081	),
  (	76	,	5.134011728	,	0.354876537	),
  (	76	,	5.146589082	,	0.372513689	),
  (	76	,	5.317146778	,	0.37560954	),
  (	76	,	5.279068267	,	0.364712388	),
  (	76	,	5.357253079	,	0.456342857	),
  (	76	,	5.253118658	,	0.416214528	),
  (	76	,	5.274034386	,	0.458582462	),
  (	76	,	5.549766507	,	0.402826562	),
  (	76	,	5.450159863	,	0.448032281	),
  (	76	,	5.587825011	,	0.458147116	),
  (	76	,	5.600210028	,	0.543079153	),
  (	76	,	5.392626834	,	0.44468769	),
  (	76	,	5.3710061	,	0.465747831	),
  (	76	,	5.467554045	,	0.508684132	),
  (	76	,	5.466968847	,	0.511938096	),
  (	76	,	5.428229424	,	0.508698764	),
  (	76	,	5.408795644	,	0.537803741	),
  (	76	,	5.416213897	,	0.54541714	),
  (	76	,	5.532360537	,	0.582886684	),
  (	76	,	5.427414224	,	0.594640998	),
  (	76	,	5.41789063	,	0.620395564	),
  (	76	,	5.834522911	,	0.390732892	),
  (	76	,	5.846411936	,	0.448964674	),
  (	76	,	5.99438892	,	0.499608812	),
  (	76	,	6.038891522	,	0.560482406	),
  (	76	,	5.936079071	,	0.492378722	),
  (	76	,	5.951339149	,	0.510978365	),
  (	76	,	5.928377553	,	0.518561712	),
  (	76	,	5.919936911	,	0.537409512	),
  (	76	,	5.993392541	,	0.536909227	),
  (	76	,	5.949775482	,	0.572852449	),
  (	76	,	5.843023655	,	0.483137039	),
  (	76	,	5.809270567	,	0.510588254	),
  (	76	,	5.790658272	,	0.529144901	),
  (	76	,	5.800495986	,	0.613115159	),
  (	76	,	5.877460062	,	0.540296578	),
  (	76	,	5.903416282	,	0.618505602	),
  (	76	,	5.849116463	,	0.612863332	),
  (	76	,	5.866296189	,	0.618422404	),
  (	76	,	6.073411971	,	0.570126399	),
  (	76	,	6.016950625	,	0.594576139	),
  (	76	,	6.114279682	,	0.673386395	),
  (	76	,	6.086761212	,	0.718069582	),
  (	76	,	6.150543382	,	0.674454296	),
  (	76	,	6.149162175	,	0.739322747	),
  (	76	,	6.173394176	,	0.754007327	),
  (	76	,	6.069480848	,	0.761937532	),
  (	76	,	5.932637305	,	0.736546179	),
  (	76	,	6.108116486	,	0.749855098	),
  (	76	,	6.115778277	,	0.769679748	),
  (	76	,	6.08437143	,	0.762665093	),
  (	76	,	6.226069262	,	0.851749979	),
  (	76	,	6.117602762	,	0.851636301	),
  (	76	,	6.158510397	,	0.864077634	),
  (	76	,	6.222405791	,	0.884240001	),
  (	76	,	5.716349855	,	0.555851666	),
  (	76	,	5.663281361	,	0.579463967	),
  (	76	,	5.726244768	,	0.600052815	),
  (	76	,	5.637752705	,	0.596932187	),
  (	76	,	5.64434926	,	0.672430776	),
  (	76	,	5.682127164	,	0.689866662	),
  (	76	,	5.683480266	,	0.716413101	),
  (	76	,	5.751322941	,	0.679401766	),
  (	76	,	5.784541235	,	0.721733837	),
  (	76	,	5.760397537	,	0.743223184	),
  (	76	,	5.762241097	,	0.76977912	),
  (	76	,	5.808284353	,	0.759694084	),
  (	76	,	5.827162681	,	0.763549594	),
  (	76	,	5.842651843	,	0.802939451	),
  (	76	,	5.850596206	,	0.80393175	),
  (	76	,	5.794017942	,	0.771544237	),
  (	76	,	5.634740238	,	0.699264085	),
  (	76	,	5.560250997	,	0.718148815	),
  (	76	,	5.615656392	,	0.754517991	),
  (	76	,	5.805723663	,	0.836252072	),
  (	76	,	5.807542956	,	0.856043103	),
  (	76	,	5.817659362	,	0.861742072	),
  (	76	,	5.736082701	,	0.823021578	),
  (	76	,	5.738667482	,	0.828166921	),
  (	76	,	5.758272246	,	0.857359896	),
  (	76	,	5.775830044	,	0.868682203	),
  (	76	,	5.786459749	,	0.877650733	),
  (	76	,	5.669042762	,	0.805913419	),
  (	76	,	5.621735914	,	0.845335796	),
  (	76	,	5.636295756	,	0.846209225	),
  (	76	,	5.663547362	,	0.846260407	),
  (	76	,	5.747799201	,	0.881207739	),
  (	76	,	5.91064302	,	0.785485084	),
  (	76	,	5.8518068	,	0.841946027	),
  (	76	,	5.865238715	,	0.852102279	),
  (	76	,	6.073719258	,	0.858939111	),
  (	76	,	6.09265577	,	0.881181358	),
  (	76	,	6.1208266	,	0.890948894	),
  (	76	,	6.1990666	,	0.962532417	),
  (	76	,	6.262463315	,	1.013855006	),
  (	76	,	6.164482614	,	1.010643224	),
  (	76	,	5.886422243	,	0.898989188	),
  (	76	,	5.881332575	,	0.900164513	),
  (	76	,	5.836558489	,	0.895669364	),
  (	76	,	5.944597066	,	0.946812842	),
  (	76	,	5.946623833	,	0.955698167	),
  (	76	,	5.845426316	,	0.980945195	),
  (	76	,	6.008487058	,	0.9859427	),
  (	76	,	6.158383932	,	1.037816794	),
  (	76	,	6.143132743	,	1.041877678	),
  (	76	,	6.168002431	,	1.048079969	),
  (	76	,	6.167973621	,	1.055376021	),
  (	76	,	6.028783137	,	1.050641169	),
  (	76	,	6.155865674	,	1.087141735	),
  (	76	,	6.141059188	,	1.115778256	),
  (	76	,	5.119422886	,	0.356300023	),
  (	76	,	5.104561568	,	0.396305538	),
  (	76	,	5.130389056	,	0.450536903	),
  (	76	,	5.058264473	,	0.406732757	),
  (	76	,	5.050620284	,	0.440494379	),
  (	76	,	5.061995892	,	0.46534444	),
  (	76	,	5.107803474	,	0.438440609	),
  (	76	,	5.122706948	,	0.450394645	),
  (	76	,	5.226381628	,	0.458916707	),
  (	76	,	5.234664117	,	0.539549579	),
  (	76	,	5.254742734	,	0.557387709	),
  (	76	,	5.180542676	,	0.538262928	),
  (	76	,	5.135063756	,	0.529271218	),
  (	76	,	5.142811999	,	0.544877541	),
  (	76	,	5.010296207	,	0.44286289	),
  (	76	,	4.996237086	,	0.45096014	),
  (	76	,	4.999811654	,	0.508123783	),
  (	76	,	5.047163541	,	0.543484903	),
  (	76	,	4.930794324	,	0.520374187	),
  (	76	,	4.955952728	,	0.529044497	),
  (	76	,	4.951816127	,	0.543621604	),
  (	76	,	4.95345416	,	0.565489113	),
  (	76	,	5.067775114	,	0.570334577	),
  (	76	,	5.127447918	,	0.596898536	),
  (	76	,	5.157280314	,	0.632256238	),
  (	76	,	5.154773441	,	0.671217691	),
  (	76	,	5.054799236	,	0.592462541	),
  (	76	,	5.036269218	,	0.597165893	),
  (	76	,	5.087514479	,	0.631573988	),
  (	76	,	5.060436985	,	0.641660927	),
  (	76	,	5.314521829	,	0.579298977	),
  (	76	,	5.275500248	,	0.579219176	),
  (	76	,	5.282401404	,	0.590893386	),
  (	76	,	5.362951481	,	0.625370464	),
  (	76	,	5.316531745	,	0.632755505	),
  (	76	,	5.31940529	,	0.641441182	),
  (	76	,	5.274301822	,	0.630896301	),
  (	76	,	5.268460662	,	0.638227723	),
  (	76	,	5.228255735	,	0.60079041	),
  (	76	,	5.301788714	,	0.657919474	),
  (	76	,	5.3267707	,	0.667701153	),
  (	76	,	5.290755046	,	0.702812029	),
  (	76	,	5.37316989	,	0.697066551	),
  (	76	,	5.449837755	,	0.694494785	),
  (	76	,	5.448546876	,	0.728898848	),
  (	76	,	5.418991518	,	0.742203248	),
  (	76	,	5.371452927	,	0.705576838	),
  (	76	,	5.369156972	,	0.706978191	),
  (	76	,	5.336836096	,	0.712103248	),
  (	76	,	5.354836756	,	0.753065351	),
  (	76	,	5.379030404	,	0.785030903	),
  (	76	,	5.384214466	,	0.810116011	),
  (	76	,	5.166252853	,	0.663346967	),
  (	76	,	5.249224397	,	0.701153062	),
  (	76	,	5.212375097	,	0.723687177	),
  (	76	,	5.214050741	,	0.730818625	),
  (	76	,	5.144906741	,	0.709071475	),
  (	76	,	5.174084148	,	0.707822648	),
  (	76	,	5.180976717	,	0.741467829	),
  (	76	,	5.133615212	,	0.715752495	),
  (	76	,	5.163445647	,	0.824575437	),
  (	76	,	5.280592426	,	0.767005494	),
  (	76	,	5.33054943	,	0.782155626	),
  (	76	,	5.269032691	,	0.788074188	),
  (	76	,	5.24375505	,	0.793719294	),
  (	76	,	5.367253745	,	0.848953793	),
  (	76	,	5.260729567	,	0.84765147	),
  (	76	,	5.274561957	,	0.853659029	),
  (	76	,	5.250060897	,	0.88077671	),
  (	76	,	5.296158853	,	0.894307751	),
  (	76	,	4.91841697	,	0.548133116	),
  (	76	,	4.90831172	,	0.579227362	),
  (	76	,	4.972933765	,	0.595072771	),
  (	76	,	4.951778475	,	0.593079113	),
  (	76	,	4.848739651	,	0.586954792	),
  (	76	,	4.861399071	,	0.601232377	),
  (	76	,	4.880067351	,	0.629241171	),
  (	76	,	4.885617367	,	0.663110709	),
  (	76	,	4.870413705	,	0.663826642	),
  (	76	,	4.961561813	,	0.677159755	),
  (	76	,	5.010054041	,	0.683381961	),
  (	76	,	5.059843141	,	0.702794213	),
  (	76	,	5.09377586	,	0.737037377	),
  (	76	,	4.938457553	,	0.723703511	),
  (	76	,	4.932813481	,	0.748960917	),
  (	76	,	4.940476854	,	0.762881179	),
  (	76	,	4.839223632	,	0.766903885	),
  (	76	,	4.747676063	,	0.714096843	),
  (	76	,	4.723324372	,	0.755181187	),
  (	76	,	4.717273623	,	0.791525521	),
  (	76	,	4.741392391	,	0.807620639	),
  (	76	,	4.871396589	,	0.764395502	),
  (	76	,	4.840578165	,	0.802537253	),
  (	76	,	4.780324317	,	0.830090848	),
  (	76	,	4.765856755	,	0.839847544	),
  (	76	,	4.736192753	,	0.861206729	),
  (	76	,	5.079310737	,	0.81050348	),
  (	76	,	5.118808113	,	0.803540188	),
  (	76	,	5.089708539	,	0.837231976	),
  (	76	,	5.034804861	,	0.843853298	),
  (	76	,	4.99067933	,	0.866257994	),
  (	76	,	5.063747337	,	0.878606481	),
  (	76	,	5.086875986	,	0.887527196	),
  (	76	,	5.13796918	,	0.959193979	),
  (	76	,	5.074376387	,	0.961123045	),
  (	76	,	4.881925558	,	0.913573358	),
  (	76	,	4.796611217	,	0.918948471	),
  (	76	,	4.750112761	,	1.011935341	),
  (	76	,	5.000072645	,	1.048935714	),
  (	76	,	4.905917066	,	1.081033549	),
  (	76	,	4.732295351	,	1.113456788	),
  (	76	,	4.774366436	,	1.130144005	),
  (	76	,	5.503193204	,	0.763089195	),
  (	76	,	5.488562271	,	0.781699727	),
  (	76	,	5.490885286	,	0.813400945	),
  (	76	,	5.539573934	,	0.798286991	),
  (	76	,	5.54351551	,	0.831731823	),
  (	76	,	5.527147986	,	0.841058405	),
  (	76	,	5.523694019	,	0.838534142	),
  (	76	,	5.529669239	,	0.869005566	),
  (	76	,	5.447343902	,	0.79328905	),
  (	76	,	5.460749793	,	0.832658888	),
  (	76	,	5.613351381	,	0.920624882	),
  (	76	,	5.708033005	,	0.926593125	),
  (	76	,	5.672405971	,	0.941936324	),
  (	76	,	5.645106347	,	0.947991351	),
  (	76	,	5.560504934	,	0.954108033	),
  (	76	,	5.550197284	,	0.979837879	),
  (	76	,	5.699707554	,	1.013380791	),
  (	76	,	5.589808393	,	0.986837724	),
  (	76	,	5.391160919	,	0.880083759	),
  (	76	,	5.364039945	,	0.880699744	),
  (	76	,	5.319005133	,	0.907169048	),
  (	76	,	5.368273176	,	0.954375693	),
  (	76	,	5.373791623	,	0.983596555	),
  (	76	,	5.31553958	,	1.026414839	),
  (	76	,	5.348190861	,	1.050299075	),
  (	76	,	5.465003474	,	1.023722509	),
  (	76	,	5.644570631	,	1.05304757	),
  (	76	,	5.525808061	,	1.037408009	),
  (	76	,	5.403177615	,	1.028831138	),
  (	76	,	5.39425313	,	1.033466039	),
  (	76	,	5.425178225	,	1.103206942	),
  (	76	,	5.778500375	,	1.025939755	),
  (	76	,	5.691032994	,	1.063122316	),
  (	76	,	5.743297699	,	1.097718095	),
  (	76	,	5.938164255	,	1.161100101	),
  (	76	,	5.697217303	,	1.087485291	),
  (	76	,	5.732964911	,	1.11242477	),
  (	76	,	5.791171269	,	1.192103573	),
  (	76	,	5.592580062	,	1.123375504	),
  (	76	,	5.599412131	,	1.134456232	),
  (	76	,	5.580046934	,	1.151730477	),
  (	76	,	5.545136587	,	1.164301503	),
  (	76	,	5.58834074	,	1.173226963	),
  (	76	,	6.001395537	,	1.226919217	),
  (	76	,	5.836102713	,	1.222755842	),
  (	76	,	5.86539019	,	1.244437867	),
  (	76	,	5.788907296	,	1.260624642	),
  (	76	,	6.201251237	,	1.319157054	),
  (	76	,	5.995694949	,	1.302223039	),
  (	76	,	5.28238853	,	1.001589816	),
  (	76	,	5.243663161	,	1.006213942	),
  (	76	,	5.224062355	,	1.09740991	),
  (	76	,	5.26553015	,	1.111891579	),
  (	76	,	5.231602717	,	1.177609282	),
  (	76	,	5.2807295	,	1.192036424	),
  (	76	,	5.108171428	,	1.199869083	),
  (	76	,	4.866210791	,	1.261421834	),
  (	76	,	4.882902625	,	1.273385008	),
  (	76	,	4.751165729	,	1.259302439	),
  (	76	,	4.943962132	,	1.293091927	),
  (	76	,	4.893245026	,	1.314238704	),
  (	76	,	5.548148058	,	1.236131794	),
  (	76	,	5.771829483	,	1.288490686	),
  (	76	,	5.79166611	,	1.304334269	),
  (	76	,	5.993646615	,	1.377098393	),
  (	76	,	5.623382544	,	1.360224082	),
  (	76	,	5.008025964	,	1.409419001	),
  (	76	,	5.002972744	,	1.409003726	),
  (	76	,	5.94757617	,	1.453348641	),
  (	76	,	5.831862298	,	1.474878576	),
  (	76	,	5.984615788	,	1.484339723	),
  (	76	,	5.267716992	,	1.434951345	),
  (	76	,	0.002360838	,	-0.710184311	),
  (	76	,	6.272195369	,	-0.64063573	),
  (	76	,	6.281342662	,	-0.553060253	),
  (	76	,	0.072178905	,	-0.571778427	),
  (	76	,	0.062554596	,	-0.480533366	),
  (	76	,	0.264239075	,	-0.449413433	),
  (	76	,	0.205069736	,	-0.422664514	),
  (	76	,	0.146630772	,	-0.455388501	),
  (	76	,	0.186208906	,	-0.352450113	),
  (	76	,	0.282844463	,	-0.361849697	),
  (	76	,	0.112178672	,	-0.377540215	),
  (	76	,	0.058063728	,	-0.359858538	),
  (	76	,	0.104702142	,	-0.310844934	),
  (	76	,	6.129215989	,	-0.477415978	),
  (	76	,	6.093414107	,	-0.472645861	),
  (	76	,	6.169768394	,	-0.433878895	),
  (	76	,	6.022803255	,	-0.456488601	),
  (	76	,	6.083026617	,	-0.343757093	),
  (	76	,	6.153456545	,	-0.381922102	),
  (	76	,	6.255441395	,	-0.35810432	),
  (	76	,	6.255986073	,	-0.320526393	),
  (	76	,	6.233053857	,	-0.329603634	),
  (	76	,	6.125543213	,	-0.310484629	),
  (	76	,	5.923205196	,	-0.355672317	),
  (	76	,	5.966218743	,	-0.281814324	),
  (	76	,	6.096232456	,	-0.31705748	),
  (	76	,	6.107249237	,	-0.275454558	),
  (	76	,	6.088350061	,	-0.201858388	),
  (	76	,	6.085535569	,	-0.169099168	),
  (	76	,	0.001980992	,	-0.291421464	),
  (	76	,	0.023739152	,	-0.251719571	),
  (	76	,	6.221545848	,	-0.257520735	),
  (	76	,	0.127299269	,	-0.202421578	),
  (	76	,	6.113897309	,	-0.151392657	),
  (	76	,	6.174412867	,	-0.133994813	),
  (	76	,	0.061181706	,	-0.068224213	),
  (	76	,	6.229319875	,	-0.077869664	),
  (	76	,	6.281388362	,	-0.032283597	),
  (	76	,	0.399911232	,	-0.332174812	),
  (	76	,	0.386623183	,	-0.201282773	),
  (	76	,	0.400531823	,	-0.179026294	),
  (	76	,	0.512788731	,	-0.11916619	),
  (	76	,	0.312125114	,	-0.224162385	),
  (	76	,	0.30369105	,	-0.203829941	),
  (	76	,	0.315308	,	-0.190942912	),
  (	76	,	0.251075436	,	-0.18283652	),
  (	76	,	0.289947142	,	-0.170460277	),
  (	76	,	0.244950317	,	-0.140041193	),
  (	76	,	0.324998268	,	-0.088109914	),
  (	76	,	0.578985244	,	-0.038890215	),
  (	76	,	0.685636945	,	-0.04073623	),
  (	76	,	0.661030137	,	0.019095092	),
  (	76	,	0.618166381	,	-0.002595102	),
  (	76	,	0.661152217	,	0.059994774	),
  (	76	,	0.493483728	,	-0.023201726	),
  (	76	,	0.445812089	,	0.040284253	),
  (	76	,	0.176323609	,	-0.133645401	),
  (	76	,	0.14480664	,	-0.067157414	),
  (	76	,	0.369512622	,	-0.016934251	),
  (	76	,	0.288403779	,	0.057150839	),
  (	76	,	0.038706454	,	0.01208637	),
  (	76	,	0.046593189	,	0.035878335	),
  (	76	,	0.2414095	,	0.119629876	),
  (	76	,	0.372352932	,	0.025489307	),
  (	76	,	0.359496784	,	0.09164981	),
  (	76	,	0.419083208	,	0.133438353	),
  (	76	,	0.419090673	,	0.133442473	),
  (	76	,	0.361931498	,	0.12951851	),
  (	76	,	0.47967125	,	0.126067166	),
  (	76	,	0.534905137	,	0.158503999	),
  (	76	,	0.442532304	,	0.158354535	),
  (	76	,	0.360940306	,	0.180971719	),
  (	76	,	5.927921507	,	-0.24551502	),
  (	76	,	5.970663927	,	-0.14158624	),
  (	76	,	5.796979602	,	-0.20269712	),
  (	76	,	5.772746493	,	-0.148353802	),
  (	76	,	5.824605854	,	-0.1175561	),
  (	76	,	5.823732492	,	-0.11171148	),
  (	76	,	5.815139991	,	-0.112901686	),
  (	76	,	5.852958017	,	-0.108964339	),
  (	76	,	6.086085322	,	-0.134441238	),
  (	76	,	6.11413451	,	-0.108078945	),
  (	76	,	6.058201848	,	-0.008724378	),
  (	76	,	6.0801705	,	0.016239246	),
  (	76	,	6.1138332	,	0.038346946	),
  (	76	,	6.079841207	,	0.046698521	),
  (	76	,	6.058826443	,	0.081646332	),
  (	76	,	6.043001917	,	0.080283497	),
  (	76	,	6.105775961	,	0.125923412	),
  (	76	,	5.707273348	,	-0.112806411	),
  (	76	,	5.743140511	,	-0.121823908	),
  (	76	,	5.840286723	,	-0.019595396	),
  (	76	,	5.783128095	,	0.004557172	),
  (	76	,	5.661856382	,	0.010154279	),
  (	76	,	5.592877549	,	0.035383144	),
  (	76	,	5.774479834	,	0.094956266	),
  (	76	,	5.715320399	,	0.090986242	),
  (	76	,	5.681674515	,	0.084375087	),
  (	76	,	5.637051926	,	0.092382855	),
  (	76	,	5.902220163	,	0.019266925	),
  (	76	,	5.902563925	,	0.052437974	),
  (	76	,	5.83592813	,	0.089782661	),
  (	76	,	5.874460404	,	0.137936984	),
  (	76	,	5.895526932	,	0.162657244	),
  (	76	,	5.998419572	,	0.126663776	),
  (	76	,	6.041744455	,	0.154512888	),
  (	76	,	5.943443767	,	0.193477671	),
  (	76	,	5.699916991	,	0.163056236	),
  (	76	,	5.95371054	,	0.249417144	),
  (	76	,	5.921780534	,	0.301641815	),
  (	76	,	5.861974317	,	0.30815244	),
  (	76	,	6.258429029	,	0.064184261	),
  (	76	,	6.260821413	,	0.106588364	),
  (	76	,	0.078023201	,	0.137287404	),
  (	76	,	6.223427042	,	0.170759656	),
  (	76	,	6.191080707	,	0.21283274	),
  (	76	,	0.173149349	,	0.201274799	),
  (	76	,	0.26294571	,	0.317623925	),
  (	76	,	0.025778798	,	0.318242981	),
  (	76	,	0.239905159	,	0.420607303	),
  (	76	,	6.01239687	,	0.237571646	),
  (	76	,	6.127460163	,	0.373721305	),
  (	76	,	6.187923818	,	0.358999056	),
  (	76	,	5.981550786	,	0.314197455	),
  (	76	,	6.047320823	,	0.315681982	),
  (	76	,	6.013129804	,	0.375471853	),
  (	76	,	6.138893274	,	0.443358459	),
  (	76	,	0.01498353	,	0.360662559	),
  (	76	,	6.240323456	,	0.433854207	),
  (	76	,	0.032201668	,	0.46163584	),
  (	76	,	0.128061443	,	0.503140338	),
  (	76	,	0.186720064	,	0.525385179	),
  (	76	,	0.051633649	,	0.496083889	),
  (	76	,	0.03496169	,	0.520763601	),
  (	76	,	0.118377084	,	0.544143213	),
  (	76	,	0.133801307	,	0.560885467	),
  (	76	,	0.065940565	,	0.576488307	),
  (	76	,	6.153196785	,	0.547653123	),
  (	76	,	6.147180009	,	0.554947869	),
  (	76	,	6.139296071	,	0.567597182	),
  (	76	,	6.14280368	,	0.575235757	),
  (	76	,	6.266081412	,	0.54240381	),
  (	76	,	6.263014558	,	0.574073021	),
  (	76	,	0.036993573	,	0.609723879	),
  (	76	,	0.012075733	,	0.625097545	),
  (	76	,	0.033679371	,	0.649006488	),
  (	76	,	6.214595721	,	0.634237673	),
  (	76	,	1.552121748	,	-0.665048056	),
  (	76	,	1.619924128	,	-0.591157522	),
  (	76	,	1.515686942	,	-0.667255979	),
  (	76	,	1.527391311	,	-0.603072972	),
  (	76	,	1.561532991	,	-0.601723838	),
  (	76	,	1.67069968	,	-0.586686537	),
  (	76	,	1.625385656	,	-0.50646802	),
  (	76	,	1.626122459	,	-0.483905692	),
  (	76	,	1.656582392	,	-0.470971955	),
  (	76	,	1.410236306	,	-0.554129736	),
  (	76	,	1.401431104	,	-0.524851427	),
  (	76	,	1.473452753	,	-0.466315505	),
  (	76	,	1.579030445	,	-0.47748178	),
  (	76	,	1.606332874	,	-0.443592102	),
  (	76	,	1.647701331	,	-0.42665525	),
  (	76	,	1.602597547	,	-0.39389579	),
  (	76	,	1.77135861	,	-0.502865978	),
  (	76	,	1.785086544	,	-0.454896167	),
  (	76	,	1.836545574	,	-0.42742761	),
  (	76	,	1.841945248	,	-0.41009578	),
  (	76	,	1.802990926	,	-0.421787331	),
  (	76	,	1.796332856	,	-0.415438667	),
  (	76	,	1.787794231	,	-0.420215748	),
  (	76	,	1.817629754	,	-0.39522607	),
  (	76	,	1.898353688	,	-0.397527453	),
  (	76	,	1.861298449	,	-0.384229313	),
  (	76	,	1.878422083	,	-0.353863314	),
  (	76	,	1.851035843	,	-0.371162632	),
  (	76	,	1.809026502	,	-0.312713259	),
  (	76	,	1.717236208	,	-0.351494342	),
  (	76	,	1.722871785	,	-0.342898024	),
  (	76	,	1.689485101	,	-0.35641588	),
  (	76	,	1.691237848	,	-0.339545107	),
  (	76	,	1.644436434	,	-0.324745048	),
  (	76	,	1.686477685	,	-0.289749016	),
  (	76	,	1.64030035	,	-0.297216554	),
  (	76	,	1.745633593	,	-0.301831728	),
  (	76	,	1.811650445	,	-0.274079243	),
  (	76	,	1.810281527	,	-0.259410545	),
  (	76	,	1.798513827	,	-0.230675518	),
  (	76	,	1.797857844	,	-0.195554862	),
  (	76	,	1.731514262	,	-0.199403155	),
  (	76	,	1.756752954	,	-0.18761429	),
  (	76	,	1.365416612	,	-0.474013962	),
  (	76	,	1.314694079	,	-0.413773362	),
  (	76	,	1.400273185	,	-0.367215162	),
  (	76	,	1.355791706	,	-0.362127995	),
  (	76	,	1.461545995	,	-0.36769969	),
  (	76	,	1.400297413	,	-0.343604597	),
  (	76	,	1.49182806	,	-0.272818698	),
  (	76	,	1.289962909	,	-0.405631481	),
  (	76	,	1.34393313	,	-0.351189912	),
  (	76	,	1.268594753	,	-0.329872767	),
  (	76	,	1.292459984	,	-0.309557009	),
  (	76	,	1.368108943	,	-0.298565273	),
  (	76	,	1.371567483	,	-0.27625373	),
  (	76	,	1.401956332	,	-0.264431153	),
  (	76	,	1.329102612	,	-0.260881661	),
  (	76	,	1.330592855	,	-0.248237802	),
  (	76	,	1.299151927	,	-0.239197239	),
  (	76	,	1.394877684	,	-0.192596412	),
  (	76	,	1.393419899	,	-0.187572552	),
  (	76	,	1.36115937	,	-0.191305347	),
  (	76	,	1.585185267	,	-0.280009096	),
  (	76	,	1.610587845	,	-0.274044697	),
  (	76	,	1.520431607	,	-0.233147179	),
  (	76	,	1.695477845	,	-0.227752653	),
  (	76	,	1.698814355	,	-0.160725137	),
  (	76	,	1.657705975	,	-0.126547363	),
  (	76	,	1.662300852	,	-0.116797264	),
  (	76	,	1.492894924	,	-0.226723378	),
  (	76	,	1.449134605	,	-0.117082068	),
  (	76	,	1.573065027	,	-0.130373579	),
  (	76	,	1.560721891	,	-0.106370633	),
  (	76	,	1.628433132	,	-0.087436833	),
  (	76	,	1.517474407	,	-0.112310578	),
  (	76	,	1.946267396	,	-0.320495043	),
  (	76	,	1.93387279	,	-0.310189526	),
  (	76	,	1.932136388	,	-0.291926681	),
  (	76	,	1.999034964	,	-0.280023459	),
  (	76	,	2.005911619	,	-0.276247405	),
  (	76	,	1.935696016	,	-0.246093958	),
  (	76	,	1.910956413	,	-0.242374543	),
  (	76	,	2.093301623	,	-0.224573689	),
  (	76	,	2.109817382	,	-0.142647593	),
  (	76	,	2.082738479	,	-0.13613544	),
  (	76	,	2.032647662	,	-0.131422419	),
  (	76	,	2.057430109	,	-0.121880554	),
  (	76	,	1.882631645	,	-0.228124907	),
  (	76	,	1.876821193	,	-0.205996398	),
  (	76	,	1.867456396	,	-0.202399213	),
  (	76	,	1.862879174	,	-0.197699292	),
  (	76	,	1.852473597	,	-0.147333381	),
  (	76	,	1.897985271	,	-0.13404601	),
  (	76	,	1.949398688	,	-0.102429953	),
  (	76	,	2.03404718	,	-0.069134892	),
  (	76	,	2.187156506	,	-0.140635582	),
  (	76	,	2.2044876	,	-0.125145484	),
  (	76	,	2.193953068	,	-0.116846969	),
  (	76	,	2.221357555	,	-0.102557453	),
  (	76	,	2.199967211	,	-0.09912237	),
  (	76	,	2.178395952	,	-0.098074157	),
  (	76	,	2.115421463	,	-0.094451787	),
  (	76	,	2.242966442	,	-0.027382237	),
  (	76	,	2.070670838	,	-0.024656227	),
  (	76	,	2.132671594	,	0.013159464	),
  (	76	,	2.121594961	,	0.02054832	),
  (	76	,	2.022888524	,	-0.023532182	),
  (	76	,	2.135276183	,	0.022934214	),
  (	76	,	2.209311928	,	0.043452543	),
  (	76	,	2.192364652	,	0.087545272	),
  (	76	,	2.171323566	,	0.108993775	),
  (	76	,	2.154890658	,	0.110011857	),
  (	76	,	2.196945345	,	0.118911109	),
  (	76	,	2.183364651	,	0.139754327	),
  (	76	,	1.825627071	,	-0.078976629	),
  (	76	,	1.780006533	,	-0.089954613	),
  (	76	,	1.713349256	,	-0.093210562	),
  (	76	,	1.713348156	,	-0.093207705	),
  (	76	,	1.69207442	,	-0.08607322	),
  (	76	,	1.727714669	,	-0.069423218	),
  (	76	,	1.705137811	,	-0.064807384	),
  (	76	,	1.811412546	,	-0.043306563	),
  (	76	,	1.867274956	,	-0.081635607	),
  (	76	,	1.838925918	,	-0.054411932	),
  (	76	,	1.856791047	,	-0.013749858	),
  (	76	,	1.923228784	,	-0.014778287	),
  (	76	,	1.824137403	,	0.006446094	),
  (	76	,	1.837808699	,	0.009615226	),
  (	76	,	1.781064867	,	0.005327461	),
  (	76	,	1.817627372	,	0.02021219	),
  (	76	,	1.851228818	,	0.0263096	),
  (	76	,	1.823710155	,	0.040005393	),
  (	76	,	1.851472641	,	0.070236234	),
  (	76	,	1.654158045	,	-0.065397019	),
  (	76	,	1.659246083	,	-0.035860339	),
  (	76	,	1.654278201	,	-0.023858881	),
  (	76	,	1.670397705	,	-0.014540402	),
  (	76	,	1.723817063	,	0.031710967	),
  (	76	,	1.598751043	,	-0.016815062	),
  (	76	,	1.60238497	,	0.026321402	),
  (	76	,	1.647607397	,	0.030978895	),
  (	76	,	1.631363528	,	0.048991808	),
  (	76	,	1.766387211	,	0.064226527	),
  (	76	,	1.821616105	,	0.050403689	),
  (	76	,	1.850214747	,	0.089569373	),
  (	76	,	1.779198081	,	0.077594046	),
  (	76	,	1.823577409	,	0.114303979	),
  (	76	,	1.736440647	,	0.074325016	),
  (	76	,	1.709879378	,	0.087844295	),
  (	76	,	1.693984666	,	0.092018308	),
  (	76	,	1.732996705	,	0.10575259	),
  (	76	,	1.720795605	,	0.116849062	),
  (	76	,	1.773898403	,	0.160642172	),
  (	76	,	1.984248181	,	0.042256633	),
  (	76	,	1.995555624	,	0.094338673	),
  (	76	,	1.993150822	,	0.106022938	),
  (	76	,	1.961708759	,	0.136842266	),
  (	76	,	2.052413467	,	0.100620392	),
  (	76	,	2.089522841	,	0.147539174	),
  (	76	,	2.007283955	,	0.193547588	),
  (	76	,	1.896122823	,	0.140208022	),
  (	76	,	1.923444826	,	0.168484167	),
  (	76	,	1.879854451	,	0.163674491	),
  (	76	,	1.918027585	,	0.181499628	),
  (	76	,	1.818784412	,	0.198823139	),
  (	76	,	1.832027048	,	0.205984048	),
  (	76	,	2.025281686	,	0.247367885	),
  (	76	,	1.925749962	,	0.229767727	),
  (	76	,	1.952292385	,	0.267320502	),
  (	76	,	1.169234341	,	-0.311385217	),
  (	76	,	1.228565166	,	-0.256354734	),
  (	76	,	1.169664252	,	-0.209475836	),
  (	76	,	1.248601114	,	-0.201780066	),
  (	76	,	1.335977482	,	-0.181905776	),
  (	76	,	1.315424306	,	-0.185866076	),
  (	76	,	1.284799944	,	-0.094607916	),
  (	76	,	1.159464365	,	-0.089938784	),
  (	76	,	1.138944144	,	-0.064906405	),
  (	76	,	1.204417079	,	-0.038926694	),
  (	76	,	1.398020251	,	-0.140155756	),
  (	76	,	1.421933302	,	-0.111052515	),
  (	76	,	1.452774536	,	-0.079700479	),
  (	76	,	1.460494179	,	-0.07665701	),
  (	76	,	1.433585165	,	-0.081979247	),
  (	76	,	1.443745105	,	-0.074259886	),
  (	76	,	1.336130309	,	-0.060825511	),
  (	76	,	1.39484415	,	-0.026468362	),
  (	76	,	1.487725819	,	-0.067075322	),
  (	76	,	1.488087503	,	-0.040235198	),
  (	76	,	1.440215079	,	-0.030536776	),
  (	76	,	1.484514242	,	-0.025526414	),
  (	76	,	1.525174162	,	-0.011900923	),
  (	76	,	1.4424171	,	0.00637987	),
  (	76	,	1.429488432	,	0.019331315	),
  (	76	,	1.450844056	,	0.046224659	),
  (	76	,	1.267392289	,	-0.067461202	),
  (	76	,	1.271950185	,	-0.063870816	),
  (	76	,	1.275696964	,	-0.055379867	),
  (	76	,	1.340752822	,	0.017298852	),
  (	76	,	1.257060056	,	0.011793285	),
  (	76	,	1.210585756	,	0.00965515	),
  (	76	,	1.228703834	,	0.009776243	),
  (	76	,	1.280509472	,	0.019721795	),
  (	76	,	1.26632646	,	0.064290269	),
  (	76	,	1.34207596	,	0.043093532	),
  (	76	,	1.375334435	,	0.074534336	),
  (	76	,	1.428532528	,	0.074378356	),
  (	76	,	1.387321136	,	0.141463786	),
  (	76	,	1.064813837	,	-0.08029423	),
  (	76	,	1.016647627	,	-0.076292993	),
  (	76	,	0.937677101	,	-0.059552639	),
  (	76	,	0.975669584	,	-0.036265167	),
  (	76	,	1.110109062	,	0.028958256	),
  (	76	,	1.103650809	,	0.033574408	),
  (	76	,	0.858178768	,	-0.06162056	),
  (	76	,	0.949634522	,	0.019591367	),
  (	76	,	0.919761356	,	0.089928341	),
  (	76	,	0.928742081	,	0.091706714	),
  (	76	,	0.938854121	,	0.099724052	),
  (	76	,	1.017621573	,	0.135609318	),
  (	76	,	0.996477533	,	0.149753568	),
  (	76	,	1.147395564	,	0.050608458	),
  (	76	,	1.281496068	,	0.105013774	),
  (	76	,	1.353210756	,	0.173875742	),
  (	76	,	1.294731651	,	0.153979938	),
  (	76	,	1.215639276	,	0.142683056	),
  (	76	,	1.209237629	,	0.189224464	),
  (	76	,	1.234018688	,	0.213073028	),
  (	76	,	1.108358527	,	0.192461102	),
  (	76	,	1.171088907	,	0.203606506	),
  (	76	,	1.168371538	,	0.204837648	),
  (	76	,	1.167630591	,	0.272079825	),
  (	76	,	1.161084228	,	0.27094783	),
  (	76	,	1.16017428	,	0.304517172	),
  (	76	,	1.60696726	,	0.05913792	),
  (	76	,	1.650558785	,	0.069542107	),
  (	76	,	1.651667164	,	0.078709874	),
  (	76	,	1.504142341	,	0.066869891	),
  (	76	,	1.516250953	,	0.071561051	),
  (	76	,	1.548721575	,	0.093441073	),
  (	76	,	1.571791183	,	0.084412416	),
  (	76	,	1.56407682	,	0.137192846	),
  (	76	,	1.661167543	,	0.092121161	),
  (	76	,	1.662870828	,	0.131517334	),
  (	76	,	1.677669118	,	0.146555012	),
  (	76	,	1.691740223	,	0.1680155	),
  (	76	,	1.65669167	,	0.214546847	),
  (	76	,	1.633811467	,	0.206185422	),
  (	76	,	1.655297661	,	0.226718972	),
  (	76	,	1.443661433	,	0.178972422	),
  (	76	,	1.578048067	,	0.295555978	),
  (	76	,	1.568745165	,	0.329031015	),
  (	76	,	1.816026923	,	0.21957055	),
  (	76	,	1.781433608	,	0.254685923	),
  (	76	,	1.794411353	,	0.263130874	),
  (	76	,	1.727349821	,	0.229985857	),
  (	76	,	1.708332979	,	0.276692433	),
  (	76	,	1.776860478	,	0.295417352	),
  (	76	,	1.776422106	,	0.298798809	),
  (	76	,	1.840270644	,	0.313728444	),
  (	76	,	1.870688813	,	0.308177553	),
  (	76	,	1.940927805	,	0.349079701	),
  (	76	,	1.872499075	,	0.341150682	),
  (	76	,	1.847848678	,	0.335486217	),
  (	76	,	1.826187267	,	0.335485165	),
  (	76	,	1.842523723	,	0.385648485	),
  (	76	,	1.715192429	,	0.295811317	),
  (	76	,	1.707768513	,	0.304005565	),
  (	76	,	1.700960825	,	0.307598229	),
  (	76	,	1.691556731	,	0.318068277	),
  (	76	,	1.664038274	,	0.370003831	),
  (	76	,	1.693652055	,	0.369266104	),
  (	76	,	1.646452991	,	0.386484874	),
  (	76	,	1.65860927	,	0.408491454	),
  (	76	,	1.666004005	,	0.414697125	),
  (	76	,	1.749929242	,	0.360331692	),
  (	76	,	1.735059067	,	0.396474148	),
  (	76	,	1.813484257	,	0.419018915	),
  (	76	,	1.754924511	,	0.444508296	),
  (	76	,	1.401495351	,	0.193887707	),
  (	76	,	1.396523522	,	0.236393883	),
  (	76	,	1.330020233	,	0.232282979	),
  (	76	,	1.304431209	,	0.253937591	),
  (	76	,	1.406697425	,	0.28138917	),
  (	76	,	1.382000938	,	0.321829987	),
  (	76	,	1.434814215	,	0.286697143	),
  (	76	,	1.432981169	,	0.289806784	),
  (	76	,	1.529510335	,	0.314618522	),
  (	76	,	1.494349962	,	0.331394258	),
  (	76	,	1.48422648	,	0.34348655	),
  (	76	,	1.450223461	,	0.333741636	),
  (	76	,	1.464659665	,	0.373556227	),
  (	76	,	1.294998835	,	0.29206518	),
  (	76	,	1.191247303	,	0.337687546	),
  (	76	,	1.29415355	,	0.406574091	),
  (	76	,	1.283751761	,	0.418853144	),
  (	76	,	1.35357004	,	0.386357726	),
  (	76	,	1.325882049	,	0.435843694	),
  (	76	,	1.330097931	,	0.466361639	),
  (	76	,	1.314735865	,	0.463110157	),
  (	76	,	1.604746728	,	0.396323365	),
  (	76	,	1.613663287	,	0.422633101	),
  (	76	,	1.632531618	,	0.418640548	),
  (	76	,	1.638046736	,	0.442156069	),
  (	76	,	1.564743372	,	0.432799295	),
  (	76	,	1.573488735	,	0.506232508	),
  (	76	,	1.671172991	,	0.499539037	),
  (	76	,	1.648717038	,	0.567312436	),
  (	76	,	1.44591844	,	0.484655986	),
  (	76	,	1.50765684	,	0.51135533	),
  (	76	,	1.503249662	,	0.532121411	),
  (	76	,	1.534688441	,	0.54030608	),
  (	76	,	1.515112147	,	0.552564621	),
  (	76	,	1.409456235	,	0.49687135	),
  (	76	,	1.42754964	,	0.522220574	),
  (	76	,	1.480970202	,	0.539145276	),
  (	76	,	1.576995531	,	0.569676589	),
  (	76	,	1.560590732	,	0.580494956	),
  (	76	,	1.639032982	,	0.630869384	),
  (	76	,	1.538728236	,	0.598093645	),
  (	76	,	1.542914247	,	0.630596076	),
  (	76	,	1.548409836	,	0.632656334	),
  (	76	,	3.15728995	,	-0.680839319	),
  (	76	,	3.142865804	,	-0.633303067	),
  (	76	,	3.116158114	,	-0.628183385	),
  (	76	,	3.161549877	,	-0.544327516	),
  (	76	,	3.202731858	,	-0.565260557	),
  (	76	,	3.221887277	,	-0.549703594	),
  (	76	,	3.283764382	,	-0.566606695	),
  (	76	,	3.313518196	,	-0.515515827	),
  (	76	,	3.189025502	,	-0.489881077	),
  (	76	,	3.116231972	,	-0.539429399	),
  (	76	,	3.021713033	,	-0.508621854	),
  (	76	,	3.082628317	,	-0.427333485	),
  (	76	,	3.091120852	,	-0.403004292	),
  (	76	,	3.404378034	,	-0.417388899	),
  (	76	,	3.262317765	,	-0.431576865	),
  (	76	,	3.283930914	,	-0.42238659	),
  (	76	,	3.340321007	,	-0.351609126	),
  (	76	,	3.486640713	,	-0.349127523	),
  (	76	,	3.48523554	,	-0.299038573	),
  (	76	,	3.277558748	,	-0.341983247	),
  (	76	,	3.246468206	,	-0.341599566	),
  (	76	,	3.289577768	,	-0.29807166	),
  (	76	,	3.193160296	,	-0.347832144	),
  (	76	,	3.22585886	,	-0.284030502	),
  (	76	,	3.241572879	,	-0.255917242	),
  (	76	,	3.405230281	,	-0.242462852	),
  (	76	,	3.280433339	,	-0.274295592	),
  (	76	,	3.361840068	,	-0.227498273	),
  (	76	,	3.347974997	,	-0.21430833	),
  (	76	,	2.951962134	,	-0.490955476	),
  (	76	,	2.870688222	,	-0.384336537	),
  (	76	,	2.86128421	,	-0.285654978	),
  (	76	,	2.840095101	,	-0.259900497	),
  (	76	,	2.953127942	,	-0.253219863	),
  (	76	,	2.999789528	,	-0.217053851	),
  (	76	,	2.908171221	,	-0.234183112	),
  (	76	,	2.920444233	,	-0.203816304	),
  (	76	,	3.210669091	,	-0.241146871	),
  (	76	,	3.096996067	,	-0.238278791	),
  (	76	,	3.154674697	,	-0.187666936	),
  (	76	,	3.222464689	,	-0.155420798	),
  (	76	,	3.020539205	,	-0.216359739	),
  (	76	,	3.052834787	,	-0.16521715	),
  (	76	,	3.056984607	,	-0.146708011	),
  (	76	,	3.213042458	,	-0.102028449	),
  (	76	,	3.195976369	,	-0.05378352	),
  (	76	,	3.094704288	,	-0.120335759	),
  (	76	,	3.114831703	,	-0.065924114	),
  (	76	,	3.072072845	,	-0.083905142	),
  (	76	,	3.48556388	,	-0.209710524	),
  (	76	,	3.639587674	,	-0.204120701	),
  (	76	,	3.589234701	,	-0.210958575	),
  (	76	,	3.623921992	,	-0.132625804	),
  (	76	,	3.413041316	,	-0.211336554	),
  (	76	,	3.440324832	,	-0.20530914	),
  (	76	,	3.452896316	,	-0.183504317	),
  (	76	,	3.446019255	,	-0.133614193	),
  (	76	,	3.526952859	,	-0.014713233	),
  (	76	,	3.739756132	,	-0.10016769	),
  (	76	,	3.716210502	,	-0.102231687	),
  (	76	,	3.900075302	,	-0.007086183	),
  (	76	,	3.764340483	,	0.039702665	),
  (	76	,	3.789438415	,	0.099149962	),
  (	76	,	3.461660048	,	-0.06099205	),
  (	76	,	3.403949934	,	-0.020697186	),
  (	76	,	3.436600726	,	0.025731151	),
  (	76	,	3.236939397	,	-0.076561222	),
  (	76	,	3.212620446	,	-0.056479401	),
  (	76	,	3.197011655	,	-0.04316283	),
  (	76	,	3.219950441	,	0.027493591	),
  (	76	,	3.361254901	,	0.10868204	),
  (	76	,	3.526758492	,	0.039021872	),
  (	76	,	3.506719506	,	0.04758941	),
  (	76	,	3.469044314	,	0.078844046	),
  (	76	,	3.518684348	,	0.099636712	),
  (	76	,	3.656583881	,	0.130259492	),
  (	76	,	3.616549236	,	0.169525613	),
  (	76	,	3.557645986	,	0.259913393	),
  (	76	,	3.496656662	,	0.246941472	),
  (	76	,	2.773858402	,	-0.243594503	),
  (	76	,	2.790866521	,	-0.226791286	),
  (	76	,	2.730836799	,	-0.229205546	),
  (	76	,	2.846140837	,	-0.193905025	),
  (	76	,	2.863775569	,	-0.185443434	),
  (	76	,	2.890788337	,	-0.174443776	),
  (	76	,	2.932991557	,	-0.165543716	),
  (	76	,	2.881431687	,	-0.165680679	),
  (	76	,	2.896526726	,	-0.134193538	),
  (	76	,	2.597163213	,	-0.192585207	),
  (	76	,	2.800799567	,	-0.114753788	),
  (	76	,	2.676986739	,	-0.088793813	),
  (	76	,	3.007386242	,	-0.077706747	),
  (	76	,	2.963819683	,	0.012624294	),
  (	76	,	3.000032713	,	0.02271531	),
  (	76	,	3.016757333	,	0.053455084	),
  (	76	,	2.862701917	,	-0.028238924	),
  (	76	,	2.797650706	,	-0.004826502	),
  (	76	,	2.908524711	,	0.03281467	),
  (	76	,	2.630821426	,	-0.098051241	),
  (	76	,	2.613770669	,	-0.052739472	),
  (	76	,	2.509085613	,	-0.08533367	),
  (	76	,	2.560047067	,	-0.056041919	),
  (	76	,	2.580158076	,	-0.032449284	),
  (	76	,	2.6407045	,	-0.061388897	),
  (	76	,	2.71423304	,	-0.013118	),
  (	76	,	2.48537872	,	-0.054497111	),
  (	76	,	2.54580465	,	0.045859388	),
  (	76	,	2.462754826	,	0.083162894	),
  (	76	,	2.786937641	,	0.100077774	),
  (	76	,	2.856925349	,	0.102065223	),
  (	76	,	2.864548353	,	0.128943821	),
  (	76	,	2.791217801	,	0.154339194	),
  (	76	,	2.734723997	,	0.23782384	),
  (	76	,	3.133804155	,	0.01516503	),
  (	76	,	3.19523272	,	0.102494614	),
  (	76	,	3.056455156	,	0.089708926	),
  (	76	,	3.131778127	,	0.121722656	),
  (	76	,	3.189693211	,	0.152153092	),
  (	76	,	3.201967568	,	0.156590969	),
  (	76	,	3.200464718	,	0.175225675	),
  (	76	,	3.106508418	,	0.154105963	),
  (	76	,	3.154189188	,	0.223529045	),
  (	76	,	3.456767856	,	0.281551546	),
  (	76	,	3.476424446	,	0.345843231	),
  (	76	,	3.459655495	,	0.347638486	),
  (	76	,	3.374133179	,	0.370787295	),
  (	76	,	3.404522176	,	0.376196089	),
  (	76	,	3.236503345	,	0.381752147	),
  (	76	,	3.284483447	,	0.408739153	),
  (	76	,	3.287918792	,	0.426710554	),
  (	76	,	3.244132007	,	0.429231572	),
  (	76	,	3.327687042	,	0.494964314	),
  (	76	,	2.923704475	,	0.277731797	),
  (	76	,	2.86390773	,	0.405795843	),
  (	76	,	2.942657497	,	0.349603555	),
  (	76	,	2.92495678	,	0.396222915	),
  (	76	,	3.16783034	,	0.404996634	),
  (	76	,	3.191175767	,	0.394333529	),
  (	76	,	3.20399831	,	0.462593422	),
  (	76	,	3.248254145	,	0.446503241	),
  (	76	,	3.280530617	,	0.511627557	),
  (	76	,	3.298758021	,	0.558575579	),
  (	76	,	3.157096301	,	0.517995253	),
  (	76	,	3.279094887	,	0.5762101	),
  (	76	,	3.094494609	,	0.490810772	),
  (	76	,	3.03262917	,	0.532476218	),
  (	76	,	3.145292225	,	0.5753261	),
  (	76	,	3.161991663	,	0.620767254	),
  (	76	,	3.126291968	,	0.609179933	),
  (	76	,	4.708335729	,	-0.677649799	),
  (	76	,	4.774193702	,	-0.656610607	),
  (	76	,	4.783165876	,	-0.615070108	),
  (	76	,	4.682963033	,	-0.647171591	),
  (	76	,	4.686500573	,	-0.614451673	),
  (	76	,	4.6839679	,	-0.605486889	),
  (	76	,	4.673274092	,	-0.612097183	),
  (	76	,	4.658706119	,	-0.614743169	),
  (	76	,	4.78053528	,	-0.56449119	),
  (	76	,	4.830476285	,	-0.547552371	),
  (	76	,	4.801590785	,	-0.546568561	),
  (	76	,	4.782986739	,	-0.543831462	),
  (	76	,	4.728119504	,	-0.521185145	),
  (	76	,	4.80150065	,	-0.507306842	),
  (	76	,	4.620697278	,	-0.601867224	),
  (	76	,	4.693842076	,	-0.533577254	),
  (	76	,	4.696833899	,	-0.527045191	),
  (	76	,	4.703695257	,	-0.524738931	),
  (	76	,	4.54409094	,	-0.551212675	),
  (	76	,	4.556740836	,	-0.52133875	),
  (	76	,	4.574767857	,	-0.507168828	),
  (	76	,	4.65141733	,	-0.470755666	),
  (	76	,	4.718697089	,	-0.516408306	),
  (	76	,	4.746233566	,	-0.403262182	),
  (	76	,	4.6788586	,	-0.395663572	),
  (	76	,	4.944199987	,	-0.484439614	),
  (	76	,	4.998721984	,	-0.430664185	),
  (	76	,	4.948574238	,	-0.393928374	),
  (	76	,	4.874788653	,	-0.448082309	),
  (	76	,	4.847811202	,	-0.434448596	),
  (	76	,	4.859839436	,	-0.421031866	),
  (	76	,	4.88012607	,	-0.403225512	),
  (	76	,	4.907155149	,	-0.366013947	),
  (	76	,	4.902395524	,	-0.365103847	),
  (	76	,	4.993124995	,	-0.375799749	),
  (	76	,	4.996283367	,	-0.365604686	),
  (	76	,	5.049455288	,	-0.367774843	),
  (	76	,	5.054902472	,	-0.326320414	),
  (	76	,	5.006081154	,	-0.300928198	),
  (	76	,	5.038975482	,	-0.302759977	),
  (	76	,	4.808711053	,	-0.389172792	),
  (	76	,	4.809119201	,	-0.388141415	),
  (	76	,	4.852968497	,	-0.33377702	),
  (	76	,	4.789474717	,	-0.343345	),
  (	76	,	4.754890912	,	-0.328898025	),
  (	76	,	4.792580095	,	-0.322461095	),
  (	76	,	4.794338539	,	-0.317164622	),
  (	76	,	4.812811454	,	-0.308523637	),
  (	76	,	4.792683015	,	-0.306033009	),
  (	76	,	4.928270871	,	-0.291872283	),
  (	76	,	4.874497915	,	-0.262260113	),
  (	76	,	4.542628318	,	-0.478531496	),
  (	76	,	4.544108302	,	-0.462536727	),
  (	76	,	4.464007643	,	-0.472945079	),
  (	76	,	4.477169409	,	-0.463918391	),
  (	76	,	4.608630172	,	-0.311793065	),
  (	76	,	4.643223302	,	-0.309696507	),
  (	76	,	4.644005771	,	-0.294351497	),
  (	76	,	4.452748325	,	-0.374586755	),
  (	76	,	4.40513437	,	-0.381397071	),
  (	76	,	4.382058411	,	-0.393113399	),
  (	76	,	4.398373241	,	-0.278634613	),
  (	76	,	4.523618684	,	-0.312674108	),
  (	76	,	4.50406361	,	-0.301011649	),
  (	76	,	4.498687756	,	-0.290336744	),
  (	76	,	4.500734656	,	-0.287837643	),
  (	76	,	4.731398704	,	-0.3028751	),
  (	76	,	4.725919812	,	-0.303929666	),
  (	76	,	4.771693225	,	-0.272246603	),
  (	76	,	4.699808762	,	-0.238294641	),
  (	76	,	4.75495867	,	-0.204635839	),
  (	76	,	4.7913575	,	-0.213673694	),
  (	76	,	4.762423954	,	-0.197386956	),
  (	76	,	4.827900715	,	-0.142866595	),
  (	76	,	4.820226139	,	-0.115262548	),
  (	76	,	4.587152732	,	-0.19149577	),
  (	76	,	4.70837484	,	-0.088116877	),
  (	76	,	4.78092527	,	-0.058600793	),
  (	76	,	5.108075012	,	-0.319805205	),
  (	76	,	5.171238274	,	-0.222115749	),
  (	76	,	5.202966337	,	-0.191222303	),
  (	76	,	5.191708787	,	-0.187186848	),
  (	76	,	5.225361796	,	-0.175197896	),
  (	76	,	5.253456657	,	-0.159298339	),
  (	76	,	5.162319784	,	-0.145385232	),
  (	76	,	5.172608785	,	-0.122522379	),
  (	76	,	5.206438781	,	-0.096700773	),
  (	76	,	5.011002171	,	-0.226129155	),
  (	76	,	4.956249775	,	-0.153493234	),
  (	76	,	5.018036147	,	-0.127029935	),
  (	76	,	4.980538148	,	-0.108080993	),
  (	76	,	5.138813266	,	-0.08834665	),
  (	76	,	5.095789856	,	-0.08408612	),
  (	76	,	5.34960064	,	-0.067452506	),
  (	76	,	5.355748671	,	-0.037000969	),
  (	76	,	5.32272702	,	-0.011267078	),
  (	76	,	5.376903795	,	0.038747681	),
  (	76	,	5.171241435	,	-0.052979165	),
  (	76	,	5.201370372	,	-0.037581218	),
  (	76	,	5.173543509	,	-0.012165325	),
  (	76	,	5.140941774	,	-0.008550273	),
  (	76	,	5.20111908	,	0.027982983	),
  (	76	,	5.315979632	,	0.064234457	),
  (	76	,	5.382272422	,	0.094982867	),
  (	76	,	5.241502922	,	0.098577876	),
  (	76	,	5.310187759	,	0.123424634	),
  (	76	,	5.264956113	,	0.131912019	),
  (	76	,	4.91648454	,	-0.116765708	),
  (	76	,	4.95619962	,	-0.100320161	),
  (	76	,	4.969324768	,	-0.0824965	),
  (	76	,	4.915235842	,	-0.016818715	),
  (	76	,	5.065552112	,	0.015968913	),
  (	76	,	4.956115808	,	-0.012918252	),
  (	76	,	4.950657089	,	0.032940809	),
  (	76	,	5.010094827	,	0.022665191	),
  (	76	,	4.818372029	,	-0.071352208	),
  (	76	,	4.791329927	,	-0.023214878	),
  (	76	,	4.831096583	,	0.003435826	),
  (	76	,	4.854819542	,	0.074984499	),
  (	76	,	4.852137718	,	0.118324544	),
  (	76	,	5.064286437	,	0.051272834	),
  (	76	,	5.098974536	,	0.154697978	),
  (	76	,	5.222496778	,	0.147434655	),
  (	76	,	5.239672529	,	0.13930294	),
  (	76	,	5.248645957	,	0.146562696	),
  (	76	,	5.242303045	,	0.187602932	),
  (	76	,	5.170303985	,	0.188061636	),
  (	76	,	5.226984521	,	0.199224342	),
  (	76	,	5.192767342	,	0.205599365	),
  (	76	,	5.029238631	,	0.105407253	),
  (	76	,	5.063638574	,	0.170004612	),
  (	76	,	4.95061539	,	0.169043028	),
  (	76	,	5.09973341	,	0.192453758	),
  (	76	,	5.111306443	,	0.202946335	),
  (	76	,	5.095068342	,	0.21795139	),
  (	76	,	5.131496264	,	0.253206354	),
  (	76	,	5.058328557	,	0.247446466	),
  (	76	,	5.069340211	,	0.253824575	),
  (	76	,	5.055010017	,	0.291426417	),
  (	76	,	5.113351614	,	0.261256241	),
  (	76	,	5.125836734	,	0.290451683	),
  (	76	,	5.111965837	,	0.313430312	),
  (	76	,	4.2644924	,	-0.267525599	),
  (	76	,	4.246324938	,	-0.263843132	),
  (	76	,	4.335047818	,	-0.219217022	),
  (	76	,	4.321537173	,	-0.182246136	),
  (	76	,	4.455930848	,	-0.122663396	),
  (	76	,	4.229712341	,	-0.216001987	),
  (	76	,	4.217553634	,	-0.20779411	),
  (	76	,	4.208121273	,	-0.199832119	),
  (	76	,	4.361517454	,	-0.131115121	),
  (	76	,	4.510028261	,	-0.162035443	),
  (	76	,	4.463504849	,	-0.110868062	),
  (	76	,	4.613542336	,	-0.050147751	),
  (	76	,	4.44028814	,	-0.052652387	),
  (	76	,	4.447793776	,	-0.029455595	),
  (	76	,	4.379457636	,	-0.013681928	),
  (	76	,	4.561842402	,	0.057791437	),
  (	76	,	4.215967537	,	-0.006398842	),
  (	76	,	4.289575119	,	-0.014944231	),
  (	76	,	4.283908803	,	0.021216143	),
  (	76	,	4.216028807	,	0.029860497	),
  (	76	,	4.097211825	,	-0.00544679	),
  (	76	,	4.065370747	,	0.015413548	),
  (	76	,	3.966074471	,	0.029483082	),
  (	76	,	4.137097166	,	0.027411918	),
  (	76	,	4.09723078	,	0.060516197	),
  (	76	,	4.114205523	,	0.071591995	),
  (	76	,	4.174347228	,	0.103161601	),
  (	76	,	4.072287608	,	0.057991251	),
  (	76	,	4.128701401	,	0.106657773	),
  (	76	,	4.436852045	,	0.113469398	),
  (	76	,	4.47679526	,	0.137088541	),
  (	76	,	4.450636404	,	0.171005141	),
  (	76	,	4.398662767	,	0.194301414	),
  (	76	,	4.402620113	,	0.224831702	),
  (	76	,	4.235502118	,	0.175196099	),
  (	76	,	4.229984153	,	0.202024491	),
  (	76	,	4.254333832	,	0.200529625	),
  (	76	,	4.314280934	,	0.23758412	),
  (	76	,	4.284380648	,	0.23483024	),
  (	76	,	4.246877413	,	0.236038071	),
  (	76	,	4.246877197	,	0.236057734	),
  (	76	,	4.320428085	,	0.264040251	),
  (	76	,	4.31133024	,	0.26793851	),
  (	76	,	4.3127193	,	0.269325996	),
  (	76	,	4.305837046	,	0.282247158	),
  (	76	,	4.330555071	,	0.294048185	),
  (	76	,	4.732752797	,	0.065947453	),
  (	76	,	4.755117682	,	0.055867422	),
  (	76	,	4.759650234	,	0.077389308	),
  (	76	,	4.774086952	,	0.073800506	),
  (	76	,	4.666995508	,	0.076384594	),
  (	76	,	4.628390569	,	0.072446465	),
  (	76	,	4.664235044	,	0.086696326	),
  (	76	,	4.831237391	,	0.122331634	),
  (	76	,	4.849555232	,	0.140101818	),
  (	76	,	4.830311241	,	0.160731936	),
  (	76	,	4.797839518	,	0.207177924	),
  (	76	,	4.608666554	,	0.169555144	),
  (	76	,	4.737320608	,	0.209498805	),
  (	76	,	4.700665907	,	0.220364838	),
  (	76	,	4.767345011	,	0.216309087	),
  (	76	,	4.676605187	,	0.261911114	),
  (	76	,	4.714673736	,	0.298506555	),
  (	76	,	4.904087266	,	0.212381333	),
  (	76	,	4.992243897	,	0.263559167	),
  (	76	,	5.028618975	,	0.314195217	),
  (	76	,	5.006459046	,	0.356466125	),
  (	76	,	4.842266408	,	0.307163965	),
  (	76	,	4.883639771	,	0.357749361	),
  (	76	,	4.773405858	,	0.353903797	),
  (	76	,	4.758737679	,	0.367006821	),
  (	76	,	4.844469376	,	0.381648136	),
  (	76	,	4.849643992	,	0.401186158	),
  (	76	,	4.854629453	,	0.444876383	),
  (	76	,	4.897406972	,	0.49087036	),
  (	76	,	4.481937668	,	0.211637744	),
  (	76	,	4.537894016	,	0.277239128	),
  (	76	,	4.569641095	,	0.31237017	),
  (	76	,	4.555315911	,	0.329009283	),
  (	76	,	4.421587722	,	0.268922484	),
  (	76	,	4.474311499	,	0.374593379	),
  (	76	,	4.370097146	,	0.330244781	),
  (	76	,	4.42337271	,	0.369540187	),
  (	76	,	4.524894519	,	0.466276927	),
  (	76	,	4.700341204	,	0.360216541	),
  (	76	,	4.7211589	,	0.391928696	),
  (	76	,	4.784498082	,	0.408384988	),
  (	76	,	4.751573638	,	0.421651476	),
  (	76	,	4.679222222	,	0.436202176	),
  (	76	,	4.719240817	,	0.444877713	),
  (	76	,	4.848040116	,	0.497348031	),
  (	76	,	4.863514165	,	0.523324203	),
  (	76	,	4.881087342	,	0.531486672	),
  (	76	,	4.762106068	,	0.52200817	),
  (	76	,	4.845583971	,	0.569708736	),
  (	76	,	4.804875236	,	0.573817842	),
  (	76	,	4.609465444	,	0.447087551	),
  (	76	,	4.640193731	,	0.471636496	),
  (	76	,	4.621134757	,	0.472104986	),
  (	76	,	4.656658772	,	0.504577957	),
  (	76	,	4.743764645	,	0.607814892	),
  (	76	,	4.677703141	,	0.591459117	),
  (	76	,	4.659622612	,	0.628342382	),
  (	76	,	4.705516945	,	0.643595615	),
  (	76	,	1.140234683	,	-1.532616795	),
  (	76	,	0.284236496	,	-1.458924251	),
  (	76	,	0.4294696	,	-1.452951085	),
  (	76	,	0.676475294	,	-1.435304372	),
  (	76	,	1.004965255	,	-1.324628578	),
  (	76	,	0.250247931	,	-1.336116943	),
  (	76	,	0.465271241	,	-1.304423712	),
  (	76	,	0.726694805	,	-1.329822357	),
  (	76	,	0.808827398	,	-1.282319655	),
  (	76	,	0.916880614	,	-1.301908791	),
  (	76	,	0.974813877	,	-1.291692878	),
  (	76	,	1.4252705	,	-1.285691655	),
  (	76	,	1.408251604	,	-1.262539557	),
  (	76	,	1.340012282	,	-1.243902681	),
  (	76	,	1.104439925	,	-1.270956755	),
  (	76	,	1.495294519	,	-1.171798152	),
  (	76	,	1.396284508	,	-1.152920089	),
  (	76	,	0.997608804	,	-1.228010003	),
  (	76	,	0.98078759	,	-1.222207382	),
  (	76	,	0.929338201	,	-1.176701274	),
  (	76	,	0.928396975	,	-1.164648025	),
  (	76	,	0.971176157	,	-1.120415445	),
  (	76	,	0.982338655	,	-1.11228881	),
  (	76	,	0.167043099	,	-1.290906769	),
  (	76	,	0.037726587	,	-1.295706963	),
  (	76	,	0.284233094	,	-1.251987984	),
  (	76	,	0.228957832	,	-1.213063757	),
  (	76	,	0.327444649	,	-1.201106349	),
  (	76	,	0.548462731	,	-1.249765401	),
  (	76	,	0.697499084	,	-1.153990775	),
  (	76	,	0.579048229	,	-1.154609862	),
  (	76	,	0.4818341	,	-1.098821957	),
  (	76	,	0.555012742	,	-1.064342413	),
  (	76	,	0.556064156	,	-1.041604749	),
  (	76	,	0.50886292	,	-1.020517683	),
  (	76	,	0.481006861	,	-1.02868898	),
  (	76	,	0.498073837	,	-1.010874436	),
  (	76	,	0.805979741	,	-1.050629944	),
  (	76	,	0.713794286	,	-1.098152071	),
  (	76	,	1.000930715	,	-0.929273043	),
  (	76	,	0.639803632	,	-0.902413031	),
  (	76	,	0.785978667	,	-0.827578243	),
  (	76	,	1.525453461	,	-1.058999768	),
  (	76	,	1.338424291	,	-1.045064134	),
  (	76	,	1.507569301	,	-0.970019911	),
  (	76	,	1.486627717	,	-0.928813794	),
  (	76	,	1.454249951	,	-0.901315919	),
  (	76	,	1.375623314	,	-0.919181552	),
  (	76	,	1.414428188	,	-0.932509262	),
  (	76	,	1.362961668	,	-0.899712176	),
  (	76	,	1.223065694	,	-1.028744085	),
  (	76	,	1.258934327	,	-0.869048819	),
  (	76	,	1.23630826	,	-0.824175135	),
  (	76	,	1.522478484	,	-0.808357404	),
  (	76	,	1.495934351	,	-0.789507621	),
  (	76	,	1.474957893	,	-0.749820989	),
  (	76	,	1.3511628	,	-0.773788394	),
  (	76	,	1.348814203	,	-0.733373023	),
  (	76	,	1.246090596	,	-0.742710221	),
  (	76	,	1.252364261	,	-0.668616514	),
  (	76	,	1.383191771	,	-0.545861713	),
  (	76	,	1.063250194	,	-0.923783536	),
  (	76	,	0.970313011	,	-0.8865535	),
  (	76	,	0.952419594	,	-0.861639778	),
  (	76	,	1.071491699	,	-0.797035063	),
  (	76	,	1.110471011	,	-0.713740532	),
  (	76	,	1.059979433	,	-0.694743425	),
  (	76	,	0.847296264	,	-0.7025917	),
  (	76	,	1.027534209	,	-0.633726153	),
  (	76	,	1.179111071	,	-0.680476965	),
  (	76	,	1.182007994	,	-0.643610406	),
  (	76	,	1.265082069	,	-0.540536535	),
  (	76	,	1.28778176	,	-0.528591667	),
  (	76	,	1.302686237	,	-0.504186748	),
  (	76	,	1.234499265	,	-0.553421714	),
  (	76	,	1.10130501	,	-0.551206568	),
  (	76	,	1.183938993	,	-0.504084734	),
  (	76	,	1.248264132	,	-0.439103942	),
  (	76	,	1.234738534	,	-0.424131008	),
  (	76	,	1.228344815	,	-0.418467089	),
  (	76	,	1.20988279	,	-0.402271295	),
  (	76	,	0.08046402	,	-1.10789846	),
  (	76	,	0.276162429	,	-1.048910305	),
  (	76	,	0.024417974	,	-1.070057921	),
  (	76	,	0.203283521	,	-1.01313757	),
  (	76	,	0.236706862	,	-1.001872908	),
  (	76	,	0.348953968	,	-1.000926639	),
  (	76	,	0.346201402	,	-0.936127246	),
  (	76	,	0.390722916	,	-0.913962489	),
  (	76	,	0.133797546	,	-0.959408332	),
  (	76	,	0.032605187	,	-0.977581603	),
  (	76	,	0.3243957	,	-0.879930598	),
  (	76	,	0.54799991	,	-0.907413795	),
  (	76	,	0.619376773	,	-0.864292377	),
  (	76	,	0.475015344	,	-0.881097687	),
  (	76	,	0.690511667	,	-0.725241359	),
  (	76	,	0.518988483	,	-0.749604584	),
  (	76	,	0.488128814	,	-0.646499038	),
  (	76	,	0.593550108	,	-0.636567388	),
  (	76	,	0.02445551	,	-0.894666041	),
  (	76	,	0.080671394	,	-0.812136947	),
  (	76	,	0.14485793	,	-0.819464592	),
  (	76	,	0.136606635	,	-0.761075576	),
  (	76	,	0.155225438	,	-0.693723897	),
  (	76	,	0.36233563	,	-0.658031796	),
  (	76	,	0.495016694	,	-0.585814416	),
  (	76	,	0.546600527	,	-0.498438221	),
  (	76	,	0.546615768	,	-0.49529396	),
  (	76	,	0.505411125	,	-0.508133292	),
  (	76	,	0.350711871	,	-0.505916989	),
  (	76	,	0.30566797	,	-0.457168072	),
  (	76	,	0.811015508	,	-0.65168724	),
  (	76	,	0.789573504	,	-0.529933085	),
  (	76	,	0.891833517	,	-0.543250057	),
  (	76	,	0.923203794	,	-0.552809305	),
  (	76	,	0.897144442	,	-0.475994576	),
  (	76	,	0.69718195	,	-0.611288781	),
  (	76	,	0.688914758	,	-0.587777479	),
  (	76	,	0.657875556	,	-0.57608978	),
  (	76	,	0.724900004	,	-0.442178247	),
  (	76	,	0.700425133	,	-0.421239768	),
  (	76	,	0.745419745	,	-0.401906354	),
  (	76	,	0.788920501	,	-0.361173379	),
  (	76	,	1.027987989	,	-0.45250931	),
  (	76	,	0.938387854	,	-0.424239028	),
  (	76	,	0.919210627	,	-0.339215634	),
  (	76	,	0.919865798	,	-0.322299679	),
  (	76	,	0.900600272	,	-0.26813842	),
  (	76	,	0.971896196	,	-0.32662511	),
  (	76	,	1.021000252	,	-0.217282113	),
  (	76	,	1.01196305	,	-0.208880611	),
  (	76	,	0.652655225	,	-0.420688943	),
  (	76	,	0.510504665	,	-0.447156405	),
  (	76	,	0.740853032	,	-0.35335821	),
  (	76	,	0.708223752	,	-0.279624899	),
  (	76	,	0.406119663	,	-0.334307409	),
  (	76	,	0.446213944	,	-0.312215533	),
  (	76	,	0.435310363	,	-0.306319888	),
  (	76	,	0.576254154	,	-0.309422955	),
  (	76	,	0.620932985	,	-0.28810603	),
  (	76	,	0.543251017	,	-0.28304945	),
  (	76	,	0.520211551	,	-0.263936623	),
  (	76	,	0.794302478	,	-0.317789346	),
  (	76	,	0