/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.util;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.util.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    public static final String NO_TEXT_AVAILABLE = "No description available";

    public static Element getChildElement(Node parent, String name, CharSequence namespace) {
        List<Element> children = XmlUtils.getChildren(parent, name, namespace, false, true);
        return children.isEmpty() ? null : children.get(0);
    }

    public static List<Element> getChildElements(Node parent, String name, CharSequence namespace) {
        return XmlUtils.getChildren(parent, name, namespace, false, false);
    }

    private static List<Element> getChildren(Node parent, String name, CharSequence namespace, boolean strict, boolean firstOnly) {
        if (parent == null || name == null) {
            return Collections.emptyList();
        }
        CharSequence normalizedSearchNS = XmlUtils.normalizeNS(namespace);
        ArrayList<Element> matches = new ArrayList<Element>();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength() && (!firstOnly || matches.isEmpty()); ++i) {
            Element element;
            if (nodes.item(i).getNodeType() != 1 || !name.equals((element = (Element)nodes.item(i)).getLocalName())) continue;
            if ("*".equals(normalizedSearchNS)) {
                matches.add(element);
                continue;
            }
            String ns = element.getNamespaceURI();
            if (ns == null) {
                if (normalizedSearchNS != null) continue;
                matches.add(element);
                continue;
            }
            if (strict) {
                if (!ns.equals(namespace)) continue;
                matches.add(element);
                continue;
            }
            CharSequence normalizedNS = XmlUtils.normalizeNS(ns);
            if (!normalizedNS.equals(normalizedSearchNS)) continue;
            matches.add(element);
        }
        return matches;
    }

    public static CharSequence normalizeNS(CharSequence namespace) {
        if (namespace != null) {
            int len;
            for (len = namespace.length(); len > 0 && namespace.charAt(len - 1) == '/'; --len) {
            }
            return namespace.subSequence(0, len);
        }
        return namespace;
    }

    public static String getTextFromChild(Element paramElem, String nodeName) {
        return XmlUtils.getTextFromChild(paramElem, nodeName, NO_TEXT_AVAILABLE);
    }

    public static String getTextFromChild(Element paramElem, String nodeName, String noValue) {
        NodeList nodeList = paramElem.getElementsByTagName(nodeName);
        return XmlUtils.getTextFromFirstChild(nodeList, noValue);
    }

    public static String getTextFromChildXPath(Element element, String xsr, String noValue) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xpath.evaluate(xsr, element, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) {
                return noValue;
            }
            return XmlUtils.getTextFromFirstChild(nodeList.item(0).getChildNodes(), noValue);
        }
        catch (XPathExpressionException e) {
            throw new ConfigurationErrorException("Illegal XPath expression: " + xsr);
        }
        catch (Exception e) {
            throw new ConfigurationErrorException("Unexpected error in parsing XPath expression: " + xsr);
        }
    }

    public static String getTextFromChildXPath(String xmlContent, String xsr, String noValue) {
        Document document = XmlUtils.getResultDom(xmlContent, false);
        return XmlUtils.getTextFromChildXPath(document.getDocumentElement(), xsr, noValue);
    }

    private static String getTextFromFirstChild(NodeList nodeList, String noValue) {
        String retVal = "";
        if (nodeList.getLength() == 0) {
            retVal = noValue;
        } else if (nodeList.getLength() > 0) {
            retVal = nodeList.item(0).getTextContent();
        }
        return retVal;
    }

    public static String getTextFromNode(Element elem) {
        String desc = "";
        NodeList list = elem.getChildNodes();
        if (list.getLength() == 0) {
            desc = null;
        } else if (list.getLength() > 0) {
            desc = StringUtils.stripWSControlChars(list.item(0).getTextContent());
        }
        return desc;
    }

    public static String getCdataFromNode(Element node) {
        String desc = "";
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 4) continue;
            desc = child.getTextContent();
        }
        return desc;
    }

    public static Document getResultDom(String xmlString, boolean namespaceAware) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(namespaceAware);
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (SAXException e) {
            throw new InternalErrorException("Can't read from response:\n " + xmlString, ErrorMessages.ErrorCode.INTERNAL_SERVICE_ERROR, e.getMessage(), "No request id received");
        }
        catch (ParserConfigurationException e) {
            throw new InternalErrorException("Can't read from response\n " + xmlString, ErrorMessages.ErrorCode.INTERNAL_SERVICE_ERROR, e.getMessage(), "No request id received");
        }
        catch (IOException e) {
            throw new InternalErrorException("Can't read from response\n " + xmlString, e);
        }
        return document;
    }

    public static Document getResultDom(String xmlString) {
        return XmlUtils.getResultDom(xmlString, false);
    }

    public static String elemToString(Element elem) {
        StringBuilder xml = new StringBuilder();
        int valueCount = 0;
        if (elem != null) {
            xml.append("<" + elem.getNodeName());
            NamedNodeMap attrs = elem.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                xml.append(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
                ++valueCount;
            }
            Boolean isLeaf = elem.getChildNodes().getLength() == 0;
            if (isLeaf.booleanValue()) {
                xml.append(" />\n");
            } else {
                NodeList children = elem.getChildNodes();
                xml.append(">");
                for (int j = 0; j < children.getLength(); ++j) {
                    if (children.item(j) instanceof Element) {
                        xml.append("\n");
                        xml.append(XmlUtils.elemToString((Element)children.item(j)));
                        ++valueCount;
                        continue;
                    }
                    if (children.item(j) instanceof Text) {
                        Text tnode = (Text)children.item(j);
                        if (!StringUtils.notEmpty(tnode.getNodeValue())) continue;
                        xml.append(((Text)children.item(j)).getNodeValue());
                        ++valueCount;
                        continue;
                    }
                    throw new InternalErrorException("Don't know what to do with this elem: " + children.item(j).toString());
                }
                xml.append("</" + elem.getNodeName() + ">");
            }
        }
        if (valueCount == 0) {
            return null;
        }
        return xml.toString();
    }
}

