/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * This project is protected by the GPL, see copying.txt                    *
 *                                                                          *
 ****************************************************************************/

/* name:        compiler.cpp
 * author       U-Foot (ufoot@bigfoot.com)
 * last update: January 2000
 * description: dummy file used to compile data files 
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "compiler.h"
#include <ClanLib/mikmod.h>

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

U61_Compiler compiler;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * title of the application window
 */ 
char *U61_Compiler::get_title()
{
  return "U61 Compiler by U-Foot (ufoot@ufoot.org)";
}

/*--------------------------------------------------------------------------*/
/*
 * main function of the application
 */
int U61_Compiler::main(int argc, char** argv)
{
  CL_SetupCore::init();
  CL_SetupMikMod::init();

  if (argc>=3)
    {
      try 
	{
	  CL_DatafileCompiler::write(argv[1],argv[2]);
	}
      catch (CL_Error e)
	{
	  cout<<e.message;
	}      
    }

  CL_SetupMikMod::deinit();
  CL_SetupCore::deinit();

  return 0;
}

