
-- various functions used for pattern matching -------------------------------

function utils_shift_column_down(x_col,y_bottom)
    local y
    local color

    y=y_bottom
    while y>=1 do
        color=u61_get_square_color(x_col,y-1)
        u61_set_square_color(x_col,y,color)
        y=y-1
    end
    u61_set_square_color(x_col,0,-1)

    if u61_get_curse_x()==x_col and u61_get_curse_y()<y_bottom then
        u61_set_curse_y(u61_get_curse_y()+1)
    end
end


-- Functions used in many curse scripts --------------------------------------

function utils_shift_map_up()
    local x
    local y
    local width
    local height
    local color

    width=u61_get_width()
    height=u61_get_height() 
    y=0
    while y<height-1 do
        x=0
        while x<width do
            color=u61_get_square_color(x,y+1)
            u61_set_square_color(x,y,color)
            x=x+1
        end
        y=y+1
    end

    u61_set_curse_y(u61_get_curse_y()-1)
end

function utils_clear_map()
    local x
    local y
    local width
    local height

    width=u61_get_width()
    height=u61_get_height() 
    y=0
    while y<height do
        x=0
        while x<width do
            u61_set_square_color(x,y,-1)
            x=x+1
        end
        y=y+1
    end
end

function utils_switch_lines(y1,y2)
    local x
    local color

    x=u61_get_width()-1
    while x>=0 do
        color=u61_get_square_color(x,y1)
        u61_set_square_color(x,y1,u61_get_square_color(x,y2))
        u61_set_square_color(x,y2,color)
        x=x-1
    end
end

function utils_get_highest_square_y()
    local x
    local y
    local width
    local height
    local min_y	

    width=u61_get_width()
    height=u61_get_height()
    min_y=height 
    y=0
    while y<height do
        x=0
        while x<width do
            if u61_get_square_color(x,y)>=0 then
                min_y=y
                x=width
                y=height
            end
            x=x+1
        end
        y=y+1
    end 

    return min_y   
end