import xmllib
import string

class XMLToX(xmllib.XMLParser):
    def __init__(self):
        xmllib.XMLParser.__init__(self)
        self.translated=""
        self.elements["FILE"]=(None,None)
        self.elements["CHAP"]=(None,None)
        self.elements["PART"]=(None,None)
        self.elements["TEXT"]=(None,None)
        self.elements["LIST"]=(None,None)
        self.elements["ELEM"]=(None,None)
        self.elements["CODE"]=(None,None)
    def write(self,text):
        self.translated=self.translated+text
    def start_file(self,title):
        pass
    def start_chap(self,title):
        pass
    def start_part(self,title):
        pass
    def start_text(self):
        pass
    def start_list(self):
        pass
    def start_elem(self):
        pass
    def start_code(self):
        pass
    def end_file(self):
        pass
    def end_chap(self):
        pass
    def end_part(self):
        pass
    def end_text(self):
        pass
    def end_list(self):
        pass
    def end_elem(self):
        pass
    def end_code(self):
        pass
    def unknown_starttag(self,tag,attributes):
        if tag=="FILE":
            self.start_file(attributes["TITLE"])
        if tag=="CHAP":
            self.start_chap(attributes["TITLE"])
        if tag=="PART":
            self.start_part(attributes["TITLE"])
        if tag=="TEXT":
            self.start_text()
        if tag=="LIST":
            self.start_list()
        if tag=="ELEM":
            self.start_elem()
        if tag=="CODE":
            self.start_code()
    def unknown_endtag(self,tag):
        if tag=="FILE":
            self.end_file()
        elif tag=="CHAP":
            self.end_chap()
        elif tag=="PART":
            self.end_part()
        elif tag=="TEXT":
            self.end_text()
        elif tag=="LIST":
            self.end_list()
        elif tag=="ELEM":
            self.end_elem()
        elif tag=="CODE":
            self.end_code()
    def translate(self,data,tag):
        return data
    def handle_data(self,data):
        if len(self.stack)>0:
            data=string.strip(data)
            if (data!=''):
                #print data
                #print self.stack
                self.write(self.translate(data,self.stack[-1][0]))

class XMLToHTML(XMLToX):
    def __init__(self,header,footer):
        XMLToX.__init__(self)
        self.header=header
        self.footer=footer
    def start_file(self,title):
        self.write("<HTML><BODY><HEAD><TITLE>"+\
                   title+\
                   "</TITLE></HEAD><BODY>\n"+\
                   self.header+\
                   "\n<CENTER><H1>"+\
                   title+\
                   "</H1></CENTER>\n")
    def start_chap(self,title):
        self.write("<HR>\n<H2>"+\
                   title+\
                   "</H2>\n")
    def start_part(self,title):
        self.write("<H3>"+\
                   title+\
                   "</H3>\n")
    def start_text(self):
        self.write("<P>")
    def start_list(self):
        self.write("<UL>")
    def start_elem(self):
        self.write("<LI>")
    def start_code(self):
        self.write("<PRE>")
    def end_file(self):
        self.write(self.footer+\
                   "\n</BODY></HTML>")
    def end_chap(self):
        self.write("\n")
    def end_part(self):
        self.write("\n")
    def end_text(self):
        self.write("</P>\n")
    def end_list(self):
        self.write("</UL>\n")
    def end_elem(self):
        self.write("</LI>\n")
    def end_code(self):
        self.write("</PRE>\n")
    def translate(self,data,tag):
        result=data
        result=string.replace(result,"<","&lt;")
        return result

class XMLToPHP3(XMLToX):
    def __init__(self):
        XMLToX.__init__(self)
    def start_file(self,title):
        self.write("<? require '../toolbox.php3'; ?>\n"+\
                   "<? require 'template.php3'; ?>\n"+\
                   "<? echo begin_page(__FILE__); ?>\n"+\
                   "<CENTER>\n"+\
                   "<? require 'navbar.php3' ?>\n"+
                   "<H1>"+\
                   title+\
                   "</H1></CENTER>\n")
    def start_chap(self,title):
        self.write("<HR>\n<H2>"+\
                   title+\
                   "</H2>\n")
    def start_part(self,title):
        self.write("<H3>"+\
                   title+\
                   "</H3>\n")
    def start_text(self):
        self.write("<P>")
    def start_list(self):
        self.write("<UL>")
    def start_elem(self):
        self.write("<LI>")
    def start_code(self):
        self.write("<PRE>")
    def end_file(self):
        self.write("<? echo end_page(); ?>")
    def end_chap(self):
        self.write("\n")
    def end_part(self):
        self.write("\n")
    def end_text(self):
        self.write("</P>\n")
    def end_list(self):
        self.write("</UL>\n")
    def end_elem(self):
        self.write("</LI>\n")
    def end_code(self):
        self.write("</PRE>\n")
    def translate(self,data,tag):
        result=data
        result=string.replace(result,"<","&lt;")
        return result

class XMLToTeX(XMLToX):
    def __init__(self):
        XMLToX.__init__(self)
    def start_file(self,title):
        self.write("\\chapter{"+\
                   self.translate(title,"TEXT")+\
                   "}\n")
    def start_chap(self,title):
        self.write("\\section{"+\
                   self.translate(title,"TEXT")+\
                   "}\n")
    def start_part(self,title):
        self.write("\\subsection{"+\
                   self.translate(title,"TEXT")+\
                   "}\n")
    def start_text(self):
        self.write("\n")
    def start_list(self):
        self.write("\\begin{itemize}\n")
    def start_elem(self):
        self.write("\\item[$\\bullet$]")
    def start_code(self):
        self.write("\\begin{verbatim}\n")
    def end_file(self):
        self.write("")
    def end_chap(self):
        self.write("\n")
    def end_part(self):
        self.write("\n")
    def end_text(self):
        self.write("\n")
    def end_list(self):
        self.write("\\end{itemize}\n")
    def end_elem(self):
        self.write("\n")
    def end_code(self):
        self.write("\n\\end{verbatim}\n")
    def translate(self,data,tag):
        result=data
        if (tag!="CODE"):
            result=string.replace(result,"_","\\_")
            result=string.replace(result,"%","\\%")
            result=string.replace(result,"}","\\}")
        result=string.replace(result,"~","$\\tilde{}$")
        return result

def run_parser(parser,dst,src):
    dst_file=open(dst,"w")
    src_file=open(src,"r")
    src_code=src_file.read()
    parser.feed(src_code)
    dst_code=parser.translated
    dst_file.write(dst_code)
    src_file.close()
    dst_file.close()
        
def make_html(html,xml,header,footer):
    header_file=open(header,"r")
    footer_file=open(footer,"r")
    header_str=header_file.read()
    footer_str=footer_file.read()
    parser=XMLToHTML(header_str,footer_str)
    run_parser(parser,html,xml)
    header_file.close()
    footer_file.close()

def make_php3(php3,xml):
    parser=XMLToPHP3()
    run_parser(parser,php3,xml)

def make_tex(tex,xml):
    parser=XMLToTeX()
    run_parser(parser,tex,xml)



