/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   version.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: tools for game versionning, useful in a network game
 *              to tell which version of the game people have...
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "version.h"

#include <stdio.h>

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*
 * these variables hold the version, for instance, 0.1.3 means than
 * version_1=0, version_2=1, version_3=3
 */
int U61_Version::version_1=0;
int U61_Version::version_2=3;
int U61_Version::version_3=3;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * writes a string containing the version into a buffer (example "0.1.3")
 */
void U61_Version::get_version_text(char *buffer)
{
    sprintf(buffer,"%d.%d.%d",version_1,version_2,version_3);
}

/*--------------------------------------------------------------------------*/
/*
 * returns a number identifying the version in a unique manner
 */
int U61_Version::get_version_code()
{
    return version_1*1000000+version_2*1000+version_3;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the first part of the version
 */
int U61_Version::get_version_1()
{
    return version_1;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the second part of the version
 */
int U61_Version::get_version_2()
{
    return version_2;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the last part of the version
 */
int U61_Version::get_version_3()
{
    return version_3;
}

