/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   sound.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: all sound playing (except music) are done through this
 *              class. just ask for a "game start" sound and it's there
 */


#ifndef INC_U61_SOUND
#define INC_U61_SOUND

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Sound
{
 public:
  static void play_game_start();
  static void play_menu_move();
  static void play_menu_validate();
  static void play_block_touch();
  static void play_block_pattern();
  static void play_player_start();
  static void play_curse_receive();
  static void play_player_loose();

  static const int VOLUME_MAX=10;
 protected:
  static void play(CL_SoundBuffer *sound);
};

#endif
