/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   music.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: used to start and stop playing music, one just has to ask
 *              for music number 'n' to be played and it starts playing
 *              and does automatically internal checks such as "does this
 *              music index exists in my current datafile"
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "music.h"
#include "global.h"
#include "debug.h"
#include "utils.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * handler on the music being played, NULL if no music selected
 */    
CL_SoundBuffer_Session *U61_Music::session=NULL;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Starts playing a new music (called when one starts a new game)
 */
void U61_Music::start()
{
  /*
  CL_SoundBuffer *sample;
  int volume;
  int chosen=0;

  chosen=U61_Utils::random(U61_Global::data.nb_music);

  volume=U61_Global::config.sound_volume;

  sample=U61_Global::data.music[chosen];

  if (session!=NULL)
    {
      session->stop();
      delete session;
    }

  session=new CL_SoundBuffer_Session(sample->prepare());
  if (session!=NULL)
    {
      session->set_volume(2.0*((float) volume)/((float) VOLUME_MAX));
      session->play();
    }
  */
}

/*--------------------------------------------------------------------------*/
/*
 * This callback must be called regularly 
 */
void U61_Music::update()
{
  /*
  int volume;

  volume=U61_Global::config.sound_volume;
  if (session!=NULL)
    {
      if (session->is_playing())
	{
	  session->set_volume(2.0*((float) volume)/((float) VOLUME_MAX));
	}
      else
	{
	  start();
	}
    }
  */
}

/*--------------------------------------------------------------------------*/
/*
 * Pauses the music, for instance when one is moving throw the menus
 */
void U61_Music::pause()
{

}

/*--------------------------------------------------------------------------*/
/*
 * Resumes the music.
 */
void U61_Music::resume()
{

}
