/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   keydef.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: A keydef is usefull to identify a key, that's to
 *              say make the link between a system code, an ascii code
 *              and a label. It also contains a "state" field which
 *              is used by the global input monitor to know wether it
 *              is pressed or not.
 */

#ifndef INC_U61_KEYDEF
#define INC_U61_KEYDEF

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_KeyDef
{ 
 public:
  U61_KeyDef();
  ~U61_KeyDef();

  void reset();
  void define(int ascii, char *label);
  char get_ascii();
  char *get_label();
  bool get_state();
  void press();
  void release();

 protected:  
  int key_ascii;
  char *key_label;
  bool key_state;
  bool key_flag;
};

#endif


