/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   edit.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a menu item which allows the user to type text
 *              this is usefull to edit the player's name for instance
 */



/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>

#include "edit.h"
#include "const.h"
#include "menuinput.h"
#include "global.h"
#include "inputmonitor.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'edit' item
 */ 
U61_Edit::U61_Edit(char *label, char *val) : U61_MenuItem()
{
  name=label;

  if (val!=NULL)
    {
      value=val;
    }
  else
    {
      strcpy(buffer,"");
      value=buffer;
    }

  pos=0;
  update();
}

/*--------------------------------------------------------------------------*/
/*
 * updates the text displayed so that it reflects the value of the item
 */
void U61_Edit::update()
{
  char buffer[U61_STRING_SIZE];

  strcpy(buffer,name);
  strcat(buffer,SEPARATOR);
  strcat(buffer,value);

  set_text(buffer);
}

/*--------------------------------------------------------------------------*/
/*
 * callback for key presses
 */
bool U61_Edit::action(int key)
{
  bool changed=false;
  int len;
  int i;
  int ascii;
  int old_pos;

  len=strlen(value); 
  old_pos=pos;

  switch (key)
    {
    case CL_KEY_RIGHT:
      pos++;
      break;
    case CL_KEY_LEFT:
      pos--;
      break;
    case CL_KEY_DELETE:
      if (pos>=len && pos>0)
	{
	  pos--;
	}
      if (len>0)
	{
	  suppress();
	  changed=true;
	}
      break;
    case CL_KEY_BACKSPACE:
      if (pos>0)
	{
	  pos--;
	  suppress();
	  changed=true;
	}
      break;
    case CL_KEY_UP:
    case CL_KEY_DOWN:
      break;
    default:
      ascii=U61_Global::input_monitor.to_ascii(key);
      if (isalnum(ascii) 
	  || ascii==' ' 
	  || ascii=='.' 
	  || ascii=='-')
	{
	  for (i=len;i>=pos;--i)
	    {
	      value[i+1]=value[i];
	    }
	  value[pos]=ascii;
	  value[MAX_SIZE]=0;
	  pos++;
	  changed=true;
	}
      break;
    }

  check_pos();

  /*
   * If the old position and the new one are different, the we force
   * an unselect/select, so that there's no problem with blinking
   */
  if (pos!=old_pos)
    {
      unselect();
      select();
      changed=true;
    }

  return changed;
}

/*--------------------------------------------------------------------------*/
/*
 * deletes the current letter
 */
void U61_Edit::suppress()
{
  int len,i;

  len=strlen(value);
  for (i=pos;i<len;++i)
    {
      value[i]=value[i+1];
    }
}

/*--------------------------------------------------------------------------*/
/*
 * checks & corrects the pos of the cursor
 */
void U61_Edit::check_pos()
{
  int len;

  len=strlen(value);
  if (pos>len)
    {
      pos=len;
    }
  if (pos<0)
    {
      pos=0;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * selects the current character
 */
void U61_Edit::select()
{
  int len,sel;

  sel=strlen(name)+strlen(SEPARATOR); 

  /*
   * We select the char which is under the cursor
   */
  len=strlen(value);
  if (pos<len)
    {
      sel+=pos; 
      select_char(sel);
      blink_char(sel);
    }
  else
    {
      /*
       * if we are at the end of the string, then we make the last char
       * dance, but we do not set it blinking
       */
      if (len>0)
	{
	  sel+=len-1;
	  select_char(sel);
	}
    }
}















