/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   playerinput.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a subclass of input. defines a keyboard input with
 *              10 keys (that's what's needed for a player)
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "playerinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a menu input object
 */ 
U61_PlayerInput::U61_PlayerInput() : U61_Input(NB_KEYS)
{
    //init();
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a menu input object
 */ 
U61_PlayerInput::~U61_PlayerInput()
{
}

/*--------------------------------------------------------------------------*/
/*
 * initializations of the player keys
 */
void U61_PlayerInput::init(U61_PlayerConfig *config)
{
    set_key(0,U61_Key(config->key_start_stop,
                      U61_Event::START_STOP,
                      U61_Key::NO_REPEAT,
                      U61_Key::NO_REPEAT));
    set_key(1,U61_Key(config->key_move_left,
                      U61_Event::MOVE_LEFT,
                      config->first_repeat_move,
                      config->standard_repeat_move));
    set_key(2,U61_Key(config->key_move_right,
                      U61_Event::MOVE_RIGHT,
                      config->first_repeat_move,
                      config->standard_repeat_move));
    set_key(3,U61_Key(config->key_rotate_left,
                      U61_Event::ROTATE_LEFT,
                      config->first_repeat_rotate,
                      config->standard_repeat_rotate));
    set_key(4,U61_Key(config->key_rotate_right,
                      U61_Event::ROTATE_RIGHT,
                      config->first_repeat_rotate,
                      config->standard_repeat_rotate));
    set_key(5,U61_Key(config->key_move_down,
                      U61_Event::MOVE_DOWN,
                      config->first_repeat_move,
                      config->standard_repeat_move));
    set_key(6,U61_Key(config->key_drop,
                      U61_Event::DROP,
                      U61_Key::NO_REPEAT,
                      U61_Key::NO_REPEAT));
    set_key(7,U61_Key(config->key_next_victim,
                      U61_Event::NEXT_VICTIM,
                      config->first_repeat_other,
                      config->standard_repeat_other));
    set_key(8,U61_Key(config->key_prev_victim,
                      U61_Event::PREV_VICTIM,
                      config->first_repeat_other,
                      config->standard_repeat_other));
    set_key(9,U61_Key(config->key_use_antidote,
                      U61_Event::USE_ANTIDOTE,
                      config->first_repeat_other,
                      config->standard_repeat_other));
}




