/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   networksource.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a network source is the event source used for remote players
 *              it polls informations from the network dispatcher
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "networksource.h"
#include "time.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a network event source
 */ 
U61_NetworkSource::U61_NetworkSource(U61_Dispatcher *d,
				     U61_Map *m,
				     int player_id)
{
  dispatcher=d;
  map=m;
  player=player_id;
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a network event source
 */ 
U61_NetworkSource::~U61_NetworkSource()
{
  
}

/*--------------------------------------------------------------------------*/
/*
 * polls all the events, and sorts them by time
 */
void U61_NetworkSource::poll()
{
  poll_dispatcher();
  poll_map();
}

/*--------------------------------------------------------------------------*/
/*
 * polls the network for something interesting 
 */
void U61_NetworkSource::poll_dispatcher()
{
  U61_Event evt;

  while (!dispatcher->empty_in(player))
    {
      evt=dispatcher->get_in(player);
      put(evt);
    }
}

/*--------------------------------------------------------------------------*/
/*
 * flushes the events that are automatically generated as time goes on
 * in fact these events are simply ignored in a network source...
 * event can *only* come from the network 
 */
void U61_NetworkSource::poll_map()
{
  U61_Event evt;
 
  map->poll_auto_events();    
  while (map->exists_auto_event())
    {
      evt=map->get_auto_event();
    }
}
