/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   data.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the data object holds all the data of the game
 *              this includes the graphics, the sounds and anything
 *              which is included in the datafile
 *              it provides an easy and standard way for all other
 *              classes to access the game resources
 */

#ifndef INC_U61_DATA
#define INC_U61_DATA

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Data
{
public:
    U61_Data();
    ~U61_Data();

    bool load1(char *name);
    bool load2();
    void unload();

    static const int NB_SQUARE_TYPE=8;
    static const int NB_SIZE=2;
    static const int SIZE_BIG=0;
    static const int SIZE_SMALL=1;
    static const int NB_MAP_MAX=128;

    int screen_w;
    int screen_h;

    int square_w[NB_SIZE];
    int square_h[NB_SIZE];
    int map_w[NB_SIZE];
    int map_h[NB_SIZE];
    int info_w[NB_SIZE];
    int info_h[NB_SIZE];

    int offset_map_x[NB_SIZE];
    int offset_map_y[NB_SIZE];
    int offset_name_x[NB_SIZE];
    int offset_name_y[NB_SIZE];
    int offset_score_x[NB_SIZE];
    int offset_score_y[NB_SIZE];
    int offset_target_x[NB_SIZE];
    int offset_target_y[NB_SIZE];
    int offset_preview_x[NB_SIZE];
    int offset_preview_y[NB_SIZE];
    int offset_curses_x[NB_SIZE];
    int offset_curses_y[NB_SIZE];
    int offset_antidotes_x[NB_SIZE];
    int offset_antidotes_y[NB_SIZE];
    int offset_next_curse_x[NB_SIZE];
    int offset_next_curse_y[NB_SIZE];
   
    int nb_map;

    CL_Font *font_menu;
    CL_Font *font_info[NB_SIZE];
    CL_Font *font_symbol[NB_SIZE];
 
    CL_SoundBuffer *sound_game_start;
    CL_SoundBuffer *sound_menu_move;
    CL_SoundBuffer *sound_menu_validate;
    CL_SoundBuffer *sound_block_touch;
    CL_SoundBuffer *sound_block_pattern;
    CL_SoundBuffer *sound_player_start;
    CL_SoundBuffer *sound_curse_receive;
    CL_SoundBuffer *sound_player_loose;
 
    CL_SoundBuffer *mikmod_test;
 
    CL_Surface *square[NB_SQUARE_TYPE][NB_SIZE];
    CL_Surface *curse[NB_SIZE];
    CL_Surface *anticipation[NB_SIZE];
    CL_Surface *explosion[NB_SIZE];

    CL_Surface *map[NB_MAP_MAX][NB_SIZE];

    CL_Surface *back;
    CL_Surface *shade;

    CL_Surface *info[NB_SIZE];

    static char *const SYMBOL_CURSE="-";
    static char *const SYMBOL_ANTIDOTE="+";

protected:
    CL_ResourceManager *manager;

    static char *const ID_PROPERTY_SCREEN_W="property/screen_w";
    static char *const ID_PROPERTY_SCREEN_H="property/screen_h";

    static char *const ID_PROPERTY_OFFSET_MAP_X_BIG=
                         "property/offset_map_x_big";
    static char *const ID_PROPERTY_OFFSET_MAP_Y_BIG=
                         "property/offset_map_y_big";
    static char *const ID_PROPERTY_OFFSET_NAME_X_BIG=
                         "property/offset_name_x_big";
    static char *const ID_PROPERTY_OFFSET_NAME_Y_BIG=
                         "property/offset_name_y_big";
    static char *const ID_PROPERTY_OFFSET_SCORE_X_BIG=
                         "property/offset_score_x_big";
    static char *const ID_PROPERTY_OFFSET_SCORE_Y_BIG=
                         "property/offset_score_y_big";
    static char *const ID_PROPERTY_OFFSET_TARGET_X_BIG=
                         "property/offset_target_x_big";
    static char *const ID_PROPERTY_OFFSET_TARGET_Y_BIG=
                         "property/offset_target_y_big";
    static char *const ID_PROPERTY_OFFSET_PREVIEW_X_BIG=
                         "property/offset_preview_x_big";
    static char *const ID_PROPERTY_OFFSET_PREVIEW_Y_BIG=
                         "property/offset_preview_y_big";
    static char *const ID_PROPERTY_OFFSET_CURSES_X_BIG=
                         "property/offset_curses_x_big";
    static char *const ID_PROPERTY_OFFSET_CURSES_Y_BIG=
                         "property/offset_curses_y_big";
    static char *const ID_PROPERTY_OFFSET_ANTIDOTES_X_BIG=
                         "property/offset_antidotes_x_big";
    static char *const ID_PROPERTY_OFFSET_ANTIDOTES_Y_BIG=
                         "property/offset_antidotes_y_big";
    static char *const ID_PROPERTY_OFFSET_NEXT_CURSE_X_BIG=
                         "property/offset_next_curse_x_big";
    static char *const ID_PROPERTY_OFFSET_NEXT_CURSE_Y_BIG=
                         "property/offset_next_curse_y_big";

    static char *const ID_PROPERTY_OFFSET_MAP_X_SMALL=
                         "property/offset_map_x_small";
    static char *const ID_PROPERTY_OFFSET_MAP_Y_SMALL=
                         "property/offset_map_y_small";
    static char *const ID_PROPERTY_OFFSET_NAME_X_SMALL=
                         "property/offset_name_x_small";
    static char *const ID_PROPERTY_OFFSET_NAME_Y_SMALL=
                         "property/offset_name_y_small";
    static char *const ID_PROPERTY_OFFSET_SCORE_X_SMALL=
                         "property/offset_score_x_small";
    static char *const ID_PROPERTY_OFFSET_SCORE_Y_SMALL=
                         "property/offset_score_y_small";
    static char *const ID_PROPERTY_OFFSET_TARGET_X_SMALL=
                         "property/offset_target_x_small";
    static char *const ID_PROPERTY_OFFSET_TARGET_Y_SMALL=
                         "property/offset_target_y_small";
    static char *const ID_PROPERTY_OFFSET_PREVIEW_X_SMALL=
                         "property/offset_preview_x_small";
    static char *const ID_PROPERTY_OFFSET_PREVIEW_Y_SMALL=
                         "property/offset_preview_y_small";
    static char *const ID_PROPERTY_OFFSET_CURSES_X_SMALL=
                         "property/offset_curses_x_small";
    static char *const ID_PROPERTY_OFFSET_CURSES_Y_SMALL=
                         "property/offset_curses_y_small";
    static char *const ID_PROPERTY_OFFSET_ANTIDOTES_X_SMALL=
                         "property/offset_antidotes_x_small";
    static char *const ID_PROPERTY_OFFSET_ANTIDOTES_Y_SMALL=
                         "property/offset_antidotes_y_small";
    static char *const ID_PROPERTY_OFFSET_NEXT_CURSE_X_SMALL=
                         "property/offset_next_curse_x_small";
    static char *const ID_PROPERTY_OFFSET_NEXT_CURSE_Y_SMALL=
                         "property/offset_next_curse_y_small";

    static char *const ID_FONT_MENU="font/menu";
    static char *const ID_FONT_INFO_BIG="font/info_big";
    static char *const ID_FONT_INFO_SMALL="font/info_small";
    static char *const ID_FONT_SYMBOL_BIG="font/symbol_big";
    static char *const ID_FONT_SYMBOL_SMALL="font/symbol_small";

    static char *const ID_SOUND_GAME_START="sound/game_start";
    static char *const ID_SOUND_MENU_MOVE="sound/menu_move";
    static char *const ID_SOUND_MENU_VALIDATE="sound/menu_validate";
    static char *const ID_SOUND_BLOCK_TOUCH="sound/block_touch";
    static char *const ID_SOUND_BLOCK_PATTERN="sound/block_pattern";
    static char *const ID_SOUND_PLAYER_START="sound/player_start";
    static char *const ID_SOUND_CURSE_RECEIVE="sound/curse_receive";
    static char *const ID_SOUND_PLAYER_LOOSE="sound/player_loose";
 
    static char *const ID_SQUARE_BIG="square/big_n";
    static char *const ID_SQUARE_SMALL="square/small_n";
    static char *const ID_SQUARE_CURSE="curse";
    static char *const ID_SQUARE_ANTICIPATION="anticipation";
    static char *const ID_SQUARE_EXPLOSION="explosion";

    static char *const ID_MAP_BIG="map/big_";
    static char *const ID_MAP_SMALL="map/small_";
    static char *const ID_MAP_NUMBER="map/number";

    static char *const ID_BACK_MAIN="back/main";
    static char *const ID_SHADE="back/shade";

    static char *const ID_INFO_BIG="info/big";
    static char *const ID_INFO_SMALL="info/small";

    bool load_properties();
    bool load_fonts();
    bool load_sounds();
    bool load_musics();
    bool load_squares();
    bool load_maps();
    bool load_back();
    bool load_info();
};

#endif
