/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   keyspeed.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu item allows the user to enter a key speed
 *              this value is used to control key repeat rates
 *              a key speed may range from to 1 to 99 or be infinite
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>
#include <stdio.h>

#include "keyspeed.h"
#include "menu.h"
#include "key.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a keyspeed item
 */ 
U61_KeySpeed::U61_KeySpeed(char *label, int *val) 
          : U61_Number(label,val,MIN_DELAY,U61_Key::NO_REPEAT)
{
}

/*--------------------------------------------------------------------------*/
/*
 * increments the value
 */
void U61_KeySpeed::inc()
{
    if ((*value)==MAX_DELAY)
    {
        (*value)=U61_Key::NO_REPEAT;
    }
    else
    {
        if ((*value)>=STEP_LIMIT)
        {
            (*value)+=STEP_VALUE;
        }
        else
        {
            (*value)++;
        }
    }
    check_range();
}

/*--------------------------------------------------------------------------*/
/*
 * decrements the value
 */
void U61_KeySpeed::dec()
{
    if ((*value)==U61_Key::NO_REPEAT)
    {
        (*value)=MAX_DELAY;
    }
    else
    {
        if ((*value)>STEP_LIMIT)
        {
            (*value)-=STEP_VALUE;
        }
        else
        {
            (*value)--;
        }
    }
    check_range();
}

/*--------------------------------------------------------------------------*/
/*
 * checks if the value is not too large or small
 */
void U61_KeySpeed::check_range()
{
    U61_Number::check_range();
    if ((*value)>MAX_DELAY && (*value)<U61_Key::NO_REPEAT)
    {
        (*value)=MAX_DELAY;
    }
}

