/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   key.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: used to poll a key. this class implements key repetition
 *              on a per-key basis. since repetition settings cna be
 *              changed for any key, u61 is able to have your "move" keys
 *              to repeat faster then "rotate" keys. and the drop key
 *              may not repeat at all ;)
 */

#ifndef INC_U61_KEY
#define INC_U61_KEY

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "event.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Key
{ 
public:
    U61_Key(int key_code_in=CL_KEY_ESCAPE, 
            int evt_code_out=U61_Event::NOTHING,
            int first_repeat_delay=NO_REPEAT,
            int standard_repeat_delay=NO_REPEAT);
    ~U61_Key();

    void init(int key_code_in,
	      int evt_code_out,
	      int first_repeat_delay,
              int standard_repeat_delay);
  
    void poll(int time);
    void reset();
    bool empty();
    U61_Event get();
    int get_code_in();    
    int get_code_out();    

    enum
    {
        RELEASED,
        PRESSED,
        REPEATING
    };

    static const int NO_REPEAT=999999999;
protected:
    list<U61_Event> queue;
 
    int code_in;
    int code_out;

    int first_delay;
    int standard_delay;

    int state;
    int last_fired;


    void fire(int time);
};

#endif
