/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   filemenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class allows the user to choose a file.
 *              it's designed to be subclassed by changing the
 *              constructor and validate function
 *              one has to tell:
 *              - which directory is to be scanned
 *              - what extensions the files to be scanned should have
 *              the extensions are removed from the files in the list
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "filemenu.h"
#include "file.h"
#include "button.h"
#include "platform.h"
#include "const.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the file menu
 */ 
U61_FileMenu::U61_FileMenu(U61_Menu *parent, char *top,
			   char *dir, char *local_dir, char *ext,
                           char *choice)
  : U61_Menu(parent, top)
{
  bool exists=false;

  last_selection=-1;
  extension=ext;
  empty=false;
  last_added=0;
  chosen_file=choice;

  if (add_files(dir))
    {
      exists=true;
    }
  if (add_files(local_dir))
    {
      exists=true;
    }

  if (!exists)
    {
      add_item(new U61_Button("not found"));
      empty=true;
    }
 
  if (last_selection<0)
    {
      last_selection=0;
    }

  select(last_selection);
}

/*----------------------------------------------------------------------------*/
/*
 * adds the contents of a directory to the list
 */
bool U61_FileMenu::add_files(char *dir)
{
  char *name;
  char buffer_label[U61_STRING_SIZE];
  char buffer_name[U61_STRING_SIZE];
  bool exists=false;

  //cout << "Searching "<<dir<<" for \""<< extension <<"\" files. \n";
  if (U61_Platform::open_dir(dir,extension))
    {
      while ((name=U61_Platform::next_file())!=NULL)
        {
          strcpy(buffer_name,dir);
	  strcat(buffer_name,name);
          strcpy(buffer_label,name);
          buffer_label[strlen(buffer_label)-strlen(extension)]=0;
	      
	  add_item(new U61_File(buffer_label,buffer_name,chosen_file));

          if (strcmp(buffer_name,chosen_file)==0)
	    {
              last_selection=last_added;
	    }
          last_added++;
	  exists=true;
        }
      U61_Platform::close_dir();
    }

  return exists;
}



