/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   debug.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utilities to log messages and debug the program
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "debug.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * contains the name of the log file
 */
char *U61_Debug::file_name="u61.log";

/*--------------------------------------------------------------------------*/
/*
 * tells if the log file should be used or not
 */
bool U61_Debug::console_state=true;

/*--------------------------------------------------------------------------*/
/*
 * contains the name of the log file
 */
bool U61_Debug::file_state=true;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * logs a message to the console, a trailing \n is automatically added
 * if true is given as a second argument, the message will be logged
 * even if console_state is set to false
 */
void U61_Debug::log_console(const ostream &o,bool always)
{
    if (always || console_state)
    {
         cout<<"U61 console : "<<o<<"<n";
    }
}

/*--------------------------------------------------------------------------*/
/*
 * logs a message to the log file, a trailing \n is automatically added
 * if true is given as a second argument, the message will be logged
 * even if file_state is set to false
 */
void U61_Debug::log_file(const ostream &o,bool always)
{
    if (always || file_state)
    {
         cout<<"U61 file    : "<<o<<"\n";
    }
}

/*--------------------------------------------------------------------------*/
/*
 * sets the log file
 */
void U61_Debug::set_file(char *name)
{
    file_name=name;
}
