/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   config.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the config object holds all the values which are stored
 *              on the HD between two game sessions. it would for instance
 *              store the player names and key settings
 *              it basically provides functions to load and save all the
 *              game parameters, and makes these parameters usable by any
 *              other class.
 *              it also provides some function which help handling game
 *              settings in general
 */

#ifndef INC_U61_CONFIG
#define INC_U61_CONFIG

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <stdio.h>
#include <ClanLib/core.h>

#include "const.h"
#include "playerconfig.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Config
{
 public:
  U61_Config();
  ~U61_Config();

  void reset();
  bool read();
  bool write();
  bool load_script();

  static const int NB_PLAYERS=4;

  int launch_count;

  char data_file[U61_STRING_SIZE];
  char script_file[U61_STRING_SIZE];

  char server_id[U61_STRING_SIZE];
  int network_port;
  int network_channel;
    
  int initial_speed;
  int acceleration;
  int curse_delay;

  int sound_volume;
  int music_volume;

  int max_fps;
  
  bool network_prevision;

  U61_PlayerConfig player[NB_PLAYERS];

 protected:
  void read_str(char *buf,char *name,char *def);
  int read_int(char *name,int def);
  bool write_str(FILE *file,char *name, char *value); 
  bool write_int(FILE *file,char *name,int value);
  void read_player_str(char *buf,int pl,char *name,char *def);
  int read_player_int(int pl,char *name,int def);
  bool write_player_str(int pl,FILE *file,char *name, char *value); 
  bool write_player_int(int pl,FILE *file,char *name,int value);
    
  static const int DUMMY_VALUE=1001;
  static char *const ID_DUMMY="cfg_dummy";
  static char *const ID_PLAYER="cfg_player_%d_";

  static char *const ID_LAUNCH_COUNT="cfg_launch_count";
  static char *const ID_DATA_FILE="cfg_data_file";
  static char *const ID_SCRIPT_FILE="cfg_script_file";

  static char *const ID_SERVER_ID="cfg_server_id";
  static char *const ID_NETWORK_PORT="cfg_network_port";
  static char *const ID_NETWORK_CHANNEL="cfg_network_channel";

  static char *const ID_INITIAL_SPEED="cfg_initial_speed";
  static char *const ID_ACCELERATION="cfg_acceleration";
  static char *const ID_CURSE_DELAY="cfg_curse_delay";

  static char *const ID_SOUND_VOLUME="cfg_sound_volume";
  static char *const ID_MUSIC_VOLUME="cfg_music_volume";

  static char *const ID_MAX_FPS="cfg_max_fps";

  static char *const ID_NETWORK_PREVISION="cfg_network_prevision";

  static char *const ID_FIRST_REPEAT_MOVE="first_repeat_move";
  static char *const ID_STANDARD_REPEAT_MOVE="standard_repeat_move";
  static char *const ID_FIRST_REPEAT_ROTATE="first_repeat_rotate";
  static char *const ID_STANDARD_REPEAT_ROTATE="standard_repeat_rotate";
  static char *const ID_FIRST_REPEAT_OTHER="first_repeat_other";
  static char *const ID_STANDARD_REPEAT_OTHER="standard_repeat_other";

  static char *const ID_PREVISION="prevision";
  static char *const ID_ACTIVABLE="playing";
  static char *const ID_NAME="name";

  static char *const ID_KEY_START_STOP="key_start_stop";
  static char *const ID_KEY_MOVE_LEFT="key_move_left";
  static char *const ID_KEY_MOVE_RIGHT="key_move_right";
  static char *const ID_KEY_ROTATE_LEFT="key_rotate_left";
  static char *const ID_KEY_ROTATE_RIGHT="key_rotate_right";
  static char *const ID_KEY_MOVE_DOWN="key_move_down";
  static char *const ID_KEY_DROP="key_drop";
  static char *const ID_KEY_NEXT_VICTIM="key_next_victim";
  static char *const ID_KEY_PREV_VICTIM="key_prev_victim";
  static char *const ID_KEY_USE_ANTEDOTE="key_use_antedote";
};

#endif
