/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   blockitem.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a block item is a square associated to an x,y couple
 *              this allows the block class to be a collection of blockitems
 *              instead of a collection of squares with a dirty array
 *              holding the coordinates of these squares
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "blockitem.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a default block item
 */ 
U61_BlockItem::U61_BlockItem()
{
    reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * frees the block item
 */ 
U61_BlockItem::~U61_BlockItem()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * resets a block item
 */
void U61_BlockItem::reset()
{
    x=0;
    y=0;
    square.reset();
}

/*--------------------------------------------------------------------------*/
/*
 * sets the x parameter, but checks if value is correct, if not, use 0
 */
void U61_BlockItem::set_x(int val)
{
    x=(val>=-COORD_MAX && val<=COORD_MAX) ? val : 0;
}

/*--------------------------------------------------------------------------*/
/*
 * sets the y parameter, but checks if value is correct, if not, use 0
 */
void U61_BlockItem::set_y(int val)
{
    y=(val>=-COORD_MAX && val<=COORD_MAX) ? val : 0;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the value of x
 */
int U61_BlockItem::get_x()
{
    return x;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the value of y
 */
int U61_BlockItem::get_y()
{
    return y;
}

