/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef _rpcsvc_key_prot_h
#define _rpcsvc_key_prot_h

#if 0
#pragma ident "@(#)key_prot.x	1.7	94/04/29 SMI"
#endif

/* Copyright (c)  1990, 1991 Sun Microsystems, Inc. */

/* 
 * Compiled from key_prot.x using rpcgen.
 * DO NOT EDIT THIS FILE!
 * This is NOT source code!
 */
#define PROOT 3
#define HEXMODULUS "d4a0ba0250b6fd2ec626e7efd637df76c716e22d0944b88b"
#define HEXKEYBYTES 48
#define KEYSIZE 192
#define KEYBYTES 24
#define KEYCHECKSUMSIZE 16

enum keystatus {
	KEY_SUCCESS = 0,
	KEY_NOSECRET = 1,
	KEY_UNKNOWN = 2,
	KEY_SYSTEMERR = 3,
};
typedef enum keystatus keystatus;
bool_t xdr_keystatus();


typedef char keybuf[HEXKEYBYTES];
bool_t xdr_keybuf();


typedef char *netnamestr;
bool_t xdr_netnamestr();


struct cryptkeyarg {
	netnamestr remotename;
	des_block deskey;
};
typedef struct cryptkeyarg cryptkeyarg;
bool_t xdr_cryptkeyarg();


struct cryptkeyarg2 {
	netnamestr remotename;
	netobj remotekey;
	des_block deskey;
};
typedef struct cryptkeyarg2 cryptkeyarg2;
bool_t xdr_cryptkeyarg2();


struct cryptkeyres {
	keystatus status;
	union {
		des_block deskey;
	} cryptkeyres_u;
};
typedef struct cryptkeyres cryptkeyres;
bool_t xdr_cryptkeyres();

#define MAXGIDS 16

struct unixcred {
	u_int uid;
	u_int gid;
	struct {
		u_int gids_len;
		u_int *gids_val;
	} gids;
};
typedef struct unixcred unixcred;
bool_t xdr_unixcred();


struct getcredres {
	keystatus status;
	union {
		unixcred cred;
	} getcredres_u;
};
typedef struct getcredres getcredres;
bool_t xdr_getcredres();


struct key_netstarg {
	keybuf st_priv_key;
	keybuf st_pub_key;
	netnamestr st_netname;
};
typedef struct key_netstarg key_netstarg;
bool_t xdr_key_netstarg();


struct key_netstres {
	keystatus status;
	union {
		key_netstarg knet;
	} key_netstres_u;
};
typedef struct key_netstres key_netstres;
bool_t xdr_key_netstres();


#ifndef opaque
#define opaque char
#endif


#define KEY_PROG ((u_long)100029)
#define KEY_VERS ((u_long)1)
#define KEY_SET ((u_long)1)
extern keystatus *key_set_1();
#define KEY_ENCRYPT ((u_long)2)
extern cryptkeyres *key_encrypt_1();
#define KEY_DECRYPT ((u_long)3)
extern cryptkeyres *key_decrypt_1();
#define KEY_GEN ((u_long)4)
extern des_block *key_gen_1();
#define KEY_GETCRED ((u_long)5)
extern getcredres *key_getcred_1();
#define KEY_VERS2 ((u_long)2)
extern keystatus *key_set_2();
extern cryptkeyres *key_encrypt_2();
extern cryptkeyres *key_decrypt_2();
extern des_block *key_gen_2();
extern getcredres *key_getcred_2();
#define KEY_ENCRYPT_PK ((u_long)6)
extern cryptkeyres *key_encrypt_pk_2();
#define KEY_DECRYPT_PK ((u_long)7)
extern cryptkeyres *key_decrypt_pk_2();
#define KEY_NET_PUT ((u_long)8)
extern keystatus *key_net_put_2();
#define KEY_NET_GET ((u_long)9)
extern key_netstres *key_net_get_2();
#define KEY_GET_CONV ((u_long)10)
extern cryptkeyres *key_get_conv_2();

#endif /*!_rpcsvc_key_prot_h*/
