;;; subst-jis.el --- Unicode/JISX translation    -*-coding: euc-jp;-*-
;; Copyright (C) 2002  Free Software Foundation, Inc.

;; Author: Dave Love <fx@gnu.org>
;; Keywords: i18n

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Provides translation tables between Unicode and
;; japanese-jisx0208/japanese-jisx0212 charsets for use by the
;; `utf-translate-cjk' option.

;;; Code:

;; Derived in Emacs 22 using
;; (map-charset-chars
;;  (lambda (range arg)
;;    (let ((i (car range))
;; 	 c)
;;      (while (<= i (cdr range))
;;        (setq c (encode-char i 'ucs))
;;        (if c
;; 	   (if (or (memq (char-syntax c) '(?\( ?\" ?\) ?\;))
;; 		   (insert "(" (format "#x%x ?\\%c" c c) ")\n")
;; 		   (insert "(" (format "#x%x ?%c" c c) ")\n")))
;; 	 (setq i (1+ i))))))
;;  'japanese-jisx0208)
;; and similarly.

(mapc
 (lambda (pair)
   (let ((unicode (car pair))
	 (char (cadr pair)))
     ;; exclude non-CJK components from decode table
     (if (or (and (>= unicode #x2e80) (<= unicode #xd7a3))
	     (and (>= unicode #xff00) (<= unicode #xffef)))
	 (puthash unicode  char ucs-unicode-to-mule-cjk))
     (puthash char unicode ucs-mule-cjk-to-unicode)))
 '(
   ;; jisx0208
   (#xa2 ?)
   (#xa3 ?)
   (#xa7 ?)
   (#xa8 ?)
   (#xac ?)
   (#xb0 ?)
   (#xb1 ?)
   (#xb4 ?)
   (#xb6 ?)
   (#xd7 ?)
   (#xf7 ?)
   (#x391 ?)
   (#x392 ?)
   (#x393 ?)
   (#x394 ?)
   (#x395 ?)
   (#x396 ?)
   (#x397 ?)
   (#x398 ?)
   (#x399 ?)
   (#x39a ?)
   (#x39b ?)
   (#x39c ?)
   (#x39d ?)
   (#x39e ?)
   (#x39f ?)
   (#x3a0 ?)
   (#x3a1 ?)
   (#x3a3 ?)
   (#x3a4 ?)
   (#x3a5 ?)
   (#x3a6 ?)
   (#x3a7 ?)
   (#x3a8 ?)
   (#x3a9 ?)
   (#x3b1 ?)
   (#x3b2 ?)
   (#x3b3 ?)
   (#x3b4 ?)
   (#x3b5 ?)
   (#x3b6 ?)
   (#x3b7 ?)
   (#x3b8 ?)
   (#x3b9 ?)
   (#x3ba ?)
   (#x3bb ?)
   (#x3bc ?)
   (#x3bd ?)
   (#x3be ?)
   (#x3bf ?)
   (#x3c0 ?)
   (#x3c1 ?)
   (#x3c3 ?)
   (#x3c4 ?)
   (#x3c5 ?)
   (#x3c6 ?)
   (#x3c7 ?)
   (#x3c8 ?)
   (#x3c9 ?)
   (#x401 ?)
   (#x410 ?)
   (#x411 ?)
   (#x412 ?)
   (#x413 ?)
   (#x414 ?)
   (#x415 ?)
   (#x416 ?)
   (#x417 ?)
   (#x418 ?)
   (#x419 ?)
   (#x41a ?)
   (#x41b ?)
   (#x41c ?)
   (#x41d ?)
   (#x41e ?)
   (#x41f ?)
   (#x420 ?)
   (#x421 ?)
   (#x422 ?)
   (#x423 ?)
   (#x424 ?)
   (#x425 ?)
   (#x426 ?)
   (#x427 ?)
   (#x428 ?)
   (#x429 ?)
   (#x42a ?)
   (#x42b ?)
   (#x42c ?)
   (#x42d ?)
   (#x42e ?)
   (#x42f ?)
   (#x430 ?)
   (#x431 ?)
   (#x432 ?)
   (#x433 ?)
   (#x434 ?)
   (#x435 ?)
   (#x436 ?)
   (#x437 ?)
   (#x438 ?)
   (#x439 ?)
   (#x43a ?)
   (#x43b ?)
   (#x43c ?)
   (#x43d ?)
   (#x43e ?)
   (#x43f ?)
   (#x440 ?)
   (#x441 ?)
   (#x442 ?)
   (#x443 ?)
   (#x444 ?)
   (#x445 ?)
   (#x446 ?)
   (#x447 ?)
   (#x448 ?)
   (#x449 ?)
   (#x44a ?)
   (#x44b ?)
   (#x44c ?)
   (#x44d ?)
   (#x44e ?)
   (#x44f ?)
   (#x451 ?)
   (#x2010 ?)
   (#x2015 ?)
   (#x2016 ?)
   (#x2018 ?)
   (#x2019 ?)
   (#x201c ?)
   (#x201d ?)
   (#x2020 ?)
   (#x2021 ?)
   (#x2025 ?)
   (#x2026 ?)
   (#x2030 ?)
   (#x2032 ?)
   (#x2033 ?)
   (#x203b ?)
   (#x2103 ?)
   (#x212b ?)
   (#x2190 ?)
   (#x2191 ?)
   (#x2192 ?)
   (#x2193 ?)
   (#x21d2 ?)
   (#x21d4 ?)
   (#x2200 ?)
   (#x2202 ?)
   (#x2203 ?)
   (#x2207 ?)
   (#x2208 ?)
   (#x220b ?)
   (#x2212 ?)
   (#x221a ?)
   (#x221d ?)
   (#x221e ?)
   (#x2220 ?)
   (#x2227 ?)
   (#x2228 ?)
   (#x2229 ?)
   (#x222a ?)
   (#x222b ?)
   (#x222c ?)
   (#x2234 ?)
   (#x2235 ?)
   (#x223d ?)
   (#x2252 ?)
   (#x2260 ?)
   (#x2261 ?)
   (#x2266 ?)
   (#x2267 ?)
   (#x226a ?)
   (#x226b ?)
   (#x2282 ?)
   (#x2283 ?)
   (#x2286 ?)
   (#x2287 ?)
   (#x22a5 ?)
   (#x2312 ?)
   (#x2500 ?)
   (#x2501 ?)
   (#x2502 ?)
   (#x2503 ?)
   (#x250c ?)
   (#x250f ?)
   (#x2510 ?)
   (#x2513 ?)
   (#x2514 ?)
   (#x2517 ?)
   (#x2518 ?)
   (#x251b ?)
   (#x251c ?)
   (#x251d ?)
   (#x2520 ?)
   (#x2523 ?)
   (#x2524 ?)
   (#x2525 ?)
   (#x2528 ?)
   (#x252b ?)
   (#x252c ?)
   (#x252f ?)
   (#x2530 ?)
   (#x2533 ?)
   (#x2534 ?)
   (#x2537 ?)
   (#x2538 ?)
   (#x253b ?)
   (#x253c ?)
   (#x253f ?)
   (#x2542 ?)
   (#x254b ?)
   (#x25a0 ?)
   (#x25a1 ?)
   (#x25b2 ?)
   (#x25b3 ?)
   (#x25bc ?)
   (#x25bd ?)
   (#x25c6 ?)
   (#x25c7 ?)
   (#x25cb ?)
   (#x25ce ?)
   (#x25cf ?)
   (#x25ef ?)
   (#x2605 ?)
   (#x2606 ?)
   (#x2640 ?)
   (#x2642 ?)
   (#x266a ?)
   (#x266d ?)
   (#x266f ?)
   (#x3000 ?)
   (#x3001 ?)
   (#x3002 ?)
   (#x3003 ?)
   (#x3005 ?)
   (#x3006 ?)
   (#x3007 ?)
   (#x3008 ?\)
   (#x3009 ?\)
   (#x300a ?\)
   (#x300b ?\)
   (#x300c ?\)
   (#x300d ?\)
   (#x300e ?\)
   (#x300f ?\)
   (#x3010 ?\)
   (#x3011 ?\)
   (#x3012 ?)
   (#x3013 ?)
   (#x3014 ?\)
   (#x3015 ?\)
   (#x301c ?)
   (#x3041 ?)
   (#x3042 ?)
   (#x3043 ?)
   (#x3044 ?)
   (#x3045 ?)
   (#x3046 ?)
   (#x3047 ?)
   (#x3048 ?)
   (#x3049 ?)
   (#x304a ?)
   (#x304b ?)
   (#x304c ?)
   (#x304d ?)
   (#x304e ?)
   (#x304f ?)
   (#x3050 ?)
   (#x3051 ?)
   (#x3052 ?)
   (#x3053 ?)
   (#x3054 ?)
   (#x3055 ?)
   (#x3056 ?)
   (#x3057 ?)
   (#x3058 ?)
   (#x3059 ?)
   (#x305a ?)
   (#x305b ?)
   (#x305c ?)
   (#x305d ?)
   (#x305e ?)
   (#x305f ?)
   (#x3060 ?)
   (#x3061 ?)
   (#x3062 ?)
   (#x3063 ?)
   (#x3064 ?)
   (#x3065 ?)
   (#x3066 ?)
   (#x3067 ?)
   (#x3068 ?)
   (#x3069 ?)
   (#x306a ?)
   (#x306b ?)
   (#x306c ?)
   (#x306d ?)
   (#x306e ?)
   (#x306f ?)
   (#x3070 ?)
   (#x3071 ?)
   (#x3072 ?)
   (#x3073 ?)
   (#x3074 ?)
   (#x3075 ?)
   (#x3076 ?)
   (#x3077 ?)
   (#x3078 ?)
   (#x3079 ?)
   (#x307a ?)
   (#x307b ?)
   (#x307c ?)
   (#x307d ?)
   (#x307e ?)
   (#x307f ?)
   (#x3080 ?)
   (#x3081 ?)
   (#x3082 ?)
   (#x3083 ?)
   (#x3084 ?)
   (#x3085 ?)
   (#x3086 ?)
   (#x3087 ?)
   (#x3088 ?)
   (#x3089 ?)
   (#x308a ?)
   (#x308b ?)
   (#x308c ?)
   (#x308d ?)
   (#x308e ?)
   (#x308f ?)
   (#x3090 ?)
   (#x3091 ?)
   (#x3092 ?)
   (#x3093 ?)
   (#x309b ?)
   (#x309c ?)
   (#x309d ?)
   (#x309e ?)
   (#x30a1 ?)
   (#x30a2 ?)
   (#x30a3 ?)
   (#x30a4 ?)
   (#x30a5 ?)
   (#x30a6 ?)
   (#x30a7 ?)
   (#x30a8 ?)
   (#x30a9 ?)
   (#x30aa ?)
   (#x30ab ?)
   (#x30ac ?)
   (#x30ad ?)
   (#x30ae ?)
   (#x30af ?)
   (#x30b0 ?)
   (#x30b1 ?)
   (#x30b2 ?)
   (#x30b3 ?)
   (#x30b4 ?)
   (#x30b5 ?)
   (#x30b6 ?)
   (#x30b7 ?)
   (#x30b8 ?)
   (#x30b9 ?)
   (#x30ba ?)
   (#x30bb ?)
   (#x30bc ?)
   (#x30bd ?)
   (#x30be ?)
   (#x30bf ?)
   (#x30c0 ?)
   (#x30c1 ?)
   (#x30c2 ?)
   (#x30c3 ?)
   (#x30c4 ?)
   (#x30c5 ?)
   (#x30c6 ?)
   (#x30c7 ?)
   (#x30c8 ?)
   (#x30c9 ?)
   (#x30ca ?)
   (#x30cb ?)
   (#x30cc ?)
   (#x30cd ?)
   (#x30ce ?)
   (#x30cf ?)
   (#x30d0 ?)
   (#x30d1 ?)
   (#x30d2 ?)
   (#x30d3 ?)
   (#x30d4 ?)
   (#x30d5 ?)
   (#x30d6 ?)
   (#x30d7 ?)
   (#x30d8 ?)
   (#x30d9 ?)
   (#x30da ?)
   (#x30db ?)
   (#x30dc ?)
   (#x30dd ?)
   (#x30de ?)
   (#x30df ?)
   (#x30e0 ?)
   (#x30e1 ?)
   (#x30e2 ?)
   (#x30e3 ?)
   (#x30e4 ?)
   (#x30e5 ?)
   (#x30e6 ?)
   (#x30e7 ?)
   (#x30e8 ?)
   (#x30e9 ?)
   (#x30ea ?)
   (#x30eb ?)
   (#x30ec ?)
   (#x30ed ?)
   (#x30ee ?)
   (#x30ef ?)
   (#x30f0 ?)
   (#x30f1 ?)
   (#x30f2 ?)
   (#x30f3 ?)
   (#x30f4 ?)
   (#x30f5 ?)
   (#x30f6 ?)
   (#x30fb ?)
   (#x30fc ?)
   (#x30fd ?)
   (#x30fe ?)
   (#x4e00 ?)
   (#x4e01 ?)
   (#x4e03 ?)
   (#x4e07 ?)
   (#x4e08 ?)
   (#x4e09 ?)
   (#x4e0a ?)
   (#x4e0b ?)
   (#x4e0d ?)
   (#x4e0e ?Ϳ)
   (#x4e10 ?Т)
   (#x4e11 ?)
   (#x4e14 ?)
   (#x4e15 ?У)
   (#x4e16 ?)
   (#x4e17 ?)
   (#x4e18 ?)
   (#x4e19 ?ʺ)
   (#x4e1e ?)
   (#x4e21 ?ξ)
   (#x4e26 ?)
   (#x4e2a ?Ф)
   (#x4e2d ?)
   (#x4e31 ?Х)
   (#x4e32 ?)
   (#x4e36 ?Ц)
   (#x4e38 ?)
   (#x4e39 ?ð)
   (#x4e3b ?)
   (#x4e3c ?Ч)
   (#x4e3f ?Ш)
   (#x4e42 ?Щ)
   (#x4e43 ?ǵ)
   (#x4e45 ?)
   (#x4e4b ?Ƿ)
   (#x4e4d ?)
   (#x4e4e ?)
   (#x4e4f ?˳)
   (#x4e55 ?)
   (#x4e56 ?Ъ)
   (#x4e57 ?)
   (#x4e58 ?Ы)
   (#x4e59 ?)
   (#x4e5d ?)
   (#x4e5e ?)
   (#x4e5f ?)
   (#x4e62 ?֦)
   (#x4e71 ?)
   (#x4e73 ?)
   (#x4e7e ?)
   (#x4e80 ?)
   (#x4e82 ?Ь)
   (#x4e85 ?Э)
   (#x4e86 ?λ)
   (#x4e88 ?ͽ)
   (#x4e89 ?)
   (#x4e8a ?Я)
   (#x4e8b ?)
   (#x4e8c ?)
   (#x4e8e ?в)
   (#x4e91 ?)
   (#x4e92 ?)
   (#x4e94 ?)
   (#x4e95 ?)
   (#x4e98 ?)
   (#x4e99 ?)
   (#x4e9b ?)
   (#x4e9c ?)
   (#x4e9e ?г)
   (#x4e9f ?д)
   (#x4ea0 ?е)
   (#x4ea1 ?˴)
   (#x4ea2 ?ж)
   (#x4ea4 ?)
   (#x4ea5 ?)
   (#x4ea6 ?)
   (#x4ea8 ?)
   (#x4eab ?)
   (#x4eac ?)
   (#x4ead ?)
   (#x4eae ?μ)
   (#x4eb0 ?з)
   (#x4eb3 ?и)
   (#x4eb6 ?й)
   (#x4eba ?)
   (#x4ec0 ?)
   (#x4ec1 ?)
   (#x4ec2 ?о)
   (#x4ec4 ?м)
   (#x4ec6 ?н)
   (#x4ec7 ?)
   (#x4eca ?)
   (#x4ecb ?)
   (#x4ecd ?л)
   (#x4ece ?к)
   (#x4ecf ?ʩ)
   (#x4ed4 ?)
   (#x4ed5 ?)
   (#x4ed6 ?¾)
   (#x4ed7 ?п)
   (#x4ed8 ?)
   (#x4ed9 ?)
   (#x4edd ?)
   (#x4ede ?)
   (#x4edf ?)
   (#x4ee3 ?)
   (#x4ee4 ?)
   (#x4ee5 ?)
   (#x4eed ?)
   (#x4eee ?)
   (#x4ef0 ?)
   (#x4ef2 ?)
   (#x4ef6 ?)
   (#x4ef7 ?)
   (#x4efb ?Ǥ)
   (#x4f01 ?)
   (#x4f09 ?)
   (#x4f0a ?)
   (#x4f0d ?)
   (#x4f0e ?)
   (#x4f0f ?)
   (#x4f10 ?Ȳ)
   (#x4f11 ?)
   (#x4f1a ?)
   (#x4f1c ?)
   (#x4f1d ?)
   (#x4f2f ?)
   (#x4f30 ?)
   (#x4f34 ?ȼ)
   (#x4f36 ?)
   (#x4f38 ?)
   (#x4f3a ?)
   (#x4f3c ?)
   (#x4f3d ?)
   (#x4f43 ?)
   (#x4f46 ?â)
   (#x4f47 ?)
   (#x4f4d ?)
   (#x4f4e ?)
   (#x4f4f ?)
   (#x4f50 ?)
   (#x4f51 ?ͤ)
   (#x4f53 ?)
   (#x4f55 ?)
   (#x4f57 ?)
   (#x4f59 ?;)
   (#x4f5a ?)
   (#x4f5b ?)
   (#x4f5c ?)
   (#x4f5d ?)
   (#x4f5e ?դ)
   (#x4f69 ?)
   (#x4f6f ?)
   (#x4f70 ?)
   (#x4f73 ?)
   (#x4f75 ?ʻ)
   (#x4f76 ?)
   (#x4f7b ?)
   (#x4f7c ?)
   (#x4f7f ?)
   (#x4f83 ?)
   (#x4f86 ?)
   (#x4f88 ?)
   (#x4f8b ?)
   (#x4f8d ?)
   (#x4f8f ?)
   (#x4f91 ?)
   (#x4f96 ?)
   (#x4f98 ?)
   (#x4f9b ?)
   (#x4f9d ?)
   (#x4fa0 ?)
   (#x4fa1 ?)
   (#x4fab ?ե)
   (#x4fad ?)
   (#x4fae ?)
   (#x4faf ?)
   (#x4fb5 ?)
   (#x4fb6 ?η)
   (#x4fbf ?)
   (#x4fc2 ?)
   (#x4fc3 ?¥)
   (#x4fc4 ?)
   (#x4fca ?)
   (#x4fce ?)
   (#x4fd0 ?)
   (#x4fd1 ?)
   (#x4fd4 ?)
   (#x4fd7 ?¯)
   (#x4fd8 ?)
   (#x4fda ?)
   (#x4fdb ?)
   (#x4fdd ?)
   (#x4fdf ?)
   (#x4fe1 ?)
   (#x4fe3 ?)
   (#x4fe4 ?)
   (#x4fe5 ?)
   (#x4fee ?)
   (#x4fef ?)
   (#x4ff3 ?)
   (#x4ff5 ?ɶ)
   (#x4ff6 ?)
   (#x4ff8 ?)
   (#x4ffa ?)
   (#x4ffe ?)
   (#x5005 ?)
   (#x5006 ?)
   (#x5009 ?)
   (#x500b ?)
   (#x500d ?)
   (#x500f ?)
   (#x5011 ?)
   (#x5012 ?)
   (#x5014 ?)
   (#x5016 ?)
   (#x5019 ?)
   (#x501a ?)
   (#x501f ?)
   (#x5021 ?)
   (#x5023 ?)
   (#x5024 ?)
   (#x5025 ?)
   (#x5026 ?)
   (#x5028 ?)
   (#x5029 ?)
   (#x502a ?)
   (#x502b ?)
   (#x502c ?)
   (#x502d ?)
   (#x5036 ?)
   (#x5039 ?)
   (#x5043 ?)
   (#x5047 ?)
   (#x5048 ?)
   (#x5049 ?)
   (#x504f ?)
   (#x5050 ?)
   (#x5055 ?)
   (#x5056 ?)
   (#x505a ?)
   (#x505c ?)
   (#x5065 ?)
   (#x506c ?)
   (#x5072 ?)
   (#x5074 ?¦)
   (#x5075 ?)
   (#x5076 ?)
   (#x5078 ?)
   (#x507d ?)
   (#x5080 ?)
   (#x5085 ?)
   (#x508d ?˵)
   (#x5091 ?)
   (#x5098 ?)
   (#x5099 ?)
   (#x509a ?)
   (#x50ac ?)
   (#x50ad ?)
   (#x50b2 ?)
   (#x50b3 ?ѣ)
   (#x50b4 ?)
   (#x50b5 ?)
   (#x50b7 ?)
   (#x50be ?)
   (#x50c2 ?Ѥ)
   (#x50c5 ?)
   (#x50c9 ?ѡ)
   (#x50ca ?Ѣ)
   (#x50cd ?Ư)
   (#x50cf ?)
   (#x50d1 ?)
   (#x50d5 ?)
   (#x50d6 ?ѥ)
   (#x50da ?ν)
   (#x50de ?Ѧ)
   (#x50e3 ?ѩ)
   (#x50e5 ?ѧ)
   (#x50e7 ?)
   (#x50ed ?Ѩ)
   (#x50ee ?Ѫ)
   (#x50f5 ?Ѭ)
   (#x50f9 ?ѫ)
   (#x50fb ?)
   (#x5100 ?)
   (#x5101 ?Ѯ)
   (#x5102 ?ѯ)
   (#x5104 ?)
   (#x5109 ?ѭ)
   (#x5112 ?)
   (#x5114 ?Ѳ)
   (#x5115 ?ѱ)
   (#x5116 ?Ѱ)
   (#x5118 ?)
   (#x511a ?ѳ)
   (#x511f ?)
   (#x5121 ?Ѵ)
   (#x512a ?ͥ)
   (#x5132 ?)
   (#x5137 ?Ѷ)
   (#x513a ?ѵ)
   (#x513b ?Ѹ)
   (#x513c ?ѷ)
   (#x513f ?ѹ)
   (#x5140 ?Ѻ)
   (#x5141 ?)
   (#x5143 ?)
   (#x5144 ?)
   (#x5145 ?)
   (#x5146 ?)
   (#x5147 ?)
   (#x5148 ?)
   (#x5149 ?)
   (#x514b ?)
   (#x514c ?Ѽ)
   (#x514d ?)
   (#x514e ?)
   (#x5150 ?)
   (#x5152 ?ѻ)
   (#x5154 ?ѽ)
   (#x515a ?)
   (#x515c ?)
   (#x5162 ?Ѿ)
   (#x5165 ?)
   (#x5168 ?)
   (#x5169 ?)
   (#x516a ?)
   (#x516b ?Ȭ)
   (#x516c ?)
   (#x516d ?ϻ)
   (#x516e ?)
   (#x5171 ?)
   (#x5175 ?ʼ)
   (#x5176 ?¶)
   (#x5177 ?)
   (#x5178 ?ŵ)
   (#x517c ?)
   (#x5180 ?)
   (#x5182 ?)
   (#x5185 ?)
   (#x5186 ?)
   (#x5189 ?)
   (#x518a ?)
   (#x518c ?)
   (#x518d ?)
   (#x518f ?)
   (#x5190 ?)
   (#x5191 ?)
   (#x5192 ?)
   (#x5193 ?)
   (#x5195 ?)
   (#x5196 ?)
   (#x5197 ?)
   (#x5199 ?)
   (#x51a0 ?)
   (#x51a2 ?)
   (#x51a4 ?)
   (#x51a5 ?̽)
   (#x51a6 ?)
   (#x51a8 ?)
   (#x51a9 ?)
   (#x51aa ?)
   (#x51ab ?)
   (#x51ac ?)
   (#x51b0 ?)
   (#x51b1 ?)
   (#x51b2 ?)
   (#x51b3 ?)
   (#x51b4 ?)
   (#x51b5 ?)
   (#x51b6 ?)
   (#x51b7 ?)
   (#x51bd ?)
   (#x51c4 ?)
   (#x51c5 ?)
   (#x51c6 ?)
   (#x51c9 ?)
   (#x51cb ?)
   (#x51cc ?ο)
   (#x51cd ?)
   (#x51d6 ?)
   (#x51db ?)
   (#x51dc ?)
   (#x51dd ?)
   (#x51e0 ?)
   (#x51e1 ?)
   (#x51e6 ?)
   (#x51e7 ?)
   (#x51e9 ?)
   (#x51ea ?)
   (#x51ed ?)
   (#x51f0 ?)
   (#x51f1 ?)
   (#x51f5 ?)
   (#x51f6 ?)
   (#x51f8 ?)
   (#x51f9 ?)
   (#x51fa ?)
   (#x51fd ?ȡ)
   (#x51fe ?)
   (#x5200 ?)
   (#x5203 ?)
   (#x5204 ?)
   (#x5206 ?ʬ)
   (#x5207 ?)
   (#x5208 ?)
   (#x520a ?)
   (#x520b ?)
   (#x520e ?)
   (#x5211 ?)
   (#x5214 ?)
   (#x5217 ?)
   (#x521d ?)
   (#x5224 ?Ƚ)
   (#x5225 ?)
   (#x5227 ?)
   (#x5229 ?)
   (#x522a ?)
   (#x522e ?)
   (#x5230 ?)
   (#x5233 ?)
   (#x5236 ?)
   (#x5237 ?)
   (#x5238 ?)
   (#x5239 ?)
   (#x523a ?)
   (#x523b ?)
   (#x5243 ?)
   (#x5244 ?)
   (#x5247 ?§)
   (#x524a ?)
   (#x524b ?)
   (#x524c ?)
   (#x524d ?)
   (#x524f ?)
   (#x5254 ?)
   (#x5256 ?˶)
   (#x525b ?)
   (#x525e ?)
   (#x5263 ?)
   (#x5264 ?)
   (#x5265 ?)
   (#x5269 ?)
   (#x526a ?)
   (#x526f ?)
   (#x5270 ?)
   (#x5271 ?)
   (#x5272 ?)
   (#x5273 ?)
   (#x5274 ?)
   (#x5275 ?)
   (#x527d ?)
   (#x527f ?)
   (#x5283 ?)
   (#x5287 ?)
   (#x5288 ?)
   (#x5289 ?έ)
   (#x528d ?)
   (#x5291 ?)
   (#x5292 ?)
   (#x5294 ?)
   (#x529b ?)
   (#x529f ?)
   (#x52a0 ?)
   (#x52a3 ?)
   (#x52a9 ?)
   (#x52aa ?)
   (#x52ab ?)
   (#x52ac ?Ң)
   (#x52ad ?ң)
   (#x52b1 ?)
   (#x52b4 ?ϫ)
   (#x52b5 ?ҥ)
   (#x52b9 ?)
   (#x52bc ?Ҥ)
   (#x52be ?)
   (#x52c1 ?Ҧ)
   (#x52c3 ?)
   (#x52c5 ?ļ)
   (#x52c7 ?ͦ)
   (#x52c9 ?)
   (#x52cd ?ҧ)
   (#x52d2 ?)
   (#x52d5 ?ư)
   (#x52d7 ?Ҩ)
   (#x52d8 ?)
   (#x52d9 ?̳)
   (#x52dd ?)
   (#x52de ?ҩ)
   (#x52df ?)
   (#x52e0 ?ҭ)
   (#x52e2 ?)
   (#x52e3 ?Ҫ)
   (#x52e4 ?)
   (#x52e6 ?ҫ)
   (#x52e7 ?)
   (#x52f2 ?)
   (#x52f3 ?Ү)
   (#x52f5 ?ү)
   (#x52f8 ?Ұ)
   (#x52f9 ?ұ)
   (#x52fa ?)
   (#x52fe ?)
   (#x52ff ?)
   (#x5301 ?)
   (#x5302 ?)
   (#x5305 ?)
   (#x5306 ?Ҳ)
   (#x5308 ?ҳ)
   (#x530d ?ҵ)
   (#x530f ?ҷ)
   (#x5310 ?Ҷ)
   (#x5315 ?Ҹ)
   (#x5316 ?)
   (#x5317 ?)
   (#x5319 ?)
   (#x531a ?ҹ)
   (#x531d ?)
   (#x5320 ?)
   (#x5321 ?)
   (#x5323 ?Һ)
   (#x532a ?)
   (#x532f ?һ)
   (#x5331 ?Ҽ)
   (#x5333 ?ҽ)
   (#x5338 ?Ҿ)
   (#x5339 ?ɤ)
   (#x533a ?)
   (#x533b ?)
   (#x533f ?ƿ)
   (#x5340 ?ҿ)
   (#x5341 ?)
   (#x5343 ?)
   (#x5345 ?)
   (#x5346 ?)
   (#x5347 ?)
   (#x5348 ?)
   (#x5349 ?)
   (#x534a ?Ⱦ)
   (#x534d ?)
   (#x5351 ?)
   (#x5352 ?´)
   (#x5353 ?)
   (#x5354 ?)
   (#x5357 ?)
   (#x5358 ?ñ)
   (#x535a ?)
   (#x535c ?)
   (#x535e ?)
   (#x5360 ?)
   (#x5366 ?)
   (#x5369 ?)
   (#x536e ?)
   (#x536f ?)
   (#x5370 ?)
   (#x5371 ?)
   (#x5373 ?¨)
   (#x5374 ?)
   (#x5375 ?)
   (#x5377 ?)
   (#x5378 ?)
   (#x537b ?)
   (#x537f ?)
   (#x5382 ?)
   (#x5384 ?)
   (#x5396 ?)
   (#x5398 ?)
   (#x539a ?)
   (#x539f ?)
   (#x53a0 ?)
   (#x53a5 ?)
   (#x53a6 ?)
   (#x53a8 ?)
   (#x53a9 ?)
   (#x53ad ?)
   (#x53ae ?)
   (#x53b0 ?)
   (#x53b3 ?)
   (#x53b6 ?)
   (#x53bb ?)
   (#x53c2 ?)
   (#x53c3 ?)
   (#x53c8 ?)
   (#x53c9 ?)
   (#x53ca ?)
   (#x53cb ?ͧ)
   (#x53cc ?)
   (#x53cd ?ȿ)
   (#x53ce ?)
   (#x53d4 ?)
   (#x53d6 ?)
   (#x53d7 ?)
   (#x53d9 ?)
   (#x53db ?)
   (#x53df ?)
   (#x53e1 ?)
   (#x53e2 ?)
   (#x53e3 ?)
   (#x53e4 ?)
   (#x53e5 ?)
   (#x53e8 ?)
   (#x53e9 ?á)
   (#x53ea ?)
   (#x53eb ?)
   (#x53ec ?)
   (#x53ed ?)
   (#x53ee ?)
   (#x53ef ?)
   (#x53f0 ?)
   (#x53f1 ?)
   (#x53f2 ?)
   (#x53f3 ?)
   (#x53f6 ?)
   (#x53f7 ?)
   (#x53f8 ?)
   (#x53fa ?)
   (#x5401 ?)
   (#x5403 ?)
   (#x5404 ?)
   (#x5408 ?)
   (#x5409 ?)
   (#x540a ?)
   (#x540b ?)
   (#x540c ?Ʊ)
   (#x540d ?̾)
   (#x540e ?)
   (#x540f ?)
   (#x5410 ?)
   (#x5411 ?)
   (#x541b ?)
   (#x541d ?)
   (#x541f ?)
   (#x5420 ?)
   (#x5426 ?)
   (#x5429 ?)
   (#x542b ?)
   (#x542c ?)
   (#x542d ?)
   (#x542e ?)
   (#x5436 ?)
   (#x5438 ?)
   (#x5439 ?)
   (#x543b ?ʭ)
   (#x543c ?)
   (#x543d ?)
   (#x543e ?)
   (#x5440 ?)
   (#x5442 ?Ϥ)
   (#x5446 ?)
   (#x5448 ?)
   (#x5449 ?)
   (#x544a ?)
   (#x544e ?)
   (#x5451 ?)
   (#x545f ?)
   (#x5468 ?)
   (#x546a ?)
   (#x5470 ?)
   (#x5471 ?)
   (#x5473 ?̣)
   (#x5475 ?)
   (#x5476 ?)
   (#x5477 ?)
   (#x547b ?)
   (#x547c ?)
   (#x547d ?̿)
   (#x5480 ?)
   (#x5484 ?)
   (#x5486 ?)
   (#x548b ?)
   (#x548c ?)
   (#x548e ?)
   (#x548f ?)
   (#x5490 ?)
   (#x5492 ?)
   (#x54a2 ?)
   (#x54a4 ?ӣ)
   (#x54a5 ?)
   (#x54a8 ?)
   (#x54ab ?ӡ)
   (#x54ac ?)
   (#x54af ?Ӿ)
   (#x54b2 ?)
   (#x54b3 ?)
   (#x54b8 ?)
   (#x54bc ?ӥ)
   (#x54bd ?)
   (#x54be ?Ӥ)
   (#x54c0 ?)
   (#x54c1 ?)
   (#x54c2 ?Ӣ)
   (#x54c4 ?)
   (#x54c7 ?)
   (#x54c8 ?)
   (#x54c9 ?)
   (#x54d8 ?Ӧ)
   (#x54e1 ?)
   (#x54e2 ?ӯ)
   (#x54e5 ?ӧ)
   (#x54e6 ?Ө)
   (#x54e8 ?)
   (#x54e9 ?)
   (#x54ed ?ӭ)
   (#x54ee ?Ӭ)
   (#x54f2 ?ů)
   (#x54fa ?Ӯ)
   (#x54fd ?ӫ)
   (#x5504 ?)
   (#x5506 ?)
   (#x5507 ?)
   (#x550f ?ө)
   (#x5510 ?)
   (#x5514 ?Ӫ)
   (#x5516 ?)
   (#x552e ?Ӵ)
   (#x552f ?ͣ)
   (#x5531 ?)
   (#x5533 ?Ӻ)
   (#x5538 ?ӹ)
   (#x5539 ?Ӱ)
   (#x553e ?)
   (#x5540 ?ӱ)
   (#x5544 ?)
   (#x5545 ?Ӷ)
   (#x5546 ?)
   (#x554c ?ӳ)
   (#x554f ?)
   (#x5553 ?)
   (#x5556 ?ӷ)
   (#x5557 ?Ӹ)
   (#x555c ?ӵ)
   (#x555d ?ӻ)
   (#x5563 ?Ӳ)
   (#x557b ?)
   (#x557c ?)
   (#x557e ?)
   (#x5580 ?ӽ)
   (#x5583 ?)
   (#x5584 ?)
   (#x5587 ?)
   (#x5589 ?)
   (#x558a ?ӿ)
   (#x558b ?)
   (#x5598 ?)
   (#x5599 ?Ӽ)
   (#x559a ?)
   (#x559c ?)
   (#x559d ?)
   (#x559e ?)
   (#x559f ?)
   (#x55a7 ?)
   (#x55a8 ?)
   (#x55a9 ?)
   (#x55aa ?)
   (#x55ab ?)
   (#x55ac ?)
   (#x55ae ?)
   (#x55b0 ?)
   (#x55b6 ?)
   (#x55c4 ?)
   (#x55c5 ?)
   (#x55c7 ?ԧ)
   (#x55d4 ?)
   (#x55da ?)
   (#x55dc ?)
   (#x55df ?)
   (#x55e3 ?)
   (#x55e4 ?)
   (#x55f7 ?)
   (#x55f9 ?)
   (#x55fd ?)
   (#x55fe ?)
   (#x5606 ?ò)
   (#x5609 ?)
   (#x5614 ?)
   (#x5616 ?)
   (#x5617 ?)
   (#x5618 ?)
   (#x561b ?)
   (#x5629 ?)
   (#x562f ?)
   (#x5631 ?)
   (#x5632 ?)
   (#x5634 ?)
   (#x5636 ?)
   (#x5638 ?)
   (#x5642 ?)
   (#x564c ?)
   (#x564e ?)
   (#x5650 ?)
   (#x565b ?)
   (#x5664 ?)
   (#x5668 ?)
   (#x566a ?)
   (#x566b ?)
   (#x566c ?)
   (#x5674 ?ʮ)
   (#x5678 ?)
   (#x567a ?ȸ)
   (#x5680 ?)
   (#x5686 ?)
   (#x5687 ?)
   (#x568a ?)
   (#x568f ?)
   (#x5694 ?)
   (#x56a0 ?)
   (#x56a2 ?ǹ)
   (#x56a5 ?)
   (#x56ae ?)
   (#x56b4 ?)
   (#x56b6 ?)
   (#x56bc ?)
   (#x56c0 ?)
   (#x56c1 ?)
   (#x56c2 ?)
   (#x56c3 ?)
   (#x56c8 ?)
   (#x56ce ?)
   (#x56d1 ?)
   (#x56d3 ?)
   (#x56d7 ?)
   (#x56d8 ?)
   (#x56da ?)
   (#x56db ?)
   (#x56de ?)
   (#x56e0 ?)
   (#x56e3 ?)
   (#x56ee ?)
   (#x56f0 ?)
   (#x56f2 ?)
   (#x56f3 ?)
   (#x56f9 ?)
   (#x56fa ?)
   (#x56fd ?)
   (#x56ff ?)
   (#x5700 ?)
   (#x5703 ?)
   (#x5704 ?)
   (#x5708 ?ԡ)
   (#x5709 ?)
   (#x570b ?Ԣ)
   (#x570d ?ԣ)
   (#x570f ?)
   (#x5712 ?)
   (#x5713 ?Ԥ)
   (#x5716 ?Ԧ)
   (#x5718 ?ԥ)
   (#x571c ?Ԩ)
   (#x571f ?)
   (#x5726 ?ԩ)
   (#x5727 ?)
   (#x5728 ?)
   (#x572d ?)
   (#x5730 ?)
   (#x5737 ?Ԫ)
   (#x5738 ?ԫ)
   (#x573b ?ԭ)
   (#x5740 ?Ԯ)
   (#x5742 ?)
   (#x5747 ?)
   (#x574a ?˷)
   (#x574e ?Ԭ)
   (#x574f ?ԯ)
   (#x5750 ?)
   (#x5751 ?)
   (#x5761 ?Գ)
   (#x5764 ?)
   (#x5766 ?ó)
   (#x5769 ?԰)
   (#x576a ?)
   (#x577f ?Դ)
   (#x5782 ?)
   (#x5788 ?Բ)
   (#x5789 ?Ե)
   (#x578b ?)
   (#x5793 ?Զ)
   (#x57a0 ?Է)
   (#x57a2 ?)
   (#x57a3 ?)
   (#x57a4 ?Թ)
   (#x57aa ?Ժ)
   (#x57b0 ?Ի)
   (#x57b3 ?Ը)
   (#x57c0 ?Ա)
   (#x57c3 ?Լ)
   (#x57c6 ?Խ)
   (#x57cb ?)
   (#x57ce ?)
   (#x57d2 ?Կ)
   (#x57d3 ?)
   (#x57d4 ?Ծ)
   (#x57d6 ?)
   (#x57dc ?Ǹ)
   (#x57df ?)
   (#x57e0 ?)
   (#x57e3 ?)
   (#x57f4 ?)
   (#x57f7 ?)
   (#x57f9 ?)
   (#x57fa ?)
   (#x57fc ?)
   (#x5800 ?)
   (#x5802 ?Ʋ)
   (#x5805 ?)
   (#x5806 ?)
   (#x580a ?)
   (#x580b ?)
   (#x5815 ?)
   (#x5819 ?)
   (#x581d ?)
   (#x5821 ?)
   (#x5824 ?)
   (#x582a ?)
   (#x582f ?)
   (#x5830 ?)
   (#x5831 ?)
   (#x5834 ?)
   (#x5835 ?)
   (#x583a ?)
   (#x583d ?)
   (#x5840 ?ʽ)
   (#x5841 ?)
   (#x584a ?)
   (#x584b ?)
   (#x5851 ?)
   (#x5852 ?)
   (#x5854 ?)
   (#x5857 ?)
   (#x5858 ?)
   (#x5859 ?ȹ)
   (#x585a ?)
   (#x585e ?)
   (#x5862 ?)
   (#x5869 ?)
   (#x586b ?Ŷ)
   (#x5870 ?)
   (#x5872 ?)
   (#x5875 ?)
   (#x5879 ?)
   (#x587e ?)
   (#x5883 ?)
   (#x5885 ?)
   (#x5893 ?)
   (#x5897 ?)
   (#x589c ?)
   (#x589f ?)
   (#x58a8 ?)
   (#x58ab ?)
   (#x58ae ?)
   (#x58b3 ?ʯ)
   (#x58b8 ?)
   (#x58b9 ?)
   (#x58ba ?)
   (#x58bb ?)
   (#x58be ?)
   (#x58c1 ?)
   (#x58c5 ?)
   (#x58c7 ?)
   (#x58ca ?)
   (#x58cc ?)
   (#x58d1 ?)
   (#x58d3 ?)
   (#x58d5 ?)
   (#x58d7 ?)
   (#x58d8 ?)
   (#x58d9 ?)
   (#x58dc ?)
   (#x58de ?)
   (#x58df ?)
   (#x58e4 ?)
   (#x58e5 ?)
   (#x58eb ?)
   (#x58ec ?)
   (#x58ee ?)
   (#x58ef ?)
   (#x58f0 ?)
   (#x58f1 ?)
   (#x58f2 ?)
   (#x58f7 ?)
   (#x58f9 ?)
   (#x58fa ?)
   (#x58fb ?)
   (#x58fc ?)
   (#x58fd ?)
   (#x5902 ?)
   (#x5909 ?)
   (#x590a ?)
   (#x590f ?)
   (#x5910 ?)
   (#x5915 ?ͼ)
   (#x5916 ?)
   (#x5918 ?)
   (#x5919 ?)
   (#x591a ?¿)
   (#x591b ?)
   (#x591c ?)
   (#x5922 ?̴)
   (#x5925 ?)
   (#x5927 ?)
   (#x5929 ?ŷ)
   (#x592a ?)
   (#x592b ?)
   (#x592c ?)
   (#x592d ?)
   (#x592e ?)
   (#x5931 ?)
   (#x5932 ?)
   (#x5937 ?)
   (#x5938 ?)
   (#x593e ?)
   (#x5944 ?)
   (#x5947 ?)
   (#x5948 ?)
   (#x5949 ?)
   (#x594e ?)
   (#x594f ?)
   (#x5950 ?)
   (#x5951 ?)
   (#x5954 ?)
   (#x5955 ?)
   (#x5957 ?)
   (#x5958 ?)
   (#x595a ?)
   (#x5960 ?)
   (#x5962 ?)
   (#x5965 ?)
   (#x5967 ?)
   (#x5968 ?)
   (#x5969 ?)
   (#x596a ?å)
   (#x596c ?)
   (#x596e ?ʳ)
   (#x5973 ?)
   (#x5974 ?)
   (#x5978 ?ա)
   (#x597d ?)
   (#x5981 ?բ)
   (#x5982 ?ǡ)
   (#x5983 ?)
   (#x5984 ?)
   (#x598a ?ǥ)
   (#x598d ?ի)
   (#x5993 ?)
   (#x5996 ?)
   (#x5999 ?̯)
   (#x599b ?֬)
   (#x599d ?գ)
   (#x59a3 ?զ)
   (#x59a5 ?)
   (#x59a8 ?˸)
   (#x59ac ?)
   (#x59b2 ?է)
   (#x59b9 ?)
   (#x59bb ?)
   (#x59be ?)
   (#x59c6 ?ը)
   (#x59c9 ?)
   (#x59cb ?)
   (#x59d0 ?)
   (#x59d1 ?)
   (#x59d3 ?)
   (#x59d4 ?)
   (#x59d9 ?լ)
   (#x59da ?խ)
   (#x59dc ?ժ)
   (#x59e5 ?)
   (#x59e6 ?)
   (#x59e8 ?թ)
   (#x59ea ?)
   (#x59eb ?ɱ)
   (#x59f6 ?)
   (#x59fb ?)
   (#x59ff ?)
   (#x5a01 ?)
   (#x5a03 ?)
   (#x5a09 ?ղ)
   (#x5a11 ?հ)
   (#x5a18 ?̼)
   (#x5a1a ?ճ)
   (#x5a1c ?ձ)
   (#x5a1f ?կ)
   (#x5a20 ?)
   (#x5a25 ?ծ)
   (#x5a29 ?)
   (#x5a2f ?)
   (#x5a35 ?շ)
   (#x5a36 ?ո)
   (#x5a3c ?)
   (#x5a40 ?մ)
   (#x5a41 ?Ϭ)
   (#x5a46 ?)
   (#x5a49 ?ն)
   (#x5a5a ?)
   (#x5a62 ?չ)
   (#x5a66 ?)
   (#x5a6a ?պ)
   (#x5a6c ?յ)
   (#x5a7f ?̻)
   (#x5a92 ?)
   (#x5a9a ?ջ)
   (#x5a9b ?ɲ)
   (#x5abc ?ռ)
   (#x5abd ?)
   (#x5abe ?ս)
   (#x5ac1 ?)
   (#x5ac2 ?տ)
   (#x5ac9 ?)
   (#x5acb ?վ)
   (#x5acc ?)
   (#x5ad0 ?)
   (#x5ad6 ?)
   (#x5ad7 ?)
   (#x5ae1 ?)
   (#x5ae3 ?)
   (#x5ae6 ?)
   (#x5ae9 ?)
   (#x5afa ?)
   (#x5afb ?)
   (#x5b09 ?)
   (#x5b0b ?)
   (#x5b0c ?)
   (#x5b16 ?)
   (#x5b22 ?)
   (#x5b2a ?)
   (#x5b2c ?)
   (#x5b30 ?)
   (#x5b32 ?)
   (#x5b36 ?)
   (#x5b3e ?)
   (#x5b40 ?)
   (#x5b43 ?)
   (#x5b45 ?)
   (#x5b50 ?)
   (#x5b51 ?)
   (#x5b54 ?)
   (#x5b55 ?)
   (#x5b57 ?)
   (#x5b58 ?¸)
   (#x5b5a ?)
   (#x5b5b ?)
   (#x5b5c ?)
   (#x5b5d ?)
   (#x5b5f ?)
   (#x5b63 ?)
   (#x5b64 ?)
   (#x5b65 ?)
   (#x5b66 ?)
   (#x5b69 ?)
   (#x5b6b ?¹)
   (#x5b70 ?)
   (#x5b71 ?֣)
   (#x5b73 ?)
   (#x5b75 ?)
   (#x5b78 ?)
   (#x5b7a ?)
   (#x5b80 ?)
   (#x5b83 ?)
   (#x5b85 ?)
   (#x5b87 ?)
   (#x5b88 ?)
   (#x5b89 ?)
   (#x5b8b ?)
   (#x5b8c ?)
   (#x5b8d ?)
   (#x5b8f ?)
   (#x5b95 ?)
   (#x5b97 ?)
   (#x5b98 ?)
   (#x5b99 ?)
   (#x5b9a ?)
   (#x5b9b ?)
   (#x5b9c ?)
   (#x5b9d ?)
   (#x5b9f ?)
   (#x5ba2 ?)
   (#x5ba3 ?)
   (#x5ba4 ?)
   (#x5ba5 ?ͨ)
   (#x5ba6 ?)
   (#x5bae ?)
   (#x5bb0 ?)
   (#x5bb3 ?)
   (#x5bb4 ?)
   (#x5bb5 ?)
   (#x5bb6 ?)
   (#x5bb8 ?)
   (#x5bb9 ?)
   (#x5bbf ?)
   (#x5bc2 ?)
   (#x5bc3 ?)
   (#x5bc4 ?)
   (#x5bc5 ?)
   (#x5bc6 ?̩)
   (#x5bc7 ?)
   (#x5bc9 ?)
   (#x5bcc ?)
   (#x5bd0 ?)
   (#x5bd2 ?)
   (#x5bd3 ?)
   (#x5bd4 ?)
   (#x5bdb ?)
   (#x5bdd ?)
   (#x5bde ?)
   (#x5bdf ?)
   (#x5be1 ?)
   (#x5be2 ?)
   (#x5be4 ?)
   (#x5be5 ?)
   (#x5be6 ?)
   (#x5be7 ?ǫ)
   (#x5be8 ?)
   (#x5be9 ?)
   (#x5beb ?)
   (#x5bee ?)
   (#x5bf0 ?)
   (#x5bf3 ?)
   (#x5bf5 ?)
   (#x5bf6 ?)
   (#x5bf8 ?)
   (#x5bfa ?)
   (#x5bfe ?)
   (#x5bff ?)
   (#x5c01 ?)
   (#x5c02 ?)
   (#x5c04 ?)
   (#x5c05 ?)
   (#x5c06 ?)
   (#x5c07 ?)
   (#x5c08 ?)
   (#x5c09 ?)
   (#x5c0a ?º)
   (#x5c0b ?)
   (#x5c0d ?)
   (#x5c0e ?Ƴ)
   (#x5c0f ?)
   (#x5c11 ?)
   (#x5c13 ?)
   (#x5c16 ?)
   (#x5c1a ?)
   (#x5c20 ?)
   (#x5c22 ?)
   (#x5c24 ?)
   (#x5c28 ?)
   (#x5c2d ?)
   (#x5c31 ?)
   (#x5c38 ?)
   (#x5c39 ?)
   (#x5c3a ?)
   (#x5c3b ?)
   (#x5c3c ?)
   (#x5c3d ?)
   (#x5c3e ?)
   (#x5c3f ?Ǣ)
   (#x5c40 ?)
   (#x5c41 ?)
   (#x5c45 ?)
   (#x5c46 ?)
   (#x5c48 ?)
   (#x5c4a ?)
   (#x5c4b ?)
   (#x5c4d ?)
   (#x5c4e ?)
   (#x5c4f ?֢)
   (#x5c50 ?֡)
   (#x5c51 ?)
   (#x5c53 ?)
   (#x5c55 ?Ÿ)
   (#x5c5e ?°)
   (#x5c60 ?)
   (#x5c61 ?)
   (#x5c64 ?)
   (#x5c65 ?)
   (#x5c6c ?֤)
   (#x5c6e ?֥)
   (#x5c6f ?)
   (#x5c71 ?)
   (#x5c76 ?֧)
   (#x5c79 ?֨)
   (#x5c8c ?֩)
   (#x5c90 ?)
   (#x5c91 ?֪)
   (#x5c94 ?֫)
   (#x5ca1 ?)
   (#x5ca8 ?)
   (#x5ca9 ?)
   (#x5cab ?֭)
   (#x5cac ?̨)
   (#x5cb1 ?)
   (#x5cb3 ?)
   (#x5cb6 ?֯)
   (#x5cb7 ?ֱ)
   (#x5cb8 ?)
   (#x5cbb ?֮)
   (#x5cbc ?ְ)
   (#x5cbe ?ֳ)
   (#x5cc5 ?ֲ)
   (#x5cc7 ?ִ)
   (#x5cd9 ?ֵ)
   (#x5ce0 ?ƽ)
   (#x5ce1 ?)
   (#x5ce8 ?)
   (#x5ce9 ?ֶ)
   (#x5cea ?ֻ)
   (#x5ced ?ֹ)
   (#x5cef ?)
   (#x5cf0 ?)
   (#x5cf6 ?)
   (#x5cfa ?ָ)
   (#x5cfb ?)
   (#x5cfd ?ַ)
   (#x5d07 ?)
   (#x5d0b ?ּ)
   (#x5d0e ?)
   (#x5d11 ?)
   (#x5d14 ?)
   (#x5d15 ?ֽ)
   (#x5d16 ?)
   (#x5d17 ?־)
   (#x5d18 ?)
   (#x5d19 ?)
   (#x5d1a ?)
   (#x5d1b ?)
   (#x5d1f ?)
   (#x5d22 ?)
   (#x5d29 ?)
   (#x5d4b ?)
   (#x5d4c ?)
   (#x5d4e ?)
   (#x5d50 ?)
   (#x5d52 ?)
   (#x5d5c ?ֿ)
   (#x5d69 ?)
   (#x5d6c ?)
   (#x5d6f ?)
   (#x5d73 ?)
   (#x5d76 ?)
   (#x5d82 ?)
   (#x5d84 ?)
   (#x5d87 ?)
   (#x5d8b ?)
   (#x5d8c ?ֺ)
   (#x5d90 ?)
   (#x5d9d ?)
   (#x5da2 ?)
   (#x5dac ?)
   (#x5dae ?)
   (#x5db7 ?)
   (#x5dba ?)
   (#x5dbc ?)
   (#x5dbd ?)
   (#x5dc9 ?)
   (#x5dcc ?)
   (#x5dcd ?)
   (#x5dd2 ?)
   (#x5dd3 ?)
   (#x5dd6 ?)
   (#x5ddb ?)
   (#x5ddd ?)
   (#x5dde ?)
   (#x5de1 ?)
   (#x5de3 ?)
   (#x5de5 ?)
   (#x5de6 ?)
   (#x5de7 ?)
   (#x5de8 ?)
   (#x5deb ?)
   (#x5dee ?)
   (#x5df1 ?)
   (#x5df2 ?)
   (#x5df3 ?̦)
   (#x5df4 ?)
   (#x5df5 ?)
   (#x5df7 ?)
   (#x5dfb ?)
   (#x5dfd ?ç)
   (#x5dfe ?)
   (#x5e02 ?)
   (#x5e03 ?)
   (#x5e06 ?)
   (#x5e0b ?)
   (#x5e0c ?)
   (#x5e11 ?)
   (#x5e16 ?ġ)
   (#x5e19 ?)
   (#x5e1a ?)
   (#x5e1b ?)
   (#x5e1d ?)
   (#x5e25 ?)
   (#x5e2b ?)
   (#x5e2d ?)
   (#x5e2f ?)
   (#x5e30 ?)
   (#x5e33 ?Ģ)
   (#x5e36 ?)
   (#x5e37 ?)
   (#x5e38 ?)
   (#x5e3d ?˹)
   (#x5e40 ?)
   (#x5e43 ?)
   (#x5e44 ?)
   (#x5e45 ?)
   (#x5e47 ?)
   (#x5e4c ?)
   (#x5e4e ?)
   (#x5e54 ?)
   (#x5e55 ?)
   (#x5e57 ?)
   (#x5e5f ?)
   (#x5e61 ?Ȩ)
   (#x5e62 ?)
   (#x5e63 ?ʾ)
   (#x5e64 ?)
   (#x5e72 ?)
   (#x5e73 ?ʿ)
   (#x5e74 ?ǯ)
   (#x5e75 ?)
   (#x5e76 ?)
   (#x5e78 ?)
   (#x5e79 ?)
   (#x5e7a ?)
   (#x5e7b ?)
   (#x5e7c ?)
   (#x5e7d ?ͩ)
   (#x5e7e ?)
   (#x5e7f ?)
   (#x5e81 ?ģ)
   (#x5e83 ?)
   (#x5e84 ?)
   (#x5e87 ?)
   (#x5e8a ?)
   (#x5e8f ?)
   (#x5e95 ?)
   (#x5e96 ?)
   (#x5e97 ?Ź)
   (#x5e9a ?)
   (#x5e9c ?)
   (#x5ea0 ?)
   (#x5ea6 ?)
   (#x5ea7 ?)
   (#x5eab ?)
   (#x5ead ?)
   (#x5eb5 ?)
   (#x5eb6 ?)
   (#x5eb7 ?)
   (#x5eb8 ?)
   (#x5ec1 ?)
   (#x5ec2 ?)
   (#x5ec3 ?)
   (#x5ec8 ?)
   (#x5ec9 ?)
   (#x5eca ?ϭ)
   (#x5ecf ?)
   (#x5ed0 ?)
   (#x5ed3 ?)
   (#x5ed6 ?ס)
   (#x5eda ?פ)
   (#x5edb ?ץ)
   (#x5edd ?ף)
   (#x5edf ?)
   (#x5ee0 ?)
   (#x5ee1 ?ק)
   (#x5ee2 ?צ)
   (#x5ee3 ?ע)
   (#x5ee8 ?ר)
   (#x5ee9 ?ש)
   (#x5eec ?ת)
   (#x5ef0 ?׭)
   (#x5ef1 ?׫)
   (#x5ef3 ?׬)
   (#x5ef4 ?׮)
   (#x5ef6 ?)
   (#x5ef7 ?)
   (#x5ef8 ?ׯ)
   (#x5efa ?)
   (#x5efb ?)
   (#x5efc ?Ƕ)
   (#x5efe ?װ)
   (#x5eff ?)
   (#x5f01 ?)
   (#x5f03 ?ױ)
   (#x5f04 ?Ϯ)
   (#x5f09 ?ײ)
   (#x5f0a ?)
   (#x5f0b ?׵)
   (#x5f0c ?С)
   (#x5f0d ?б)
   (#x5f0f ?)
   (#x5f10 ?)
   (#x5f11 ?׶)
   (#x5f13 ?)
   (#x5f14 ?Ĥ)
   (#x5f15 ?)
   (#x5f16 ?׷)
   (#x5f17 ?ʦ)
   (#x5f18 ?)
   (#x5f1b ?)
   (#x5f1f ?)
   (#x5f25 ?)
   (#x5f26 ?)
   (#x5f27 ?)
   (#x5f29 ?׸)
   (#x5f2d ?׹)
   (#x5f2f ?׿)
   (#x5f31 ?)
   (#x5f35 ?ĥ)
   (#x5f37 ?)
   (#x5f38 ?׺)
   (#x5f3c ?ɫ)
   (#x5f3e ?)
   (#x5f41 ?׻)
   (#x5f48 ?׼)
   (#x5f4a ?)
   (#x5f4c ?׽)
   (#x5f4e ?׾)
   (#x5f51 ?)
   (#x5f53 ?)
   (#x5f56 ?)
   (#x5f57 ?)
   (#x5f59 ?)
   (#x5f5c ?״)
   (#x5f5d ?׳)
   (#x5f61 ?)
   (#x5f62 ?)
   (#x5f66 ?ɧ)
   (#x5f69 ?)
   (#x5f6a ?ɷ)
   (#x5f6b ?Ħ)
   (#x5f6c ?)
   (#x5f6d ?)
   (#x5f70 ?)
   (#x5f71 ?)
   (#x5f73 ?)
   (#x5f77 ?)
   (#x5f79 ?)
   (#x5f7c ?)
   (#x5f7f ?)
   (#x5f80 ?)
   (#x5f81 ?)
   (#x5f82 ?)
   (#x5f83 ?)
   (#x5f84 ?)
   (#x5f85 ?)
   (#x5f87 ?)
   (#x5f88 ?)
   (#x5f8a ?)
   (#x5f8b ?Χ)
   (#x5f8c ?)
   (#x5f90 ?)
   (#x5f91 ?)
   (#x5f92 ?)
   (#x5f93 ?)
   (#x5f97 ?)
   (#x5f98 ?)
   (#x5f99 ?)
   (#x5f9e ?)
   (#x5fa0 ?)
   (#x5fa1 ?)
   (#x5fa8 ?)
   (#x5fa9 ?)
   (#x5faa ?)
   (#x5fad ?)
   (#x5fae ?)
   (#x5fb3 ?)
   (#x5fb4 ?ħ)
   (#x5fb9 ?Ű)
   (#x5fbc ?)
   (#x5fbd ?)
   (#x5fc3 ?)
   (#x5fc5 ?ɬ)
   (#x5fcc ?)
   (#x5fcd ?Ǧ)
   (#x5fd6 ?)
   (#x5fd7 ?)
   (#x5fd8 ?˺)
   (#x5fd9 ?˻)
   (#x5fdc ?)
   (#x5fdd ?)
   (#x5fe0 ?)
   (#x5fe4 ?)
   (#x5feb ?)
   (#x5ff0 ?ح)
   (#x5ff1 ?)
   (#x5ff5 ?ǰ)
   (#x5ff8 ?)
   (#x5ffb ?)
   (#x5ffd ?)
   (#x5fff ?)
   (#x600e ?)
   (#x600f ?)
   (#x6010 ?)
   (#x6012 ?)
   (#x6015 ?)
   (#x6016 ?)
   (#x6019 ?)
   (#x601b ?)
   (#x601c ?)
   (#x601d ?)
   (#x6020 ?)
   (#x6021 ?)
   (#x6025 ?)
   (#x6026 ?)
   (#x6027 ?)
   (#x6028 ?)
   (#x6029 ?)
   (#x602a ?)
   (#x602b ?)
   (#x602f ?)
   (#x6031 ?)
   (#x603a ?)
   (#x6041 ?)
   (#x6042 ?)
   (#x6043 ?)
   (#x6046 ?)
   (#x604a ?)
   (#x604b ?)
   (#x604d ?)
   (#x6050 ?)
   (#x6052 ?)
   (#x6055 ?)
   (#x6059 ?)
   (#x605a ?)
   (#x605f ?)
   (#x6060 ?)
   (#x6062 ?)
   (#x6063 ?)
   (#x6064 ?)
   (#x6065 ?)
   (#x6068 ?)
   (#x6069 ?)
   (#x606a ?)
   (#x606b ?)
   (#x606c ?)
   (#x606d ?)
   (#x606f ?©)
   (#x6070 ?)
   (#x6075 ?)
   (#x6077 ?)
   (#x6081 ?)
   (#x6083 ?)
   (#x6084 ?ء)
   (#x6089 ?)
   (#x608b ?ا)
   (#x608c ?)
   (#x608d ?)
   (#x6092 ?إ)
   (#x6094 ?)
   (#x6096 ?أ)
   (#x6097 ?ؤ)
   (#x609a ?)
   (#x609b ?آ)
   (#x609f ?)
   (#x60a0 ?ͪ)
   (#x60a3 ?)
   (#x60a6 ?)
   (#x60a7 ?ئ)
   (#x60a9 ?Ǻ)
   (#x60aa ?)
   (#x60b2 ?)
   (#x60b3 ?)
   (#x60b4 ?ج)
   (#x60b5 ?ذ)
   (#x60b6 ?)
   (#x60b8 ?ة)
   (#x60bc ?)
   (#x60bd ?خ)
   (#x60c5 ?)
   (#x60c6 ?د)
   (#x60c7 ?)
   (#x60d1 ?)
   (#x60d3 ?ث)
   (#x60d8 ?ر)
   (#x60da ?)
   (#x60dc ?)
   (#x60df ?)
   (#x60e0 ?ت)
   (#x60e1 ?ب)
   (#x60e3 ?)
   (#x60e7 ?)
   (#x60e8 ?)
   (#x60f0 ?)
   (#x60f1 ?ؽ)
   (#x60f3 ?)
   (#x60f4 ?ظ)
   (#x60f6 ?ص)
   (#x60f7 ?ض)
   (#x60f9 ?)
   (#x60fa ?ع)
   (#x60fb ?ؼ)
   (#x6100 ?ط)
   (#x6101 ?)
   (#x6103 ?غ)
   (#x6106 ?ش)
   (#x6108 ?)
   (#x6109 ?)
   (#x610d ?ؾ)
   (#x610e ?ؿ)
   (#x610f ?)
   (#x6115 ?س)
   (#x611a ?)
   (#x611b ?)
   (#x611f ?)
   (#x6121 ?ػ)
   (#x6127 ?)
   (#x6128 ?)
   (#x612c ?)
   (#x6134 ?)
   (#x613c ?)
   (#x613d ?)
   (#x613e ?)
   (#x613f ?)
   (#x6142 ?)
   (#x6144 ?)
   (#x6147 ?)
   (#x6148 ?)
   (#x614a ?)
   (#x614b ?)
   (#x614c ?)
   (#x614d ?ز)
   (#x614e ?)
   (#x6153 ?)
   (#x6155 ?)
   (#x6158 ?)
   (#x6159 ?)
   (#x615a ?)
   (#x615d ?)
   (#x615f ?)
   (#x6162 ?)
   (#x6163 ?)
   (#x6165 ?)
   (#x6167 ?)
   (#x6168 ?)
   (#x616b ?)
   (#x616e ?θ)
   (#x616f ?)
   (#x6170 ?)
   (#x6171 ?)
   (#x6173 ?)
   (#x6174 ?)
   (#x6175 ?)
   (#x6176 ?)
   (#x6177 ?)
   (#x617e ?)
   (#x6182 ?ͫ)
   (#x6187 ?)
   (#x618a ?)
   (#x618e ?)
   (#x6190 ?)
   (#x6191 ?)
   (#x6194 ?)
   (#x6196 ?)
   (#x6199 ?)
   (#x619a ?)
   (#x61a4 ?ʰ)
   (#x61a7 ?ƴ)
   (#x61a9 ?)
   (#x61ab ?)
   (#x61ac ?)
   (#x61ae ?)
   (#x61b2 ?)
   (#x61b6 ?)
   (#x61ba ?)
   (#x61be ?)
   (#x61c3 ?)
   (#x61c6 ?)
   (#x61c7 ?)
   (#x61c8 ?)
   (#x61c9 ?)
   (#x61ca ?)
   (#x61cb ?)
   (#x61cc ?)
   (#x61cd ?)
   (#x61d0 ?)
   (#x61e3 ?)
   (#x61e6 ?)
   (#x61f2 ?Ĩ)
   (#x61f4 ?)
   (#x61f6 ?)
   (#x61f7 ?)
   (#x61f8 ?)
   (#x61fa ?)
   (#x61fc ?)
   (#x61fd ?)
   (#x61fe ?)
   (#x61ff ?)
   (#x6200 ?)
   (#x6208 ?)
   (#x6209 ?)
   (#x620a ?)
   (#x620c ?)
   (#x620d ?)
   (#x620e ?)
   (#x6210 ?)
   (#x6211 ?)
   (#x6212 ?)
   (#x6214 ?)
   (#x6216 ?)
   (#x621a ?)
   (#x621b ?)
   (#x621d ?)
   (#x621e ?١)
   (#x621f ?)
   (#x6221 ?٢)
   (#x6226 ?)
   (#x622a ?٣)
   (#x622e ?٤)
   (#x622f ?)
   (#x6230 ?٥)
   (#x6232 ?٦)
   (#x6233 ?٧)
   (#x6234 ?)
   (#x6238 ?)
   (#x623b ?)
   (#x623f ?˼)
   (#x6240 ?)
   (#x6241 ?٨)
   (#x6247 ?)
   (#x6248 ?)
   (#x6249 ?)
   (#x624b ?)
   (#x624d ?)
   (#x624e ?٩)
   (#x6253 ?)
   (#x6255 ?ʧ)
   (#x6258 ?)
   (#x625b ?٬)
   (#x625e ?٪)
   (#x6260 ?٭)
   (#x6263 ?٫)
   (#x6268 ?ٮ)
   (#x626e ?ʱ)
   (#x6271 ?)
   (#x6276 ?)
   (#x6279 ?)
   (#x627c ?ٯ)
   (#x627e ?ٲ)
   (#x627f ?)
   (#x6280 ?)
   (#x6282 ?ٰ)
   (#x6283 ?ٷ)
   (#x6284 ?)
   (#x6289 ?ٱ)
   (#x628a ?)
   (#x6291 ?)
   (#x6292 ?ٳ)
   (#x6293 ?ٴ)
   (#x6294 ?ٸ)
   (#x6295 ?)
   (#x6296 ?ٵ)
   (#x6297 ?)
   (#x6298 ?)
   (#x629b ?)
   (#x629c ?ȴ)
   (#x629e ?)
   (#x62ab ?)
   (#x62ac ?ڭ)
   (#x62b1 ?)
   (#x62b5 ?)
   (#x62b9 ?)
   (#x62bb ?ٻ)
   (#x62bc ?)
   (#x62bd ?)
   (#x62c2 ?)
   (#x62c5 ?ô)
   (#x62c6 ?پ)
   (#x62c7 ?)
   (#x62c8 ?)
   (#x62c9 ?)
   (#x62ca ?)
   (#x62cc ?)
   (#x62cd ?)
   (#x62cf ?ټ)
   (#x62d0 ?)
   (#x62d1 ?ٺ)
   (#x62d2 ?)
   (#x62d3 ?)
   (#x62d4 ?ٶ)
   (#x62d7 ?ٹ)
   (#x62d8 ?)
   (#x62d9 ?)
   (#x62db ?)
   (#x62dc ?)
   (#x62dd ?)
   (#x62e0 ?)
   (#x62e1 ?)
   (#x62ec ?)
   (#x62ed ?)
   (#x62ee ?)
   (#x62ef ?)
   (#x62f1 ?)
   (#x62f3 ?)
   (#x62f5 ?)
   (#x62f6 ?)
   (#x62f7 ?)
   (#x62fe ?)
   (#x62ff ?ٽ)
   (#x6301 ?)
   (#x6302 ?)
   (#x6307 ?)
   (#x6308 ?)
   (#x6309 ?)
   (#x630c ?)
   (#x6311 ?ĩ)
   (#x6319 ?)
   (#x631f ?)
   (#x6327 ?)
   (#x6328 ?)
   (#x632b ?)
   (#x632f ?)
   (#x633a ?)
   (#x633d ?)
   (#x633e ?)
   (#x633f ?)
   (#x6349 ?ª)
   (#x634c ?)
   (#x634d ?)
   (#x634f ?)
   (#x6350 ?)
   (#x6355 ?)
   (#x6357 ?Ľ)
   (#x635c ?)
   (#x6367 ?)
   (#x6368 ?)
   (#x6369 ?)
   (#x636b ?)
   (#x636e ?)
   (#x6372 ?)
   (#x6376 ?)
   (#x6377 ?)
   (#x637a ?)
   (#x637b ?Ǳ)
   (#x6380 ?)
   (#x6383 ?)
   (#x6388 ?)
   (#x6389 ?)
   (#x638c ?)
   (#x638e ?)
   (#x638f ?)
   (#x6392 ?)
   (#x6396 ?)
   (#x6398 ?)
   (#x639b ?)
   (#x639f ?)
   (#x63a0 ?Ϋ)
   (#x63a1 ?)
   (#x63a2 ?õ)
   (#x63a3 ?)
   (#x63a5 ?)
   (#x63a7 ?)
   (#x63a8 ?)
   (#x63a9 ?)
   (#x63aa ?)
   (#x63ab ?)
   (#x63ac ?)
   (#x63b2 ?)
   (#x63b4 ?)
   (#x63b5 ?)
   (#x63bb ?)
   (#x63be ?)
   (#x63c0 ?)
   (#x63c3 ?·)
   (#x63c4 ?)
   (#x63c6 ?)
   (#x63c9 ?)
   (#x63cf ?)
   (#x63d0 ?)
   (#x63d2 ?)
   (#x63d6 ?ͬ)
   (#x63da ?)
   (#x63db ?)
   (#x63e1 ?)
   (#x63e3 ?)
   (#x63e9 ?)
   (#x63ee ?)
   (#x63f4 ?)
   (#x63f6 ?)
   (#x63fa ?)
   (#x6406 ?)
   (#x640d ?»)
   (#x640f ?)
   (#x6413 ?)
   (#x6416 ?)
   (#x6417 ?)
   (#x641c ?)
   (#x6426 ?)
   (#x6428 ?)
   (#x642c ?)
   (#x642d ?)
   (#x6434 ?)
   (#x6436 ?)
   (#x643a ?)
   (#x643e ?)
   (#x6442 ?)
   (#x644e ?)
   (#x6458 ?Ŧ)
   (#x6467 ?)
   (#x6469 ?)
   (#x646f ?)
   (#x6476 ?)
   (#x6478 ?)
   (#x647a ?)
   (#x6483 ?)
   (#x6488 ?)
   (#x6492 ?)
   (#x6493 ?)
   (#x6495 ?)
   (#x649a ?ǲ)
   (#x649e ?Ƶ)
   (#x64a4 ?ű)
   (#x64a5 ?)
   (#x64a9 ?)
   (#x64ab ?)
   (#x64ad ?)
   (#x64ae ?)
   (#x64b0 ?)
   (#x64b2 ?)
   (#x64b9 ?)
   (#x64bb ?ڥ)
   (#x64bc ?)
   (#x64c1 ?)
   (#x64c2 ?ڧ)
   (#x64c5 ?ڣ)
   (#x64c7 ?ڤ)
   (#x64cd ?)
   (#x64d2 ?ڢ)
   (#x64d4 ?ٿ)
   (#x64d8 ?ڦ)
   (#x64da ?ڡ)
   (#x64e0 ?ګ)
   (#x64e1 ?ڬ)
   (#x64e2 ?ŧ)
   (#x64e3 ?ڮ)
   (#x64e6 ?)
   (#x64e7 ?ک)
   (#x64ec ?)
   (#x64ef ?گ)
   (#x64f1 ?ڨ)
   (#x64f2 ?ڳ)
   (#x64f4 ?ڲ)
   (#x64f6 ?ڱ)
   (#x64fa ?ڴ)
   (#x64fd ?ڶ)
   (#x64fe ?)
   (#x6500 ?ڵ)
   (#x6505 ?ڹ)
   (#x6518 ?ڷ)
   (#x651c ?ڸ)
   (#x651d ?)
   (#x6523 ?ڻ)
   (#x6524 ?ں)
   (#x652a ?)
   (#x652b ?ڼ)
   (#x652c ?ڰ)
   (#x652f ?)
   (#x6534 ?ڽ)
   (#x6535 ?ھ)
   (#x6536 ?)
   (#x6537 ?ڿ)
   (#x6538 ?)
   (#x6539 ?)
   (#x653b ?)
   (#x653e ?)
   (#x653f ?)
   (#x6545 ?)
   (#x6548 ?)
   (#x654d ?)
   (#x654f ?)
   (#x6551 ?)
   (#x6555 ?)
   (#x6556 ?)
   (#x6557 ?)
   (#x6558 ?)
   (#x6559 ?)
   (#x655d ?)
   (#x655e ?)
   (#x6562 ?)
   (#x6563 ?)
   (#x6566 ?)
   (#x656c ?)
   (#x6570 ?)
   (#x6572 ?)
   (#x6574 ?)
   (#x6575 ?Ũ)
   (#x6577 ?)
   (#x6578 ?)
   (#x6582 ?)
   (#x6583 ?)
   (#x6587 ?ʸ)
   (#x6588 ?)
   (#x6589 ?)
   (#x658c ?)
   (#x658e ?)
   (#x6590 ?)
   (#x6591 ?)
   (#x6597 ?)
   (#x6599 ?)
   (#x659b ?)
   (#x659c ?)
   (#x659f ?)
   (#x65a1 ?)
   (#x65a4 ?)
   (#x65a5 ?)
   (#x65a7 ?)
   (#x65ab ?)
   (#x65ac ?)
   (#x65ad ?)
   (#x65af ?)
   (#x65b0 ?)
   (#x65b7 ?)
   (#x65b9 ?)
   (#x65bc ?)
   (#x65bd ?)
   (#x65c1 ?)
   (#x65c3 ?)
   (#x65c4 ?)
   (#x65c5 ?ι)
   (#x65c6 ?)
   (#x65cb ?)
   (#x65cc ?)
   (#x65cf ?²)
   (#x65d2 ?)
   (#x65d7 ?)
   (#x65d9 ?)
   (#x65db ?)
   (#x65e0 ?)
   (#x65e1 ?)
   (#x65e2 ?)
   (#x65e5 ?)
   (#x65e6 ?ö)
   (#x65e7 ?)
   (#x65e8 ?)
   (#x65e9 ?)
   (#x65ec ?)
   (#x65ed ?)
   (#x65f1 ?)
   (#x65fa ?)
   (#x65fb ?)
   (#x6602 ?)
   (#x6603 ?)
   (#x6606 ?)
   (#x6607 ?)
   (#x660a ?)
   (#x660c ?)
   (#x660e ?)
   (#x660f ?)
   (#x6613 ?)
   (#x6614 ?)
   (#x661c ?)
   (#x661f ?)
   (#x6620 ?)
   (#x6625 ?)
   (#x6627 ?)
   (#x6628 ?)
   (#x662d ?)
   (#x662f ?)
   (#x6634 ?)
   (#x6635 ?)
   (#x6636 ?)
   (#x663c ?)
   (#x663f ?ۦ)
   (#x6641 ?)
   (#x6642 ?)
   (#x6643 ?)
   (#x6644 ?)
   (#x6649 ?)
   (#x664b ?)
   (#x664f ?)
   (#x6652 ?)
   (#x665d ?)
   (#x665e ?)
   (#x665f ?)
   (#x6662 ?)
   (#x6664 ?)
   (#x6666 ?)
   (#x6667 ?)
   (#x6668 ?)
   (#x6669 ?)
   (#x666e ?)
   (#x666f ?)
   (#x6670 ?)
   (#x6674 ?)
   (#x6676 ?)
   (#x667a ?)
   (#x6681 ?)
   (#x6683 ?)
   (#x6684 ?)
   (#x6687 ?)
   (#x6688 ?)
   (#x6689 ?)
   (#x668e ?)
   (#x6691 ?)
   (#x6696 ?)
   (#x6697 ?)
   (#x6698 ?)
   (#x669d ?)
   (#x66a2 ?Ī)
   (#x66a6 ?)
   (#x66ab ?)
   (#x66ae ?)
   (#x66b4 ?˽)
   (#x66b8 ?ۢ)
   (#x66b9 ?)
   (#x66bc ?)
   (#x66be ?)
   (#x66c1 ?)
   (#x66c4 ?ۡ)
   (#x66c7 ?)
   (#x66c9 ?)
   (#x66d6 ?ۣ)
   (#x66d9 ?)
   (#x66da ?ۤ)
   (#x66dc ?)
   (#x66dd ?)
   (#x66e0 ?ۥ)
   (#x66e6 ?ۧ)
   (#x66e9 ?ۨ)
   (#x66f0 ?۩)
   (#x66f2 ?)
   (#x66f3 ?)
   (#x66f4 ?)
   (#x66f5 ?۪)
   (#x66f7 ?۫)
   (#x66f8 ?)
   (#x66f9 ?)
   (#x66fc ?)
   (#x66fd ?)
   (#x66fe ?)
   (#x66ff ?)
   (#x6700 ?)
   (#x6703 ?)
   (#x6708 ?)
   (#x6709 ?ͭ)
   (#x670b ?)
   (#x670d ?)
   (#x670f ?۬)
   (#x6714 ?)
   (#x6715 ?Ŀ)
   (#x6716 ?ۭ)
   (#x6717 ?ϯ)
   (#x671b ?˾)
   (#x671d ?ī)
   (#x671e ?ۮ)
   (#x671f ?)
   (#x6726 ?ۯ)
   (#x6727 ?۰)
   (#x6728 ?)
   (#x672a ?̤)
   (#x672b ?)
   (#x672c ?)
   (#x672d ?)
   (#x672e ?۲)
   (#x6731 ?)
   (#x6734 ?)
   (#x6736 ?۴)
   (#x6737 ?۷)
   (#x6738 ?۶)
   (#x673a ?)
   (#x673d ?)
   (#x673f ?۳)
   (#x6741 ?۵)
   (#x6746 ?۸)
   (#x6749 ?)
   (#x674e ?)
   (#x674f ?)
   (#x6750 ?)
   (#x6751 ?¼)
   (#x6753 ?)
   (#x6756 ?)
   (#x6759 ?ۻ)
   (#x675c ?)
   (#x675e ?۹)
   (#x675f ?«)
   (#x6760 ?ۺ)
   (#x6761 ?)
   (#x6762 ?)
   (#x6763 ?ۼ)
   (#x6764 ?۽)
   (#x6765 ?)
   (#x676a ?)
   (#x676d ?)
   (#x676f ?)
   (#x6770 ?ۿ)
   (#x6771 ?)
   (#x6772 ?)
   (#x6773 ?)
   (#x6775 ?)
   (#x6777 ?)
   (#x677c ?)
   (#x677e ?)
   (#x677f ?)
   (#x6785 ?)
   (#x6787 ?)
   (#x6789 ?۾)
   (#x678b ?)
   (#x678c ?)
   (#x6790 ?)
   (#x6795 ?)
   (#x6797 ?)
   (#x679a ?)
   (#x679c ?)
   (#x679d ?)
   (#x67a0 ?)
   (#x67a1 ?)
   (#x67a2 ?)
   (#x67a6 ?)
   (#x67a9 ?)
   (#x67af ?)
   (#x67b3 ?)
   (#x67b4 ?)
   (#x67b6 ?)
   (#x67b7 ?)
   (#x67b8 ?)
   (#x67b9 ?)
   (#x67c1 ?)
   (#x67c4 ?)
   (#x67c6 ?)
   (#x67ca ?ɢ)
   (#x67ce ?)
   (#x67cf ?)
   (#x67d0 ?˿)
   (#x67d1 ?)
   (#x67d3 ?)
   (#x67d4 ?)
   (#x67d8 ?)
   (#x67da ?ͮ)
   (#x67dd ?)
   (#x67de ?)
   (#x67e2 ?)
   (#x67e4 ?)
   (#x67e7 ?)
   (#x67e9 ?)
   (#x67ec ?)
   (#x67ee ?)
   (#x67ef ?)
   (#x67f1 ?)
   (#x67f3 ?)
   (#x67f4 ?)
   (#x67f5 ?)
   (#x67fb ?)
   (#x67fe ?)
   (#x67ff ?)
   (#x6802 ?)
   (#x6803 ?)
   (#x6804 ?)
   (#x6813 ?)
   (#x6816 ?)
   (#x6817 ?)
   (#x681e ?)
   (#x6821 ?)
   (#x6822 ?)
   (#x6829 ?)
   (#x682a ?)
   (#x682b ?)
   (#x6832 ?)
   (#x6834 ?)
   (#x6838 ?)
   (#x6839 ?)
   (#x683c ?)
   (#x683d ?)
   (#x6840 ?)
   (#x6841 ?)
   (#x6842 ?)
   (#x6843 ?)
   (#x6846 ?)
   (#x6848 ?)
   (#x684d ?)
   (#x684e ?)
   (#x6850 ?)
   (#x6851 ?)
   (#x6853 ?)
   (#x6854 ?)
   (#x6859 ?)
   (#x685c ?)
   (#x685d ?)
   (#x685f ?)
   (#x6863 ?)
   (#x6867 ?ɰ)
   (#x6874 ?)
   (#x6876 ?)
   (#x6877 ?)
   (#x687e ?)
   (#x687f ?)
   (#x6881 ?)
   (#x6883 ?)
   (#x6885 ?)
   (#x688d ?)
   (#x688f ?)
   (#x6893 ?)
   (#x6894 ?)
   (#x6897 ?)
   (#x689b ?)
   (#x689d ?)
   (#x689f ?)
   (#x68a0 ?)
   (#x68a2 ?)
   (#x68a6 ?)
   (#x68a7 ?)
   (#x68a8 ?)
   (#x68ad ?)
   (#x68af ?)
   (#x68b0 ?)
   (#x68b1 ?)
   (#x68b3 ?)
   (#x68b5 ?)
   (#x68b6 ?)
   (#x68b9 ?)
   (#x68ba ?)
   (#x68bc ?)
   (#x68c4 ?)
   (#x68c6 ?ܲ)
   (#x68c9 ?)
   (#x68ca ?)
   (#x68cb ?)
   (#x68cd ?)
   (#x68d2 ?)
   (#x68d4 ?ܡ)
   (#x68d5 ?ܣ)
   (#x68d7 ?ܧ)
   (#x68d8 ?)
   (#x68da ?ê)
   (#x68df ?)
   (#x68e0 ?ܫ)
   (#x68e1 ?)
   (#x68e3 ?ܨ)
   (#x68e7 ?ܢ)
   (#x68ee ?)
   (#x68ef ?ܬ)
   (#x68f2 ?)
   (#x68f9 ?ܪ)
   (#x68fa ?)
   (#x6900 ?)
   (#x6901 ?)
   (#x6904 ?ܦ)
   (#x6905 ?)
   (#x6908 ?)
   (#x690b ?̺)
   (#x690c ?)
   (#x690d ?)
   (#x690e ?)
   (#x690f ?)
   (#x6912 ?ܥ)
   (#x6919 ?)
   (#x691a ?ܯ)
   (#x691b ?)
   (#x691c ?)
   (#x6921 ?ܱ)
   (#x6922 ?)
   (#x6923 ?ܰ)
   (#x6925 ?ܩ)
   (#x6926 ?)
   (#x6928 ?ܭ)
   (#x692a ?ܮ)
   (#x6930 ?ܿ)
   (#x6934 ?)
   (#x6936 ?ܤ)
   (#x6939 ?ܻ)
   (#x693d ?ܽ)
   (#x693f ?)
   (#x694a ?)
   (#x6953 ?)
   (#x6954 ?ܸ)
   (#x6955 ?)
   (#x6959 ?ܾ)
   (#x695a ?)
   (#x695c ?ܵ)
   (#x695d ?)
   (#x695e ?)
   (#x6960 ?)
   (#x6961 ?)
   (#x6962 ?)
   (#x696a ?)
   (#x696b ?ܷ)
   (#x696d ?)
   (#x696e ?ܺ)
   (#x696f ?)
   (#x6973 ?)
   (#x6974 ?ܼ)
   (#x6975 ?)
   (#x6977 ?ܴ)
   (#x6978 ?ܶ)
   (#x6979 ?ܳ)
   (#x697c ?ϰ)
   (#x697d ?)
   (#x697e ?ܹ)
   (#x6981 ?)
   (#x6982 ?)
   (#x698a ?)
   (#x698e ?)
   (#x6991 ?)
   (#x6994 ?ϱ)
   (#x6995 ?)
   (#x699b ?)
   (#x699c ?)
   (#x69a0 ?)
   (#x69a7 ?)
   (#x69ae ?)
   (#x69b1 ?)
   (#x69b2 ?)
   (#x69b4 ?)
   (#x69bb ?)
   (#x69be ?)
   (#x69bf ?)
   (#x69c1 ?)
   (#x69c3 ?)
   (#x69c7 ?)
   (#x69ca ?)
   (#x69cb ?)
   (#x69cc ?)
   (#x69cd ?)
   (#x69ce ?)
   (#x69d0 ?)
   (#x69d3 ?)
   (#x69d8 ?)
   (#x69d9 ?)
   (#x69dd ?)
   (#x69de ?)
   (#x69e7 ?)
   (#x69e8 ?)
   (#x69eb ?)
   (#x69ed ?)
   (#x69f2 ?)
   (#x69f9 ?)
   (#x69fb ?)
   (#x69fd ?)
   (#x69ff ?)
   (#x6a02 ?)
   (#x6a05 ?)
   (#x6a0a ?)
   (#x6a0b ?)
   (#x6a0c ?)
   (#x6a12 ?)
   (#x6a13 ?)
   (#x6a14 ?)
   (#x6a17 ?)
   (#x6a19 ?ɸ)
   (#x6a1b ?)
   (#x6a1e ?)
   (#x6a1f ?)
   (#x6a21 ?)
   (#x6a22 ?)
   (#x6a23 ?)
   (#x6a29 ?)
   (#x6a2a ?)
   (#x6a2b ?)
   (#x6a2e ?)
   (#x6a35 ?)
   (#x6a36 ?)
   (#x6a38 ?)
   (#x6a39 ?)
   (#x6a3a ?)
   (#x6a3d ?î)
   (#x6a44 ?)
   (#x6a47 ?)
   (#x6a48 ?)
   (#x6a4b ?)
   (#x6a58 ?)
   (#x6a59 ?)
   (#x6a5f ?)
   (#x6a61 ?)
   (#x6a62 ?)
   (#x6a66 ?)
   (#x6a72 ?)
   (#x6a78 ?)
   (#x6a7f ?)
   (#x6a80 ?)
   (#x6a84 ?)
   (#x6a8d ?)
   (#x6a8e ?)
   (#x6a90 ?)
   (#x6a97 ?ݡ)
   (#x6a9c ?)
   (#x6aa0 ?)
   (#x6aa2 ?)
   (#x6aa3 ?)
   (#x6aaa ?ݬ)
   (#x6aac ?ݨ)
   (#x6aae ?)
   (#x6ab3 ?ݧ)
   (#x6ab8 ?ݦ)
   (#x6abb ?ݣ)
   (#x6ac1 ?)
   (#x6ac2 ?ݥ)
   (#x6ac3 ?ݤ)
   (#x6ad1 ?ݪ)
   (#x6ad3 ?Ϧ)
   (#x6ada ?ݭ)
   (#x6adb ?)
   (#x6ade ?ݩ)
   (#x6adf ?ݫ)
   (#x6ae8 ?ȧ)
   (#x6aea ?ݮ)
   (#x6afa ?ݲ)
   (#x6afb ?ݯ)
   (#x6b04 ?)
   (#x6b05 ?ݰ)
   (#x6b0a ?)
   (#x6b12 ?ݳ)
   (#x6b16 ?ݴ)
   (#x6b1d ?)
   (#x6b1f ?ݶ)
   (#x6b20 ?)
   (#x6b21 ?)
   (#x6b23 ?)
   (#x6b27 ?)
   (#x6b32 ?)
   (#x6b37 ?ݸ)
   (#x6b38 ?ݷ)
   (#x6b39 ?ݺ)
   (#x6b3a ?)
   (#x6b3d ?)
   (#x6b3e ?)
   (#x6b43 ?ݽ)
   (#x6b47 ?ݼ)
   (#x6b49 ?ݾ)
   (#x6b4c ?)
   (#x6b4e ?÷)
   (#x6b50 ?ݿ)
   (#x6b53 ?)
   (#x6b54 ?)
   (#x6b59 ?)
   (#x6b5b ?)
   (#x6b5f ?)
   (#x6b61 ?)
   (#x6b62 ?)
   (#x6b63 ?)
   (#x6b64 ?)
   (#x6b66 ?)
   (#x6b69 ?)
   (#x6b6a ?)
   (#x6b6f ?)
   (#x6b73 ?)
   (#x6b74 ?)
   (#x6b78 ?)
   (#x6b79 ?)
   (#x6b7b ?)
   (#x6b7f ?)
   (#x6b80 ?)
   (#x6b83 ?)
   (#x6b84 ?)
   (#x6b86 ?)
   (#x6b89 ?)
   (#x6b8a ?)
   (#x6b8b ?)
   (#x6b8d ?)
   (#x6b95 ?)
   (#x6b96 ?)
   (#x6b98 ?)
   (#x6b9e ?)
   (#x6ba4 ?)
   (#x6baa ?)
   (#x6bab ?)
   (#x6baf ?)
   (#x6bb1 ?)
   (#x6bb2 ?)
   (#x6bb3 ?)
   (#x6bb4 ?)
   (#x6bb5 ?)
   (#x6bb7 ?)
   (#x6bba ?)
   (#x6bbb ?)
   (#x6bbc ?)
   (#x6bbf ?)
   (#x6bc0 ?)
   (#x6bc5 ?)
   (#x6bc6 ?)
   (#x6bcb ?)
   (#x6bcd ?)
   (#x6bce ?)
   (#x6bd2 ?)
   (#x6bd3 ?)
   (#x6bd4 ?)
   (#x6bd8 ?)
   (#x6bdb ?)
   (#x6bdf ?)
   (#x6beb ?)
   (#x6bec ?)
   (#x6bef ?)
   (#x6bf3 ?)
   (#x6c08 ?)
   (#x6c0f ?)
   (#x6c11 ?̱)
   (#x6c13 ?)
   (#x6c14 ?)
   (#x6c17 ?)
   (#x6c1b ?)
   (#x6c23 ?)
   (#x6c24 ?)
   (#x6c34 ?)
   (#x6c37 ?ɹ)
   (#x6c38 ?)
   (#x6c3e ?)
   (#x6c40 ?)
   (#x6c41 ?)
   (#x6c42 ?)
   (#x6c4e ?)
   (#x6c50 ?)
   (#x6c55 ?)
   (#x6c57 ?)
   (#x6c5a ?)
   (#x6c5d ?)
   (#x6c5e ?)
   (#x6c5f ?)
   (#x6c60 ?)
   (#x6c62 ?)
   (#x6c68 ?)
   (#x6c6a ?)
   (#x6c70 ?)
   (#x6c72 ?)
   (#x6c73 ?)
   (#x6c7a ?)
   (#x6c7d ?)
   (#x6c7e ?)
   (#x6c81 ?)
   (#x6c82 ?)
   (#x6c83 ?)
   (#x6c88 ?)
   (#x6c8c ?)
   (#x6c8d ?)
   (#x6c90 ?)
   (#x6c92 ?)
   (#x6c93 ?)
   (#x6c96 ?)
   (#x6c99 ?)
   (#x6c9a ?)
   (#x6c9b ?)
   (#x6ca1 ?)
   (#x6ca2 ?)
   (#x6cab ?)
   (#x6cae ?)
   (#x6cb1 ?)
   (#x6cb3 ?)
   (#x6cb8 ?ʨ)
   (#x6cb9 ?)
   (#x6cba ?ޡ)
   (#x6cbb ?)
   (#x6cbc ?)
   (#x6cbd ?)
   (#x6cbe ?)
   (#x6cbf ?)
   (#x6cc1 ?)
   (#x6cc4 ?)
   (#x6cc5 ?)
   (#x6cc9 ?)
   (#x6cca ?)
   (#x6ccc ?)
   (#x6cd3 ?)
   (#x6cd5 ?ˡ)
   (#x6cd7 ?)
   (#x6cd9 ?ޤ)
   (#x6cdb ?ޢ)
   (#x6cdd ?)
   (#x6ce1 ?ˢ)
   (#x6ce2 ?)
   (#x6ce3 ?)
   (#x6ce5 ?ť)
   (#x6ce8 ?)
   (#x6cea ?ޥ)
   (#x6cef ?ޣ)
   (#x6cf0 ?)
   (#x6cf1 ?)
   (#x6cf3 ?)
   (#x6d0b ?)
   (#x6d0c ?ް)
   (#x6d12 ?ޯ)
   (#x6d17 ?)
   (#x6d19 ?ެ)
   (#x6d1b ?)
   (#x6d1e ?ƶ)
   (#x6d1f ?ަ)
   (#x6d25 ?)
   (#x6d29 ?)
   (#x6d2a ?)
   (#x6d2b ?ީ)
   (#x6d32 ?)
   (#x6d33 ?ޮ)
   (#x6d35 ?ޭ)
   (#x6d36 ?ި)
   (#x6d38 ?ޫ)
   (#x6d3b ?)
   (#x6d3d ?ު)
   (#x6d3e ?)
   (#x6d41 ?ή)
   (#x6d44 ?)
   (#x6d45 ?)
   (#x6d59 ?޶)
   (#x6d5a ?޴)
   (#x6d5c ?)
   (#x6d63 ?ޱ)
   (#x6d64 ?޳)
   (#x6d66 ?)
   (#x6d69 ?)
   (#x6d6a ?ϲ)
   (#x6d6c ?)
   (#x6d6e ?)
   (#x6d74 ?)
   (#x6d77 ?)
   (#x6d78 ?)
   (#x6d79 ?޵)
   (#x6d85 ?޺)
   (#x6d88 ?)
   (#x6d8c ?Ͱ)
   (#x6d8e ?޷)
   (#x6d93 ?޲)
   (#x6d95 ?޸)
   (#x6d99 ?)
   (#x6d9b ?)
   (#x6d9c ?)
   (#x6daf ?)
   (#x6db2 ?)
   (#x6db5 ?޾)
   (#x6db8 ?)
   (#x6dbc ?)
   (#x6dc0 ?)
   (#x6dc5 ?)
   (#x6dc6 ?)
   (#x6dc7 ?޿)
   (#x6dcb ?)
   (#x6dcc ?)
   (#x6dd1 ?)
   (#x6dd2 ?)
   (#x6dd5 ?)
   (#x6dd8 ?)
   (#x6dd9 ?)
   (#x6dde ?)
   (#x6de1 ?ø)
   (#x6de4 ?)
   (#x6de6 ?)
   (#x6de8 ?)
   (#x6dea ?)
   (#x6deb ?)
   (#x6dec ?)
   (#x6dee ?)
   (#x6df1 ?)
   (#x6df3 ?)
   (#x6df5 ?ʥ)
   (#x6df7 ?)
   (#x6df9 ?޻)
   (#x6dfa ?)
   (#x6dfb ?ź)
   (#x6e05 ?)
   (#x6e07 ?)
   (#x6e08 ?)
   (#x6e09 ?)
   (#x6e0a ?޽)
   (#x6e0b ?)
   (#x6e13 ?)
   (#x6e15 ?޼)
   (#x6e19 ?)
   (#x6e1a ?)
   (#x6e1b ?)
   (#x6e1d ?)
   (#x6e1f ?)
   (#x6e20 ?)
   (#x6e21 ?)
   (#x6e23 ?)
   (#x6e24 ?)
   (#x6e25 ?)
   (#x6e26 ?)
   (#x6e29 ?)
   (#x6e2b ?)
   (#x6e2c ?¬)
   (#x6e2d ?)
   (#x6e2e ?)
   (#x6e2f ?)
   (#x6e38 ?)
   (#x6e3a ?)
   (#x6e3e ?)
   (#x6e43 ?)
   (#x6e4a ?̫)
   (#x6e4d ?)
   (#x6e4e ?)
   (#x6e56 ?)
   (#x6e58 ?)
   (#x6e5b ?ù)
   (#x6e5f ?)
   (#x6e67 ?ͯ)
   (#x6e6b ?)
   (#x6e6e ?)
   (#x6e6f ?)
   (#x6e72 ?)
   (#x6e76 ?)
   (#x6e7e ?)
   (#x6e7f ?)
   (#x6e80 ?)
   (#x6e82 ?)
   (#x6e8c ?Ȯ)
   (#x6e8f ?)
   (#x6e90 ?)
   (#x6e96 ?)
   (#x6e98 ?)
   (#x6e9c ?ί)
   (#x6e9d ?)
   (#x6e9f ?)
   (#x6ea2 ?)
   (#x6ea5 ?)
   (#x6eaa ?)
   (#x6eaf ?)
   (#x6eb2 ?)
   (#x6eb6 ?)
   (#x6eb7 ?)
   (#x6eba ?Ů)
   (#x6ebd ?)
   (#x6ec2 ?)
   (#x6ec4 ?)
   (#x6ec5 ?)
   (#x6ec9 ?)
   (#x6ecb ?)
   (#x6ecc ?)
   (#x6ed1 ?)
   (#x6ed3 ?)
   (#x6ed4 ?)
   (#x6ed5 ?)
   (#x6edd ?)
   (#x6ede ?)
   (#x6eec ?)
   (#x6eef ?)
   (#x6ef2 ?)
   (#x6ef4 ?ũ)
   (#x6ef7 ?ߣ)
   (#x6ef8 ?)
   (#x6efe ?)
   (#x6eff ?)
   (#x6f01 ?)
   (#x6f02 ?ɺ)
   (#x6f06 ?)
   (#x6f09 ?)
   (#x6f0f ?ϳ)
   (#x6f11 ?)
   (#x6f13 ?ߢ)
   (#x6f14 ?)
   (#x6f15 ?)
   (#x6f20 ?)
   (#x6f22 ?)
   (#x6f23 ?)
   (#x6f2b ?̡)
   (#x6f2c ?)
   (#x6f31 ?)
   (#x6f32 ?)
   (#x6f38 ?)
   (#x6f3e ?ߡ)
   (#x6f3f ?)
   (#x6f41 ?)
   (#x6f45 ?)
   (#x6f54 ?)
   (#x6f58 ?߯)
   (#x6f5b ?ߪ)
   (#x6f5c ?)
   (#x6f5f ?)
   (#x6f64 ?)
   (#x6f66 ?߳)
   (#x6f6d ?߬)
   (#x6f6e ?Ĭ)
   (#x6f6f ?ߩ)
   (#x6f70 ?)
   (#x6f74 ?)
   (#x6f78 ?ߦ)
   (#x6f7a ?ߥ)
   (#x6f7c ?߮)
   (#x6f80 ?ߨ)
   (#x6f81 ?ߧ)
   (#x6f82 ?߭)
   (#x6f84 ?)
   (#x6f86 ?ߤ)
   (#x6f8e ?߰)
   (#x6f91 ?߱)
   (#x6f97 ?)
   (#x6fa1 ?߶)
   (#x6fa3 ?ߵ)
   (#x6fa4 ?߷)
   (#x6faa ?ߺ)
   (#x6fb1 ?)
   (#x6fb3 ?ߴ)
   (#x6fb9 ?߸)
   (#x6fc0 ?)
   (#x6fc1 ?)
   (#x6fc2 ?߲)
   (#x6fc3 ?ǻ)
   (#x6fc6 ?߹)
   (#x6fd4 ?߾)
   (#x6fd5 ?߼)
   (#x6fd8 ?߿)
   (#x6fdb ?)
   (#x6fdf ?߻)
   (#x6fe0 ?)
   (#x6fe1 ?Ǩ)
   (#x6fe4 ?޹)
   (#x6feb ?)
   (#x6fec ?߽)
   (#x6fee ?)
   (#x6fef ?)
   (#x6ff1 ?)
   (#x6ff3 ?߫)
   (#x6ff6 ?)
   (#x6ffa ?)
   (#x6ffe ?)
   (#x7001 ?)
   (#x7009 ?)
   (#x700b ?)
   (#x700f ?)
   (#x7011 ?)
   (#x7015 ?)
   (#x7018 ?)
   (#x701a ?)
   (#x701b ?)
   (#x701d ?)
   (#x701e ?)
   (#x701f ?)
   (#x7026 ?)
   (#x7027 ?)
   (#x702c ?)
   (#x7030 ?)
   (#x7032 ?)
   (#x703e ?)
   (#x704c ?)
   (#x7051 ?)
   (#x7058 ?)
   (#x7063 ?)
   (#x706b ?)
   (#x706f ?)
   (#x7070 ?)
   (#x7078 ?)
   (#x707c ?)
   (#x707d ?)
   (#x7089 ?ϧ)
   (#x708a ?)
   (#x708e ?)
   (#x7092 ?)
   (#x7099 ?)
   (#x70ac ?)
   (#x70ad ?ú)
   (#x70ae ?)
   (#x70af ?)
   (#x70b3 ?)
   (#x70b8 ?)
   (#x70b9 ?)
   (#x70ba ?)
   (#x70c8 ?)
   (#x70cb ?)
   (#x70cf ?)
   (#x70d9 ?)
   (#x70dd ?)
   (#x70df ?)
   (#x70f1 ?)
   (#x70f9 ?ˣ)
   (#x70fd ?)
   (#x7109 ?)
   (#x7114 ?)
   (#x7119 ?)
   (#x711a ?ʲ)
   (#x711c ?)
   (#x7121 ?̵)
   (#x7126 ?)
   (#x7136 ?)
   (#x713c ?)
   (#x7149 ?)
   (#x714c ?)
   (#x714e ?)
   (#x7155 ?)
   (#x7156 ?)
   (#x7159 ?)
   (#x7162 ?)
   (#x7164 ?)
   (#x7165 ?)
   (#x7166 ?)
   (#x7167 ?)
   (#x7169 ?)
   (#x716c ?)
   (#x716e ?)
   (#x717d ?)
   (#x7184 ?)
   (#x7188 ?)
   (#x718a ?)
   (#x718f ?)
   (#x7194 ?)
   (#x7195 ?)
   (#x7199 ?)
   (#x719f ?)
   (#x71a8 ?)
   (#x71ac ?)
   (#x71b1 ?Ǯ)
   (#x71b9 ?)
   (#x71be ?)
   (#x71c3 ?ǳ)
   (#x71c8 ?)
   (#x71c9 ?)
   (#x71ce ?)
   (#x71d0 ?)
   (#x71d2 ?)
   (#x71d4 ?)
   (#x71d5 ?)
   (#x71d7 ?)
   (#x71df ?)
   (#x71e0 ?)
   (#x71e5 ?)
   (#x71e6 ?)
   (#x71e7 ?)
   (#x71ec ?)
   (#x71ed ?)
   (#x71ee ?)
   (#x71f5 ?)
   (#x71f9 ?)
   (#x71fb ?)
   (#x71fc ?)
   (#x71ff ?)
   (#x7206 ?)
   (#x720d ?)
   (#x7210 ?)
   (#x721b ?)
   (#x7228 ?)
   (#x722a ?)
   (#x722c ?)
   (#x722d ?)
   (#x7230 ?)
   (#x7232 ?)
   (#x7235 ?)
   (#x7236 ?)
   (#x723a ?)
   (#x723b ?)
   (#x723c ?)
   (#x723d ?)
   (#x723e ?)
   (#x723f ?)
   (#x7240 ?)
   (#x7246 ?)
   (#x7247 ?)
   (#x7248 ?)
   (#x724b ?)
   (#x724c ?)
   (#x7252 ?ĭ)
   (#x7258 ?)
   (#x7259 ?)
   (#x725b ?)
   (#x725d ?)
   (#x725f ?̶)
   (#x7261 ?)
   (#x7262 ?ϴ)
   (#x7267 ?)
   (#x7269 ?ʪ)
   (#x7272 ?)
   (#x7274 ?)
   (#x7279 ?)
   (#x727d ?)
   (#x727e ?)
   (#x7280 ?)
   (#x7281 ?)
   (#x7282 ?)
   (#x7287 ?)
   (#x7292 ?)
   (#x7296 ?)
   (#x72a0 ?)
   (#x72a2 ?)
   (#x72a7 ?)
   (#x72ac ?)
   (#x72af ?)
   (#x72b2 ?)
   (#x72b6 ?)
   (#x72b9 ?)
   (#x72c2 ?)
   (#x72c3 ?)
   (#x72c4 ?)
   (#x72c6 ?)
   (#x72ce ?)
   (#x72d0 ?)
   (#x72d2 ?)
   (#x72d7 ?)
   (#x72d9 ?)
   (#x72db ?)
   (#x72e0 ?)
   (#x72e1 ?)
   (#x72e2 ?)
   (#x72e9 ?)
   (#x72ec ?)
   (#x72ed ?)
   (#x72f7 ?)
   (#x72f8 ?ì)
   (#x72f9 ?)
   (#x72fc ?ϵ)
   (#x72fd ?)
   (#x730a ?)
   (#x7316 ?)
   (#x7317 ?)
   (#x731b ?)
   (#x731c ?)
   (#x731d ?)
   (#x731f ?)
   (#x7325 ?)
   (#x7329 ?)
   (#x732a ?)
   (#x732b ?ǭ)
   (#x732e ?)
   (#x732f ?)
   (#x7334 ?)
   (#x7336 ?ͱ)
   (#x7337 ?Ͳ)
   (#x733e ?)
   (#x733f ?)
   (#x7344 ?)
   (#x7345 ?)
   (#x734e ?)
   (#x734f ?)
   (#x7357 ?)
   (#x7363 ?)
   (#x7368 ?)
   (#x736a ?)
   (#x7370 ?)
   (#x7372 ?)
   (#x7375 ?)
   (#x7378 ?)
   (#x737a ?)
   (#x737b ?)
   (#x7384 ?)
   (#x7387 ?Ψ)
   (#x7389 ?)
   (#x738b ?)
   (#x7396 ?)
   (#x73a9 ?)
   (#x73b2 ?)
   (#x73b3 ?)
   (#x73bb ?)
   (#x73c0 ?)
   (#x73c2 ?)
   (#x73c8 ?)
   (#x73ca ?)
   (#x73cd ?)
   (#x73ce ?)
   (#x73de ?)
   (#x73e0 ?)
   (#x73e5 ?)
   (#x73ea ?)
   (#x73ed ?)
   (#x73ee ?)
   (#x73f1 ?)
   (#x73f8 ?)
   (#x73fe ?)
   (#x7403 ?)
   (#x7405 ?)
   (#x7406 ?)
   (#x7409 ?ΰ)
   (#x7422 ?)
   (#x7425 ?)
   (#x7432 ?)
   (#x7433 ?)
   (#x7434 ?)
   (#x7435 ?)
   (#x7436 ?)
   (#x743a ?)
   (#x743f ?)
   (#x7441 ?)
   (#x7455 ?)
   (#x7459 ?)
   (#x745a ?)
   (#x745b ?)
   (#x745c ?)
   (#x745e ?)
   (#x745f ?)
   (#x7460 ?)
   (#x7463 ?)
   (#x7464 ?)
   (#x7469 ?)
   (#x746a ?)
   (#x746f ?)
   (#x7470 ?)
   (#x7473 ?)
   (#x7476 ?)
   (#x747e ?)
   (#x7483 ?)
   (#x748b ?)
   (#x749e ?)
   (#x74a2 ?)
   (#x74a7 ?)
   (#x74b0 ?)
   (#x74bd ?)
   (#x74ca ?)
   (#x74cf ?)
   (#x74d4 ?)
   (#x74dc ?)
   (#x74e0 ?)
   (#x74e2 ?ɻ)
   (#x74e3 ?)
   (#x74e6 ?)
   (#x74e7 ?)
   (#x74e9 ?)
   (#x74ee ?)
   (#x74f0 ?)
   (#x74f1 ?)
   (#x74f2 ?)
   (#x74f6 ?)
   (#x74f7 ?)
   (#x74f8 ?)
   (#x7503 ?)
   (#x7504 ?)
   (#x7505 ?)
   (#x750c ?)
   (#x750d ?)
   (#x750e ?)
   (#x7511 ?)
   (#x7513 ?)
   (#x7515 ?)
   (#x7518 ?)
   (#x751a ?)
   (#x751c ?ż)
   (#x751e ?)
   (#x751f ?)
   (#x7523 ?)
   (#x7525 ?)
   (#x7526 ?)
   (#x7528 ?)
   (#x752b ?)
   (#x752c ?)
   (#x7530 ?)
   (#x7531 ?ͳ)
   (#x7532 ?)
   (#x7533 ?)
   (#x7537 ?)
   (#x7538 ?Ҵ)
   (#x753a ?Į)
   (#x753b ?)
   (#x753c ?)
   (#x7544 ?)
   (#x7546 ?)
   (#x7549 ?)
   (#x754a ?)
   (#x754b ?)
   (#x754c ?)
   (#x754d ?)
   (#x754f ?)
   (#x7551 ?Ȫ)
   (#x7554 ?)
   (#x7559 ?α)
   (#x755a ?)
   (#x755b ?)
   (#x755c ?)
   (#x755d ?)
   (#x7560 ?ȫ)
   (#x7562 ?ɭ)
   (#x7564 ?)
   (#x7565 ?ά)
   (#x7566 ?)
   (#x7567 ?)
   (#x7569 ?)
   (#x756a ?)
   (#x756b ?)
   (#x756d ?)
   (#x7570 ?)
   (#x7573 ?)
   (#x7574 ?)
   (#x7576 ?)
   (#x7577 ?)
   (#x7578 ?)
   (#x757f ?)
   (#x7582 ?)
   (#x7586 ?)
   (#x7587 ?)
   (#x7589 ?)
   (#x758a ?)
   (#x758b ?ɥ)
   (#x758e ?)
   (#x758f ?)
   (#x7591 ?)
   (#x7594 ?)
   (#x759a ?)
   (#x759d ?)
   (#x75a3 ?)
   (#x75a5 ?)
   (#x75ab ?)
   (#x75b1 ?)
   (#x75b2 ?)
   (#x75b3 ?)
   (#x75b5 ?)
   (#x75b8 ?)
   (#x75b9 ?)
   (#x75bc ?)
   (#x75bd ?)
   (#x75be ?)
   (#x75c2 ?)
   (#x75c3 ?)
   (#x75c5 ?)
   (#x75c7 ?)
   (#x75ca ?)
   (#x75cd ?)
   (#x75d2 ?)
   (#x75d4 ?)
   (#x75d5 ?)
   (#x75d8 ?)
   (#x75d9 ?)
   (#x75db ?)
   (#x75de ?)
   (#x75e2 ?Ρ)
   (#x75e3 ?)
   (#x75e9 ?)
   (#x75f0 ?)
   (#x75f2 ?)
   (#x75f3 ?)
   (#x75f4 ?)
   (#x75fa ?)
   (#x75fc ?)
   (#x75fe ?)
   (#x75ff ?)
   (#x7601 ?)
   (#x7609 ?)
   (#x760b ?)
   (#x760d ?)
   (#x761f ?)
   (#x7620 ?)
   (#x7621 ?)
   (#x7622 ?)
   (#x7624 ?)
   (#x7627 ?)
   (#x7630 ?)
   (#x7634 ?)
   (#x763b ?)
   (#x7642 ?)
   (#x7646 ?)
   (#x7647 ?)
   (#x7648 ?)
   (#x764c ?)
   (#x7652 ?)
   (#x7656 ?)
   (#x7658 ?)
   (#x765c ?)
   (#x7661 ?)
   (#x7662 ?)
   (#x7667 ?)
   (#x7668 ?)
   (#x7669 ?)
   (#x766a ?)
   (#x766c ?)
   (#x7670 ?)
   (#x7672 ?)
   (#x7676 ?)
   (#x7678 ?)
   (#x767a ?ȯ)
   (#x767b ?)
   (#x767c ?)
   (#x767d ?)
   (#x767e ?ɴ)
   (#x7680 ?)
   (#x7683 ?)
   (#x7684 ?Ū)
   (#x7686 ?)
   (#x7687 ?)
   (#x7688 ?)
   (#x768b ?)
   (#x768e ?)
   (#x7690 ?)
   (#x7693 ?)
   (#x7696 ?)
   (#x7699 ?)
   (#x769a ?)
   (#x76ae ?)
   (#x76b0 ?)
   (#x76b4 ?)
   (#x76b7 ?)
   (#x76b8 ?)
   (#x76b9 ?)
   (#x76ba ?)
   (#x76bf ?)
   (#x76c2 ?)
   (#x76c3 ?)
   (#x76c6 ?)
   (#x76c8 ?)
   (#x76ca ?)
   (#x76cd ?)
   (#x76d2 ?)
   (#x76d6 ?)
   (#x76d7 ?)
   (#x76db ?)
   (#x76dc ?ݹ)
   (#x76de ?)
   (#x76df ?)
   (#x76e1 ?)
   (#x76e3 ?)
   (#x76e4 ?)
   (#x76e5 ?)
   (#x76e7 ?)
   (#x76ea ?)
   (#x76ee ?)
   (#x76f2 ?)
   (#x76f4 ?ľ)
   (#x76f8 ?)
   (#x76fb ?)
   (#x76fe ?)
   (#x7701 ?)
   (#x7704 ?)
   (#x7707 ?)
   (#x7708 ?)
   (#x7709 ?)
   (#x770b ?)
   (#x770c ?)
   (#x771b ?)
   (#x771e ?)
   (#x771f ?)
   (#x7720 ?̲)
   (#x7724 ?)
   (#x7725 ?)
   (#x7726 ?)
   (#x7729 ?)
   (#x7737 ?)
   (#x7738 ?)
   (#x773a ?į)
   (#x773c ?)
   (#x7740 ?)
   (#x7747 ?)
   (#x775a ?)
   (#x775b ?)
   (#x7761 ?)
   (#x7763 ?)
   (#x7765 ?)
   (#x7766 ?)
   (#x7768 ?)
   (#x776b ?)
   (#x7779 ?)
   (#x777e ?)
   (#x777f ?)
   (#x778b ?)
   (#x778e ?)
   (#x7791 ?)
   (#x779e ?)
   (#x77a0 ?)
   (#x77a5 ?)
   (#x77ac ?)
   (#x77ad ?)
   (#x77b0 ?)
   (#x77b3 ?Ʒ)
   (#x77b6 ?)
   (#x77b9 ?)
   (#x77bb ?)
   (#x77bc ?)
   (#x77bd ?)
   (#x77bf ?)
   (#x77c7 ?)
   (#x77cd ?)
   (#x77d7 ?)
   (#x77da ?)
   (#x77db ?̷)
   (#x77dc ?)
   (#x77e2 ?)
   (#x77e3 ?)
   (#x77e5 ?)
   (#x77e7 ?)
   (#x77e9 ?)
   (#x77ed ?û)
   (#x77ee ?)
   (#x77ef ?)
   (#x77f3 ?)
   (#x77fc ?)
   (#x7802 ?)
   (#x780c ?)
   (#x7812 ?)
   (#x7814 ?)
   (#x7815 ?)
   (#x7820 ?)
   (#x7825 ?)
   (#x7826 ?)
   (#x7827 ?)
   (#x7832 ?ˤ)
   (#x7834 ?)
   (#x783a ?)
   (#x783f ?)
   (#x7845 ?)
   (#x785d ?)
   (#x786b ?β)
   (#x786c ?)
   (#x786f ?)
   (#x7872 ?ȣ)
   (#x7874 ?)
   (#x787c ?)
   (#x7881 ?)
   (#x7886 ?)
   (#x7887 ?)
   (#x788c ?)
   (#x788d ?)
   (#x788e ?)
   (#x7891 ?)
   (#x7893 ?)
   (#x7895 ?)
   (#x7897 ?)
   (#x789a ?)
   (#x78a3 ?)
   (#x78a7 ?)
   (#x78a9 ?)
   (#x78aa ?)
   (#x78af ?)
   (#x78b5 ?)
   (#x78ba ?)
   (#x78bc ?)
   (#x78be ?)
   (#x78c1 ?)
   (#x78c5 ?)
   (#x78c6 ?)
   (#x78ca ?)
   (#x78cb ?)
   (#x78d0 ?)
   (#x78d1 ?)
   (#x78d4 ?)
   (#x78da ?)
   (#x78e7 ?)
   (#x78e8 ?)
   (#x78ec ?)
   (#x78ef ?)
   (#x78f4 ?)
   (#x78fd ?)
   (#x7901 ?)
   (#x7907 ?)
   (#x790e ?)
   (#x7911 ?)
   (#x7912 ?)
   (#x7919 ?)
   (#x7926 ?)
   (#x792a ?)
   (#x792b ?)
   (#x792c ?)
   (#x793a ?)
   (#x793c ?)
   (#x793e ?)
   (#x7940 ?)
   (#x7941 ?)
   (#x7947 ?)
   (#x7948 ?)
   (#x7949 ?)
   (#x7950 ?ʹ)
   (#x7953 ?)
   (#x7955 ?)
   (#x7956 ?)
   (#x7957 ?)
   (#x795a ?)
   (#x795d ?)
   (#x795e ?)
   (#x795f ?)
   (#x7960 ?)
   (#x7962 ?Ǫ)
   (#x7965 ?)
   (#x7968 ?ɼ)
   (#x796d ?)
   (#x7977 ?)
   (#x797a ?)
   (#x797f ?)
   (#x7980 ?)
   (#x7981 ?)
   (#x7984 ?Ͻ)
   (#x7985 ?)
   (#x798a ?)
   (#x798d ?)
   (#x798e ?)
   (#x798f ?ʡ)
   (#x799d ?)
   (#x79a6 ?)
   (#x79a7 ?)
   (#x79aa ?)
   (#x79ae ?)
   (#x79b0 ?ǩ)
   (#x79b3 ?)
   (#x79b9 ?)
   (#x79ba ?)
   (#x79bd ?)
   (#x79be ?)
   (#x79bf ?)
   (#x79c0 ?)
   (#x79c1 ?)
   (#x79c9 ?)
   (#x79cb ?)
   (#x79d1 ?)
   (#x79d2 ?)
   (#x79d5 ?)
   (#x79d8 ?)
   (#x79df ?)
   (#x79e1 ?)
   (#x79e3 ?)
   (#x79e4 ?)
   (#x79e6 ?)
   (#x79e7 ?)
   (#x79e9 ?)
   (#x79ec ?)
   (#x79f0 ?)
   (#x79fb ?)
   (#x7a00 ?)
   (#x7a08 ?)
   (#x7a0b ?)
   (#x7a0d ?)
   (#x7a0e ?)
   (#x7a14 ?̭)
   (#x7a17 ?ɣ)
   (#x7a18 ?)
   (#x7a19 ?)
   (#x7a1a ?)
   (#x7a1c ?)
   (#x7a1f ?)
   (#x7a20 ?)
   (#x7a2e ?)
   (#x7a31 ?)
   (#x7a32 ?)
   (#x7a37 ?)
   (#x7a3b ?)
   (#x7a3c ?)
   (#x7a3d ?)
   (#x7a3e ?)
   (#x7a3f ?)
   (#x7a40 ?)
   (#x7a42 ?)
   (#x7a43 ?)
   (#x7a46 ?)
   (#x7a49 ?)
   (#x7a4d ?)
   (#x7a4e ?)
   (#x7a4f ?)
   (#x7a50 ?)
   (#x7a57 ?)
   (#x7a61 ?)
   (#x7a62 ?)
   (#x7a63 ?)
   (#x7a69 ?)
   (#x7a6b ?)
   (#x7a70 ?)
   (#x7a74 ?)
   (#x7a76 ?)
   (#x7a79 ?)
   (#x7a7a ?)
   (#x7a7d ?)
   (#x7a7f ?)
   (#x7a81 ?)
   (#x7a83 ?)
   (#x7a84 ?)
   (#x7a88 ?)
   (#x7a92 ?)
   (#x7a93 ?)
   (#x7a95 ?)
   (#x7a96 ?)
   (#x7a97 ?)
   (#x7a98 ?)
   (#x7a9f ?)
   (#x7aa9 ?)
   (#x7aaa ?)
   (#x7aae ?)
   (#x7aaf ?)
   (#x7ab0 ?)
   (#x7ab6 ?)
   (#x7aba ?)
   (#x7abf ?)
   (#x7ac3 ?)
   (#x7ac4 ?)
   (#x7ac5 ?)
   (#x7ac7 ?)
   (#x7ac8 ?)
   (#x7aca ?)
   (#x7acb ?Ω)
   (#x7acd ?)
   (#x7acf ?)
   (#x7ad2 ?)
   (#x7ad3 ?)
   (#x7ad5 ?)
   (#x7ad9 ?)
   (#x7ada ?)
   (#x7adc ?ε)
   (#x7add ?)
   (#x7adf ?)
   (#x7ae0 ?)
   (#x7ae1 ?)
   (#x7ae2 ?)
   (#x7ae3 ?)
   (#x7ae5 ?Ƹ)
   (#x7ae6 ?)
   (#x7aea ?è)
   (#x7aed ?)
   (#x7aef ?ü)
   (#x7af0 ?)
   (#x7af6 ?)
   (#x7af8 ?ѿ)
   (#x7af9 ?)
   (#x7afa ?)
   (#x7aff ?)
   (#x7b02 ?)
   (#x7b04 ?)
   (#x7b06 ?)
   (#x7b08 ?)
   (#x7b0a ?)
   (#x7b0b ?)
   (#x7b0f ?)
   (#x7b11 ?)
   (#x7b18 ?)
   (#x7b19 ?)
   (#x7b1b ?ū)
   (#x7b1e ?)
   (#x7b20 ?)
   (#x7b25 ?)
   (#x7b26 ?)
   (#x7b28 ?)
   (#x7b2c ?)
   (#x7b33 ?)
   (#x7b35 ?)
   (#x7b36 ?)
   (#x7b39 ?)
   (#x7b45 ?)
   (#x7b46 ?ɮ)
   (#x7b48 ?Ȧ)
   (#x7b49 ?)
   (#x7b4b ?)
   (#x7b4c ?)
   (#x7b4d ?)
   (#x7b4f ?ȵ)
   (#x7b50 ?)
   (#x7b51 ?)
   (#x7b52 ?)
   (#x7b54 ?)
   (#x7b56 ?)
   (#x7b5d ?)
   (#x7b65 ?)
   (#x7b67 ?)
   (#x7b6c ?)
   (#x7b6e ?)
   (#x7b70 ?)
   (#x7b71 ?)
   (#x7b74 ?)
   (#x7b75 ?)
   (#x7b7a ?)
   (#x7b86 ?)
   (#x7b87 ?)
   (#x7b8b ?)
   (#x7b8d ?)
   (#x7b8f ?)
   (#x7b92 ?)
   (#x7b94 ?)
   (#x7b95 ?̧)
   (#x7b97 ?)
   (#x7b98 ?)
   (#x7b99 ?)
   (#x7b9a ?)
   (#x7b9c ?)
   (#x7b9d ?)
   (#x7b9f ?)
   (#x7ba1 ?)
   (#x7baa ?ý)
   (#x7bad ?)
   (#x7bb1 ?Ȣ)
   (#x7bb4 ?)
   (#x7bb8 ?Ȥ)
   (#x7bc0 ?)
   (#x7bc1 ?)
   (#x7bc4 ?)
   (#x7bc6 ?)
   (#x7bc7 ?)
   (#x7bc9 ?)
   (#x7bcb ?)
   (#x7bcc ?)
   (#x7bcf ?)
   (#x7bdd ?)
   (#x7be0 ?)
   (#x7be4 ?)
   (#x7be5 ?)
   (#x7be6 ?)
   (#x7be9 ?)
   (#x7bed ?϶)
   (#x7bf3 ?)
   (#x7bf6 ?)
   (#x7bf7 ?)
   (#x7c00 ?)
   (#x7c07 ?)
   (#x7c0d ?)
   (#x7c11 ?)
   (#x7c12 ?)
   (#x7c13 ?)
   (#x7c14 ?)
   (#x7c17 ?)
   (#x7c1f ?)
   (#x7c21 ?)
   (#x7c23 ?)
   (#x7c27 ?)
   (#x7c2a ?)
   (#x7c2b ?)
   (#x7c37 ?)
   (#x7c38 ?)
   (#x7c3d ?)
   (#x7c3e ?)
   (#x7c3f ?)
   (#x7c40 ?)
   (#x7c43 ?)
   (#x7c4c ?)
   (#x7c4d ?)
   (#x7c4f ?)
   (#x7c50 ?)
   (#x7c54 ?)
   (#x7c56 ?)
   (#x7c58 ?)
   (#x7c5f ?)
   (#x7c60 ?)
   (#x7c64 ?)
   (#x7c65 ?)
   (#x7c6c ?)
   (#x7c73 ?)
   (#x7c75 ?)
   (#x7c7e ?)
   (#x7c81 ?)
   (#x7c82 ?)
   (#x7c83 ?)
   (#x7c89 ?ʴ)
   (#x7c8b ?)
   (#x7c8d ?̰)
   (#x7c90 ?)
   (#x7c92 ?γ)
   (#x7c95 ?)
   (#x7c97 ?)
   (#x7c98 ?Ǵ)
   (#x7c9b ?)
   (#x7c9f ?)
   (#x7ca1 ?)
   (#x7ca2 ?)
   (#x7ca4 ?)
   (#x7ca5 ?)
   (#x7ca7 ?)
   (#x7ca8 ?)
   (#x7cab ?)
   (#x7cad ?)
   (#x7cae ?)
   (#x7cb1 ?)
   (#x7cb2 ?)
   (#x7cb3 ?)
   (#x7cb9 ?)
   (#x7cbd ?)
   (#x7cbe ?)
   (#x7cc0 ?)
   (#x7cc2 ?)
   (#x7cc5 ?)
   (#x7cca ?)
   (#x7cce ?)
   (#x7cd2 ?)
   (#x7cd6 ?)
   (#x7cd8 ?)
   (#x7cdc ?)
   (#x7cde ?ʵ)
   (#x7cdf ?)
   (#x7ce0 ?)
   (#x7ce2 ?)
   (#x7ce7 ?)
   (#x7cef ?)
   (#x7cf2 ?)
   (#x7cf4 ?)
   (#x7cf6 ?)
   (#x7cf8 ?)
   (#x7cfa ?)
   (#x7cfb ?)
   (#x7cfe ?)
   (#x7d00 ?)
   (#x7d02 ?)
   (#x7d04 ?)
   (#x7d05 ?)
   (#x7d06 ?)
   (#x7d0a ?)
   (#x7d0b ?)
   (#x7d0d ?Ǽ)
   (#x7d10 ?ɳ)
   (#x7d14 ?)
   (#x7d15 ?)
   (#x7d17 ?)
   (#x7d18 ?)
   (#x7d19 ?)
   (#x7d1a ?)
   (#x7d1b ?ʶ)
   (#x7d1c ?)
   (#x7d20 ?)
   (#x7d21 ?)
   (#x7d22 ?)
   (#x7d2b ?)
   (#x7d2c ?)
   (#x7d2e ?)
   (#x7d2f ?)
   (#x7d30 ?)
   (#x7d32 ?)
   (#x7d33 ?)
   (#x7d35 ?)
   (#x7d39 ?)
   (#x7d3a ?)
   (#x7d3f ?)
   (#x7d42 ?)
   (#x7d43 ?)
   (#x7d44 ?)
   (#x7d45 ?)
   (#x7d46 ?)
   (#x7d4b ?)
   (#x7d4c ?)
   (#x7d4e ?)
   (#x7d4f ?)
   (#x7d50 ?)
   (#x7d56 ?)
   (#x7d5b ?)
   (#x7d5e ?)
   (#x7d61 ?)
   (#x7d62 ?)
   (#x7d63 ?)
   (#x7d66 ?)
   (#x7d68 ?)
   (#x7d6e ?)
   (#x7d71 ?)
   (#x7d72 ?)
   (#x7d73 ?)
   (#x7d75 ?)
   (#x7d76 ?)
   (#x7d79 ?)
   (#x7d7d ?)
   (#x7d89 ?)
   (#x7d8f ?)
   (#x7d93 ?)
   (#x7d99 ?)
   (#x7d9a ?³)
   (#x7d9b ?)
   (#x7d9c ?)
   (#x7d9f ?)
   (#x7da2 ?)
   (#x7da3 ?)
   (#x7dab ?)
   (#x7dac ?)
   (#x7dad ?)
   (#x7dae ?)
   (#x7daf ?)
   (#x7db0 ?)
   (#x7db1 ?)
   (#x7db2 ?)
   (#x7db4 ?)
   (#x7db5 ?)
   (#x7db8 ?)
   (#x7dba ?)
   (#x7dbb ?þ)
   (#x7dbd ?)
   (#x7dbe ?)
   (#x7dbf ?)
   (#x7dc7 ?)
   (#x7dca ?)
   (#x7dcb ?)
   (#x7dcf ?)
   (#x7dd1 ?)
   (#x7dd2 ?)
   (#x7dd5 ?)
   (#x7dd8 ?)
   (#x7dda ?)
   (#x7ddc ?)
   (#x7ddd ?)
   (#x7dde ?)
   (#x7de0 ?)
   (#x7de1 ?)
   (#x7de4 ?)
   (#x7de8 ?)
   (#x7de9 ?)
   (#x7dec ?)
   (#x7def ?)
   (#x7df2 ?)
   (#x7df4 ?)
   (#x7dfb ?)
   (#x7e01 ?)
   (#x7e04 ?)
   (#x7e05 ?)
   (#x7e09 ?)
   (#x7e0a ?)
   (#x7e0b ?)
   (#x7e12 ?)
   (#x7e1b ?)
   (#x7e1e ?)
   (#x7e1f ?)
   (#x7e21 ?)
   (#x7e22 ?)
   (#x7e23 ?)
   (#x7e26 ?)
   (#x7e2b ?˥)
   (#x7e2e ?)
   (#x7e31 ?)
   (#x7e32 ?)
   (#x7e35 ?)
   (#x7e37 ?)
   (#x7e39 ?)
   (#x7e3a ?)
   (#x7e3b ?)
   (#x7e3d ?)
   (#x7e3e ?)
   (#x7e41 ?)
   (#x7e43 ?)
   (#x7e46 ?)
   (#x7e4a ?)
   (#x7e4b ?)
   (#x7e4d ?)
   (#x7e54 ?)
   (#x7e55 ?)
   (#x7e56 ?)
   (#x7e59 ?)
   (#x7e5a ?)
   (#x7e5d ?)
   (#x7e5e ?)
   (#x7e66 ?)
   (#x7e67 ?)
   (#x7e69 ?)
   (#x7e6a ?)
   (#x7e6d ?)
   (#x7e70 ?)
   (#x7e79 ?)
   (#x7e7b ?)
   (#x7e7c ?)
   (#x7e7d ?)
   (#x7e7f ?)
   (#x7e82 ?)
   (#x7e83 ?)
   (#x7e88 ?)
   (#x7e89 ?)
   (#x7e8c ?)
   (#x7e8e ?)
   (#x7e8f ?Ż)
   (#x7e90 ?)
   (#x7e92 ?)
   (#x7e93 ?)
   (#x7e94 ?)
   (#x7e96 ?)
   (#x7e9b ?)
   (#x7e9c ?)
   (#x7f36 ?)
   (#x7f38 ?)
   (#x7f3a ?)
   (#x7f45 ?)
   (#x7f4c ?)
   (#x7f4d ?)
   (#x7f4e ?)
   (#x7f50 ?)
   (#x7f51 ?)
   (#x7f54 ?)
   (#x7f55 ?)
   (#x7f58 ?)
   (#x7f5f ?)
   (#x7f60 ?)
   (#x7f67 ?)
   (#x7f68 ?)
   (#x7f69 ?)
   (#x7f6a ?)
   (#x7f6b ?)
   (#x7f6e ?)
   (#x7f70 ?ȳ)
   (#x7f72 ?)
   (#x7f75 ?)
   (#x7f77 ?)
   (#x7f78 ?)
   (#x7f79 ?)
   (#x7f82 ?)
   (#x7f83 ?)
   (#x7f85 ?)
   (#x7f86 ?)
   (#x7f87 ?)
   (#x7f88 ?)
   (#x7f8a ?)
   (#x7f8c ?)
   (#x7f8e ?)
   (#x7f94 ?)
   (#x7f9a ?)
   (#x7f9d ?)
   (#x7f9e ?)
   (#x7fa3 ?)
   (#x7fa4 ?)
   (#x7fa8 ?)
   (#x7fa9 ?)
   (#x7fae ?)
   (#x7faf ?)
   (#x7fb2 ?)
   (#x7fb6 ?)
   (#x7fb8 ?)
   (#x7fb9 ?)
   (#x7fbd ?)
   (#x7fc1 ?)
   (#x7fc5 ?)
   (#x7fc6 ?)
   (#x7fca ?)
   (#x7fcc ?)
   (#x7fd2 ?)
   (#x7fd4 ?)
   (#x7fd5 ?)
   (#x7fe0 ?)
   (#x7fe1 ?)
   (#x7fe6 ?)
   (#x7fe9 ?)
   (#x7feb ?)
   (#x7ff0 ?)
   (#x7ff3 ?)
   (#x7ff9 ?)
   (#x7ffb ?)
   (#x7ffc ?)
   (#x8000 ?)
   (#x8001 ?Ϸ)
   (#x8003 ?)
   (#x8004 ?)
   (#x8005 ?)
   (#x8006 ?)
   (#x800b ?)
   (#x800c ?)
   (#x8010 ?)
   (#x8012 ?)
   (#x8015 ?)
   (#x8017 ?)
   (#x8018 ?)
   (#x8019 ?)
   (#x801c ?)
   (#x8021 ?)
   (#x8028 ?)
   (#x8033 ?)
   (#x8036 ?)
   (#x803b ?)
   (#x803d ?ÿ)
   (#x803f ?)
   (#x8046 ?)
   (#x804a ?)
   (#x8052 ?)
   (#x8056 ?)
   (#x8058 ?)
   (#x805a ?)
   (#x805e ?ʹ)
   (#x805f ?)
   (#x8061 ?)
   (#x8062 ?)
   (#x8068 ?)
   (#x806f ?)
   (#x8070 ?)
   (#x8072 ?)
   (#x8073 ?)
   (#x8074 ?İ)
   (#x8076 ?)
   (#x8077 ?)
   (#x8079 ?)
   (#x807d ?)
   (#x807e ?ϸ)
   (#x807f ?)
   (#x8084 ?)
   (#x8085 ?)
   (#x8086 ?)
   (#x8087 ?ȥ)
   (#x8089 ?)
   (#x808b ?Ͼ)
   (#x808c ?ȩ)
   (#x8093 ?)
   (#x8096 ?)
   (#x8098 ?ɪ)
   (#x809a ?)
   (#x809b ?)
   (#x809d ?)
   (#x80a1 ?)
   (#x80a2 ?)
   (#x80a5 ?)
   (#x80a9 ?)
   (#x80aa ?)
   (#x80ac ?)
   (#x80ad ?)
   (#x80af ?)
   (#x80b1 ?)
   (#x80b2 ?)
   (#x80b4 ?)
   (#x80ba ?)
   (#x80c3 ?)
   (#x80c4 ?)
   (#x80c6 ?)
   (#x80cc ?)
   (#x80ce ?)
   (#x80d6 ?)
   (#x80d9 ?)
   (#x80da ?)
   (#x80db ?)
   (#x80dd ?)
   (#x80de ?˦)
   (#x80e1 ?)
   (#x80e4 ?)
   (#x80e5 ?)
   (#x80ef ?)
   (#x80f1 ?)
   (#x80f4 ?ƹ)
   (#x80f8 ?)
   (#x80fc ?)
   (#x80fd ?ǽ)
   (#x8102 ?)
   (#x8105 ?)
   (#x8106 ?)
   (#x8107 ?)
   (#x8108 ?̮)
   (#x8109 ?)
   (#x810a ?)
   (#x811a ?)
   (#x811b ?)
   (#x8123 ?)
   (#x8129 ?)
   (#x812f ?)
   (#x8131 ?æ)
   (#x8133 ?Ǿ)
   (#x8139 ?ı)
   (#x813e ?)
   (#x8146 ?)
   (#x814b ?)
   (#x814e ?)
   (#x8150 ?)
   (#x8151 ?)
   (#x8153 ?)
   (#x8154 ?)
   (#x8155 ?)
   (#x815f ?)
   (#x8165 ?)
   (#x8166 ?)
   (#x816b ?)
   (#x816e ?)
   (#x8170 ?)
   (#x8171 ?)
   (#x8174 ?)
   (#x8178 ?Ĳ)
   (#x8179 ?ʢ)
   (#x817a ?)
   (#x817f ?)
   (#x8180 ?)
   (#x8182 ?)
   (#x8183 ?)
   (#x8188 ?)
   (#x818a ?)
   (#x818f ?)
   (#x8193 ?)
   (#x8195 ?)
   (#x819a ?)
   (#x819c ?)
   (#x819d ?ɨ)
   (#x81a0 ?)
   (#x81a3 ?)
   (#x81a4 ?)
   (#x81a8 ?)
   (#x81a9 ?)
   (#x81b0 ?)
   (#x81b3 ?)
   (#x81b5 ?)
   (#x81b8 ?)
   (#x81ba ?)
   (#x81bd ?)
   (#x81be ?)
   (#x81bf ?ǿ)
   (#x81c0 ?)
   (#x81c2 ?)
   (#x81c6 ?)
   (#x81c8 ?)
   (#x81c9 ?)
   (#x81cd ?)
   (#x81d1 ?)
   (#x81d3 ?¡)
   (#x81d8 ?)
   (#x81d9 ?)
   (#x81da ?)
   (#x81df ?)
   (#x81e0 ?)
   (#x81e3 ?)
   (#x81e5 ?)
   (#x81e7 ?)
   (#x81e8 ?)
   (#x81ea ?)
   (#x81ed ?)
   (#x81f3 ?)
   (#x81f4 ?)
   (#x81fa ?)
   (#x81fb ?)
   (#x81fc ?)
   (#x81fe ?)
   (#x8201 ?)
   (#x8202 ?)
   (#x8205 ?)
   (#x8207 ?)
   (#x8208 ?)
   (#x8209 ?ڪ)
   (#x820a ?)
   (#x820c ?)
   (#x820d ?)
   (#x820e ?)
   (#x8210 ?)
   (#x8212 ?а)
   (#x8216 ?)
   (#x8217 ?)
   (#x8218 ?)
   (#x821b ?)
   (#x821c ?)
   (#x821e ?)
   (#x821f ?)
   (#x8229 ?)
   (#x822a ?)
   (#x822b ?)
   (#x822c ?)
   (#x822e ?)
   (#x8233 ?)
   (#x8235 ?)
   (#x8236 ?)
   (#x8237 ?)
   (#x8238 ?)
   (#x8239 ?)
   (#x8240 ?)
   (#x8247 ?)
   (#x8258 ?)
   (#x8259 ?)
   (#x825a ?)
   (#x825d ?)
   (#x825f ?)
   (#x8262 ?)
   (#x8264 ?)
   (#x8266 ?)
   (#x8268 ?)
   (#x826a ?)
   (#x826b ?)
   (#x826e ?)
   (#x826f ?)
   (#x8271 ?)
   (#x8272 ?)
   (#x8276 ?)
   (#x8277 ?)
   (#x8278 ?)
   (#x827e ?)
   (#x828b ?)
   (#x828d ?)
   (#x8292 ?)
   (#x8299 ?)
   (#x829d ?)
   (#x829f ?)
   (#x82a5 ?)
   (#x82a6 ?)
   (#x82ab ?)
   (#x82ac ?)
   (#x82ad ?)
   (#x82af ?)
   (#x82b1 ?)
   (#x82b3 ?˧)
   (#x82b8 ?)
   (#x82b9 ?)
   (#x82bb ?)
   (#x82bd ?)
   (#x82c5 ?)
   (#x82d1 ?)
   (#x82d2 ?)
   (#x82d3 ?)
   (#x82d4 ?)
   (#x82d7 ?)
   (#x82d9 ?)
   (#x82db ?)
   (#x82dc ?)
   (#x82de ?)
   (#x82df ?)
   (#x82e1 ?)
   (#x82e3 ?)
   (#x82e5 ?)
   (#x82e6 ?)
   (#x82e7 ?)
   (#x82eb ?)
   (#x82f1 ?)
   (#x82f3 ?)
   (#x82f4 ?)
   (#x82f9 ?)
   (#x82fa ?)
   (#x82fb ?)
   (#x8302 ?)
   (#x8303 ?)
   (#x8304 ?)
   (#x8305 ?)
   (#x8306 ?)
   (#x8309 ?)
   (#x830e ?)
   (#x8316 ?)
   (#x8317 ?)
   (#x8318 ?)
   (#x831c ?)
   (#x8323 ?)
   (#x8328 ?)
   (#x832b ?)
   (#x832f ?)
   (#x8331 ?)
   (#x8332 ?)
   (#x8334 ?)
   (#x8335 ?)
   (#x8336 ?)
   (#x8338 ?)
   (#x8339 ?)
   (#x8340 ?)
   (#x8345 ?)
   (#x8349 ?)
   (#x834a ?)
   (#x834f ?)
   (#x8350 ?)
   (#x8352 ?)
   (#x8358 ?)
   (#x8373 ?)
   (#x8375 ?)
   (#x8377 ?)
   (#x837b ?)
   (#x837c ?)
   (#x8385 ?)
   (#x8387 ?)
   (#x8389 ?)
   (#x838a ?)
   (#x838e ?)
   (#x8393 ?)
   (#x8396 ?)
   (#x839a ?)
   (#x839e ?)
   (#x839f ?)
   (#x83a0 ?)
   (#x83a2 ?)
   (#x83a8 ?)
   (#x83aa ?)
   (#x83ab ?)
   (#x83b1 ?)
   (#x83b5 ?)
   (#x83bd ?)
   (#x83c1 ?)
   (#x83c5 ?)
   (#x83ca ?)
   (#x83cc ?)
   (#x83ce ?)
   (#x83d3 ?)
   (#x83d6 ?)
   (#x83d8 ?)
   (#x83dc ?)
   (#x83df ?)
   (#x83e0 ?)
   (#x83e9 ?)
   (#x83eb ?)
   (#x83ef ?)
   (#x83f0 ?)
   (#x83f1 ?ɩ)
   (#x83f2 ?)
   (#x83f4 ?)
   (#x83f7 ?)
   (#x83fb ?)
   (#x83fd ?)
   (#x8403 ?)
   (#x8404 ?ƺ)
   (#x8407 ?)
   (#x840b ?)
   (#x840c ?˨)
   (#x840d ?)
   (#x840e ?)
   (#x8413 ?)
   (#x8420 ?)
   (#x8422 ?)
   (#x8429 ?)
   (#x842a ?)
   (#x842c ?)
   (#x8431 ?)
   (#x8435 ?)
   (#x8438 ?)
   (#x843c ?)
   (#x843d ?)
   (#x8446 ?)
   (#x8449 ?)
   (#x844e ?Ϊ)
   (#x8457 ?)
   (#x845b ?)
   (#x8461 ?)
   (#x8462 ?)
   (#x8463 ?ơ)
   (#x8466 ?)
   (#x8469 ?)
   (#x846b ?)
   (#x846c ?)
   (#x846d ?)
   (#x846e ?)
   (#x846f ?)
   (#x8471 ?Ǭ)
   (#x8475 ?)
   (#x8477 ?)
   (#x8479 ?)
   (#x847a ?)
   (#x8482 ?)
   (#x8484 ?)
   (#x848b ?)
   (#x8490 ?)
   (#x8494 ?)
   (#x8499 ?)
   (#x849c ?)
   (#x849f ?)
   (#x84a1 ?)
   (#x84ad ?)
   (#x84b2 ?)
   (#x84b8 ?)
   (#x84b9 ?)
   (#x84bb ?)
   (#x84bc ?)
   (#x84bf ?)
   (#x84c1 ?)
   (#x84c4 ?)
   (#x84c6 ?)
   (#x84c9 ?)
   (#x84ca ?)
   (#x84cb ?)
   (#x84cd ?)
   (#x84d0 ?)
   (#x84d1 ?̬)
   (#x84d6 ?)
   (#x84d9 ?)
   (#x84da ?)
   (#x84ec ?˩)
   (#x84ee ?ϡ)
   (#x84f4 ?)
   (#x84fc ?)
   (#x84ff ?)
   (#x8500 ?)
   (#x8506 ?)
   (#x8511 ?)
   (#x8513 ?̢)
   (#x8514 ?)
   (#x8515 ?)
   (#x8517 ?)
   (#x8518 ?)
   (#x851a ?)
   (#x851f ?)
   (#x8521 ?)
   (#x8526 ?)
   (#x852c ?)
   (#x852d ?)
   (#x8535 ?¢)
   (#x853d ?)
   (#x8540 ?)
   (#x8541 ?)
   (#x8543 ?)
   (#x8548 ?)
   (#x8549 ?)
   (#x854a ?)
   (#x854b ?)
   (#x854e ?)
   (#x8555 ?)
   (#x8557 ?)
   (#x8558 ?)
   (#x855a ?)
   (#x8563 ?)
   (#x8568 ?)
   (#x8569 ?Ƣ)
   (#x856a ?)
   (#x856d ?)
   (#x8577 ?)
   (#x857e ?)
   (#x8580 ?)
   (#x8584 ?)
   (#x8587 ?)
   (#x8588 ?)
   (#x858a ?)
   (#x8590 ?)
   (#x8591 ?)
   (#x8594 ?)
   (#x8597 ?)
   (#x8599 ?)
   (#x859b ?)
   (#x859c ?)
   (#x85a4 ?)
   (#x85a6 ?)
   (#x85a8 ?)
   (#x85a9 ?)
   (#x85aa ?)
   (#x85ab ?)
   (#x85ac ?)
   (#x85ae ?)
   (#x85af ?)
   (#x85b9 ?)
   (#x85ba ?)
   (#x85c1 ?)
   (#x85c9 ?)
   (#x85cd ?)
   (#x85cf ?)
   (#x85d0 ?)
   (#x85d5 ?)
   (#x85dc ?)
   (#x85dd ?)
   (#x85e4 ?ƣ)
   (#x85e5 ?)
   (#x85e9 ?)
   (#x85ea ?)
   (#x85f7 ?)
   (#x85f9 ?)
   (#x85fa ?)
   (#x85fb ?)
   (#x85fe ?)
   (#x8602 ?)
   (#x8606 ?)
   (#x8607 ?)
   (#x860a ?)
   (#x860b ?)
   (#x8613 ?)
   (#x8616 ?ݱ)
   (#x8617 ?ݢ)
   (#x861a ?)
   (#x8622 ?)
   (#x862d ?)
   (#x862f ?)
   (#x8630 ?)
   (#x863f ?)
   (#x864d ?)
   (#x864e ?)
   (#x8650 ?)
   (#x8654 ?)
   (#x8655 ?)
   (#x865a ?)
   (#x865c ?κ)
   (#x865e ?)
   (#x865f ?)
   (#x8667 ?)
   (#x866b ?)
   (#x8671 ?)
   (#x8679 ?)
   (#x867b ?)
   (#x868a ?)
   (#x868b ?)
   (#x868c ?)
   (#x8693 ?)
   (#x8695 ?)
   (#x86a3 ?)
   (#x86a4 ?)
   (#x86a9 ?)
   (#x86aa ?)
   (#x86ab ?)
   (#x86af ?)
   (#x86b0 ?)
   (#x86b6 ?)
   (#x86c4 ?)
   (#x86c6 ?)
   (#x86c7 ?)
   (#x86c9 ?)
   (#x86cb ?)
   (#x86cd ?)
   (#x86ce ?)
   (#x86d4 ?)
   (#x86d9 ?)
   (#x86db ?)
   (#x86de ?)
   (#x86df ?)
   (#x86e4 ?Ⱥ)
   (#x86e9 ?)
   (#x86ec ?)
   (#x86ed ?)
   (#x86ee ?)
   (#x86ef ?)
   (#x86f8 ?)
   (#x86f9 ?)
   (#x86fb ?)
   (#x86fe ?)
   (#x8700 ?)
   (#x8702 ?˪)
   (#x8703 ?)
   (#x8706 ?)
   (#x8708 ?)
   (#x8709 ?)
   (#x870a ?)
   (#x870d ?)
   (#x8711 ?)
   (#x8712 ?)
   (#x8718 ?)
   (#x871a ?)
   (#x871c ?̪)
   (#x8725 ?)
   (#x8729 ?)
   (#x8734 ?)
   (#x8737 ?)
   (#x873b ?)
   (#x873f ?)
   (#x8749 ?)
   (#x874b ?Ϲ)
   (#x874c ?)
   (#x874e ?)
   (#x8753 ?)
   (#x8755 ?)
   (#x8757 ?)
   (#x8759 ?)
   (#x875f ?)
   (#x8760 ?)
   (#x8763 ?)
   (#x8766 ?)
   (#x8768 ?)
   (#x876a ?)
   (#x876e ?)
   (#x8774 ?)
   (#x8776 ?ĳ)
   (#x8778 ?)
   (#x877f ?)
   (#x8782 ?)
   (#x878d ?ͻ)
   (#x879f ?)
   (#x87a2 ?)
   (#x87ab ?)
   (#x87af ?)
   (#x87b3 ?)
   (#x87ba ?)
   (#x87bb ?)
   (#x87bd ?)
   (#x87c0 ?)
   (#x87c4 ?)
   (#x87c6 ?)
   (#x87c7 ?)
   (#x87cb ?)
   (#x87d0 ?)
   (#x87d2 ?)
   (#x87e0 ?)
   (#x87ef ?)
   (#x87f2 ?)
   (#x87f6 ?)
   (#x87f7 ?)
   (#x87f9 ?)
   (#x87fb ?)
   (#x87fe ?)
   (#x8805 ?)
   (#x880d ?)
   (#x880e ?)
   (#x880f ?)
   (#x8811 ?)
   (#x8815 ?)
   (#x8816 ?)
   (#x8821 ?)
   (#x8822 ?)
   (#x8823 ?)
   (#x8827 ?)
   (#x8831 ?)
   (#x8836 ?)
   (#x8839 ?)
   (#x883b ?)
   (#x8840 ?)
   (#x8842 ?)
   (#x8844 ?)
   (#x8846 ?)
   (#x884c ?)
   (#x884d ?ާ)
   (#x8852 ?)
   (#x8853 ?)
   (#x8857 ?)
   (#x8859 ?)
   (#x885b ?)
   (#x885d ?)
   (#x885e ?)
   (#x8861 ?)
   (#x8862 ?)
   (#x8863 ?)
   (#x8868 ?ɽ)
   (#x886b ?)
   (#x8870 ?)
   (#x8872 ?)
   (#x8875 ?)
   (#x8877 ?)
   (#x887d ?)
   (#x887e ?)
   (#x887f ?)
   (#x8881 ?)
   (#x8882 ?)
   (#x8888 ?)
   (#x888b ?)
   (#x888d ?)
   (#x8892 ?)
   (#x8896 ?µ)
   (#x8897 ?)
   (#x8899 ?)
   (#x889e ?)
   (#x88a2 ?)
   (#x88a4 ?)
   (#x88ab ?)
   (#x88ae ?)
   (#x88b0 ?)
   (#x88b1 ?)
   (#x88b4 ?)
   (#x88b5 ?)
   (#x88b7 ?)
   (#x88bf ?)
   (#x88c1 ?)
   (#x88c2 ?)
   (#x88c3 ?)
   (#x88c4 ?)
   (#x88c5 ?)
   (#x88cf ?΢)
   (#x88d4 ?)
   (#x88d5 ?͵)
   (#x88d8 ?)
   (#x88d9 ?)
   (#x88dc ?)
   (#x88dd ?)
   (#x88df ?)
   (#x88e1 ?Σ)
   (#x88e8 ?)
   (#x88f2 ?)
   (#x88f3 ?)
   (#x88f4 ?)
   (#x88f8 ?)
   (#x88f9 ?)
   (#x88fc ?)
   (#x88fd ?)
   (#x88fe ?)
   (#x8902 ?)
   (#x8904 ?)
   (#x8907 ?ʣ)
   (#x890a ?)
   (#x890c ?)
   (#x8910 ?)
   (#x8912 ?˫)
   (#x8913 ?)
   (#x891d ?)
   (#x891e ?)
   (#x8925 ?)
   (#x892a ?)
   (#x892b ?)
   (#x8936 ?)
   (#x8938 ?)
   (#x893b ?)
   (#x8941 ?)
   (#x8943 ?)
   (#x8944 ?)
   (#x894c ?)
   (#x894d ?)
   (#x8956 ?)
   (#x895e ?)
   (#x895f ?)
   (#x8960 ?)
   (#x8964 ?)
   (#x8966 ?)
   (#x896a ?)
   (#x896d ?)
   (#x896f ?)
   (#x8972 ?)
   (#x8974 ?)
   (#x8977 ?)
   (#x897e ?)
   (#x897f ?)
   (#x8981 ?)
   (#x8983 ?)
   (#x8986 ?ʤ)
   (#x8987 ?)
   (#x8988 ?)
   (#x898a ?)
   (#x898b ?)
   (#x898f ?)
   (#x8993 ?)
   (#x8996 ?)
   (#x8997 ?)
   (#x8998 ?)
   (#x899a ?)
   (#x89a1 ?)
   (#x89a6 ?)
   (#x89a7 ?)
   (#x89a9 ?)
   (#x89aa ?)
   (#x89ac ?)
   (#x89af ?)
   (#x89b2 ?)
   (#x89b3 ?)
   (#x89ba ?)
   (#x89bd ?)
   (#x89bf ?)
   (#x89c0 ?)
   (#x89d2 ?)
   (#x89da ?)
   (#x89dc ?)
   (#x89dd ?)
   (#x89e3 ?)
   (#x89e6 ?)
   (#x89e7 ?)
   (#x89f4 ?)
   (#x89f8 ?)
   (#x8a00 ?)
   (#x8a02 ?)
   (#x8a03 ?)
   (#x8a08 ?)
   (#x8a0a ?)
   (#x8a0c ?)
   (#x8a0e ?Ƥ)
   (#x8a10 ?)
   (#x8a13 ?)
   (#x8a16 ?)
   (#x8a17 ?)
   (#x8a18 ?)
   (#x8a1b ?)
   (#x8a1d ?)
   (#x8a1f ?)
   (#x8a23 ?)
   (#x8a25 ?)
   (#x8a2a ?ˬ)
   (#x8a2d ?)
   (#x8a31 ?)
   (#x8a33 ?)
   (#x8a34 ?)
   (#x8a36 ?)
   (#x8a3a ?)
   (#x8a3b ?)
   (#x8a3c ?)
   (#x8a41 ?)
   (#x8a46 ?)
   (#x8a48 ?)
   (#x8a50 ?)
   (#x8a51 ?)
   (#x8a52 ?)
   (#x8a54 ?)
   (#x8a55 ?ɾ)
   (#x8a5b ?)
   (#x8a5e ?)
   (#x8a60 ?)
   (#x8a62 ?)
   (#x8a63 ?)
   (#x8a66 ?)
   (#x8a69 ?)
   (#x8a6b ?)
   (#x8a6c ?)
   (#x8a6d ?)
   (#x8a6e ?)
   (#x8a70 ?)
   (#x8a71 ?)
   (#x8a72 ?)
   (#x8a73 ?)
   (#x8a7c ?)
   (#x8a82 ?)
   (#x8a84 ?)
   (#x8a85 ?)
   (#x8a87 ?)
   (#x8a89 ?)
   (#x8a8c ?)
   (#x8a8d ?ǧ)
   (#x8a91 ?)
   (#x8a93 ?)
   (#x8a95 ?)
   (#x8a98 ?Ͷ)
   (#x8a9a ?)
   (#x8a9e ?)
   (#x8aa0 ?)
   (#x8aa1 ?)
   (#x8aa3 ?)
   (#x8aa4 ?)
   (#x8aa5 ?)
   (#x8aa6 ?)
   (#x8aa8 ?)
   (#x8aac ?)
   (#x8aad ?)
   (#x8ab0 ?ï)
   (#x8ab2 ?)
   (#x8ab9 ?)
   (#x8abc ?)
   (#x8abf ?Ĵ)
   (#x8ac2 ?)
   (#x8ac4 ?)
   (#x8ac7 ?)
   (#x8acb ?)
   (#x8acc ?)
   (#x8acd ?)
   (#x8acf ?)
   (#x8ad2 ?)
   (#x8ad6 ?)
   (#x8ada ?)
   (#x8adb ?)
   (#x8adc ?ĵ)
   (#x8ade ?)
   (#x8ae0 ?)
   (#x8ae1 ?)
   (#x8ae2 ?)
   (#x8ae4 ?)
   (#x8ae6 ?)
   (#x8ae7 ?)
   (#x8aeb ?)
   (#x8aed ?͡)
   (#x8aee ?)
   (#x8af1 ?)
   (#x8af3 ?)
   (#x8af7 ?)
   (#x8af8 ?)
   (#x8afa ?)
   (#x8afe ?)
   (#x8b00 ?)
   (#x8b01 ?)
   (#x8b02 ?)
   (#x8b04 ?ƥ)
   (#x8b07 ?)
   (#x8b0c ?)
   (#x8b0e ?)
   (#x8b10 ?)
   (#x8b14 ?)
   (#x8b16 ?)
   (#x8b17 ?)
   (#x8b19 ?)
   (#x8b1a ?)
   (#x8b1b ?)
   (#x8b1d ?)
   (#x8b20 ?)
   (#x8b21 ?)
   (#x8b26 ?)
   (#x8b28 ?)
   (#x8b2b ?)
   (#x8b2c ?ɵ)
   (#x8b33 ?)
   (#x8b39 ?)
   (#x8b3e ?)
   (#x8b41 ?)
   (#x8b49 ?)
   (#x8b4c ?)
   (#x8b4e ?)
   (#x8b4f ?)
   (#x8b56 ?)
   (#x8b58 ?)
   (#x8b5a ?)
   (#x8b5b ?)
   (#x8b5c ?)
   (#x8b5f ?)
   (#x8b66 ?)
   (#x8b6b ?)
   (#x8b6c ?)
   (#x8b6f ?)
   (#x8b70 ?)
   (#x8b71 ?)
   (#x8b72 ?)
   (#x8b74 ?)
   (#x8b77 ?)
   (#x8b7d ?)
   (#x8b80 ?)
   (#x8b83 ?)
   (#x8b8a ?)
   (#x8b8c ?)
   (#x8b8e ?)
   (#x8b90 ?)
   (#x8b92 ?)
   (#x8b93 ?)
   (#x8b96 ?)
   (#x8b99 ?)
   (#x8b9a ?)
   (#x8c37 ?ë)
   (#x8c3a ?)
   (#x8c3f ?)
   (#x8c41 ?)
   (#x8c46 ?Ʀ)
   (#x8c48 ?)
   (#x8c4a ?˭)
   (#x8c4c ?)
   (#x8c4e ?)
   (#x8c50 ?)
   (#x8c55 ?)
   (#x8c5a ?)
   (#x8c61 ?)
   (#x8c62 ?)
   (#x8c6a ?)
   (#x8c6b ?Ю)
   (#x8c6c ?)
   (#x8c78 ?)
   (#x8c79 ?ɿ)
   (#x8c7a ?)
   (#x8c7c ?)
   (#x8c82 ?)
   (#x8c85 ?)
   (#x8c89 ?)
   (#x8c8a ?)
   (#x8c8c ?)
   (#x8c8d ?)
   (#x8c8e ?)
   (#x8c94 ?)
   (#x8c98 ?)
   (#x8c9d ?)
   (#x8c9e ?)
   (#x8ca0 ?)
   (#x8ca1 ?)
   (#x8ca2 ?)
   (#x8ca7 ?)
   (#x8ca8 ?)
   (#x8ca9 ?)
   (#x8caa ?)
   (#x8cab ?)
   (#x8cac ?)
   (#x8cad ?)
   (#x8cae ?)
   (#x8caf ?)
   (#x8cb0 ?)
   (#x8cb2 ?)
   (#x8cb3 ?)
   (#x8cb4 ?)
   (#x8cb6 ?)
   (#x8cb7 ?)
   (#x8cb8 ?)
   (#x8cbb ?)
   (#x8cbc ?Ž)
   (#x8cbd ?)
   (#x8cbf ?)
   (#x8cc0 ?)
   (#x8cc1 ?)
   (#x8cc2 ?Ϩ)
   (#x8cc3 ?)
   (#x8cc4 ?)
   (#x8cc7 ?)
   (#x8cc8 ?)
   (#x8cca ?±)
   (#x8ccd ?)
   (#x8cce ?)
   (#x8cd1 ?)
   (#x8cd3 ?)
   (#x8cda ?)
   (#x8cdb ?)
   (#x8cdc ?)
   (#x8cde ?)
   (#x8ce0 ?)
   (#x8ce2 ?)
   (#x8ce3 ?)
   (#x8ce4 ?)
   (#x8ce6 ?)
   (#x8cea ?)
   (#x8ced ?)
   (#x8cfa ?)
   (#x8cfb ?)
   (#x8cfc ?)
   (#x8cfd ?)
   (#x8d04 ?)
   (#x8d05 ?)
   (#x8d07 ?)
   (#x8d08 ?£)
   (#x8d0a ?)
   (#x8d0b ?)
   (#x8d0d ?)
   (#x8d0f ?)
   (#x8d10 ?)
   (#x8d13 ?)
   (#x8d14 ?)
   (#x8d16 ?)
   (#x8d64 ?)
   (#x8d66 ?)
   (#x8d67 ?)
   (#x8d6b ?)
   (#x8d6d ?)
   (#x8d70 ?)
   (#x8d71 ?)
   (#x8d73 ?)
   (#x8d74 ?)
   (#x8d77 ?)
   (#x8d81 ?)
   (#x8d85 ?Ķ)
   (#x8d8a ?)
   (#x8d99 ?)
   (#x8da3 ?)
   (#x8da8 ?)
   (#x8db3 ?­)
   (#x8dba ?)
   (#x8dbe ?)
   (#x8dc2 ?)
   (#x8dcb ?)
   (#x8dcc ?)
   (#x8dcf ?)
   (#x8dd6 ?)
   (#x8dda ?)
   (#x8ddb ?)
   (#x8ddd ?)
   (#x8ddf ?)
   (#x8de1 ?)
   (#x8de3 ?)
   (#x8de8 ?)
   (#x8dea ?)
   (#x8deb ?)
   (#x8def ?ϩ)
   (#x8df3 ?ķ)
   (#x8df5 ?)
   (#x8dfc ?)
   (#x8dff ?)
   (#x8e08 ?)
   (#x8e09 ?)
   (#x8e0a ?)
   (#x8e0f ?Ƨ)
   (#x8e10 ?)
   (#x8e1d ?)
   (#x8e1e ?)
   (#x8e1f ?)
   (#x8e2a ?)
   (#x8e30 ?)
   (#x8e34 ?)
   (#x8e35 ?)
   (#x8e42 ?)
   (#x8e44 ?)
   (#x8e47 ?)
   (#x8e48 ?)
   (#x8e49 ?)
   (#x8e4a ?)
   (#x8e4c ?)
   (#x8e50 ?)
   (#x8e55 ?)
   (#x8e59 ?)
   (#x8e5f ?)
   (#x8e60 ?)
   (#x8e63 ?)
   (#x8e64 ?)
   (#x8e72 ?)
   (#x8e74 ?)
   (#x8e76 ?)
   (#x8e7c ?)
   (#x8e81 ?)
   (#x8e84 ?)
   (#x8e85 ?)
   (#x8e87 ?)
   (#x8e8a ?)
   (#x8e8b ?)
   (#x8e8d ?)
   (#x8e91 ?)
   (#x8e93 ?)
   (#x8e94 ?)
   (#x8e99 ?)
   (#x8ea1 ?)
   (#x8eaa ?)
   (#x8eab ?)
   (#x8eac ?)
   (#x8eaf ?)
   (#x8eb0 ?)
   (#x8eb1 ?)
   (#x8ebe ?)
   (#x8ec5 ?)
   (#x8ec6 ?)
   (#x8ec8 ?)
   (#x8eca ?)
   (#x8ecb ?)
   (#x8ecc ?)
   (#x8ecd ?)
   (#x8ed2 ?)
   (#x8edb ?)
   (#x8edf ?)
   (#x8ee2 ?ž)
   (#x8ee3 ?)
   (#x8eeb ?)
   (#x8ef8 ?)
   (#x8efb ?)
   (#x8efc ?)
   (#x8efd ?)
   (#x8efe ?)
   (#x8f03 ?)
   (#x8f05 ?)
   (#x8f09 ?)
   (#x8f0a ?)
   (#x8f0c ?)
   (#x8f12 ?)
   (#x8f13 ?)
   (#x8f14 ?)
   (#x8f15 ?)
   (#x8f19 ?)
   (#x8f1b ?)
   (#x8f1c ?)
   (#x8f1d ?)
   (#x8f1f ?)
   (#x8f26 ?)
   (#x8f29 ?)
   (#x8f2a ?)
   (#x8f2f ?)
   (#x8f33 ?)
   (#x8f38 ?͢)
   (#x8f39 ?)
   (#x8f3b ?)
   (#x8f3e ?)
   (#x8f3f ?)
   (#x8f42 ?)
   (#x8f44 ?)
   (#x8f45 ?)
   (#x8f46 ?)
   (#x8f49 ?)
   (#x8f4c ?)
   (#x8f4d ?Ų)
   (#x8f4e ?)
   (#x8f57 ?)
   (#x8f5c ?)
   (#x8f5f ?)
   (#x8f61 ?)
   (#x8f62 ?)
   (#x8f63 ?)
   (#x8f64 ?)
   (#x8f9b ?)
   (#x8f9c ?)
   (#x8f9e ?)
   (#x8f9f ?)
   (#x8fa3 ?)
   (#x8fa7 ?ҡ)
   (#x8fa8 ?)
   (#x8fad ?)
   (#x8fae ?)
   (#x8faf ?)
   (#x8fb0 ?ä)
   (#x8fb1 ?)
   (#x8fb2 ?)
   (#x8fb7 ?)
   (#x8fba ?)
   (#x8fbb ?)
   (#x8fbc ?)
   (#x8fbf ?é)
   (#x8fc2 ?)
   (#x8fc4 ?)
   (#x8fc5 ?)
   (#x8fce ?)
   (#x8fd1 ?)
   (#x8fd4 ?)
   (#x8fda ?)
   (#x8fe2 ?)
   (#x8fe5 ?)
   (#x8fe6 ?)
   (#x8fe9 ?)
   (#x8fea ?)
   (#x8feb ?)
   (#x8fed ?ų)
   (#x8fef ?)
   (#x8ff0 ?)
   (#x8ff4 ?)
   (#x8ff7 ?)
   (#x8ff8 ?)
   (#x8ff9 ?)
   (#x8ffa ?)
   (#x8ffd ?)
   (#x9000 ?)
   (#x9001 ?)
   (#x9003 ?ƨ)
   (#x9005 ?)
   (#x9006 ?)
   (#x900b ?)
   (#x900d ?)
   (#x900e ?)
   (#x900f ?Ʃ)
   (#x9010 ?)
   (#x9011 ?)
   (#x9013 ?)
   (#x9014 ?)
   (#x9015 ?)
   (#x9016 ?)
   (#x9017 ?)
   (#x9019 ?)
   (#x901a ?)
   (#x901d ?)
   (#x901e ?)
   (#x901f ?®)
   (#x9020 ?¤)
   (#x9021 ?)
   (#x9022 ?)
   (#x9023 ?Ϣ)
   (#x9027 ?)
   (#x902e ?)
   (#x9031 ?)
   (#x9032 ?)
   (#x9035 ?)
   (#x9036 ?)
   (#x9038 ?)
   (#x9039 ?)
   (#x903c ?ɯ)
   (#x903e ?)
   (#x9041 ?)
   (#x9042 ?)
   (#x9045 ?)
   (#x9047 ?)
   (#x9049 ?)
   (#x904a ?ͷ)
   (#x904b ?)
   (#x904d ?)
   (#x904e ?)
   (#x904f ?)
   (#x9050 ?)
   (#x9051 ?)
   (#x9052 ?)
   (#x9053 ?ƻ)
   (#x9054 ?ã)
   (#x9055 ?)
   (#x9056 ?)
   (#x9058 ?)
   (#x9059 ?)
   (#x905c ?½)
   (#x905e ?)
   (#x9060 ?)
   (#x9061 ?)
   (#x9063 ?)
   (#x9065 ?)
   (#x9068 ?)
   (#x9069 ?Ŭ)
   (#x906d ?)
   (#x906e ?)
   (#x906f ?)
   (#x9072 ?)
   (#x9075 ?)
   (#x9076 ?)
   (#x9077 ?)
   (#x9078 ?)
   (#x907a ?)
   (#x907c ?)
   (#x907d ?)
   (#x907f ?)
   (#x9080 ?)
   (#x9081 ?)
   (#x9082 ?)
   (#x9083 ?)
   (#x9084 ?)
   (#x9087 ?)
   (#x9089 ?)
   (#x908a ?)
   (#x908f ?)
   (#x9091 ?͸)
   (#x90a3 ?)
   (#x90a6 ?ˮ)
   (#x90a8 ?)
   (#x90aa ?)
   (#x90af ?)
   (#x90b1 ?)
   (#x90b5 ?)
   (#x90b8 ?š)
   (#x90c1 ?)
   (#x90ca ?)
   (#x90ce ?Ϻ)
   (#x90db ?)
   (#x90e1 ?)
   (#x90e2 ?)
   (#x90e4 ?)
   (#x90e8 ?)
   (#x90ed ?)
   (#x90f5 ?͹)
   (#x90f7 ?)
   (#x90fd ?)
   (#x9102 ?)
   (#x9112 ?)
   (#x9119 ?)
   (#x912d ?Ţ)
   (#x9130 ?)
   (#x9132 ?)
   (#x9149 ?)
   (#x914a ?)
   (#x914b ?)
   (#x914c ?)
   (#x914d ?)
   (#x914e ?)
   (#x9152 ?)
   (#x9154 ?)
   (#x9156 ?)
   (#x9158 ?)
   (#x9162 ?)
   (#x9163 ?)
   (#x9165 ?)
   (#x9169 ?)
   (#x916a ?)
   (#x916c ?)
   (#x9172 ?)
   (#x9173 ?)
   (#x9175 ?)
   (#x9177 ?)
   (#x9178 ?)
   (#x9182 ?)
   (#x9187 ?)
   (#x9189 ?)
   (#x918b ?)
   (#x918d ?)
   (#x9190 ?)
   (#x9192 ?)
   (#x9197 ?Ȱ)
   (#x919c ?)
   (#x91a2 ?)
   (#x91a4 ?)
   (#x91aa ?)
   (#x91ab ?)
   (#x91af ?)
   (#x91b4 ?)
   (#x91b5 ?)
   (#x91b8 ?)
   (#x91ba ?)
   (#x91c0 ?)
   (#x91c1 ?)
   (#x91c6 ?)
   (#x91c7 ?)
   (#x91c8 ?)
   (#x91c9 ?)
   (#x91cb ?)
   (#x91cc ?Τ)
   (#x91cd ?)
   (#x91ce ?)
   (#x91cf ?)
   (#x91d0 ?)
   (#x91d1 ?)
   (#x91d6 ?)
   (#x91d8 ?ţ)
   (#x91db ?)
   (#x91dc ?)
   (#x91dd ?)
   (#x91df ?)
   (#x91e1 ?)
   (#x91e3 ?)
   (#x91e6 ?)
   (#x91e7 ?)
   (#x91f5 ?)
   (#x91f6 ?)
   (#x91fc ?)
   (#x91ff ?)
   (#x920d ?)
   (#x920e ?)
   (#x9211 ?)
   (#x9214 ?)
   (#x9215 ?)
   (#x921e ?)
   (#x9229 ?)
   (#x922c ?)
   (#x9234 ?)
   (#x9237 ?)
   (#x923f ?)
   (#x9244 ?Ŵ)
   (#x9245 ?)
   (#x9248 ?)
   (#x9249 ?)
   (#x924b ?)
   (#x9250 ?)
   (#x9257 ?)
   (#x925a ?)
   (#x925b ?)
   (#x925e ?)
   (#x9262 ?ȭ)
   (#x9264 ?)
   (#x9266 ?)
   (#x9271 ?)
   (#x927e ?)
   (#x9280 ?)
   (#x9283 ?)
   (#x9285 ?Ƽ)
   (#x9291 ?)
   (#x9293 ?)
   (#x9295 ?)
   (#x9296 ?)
   (#x9298 ?)
   (#x929a ?ĸ)
   (#x929b ?)
   (#x929c ?)
   (#x92ad ?)
   (#x92b7 ?)
   (#x92b9 ?)
   (#x92cf ?)
   (#x92d2 ?˯)
   (#x92e4 ?)
   (#x92e9 ?)
   (#x92ea ?)
   (#x92ed ?)
   (#x92f2 ?)
   (#x92f3 ?)
   (#x92f8 ?)
   (#x92fa ?)
   (#x92fc ?)
   (#x9306 ?)
   (#x930f ?)
   (#x9310 ?)
   (#x9318 ?)
   (#x9319 ?)
   (#x931a ?)
   (#x9320 ?)
   (#x9322 ?)
   (#x9323 ?)
   (#x9326 ?)
   (#x9328 ?)
   (#x932b ?)
   (#x932c ?ϣ)
   (#x932e ?)
   (#x932f ?)
   (#x9332 ?Ͽ)
   (#x9335 ?)
   (#x933a ?)
   (#x933b ?)
   (#x9344 ?)
   (#x934b ?)
   (#x934d ?)
   (#x9354 ?)
   (#x9356 ?)
   (#x935b ?)
   (#x935c ?)
   (#x9360 ?)
   (#x936c ?)
   (#x936e ?)
   (#x9375 ?)
   (#x937c ?)
   (#x937e ?)
   (#x938c ?)
   (#x9394 ?)
   (#x9396 ?)
   (#x9397 ?)
   (#x939a ?)
   (#x93a7 ?)
   (#x93ac ?)
   (#x93ad ?)
   (#x93ae ?)
   (#x93b0 ?)
   (#x93b9 ?)
   (#x93c3 ?)
   (#x93c8 ?)
   (#x93d0 ?)
   (#x93d1 ?ŭ)
   (#x93d6 ?)
   (#x93d7 ?)
   (#x93d8 ?)
   (#x93dd ?)
   (#x93e1 ?)
   (#x93e4 ?)
   (#x93e5 ?)
   (#x93e8 ?)
   (#x9403 ?)
   (#x9407 ?)
   (#x9410 ?)
   (#x9413 ?)
   (#x9414 ?)
   (#x9418 ?)
   (#x9419 ?ƪ)
   (#x941a ?)
   (#x9421 ?)
   (#x942b ?)
   (#x9435 ?)
   (#x9436 ?)
   (#x9438 ?)
   (#x943a ?)
   (#x9441 ?)
   (#x9444 ?)
   (#x9451 ?)
   (#x9452 ?)
   (#x9453 ?)
   (#x945a ?)
   (#x945b ?)
   (#x945e ?)
   (#x9460 ?)
   (#x9462 ?)
   (#x946a ?)
   (#x9470 ?)
   (#x9475 ?)
   (#x9477 ?)
   (#x947c ?)
   (#x947d ?)
   (#x947e ?)
   (#x947f ?)
   (#x9481 ?)
   (#x9577 ?Ĺ)
   (#x9580 ?)
   (#x9582 ?)
   (#x9583 ?)
   (#x9587 ?)
   (#x9589 ?)
   (#x958a ?)
   (#x958b ?)
   (#x958f ?)
   (#x9591 ?)
   (#x9593 ?)
   (#x9594 ?)
   (#x9596 ?)
   (#x9598 ?)
   (#x9599 ?)
   (#x95a0 ?)
   (#x95a2 ?)
   (#x95a3 ?)
   (#x95a4 ?)
   (#x95a5 ?ȶ)
   (#x95a7 ?)
   (#x95a8 ?)
   (#x95ad ?)
   (#x95b2 ?)
   (#x95b9 ?)
   (#x95bb ?)
   (#x95bc ?)
   (#x95be ?)
   (#x95c3 ?)
   (#x95c7 ?)
   (#x95ca ?)
   (#x95cc ?)
   (#x95cd ?)
   (#x95d4 ?)
   (#x95d5 ?)
   (#x95d6 ?)
   (#x95d8 ?Ʈ)
   (#x95dc ?)
   (#x95e1 ?)
   (#x95e2 ?)
   (#x95e5 ?)
   (#x961c ?)
   (#x9621 ?)
   (#x9628 ?)
   (#x962a ?)
   (#x962e ?)
   (#x962f ?)
   (#x9632 ?)
   (#x963b ?)
   (#x963f ?)
   (#x9640 ?)
   (#x9642 ?)
   (#x9644 ?)
   (#x964b ?)
   (#x964c ?)
   (#x964d ?)
   (#x964f ?)
   (#x9650 ?)
   (#x965b ?)
   (#x965c ?)
   (#x965d ?)
   (#x965e ?)
   (#x965f ?)
   (#x9662 ?)
   (#x9663 ?)
   (#x9664 ?)
   (#x9665 ?)
   (#x9666 ?)
   (#x966a ?)
   (#x966c ?)
   (#x9670 ?)
   (#x9672 ?)
   (#x9673 ?)
   (#x9675 ?)
   (#x9676 ?ƫ)
   (#x9677 ?)
   (#x9678 ?Φ)
   (#x967a ?)
   (#x967d ?)
   (#x9685 ?)
   (#x9686 ?δ)
   (#x9688 ?)
   (#x968a ?)
   (#x968b ?)
   (#x968d ?)
   (#x968e ?)
   (#x968f ?)
   (#x9694 ?)
   (#x9695 ?)
   (#x9697 ?)
   (#x9698 ?)
   (#x9699 ?)
   (#x969b ?)
   (#x969c ?)
   (#x96a0 ?)
   (#x96a3 ?)
   (#x96a7 ?)
   (#x96a8 ?)
   (#x96aa ?)
   (#x96b0 ?)
   (#x96b1 ?)
   (#x96b2 ?)
   (#x96b4 ?)
   (#x96b6 ?)
   (#x96b7 ?)
   (#x96b8 ?)
   (#x96b9 ?)
   (#x96bb ?)
   (#x96bc ?Ȼ)
   (#x96c0 ?)
   (#x96c1 ?)
   (#x96c4 ?ͺ)
   (#x96c5 ?)
   (#x96c6 ?)
   (#x96c7 ?)
   (#x96c9 ?)
   (#x96cb ?)
   (#x96cc ?)
   (#x96cd ?)
   (#x96ce ?)
   (#x96d1 ?)
   (#x96d5 ?)
   (#x96d6 ?)
   (#x96d9 ?)
   (#x96db ?)
   (#x96dc ?)
   (#x96e2 ?Υ)
   (#x96e3 ?)
   (#x96e8 ?)
   (#x96ea ?)
   (#x96eb ?)
   (#x96f0 ?ʷ)
   (#x96f2 ?)
   (#x96f6 ?)
   (#x96f7 ?)
   (#x96f9 ?)
   (#x96fb ?)
   (#x9700 ?)
   (#x9704 ?)
   (#x9706 ?)
   (#x9707 ?)
   (#x9708 ?)
   (#x970a ?)
   (#x970d ?)
   (#x970e ?)
   (#x970f ?)
   (#x9711 ?)
   (#x9713 ?)
   (#x9716 ?)
   (#x9719 ?)
   (#x971c ?)
   (#x971e ?)
   (#x9724 ?)
   (#x9727 ?̸)
   (#x972a ?)
   (#x9730 ?)
   (#x9732 ?Ϫ)
   (#x9738 ?۱)
   (#x9739 ?)
   (#x973d ?)
   (#x973e ?)
   (#x9742 ?)
   (#x9744 ?)
   (#x9746 ?)
   (#x9748 ?)
   (#x9749 ?)
   (#x9752 ?)
   (#x9756 ?)
   (#x9759 ?)
   (#x975c ?)
   (#x975e ?)
   (#x9760 ?)
   (#x9761 ?)
   (#x9762 ?)
   (#x9764 ?)
   (#x9766 ?)
   (#x9768 ?)
   (#x9769 ?)
   (#x976b ?)
   (#x976d ?)
   (#x9771 ?)
   (#x9774 ?)
   (#x9779 ?)
   (#x977a ?)
   (#x977c ?)
   (#x9781 ?)
   (#x9784 ?)
   (#x9785 ?)
   (#x9786 ?)
   (#x978b ?)
   (#x978d ?)
   (#x978f ?)
   (#x9790 ?)
   (#x9798 ?)
   (#x979c ?)
   (#x97a0 ?)
   (#x97a3 ?)
   (#x97a6 ?)
   (#x97a8 ?)
   (#x97ab ?)
   (#x97ad ?)
   (#x97b3 ?)
   (#x97b4 ?)
   (#x97c3 ?)
   (#x97c6 ?)
   (#x97c8 ?)
   (#x97cb ?)
   (#x97d3 ?)
   (#x97dc ?)
   (#x97ed ?)
   (#x97ee ?ǣ)
   (#x97f2 ?)
   (#x97f3 ?)
   (#x97f5 ?)
   (#x97f6 ?)
   (#x97fb ?)
   (#x97ff ?)
   (#x9801 ?)
   (#x9802 ?ĺ)
   (#x9803 ?)
   (#x9805 ?)
   (#x9806 ?)
   (#x9808 ?)
   (#x980c ?)
   (#x980f ?)
   (#x9810 ?)
   (#x9811 ?)
   (#x9812 ?)
   (#x9813 ?)
   (#x9817 ?)
   (#x9818 ?)
   (#x981a ?)
   (#x9821 ?)
   (#x9824 ?)
   (#x982c ?)
   (#x982d ?Ƭ)
   (#x9834 ?)
   (#x9837 ?)
   (#x9838 ?)
   (#x983b ?)
   (#x983c ?)
   (#x983d ?)
   (#x9846 ?)
   (#x984b ?)
   (#x984c ?)
   (#x984d ?)
   (#x984e ?)
   (#x984f ?)
   (#x9854 ?)
   (#x9855 ?)
   (#x9858 ?)
   (#x985b ?ſ)
   (#x985e ?)
   (#x9867 ?)
   (#x986b ?)
   (#x986f ?)
   (#x9870 ?)
   (#x9871 ?)
   (#x9873 ?)
   (#x9874 ?)
   (#x98a8 ?)
   (#x98aa ?)
   (#x98af ?)
   (#x98b1 ?)
   (#x98b6 ?)
   (#x98c3 ?)
   (#x98c4 ?)
   (#x98c6 ?)
   (#x98db ?)
   (#x98dc ?)
   (#x98df ?)
   (#x98e2 ?)
   (#x98e9 ?)
   (#x98eb ?)
   (#x98ed ?Ҭ)
   (#x98ee ?ݻ)
   (#x98ef ?)
   (#x98f2 ?)
   (#x98f4 ?)
   (#x98fc ?)
   (#x98fd ?˰)
   (#x98fe ?)
   (#x9903 ?)
   (#x9905 ?)
   (#x9909 ?)
   (#x990a ?)
   (#x990c ?)
   (#x9910 ?)
   (#x9912 ?)
   (#x9913 ?)
   (#x9914 ?)
   (#x9918 ?)
   (#x991d ?)
   (#x991e ?)
   (#x9920 ?)
   (#x9921 ?)
   (#x9924 ?)
   (#x9928 ?)
   (#x992c ?)
   (#x992e ?)
   (#x993d ?)
   (#x993e ?)
   (#x9942 ?)
   (#x9945 ?)
   (#x9949 ?)
   (#x994b ?)
   (#x994c ?)
   (#x9950 ?)
   (#x9951 ?)
   (#x9952 ?)
   (#x9955 ?)
   (#x9957 ?)
   (#x9996 ?)
   (#x9997 ?)
   (#x9998 ?)
   (#x9999 ?)
   (#x99a5 ?)
   (#x99a8 ?)
   (#x99ac ?)
   (#x99ad ?)
   (#x99ae ?)
   (#x99b3 ?)
   (#x99b4 ?)
   (#x99bc ?)
   (#x99c1 ?)
   (#x99c4 ?)
   (#x99c5 ?)
   (#x99c6 ?)
   (#x99c8 ?)
   (#x99d0 ?)
   (#x99d1 ?)
   (#x99d2 ?)
   (#x99d5 ?)
   (#x99d8 ?)
   (#x99db ?)
   (#x99dd ?)
   (#x99df ?)
   (#x99e2 ?)
   (#x99ed ?)
   (#x99ee ?)
   (#x99f1 ?)
   (#x99f2 ?)
   (#x99f8 ?)
   (#x99fb ?)
   (#x99ff ?)
   (#x9a01 ?)
   (#x9a05 ?)
   (#x9a0e ?)
   (#x9a0f ?)
   (#x9a12 ?)
   (#x9a13 ?)
   (#x9a19 ?)
   (#x9a28 ?)
   (#x9a2b ?)
   (#x9a30 ?ƭ)
   (#x9a37 ?)
   (#x9a3e ?)
   (#x9a40 ?)
   (#x9a42 ?)
   (#x9a43 ?)
   (#x9a45 ?)
   (#x9a4d ?)
   (#x9a55 ?)
   (#x9a57 ?)
   (#x9a5a ?)
   (#x9a5b ?)
   (#x9a5f ?)
   (#x9a62 ?)
   (#x9a64 ?)
   (#x9a65 ?)
   (#x9a69 ?)
   (#x9a6a ?)
   (#x9a6b ?)
   (#x9aa8 ?)
   (#x9aad ?)
   (#x9ab0 ?)
   (#x9ab8 ?)
   (#x9abc ?)
   (#x9ac0 ?)
   (#x9ac4 ?)
   (#x9acf ?)
   (#x9ad1 ?)
   (#x9ad3 ?)
   (#x9ad4 ?)
   (#x9ad8 ?)
   (#x9ade ?)
   (#x9adf ?)
   (#x9ae2 ?)
   (#x9ae3 ?)
   (#x9ae6 ?)
   (#x9aea ?ȱ)
   (#x9aeb ?)
   (#x9aed ?ɦ)
   (#x9aee ?)
   (#x9aef ?)
   (#x9af1 ?)
   (#x9af4 ?)
   (#x9af7 ?)
   (#x9afb ?)
   (#x9b06 ?)
   (#x9b18 ?)
   (#x9b1a ?)
   (#x9b1f ?)
   (#x9b22 ?)
   (#x9b23 ?)
   (#x9b25 ?)
   (#x9b27 ?)
   (#x9b28 ?)
   (#x9b29 ?)
   (#x9b2a ?)
   (#x9b2e ?)
   (#x9b2f ?)
   (#x9b31 ?ݵ)
   (#x9b32 ?)
   (#x9b3b ?)
   (#x9b3c ?)
   (#x9b41 ?)
   (#x9b42 ?)
   (#x9b43 ?)
   (#x9b44 ?)
   (#x9b45 ?̥)
   (#x9b4d ?)
   (#x9b4e ?)
   (#x9b4f ?)
   (#x9b51 ?)
   (#x9b54 ?)
   (#x9b58 ?)
   (#x9b5a ?)
   (#x9b6f ?ϥ)
   (#x9b74 ?)
   (#x9b83 ?)
   (#x9b8e ?)
   (#x9b91 ?)
   (#x9b92 ?ʫ)
   (#x9b93 ?)
   (#x9b96 ?)
   (#x9b97 ?)
   (#x9b9f ?)
   (#x9ba0 ?)
   (#x9ba8 ?)
   (#x9baa ?)
   (#x9bab ?)
   (#x9bad ?)
   (#x9bae ?)
   (#x9bb4 ?)
   (#x9bb9 ?)
   (#x9bc0 ?)
   (#x9bc6 ?)
   (#x9bc9 ?)
   (#x9bca ?)
   (#x9bcf ?)
   (#x9bd1 ?)
   (#x9bd2 ?)
   (#x9bd4 ?)
   (#x9bd6 ?)
   (#x9bdb ?)
   (#x9be1 ?)
   (#x9be2 ?)
   (#x9be3 ?)
   (#x9be4 ?)
   (#x9be8 ?)
   (#x9bf0 ?)
   (#x9bf1 ?)
   (#x9bf2 ?)
   (#x9bf5 ?)
   (#x9c04 ?)
   (#x9c06 ?)
   (#x9c08 ?)
   (#x9c09 ?)
   (#x9c0a ?)
   (#x9c0c ?)
   (#x9c0d ?)
   (#x9c10 ?)
   (#x9c12 ?)
   (#x9c13 ?)
   (#x9c14 ?)
   (#x9c15 ?)
   (#x9c1b ?)
   (#x9c21 ?)
   (#x9c24 ?)
   (#x9c25 ?)
   (#x9c2d ?)
   (#x9c2e ?)
   (#x9c2f ?)
   (#x9c30 ?)
   (#x9c32 ?)
   (#x9c39 ?)
   (#x9c3a ?)
   (#x9c3b ?)
   (#x9c3e ?)
   (#x9c46 ?)
   (#x9c47 ?)
   (#x9c48 ?í)
   (#x9c52 ?)
   (#x9c57 ?)
   (#x9c5a ?)
   (#x9c60 ?)
   (#x9c67 ?)
   (#x9c76 ?)
   (#x9c78 ?)
   (#x9ce5 ?Ļ)
   (#x9ce7 ?)
   (#x9ce9 ?ȷ)
   (#x9ceb ?)
   (#x9cec ?)
   (#x9cf0 ?)
   (#x9cf3 ?˱)
   (#x9cf4 ?)
   (#x9cf6 ?)
   (#x9d03 ?)
   (#x9d06 ?)
   (#x9d07 ?ƾ)
   (#x9d08 ?)
   (#x9d09 ?)
   (#x9d0e ?)
   (#x9d12 ?)
   (#x9d15 ?)
   (#x9d1b ?)
   (#x9d1f ?)
   (#x9d23 ?)
   (#x9d26 ?)
   (#x9d28 ?)
   (#x9d2a ?)
   (#x9d2b ?)
   (#x9d2c ?)
   (#x9d3b ?)
   (#x9d3e ?)
   (#x9d3f ?)
   (#x9d41 ?)
   (#x9d44 ?)
   (#x9d46 ?)
   (#x9d48 ?)
   (#x9d50 ?)
   (#x9d51 ?)
   (#x9d59 ?)
   (#x9d5c ?)
   (#x9d5d ?)
   (#x9d5e ?)
   (#x9d60 ?)
   (#x9d61 ?̹)
   (#x9d64 ?)
   (#x9d6c ?˲)
   (#x9d6f ?)
   (#x9d72 ?)
   (#x9d7a ?)
   (#x9d87 ?)
   (#x9d89 ?)
   (#x9d8f ?)
   (#x9d9a ?)
   (#x9da4 ?)
   (#x9da9 ?)
   (#x9dab ?)
   (#x9daf ?)
   (#x9db2 ?)
   (#x9db4 ?)
   (#x9db8 ?)
   (#x9dba ?)
   (#x9dbb ?)
   (#x9dc1 ?)
   (#x9dc2 ?)
   (#x9dc4 ?)
   (#x9dc6 ?)
   (#x9dcf ?)
   (#x9dd3 ?)
   (#x9dd9 ?)
   (#x9de6 ?)
   (#x9ded ?)
   (#x9def ?)
   (#x9df2 ?)
   (#x9df8 ?)
   (#x9df9 ?)
   (#x9dfa ?)
   (#x9dfd ?)
   (#x9e1a ?)
   (#x9e1b ?)
   (#x9e1e ?)
   (#x9e75 ?)
   (#x9e78 ?)
   (#x9e79 ?)
   (#x9e7d ?)
   (#x9e7f ?)
   (#x9e81 ?)
   (#x9e88 ?)
   (#x9e8b ?)
   (#x9e8c ?)
   (#x9e91 ?)
   (#x9e92 ?)
   (#x9e93 ?ϼ)
   (#x9e95 ?)
   (#x9e97 ?)
   (#x9e9d ?)
   (#x9e9f ?)
   (#x9ea5 ?)
   (#x9ea6 ?)
   (#x9ea9 ?)
   (#x9eaa ?)
   (#x9ead ?)
   (#x9eb8 ?)
   (#x9eb9 ?)
   (#x9eba ?)
   (#x9ebb ?)
   (#x9ebc ?)
   (#x9ebe ?)
   (#x9ebf ?)
   (#x9ec4 ?)
   (#x9ecc ?)
   (#x9ecd ?)
   (#x9ece ?)
   (#x9ecf ?)
   (#x9ed0 ?)
   (#x9ed2 ?)
   (#x9ed4 ?)
   (#x9ed8 ?)
   (#x9ed9 ?)
   (#x9edb ?)
   (#x9edc ?)
   (#x9edd ?)
   (#x9ede ?)
   (#x9ee0 ?)
   (#x9ee5 ?)
   (#x9ee8 ?)
   (#x9eef ?)
   (#x9ef4 ?)
   (#x9ef6 ?)
   (#x9ef7 ?)
   (#x9ef9 ?)
   (#x9efb ?)
   (#x9efc ?)
   (#x9efd ?)
   (#x9f07 ?)
   (#x9f08 ?)
   (#x9f0e ?Ť)
   (#x9f13 ?)
   (#x9f15 ?)
   (#x9f20 ?)
   (#x9f21 ?)
   (#x9f2c ?)
   (#x9f3b ?ɡ)
   (#x9f3e ?)
   (#x9f4a ?)
   (#x9f4b ?)
   (#x9f4e ?)
   (#x9f4f ?)
   (#x9f52 ?)
   (#x9f54 ?)
   (#x9f5f ?)
   (#x9f60 ?)
   (#x9f61 ?)
   (#x9f62 ?)
   (#x9f63 ?)
   (#x9f66 ?)
   (#x9f67 ?)
   (#x9f6a ?)
   (#x9f6c ?)
   (#x9f72 ?)
   (#x9f76 ?)
   (#x9f77 ?)
   (#x9f8d ?ζ)
   (#x9f95 ?)
   (#x9f9c ?)
   (#x9f9d ?)
   (#x9fa0 ?)
   (#xff01 ?)
   (#xff03 ?)
   (#xff04 ?)
   (#xff05 ?)
   (#xff06 ?)
   (#xff08 ?\)
   (#xff09 ?\)
   (#xff0a ?)
   (#xff0b ?)
   (#xff0c ?)
   (#xff0e ?)
   (#xff0f ?)
   (#xff10 ?)
   (#xff11 ?)
   (#xff12 ?)
   (#xff13 ?)
   (#xff14 ?)
   (#xff15 ?)
   (#xff16 ?)
   (#xff17 ?)
   (#xff18 ?)
   (#xff19 ?)
   (#xff1a ?)
   (#xff1b ?)
   (#xff1c ?)
   (#xff1d ?)
   (#xff1e ?)
   (#xff1f ?)
   (#xff20 ?)
   (#xff21 ?)
   (#xff22 ?)
   (#xff23 ?)
   (#xff24 ?)
   (#xff25 ?)
   (#xff26 ?)
   (#xff27 ?)
   (#xff28 ?)
   (#xff29 ?)
   (#xff2a ?)
   (#xff2b ?)
   (#xff2c ?)
   (#xff2d ?)
   (#xff2e ?)
   (#xff2f ?)
   (#xff30 ?)
   (#xff31 ?)
   (#xff32 ?)
   (#xff33 ?)
   (#xff34 ?)
   (#xff35 ?)
   (#xff36 ?)
   (#xff37 ?)
   (#xff38 ?)
   (#xff39 ?)
   (#xff3a ?)
   (#xff3b ?\)
   (#xff3c ?)
   (#xff3d ?\)
   (#xff3e ?)
   (#xff3f ?)
   (#xff40 ?)
   (#xff41 ?)
   (#xff42 ?)
   (#xff43 ?)
   (#xff44 ?)
   (#xff45 ?)
   (#xff46 ?)
   (#xff47 ?)
   (#xff48 ?)
   (#xff49 ?)
   (#xff4a ?)
   (#xff4b ?)
   (#xff4c ?)
   (#xff4d ?)
   (#xff4e ?)
   (#xff4f ?)
   (#xff50 ?)
   (#xff51 ?)
   (#xff52 ?)
   (#xff53 ?)
   (#xff54 ?)
   (#xff55 ?)
   (#xff56 ?)
   (#xff57 ?)
   (#xff58 ?)
   (#xff59 ?)
   (#xff5a ?)
   (#xff5b ?\)
   (#xff5c ?)
   (#xff5d ?\)
   (#xffe3 ?)
   (#xffe5 ?)

   ;; jisx0212

   (#xa1 ?)
   (#xa4 ?)
   (#xa6 ?)
   (#xa9 ?)
   (#xaa ?)
   (#xae ?)
   (#xaf ?)
   (#xb8 ?)
   (#xba ?)
   (#xbf ?)
   (#xc0 ?)
   (#xc1 ?)
   (#xc2 ?)
   (#xc3 ?)
   (#xc4 ?)
   (#xc5 ?)
   (#xc6 ?)
   (#xc7 ?)
   (#xc8 ?)
   (#xc9 ?)
   (#xca ?)
   (#xcb ?)
   (#xcc ?)
   (#xcd ?)
   (#xce ?)
   (#xcf ?)
   (#xd1 ?)
   (#xd2 ?)
   (#xd3 ?)
   (#xd4 ?)
   (#xd5 ?)
   (#xd6 ?)
   (#xd8 ?)
   (#xd9 ?)
   (#xda ?)
   (#xdb ?)
   (#xdc ?)
   (#xdd ?)
   (#xde ?)
   (#xdf ?)
   (#xe0 ?)
   (#xe1 ?)
   (#xe2 ?)
   (#xe3 ?)
   (#xe4 ?)
   (#xe5 ?)
   (#xe6 ?)
   (#xe7 ?)
   (#xe8 ?)
   (#xe9 ?)
   (#xea ?)
   (#xeb ?)
   (#xec ?)
   (#xed ?)
   (#xee ?)
   (#xef ?)
   (#xf0 ?)
   (#xf1 ?)
   (#xf2 ?)
   (#xf3 ?)
   (#xf4 ?)
   (#xf5 ?)
   (#xf6 ?)
   (#xf8 ?)
   (#xf9 ?)
   (#xfa ?)
   (#xfb ?)
   (#xfc ?)
   (#xfd ?)
   (#xfe ?)
   (#xff ?)
   (#x100 ?)
   (#x101 ?)
   (#x102 ?)
   (#x103 ?)
   (#x104 ?)
   (#x105 ?)
   (#x106 ?)
   (#x107 ?)
   (#x108 ?)
   (#x109 ?)
   (#x10a ?)
   (#x10b ?)
   (#x10c ?)
   (#x10d ?)
   (#x10e ?)
   (#x10f ?)
   (#x110 ?)
   (#x111 ?)
   (#x112 ?)
   (#x113 ?)
   (#x116 ?)
   (#x117 ?)
   (#x118 ?)
   (#x119 ?)
   (#x11a ?)
   (#x11b ?)
   (#x11c ?)
   (#x11d ?)
   (#x11e ?)
   (#x11f ?)
   (#x120 ?)
   (#x121 ?)
   (#x122 ?)
   (#x124 ?)
   (#x125 ?)
   (#x126 ?)
   (#x127 ?)
   (#x128 ?)
   (#x129 ?)
   (#x12a ?)
   (#x12b ?)
   (#x12e ?)
   (#x12f ?)
   (#x130 ?)
   (#x131 ?)
   (#x132 ?)
   (#x133 ?)
   (#x134 ?)
   (#x135 ?)
   (#x136 ?)
   (#x137 ?)
   (#x138 ?)
   (#x139 ?)
   (#x13a ?)
   (#x13b ?)
   (#x13c ?)
   (#x13d ?)
   (#x13e ?)
   (#x13f ?)
   (#x140 ?)
   (#x141 ?)
   (#x142 ?)
   (#x143 ?)
   (#x144 ?)
   (#x145 ?)
   (#x146 ?)
   (#x147 ?)
   (#x148 ?)
   (#x149 ?)
   (#x14a ?)
   (#x14b ?)
   (#x14c ?)
   (#x14d ?)
   (#x150 ?)
   (#x151 ?)
   (#x152 ?)
   (#x153 ?)
   (#x154 ?)
   (#x155 ?)
   (#x156 ?)
   (#x157 ?)
   (#x158 ?)
   (#x159 ?)
   (#x15a ?)
   (#x15b ?)
   (#x15c ?)
   (#x15d ?)
   (#x15e ?)
   (#x15f ?)
   (#x160 ?)
   (#x161 ?)
   (#x162 ?)
   (#x163 ?)
   (#x164 ?)
   (#x165 ?)
   (#x166 ?)
   (#x167 ?)
   (#x168 ?)
   (#x169 ?)
   (#x16a ?)
   (#x16b ?)
   (#x16c ?)
   (#x16d ?)
   (#x16e ?)
   (#x16f ?)
   (#x170 ?)
   (#x171 ?)
   (#x172 ?)
   (#x173 ?)
   (#x174 ?)
   (#x175 ?)
   (#x176 ?)
   (#x177 ?)
   (#x178 ?)
   (#x179 ?)
   (#x17a ?)
   (#x17b ?)
   (#x17c ?)
   (#x17d ?)
   (#x17e ?)
   (#x1cd ?)
   (#x1ce ?)
   (#x1cf ?)
   (#x1d0 ?)
   (#x1d1 ?)
   (#x1d2 ?)
   (#x1d3 ?)
   (#x1d4 ?)
   (#x1d5 ?)
   (#x1d6 ?)
   (#x1d7 ?)
   (#x1d8 ?)
   (#x1d9 ?)
   (#x1da ?)
   (#x1db ?)
   (#x1dc ?)
   (#x1f5 ?)
   (#x2c7 ?)
   (#x2d8 ?)
   (#x2d9 ?)
   (#x2da ?)
   (#x2db ?)
   (#x2dd ?)
   (#x384 ?)
   (#x385 ?)
   (#x386 ?)
   (#x388 ?)
   (#x389 ?)
   (#x38a ?)
   (#x38c ?)
   (#x38e ?)
   (#x38f ?)
   (#x390 ?)
   (#x3aa ?)
   (#x3ab ?)
   (#x3ac ?)
   (#x3ad ?)
   (#x3ae ?)
   (#x3af ?)
   (#x3b0 ?)
   (#x3c2 ?)
   (#x3ca ?)
   (#x3cb ?)
   (#x3cc ?)
   (#x3cd ?)
   (#x3ce ?)
   (#x402 ?)
   (#x403 ?)
   (#x404 ?)
   (#x405 ?)
   (#x406 ?)
   (#x407 ?)
   (#x408 ?)
   (#x409 ?)
   (#x40a ?)
   (#x40b ?)
   (#x40c ?)
   (#x40e ?)
   (#x40f ?)
   (#x452 ?)
   (#x453 ?)
   (#x454 ?)
   (#x455 ?)
   (#x456 ?)
   (#x457 ?)
   (#x458 ?)
   (#x459 ?)
   (#x45a ?)
   (#x45b ?)
   (#x45c ?)
   (#x45e ?)
   (#x45f ?)
   (#x2116 ?)
   (#x2122 ?)
   (#x4e02 ?)
   (#x4e04 ?)
   (#x4e05 ?)
   (#x4e0c ?)
   (#x4e12 ?)
   (#x4e1f ?)
   (#x4e23 ?)
   (#x4e24 ?)
   (#x4e28 ?)
   (#x4e2b ?)
   (#x4e2e ?)
   (#x4e2f ?)
   (#x4e30 ?)
   (#x4e35 ?)
   (#x4e40 ?)
   (#x4e41 ?)
   (#x4e44 ?)
   (#x4e47 ?)
   (#x4e51 ?)
   (#x4e5a ?)
   (#x4e5c ?)
   (#x4e63 ?)
   (#x4e68 ?)
   (#x4e69 ?)
   (#x4e74 ?)
   (#x4e75 ?)
   (#x4e79 ?)
   (#x4e7f ?)
   (#x4e8d ?)
   (#x4e96 ?)
   (#x4e97 ?)
   (#x4e9d ?)
   (#x4eaf ?)
   (#x4eb9 ?)
   (#x4ec3 ?)
   (#x4ed0 ?)
   (#x4eda ?)
   (#x4edb ?)
   (#x4ee0 ?)
   (#x4ee1 ?)
   (#x4ee2 ?)
   (#x4ee8 ?)
   (#x4eef ?)
   (#x4ef1 ?)
   (#x4ef3 ?)
   (#x4ef5 ?)
   (#x4efd ?)
   (#x4efe ?)
   (#x4eff ?)
   (#x4f00 ?)
   (#x4f02 ?)
   (#x4f03 ?)
   (#x4f08 ?)
   (#x4f0b ?)
   (#x4f0c ?)
   (#x4f12 ?)
   (#x4f15 ?)
   (#x4f16 ?)
   (#x4f17 ?)
   (#x4f19 ?)
   (#x4f2e ?)
   (#x4f31 ?)
   (#x4f33 ?)
   (#x4f35 ?)
   (#x4f37 ?)
   (#x4f39 ?)
   (#x4f3b ?)
   (#x4f3e ?)
   (#x4f40 ?)
   (#x4f42 ?)
   (#x4f48 ?)
   (#x4f49 ?)
   (#x4f4b ?)
   (#x4f4c ?)
   (#x4f52 ?)
   (#x4f54 ?)
   (#x4f56 ?)
   (#x4f58 ?)
   (#x4f5f ?)
   (#x4f60 ?)
   (#x4f63 ?)
   (#x4f6a ?)
   (#x4f6c ?)
   (#x4f6e ?)
   (#x4f71 ?)
   (#x4f77 ?)
   (#x4f78 ?)
   (#x4f79 ?)
   (#x4f7a ?)
   (#x4f7d ?)
   (#x4f7e ?)
   (#x4f81 ?)
   (#x4f82 ?)
   (#x4f84 ?)
   (#x4f85 ?)
   (#x4f89 ?)
   (#x4f8a ?)
   (#x4f8c ?)
   (#x4f8e ?)
   (#x4f90 ?)
   (#x4f92 ?)
   (#x4f93 ?)
   (#x4f94 ?)
   (#x4f97 ?)
   (#x4f99 ?)
   (#x4f9a ?)
   (#x4f9e ?)
   (#x4f9f ?)
   (#x4fb2 ?)
   (#x4fb7 ?)
   (#x4fb9 ?)
   (#x4fbb ?)
   (#x4fbc ?)
   (#x4fbd ?)
   (#x4fbe ?)
   (#x4fc0 ?)
   (#x4fc1 ?)
   (#x4fc5 ?)
   (#x4fc6 ?)
   (#x4fc8 ?)
   (#x4fc9 ?)
   (#x4fcb ?)
   (#x4fcc ?)
   (#x4fcd ?)
   (#x4fcf ?)
   (#x4fd2 ?)
   (#x4fdc ?)
   (#x4fe0 ?)
   (#x4fe2 ?)
   (#x4ff0 ?)
   (#x4ff2 ?)
   (#x4ffc ?)
   (#x4ffd ?)
   (#x4fff ?)
   (#x5000 ?)
   (#x5001 ?)
   (#x5004 ?)
   (#x5007 ?)
   (#x500a ?)
   (#x500c ?)
   (#x500e ?)
   (#x5010 ?)
   (#x5013 ?)
   (#x5017 ?)
   (#x5018 ?)
   (#x501b ?)
   (#x501c ?)
   (#x501d ?)
   (#x501e ?)
   (#x5022 ?)
   (#x5027 ?)
   (#x502e ?)
   (#x5030 ?)
   (#x5032 ?)
   (#x5033 ?)
   (#x5035 ?)
   (#x503b ?)
   (#x5040 ?)
   (#x5041 ?)
   (#x5042 ?)
   (#x5045 ?)
   (#x5046 ?)
   (#x504a ?)
   (#x504c ?)
   (#x504e ?)
   (#x5051 ?)
   (#x5052 ?)
   (#x5053 ?)
   (#x5057 ?)
   (#x5059 ?)
   (#x505f ?)
   (#x5060 ?)
   (#x5062 ?)
   (#x5063 ?)
   (#x5066 ?)
   (#x5067 ?)
   (#x506a ?)
   (#x506d ?)
   (#x5070 ?)
   (#x5071 ?)
   (#x5081 ?)
   (#x5083 ?)
   (#x5084 ?)
   (#x5086 ?)
   (#x508a ?)
   (#x508e ?)
   (#x508f ?)
   (#x5090 ?)
   (#x5092 ?)
   (#x5093 ?)
   (#x5094 ?)
   (#x5096 ?)
   (#x509b ?)
   (#x509c ?)
   (#x509e ?)
   (#x509f ?)
   (#x50a0 ?)
   (#x50a1 ?)
   (#x50a2 ?)
   (#x50aa ?)
   (#x50af ?)
   (#x50b0 ?)
   (#x50b9 ?)
   (#x50ba ?)
   (#x50bd ?)
   (#x50c0 ?)
   (#x50c3 ?)
   (#x50c4 ?)
   (#x50c7 ?)
   (#x50cc ?)
   (#x50ce ?)
   (#x50d0 ?)
   (#x50d3 ?)
   (#x50d4 ?)
   (#x50d8 ?)
   (#x50dc ?)
   (#x50dd ?)
   (#x50df ?)
   (#x50e2 ?)
   (#x50e4 ?)
   (#x50e6 ?)
   (#x50e8 ?)
   (#x50e9 ?)
   (#x50ef ?)
   (#x50f1 ?)
   (#x50f2 ?)
   (#x50f6 ?)
   (#x50fa ?)
   (#x50fe ?)
   (#x5103 ?)
   (#x5106 ?)
   (#x5107 ?)
   (#x5108 ?)
   (#x510b ?)
   (#x510c ?)
   (#x510d ?)
   (#x510e ?)
   (#x5110 ?)
   (#x5117 ?)
   (#x5119 ?)
   (#x511b ?)
   (#x511c ?)
   (#x511d ?)
   (#x511e ?)
   (#x5123 ?)
   (#x5127 ?)
   (#x5128 ?)
   (#x512c ?)
   (#x512d ?)
   (#x512f ?)
   (#x5131 ?)
   (#x5133 ?)
   (#x5134 ?)
   (#x5135 ?)
   (#x5138 ?)
   (#x5139 ?)
   (#x5142 ?)
   (#x514a ?)
   (#x514f ?)
   (#x5153 ?)
   (#x5155 ?)
   (#x5157 ?)
   (#x5158 ?)
   (#x515f ?)
   (#x5164 ?)
   (#x5166 ?)
   (#x517e ?)
   (#x5183 ?)
   (#x5184 ?)
   (#x518b ?)
   (#x518e ?)
   (#x5198 ?)
   (#x519d ?)
   (#x51a1 ?)
   (#x51a3 ?)
   (#x51ad ?)
   (#x51b8 ?)
   (#x51ba ?)
   (#x51bc ?)
   (#x51be ?)
   (#x51bf ?)
   (#x51c2 ?)
   (#x51c8 ?)
   (#x51cf ?)
   (#x51d1 ?)
   (#x51d2 ?)
   (#x51d3 ?)
   (#x51d5 ?)
   (#x51d8 ?)
   (#x51de ?)
   (#x51e2 ?)
   (#x51e5 ?)
   (#x51ee ?)
   (#x51f2 ?)
   (#x51f3 ?)
   (#x51f4 ?)
   (#x51f7 ?)
   (#x5201 ?)
   (#x5202 ?)
   (#x5205 ?)
   (#x5212 ?)
   (#x5213 ?)
   (#x5215 ?)
   (#x5216 ?)
   (#x5218 ?)
   (#x5222 ?)
   (#x5228 ?)
   (#x5231 ?)
   (#x5232 ?)
   (#x5235 ?)
   (#x523c ?)
   (#x5245 ?)
   (#x5249 ?)
   (#x5255 ?)
   (#x5257 ?)
   (#x5258 ?)
   (#x525a ?)
   (#x525c ?)
   (#x525f ?)
   (#x5260 ?)
   (#x5261 ?)
   (#x5266 ?)
   (#x526e ?)
   (#x5277 ?)
   (#x5278 ?)
   (#x5279 ?)
   (#x5280 ?)
   (#x5282 ?)
   (#x5285 ?)
   (#x528a ?)
   (#x528c ?)
   (#x5293 ?)
   (#x5295 ?)
   (#x5296 ?)
   (#x5297 ?)
   (#x5298 ?)
   (#x529a ?)
   (#x529c ?)
   (#x52a4 ?)
   (#x52a5 ?)
   (#x52a6 ?)
   (#x52a7 ?)
   (#x52af ?)
   (#x52b0 ?)
   (#x52b6 ?)
   (#x52b7 ?)
   (#x52b8 ?)
   (#x52ba ?)
   (#x52bb ?)
   (#x52bd ?)
   (#x52c0 ?)
   (#x52c4 ?)
   (#x52c6 ?)
   (#x52c8 ?)
   (#x52cc ?)
   (#x52cf ?)
   (#x52d1 ?)
   (#x52d4 ?)
   (#x52d6 ?)
   (#x52db ?)
   (#x52dc ?)
   (#x52e1 ?)
   (#x52e5 ?)
   (#x52e8 ?)
   (#x52e9 ?)
   (#x52ea ?)
   (#x52ec ?)
   (#x52f0 ?)
   (#x52f1 ?)
   (#x52f4 ?)
   (#x52f6 ?)
   (#x52f7 ?)
   (#x5300 ?)
   (#x5303 ?)
   (#x530a ?)
   (#x530b ?)
   (#x530c ?)
   (#x5311 ?)
   (#x5313 ?)
   (#x5318 ?)
   (#x531b ?)
   (#x531c ?)
   (#x531e ?)
   (#x531f ?)
   (#x5325 ?)
   (#x5327 ?)
   (#x5328 ?)
   (#x5329 ?)
   (#x532b ?)
   (#x532c ?)
   (#x532d ?)
   (#x5330 ?)
   (#x5332 ?)
   (#x5335 ?)
   (#x533c ?)
   (#x533d ?)
   (#x533e ?)
   (#x5342 ?)
   (#x534b ?)
   (#x534c ?)
   (#x5359 ?)
   (#x535b ?)
   (#x5361 ?)
   (#x5363 ?)
   (#x5365 ?)
   (#x536c ?)
   (#x536d ?)
   (#x5372 ?)
   (#x5379 ?)
   (#x537e ?)
   (#x5383 ?)
   (#x5387 ?)
   (#x5388 ?)
   (#x538e ?)
   (#x5393 ?)
   (#x5394 ?)
   (#x5399 ?)
   (#x539d ?)
   (#x53a1 ?)
   (#x53a4 ?)
   (#x53aa ?)
   (#x53ab ?)
   (#x53af ?)
   (#x53b2 ?)
   (#x53b4 ?)
   (#x53b5 ?)
   (#x53b7 ?)
   (#x53b8 ?)
   (#x53ba ?)
   (#x53bd ?)
   (#x53c0 ?)
   (#x53c5 ?)
   (#x53cf ?)
   (#x53d2 ?)
   (#x53d3 ?)
   (#x53d5 ?)
   (#x53da ?)
   (#x53dd ?)
   (#x53de ?)
   (#x53e0 ?)
   (#x53e6 ?)
   (#x53e7 ?)
   (#x53f5 ?)
   (#x5402 ?)
   (#x5413 ?)
   (#x541a ?)
   (#x5421 ?)
   (#x5427 ?)
   (#x5428 ?)
   (#x542a ?)
   (#x542f ?)
   (#x5431 ?)
   (#x5434 ?)
   (#x5435 ?)
   (#x5443 ?)
   (#x5444 ?)
   (#x5447 ?)
   (#x544d ?)
   (#x544f ?)
   (#x545e ?)
   (#x5462 ?)
   (#x5464 ?)
   (#x5466 ?)
   (#x5467 ?)
   (#x5469 ?)
   (#x546b ?)
   (#x546d ?)
   (#x546e ?)
   (#x5474 ?)
   (#x547f ?)
   (#x5481 ?)
   (#x5483 ?)
   (#x5485 ?)
   (#x5488 ?)
   (#x5489 ?)
   (#x548d ?)
   (#x5491 ?)
   (#x5495 ?)
   (#x5496 ?)
   (#x549c ?)
   (#x549f ?)
   (#x54a1 ?)
   (#x54a6 ?)
   (#x54a7 ?)
   (#x54a9 ?)
   (#x54aa ?)
   (#x54ad ?)
   (#x54ae ?)
   (#x54b1 ?)
   (#x54b7 ?)
   (#x54b9 ?)
   (#x54ba ?)
   (#x54bb ?)
   (#x54bf ?)
   (#x54c6 ?)
   (#x54ca ?)
   (#x54cd ?)
   (#x54ce ?)
   (#x54e0 ?)
   (#x54ea ?)
   (#x54ec ?)
   (#x54ef ?)
   (#x54f6 ?)
   (#x54fc ?)
   (#x54fe ?)
   (#x54ff ?)
   (#x5500 ?)
   (#x5501 ?)
   (#x5505 ?)
   (#x5508 ?)
   (#x5509 ?)
   (#x550c ?)
   (#x550d ?)
   (#x550e ?)
   (#x5515 ?)
   (#x552a ?)
   (#x552b ?)
   (#x5532 ?)
   (#x5535 ?)
   (#x5536 ?)
   (#x553b ?)
   (#x553c ?)
   (#x553d ?)
   (#x5541 ?)
   (#x5547 ?)
   (#x5549 ?)
   (#x554a ?)
   (#x554d ?)
   (#x5550 ?)
   (#x5551 ?)
   (#x5558 ?)
   (#x555a ?)
   (#x555b ?)
   (#x555e ?)
   (#x5560 ?)
   (#x5561 ?)
   (#x5564 ?)
   (#x5566 ?)
   (#x557f ?)
   (#x5581 ?)
   (#x5582 ?)
   (#x5586 ?)
   (#x5588 ?)
   (#x558e ?)
   (#x558f ?)
   (#x5591 ?)
   (#x5592 ?)
   (#x5593 ?)
   (#x5594 ?)
   (#x5597 ?)
   (#x55a3 ?)
   (#x55a4 ?)
   (#x55ad ?)
   (#x55b2 ?)
   (#x55bf ?)
   (#x55c1 ?)
   (#x55c3 ?)
   (#x55c6 ?)
   (#x55c9 ?)
   (#x55cb ?)
   (#x55cc ?)
   (#x55ce ?)
   (#x55d1 ?)
   (#x55d2 ?)
   (#x55d3 ?)
   (#x55d7 ?)
   (#x55d8 ?)
   (#x55db ?)
   (#x55de ?)
   (#x55e2 ?)
   (#x55e9 ?)
   (#x55f6 ?)
   (#x55ff ?)
   (#x5605 ?)
   (#x5608 ?)
   (#x560a ?)
   (#x560d ?)
   (#x560e ?)
   (#x560f ?)
   (#x5610 ?)
   (#x5611 ?)
   (#x5612 ?)
   (#x5619 ?)
   (#x562c ?)
   (#x5630 ?)
   (#x5633 ?)
   (#x5635 ?)
   (#x5637 ?)
   (#x5639 ?)
   (#x563b ?)
   (#x563c ?)
   (#x563d ?)
   (#x563f ?)
   (#x5640 ?)
   (#x5641 ?)
   (#x5643 ?)
   (#x5644 ?)
   (#x5646 ?)
   (#x5649 ?)
   (#x564b ?)
   (#x564d ?)
   (#x564f ?)
   (#x5654 ?)
   (#x565e ?)
   (#x5660 ?)
   (#x5661 ?)
   (#x5662 ?)
   (#x5663 ?)
   (#x5666 ?)
   (#x5669 ?)
   (#x566d ?)
   (#x566f ?)
   (#x5671 ?)
   (#x5672 ?)
   (#x5675 ?)
   (#x5684 ?)
   (#x5685 ?)
   (#x5688 ?)
   (#x568b ?)
   (#x568c ?)
   (#x5695 ?)
   (#x5699 ?)
   (#x569a ?)
   (#x569d ?)
   (#x569e ?)
   (#x569f ?)
   (#x56a6 ?)
   (#x56a7 ?)
   (#x56a8 ?)
   (#x56a9 ?)
   (#x56ab ?)
   (#x56ac ?)
   (#x56ad ?)
   (#x56b1 ?)
   (#x56b3 ?)
   (#x56b7 ?)
   (#x56be ?)
   (#x56c5 ?)
   (#x56c9 ?)
   (#x56ca ?)
   (#x56cb ?)
   (#x56cc ?)
   (#x56cd ?)
   (#x56cf ?)
   (#x56d0 ?)
   (#x56d9 ?)
   (#x56dc ?)
   (#x56dd ?)
   (#x56df ?)
   (#x56e1 ?)
   (#x56e4 ?)
   (#x56e5 ?)
   (#x56e6 ?)
   (#x56e7 ?)
   (#x56e8 ?)
   (#x56eb ?)
   (#x56ed ?)
   (#x56f1 ?)
   (#x56f6 ?)
   (#x56f7 ?)
   (#x5701 ?)
   (#x5702 ?)
   (#x5707 ?)
   (#x570a ?)
   (#x570c ?)
   (#x5711 ?)
   (#x5715 ?)
   (#x571a ?)
   (#x571b ?)
   (#x571d ?)
   (#x5720 ?)
   (#x5722 ?)
   (#x5723 ?)
   (#x5724 ?)
   (#x5725 ?)
   (#x5729 ?)
   (#x572a ?)
   (#x572c ?)
   (#x572e ?)
   (#x572f ?)
   (#x5733 ?)
   (#x5734 ?)
   (#x573d ?)
   (#x573e ?)
   (#x573f ?)
   (#x5745 ?)
   (#x5746 ?)
   (#x574c ?)
   (#x574d ?)
   (#x5752 ?)
   (#x5762 ?)
   (#x5765 ?)
   (#x5767 ?)
   (#x5768 ?)
   (#x576b ?)
   (#x576d ?)
   (#x576e ?)
   (#x576f ?)
   (#x5770 ?)
   (#x5771 ?)
   (#x5773 ?)
   (#x5774 ?)
   (#x5775 ?)
   (#x5777 ?)
   (#x5779 ?)
   (#x577a ?)
   (#x577b ?)
   (#x577c ?)
   (#x577e ?)
   (#x5781 ?)
   (#x5783 ?)
   (#x578c ?)
   (#x5794 ?)
   (#x5795 ?)
   (#x5797 ?)
   (#x5799 ?)
   (#x579a ?)
   (#x579c ?)
   (#x579d ?)
   (#x579e ?)
   (#x579f ?)
   (#x57a1 ?)
   (#x57a7 ?)
   (#x57a8 ?)
   (#x57a9 ?)
   (#x57ac ?)
   (#x57b8 ?)
   (#x57bd ?)
   (#x57c7 ?)
   (#x57c8 ?)
   (#x57cc ?)
   (#x57cf ?)
   (#x57d5 ?)
   (#x57dd ?)
   (#x57de ?)
   (#x57e1 ?)
   (#x57e4 ?)
   (#x57e6 ?)
   (#x57e7 ?)
   (#x57e9 ?)
   (#x57ed ?)
   (#x57f0 ?)
   (#x57f5 ?)
   (#x57f6 ?)
   (#x57f8 ?)
   (#x57fd ?)
   (#x57fe ?)
   (#x57ff ?)
   (#x5803 ?)
   (#x5804 ?)
   (#x5808 ?)
   (#x5809 ?)
   (#x580c ?)
   (#x580d ?)
   (#x581b ?)
   (#x581e ?)
   (#x581f ?)
   (#x5820 ?)
   (#x5826 ?)
   (#x5827 ?)
   (#x582d ?)
   (#x5832 ?)
   (#x5839 ?)
   (#x583f ?)
   (#x5849 ?)
   (#x584c ?)
   (#x584d ?)
   (#x584f ?)
   (#x5850 ?)
   (#x5855 ?)
   (#x585f ?)
   (#x5861 ?)
   (#x5864 ?)
   (#x5867 ?)
   (#x5868 ?)
   (#x5878 ?)
   (#x587c ?)
   (#x587f ?)
   (#x5880 ?)
   (#x5881 ?)
   (#x5887 ?)
   (#x5888 ?)
   (#x5889 ?)
   (#x588a ?)
   (#x588c ?)
   (#x588d ?)
   (#x588f ?)
   (#x5890 ?)
   (#x5894 ?)
   (#x5896 ?)
   (#x589d ?)
   (#x58a0 ?)
   (#x58a1 ?)
   (#x58a2 ?)
   (#x58a6 ?)
   (#x58a9 ?)
   (#x58b1 ?)
   (#x58b2 ?)
   (#x58bc ?)
   (#x58c2 ?)
   (#x58c4 ?)
   (#x58c8 ?)
   (#x58cd ?)
   (#x58ce ?)
   (#x58d0 ?)
   (#x58d2 ?)
   (#x58d4 ?)
   (#x58d6 ?)
   (#x58da ?)
   (#x58dd ?)
   (#x58e1 ?)
   (#x58e2 ?)
   (#x58e9 ?)
   (#x58f3 ?)
   (#x5905 ?)
   (#x5906 ?)
   (#x590b ?)
   (#x590c ?)
   (#x5912 ?)
   (#x5913 ?)
   (#x5914 ?)
   (#x591d ?)
   (#x5921 ?)
   (#x5923 ?)
   (#x5924 ?)
   (#x5928 ?)
   (#x592f ?)
   (#x5930 ?)
   (#x5933 ?)
   (#x5935 ?)
   (#x5936 ?)
   (#x593f ?)
   (#x5943 ?)
   (#x5946 ?)
   (#x5952 ?)
   (#x5953 ?)
   (#x5959 ?)
   (#x595b ?)
   (#x595d ?)
   (#x595e ?)
   (#x595f ?)
   (#x5961 ?)
   (#x5963 ?)
   (#x596b ?)
   (#x596d ?)
   (#x596f ?)
   (#x5972 ?)
   (#x5975 ?)
   (#x5976 ?)
   (#x5979 ?)
   (#x597b ?)
   (#x597c ?)
   (#x598b ?)
   (#x598c ?)
   (#x598e ?)
   (#x5992 ?)
   (#x5995 ?)
   (#x5997 ?)
   (#x599f ?)
   (#x59a4 ?)
   (#x59a7 ?)
   (#x59ad ?)
   (#x59ae ?)
   (#x59af ?)
   (#x59b0 ?)
   (#x59b3 ?)
   (#x59b7 ?)
   (#x59ba ?)
   (#x59bc ?)
   (#x59c1 ?)
   (#x59c3 ?)
   (#x59c4 ?)
   (#x59c8 ?)
   (#x59ca ?)
   (#x59cd ?)
   (#x59d2 ?)
   (#x59dd ?)
   (#x59de ?)
   (#x59df ?)
   (#x59e3 ?)
   (#x59e4 ?)
   (#x59e7 ?)
   (#x59ee ?)
   (#x59ef ?)
   (#x59f1 ?)
   (#x59f2 ?)
   (#x59f4 ?)
   (#x59f7 ?)
   (#x5a00 ?)
   (#x5a04 ?)
   (#x5a0c ?)
   (#x5a0d ?)
   (#x5a0e ?)
   (#x5a12 ?)
   (#x5a13 ?)
   (#x5a1e ?)
   (#x5a23 ?)
   (#x5a24 ?)
   (#x5a27 ?)
   (#x5a28 ?)
   (#x5a2a ?)
   (#x5a2d ?)
   (#x5a30 ?)
   (#x5a44 ?)
   (#x5a45 ?)
   (#x5a47 ?)
   (#x5a48 ?)
   (#x5a4c ?)
   (#x5a50 ?)
   (#x5a55 ?)
   (#x5a5e ?)
   (#x5a63 ?)
   (#x5a65 ?)
   (#x5a67 ?)
   (#x5a6d ?)
   (#x5a77 ?)
   (#x5a7a ?)
   (#x5a7b ?)
   (#x5a7e ?)
   (#x5a8b ?)
   (#x5a90 ?)
   (#x5a93 ?)
   (#x5a96 ?)
   (#x5a99 ?)
   (#x5a9c ?)
   (#x5a9e ?)
   (#x5a9f ?)
   (#x5aa0 ?)
   (#x5aa2 ?)
   (#x5aa7 ?)
   (#x5aac ?)
   (#x5ab1 ?)
   (#x5ab2 ?)
   (#x5ab3 ?)
   (#x5ab5 ?)
   (#x5ab8 ?)
   (#x5aba ?)
   (#x5abb ?)
   (#x5abf ?)
   (#x5ac4 ?)
   (#x5ac6 ?)
   (#x5ac8 ?)
   (#x5acf ?)
   (#x5ada ?)
   (#x5adc ?)
   (#x5ae0 ?)
   (#x5ae5 ?)
   (#x5aea ?)
   (#x5aee ?)
   (#x5af5 ?)
   (#x5af6 ?)
   (#x5afd ?)
   (#x5b00 ?)
   (#x5b01 ?)
   (#x5b08 ?)
   (#x5b17 ?)
   (#x5b19 ?)
   (#x5b1b ?)
   (#x5b1d ?)
   (#x5b21 ?)
   (#x5b25 ?)
   (#x5b2d ?)
   (#x5b34 ?)
   (#x5b38 ?)
   (#x5b41 ?)
   (#x5b4b ?)
   (#x5b4c ?)
   (#x5b52 ?)
   (#x5b56 ?)
   (#x5b5e ?)
   (#x5b68 ?)
   (#x5b6e ?)
   (#x5b6f ?)
   (#x5b7c ?)
   (#x5b7d ?)
   (#x5b7e ?)
   (#x5b7f ?)
   (#x5b81 ?)
   (#x5b84 ?)
   (#x5b86 ?)
   (#x5b8a ?)
   (#x5b8e ?)
   (#x5b90 ?)
   (#x5b91 ?)
   (#x5b93 ?)
   (#x5b94 ?)
   (#x5b96 ?)
   (#x5ba8 ?)
   (#x5ba9 ?)
   (#x5bac ?)
   (#x5bad ?)
   (#x5baf ?)
   (#x5bb1 ?)
   (#x5bb2 ?)
   (#x5bb7 ?)
   (#x5bba ?)
   (#x5bbc ?)
   (#x5bc0 ?)
   (#x5bc1 ?)
   (#x5bcd ?)
   (#x5bcf ?)
   (#x5bd6 ?)
   (#x5bd7 ?)
   (#x5bd8 ?)
   (#x5bd9 ?)
   (#x5bda ?)
   (#x5be0 ?)
   (#x5bef ?)
   (#x5bf1 ?)
   (#x5bf4 ?)
   (#x5bfd ?)
   (#x5c0c ?)
   (#x5c17 ?)
   (#x5c1e ?)
   (#x5c1f ?)
   (#x5c23 ?)
   (#x5c26 ?)
   (#x5c29 ?)
   (#x5c2b ?)
   (#x5c2c ?)
   (#x5c2e ?)
   (#x5c30 ?)
   (#x5c32 ?)
   (#x5c35 ?)
   (#x5c36 ?)
   (#x5c59 ?)
   (#x5c5a ?)
   (#x5c5c ?)
   (#x5c62 ?)
   (#x5c63 ?)
   (#x5c67 ?)
   (#x5c68 ?)
   (#x5c69 ?)
   (#x5c6d ?)
   (#x5c70 ?)
   (#x5c74 ?)
   (#x5c75 ?)
   (#x5c7a ?)
   (#x5c7b ?)
   (#x5c7c ?)
   (#x5c7d ?)
   (#x5c87 ?)
   (#x5c88 ?)
   (#x5c8a ?)
   (#x5c8f ?)
   (#x5c92 ?)
   (#x5c9d ?)
   (#x5c9f ?)
   (#x5ca0 ?)
   (#x5ca2 ?)
   (#x5ca3 ?)
   (#x5ca6 ?)
   (#x5caa ?)
   (#x5cb2 ?)
   (#x5cb4 ?)
   (#x5cb5 ?)
   (#x5cba ?)
   (#x5cc9 ?)
   (#x5ccb ?)
   (#x5cd2 ?)
   (#x5cd7 ?)
   (#x5cdd ?)
   (#x5cee ?)
   (#x5cf1 ?)
   (#x5cf2 ?)
   (#x5cf4 ?)
   (#x5d01 ?)
   (#x5d06 ?)
   (#x5d0d ?)
   (#x5d12 ?)
   (#x5d23 ?)
   (#x5d24 ?)
   (#x5d26 ?)
   (#x5d27 ?)
   (#x5d2b ?)
   (#x5d31 ?)
   (#x5d34 ?)
   (#x5d39 ?)
   (#x5d3d ?)
   (#x5d3f ?)
   (#x5d42 ?)
   (#x5d43 ?)
   (#x5d46 ?)
   (#x5d48 ?)
   (#x5d4a ?)
   (#x5d51 ?)
   (#x5d55 ?)
   (#x5d59 ?)
   (#x5d5f ?)
   (#x5d60 ?)
   (#x5d61 ?)
   (#x5d62 ?)
   (#x5d64 ?)
   (#x5d6a ?)
   (#x5d6d ?)
   (#x5d70 ?)
   (#x5d79 ?)
   (#x5d7a ?)
   (#x5d7e ?)
   (#x5d7f ?)
   (#x5d81 ?)
   (#x5d83 ?)
   (#x5d88 ?)
   (#x5d8a ?)
   (#x5d92 ?)
   (#x5d93 ?)
   (#x5d94 ?)
   (#x5d95 ?)
   (#x5d99 ?)
   (#x5d9b ?)
   (#x5d9f ?)
   (#x5da0 ?)
   (#x5da7 ?)
   (#x5dab ?)
   (#x5db0 ?)
   (#x5db2 ?)
   (#x5db4 ?)
   (#x5db8 ?)
   (#x5db9 ?)
   (#x5dc3 ?)
   (#x5dc7 ?)
   (#x5dcb ?)
   (#x5dce ?)
   (#x5dd0 ?)
   (#x5dd8 ?)
   (#x5dd9 ?)
   (#x5de0 ?)
   (#x5de4 ?)
   (#x5de9 ?)
   (#x5df8 ?)
   (#x5df9 ?)
   (#x5e00 ?)
   (#x5e07 ?)
   (#x5e0d ?)
   (#x5e12 ?)
   (#x5e14 ?)
   (#x5e15 ?)
   (#x5e18 ?)
   (#x5e1f ?)
   (#x5e20 ?)
   (#x5e28 ?)
   (#x5e2e ?)
   (#x5e32 ?)
   (#x5e35 ?)
   (#x5e3e ?)
   (#x5e49 ?)
   (#x5e4b ?)
   (#x5e50 ?)
   (#x5e51 ?)
   (#x5e56 ?)
   (#x5e58 ?)
   (#x5e5b ?)
   (#x5e5c ?)
   (#x5e5e ?)
   (#x5e68 ?)
   (#x5e6a ?)
   (#x5e6b ?)
   (#x5e6c ?)
   (#x5e6d ?)
   (#x5e6e ?)
   (#x5e70 ?)
   (#x5e80 ?)
   (#x5e8b ?)
   (#x5e8e ?)
   (#x5ea2 ?)
   (#x5ea4 ?)
   (#x5ea5 ?)
   (#x5ea8 ?)
   (#x5eaa ?)
   (#x5eac ?)
   (#x5eb1 ?)
   (#x5eb3 ?)
   (#x5ebd ?)
   (#x5ebe ?)
   (#x5ebf ?)
   (#x5ec6 ?)
   (#x5ecb ?)
   (#x5ecc ?)
   (#x5ece ?)
   (#x5ed1 ?)
   (#x5ed2 ?)
   (#x5ed4 ?)
   (#x5ed5 ?)
   (#x5edc ?)
   (#x5ede ?)
   (#x5ee5 ?)
   (#x5eeb ?)
   (#x5f02 ?)
   (#x5f06 ?)
   (#x5f07 ?)
   (#x5f08 ?)
   (#x5f0e ?)
   (#x5f19 ?)
   (#x5f1c ?)
   (#x5f1d ?)
   (#x5f21 ?)
   (#x5f22 ?)
   (#x5f23 ?)
   (#x5f24 ?)
   (#x5f28 ?)
   (#x5f2b ?)
   (#x5f2c ?)
   (#x5f2e ?)
   (#x5f30 ?)
   (#x5f34 ?)
   (#x5f36 ?)
   (#x5f3b ?)
   (#x5f3d ?)
   (#x5f3f ?)
   (#x5f40 ?)
   (#x5f44 ?)
   (#x5f45 ?)
   (#x5f47 ?)
   (#x5f4d ?)
   (#x5f50 ?)
   (#x5f54 ?)
   (#x5f58 ?)
   (#x5f5b ?)
   (#x5f60 ?)
   (#x5f63 ?)
   (#x5f64 ?)
   (#x5f67 ?)
   (#x5f6f ?)
   (#x5f72 ?)
   (#x5f74 ?)
   (#x5f75 ?)
   (#x5f78 ?)
   (#x5f7a ?)
   (#x5f7d ?)
   (#x5f7e ?)
   (#x5f89 ?)
   (#x5f8d ?)
   (#x5f8f ?)
   (#x5f96 ?)
   (#x5f9c ?)
   (#x5f9d ?)
   (#x5fa2 ?)
   (#x5fa4 ?)
   (#x5fa7 ?)
   (#x5fab ?)
   (#x5fac ?)
   (#x5faf ?)
   (#x5fb0 ?)
   (#x5fb1 ?)
   (#x5fb8 ?)
   (#x5fc4 ?)
   (#x5fc7 ?)
   (#x5fc8 ?)
   (#x5fc9 ?)
   (#x5fcb ?)
   (#x5fd0 ?)
   (#x5fd1 ?)
   (#x5fd2 ?)
   (#x5fd3 ?)
   (#x5fd4 ?)
   (#x5fde ?)
   (#x5fe1 ?)
   (#x5fe2 ?)
   (#x5fe8 ?)
   (#x5fe9 ?)
   (#x5fea ?)
   (#x5fec ?)
   (#x5fed ?)
   (#x5fee ?)
   (#x5fef ?)
   (#x5ff2 ?)
   (#x5ff3 ?)
   (#x5ff6 ?)
   (#x5ffa ?)
   (#x5ffc ?)
   (#x6007 ?)
   (#x600a ?)
   (#x600d ?)
   (#x6013 ?)
   (#x6014 ?)
   (#x6017 ?)
   (#x6018 ?)
   (#x601a ?)
   (#x601f ?)
   (#x6024 ?)
   (#x602d ?)
   (#x6033 ?)
   (#x6035 ?)
   (#x6040 ?)
   (#x6047 ?)
   (#x6048 ?)
   (#x6049 ?)
   (#x604c ?)
   (#x6051 ?)
   (#x6054 ?)
   (#x6056 ?)
   (#x6057 ?)
   (#x605d ?)
   (#x6061 ?)
   (#x6067 ?)
   (#x6071 ?)
   (#x607e ?)
   (#x607f ?)
   (#x6082 ?)
   (#x6086 ?)
   (#x6088 ?)
   (#x608a ?)
   (#x608e ?)
   (#x6091 ?)
   (#x6093 ?)
   (#x6095 ?)
   (#x6098 ?)
   (#x609d ?)
   (#x609e ?)
   (#x60a2 ?)
   (#x60a4 ?)
   (#x60a5 ?)
   (#x60a8 ?)
   (#x60b0 ?)
   (#x60b1 ?)
   (#x60b7 ?)
   (#x60bb ?)
   (#x60be ?)
   (#x60c2 ?)
   (#x60c4 ?)
   (#x60c8 ?)
   (#x60c9 ?)
   (#x60ca ?)
   (#x60cb ?)
   (#x60ce ?)
   (#x60cf ?)
   (#x60d4 ?)
   (#x60d5 ?)
   (#x60d9 ?)
   (#x60db ?)
   (#x60dd ?)
   (#x60de ?)
   (#x60e2 ?)
   (#x60e5 ?)
   (#x60f2 ?)
   (#x60f5 ?)
   (#x60f8 ?)
   (#x60fc ?)
   (#x60fd ?)
   (#x6102 ?)
   (#x6107 ?)
   (#x610a ?)
   (#x610c ?)
   (#x6110 ?)
   (#x6111 ?)
   (#x6112 ?)
   (#x6113 ?)
   (#x6114 ?)
   (#x6116 ?)
   (#x6117 ?)
   (#x6119 ?)
   (#x611c ?)
   (#x611e ?)
   (#x6122 ?)
   (#x612a ?)
   (#x612b ?)
   (#x6130 ?)
   (#x6131 ?)
   (#x6135 ?)
   (#x6136 ?)
   (#x6137 ?)
   (#x6139 ?)
   (#x6141 ?)
   (#x6145 ?)
   (#x6146 ?)
   (#x6149 ?)
   (#x615e ?)
   (#x6160 ?)
   (#x616c ?)
   (#x6172 ?)
   (#x6178 ?)
   (#x617b ?)
   (#x617c ?)
   (#x617f ?)
   (#x6180 ?)
   (#x6181 ?)
   (#x6183 ?)
   (#x6184 ?)
   (#x618b ?)
   (#x618d ?)
   (#x6192 ?)
   (#x6193 ?)
   (#x6197 ?)
   (#x6198 ?)
   (#x619c ?)
   (#x619d ?)
   (#x619f ?)
   (#x61a0 ?)
   (#x61a5 ?)
   (#x61a8 ?)
   (#x61aa ?)
   (#x61ad ?)
   (#x61b8 ?)
   (#x61b9 ?)
   (#x61bc ?)
   (#x61c0 ?)
   (#x61c1 ?)
   (#x61c2 ?)
   (#x61ce ?)
   (#x61cf ?)
   (#x61d5 ?)
   (#x61dc ?)
   (#x61dd ?)
   (#x61de ?)
   (#x61df ?)
   (#x61e1 ?)
   (#x61e2 ?)
   (#x61e5 ?)
   (#x61e7 ?)
   (#x61e9 ?)
   (#x61ec ?)
   (#x61ed ?)
   (#x61ef ?)
   (#x6201 ?)
   (#x6203 ?)
   (#x6204 ?)
   (#x6207 ?)
   (#x6213 ?)
   (#x6215 ?)
   (#x621c ?)
   (#x6220 ?)
   (#x6222 ?)
   (#x6223 ?)
   (#x6227 ?)
   (#x6229 ?)
   (#x622b ?)
   (#x6239 ?)
   (#x623d ?)
   (#x6242 ?)
   (#x6243 ?)
   (#x6244 ?)
   (#x6246 ?)
   (#x624c ?)
   (#x6250 ?)
   (#x6251 ?)
   (#x6252 ?)
   (#x6254 ?)
   (#x6256 ?)
   (#x625a ?)
   (#x625c ?)
   (#x6264 ?)
   (#x626d ?)
   (#x626f ?)
   (#x6273 ?)
   (#x627a ?)
   (#x627d ?)
   (#x628d ?)
   (#x628e ?)
   (#x628f ?)
   (#x6290 ?)
   (#x62a6 ?)
   (#x62a8 ?)
   (#x62b3 ?)
   (#x62b6 ?)
   (#x62b7 ?)
   (#x62ba ?)
   (#x62be ?)
   (#x62bf ?)
   (#x62c4 ?)
   (#x62ce ?)
   (#x62d5 ?)
   (#x62d6 ?)
   (#x62da ?)
   (#x62ea ?)
   (#x62f2 ?)
   (#x62f4 ?)
   (#x62fc ?)
   (#x62fd ?)
   (#x6303 ?)
   (#x6304 ?)
   (#x630a ?)
   (#x630b ?)
   (#x630d ?)
   (#x6310 ?)
   (#x6313 ?)
   (#x6316 ?)
   (#x6318 ?)
   (#x6329 ?)
   (#x632a ?)
   (#x632d ?)
   (#x6335 ?)
   (#x6336 ?)
   (#x6339 ?)
   (#x633c ?)
   (#x6341 ?)
   (#x6342 ?)
   (#x6343 ?)
   (#x6344 ?)
   (#x6346 ?)
   (#x634a ?)
   (#x634b ?)
   (#x634e ?)
   (#x6352 ?)
   (#x6353 ?)
   (#x6354 ?)
   (#x6358 ?)
   (#x635b ?)
   (#x6365 ?)
   (#x6366 ?)
   (#x636c ?)
   (#x636d ?)
   (#x6371 ?)
   (#x6374 ?)
   (#x6375 ?)
   (#x6378 ?)
   (#x637c ?)
   (#x637d ?)
   (#x637f ?)
   (#x6382 ?)
   (#x6384 ?)
   (#x6387 ?)
   (#x638a ?)
   (#x6390 ?)
   (#x6394 ?)
   (#x6395 ?)
   (#x6399 ?)
   (#x639a ?)
   (#x639e ?)
   (#x63a4 ?)
   (#x63a6 ?)
   (#x63ad ?)
   (#x63ae ?)
   (#x63af ?)
   (#x63bd ?)
   (#x63c1 ?)
   (#x63c5 ?)
   (#x63c8 ?)
   (#x63ce ?)
   (#x63d1 ?)
   (#x63d3 ?)
   (#x63d4 ?)
   (#x63d5 ?)
   (#x63dc ?)
   (#x63e0 ?)
   (#x63e5 ?)
   (#x63ea ?)
   (#x63ec ?)
   (#x63f2 ?)
   (#x63f3 ?)
   (#x63f5 ?)
   (#x63f8 ?)
   (#x63f9 ?)
   (#x6409 ?)
   (#x640a ?)
   (#x6410 ?)
   (#x6412 ?)
   (#x6414 ?)
   (#x6418 ?)
   (#x641e ?)
   (#x6420 ?)
   (#x6422 ?)
   (#x6424 ?)
   (#x6425 ?)
   (#x6429 ?)
   (#x642a ?)
   (#x642f ?)
   (#x6430 ?)
   (#x6435 ?)
   (#x643d ?)
   (#x643f ?)
   (#x644b ?)
   (#x644f ?)
   (#x6451 ?)
   (#x6452 ?)
   (#x6453 ?)
   (#x6454 ?)
   (#x645a ?)
   (#x645b ?)
   (#x645c ?)
   (#x645d ?)
   (#x645f ?)
   (#x6460 ?)
   (#x6461 ?)
   (#x6463 ?)
   (#x646d ?)
   (#x6473 ?)
   (#x6474 ?)
   (#x647b ?)
   (#x647d ?)
   (#x6485 ?)
   (#x6487 ?)
   (#x648f ?)
   (#x6490 ?)
   (#x6491 ?)
   (#x6498 ?)
   (#x6499 ?)
   (#x649b ?)
   (#x649d ?)
   (#x649f ?)
   (#x64a1 ?)
   (#x64a3 ?)
   (#x64a6 ?)
   (#x64a8 ?)
   (#x64ac ?)
   (#x64b3 ?)
   (#x64bd ?)
   (#x64be ?)
   (#x64bf ?)
   (#x64c4 ?)
   (#x64c9 ?)
   (#x64ca ?)
   (#x64cb ?)
   (#x64cc ?)
   (#x64ce ?)
   (#x64d0 ?)
   (#x64d1 ?)
   (#x64d5 ?)
   (#x64d7 ?)
   (#x64e4 ?)
   (#x64e5 ?)
   (#x64e9 ?)
   (#x64ea ?)
   (#x64ed ?)
   (#x64f0 ?)
   (#x64f5 ?)
   (#x64f7 ?)
   (#x64fb ?)
   (#x64ff ?)
   (#x6501 ?)
   (#x6504 ?)
   (#x6508 ?)
   (#x6509 ?)
   (#x650a ?)
   (#x650f ?)
   (#x6513 ?)
   (#x6514 ?)
   (#x6516 ?)
   (#x6519 ?)
   (#x651b ?)
   (#x651e ?)
   (#x651f ?)
   (#x6522 ?)
   (#x6526 ?)
   (#x6529 ?)
   (#x652e ?)
   (#x6531 ?)
   (#x653a ?)
   (#x653c ?)
   (#x653d ?)
   (#x6543 ?)
   (#x6547 ?)
   (#x6549 ?)
   (#x6550 ?)
   (#x6552 ?)
   (#x6554 ?)
   (#x655f ?)
   (#x6560 ?)
   (#x6567 ?)
   (#x656b ?)
   (#x657a ?)
   (#x657d ?)
   (#x6581 ?)
   (#x6585 ?)
   (#x658a ?)
   (#x6592 ?)
   (#x6595 ?)
   (#x6598 ?)
   (#x659d ?)
   (#x65a0 ?)
   (#x65a3 ?)
   (#x65a6 ?)
   (#x65ae ?)
   (#x65b2 ?)
   (#x65b3 ?)
   (#x65b4 ?)
   (#x65bf ?)
   (#x65c2 ?)
   (#x65c8 ?)
   (#x65c9 ?)
   (#x65ce ?)
   (#x65d0 ?)
   (#x65d4 ?)
   (#x65d6 ?)
   (#x65d8 ?)
   (#x65df ?)
   (#x65f0 ?)
   (#x65f2 ?)
   (#x65f4 ?)
   (#x65f5 ?)
   (#x65f9 ?)
   (#x65fe ?)
   (#x65ff ?)
   (#x6600 ?)
   (#x6604 ?)
   (#x6608 ?)
   (#x6609 ?)
   (#x660d ?)
   (#x6611 ?)
   (#x6612 ?)
   (#x6615 ?)
   (#x6616 ?)
   (#x661d ?)
   (#x661e ?¡)
   (#x6621 ?¢)
   (#x6622 ?£)
   (#x6623 ?¤)
   (#x6624 ?¥)
   (#x6626 ?¦)
   (#x6629 ?§)
   (#x662a ?¨)
   (#x662b ?©)
   (#x662c ?ª)
   (#x662e ?«)
   (#x6630 ?¬)
   (#x6631 ?­)
   (#x6633 ?®)
   (#x6637 ?°)
   (#x6639 ?¯)
   (#x6640 ?±)
   (#x6645 ?²)
   (#x6646 ?³)
   (#x664a ?´)
   (#x664c ?µ)
   (#x664e ?·)
   (#x6651 ?¶)
   (#x6657 ?¸)
   (#x6658 ?¹)
   (#x6659 ?º)
   (#x665b ?»)
   (#x665c ?¼)
   (#x6660 ?½)
   (#x6661 ?¾)
   (#x666a ?)
   (#x666b ?)
   (#x666c ?)
   (#x6673 ?)
   (#x6675 ?)
   (#x6677 ?)
   (#x6678 ?)
   (#x6679 ?)
   (#x667b ?)
   (#x667c ?)
   (#x667e ?)
   (#x667f ?)
   (#x6680 ?)
   (#x668b ?)
   (#x668c ?)
   (#x668d ?)
   (#x6690 ?)
   (#x6692 ?)
   (#x6699 ?)
   (#x669a ?)
   (#x669b ?)
   (#x669c ?)
   (#x669f ?)
   (#x66a0 ?)
   (#x66a4 ?)
   (#x66ad ?)
   (#x66b1 ?)
   (#x66b2 ?)
   (#x66b5 ?)
   (#x66bb ?)
   (#x66bf ?)
   (#x66c0 ?)
   (#x66c2 ?)
   (#x66c3 ?)
   (#x66c8 ?)
   (#x66cc ?)
   (#x66ce ?)
   (#x66cf ?)
   (#x66d4 ?)
   (#x66db ?)
   (#x66df ?)
   (#x66e8 ?)
   (#x66eb ?)
   (#x66ec ?)
   (#x66ee ?)
   (#x66fa ?)
   (#x66fb ?¿)
   (#x6705 ?)
   (#x6707 ?)
   (#x670e ?)
   (#x6713 ?)
   (#x6719 ?)
   (#x671c ?)
   (#x6720 ?)
   (#x6722 ?)
   (#x6733 ?)
   (#x673e ?)
   (#x6745 ?)
   (#x6747 ?)
   (#x6748 ?)
   (#x674c ?)
   (#x6754 ?)
   (#x6755 ?)
   (#x675d ?)
   (#x6766 ?á)
   (#x676c ?â)
   (#x676e ?ã)
   (#x6774 ?ä)
   (#x6776 ?å)
   (#x677b ?æ)
   (#x6781 ?ç)
   (#x6784 ?è)
   (#x678e ?é)
   (#x678f ?ê)
   (#x6791 ?ë)
   (#x6793 ?ì)
   (#x6796 ?í)
   (#x6798 ?î)
   (#x6799 ?ï)
   (#x679b ?ð)
   (#x67b0 ?ñ)
   (#x67b1 ?ò)
   (#x67b2 ?ó)
   (#x67b5 ?ô)
   (#x67bb ?õ)
   (#x67bc ?ö)
   (#x67bd ?÷)
   (#x67c0 ?ù)
   (#x67c2 ?ú)
   (#x67c3 ?û)
   (#x67c5 ?ü)
   (#x67c8 ?ý)
   (#x67c9 ?þ)
   (#x67d2 ?ÿ)
   (#x67d7 ?)
   (#x67d9 ?)
   (#x67dc ?)
   (#x67e1 ?)
   (#x67e6 ?)
   (#x67f0 ?)
   (#x67f2 ?)
   (#x67f6 ?)
   (#x67f7 ?)
   (#x67f9 ?ø)
   (#x6814 ?)
   (#x6819 ?)
   (#x681d ?)
   (#x681f ?)
   (#x6827 ?)
   (#x6828 ?)
   (#x682c ?)
   (#x682d ?)
   (#x682f ?)
   (#x6830 ?)
   (#x6831 ?)
   (#x6833 ?)
   (#x683b ?)
   (#x683f ?)
   (#x6844 ?)
   (#x6845 ?)
   (#x684a ?)
   (#x684c ?)
   (#x6852 ?)
   (#x6855 ?)
   (#x6857 ?)
   (#x6858 ?)
   (#x685b ?)
   (#x686b ?)
   (#x686e ?)
   (#x686f ?)
   (#x6870 ?)
   (#x6871 ?)
   (#x6872 ?)
   (#x6875 ?)
   (#x6879 ?)
   (#x687a ?)
   (#x687b ?)
   (#x687c ?)
   (#x6882 ?)
   (#x6884 ?)
   (#x6886 ?)
   (#x6888 ?)
   (#x6896 ?)
   (#x6898 ?)
   (#x689a ?)
   (#x689c ?)
   (#x68a1 ?)
   (#x68a3 ?)
   (#x68a5 ?)
   (#x68a9 ?)
   (#x68aa ?)
   (#x68ae ?)
   (#x68b2 ?)
   (#x68bb ?)
   (#x68c5 ?)
   (#x68c8 ?)
   (#x68cc ?)
   (#x68cf ?)
   (#x68d0 ?ġ)
   (#x68d1 ?Ģ)
   (#x68d3 ?ģ)
   (#x68d6 ?Ĥ)
   (#x68d9 ?ĥ)
   (#x68dc ?Ħ)
   (#x68dd ?ħ)
   (#x68e5 ?Ĩ)
   (#x68e8 ?ĩ)
   (#x68ea ?Ī)
   (#x68eb ?ī)
   (#x68ec ?Ĭ)
   (#x68ed ?ĭ)
   (#x68f0 ?Į)
   (#x68f1 ?į)
   (#x68f5 ?İ)
   (#x68f6 ?ı)
   (#x68fb ?Ĳ)
   (#x68fc ?ĳ)
   (#x68fd ?Ĵ)
   (#x6906 ?ĵ)
   (#x6909 ?Ķ)
   (#x690a ?ķ)
   (#x6910 ?ĸ)
   (#x6911 ?Ĺ)
   (#x6913 ?ĺ)
   (#x6916 ?Ļ)
   (#x6917 ?ļ)
   (#x6931 ?Ľ)
   (#x6933 ?ľ)
   (#x6935 ?Ŀ)
   (#x6938 ?)
   (#x693b ?)
   (#x6942 ?)
   (#x6945 ?)
   (#x6949 ?)
   (#x694e ?)
   (#x6957 ?)
   (#x695b ?)
   (#x6963 ?)
   (#x6964 ?)
   (#x6965 ?)
   (#x6966 ?)
   (#x6968 ?)
   (#x6969 ?)
   (#x696c ?)
   (#x6970 ?)
   (#x6971 ?)
   (#x6972 ?)
   (#x697a ?)
   (#x697b ?)
   (#x697f ?)
   (#x6980 ?)
   (#x698d ?)
   (#x6992 ?)
   (#x6996 ?)
   (#x6998 ?)
   (#x69a1 ?)
   (#x69a5 ?)
   (#x69a6 ?)
   (#x69a8 ?)
   (#x69ab ?)
   (#x69ad ?)
   (#x69af ?)
   (#x69b7 ?)
   (#x69b8 ?)
   (#x69ba ?)
   (#x69bc ?)
   (#x69c5 ?)
   (#x69c8 ?)
   (#x69d1 ?)
   (#x69d6 ?)
   (#x69d7 ?)
   (#x69e2 ?)
   (#x69e5 ?)
   (#x69ee ?)
   (#x69ef ?)
   (#x69f1 ?)
   (#x69f3 ?)
   (#x69f5 ?)
   (#x69fe ?)
   (#x6a00 ?)
   (#x6a01 ?)
   (#x6a03 ?)
   (#x6a0f ?)
   (#x6a11 ?)
   (#x6a15 ?)
   (#x6a1a ?)
   (#x6a1d ?)
   (#x6a20 ?)
   (#x6a24 ?)
   (#x6a28 ?)
   (#x6a30 ?)
   (#x6a32 ?)
   (#x6a34 ?š)
   (#x6a37 ?Ţ)
   (#x6a3b ?ţ)
   (#x6a3e ?Ť)
   (#x6a3f ?ť)
   (#x6a45 ?Ŧ)
   (#x6a46 ?ŧ)
   (#x6a49 ?Ũ)
   (#x6a4a ?ũ)
   (#x6a4e ?Ū)
   (#x6a50 ?ū)
   (#x6a51 ?Ŭ)
   (#x6a52 ?ŭ)
   (#x6a55 ?Ů)
   (#x6a56 ?ů)
   (#x6a5b ?Ű)
   (#x6a64 ?ű)
   (#x6a67 ?Ų)
   (#x6a6a ?ų)
   (#x6a71 ?Ŵ)
   (#x6a73 ?ŵ)
   (#x6a7e ?Ŷ)
   (#x6a81 ?ŷ)
   (#x6a83 ?Ÿ)
   (#x6a86 ?Ź)
   (#x6a87 ?ź)
   (#x6a89 ?Ż)
   (#x6a8b ?ż)
   (#x6a91 ?Ž)
   (#x6a9b ?ž)
   (#x6a9d ?ſ)
   (#x6a9e ?)
   (#x6a9f ?)
   (#x6aa5 ?)
   (#x6aab ?)
   (#x6aaf ?)
   (#x6ab0 ?)
   (#x6ab1 ?)
   (#x6ab4 ?)
   (#x6abd ?)
   (#x6abe ?)
   (#x6abf ?)
   (#x6ac6 ?)
   (#x6ac8 ?)
   (#x6ac9 ?)
   (#x6acc ?)
   (#x6ad0 ?)
   (#x6ad4 ?)
   (#x6ad5 ?)
   (#x6ad6 ?)
   (#x6adc ?)
   (#x6add ?)
   (#x6ae4 ?)
   (#x6ae7 ?)
   (#x6aec ?)
   (#x6af0 ?)
   (#x6af1 ?)
   (#x6af2 ?)
   (#x6afc ?)
   (#x6afd ?)
   (#x6b02 ?)
   (#x6b03 ?)
   (#x6b06 ?)
   (#x6b07 ?)
   (#x6b09 ?)
   (#x6b0f ?)
   (#x6b10 ?)
   (#x6b11 ?)
   (#x6b17 ?)
   (#x6b1b ?)
   (#x6b1e ?)
   (#x6b24 ?)
   (#x6b28 ?)
   (#x6b2b ?)
   (#x6b2c ?)
   (#x6b2f ?)
   (#x6b35 ?)
   (#x6b36 ?)
   (#x6b3b ?)
   (#x6b3f ?)
   (#x6b46 ?)
   (#x6b4a ?)
   (#x6b4d ?)
   (#x6b52 ?)
   (#x6b56 ?)
   (#x6b58 ?)
   (#x6b5d ?)
   (#x6b60 ?)
   (#x6b67 ?)
   (#x6b6b ?)
   (#x6b6e ?)
   (#x6b70 ?)
   (#x6b75 ?)
   (#x6b7d ?)
   (#x6b7e ?ơ)
   (#x6b82 ?Ƣ)
   (#x6b85 ?ƣ)
   (#x6b97 ?Ƥ)
   (#x6b9b ?ƥ)
   (#x6b9f ?Ʀ)
   (#x6ba0 ?Ƨ)
   (#x6ba2 ?ƨ)
   (#x6ba3 ?Ʃ)
   (#x6ba8 ?ƪ)
   (#x6ba9 ?ƫ)
   (#x6bac ?Ƭ)
   (#x6bad ?ƭ)
   (#x6bae ?Ʈ)
   (#x6bb0 ?Ư)
   (#x6bb8 ?ư)
   (#x6bb9 ?Ʊ)
   (#x6bbd ?Ʋ)
   (#x6bbe ?Ƴ)
   (#x6bc3 ?ƴ)
   (#x6bc4 ?Ƶ)
   (#x6bc9 ?ƶ)
   (#x6bcc ?Ʒ)
   (#x6bd6 ?Ƹ)
   (#x6bda ?ƹ)
   (#x6be1 ?ƺ)
   (#x6be3 ?ƻ)
   (#x6be6 ?Ƽ)
   (#x6be7 ?ƽ)
   (#x6bee ?ƾ)
   (#x6bf1 ?ƿ)
   (#x6bf7 ?)
   (#x6bf9 ?)
   (#x6bff ?)
   (#x6c02 ?)
   (#x6c04 ?)
   (#x6c05 ?)
   (#x6c09 ?)
   (#x6c0d ?)
   (#x6c0e ?)
   (#x6c10 ?)
   (#x6c12 ?)
   (#x6c19 ?)
   (#x6c1f ?)
   (#x6c26 ?)
   (#x6c27 ?)
   (#x6c28 ?)
   (#x6c2c ?)
   (#x6c2e ?)
   (#x6c33 ?)
   (#x6c35 ?)
   (#x6c36 ?)
   (#x6c3a ?)
   (#x6c3b ?)
   (#x6c3f ?)
   (#x6c4a ?)
   (#x6c4b ?)
   (#x6c4d ?)
   (#x6c4f ?)
   (#x6c52 ?)
   (#x6c54 ?)
   (#x6c59 ?)
   (#x6c5b ?)
   (#x6c5c ?)
   (#x6c67 ?Ƕ)
   (#x6c6b ?)
   (#x6c6d ?)
   (#x6c6f ?)
   (#x6c74 ?)
   (#x6c76 ?)
   (#x6c78 ?)
   (#x6c79 ?)
   (#x6c7b ?)
   (#x6c85 ?)
   (#x6c86 ?)
   (#x6c87 ?)
   (#x6c89 ?)
   (#x6c94 ?)
   (#x6c95 ?)
   (#x6c97 ?)
   (#x6c98 ?)
   (#x6c9c ?)
   (#x6c9f ?)
   (#x6cb0 ?)
   (#x6cb2 ?)
   (#x6cb4 ?)
   (#x6cc2 ?)
   (#x6cc6 ?)
   (#x6ccd ?)
   (#x6ccf ?)
   (#x6cd0 ?)
   (#x6cd1 ?)
   (#x6cd2 ?)
   (#x6cd4 ?)
   (#x6cd6 ?)
   (#x6cda ?ǡ)
   (#x6cdc ?Ǣ)
   (#x6ce0 ?ǣ)
   (#x6ce7 ?Ǥ)
   (#x6ce9 ?ǥ)
   (#x6ceb ?Ǧ)
   (#x6cec ?ǧ)
   (#x6cee ?Ǩ)
   (#x6cf2 ?ǩ)
   (#x6cf4 ?Ǫ)
   (#x6d04 ?ǫ)
   (#x6d07 ?Ǭ)
   (#x6d0a ?ǭ)
   (#x6d0e ?Ǯ)
   (#x6d0f ?ǯ)
   (#x6d11 ?ǰ)
   (#x6d13 ?Ǳ)
   (#x6d1a ?ǲ)
   (#x6d26 ?ǳ)
   (#x6d27 ?Ǵ)
   (#x6d28 ?ǵ)
   (#x6d2e ?Ƿ)
   (#x6d2f ?Ǹ)
   (#x6d31 ?ǹ)
   (#x6d39 ?Ǻ)
   (#x6d3c ?ǻ)
   (#x6d3f ?Ǽ)
   (#x6d57 ?ǽ)
   (#x6d5e ?Ǿ)
   (#x6d5f ?ǿ)
   (#x6d61 ?)
   (#x6d65 ?)
   (#x6d67 ?)
   (#x6d6f ?)
   (#x6d70 ?)
   (#x6d7c ?)
   (#x6d82 ?)
   (#x6d87 ?)
   (#x6d91 ?)
   (#x6d92 ?)
   (#x6d94 ?)
   (#x6d96 ?)
   (#x6d97 ?)
   (#x6d98 ?)
   (#x6daa ?)
   (#x6dac ?)
   (#x6db4 ?)
   (#x6db7 ?)
   (#x6db9 ?)
   (#x6dbd ?)
   (#x6dbf ?)
   (#x6dc4 ?)
   (#x6dc8 ?)
   (#x6dca ?)
   (#x6dce ?)
   (#x6dcf ?)
   (#x6dd6 ?)
   (#x6ddb ?)
   (#x6ddd ?)
   (#x6ddf ?)
   (#x6de0 ?)
   (#x6de2 ?)
   (#x6de5 ?)
   (#x6de9 ?)
   (#x6def ?)
   (#x6df0 ?)
   (#x6df4 ?)
   (#x6df6 ?)
   (#x6dfc ?)
   (#x6e00 ?)
   (#x6e04 ?)
   (#x6e1e ?)
   (#x6e22 ?)
   (#x6e27 ?)
   (#x6e32 ?)
   (#x6e36 ?)
   (#x6e39 ?)
   (#x6e3b ?)
   (#x6e3c ?)
   (#x6e44 ?)
   (#x6e45 ?)
   (#x6e48 ?)
   (#x6e49 ?)
   (#x6e4b ?)
   (#x6e4f ?)
   (#x6e51 ?)
   (#x6e52 ?)
   (#x6e53 ?)
   (#x6e54 ?)
   (#x6e57 ?)
   (#x6e5c ?)
   (#x6e5d ?)
   (#x6e5e ?)
   (#x6e62 ?ȡ)
   (#x6e63 ?Ȣ)
   (#x6e68 ?ȣ)
   (#x6e73 ?Ȥ)
   (#x6e7b ?ȥ)
   (#x6e7d ?Ȧ)
   (#x6e8d ?ȧ)
   (#x6e93 ?Ȩ)
   (#x6e99 ?ȩ)
   (#x6ea0 ?Ȫ)
   (#x6ea7 ?ȫ)
   (#x6ead ?Ȭ)
   (#x6eae ?ȭ)
   (#x6eb1 ?Ȯ)
   (#x6eb3 ?ȯ)
   (#x6ebb ?Ȱ)
   (#x6ebf ?ȱ)
   (#x6ec0 ?Ȳ)
   (#x6ec1 ?ȳ)
   (#x6ec3 ?ȴ)
   (#x6ec7 ?ȵ)
   (#x6ec8 ?ȶ)
   (#x6eca ?ȷ)
   (#x6ecd ?ȸ)
   (#x6ece ?ȹ)
   (#x6ecf ?Ⱥ)
   (#x6eeb ?Ȼ)
   (#x6eed ?ȼ)
   (#x6eee ?Ƚ)
   (#x6ef9 ?Ⱦ)
   (#x6efb ?ȿ)
   (#x6efd ?)
   (#x6f04 ?)
   (#x6f08 ?)
   (#x6f0a ?)
   (#x6f0c ?)
   (#x6f0d ?)
   (#x6f16 ?)
   (#x6f18 ?)
   (#x6f1a ?)
   (#x6f1b ?)
   (#x6f26 ?)
   (#x6f29 ?)
   (#x6f2a ?)
   (#x6f2d ?)
   (#x6f2f ?)
   (#x6f30 ?)
   (#x6f33 ?)
   (#x6f36 ?)
   (#x6f3b ?)
   (#x6f3c ?)
   (#x6f4f ?)
   (#x6f51 ?)
   (#x6f52 ?)
   (#x6f53 ?)
   (#x6f57 ?)
   (#x6f59 ?)
   (#x6f5a ?)
   (#x6f5d ?)
   (#x6f5e ?)
   (#x6f61 ?)
   (#x6f62 ?)
   (#x6f68 ?)
   (#x6f6c ?)
   (#x6f7d ?)
   (#x6f7e ?)
   (#x6f83 ?)
   (#x6f87 ?)
   (#x6f88 ?)
   (#x6f8b ?)
   (#x6f8c ?)
   (#x6f8d ?)
   (#x6f90 ?)
   (#x6f92 ?)
   (#x6f93 ?)
   (#x6f94 ?)
   (#x6f96 ?)
   (#x6f9a ?)
   (#x6f9f ?)
   (#x6fa0 ?)
   (#x6fa5 ?)
   (#x6fa6 ?)
   (#x6fa7 ?)
   (#x6fa8 ?)
   (#x6fae ?)
   (#x6faf ?)
   (#x6fb0 ?)
   (#x6fb5 ?)
   (#x6fb6 ?)
   (#x6fbc ?)
   (#x6fc5 ?)
   (#x6fc7 ?)
   (#x6fc8 ?)
   (#x6fca ?)
   (#x6fda ?ɡ)
   (#x6fde ?ɢ)
   (#x6fe8 ?ɣ)
   (#x6fe9 ?ɤ)
   (#x6ff0 ?ɥ)
   (#x6ff5 ?ɦ)
   (#x6ff9 ?ɧ)
   (#x6ffc ?ɨ)
   (#x6ffd ?ɩ)
   (#x7000 ?ɪ)
   (#x7005 ?ɫ)
   (#x7006 ?ɬ)
   (#x7007 ?ɭ)
   (#x700d ?ɮ)
   (#x7017 ?ɯ)
   (#x7020 ?ɰ)
   (#x7023 ?ɱ)
   (#x702f ?ɲ)
   (#x7034 ?ɳ)
   (#x7037 ?ɴ)
   (#x7039 ?ɵ)
   (#x703c ?ɶ)
   (#x7043 ?ɷ)
   (#x7044 ?ɸ)
   (#x7048 ?ɹ)
   (#x7049 ?ɺ)
   (#x704a ?ɻ)
   (#x704b ?ɼ)
   (#x704e ?)
   (#x7054 ?ɽ)
   (#x7055 ?ɾ)
   (#x705d ?ɿ)
   (#x705e ?)
   (#x7064 ?)
   (#x7065 ?)
   (#x706c ?)
   (#x706e ?)
   (#x7075 ?)
   (#x7076 ?)
   (#x707e ?)
   (#x7081 ?)
   (#x7085 ?)
   (#x7086 ?)
   (#x7094 ?)
   (#x7095 ?)
   (#x7096 ?)
   (#x7097 ?)
   (#x7098 ?)
   (#x709b ?)
   (#x70a4 ?)
   (#x70ab ?)
   (#x70b0 ?)
   (#x70b1 ?)
   (#x70b4 ?)
   (#x70b7 ?)
   (#x70ca ?)
   (#x70d1 ?)
   (#x70d3 ?)
   (#x70d4 ?)
   (#x70d5 ?)
   (#x70d6 ?)
   (#x70d8 ?)
   (#x70dc ?)
   (#x70e4 ?)
   (#x70fa ?)
   (#x7103 ?)
   (#x7104 ?)
   (#x7105 ?)
   (#x7106 ?)
   (#x7107 ?)
   (#x710b ?)
   (#x710c ?)
   (#x710f ?)
   (#x711e ?)
   (#x7120 ?)
   (#x712b ?)
   (#x712d ?)
   (#x712f ?)
   (#x7130 ?)
   (#x7131 ?)
   (#x7138 ?)
   (#x7141 ?)
   (#x7145 ?)
   (#x7146 ?)
   (#x7147 ?)
   (#x714a ?)
   (#x714b ?)
   (#x7150 ?)
   (#x7152 ?)
   (#x7157 ?)
   (#x715a ?)
   (#x715c ?)
   (#x715e ?)
   (#x7160 ?)
   (#x7168 ?ʡ)
   (#x7179 ?ʢ)
   (#x7180 ?ʣ)
   (#x7185 ?ʤ)
   (#x7187 ?ʥ)
   (#x718c ?ʦ)
   (#x7192 ?ʧ)
   (#x719a ?ʨ)
   (#x719b ?ʩ)
   (#x71a0 ?ʪ)
   (#x71a2 ?ʫ)
   (#x71af ?ʬ)
   (#x71b0 ?ʭ)
   (#x71b2 ?ʮ)
   (#x71b3 ?ʯ)
   (#x71ba ?ʰ)
   (#x71bf ?ʱ)
   (#x71c0 ?ʲ)
   (#x71c1 ?ʳ)
   (#x71c4 ?ʴ)
   (#x71cb ?ʵ)
   (#x71cc ?ʶ)
   (#x71d3 ?ʷ)
   (#x71d6 ?ʸ)
   (#x71d9 ?ʹ)
   (#x71da ?ʺ)
   (#x71dc ?ʻ)
   (#x71f8 ?ʼ)
   (#x71fe ?ʽ)
   (#x7200 ?ʾ)
   (#x7207 ?ʿ)
   (#x7208 ?)
   (#x7209 ?)
   (#x7213 ?)
   (#x7217 ?)
   (#x721a ?)
   (#x721d ?)
   (#x721f ?)
   (#x7224 ?)
   (#x722b ?)
   (#x722f ?)
   (#x7234 ?)
   (#x7238 ?)
   (#x7239 ?)
   (#x7241 ?)
   (#x7242 ?)
   (#x7243 ?)
   (#x7245 ?)
   (#x724e ?)
   (#x724f ?)
   (#x7250 ?)
   (#x7253 ?)
   (#x7255 ?)
   (#x7256 ?)
   (#x725a ?)
   (#x725c ?)
   (#x725e ?)
   (#x7260 ?)
   (#x7263 ?)
   (#x7268 ?)
   (#x726b ?)
   (#x726e ?)
   (#x726f ?)
   (#x7271 ?)
   (#x7277 ?)
   (#x7278 ?)
   (#x727b ?)
   (#x727c ?)
   (#x727f ?)
   (#x7284 ?)
   (#x7289 ?)
   (#x728d ?)
   (#x728e ?)
   (#x7293 ?)
   (#x729b ?)
   (#x72a8 ?)
   (#x72ad ?)
   (#x72ae ?)
   (#x72b1 ?)
   (#x72b4 ?)
   (#x72be ?)
   (#x72c1 ?)
   (#x72c7 ?)
   (#x72c9 ?)
   (#x72cc ?)
   (#x72d5 ?)
   (#x72d6 ?)
   (#x72d8 ?)
   (#x72df ?)
   (#x72e5 ?)
   (#x72f3 ?)
   (#x72f4 ?)
   (#x72fa ?)
   (#x72fb ?)
   (#x72fe ?ˡ)
   (#x7302 ?ˢ)
   (#x7304 ?ˣ)
   (#x7305 ?ˤ)
   (#x7307 ?˥)
   (#x730b ?˦)
   (#x730d ?˧)
   (#x7312 ?˨)
   (#x7313 ?˩)
   (#x7318 ?˪)
   (#x7319 ?˫)
   (#x731e ?ˬ)
   (#x7322 ?˭)
   (#x7324 ?ˮ)
   (#x7327 ?˯)
   (#x7328 ?˰)
   (#x732c ?˱)
   (#x7331 ?˲)
   (#x7332 ?˳)
   (#x7335 ?˴)
   (#x733a ?˵)
   (#x733b ?˶)
   (#x733d ?˷)
   (#x7343 ?˸)
   (#x734d ?˹)
   (#x7350 ?˺)
   (#x7352 ?˻)
   (#x7356 ?˼)
   (#x7358 ?˽)
   (#x735d ?˾)
   (#x735e ?˿)
   (#x735f ?)
   (#x7360 ?)
   (#x7366 ?)
   (#x7367 ?)
   (#x7369 ?)
   (#x736b ?)
   (#x736c ?)
   (#x736e ?)
   (#x736f ?)
   (#x7371 ?)
   (#x7377 ?)
   (#x7379 ?)
   (#x737c ?)
   (#x7380 ?)
   (#x7381 ?)
   (#x7383 ?)
   (#x7385 ?)
   (#x7386 ?)
   (#x738e ?)
   (#x7390 ?)
   (#x7393 ?)
   (#x7395 ?)
   (#x7397 ?)
   (#x7398 ?)
   (#x739c ?)
   (#x739e ?)
   (#x739f ?)
   (#x73a0 ?)
   (#x73a2 ?)
   (#x73a5 ?)
   (#x73a6 ?)
   (#x73aa ?)
   (#x73ab ?)
   (#x73ad ?)
   (#x73b5 ?)
   (#x73b7 ?)
   (#x73b9 ?)
   (#x73bc ?)
   (#x73bd ?)
   (#x73bf ?)
   (#x73c5 ?)
   (#x73c6 ?)
   (#x73c9 ?)
   (#x73cb ?)
   (#x73cc ?)
   (#x73cf ?)
   (#x73d2 ?)
   (#x73d3 ?)
   (#x73d6 ?)
   (#x73d9 ?)
   (#x73dd ?)
   (#x73e1 ?)
   (#x73e3 ?)
   (#x73e6 ?)
   (#x73e7 ?)
   (#x73e9 ?)
   (#x73f4 ?)
   (#x73f5 ?)
   (#x73f7 ?)
   (#x73f9 ?)
   (#x73fa ?)
   (#x73fb ?)
   (#x73fd ?)
   (#x73ff ?̡)
   (#x7400 ?̢)
   (#x7401 ?̣)
   (#x7404 ?̤)
   (#x7407 ?̥)
   (#x740a ?̦)
   (#x7411 ?̧)
   (#x741a ?̨)
   (#x741b ?̩)
   (#x7424 ?̪)
   (#x7426 ?̫)
   (#x7428 ?̬)
   (#x7429 ?̭)
   (#x742a ?̮)
   (#x742b ?̯)
   (#x742c ?̰)
   (#x742d ?̱)
   (#x742e ?̲)
   (#x742f ?̳)
   (#x7430 ?̴)
   (#x7431 ?̵)
   (#x7439 ?̶)
   (#x7440 ?̷)
   (#x7443 ?̸)
   (#x7444 ?̹)
   (#x7446 ?̺)
   (#x7447 ?̻)
   (#x744b ?̼)
   (#x744d ?̽)
   (#x7451 ?̾)
   (#x7452 ?̿)
   (#x7457 ?)
   (#x745d ?)
   (#x7462 ?)
   (#x7466 ?)
   (#x7467 ?)
   (#x7468 ?)
   (#x746b ?)
   (#x746d ?)
   (#x746e ?)
   (#x7471 ?)
   (#x7472 ?)
   (#x7480 ?)
   (#x7481 ?)
   (#x7485 ?)
   (#x7486 ?)
   (#x7487 ?)
   (#x7489 ?)
   (#x748f ?)
   (#x7490 ?)
   (#x7491 ?)
   (#x7492 ?)
   (#x7498 ?)
   (#x7499 ?)
   (#x749a ?)
   (#x749c ?)
   (#x749f ?)
   (#x74a0 ?)
   (#x74a1 ?)
   (#x74a3 ?)
   (#x74a6 ?)
   (#x74a8 ?)
   (#x74a9 ?)
   (#x74aa ?)
   (#x74ab ?)
   (#x74ae ?)
   (#x74af ?)
   (#x74b1 ?)
   (#x74b2 ?)
   (#x74b5 ?)
   (#x74b9 ?)
   (#x74bb ?)
   (#x74bf ?)
   (#x74c8 ?)
   (#x74c9 ?)
   (#x74cc ?)
   (#x74d0 ?)
   (#x74d3 ?)
   (#x74d8 ?)
   (#x74da ?)
   (#x74db ?)
   (#x74de ?)
   (#x74df ?)
   (#x74e4 ?)
   (#x74e8 ?)
   (#x74ea ?)
   (#x74eb ?)
   (#x74ef ?)
   (#x74f4 ?)
   (#x74fa ?)
   (#x74fb ?)
   (#x74fc ?)
   (#x74ff ?)
   (#x7506 ?)
   (#x7512 ?͡)
   (#x7516 ?͢)
   (#x7517 ?ͣ)
   (#x7520 ?ͤ)
   (#x7521 ?ͥ)
   (#x7524 ?ͦ)
   (#x7527 ?ͧ)
   (#x7529 ?ͨ)
   (#x752a ?ͩ)
   (#x752f ?ͪ)
   (#x7536 ?ͫ)
   (#x7539 ?ͬ)
   (#x753d ?ͭ)
   (#x753e ?ͮ)
   (#x753f ?ͯ)
   (#x7540 ?Ͱ)
   (#x7543 ?ͱ)
   (#x7547 ?Ͳ)
   (#x7548 ?ͳ)
   (#x754e ?ʹ)
   (#x7550 ?͵)
   (#x7552 ?Ͷ)
   (#x7557 ?ͷ)
   (#x755e ?͸)
   (#x755f ?͹)
   (#x7561 ?ͺ)
   (#x756f ?ͻ)
   (#x7571 ?ͼ)
   (#x7579 ?ͽ)
   (#x757a ?;)
   (#x757b ?Ϳ)
   (#x757c ?)
   (#x757d ?)
   (#x757e ?)
   (#x7581 ?)
   (#x7585 ?)
   (#x7590 ?)
   (#x7592 ?)
   (#x7593 ?)
   (#x7595 ?)
   (#x7599 ?)
   (#x759c ?)
   (#x75a2 ?)
   (#x75a4 ?)
   (#x75b4 ?)
   (#x75ba ?)
   (#x75bf ?)
   (#x75c0 ?)
   (#x75c1 ?)
   (#x75c4 ?)
   (#x75c6 ?)
   (#x75cc ?)
   (#x75ce ?)
   (#x75cf ?)
   (#x75d7 ?)
   (#x75dc ?)
   (#x75df ?)
   (#x75e0 ?)
   (#x75e1 ?)
   (#x75e4 ?)
   (#x75e7 ?)
   (#x75ec ?)
   (#x75ee ?)
   (#x75ef ?)
   (#x75f1 ?)
   (#x75f9 ?)
   (#x7600 ?)
   (#x7602 ?)
   (#x7603 ?)
   (#x7604 ?)
   (#x7607 ?)
   (#x7608 ?)
   (#x760a ?)
   (#x760c ?)
   (#x760f ?)
   (#x7612 ?)
   (#x7613 ?)
   (#x7615 ?)
   (#x7616 ?)
   (#x7619 ?)
   (#x761b ?)
   (#x761c ?)
   (#x761d ?)
   (#x761e ?)
   (#x7623 ?)
   (#x7625 ?)
   (#x7626 ?)
   (#x7629 ?)
   (#x762d ?)
   (#x7632 ?)
   (#x7633 ?)
   (#x7635 ?)
   (#x7638 ?)
   (#x7639 ?)
   (#x763a ?Ρ)
   (#x763c ?΢)
   (#x7640 ?Τ)
   (#x7641 ?Υ)
   (#x7643 ?Φ)
   (#x7644 ?Χ)
   (#x7645 ?Ψ)
   (#x7649 ?Ω)
   (#x764a ?Σ)
   (#x764b ?Ϊ)
   (#x7655 ?Ϋ)
   (#x7659 ?ά)
   (#x765f ?έ)
   (#x7664 ?ή)
   (#x7665 ?ί)
   (#x766d ?ΰ)
   (#x766e ?α)
   (#x766f ?β)
   (#x7671 ?γ)
   (#x7674 ?δ)
   (#x7681 ?ε)
   (#x7685 ?ζ)
   (#x768c ?η)
   (#x768d ?θ)
   (#x7695 ?ι)
   (#x769b ?κ)
   (#x769c ?λ)
   (#x769d ?μ)
   (#x769f ?ν)
   (#x76a0 ?ξ)
   (#x76a2 ?ο)
   (#x76a3 ?)
   (#x76a4 ?)
   (#x76a5 ?)
   (#x76a6 ?)
   (#x76a7 ?)
   (#x76a8 ?)
   (#x76aa ?)
   (#x76ad ?)
   (#x76bd ?)
   (#x76c1 ?)
   (#x76c5 ?)
   (#x76c9 ?)
   (#x76cb ?)
   (#x76cc ?)
   (#x76ce ?)
   (#x76d4 ?)
   (#x76d9 ?)
   (#x76e0 ?)
   (#x76e6 ?)
   (#x76e8 ?)
   (#x76ec ?)
   (#x76f0 ?)
   (#x76f1 ?)
   (#x76f6 ?)
   (#x76f9 ?)
   (#x76fc ?)
   (#x7700 ?)
   (#x7706 ?)
   (#x770a ?)
   (#x770e ?)
   (#x7712 ?)
   (#x7714 ?)
   (#x7715 ?)
   (#x7717 ?)
   (#x7719 ?)
   (#x771a ?)
   (#x771c ?)
   (#x7722 ?)
   (#x7728 ?)
   (#x772d ?)
   (#x772e ?)
   (#x772f ?)
   (#x7734 ?)
   (#x7735 ?)
   (#x7736 ?)
   (#x7739 ?)
   (#x773d ?)
   (#x773e ?)
   (#x7742 ?)
   (#x7745 ?)
   (#x7746 ?)
   (#x774a ?)
   (#x774d ?)
   (#x774e ?)
   (#x774f ?)
   (#x7752 ?)
   (#x7756 ?)
   (#x7757 ?)
   (#x775c ?)
   (#x775e ?)
   (#x775f ?)
   (#x7760 ?)
   (#x7762 ?)
   (#x7764 ?ϡ)
   (#x7767 ?Ϣ)
   (#x776a ?ϣ)
   (#x776c ?Ϥ)
   (#x7770 ?ϥ)
   (#x7772 ?Ϧ)
   (#x7773 ?ϧ)
   (#x7774 ?Ϩ)
   (#x777a ?ϩ)
   (#x777d ?Ϫ)
   (#x7780 ?ϫ)
   (#x7784 ?Ϭ)
   (#x778c ?ϭ)
   (#x778d ?Ϯ)
   (#x7794 ?ϯ)
   (#x7795 ?ϰ)
   (#x7796 ?ϱ)
   (#x779a ?ϲ)
   (#x779f ?ϳ)
   (#x77a2 ?ϴ)
   (#x77a7 ?ϵ)
   (#x77aa ?϶)
   (#x77ae ?Ϸ)
   (#x77af ?ϸ)
   (#x77b1 ?Ϲ)
   (#x77b5 ?Ϻ)
   (#x77be ?ϻ)
   (#x77c3 ?ϼ)
   (#x77c9 ?Ͻ)
   (#x77d1 ?Ͼ)
   (#x77d2 ?Ͽ)
   (#x77d5 ?)
   (#x77d9 ?)
   (#x77de ?)
   (#x77df ?)
   (#x77e0 ?)
   (#x77e4 ?)
   (#x77e6 ?)
   (#x77ea ?)
   (#x77ec ?)
   (#x77f0 ?)
   (#x77f1 ?)
   (#x77f4 ?)
   (#x77f8 ?)
   (#x77fb ?)
   (#x7805 ?)
   (#x7806 ?)
   (#x7809 ?)
   (#x780d ?)
   (#x780e ?)
   (#x7811 ?)
   (#x781d ?)
   (#x7821 ?)
   (#x7822 ?)
   (#x7823 ?)
   (#x782d ?)
   (#x782e ?)
   (#x7830 ?)
   (#x7835 ?)
   (#x7837 ?)
   (#x7843 ?)
   (#x7844 ?)
   (#x7847 ?)
   (#x7848 ?)
   (#x784c ?)
   (#x784e ?)
   (#x7852 ?)
   (#x785c ?)
   (#x785e ?)
   (#x7860 ?)
   (#x7861 ?)
   (#x7863 ?)
   (#x7864 ?)
   (#x7868 ?)
   (#x786a ?)
   (#x786e ?)
   (#x787a ?)
   (#x787e ?)
   (#x788a ?)
   (#x788f ?)
   (#x7894 ?)
   (#x7898 ?)
   (#x789d ?)
   (#x789e ?)
   (#x789f ?)
   (#x78a1 ?)
   (#x78a4 ?)
   (#x78a8 ?)
   (#x78ac ?)
   (#x78ad ?)
   (#x78b0 ?)
   (#x78b1 ?)
   (#x78b2 ?)
   (#x78b3 ?)
   (#x78bb ?С)
   (#x78bd ?Т)
   (#x78bf ?У)
   (#x78c7 ?Ф)
   (#x78c8 ?Х)
   (#x78c9 ?Ц)
   (#x78cc ?Ч)
   (#x78ce ?Ш)
   (#x78d2 ?Щ)
   (#x78d3 ?Ъ)
   (#x78d5 ?Ы)
   (#x78d6 ?Ь)
   (#x78db ?Ю)
   (#x78df ?Я)
   (#x78e0 ?а)
   (#x78e1 ?б)
   (#x78e4 ?Э)
   (#x78e6 ?в)
   (#x78ea ?г)
   (#x78f2 ?д)
   (#x78f3 ?е)
   (#x78f6 ?з)
   (#x78f7 ?и)
   (#x78fa ?й)
   (#x78fb ?к)
   (#x78ff ?л)
   (#x7900 ?ж)
   (#x7906 ?м)
   (#x790c ?н)
   (#x7910 ?о)
   (#x791a ?п)
   (#x791c ?)
   (#x791e ?)
   (#x791f ?)
   (#x7920 ?)
   (#x7925 ?)
   (#x7927 ?)
   (#x7929 ?)
   (#x792d ?)
   (#x7931 ?)
   (#x7934 ?)
   (#x7935 ?)
   (#x793b ?)
   (#x793d ?)
   (#x793f ?)
   (#x7944 ?)
   (#x7945 ?)
   (#x7946 ?)
   (#x794a ?)
   (#x794b ?)
   (#x794f ?)
   (#x7951 ?)
   (#x7954 ?)
   (#x7958 ?)
   (#x795b ?)
   (#x795c ?)
   (#x7967 ?)
   (#x7969 ?)
   (#x796b ?)
   (#x7972 ?)
   (#x7979 ?)
   (#x797b ?)
   (#x797c ?)
   (#x797e ?)
   (#x798b ?)
   (#x798c ?)
   (#x7991 ?)
   (#x7993 ?)
   (#x7994 ?)
   (#x7995 ?)
   (#x7996 ?)
   (#x7998 ?)
   (#x799b ?)
   (#x799c ?)
   (#x79a1 ?)
   (#x79a8 ?)
   (#x79a9 ?)
   (#x79ab ?)
   (#x79af ?)
   (#x79b1 ?)
   (#x79b4 ?)
   (#x79b8 ?)
   (#x79bb ?)
   (#x79c2 ?)
   (#x79c4 ?)
   (#x79c7 ?)
   (#x79c8 ?)
   (#x79ca ?)
   (#x79cf ?)
   (#x79d4 ?)
   (#x79d6 ?)
   (#x79da ?)
   (#x79dd ?)
   (#x79de ?)
   (#x79e0 ?ѡ)
   (#x79e2 ?Ѣ)
   (#x79e5 ?ѣ)
   (#x79ea ?Ѥ)
   (#x79eb ?ѥ)
   (#x79ed ?Ѧ)
   (#x79f1 ?ѧ)
   (#x79f8 ?Ѩ)
   (#x79fc ?ѩ)
   (#x7a02 ?Ѫ)
   (#x7a03 ?ѫ)
   (#x7a07 ?Ѭ)
   (#x7a09 ?ѭ)
   (#x7a0a ?Ѯ)
   (#x7a0c ?ѯ)
   (#x7a11 ?Ѱ)
   (#x7a15 ?ѱ)
   (#x7a1b ?Ѳ)
   (#x7a1e ?ѳ)
   (#x7a21 ?Ѵ)
   (#x7a27 ?ѵ)
   (#x7a2b ?Ѷ)
   (#x7a2d ?ѷ)
   (#x7a2f ?Ѹ)
   (#x7a30 ?ѹ)
   (#x7a34 ?Ѻ)
   (#x7a35 ?ѻ)
   (#x7a38 ?Ѽ)
   (#x7a39 ?ѽ)
   (#x7a3a ?Ѿ)
   (#x7a44 ?ѿ)
   (#x7a45 ?)
   (#x7a47 ?)
   (#x7a48 ?)
   (#x7a4c ?)
   (#x7a55 ?)
   (#x7a56 ?)
   (#x7a59 ?)
   (#x7a5c ?)
   (#x7a5d ?)
   (#x7a5f ?)
   (#x7a60 ?)
   (#x7a65 ?)
   (#x7a67 ?)
   (#x7a6a ?)
   (#x7a6d ?)
   (#x7a75 ?)
   (#x7a78 ?)
   (#x7a7e ?)
   (#x7a80 ?)
   (#x7a82 ?)
   (#x7a85 ?)
   (#x7a86 ?)
   (#x7a8a ?)
   (#x7a8b ?)
   (#x7a90 ?)
   (#x7a91 ?)
   (#x7a94 ?)
   (#x7a9e ?)
   (#x7aa0 ?)
   (#x7aa3 ?)
   (#x7aac ?)
   (#x7ab3 ?)
   (#x7ab5 ?)
   (#x7ab9 ?)
   (#x7abb ?)
   (#x7abc ?)
   (#x7ac6 ?)
   (#x7ac9 ?)
   (#x7acc ?)
   (#x7ace ?)
   (#x7ad1 ?)
   (#x7adb ?)
   (#x7ae8 ?)
   (#x7ae9 ?)
   (#x7aeb ?)
   (#x7aec ?)
   (#x7af1 ?)
   (#x7af4 ?)
   (#x7afb ?)
   (#x7afd ?)
   (#x7afe ?)
   (#x7b07 ?)
   (#x7b14 ?)
   (#x7b1f ?)
   (#x7b23 ?)
   (#x7b27 ?)
   (#x7b29 ?)
   (#x7b2a ?)
   (#x7b2b ?)
   (#x7b2d ?)
   (#x7b2e ?)
   (#x7b2f ?)
   (#x7b30 ?)
   (#x7b31 ?ҡ)
   (#x7b34 ?Ң)
   (#x7b3d ?ң)
   (#x7b3f ?Ҥ)
   (#x7b40 ?ҥ)
   (#x7b41 ?Ҧ)
   (#x7b47 ?ҧ)
   (#x7b4e ?Ҩ)
   (#x7b55 ?ҩ)
   (#x7b60 ?Ҫ)
   (#x7b64 ?ҫ)
   (#x7b66 ?Ҭ)
   (#x7b69 ?ҭ)
   (#x7b6a ?Ү)
   (#x7b6d ?ү)
   (#x7b6f ?Ұ)
   (#x7b72 ?ұ)
   (#x7b73 ?Ҳ)
   (#x7b77 ?ҳ)
   (#x7b84 ?Ҵ)
   (#x7b89 ?ҵ)
   (#x7b8e ?Ҷ)
   (#x7b90 ?ҷ)
   (#x7b91 ?Ҹ)
   (#x7b96 ?ҹ)
   (#x7b9b ?Һ)
   (#x7b9e ?һ)
   (#x7ba0 ?Ҽ)
   (#x7ba5 ?ҽ)
   (#x7bac ?Ҿ)
   (#x7baf ?ҿ)
   (#x7bb0 ?)
   (#x7bb2 ?)
   (#x7bb5 ?)
   (#x7bb6 ?)
   (#x7bba ?)
   (#x7bbb ?)
   (#x7bbc ?)
   (#x7bbd ?)
   (#x7bc2 ?)
   (#x7bc5 ?)
   (#x7bc8 ?)
   (#x7bca ?)
   (#x7bd4 ?)
   (#x7bd6 ?)
   (#x7bd7 ?)
   (#x7bd9 ?)
   (#x7bda ?)
   (#x7bdb ?)
   (#x7be8 ?)
   (#x7bea ?)
   (#x7bf2 ?)
   (#x7bf4 ?)
   (#x7bf5 ?)
   (#x7bf8 ?)
   (#x7bf9 ?)
   (#x7bfa ?)
   (#x7bfc ?)
   (#x7bfe ?)
   (#x7c01 ?)
   (#x7c02 ?)
   (#x7c03 ?)
   (#x7c04 ?)
   (#x7c06 ?)
   (#x7c09 ?)
   (#x7c0b ?)
   (#x7c0c ?)
   (#x7c0e ?)
   (#x7c0f ?)
   (#x7c19 ?)
   (#x7c1b ?)
   (#x7c20 ?)
   (#x7c25 ?)
   (#x7c26 ?)
   (#x7c28 ?)
   (#x7c2c ?)
   (#x7c31 ?)
   (#x7c33 ?)
   (#x7c34 ?)
   (#x7c36 ?)
   (#x7c39 ?)
   (#x7c3a ?)
   (#x7c46 ?)
   (#x7c4a ?)
   (#x7c51 ?)
   (#x7c52 ?)
   (#x7c53 ?)
   (#x7c55 ?)
   (#x7c59 ?)
   (#x7c5a ?)
   (#x7c5b ?)
   (#x7c5c ?)
   (#x7c5d ?)
   (#x7c5e ?)
   (#x7c61 ?ӡ)
   (#x7c63 ?Ӣ)
   (#x7c67 ?ӣ)
   (#x7c69 ?Ӥ)
   (#x7c6d ?ӥ)
   (#x7c6e ?Ӧ)
   (#x7c70 ?ӧ)
   (#x7c72 ?Ө)
   (#x7c79 ?ө)
   (#x7c7c ?Ӫ)
   (#x7c7d ?ӫ)
   (#x7c86 ?Ӭ)
   (#x7c87 ?ӭ)
   (#x7c8f ?Ӯ)
   (#x7c94 ?ӯ)
   (#x7c9e ?Ӱ)
   (#x7ca0 ?ӱ)
   (#x7ca6 ?Ӳ)
   (#x7cb0 ?ӳ)
   (#x7cb6 ?Ӵ)
   (#x7cb7 ?ӵ)
   (#x7cba ?Ӷ)
   (#x7cbb ?ӷ)
   (#x7cbc ?Ӹ)
   (#x7cbf ?ӹ)
   (#x7cc4 ?Ӻ)
   (#x7cc7 ?ӻ)
   (#x7cc8 ?Ӽ)
   (#x7cc9 ?ӽ)
   (#x7ccd ?Ӿ)
   (#x7ccf ?ӿ)
   (#x7cd3 ?)
   (#x7cd4 ?)
   (#x7cd5 ?)
   (#x7cd7 ?)
   (#x7cd9 ?)
   (#x7cda ?)
   (#x7cdd ?)
   (#x7ce6 ?)
   (#x7ce9 ?)
   (#x7ceb ?)
   (#x7cf5 ?)
   (#x7d03 ?)
   (#x7d07 ?)
   (#x7d08 ?)
   (#x7d09 ?)
   (#x7d0f ?)
   (#x7d11 ?)
   (#x7d12 ?)
   (#x7d13 ?)
   (#x7d16 ?)
   (#x7d1d ?)
   (#x7d1e ?)
   (#x7d23 ?)
   (#x7d26 ?)
   (#x7d2a ?)
   (#x7d2d ?)
   (#x7d31 ?)
   (#x7d3c ?)
   (#x7d3d ?)
   (#x7d3e ?)
   (#x7d40 ?)
   (#x7d41 ?)
   (#x7d47 ?)
   (#x7d48 ?)
   (#x7d4d ?)
   (#x7d51 ?)
   (#x7d53 ?)
   (#x7d57 ?)
   (#x7d59 ?)
   (#x7d5a ?)
   (#x7d5c ?)
   (#x7d5d ?)
   (#x7d65 ?)
   (#x7d67 ?)
   (#x7d6a ?)
   (#x7d70 ?)
   (#x7d78 ?)
   (#x7d7a ?)
   (#x7d7b ?)
   (#x7d7f ?)
   (#x7d81 ?)
   (#x7d82 ?)
   (#x7d83 ?)
   (#x7d85 ?)
   (#x7d86 ?)
   (#x7d88 ?)
   (#x7d8b ?)
   (#x7d8c ?)
   (#x7d8d ?)
   (#x7d91 ?)
   (#x7d96 ?)
   (#x7d97 ?)
   (#x7d9d ?)
   (#x7d9e ?ԡ)
   (#x7da6 ?Ԣ)
   (#x7da7 ?ԣ)
   (#x7daa ?Ԥ)
   (#x7db3 ?ԥ)
   (#x7db6 ?Ԧ)
   (#x7db7 ?ԧ)
   (#x7db9 ?Ԩ)
   (#x7dc2 ?ԩ)
   (#x7dc3 ?Ԫ)
   (#x7dc4 ?ԫ)
   (#x7dc5 ?Ԭ)
   (#x7dc6 ?ԭ)
   (#x7dcc ?Ԯ)
   (#x7dcd ?ԯ)
   (#x7dce ?԰)
   (#x7dd7 ?Ա)
   (#x7dd9 ?Բ)
   (#x7de2 ?Դ)
   (#x7de5 ?Ե)
   (#x7de6 ?Զ)
   (#x7dea ?Է)
   (#x7deb ?Ը)
   (#x7ded ?Թ)
   (#x7df1 ?Ժ)
   (#x7df5 ?Ի)
   (#x7df6 ?Լ)
   (#x7df9 ?Խ)
   (#x7dfa ?Ծ)
   (#x7e00 ?Գ)
   (#x7e08 ?Կ)
   (#x7e10 ?)
   (#x7e11 ?)
   (#x7e15 ?)
   (#x7e17 ?)
   (#x7e1c ?)
   (#x7e1d ?)
   (#x7e20 ?)
   (#x7e27 ?)
   (#x7e28 ?)
   (#x7e2c ?)
   (#x7e2d ?)
   (#x7e2f ?)
   (#x7e33 ?)
   (#x7e36 ?)
   (#x7e3f ?)
   (#x7e44 ?)
   (#x7e45 ?)
   (#x7e47 ?)
   (#x7e4e ?)
   (#x7e50 ?)
   (#x7e52 ?)
   (#x7e58 ?)
   (#x7e5f ?)
   (#x7e61 ?)
   (#x7e62 ?)
   (#x7e65 ?)
   (#x7e6b ?)
   (#x7e6e ?)
   (#x7e6f ?)
   (#x7e73 ?)
   (#x7e78 ?)
   (#x7e7e ?)
   (#x7e81 ?)
   (#x7e86 ?)
   (#x7e87 ?)
   (#x7e8a ?)
   (#x7e8d ?)
   (#x7e91 ?)
   (#x7e95 ?)
   (#x7e98 ?)
   (#x7e9a ?)
   (#x7e9d ?)
   (#x7e9e ?)
   (#x7f3b ?)
   (#x7f3c ?)
   (#x7f3d ?)
   (#x7f3e ?)
   (#x7f3f ?)
   (#x7f43 ?)
   (#x7f44 ?)
   (#x7f47 ?)
   (#x7f4f ?)
   (#x7f52 ?)
   (#x7f53 ?)
   (#x7f5b ?)
   (#x7f5c ?)
   (#x7f5d ?)
   (#x7f61 ?)
   (#x7f63 ?)
   (#x7f64 ?)
   (#x7f65 ?)
   (#x7f66 ?)
   (#x7f6d ?)
   (#x7f71 ?ա)
   (#x7f7d ?բ)
   (#x7f7e ?գ)
   (#x7f7f ?դ)
   (#x7f80 ?ե)
   (#x7f8b ?զ)
   (#x7f8d ?է)
   (#x7f8f ?ը)
   (#x7f90 ?թ)
   (#x7f91 ?ժ)
   (#x7f96 ?ի)
   (#x7f97 ?լ)
   (#x7f9c ?խ)
   (#x7fa1 ?ծ)
   (#x7fa2 ?կ)
   (#x7fa6 ?հ)
   (#x7faa ?ձ)
   (#x7fad ?ղ)
   (#x7fb4 ?ճ)
   (#x7fbc ?մ)
   (#x7fbf ?յ)
   (#x7fc0 ?ն)
   (#x7fc3 ?շ)
   (#x7fc8 ?ո)
   (#x7fce ?չ)
   (#x7fcf ?պ)
   (#x7fdb ?ջ)
   (#x7fdf ?ռ)
   (#x7fe3 ?ս)
   (#x7fe5 ?վ)
   (#x7fe8 ?տ)
   (#x7fec ?)
   (#x7fee ?)
   (#x7fef ?)
   (#x7ff2 ?)
   (#x7ffa ?)
   (#x7ffd ?)
   (#x7ffe ?)
   (#x7fff ?)
   (#x8007 ?)
   (#x8008 ?)
   (#x800a ?)
   (#x800d ?)
   (#x800e ?)
   (#x800f ?)
   (#x8011 ?)
   (#x8013 ?)
   (#x8014 ?)
   (#x8016 ?)
   (#x801d ?)
   (#x801e ?)
   (#x801f ?)
   (#x8020 ?)
   (#x8024 ?)
   (#x8026 ?)
   (#x802c ?)
   (#x802e ?)
   (#x8030 ?)
   (#x8034 ?)
   (#x8035 ?)
   (#x8037 ?)
   (#x8039 ?)
   (#x803a ?)
   (#x803c ?)
   (#x803e ?)
   (#x8040 ?)
   (#x8044 ?)
   (#x8060 ?)
   (#x8064 ?)
   (#x8066 ?)
   (#x806d ?)
   (#x8071 ?)
   (#x8075 ?)
   (#x8081 ?)
   (#x8088 ?)
   (#x808e ?)
   (#x809c ?)
   (#x809e ?)
   (#x80a6 ?)
   (#x80a7 ?)
   (#x80ab ?)
   (#x80b8 ?)
   (#x80b9 ?)
   (#x80c8 ?)
   (#x80cd ?)
   (#x80cf ?)
   (#x80d2 ?)
   (#x80d4 ?)
   (#x80d5 ?)
   (#x80d7 ?)
   (#x80d8 ?)
   (#x80e0 ?)
   (#x80ed ?)
   (#x80ee ?)
   (#x80f0 ?֡)
   (#x80f2 ?֢)
   (#x80f3 ?֣)
   (#x80f6 ?֤)
   (#x80f9 ?֥)
   (#x80fa ?֦)
   (#x80fe ?֧)
   (#x8103 ?֨)
   (#x810b ?֩)
   (#x8116 ?֪)
   (#x8117 ?֫)
   (#x8118 ?֬)
   (#x811c ?֭)
   (#x811e ?֮)
   (#x8120 ?֯)
   (#x8124 ?ְ)
   (#x8127 ?ֱ)
   (#x812c ?ֲ)
   (#x8130 ?ֳ)
   (#x8135 ?ִ)
   (#x813a ?ֵ)
   (#x813c ?ֶ)
   (#x8145 ?ַ)
   (#x8147 ?ָ)
   (#x814a ?ֹ)
   (#x814c ?ֺ)
   (#x8152 ?ֻ)
   (#x8157 ?ּ)
   (#x8160 ?ֽ)
   (#x8161 ?־)
   (#x8167 ?ֿ)
   (#x8168 ?)
   (#x8169 ?)
   (#x816d ?)
   (#x816f ?)
   (#x8177 ?)
   (#x8181 ?)
   (#x8184 ?)
   (#x8185 ?)
   (#x8186 ?)
   (#x818b ?)
   (#x818e ?)
   (#x8190 ?)
   (#x8196 ?)
   (#x8198 ?)
   (#x819b ?)
   (#x819e ?)
   (#x81a2 ?)
   (#x81ae ?)
   (#x81b2 ?)
   (#x81b4 ?)
   (#x81bb ?)
   (#x81c3 ?)
   (#x81c5 ?)
   (#x81ca ?)
   (#x81cb ?)
   (#x81ce ?)
   (#x81cf ?)
   (#x81d5 ?)
   (#x81d7 ?)
   (#x81db ?)
   (#x81dd ?)
   (#x81de ?)
   (#x81e1 ?)
   (#x81e4 ?)
   (#x81eb ?)
   (#x81ec ?)
   (#x81f0 ?)
   (#x81f1 ?)
   (#x81f2 ?)
   (#x81f5 ?)
   (#x81f6 ?)
   (#x81f8 ?)
   (#x81f9 ?)
   (#x81fd ?)
   (#x81ff ?)
   (#x8200 ?)
   (#x8203 ?)
   (#x820f ?)
   (#x8213 ?)
   (#x8214 ?)
   (#x8219 ?)
   (#x821a ?)
   (#x821d ?)
   (#x8221 ?)
   (#x8222 ?)
   (#x8228 ?)
   (#x8232 ?)
   (#x8234 ?)
   (#x823a ?)
   (#x8243 ?)
   (#x8244 ?)
   (#x8245 ?)
   (#x8246 ?)
   (#x824b ?ס)
   (#x824e ?ע)
   (#x824f ?ף)
   (#x8251 ?פ)
   (#x8256 ?ץ)
   (#x825c ?צ)
   (#x8260 ?ק)
   (#x8263 ?ר)
   (#x8267 ?ש)
   (#x826d ?ת)
   (#x8274 ?׫)
   (#x827b ?׬)
   (#x827d ?׭)
   (#x827f ?׮)
   (#x8280 ?ׯ)
   (#x8281 ?װ)
   (#x8283 ?ױ)
   (#x8284 ?ײ)
   (#x8287 ?׳)
   (#x8289 ?״)
   (#x828a ?׵)
   (#x828e ?׶)
   (#x8291 ?׷)
   (#x8294 ?׸)
   (#x8296 ?׹)
   (#x8298 ?׺)
   (#x829a ?׻)
   (#x829b ?׼)
   (#x82a0 ?׽)
   (#x82a1 ?׾)
   (#x82a3 ?׿)
   (#x82a4 ?)
   (#x82a7 ?)
   (#x82a8 ?)
   (#x82a9 ?)
   (#x82aa ?)
   (#x82ae ?)
   (#x82b0 ?)
   (#x82b2 ?)
   (#x82b4 ?)
   (#x82b7 ?)
   (#x82ba ?)
   (#x82bc ?)
   (#x82be ?)
   (#x82bf ?)
   (#x82c6 ?)
   (#x82d0 ?)
   (#x82d5 ?)
   (#x82da ?)
   (#x82e0 ?)
   (#x82e2 ?)
   (#x82e4 ?)
   (#x82e8 ?)
   (#x82ea ?)
   (#x82ed ?)
   (#x82ef ?)
   (#x82f6 ?)
   (#x82f7 ?)
   (#x82fd ?)
   (#x82fe ?)
   (#x8300 ?)
   (#x8301 ?)
   (#x8307 ?)
   (#x8308 ?)
   (#x830a ?)
   (#x830b ?)
   (#x831b ?)
   (#x831d ?)
   (#x831e ?)
   (#x831f ?)
   (#x8321 ?)
   (#x8322 ?)
   (#x832c ?)
   (#x832d ?)
   (#x832e ?)
   (#x8330 ?)
   (#x8333 ?)
   (#x8337 ?)
   (#x833a ?)
   (#x833c ?)
   (#x833d ?)
   (#x8342 ?)
   (#x8343 ?)
   (#x8344 ?)
   (#x8347 ?)
   (#x834d ?)
   (#x834e ?)
   (#x8351 ?)
   (#x8353 ?ؾ)
   (#x8354 ?)
   (#x8355 ?)
   (#x8356 ?)
   (#x8357 ?)
   (#x8370 ?)
   (#x8378 ?)
   (#x837d ?ء)
   (#x837f ?آ)
   (#x8380 ?أ)
   (#x8382 ?ؤ)
   (#x8384 ?إ)
   (#x8386 ?ئ)
   (#x838d ?ا)
   (#x8392 ?ب)
   (#x8394 ?ة)
   (#x8395 ?ت)
   (#x8398 ?ث)
   (#x8399 ?ج)
   (#x839b ?ح)
   (#x839c ?خ)
   (#x839d ?د)
   (#x83a6 ?ذ)
   (#x83a7 ?ر)
   (#x83a9 ?ز)
   (#x83ac ?س)
   (#x83ad ?)
   (#x83be ?ش)
   (#x83bf ?ص)
   (#x83c0 ?ض)
   (#x83c7 ?ط)
   (#x83c9 ?ظ)
   (#x83cf ?ع)
   (#x83d0 ?غ)
   (#x83d1 ?ػ)
   (#x83d4 ?ؼ)
   (#x83dd ?ؽ)
   (#x83e8 ?ؿ)
   (#x83ea ?)
   (#x83f6 ?)
   (#x83f8 ?)
   (#x83f9 ?)
   (#x83fc ?)
   (#x8401 ?)
   (#x8406 ?)
   (#x840a ?)
   (#x840f ?)
   (#x8411 ?)
   (#x8415 ?)
   (#x8419 ?)
   (#x842f ?)
   (#x8439 ?)
   (#x8445 ?)
   (#x8447 ?)
   (#x8448 ?)
   (#x844a ?)
   (#x844d ?)
   (#x844f ?)
   (#x8451 ?)
   (#x8452 ?)
   (#x8456 ?)
   (#x8458 ?)
   (#x8459 ?)
   (#x845a ?)
   (#x845c ?)
   (#x8460 ?)
   (#x8464 ?)
   (#x8465 ?)
   (#x8467 ?)
   (#x846a ?)
   (#x8470 ?)
   (#x8473 ?)
   (#x8474 ?)
   (#x8476 ?)
   (#x8478 ?)
   (#x847c ?)
   (#x847d ?)
   (#x8481 ?)
   (#x8485 ?)
   (#x8492 ?)
   (#x8493 ?)
   (#x8495 ?)
   (#x849e ?)
   (#x84a6 ?)
   (#x84a8 ?)
   (#x84a9 ?)
   (#x84aa ?)
   (#x84af ?)
   (#x84b1 ?)
   (#x84b4 ?)
   (#x84ba ?)
   (#x84bd ?)
   (#x84be ?)
   (#x84c0 ?)
   (#x84c2 ?)
   (#x84c7 ?)
   (#x84c8 ?)
   (#x84cc ?)
   (#x84cf ?)
   (#x84d3 ?)
   (#x84dc ?١)
   (#x84e7 ?٢)
   (#x84ea ?٣)
   (#x84ef ?٤)
   (#x84f0 ?٥)
   (#x84f1 ?٦)
   (#x84f2 ?٧)
   (#x84f7 ?٨)
   (#x84fa ?٪)
   (#x84fb ?٫)
   (#x84fd ?٬)
   (#x8502 ?٭)
   (#x8503 ?ٮ)
   (#x8507 ?ٯ)
   (#x850c ?ٰ)
   (#x850e ?ٱ)
   (#x8510 ?ٲ)
   (#x851c ?ٳ)
   (#x851e ?ٴ)
   (#x8522 ?ٵ)
   (#x8523 ?ٶ)
   (#x8524 ?ٷ)
   (#x8525 ?ٸ)
   (#x8527 ?ٹ)
   (#x852a ?ٺ)
   (#x852b ?ٻ)
   (#x852f ?ټ)
   (#x8532 ?٩)
   (#x8533 ?ٽ)
   (#x8534 ?پ)
   (#x8536 ?ٿ)
   (#x853f ?)
   (#x8546 ?)
   (#x854f ?)
   (#x8550 ?)
   (#x8551 ?)
   (#x8552 ?)
   (#x8553 ?)
   (#x8556 ?)
   (#x8559 ?)
   (#x855c ?)
   (#x855d ?)
   (#x855e ?)
   (#x855f ?)
   (#x8560 ?)
   (#x8561 ?)
   (#x8562 ?)
   (#x8564 ?)
   (#x856b ?)
   (#x856f ?)
   (#x8579 ?)
   (#x857a ?)
   (#x857b ?)
   (#x857d ?)
   (#x857f ?)
   (#x8581 ?)
   (#x8585 ?)
   (#x8586 ?)
   (#x8589 ?)
   (#x858b ?)
   (#x858c ?)
   (#x858f ?)
   (#x8593 ?)
   (#x8598 ?)
   (#x859d ?)
   (#x859f ?)
   (#x85a0 ?)
   (#x85a2 ?)
   (#x85a5 ?)
   (#x85a7 ?)
   (#x85ad ?)
   (#x85b4 ?)
   (#x85b6 ?)
   (#x85b7 ?)
   (#x85b8 ?)
   (#x85bc ?)
   (#x85bd ?)
   (#x85be ?)
   (#x85bf ?)
   (#x85c2 ?)
   (#x85c7 ?)
   (#x85ca ?)
   (#x85cb ?)
   (#x85ce ?)
   (#x85d8 ?)
   (#x85da ?)
   (#x85df ?)
   (#x85e0 ?)
   (#x85e6 ?)
   (#x85e8 ?)
   (#x85ed ?)
   (#x85f3 ?)
   (#x85f6 ?)
   (#x85fc ?)
   (#x85ff ?ڡ)
   (#x8600 ?ڢ)
   (#x8604 ?ڣ)
   (#x8605 ?ڤ)
   (#x860d ?ڥ)
   (#x860e ?ڦ)
   (#x8610 ?ڧ)
   (#x8611 ?ڨ)
   (#x8612 ?ک)
   (#x8618 ?ڪ)
   (#x8619 ?ګ)
   (#x861b ?ڬ)
   (#x861e ?ڭ)
   (#x8621 ?ڮ)
   (#x8627 ?گ)
   (#x8629 ?ڰ)
   (#x8636 ?ڱ)
   (#x8638 ?ڲ)
   (#x863a ?ڳ)
   (#x863c ?ڴ)
   (#x863d ?ڵ)
   (#x8640 ?ڶ)
   (#x8641 ?)
   (#x8642 ?ڷ)
   (#x8646 ?ڸ)
   (#x8652 ?ڹ)
   (#x8653 ?ں)
   (#x8656 ?ڻ)
   (#x8657 ?ڼ)
   (#x8658 ?ڽ)
   (#x8659 ?ھ)
   (#x865d ?ڿ)
   (#x8660 ?)
   (#x8661 ?)
   (#x8662 ?)
   (#x8663 ?)
   (#x8664 ?)
   (#x8669 ?)
   (#x866c ?)
   (#x866f ?)
   (#x8675 ?)
   (#x8676 ?)
   (#x8677 ?)
   (#x867a ?)
   (#x8688 ?)
   (#x868d ?)
   (#x8691 ?)
   (#x8696 ?)
   (#x8698 ?)
   (#x869a ?)
   (#x869c ?)
   (#x86a1 ?)
   (#x86a6 ?)
   (#x86a7 ?)
   (#x86a8 ?)
   (#x86ad ?)
   (#x86b1 ?)
   (#x86b3 ?)
   (#x86b4 ?)
   (#x86b5 ?)
   (#x86b7 ?)
   (#x86b8 ?)
   (#x86b9 ?)
   (#x86bf ?)
   (#x86c0 ?)
   (#x86c1 ?)
   (#x86c3 ?)
   (#x86c5 ?)
   (#x86d1 ?)
   (#x86d2 ?)
   (#x86d5 ?)
   (#x86d7 ?)
   (#x86da ?)
   (#x86dc ?)
   (#x86e0 ?)
   (#x86e3 ?)
   (#x86e5 ?)
   (#x86e7 ?)
   (#x86fa ?)
   (#x86fc ?)
   (#x86fd ?)
   (#x8704 ?)
   (#x8705 ?)
   (#x8707 ?)
   (#x870b ?)
   (#x870e ?)
   (#x870f ?)
   (#x8710 ?)
   (#x8713 ?)
   (#x8714 ?)
   (#x8719 ?)
   (#x871e ?)
   (#x871f ?)
   (#x8721 ?)
   (#x8723 ?)
   (#x8728 ?ۡ)
   (#x872e ?ۢ)
   (#x872f ?ۣ)
   (#x8731 ?ۤ)
   (#x8732 ?ۥ)
   (#x8739 ?ۦ)
   (#x873a ?ۧ)
   (#x873c ?ۨ)
   (#x873d ?۩)
   (#x873e ?۪)
   (#x8740 ?۫)
   (#x8743 ?۬)
   (#x8745 ?ۭ)
   (#x874d ?ۮ)
   (#x8758 ?ۯ)
   (#x875d ?۰)
   (#x8761 ?۱)
   (#x8764 ?۲)
   (#x8765 ?۳)
   (#x876f ?۴)
   (#x8771 ?۵)
   (#x8772 ?۶)
   (#x877b ?۷)
   (#x8783 ?۸)
   (#x8784 ?۹)
   (#x8785 ?ۺ)
   (#x8786 ?ۻ)
   (#x8787 ?ۼ)
   (#x8788 ?۽)
   (#x8789 ?۾)
   (#x878b ?ۿ)
   (#x878c ?)
   (#x8790 ?)
   (#x8793 ?)
   (#x8795 ?)
   (#x8797 ?)
   (#x8798 ?)
   (#x8799 ?)
   (#x879e ?)
   (#x87a0 ?)
   (#x87a3 ?)
   (#x87a7 ?)
   (#x87ac ?)
   (#x87ad ?)
   (#x87ae ?)
   (#x87b1 ?)
   (#x87b5 ?)
   (#x87be ?)
   (#x87bf ?)
   (#x87c1 ?)
   (#x87c8 ?)
   (#x87c9 ?)
   (#x87ca ?)
   (#x87ce ?)
   (#x87d5 ?)
   (#x87d6 ?)
   (#x87d9 ?)
   (#x87da ?)
   (#x87dc ?)
   (#x87df ?)
   (#x87e2 ?)
   (#x87e3 ?)
   (#x87e4 ?)
   (#x87ea ?)
   (#x87eb ?)
   (#x87ed ?)
   (#x87f1 ?)
   (#x87f3 ?)
   (#x87f8 ?)
   (#x87fa ?)
   (#x87ff ?)
   (#x8801 ?)
   (#x8803 ?)
   (#x8806 ?)
   (#x8809 ?)
   (#x880a ?)
   (#x880b ?)
   (#x8810 ?)
   (#x8812 ?)
   (#x8813 ?)
   (#x8814 ?)
   (#x8818 ?)
   (#x8819 ?)
   (#x881a ?)
   (#x881b ?)
   (#x881c ?)
   (#x881e ?)
   (#x881f ?)
   (#x8828 ?)
   (#x882d ?)
   (#x882e ?)
   (#x8830 ?)
   (#x8832 ?)
   (#x8835 ?)
   (#x883a ?ܡ)
   (#x883c ?ܢ)
   (#x8841 ?ܣ)
   (#x8843 ?ܤ)
   (#x8845 ?ܥ)
   (#x8848 ?ܦ)
   (#x8849 ?ܧ)
   (#x884a ?ܨ)
   (#x884b ?ܩ)
   (#x884e ?ܪ)
   (#x8851 ?ܫ)
   (#x8855 ?ܬ)
   (#x8856 ?ܭ)
   (#x8858 ?ܮ)
   (#x885a ?ܯ)
   (#x885c ?ܰ)
   (#x885f ?ܱ)
   (#x8860 ?ܲ)
   (#x8864 ?ܳ)
   (#x8869 ?ܴ)
   (#x8871 ?ܵ)
   (#x8879 ?ܶ)
   (#x887b ?ܷ)
   (#x8880 ?ܸ)
   (#x8898 ?ܹ)
   (#x889a ?ܺ)
   (#x889b ?ܻ)
   (#x889c ?ܼ)
   (#x889f ?ܽ)
   (#x88a0 ?ܾ)
   (#x88a8 ?ܿ)
   (#x88aa ?)
   (#x88ba ?)
   (#x88bd ?)
   (#x88be ?)
   (#x88c0 ?)
   (#x88ca ?)
   (#x88cb ?)
   (#x88cc ?)
   (#x88cd ?)
   (#x88ce ?)
   (#x88d1 ?)
   (#x88d2 ?)
   (#x88d3 ?)
   (#x88db ?)
   (#x88de ?)
   (#x88e7 ?)
   (#x88ef ?)
   (#x88f0 ?)
   (#x88f1 ?)
   (#x88f5 ?)
   (#x88f7 ?)
   (#x8901 ?)
   (#x8906 ?)
   (#x890d ?)
   (#x890e ?)
   (#x890f ?)
   (#x8915 ?)
   (#x8916 ?)
   (#x8918 ?)
   (#x8919 ?)
   (#x891a ?)
   (#x891c ?)
   (#x8920 ?)
   (#x8926 ?)
   (#x8927 ?)
   (#x8928 ?)
   (#x8930 ?)
   (#x8931 ?)
   (#x8932 ?)
   (#x8935 ?)
   (#x8939 ?)
   (#x893a ?)
   (#x893e ?)
   (#x8940 ?)
   (#x8942 ?)
   (#x8945 ?)
   (#x8946 ?)
   (#x8949 ?)
   (#x894f ?)
   (#x8952 ?)
   (#x8957 ?)
   (#x895a ?)
   (#x895b ?)
   (#x895c ?)
   (#x8961 ?)
   (#x8962 ?)
   (#x8963 ?)
   (#x896b ?)
   (#x896e ?)
   (#x8970 ?)
   (#x8973 ?)
   (#x8975 ?)
   (#x897a ?)
   (#x897b ?ݡ)
   (#x897c ?ݢ)
   (#x897d ?ݣ)
   (#x8989 ?ݤ)
   (#x898d ?ݥ)
   (#x8990 ?ݦ)
   (#x8994 ?ݧ)
   (#x8995 ?ݨ)
   (#x899b ?ݩ)
   (#x899c ?ݪ)
   (#x899f ?ݫ)
   (#x89a0 ?ݬ)
   (#x89a5 ?ݭ)
   (#x89b0 ?ݮ)
   (#x89b4 ?ݯ)
   (#x89b5 ?ݰ)
   (#x89b6 ?ݱ)
   (#x89b7 ?ݲ)
   (#x89bc ?ݳ)
   (#x89d4 ?ݴ)
   (#x89d5 ?ݵ)
   (#x89d6 ?ݶ)
   (#x89d7 ?ݷ)
   (#x89d8 ?ݸ)
   (#x89e5 ?ݹ)
   (#x89e9 ?ݺ)
   (#x89eb ?ݻ)
   (#x89ed ?ݼ)
   (#x89f1 ?ݽ)
   (#x89f3 ?ݾ)
   (#x89f6 ?ݿ)
   (#x89f9 ?)
   (#x89fd ?)
   (#x89ff ?)
   (#x8a04 ?)
   (#x8a05 ?)
   (#x8a07 ?)
   (#x8a0f ?)
   (#x8a11 ?)
   (#x8a12 ?)
   (#x8a14 ?)
   (#x8a15 ?)
   (#x8a1e ?)
   (#x8a20 ?)
   (#x8a22 ?)
   (#x8a24 ?)
   (#x8a26 ?)
   (#x8a2b ?)
   (#x8a2c ?)
   (#x8a2f ?)
   (#x8a35 ?)
   (#x8a37 ?)
   (#x8a3d ?)
   (#x8a3e ?)
   (#x8a40 ?)
   (#x8a43 ?)
   (#x8a45 ?)
   (#x8a47 ?)
   (#x8a49 ?)
   (#x8a4d ?)
   (#x8a4e ?)
   (#x8a53 ?)
   (#x8a56 ?)
   (#x8a57 ?)
   (#x8a58 ?)
   (#x8a5c ?)
   (#x8a5d ?)
   (#x8a61 ?)
   (#x8a65 ?)
   (#x8a67 ?)
   (#x8a75 ?)
   (#x8a76 ?)
   (#x8a77 ?)
   (#x8a79 ?)
   (#x8a7a ?)
   (#x8a7b ?)
   (#x8a7e ?)
   (#x8a7f ?)
   (#x8a80 ?)
   (#x8a83 ?)
   (#x8a86 ?)
   (#x8a8b ?)
   (#x8a8f ?)
   (#x8a90 ?)
   (#x8a92 ?)
   (#x8a96 ?)
   (#x8a97 ?)
   (#x8a99 ?)
   (#x8a9f ?)
   (#x8aa7 ?)
   (#x8aa9 ?)
   (#x8aae ?)
   (#x8aaf ?)
   (#x8ab3 ?)
   (#x8ab6 ?ޡ)
   (#x8ab7 ?ޢ)
   (#x8abb ?ޣ)
   (#x8abe ?ޤ)
   (#x8ac3 ?ޥ)
   (#x8ac6 ?ަ)
   (#x8ac8 ?ާ)
   (#x8ac9 ?ި)
   (#x8aca ?ީ)
   (#x8ad1 ?ު)
   (#x8ad3 ?ޫ)
   (#x8ad4 ?ެ)
   (#x8ad5 ?ޭ)
   (#x8ad7 ?ޮ)
   (#x8add ?ޯ)
   (#x8adf ?ް)
   (#x8aec ?ޱ)
   (#x8af0 ?޲)
   (#x8af4 ?޳)
   (#x8af5 ?޴)
   (#x8af6 ?޵)
   (#x8afc ?޶)
   (#x8aff ?޷)
   (#x8b05 ?޸)
   (#x8b06 ?޹)
   (#x8b0a ?޿)
   (#x8b0b ?޺)
   (#x8b11 ?޻)
   (#x8b1c ?޼)
   (#x8b1e ?޽)
   (#x8b1f ?޾)
   (#x8b2d ?)
   (#x8b30 ?)
   (#x8b37 ?)
   (#x8b3c ?)
   (#x8b42 ?)
   (#x8b43 ?)
   (#x8b44 ?)
   (#x8b45 ?)
   (#x8b46 ?)
   (#x8b48 ?)
   (#x8b4d ?)
   (#x8b52 ?)
   (#x8b53 ?)
   (#x8b54 ?)
   (#x8b59 ?)
   (#x8b5e ?)
   (#x8b63 ?)
   (#x8b6d ?)
   (#x8b76 ?)
   (#x8b78 ?)
   (#x8b79 ?)
   (#x8b7c ?)
   (#x8b7e ?)
   (#x8b81 ?)
   (#x8b84 ?)
   (#x8b85 ?)
   (#x8b8b ?)
   (#x8b8d ?)
   (#x8b8f ?)
   (#x8b94 ?)
   (#x8b95 ?)
   (#x8b9c ?)
   (#x8b9e ?)
   (#x8b9f ?)
   (#x8c38 ?)
   (#x8c39 ?)
   (#x8c3d ?)
   (#x8c3e ?)
   (#x8c45 ?)
   (#x8c47 ?)
   (#x8c49 ?)
   (#x8c4b ?)
   (#x8c4f ?)
   (#x8c51 ?)
   (#x8c53 ?)
   (#x8c54 ?)
   (#x8c57 ?)
   (#x8c58 ?)
   (#x8c59 ?)
   (#x8c5b ?)
   (#x8c5d ?)
   (#x8c63 ?)
   (#x8c64 ?)
   (#x8c66 ?)
   (#x8c68 ?)
   (#x8c69 ?)
   (#x8c6d ?)
   (#x8c73 ?)
   (#x8c75 ?)
   (#x8c76 ?)
   (#x8c7b ?)
   (#x8c7e ?)
   (#x8c86 ?)
   (#x8c87 ?ߡ)
   (#x8c8b ?ߢ)
   (#x8c90 ?ߣ)
   (#x8c92 ?ߤ)
   (#x8c93 ?ߥ)
   (#x8c99 ?ߦ)
   (#x8c9b ?ߧ)
   (#x8c9c ?ߨ)
   (#x8ca4 ?ߩ)
   (#x8cb9 ?ߪ)
   (#x8cba ?߫)
   (#x8cc5 ?߬)
   (#x8cc6 ?߭)
   (#x8cc9 ?߮)
   (#x8ccb ?߯)
   (#x8ccf ?߰)
   (#x8cd5 ?߲)
   (#x8cd6 ?߱)
   (#x8cd9 ?߳)
   (#x8cdd ?ߴ)
   (#x8ce1 ?ߵ)
   (#x8ce8 ?߶)
   (#x8cec ?߷)
   (#x8cef ?߸)
   (#x8cf0 ?߹)
   (#x8cf2 ?ߺ)
   (#x8cf5 ?߻)
   (#x8cf7 ?߼)
   (#x8cf8 ?߽)
   (#x8cfe ?߾)
   (#x8cff ?߿)
   (#x8d01 ?)
   (#x8d03 ?)
   (#x8d09 ?)
   (#x8d12 ?)
   (#x8d17 ?)
   (#x8d1b ?)
   (#x8d65 ?)
   (#x8d69 ?)
   (#x8d6c ?)
   (#x8d6e ?)
   (#x8d7f ?)
   (#x8d82 ?)
   (#x8d84 ?)
   (#x8d88 ?)
   (#x8d8d ?)
   (#x8d90 ?)
   (#x8d91 ?)
   (#x8d95 ?)
   (#x8d9e ?)
   (#x8d9f ?)
   (#x8da0 ?)
   (#x8da6 ?)
   (#x8dab ?)
   (#x8dac ?)
   (#x8daf ?)
   (#x8db2 ?)
   (#x8db5 ?)
   (#x8db7 ?)
   (#x8db9 ?)
   (#x8dbb ?)
   (#x8dbc ?)
   (#x8dc0 ?)
   (#x8dc5 ?)
   (#x8dc6 ?)
   (#x8dc7 ?)
   (#x8dc8 ?)
   (#x8dca ?)
   (#x8dce ?)
   (#x8dd1 ?)
   (#x8dd4 ?)
   (#x8dd5 ?)
   (#x8dd7 ?)
   (#x8dd9 ?)
   (#x8de4 ?)
   (#x8de5 ?)
   (#x8de7 ?)
   (#x8dec ?)
   (#x8df0 ?)
   (#x8df1 ?)
   (#x8df2 ?)
   (#x8df4 ?)
   (#x8dfd ?)
   (#x8e01 ?)
   (#x8e04 ?)
   (#x8e05 ?)
   (#x8e06 ?)
   (#x8e0b ?)
   (#x8e11 ?)
   (#x8e14 ?)
   (#x8e16 ?)
   (#x8e20 ?)
   (#x8e21 ?)
   (#x8e22 ?)
   (#x8e23 ?)
   (#x8e26 ?)
   (#x8e27 ?)
   (#x8e31 ?)
   (#x8e33 ?)
   (#x8e36 ?)
   (#x8e37 ?)
   (#x8e38 ?)
   (#x8e39 ?)
   (#x8e3d ?)
   (#x8e40 ?)
   (#x8e41 ?)
   (#x8e4b ?)
   (#x8e4d ?)
   (#x8e4e ?)
   (#x8e4f ?)
   (#x8e54 ?)
   (#x8e5b ?)
   (#x8e5c ?)
   (#x8e5d ?)
   (#x8e5e ?)
   (#x8e61 ?)
   (#x8e62 ?)
   (#x8e69 ?)
   (#x8e6c ?)
   (#x8e6d ?)
   (#x8e6f ?)
   (#x8e70 ?)
   (#x8e71 ?)
   (#x8e79 ?)
   (#x8e7a ?)
   (#x8e7b ?)
   (#x8e82 ?)
   (#x8e83 ?)
   (#x8e89 ?)
   (#x8e90 ?)
   (#x8e92 ?)
   (#x8e95 ?)
   (#x8e9a ?)
   (#x8e9b ?)
   (#x8e9d ?)
   (#x8e9e ?)
   (#x8ea2 ?)
   (#x8ea7 ?)
   (#x8ea9 ?)
   (#x8ead ?)
   (#x8eae ?)
   (#x8eb3 ?)
   (#x8eb5 ?)
   (#x8eba ?)
   (#x8ebb ?)
   (#x8ec0 ?)
   (#x8ec1 ?)
   (#x8ec3 ?)
   (#x8ec4 ?)
   (#x8ec7 ?)
   (#x8ecf ?)
   (#x8ed1 ?)
   (#x8ed4 ?)
   (#x8edc ?)
   (#x8ee8 ?)
   (#x8eed ?)
   (#x8eee ?)
   (#x8ef0 ?)
   (#x8ef1 ?)
   (#x8ef7 ?)
   (#x8ef9 ?)
   (#x8efa ?)
   (#x8f00 ?)
   (#x8f02 ?)
   (#x8f07 ?)
   (#x8f08 ?)
   (#x8f0f ?)
   (#x8f10 ?)
   (#x8f16 ?)
   (#x8f17 ?)
   (#x8f18 ?)
   (#x8f1e ?)
   (#x8f20 ?)
   (#x8f21 ?)
   (#x8f23 ?)
   (#x8f25 ?)
   (#x8f27 ?)
   (#x8f28 ?)
   (#x8f2c ?)
   (#x8f2d ?)
   (#x8f2e ?)
   (#x8f34 ?)
   (#x8f35 ?)
   (#x8f36 ?)
   (#x8f37 ?)
   (#x8f3a ?)
   (#x8f40 ?)
   (#x8f41 ?)
   (#x8f43 ?)
   (#x8f47 ?)
   (#x8f4f ?)
   (#x8f51 ?)
   (#x8f52 ?)
   (#x8f53 ?)
   (#x8f54 ?)
   (#x8f55 ?)
   (#x8f58 ?)
   (#x8f5d ?)
   (#x8f5e ?)
   (#x8f65 ?)
   (#x8f9d ?)
   (#x8fa0 ?)
   (#x8fa1 ?)
   (#x8fa4 ?)
   (#x8fa5 ?)
   (#x8fa6 ?)
   (#x8fb5 ?)
   (#x8fb6 ?)
   (#x8fb8 ?)
   (#x8fbe ?)
   (#x8fc0 ?)
   (#x8fc1 ?)
   (#x8fc6 ?)
   (#x8fca ?)
   (#x8fcb ?)
   (#x8fcd ?)
   (#x8fd0 ?)
   (#x8fd2 ?)
   (#x8fd3 ?)
   (#x8fd5 ?)
   (#x8fe0 ?)
   (#x8fe3 ?)
   (#x8fe4 ?)
   (#x8fe8 ?)
   (#x8fee ?)
   (#x8ff1 ?)
   (#x8ff5 ?)
   (#x8ff6 ?)
   (#x8ffb ?)
   (#x8ffe ?)
   (#x9002 ?)
   (#x9004 ?)
   (#x9008 ?)
   (#x900c ?)
   (#x9018 ?)
   (#x901b ?)
   (#x9028 ?)
   (#x9029 ?)
   (#x902a ?)
   (#x902c ?)
   (#x902d ?)
   (#x902f ?)
   (#x9033 ?)
   (#x9034 ?)
   (#x9037 ?)
   (#x903f ?)
   (#x9043 ?)
   (#x9044 ?)
   (#x904c ?)
   (#x905b ?)
   (#x905d ?)
   (#x9062 ?)
   (#x9066 ?)
   (#x9067 ?)
   (#x906c ?)
   (#x9070 ?)
   (#x9074 ?)
   (#x9079 ?)
   (#x9085 ?)
   (#x9088 ?)
   (#x908b ?)
   (#x908c ?)
   (#x908e ?)
   (#x9090 ?)
   (#x9095 ?)
   (#x9097 ?)
   (#x9098 ?)
   (#x9099 ?)
   (#x909b ?)
   (#x90a0 ?)
   (#x90a1 ?)
   (#x90a2 ?)
   (#x90a5 ?)
   (#x90b0 ?)
   (#x90b2 ?)
   (#x90b3 ?)
   (#x90b4 ?)
   (#x90b6 ?)
   (#x90bd ?)
   (#x90be ?)
   (#x90c3 ?)
   (#x90c4 ?)
   (#x90c5 ?)
   (#x90c7 ?)
   (#x90c8 ?)
   (#x90cc ?)
   (#x90d2 ?)
   (#x90d5 ?)
   (#x90d7 ?)
   (#x90d8 ?)
   (#x90d9 ?)
   (#x90dc ?)
   (#x90dd ?)
   (#x90df ?)
   (#x90e5 ?)
   (#x90eb ?)
   (#x90ef ?)
   (#x90f0 ?)
   (#x90f4 ?)
   (#x90f6 ?)
   (#x90fe ?)
   (#x90ff ?)
   (#x9100 ?)
   (#x9104 ?)
   (#x9105 ?)
   (#x9106 ?)
   (#x9108 ?)
   (#x910d ?)
   (#x9110 ?)
   (#x9114 ?)
   (#x9116 ?)
   (#x9117 ?)
   (#x9118 ?)
   (#x911a ?)
   (#x911c ?)
   (#x911e ?)
   (#x9120 ?)
   (#x9122 ?)
   (#x9123 ?)
   (#x9125 ?)
   (#x9127 ?)
   (#x9129 ?)
   (#x912e ?)
   (#x912f ?)
   (#x9131 ?)
   (#x9134 ?)
   (#x9136 ?)
   (#x9137 ?)
   (#x9139 ?)
   (#x913a ?)
   (#x913c ?)
   (#x913d ?)
   (#x9143 ?)
   (#x9147 ?)
   (#x9148 ?)
   (#x914f ?)
   (#x9153 ?)
   (#x9157 ?)
   (#x9159 ?)
   (#x915a ?)
   (#x915b ?)
   (#x9161 ?)
   (#x9164 ?)
   (#x9167 ?)
   (#x916d ?)
   (#x9174 ?)
   (#x9179 ?)
   (#x917a ?)
   (#x917b ?)
   (#x9181 ?)
   (#x9183 ?)
   (#x9185 ?)
   (#x9186 ?)
   (#x918a ?)
   (#x918e ?)
   (#x9191 ?)
   (#x9193 ?)
   (#x9194 ?)
   (#x9195 ?)
   (#x9198 ?)
   (#x919e ?)
   (#x91a1 ?)
   (#x91a6 ?)
   (#x91a8 ?)
   (#x91ac ?)
   (#x91ad ?)
   (#x91ae ?)
   (#x91b0 ?)
   (#x91b1 ?)
   (#x91b2 ?)
   (#x91b3 ?)
   (#x91b6 ?)
   (#x91bb ?)
   (#x91bc ?)
   (#x91bd ?)
   (#x91bf ?)
   (#x91c2 ?)
   (#x91c3 ?)
   (#x91c5 ?)
   (#x91d3 ?)
   (#x91d4 ?)
   (#x91d7 ?)
   (#x91d9 ?)
   (#x91da ?)
   (#x91de ?)
   (#x91e4 ?)
   (#x91e5 ?)
   (#x91e9 ?)
   (#x91ea ?)
   (#x91ec ?)
   (#x91ed ?)
   (#x91ee ?)
   (#x91ef ?)
   (#x91f0 ?)
   (#x91f1 ?)
   (#x91f7 ?)
   (#x91f9 ?)
   (#x91fb ?)
   (#x91fd ?)
   (#x9200 ?)
   (#x9201 ?)
   (#x9204 ?)
   (#x9205 ?)
   (#x9206 ?)
   (#x9207 ?)
   (#x9209 ?)
   (#x920a ?)
   (#x920c ?)
   (#x9210 ?)
   (#x9212 ?)
   (#x9213 ?)
   (#x9216 ?)
   (#x9218 ?)
   (#x921c ?)
   (#x921d ?)
   (#x9223 ?)
   (#x9224 ?)
   (#x9225 ?)
   (#x9226 ?)
   (#x9228 ?)
   (#x922e ?)
   (#x922f ?)
   (#x9230 ?)
   (#x9233 ?)
   (#x9235 ?)
   (#x9236 ?)
   (#x9238 ?)
   (#x9239 ?)
   (#x923a ?)
   (#x923c ?)
   (#x923e ?)
   (#x9240 ?)
   (#x9242 ?)
   (#x9243 ?)
   (#x9246 ?)
   (#x9247 ?)
   (#x924a ?)
   (#x924d ?)
   (#x924e ?)
   (#x924f ?)
   (#x9251 ?)
   (#x9258 ?)
   (#x9259 ?)
   (#x925c ?)
   (#x925d ?)
   (#x9260 ?)
   (#x9261 ?)
   (#x9265 ?)
   (#x9267 ?)
   (#x9268 ?)
   (#x9269 ?)
   (#x926e ?)
   (#x926f ?)
   (#x9270 ?)
   (#x9275 ?)
   (#x9276 ?)
   (#x9277 ?)
   (#x9278 ?)
   (#x9279 ?)
   (#x927b ?)
   (#x927c ?)
   (#x927d ?)
   (#x927f ?)
   (#x9288 ?)
   (#x9289 ?)
   (#x928a ?)
   (#x928d ?)
   (#x928e ?)
   (#x9292 ?)
   (#x9297 ?)
   (#x9299 ?)
   (#x929f ?)
   (#x92a0 ?)
   (#x92a4 ?)
   (#x92a5 ?)
   (#x92a7 ?)
   (#x92a8 ?)
   (#x92ab ?)
   (#x92af ?)
   (#x92b2 ?)
   (#x92b6 ?)
   (#x92b8 ?)
   (#x92ba ?)
   (#x92bb ?)
   (#x92bc ?)
   (#x92bd ?)
   (#x92bf ?)
   (#x92c0 ?)
   (#x92c1 ?)
   (#x92c2 ?)
   (#x92c3 ?)
   (#x92c5 ?)
   (#x92c6 ?)
   (#x92c7 ?)
   (#x92c8 ?)
   (#x92cb ?)
   (#x92cc ?)
   (#x92cd ?)
   (#x92ce ?)
   (#x92d0 ?)
   (#x92d3 ?)
   (#x92d5 ?)
   (#x92d7 ?)
   (#x92d8 ?)
   (#x92d9 ?)
   (#x92dc ?)
   (#x92dd ?)
   (#x92df ?)
   (#x92e0 ?)
   (#x92e1 ?)
   (#x92e3 ?)
   (#x92e5 ?)
   (#x92e7 ?)
   (#x92e8 ?)
   (#x92ec ?)
   (#x92ee ?)
   (#x92f0 ?)
   (#x92f9 ?)
   (#x92fb ?)
   (#x92ff ?)
   (#x9300 ?)
   (#x9302 ?)
   (#x9308 ?)
   (#x930d ?)
   (#x9311 ?)
   (#x9314 ?)
   (#x9315 ?)
   (#x931c ?)
   (#x931d ?)
   (#x931e ?)
   (#x931f ?)
   (#x9321 ?)
   (#x9324 ?)
   (#x9325 ?)
   (#x9327 ?)
   (#x9329 ?)
   (#x932a ?)
   (#x9333 ?)
   (#x9334 ?)
   (#x9336 ?)
   (#x9337 ?)
   (#x9347 ?)
   (#x9348 ?)
   (#x9349 ?)
   (#x9350 ?)
   (#x9351 ?)
   (#x9352 ?)
   (#x9355 ?)
   (#x9357 ?)
   (#x9358 ?)
   (#x935a ?)
   (#x935e ?)
   (#x9364 ?)
   (#x9365 ?)
   (#x9367 ?)
   (#x9369 ?)
   (#x936a ?)
   (#x936d ?)
   (#x936f ?)
   (#x9370 ?)
   (#x9371 ?)
   (#x9373 ?)
   (#x9374 ?)
   (#x9376 ?)
   (#x937a ?)
   (#x937d ?)
   (#x937f ?)
   (#x9380 ?)
   (#x9381 ?)
   (#x9382 ?)
   (#x9388 ?)
   (#x938a ?)
   (#x938b ?)
   (#x938d ?)
   (#x938f ?)
   (#x9392 ?)
   (#x9395 ?)
   (#x9398 ?)
   (#x939b ?)
   (#x939e ?)
   (#x93a1 ?)
   (#x93a3 ?)
   (#x93a4 ?)
   (#x93a6 ?)
   (#x93a8 ?)
   (#x93a9 ?)
   (#x93ab ?)
   (#x93b4 ?)
   (#x93b5 ?)
   (#x93b6 ?)
   (#x93ba ?)
   (#x93c1 ?)
   (#x93c4 ?)
   (#x93c5 ?)
   (#x93c6 ?)
   (#x93c7 ?)
   (#x93c9 ?)
   (#x93ca ?)
   (#x93cb ?)
   (#x93cc ?)
   (#x93cd ?)
   (#x93d3 ?)
   (#x93d9 ?)
   (#x93dc ?)
   (#x93de ?)
   (#x93df ?)
   (#x93e2 ?)
   (#x93e6 ?)
   (#x93e7 ?)
   (#x93f7 ?)
   (#x93f8 ?)
   (#x93f9 ?)
   (#x93fa ?)
   (#x93fb ?)
   (#x93fd ?)
   (#x9401 ?)
   (#x9402 ?)
   (#x9404 ?)
   (#x9408 ?)
   (#x9409 ?)
   (#x940d ?)
   (#x940e ?)
   (#x940f ?)
   (#x9415 ?)
   (#x9416 ?)
   (#x9417 ?)
   (#x941f ?)
   (#x942e ?)
   (#x942f ?)
   (#x9431 ?)
   (#x9432 ?)
   (#x9433 ?)
   (#x9434 ?)
   (#x943b ?)
   (#x943d ?)
   (#x943f ?)
   (#x9443 ?)
   (#x9445 ?)
   (#x9448 ?)
   (#x944a ?)
   (#x944c ?)
   (#x9455 ?)
   (#x9459 ?)
   (#x945c ?)
   (#x945f ?)
   (#x9461 ?)
   (#x9463 ?)
   (#x9468 ?)
   (#x946b ?)
   (#x946d ?)
   (#x946e ?)
   (#x946f ?)
   (#x9471 ?)
   (#x9472 ?)
   (#x9483 ?)
   (#x9484 ?)
   (#x9578 ?)
   (#x9579 ?)
   (#x957e ?)
   (#x9584 ?)
   (#x9588 ?)
   (#x958c ?)
   (#x958d ?)
   (#x958e ?)
   (#x959d ?)
   (#x959e ?)
   (#x959f ?)
   (#x95a1 ?)
   (#x95a6 ?)
   (#x95a9 ?)
   (#x95ab ?)
   (#x95ac ?)
   (#x95b4 ?)
   (#x95b6 ?)
   (#x95ba ?)
   (#x95bd ?)
   (#x95bf ?)
   (#x95c6 ?)
   (#x95c8 ?)
   (#x95c9 ?)
   (#x95cb ?)
   (#x95d0 ?)
   (#x95d1 ?)
   (#x95d2 ?)
   (#x95d3 ?)
   (#x95d9 ?)
   (#x95da ?)
   (#x95dd ?)
   (#x95de ?)
   (#x95df ?)
   (#x95e0 ?)
   (#x95e4 ?)
   (#x95e6 ?)
   (#x961d ?)
   (#x961e ?)
   (#x9622 ?)
   (#x9624 ?)
   (#x9625 ?)
   (#x9626 ?)
   (#x962c ?)
   (#x9631 ?)
   (#x9633 ?)
   (#x9637 ?)
   (#x9638 ?)
   (#x9639 ?)
   (#x963a ?)
   (#x963c ?)
   (#x963d ?)
   (#x9641 ?)
   (#x9652 ?)
   (#x9654 ?)
   (#x9656 ?)
   (#x9657 ?)
   (#x9658 ?)
   (#x9661 ?)
   (#x966e ?)
   (#x9674 ?)
   (#x967b ?)
   (#x967c ?)
   (#x967e ?)
   (#x967f ?)
   (#x9681 ?)
   (#x9682 ?)
   (#x9683 ?)
   (#x9684 ?)
   (#x9689 ?)
   (#x9691 ?)
   (#x9696 ?)
   (#x969a ?)
   (#x969d ?)
   (#x969f ?)
   (#x96a4 ?)
   (#x96a5 ?)
   (#x96a6 ?)
   (#x96a9 ?)
   (#x96ae ?)
   (#x96af ?)
   (#x96b3 ?)
   (#x96ba ?)
   (#x96ca ?)
   (#x96d2 ?)
   (#x96d8 ?)
   (#x96da ?)
   (#x96dd ?)
   (#x96de ?)
   (#x96df ?)
   (#x96e9 ?)
   (#x96ef ?)
   (#x96f1 ?)
   (#x96fa ?)
   (#x9702 ?)
   (#x9703 ?)
   (#x9705 ?)
   (#x9709 ?)
   (#x971a ?)
   (#x971b ?)
   (#x971d ?)
   (#x9721 ?)
   (#x9722 ?)
   (#x9723 ?)
   (#x9728 ?)
   (#x9731 ?)
   (#x9733 ?)
   (#x9741 ?)
   (#x9743 ?)
   (#x974a ?)
   (#x974e ?)
   (#x974f ?)
   (#x9755 ?)
   (#x9757 ?)
   (#x9758 ?)
   (#x975a ?)
   (#x975b ?)
   (#x9763 ?)
   (#x9767 ?)
   (#x976a ?)
   (#x976e ?)
   (#x9773 ?)
   (#x9776 ?)
   (#x9777 ?)
   (#x9778 ?)
   (#x977b ?)
   (#x977d ?)
   (#x977f ?)
   (#x9780 ?)
   (#x9789 ?)
   (#x9795 ?)
   (#x9796 ?)
   (#x9797 ?)
   (#x9799 ?)
   (#x979a ?)
   (#x979e ?)
   (#x979f ?)
   (#x97a2 ?)
   (#x97ac ?)
   (#x97ae ?)
   (#x97b1 ?)
   (#x97b2 ?)
   (#x97b5 ?)
   (#x97b6 ?)
   (#x97b8 ?)
   (#x97b9 ?)
   (#x97ba ?)
   (#x97bc ?)
   (#x97be ?)
   (#x97bf ?)
   (#x97c1 ?)
   (#x97c4 ?)
   (#x97c5 ?)
   (#x97c7 ?)
   (#x97c9 ?)
   (#x97ca ?)
   (#x97cc ?)
   (#x97cd ?)
   (#x97ce ?)
   (#x97d0 ?)
   (#x97d1 ?)
   (#x97d4 ?)
   (#x97d7 ?)
   (#x97d8 ?)
   (#x97d9 ?)
   (#x97db ?)
   (#x97dd ?)
   (#x97de ?)
   (#x97e0 ?)
   (#x97e1 ?)
   (#x97e4 ?)
   (#x97ef ?)
   (#x97f1 ?)
   (#x97f4 ?)
   (#x97f7 ?)
   (#x97f8 ?)
   (#x97fa ?)
   (#x9807 ?)
   (#x980a ?)
   (#x980d ?)
   (#x980e ?)
   (#x9814 ?)
   (#x9816 ?)
   (#x9819 ?)
   (#x981c ?)
   (#x981e ?)
   (#x9820 ?)
   (#x9823 ?)
   (#x9825 ?)
   (#x9826 ?)
   (#x982b ?)
   (#x982e ?)
   (#x982f ?)
   (#x9830 ?)
   (#x9832 ?)
   (#x9833 ?)
   (#x9835 ?)
   (#x983e ?)
   (#x9844 ?)
   (#x9847 ?)
   (#x984a ?)
   (#x9851 ?)
   (#x9852 ?)
   (#x9853 ?)
   (#x9856 ?)
   (#x9857 ?)
   (#x9859 ?)
   (#x985a ?)
   (#x9862 ?)
   (#x9863 ?)
   (#x9865 ?)
   (#x9866 ?)
   (#x986a ?)
   (#x986c ?)
   (#x98ab ?)
   (#x98ad ?)
   (#x98ae ?)
   (#x98b0 ?)
   (#x98b4 ?)
   (#x98b7 ?)
   (#x98b8 ?)
   (#x98ba ?)
   (#x98bb ?)
   (#x98bf ?)
   (#x98c2 ?)
   (#x98c5 ?)
   (#x98c8 ?)
   (#x98cc ?)
   (#x98e1 ?)
   (#x98e3 ?)
   (#x98e5 ?)
   (#x98e6 ?)
   (#x98e7 ?)
   (#x98ea ?)
   (#x98f3 ?)
   (#x98f6 ?)
   (#x9902 ?)
   (#x9907 ?)
   (#x9908 ?)
   (#x9911 ?)
   (#x9915 ?)
   (#x9916 ?)
   (#x9917 ?)
   (#x991a ?)
   (#x991b ?)
   (#x991c ?)
   (#x991f ?)
   (#x9922 ?)
   (#x9926 ?)
   (#x9927 ?)
   (#x992b ?)
   (#x9931 ?)
   (#x9932 ?)
   (#x9933 ?)
   (#x9934 ?)
   (#x9935 ?)
   (#x9939 ?)
   (#x993a ?)
   (#x993b ?)
   (#x993c ?)
   (#x9940 ?)
   (#x9941 ?)
   (#x9946 ?)
   (#x9947 ?)
   (#x9948 ?)
   (#x994d ?)
   (#x994e ?)
   (#x9954 ?)
   (#x9958 ?)
   (#x9959 ?)
   (#x995b ?)
   (#x995c ?)
   (#x995e ?)
   (#x995f ?)
   (#x9960 ?)
   (#x999b ?)
   (#x999d ?)
   (#x999f ?)
   (#x99a6 ?)
   (#x99b0 ?)
   (#x99b1 ?)
   (#x99b2 ?)
   (#x99b5 ?)
   (#x99b9 ?)
   (#x99ba ?)
   (#x99bd ?)
   (#x99bf ?)
   (#x99c3 ?)
   (#x99c9 ?)
   (#x99d3 ?)
   (#x99d4 ?)
   (#x99d9 ?)
   (#x99da ?)
   (#x99dc ?)
   (#x99de ?)
   (#x99e7 ?)
   (#x99ea ?)
   (#x99eb ?)
   (#x99ec ?)
   (#x99f0 ?)
   (#x99f4 ?)
   (#x99f5 ?)
   (#x99f9 ?)
   (#x99fd ?)
   (#x99fe ?)
   (#x9a02 ?)
   (#x9a03 ?)
   (#x9a04 ?)
   (#x9a0b ?)
   (#x9a0c ?)
   (#x9a10 ?)
   (#x9a11 ?)
   (#x9a16 ?)
   (#x9a1e ?)
   (#x9a20 ?)
   (#x9a22 ?)
   (#x9a23 ?)
   (#x9a24 ?)
   (#x9a27 ?)
   (#x9a2d ?)
   (#x9a2e ?)
   (#x9a33 ?)
   (#x9a35 ?)
   (#x9a36 ?)
   (#x9a38 ?)
   (#x9a41 ?)
   (#x9a44 ?)
   (#x9a47 ?)
   (#x9a4a ?)
   (#x9a4b ?)
   (#x9a4c ?)
   (#x9a4e ?)
   (#x9a51 ?)
   (#x9a54 ?)
   (#x9a56 ?)
   (#x9a5d ?)
   (#x9aaa ?)
   (#x9aac ?)
   (#x9aae ?)
   (#x9aaf ?)
   (#x9ab2 ?)
   (#x9ab4 ?)
   (#x9ab5 ?)
   (#x9ab6 ?)
   (#x9ab9 ?)
   (#x9abb ?)
   (#x9abe ?)
   (#x9abf ?)
   (#x9ac1 ?)
   (#x9ac3 ?)
   (#x9ac6 ?)
   (#x9ac8 ?)
   (#x9ace ?)
   (#x9ad0 ?)
   (#x9ad2 ?)
   (#x9ad5 ?)
   (#x9ad6 ?)
   (#x9ad7 ?)
   (#x9adb ?)
   (#x9adc ?)
   (#x9ae0 ?)
   (#x9ae4 ?)
   (#x9ae5 ?)
   (#x9ae7 ?)
   (#x9ae9 ?)
   (#x9aec ?)
   (#x9af2 ?)
   (#x9af3 ?)
   (#x9af5 ?)
   (#x9af9 ?)
   (#x9afa ?)
   (#x9afd ?)
   (#x9aff ?)
   (#x9b00 ?)
   (#x9b01 ?)
   (#x9b02 ?)
   (#x9b03 ?)
   (#x9b04 ?)
   (#x9b05 ?)
   (#x9b08 ?)
   (#x9b09 ?)
   (#x9b0b ?)
   (#x9b0c ?)
   (#x9b0d ?)
   (#x9b0e ?)
   (#x9b10 ?)
   (#x9b12 ?)
   (#x9b16 ?)
   (#x9b19 ?)
   (#x9b1b ?)
   (#x9b1c ?)
   (#x9b20 ?)
   (#x9b26 ?)
   (#x9b2b ?)
   (#x9b2d ?)
   (#x9b33 ?)
   (#x9b34 ?)
   (#x9b35 ?)
   (#x9b37 ?)
   (#x9b39 ?)
   (#x9b3a ?)
   (#x9b3d ?)
   (#x9b48 ?)
   (#x9b4b ?)
   (#x9b4c ?)
   (#x9b55 ?)
   (#x9b56 ?)
   (#x9b57 ?)
   (#x9b5b ?)
   (#x9b5e ?)
   (#x9b61 ?)
   (#x9b63 ?)
   (#x9b65 ?)
   (#x9b66 ?)
   (#x9b68 ?)
   (#x9b6a ?)
   (#x9b6b ?)
   (#x9b6c ?)
   (#x9b6d ?)
   (#x9b6e ?)
   (#x9b73 ?)
   (#x9b75 ?)
   (#x9b77 ?)
   (#x9b78 ?)
   (#x9b79 ?)
   (#x9b7f ?)
   (#x9b80 ?)
   (#x9b84 ?)
   (#x9b85 ?)
   (#x9b86 ?)
   (#x9b87 ?)
   (#x9b89 ?)
   (#x9b8a ?)
   (#x9b8b ?)
   (#x9b8d ?)
   (#x9b8f ?)
   (#x9b90 ?)
   (#x9b94 ?)
   (#x9b9a ?)
   (#x9b9d ?)
   (#x9b9e ?)
   (#x9ba6 ?)
   (#x9ba7 ?)
   (#x9ba9 ?)
   (#x9bac ?)
   (#x9bb0 ?)
   (#x9bb1 ?)
   (#x9bb2 ?)
   (#x9bb7 ?)
   (#x9bb8 ?)
   (#x9bbb ?)
   (#x9bbc ?)
   (#x9bbe ?)
   (#x9bbf ?)
   (#x9bc1 ?)
   (#x9bc7 ?)
   (#x9bc8 ?)
   (#x9bce ?)
   (#x9bd0 ?)
   (#x9bd7 ?)
   (#x9bd8 ?)
   (#x9bdd ?)
   (#x9bdf ?)
   (#x9be5 ?)
   (#x9be7 ?)
   (#x9bea ?)
   (#x9beb ?)
   (#x9bef ?)
   (#x9bf3 ?)
   (#x9bf7 ?)
   (#x9bf8 ?)
   (#x9bf9 ?)
   (#x9bfa ?)
   (#x9bfd ?)
   (#x9bff ?)
   (#x9c00 ?)
   (#x9c02 ?)
   (#x9c0b ?)
   (#x9c0f ?)
   (#x9c11 ?)
   (#x9c16 ?)
   (#x9c18 ?)
   (#x9c19 ?)
   (#x9c1a ?)
   (#x9c1c ?)
   (#x9c1e ?)
   (#x9c22 ?)
   (#x9c23 ?)
   (#x9c26 ?)
   (#x9c27 ?)
   (#x9c28 ?)
   (#x9c29 ?)
   (#x9c2a ?)
   (#x9c31 ?)
   (#x9c35 ?)
   (#x9c36 ?)
   (#x9c37 ?)
   (#x9c3d ?)
   (#x9c41 ?)
   (#x9c43 ?)
   (#x9c44 ?)
   (#x9c45 ?)
   (#x9c49 ?)
   (#x9c4a ?)
   (#x9c4e ?)
   (#x9c4f ?)
   (#x9c50 ?)
   (#x9c53 ?)
   (#x9c54 ?)
   (#x9c56 ?)
   (#x9c58 ?)
   (#x9c5b ?)
   (#x9c5c ?)
   (#x9c5d ?)
   (#x9c5e ?)
   (#x9c5f ?)
   (#x9c63 ?)
   (#x9c68 ?)
   (#x9c69 ?)
   (#x9c6a ?)
   (#x9c6b ?)
   (#x9c6e ?)
   (#x9c70 ?)
   (#x9c72 ?)
   (#x9c75 ?)
   (#x9c77 ?)
   (#x9c7b ?)
   (#x9ce6 ?)
   (#x9cf2 ?)
   (#x9cf7 ?)
   (#x9cf9 ?)
   (#x9d02 ?)
   (#x9d0b ?)
   (#x9d11 ?)
   (#x9d17 ?)
   (#x9d18 ?)
   (#x9d1c ?)
   (#x9d1d ?)
   (#x9d1e ?)
   (#x9d2f ?)
   (#x9d30 ?)
   (#x9d32 ?)
   (#x9d33 ?)
   (#x9d34 ?)
   (#x9d3a ?)
   (#x9d3c ?)
   (#x9d3d ?)
   (#x9d42 ?)
   (#x9d43 ?)
   (#x9d45 ?)
   (#x9d47 ?)
   (#x9d4a ?)
   (#x9d53 ?)
   (#x9d54 ?)
   (#x9d5f ?)
   (#x9d62 ?)
   (#x9d63 ?)
   (#x9d65 ?)
   (#x9d69 ?)
   (#x9d6a ?)
   (#x9d6b ?)
   (#x9d70 ?)
   (#x9d76 ?)
   (#x9d77 ?)
   (#x9d7b ?)
   (#x9d7c ?)
   (#x9d7e ?)
   (#x9d83 ?)
   (#x9d84 ?)
   (#x9d86 ?)
   (#x9d8a ?)
   (#x9d8d ?)
   (#x9d8e ?)
   (#x9d92 ?)
   (#x9d93 ?)
   (#x9d95 ?)
   (#x9d96 ?)
   (#x9d97 ?)
   (#x9d98 ?)
   (#x9da1 ?)
   (#x9daa ?)
   (#x9dac ?)
   (#x9dae ?)
   (#x9db1 ?)
   (#x9db5 ?)
   (#x9db9 ?)
   (#x9dbc ?)
   (#x9dbf ?)
   (#x9dc3 ?)
   (#x9dc7 ?)
   (#x9dc9 ?)
   (#x9dca ?)
   (#x9dd4 ?)
   (#x9dd5 ?)
   (#x9dd6 ?)
   (#x9dd7 ?)
   (#x9dda ?)
   (#x9dde ?)
   (#x9ddf ?)
   (#x9de0 ?)
   (#x9de5 ?)
   (#x9de7 ?)
   (#x9de9 ?)
   (#x9deb ?)
   (#x9dee ?)
   (#x9df0 ?)
   (#x9df3 ?)
   (#x9df4 ?)
   (#x9dfe ?)
   (#x9e02 ?)
   (#x9e07 ?)
   (#x9e0a ?)
   (#x9e0e ?)
   (#x9e10 ?)
   (#x9e11 ?)
   (#x9e12 ?)
   (#x9e15 ?)
   (#x9e16 ?)
   (#x9e19 ?)
   (#x9e1c ?)
   (#x9e1d ?)
   (#x9e7a ?)
   (#x9e7b ?)
   (#x9e7c ?)
   (#x9e80 ?)
   (#x9e82 ?)
   (#x9e83 ?)
   (#x9e84 ?)
   (#x9e85 ?)
   (#x9e87 ?)
   (#x9e8e ?)
   (#x9e8f ?)
   (#x9e96 ?)
   (#x9e98 ?)
   (#x9e9b ?)
   (#x9e9e ?)
   (#x9ea4 ?)
   (#x9ea8 ?)
   (#x9eac ?)
   (#x9eae ?)
   (#x9eaf ?)
   (#x9eb0 ?)
   (#x9eb3 ?)
   (#x9eb4 ?)
   (#x9eb5 ?)
   (#x9ec6 ?)
   (#x9ec8 ?)
   (#x9ecb ?)
   (#x9ed5 ?)
   (#x9edf ?)
   (#x9ee4 ?)
   (#x9ee7 ?)
   (#x9eec ?)
   (#x9eed ?)
   (#x9eee ?)
   (#x9ef0 ?)
   (#x9ef1 ?)
   (#x9ef2 ?)
   (#x9ef5 ?)
   (#x9ef8 ?)
   (#x9eff ?)
   (#x9f02 ?)
   (#x9f03 ?)
   (#x9f09 ?)
   (#x9f0f ?)
   (#x9f10 ?)
   (#x9f11 ?)
   (#x9f12 ?)
   (#x9f14 ?)
   (#x9f16 ?)
   (#x9f17 ?)
   (#x9f19 ?)
   (#x9f1a ?)
   (#x9f1b ?)
   (#x9f1f ?)
   (#x9f22 ?)
   (#x9f26 ?)
   (#x9f2a ?)
   (#x9f2b ?)
   (#x9f2f ?)
   (#x9f31 ?)
   (#x9f32 ?)
   (#x9f34 ?)
   (#x9f37 ?)
   (#x9f39 ?)
   (#x9f3a ?)
   (#x9f3c ?)
   (#x9f3d ?)
   (#x9f3f ?)
   (#x9f41 ?)
   (#x9f43 ?)
   (#x9f44 ?)
   (#x9f45 ?)
   (#x9f46 ?)
   (#x9f47 ?)
   (#x9f53 ?)
   (#x9f55 ?)
   (#x9f56 ?)
   (#x9f57 ?)
   (#x9f58 ?)
   (#x9f5a ?)
   (#x9f5d ?)
   (#x9f5e ?)
   (#x9f68 ?)
   (#x9f69 ?)
   (#x9f6d ?)
   (#x9f6e ?)
   (#x9f6f ?)
   (#x9f70 ?)
   (#x9f71 ?)
   (#x9f73 ?)
   (#x9f75 ?)
   (#x9f7a ?)
   (#x9f7d ?)
   (#x9f8f ?)
   (#x9f90 ?)
   (#x9f91 ?)
   (#x9f92 ?)
   (#x9f94 ?)
   (#x9f96 ?)
   (#x9f97 ?)
   (#x9f9e ?)
   (#x9fa1 ?)
   (#x9fa2 ?)
   (#x9fa3 ?)
   (#x9fa5 ?)
   (#xff5e ?)))

;;; arch-tag: 7f320453-b293-4159-af5e-6f0bab03048c
;;; subst-jis.el ends here
