#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export VERMAJ=`echo $VER | sed -e 's/^\([[:alnum:]]*\)\..*$/\1/'`
export VERMIN=`echo $VER | sed -e 's/^.*\.\([[:alnum:]]*\)\..*$/\1/'`
export FULLPKG=${PKG}-${VER}-${REL}
export PKG2=lib${PKG}${VERMAJ}.${VERMIN}
export PKG3=lib${PKG}${VERMAJ}.${VERMIN}-devel
# if the orig src package is bzip2'ed, remember to
# change 'z' to 'j' in the 'tar xvzf' commands in the
# prep) and mkpatch) sections
export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg2_name=${PKG2}-${VER}-${REL}.tar.bz2
export bin_pkg3_name=${PKG3}-${VER}-${REL}.tar.bz2
export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg2_name}
export bin_pkg3=${topdir}/${bin_pkg3_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
MY_CFLAGS=
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} ; \
  mkdirs )
}
conf() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ../dist/configure --target=${target} \
  --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --bindir=${prefix}/bin --libdir=${prefix}/lib \
  --includedir=${prefix}/include/db${VERMAJ}.${VERMIN} \
  --datadir=${prefix}/share --mandir=${prefix}/share/man \
  --infodir=${prefix}/share/info \
  --libexecdir='${sbindir}' --localstatedir=/var \
  --program-transform-name="s,^db_,db${VERMAJ}.${VERMIN}_," \
  --enable-cxx --enable-compat185 --disable-test 
)
}
build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" make )
}
check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} 
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  if [ -d ${instdir}${prefix}/share/doc/${PKG}-${VER} ]; then \
    rm -rf ${instdir}${prefix}/share/doc/${PKG}-${VER} 
  fi && \
  if [ -d ${instdir}${prefix}/share/doc/${PKG3}-${VER} ]; then \
    rm -rf ${instdir}${prefix}/share/doc/${PKG3}-${VER} 
  fi && \
  mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER} && \
  mkdir -p ${instdir}${prefix}/share/doc/${PKG3}-${VER} && \
  for f in ${instdir}${prefix}/share/doc/db/* ; do
    mv $f ${instdir}${prefix}/share/doc/${PKG}-${VER}/
  done && \
  rmdir ${instdir}${prefix}/share/doc/db && \
  mv ${instdir}${prefix}/share/doc/${PKG}-${VER}/utility \
     ${instdir}${prefix}/share/doc/${PKG3}-${VER}/ && \
  if [ ! -d ${instdir}${prefix}/share/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${sysconfdir}/postinstall ]; then \
    mkdir -p ${instdir}${sysconfdir}/postinstall ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/LICENSE ${srcdir}/README ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG3}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
         ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
         ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README && \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
    ${instdir}${sysconfdir}/postinstall/libdb${VERMAJ}.${VERMIN}-devel.sh ; && \
  for i in archive deadlock load recover upgrade checkpoint dump printlog \
    stat verify ; do mv ${instdir}${prefix}/bin/db_${i}.exe ${instdir}${prefix}/bin/db${VERMAJ}.${VERMIN}_${i}.exe ; done ;
)
}
strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 )
}
pkg() {
  (cd ${instdir} && find . -type f | xargs touch && \
  tar cvjf ${bin_pkg} --exclude="${pnoslash}/bin" \
    --exclude="${snoslash}/etc" \
    --exclude="${pnoslash}/include" \
    --exclude="${pnoslash}/lib" \
    --exclude="${snoslash}/postinstall" \
    --exclude="${pnoslash}/share/doc/${PKG3}*" \
    --exclude="${pnoslash}/share/doc/Cygwin/${PKG3}*" \
	 * ;
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll ;
  tar cvjf ${bin_pkg3} ${pnoslash}/bin/*.exe \
    ${pnoslash}/include ${pnoslash}/lib ${snoslash}/postinstall \
    ${pnoslash}/share/doc/${PKG3}* ${pnoslash}/share/doc/Cygwin/${PKG3}* )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' -x 'autom4te.cache' -x 'configure.lineno' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  cbisps) conf && build && install && \
     strip && pkg && spkg ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
