#!/bin/sh
# cygwin-doc.sh
# requires "mkshortcut" from cygutils

# Install info updates
PREFIX=/usr/share
INFODIR=${PREFIX}/info
cd ${INFODIR}
for i in cygwin.info libc.info libm.info; do
  /usr/bin/install-info --dir-file=${INFODIR}/dir --info-file=${i}
done

MKS=/usr/bin/mkshortcut
if [ ! -f $MKS ]; then
	echo "$0: This script requires mkshortcut from cygutils"
	exit 1
fi
# determine if there is a Start Menu "Cygwin" directory, put links if so
CYGWIN_ASM="$(/bin/cygpath -AP)/Cygwin"
CYGWIN_SM="$(/bin/cygpath -P)/Cygwin"
if [ -d "$CYGWIN_ASM" ]; then
	FLAG="-AP"
elif [ -d "$CYGWIN_SM" ]; then
	FLAG="-P"
else
	exit 0
fi

DIR=/usr/share/doc/cygwin-doc-1.3

$MKS $FLAG -n "Cygwin/Cygwin FAQ" $DIR/html/faq.html
$MKS $FLAG -n "Cygwin/User's Guide" $DIR/html/cygwin-ug-net/cygwin-ug-net.html
$MKS $FLAG -n "Cygwin/User's Guide (One file)" $DIR/cygwin-ug-net-nochunks.html
$MKS $FLAG -n "Cygwin/User's Guide (PDF)" $DIR/cygwin-ug-net.pdf
$MKS $FLAG -n "Cygwin/Cygwin API Reference" $DIR/html/cygwin-api/cygwin-api.html
