#!perl -w
# $Id: platform.pl,v 1.4 2004/09/30 07:34:13 jlinoff Exp $
#
# This tool creates a directory tree.
#
# Usage: perl dtree.pl <directory>
#
use strict;
use Config;
&Main;

# ================================================
# MAIN
# ================================================
sub Main {
  while ( $#ARGV >= 0 ) {
    my $arg = shift @ARGV;
    if ( $arg eq "-version" ) {
      my $X = "\$";
      print "\$Id: platform.pl,v 1.4 2004/09/30 07:34:13 jlinoff Exp $X\n";
      exit 0;
    }
    elsif ( $arg eq "-h" || $arg eq "-help" ) {
      &Help;
      exit 0;
    }
    else {
      print STDERR "ERROR: Unrecognized switch.\n";
      print STDERR "       Use the -h switch to get more information.\n";
      print STDERR "\n";
      exit 1;
    }
  }
  my $osn = $Config{'archname'}; # issue 0141: jdl 2003/01/21
  my $osv = $Config{'osvers'};
  $osv = "$1$2" if ($osv =~ /(.*)\(.*\)(.*)/);  # issue 0079: bzoe 10/18/01
  $osv =~ s/[\+\*]/-/g; # These cause pattern matching problems in perl.
  print "$osn-$osv\n";
}
# ================================================
# Help
# ================================================
sub Help {
  my $X = "\$";
  print <<END

\$Id: platform.pl,v 1.4 2004/09/30 07:34:13 jlinoff Exp $X

usage: perl platform.pl [-h] [-help] [-version]

  -h
  -help     On-line help.

  -version  Print the program version and exit.

examples\:

  prompt> perl platform.pl
  MSWin32

END
}
