#!perl
# $Id: makedepend.pl,v 1.2 2004/09/30 07:34:13 jlinoff Exp $
#
# Walk over the source files and generate the local dependencies.
#
use strict;

my %depends = ();

&Main;

# ================================================
# MAIN
# ================================================
sub Main
  {
    my @files = ();
    while ( $#ARGV >= 0 ) {
      my $arg = shift @ARGV;
      push @files,$arg;
    }
    my $file;

    # ================================================
    # Print the objs target.
    # ================================================
    print "OBJS =";
    foreach $file ( @files ) {
      my $obj = $file;
      $obj =~ s/\.cc$/\.\${OBJ_EXT}/;
      print " \\\n\t\${BIN_DIR}/$obj";
    }
    print "\n";
    print "\n";

    # ================================================
    # Print the dependencies.
    # ================================================
    foreach $file ( @files ) {
      %depends = ();
      &process_file( $file );
      my $obj = $file;
      $obj =~ s/\.cc$/\.\${OBJ_EXT}/;
      print "\${BIN_DIR}/${obj} : $file";
      my $key;
      foreach $key ( sort keys %depends ) {
	print " \\\n\t$key";
      }
      print "\n";
      print "\t\@echo \"================================================\"\n";
      print "\t\@echo \"Compiling \$\@\"\n";
      print "\t\${CXX} \${CXX_FLAGS} \${CXX_OUT}\$\@ ${file}\n";
      print "\n";
    }
  }
sub process_file
  {
    my $file = shift;
    my @includes = ();
    open FP,"$file" || die "ERROR: !*";
    while( <FP> ) {
      if( /^\s*\#\s*include\s+\"([^\"]+)/ ) {
	push @includes,$1;
      }
    }
    close FP;
    my $include;
    foreach $include ( @includes ) {
      if( ! defined $depends{$include} ) {
	$depends{$include} = 1;
	&process_file($include);
      }
    }
  }
