'\"
'\" Copyright 1998 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Tabset widget created by George Howlett.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.3 2001/02/17 07:46:19 ghowlett Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.ft CW
.sp
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
.ft R
.sp
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH tabset n 3.0 BLT "BLT Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tabset \- Create and manipulate tabset widgets
.BE
.SH SYNOPSIS
\fBtabset\fR \fIpathName \fR?\fIoptions\fR?
.SH DESCRIPTION
The \fBtabset\fR widget displays a series of overlapping folders. Only
the contents of one folder at a time is displayed.  By clicking on the
tab's of a folder, you can view other folders.  Each folder may
contain any Tk widget that can be automatically positioned and resized
in the folder.
.PP
There's no limit to the number of folders.  Tabs can be tiered or
scrolled.  Pages (i.e. embedded widgets) can be torn off and displayed
in another toplevel widget, and also restored.  A tabset can also be
used as just a set of tabs, without a displaying any pages.  You can
bind events to individual tabs, so it's easy to add features like
"balloon help".
.SH INTRODUCTION
Notebooks are a popular graphical paradigm.  They allow you to organize
several windows that are too big to display at the same time as 
pages of a notebook.  For example, your application may display several 
X-Y graphs at the same time.  The graphs are too big to pack into the 
same frame.  Managing them in several \fBtoplevel\fR widgets is
also cumbersome and clutters the screen.  Instead, the \fBtabset\fR widget 
organizes the graphs as folders in a notebook.  
.PP
Only one page is visible at a time. When you click on a tab, 
the folder corresponding to the tab is displayed in the  \fBtabset\fR 
widget.  The tabset also lets you temporarily tear pages 
out of the notebook into a separate toplevel widget, and put them back 
in the tabset later.  For example, you could compare two graphs side-by-side 
by tearing them out, and then replace them when you are finished.
.PP
A tabset can contain any number of folders.  If there are too
many tabs to view, you can arrange them as multiple tiers or scroll
the tabs. You can also attach Tk scrollbars to the tabset to scroll the tabs.
.SH SYNTAX
The \fBtabset\fR command creates a new window using the \fIpathName\fR
argument and makes it into a tabset widget.
.DS
\fBtabset \fIpathName \fR?\fIoption value\fR?...
.DE
Additional options may be specified on the command line or in the
option database to configure aspects of the tabset such as its colors,
font, text, and relief.  The \fBtabset\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked, there
must not exist a window named \fIpathName\fR, but \fIpathName\fR's
parent must exist.
.PP
When first created, a new tabset contains no tabs.  Tabs are added or
deleted using widget operations described below. It is not necessary
for all the tabs to be displayed in the tabset window at once;
commands described below may be used to change the view in the window.
Tabsets allow scrolling of tabs using the \fB\-scrollcommand\fR
option.  They also support scanning (see the \fBscan\fR operation).
Tabs may be arranged along any side of the tabset window using the
\fB\-side\fR option.
.PP
The size of the tabset window is determined the number of tiers of
tabs and the sizes of the Tk widgets embedded inside each folder.
The widest widget determines the width of the folder. The tallest
determines the height.  If no folders contain an embedded widget, the
size is detemined solely by the size of the tabs.  
.PP
You can override either dimension with the tabset's \fB\-width\fR
and \fB\-height\fR options.
.SH "INDICES"
Indices refer to individual tabs/folders in the tabset.  Many of
the operations for tabset widgets take one or more indices as
arguments.  An index may take several forms:
.TP 12
\fInumber\fR 
Unique node id of the tab.
.TP 12
\fB@\fIx\fB,\fIy\fR
Tab that covers the point in the tabset window
specified by \fIx\fR and \fIy\fR (in screen coordinates).  If no
tab covers that point, then the index is ignored.
.TP 12
\fBselect\fR 
The currently selected tab.  The \fBselect\fR index is 
typically changed by either clicking on the tab with the left mouse 
button or using the widget's \fBinvoke\fR operation.
.TP 12
\fBactive\fR 
The tab where the mouse pointer is currently located.  The label 
is drawn using its active colors (see the \fB\-activebackground\fR and
\fB\-activeforeground\fR options).  The \fBactive\fR index is typically
changed by moving the mouse pointer over a tab or using the widget's
\fBactivate\fR operation. There can be only one active tab at a time.
If there is no tab located under the mouse pointer, the index
is ignored.
.TP 12
\fBfocus\fR 
Tab that currently has the widget's focus.
This tab is displayed with a dashed line around its label.  You can
change this using the \fBfocus\fR operation. If no tab has focus,
then the index is ignored.
.TP 12
\fBdown\fR 
Tab immediately below the tab that currently has focus,
if there is one. If there is no tab below, the current 
tab is returned.
.TP 12
\fBleft\fR
Tab immediately to the left the tab that currently has focus,
if there is one.  If there is no tab to the left, the current 
tab is returned.
.TP 12
\fBright\fR 
Tab immediately to the right the tab that currently has focus, if
there is one. If there is no tab to the right, the current tab is
returned.
.TP 12
\fBup\fR 
Tab immediately above, if there is one, to the tab that currently has
focus. If there is no tab above, the current tab is returned.
.TP 12
\fBend\fR
Last tab in the tabset.  If there are no tabs in the tabset then the
index is ignored.
.LP
Some indices may not always be available.  For example, if the mouse
is not over any tab, "active" does not have an index.  For most
tabset operations this is harmless and ignored.  
.SH "OPERATIONS"
All \fBtabset\fR operations are invoked by specifying the widget's
pathname, the operation, and any arguments that pertain to that
operation.  The general form is:
.sp
.DS
	\fIpathName operation \fR?\fIarg arg ...\fR?
.DE
.sp
\fIOperation\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following operations are available for tabset widgets:
.TP
\fIpathName \fBactivate\fR \fIindex\fR 
Sets the active tab to the one indicated by \fIindex\fR.  The
active tab is drawn with its \fIactive\fR colors (see the
\fB\-activebackground\fR and \fB\-activeforeground\fR options) and may
be retrieved with the index \fBactive\fR.  Only one tab may be active
at a time.  If \fIindex\fR is the empty string, then all tabs will
be drawn with their normal foreground and background colors.
.TP
\fIpathName \fBbind\fR \fItagName\fR ?\fIsequence\fR? ?\fIcommand\fR? 
Associates \fIcommand\fR with \fItagName\fR such that whenever the
event sequence given by \fIsequence\fR occurs for a tab with this
tag, \fIcommand\fR will be invoked.  The syntax is similar to the 
\fBbind\fR command except that it operates on tabs, rather 
than widgets. See the \fBbind\fR manual entry for
complete details on \fIsequence\fR and the substitutions performed on 
\fIcommand\fR.  
.sp
If all arguments are specified then a new binding is created, replacing 
any existing binding for the same \fIsequence\fR and \fItagName\fR.
If the first character of \fIcommand\fR is \f(CW+\fR then \fIcommand\fR 
augments an existing binding rather than replacing it. 
If no \fIcommand\fR argument is provided then the command currently
associated with \fItagName\fR and \fIsequence\fR (it's an error occurs 
if there's no such binding) is returned.  If both \fIcommand\fR and 
\fIsequence\fR are missing then a list of all the event sequences for 
which bindings have been defined for \fItagName\fR. 
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described in the section
.SB "WIDGET OPTIONS" 
below.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all 
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described in the section
.SB "WIDGET OPTIONS" 
below.
.TP
\fIpathName \fBdelete \fIfirst \fR?\fIlast\fR?
Deletes one or more tabs from the tabset.  \fIFirst\fR and \fIlast\fR
are the first and last indices, defining a range of tabs to be deleted.  
If \fIlast\fR isn't specified, then only the tab at \fIfirst\fR 
is deleted.
.TP
\fIpathName \fBfocus \fIindex\fR
Designates a tab to get the widget's focus.  This tab is displayed 
with a dashed line around its label. 
.TP
\fIpathName \fBget\fR \fIindex\fR
Returns the name of the tab.  The value of \fIindex\fR may
be in any form described in the section
.SB "INDICES".
.TP
\fIpathName \fBindex\fR ?\fIflag\fR? \fIstring\fR 
Returns the node id of the tab specified by \fIstring\fR.  If
\fIflag\fR is \fB\-name\fR, then \fIstring\fR is the name of a tab.
If \fIflag\fR is \fB\-index\fR, \fIstring\fR is an index such as
"active" or "focus".  If \fIflag\fR isn't specified, it defaults to
\fB\-index\fR.
.TP
\fIpathName \fBinsert\fR \fIposition \fIname\fR ?\fIoption value\fR?...
Inserts new tabs into the tabset.  Tabs are inserted just before the
tab given by \fIposition\fR.  \fIPosition\fR may be either a number,
indicating where in the list the new tab should be added, or \fBend\fR,
indicating that the new tab is to be added the end of the list.  
\fIName\fR is the symbolic name of the tab. \fIBe careful not to use 
a number. Otherwise the tabset will confuse it with tab indices\fR.  Returns 
a list of indices for all the new tabs.
.TP
\fIpathName \fBinvoke \fIindex\fR
Selects the tab given by \fIindex\fR, maps the tab's embedded widget, and 
invokes the Tcl command associated with the tab, if  there  is  one.  
The return value is the return value from the Tcl command, or an empty
string  if there  is  no  command  associated with the tab.
This command is ignored if the  tab's state (see the \fB\-state\fR option)
is disabled.
.TP
\fIpathName \fBmove\fR \fIindex\fR \fBbefore\fR|\fBafter\fR \fIindex\fR
Moves the tab \fIindex\fR to a new position in the tabset.
.TP
\fIpathName \fBnearest\fR \fIx\fR \fIy\fR
Returns the name of the tab nearest to given X-Y screen coordinate.
.TP
\fIpathName \fBperforation \fIoperation\fR ?\fIargs\fR?
This operation controls the perforation on the tab label.
.RS
.TP
\fIpathName \fBperforation highlight\fR \fIindex\fR \fIboolean\fR
.TP
\fIpathName \fBperforation invoke\fR \fIindex\fR
Invokes the command specified for perforations (see the 
\fB\-perforationcommand\fR widget option). Typically this command
places the page into a top level widget. The name of the toplevel
is the concatonation of the \fIpathName\fR, "-",  and the \fItabName\fR.
The return value is the return value from the Tcl command, or an empty
string  if there  is  no  command  associated with the tab.
This command is ignored if the  tab's state (see the \fB\-state\fR option)
is disabled.
.RE
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command implements scanning on tabsets.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
Records \fIx\fR and \fIy\fR and the current view in the tabset
window;  used with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget.  It returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR.
This command computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR command for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the list at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBsee \fIindex\fR 
Scrolls the tabset so that the tab
\fIindex\fR is visible in the widget's window.
.TP
\fIpathName \fBsize\fR
Returns the number of tabs in the tabset.
.TP
\fIpathName \fBtab \fIoperation\fR ?\fIargs\fR?
.RS
.TP
\fIpathName \fBtab cget\fR \fInameOrIndex\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBtab configure\fR
operation described in the section 
.SB "TAB OPTIONS"
below.
.TP
\fIpathName \fBtab configure\fR \fInameOrIndex\fR ?\fInameOrIndex\fR...? \fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of one or more tabs.
If no \fIoption\fR is specified, this operation returns a list 
describing all the available options for \fInameOrIndex\fR.  
\fINameOrIndex\fR can be either the name of a tab or its index.  Names
of tabs take precedence over their indices.  That means a tab named 
\fIfocus\fR is picked over the "focus" tab.
.sp
If \fIoption\fR is specified, but not \fIvalue\fR, then a list describing the
one named option is returned.  If  one or more \fIoption\-value\fR pairs 
are specified, then each named tab (specified by \fInameOrIndex\fR) will
have its configurations option(s) set the given value(s).  In
this last case, the empty string is returned.
\fIOption\fR and \fIvalue\fR are described in the section 
.SB "TAB OPTIONS"
below.
.TP
\fIpathName \fBtab names\fR ?\fIpattern\fR?
Returns the names of all the tabs matching the given pattern. If
no \fIpattern\fR argument is provided, then all tab names are returned.
.TP
\fIpathName \fBtab tearoff \fIindex\fR ?\fInewName\fR?
Reparents the widget embedded into \fIindex\fR, placing
it inside of \fInewName\fR.  \fINewName\fR is either the name of
an new widget that will contain the embedded widget or the name
of the \fBtabset\fR widget.  It the last case, the embedded widget
is put back into the folder.
.sp
If no \fInewName\fR argument is provided, then the name of the current
parent of the embedded widget is returned.
.RE
.TP
\fIpathName \fBview \fIargs\fR
This command queries or changes the position of the
tabset in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName \fBview\fR 
Returns a list of two numbers between 0.0 and
1.0 that describe the amount and position of the tabset that is
visible in the window.  For example, if \fIview\fR is "0.2 0.6", 20%
of the tabset's text is off-screen to the left, 40% is visible in the
window, and 40% of the tabset is off-screen to the right.  These are
the same values passed to scrollbars via the \fB\-scrollcommand\fR
option.
.TP
\fIpathName \fBview moveto\fI fraction\fR
Adjusts the view in the window so that \fIfraction\fR of the
total width of the tabset text is off-screen to the left.
\fIfraction\fR must be a number between 0.0 and 1.0.
.TP
\fIpathName \fBview scroll \fInumber what\fR 
This command shifts the view in the window (left/top or right/bottom)
according to \fInumber\fR and \fIwhat\fR.  \fINumber\fR must be an
integer. \fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an
abbreviation of these.  If \fIwhat\fR is \fBunits\fR, the view adjusts
left or right by \fInumber\fR scroll units (see the
\fB\-scrollincrement\fR option).  ; if it is \fBpages\fR then the view
adjusts by \fInumber\fR widget windows.  If \fInumber\fR is negative
then tabs farther to the left become visible; if it is positive then
tabs farther to the right become visible.
.RE
.SH "WIDGET OPTIONS"
Widget configuration options may be set either by the \fBconfigure\fR 
operation or the Tk \fBoption\fR command.  The resource class
is \f(CWTabset\fR.  The resource name is the name of the widget.
.CS
option add *Tabset.Foreground white
option add *Tabset.Background blue
.CE
The following widget options are available:
.TP
\fB\-activebackground \fIcolor\fR
Sets the default active background color for tabs.  A tab is active
when the mouse is positioned over it or set by the \fBactivate\fR
operation.  Individual tabs may override this option by setting the 
tab's \fB\-activebackground\fR option. 
.TP
\fB\-activeforeground \fIcolor\fR
Sets the default active foreground color for tabs.  A tab is active
when the mouse is positioned over it or set by the \fBactivate\fR
operation.  Individual tabs may override this option by setting the
tab's \fB\-activeforeground\fR option.
.TP
\fB\-background \fIcolor\fR
Sets the background color of the tabset.  
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the widget.  The
\fB\-relief\fR option determines how the border is to be drawn.  The
default is \f(CW2\fR.
.TP
\fB\-cursor \fIcursor\fR
Specifies the widget's cursor.  The default cursor is \f(CW""\fR.
.TP
\fB\-dashes \fIdashList\fR
Sets the dash style of the focus outline.  When a tab has the widget's
focus, it is drawn with a dashed outline around its label.  
\fIDashList\fR is a list of up
to 11 numbers that alternately represent the lengths of the dashes
and gaps on the cross hair lines.  Each number must be between 1 and
255.  If \fIdashList\fR is \f(CW""\fR, the outline will be a solid
line.  The default value is \f(CW5 2\fR.
.TP
\fB\-font \fIfontName\fR 
Sets the default font for the text in tab labels.  Individual tabs may
override this by setting the tab's \fB\-font\fR option.  The default value is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR 
Sets the default color of tab labels.  Individual tabs may
override this option by setting the tab's \fB\-foreground\fR option.  
The default value is \f(CWblack\fR.
.TP 
\fB\-gap \fIsize\fR
Sets the gap (in pixels) between tabs.  The default value is \f(CW2\fR.
.TP
\fB\-height \fIpixels\fR
Specifies the requested height of widget.  If \fIpixels\fR is
0, then the height of the widget will be calculated based on
the size the tabs and their pages.
The default is \f(CW0\fR.
.TP 
\fB\-highlightbackground  \fIcolor\fR
Sets the color to display in the traversal highlight region when
the tabset does not have the input focus.  
.TP 
\fB\-highlightcolor \fIcolor\fR
Sets the color to use for the traversal highlight rectangle that is
drawn around the widget when it has the input focus. 
The default is \f(CWblack\fR.
.TP 
\fB\-highlightthickness \fIpixels\fR
Sets the width of the highlight rectangle to draw around the outside of 
the widget when it has the input focus. \fIPixels\fR is a non-negative 
value and may have any of the forms acceptable to \fBTk_GetPixels\fR.
If the value is zero, no focus highlight is drawn around the widget.
The default is \f(CW2\fR.
.TP
\fB\-outerpad \fIpixels\fR
Padding around the exterior of the tabset and folder.
.TP
\fB\-pageheight \fIpixels\fR
Sets the requested height of the page.  The page is the area under the
tab used to display the page contents.  If \fIpixels\fR is \f(CW0\fR,
the maximum height of all embedded tab windows is used.  The default
is \f(CW0\fR.
.TP
\fB\-pagewidth \fIpixels\fR
Sets the requested width of the page.  The page is the area under the
tab used to display the page contents.  If \fIpixels\fR is \f(CW0\fR,
the maximum width of all embedded tab windows is used.  The default
is \f(CW0\fR.
.TP
\fB\-perforationcommand\fR \fIstring\fR
Specifies a Tcl script to be invoked to tear off the current
page in the tabset. This command is typically invoked when 
left mouse button is released over the tab perforation.  The default
action is to tear-off the page and place it into a new toplevel 
window.
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect for the tabset widget.  \fIRelief\fR
specifies how the tabset should appear relative to widget that
it is packed into; for example, \f(CWraised\fR means the tabset should
appear to protrude.  The default is \f(CWsunken\fR.
.TP
\fB\-rotate \fItheta\fR
Specifies the degrees to rotate text in tab labels.
\fITheta\fR is a real value representing the number of degrees
to rotate the tick labels.  The default is \f(CW0.0\fR degrees.
.TP 
\fB\-samewidth \fIboolean\fR
Indicates if each tab should be the same width.  If true, each tab will
be as wide as the widest tab.  The default is \f(CWno\fR.
.TP 
\fB\-scrollcommand \fIstring\fR
Specifies the prefix for a command for communicating with 
scrollbars.  Whenever the view in the widget's window 
changes, the widget will generate a Tcl command by concatenating the 
scroll command and two numbers.  If this option is not specified, then 
no command will be executed. 
.TP 
\fB\-scrollincrement \fIpixels\fR
Sets the smallest number of pixels to scroll the tabs. 
If \fIpixels\fR is greater than 0, this sets the units for 
scrolling (e.g.,  when you the change the view by clicking
on the left and right arrows of a scrollbar).
.TP
\fB\-selectbackground \fIcolor\fR
Sets the color to use when displaying background of the selected
tab. Individual tabs can override this option by setting the tab's 
\fB\-selectbackground\fR option.
'\".TP 
'\" \fB\-selectborderwidth \fIpixels\fR
'\" Sets the width of the raised 3-D border to draw around the label of 
'\" the selected tab.  \fIPixels\fR must be a non-negative value.
'\" The default value is \f(CW1\fR.
.TP
\fB\-selectcommand \fIstring\fR
Specifies a default Tcl script to be associated with tabs.  This
command is typically invoked when left mouse button is released over 
the tab.  Individual tabs may override this with the tab's
\fB\-command\fR option. The default value is \f(CW""\fR.
.TP
\fB\-selectforeground \fIcolor\fB
Sets the default color of the selected tab's text label. 
Individual tabs can override this option by setting the tab's 
\fB\-selectforeground\fR option. The default value is \f(CWblack\fR.
.TP
\fB\-selectpad \fIpixels\fB
Specifies extra padding to be displayed around the selected tab. 
The default value is \f(CW3\fR.
.TP
\fB\-side \fIside\fB
Specifies the side of the widget to place tabs. The following
values are valid for \fIside\fR. The default value is \f(CWtop\fR.
.RS
.TP 1i
\f(CWtop\fR
Tabs are drawn along the top.
.TP 1i
\f(CWleft\fR
Tabs are drawn along the left side.
.TP 1i
\f(CWright\fR
Tabs are drawn along the right side.
.TP 1i
\f(CWboth\fR
Tabs are drawn along the bottom side.
.RE
.TP 
\fB\-slant \fIslant\fR
Specifies if the tabs should be slanted 45 degrees on the left and/or 
right sides. The following values are valid for \fIslant\fR. The default 
is \f(CWnone\fR.
.RS
.TP 1i
\f(CWnone\fR
Tabs are drawn as a rectangle.  
.TP 1i
\f(CWleft\fR
The left side of the tab is slanted.  
.TP 1i
\f(CWright\fR
The right side of the tab is slanted.  
.TP 1i
\f(CWboth\fR
Boths sides of the tab are slanted.
.RE
.TP
\fB\-tabbackground \fIcolor\fR
Sets the default background color of tabs.
Individual tabs can override this option by setting the tab's 
\fB\-background\fR option.
.TP
\fB\-tabborderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the tab.  The
\fB\-tabrelief\fR option determines how the border is to be drawn.  The
default is \f(CW2\fR.
.TP
\fB\-tabforeground \fIcolor\fR
Specifies the color to use when displaying a tab's label.
Individual tabs can override this option by setting the tab's 
\fB\-foreground\fR option.
.TP
\fB\-tabrelief \fIrelief\fR
Specifies the 3-D effect for both tabs and folders.  \fIRelief\fR
specifies how the tabs should appear relative to background of the 
widget; for example, \f(CWraised\fR means the tab should
appear to protrude.  The default is \f(CWraised\fR.
.TP
\fB\-takefocus\fR \fIfocus\fR 
Provides information used when moving the focus from window to window
via keyboard traversal (e.g., Tab and Shift-Tab).  If \fIfocus\fR is
\f(CW0\fR, this means that this window should be skipped entirely during
keyboard traversal.  \f(CW1\fR means that the this window should always
receive the input focus.  An empty value means that the traversal
scripts decide whether to focus on the window.
The default is \f(CW1\fR.
.TP
\fB\-tearoff \fIboolean\fR
.TP
\fB\-textside \fIside\fB
If both images and text are specified for a tab, this option determines on
which side of the tab the text is to be displayed. The 
valid sides are \f(CWleft\fR, \f(CWright\fR, \f(CWtop\fR, and
\f(CWbottom\fR.  The default value is \f(CWleft\fR.
.TP
\fB\-tiers \fInumber\fB
Specifies the maximum number of tiers to use to display the tabs.
The default value is \f(CW1\fR.
.TP
\fB\-tile \fIimage\fR 
Specifies a tiled background for the widget.  If \fIimage\fR isn't
\f(CW""\fR, the background is tiled using \fIimage\fR.
Otherwise, the normal background color is drawn (see the
\fB\-background\fR option).  \fIImage\fR must be an image created
using the Tk \fBimage\fR command.  The default is \f(CW""\fR.
.TP
\fB\-width \fIpixels\fR
Specifies the requested width of the widget.  If \fIpixels\fR is
0, then the width of the widget will be calculated based on
the size the tabs and their pages.
The default is \f(CW0\fR.
.SH "TAB OPTIONS"
In addition to the \fBconfigure\fR operation, widget configuration
options may also be set by the Tk \fBoption\fR command.  The class
resource name is \f(CWTab\fR.
.CS
option add *Tabset.Tab.Foreground white
option add *Tabset.name.Background blue
.CE
The following widget options are available:
.TP
\fB\-activebackground \fIcolor\fR
Sets the active background color for \fInameOrIndex\fR.  A tab is active
when the mouse is positioned over it or set by the \fBactivate\fR
operation.  This overrides the widget's \fB-activebackground\fR 
option. 
.TP
\fB\-activeforeground \fIcolor\fR
Sets the default active foreground color \fInameOrIndex\fR.  A tab is "active"
when the mouse is positioned over it or set by the \fBactivate\fR
operation.  Individual tabs may override this option by setting the
tab's \fB-activeforeground\fR option.
.TP
\fB\-anchor \fIanchor\fR 
Anchors the tab's embedded widget to a particular edge of the folder.
This option has effect only if the space in the folder surrounding the 
embedded widget is larger than the widget itself. \fIAnchor\fR specifies
how the widget will be positioned in the extra space.  For example, if
\fIanchor\fR is \f(CWcenter\fR then the window is centered in the folder
; if \fIanchor\fR is \f(CWw\fR then the window will
be aligned with the leftmost edge of the folder. The default value is
\f(CWcenter\fR.
.TP
\fB\-background \fIcolor\fR
Sets the background color for \fInameOrIndex\fR.  Setting this option overides the 
widget's \fB\-tabbackground\fR option.
.TP
\fB\-bindtags \fItagList\fR
Specifies the binding tags for this tab.  \fITagList\fR is a list of
binding tag names.  The tags and their order will determine how
commands for events in tabs are invoked.  Each tag in the list matching 
the event sequence will have its Tcl command executed.  Implicitly the 
name of the tab is always the first tag in the list.  The default value is
\f(CWall\fR.
.TP
\fB\-command \fIstring\fR
Specifies a Tcl script to be associated with \fInameOrIndex\fR.  This
command is typically invoked when left mouse button is released over 
the tab.  Setting this option overrides the widget's
\fB\-selectcommand\fR option. 
.TP
\fB\-data \fIstring\fR
Specifies a string to be associated with \fInameOrIndex\fR.
This value isn't used in the widget code.  It may be used in Tcl bindings 
to associate extra data (other than the image or text) with the
tab. The default value is \f(CW""\fR.
.TP
\fB\-fill \fIfill\fR
If the space in the folder surrounding the tab's embedded widget is 
larger than the widget, then \fIfill\fR indicates if the embedded widget 
should be stretched to occupy the extra space.  \fIFill\fR is either 
\f(CWnone\fR,
\f(CWx\fR, \f(CWy\fR, \f(CWboth\fR.  For example, if \fIfill\fR is \f(CWx\fR,
then the widget is stretched horizontally.  If \fIfill\fR is \f(CWy\fR,
the widget is stretched vertically.  The default is \f(CWnone\fR.
.TP
\fB\-font \fIfontName\fR 
Sets the font for the text in tab labels.  If \fIfontName\fR is not
the empty string, this overrides the tabset's \fB\-font\fR option.
The default value is \f(CW""\fR.
.TP
\fB\-foreground \fIcolor\fR 
Sets the color of the label for \fInameOrIndex\fR.  If \fIcolor\fR
is not the empty string, this overrides the widget's \fB\-tabforeground\fR 
option.  The default value is \f(CW""\fR.
.TP 
\fB\-image \fIimageName\fR
Specifies the image to be drawn in label for \fInameOrIndex\fR.
If \fIimage\fR is \f(CW""\fR, no image will be drawn.  Both text and
images may be displayed at the same time in tab labels.
The default value is \f(CW""\fR.
.TP
\fB\-ipadx \fIpad\fR
Sets the padding to the left and right of the label.
\fIPad\fR can be a list of one or two screen distances.  If \fIpad\fR
has two elements, the left side of the label is padded by the first
distance and the right side by the second.  If \fIpad\fR has just one
distance, both the left and right sides are padded evenly.  The
default value is \f(CW0\fR.
.TP
\fB\-ipady \fIpad\fR
Sets the padding to the top and bottom of the label.
\fIPad\fR can be a list of one or two screen distances.  If \fIpad\fR
has two elements, the top of the label is padded by the first
distance and the bottom by the second.  If \fIpad\fR has just one
distance, both the top and bottom sides are padded evenly.  The
default value is \f(CW0\fR.
.TP
\fB\-padx \fIpad\fR
Sets the padding around the left and right of the embedded widget, if 
one exists.
\fIPad\fR can be a list of one or two screen distances.  If \fIpad\fR
has two elements, the left side of the widget is padded by the first
distance and the right side by the second.  If \fIpad\fR has just one
distance, both the left and right sides are padded evenly.  The
default value is \f(CW0\fR.
.TP
\fB\-pady \fIpad\fR
Sets the padding around the top and bottom of the embedded widget, if
one exists.
\fIPad\fR can be a list of one or two screen distances.  If \fIpad\fR
has two elements, the top of the widget is padded by the first
distance and the bottom by the second.  If \fIpad\fR has just one
distance, both the top and bottom sides are padded evenly.  The
default value is \f(CW0\fR.
.TP 
\fB\-selectbackground \fIcolor\fR
Sets the color to use when displaying background of the selected
tab. If \fIcolor\fR is not the empty string, this overrides the
widget's \fB\-selectbackground\fR option. The default value is
\f(CW""\fR.
.TP 
\fB\-shadow \fIcolor\fR
Sets the shadow color for the text in the tab's label. Drop shadows
are useful when both the foreground and background of the tab
have similar color intensities.
If \fIcolor\fR is the empty string, no shadow is drawn.
The default value is \f(CW""\fR.
.TP
\fB\-state \fIstate\fR
Sets the state of the tab. If \fIstate\fR is \f(CWdisable\fR the
text of the tab is drawn as engraved and operations on the tab
(such as \fBinvoke\fR and \fBtab tearoff\fR) are ignored.
The default is \f(CWnormal\fR.
.TP
\fB\-stipple \fIbitmap\fR
Specifies a stipple pattern to use for the background of the folder
when the window is torn off.
\fIBitmap\fR specifies a bitmap to use as the stipple
pattern. The default is \f(CWBLT\fR.
.TP
\fB\-text \fItext\fR
Specifies the text of the tab's label.  The exact way the text is
drawn may be affected by other options such as \fB\-state\fR or
\fB\-rotate\fR.
.TP
\fB\-window \fIpathName\fR
Specifies the widget to be embedded into the tab.  \fIPathName\fR must
be a child of the \fBtabset\fR widget.  The tabset will "pack" and
manage the size and placement of \fIpathName\fR.  The default value
is \f(CW""\fR.
.TP
\fB\-windowheight \fIpixels\fR
Sets the requested height of the page.  The page is the area under the
tab used to display the page contents.  If \fIpixels\fR is \f(CW0\fR,
the maximum height of all embedded tab windows is used.  The default
is \f(CW0\fR.
.TP
\fB\-windowwidth \fIpixels\fR
Sets the requested width of the page.  The page is the area under the
tab used to display the page contents.  If \fIpixels\fR is \f(CW0\fR,
the maximum width of all embedded tab windows is used.  The default
is \f(CW0\fR.
.SH "DEFAULT BINDINGS"
.PP
BLT automatically generates class bindings that supply tabsets their
default behaviors. The following event sequences are set by default 
for tabsets (via the class bind tag \f(CWTabset\fR):
.IP \fB<ButtonPress-2>\fR
.IP \fB<B2-Motion>\fR
.IP \fB<ButtonRelease-2>\fR
Mouse button 2 may be used for scanning.
If it is pressed and dragged over the tabset, the contents of
the tabset drag at high speed in the direction the mouse moves.
.IP \fB<KeyPress-Up>\fR
.IP \fB<KeyPress-Down>\fR
The up and down arrow keys move the focus to the tab immediately above
or below the current focus tab.  The tab with focus is drawn
with the a dashed outline around the tab label.
.IP \fB<KeyPress-Left>\fR
.IP \fB<KeyPress-Right>\fR
The left and right arrow keys move the focus to the tab immediately to the left
or right of the current focus tab.  The tab with focus is drawn
with the a dashed outline around the tab label.
.IP \fB<KeyPress-space>\fR
.IP \fB<KeyPress-Return>\fR
The space and return keys select the current tab given focus.
When a folder is selected, it's command is invoked and the 
embedded widget is mapped.
.PP
Each tab, by default, also has a set of bindings (via the tag
\f(CWall\fR).  These bindings may be reset using the tabset's 
\fBbind\fR operation.
.IP \fB<Enter>\fR
.IP \fB<Leave>\fR
When the mouse pointer enters a tab, it is activated (i.e. drawn in
its active colors) and when the pointer leaves, it is redrawn in
its normal colors.
.IP \fB<ButtonRelease-1>\fR
Clicking with the left mouse button on a tab causes the tab to be
selected and its Tcl script (see the \fB\-command\fR or
\fB\-selectcommand\fR options) to be invoked.  The folder and any embedded
widget (if one is specified) is automatically mapped.
.IP \fB<ButtonRelease-3>\fR
.IP \fB<Control-ButtonRelease-1>\fR
Clicking on the right mouse button (or the left mouse button with the
Control key held down) tears off the current page into its own toplevel
widget. The embedded widget is re-packed into a new toplevel and 
an outline of the widget is drawn in the folder.  Clicking again
(toggling) will reverse this operation and replace the page back in
the folder.
.SH "BIND TAGS"
You can bind commands to tabs that are triggered when a particular
event sequence occurs in them, much like canvas items in Tk's 
canvas widget.  Not all event sequences are valid.  The only binding 
events that may be specified are those related to the mouse and 
keyboard (such as \fBEnter\fR, \fBLeave\fR, \fBButtonPress\fR, 
\fBMotion\fR, and \fBKeyPress\fR).
.PP
It is possible for multiple bindings to match a particular event.
This could occur, for example, if one binding is associated with the
tab name and another is associated with the tab's tags
(see the \fB\-bindtags\fR option).  When this occurs, all the 
matching bindings are invoked.  A binding associated with the tab
name is invoked first, followed by one binding for each of the tab's 
bindtags.  If there are multiple matching bindings for a single tag, 
then only the most specific binding is invoked.  A continue command 
in a binding script terminates that script, and a break command 
terminates that script and skips any remaining scripts for the event, 
just as for the bind command.
.PP
The \fB\-bindtags\fR option for tabs controls addition tag names that
can be matched.  Implicitly the first tag for each tab is its name.
Setting the value of the \fB\-bindtags\fR option doesn't change this.
.SH EXAMPLE
You create a tabset widget with the \fBtabset\fR command.
.CS
# Create a new tabset
tabset .ts -relief sunken -borderwidth 2 
.CE
A new Tcl command \f(CW.ts\fR is also created.  This command can be
used to query and modify the tabset.  For example, to change the
default font used by all the tab labels, you use the new command and
the tabset's \fBconfigure\fR operation.
.CS
# Change the default font.
\&.ts configure \-font "fixed"
.CE
You can then add folders using the \fBinsert\fR operation.
.CS
# Create a new folder "f1"
\&.ts insert 0 "f1"
.CE
This inserts the new tab named "f1" into the tabset.  The index
\f(CW0\fR indicates location to insert the new tab.  You can also use
the index \f(CWend\fR to append a tab to the end of the tabset.  By
default, the text of the tab is the name of the tab.  You can change
this by configuring the \fB\-text\fR option.
.CS
# Change the label of "f1"
\&.ts tab configure "f1" -text "Tab #1" 
.CE
The \fBinsert\fR operation lets you add one or more folders at a time.
.CS
\&.ts insert end "f2" -text "Tab #2" "f3" "f4" 
.CE
The tab on each folder contains a label.  A label may display both
an image and a text string.  You can reconfigure the tab's attributes
(foreground/background colors, font, rotation, etc) using the \fBtab
configure\fR operation.
.CS
# Add an image to the label of "f1"
set image [image create photo -file stopsign.gif]
\&.ts tab configure "f1" -image $image
\&.ts tab configure "f2" -rotate 90
.CE
Each folder may contain an embedded widget to represent its contents.
The widget to be embedded must be a child of the tabset widget.  Using
the \fB\-window\fR option, you specify the name of widget to be
embedded.  But don't pack the widget, the tabset takes care of placing
and arranging the widget for you.
.CS
graph .ts.graph
\&.ts tab configure "f1" -window ".ts.graph" \\
    -fill both -padx 0.25i -pady 0.25i
.CE
The size of the folder is determined the sizes of the Tk widgets
embedded inside each folder.  The folder will be as wide as the widest
widget in any folder. The tallest determines the height.  You can use
the tab's \fB\-pagewidth\fR and \fB\-pageheight\fR options override this.
.PP
Other options control how the widget appears in the folder.  The
\fB\-fill\fR option says that you wish to have the widget stretch to
fill the available space in the folder.
.CS
\&.ts tab configure "f1" -fill both -padx 0.25i -pady 0.25i
.CE
.PP
Now when you click the left mouse button on "f1", the
graph will be displayed in the folder.  It will be automatically
hidden when another folder is selected.  If you click on the right
mouse button, the embedded widget will be moved into a toplevel widget 
of its own.  Clicking again on the right mouse button puts it back into 
the folder.
.PP
If you want to share a page between two different folders, the
\fB\-command\fR option lets you specify a Tcl command to be invoked
whenever the folder is selected.  You can reset the \fB\-window\fR
option for the tab whenever it's clicked.
.CS
\&.ts tab configure "f2" -command { 
    \&.ts tab configure "f2" -window ".ts.graph"
}
\&.ts tab configure "f1" -command { 
    \&.ts tab configure "f1" -window ".ts.graph"
}
.CE
If you have many folders, you may wish to stack tabs in multiple
tiers.  The tabset's \fB\-tiers\fR option requests a maximum
number of tiers.   The default is one tier.  
.CS
\&.ts configure -tiers 2
.CE
If the tabs can fit in less tiers, the widget will use that many.  
Whenever there are more tabs than can be displayed in the maximum number
of tiers, the tabset will automatically let you scroll the tabs.  You
can even attach a scrollbar to the tabset.
.CS
\&.ts configure -scrollcommand { .sbar set }  -scrollincrement 20
\&.sbar configure -orient horizontal -command { .ts view }
.CE
By default tabs are along the top of the tabset from left to right.  
But tabs can be placed on any side of the tabset using the \fB\-side\fR
option.
.CS
# Arrange tabs along the right side of the tabset. 
\&.ts configure -side right -rotate 270
.CE
.SH KEYWORDS
tabset, widget
