'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Busy command created by George Howlett.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.3 2001/02/17 07:46:19 ghowlett Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.ft CW
.sp
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
.ft R
.sp
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH busy n 3.0 BLT "BLT Built-In Commands"
.BS 
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
\fBbusy\fR \- Make Tk widgets busy, temporarily blocking user interactions.
.SH SYNOPSIS
\fBblt::busy hold \fIwindow\fR ?\fIoption value\fR?...
.sp
\fBblt::busy release \fIwindow\fR ?\fIwindow\fR?...
.sp
\fBblt::busy configure \fIwindow\fR ?\fIoption value\fR?...
.sp
\fBblt::busy forget \fIwindow\fR ?\fIwindow\fR?...
.sp
\fBblt::busy isbusy \fR?\fIpattern\fR?
.sp
\fBblt::busy names \fR?\fIpattern\fR?
.sp
\fBblt::busy status \fIwindow\fR 
.BE
.SH DESCRIPTION
.PP
The \fBbusy\fR command provides a simple means to block
keyboard, button, and pointer events from Tk widgets, while overriding
the widget's cursor with a configurable busy cursor.
.SH INTRODUCTION
.PP
There are many times in applications where you want to temporarily
restrict what actions the user can take.  For example, an application
could have a "run" button that when pressed causes some processing to
occur.  But while the application is busy processing, you probably don't
want the the user to be able to click the "run" button again.  You
may also want restrict the user from other tasks such as clicking a
"print" button.
.PP
The \fBbusy\fR command lets you make Tk widgets busy. This means
that user interactions such as button clicks, moving the mouse, typing
at the keyboard, etc. are ignored by the widget.  You can set a
special cursor (like a watch) that overrides the widget's normal
cursor, providing feedback that the application (widget) is
temporarily busy.
.PP
When a widget is made busy, the widget and all of its descendents will
ignore events.  It's easy to make an entire panel of widgets busy. You
can simply make the toplevel widget (such as ".") busy.  This is
easier and far much more efficient than recursively traversing the
widget hierarchy, disabling each widget and re-configuring its cursor.
.PP
Often, the busy command can be used instead of Tk's \fBgrab\fR
command.  Unlike \fBgrab\fR which restricts all user interactions to
one widget, with the busy command you can have more than one widget
active (for example, a "cancel" dialog and a "help" button).
.SH EXAMPLE
You can make several widgets busy by simply making its ancestor widget
busy using the \fBhold\fR operation.
.CS
frame .top
button .top.button; canvas .top.canvas
pack .top.button .top.canvas
pack .top
  . . .
blt::busy hold .top
update
.CE
All the widgets within \f(CW.top\fR (including \f(CW.top\fR) are now busy.  
Using \fBupdate\fR insures that \fBbusy\fR command will take effect before
any other user events can occur.
.PP
When the application is no longer busy processing, you can allow user
interactions again by the \fBrelease\fR operation.
.nf

\f(CW	blt::busy release .top \fR

.fi
The busy window has a configurable cursor.  You can change the busy
cursor using the \fBconfigure\fR operation.
.nf

\f(CW	blt::busy configure .top -cursor "watch"\fR

.fi
Finally, when you no longer need to the busy window, 
invoke the \fBforget\fR operation to free any resources it allocated.
.nf

\f(CW	blt::busy forget .top \fR

.fi
Destroying the widget will also clean up any resources allocated by
the busy command.
.PP
.SH OPERATIONS
The following operations are available for the \fBbusy\fR command:
.TP
\fBblt::busy hold \fIwindow\fR ?\fIoption value\fR?...
Makes the widget \fIwindow\fR (and its descendants in the Tk window
hierarchy) busy.  \fIWindow\fR must be a valid path name of a Tk
widget.  The busy window is mapped the next time idle tasks are
processed, and the widget and its descendants will be blocked from
user interactions. All events in the widget window and its
descendants are ignored.  Normally \fBupdate\fR should be called
immediately afterward to insure that the \fBhold\fR operation is in
effect \fIbefore\fR the application starts its processing. The
following configuration options are valid:
.RS
.TP
\fB\-cursor \fIcursorName\fR
Specifies the cursor to be displayed when the widget is made busy.
\fICursorName\fR can be in any form accepted by \fBTk_GetCursor\fR.
The default cursor is \f(CWwatch\fR.
.RE
.TP
\fBblt::busy configure \fIwindow\fR ?\fIoption value\fR?...
Queries or modifies the \fBbusy\fR command configuration options for 
\fIwindow\fR. \fIWindow\fR must be the path name of a widget previously
made busy by the \fBhold\fR operation.  If no options are
specified, a list describing all of the available options for
\fIwindow\fR (see \fBTk_ConfigureInfo\fR for information on the format
of this list) is returned.  If \fIoption\fR is specified with no
\fIvalue\fR, then the command returns a list describing the one named
option (this list will be identical to the corresponding sublist of
the value returned if no \fIoption\fR is specified).  If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given widget option(s) to have the given value(s); in this case the
command returns the empty string.  \fIOption\fR may have any of the
values accepted by the \fBhold\fR operation.  
.sp
Please note that the
option database is referenced through \fIwindow\fR.  For example, if 
the widget \f(CW.frame\fR is to be made busy, the busy 
cursor can be specified for it by either \fBoption\fR command:
.nf

	\f(CWoption add *frame.busyCursor gumby\fR
	\f(CWoption add *Frame.BusyCursor gumby\fR

.fi
.TP
\fBblt::busy forget \fIwindow\fR ?\fIwindow\fR?...
Releases resources allocated by the busy command for \fIwindow\fR,
including the busy window.  User events will again be received again 
by \fIwindow\fR.  Resources are also released when \fIwindow\fR
is destroyed. \fIWindow\fR must be the name of a widget specified 
in the \fBhold\fR operation, otherwise an error is reported.
.TP
\fBblt::busy check \fIwindow\fR
Checks if \fIwindow\fR or any of its ancestors are currently busy.  If
\fIwindow\fR is presently busy (it can not receive user interactions)
\f(CW1\fR is returned, otherwise \f(CW0\fR.
.TP
\fBblt::busy isbusy \fR?\fIpattern\fR?
Returns the pathnames of all widgets that are currently busy.
If a \fIpattern\fR is given, the path names of busy widgets 
matching \fIpattern\fR are returned.
.TP
\fBblt::busy names \fR?\fIpattern\fR?
Returns the pathnames of all widgets that have previously been
made busy (i.e. a busy window is allocated and associated with the
widget).  It makes no difference if the window is currently busy or
not.  If a \fIpattern\fR is given, the path names of busy widgets
matching \fIpattern\fR are returned.
.TP
\fBblt::busy release \fIwindow\fR ?\fIwindow\fR?...
Restores user interactions to the widget \fIwindow\fR again. 
This differs from the \fBforget\fR operation in that the busy window 
is not destroyed, but simply unmapped.  
\fIWindow\fR must be the name of a widget specified 
in a \fBhold\fR operation, otherwise an error is reported.
.TP
\fBblt::busy status \fIwindow\fR
Returns the status of a widget \fIwindow\fR previously made busy.
An error is reported if \fIwindow\fR does not was never made busy, or
the \fBforget\fR operation was invoked (i.e. does not currently have a
busy window associated with it).  If \fIwindow\fR is presently can
not receive user interactions, \f(CW1\fR is returned, otherwise \f(CW0\fR.
.sp 1
.SH BINDINGS
The event blocking feature is implemented by creating and mapping a
transparent window that completely covers the widget.  When the busy
window is mapped, it invisibly shields the widget and its hierarchy
from all events that may be sent.  Like Tk widgets, busy windows have
widget names in the Tk window hierarchy.  This means that you can use
the \fBbind\fR command, to handle events in the busy window.
.CS
blt::busy hold .frame.canvas
bind .frame.canvas_Busy <Enter> { ... } 
.CE
.PP
Normally the busy window is a sibling of the widget.  The
name of the busy window is "\fIwidget\f(CW_Busy\fR" where \fIwidget\fR
is the name of the widget to be made busy.  In the previous example, the
pathname of the busy window is "\f(CW.frame.canvas_Busy\fR" The
exception is when the widget is a toplevel widget (such as ".")  where
the busy window can't be made a sibling.  The busy window is then a
child of the widget named "\fIwidget\f(CW._Busy\fR" where \fIwidget\fR
is the name of the toplevel widget.  In the following example, the
pathname of the busy window is "\f(CW._Busy\fR"
.CS
blt::busy hold .
bind ._Busy <Enter> { ... } 
.CE
.SH ENTER/LEAVE EVENTS
Mapping and unmapping busy windows generates Enter/Leave events for
all widgets they cover.  Please note this if you are tracking
Enter/Leave events in widgets.
.SH KEYBOARD EVENTS
When a widget is made busy, the widget is prevented from gaining the
keyboard focus by the busy window. But if the widget already had
focus, it still may received keyboard events.  To prevent this, you
must move focus to another window.
.CS
blt::busy hold .frame
label .dummy
focus .dummy
update
.CE
The above example moves the focus from .frame immediately after
invoking the \fBhold\fR so that no keyboard events will be sent to
\f(CW.frame\fR or any of its descendants.
.PP
Tk's tab traversal mechanism should be also modified to check for busy
windows. You can do this by adding a simple test to "tkFocusOK".  Here's
an example.
.CS
tk_focusNext .
rename tkFocusOK tkFocusOK.orig
proc tkFocusOK { w }  {
    if { [blt::busy check $w] } {
	return 0
    }
    return [tkFocusOK.orig $w]
}
.CE
.SH KEYWORDS
busy, keyboard events, pointer events, window, cursor


