#!../src/bltwish

package require BLT
source scripts/demo.tcl
#blt::bltdebug 100

source scripts/stipples.tcl

blt::tabset .t \
    -samewidth yes \
    -side left \
    -textside bottom \
    -textside top \
    -bg red \
    -tiers 1 \
    -scrollincrement 10 \
    -scrollcommand { .s set } \
    -rotate 0 \
    -selectcommand {  MakePhoto %W %n } 


scrollbar .s -command { .t view } -orient horizontal
 
option clear
option add *Tabset.Tab.font -*-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*

set files [glob ./images/*.gif]
set files [lsort $files]
set vertFilter sinc
set horzFilter sinc
#set vertFilter none
#set horzFilter none


proc ResizePhoto { src dest maxSize } {
    set maxSize [winfo fpixels . $maxSize]
    set w [image width $src]
    set h [image height $src]
    set sw [expr double($maxSize) / $w]
    set sh [expr double($maxSize) / $h]
    set s [expr min($sw, $sh)]
    set w [expr round($s * $w)]
    set h [expr round($s * $h)]
    $dest configure -width $w -height $h
    
    global horzFilter vertFilter
    blt::winop resample $src $dest $horzFilter $vertFilter
}

image create photo src
image create photo dest

label .t.label -image dest -bg purple

proc MakePhoto { w name } {
    set file ./images/$name.gif
    src configure -file $file

    set width [$w tab pagewidth]
    set height [$w tab pageheight]
    if { $width < $height } {
	ResizePhoto src dest $width
    } else {
	ResizePhoto src dest $height
    }
    .t tab dockall
    .t tab configure $name -window .t.label -padx 4m -pady 4m -fill both
}

blt::table . \
    .t 0,0 -fill both \
    .s 1,0 -fill x 

blt::table configure . r1 -resize none
focus .t

foreach f $files {
    src configure -file $f
    set f [file tail [file root $f]]
    set thumb [image create photo]
    ResizePhoto src $thumb 0.5i
    .t insert end $f -image $thumb -fill both
}

.t focus 0
.t invoke 0
