#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi


tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export FULLPKG=${PKG}-${VER}-${REL}

export src_orig_pkg_name=${PKG}_${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}_${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr
sysconfdir=${prefix}/etc
path_old=${PATH}

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdirs && \
  chmod +x ${srcdir}/CYGWIN-PATCHES/shtool && \
  cd ${srcdir} && \
  CYGWIN-PATCHES/shtool mkshadow -v . .build )
}
conf() {
  echo Configure successful.
}
build() {
  (cd ${objdir} && make cygwin )
}
check() {
  (cd ${objdir} && \
  echo "'make check' not supported for this package" |\
    tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && make clean )
}
real_install() {
  (cd ${objdir} && \
  if [ ! -d ${instdir}${prefix}/sbin ] ; then \
    mkdir -p ${instdir}${prefix}/sbin ; \
  fi && \
  for f in tcpd.exe tcpdchk.exe tcpdmatch.exe \
           safe_finger.exe try-from.exe ; do 
    /usr/bin/install -m 755 ${f} ${instdir}${prefix}/sbin 
  done && \
#  if [ ! -d ${instdir}${prefix}/bin ] ; then \
#    mkdir -p ${instdir}${prefix}/bin ; \
#  fi && \
#  /usr/bin/install -m 755 *.dll ${instdir}${prefix}/bin && \
  if [ ! -d ${instdir}${prefix}/man/man3 ] ; then \
    mkdir -p ${instdir}${prefix}/man/man3 ; \
  fi && \
  /usr/bin/install -m 755 hosts_access.3 ${instdir}${prefix}/man/man3
  if [ ! -d ${instdir}${prefix}/man/man5 ] ; then \
    mkdir -p ${instdir}${prefix}/man/man5 ; \
  fi && \
  /usr/bin/install -m 755 hosts_access.5 hosts_options.5 \
    ${instdir}${prefix}/man/man5
  if [ ! -d ${instdir}${prefix}/man/man8 ] ; then \
    mkdir -p ${instdir}${prefix}/man/man8 ; \
  fi && \
  /usr/bin/install -m 755 tcpdchk.8 tcpdmatch.8 tcpd.8 \
    ${instdir}${prefix}/man/man8
  if [ ! -d ${instdir}${prefix}/lib ] ; then \
    mkdir -p ${instdir}${prefix}/lib ; \
  fi && \
  /usr/bin/install -m 644 libwrap.a ${instdir}${prefix}/lib
#  /usr/bin/install -m 644 libwrap.dll.a ${instdir}${prefix}/lib
  if [ ! -d ${instdir}${prefix}/include ] ; then \
    mkdir -p ${instdir}${prefix}/include ; \
  fi && \
  /usr/bin/install -m 644 tcpd.h ${instdir}${prefix}/include )
}
install() {
  (cd ${objdir} && \
  real_install && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/tcp_wrappers.README \
    ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README && \
  /usr/bin/install -m 644 ${srcdir}/README \
    ${srcdir}/BLURB ${srcdir}/CHANGES ${srcdir}/DISCLAIMER \
    ${srcdir}/README.IRIX ${srcdir}/README.NIS \
	 ${instdir}${prefix}/doc/${PKG}-${VER} && \
  if [ ! -d ${instdir}/etc/postinstall ] ; then \
    mkdir -p ${instdir}/etc/postinstall ; \
  fi && \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
    ${instdir}/etc/postinstall/${PKG}.sh )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} ; \
  mv ${PKG}_${VER} ../${PKG}_${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}_${VER}-orig ${PKG}_${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}_${VER}-orig )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip ;
#  find . -name "*.dll" | xargs strip ;
  )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir}
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; STATUS=1 ;;
esac
export PATH=${path_old}
exit ${STATUS}
