#!/bin/sh

# run the build with ntsec on if possible...
pkg=perl
ver=5.8.5
release=-3
dir=`pwd`
shortver=`echo ${ver}${release} | sed 's/-.*//'`
buildperl=buildperl

## checkout builddir
rm -rf ${dir}/${buildperl}
mkdir -p -m 777 ${dir}/${buildperl}

## unpack
rm -rf ${pkg}-${ver}
tar jxf ${pkg}-${ver}.tar.bz2
mkdir -p /usr/share/doc/${pkg}-${ver}${release}
/bin/install -c -m 644 ${pkg}-${ver}/Artistic ${pkg}-${ver}/Copying ${pkg}-${ver}/README /usr/share/doc/${pkg}-${ver}${release}

## patch to strip the binaries & dll's
(cd ${pkg}-${ver} ; patch -p1<../hints.cygwin.sh.patch)
## db_file patch
(cd ${pkg}-${ver} ; patch -p1<../db_file-1.810.patch)

## configure perl
cd ${dir}/${buildperl}

cp ${dir}/Policy.sh ${dir}/${buildperl}

sh ${dir}/${pkg}-${ver}/Configure -de	\
		-Dmksymlinks	\
		-Duse64bitint	\
		-Dusethreads	\
		-Doptimize='-O2'	\
		-Dman3ext='3pm'	\
		2>&1 | tee ${dir}/log.configure

# Implied by usethreads
#		-Dusemultiplicity	\
#		-Uusemymalloc	\

## build perl
make 2>&1 | tee ${dir}/log.make

cp /usr/bin/cygcrypt-0.dll .

## make the tests
export PERLIO=perlio
make test 2>&1 | tee ${dir}/log.test
(cd t;./perl harness) 2>&1 | tee ${dir}/log.harness

rm -f cygcrypt-0.dll

## install
make install-strip 2>&1 | tee ${dir}/log.install

cd ${dir}
for i in \
         Compress-Zlib-1.33	\
         IO-Zlib-1.01	\
         Archive-Tar-1.10	\
         MD5-2.03	\
         Term-ReadLine-Perl-1.0203 \
         Net-Telnet-3.03	\
         TermReadKey-2.21	\
         XML-Parser-2.34;	\
do (tar xzf ${i}.tar.gz &&	\
    (cd ${i} &&	\
    perl Makefile.PL &&	\
    make &&	\
    make install_vendor UNINST=1));	\
done
