/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    private byte[] inbuf;
    private int inbufLength;
    protected byte[] buf;
    protected Deflater def;

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    protected void deflate() throws IOException {
        do {
            int len;
            if ((len = this.def.deflate(this.buf, 0, this.buf.length)) <= 0) continue;
            this.out.write(this.buf, 0, len);
        } while (!this.def.needsInput());
    }

    public DeflaterOutputStream(OutputStream out) {
        this(out, new Deflater(), 512);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl) {
        this(out, defl, 512);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl, int bufsize) {
        super(out);
        if (bufsize <= 0) {
            throw new IllegalArgumentException("bufsize <= 0");
        }
        this.buf = new byte[bufsize];
        this.def = defl;
    }

    public void finish() throws IOException {
        this.inbufWrite();
        this.def.finish();
        while (!this.def.finished()) {
            int len = this.def.deflate(this.buf, 0, this.buf.length);
            if (len <= 0) continue;
            this.out.write(this.buf, 0, len);
        }
    }

    public void write(int bval) throws IOException {
        if (this.inbuf == null) {
            this.inbuf = new byte[128];
        } else if (this.inbufLength == this.inbuf.length) {
            this.inbufWrite();
        }
        this.inbuf[this.inbufLength++] = (byte)bval;
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.inbufWrite();
        this.def.setInput(buf, off, len);
        this.deflate();
    }

    private void inbufWrite() throws IOException {
        if (this.inbufLength > 0) {
            int size = this.inbufLength;
            this.inbufLength = 0;
            this.write(this.inbuf, 0, size);
        }
    }
}

