/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import gnu.java.nio.charset.UTF_8;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public final class Provider
extends CharsetProvider {
    private static Provider singleton;
    private final HashMap canonicalNames = new HashMap();
    private final HashMap charsets = new HashMap();

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private Provider() {
        this.addCharset(new US_ASCII());
        this.addCharset(new ISO_8859_1());
        this.addCharset(new UTF_8());
        this.addCharset(new UTF_16BE());
        this.addCharset(new UTF_16LE());
        this.addCharset(new UTF_16());
    }

    public Iterator charsets() {
        return Collections.unmodifiableCollection(this.charsets.values()).iterator();
    }

    public Charset charsetForName(String charsetName) {
        return (Charset)this.charsets.get(this.canonicalize(charsetName));
    }

    private Object canonicalize(String charsetName) {
        Object o = this.canonicalNames.get(charsetName);
        if (o == null) {
            return charsetName;
        }
        return o;
    }

    private void addCharset(Charset cs) {
        String canonicalName = cs.name();
        this.charsets.put(canonicalName, cs);
        Iterator i = cs.aliases().iterator();
        while (i.hasNext()) {
            this.canonicalNames.put(i.next(), canonicalName);
        }
    }

    public static synchronized Provider provider() {
        if (singleton == null) {
            singleton = new Provider();
        }
        return singleton;
    }

    static {
        Class clazz = Provider.class$("gnu.java.nio.charset.Provider");
        synchronized (clazz) {
            try {
                singleton = null;
            }
            finally {
                Object var1_1 = null;
            }
            return;
        }
    }
}

