/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private final String detailMessage;
    private Throwable cause;
    private StackTraceElement[] stackTrace;
    private static final String nl = System.getProperty("line.separator");
    private transient VMThrowable vmState;

    private /* synthetic */ void finit$() {
        this.cause = this;
    }

    public Throwable() {
        this((String)null);
    }

    public Throwable(String message) {
        this.finit$();
        this.fillInStackTrace();
        this.detailMessage = message;
    }

    public Throwable(String message, Throwable cause) {
        this(message);
        this.initCause(cause);
    }

    public Throwable(Throwable cause) {
        this(cause == null ? null : cause.toString(), cause);
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    public Throwable initCause(Throwable cause) {
        if (cause == this) {
            throw new IllegalArgumentException();
        }
        if (this.cause != this) {
            throw new IllegalStateException();
        }
        this.cause = cause;
        return this;
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        return this.getClass().getName() + (msg == null ? "" : ": " + msg);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        s.print(this.stackTraceString());
    }

    public void printStackTrace(PrintWriter pw) {
        pw.print(this.stackTraceString());
    }

    private String stackTraceString() {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stack = this.getStackTrace();
        Throwable.stackTraceStringBuffer(sb, this.toString(), stack, 0);
        for (Throwable cause = this.getCause(); cause != null; cause = cause.getCause()) {
            sb.append("Caused by: ");
            StackTraceElement[] parentStack = stack;
            stack = cause.getStackTrace();
            if (parentStack == null || parentStack.length == 0) {
                Throwable.stackTraceStringBuffer(sb, cause.toString(), stack, 0);
                continue;
            }
            int equal = 0;
            int frame = stack.length - 1;
            for (int parentFrame = parentStack.length - 1; frame > 0 && parentFrame > 0 && stack[frame].equals(parentStack[parentFrame]); --frame, --parentFrame) {
                ++equal;
            }
            Throwable.stackTraceStringBuffer(sb, cause.toString(), stack, equal);
        }
        return sb.toString();
    }

    private static void stackTraceStringBuffer(StringBuffer sb, String name, StackTraceElement[] stack, int equal) {
        sb.append(name);
        sb.append(nl);
        if (stack == null || stack.length == 0) {
            sb.append("   <<No stacktrace available>>");
            sb.append(nl);
        } else {
            for (int i = 0; i < stack.length - equal; ++i) {
                sb.append("   at ");
                sb.append(stack[i] == null ? "<<Unknown>>" : stack[i].toString());
                sb.append(nl);
            }
            if (equal > 0) {
                sb.append("   ...");
                sb.append(equal);
                sb.append(" more");
                sb.append(nl);
            }
        }
    }

    public Throwable fillInStackTrace() {
        this.vmState = VMThrowable.fillInStackTrace(this);
        this.stackTrace = null;
        return this;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            if (this.vmState == null) {
                this.stackTrace = new StackTraceElement[0];
            } else {
                this.stackTrace = this.vmState.getStackTrace(this);
                this.vmState = null;
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        int i = stackTrace.length;
        StackTraceElement[] st = new StackTraceElement[i];
        while (--i >= 0) {
            st[i] = stackTrace[i];
            if (st[i] != null) continue;
            throw new NullPointerException("Element " + i + " null");
        }
        this.stackTrace = st;
    }
}

