/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;

public class MulticastSocket
extends DatagramSocket {
    public MulticastSocket() throws IOException {
        super(0, null);
    }

    public MulticastSocket(int port) throws IOException {
        super(port, null);
    }

    public MulticastSocket(SocketAddress address) throws IOException {
        super(address);
    }

    public InetAddress getInterface() throws SocketException {
        return (InetAddress)this.impl.getOption(16);
    }

    public byte getTTL() throws IOException {
        return this.impl.getTTL();
    }

    public int getTimeToLive() throws IOException {
        return this.impl.getTimeToLive();
    }

    public void setInterface(InetAddress addr) throws SocketException {
        this.impl.setOption(16, addr);
    }

    public void setNetworkInterface(NetworkInterface netIf) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("MulticastSocket: Cant access socket implementation");
        }
        Enumeration e = netIf.getInetAddresses();
        if (!e.hasMoreElements()) {
            throw new SocketException("MulticastSocket: Error");
        }
        InetAddress address = (InetAddress)e.nextElement();
        this.impl.setOption(16, address);
    }

    public NetworkInterface getNetworkInterface() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("MulticastSocket: Cant access socket implementation");
        }
        InetAddress address = (InetAddress)this.impl.getOption(16);
        NetworkInterface netIf = NetworkInterface.getByInetAddress(address);
        return netIf;
    }

    public void setLoopbackMode(boolean disable) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("MulticastSocket: Cant access socket implementation");
        }
        this.impl.setOption(18, new Boolean(disable));
    }

    public boolean getLoopbackMode() throws SocketException {
        Object obj = this.impl.getOption(18);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public void setTTL(byte ttl) throws IOException {
        this.impl.setTTL(ttl);
    }

    public void setTimeToLive(int ttl) throws IOException {
        if (ttl <= 0 || ttl > 255) {
            throw new IllegalArgumentException("Invalid ttl: " + ttl);
        }
        this.impl.setTimeToLive(ttl);
    }

    public void joinGroup(InetAddress mcastaddr) throws IOException {
        if (!mcastaddr.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(mcastaddr);
        }
        this.impl.join(mcastaddr);
    }

    public void leaveGroup(InetAddress mcastaddr) throws IOException {
        if (!mcastaddr.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(mcastaddr);
        }
        this.impl.leave(mcastaddr);
    }

    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (!(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("SocketAddress type not supported");
        }
        InetSocketAddress tmp = (InetSocketAddress)mcastaddr;
        if (!tmp.getAddress().isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(tmp.getAddress());
        }
        this.impl.joinGroup(mcastaddr, netIf);
    }

    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        InetSocketAddress tmp = (InetSocketAddress)mcastaddr;
        if (!tmp.getAddress().isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(tmp.getAddress());
        }
        this.impl.leaveGroup(mcastaddr, netIf);
    }

    public synchronized void send(DatagramPacket p, byte ttl) throws IOException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            InetAddress addr = p.getAddress();
            if (addr.isMulticastAddress()) {
                s.checkMulticast(addr, ttl);
            } else {
                s.checkConnect(addr.getHostAddress(), p.getPort());
            }
        }
        int oldttl = this.impl.getTimeToLive();
        this.impl.setTimeToLive(ttl & 0xFF);
        this.impl.send(p);
        this.impl.setTimeToLive(oldttl);
    }
}

