/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon8;

import com.nwalsh.saxon8.Callout;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tinytree.TinyBuilder;

public class Verbatim {
    private static final int CALLOUT_TEXT = 1;
    private static final int CALLOUT_UNICODE = 2;
    private static final int CALLOUT_GRAPHICS = 3;
    private static int modulus = 5;
    private static int width = 0;
    private static int lineNumber = 1;
    private static String separator = " | ";
    private static int lineCount = 0;
    private static NodeInfo wrapper = null;
    private static Vector openElements = null;
    private static Vector calloutList = null;
    private static int colNumber = 1;
    private static int defaultColumn = 60;
    private static int calloutStyle = 1;
    private static String textPrefix = "(";
    private static String textSuffix = ")";
    private static NodeInfo textWrapper = null;
    private static int unicodeStart = 0;
    private static int unicodeMax = 10;
    private static NodeInfo unicodeWrapper = null;
    private static int graphicsMax = 10;
    private static NodeInfo graphicsWrapper = null;

    public static DocumentInfo numberLines(XPathContext context, SequenceIterator ns, SequenceIterator wrapperns, int lnLineNumber, int lnEveryNth, int lnWidth, String lnSeparator) throws TransformerException {
        Controller controller = context.getController();
        Configuration config = controller.getConfiguration();
        NamePool pool = config.getNamePool();
        TinyBuilder builder = new TinyBuilder();
        NamespaceReducer reducer = new NamespaceReducer();
        reducer.setUnderlyingReceiver((Receiver)builder);
        NamespaceReducer tree = reducer;
        tree.setConfiguration(config);
        builder.setConfiguration(config);
        tree.open();
        tree.startDocument(0);
        wrapper = Verbatim.findWrapper(wrapperns);
        lineCount = 1;
        SequenceIterator nscount = ns.getAnother();
        NodeInfo verbatim = (NodeInfo)nscount.next();
        if (verbatim.getNodeKind() != 1) {
            System.err.println("Error!!!: " + verbatim);
        } else {
            NodeInfo node = verbatim;
            if (node.hasChildNodes()) {
                AxisIterator children = node.iterateAxis((byte)3);
                NodeInfo child = (NodeInfo)children.next();
                while (child != null) {
                    Verbatim.countLines(child);
                    child = (NodeInfo)children.next();
                }
            }
        }
        lineNumber = lnLineNumber;
        modulus = lineCount < lnEveryNth || lnEveryNth < 1 ? 1 : lnEveryNth;
        double log10numLines = Math.log(lineCount) / Math.log(10.0);
        width = (double)lnWidth < log10numLines + 1.0 ? (int)Math.floor(log10numLines + 1.0) : lnWidth;
        separator = lnSeparator;
        openElements = new Vector();
        verbatim = (NodeInfo)ns.next();
        if (verbatim.getNodeKind() != 1) {
            System.err.println("Error!!!: " + verbatim);
        } else {
            NodeInfo node = verbatim;
            if (node.hasChildNodes()) {
                Verbatim.formatLineNumber(pool, (Receiver)tree);
                AxisIterator children = node.iterateAxis((byte)3);
                NodeInfo child = (NodeInfo)children.next();
                while (child != null) {
                    Verbatim.number(child, pool, (Receiver)tree);
                    child = (NodeInfo)children.next();
                }
            }
        }
        tree.endDocument();
        tree.close();
        return builder.getCurrentDocument();
    }

    private static NodeInfo findWrapper(SequenceIterator wrapperns) throws TransformerException {
        NodeInfo wrapper = (NodeInfo)wrapperns.next();
        if (wrapper.getNodeKind() == 9) {
            if (wrapper.hasChildNodes()) {
                AxisIterator children = wrapper.iterateAxis((byte)3);
                NodeInfo child = (NodeInfo)children.next();
                while (child != null && child.getNodeKind() != 1) {
                    child = (NodeInfo)children.next();
                }
                if (child != null) {
                    wrapper = child;
                }
            } else {
                wrapper = null;
            }
        } else if (wrapper.getNodeKind() != 1) {
            wrapper = null;
        }
        return wrapper;
    }

    public static void countLines(NodeInfo node) throws TransformerException {
        if (node.getNodeKind() == 1 && node.hasChildNodes()) {
            AxisIterator children = node.iterateAxis((byte)3);
            NodeInfo child = (NodeInfo)children.next();
            while (child != null) {
                Verbatim.countLines(child);
                child = (NodeInfo)children.next();
            }
        }
        if (node.getNodeKind() == 3) {
            String text = node.getStringValue();
            int pos = text.indexOf(10);
            while (pos >= 0) {
                ++lineCount;
                text = text.substring(pos + 1);
                pos = text.indexOf(10);
            }
        }
    }

    public static void number(NodeInfo node, NamePool pool, Receiver tree) throws TransformerException {
        switch (node.getNodeKind()) {
            case 1: {
                tree.startElement(node.getNameCode(), 0, 0, 0);
                AxisIterator attrIter = node.iterateAxis((byte)2);
                NodeInfo attr = (NodeInfo)attrIter.next();
                while (attr != null) {
                    tree.attribute(attr.getNameCode(), 0, (CharSequence)attr.getStringValue(), 0, 0);
                    attr = (NodeInfo)attrIter.next();
                }
                openElements.add(node);
                tree.startContent();
                if (node.hasChildNodes()) {
                    AxisIterator children = node.iterateAxis((byte)3);
                    NodeInfo child = (NodeInfo)children.next();
                    while (child != null) {
                        Verbatim.number(child, pool, tree);
                        child = (NodeInfo)children.next();
                    }
                }
                openElements.remove(openElements.size() - 1);
                tree.endElement();
                break;
            }
            case 3: {
                String text = node.getStringValue();
                int pos = text.indexOf(10);
                while (pos >= 0) {
                    int openpos;
                    tree.characters((CharSequence)text.substring(0, pos), 0, 0);
                    for (openpos = 0; openpos < openElements.size(); ++openpos) {
                        tree.endElement();
                    }
                    tree.characters((CharSequence)"\n", 0, 0);
                    ++lineNumber;
                    Verbatim.formatLineNumber(pool, tree);
                    for (openpos = 0; openpos < openElements.size(); ++openpos) {
                        NodeInfo onode = (NodeInfo)openElements.get(openpos);
                        tree.startElement(onode.getNameCode(), 0, 0, 0);
                        AxisIterator oattrIter = onode.iterateAxis((byte)2);
                        NodeInfo attr = (NodeInfo)oattrIter.next();
                        while (attr != null) {
                            if (!"id".equals(attr.getLocalPart())) {
                                tree.attribute(attr.getNameCode(), 0, (CharSequence)attr.getStringValue(), 0, 0);
                            }
                            attr = (NodeInfo)oattrIter.next();
                        }
                        tree.startContent();
                    }
                    text = text.substring(pos + 1);
                    pos = text.indexOf(10);
                }
                tree.characters((CharSequence)text, 0, 0);
                break;
            }
            case 8: {
                tree.comment((CharSequence)node.getStringValue(), 0, 0);
                break;
            }
            case 7: {
                tree.processingInstruction(node.getDisplayName(), (CharSequence)node.getStringValue(), 0, 0);
                break;
            }
            default: {
                System.err.println("Error!");
            }
        }
    }

    public static void formatLineNumber(NamePool pool, Receiver tree) throws TransformerException {
        char ch = '\u00a0';
        String lno = "";
        if (lineNumber == 1 || modulus >= 1 && lineNumber % modulus == 0) {
            lno = "" + lineNumber;
        }
        while (lno.length() < width) {
            lno = ch + lno;
        }
        lno = lno + separator;
        if (wrapper != null) {
            tree.startElement(wrapper.getNameCode(), 0, 0, 0);
            AxisIterator attrIter = wrapper.iterateAxis((byte)2);
            NodeInfo attr = (NodeInfo)attrIter.next();
            while (attr != null) {
                tree.attribute(attr.getNameCode(), 0, (CharSequence)attr.getStringValue(), 0, 0);
                attr = (NodeInfo)attrIter.next();
            }
            tree.startContent();
        }
        tree.characters((CharSequence)lno, 0, 0);
        if (wrapper != null) {
            tree.endElement();
        }
    }

    public static DocumentInfo insertCallouts(XPathContext context, SequenceIterator ns, SequenceIterator areaspecns, String prefix, String suffix, boolean useText, SequenceIterator twrapperns, int uStart, int uMax, boolean useUnicode, SequenceIterator uwrapperns, int gMax, boolean useGraphics, SequenceIterator gwrapperns) throws TransformerException {
        textPrefix = prefix;
        textSuffix = suffix;
        if (useText) {
            calloutStyle = 1;
        }
        unicodeStart = uStart;
        unicodeMax = uMax;
        if (useUnicode) {
            calloutStyle = 2;
        }
        graphicsMax = gMax;
        if (useGraphics) {
            calloutStyle = 3;
        }
        textWrapper = Verbatim.findWrapper(twrapperns);
        unicodeWrapper = Verbatim.findWrapper(uwrapperns);
        graphicsWrapper = Verbatim.findWrapper(gwrapperns);
        Verbatim.setupCallouts(areaspecns);
        Controller controller = context.getController();
        Configuration config = controller.getConfiguration();
        NamePool pool = config.getNamePool();
        TinyBuilder builder = new TinyBuilder();
        NamespaceReducer reducer = new NamespaceReducer();
        reducer.setUnderlyingReceiver((Receiver)builder);
        NamespaceReducer tree = reducer;
        tree.setConfiguration(config);
        builder.setConfiguration(config);
        tree.open();
        tree.startDocument(0);
        lineNumber = 1;
        colNumber = 1;
        openElements = new Vector();
        NodeInfo verbatim = (NodeInfo)ns.next();
        if (verbatim.getNodeKind() != 1) {
            System.err.println("Error!!!: " + verbatim);
        } else {
            NodeInfo node = verbatim;
            if (node.hasChildNodes()) {
                Verbatim.formatLineNumber(pool, (Receiver)tree);
                AxisIterator children = node.iterateAxis((byte)3);
                NodeInfo child = (NodeInfo)children.next();
                while (child != null) {
                    Verbatim.insert(child, pool, (Receiver)tree);
                    child = (NodeInfo)children.next();
                }
            }
        }
        tree.endDocument();
        tree.close();
        return builder.getCurrentDocument();
    }

    public static void insert(NodeInfo node, NamePool pool, Receiver tree) throws TransformerException {
        switch (node.getNodeKind()) {
            case 1: {
                tree.startElement(node.getNameCode(), 0, 0, 0);
                AxisIterator attrIter = node.iterateAxis((byte)2);
                NodeInfo attr = (NodeInfo)attrIter.next();
                while (attr != null) {
                    tree.attribute(attr.getNameCode(), 0, (CharSequence)attr.getStringValue(), 0, 0);
                    attr = (NodeInfo)attrIter.next();
                }
                openElements.add(node);
                tree.startContent();
                if (node.hasChildNodes()) {
                    AxisIterator children = node.iterateAxis((byte)3);
                    NodeInfo child = (NodeInfo)children.next();
                    while (child != null) {
                        Verbatim.insert(child, pool, tree);
                        child = (NodeInfo)children.next();
                    }
                }
                openElements.remove(openElements.size() - 1);
                tree.endElement();
                break;
            }
            case 3: {
                String text = node.getStringValue();
                if (calloutList.size() > 0) {
                    Callout callout = (Callout)calloutList.get(0);
                    System.err.println(lineNumber + ", " + callout.getLine());
                    for (int count = 0; count < text.length(); ++count) {
                        boolean done;
                        boolean bl = done = callout == null;
                        while (!done) {
                            done = true;
                            if (lineNumber != callout.getLine() || colNumber != callout.getColumn()) continue;
                            Verbatim.insertCallout(callout, node, pool, tree);
                            callout = null;
                            calloutList.remove(0);
                            if (calloutList.size() <= 0) continue;
                            callout = (Callout)calloutList.get(0);
                            done = false;
                        }
                        String ch = text.substring(count, count + 1);
                        while (callout != null && "\n".equals(ch) && lineNumber == callout.getLine()) {
                            tree.characters((CharSequence)" ", 0, 0);
                            ++colNumber;
                            done = false;
                            while (!done) {
                                done = true;
                                if (lineNumber != callout.getLine() || colNumber != callout.getColumn()) continue;
                                Verbatim.insertCallout(callout, node, pool, tree);
                                callout = null;
                                calloutList.remove(0);
                                if (calloutList.size() <= 0) continue;
                                callout = (Callout)calloutList.get(0);
                                done = false;
                            }
                        }
                        tree.characters((CharSequence)ch, 0, 0);
                        if ("\n".equals(ch)) {
                            ++lineNumber;
                            colNumber = 1;
                            continue;
                        }
                        ++colNumber;
                    }
                    break;
                }
                tree.characters((CharSequence)text, 0, 0);
                break;
            }
            case 8: {
                tree.comment((CharSequence)node.getStringValue(), 0, 0);
                break;
            }
            case 7: {
                tree.processingInstruction(node.getDisplayName(), (CharSequence)node.getStringValue(), 0, 0);
                break;
            }
            default: {
                System.err.println("Error!");
            }
        }
    }

    public static void insertCallout(Callout callout, NodeInfo node, NamePool pool, Receiver tree) throws TransformerException {
        int openpos;
        int style = calloutStyle;
        if (style == 2 && callout.getCallout() > unicodeMax || style == 3 && callout.getCallout() > graphicsMax) {
            style = 1;
        }
        for (openpos = 0; openpos < openElements.size(); ++openpos) {
            tree.endElement();
        }
        switch (style) {
            case 1: {
                Verbatim.startCalloutWrapper(callout, textWrapper, tree);
                tree.characters((CharSequence)(textPrefix + callout.getCallout() + textSuffix), 0, 0);
                Verbatim.endCalloutWrapper(textWrapper, tree);
                break;
            }
            case 2: {
                Verbatim.startCalloutWrapper(callout, unicodeWrapper, tree);
                int codepoint = unicodeStart + callout.getCallout() - 1;
                char[] chars = new char[]{(char)codepoint};
                String unicodeCh = new String(chars);
                tree.characters((CharSequence)unicodeCh, 0, 0);
                Verbatim.endCalloutWrapper(unicodeWrapper, tree);
                break;
            }
            case 3: {
                Verbatim.startCalloutWrapper(callout, graphicsWrapper, tree);
                Verbatim.endCalloutWrapper(graphicsWrapper, tree);
                break;
            }
        }
        for (openpos = 0; openpos < openElements.size(); ++openpos) {
            NodeInfo onode = (NodeInfo)openElements.get(openpos);
            tree.startElement(onode.getNameCode(), 0, 0, 0);
            AxisIterator oattrIter = onode.iterateAxis((byte)2);
            NodeInfo attr = (NodeInfo)oattrIter.next();
            while (attr != null) {
                if (!"id".equals(attr.getLocalPart())) {
                    tree.attribute(attr.getNameCode(), 0, (CharSequence)attr.getStringValue(), 0, 0);
                }
                attr = (NodeInfo)oattrIter.next();
            }
            tree.startContent();
        }
    }

    private static void startCalloutWrapper(Callout callout, NodeInfo wrapper, Receiver tree) throws TransformerException {
        if (wrapper != null) {
            tree.startElement(wrapper.getNameCode(), 0, 0, 0);
            AxisIterator attrIter = wrapper.iterateAxis((byte)2);
            NodeInfo attr = (NodeInfo)attrIter.next();
            while (attr != null) {
                String value = attr.getStringValue().replaceAll("\\{CALLOUT\\}", "" + callout.getCallout());
                tree.attribute(attr.getNameCode(), 0, (CharSequence)value, 0, 0);
                attr = (NodeInfo)attrIter.next();
            }
            tree.startContent();
        }
    }

    private static void endCalloutWrapper(NodeInfo wrapper, Receiver tree) throws TransformerException {
        if (wrapper != null) {
            tree.endElement();
        }
    }

    public static void setupCallouts(SequenceIterator areaspecns) throws TransformerException {
        calloutList = new Vector();
        boolean pos = false;
        int coNum = 0;
        boolean inAreaSet = false;
        NodeInfo areaspec = (NodeInfo)areaspecns.next();
        if (!areaspec.hasChildNodes()) {
            return;
        }
        AxisIterator children = areaspec.iterateAxis((byte)3);
        NodeInfo child = (NodeInfo)children.next();
        while (child != null) {
            if (child.getNodeKind() == 1) {
                if ("areaset".equals(child.getLocalPart())) {
                    ++coNum;
                    AxisIterator areas = child.iterateAxis((byte)3);
                    NodeInfo area = (NodeInfo)areas.next();
                    while (area != null) {
                        if (area.getNodeKind() == 1) {
                            if ("area".equals(area.getLocalPart())) {
                                Verbatim.addCallout(coNum, area, defaultColumn);
                            } else {
                                System.out.println("Unexpected element in areaset: " + area.getDisplayName());
                            }
                        }
                        area = (NodeInfo)areas.next();
                    }
                } else if ("area".equals(child.getLocalPart())) {
                    Verbatim.addCallout(++coNum, child, defaultColumn);
                } else {
                    System.out.println("Unexpected element in areaspec: " + child.getLocalPart());
                }
            }
            child = (NodeInfo)children.next();
        }
        Collections.sort(calloutList);
    }

    protected static void addCallout(int coNum, NodeInfo area, int defaultColumn) {
        String units = null;
        String coords = null;
        AxisIterator attrIter = area.iterateAxis((byte)2);
        NodeInfo attr = (NodeInfo)attrIter.next();
        while (attr != null) {
            if ("".equals(attr.getURI())) {
                if ("units".equals(attr.getLocalPart())) {
                    units = attr.getStringValue();
                }
                if ("coords".equals(attr.getLocalPart())) {
                    coords = attr.getStringValue();
                }
            }
            attr = (NodeInfo)attrIter.next();
        }
        if (units != null && !units.equals("linecolumn") && !units.equals("linerange")) {
            System.out.println("Only linecolumn and linerange units are supported");
            return;
        }
        if (coords == null) {
            System.out.println("Coords must be specified");
            return;
        }
        StringTokenizer st = new StringTokenizer(coords);
        int tokenCount = 0;
        int c1 = 0;
        int c2 = 0;
        while (st.hasMoreTokens()) {
            if (++tokenCount > 2) {
                System.out.println("Unparseable coordinates");
                return;
            }
            try {
                int coord;
                String token = st.nextToken();
                c2 = coord = Integer.parseInt(token);
                if (tokenCount != 1) continue;
                c1 = coord;
            }
            catch (NumberFormatException e) {
                System.out.println("Unparseable coordinate");
                return;
            }
        }
        if (tokenCount == 2) {
            if (units != null && units.equals("linerange")) {
                for (int count = c1; count <= c2; ++count) {
                    calloutList.add(new Callout(coNum, area, count, defaultColumn));
                }
            } else {
                calloutList.add(new Callout(coNum, area, c1, c2));
            }
        } else {
            calloutList.add(new Callout(coNum, area, c1, defaultColumn));
        }
    }
}

