<?xml version="1.0" encoding="UTF-8"?>
<!--
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx">
    <xsl:import href="skin.xsl"/>
    <!-- base sdxworld -->
    <xsl:template match="sdxworld">
        <br/>
        <br/>
        <table class="form" width="100%" border="1" cellspacing="5">
            <tr>
                <td>
                    <h2>
                        <xsl:text>sdx:world</xsl:text>
                    </h2>
                    <div>
                        <em>Les applications SDX en fonctionnement</em>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <!-- répertoire de fichiers XML -->
                    <form name="dir" action="{@action}" method="GET">
               Répertoire local &#160;<input type="text" name="sdxworld" size="50" value="{normalize-space(/*/documents/@sdxworld)}"/>
                &#160;
        				<input type="submit" value="Importer"/>
                        <div>
                            <small>
				Répertoire local de documents xml à indexer
	        			</small>
                        </div>
                    </form>
                    <!-- un fichier zip -->
                    <form name="zip" action="{@action}" method="POST" enctype="multipart/form-data">
            ZIP à importer <input type="file" name="zip" size="50" onchange="this.form.submit()"/>
            &#160;
    				<input type="submit" value="Importer"/>
                        <div>
                            <small>
        Le contenu du répertoire ci-dessus est copié là : <xsl:value-of select="concat(normalize-space(/*/documents/@sdxworld),'/zip/documents.zip')"/>
                            </small>
                        </div>
                    </form>
                    <!-- une url -->
                    <form name="url" action="{@action}" method="GET">
            URL&#160;<input onfocus="this.select()" type="text" name="site" size="50" value=""/>
            &#160;
    				Indexation
    				<select name="index">
                            <option value="">Défaut</option>
                            <option value="../conf/index-links.xsl">Images</option>
                            <!--
                <option value="../conf/index-yahoo.xsl">Yahoo</option>
                -->
                        </select>
                        <input type="submit" value="Indexer"/>
                        <div>
                            <small>
				En cliquant l'url d'un des projets, 
				elle s'inscrit directement dans le champ texte.
        				</small>
                        </div>
                    </form>
                </td>
            </tr>
            <tr>
                <td>
                    <xsl:call-template name="sdx:results-head">
                        <xsl:with-param name="sdx:results" select="sdx:results"/>
                        <xsl:with-param name="queryParam" select="'sdxworld'"/>
                    </xsl:call-template>
                    -
                    <xsl:call-template name="sdx:results-delete">
                        <xsl:with-param name="sdx:results" select="sdx:results"/>
                        <xsl:with-param name="action" select="'delete.xsp'"/>
                    </xsl:call-template>
                </td>
            </tr>
        </table>
        <xsl:apply-templates select="sdx:results"/>
    </xsl:template>
    <!-- sdx:doc -->
    <xsl:template match="sdxdoc">
        <br/>
        <br/>
        <table class="form" width="100%" border="1" cellspacing="5">
            <tr>
                <td>
                    <h2>
                        <xsl:text>sdx:doc</xsl:text>
                    </h2>
                    <div>
                        <em>La documentation SDX, indexation d'un site HTML</em>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <form name="sdxdoc" action="{@action}" method="GET">
               Répertoire local &#160;<input type="text" name="sdxdoc" size="50" value="{normalize-space(/*/documents/@sdxdoc)}"/>
                &#160;
        				<input type="submit" value="Importer"/>
                        <div>
                            <small>
				Répertoire local d'un site HTML à indexer
	        			</small>
                        </div>
                    </form>
                </td>
            </tr>
            <tr>
                <td>
                    <xsl:call-template name="sdx:results-head">
                        <xsl:with-param name="sdx:results" select="sdx:results"/>
                        <xsl:with-param name="queryParam" select="'sdxdoc'"/>
                    </xsl:call-template>
                    -
                    <xsl:call-template name="sdx:results-delete">
                        <xsl:with-param name="sdx:results" select="sdx:results"/>
                        <xsl:with-param name="action" select="'delete.xsp'"/>
                    </xsl:call-template>
                </td>
            </tr>
        </table>
        <xsl:apply-templates select="sdx:results"/>
    </xsl:template>
    <!-- sdx:results -->
    <xsl:template match="sdx:results">
        <xsl:choose>
            <xsl:when test="@nb > 0">
                <xsl:apply-templates>
                    <!-- template depuis sdx-default.xsl -->
                    <xsl:with-param name="action" select="'document.xsp'">
                        <!-- vers où voir une page -->
                    </xsl:with-param>
                    <xsl:with-param name="delete" select="'true'"/>
                    <xsl:with-param name="action-delete" select="'delete.xsp'">
                        <!-- vers où détruire une page -->
                    </xsl:with-param>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <b>Votre base est vide. </b>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--
            <a style="text-decoration:none; color:black" href="#">
                <xsl:attribute name="onclick">
        document.forms['attach'].ref.value='{sdx:field[@name='sdxdocid']}';
    path='{normalize-space(/*/documents/@dir)}';
    document.forms['attach'].url.value =
        document.forms['attach'].url.value.replace(/\\[^\\]*$/, '')
        + '\\{sdx:field[@name='sdxdocid']}.jpg'
    ; 
    return false;
                </xsl:attribute>
            </a>
            -->
    <xsl:template match="sdx:field"/>
    <xsl:template match="sdx:field[@name='url']">
        <small>
            <xsl:text>&#160;</xsl:text>
            <a style="color:black" href="{@value}" onclick="document.forms['url'].url.value=this.href; return false">
                <xsl:value-of select="@value"/>
            </a>
        </small>
    </xsl:template>
    <xsl:template match="sdx:field[@name='titre']">
        <b>
            <xsl:value-of select="@value"/>
        </b>
    </xsl:template>
    <xsl:template match="sdx:field[@name='sdxdocid']">
        <small>
            <xsl:text>&#160;&#160;&#160;id=</xsl:text>
            <xsl:value-of select="@value"/>
        </small>
    </xsl:template>
    <!-- rights -->
    <xsl:template match="noteditor">
        <p>Pour accéder à cette page, veuillez d'abord vous identifier : 
    <a href="login.xsp">login.xsp</a>
        </p>
    </xsl:template>
    <xsl:template match="sdx:query"/>
    <!-- un formulaire pour attacher un document à un autre 
    <xsl:template match="formulaire[@type='attach']">
        <br/>
        <form name="attach" action="{@traitement}" method="get">
            <h2>Attacher une image à un document xml    
                <small>(base de documents "sites")</small>
            </h2>
            <p>Indiquez un identifiant de document et l'url 
        d'une image, pour qu'elle lui soit attachée.
            </p>
            <div class="form">
            Document
            <input type="text" name="ref" size="10" value=""/>
                <input type="submit" value="lister" onclick="this.form.action='admin.xsp'"/>
                <br/>
            URL image
            <input type="text" name="url" size="60" value="file://{normalize-space(/*/documents/@dir)}\"/>
                <input type="submit" value="Attacher"/>
                <br/>
                <xsl:apply-templates/>
                <div>
                    <small>
				En cliquant l'identifiant d'un des projets, 
				il s'inscrit directement dans le champ texte,
				avec l'url d'une image correspondante.
            				</small>
                </div>
            </div>
        </form>
    </xsl:template>
    -->
</xsl:stylesheet>
