/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.lucene;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import java.util.Enumeration;
import java.util.Hashtable;

/**In progress, good idea, but we need a use case?-rbp
 *
 * This class basically provides an easy way to build a lucene document
 * for store in a LuceneDataStore
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Dec 12, 2002
 * Time: 2:14:55 PM
 * To change this template use Options | File Templates.
 */
public class LuceneData extends SdxObjectImpl {

    protected Hashtable ldFields = new Hashtable();
    public final static String allKey = LuceneDataStore.ALL_FIELD;
    public final static String allValue = LuceneDataStore.ALL_VALUE;
    public final static String idKey = LuceneDataStore.ID_FIELD;
    public final static String xmlLangKey = LuceneDataStore.XML_LANG_FIELD;

    public LuceneData() {
        addLDField(allKey, allValue);
    }


    public LuceneData(Document lDoc) {
        if (lDoc != null) {
            Enumeration lFields = lDoc.fields();
            if (lFields != null) {
                while (lFields.hasMoreElements()) {
                    Field field = (Field) lFields.nextElement();
                    if (field != null)
                        addLDField(field);
                }
            }
        }
    }

    public void setId(String id) {
        addLDField(idKey, id);
    }

    public void setXmlLang(String xmlLang) {
        addLDField(xmlLangKey, xmlLang);
    }

    public String getXmlLang() {

        /*if one is building a LuceneData object we return
        *the value from our internal data structures
        */
        LuceneDataField xmlLang = getField(xmlLangKey);
        if (xmlLang != null)
            return xmlLang.getValue();
        else
            return null;

    }

    public String getId() {
        /*if one is building a LuceneData object we return
        *the value from our internal data structures
        */
        LuceneDataField id = getField(idKey);
        if (id != null)
            return id.getValue();
        else
            return null;
    }

    public void addField(String fieldName, String value, String type) {
        if (Utilities.checkString(fieldName)) {
            if (ldFields.containsKey(fieldName))
                updateLDField(fieldName, value);
            else
                addLDField(fieldName, value, type);
        }
    }

    public void removeField(String fieldName) {
        deleteLDField(fieldName);
    }

    public void removeValue(String fieldName, String value) {
        if (ldFields.containsKey(fieldName)) {
            if (Utilities.checkString(value)) {
                LuceneDataField ldf = getField(fieldName);
                if (ldf != null)
                    ldf.deleteValue(value);
            }
        }
    }

    public String[] getFieldValues(String fieldName) {
        if (Utilities.checkString(fieldName)) {
            if (ldFields.containsKey(fieldName)) {
                LuceneDataField ldf = getField(fieldName);
                if (ldf != null)
                    return ldf.getValues();
                else
                    return null;
            } else
                return null;
        } else
            return null;
    }

    public String getFieldValue(String fieldName) {
        if (Utilities.checkString(fieldName)) {
            if (ldFields.containsKey(fieldName)) {
                LuceneDataField ldf = getField(fieldName);
                if (ldf != null)
                    return ldf.getValue();
                else
                    return null;
            } else
                return null;

        } else
            return null;
    }


    /**
     * Returns a Lucene f based upon the current set of properties/LuceneDataFields.
     *
     */
    public Document getLuceneDocument() {
        Document ldoc = null;
        // Now the properties
        Enumeration props = ldFields.elements();
        if (props != null) {
            ldoc = new Document();
            while (props.hasMoreElements()) {
                LuceneDataField ldf = (LuceneDataField) props.nextElement();
                if (ldf != null) {
                    String[] values = ldf.getValues();
                    for (int j = 0; j < values.length; j++) {
                        ldoc.add(ldf.getLuceneField(values[j]));
                    }
                }
            }
        }
        return ldoc;

    }

    /**Builds a keyworld lucene field*/
    protected void addLDField(String name, String value) {
        if (Utilities.checkString(name) && Utilities.checkString(value)) {
            LuceneDataField ldf = new LuceneDataField();
            ldf.setName(name);
            ldf.setFieldType(true, true, false);
            ldf.addValue(value);
            ldFields.put(name, ldf);
        }
    }

    protected void addLDField(String name, String value, String type) {
        if (Utilities.checkString(name) && Utilities.checkString(value)) {
            LuceneDataField ldf = new LuceneDataField();
            ldf.setName(name);
            ldf.setFieldType(type);
            ldf.addValue(value);
            ldFields.put(name, ldf);
        }
    }

    protected void addLDField(Field f) {
        String name = "";
        String value = "";
        boolean store = false;
        boolean index = false;
        boolean token = false;
        if (f != null) {
            name = f.name();
            value = f.stringValue();
            store = f.isStored();
            index = f.isIndexed();
            token = f.isTokenized();
        }

        if (Utilities.checkString(name) && Utilities.checkString(value)) {
            LuceneDataField ldf = new LuceneDataField();
            //ldf.setName(name);
            ldf.setFieldType(store, index, token);
            //ldf.addValue(value);
            addField(name, value, ldf.getTypeName());
            //ldFields.put(name, ldf);
        }
    }

    protected void updateLDField(String name, String value) {
        if (Utilities.checkString(name) && Utilities.checkString(value)) {
            LuceneDataField prop = getField(name);
            if (prop != null)
                prop.addValue(value);
        }

    }

    protected void deleteLDField(String name) {
        if (Utilities.checkString(name) && ldFields.containsKey(name)) {
            ldFields.remove(name);
        }
    }


    /**Gets a specific LuceneDataField*/
    public LuceneDataField getField(String key) {
        LuceneDataField ldf = null;
        if (ldFields.containsKey(key))
            ldf = (LuceneDataField) ldFields.get(key);
        return ldf;
    }

    /**Returns all LuceneDataFields*/
    public Enumeration getFields() {
        return ldFields.elements();
    }

    /**Returns only the content LuceneDataFields, excluding the all, id, and xmllang fields*/
    public Enumeration getContentFields() {
        Hashtable contentFields = new Hashtable(ldFields);
        contentFields.remove(allKey);
        contentFields.remove(idKey);
        contentFields.remove(xmlLangKey);
        return contentFields.elements();
    }

    /**
     * Returns a Lucene field for indexing a name/value pair.
     *
     * @param name      Name of the field.
     * @param value     Value of the field.
     */
    protected Field getLuceneField(String name, String value) throws SDXException {
        //TODO?:not testing the value for an empty string because fred thinks i could be useful?-rbp
        if (!Utilities.checkString(name) || value == null) {
            String[] args = new String[2];
            args[0] = name;
            args[1] = value;
            //not logging here
            throw new SDXException(null, SDXExceptionCode.ERROR_CREATE_LUCENE_FIELD, args, null);
        } else
            return Field.Keyword(name, value);
    }


}
