/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.Framework;
import fr.gouv.culture.sdx.utils.constants.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import java.util.Hashtable;
import java.util.Locale;

/**
 * An anonymous SDX user.
 *
 * <p>
 * The information for this user will be sent directly and not from an
 * XML document.
 */
public class AnonymousUserInformation extends UserInformation {

    /**
     * Creates an anonymous user with a preferred locale.
     *
     * @param   locale      The preferred locale.
     */
    public AnonymousUserInformation(Locale locale) throws SDXException {
        setId(UserInformation.ANONYMOUS_USERNAME);
        setGroups(new Hashtable());
        setPreferredLocale(locale);
    }

    /**
     * Sends information about this anonymous user.
     *
     * <p>
     * The information sent is basically a user definition with an
     * anonymous property set to true.
     *
     * @param   handler     The handler where to send events.
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", Node.Name.ANONYMOUS, Node.Name.ANONYMOUS, Node.Type.CDATA, "true");
        if (super.ip != null) atts.addAttribute("", Node.Name.IP, Node.Name.IP, Node.Type.CDATA, super.ip);
        if (super.host != null) atts.addAttribute("", Node.Name.HOST, Node.Name.HOST, Node.Type.CDATA, super.host);
        handler.startElement(Framework.SDXNamespaceURI, Node.Name.USER, Framework.SDXNamespacePrefix + ":" + Node.Name.USER, atts);
        handler.endElement(Framework.SDXNamespaceURI, Node.Name.USER, Framework.SDXNamespacePrefix + ":" + Node.Name.USER);
    }


}
